// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package slice

import (
	"context"
	"sync"
)

var (
	lockBundleMockBuild sync.RWMutex
)

// Ensure, that BundleMock does implement Bundle.
// If this is not the case, regenerate this file with moq.
var _ Bundle = &BundleMock{}

// BundleMock is a mock implementation of Bundle.
//
//     func TestSomethingThatUsesBundle(t *testing.T) {
//
//         // make and configure a mocked Bundle
//         mockedBundle := &BundleMock{
//             BuildFunc: func(builder ContainerBuilder)  {
// 	               panic("mock out the Build method")
//             },
//         }
//
//         // use mockedBundle in code that requires Bundle
//         // and then make assertions.
//
//     }
type BundleMock struct {
	// BuildFunc mocks the Build method.
	BuildFunc func(builder ContainerBuilder)

	// calls tracks calls to the methods.
	calls struct {
		// Build holds details about calls to the Build method.
		Build []struct {
			// Builder is the builder argument value.
			Builder ContainerBuilder
		}
	}
}

// Build calls BuildFunc.
func (mock *BundleMock) Build(builder ContainerBuilder) {
	if mock.BuildFunc == nil {
		panic("BundleMock.BuildFunc: method is nil but Bundle.Build was just called")
	}
	callInfo := struct {
		Builder ContainerBuilder
	}{
		Builder: builder,
	}
	lockBundleMockBuild.Lock()
	mock.calls.Build = append(mock.calls.Build, callInfo)
	lockBundleMockBuild.Unlock()
	mock.BuildFunc(builder)
}

// BuildCalls gets all the calls that were made to Build.
// Check the length with:
//     len(mockedBundle.BuildCalls())
func (mock *BundleMock) BuildCalls() []struct {
	Builder ContainerBuilder
} {
	var calls []struct {
		Builder ContainerBuilder
	}
	lockBundleMockBuild.RLock()
	calls = mock.calls.Build
	lockBundleMockBuild.RUnlock()
	return calls
}

var (
	lockBootShutdownMockBoot     sync.RWMutex
	lockBootShutdownMockBuild    sync.RWMutex
	lockBootShutdownMockShutdown sync.RWMutex
)

// Ensure, that BootShutdownMock does implement BootShutdown.
// If this is not the case, regenerate this file with moq.
var _ BootShutdown = &BootShutdownMock{}

// BootShutdownMock is a mock implementation of BootShutdown.
//
//     func TestSomethingThatUsesBootShutdown(t *testing.T) {
//
//         // make and configure a mocked BootShutdown
//         mockedBootShutdown := &BootShutdownMock{
//             BootFunc: func(ctx context.Context, container Container) error {
// 	               panic("mock out the Boot method")
//             },
//             BuildFunc: func(builder ContainerBuilder)  {
// 	               panic("mock out the Build method")
//             },
//             ShutdownFunc: func(ctx context.Context, container Container) error {
// 	               panic("mock out the Shutdown method")
//             },
//         }
//
//         // use mockedBootShutdown in code that requires BootShutdown
//         // and then make assertions.
//
//     }
type BootShutdownMock struct {
	// BootFunc mocks the Boot method.
	BootFunc func(ctx context.Context, container Container) error

	// BuildFunc mocks the Build method.
	BuildFunc func(builder ContainerBuilder)

	// ShutdownFunc mocks the Shutdown method.
	ShutdownFunc func(ctx context.Context, container Container) error

	// calls tracks calls to the methods.
	calls struct {
		// Boot holds details about calls to the Boot method.
		Boot []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Container is the container argument value.
			Container Container
		}
		// Build holds details about calls to the Build method.
		Build []struct {
			// Builder is the builder argument value.
			Builder ContainerBuilder
		}
		// Shutdown holds details about calls to the Shutdown method.
		Shutdown []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Container is the container argument value.
			Container Container
		}
	}
}

// Boot calls BootFunc.
func (mock *BootShutdownMock) Boot(ctx context.Context, container Container) error {
	if mock.BootFunc == nil {
		panic("BootShutdownMock.BootFunc: method is nil but BootShutdown.Boot was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Container Container
	}{
		Ctx:       ctx,
		Container: container,
	}
	lockBootShutdownMockBoot.Lock()
	mock.calls.Boot = append(mock.calls.Boot, callInfo)
	lockBootShutdownMockBoot.Unlock()
	return mock.BootFunc(ctx, container)
}

// BootCalls gets all the calls that were made to Boot.
// Check the length with:
//     len(mockedBootShutdown.BootCalls())
func (mock *BootShutdownMock) BootCalls() []struct {
	Ctx       context.Context
	Container Container
} {
	var calls []struct {
		Ctx       context.Context
		Container Container
	}
	lockBootShutdownMockBoot.RLock()
	calls = mock.calls.Boot
	lockBootShutdownMockBoot.RUnlock()
	return calls
}

// Build calls BuildFunc.
func (mock *BootShutdownMock) Build(builder ContainerBuilder) {
	if mock.BuildFunc == nil {
		panic("BootShutdownMock.BuildFunc: method is nil but BootShutdown.Build was just called")
	}
	callInfo := struct {
		Builder ContainerBuilder
	}{
		Builder: builder,
	}
	lockBootShutdownMockBuild.Lock()
	mock.calls.Build = append(mock.calls.Build, callInfo)
	lockBootShutdownMockBuild.Unlock()
	mock.BuildFunc(builder)
}

// BuildCalls gets all the calls that were made to Build.
// Check the length with:
//     len(mockedBootShutdown.BuildCalls())
func (mock *BootShutdownMock) BuildCalls() []struct {
	Builder ContainerBuilder
} {
	var calls []struct {
		Builder ContainerBuilder
	}
	lockBootShutdownMockBuild.RLock()
	calls = mock.calls.Build
	lockBootShutdownMockBuild.RUnlock()
	return calls
}

// Shutdown calls ShutdownFunc.
func (mock *BootShutdownMock) Shutdown(ctx context.Context, container Container) error {
	if mock.ShutdownFunc == nil {
		panic("BootShutdownMock.ShutdownFunc: method is nil but BootShutdown.Shutdown was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Container Container
	}{
		Ctx:       ctx,
		Container: container,
	}
	lockBootShutdownMockShutdown.Lock()
	mock.calls.Shutdown = append(mock.calls.Shutdown, callInfo)
	lockBootShutdownMockShutdown.Unlock()
	return mock.ShutdownFunc(ctx, container)
}

// ShutdownCalls gets all the calls that were made to Shutdown.
// Check the length with:
//     len(mockedBootShutdown.ShutdownCalls())
func (mock *BootShutdownMock) ShutdownCalls() []struct {
	Ctx       context.Context
	Container Container
} {
	var calls []struct {
		Ctx       context.Context
		Container Container
	}
	lockBootShutdownMockShutdown.RLock()
	calls = mock.calls.Shutdown
	lockBootShutdownMockShutdown.RUnlock()
	return calls
}
