use std::process::Command;
pub fn pwd() -> Result<String, &'static str> {
    let get_pwd = if cfg!(target_os = "windows") {
        Command::new("cmd")
            .args(["/C", "echo %cd%"])
            .output()
            .expect("failed to execute process")
    //} else if cfg!(target_os = "macos") {
    //    Command::new("sh")
    //        .arg("-c")
    //        .arg("echo ${PWD##*/}")
    //        .output()
    //        .expect("failed to execute process")
    //} else if cfg!(target_os = "linux") {
    //    Command::new("sh")
    //        .arg("-c")
    //        .arg("echo ${PWD##*/}")
    //        .output()
    //        .expect("failed to execute process")
    } else {
        Command::new("sh")
            .arg("-c")
            .arg("echo ${PWD##*/}")
            .output()
            .expect("failed to execute process")
    };

    let mut _pwd = String::from_utf8(get_pwd.stdout)
        .map_err(|non_utf8| String::from_utf8_lossy(non_utf8.as_bytes()).into_owned())
        .unwrap();

    let _mutable_string = String::new();
    let mutable_string = _pwd.clone();
    Ok(mutable_string.to_string())
} //end pwd()
