#[allow(unused_imports)]
use crate::pubkeys::PubKeys;
use crate::stats::Stats;

use nostr_sdk::prelude::{Event, Kind, /*Tag, */Timestamp, TagStandard};
use std::sync::LazyLock;

pub const LOCALHOST_8080: &str = "ws://127.0.0.1:8080";

pub const BOOTSTRAP_RELAY0: &str = "wss://relay.nostr.band";
pub const BOOTSTRAP_RELAY1: &str = "wss://nostr.wine";
pub const BOOTSTRAP_RELAY2: &str = "wss://relay.damus.io";


pub static BOOTSTRAP_RELAYS: LazyLock<Vec<String>> = LazyLock::new(|| {
    // The vec! macro and String::from calls are now inside a closure,
    // which is executed at runtime when the static variable is first needed.
    vec![
        String::from(BOOTSTRAP_RELAY0),
        String::from(BOOTSTRAP_RELAY1),
        String::from(BOOTSTRAP_RELAY2),
    ]
});

//pub const APP_SECRET_KEY: &str = "nsec1ufnus6pju578ste3v90xd5m2decpuzpql2295m3sknqcjzyys9ls0qlc85";
pub const APP_SECRET_KEY: &str = "nsec1uwcvgs5clswpfxhm7nyfjmaeysn6us0yvjdexn9yjkv3k7zjhp2sv7rt36";
pub struct Processor {
    pubkeys: PubKeys,
    stats: Stats,
}

impl Default for Processor {
    fn default() -> Self {
        Self::new()
    }
}

impl Processor {
    pub fn new() -> Self {
        Self {
            pubkeys: PubKeys::new(),
            stats: Stats::new(),
        }
    }

    #[allow(dead_code)]
    fn age(t: Timestamp) -> i64 {
        Timestamp::now().as_u64() as i64 - t.as_u64() as i64
    }

    pub fn handle_event(&mut self, event: &Event) {
        //TODO: forward (proxy)
        //println!("{:?}", event.id);
        //println!("{:}", event.as_json());
        //println!("age {:?}  created_at {:?}", Self::age(event.created_at), event.created_at);
        match event.kind {
            //Kind::Metadata => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::TextNote => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::EncryptedDirectMessage => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::EventDeletion => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::Repost => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::Reaction => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::ChannelCreation => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::ChannelMetadata => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::ChannelMessage => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::ChannelHideMessage => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::ChannelMuteUser => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::PublicChatReserved45 => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::PublicChatReserved46 => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::PublicChatReserved47 => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::PublicChatReserved48 => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::PublicChatReserved49 => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::Reporting => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::ZapRequest => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::Zap => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::Authentication => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::NostrConnect => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::RelayList => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::Replaceable(u16) => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::Ephemeral(u16) => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::ParameterizedReplaceable(u16) => {
            //    println!("{:?}", event.kind);
            //}
            //Kind::Custom(u64) => {
            //    println!("{:?}", event.kind);
            //}
            Kind::ContactList => {
                self.stats.add_contacts();
                // count p tags
                //let mut cnt = 0;
                for t in &event.tags {
                    if let Some(TagStandard::PublicKey { public_key, .. }) = t.as_standardized() {
                        self.pubkeys.add(public_key);
                        //cnt += 1;
                    }
                }
                //println!("Contacts {} \t ", cnt); // event.pubkey.to_bech32().unwrap(),
                // self.print_summary();

                //println!("{:?}", event);
            }
            Kind::RecommendRelay => {
                self.stats.add_relays();
                //println!("{:?}", event);
            }
            _ => {
                //println!("{:?}", event.kind)
                println!("processing...")
            }
        }
    }

    // fn print_summary(&self) {
    //     print!("pks {} \t ", self.pubkeys.count());
    //     self.stats.print_summary();
    // }

    pub fn dump(&self) {
        //println!();
        //println!(
        //    "Number of ContactList events:      \t {}",
        //    self.stats.count_contacts
        //);
        //println!(
        //    "Number of RecommendedRelay events: \t {}",
        //    self.stats.count_relays
        //);
        //println!();
        //self.pubkeys.dump();
    }
}
