# Installing row

## Installation methods

Choose one of the installation methods below.

### Installing binaries with cargo binstall

[cargo-binstall] downloads the prebuilt releases directly from GitHub and installs
them. First, [install cargo-binstall] (follow the link for instructions). Then
execute
```bash
cargo binstall row
```
to install **row**. Follow the on-screen prompts.

[cargo-binstall]: https://github.com/cargo-bins/cargo-binstall
[install cargo-binstall]: https://github.com/cargo-bins/cargo-binstall?tab=readme-ov-file#installation

### Installing binaries manually

Download binary from [latest row release] that matches your operating system and
hardware architecture.
* `x86_64-unknown-linux-gnu` - Linux x86_64 (*Intel/AMD 64-bit*).
* `aarch64-apple-darwin` - Mac arm64 (*Apple Silicon*).

Extract the file:
```bash
tar -xvf row-*.tar.zst
```

Place the executable `row` in a directory that is on your `$PATH`.

> [!TIP]
> If you are unsure what your system architecture is, execute `uname -sm`.

[latest row release]: https://github.com/glotzerlab/row/releases

### Installing binaries with conda

**Row** is available on [conda-forge] for the *linux-64*, *linux-aarch64*, *osx-64*,
*osx-arm64* architectures. Install with [micromamba]:

```bash
micromamba install row
```

[conda-forge]: https://conda-forge.org/
[micromamba]: https://mamba.readthedocs.io/en/latest/user_guide/micromamba.html

### Building the latest release from source

Install [Rust]. Then execute:

```bash
cargo install row --locked
```

Ensure that `$HOME/.cargo/bin` is on your `$PATH`.

> [!TIP]
> You can keep your installation up to date with **[cargo-update]**.

[Rust]: https://doc.rust-lang.org/stable/book/
[cargo-update]: https://github.com/nabijaczleweli/cargo-update

### Building the latest development version

Clone the repository:
```bash
git clone git@github.com:glotzerlab/row.git
```

Install row:
```bash
cargo install --path row --locked
```

Ensure that `$HOME/.cargo/bin` is on your `$PATH`.

## Configuring shell autocompletion

Execute the appropriate command in your shell's profile:
* Bash:
   ```shell
   source <(COMPLETE=bash row)
   ```
* Fish:
    ```shell
    source (COMPLETE=fish row | psub)
    ```
* Zsh:
    ```shell
    source <(COMPLETE=zsh row)
    ```
For additional shell configurations, see [clap-complete's documentation].

[clap-complete's documentation]: https://docs.rs/clap_complete/latest/clap_complete/env/index.html
