# Release notes

## 1.0.0 (2025-11-19)

*Highlights:*

This release is labeled 1.0 in recognition that **row** has been stable for some
time now. Future releases will continue to follow semantic versioning. Specifically,
future changes will be considered breaking if they would require users to modify
`workflow.toml` or if they change the `--short` output format of any command. Changes to
the human-readable output will not be considered breaking.

**Row** 1.0 can now set the number of threads per process for applications that
use [rayon]. Set `"rayon"` as the first element in `launchers`:
```toml
[[action]]
launchers = ["rayon"]
```

The documentation now shows the current page's headings in the left sidebar. Click on a
heading to navigate to that section.

**Row** 1.0 also adds support for certain SLURM configurations that do not accept
`--gpus-per-task`.

[rayon]: https://github.com/rayon-rs/rayon/

*Added:*

* Rayon launcher that prefixes commands with `RAYON_NUM_THREADS={T}` (#195).
* `slurm_gpus_per_task` cluster option (#197).

*Changed:*

* Build the documentation with mdBook 0.5.0 (#203).

*Fixed:*

* Fix the "JSON Pointers" example (#191).
* Handle non-numeric suffixes output by `sbatch` (#197).

## 0.7.1 (2025-08-21)

*Fixed:*

* Statically link Linux binaries so that `cargo binstall row` installs a working version
  even on old Linux distributions.

## 0.7.0 (2025-08-11)

*Highlights:*

**Row** 0.7 allows users to place product files in subdirectories. For example:
```toml
[[action]]
products = ['file1.dat', 'subdir/file2.h5', 'long/path/to/file3.gsd']
```

The code is also more readable now using if-let chains that require Rust 1.88.

*Added:*

* `products` can now contain files in subdirectories.

*Changed:*

* Rust 1.88.0 is required to build **row** from source.

## 0.6.0 (2025-05-02)

*Highlights:*

**Row** 0.6 adds new options that allow you to customize the location and/or names of
the output files generated by submitted jobs. Set `output_file_path` to place
all output files in a given directory:

```toml
[action.submit_options.<cluster_name>]
output_file_path = "my_output_directory"
```

By default, files are named `{action_name}-%j.out` Set `output_file_name` to use
different names:
```toml
[action.submit_options.<cluster_name>]
output_file_path = "output-%j.txt"
```

The string `"{output_file_path}/{output_file_path}"` (or just `"{output_file_name}"`
when `output_file_path` is unset) is passed to
[sbatch's `--output`](https://slurm.schedmd.com/sbatch.html#OPT_output) option.

*Added:*

* The `submit_options` keys `output_file_path` and `output_file_name`.

## 0.5.0 (2025-04-21)

*Highlights:*

In **Row** 0.5, the subcommands `show directories`, `show jobs`, and `show status` now
report `No matches` when there are no results to show.

Users can also request an amount of memory specific to an action with
`memory_per_cpu_mb` or `memory_per_gpu_mb`. For example:

```toml
[action.resources]
memory_per_cpu_mb = 1024
```

When set, the given value will be passed to the SLURM option `--mem-per-cpu` or
`--mem-per-gpu` if the partition has no memory request set or the action's value is
smaller than the partition's. **Row** returns an error when the user requests more
memory than the partition has available to prevent unexpected additional costs.

> [!TIP]
> Most users should omit the memory request. When omitted **row** will
> automatically select the maximum amount of memory possible without incurring
> extra charges on your HPC resources.

*Added:*

* Actions can request the following new resources: `memory_per_cpu_mb` or
  `memory_per_gpu_mb`.

*Changed:*

* Writing tabular output with no rows now results in the output `No matches.`.
* Build executables on Ubuntu 22.04.
* Report an error when the workflow requests 0 processes, GPUs, or threads.
* Require Rust 1.85 or newer to build.
* Memory requests in `clusters.toml` must now be set in MB. The `memory_per_*`
  keys are renamed to `memory_per_*_mb`.

*Fixed:*

* Submit MPI jobs on Great Lakes without error.

## 0.4.0 (2024-12-06)

*Highlights:*

**Row** 0.4 expands the `command` templating functionality, adds shell autocompletion,
and the `show jobs` subcommand.

The new _template arguments_ allow direct use of command line applications as actions,
removing the need for _shim_ scripts that access the workspace path and/or directory
values before invoking a subprocess. `{workspace_path}` expands to the current project's
workspace path and `{/JSON pointer}` expands to the value of the given JSON pointer for
the directory acted on.

_Shell autocompletion_ allows users to autocomplete all parameter names and
workspace dependent values for `cluster`, `action`, and `directories`. To enable,
execute the appropriate command in your shell's profile:
* Bash: `source <(COMPLETE=bash row)`
* Fish: `source (COMPLETE=fish row | psub)`
* Zsh: `source <(COMPLETE=zsh row)`

`show jobs` prints a table summarizing all currently submitted jobs that match given
action and directory criteria.

*Added:*

* In job scripts, set the environment variable `ACTION_WORKSPACE_PATH` to the _relative_
  path to the current workspace.
* `{workspace_path}` template parameter in `action.command` - replaced with the
  _relative_ path to the current workspace.
* `{/JSON pointer}` template parameter in `action.command` - replaced with the portion
  of the directory's value referenced by the given JSON pointer.
* Shell autocomplete.
* `show jobs` subcommand.

*Fixed:*

* All user-provided content (directories, action names, cluster names, and values) are
  properly escaped in the bash script output.
* Typographical errors in the documentation.
* The documentation now builds correctly with _mdbook_ 0.4.43.
* Example code converts environment variables to integers where needed.

## 0.3.1 (2024-10-04)

*Changed:*

* Improved the documentation.

## 0.3.0 (2024-08-21)

*Highlights:*

**Row** 0.3 adds command line arguments to reduce the output from `show` commands,
including the `--short` option to most `show` subcommand and status filtering options
to `show status`. For example, `row show status --eligible` shows only actions that have
eligible directories and `row show cluster --all --short` lists the names of all the
available cluster configurations. **Row** 0.3 also makes a number of fixes and changes
when using `group.include` in a non-trivial manner.

*Added:*

* Edit links to documentation pages.
* New arguments to `show status` display actions that are in the requested states:
 `--completed`, `--eligible`, `--submitted`, and `--waiting`.
* `cluster.submit_options` configuration option in `clusters.toml`.
* `--short` option to `show launchers` and `show directories`.

*Changed:*

* Show `import` lines in Python examples.
* Improve the verbose output from `submit`.
* `show status` hides actions with 0 directories by default. Pass `--all` to show all
  actions.
* `clean` now cleans all caches by default.
* Submit jobs with `--constraint="scratch"` by default on Delta.
* Submit jobs with `--constraint="nvme"` by default on Frontier.
* `group.include.all` now employs short circuit evaluation.
* Change `--name` option of `show cluster` to `--short`.
* `show directories` now accepts an optional `--action` argument.

*Fixed:*

* `submit_whole = true` checks only directories that match `group.include`.
* Do not print trailing spaces after the final column in tabular output.

## 0.2.0 (2024-06-18)

**Row** 0.2 adds support for partial-node job submissions on clusters without shared
partitions and fixes GPU job submissions on some clusters.

*Added:*

* `warn_[cpus|gpus]_not_multiple_of` key in *clusters.toml*.

*Changed:*

* OLCF Frontier configuration now uses `warn_gpus_not_multiple_of` instead of `require_gpus_multiple_of`.
* OLCF Andes configuration now uses `warn_cpus_not_multiple_of` instead of `require_cpus_multiple_of`.

*Fixed:*

* Prevent `gpus-per-task is mutually exclusive with tres-per-task` error.
* Correctly set `--mem-per-gpu` on Great Lakes.
* Correct formatting in the documentation.
* Correct typos in the documentation.

## 0.1.3 (2024-05-30)

*Fixed:*

* Broken build.

## 0.1.2 (2024-05-30)

*Fixed:*

* Erroneous code examples in the *Grouping directories* tutorial.

## 0.1.1 (2024-05-29)

*Added:*

* `conda-forge` installation instructions.

## 0.1.0 (2024-05-22)

* Initial release.
