"""Example actions.py using mpi4py."""

import argparse
import os

# ANCHOR: action
import hoomd
import signac


def action_implementation(job, communicator):
    """Implement the action on a single job."""
    # Your HOOMD-blue simulation goes here. Use the given communicator. For example:
    # cpu = hoomd.device.CPU(communicator=communicator)
    # simulation = hoomd.Simulation(device=cpu)


def action(*jobs):
    """Execute actions on directories in parallel using HOOMD-blue."""
    processes_per_directory = int(os.environ['ACTION_PROCESSES_PER_DIRECTORY'])
    communicator = hoomd.communicator.Communicator(ranks_per_partition=processes_per_directory)
    action_implementation(jobs[communicator.partition], communicator)
    # ANCHOR_END: action


if __name__ == '__main__':
    # Parse the command line arguments: python action.py --action <ACTION> [DIRECTORIES]
    parser = argparse.ArgumentParser()
    parser.add_argument('--action', required=True)
    parser.add_argument('directories', nargs='+')
    args = parser.parse_args()

    # Open the signac jobs
    project = signac.get_project()
    jobs = [project.open_job(id=directory) for directory in args.directories]

    # Call the action
    globals()[args.action](*jobs)
