/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.stream;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;

abstract class AbstractSpinedBuffer {
    public static final int MIN_CHUNK_POWER = 4;
    public static final int MIN_CHUNK_SIZE = 16;
    public static final int MAX_CHUNK_POWER = 30;
    public static final int MIN_SPINE_SIZE = 8;
    protected final int initialChunkPower;
    protected int elementIndex;
    protected int spineIndex;
    protected long[] priorElementCount;

    protected AbstractSpinedBuffer() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.initialChunkPower = 4;
    }

    protected AbstractSpinedBuffer(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Illegal Capacity: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfLeadingZeros:(I)I");
        int n2 = 32 - Integer.numberOfLeadingZeros(n - 1);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        this.initialChunkPower = Math.max(4, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEmpty() {
        RuntimeCostAccounter.recordJump();
        if (this.spineIndex != 0) return false;
        RuntimeCostAccounter.recordJump();
        if (this.elementIndex != 0) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    public long count() {
        long l;
        RuntimeCostAccounter.recordJump();
        if (this.spineIndex == 0) {
            l = this.elementIndex;
            RuntimeCostAccounter.recordJump();
        } else {
            l = this.priorElementCount[this.spineIndex] + (long)this.elementIndex;
        }
        return l;
    }

    /*
     * Unable to fully structure code
     */
    protected int chunkSize(int var1_1) {
        RuntimeCostAccounter.recordJump();
        if (var1_1 == 0) ** GOTO lbl-1000
        RuntimeCostAccounter.recordJump();
        if (var1_1 == 1) lbl-1000:
        // 2 sources

        {
            v0 = this.initialChunkPower;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
            v0 = Math.min(this.initialChunkPower + var1_1 - 1, 30);
        }
        var2_2 = v0;
        return 1 << var2_2;
    }

    public abstract void clear();
}

