/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.Instant;
import sandbox.java.time.Ser;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.ZoneRegion;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.format.DateTimeFormatterBuilder;
import sandbox.java.time.format.TextStyle;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.zone.ZoneRules;
import sandbox.java.time.zone.ZoneRulesException;
import sandbox.java.time.zone.ZoneRulesProvider;
import sandbox.java.util.Collections;
import sandbox.java.util.HashMap;
import sandbox.java.util.Locale;
import sandbox.java.util.Map;
import sandbox.java.util.Objects;
import sandbox.java.util.Set;
import sandbox.java.util.TimeZone;

public abstract class ZoneId
implements Serializable {
    public static final Map<String, String> SHORT_IDS;
    private static final long serialVersionUID = 8352817235686L;

    public static ZoneId systemDefault() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TimeZone.getDefault:()Ljava/util/TimeZone;");
        TimeZone timeZone = TimeZone.getDefault();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TimeZone.toZoneId:()Ljava/time/ZoneId;");
        return timeZone.toZoneId();
    }

    public static Set<String> getAvailableZoneIds() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesProvider.getAvailableZoneIds:()Ljava/util/Set;");
        return ZoneRulesProvider.getAvailableZoneIds();
    }

    public static ZoneId of(String string, Map<String, String> map) {
        String string2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(string, "zoneId");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(map, "aliasMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        String string3 = map.get(string);
        RuntimeCostAccounter.recordJump();
        if (string3 != null) {
            string2 = string3;
            RuntimeCostAccounter.recordJump();
        } else {
            string2 = string;
        }
        string3 = string2;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.of:(Ljava/lang/String;)Ljava/time/ZoneId;");
        return ZoneId.of(string3);
    }

    public static ZoneId of(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.of:(Ljava/lang/String;Z)Ljava/time/ZoneId;");
        return ZoneId.of(string, true);
    }

    public static ZoneId ofOffset(String string, ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(string, "prefix");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneOffset, "offset");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n = string.length();
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            return zoneOffset;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        boolean bl = string.equals("GMT");
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
            boolean bl2 = string.equals("UTC");
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                boolean bl3 = string.equals("UT");
                RuntimeCostAccounter.recordJump();
                if (!bl3) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("prefix should be GMT, UTC or UT, is: ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(string);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string2 = stringBuilder3.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        int n2 = zoneOffset.getTotalSeconds();
        RuntimeCostAccounter.recordJump();
        if (n2 != 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getId:()Ljava/lang/String;");
            String string3 = zoneOffset.getId();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.concat:(Ljava/lang/String;)Ljava/lang/String;");
            string = string.concat(string3);
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/ZoneRegion");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getRules:()Ljava/time/zone/ZoneRules;");
        ZoneRules zoneRules = zoneOffset.getRules();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneRegion.<init>:(Ljava/lang/String;Ljava/time/zone/ZoneRules;)V");
        return new ZoneRegion(string, zoneRules);
    }

    static ZoneId of(String string, boolean bl) {
        block10: {
            block9: {
                block8: {
                    block7: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                        Objects.requireNonNull(string, "zoneId");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                        int n = string.length();
                        RuntimeCostAccounter.recordJump();
                        if (n <= 1) break block7;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
                        boolean bl2 = string.startsWith("+");
                        RuntimeCostAccounter.recordJump();
                        if (bl2) break block7;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
                        boolean bl3 = string.startsWith("-");
                        RuntimeCostAccounter.recordJump();
                        if (!bl3) break block8;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.of:(Ljava/lang/String;)Ljava/time/ZoneOffset;");
                    return ZoneOffset.of(string);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
                boolean bl4 = string.startsWith("UTC");
                RuntimeCostAccounter.recordJump();
                if (bl4) break block9;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
                boolean bl5 = string.startsWith("GMT");
                RuntimeCostAccounter.recordJump();
                if (!bl5) break block10;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.ofWithPrefix:(Ljava/lang/String;IZ)Ljava/time/ZoneId;");
            return ZoneId.ofWithPrefix(string, 3, bl);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
        boolean bl6 = string.startsWith("UT");
        RuntimeCostAccounter.recordJump();
        if (bl6) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.ofWithPrefix:(Ljava/lang/String;IZ)Ljava/time/ZoneId;");
            return ZoneId.ofWithPrefix(string, 2, bl);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneRegion.ofId:(Ljava/lang/String;Z)Ljava/time/ZoneRegion;");
        return ZoneRegion.ofId(string, bl);
    }

    private static ZoneId ofWithPrefix(String string, int n, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
        String string2 = string.substring(0, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n2 = string.length();
        RuntimeCostAccounter.recordJump();
        if (n2 == n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.ofOffset:(Ljava/lang/String;Ljava/time/ZoneOffset;)Ljava/time/ZoneId;");
            return ZoneId.ofOffset(string2, ZoneOffset.UTC);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
        char c = string.charAt(n);
        RuntimeCostAccounter.recordJump();
        if (c != '+') {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
            char c2 = string.charAt(n);
            RuntimeCostAccounter.recordJump();
            if (c2 != '-') {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneRegion.ofId:(Ljava/lang/String;Z)Ljava/time/ZoneRegion;");
                return ZoneRegion.ofId(string, bl);
            }
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
            String string3 = string.substring(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.of:(Ljava/lang/String;)Ljava/time/ZoneOffset;");
            ZoneOffset zoneOffset = ZoneOffset.of(string3);
            RuntimeCostAccounter.recordJump();
            if (zoneOffset == ZoneOffset.UTC) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.ofOffset:(Ljava/lang/String;Ljava/time/ZoneOffset;)Ljava/time/ZoneId;");
                return ZoneId.ofOffset(string2, zoneOffset);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.ofOffset:(Ljava/lang/String;Ljava/time/ZoneOffset;)Ljava/time/ZoneId;");
            return ZoneId.ofOffset(string2, zoneOffset);
        }
        catch (DateTimeException dateTimeException) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Invalid ID for offset-based ZoneId: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string4 = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            DateTimeException dateTimeException2 = new DateTimeException(string4, dateTimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException2;
        }
    }

    public static ZoneId from(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zone:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<ZoneId> temporalQuery = TemporalQueries.zone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        ZoneId zoneId = temporalAccessor.query(temporalQuery);
        RuntimeCostAccounter.recordJump();
        if (zoneId == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain ZoneId from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" of type ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
            String string = clazz.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string2);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        return zoneId;
    }

    ZoneId() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordJump();
        if (clazz != ZoneOffset.class) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz2 = this.getClass();
            RuntimeCostAccounter.recordJump();
            if (clazz2 != ZoneRegion.class) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                AssertionError assertionError = new AssertionError((Object)"Invalid subclass");
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }
    }

    public abstract String getId();

    public String getDisplayName(TextStyle textStyle, Locale locale) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendZoneText:(Ljava/time/format/TextStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder2 = dateTimeFormatterBuilder.appendZoneText(textStyle);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/util/Locale;)Ljava/time/format/DateTimeFormatter;");
        DateTimeFormatter dateTimeFormatter = dateTimeFormatterBuilder2.toFormatter(locale);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.toTemporal:()Ljava/time/temporal/TemporalAccessor;");
        TemporalAccessor temporalAccessor = this.toTemporal();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.format:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/String;");
        return dateTimeFormatter.format(temporalAccessor);
    }

    private TemporalAccessor toTemporal() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/ZoneId$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId$1.<init>:(Ljava/time/ZoneId;)V");
        return new TemporalAccessor(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public boolean isSupported(TemporalField temporalField) {
                return false;
            }

            @Override
            public long getLong(TemporalField temporalField) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder3.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
                UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
                RuntimeCostAccounter.recordThrow();
                throw unsupportedTemporalTypeException;
            }

            @Override
            public <R> R query(TemporalQuery<R> temporalQuery) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zoneId:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneId> temporalQuery2 = TemporalQueries.zoneId();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery2) {
                    return (R)ZoneId.this;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
                return TemporalAccessor.super.query(temporalQuery);
            }
        };
    }

    public abstract ZoneRules getRules();

    public ZoneId normalized() {
        block2: {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
                ZoneRules zoneRules = this.getRules();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.isFixedOffset:()Z");
                boolean bl = zoneRules.isFixedOffset();
                RuntimeCostAccounter.recordJump();
                if (!bl) break block2;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getOffset:(Ljava/time/Instant;)Ljava/time/ZoneOffset;");
                return zoneRules.getOffset(Instant.EPOCH);
            }
            catch (ZoneRulesException zoneRulesException) {
                // empty catch block
            }
        }
        RuntimeCostAccounter.recordJump();
        return this;
    }

    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof ZoneId;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ZoneId zoneId = (ZoneId)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getId:()Ljava/lang/String;");
            String string = this.getId();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getId:()Ljava/lang/String;");
            String string2 = zoneId.getId();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
            return string.equals(string2);
        }
        return false;
    }

    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getId:()Ljava/lang/String;");
        String string = this.getId();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.hashCode:()I");
        return string.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getId:()Ljava/lang/String;");
        return this.getId();
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(7, this);
    }

    abstract void write(DataOutput var1) throws IOException;

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:(I)V");
        HashMap<String, String> hashMap = new HashMap<String, String>(64);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("ACT", "Australia/Darwin");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("AET", "Australia/Sydney");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("AGT", "America/Argentina/Buenos_Aires");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("ART", "Africa/Cairo");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("AST", "America/Anchorage");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("BET", "America/Sao_Paulo");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("BST", "Asia/Dhaka");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("CAT", "Africa/Harare");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("CNT", "America/St_Johns");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("CST", "America/Chicago");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("CTT", "Asia/Shanghai");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("EAT", "Africa/Addis_Ababa");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("ECT", "Europe/Paris");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("IET", "America/Indiana/Indianapolis");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("IST", "Asia/Kolkata");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("JST", "Asia/Tokyo");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("MIT", "Pacific/Apia");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("NET", "Asia/Yerevan");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("NST", "Pacific/Auckland");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("PLT", "Asia/Karachi");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("PNT", "America/Phoenix");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("PRT", "America/Puerto_Rico");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("PST", "America/Los_Angeles");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("SST", "Pacific/Guadalcanal");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("VST", "Asia/Ho_Chi_Minh");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("EST", "-05:00");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("MST", "-07:00");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put("HST", "-10:00");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableMap:(Ljava/util/Map;)Ljava/util/Map;");
        SHORT_IDS = Collections.unmodifiableMap(hashMap);
    }
}

