/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.math;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.math.BigDecimal;
import sandbox.java.math.BigInteger;
import sandbox.java.math.SignedMutableBigInteger;
import sandbox.java.util.Arrays;

class MutableBigInteger {
    int[] value;
    int intLen;
    int offset;
    static final MutableBigInteger ONE;
    static final int KNUTH_POW2_THRESH_LEN = 6;
    static final int KNUTH_POW2_THRESH_ZEROS = 3;
    static final /* synthetic */ boolean $assertionsDisabled;

    MutableBigInteger() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.offset = 0;
        RuntimeCostAccounter.recordArrayAllocation((int)1, (int)4);
        this.value = new int[1];
        this.intLen = 0;
    }

    MutableBigInteger(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.offset = 0;
        RuntimeCostAccounter.recordArrayAllocation((int)1, (int)4);
        this.value = new int[1];
        this.intLen = 1;
        this.value[0] = n;
    }

    MutableBigInteger(int[] nArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.offset = 0;
        this.value = nArray;
        this.intLen = nArray.length;
    }

    MutableBigInteger(BigInteger bigInteger) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.offset = 0;
        this.intLen = bigInteger.mag.length;
        int[] nArray = bigInteger.mag;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([II)[I");
        this.value = Arrays.copyOf(nArray, this.intLen);
    }

    MutableBigInteger(MutableBigInteger mutableBigInteger) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.offset = 0;
        this.intLen = mutableBigInteger.intLen;
        int[] nArray = mutableBigInteger.value;
        int n = mutableBigInteger.offset;
        int n2 = mutableBigInteger.offset + this.intLen;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOfRange:([III)[I");
        this.value = Arrays.copyOfRange(nArray, n, n2);
    }

    private void ones(int n) {
        int n2 = this.value.length;
        RuntimeCostAccounter.recordJump();
        if (n > n2) {
            int n3 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
            this.value = new int[n3];
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.fill:([II)V");
        Arrays.fill(this.value, -1);
        this.offset = 0;
        this.intLen = n;
    }

    private int[] getMagnitudeArray() {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (this.offset > 0) break block2;
                int n = this.value.length;
                RuntimeCostAccounter.recordJump();
                if (n == this.intLen) break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOfRange:([III)[I");
            return Arrays.copyOfRange(this.value, this.offset, this.offset + this.intLen);
        }
        return this.value;
    }

    private long toLong() {
        long l;
        RuntimeCostAccounter.recordJump();
        if (!$assertionsDisabled) {
            RuntimeCostAccounter.recordJump();
            if (this.intLen > 2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                AssertionError assertionError = new AssertionError((Object)"this MutableBigInteger exceeds the range of long");
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (this.intLen == 0) {
            return 0L;
        }
        long l2 = (long)this.value[this.offset] & 0xFFFFFFFFL;
        RuntimeCostAccounter.recordJump();
        if (this.intLen == 2) {
            l = l2 << 32 | (long)this.value[this.offset + 1] & 0xFFFFFFFFL;
            RuntimeCostAccounter.recordJump();
        } else {
            l = l2;
        }
        return l;
    }

    BigInteger toBigInteger(int n) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (this.intLen == 0) break block2;
                RuntimeCostAccounter.recordJump();
                if (n != 0) break block3;
            }
            return BigInteger.ZERO;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.getMagnitudeArray:()[I");
        int[] nArray = this.getMagnitudeArray();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
        return new BigInteger(nArray, n);
    }

    BigInteger toBigInteger() {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.normalize:()V");
        this.normalize();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.isZero:()Z");
        boolean bl = this.isZero();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            n = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 1;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toBigInteger:(I)Ljava/math/BigInteger;");
        return this.toBigInteger(n);
    }

    BigDecimal toBigDecimal(int n, int n2) {
        long l;
        long l2;
        int n3;
        int n4;
        int[] nArray;
        block13: {
            block12: {
                block11: {
                    block10: {
                        RuntimeCostAccounter.recordJump();
                        if (this.intLen == 0) break block10;
                        RuntimeCostAccounter.recordJump();
                        if (n != 0) break block11;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.zeroValueOf:(I)Ljava/math/BigDecimal;");
                    return BigDecimal.zeroValueOf(n2);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.getMagnitudeArray:()[I");
                nArray = this.getMagnitudeArray();
                n4 = nArray.length;
                n3 = nArray[0];
                RuntimeCostAccounter.recordJump();
                if (n4 > 2) break block12;
                RuntimeCostAccounter.recordJump();
                if (n3 >= 0) break block13;
                RuntimeCostAccounter.recordJump();
                if (n4 != 2) break block13;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigDecimal");
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
            BigInteger bigInteger = new BigInteger(nArray, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.<init>:(Ljava/math/BigInteger;JII)V");
            return new BigDecimal(bigInteger, Long.MIN_VALUE, n2, 0);
        }
        RuntimeCostAccounter.recordJump();
        if (n4 == 2) {
            l2 = (long)nArray[1] & 0xFFFFFFFFL | ((long)n3 & 0xFFFFFFFFL) << 32;
            RuntimeCostAccounter.recordJump();
        } else {
            l2 = (long)n3 & 0xFFFFFFFFL;
        }
        long l3 = l2;
        RuntimeCostAccounter.recordJump();
        if (n == -1) {
            l = -l3;
            RuntimeCostAccounter.recordJump();
        } else {
            l = l3;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.valueOf:(JI)Ljava/math/BigDecimal;");
        return BigDecimal.valueOf(l, n2);
    }

    long toCompactValue(int n) {
        long l;
        long l2;
        int n2;
        int n3;
        int[] nArray;
        block13: {
            block12: {
                block11: {
                    block10: {
                        RuntimeCostAccounter.recordJump();
                        if (this.intLen == 0) break block10;
                        RuntimeCostAccounter.recordJump();
                        if (n != 0) break block11;
                    }
                    return 0L;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.getMagnitudeArray:()[I");
                nArray = this.getMagnitudeArray();
                n3 = nArray.length;
                n2 = nArray[0];
                RuntimeCostAccounter.recordJump();
                if (n3 > 2) break block12;
                RuntimeCostAccounter.recordJump();
                if (n2 >= 0) break block13;
                RuntimeCostAccounter.recordJump();
                if (n3 != 2) break block13;
            }
            return Long.MIN_VALUE;
        }
        RuntimeCostAccounter.recordJump();
        if (n3 == 2) {
            l2 = (long)nArray[1] & 0xFFFFFFFFL | ((long)n2 & 0xFFFFFFFFL) << 32;
            RuntimeCostAccounter.recordJump();
        } else {
            l2 = (long)n2 & 0xFFFFFFFFL;
        }
        long l3 = l2;
        RuntimeCostAccounter.recordJump();
        if (n == -1) {
            l = -l3;
            RuntimeCostAccounter.recordJump();
        } else {
            l = l3;
        }
        return l;
    }

    void clear() {
        this.intLen = 0;
        this.offset = 0;
        int n = 0;
        int n2 = this.value.length;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            this.value[n] = 0;
            ++n;
            RuntimeCostAccounter.recordJump();
        }
    }

    void reset() {
        this.intLen = 0;
        this.offset = 0;
    }

    final int compare(MutableBigInteger mutableBigInteger) {
        int n = mutableBigInteger.intLen;
        RuntimeCostAccounter.recordJump();
        if (this.intLen < n) {
            return -1;
        }
        RuntimeCostAccounter.recordJump();
        if (this.intLen > n) {
            return 1;
        }
        int[] nArray = mutableBigInteger.value;
        int n2 = this.offset;
        int n3 = mutableBigInteger.offset;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= this.intLen + this.offset) break;
            int n4 = this.value[n2] + Integer.MIN_VALUE;
            int n5 = nArray[n3] + Integer.MIN_VALUE;
            RuntimeCostAccounter.recordJump();
            if (n4 < n5) {
                return -1;
            }
            RuntimeCostAccounter.recordJump();
            if (n4 > n5) {
                return 1;
            }
            ++n2;
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        return 0;
    }

    private int compareShifted(MutableBigInteger mutableBigInteger, int n) {
        int n2 = mutableBigInteger.intLen;
        int n3 = this.intLen - n;
        RuntimeCostAccounter.recordJump();
        if (n3 < n2) {
            return -1;
        }
        RuntimeCostAccounter.recordJump();
        if (n3 > n2) {
            return 1;
        }
        int[] nArray = mutableBigInteger.value;
        int n4 = this.offset;
        int n5 = mutableBigInteger.offset;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 >= n3 + this.offset) break;
            int n6 = this.value[n4] + Integer.MIN_VALUE;
            int n7 = nArray[n5] + Integer.MIN_VALUE;
            RuntimeCostAccounter.recordJump();
            if (n6 < n7) {
                return -1;
            }
            RuntimeCostAccounter.recordJump();
            if (n6 > n7) {
                return 1;
            }
            ++n4;
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
        return 0;
    }

    final int compareHalf(MutableBigInteger mutableBigInteger) {
        int n;
        int n2 = mutableBigInteger.intLen;
        int n3 = this.intLen;
        RuntimeCostAccounter.recordJump();
        if (n3 <= 0) {
            int n4;
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) {
                n4 = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                n4 = -1;
            }
            return n4;
        }
        RuntimeCostAccounter.recordJump();
        if (n3 > n2) {
            return 1;
        }
        RuntimeCostAccounter.recordJump();
        if (n3 < n2 - 1) {
            return -1;
        }
        int[] nArray = mutableBigInteger.value;
        int n5 = 0;
        int n6 = 0;
        RuntimeCostAccounter.recordJump();
        if (n3 != n2) {
            int n7 = nArray[n5];
            RuntimeCostAccounter.recordJump();
            if (n7 == 1) {
                ++n5;
                n6 = Integer.MIN_VALUE;
                RuntimeCostAccounter.recordJump();
            } else {
                return -1;
            }
        }
        int[] nArray2 = this.value;
        int n8 = this.offset;
        int n9 = n5;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n8 >= n3 + this.offset) break;
            int n10 = nArray[n9++];
            long l = (long)((n10 >>> 1) + n6) & 0xFFFFFFFFL;
            long l2 = (long)nArray2[n8++] & 0xFFFFFFFFL;
            RuntimeCostAccounter.recordJump();
            if (l2 != l) {
                int n11;
                RuntimeCostAccounter.recordJump();
                if (l2 < l) {
                    n11 = -1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n11 = 1;
                }
                return n11;
            }
            n6 = (n10 & 1) << 31;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (n6 == 0) {
            n = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            n = -1;
        }
        return n;
    }

    private final int getLowestSetBit() {
        RuntimeCostAccounter.recordJump();
        if (this.intLen == 0) {
            return -1;
        }
        int n = this.intLen - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            int n2 = this.value[n + this.offset];
            RuntimeCostAccounter.recordJump();
            if (n2 != 0) break;
            --n;
            RuntimeCostAccounter.recordJump();
        }
        int n3 = this.value[n + this.offset];
        RuntimeCostAccounter.recordJump();
        if (n3 == 0) {
            return -1;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfTrailingZeros:(I)I");
        return (this.intLen - 1 - n << 5) + Integer.numberOfTrailingZeros(n3);
    }

    private final int getInt(int n) {
        return this.value[this.offset + n];
    }

    private final long getLong(int n) {
        return (long)this.value[this.offset + n] & 0xFFFFFFFFL;
    }

    final void normalize() {
        int n;
        int n2;
        RuntimeCostAccounter.recordJump();
        if (this.intLen == 0) {
            this.offset = 0;
            return;
        }
        int n3 = this.offset;
        int n4 = this.value[n3];
        RuntimeCostAccounter.recordJump();
        if (n4 != 0) {
            return;
        }
        int n5 = n3 + this.intLen;
        do {
            RuntimeCostAccounter.recordJump();
            if (++n3 >= n5) break;
            n2 = this.value[n3];
            RuntimeCostAccounter.recordJump();
        } while (n2 == 0);
        int n6 = n3 - this.offset;
        this.intLen -= n6;
        RuntimeCostAccounter.recordJump();
        if (this.intLen == 0) {
            n = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            n = this.offset + n6;
        }
        this.offset = n;
    }

    private final void ensureCapacity(int n) {
        int n2 = this.value.length;
        RuntimeCostAccounter.recordJump();
        if (n2 < n) {
            int n3 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
            this.value = new int[n3];
            this.offset = 0;
            this.intLen = n;
        }
    }

    int[] toIntArray() {
        int n = this.intLen;
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)4);
        int[] nArray = new int[n];
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= this.intLen) break;
            nArray[n2] = this.value[this.offset + n2];
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        return nArray;
    }

    void setInt(int n, int n2) {
        this.value[this.offset + n] = n2;
    }

    void setValue(int[] nArray, int n) {
        this.value = nArray;
        this.intLen = n;
        this.offset = 0;
    }

    void copyValue(MutableBigInteger mutableBigInteger) {
        int n = mutableBigInteger.intLen;
        int n2 = this.value.length;
        RuntimeCostAccounter.recordJump();
        if (n2 < n) {
            int n3 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
            this.value = new int[n3];
        }
        int[] nArray = mutableBigInteger.value;
        int n4 = mutableBigInteger.offset;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(nArray, n4, this.value, 0, n);
        this.intLen = n;
        this.offset = 0;
    }

    void copyValue(int[] nArray) {
        int n = nArray.length;
        int n2 = this.value.length;
        RuntimeCostAccounter.recordJump();
        if (n2 < n) {
            int n3 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
            this.value = new int[n3];
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(nArray, 0, this.value, 0, n);
        this.intLen = n;
        this.offset = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isOne() {
        RuntimeCostAccounter.recordJump();
        if (this.intLen != 1) return false;
        int n = this.value[this.offset];
        RuntimeCostAccounter.recordJump();
        if (n != 1) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    boolean isZero() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.intLen == 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isEven() {
        RuntimeCostAccounter.recordJump();
        if (this.intLen != 0) {
            int n = this.value[this.offset + this.intLen - 1] & 1;
            RuntimeCostAccounter.recordJump();
            if (n != 0) return false;
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    boolean isOdd() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.isZero:()Z");
        boolean bl2 = this.isZero();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            bl = false;
            RuntimeCostAccounter.recordJump();
        } else {
            int n = this.value[this.offset + this.intLen - 1] & 1;
            RuntimeCostAccounter.recordJump();
            if (n == 1) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
        }
        return bl;
    }

    boolean isNormal() {
        boolean bl;
        int n = this.value.length;
        RuntimeCostAccounter.recordJump();
        if (this.intLen + this.offset > n) {
            return false;
        }
        RuntimeCostAccounter.recordJump();
        if (this.intLen == 0) {
            return true;
        }
        int n2 = this.value[this.offset];
        RuntimeCostAccounter.recordJump();
        if (n2 != 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toBigInteger:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger = this.toBigInteger(1);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.toString:()Ljava/lang/String;");
        return bigInteger.toString();
    }

    void safeRightShift(int n) {
        int n2 = n / 32;
        RuntimeCostAccounter.recordJump();
        if (n2 >= this.intLen) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.reset:()V");
            this.reset();
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.rightShift:(I)V");
            this.rightShift(n);
        }
    }

    void rightShift(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.intLen == 0) {
            return;
        }
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        this.intLen -= n2;
        RuntimeCostAccounter.recordJump();
        if (n3 == 0) {
            return;
        }
        int n4 = this.value[this.offset];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLengthForInt:(I)I");
        int n5 = BigInteger.bitLengthForInt(n4);
        RuntimeCostAccounter.recordJump();
        if (n3 >= n5) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.primitiveLeftShift:(I)V");
            this.primitiveLeftShift(32 - n3);
            --this.intLen;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.primitiveRightShift:(I)V");
            this.primitiveRightShift(n3);
        }
    }

    void safeLeftShift(int n) {
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.leftShift:(I)V");
            this.leftShift(n);
        }
    }

    void leftShift(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.intLen == 0) {
            return;
        }
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        int n4 = this.value[this.offset];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLengthForInt:(I)I");
        int n5 = BigInteger.bitLengthForInt(n4);
        RuntimeCostAccounter.recordJump();
        if (n <= 32 - n5) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.primitiveLeftShift:(I)V");
            this.primitiveLeftShift(n3);
            return;
        }
        int n6 = this.intLen + n2 + 1;
        RuntimeCostAccounter.recordJump();
        if (n3 <= 32 - n5) {
            --n6;
        }
        int n7 = this.value.length;
        RuntimeCostAccounter.recordJump();
        if (n7 < n6) {
            int n8 = n6;
            RuntimeCostAccounter.recordArrayAllocation((int)n8, (int)4);
            int[] nArray = new int[n8];
            int n9 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n9 >= this.intLen) break;
                nArray[n9] = this.value[this.offset + n9];
                ++n9;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.setValue:([II)V");
            this.setValue(nArray, n6);
            RuntimeCostAccounter.recordJump();
        } else {
            int n10 = this.value.length - this.offset;
            RuntimeCostAccounter.recordJump();
            if (n10 >= n6) {
                int n11 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n11 >= n6 - this.intLen) break;
                    this.value[this.offset + this.intLen + n11] = 0;
                    ++n11;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
            } else {
                int n12 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n12 >= this.intLen) break;
                    this.value[n12] = this.value[this.offset + n12];
                    ++n12;
                    RuntimeCostAccounter.recordJump();
                }
                n12 = this.intLen;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n12 >= n6) break;
                    this.value[n12] = 0;
                    ++n12;
                    RuntimeCostAccounter.recordJump();
                }
                this.offset = 0;
            }
        }
        this.intLen = n6;
        RuntimeCostAccounter.recordJump();
        if (n3 == 0) {
            return;
        }
        RuntimeCostAccounter.recordJump();
        if (n3 <= 32 - n5) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.primitiveLeftShift:(I)V");
            this.primitiveLeftShift(n3);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.primitiveRightShift:(I)V");
            this.primitiveRightShift(32 - n3);
        }
    }

    private int divadd(int[] nArray, int[] nArray2, int n) {
        long l = 0L;
        int n2 = nArray.length - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 < 0) break;
            long l2 = ((long)nArray[n2] & 0xFFFFFFFFL) + ((long)nArray2[n2 + n] & 0xFFFFFFFFL) + l;
            nArray2[n2 + n] = (int)l2;
            l = l2 >>> 32;
            --n2;
            RuntimeCostAccounter.recordJump();
        }
        return (int)l;
    }

    private int mulsub(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        long l = (long)n & 0xFFFFFFFFL;
        long l2 = 0L;
        n3 += n2;
        int n4 = n2 - 1;
        while (true) {
            int n5;
            RuntimeCostAccounter.recordJump();
            if (n4 < 0) break;
            long l3 = ((long)nArray2[n4] & 0xFFFFFFFFL) * l + l2;
            long l4 = (long)nArray[n3] - l3;
            nArray[n3--] = (int)l4;
            long l5 = (l4 & 0xFFFFFFFFL) - ((long)(~((int)l3)) & 0xFFFFFFFFL);
            long l6 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l6 > 0) {
                n5 = 1;
                RuntimeCostAccounter.recordJump();
            } else {
                n5 = 0;
            }
            l2 = (l3 >>> 32) + (long)n5;
            --n4;
            RuntimeCostAccounter.recordJump();
        }
        return (int)l2;
    }

    private int mulsubBorrow(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        long l = (long)n & 0xFFFFFFFFL;
        long l2 = 0L;
        n3 += n2;
        int n4 = n2 - 1;
        while (true) {
            int n5;
            RuntimeCostAccounter.recordJump();
            if (n4 < 0) break;
            long l3 = ((long)nArray2[n4] & 0xFFFFFFFFL) * l + l2;
            long l4 = (long)nArray[n3--] - l3;
            long l5 = (l4 & 0xFFFFFFFFL) - ((long)(~((int)l3)) & 0xFFFFFFFFL);
            long l6 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l6 > 0) {
                n5 = 1;
                RuntimeCostAccounter.recordJump();
            } else {
                n5 = 0;
            }
            l2 = (l3 >>> 32) + (long)n5;
            --n4;
            RuntimeCostAccounter.recordJump();
        }
        return (int)l2;
    }

    private final void primitiveRightShift(int n) {
        int[] nArray = this.value;
        int n2 = 32 - n;
        int n3 = this.offset + this.intLen - 1;
        int n4 = nArray[n3];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 <= this.offset) break;
            int n5 = n4;
            n4 = nArray[n3 - 1];
            nArray[n3] = n4 << n2 | n5 >>> n;
            --n3;
            RuntimeCostAccounter.recordJump();
        }
        int n6 = this.offset;
        nArray[n6] = nArray[n6] >>> n;
    }

    private final void primitiveLeftShift(int n) {
        int[] nArray = this.value;
        int n2 = 32 - n;
        int n3 = this.offset;
        int n4 = nArray[n3];
        int n5 = n3 + this.intLen - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n5) break;
            int n6 = n4;
            n4 = nArray[n3 + 1];
            nArray[n3] = n6 << n | n4 >>> n2;
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        int n7 = this.offset + this.intLen - 1;
        nArray[n7] = nArray[n7] << n;
    }

    private BigInteger getLower(int n) {
        int n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.isZero:()Z");
        boolean bl = this.isZero();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return BigInteger.ZERO;
        }
        RuntimeCostAccounter.recordJump();
        if (this.intLen < n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toBigInteger:(I)Ljava/math/BigInteger;");
            return this.toBigInteger(1);
        }
        int n3 = n;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 <= 0) break;
            int n4 = this.value[this.offset + this.intLen - n3];
            RuntimeCostAccounter.recordJump();
            if (n4 != 0) break;
            --n3;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (n3 > 0) {
            n2 = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = 0;
        }
        int n5 = n2;
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOfRange:([III)[I");
        int[] nArray = Arrays.copyOfRange(this.value, this.offset + this.intLen - n3, this.offset + this.intLen);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
        return new BigInteger(nArray, n5);
    }

    private void keepLower(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.intLen >= n) {
            this.offset += this.intLen - n;
            this.intLen = n;
        }
    }

    void add(MutableBigInteger mutableBigInteger) {
        long l;
        int[] nArray;
        int n;
        int n2 = this.intLen;
        int n3 = mutableBigInteger.intLen;
        int n4 = mutableBigInteger.intLen;
        RuntimeCostAccounter.recordJump();
        if (this.intLen > n4) {
            n = this.intLen;
            RuntimeCostAccounter.recordJump();
        } else {
            n = mutableBigInteger.intLen;
        }
        int n5 = n;
        int n6 = this.value.length;
        RuntimeCostAccounter.recordJump();
        if (n6 < n5) {
            int n7 = n5;
            RuntimeCostAccounter.recordArrayAllocation((int)n7, (int)4);
            nArray = new int[n7];
            RuntimeCostAccounter.recordJump();
        } else {
            nArray = this.value;
        }
        int[] nArray2 = nArray;
        int n8 = nArray2.length - 1;
        long l2 = 0L;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) break;
            RuntimeCostAccounter.recordJump();
            if (n3 <= 0) break;
            l = ((long)this.value[--n2 + this.offset] & 0xFFFFFFFFL) + ((long)mutableBigInteger.value[--n3 + mutableBigInteger.offset] & 0xFFFFFFFFL) + l2;
            nArray2[n8--] = (int)l;
            l2 = l >>> 32;
            RuntimeCostAccounter.recordJump();
        }
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) break;
            --n2;
            RuntimeCostAccounter.recordJump();
            if (l2 == 0L) {
                RuntimeCostAccounter.recordJump();
                if (nArray2 == this.value) {
                    RuntimeCostAccounter.recordJump();
                    if (n8 == n2 + this.offset) {
                        return;
                    }
                }
            }
            l = ((long)this.value[n2 + this.offset] & 0xFFFFFFFFL) + l2;
            nArray2[n8--] = (int)l;
            l2 = l >>> 32;
            RuntimeCostAccounter.recordJump();
        }
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 <= 0) break;
            l = ((long)mutableBigInteger.value[--n3 + mutableBigInteger.offset] & 0xFFFFFFFFL) + l2;
            nArray2[n8--] = (int)l;
            l2 = l >>> 32;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (l2 > 0L) {
            int n9 = nArray2.length;
            RuntimeCostAccounter.recordJump();
            if (n9 < ++n5) {
                int n10 = n5;
                RuntimeCostAccounter.recordArrayAllocation((int)n10, (int)4);
                int[] nArray3 = new int[n10];
                int n11 = nArray2.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(nArray2, 0, nArray3, 1, n11);
                nArray3[0] = 1;
                nArray2 = nArray3;
                RuntimeCostAccounter.recordJump();
            } else {
                nArray2[n8--] = 1;
            }
        }
        this.value = nArray2;
        this.intLen = n5;
        this.offset = nArray2.length - n5;
    }

    void addShifted(MutableBigInteger mutableBigInteger, int n) {
        long l;
        int n2;
        int[] nArray;
        int n3;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.isZero:()Z");
        boolean bl = mutableBigInteger.isZero();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return;
        }
        int n4 = this.intLen;
        int n5 = mutableBigInteger.intLen + n;
        RuntimeCostAccounter.recordJump();
        if (this.intLen > n5) {
            n3 = this.intLen;
            RuntimeCostAccounter.recordJump();
        } else {
            n3 = n5;
        }
        int n6 = n3;
        int n7 = this.value.length;
        RuntimeCostAccounter.recordJump();
        if (n7 < n6) {
            int n8 = n6;
            RuntimeCostAccounter.recordArrayAllocation((int)n8, (int)4);
            nArray = new int[n8];
            RuntimeCostAccounter.recordJump();
        } else {
            nArray = this.value;
        }
        int[] nArray2 = nArray;
        int n9 = nArray2.length - 1;
        long l2 = 0L;
        while (true) {
            int n10;
            RuntimeCostAccounter.recordJump();
            if (n4 <= 0) break;
            RuntimeCostAccounter.recordJump();
            if (n5 <= 0) break;
            --n4;
            int n11 = --n5 + mutableBigInteger.offset;
            int n12 = mutableBigInteger.value.length;
            RuntimeCostAccounter.recordJump();
            if (n11 < n12) {
                n10 = mutableBigInteger.value[n5 + mutableBigInteger.offset];
                RuntimeCostAccounter.recordJump();
            } else {
                n10 = 0;
            }
            n2 = n10;
            l = ((long)this.value[n4 + this.offset] & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL) + l2;
            nArray2[n9--] = (int)l;
            l2 = l >>> 32;
            RuntimeCostAccounter.recordJump();
        }
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 <= 0) break;
            --n4;
            RuntimeCostAccounter.recordJump();
            if (l2 == 0L) {
                RuntimeCostAccounter.recordJump();
                if (nArray2 == this.value) {
                    RuntimeCostAccounter.recordJump();
                    if (n9 == n4 + this.offset) {
                        return;
                    }
                }
            }
            l = ((long)this.value[n4 + this.offset] & 0xFFFFFFFFL) + l2;
            nArray2[n9--] = (int)l;
            l2 = l >>> 32;
            RuntimeCostAccounter.recordJump();
        }
        while (true) {
            int n13;
            RuntimeCostAccounter.recordJump();
            if (n5 <= 0) break;
            int n14 = --n5 + mutableBigInteger.offset;
            int n15 = mutableBigInteger.value.length;
            RuntimeCostAccounter.recordJump();
            if (n14 < n15) {
                n13 = mutableBigInteger.value[n5 + mutableBigInteger.offset];
                RuntimeCostAccounter.recordJump();
            } else {
                n13 = 0;
            }
            n2 = n13;
            l = ((long)n2 & 0xFFFFFFFFL) + l2;
            nArray2[n9--] = (int)l;
            l2 = l >>> 32;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (l2 > 0L) {
            int n16 = nArray2.length;
            RuntimeCostAccounter.recordJump();
            if (n16 < ++n6) {
                int n17 = n6;
                RuntimeCostAccounter.recordArrayAllocation((int)n17, (int)4);
                int[] nArray3 = new int[n17];
                int n18 = nArray2.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(nArray2, 0, nArray3, 1, n18);
                nArray3[0] = 1;
                nArray2 = nArray3;
                RuntimeCostAccounter.recordJump();
            } else {
                nArray2[n9--] = 1;
            }
        }
        this.value = nArray2;
        this.intLen = n6;
        this.offset = nArray2.length - n6;
    }

    void addDisjoint(MutableBigInteger mutableBigInteger, int n) {
        int[] nArray;
        int n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.isZero:()Z");
        boolean bl = mutableBigInteger.isZero();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return;
        }
        int n3 = this.intLen;
        int n4 = mutableBigInteger.intLen + n;
        RuntimeCostAccounter.recordJump();
        if (this.intLen > n4) {
            n2 = this.intLen;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = n4;
        }
        int n5 = n2;
        int n6 = this.value.length;
        RuntimeCostAccounter.recordJump();
        if (n6 < n5) {
            int n7 = n5;
            RuntimeCostAccounter.recordArrayAllocation((int)n7, (int)4);
            nArray = new int[n7];
            RuntimeCostAccounter.recordJump();
        } else {
            nArray = this.value;
            int n8 = this.value.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.fill:([IIII)V");
            Arrays.fill(this.value, this.offset + this.intLen, n8, 0);
        }
        int n9 = nArray.length - 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(this.value, this.offset, nArray, n9 + 1 - n3, n3);
        n9 -= n3;
        int n10 = mutableBigInteger.value.length - mutableBigInteger.offset;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
        int n11 = Math.min(n4 -= n3, n10);
        int[] nArray2 = mutableBigInteger.value;
        int n12 = mutableBigInteger.offset;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(nArray2, n12, nArray, n9 + 1 - n4, n11);
        int n13 = n9 + 1 - n4 + n11;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n13 >= n9 + 1) break;
            nArray[n13] = 0;
            ++n13;
            RuntimeCostAccounter.recordJump();
        }
        this.value = nArray;
        this.intLen = n5;
        this.offset = nArray.length - n5;
    }

    void addLower(MutableBigInteger mutableBigInteger, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/MutableBigInteger;)V");
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(mutableBigInteger);
        int n2 = mutableBigInteger2.offset + mutableBigInteger2.intLen;
        RuntimeCostAccounter.recordJump();
        if (n2 >= n) {
            mutableBigInteger2.offset = mutableBigInteger2.offset + mutableBigInteger2.intLen - n;
            mutableBigInteger2.intLen = n;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.normalize:()V");
        mutableBigInteger2.normalize();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.add:(Ljava/math/MutableBigInteger;)V");
        this.add(mutableBigInteger2);
    }

    int subtract(MutableBigInteger mutableBigInteger) {
        MutableBigInteger mutableBigInteger2 = this;
        int[] nArray = this.value;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.compare:(Ljava/math/MutableBigInteger;)I");
        int n = mutableBigInteger2.compare(mutableBigInteger);
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.reset:()V");
            this.reset();
            return 0;
        }
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            MutableBigInteger mutableBigInteger3 = mutableBigInteger2;
            mutableBigInteger2 = mutableBigInteger;
            mutableBigInteger = mutableBigInteger3;
        }
        int n2 = mutableBigInteger2.intLen;
        int n3 = nArray.length;
        RuntimeCostAccounter.recordJump();
        if (n3 < n2) {
            int n4 = n2;
            RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)4);
            nArray = new int[n4];
        }
        long l = 0L;
        int n5 = mutableBigInteger2.intLen;
        int n6 = mutableBigInteger.intLen;
        int n7 = nArray.length - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n6 <= 0) break;
            l = ((long)mutableBigInteger2.value[--n5 + mutableBigInteger2.offset] & 0xFFFFFFFFL) - ((long)mutableBigInteger.value[--n6 + mutableBigInteger.offset] & 0xFFFFFFFFL) - (long)((int)(-(l >> 32)));
            nArray[n7--] = (int)l;
            RuntimeCostAccounter.recordJump();
        }
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n5 <= 0) break;
            l = ((long)mutableBigInteger2.value[--n5 + mutableBigInteger2.offset] & 0xFFFFFFFFL) - (long)((int)(-(l >> 32)));
            nArray[n7--] = (int)l;
            RuntimeCostAccounter.recordJump();
        }
        this.value = nArray;
        this.intLen = n2;
        this.offset = this.value.length - n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.normalize:()V");
        this.normalize();
        return n;
    }

    private int difference(MutableBigInteger mutableBigInteger) {
        MutableBigInteger mutableBigInteger2 = this;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.compare:(Ljava/math/MutableBigInteger;)I");
        int n = mutableBigInteger2.compare(mutableBigInteger);
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            return 0;
        }
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            MutableBigInteger mutableBigInteger3 = mutableBigInteger2;
            mutableBigInteger2 = mutableBigInteger;
            mutableBigInteger = mutableBigInteger3;
        }
        long l = 0L;
        int n2 = mutableBigInteger2.intLen;
        int n3 = mutableBigInteger.intLen;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 <= 0) break;
            l = ((long)mutableBigInteger2.value[mutableBigInteger2.offset + --n2] & 0xFFFFFFFFL) - ((long)mutableBigInteger.value[mutableBigInteger.offset + --n3] & 0xFFFFFFFFL) - (long)((int)(-(l >> 32)));
            mutableBigInteger2.value[mutableBigInteger2.offset + n2] = (int)l;
            RuntimeCostAccounter.recordJump();
        }
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) break;
            l = ((long)mutableBigInteger2.value[mutableBigInteger2.offset + --n2] & 0xFFFFFFFFL) - (long)((int)(-(l >> 32)));
            mutableBigInteger2.value[mutableBigInteger2.offset + n2] = (int)l;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.normalize:()V");
        mutableBigInteger2.normalize();
        return n;
    }

    void multiply(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2) {
        int n = this.intLen;
        int n2 = mutableBigInteger.intLen;
        int n3 = n + n2;
        int n4 = mutableBigInteger2.value.length;
        RuntimeCostAccounter.recordJump();
        if (n4 < n3) {
            int n5 = n3;
            RuntimeCostAccounter.recordArrayAllocation((int)n5, (int)4);
            mutableBigInteger2.value = new int[n5];
        }
        mutableBigInteger2.offset = 0;
        mutableBigInteger2.intLen = n3;
        long l = 0L;
        int n6 = n2 - 1;
        int n7 = n2 + n - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n6 < 0) break;
            long l2 = ((long)mutableBigInteger.value[n6 + mutableBigInteger.offset] & 0xFFFFFFFFL) * ((long)this.value[n - 1 + this.offset] & 0xFFFFFFFFL) + l;
            mutableBigInteger2.value[n7] = (int)l2;
            l = l2 >>> 32;
            --n6;
            --n7;
            RuntimeCostAccounter.recordJump();
        }
        mutableBigInteger2.value[n - 1] = (int)l;
        n6 = n - 2;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n6 < 0) break;
            l = 0L;
            n7 = n2 - 1;
            int n8 = n2 + n6;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n7 < 0) break;
                long l3 = ((long)mutableBigInteger.value[n7 + mutableBigInteger.offset] & 0xFFFFFFFFL) * ((long)this.value[n6 + this.offset] & 0xFFFFFFFFL) + ((long)mutableBigInteger2.value[n8] & 0xFFFFFFFFL) + l;
                mutableBigInteger2.value[n8] = (int)l3;
                l = l3 >>> 32;
                --n7;
                --n8;
                RuntimeCostAccounter.recordJump();
            }
            mutableBigInteger2.value[n6] = (int)l;
            --n6;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.normalize:()V");
        mutableBigInteger2.normalize();
    }

    void mul(int n, MutableBigInteger mutableBigInteger) {
        int[] nArray;
        RuntimeCostAccounter.recordJump();
        if (n == 1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.copyValue:(Ljava/math/MutableBigInteger;)V");
            mutableBigInteger.copyValue(this);
            return;
        }
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.clear:()V");
            mutableBigInteger.clear();
            return;
        }
        long l = (long)n & 0xFFFFFFFFL;
        int n2 = mutableBigInteger.value.length;
        RuntimeCostAccounter.recordJump();
        if (n2 < this.intLen + 1) {
            int n3 = this.intLen + 1;
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
            nArray = new int[n3];
            RuntimeCostAccounter.recordJump();
        } else {
            nArray = mutableBigInteger.value;
        }
        int[] nArray2 = nArray;
        long l2 = 0L;
        int n4 = this.intLen - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 < 0) break;
            long l3 = l * ((long)this.value[n4 + this.offset] & 0xFFFFFFFFL) + l2;
            nArray2[n4 + 1] = (int)l3;
            l2 = l3 >>> 32;
            --n4;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (l2 == 0L) {
            mutableBigInteger.offset = 1;
            mutableBigInteger.intLen = this.intLen;
            RuntimeCostAccounter.recordJump();
        } else {
            mutableBigInteger.offset = 0;
            mutableBigInteger.intLen = this.intLen + 1;
            nArray2[0] = (int)l2;
        }
        mutableBigInteger.value = nArray2;
    }

    int divideOneWord(int n, MutableBigInteger mutableBigInteger) {
        long l = (long)n & 0xFFFFFFFFL;
        RuntimeCostAccounter.recordJump();
        if (this.intLen == 1) {
            int n2;
            long l2 = (long)this.value[this.offset] & 0xFFFFFFFFL;
            int n3 = (int)(l2 / l);
            int n4 = (int)(l2 - (long)n3 * l);
            mutableBigInteger.value[0] = n3;
            RuntimeCostAccounter.recordJump();
            if (n3 == 0) {
                n2 = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = 1;
            }
            mutableBigInteger.intLen = n2;
            mutableBigInteger.offset = 0;
            return n4;
        }
        int n5 = mutableBigInteger.value.length;
        RuntimeCostAccounter.recordJump();
        if (n5 < this.intLen) {
            int n6 = this.intLen;
            RuntimeCostAccounter.recordArrayAllocation((int)n6, (int)4);
            mutableBigInteger.value = new int[n6];
        }
        mutableBigInteger.offset = 0;
        mutableBigInteger.intLen = this.intLen;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfLeadingZeros:(I)I");
        int n7 = Integer.numberOfLeadingZeros(n);
        int n8 = this.value[this.offset];
        long l3 = (long)n8 & 0xFFFFFFFFL;
        RuntimeCostAccounter.recordJump();
        if (l3 < l) {
            mutableBigInteger.value[0] = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            mutableBigInteger.value[0] = (int)(l3 / l);
            n8 = (int)(l3 - (long)mutableBigInteger.value[0] * l);
            l3 = (long)n8 & 0xFFFFFFFFL;
        }
        int n9 = this.intLen;
        while (true) {
            int n10;
            RuntimeCostAccounter.recordJump();
            if (--n9 <= 0) break;
            long l4 = l3 << 32 | (long)this.value[this.offset + this.intLen - n9] & 0xFFFFFFFFL;
            RuntimeCostAccounter.recordJump();
            if (l4 >= 0L) {
                n10 = (int)(l4 / l);
                n8 = (int)(l4 - (long)n10 * l);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divWord:(JI)J");
                long l5 = MutableBigInteger.divWord(l4, n);
                n10 = (int)(l5 & 0xFFFFFFFFL);
                n8 = (int)(l5 >>> 32);
            }
            mutableBigInteger.value[this.intLen - n9] = n10;
            l3 = (long)n8 & 0xFFFFFFFFL;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.normalize:()V");
        mutableBigInteger.normalize();
        RuntimeCostAccounter.recordJump();
        if (n7 > 0) {
            return n8 % n;
        }
        return n8;
    }

    MutableBigInteger divide(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divide:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;Z)Ljava/math/MutableBigInteger;");
        return this.divide(mutableBigInteger, mutableBigInteger2, true);
    }

    MutableBigInteger divide(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2, boolean bl) {
        block3: {
            block2: {
                int n = mutableBigInteger.intLen;
                RuntimeCostAccounter.recordJump();
                if (n < 80) break block2;
                int n2 = this.intLen - mutableBigInteger.intLen;
                RuntimeCostAccounter.recordJump();
                if (n2 >= 40) break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divideKnuth:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;Z)Ljava/math/MutableBigInteger;");
            return this.divideKnuth(mutableBigInteger, mutableBigInteger2, bl);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divideAndRemainderBurnikelZiegler:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
        return this.divideAndRemainderBurnikelZiegler(mutableBigInteger, mutableBigInteger2);
    }

    MutableBigInteger divideKnuth(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divideKnuth:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;Z)Ljava/math/MutableBigInteger;");
        return this.divideKnuth(mutableBigInteger, mutableBigInteger2, true);
    }

    MutableBigInteger divideKnuth(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2, boolean bl) {
        int n = mutableBigInteger.intLen;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
            ArithmeticException arithmeticException = new ArithmeticException("BigInteger divide by zero");
            RuntimeCostAccounter.recordThrow();
            throw arithmeticException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.intLen == 0) {
            MutableBigInteger mutableBigInteger3;
            mutableBigInteger2.offset = 0;
            mutableBigInteger2.intLen = 0;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
                mutableBigInteger3 = new MutableBigInteger();
                RuntimeCostAccounter.recordJump();
            } else {
                mutableBigInteger3 = null;
            }
            return mutableBigInteger3;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.compare:(Ljava/math/MutableBigInteger;)I");
        int n2 = this.compare(mutableBigInteger);
        RuntimeCostAccounter.recordJump();
        if (n2 < 0) {
            MutableBigInteger mutableBigInteger4;
            mutableBigInteger2.offset = 0;
            mutableBigInteger2.intLen = 0;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/MutableBigInteger;)V");
                mutableBigInteger4 = new MutableBigInteger(this);
                RuntimeCostAccounter.recordJump();
            } else {
                mutableBigInteger4 = null;
            }
            return mutableBigInteger4;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            MutableBigInteger mutableBigInteger5;
            mutableBigInteger2.intLen = 1;
            mutableBigInteger2.value[0] = 1;
            mutableBigInteger2.offset = 0;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
                mutableBigInteger5 = new MutableBigInteger();
                RuntimeCostAccounter.recordJump();
            } else {
                mutableBigInteger5 = null;
            }
            return mutableBigInteger5;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.clear:()V");
        mutableBigInteger2.clear();
        int n3 = mutableBigInteger.intLen;
        RuntimeCostAccounter.recordJump();
        if (n3 == 1) {
            int n4 = mutableBigInteger.value[mutableBigInteger.offset];
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divideOneWord:(ILjava/math/MutableBigInteger;)I");
            int n5 = this.divideOneWord(n4, mutableBigInteger2);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordJump();
                if (n5 == 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
                    return new MutableBigInteger();
                }
                RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(I)V");
                return new MutableBigInteger(n5);
            }
            return null;
        }
        RuntimeCostAccounter.recordJump();
        if (this.intLen >= 6) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.getLowestSetBit:()I");
            int n6 = this.getLowestSetBit();
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.getLowestSetBit:()I");
            int n7 = mutableBigInteger.getLowestSetBit();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
            int n8 = Math.min(n6, n7);
            RuntimeCostAccounter.recordJump();
            if (n8 >= 96) {
                RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/MutableBigInteger;)V");
                MutableBigInteger mutableBigInteger6 = new MutableBigInteger(this);
                RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/MutableBigInteger;)V");
                mutableBigInteger = new MutableBigInteger(mutableBigInteger);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.rightShift:(I)V");
                mutableBigInteger6.rightShift(n8);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.rightShift:(I)V");
                mutableBigInteger.rightShift(n8);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divideKnuth:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
                MutableBigInteger mutableBigInteger7 = mutableBigInteger6.divideKnuth(mutableBigInteger, mutableBigInteger2);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.leftShift:(I)V");
                mutableBigInteger7.leftShift(n8);
                return mutableBigInteger7;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divideMagnitude:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;Z)Ljava/math/MutableBigInteger;");
        return this.divideMagnitude(mutableBigInteger, mutableBigInteger2, bl);
    }

    MutableBigInteger divideAndRemainderBurnikelZiegler(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2) {
        MutableBigInteger mutableBigInteger3;
        int n = this.intLen;
        int n2 = mutableBigInteger.intLen;
        mutableBigInteger2.intLen = 0;
        mutableBigInteger2.offset = 0;
        RuntimeCostAccounter.recordJump();
        if (n < n2) {
            return this;
        }
        int n3 = n2 / 80;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfLeadingZeros:(I)I");
        int n4 = 1 << 32 - Integer.numberOfLeadingZeros(n3);
        int n5 = (n2 + n4 - 1) / n4;
        int n6 = n5 * n4;
        long l = 32L * (long)n6;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.bitLength:()J");
        long l2 = l - mutableBigInteger.bitLength();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(JJ)J");
        int n7 = (int)Math.max(0L, l2);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/MutableBigInteger;)V");
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger(mutableBigInteger);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.safeLeftShift:(I)V");
        mutableBigInteger4.safeLeftShift(n7);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.safeLeftShift:(I)V");
        this.safeLeftShift(n7);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.bitLength:()J");
        int n8 = (int)((this.bitLength() + l) / l);
        RuntimeCostAccounter.recordJump();
        if (n8 < 2) {
            n8 = 2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.getBlock:(III)Ljava/math/MutableBigInteger;");
        MutableBigInteger mutableBigInteger5 = this.getBlock(n8 - 1, n8, n6);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.getBlock:(III)Ljava/math/MutableBigInteger;");
        MutableBigInteger mutableBigInteger6 = this.getBlock(n8 - 2, n8, n6);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.addDisjoint:(Ljava/math/MutableBigInteger;I)V");
        mutableBigInteger6.addDisjoint(mutableBigInteger5, n6);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
        MutableBigInteger mutableBigInteger7 = new MutableBigInteger();
        int n9 = n8 - 2;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n9 <= 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divide2n1n:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
            mutableBigInteger3 = mutableBigInteger6.divide2n1n(mutableBigInteger4, mutableBigInteger7);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.getBlock:(III)Ljava/math/MutableBigInteger;");
            mutableBigInteger6 = this.getBlock(n9 - 1, n8, n6);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.addDisjoint:(Ljava/math/MutableBigInteger;I)V");
            mutableBigInteger6.addDisjoint(mutableBigInteger3, n6);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.addShifted:(Ljava/math/MutableBigInteger;I)V");
            mutableBigInteger2.addShifted(mutableBigInteger7, n9 * n6);
            --n9;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divide2n1n:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
        mutableBigInteger3 = mutableBigInteger6.divide2n1n(mutableBigInteger4, mutableBigInteger7);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.add:(Ljava/math/MutableBigInteger;)V");
        mutableBigInteger2.add(mutableBigInteger7);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.rightShift:(I)V");
        mutableBigInteger3.rightShift(n7);
        return mutableBigInteger3;
    }

    private MutableBigInteger divide2n1n(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2) {
        int n;
        block3: {
            block2: {
                n = mutableBigInteger.intLen;
                RuntimeCostAccounter.recordJump();
                if (n % 2 != 0) break block2;
                RuntimeCostAccounter.recordJump();
                if (n >= 80) break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divideKnuth:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
            return this.divideKnuth(mutableBigInteger, mutableBigInteger2);
        }
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/MutableBigInteger;)V");
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(this);
        int n2 = 32 * (n / 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.safeRightShift:(I)V");
        mutableBigInteger3.safeRightShift(n2);
        int n3 = n / 2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.keepLower:(I)V");
        this.keepLower(n3);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divide3n2n:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
        MutableBigInteger mutableBigInteger5 = mutableBigInteger3.divide3n2n(mutableBigInteger, mutableBigInteger4);
        int n4 = n / 2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.addDisjoint:(Ljava/math/MutableBigInteger;I)V");
        this.addDisjoint(mutableBigInteger5, n4);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divide3n2n:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
        MutableBigInteger mutableBigInteger6 = this.divide3n2n(mutableBigInteger, mutableBigInteger2);
        int n5 = n / 2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.addDisjoint:(Ljava/math/MutableBigInteger;I)V");
        mutableBigInteger2.addDisjoint(mutableBigInteger4, n5);
        return mutableBigInteger6;
    }

    private MutableBigInteger divide3n2n(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2) {
        MutableBigInteger mutableBigInteger3;
        MutableBigInteger mutableBigInteger4;
        int n = mutableBigInteger.intLen / 2;
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/MutableBigInteger;)V");
        MutableBigInteger mutableBigInteger5 = new MutableBigInteger(this);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.safeRightShift:(I)V");
        mutableBigInteger5.safeRightShift(32 * n);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/MutableBigInteger;)V");
        MutableBigInteger mutableBigInteger6 = new MutableBigInteger(mutableBigInteger);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.safeRightShift:(I)V");
        mutableBigInteger6.safeRightShift(n * 32);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.getLower:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger = mutableBigInteger.getLower(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.compareShifted:(Ljava/math/MutableBigInteger;I)I");
        int n2 = this.compareShifted(mutableBigInteger, n);
        RuntimeCostAccounter.recordJump();
        if (n2 < 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divide2n1n:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
            mutableBigInteger4 = mutableBigInteger5.divide2n1n(mutableBigInteger6, mutableBigInteger2);
            RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toBigInteger:()Ljava/math/BigInteger;");
            BigInteger bigInteger2 = mutableBigInteger2.toBigInteger();
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            BigInteger bigInteger3 = bigInteger2.multiply(bigInteger);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/BigInteger;)V");
            mutableBigInteger3 = new MutableBigInteger(bigInteger3);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.ones:(I)V");
            mutableBigInteger2.ones(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.add:(Ljava/math/MutableBigInteger;)V");
            mutableBigInteger5.add(mutableBigInteger6);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.leftShift:(I)V");
            mutableBigInteger6.leftShift(32 * n);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.subtract:(Ljava/math/MutableBigInteger;)I");
            mutableBigInteger5.subtract(mutableBigInteger6);
            mutableBigInteger4 = mutableBigInteger5;
            RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/BigInteger;)V");
            mutableBigInteger3 = new MutableBigInteger(bigInteger);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.leftShift:(I)V");
            mutableBigInteger3.leftShift(32 * n);
            RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/BigInteger;)V");
            MutableBigInteger mutableBigInteger7 = new MutableBigInteger(bigInteger);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.subtract:(Ljava/math/MutableBigInteger;)I");
            mutableBigInteger3.subtract(mutableBigInteger7);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.leftShift:(I)V");
        mutableBigInteger4.leftShift(32 * n);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.addLower:(Ljava/math/MutableBigInteger;I)V");
        mutableBigInteger4.addLower(this, n);
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.compare:(Ljava/math/MutableBigInteger;)I");
            int n3 = mutableBigInteger4.compare(mutableBigInteger3);
            RuntimeCostAccounter.recordJump();
            if (n3 >= 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.add:(Ljava/math/MutableBigInteger;)V");
            mutableBigInteger4.add(mutableBigInteger);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.subtract:(Ljava/math/MutableBigInteger;)I");
            mutableBigInteger2.subtract(ONE);
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.subtract:(Ljava/math/MutableBigInteger;)I");
        mutableBigInteger4.subtract(mutableBigInteger3);
        return mutableBigInteger4;
    }

    private MutableBigInteger getBlock(int n, int n2, int n3) {
        int n4;
        int n5 = n * n3;
        RuntimeCostAccounter.recordJump();
        if (n5 >= this.intLen) {
            RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
            return new MutableBigInteger();
        }
        RuntimeCostAccounter.recordJump();
        if (n == n2 - 1) {
            n4 = this.intLen;
            RuntimeCostAccounter.recordJump();
        } else {
            n4 = (n + 1) * n3;
        }
        RuntimeCostAccounter.recordJump();
        if (n4 > this.intLen) {
            RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
            return new MutableBigInteger();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOfRange:([III)[I");
        int[] nArray = Arrays.copyOfRange(this.value, this.offset + this.intLen - n4, this.offset + this.intLen - n5);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:([I)V");
        return new MutableBigInteger(nArray);
    }

    long bitLength() {
        RuntimeCostAccounter.recordJump();
        if (this.intLen == 0) {
            return 0L;
        }
        long l = (long)this.intLen * 32L;
        int n = this.value[this.offset];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfLeadingZeros:(I)I");
        return l - (long)Integer.numberOfLeadingZeros(n);
    }

    long divide(long l, MutableBigInteger mutableBigInteger) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
            ArithmeticException arithmeticException = new ArithmeticException("BigInteger divide by zero");
            RuntimeCostAccounter.recordThrow();
            throw arithmeticException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.intLen == 0) {
            mutableBigInteger.offset = 0;
            mutableBigInteger.intLen = 0;
            return 0L;
        }
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            l = -l;
        }
        int n = (int)(l >>> 32);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.clear:()V");
        mutableBigInteger.clear();
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            int n2 = (int)l;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divideOneWord:(ILjava/math/MutableBigInteger;)I");
            return (long)this.divideOneWord(n2, mutableBigInteger) & 0xFFFFFFFFL;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divideLongMagnitude:(JLjava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
        MutableBigInteger mutableBigInteger2 = this.divideLongMagnitude(l, mutableBigInteger);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toLong:()J");
        return mutableBigInteger2.toLong();
    }

    private static void copyAndShift(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4) {
        int n5 = 32 - n4;
        int n6 = nArray[n];
        int n7 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n7 >= n2 - 1) break;
            int n8 = n6;
            n6 = nArray[++n];
            nArray2[n3 + n7] = n8 << n4 | n6 >>> n5;
            ++n7;
            RuntimeCostAccounter.recordJump();
        }
        nArray2[n3 + n2 - 1] = n6 << n4;
    }

    private MutableBigInteger divideMagnitude(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2, boolean bl) {
        MutableBigInteger mutableBigInteger3;
        long l;
        long l2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        MutableBigInteger mutableBigInteger4;
        int[] nArray;
        int n9 = mutableBigInteger.value[mutableBigInteger.offset];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfLeadingZeros:(I)I");
        int n10 = Integer.numberOfLeadingZeros(n9);
        int n11 = mutableBigInteger.intLen;
        RuntimeCostAccounter.recordJump();
        if (n10 > 0) {
            int[] nArray2;
            int n12 = n11;
            RuntimeCostAccounter.recordArrayAllocation((int)n12, (int)4);
            nArray = new int[n12];
            int[] nArray3 = mutableBigInteger.value;
            int n13 = mutableBigInteger.offset;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.copyAndShift:([III[III)V");
            MutableBigInteger.copyAndShift(nArray3, n13, n11, nArray, 0, n10);
            int n14 = this.value[this.offset];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfLeadingZeros:(I)I");
            int n15 = Integer.numberOfLeadingZeros(n14);
            RuntimeCostAccounter.recordJump();
            if (n15 >= n10) {
                int n16 = this.intLen + 1;
                RuntimeCostAccounter.recordArrayAllocation((int)n16, (int)4);
                nArray2 = new int[n16];
                RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:([I)V");
                mutableBigInteger4 = new MutableBigInteger(nArray2);
                mutableBigInteger4.intLen = this.intLen;
                mutableBigInteger4.offset = 1;
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.copyAndShift:([III[III)V");
                MutableBigInteger.copyAndShift(this.value, this.offset, this.intLen, nArray2, 1, n10);
                RuntimeCostAccounter.recordJump();
            } else {
                int n17 = this.intLen + 2;
                RuntimeCostAccounter.recordArrayAllocation((int)n17, (int)4);
                nArray2 = new int[n17];
                RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:([I)V");
                mutableBigInteger4 = new MutableBigInteger(nArray2);
                mutableBigInteger4.intLen = this.intLen + 1;
                mutableBigInteger4.offset = 1;
                n8 = this.offset;
                int n18 = 0;
                n7 = 32 - n10;
                int n19 = 1;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n19 >= this.intLen + 1) break;
                    int n20 = n18;
                    n18 = this.value[n8];
                    nArray2[n19] = n20 << n10 | n18 >>> n7;
                    ++n19;
                    ++n8;
                    RuntimeCostAccounter.recordJump();
                }
                nArray2[this.intLen + 1] = n18 << n10;
                RuntimeCostAccounter.recordJump();
            }
        } else {
            int[] nArray4 = mutableBigInteger.value;
            int n21 = mutableBigInteger.offset;
            int n22 = mutableBigInteger.offset + mutableBigInteger.intLen;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOfRange:([III)[I");
            nArray = Arrays.copyOfRange(nArray4, n21, n22);
            RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
            int n23 = this.intLen + 1;
            RuntimeCostAccounter.recordArrayAllocation((int)n23, (int)4);
            int[] nArray5 = new int[n23];
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:([I)V");
            mutableBigInteger4 = new MutableBigInteger(nArray5);
            int[] nArray6 = mutableBigInteger4.value;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.value, this.offset, nArray6, 1, this.intLen);
            mutableBigInteger4.intLen = this.intLen;
            mutableBigInteger4.offset = 1;
        }
        int n24 = mutableBigInteger4.intLen;
        n8 = n24 - n11 + 1;
        int n25 = mutableBigInteger2.value.length;
        RuntimeCostAccounter.recordJump();
        if (n25 < n8) {
            int n26 = n8;
            RuntimeCostAccounter.recordArrayAllocation((int)n26, (int)4);
            mutableBigInteger2.value = new int[n26];
            mutableBigInteger2.offset = 0;
        }
        mutableBigInteger2.intLen = n8;
        int[] nArray7 = mutableBigInteger2.value;
        int n27 = mutableBigInteger4.intLen++;
        RuntimeCostAccounter.recordJump();
        if (n27 == n24) {
            mutableBigInteger4.offset = 0;
            mutableBigInteger4.value[0] = 0;
        }
        n7 = nArray[0];
        long l3 = (long)n7 & 0xFFFFFFFFL;
        int n28 = nArray[1];
        int n29 = 0;
        while (true) {
            long l4;
            long l5;
            RuntimeCostAccounter.recordJump();
            if (n29 >= n8 - 1) break;
            n6 = 0;
            n5 = 0;
            n4 = 0;
            n3 = mutableBigInteger4.value[n29 + mutableBigInteger4.offset];
            n2 = n3 + Integer.MIN_VALUE;
            n = mutableBigInteger4.value[n29 + 1 + mutableBigInteger4.offset];
            RuntimeCostAccounter.recordJump();
            if (n3 == n7) {
                int n30;
                n6 = -1;
                n5 = n3 + n;
                RuntimeCostAccounter.recordJump();
                if (n5 + Integer.MIN_VALUE < n2) {
                    n30 = 1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n30 = 0;
                }
                n4 = n30;
                RuntimeCostAccounter.recordJump();
            } else {
                l5 = (long)n3 << 32 | (long)n & 0xFFFFFFFFL;
                RuntimeCostAccounter.recordJump();
                if (l5 >= 0L) {
                    n6 = (int)(l5 / l3);
                    n5 = (int)(l5 - (long)n6 * l3);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divWord:(JI)J");
                    l4 = MutableBigInteger.divWord(l5, n7);
                    n6 = (int)(l4 & 0xFFFFFFFFL);
                    n5 = (int)(l4 >>> 32);
                }
            }
            RuntimeCostAccounter.recordJump();
            if (n6 == 0) {
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (n4 == 0) {
                    l5 = (long)mutableBigInteger4.value[n29 + 2 + mutableBigInteger4.offset] & 0xFFFFFFFFL;
                    l4 = ((long)n5 & 0xFFFFFFFFL) << 32 | l5;
                    long l6 = ((long)n28 & 0xFFFFFFFFL) * ((long)n6 & 0xFFFFFFFFL);
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.unsignedLongCompare:(JJ)Z");
                    boolean bl2 = this.unsignedLongCompare(l6, l4);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        --n6;
                        n5 = (int)(((long)n5 & 0xFFFFFFFFL) + l3);
                        long l7 = ((long)n5 & 0xFFFFFFFFL) - l3;
                        long l8 = l7 == 0L ? 0 : (l7 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (l8 >= 0) {
                            l4 = ((long)n5 & 0xFFFFFFFFL) << 32 | l5;
                            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.unsignedLongCompare:(JJ)Z");
                            boolean bl3 = this.unsignedLongCompare(l6 -= (long)n28 & 0xFFFFFFFFL, l4);
                            RuntimeCostAccounter.recordJump();
                            if (bl3) {
                                --n6;
                            }
                        }
                    }
                }
                mutableBigInteger4.value[n29 + mutableBigInteger4.offset] = 0;
                int[] nArray8 = mutableBigInteger4.value;
                int n31 = n29 + mutableBigInteger4.offset;
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.mulsub:([I[IIII)I");
                int n32 = this.mulsub(nArray8, nArray, n6, n11, n31);
                RuntimeCostAccounter.recordJump();
                if (n32 + Integer.MIN_VALUE > n2) {
                    int[] nArray9 = mutableBigInteger4.value;
                    int n33 = n29 + 1 + mutableBigInteger4.offset;
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divadd:([I[II)I");
                    this.divadd(nArray, nArray9, n33);
                }
                nArray7[n29] = --n6;
            }
            ++n29;
            RuntimeCostAccounter.recordJump();
        }
        n29 = 0;
        n6 = 0;
        n5 = 0;
        n4 = mutableBigInteger4.value[n8 - 1 + mutableBigInteger4.offset];
        n3 = n4 + Integer.MIN_VALUE;
        n2 = mutableBigInteger4.value[n8 + mutableBigInteger4.offset];
        RuntimeCostAccounter.recordJump();
        if (n4 == n7) {
            int n34;
            n29 = -1;
            n6 = n4 + n2;
            RuntimeCostAccounter.recordJump();
            if (n6 + Integer.MIN_VALUE < n3) {
                n34 = 1;
                RuntimeCostAccounter.recordJump();
            } else {
                n34 = 0;
            }
            n5 = n34;
            RuntimeCostAccounter.recordJump();
        } else {
            l2 = (long)n4 << 32 | (long)n2 & 0xFFFFFFFFL;
            RuntimeCostAccounter.recordJump();
            if (l2 >= 0L) {
                n29 = (int)(l2 / l3);
                n6 = (int)(l2 - (long)n29 * l3);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divWord:(JI)J");
                l = MutableBigInteger.divWord(l2, n7);
                n29 = (int)(l & 0xFFFFFFFFL);
                n6 = (int)(l >>> 32);
            }
        }
        RuntimeCostAccounter.recordJump();
        if (n29 != 0) {
            RuntimeCostAccounter.recordJump();
            if (n5 == 0) {
                l2 = (long)mutableBigInteger4.value[n8 + 1 + mutableBigInteger4.offset] & 0xFFFFFFFFL;
                l = ((long)n6 & 0xFFFFFFFFL) << 32 | l2;
                long l9 = ((long)n28 & 0xFFFFFFFFL) * ((long)n29 & 0xFFFFFFFFL);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.unsignedLongCompare:(JJ)Z");
                boolean bl4 = this.unsignedLongCompare(l9, l);
                RuntimeCostAccounter.recordJump();
                if (bl4) {
                    --n29;
                    n6 = (int)(((long)n6 & 0xFFFFFFFFL) + l3);
                    long l10 = ((long)n6 & 0xFFFFFFFFL) - l3;
                    long l11 = l10 == 0L ? 0 : (l10 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l11 >= 0) {
                        l = ((long)n6 & 0xFFFFFFFFL) << 32 | l2;
                        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.unsignedLongCompare:(JJ)Z");
                        boolean bl5 = this.unsignedLongCompare(l9 -= (long)n28 & 0xFFFFFFFFL, l);
                        RuntimeCostAccounter.recordJump();
                        if (bl5) {
                            --n29;
                        }
                    }
                }
            }
            mutableBigInteger4.value[n8 - 1 + mutableBigInteger4.offset] = 0;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                int[] nArray10 = mutableBigInteger4.value;
                int n35 = n8 - 1 + mutableBigInteger4.offset;
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.mulsub:([I[IIII)I");
                n = this.mulsub(nArray10, nArray, n29, n11, n35);
                RuntimeCostAccounter.recordJump();
            } else {
                int[] nArray11 = mutableBigInteger4.value;
                int n36 = n8 - 1 + mutableBigInteger4.offset;
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.mulsubBorrow:([I[IIII)I");
                n = this.mulsubBorrow(nArray11, nArray, n29, n11, n36);
            }
            RuntimeCostAccounter.recordJump();
            if (n + Integer.MIN_VALUE > n3) {
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    int[] nArray12 = mutableBigInteger4.value;
                    int n37 = n8 - 1 + 1 + mutableBigInteger4.offset;
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divadd:([I[II)I");
                    this.divadd(nArray, nArray12, n37);
                }
            }
            nArray7[n8 - 1] = --n29;
        }
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (n10 > 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.rightShift:(I)V");
                mutableBigInteger4.rightShift(n10);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.normalize:()V");
            mutableBigInteger4.normalize();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.normalize:()V");
        mutableBigInteger2.normalize();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            mutableBigInteger3 = mutableBigInteger4;
            RuntimeCostAccounter.recordJump();
        } else {
            mutableBigInteger3 = null;
        }
        return mutableBigInteger3;
    }

    private MutableBigInteger divideLongMagnitude(long l, MutableBigInteger mutableBigInteger) {
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        int n = this.intLen + 1;
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)4);
        int[] nArray = new int[n];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:([I)V");
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(nArray);
        int[] nArray2 = mutableBigInteger2.value;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(this.value, this.offset, nArray2, 1, this.intLen);
        mutableBigInteger2.intLen = this.intLen;
        mutableBigInteger2.offset = 1;
        int n2 = mutableBigInteger2.intLen;
        int n3 = n2 - 2 + 1;
        int n4 = mutableBigInteger.value.length;
        RuntimeCostAccounter.recordJump();
        if (n4 < n3) {
            int n5 = n3;
            RuntimeCostAccounter.recordArrayAllocation((int)n5, (int)4);
            mutableBigInteger.value = new int[n5];
            mutableBigInteger.offset = 0;
        }
        mutableBigInteger.intLen = n3;
        int[] nArray3 = mutableBigInteger.value;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.numberOfLeadingZeros:(J)I");
        int n6 = Long.numberOfLeadingZeros(l);
        RuntimeCostAccounter.recordJump();
        if (n6 > 0) {
            l <<= n6;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.leftShift:(I)V");
            mutableBigInteger2.leftShift(n6);
        }
        int n7 = mutableBigInteger2.intLen++;
        RuntimeCostAccounter.recordJump();
        if (n7 == n2) {
            mutableBigInteger2.offset = 0;
            mutableBigInteger2.value[0] = 0;
        }
        int n8 = (int)(l >>> 32);
        long l2 = (long)n8 & 0xFFFFFFFFL;
        int n9 = (int)(l & 0xFFFFFFFFL);
        int n10 = 0;
        while (true) {
            long l3;
            long l4;
            RuntimeCostAccounter.recordJump();
            if (n10 >= n3) break;
            int n11 = 0;
            int n12 = 0;
            boolean bl = false;
            int n13 = mutableBigInteger2.value[n10 + mutableBigInteger2.offset];
            int n14 = n13 + Integer.MIN_VALUE;
            int n15 = mutableBigInteger2.value[n10 + 1 + mutableBigInteger2.offset];
            RuntimeCostAccounter.recordJump();
            if (n13 == n8) {
                boolean bl2;
                n11 = -1;
                n12 = n13 + n15;
                RuntimeCostAccounter.recordJump();
                if (n12 + Integer.MIN_VALUE < n14) {
                    bl2 = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl2 = false;
                }
                bl = bl2;
                RuntimeCostAccounter.recordJump();
            } else {
                l4 = (long)n13 << 32 | (long)n15 & 0xFFFFFFFFL;
                RuntimeCostAccounter.recordJump();
                if (l4 >= 0L) {
                    n11 = (int)(l4 / l2);
                    n12 = (int)(l4 - (long)n11 * l2);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divWord:(JI)J");
                    l3 = MutableBigInteger.divWord(l4, n8);
                    n11 = (int)(l3 & 0xFFFFFFFFL);
                    n12 = (int)(l3 >>> 32);
                }
            }
            RuntimeCostAccounter.recordJump();
            if (n11 == 0) {
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    l4 = (long)mutableBigInteger2.value[n10 + 2 + mutableBigInteger2.offset] & 0xFFFFFFFFL;
                    l3 = ((long)n12 & 0xFFFFFFFFL) << 32 | l4;
                    long l5 = ((long)n9 & 0xFFFFFFFFL) * ((long)n11 & 0xFFFFFFFFL);
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.unsignedLongCompare:(JJ)Z");
                    boolean bl3 = this.unsignedLongCompare(l5, l3);
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        --n11;
                        n12 = (int)(((long)n12 & 0xFFFFFFFFL) + l2);
                        long l6 = ((long)n12 & 0xFFFFFFFFL) - l2;
                        long l7 = l6 == 0L ? 0 : (l6 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (l7 >= 0) {
                            l3 = ((long)n12 & 0xFFFFFFFFL) << 32 | l4;
                            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.unsignedLongCompare:(JJ)Z");
                            boolean bl4 = this.unsignedLongCompare(l5 -= (long)n9 & 0xFFFFFFFFL, l3);
                            RuntimeCostAccounter.recordJump();
                            if (bl4) {
                                --n11;
                            }
                        }
                    }
                }
                mutableBigInteger2.value[n10 + mutableBigInteger2.offset] = 0;
                int[] nArray4 = mutableBigInteger2.value;
                int n16 = n10 + mutableBigInteger2.offset;
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.mulsubLong:([IIIII)I");
                int n17 = this.mulsubLong(nArray4, n8, n9, n11, n16);
                RuntimeCostAccounter.recordJump();
                if (n17 + Integer.MIN_VALUE > n14) {
                    int[] nArray5 = mutableBigInteger2.value;
                    int n18 = n10 + 1 + mutableBigInteger2.offset;
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divaddLong:(II[II)I");
                    this.divaddLong(n8, n9, nArray5, n18);
                }
                nArray3[n10] = --n11;
            }
            ++n10;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (n6 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.rightShift:(I)V");
            mutableBigInteger2.rightShift(n6);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.normalize:()V");
        mutableBigInteger.normalize();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.normalize:()V");
        mutableBigInteger2.normalize();
        return mutableBigInteger2;
    }

    private int divaddLong(int n, int n2, int[] nArray, int n3) {
        long l = 0L;
        long l2 = ((long)n2 & 0xFFFFFFFFL) + ((long)nArray[1 + n3] & 0xFFFFFFFFL);
        nArray[1 + n3] = (int)l2;
        l2 = ((long)n & 0xFFFFFFFFL) + ((long)nArray[n3] & 0xFFFFFFFFL) + l;
        nArray[n3] = (int)l2;
        l = l2 >>> 32;
        return (int)l;
    }

    private int mulsubLong(int[] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        long l = (long)n3 & 0xFFFFFFFFL;
        long l2 = ((long)n2 & 0xFFFFFFFFL) * l;
        long l3 = (long)nArray[n4 += 2] - l2;
        nArray[n4--] = (int)l3;
        long l4 = (l3 & 0xFFFFFFFFL) - ((long)(~((int)l2)) & 0xFFFFFFFFL);
        long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l5 > 0) {
            n6 = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n6 = 0;
        }
        long l6 = (l2 >>> 32) + (long)n6;
        l2 = ((long)n & 0xFFFFFFFFL) * l + l6;
        l3 = (long)nArray[n4] - l2;
        nArray[n4--] = (int)l3;
        long l7 = (l3 & 0xFFFFFFFFL) - ((long)(~((int)l2)) & 0xFFFFFFFFL);
        long l8 = l7 == 0L ? 0 : (l7 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l8 > 0) {
            n5 = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n5 = 0;
        }
        l6 = (l2 >>> 32) + (long)n5;
        return (int)l6;
    }

    private boolean unsignedLongCompare(long l, long l2) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (l + Long.MIN_VALUE > l2 + Long.MIN_VALUE) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    static long divWord(long l, int n) {
        long l2 = (long)n & 0xFFFFFFFFL;
        RuntimeCostAccounter.recordJump();
        if (l2 == 1L) {
            long l3 = (int)l;
            long l4 = 0L;
            return l4 << 32 | l3 & 0xFFFFFFFFL;
        }
        long l5 = (l >>> 1) / (l2 >>> 1);
        long l6 = l - l5 * l2;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (l6 >= 0L) break;
            l6 += l2;
            --l5;
            RuntimeCostAccounter.recordJump();
        }
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (l6 < l2) break;
            l6 -= l2;
            ++l5;
            RuntimeCostAccounter.recordJump();
        }
        return l6 << 32 | l5 & 0xFFFFFFFFL;
    }

    MutableBigInteger hybridGCD(MutableBigInteger mutableBigInteger) {
        MutableBigInteger mutableBigInteger2 = this;
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger();
        while (true) {
            int n = mutableBigInteger.intLen;
            RuntimeCostAccounter.recordJump();
            if (n == 0) break;
            int n2 = mutableBigInteger2.intLen - mutableBigInteger.intLen;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
            int n3 = Math.abs(n2);
            RuntimeCostAccounter.recordJump();
            if (n3 < 2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.binaryGCD:(Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
                return mutableBigInteger2.binaryGCD(mutableBigInteger);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divide:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
            MutableBigInteger mutableBigInteger4 = mutableBigInteger2.divide(mutableBigInteger, mutableBigInteger3);
            mutableBigInteger2 = mutableBigInteger;
            mutableBigInteger = mutableBigInteger4;
            RuntimeCostAccounter.recordJump();
        }
        return mutableBigInteger2;
    }

    private MutableBigInteger binaryGCD(MutableBigInteger mutableBigInteger) {
        int n;
        MutableBigInteger mutableBigInteger2;
        boolean bl;
        int n2;
        MutableBigInteger mutableBigInteger3 = this;
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.getLowestSetBit:()I");
        int n3 = mutableBigInteger3.getLowestSetBit();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.getLowestSetBit:()I");
        int n4 = mutableBigInteger.getLowestSetBit();
        RuntimeCostAccounter.recordJump();
        if (n3 < n4) {
            n2 = n3;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = n4;
        }
        int n5 = n2;
        RuntimeCostAccounter.recordJump();
        if (n5 != 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.rightShift:(I)V");
            mutableBigInteger3.rightShift(n5);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.rightShift:(I)V");
            mutableBigInteger.rightShift(n5);
        }
        RuntimeCostAccounter.recordJump();
        if (n5 == n3) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        boolean bl2 = bl;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            mutableBigInteger2 = mutableBigInteger;
            RuntimeCostAccounter.recordJump();
        } else {
            mutableBigInteger2 = mutableBigInteger3;
        }
        MutableBigInteger mutableBigInteger5 = mutableBigInteger2;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            n = -1;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 1;
        }
        int n6 = n;
        while (true) {
            MutableBigInteger mutableBigInteger6;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.getLowestSetBit:()I");
            int n7 = mutableBigInteger5.getLowestSetBit();
            RuntimeCostAccounter.recordJump();
            if (n7 < 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.rightShift:(I)V");
            mutableBigInteger5.rightShift(n7);
            RuntimeCostAccounter.recordJump();
            if (n6 > 0) {
                mutableBigInteger3 = mutableBigInteger5;
                RuntimeCostAccounter.recordJump();
            } else {
                mutableBigInteger = mutableBigInteger5;
            }
            int n8 = mutableBigInteger3.intLen;
            RuntimeCostAccounter.recordJump();
            if (n8 < 2) {
                int n9 = mutableBigInteger.intLen;
                RuntimeCostAccounter.recordJump();
                if (n9 < 2) {
                    int n10 = mutableBigInteger3.value[mutableBigInteger3.offset];
                    int n11 = mutableBigInteger.value[mutableBigInteger.offset];
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.binaryGcd:(II)I");
                    mutableBigInteger4.value[0] = n10 = MutableBigInteger.binaryGcd(n10, n11);
                    mutableBigInteger4.intLen = 1;
                    mutableBigInteger4.offset = 0;
                    RuntimeCostAccounter.recordJump();
                    if (n5 > 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.leftShift:(I)V");
                        mutableBigInteger4.leftShift(n5);
                    }
                    return mutableBigInteger4;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.difference:(Ljava/math/MutableBigInteger;)I");
            n6 = mutableBigInteger3.difference(mutableBigInteger);
            RuntimeCostAccounter.recordJump();
            if (n6 == 0) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            RuntimeCostAccounter.recordJump();
            if (n6 >= 0) {
                mutableBigInteger6 = mutableBigInteger3;
                RuntimeCostAccounter.recordJump();
            } else {
                mutableBigInteger6 = mutableBigInteger;
            }
            mutableBigInteger5 = mutableBigInteger6;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (n5 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.leftShift:(I)V");
            mutableBigInteger3.leftShift(n5);
        }
        return mutableBigInteger3;
    }

    static int binaryGcd(int n, int n2) {
        int n3;
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return n;
        }
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            return n2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfTrailingZeros:(I)I");
        int n4 = Integer.numberOfTrailingZeros(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfTrailingZeros:(I)I");
        int n5 = Integer.numberOfTrailingZeros(n2);
        n >>>= n4;
        n2 >>>= n5;
        RuntimeCostAccounter.recordJump();
        if (n4 < n5) {
            n3 = n4;
            RuntimeCostAccounter.recordJump();
        } else {
            n3 = n5;
        }
        int n6 = n3;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n == n2) break;
            RuntimeCostAccounter.recordJump();
            if (n + Integer.MIN_VALUE > n2 + Integer.MIN_VALUE) {
                n -= n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfTrailingZeros:(I)I");
                n >>>= Integer.numberOfTrailingZeros(n);
                RuntimeCostAccounter.recordJump();
                continue;
            }
            n2 -= n;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfTrailingZeros:(I)I");
            n2 >>>= Integer.numberOfTrailingZeros(n2);
            RuntimeCostAccounter.recordJump();
        }
        return n << n6;
    }

    MutableBigInteger mutableModInverse(MutableBigInteger mutableBigInteger) {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.isOdd:()Z");
        boolean bl = mutableBigInteger.isOdd();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.modInverse:(Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
            return this.modInverse(mutableBigInteger);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.isEven:()Z");
        boolean bl2 = this.isEven();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
            ArithmeticException arithmeticException = new ArithmeticException("BigInteger not invertible.");
            RuntimeCostAccounter.recordThrow();
            throw arithmeticException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.getLowestSetBit:()I");
        int n = mutableBigInteger.getLowestSetBit();
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/MutableBigInteger;)V");
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(mutableBigInteger);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.rightShift:(I)V");
        mutableBigInteger2.rightShift(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.isOne:()Z");
        boolean bl3 = mutableBigInteger2.isOne();
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.modInverseMP2:(I)Ljava/math/MutableBigInteger;");
            return this.modInverseMP2(n);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.modInverse:(Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
        MutableBigInteger mutableBigInteger3 = this.modInverse(mutableBigInteger2);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.modInverseMP2:(I)Ljava/math/MutableBigInteger;");
        MutableBigInteger mutableBigInteger4 = this.modInverseMP2(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.modInverseBP2:(Ljava/math/MutableBigInteger;I)Ljava/math/MutableBigInteger;");
        MutableBigInteger mutableBigInteger5 = MutableBigInteger.modInverseBP2(mutableBigInteger2, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.modInverseMP2:(I)Ljava/math/MutableBigInteger;");
        MutableBigInteger mutableBigInteger6 = mutableBigInteger2.modInverseMP2(n);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
        MutableBigInteger mutableBigInteger7 = new MutableBigInteger();
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
        MutableBigInteger mutableBigInteger8 = new MutableBigInteger();
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
        MutableBigInteger mutableBigInteger9 = new MutableBigInteger();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.leftShift:(I)V");
        mutableBigInteger3.leftShift(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.multiply:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)V");
        mutableBigInteger3.multiply(mutableBigInteger5, mutableBigInteger9);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.multiply:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)V");
        mutableBigInteger4.multiply(mutableBigInteger2, mutableBigInteger7);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.multiply:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)V");
        mutableBigInteger7.multiply(mutableBigInteger6, mutableBigInteger8);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.add:(Ljava/math/MutableBigInteger;)V");
        mutableBigInteger9.add(mutableBigInteger8);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divide:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
        return mutableBigInteger9.divide(mutableBigInteger, mutableBigInteger7);
    }

    MutableBigInteger modInverseMP2(int n) {
        long l;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.isEven:()Z");
        boolean bl = this.isEven();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
            ArithmeticException arithmeticException = new ArithmeticException("Non-invertible. (GCD != 1)");
            RuntimeCostAccounter.recordThrow();
            throw arithmeticException;
        }
        RuntimeCostAccounter.recordJump();
        if (n > 64) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.euclidModInverse:(I)Ljava/math/MutableBigInteger;");
            return this.euclidModInverse(n);
        }
        int n2 = this.value[this.offset + this.intLen - 1];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.inverseMod32:(I)I");
        int n3 = MutableBigInteger.inverseMod32(n2);
        RuntimeCostAccounter.recordJump();
        if (n < 33) {
            int n4;
            RuntimeCostAccounter.recordJump();
            if (n == 32) {
                n4 = n3;
                RuntimeCostAccounter.recordJump();
            } else {
                n4 = n3 & (1 << n) - 1;
            }
            n3 = n4;
            RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(I)V");
            return new MutableBigInteger(n3);
        }
        long l2 = (long)this.value[this.offset + this.intLen - 1] & 0xFFFFFFFFL;
        RuntimeCostAccounter.recordJump();
        if (this.intLen > 1) {
            l2 |= (long)this.value[this.offset + this.intLen - 2] << 32;
        }
        long l3 = (long)n3 & 0xFFFFFFFFL;
        l3 *= 2L - l2 * l3;
        RuntimeCostAccounter.recordJump();
        if (n == 64) {
            l = l3;
            RuntimeCostAccounter.recordJump();
        } else {
            l = l3 & (1L << n) - 1L;
        }
        l3 = l;
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordArrayAllocation((int)2, (int)4);
        int[] nArray = new int[2];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:([I)V");
        MutableBigInteger mutableBigInteger = new MutableBigInteger(nArray);
        mutableBigInteger.value[0] = (int)(l3 >>> 32);
        mutableBigInteger.value[1] = (int)l3;
        mutableBigInteger.intLen = 2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.normalize:()V");
        mutableBigInteger.normalize();
        return mutableBigInteger;
    }

    static int inverseMod32(int n) {
        int n2 = n;
        n2 *= 2 - n * n2;
        n2 *= 2 - n * n2;
        n2 *= 2 - n * n2;
        n2 *= 2 - n * n2;
        return n2;
    }

    static MutableBigInteger modInverseBP2(MutableBigInteger mutableBigInteger, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(I)V");
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(1);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/MutableBigInteger;)V");
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(mutableBigInteger);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.fixup:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;I)Ljava/math/MutableBigInteger;");
        return MutableBigInteger.fixup(mutableBigInteger2, mutableBigInteger3, n);
    }

    private MutableBigInteger modInverse(MutableBigInteger mutableBigInteger) {
        int n;
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/MutableBigInteger;)V");
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(mutableBigInteger);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/MutableBigInteger;)V");
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(this);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/MutableBigInteger;)V");
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger(mutableBigInteger2);
        RuntimeCostAccounter.recordAllocation((String)"java/math/SignedMutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/SignedMutableBigInteger.<init>:(I)V");
        SignedMutableBigInteger signedMutableBigInteger = new SignedMutableBigInteger(1);
        RuntimeCostAccounter.recordAllocation((String)"java/math/SignedMutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/SignedMutableBigInteger.<init>:()V");
        SignedMutableBigInteger signedMutableBigInteger2 = new SignedMutableBigInteger();
        MutableBigInteger mutableBigInteger5 = null;
        SignedMutableBigInteger signedMutableBigInteger3 = null;
        int n2 = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.isEven:()Z");
        boolean bl = mutableBigInteger3.isEven();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.getLowestSetBit:()I");
            n = mutableBigInteger3.getLowestSetBit();
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.rightShift:(I)V");
            mutableBigInteger3.rightShift(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/SignedMutableBigInteger.leftShift:(I)V");
            signedMutableBigInteger2.leftShift(n);
            n2 = n;
        }
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.isOne:()Z");
            boolean bl2 = mutableBigInteger3.isOne();
            RuntimeCostAccounter.recordJump();
            if (bl2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.isZero:()Z");
            boolean bl3 = mutableBigInteger3.isZero();
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
                ArithmeticException arithmeticException = new ArithmeticException("BigInteger not invertible.");
                RuntimeCostAccounter.recordThrow();
                throw arithmeticException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.compare:(Ljava/math/MutableBigInteger;)I");
            int n3 = mutableBigInteger3.compare(mutableBigInteger4);
            RuntimeCostAccounter.recordJump();
            if (n3 < 0) {
                mutableBigInteger5 = mutableBigInteger3;
                mutableBigInteger3 = mutableBigInteger4;
                mutableBigInteger4 = mutableBigInteger5;
                signedMutableBigInteger3 = signedMutableBigInteger2;
                signedMutableBigInteger2 = signedMutableBigInteger;
                signedMutableBigInteger = signedMutableBigInteger3;
            }
            int n4 = (mutableBigInteger3.value[mutableBigInteger3.offset + mutableBigInteger3.intLen - 1] ^ mutableBigInteger4.value[mutableBigInteger4.offset + mutableBigInteger4.intLen - 1]) & 3;
            RuntimeCostAccounter.recordJump();
            if (n4 == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.subtract:(Ljava/math/MutableBigInteger;)I");
                mutableBigInteger3.subtract(mutableBigInteger4);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/SignedMutableBigInteger.signedSubtract:(Ljava/math/SignedMutableBigInteger;)V");
                signedMutableBigInteger.signedSubtract(signedMutableBigInteger2);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.add:(Ljava/math/MutableBigInteger;)V");
                mutableBigInteger3.add(mutableBigInteger4);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/SignedMutableBigInteger.signedAdd:(Ljava/math/SignedMutableBigInteger;)V");
                signedMutableBigInteger.signedAdd(signedMutableBigInteger2);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.getLowestSetBit:()I");
            n = mutableBigInteger3.getLowestSetBit();
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.rightShift:(I)V");
            mutableBigInteger3.rightShift(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/SignedMutableBigInteger.leftShift:(I)V");
            signedMutableBigInteger2.leftShift(n);
            n2 += n;
            RuntimeCostAccounter.recordJump();
        }
        while (true) {
            int n5 = signedMutableBigInteger.sign;
            RuntimeCostAccounter.recordJump();
            if (n5 >= 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/SignedMutableBigInteger.signedAdd:(Ljava/math/MutableBigInteger;)V");
            signedMutableBigInteger.signedAdd(mutableBigInteger2);
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.fixup:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;I)Ljava/math/MutableBigInteger;");
        return MutableBigInteger.fixup(signedMutableBigInteger, mutableBigInteger2, n2);
    }

    static MutableBigInteger fixup(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2, int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger();
        int n2 = mutableBigInteger2.value[mutableBigInteger2.offset + mutableBigInteger2.intLen - 1];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.inverseMod32:(I)I");
        int n3 = -MutableBigInteger.inverseMod32(n2);
        int n4 = 0;
        int n5 = n >> 5;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 >= n5) break;
            int n6 = n3 * mutableBigInteger.value[mutableBigInteger.offset + mutableBigInteger.intLen - 1];
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.mul:(ILjava/math/MutableBigInteger;)V");
            mutableBigInteger2.mul(n6, mutableBigInteger3);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.add:(Ljava/math/MutableBigInteger;)V");
            mutableBigInteger.add(mutableBigInteger3);
            --mutableBigInteger.intLen;
            ++n4;
            RuntimeCostAccounter.recordJump();
        }
        n4 = n & 0x1F;
        RuntimeCostAccounter.recordJump();
        if (n4 != 0) {
            n5 = n3 * mutableBigInteger.value[mutableBigInteger.offset + mutableBigInteger.intLen - 1];
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.mul:(ILjava/math/MutableBigInteger;)V");
            mutableBigInteger2.mul(n5 &= (1 << n4) - 1, mutableBigInteger3);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.add:(Ljava/math/MutableBigInteger;)V");
            mutableBigInteger.add(mutableBigInteger3);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.rightShift:(I)V");
            mutableBigInteger.rightShift(n4);
        }
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.compare:(Ljava/math/MutableBigInteger;)I");
            int n7 = mutableBigInteger.compare(mutableBigInteger2);
            RuntimeCostAccounter.recordJump();
            if (n7 < 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.subtract:(Ljava/math/MutableBigInteger;)I");
            mutableBigInteger.subtract(mutableBigInteger2);
            RuntimeCostAccounter.recordJump();
        }
        return mutableBigInteger;
    }

    MutableBigInteger euclidModInverse(int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(I)V");
        MutableBigInteger mutableBigInteger = new MutableBigInteger(1);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.leftShift:(I)V");
        mutableBigInteger.leftShift(n);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/MutableBigInteger;)V");
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(mutableBigInteger);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/MutableBigInteger;)V");
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(this);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divide:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
        MutableBigInteger mutableBigInteger5 = mutableBigInteger.divide(mutableBigInteger3, mutableBigInteger4);
        MutableBigInteger mutableBigInteger6 = mutableBigInteger;
        mutableBigInteger = mutableBigInteger5;
        mutableBigInteger5 = mutableBigInteger6;
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/MutableBigInteger;)V");
        MutableBigInteger mutableBigInteger7 = new MutableBigInteger(mutableBigInteger4);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(I)V");
        MutableBigInteger mutableBigInteger8 = new MutableBigInteger(1);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
        MutableBigInteger mutableBigInteger9 = new MutableBigInteger();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.isOne:()Z");
            boolean bl = mutableBigInteger.isOne();
            RuntimeCostAccounter.recordJump();
            if (bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divide:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
            mutableBigInteger5 = mutableBigInteger3.divide(mutableBigInteger, mutableBigInteger4);
            int n2 = mutableBigInteger5.intLen;
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
                ArithmeticException arithmeticException = new ArithmeticException("BigInteger not invertible.");
                RuntimeCostAccounter.recordThrow();
                throw arithmeticException;
            }
            mutableBigInteger3 = mutableBigInteger6 = mutableBigInteger5;
            int n3 = mutableBigInteger4.intLen;
            RuntimeCostAccounter.recordJump();
            if (n3 == 1) {
                int n4 = mutableBigInteger4.value[mutableBigInteger4.offset];
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.mul:(ILjava/math/MutableBigInteger;)V");
                mutableBigInteger7.mul(n4, mutableBigInteger9);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.multiply:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)V");
                mutableBigInteger4.multiply(mutableBigInteger7, mutableBigInteger9);
            }
            mutableBigInteger6 = mutableBigInteger4;
            mutableBigInteger4 = mutableBigInteger9;
            mutableBigInteger9 = mutableBigInteger6;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.add:(Ljava/math/MutableBigInteger;)V");
            mutableBigInteger8.add(mutableBigInteger4);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.isOne:()Z");
            boolean bl2 = mutableBigInteger3.isOne();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                return mutableBigInteger8;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divide:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
            mutableBigInteger5 = mutableBigInteger.divide(mutableBigInteger3, mutableBigInteger4);
            int n5 = mutableBigInteger5.intLen;
            RuntimeCostAccounter.recordJump();
            if (n5 == 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
                ArithmeticException arithmeticException = new ArithmeticException("BigInteger not invertible.");
                RuntimeCostAccounter.recordThrow();
                throw arithmeticException;
            }
            mutableBigInteger6 = mutableBigInteger;
            mutableBigInteger = mutableBigInteger5;
            int n6 = mutableBigInteger4.intLen;
            RuntimeCostAccounter.recordJump();
            if (n6 == 1) {
                int n7 = mutableBigInteger4.value[mutableBigInteger4.offset];
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.mul:(ILjava/math/MutableBigInteger;)V");
                mutableBigInteger8.mul(n7, mutableBigInteger9);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.multiply:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)V");
                mutableBigInteger4.multiply(mutableBigInteger8, mutableBigInteger9);
            }
            mutableBigInteger6 = mutableBigInteger4;
            mutableBigInteger4 = mutableBigInteger9;
            mutableBigInteger9 = mutableBigInteger6;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.add:(Ljava/math/MutableBigInteger;)V");
            mutableBigInteger7.add(mutableBigInteger4);
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.subtract:(Ljava/math/MutableBigInteger;)I");
        mutableBigInteger2.subtract(mutableBigInteger7);
        return mutableBigInteger2;
    }

    static {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
        boolean bl2 = MutableBigInteger.class.desiredAssertionStatus();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        $assertionsDisabled = bl;
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(I)V");
        ONE = new MutableBigInteger(1);
    }
}

