/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.strands.queues.CircularBuffer;

abstract class CircularDWordBuffer<E>
extends CircularBuffer<E> {
    private final long[] array;
    private static final int base;
    private static final int shift;

    public CircularDWordBuffer(int size, boolean singleProducer) {
        super(size, singleProducer);
        this.array = new long[this.capacity];
    }

    void enqRaw(long elem) {
        long index = this.preEnq();
        this.orderedSet((int)index & this.mask, elem);
        this.postEnq();
    }

    private static long byteOffset(int i) {
        return ((long)i << shift) + (long)base;
    }

    private void orderedSet(int i, long value) {
        UNSAFE.putOrderedLong(this.array, CircularDWordBuffer.byteOffset(i), value);
    }

    static {
        try {
            base = UNSAFE.arrayBaseOffset(long[].class);
            int scale = UNSAFE.arrayIndexScale(long[].class);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            shift = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    abstract class DWordConsumer
    extends CircularBuffer.Consumer {
        private long value;

        DWordConsumer() {
        }

        @Override
        protected void grabValue(int index) {
            this.value = CircularDWordBuffer.this.array[index];
        }

        @Override
        protected void clearValue() {
        }

        long getRawValue() {
            return this.value;
        }
    }
}

