/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.stream;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Objects;
import sandbox.java.util.Spliterator;
import sandbox.java.util.function.IntFunction;
import sandbox.java.util.function.Supplier;
import sandbox.java.util.stream.BaseStream;
import sandbox.java.util.stream.Node;
import sandbox.java.util.stream.PipelineHelper;
import sandbox.java.util.stream.Sink;
import sandbox.java.util.stream.StreamOpFlag;
import sandbox.java.util.stream.StreamShape;
import sandbox.java.util.stream.Streams;
import sandbox.java.util.stream.TerminalOp;

abstract class AbstractPipeline<E_IN, E_OUT, S extends BaseStream<E_OUT, S>>
extends PipelineHelper<E_OUT>
implements BaseStream<E_OUT, S> {
    private static final String MSG_STREAM_LINKED = "stream has already been operated upon or closed";
    private static final String MSG_CONSUMED = "source already consumed or closed";
    private final AbstractPipeline sourceStage;
    private final AbstractPipeline previousStage;
    protected final int sourceOrOpFlags;
    private AbstractPipeline nextStage;
    private int depth;
    private int combinedFlags;
    private Spliterator<?> sourceSpliterator;
    private Supplier<? extends Spliterator<?>> sourceSupplier;
    private boolean linkedOrConsumed;
    private boolean sourceAnyStateful;
    private Runnable sourceCloseAction;
    private boolean parallel;
    static final /* synthetic */ boolean $assertionsDisabled;

    AbstractPipeline(Supplier<? extends Spliterator<?>> supplier, int n, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.<init>:()V");
        this.previousStage = null;
        this.sourceSupplier = supplier;
        this.sourceStage = this;
        this.sourceOrOpFlags = n & StreamOpFlag.STREAM_MASK;
        this.combinedFlags = ~(this.sourceOrOpFlags << 1) & StreamOpFlag.INITIAL_OPS_VALUE;
        this.depth = 0;
        this.parallel = bl;
    }

    AbstractPipeline(Spliterator<?> spliterator, int n, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.<init>:()V");
        this.previousStage = null;
        this.sourceSpliterator = spliterator;
        this.sourceStage = this;
        this.sourceOrOpFlags = n & StreamOpFlag.STREAM_MASK;
        this.combinedFlags = ~(this.sourceOrOpFlags << 1) & StreamOpFlag.INITIAL_OPS_VALUE;
        this.depth = 0;
        this.parallel = bl;
    }

    AbstractPipeline(AbstractPipeline<?, E_IN, ?> abstractPipeline, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.<init>:()V");
        boolean bl = abstractPipeline.linkedOrConsumed;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException(MSG_STREAM_LINKED);
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        abstractPipeline.linkedOrConsumed = true;
        abstractPipeline.nextStage = this;
        this.previousStage = abstractPipeline;
        this.sourceOrOpFlags = n & StreamOpFlag.OP_MASK;
        int n2 = abstractPipeline.combinedFlags;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.combineOpFlags:(II)I");
        this.combinedFlags = StreamOpFlag.combineOpFlags(n, n2);
        this.sourceStage = abstractPipeline.sourceStage;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.opIsStateful:()Z");
        boolean bl2 = this.opIsStateful();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            this.sourceStage.sourceAnyStateful = true;
        }
        this.depth = abstractPipeline.depth + 1;
    }

    final <R> R evaluate(TerminalOp<E_OUT, R> terminalOp) {
        R r;
        RuntimeCostAccounter.recordJump();
        if (!$assertionsDisabled) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.getOutputShape:()Ljava/util/stream/StreamShape;");
            StreamShape streamShape = this.getOutputShape();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/TerminalOp.inputShape:()Ljava/util/stream/StreamShape;");
            StreamShape streamShape2 = terminalOp.inputShape();
            RuntimeCostAccounter.recordJump();
            if (streamShape != streamShape2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                AssertionError assertionError = new AssertionError();
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (this.linkedOrConsumed) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException(MSG_STREAM_LINKED);
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        this.linkedOrConsumed = true;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.isParallel:()Z");
        boolean bl = this.isParallel();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/TerminalOp.getOpFlags:()I");
            int n = terminalOp.getOpFlags();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.sourceSpliterator:(I)Ljava/util/Spliterator;");
            Spliterator<?> spliterator = this.sourceSpliterator(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/TerminalOp.evaluateParallel:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;)Ljava/lang/Object;");
            r = terminalOp.evaluateParallel(this, spliterator);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/TerminalOp.getOpFlags:()I");
            int n = terminalOp.getOpFlags();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.sourceSpliterator:(I)Ljava/util/Spliterator;");
            Spliterator<?> spliterator = this.sourceSpliterator(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/TerminalOp.evaluateSequential:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;)Ljava/lang/Object;");
            r = terminalOp.evaluateSequential(this, spliterator);
        }
        return r;
    }

    final Node<E_OUT> evaluateToArrayNode(IntFunction<E_OUT[]> intFunction) {
        RuntimeCostAccounter.recordJump();
        if (this.linkedOrConsumed) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException(MSG_STREAM_LINKED);
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        this.linkedOrConsumed = true;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.isParallel:()Z");
        boolean bl = this.isParallel();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (this.previousStage != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.opIsStateful:()Z");
                boolean bl2 = this.opIsStateful();
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.sourceSpliterator:(I)Ljava/util/Spliterator;");
                    Spliterator<?> spliterator = this.previousStage.sourceSpliterator(0);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.opEvaluateParallel:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;Ljava/util/function/IntFunction;)Ljava/util/stream/Node;");
                    return this.opEvaluateParallel(this.previousStage, spliterator, intFunction);
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.sourceSpliterator:(I)Ljava/util/Spliterator;");
        Spliterator<?> spliterator = this.sourceSpliterator(0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.evaluate:(Ljava/util/Spliterator;ZLjava/util/function/IntFunction;)Ljava/util/stream/Node;");
        return this.evaluate((Spliterator<P_IN>)spliterator, true, intFunction);
    }

    final Spliterator<E_OUT> sourceStageSpliterator() {
        RuntimeCostAccounter.recordJump();
        if (this != this.sourceStage) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
            IllegalStateException illegalStateException = new IllegalStateException();
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.linkedOrConsumed) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException(MSG_STREAM_LINKED);
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        this.linkedOrConsumed = true;
        Spliterator<?> spliterator = this.sourceStage.sourceSpliterator;
        RuntimeCostAccounter.recordJump();
        if (spliterator != null) {
            Spliterator<?> spliterator2 = this.sourceStage.sourceSpliterator;
            this.sourceStage.sourceSpliterator = null;
            return spliterator2;
        }
        Supplier<? extends Spliterator<?>> supplier = this.sourceStage.sourceSupplier;
        RuntimeCostAccounter.recordJump();
        if (supplier != null) {
            Supplier<Spliterator<?>> supplier2 = this.sourceStage.sourceSupplier;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
            Spliterator<?> spliterator3 = supplier2.get();
            this.sourceStage.sourceSupplier = null;
            return spliterator3;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
        IllegalStateException illegalStateException = new IllegalStateException(MSG_CONSUMED);
        RuntimeCostAccounter.recordThrow();
        throw illegalStateException;
    }

    @Override
    public final S sequential() {
        this.sourceStage.parallel = false;
        return (S)this;
    }

    @Override
    public final S parallel() {
        this.sourceStage.parallel = true;
        return (S)this;
    }

    @Override
    public void close() {
        this.linkedOrConsumed = true;
        this.sourceSupplier = null;
        this.sourceSpliterator = null;
        Runnable runnable = this.sourceStage.sourceCloseAction;
        RuntimeCostAccounter.recordJump();
        if (runnable != null) {
            Runnable runnable2 = this.sourceStage.sourceCloseAction;
            this.sourceStage.sourceCloseAction = null;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runnable.run:()V");
            runnable2.run();
        }
    }

    @Override
    public S onClose(Runnable runnable) {
        Runnable runnable2;
        Runnable runnable3 = this.sourceStage.sourceCloseAction;
        RuntimeCostAccounter.recordJump();
        if (runnable3 == null) {
            runnable2 = runnable;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams.composeWithExceptions:(Ljava/lang/Runnable;Ljava/lang/Runnable;)Ljava/lang/Runnable;");
            runnable2 = Streams.composeWithExceptions(runnable3, runnable);
        }
        this.sourceStage.sourceCloseAction = runnable2;
        return (S)this;
    }

    @Override
    public Spliterator<E_OUT> spliterator() {
        RuntimeCostAccounter.recordJump();
        if (this.linkedOrConsumed) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException(MSG_STREAM_LINKED);
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        this.linkedOrConsumed = true;
        RuntimeCostAccounter.recordJump();
        if (this == this.sourceStage) {
            Spliterator<?> spliterator = this.sourceStage.sourceSpliterator;
            RuntimeCostAccounter.recordJump();
            if (spliterator != null) {
                Spliterator<?> spliterator2 = this.sourceStage.sourceSpliterator;
                this.sourceStage.sourceSpliterator = null;
                return spliterator2;
            }
            Supplier<? extends Spliterator<?>> supplier = this.sourceStage.sourceSupplier;
            RuntimeCostAccounter.recordJump();
            if (supplier != null) {
                Supplier<? extends Spliterator<?>> supplier2 = this.sourceStage.sourceSupplier;
                this.sourceStage.sourceSupplier = null;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.lazySpliterator:(Ljava/util/function/Supplier;)Ljava/util/Spliterator;");
                return this.lazySpliterator(supplier2);
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException(MSG_CONSUMED);
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        Supplier supplier = () -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.sourceSpliterator:(I)Ljava/util/Spliterator;");
            return this.sourceSpliterator(0);
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.isParallel:()Z");
        boolean bl = this.isParallel();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.wrap:(Ljava/util/stream/PipelineHelper;Ljava/util/function/Supplier;Z)Ljava/util/Spliterator;");
        return this.wrap(this, supplier, bl);
    }

    @Override
    public final boolean isParallel() {
        return this.sourceStage.parallel;
    }

    final int getStreamFlags() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.toStreamFlags:(I)I");
        return StreamOpFlag.toStreamFlags(this.combinedFlags);
    }

    private void parallelPrepare(int n) {
        AbstractPipeline abstractPipeline;
        int n2;
        AbstractPipeline abstractPipeline2 = this.sourceStage;
        boolean bl = this.sourceStage.sourceAnyStateful;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            n2 = 1;
            abstractPipeline = this.sourceStage;
            AbstractPipeline abstractPipeline3 = this.sourceStage.nextStage;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (abstractPipeline3 == null) break;
                int n3 = abstractPipeline3.sourceOrOpFlags;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.opIsStateful:()Z");
                boolean bl2 = abstractPipeline3.opIsStateful();
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
                    boolean bl3 = StreamOpFlag.SHORT_CIRCUIT.isKnown(n3);
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        abstractPipeline2 = abstractPipeline3;
                        n3 &= ~StreamOpFlag.IS_SHORT_CIRCUIT;
                    }
                    n2 = 0;
                    n3 = n3 & ~StreamOpFlag.NOT_SIZED | StreamOpFlag.IS_SIZED;
                }
                abstractPipeline3.depth = n2++;
                int n4 = abstractPipeline.combinedFlags;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.combineOpFlags:(II)I");
                abstractPipeline3.combinedFlags = StreamOpFlag.combineOpFlags(n3, n4);
                abstractPipeline = abstractPipeline3;
                abstractPipeline3 = abstractPipeline3.nextStage;
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            n2 = n & StreamOpFlag.UPSTREAM_TERMINAL_OP_MASK;
            abstractPipeline = abstractPipeline2;
            while (true) {
                AbstractPipeline abstractPipeline4 = abstractPipeline.nextStage;
                RuntimeCostAccounter.recordJump();
                if (abstractPipeline4 == null) break;
                int n5 = abstractPipeline.combinedFlags;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.combineOpFlags:(II)I");
                abstractPipeline.combinedFlags = StreamOpFlag.combineOpFlags(n2, n5);
                abstractPipeline = abstractPipeline.nextStage;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.combineOpFlags:(II)I");
            this.combinedFlags = StreamOpFlag.combineOpFlags(n, this.combinedFlags);
        }
    }

    private Spliterator<?> sourceSpliterator(int n) {
        Spliterator<Object> spliterator = null;
        Spliterator<?> spliterator2 = this.sourceStage.sourceSpliterator;
        RuntimeCostAccounter.recordJump();
        if (spliterator2 != null) {
            spliterator = this.sourceStage.sourceSpliterator;
            this.sourceStage.sourceSpliterator = null;
            RuntimeCostAccounter.recordJump();
        } else {
            Supplier<? extends Spliterator<?>> supplier = this.sourceStage.sourceSupplier;
            RuntimeCostAccounter.recordJump();
            if (supplier != null) {
                Supplier<Spliterator<?>> supplier2 = this.sourceStage.sourceSupplier;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
                spliterator = supplier2.get();
                this.sourceStage.sourceSupplier = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException(MSG_CONSUMED);
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.isParallel:()Z");
        boolean bl = this.isParallel();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.parallelPrepare:(I)V");
            this.parallelPrepare(n);
            AbstractPipeline abstractPipeline = this.sourceStage;
            AbstractPipeline abstractPipeline2 = this.sourceStage.nextStage;
            AbstractPipeline abstractPipeline3 = this;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (abstractPipeline == abstractPipeline3) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.opIsStateful:()Z");
                boolean bl2 = abstractPipeline2.opIsStateful();
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.opEvaluateParallelLazy:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;)Ljava/util/Spliterator;");
                    spliterator = abstractPipeline2.opEvaluateParallelLazy(abstractPipeline, spliterator);
                }
                abstractPipeline = abstractPipeline2;
                abstractPipeline2 = abstractPipeline2.nextStage;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if (n != 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.combineOpFlags:(II)I");
                this.combinedFlags = StreamOpFlag.combineOpFlags(n, this.combinedFlags);
            }
        }
        return spliterator;
    }

    @Override
    final StreamShape getSourceShape() {
        AbstractPipeline abstractPipeline = this;
        while (true) {
            int n = abstractPipeline.depth;
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            abstractPipeline = abstractPipeline.previousStage;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.getOutputShape:()Ljava/util/stream/StreamShape;");
        return abstractPipeline.getOutputShape();
    }

    @Override
    final <P_IN> long exactOutputSizeIfKnown(Spliterator<P_IN> spliterator) {
        long l;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.getStreamAndOpFlags:()I");
        int n = this.getStreamAndOpFlags();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
        boolean bl = StreamOpFlag.SIZED.isKnown(n);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.getExactSizeIfKnown:()J");
            l = spliterator.getExactSizeIfKnown();
            RuntimeCostAccounter.recordJump();
        } else {
            l = -1L;
        }
        return l;
    }

    @Override
    final <P_IN, S extends Sink<E_OUT>> S wrapAndCopyInto(S s, Spliterator<P_IN> spliterator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.wrapSink:(Ljava/util/stream/Sink;)Ljava/util/stream/Sink;");
        Sink<P_IN> sink = this.wrapSink(Objects.requireNonNull(s));
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.copyInto:(Ljava/util/stream/Sink;Ljava/util/Spliterator;)V");
        this.copyInto(sink, spliterator);
        return s;
    }

    @Override
    final <P_IN> void copyInto(Sink<P_IN> sink, Spliterator<P_IN> spliterator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(sink);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.getStreamAndOpFlags:()I");
        int n = this.getStreamAndOpFlags();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
        boolean bl = StreamOpFlag.SHORT_CIRCUIT.isKnown(n);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.getExactSizeIfKnown:()J");
            long l = spliterator.getExactSizeIfKnown();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.begin:(J)V");
            sink.begin(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.forEachRemaining:(Ljava/util/function/Consumer;)V");
            spliterator.forEachRemaining(sink);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.end:()V");
            sink.end();
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.copyIntoWithCancel:(Ljava/util/stream/Sink;Ljava/util/Spliterator;)V");
            this.copyIntoWithCancel(sink, spliterator);
        }
    }

    @Override
    final <P_IN> void copyIntoWithCancel(Sink<P_IN> sink, Spliterator<P_IN> spliterator) {
        AbstractPipeline abstractPipeline = this;
        while (true) {
            int n = abstractPipeline.depth;
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            abstractPipeline = abstractPipeline.previousStage;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.getExactSizeIfKnown:()J");
        long l = spliterator.getExactSizeIfKnown();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.begin:(J)V");
        sink.begin(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.forEachWithCancel:(Ljava/util/Spliterator;Ljava/util/stream/Sink;)V");
        abstractPipeline.forEachWithCancel(spliterator, sink);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.end:()V");
        sink.end();
    }

    @Override
    final int getStreamAndOpFlags() {
        return this.combinedFlags;
    }

    final boolean isOrdered() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
        return StreamOpFlag.ORDERED.isKnown(this.combinedFlags);
    }

    @Override
    final <P_IN> Sink<P_IN> wrapSink(Sink<E_OUT> sink) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(sink);
        AbstractPipeline abstractPipeline = this;
        while (true) {
            int n = abstractPipeline.depth;
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            int n2 = abstractPipeline.previousStage.combinedFlags;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.opWrapSink:(ILjava/util/stream/Sink;)Ljava/util/stream/Sink;");
            sink = abstractPipeline.opWrapSink(n2, sink);
            abstractPipeline = abstractPipeline.previousStage;
            RuntimeCostAccounter.recordJump();
        }
        return sink;
    }

    @Override
    final <P_IN> Spliterator<E_OUT> wrapSpliterator(Spliterator<P_IN> spliterator) {
        RuntimeCostAccounter.recordJump();
        if (this.depth == 0) {
            return spliterator;
        }
        Supplier<Spliterator<P_IN>> supplier = () -> spliterator;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.isParallel:()Z");
        boolean bl = this.isParallel();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.wrap:(Ljava/util/stream/PipelineHelper;Ljava/util/function/Supplier;Z)Ljava/util/Spliterator;");
        return this.wrap(this, supplier, bl);
    }

    @Override
    final <P_IN> Node<E_OUT> evaluate(Spliterator<P_IN> spliterator, boolean bl, IntFunction<E_OUT[]> intFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.isParallel:()Z");
        boolean bl2 = this.isParallel();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.evaluateToNode:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;ZLjava/util/function/IntFunction;)Ljava/util/stream/Node;");
            return this.evaluateToNode(this, spliterator, bl, intFunction);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.exactOutputSizeIfKnown:(Ljava/util/Spliterator;)J");
        long l = this.exactOutputSizeIfKnown(spliterator);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.makeNodeBuilder:(JLjava/util/function/IntFunction;)Ljava/util/stream/Node$Builder;");
        Node.Builder<E_OUT> builder = this.makeNodeBuilder(l, intFunction);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.wrapAndCopyInto:(Ljava/util/stream/Sink;Ljava/util/Spliterator;)Ljava/util/stream/Sink;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$Builder.build:()Ljava/util/stream/Node;");
        return this.wrapAndCopyInto(builder, spliterator).build();
    }

    abstract StreamShape getOutputShape();

    abstract <P_IN> Node<E_OUT> evaluateToNode(PipelineHelper<E_OUT> var1, Spliterator<P_IN> var2, boolean var3, IntFunction<E_OUT[]> var4);

    abstract <P_IN> Spliterator<E_OUT> wrap(PipelineHelper<E_OUT> var1, Supplier<Spliterator<P_IN>> var2, boolean var3);

    abstract Spliterator<E_OUT> lazySpliterator(Supplier<? extends Spliterator<E_OUT>> var1);

    abstract void forEachWithCancel(Spliterator<E_OUT> var1, Sink<E_OUT> var2);

    @Override
    abstract Node.Builder<E_OUT> makeNodeBuilder(long var1, IntFunction<E_OUT[]> var3);

    abstract boolean opIsStateful();

    abstract Sink<E_IN> opWrapSink(int var1, Sink<E_OUT> var2);

    <P_IN> Node<E_OUT> opEvaluateParallel(PipelineHelper<E_OUT> pipelineHelper, Spliterator<P_IN> spliterator, IntFunction<E_OUT[]> intFunction) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:(Ljava/lang/String;)V");
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("Parallel evaluation is not supported");
        RuntimeCostAccounter.recordThrow();
        throw unsupportedOperationException;
    }

    <P_IN> Spliterator<E_OUT> opEvaluateParallelLazy(PipelineHelper<E_OUT> pipelineHelper, Spliterator<P_IN> spliterator) {
        IntFunction<E_OUT[]> intFunction = n -> {
            int n2 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
            return new Object[n2];
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractPipeline.opEvaluateParallel:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;Ljava/util/function/IntFunction;)Ljava/util/stream/Node;");
        Node<E_OUT> node = this.opEvaluateParallel(pipelineHelper, spliterator, intFunction);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.spliterator:()Ljava/util/Spliterator;");
        return node.spliterator();
    }

    static {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
        boolean bl2 = AbstractPipeline.class.desiredAssertionStatus();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        $assertionsDisabled = bl;
    }
}

