/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent.locks;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.Collection;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.locks.AbstractQueuedSynchronizer;
import sandbox.java.util.concurrent.locks.Condition;
import sandbox.java.util.concurrent.locks.Lock;
import sandbox.java.util.concurrent.locks.ReadWriteLock;
import sandbox.sun.misc.Unsafe;

public class ReentrantReadWriteLock
implements ReadWriteLock,
Serializable {
    private static final long serialVersionUID = -6992448646407690164L;
    private final ReadLock readerLock;
    private final WriteLock writerLock;
    final Sync sync;
    private static final Unsafe UNSAFE;
    private static final long TID_OFFSET;

    public ReentrantReadWriteLock() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock.<init>:(Z)V");
        this(false);
    }

    public ReentrantReadWriteLock(boolean bl) {
        Sync sync;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantReadWriteLock$FairSync");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$FairSync.<init>:()V");
            sync = new FairSync();
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantReadWriteLock$NonfairSync");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$NonfairSync.<init>:()V");
            sync = new NonfairSync();
        }
        this.sync = sync;
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantReadWriteLock$ReadLock");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$ReadLock.<init>:(Ljava/util/concurrent/locks/ReentrantReadWriteLock;)V");
        this.readerLock = new ReadLock(this);
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantReadWriteLock$WriteLock");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$WriteLock.<init>:(Ljava/util/concurrent/locks/ReentrantReadWriteLock;)V");
        this.writerLock = new WriteLock(this);
    }

    @Override
    public WriteLock writeLock() {
        return this.writerLock;
    }

    @Override
    public ReadLock readLock() {
        return this.readerLock;
    }

    public final boolean isFair() {
        return this.sync instanceof FairSync;
    }

    protected Thread getOwner() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getOwner:()Ljava/lang/Thread;");
        return this.sync.getOwner();
    }

    public int getReadLockCount() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getReadLockCount:()I");
        return this.sync.getReadLockCount();
    }

    public boolean isWriteLocked() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.isWriteLocked:()Z");
        return this.sync.isWriteLocked();
    }

    public boolean isWriteLockedByCurrentThread() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.isHeldExclusively:()Z");
        return this.sync.isHeldExclusively();
    }

    public int getWriteHoldCount() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getWriteHoldCount:()I");
        return this.sync.getWriteHoldCount();
    }

    public int getReadHoldCount() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getReadHoldCount:()I");
        return this.sync.getReadHoldCount();
    }

    protected Collection<Thread> getQueuedWriterThreads() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getExclusiveQueuedThreads:()Ljava/util/Collection;");
        return this.sync.getExclusiveQueuedThreads();
    }

    protected Collection<Thread> getQueuedReaderThreads() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getSharedQueuedThreads:()Ljava/util/Collection;");
        return this.sync.getSharedQueuedThreads();
    }

    public final boolean hasQueuedThreads() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.hasQueuedThreads:()Z");
        return this.sync.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread thread) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.isQueued:(Ljava/lang/Thread;)Z");
        return this.sync.isQueued(thread);
    }

    public final int getQueueLength() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getQueueLength:()I");
        return this.sync.getQueueLength();
    }

    protected Collection<Thread> getQueuedThreads() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getQueuedThreads:()Ljava/util/Collection;");
        return this.sync.getQueuedThreads();
    }

    public boolean hasWaiters(Condition condition) {
        RuntimeCostAccounter.recordJump();
        if (condition == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        boolean bl = condition instanceof AbstractQueuedSynchronizer.ConditionObject;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("not owner");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        AbstractQueuedSynchronizer.ConditionObject conditionObject = (AbstractQueuedSynchronizer.ConditionObject)condition;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.hasWaiters:(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$ConditionObject;)Z");
        return this.sync.hasWaiters(conditionObject);
    }

    public int getWaitQueueLength(Condition condition) {
        RuntimeCostAccounter.recordJump();
        if (condition == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        boolean bl = condition instanceof AbstractQueuedSynchronizer.ConditionObject;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("not owner");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        AbstractQueuedSynchronizer.ConditionObject conditionObject = (AbstractQueuedSynchronizer.ConditionObject)condition;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getWaitQueueLength:(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$ConditionObject;)I");
        return this.sync.getWaitQueueLength(conditionObject);
    }

    protected Collection<Thread> getWaitingThreads(Condition condition) {
        RuntimeCostAccounter.recordJump();
        if (condition == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        boolean bl = condition instanceof AbstractQueuedSynchronizer.ConditionObject;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("not owner");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        AbstractQueuedSynchronizer.ConditionObject conditionObject = (AbstractQueuedSynchronizer.ConditionObject)condition;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getWaitingThreads:(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$ConditionObject;)Ljava/util/Collection;");
        return this.sync.getWaitingThreads(conditionObject);
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getCount:()I");
        int n = this.sync.getCount();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.exclusiveCount:(I)I");
        int n2 = Sync.exclusiveCount(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.sharedCount:(I)I");
        int n3 = Sync.sharedCount(n);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
        String string = super.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append("[Write locks = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(", Read locks = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder6.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder7.toString();
    }

    static final long getThreadId(Thread thread) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getLongVolatile:(Ljava/lang/Object;J)J");
        return UNSAFE.getLongVolatile((Object)thread, TID_OFFSET);
    }

    static {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
            UNSAFE = Unsafe.getUnsafe();
            Class<Thread> clazz = Thread.class;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = clazz.getDeclaredField("tid");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            TID_OFFSET = UNSAFE.objectFieldOffset(field);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }

    public static class WriteLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -4992448646407690164L;
        private final Sync sync;

        protected WriteLock(ReentrantReadWriteLock reentrantReadWriteLock) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.sync = reentrantReadWriteLock.sync;
        }

        @Override
        public void lock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.acquire:(I)V");
            this.sync.acquire(1);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.acquireInterruptibly:(I)V");
            this.sync.acquireInterruptibly(1);
        }

        @Override
        public boolean tryLock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.tryWriteLock:()Z");
            return this.sync.tryWriteLock();
        }

        @Override
        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
            long l2 = timeUnit.toNanos(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.tryAcquireNanos:(IJ)Z");
            return this.sync.tryAcquireNanos(1, l2);
        }

        @Override
        public void unlock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.release:(I)Z");
            this.sync.release(1);
        }

        @Override
        public Condition newCondition() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.newCondition:()Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$ConditionObject;");
            return this.sync.newCondition();
        }

        public String toString() {
            String string;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getOwner:()Ljava/lang/Thread;");
            Thread thread = this.sync.getOwner();
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
            String string2 = super.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(string2);
            RuntimeCostAccounter.recordJump();
            if (thread == null) {
                string = "[Unlocked]";
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder3 = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append("[Locked by thread ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.getName:()Ljava/lang/String;");
                String string3 = thread.getName();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(string3);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append("]");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                string = stringBuilder6.toString();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder7.toString();
        }

        public boolean isHeldByCurrentThread() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.isHeldExclusively:()Z");
            return this.sync.isHeldExclusively();
        }

        public int getHoldCount() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getWriteHoldCount:()I");
            return this.sync.getWriteHoldCount();
        }
    }

    public static class ReadLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -5992448646407690164L;
        private final Sync sync;

        protected ReadLock(ReentrantReadWriteLock reentrantReadWriteLock) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.sync = reentrantReadWriteLock.sync;
        }

        @Override
        public void lock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.acquireShared:(I)V");
            this.sync.acquireShared(1);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.acquireSharedInterruptibly:(I)V");
            this.sync.acquireSharedInterruptibly(1);
        }

        @Override
        public boolean tryLock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.tryReadLock:()Z");
            return this.sync.tryReadLock();
        }

        @Override
        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
            long l2 = timeUnit.toNanos(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.tryAcquireSharedNanos:(IJ)Z");
            return this.sync.tryAcquireSharedNanos(1, l2);
        }

        @Override
        public void unlock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.releaseShared:(I)Z");
            this.sync.releaseShared(1);
        }

        @Override
        public Condition newCondition() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }

        public String toString() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getReadLockCount:()I");
            int n = this.sync.getReadLockCount();
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
            String string = super.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append("[Read locks = ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append("]");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder5.toString();
        }
    }

    static final class FairSync
    extends Sync {
        private static final long serialVersionUID = -2274990926593161451L;

        FairSync() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.<init>:()V");
        }

        @Override
        final boolean writerShouldBlock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$FairSync.hasQueuedPredecessors:()Z");
            return this.hasQueuedPredecessors();
        }

        @Override
        final boolean readerShouldBlock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$FairSync.hasQueuedPredecessors:()Z");
            return this.hasQueuedPredecessors();
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = -8159625535654395037L;

        NonfairSync() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.<init>:()V");
        }

        @Override
        final boolean writerShouldBlock() {
            return false;
        }

        @Override
        final boolean readerShouldBlock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$NonfairSync.apparentlyFirstQueuedIsExclusive:()Z");
            return this.apparentlyFirstQueuedIsExclusive();
        }
    }

    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 6317671515068378041L;
        static final int SHARED_SHIFT = 16;
        static final int SHARED_UNIT = 65536;
        static final int MAX_COUNT = 65535;
        static final int EXCLUSIVE_MASK = 65535;
        private transient ThreadLocalHoldCounter readHolds;
        private transient HoldCounter cachedHoldCounter;
        private transient Thread firstReader;
        private transient int firstReaderHoldCount;

        static int sharedCount(int n) {
            return n >>> 16;
        }

        static int exclusiveCount(int n) {
            return n & 0xFFFF;
        }

        Sync() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedSynchronizer.<init>:()V");
            this.firstReader = null;
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$ThreadLocalHoldCounter");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$ThreadLocalHoldCounter.<init>:()V");
            this.readHolds = new ThreadLocalHoldCounter();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getState:()I");
            int n = this.getState();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.setState:(I)V");
            this.setState(n);
        }

        abstract boolean readerShouldBlock();

        abstract boolean writerShouldBlock();

        @Override
        protected final boolean tryRelease(int n) {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.isHeldExclusively:()Z");
            boolean bl2 = this.isHeldExclusively();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalMonitorStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalMonitorStateException.<init>:()V");
                IllegalMonitorStateException illegalMonitorStateException = new IllegalMonitorStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalMonitorStateException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getState:()I");
            int n2 = this.getState() - n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.exclusiveCount:(I)I");
            int n3 = Sync.exclusiveCount(n2);
            RuntimeCostAccounter.recordJump();
            if (n3 == 0) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            boolean bl3 = bl;
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.setExclusiveOwnerThread:(Ljava/lang/Thread;)V");
                this.setExclusiveOwnerThread(null);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.setState:(I)V");
            this.setState(n2);
            return bl3;
        }

        @Override
        protected final boolean tryAcquire(int n) {
            Thread thread;
            block11: {
                block10: {
                    int n2;
                    block7: {
                        int n3;
                        block9: {
                            block8: {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                                thread = Thread.currentThread();
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getState:()I");
                                n2 = this.getState();
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.exclusiveCount:(I)I");
                                n3 = Sync.exclusiveCount(n2);
                                RuntimeCostAccounter.recordJump();
                                if (n2 == 0) break block7;
                                RuntimeCostAccounter.recordJump();
                                if (n3 == 0) break block8;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getExclusiveOwnerThread:()Ljava/lang/Thread;");
                                Thread thread2 = this.getExclusiveOwnerThread();
                                RuntimeCostAccounter.recordJump();
                                if (thread == thread2) break block9;
                            }
                            return false;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.exclusiveCount:(I)I");
                        int n4 = n3 + Sync.exclusiveCount(n);
                        RuntimeCostAccounter.recordJump();
                        if (n4 > 65535) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/String;)V");
                            Error error = new Error("Maximum lock count exceeded");
                            RuntimeCostAccounter.recordThrow();
                            throw error;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.setState:(I)V");
                        this.setState(n2 + n);
                        return true;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.writerShouldBlock:()Z");
                    boolean bl = this.writerShouldBlock();
                    RuntimeCostAccounter.recordJump();
                    if (bl) break block10;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.compareAndSetState:(II)Z");
                    boolean bl2 = this.compareAndSetState(n2, n2 + n);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) break block11;
                }
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.setExclusiveOwnerThread:(Ljava/lang/Thread;)V");
            this.setExclusiveOwnerThread(thread);
            return true;
        }

        @Override
        protected final boolean tryReleaseShared(int n) {
            int n2;
            block12: {
                HoldCounter holdCounter;
                block14: {
                    block13: {
                        Thread thread;
                        block11: {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                            thread = Thread.currentThread();
                            RuntimeCostAccounter.recordJump();
                            if (this.firstReader != thread) break block11;
                            RuntimeCostAccounter.recordJump();
                            if (this.firstReaderHoldCount == 1) {
                                this.firstReader = null;
                                RuntimeCostAccounter.recordJump();
                            } else {
                                --this.firstReaderHoldCount;
                                RuntimeCostAccounter.recordJump();
                            }
                            break block12;
                        }
                        holdCounter = this.cachedHoldCounter;
                        RuntimeCostAccounter.recordJump();
                        if (holdCounter == null) break block13;
                        long l = holdCounter.tid;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock.getThreadId:(Ljava/lang/Thread;)J");
                        long l2 = l - ReentrantReadWriteLock.getThreadId(thread);
                        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (l3 == false) break block14;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$ThreadLocalHoldCounter.get:()Ljava/lang/Object;");
                    holdCounter = (HoldCounter)this.readHolds.get();
                }
                n2 = holdCounter.count;
                RuntimeCostAccounter.recordJump();
                if (n2 <= 1) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$ThreadLocalHoldCounter.remove:()V");
                    this.readHolds.remove();
                    RuntimeCostAccounter.recordJump();
                    if (n2 <= 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.unmatchedUnlockException:()Ljava/lang/IllegalMonitorStateException;");
                        IllegalMonitorStateException illegalMonitorStateException = this.unmatchedUnlockException();
                        RuntimeCostAccounter.recordThrow();
                        throw illegalMonitorStateException;
                    }
                }
                --holdCounter.count;
            }
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getState:()I");
                int n3 = this.getState();
                n2 = n3 - 65536;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.compareAndSetState:(II)Z");
                boolean bl = this.compareAndSetState(n3, n2);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    boolean bl2;
                    RuntimeCostAccounter.recordJump();
                    if (n2 == 0) {
                        bl2 = true;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        bl2 = false;
                    }
                    return bl2;
                }
                RuntimeCostAccounter.recordJump();
            }
        }

        private IllegalMonitorStateException unmatchedUnlockException() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalMonitorStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalMonitorStateException.<init>:(Ljava/lang/String;)V");
            return new IllegalMonitorStateException("attempt to unlock read lock, not locked by current thread");
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected final int tryAcquireShared(int var1_1) {
            block5: {
                block7: {
                    block8: {
                        block6: {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                            var2_2 = Thread.currentThread();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getState:()I");
                            var3_3 = this.getState();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.exclusiveCount:(I)I");
                            v0 = Sync.exclusiveCount(var3_3);
                            RuntimeCostAccounter.recordJump();
                            if (v0 != 0) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getExclusiveOwnerThread:()Ljava/lang/Thread;");
                                v1 = this.getExclusiveOwnerThread();
                                RuntimeCostAccounter.recordJump();
                                if (v1 != var2_2) {
                                    return -1;
                                }
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.sharedCount:(I)I");
                            var4_4 = Sync.sharedCount(var3_3);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.readerShouldBlock:()Z");
                            v2 = this.readerShouldBlock();
                            RuntimeCostAccounter.recordJump();
                            if (v2) break block5;
                            RuntimeCostAccounter.recordJump();
                            if (var4_4 >= 65535) break block5;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.compareAndSetState:(II)Z");
                            v3 = this.compareAndSetState(var3_3, var3_3 + 65536);
                            RuntimeCostAccounter.recordJump();
                            if (!v3) break block5;
                            RuntimeCostAccounter.recordJump();
                            if (var4_4 != 0) break block6;
                            this.firstReader = var2_2;
                            this.firstReaderHoldCount = 1;
                            RuntimeCostAccounter.recordJump();
                            break block7;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (this.firstReader != var2_2) break block8;
                        ++this.firstReaderHoldCount;
                        RuntimeCostAccounter.recordJump();
                        break block7;
                    }
                    var5_5 = this.cachedHoldCounter;
                    RuntimeCostAccounter.recordJump();
                    if (var5_5 == null) ** GOTO lbl-1000
                    v4 = var5_5.tid;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock.getThreadId:(Ljava/lang/Thread;)J");
                    cfr_temp_0 = v4 - ReentrantReadWriteLock.getThreadId(var2_2);
                    v5 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (v5 != false) lbl-1000:
                    // 2 sources

                    {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$ThreadLocalHoldCounter.get:()Ljava/lang/Object;");
                        this.cachedHoldCounter = var5_5 = (HoldCounter)this.readHolds.get();
                        RuntimeCostAccounter.recordJump();
                    } else {
                        v6 = var5_5.count;
                        RuntimeCostAccounter.recordJump();
                        if (v6 == 0) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$ThreadLocalHoldCounter.set:(Ljava/lang/Object;)V");
                            this.readHolds.set(var5_5);
                        }
                    }
                    ++var5_5.count;
                }
                return 1;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.fullTryAcquireShared:(Ljava/lang/Thread;)I");
            return this.fullTryAcquireShared(var2_2);
        }

        /*
         * Unable to fully structure code
         */
        final int fullTryAcquireShared(Thread var1_1) {
            var2_2 = null;
            while (true) {
                block18: {
                    block20: {
                        block21: {
                            block19: {
                                block14: {
                                    block16: {
                                        block17: {
                                            block15: {
                                                block13: {
                                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getState:()I");
                                                    var3_3 = this.getState();
                                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.exclusiveCount:(I)I");
                                                    v0 = Sync.exclusiveCount(var3_3);
                                                    RuntimeCostAccounter.recordJump();
                                                    if (v0 == 0) break block13;
                                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getExclusiveOwnerThread:()Ljava/lang/Thread;");
                                                    v1 = this.getExclusiveOwnerThread();
                                                    RuntimeCostAccounter.recordJump();
                                                    if (v1 != var1_1) {
                                                        return -1;
                                                    }
                                                    break block14;
                                                }
                                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.readerShouldBlock:()Z");
                                                v2 = this.readerShouldBlock();
                                                RuntimeCostAccounter.recordJump();
                                                if (!v2) break block14;
                                                RuntimeCostAccounter.recordJump();
                                                if (this.firstReader != var1_1) break block15;
                                                RuntimeCostAccounter.recordJump();
                                                break block14;
                                            }
                                            RuntimeCostAccounter.recordJump();
                                            if (var2_2 != null) break block16;
                                            var2_2 = this.cachedHoldCounter;
                                            RuntimeCostAccounter.recordJump();
                                            if (var2_2 == null) break block17;
                                            v3 = var2_2.tid;
                                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock.getThreadId:(Ljava/lang/Thread;)J");
                                            cfr_temp_0 = v3 - ReentrantReadWriteLock.getThreadId(var1_1);
                                            v4 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                                            RuntimeCostAccounter.recordJump();
                                            if (v4 == false) break block16;
                                        }
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$ThreadLocalHoldCounter.get:()Ljava/lang/Object;");
                                        var2_2 = (HoldCounter)this.readHolds.get();
                                        v5 = var2_2.count;
                                        RuntimeCostAccounter.recordJump();
                                        if (v5 == 0) {
                                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$ThreadLocalHoldCounter.remove:()V");
                                            this.readHolds.remove();
                                        }
                                    }
                                    v6 = var2_2.count;
                                    RuntimeCostAccounter.recordJump();
                                    if (v6 == 0) {
                                        return -1;
                                    }
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.sharedCount:(I)I");
                                v7 = Sync.sharedCount(var3_3);
                                RuntimeCostAccounter.recordJump();
                                if (v7 == 65535) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/String;)V");
                                    v8 = new Error("Maximum lock count exceeded");
                                    RuntimeCostAccounter.recordThrow();
                                    throw v8;
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.compareAndSetState:(II)Z");
                                v9 = this.compareAndSetState(var3_3, var3_3 + 65536);
                                RuntimeCostAccounter.recordJump();
                                if (!v9) break block18;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.sharedCount:(I)I");
                                v10 = Sync.sharedCount(var3_3);
                                RuntimeCostAccounter.recordJump();
                                if (v10 != 0) break block19;
                                this.firstReader = var1_1;
                                this.firstReaderHoldCount = 1;
                                RuntimeCostAccounter.recordJump();
                                break block20;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (this.firstReader != var1_1) break block21;
                            ++this.firstReaderHoldCount;
                            RuntimeCostAccounter.recordJump();
                            break block20;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (var2_2 == null) {
                            var2_2 = this.cachedHoldCounter;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (var2_2 == null) ** GOTO lbl-1000
                        v11 = var2_2.tid;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock.getThreadId:(Ljava/lang/Thread;)J");
                        cfr_temp_1 = v11 - ReentrantReadWriteLock.getThreadId(var1_1);
                        v12 = cfr_temp_1 == 0L ? 0 : (cfr_temp_1 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (v12 != false) lbl-1000:
                        // 2 sources

                        {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$ThreadLocalHoldCounter.get:()Ljava/lang/Object;");
                            var2_2 = (HoldCounter)this.readHolds.get();
                            RuntimeCostAccounter.recordJump();
                        } else {
                            v13 = var2_2.count;
                            RuntimeCostAccounter.recordJump();
                            if (v13 == 0) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$ThreadLocalHoldCounter.set:(Ljava/lang/Object;)V");
                                this.readHolds.set(var2_2);
                            }
                        }
                        ++var2_2.count;
                        this.cachedHoldCounter = var2_2;
                    }
                    return 1;
                }
                RuntimeCostAccounter.recordJump();
            }
        }

        final boolean tryWriteLock() {
            int n;
            Thread thread;
            block5: {
                int n2;
                block7: {
                    block6: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                        thread = Thread.currentThread();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getState:()I");
                        n = this.getState();
                        RuntimeCostAccounter.recordJump();
                        if (n == 0) break block5;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.exclusiveCount:(I)I");
                        n2 = Sync.exclusiveCount(n);
                        RuntimeCostAccounter.recordJump();
                        if (n2 == 0) break block6;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getExclusiveOwnerThread:()Ljava/lang/Thread;");
                        Thread thread2 = this.getExclusiveOwnerThread();
                        RuntimeCostAccounter.recordJump();
                        if (thread == thread2) break block7;
                    }
                    return false;
                }
                RuntimeCostAccounter.recordJump();
                if (n2 == 65535) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/String;)V");
                    Error error = new Error("Maximum lock count exceeded");
                    RuntimeCostAccounter.recordThrow();
                    throw error;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.compareAndSetState:(II)Z");
            boolean bl = this.compareAndSetState(n, n + 1);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.setExclusiveOwnerThread:(Ljava/lang/Thread;)V");
            this.setExclusiveOwnerThread(thread);
            return true;
        }

        /*
         * Unable to fully structure code
         */
        final boolean tryReadLock() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            var1_1 = Thread.currentThread();
            while (true) {
                block7: {
                    block9: {
                        block10: {
                            block8: {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getState:()I");
                                var2_2 = this.getState();
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.exclusiveCount:(I)I");
                                v0 = Sync.exclusiveCount(var2_2);
                                RuntimeCostAccounter.recordJump();
                                if (v0 != 0) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getExclusiveOwnerThread:()Ljava/lang/Thread;");
                                    v1 = this.getExclusiveOwnerThread();
                                    RuntimeCostAccounter.recordJump();
                                    if (v1 != var1_1) {
                                        return false;
                                    }
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.sharedCount:(I)I");
                                var3_3 = Sync.sharedCount(var2_2);
                                RuntimeCostAccounter.recordJump();
                                if (var3_3 == 65535) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/String;)V");
                                    v2 = new Error("Maximum lock count exceeded");
                                    RuntimeCostAccounter.recordThrow();
                                    throw v2;
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.compareAndSetState:(II)Z");
                                v3 = this.compareAndSetState(var2_2, var2_2 + 65536);
                                RuntimeCostAccounter.recordJump();
                                if (!v3) break block7;
                                RuntimeCostAccounter.recordJump();
                                if (var3_3 != 0) break block8;
                                this.firstReader = var1_1;
                                this.firstReaderHoldCount = 1;
                                RuntimeCostAccounter.recordJump();
                                break block9;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (this.firstReader != var1_1) break block10;
                            ++this.firstReaderHoldCount;
                            RuntimeCostAccounter.recordJump();
                            break block9;
                        }
                        var4_4 = this.cachedHoldCounter;
                        RuntimeCostAccounter.recordJump();
                        if (var4_4 == null) ** GOTO lbl-1000
                        v4 = var4_4.tid;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock.getThreadId:(Ljava/lang/Thread;)J");
                        cfr_temp_0 = v4 - ReentrantReadWriteLock.getThreadId(var1_1);
                        v5 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (v5 != false) lbl-1000:
                        // 2 sources

                        {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$ThreadLocalHoldCounter.get:()Ljava/lang/Object;");
                            this.cachedHoldCounter = var4_4 = (HoldCounter)this.readHolds.get();
                            RuntimeCostAccounter.recordJump();
                        } else {
                            v6 = var4_4.count;
                            RuntimeCostAccounter.recordJump();
                            if (v6 == 0) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$ThreadLocalHoldCounter.set:(Ljava/lang/Object;)V");
                                this.readHolds.set(var4_4);
                            }
                        }
                        ++var4_4.count;
                    }
                    return true;
                }
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        protected final boolean isHeldExclusively() {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getExclusiveOwnerThread:()Ljava/lang/Thread;");
            Thread thread = this.getExclusiveOwnerThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread2 = Thread.currentThread();
            RuntimeCostAccounter.recordJump();
            if (thread == thread2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        final AbstractQueuedSynchronizer.ConditionObject newCondition() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/AbstractQueuedSynchronizer$ConditionObject");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedSynchronizer$ConditionObject.<init>:(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer;)V");
            return new AbstractQueuedSynchronizer.ConditionObject();
        }

        final Thread getOwner() {
            Thread thread;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getState:()I");
            int n = this.getState();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.exclusiveCount:(I)I");
            int n2 = Sync.exclusiveCount(n);
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                thread = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getExclusiveOwnerThread:()Ljava/lang/Thread;");
                thread = this.getExclusiveOwnerThread();
            }
            return thread;
        }

        final int getReadLockCount() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getState:()I");
            int n = this.getState();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.sharedCount:(I)I");
            return Sync.sharedCount(n);
        }

        final boolean isWriteLocked() {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getState:()I");
            int n = this.getState();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.exclusiveCount:(I)I");
            int n2 = Sync.exclusiveCount(n);
            RuntimeCostAccounter.recordJump();
            if (n2 != 0) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        final int getWriteHoldCount() {
            int n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.isHeldExclusively:()Z");
            boolean bl = this.isHeldExclusively();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getState:()I");
                int n2 = this.getState();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.exclusiveCount:(I)I");
                n = Sync.exclusiveCount(n2);
                RuntimeCostAccounter.recordJump();
            } else {
                n = 0;
            }
            return n;
        }

        final int getReadHoldCount() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getReadLockCount:()I");
            int n = this.getReadLockCount();
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                return 0;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordJump();
            if (this.firstReader == thread) {
                return this.firstReaderHoldCount;
            }
            HoldCounter holdCounter = this.cachedHoldCounter;
            RuntimeCostAccounter.recordJump();
            if (holdCounter != null) {
                long l = holdCounter.tid;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock.getThreadId:(Ljava/lang/Thread;)J");
                long l2 = l - ReentrantReadWriteLock.getThreadId(thread);
                long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l3 == false) {
                    return holdCounter.count;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$ThreadLocalHoldCounter.get:()Ljava/lang/Object;");
            int n2 = ((HoldCounter)this.readHolds.get()).count;
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$ThreadLocalHoldCounter.remove:()V");
                this.readHolds.remove();
            }
            return n2;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
            objectInputStream.defaultReadObject();
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$ThreadLocalHoldCounter");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$ThreadLocalHoldCounter.<init>:()V");
            this.readHolds = new ThreadLocalHoldCounter();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.setState:(I)V");
            this.setState(0);
        }

        final int getCount() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync.getState:()I");
            return this.getState();
        }

        static final class ThreadLocalHoldCounter
        extends ThreadLocal<HoldCounter> {
            ThreadLocalHoldCounter() {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ThreadLocal.<init>:()V");
            }

            @Override
            public HoldCounter initialValue() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$HoldCounter");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock$Sync$HoldCounter.<init>:()V");
                return new HoldCounter();
            }
        }

        static final class HoldCounter {
            int count;
            final long tid;

            HoldCounter() {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.count = 0;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                Thread thread = Thread.currentThread();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantReadWriteLock.getThreadId:(Ljava/lang/Thread;)J");
                this.tid = ReentrantReadWriteLock.getThreadId(thread);
            }
        }
    }
}

