/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.concurrent.AbstractExecutorService;
import sandbox.java.util.concurrent.BlockingQueue;
import sandbox.java.util.concurrent.Callable;
import sandbox.java.util.concurrent.CompletionService;
import sandbox.java.util.concurrent.Executor;
import sandbox.java.util.concurrent.Future;
import sandbox.java.util.concurrent.FutureTask;
import sandbox.java.util.concurrent.LinkedBlockingQueue;
import sandbox.java.util.concurrent.RunnableFuture;
import sandbox.java.util.concurrent.TimeUnit;

public class ExecutorCompletionService<V>
implements CompletionService<V> {
    private final Executor executor;
    private final AbstractExecutorService aes;
    private final BlockingQueue<Future<V>> completionQueue;

    private RunnableFuture<V> newTaskFor(Callable<V> callable) {
        RuntimeCostAccounter.recordJump();
        if (this.aes == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/FutureTask");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.<init>:(Ljava/util/concurrent/Callable;)V");
            return new FutureTask<V>(callable);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/AbstractExecutorService.newTaskFor:(Ljava/util/concurrent/Callable;)Ljava/util/concurrent/RunnableFuture;");
        return this.aes.newTaskFor(callable);
    }

    private RunnableFuture<V> newTaskFor(Runnable runnable, V v) {
        RuntimeCostAccounter.recordJump();
        if (this.aes == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/FutureTask");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.<init>:(Ljava/lang/Runnable;Ljava/lang/Object;)V");
            return new FutureTask<V>(runnable, v);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/AbstractExecutorService.newTaskFor:(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/RunnableFuture;");
        return this.aes.newTaskFor(runnable, v);
    }

    public ExecutorCompletionService(Executor executor) {
        AbstractExecutorService abstractExecutorService;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (executor == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        this.executor = executor;
        boolean bl = executor instanceof AbstractExecutorService;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            abstractExecutorService = (AbstractExecutorService)executor;
            RuntimeCostAccounter.recordJump();
        } else {
            abstractExecutorService = null;
        }
        this.aes = abstractExecutorService;
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.<init>:()V");
        this.completionQueue = new LinkedBlockingQueue<Future<V>>();
    }

    public ExecutorCompletionService(Executor executor, BlockingQueue<Future<V>> blockingQueue) {
        AbstractExecutorService abstractExecutorService;
        block6: {
            block5: {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                RuntimeCostAccounter.recordJump();
                if (executor == null) break block5;
                RuntimeCostAccounter.recordJump();
                if (blockingQueue != null) break block6;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        this.executor = executor;
        boolean bl = executor instanceof AbstractExecutorService;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            abstractExecutorService = (AbstractExecutorService)executor;
            RuntimeCostAccounter.recordJump();
        } else {
            abstractExecutorService = null;
        }
        this.aes = abstractExecutorService;
        this.completionQueue = blockingQueue;
    }

    @Override
    public Future<V> submit(Callable<V> callable) {
        RuntimeCostAccounter.recordJump();
        if (callable == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorCompletionService.newTaskFor:(Ljava/util/concurrent/Callable;)Ljava/util/concurrent/RunnableFuture;");
        RunnableFuture<V> runnableFuture = this.newTaskFor(callable);
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ExecutorCompletionService$QueueingFuture");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorCompletionService$QueueingFuture.<init>:(Ljava/util/concurrent/ExecutorCompletionService;Ljava/util/concurrent/RunnableFuture;)V");
        QueueingFuture queueingFuture = new QueueingFuture(runnableFuture);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executor.execute:(Ljava/lang/Runnable;)V");
        this.executor.execute(queueingFuture);
        return runnableFuture;
    }

    @Override
    public Future<V> submit(Runnable runnable, V v) {
        RuntimeCostAccounter.recordJump();
        if (runnable == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorCompletionService.newTaskFor:(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/RunnableFuture;");
        RunnableFuture<V> runnableFuture = this.newTaskFor(runnable, v);
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ExecutorCompletionService$QueueingFuture");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorCompletionService$QueueingFuture.<init>:(Ljava/util/concurrent/ExecutorCompletionService;Ljava/util/concurrent/RunnableFuture;)V");
        QueueingFuture queueingFuture = new QueueingFuture(runnableFuture);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executor.execute:(Ljava/lang/Runnable;)V");
        this.executor.execute(queueingFuture);
        return runnableFuture;
    }

    @Override
    public Future<V> take() throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.take:()Ljava/lang/Object;");
        return this.completionQueue.take();
    }

    @Override
    public Future<V> poll() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.poll:()Ljava/lang/Object;");
        return (Future)this.completionQueue.poll();
    }

    @Override
    public Future<V> poll(long l, TimeUnit timeUnit) throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.poll:(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;");
        return this.completionQueue.poll(l, timeUnit);
    }

    private class QueueingFuture
    extends FutureTask<Void> {
        private final Future<V> task;

        QueueingFuture(RunnableFuture<V> runnableFuture) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.<init>:(Ljava/lang/Runnable;Ljava/lang/Object;)V");
            super(runnableFuture, null);
            this.task = runnableFuture;
        }

        @Override
        protected void done() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorCompletionService.access$000:(Ljava/util/concurrent/ExecutorCompletionService;)Ljava/util/concurrent/BlockingQueue;");
            BlockingQueue blockingQueue = ExecutorCompletionService.this.completionQueue;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.add:(Ljava/lang/Object;)Z");
            blockingQueue.add(this.task);
        }
    }
}

