/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Closeable;
import sandbox.java.io.File;
import sandbox.java.io.FileInputStream;
import sandbox.java.io.FileNotFoundException;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.io.InputStreamReader;
import sandbox.java.io.StringReader;
import sandbox.java.math.BigDecimal;
import sandbox.java.math.BigInteger;
import sandbox.java.nio.CharBuffer;
import sandbox.java.nio.channels.Channels;
import sandbox.java.nio.channels.FileChannel;
import sandbox.java.nio.channels.ReadableByteChannel;
import sandbox.java.nio.charset.Charset;
import sandbox.java.nio.charset.CharsetDecoder;
import sandbox.java.nio.charset.IllegalCharsetNameException;
import sandbox.java.nio.charset.UnsupportedCharsetException;
import sandbox.java.nio.file.Files;
import sandbox.java.nio.file.OpenOption;
import sandbox.java.nio.file.Path;
import sandbox.java.text.DecimalFormat;
import sandbox.java.text.DecimalFormatSymbols;
import sandbox.java.text.NumberFormat;
import sandbox.java.util.InputMismatchException;
import sandbox.java.util.Iterator;
import sandbox.java.util.Locale;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Objects;
import sandbox.java.util.regex.MatchResult;
import sandbox.java.util.regex.Matcher;
import sandbox.java.util.regex.Pattern;
import sandbox.sun.misc.LRUCache;

public final class Scanner
implements Iterator<String>,
Closeable {
    private CharBuffer buf;
    private static final int BUFFER_SIZE = 1024;
    private int position;
    private Matcher matcher;
    private Pattern delimPattern;
    private Pattern hasNextPattern;
    private int hasNextPosition;
    private String hasNextResult;
    private Readable source;
    private boolean sourceClosed;
    private boolean needInput;
    private boolean skipped;
    private int savedScannerPosition;
    private Object typeCache;
    private boolean matchValid;
    private boolean closed;
    private int radix;
    private int defaultRadix;
    private Locale locale;
    private LRUCache<String, Pattern> patternCache;
    private IOException lastException;
    private static Pattern WHITESPACE_PATTERN;
    private static Pattern FIND_ANY_PATTERN;
    private static Pattern NON_ASCII_DIGIT;
    private String groupSeparator;
    private String decimalSeparator;
    private String nanString;
    private String infinityString;
    private String positivePrefix;
    private String negativePrefix;
    private String positiveSuffix;
    private String negativeSuffix;
    private static volatile Pattern boolPattern;
    private static final String BOOLEAN_PATTERN = "true|false";
    private Pattern integerPattern;
    private String digits;
    private String non0Digit;
    private int SIMPLE_GROUP_INDEX;
    private static volatile Pattern separatorPattern;
    private static volatile Pattern linePattern;
    private static final String LINE_SEPARATOR_PATTERN = "\r\n|[\n\r\u2028\u2029\u0085]";
    private static final String LINE_PATTERN = ".*(\r\n|[\n\r\u2028\u2029\u0085])|.+$";
    private Pattern floatPattern;
    private Pattern decimalPattern;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static Pattern boolPattern() {
        Pattern pattern = boolPattern;
        RuntimeCostAccounter.recordJump();
        if (pattern == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.compile:(Ljava/lang/String;I)Ljava/util/regex/Pattern;");
            boolPattern = pattern = Pattern.compile(BOOLEAN_PATTERN, 2);
        }
        return pattern;
    }

    private String buildIntegerPatternString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
        String string = this.digits.substring(0, this.radix);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("((?i)[");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append("]|\\p{javaDigit})");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string2 = stringBuilder4.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder5 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append("(");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder6.append(this.non0Digit);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder8 = stringBuilder7.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder9 = stringBuilder8.append("?");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder10 = stringBuilder9.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder11 = stringBuilder10.append("?(");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder12 = stringBuilder11.append(this.groupSeparator);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder13 = stringBuilder12.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder14 = stringBuilder13.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder15 = stringBuilder14.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder16 = stringBuilder15.append(")+)");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string3 = stringBuilder16.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder17 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder18 = stringBuilder17.append("((");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder19 = stringBuilder18.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder20 = stringBuilder19.append("++)|");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder21 = stringBuilder20.append(string3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder22 = stringBuilder21.append(")");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string4 = stringBuilder22.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder23 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder24 = stringBuilder23.append("([-+]?(");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder25 = stringBuilder24.append(string4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder26 = stringBuilder25.append("))");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string5 = stringBuilder26.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder27 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder28 = stringBuilder27.append(this.negativePrefix);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder29 = stringBuilder28.append(string4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder30 = stringBuilder29.append(this.negativeSuffix);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string6 = stringBuilder30.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder31 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder32 = stringBuilder31.append(this.positivePrefix);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder33 = stringBuilder32.append(string4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder34 = stringBuilder33.append(this.positiveSuffix);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string7 = stringBuilder34.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder35 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder36 = stringBuilder35.append("(");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder37 = stringBuilder36.append(string5);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder38 = stringBuilder37.append(")|(");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder39 = stringBuilder38.append(string7);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder40 = stringBuilder39.append(")|(");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder41 = stringBuilder40.append(string6);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder42 = stringBuilder41.append(")");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder42.toString();
    }

    private Pattern integerPattern() {
        RuntimeCostAccounter.recordJump();
        if (this.integerPattern == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.buildIntegerPatternString:()Ljava/lang/String;");
            String string = this.buildIntegerPatternString();
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/LRUCache.forName:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.integerPattern = (Pattern)this.patternCache.forName((Object)string);
        }
        return this.integerPattern;
    }

    private static Pattern separatorPattern() {
        Pattern pattern = separatorPattern;
        RuntimeCostAccounter.recordJump();
        if (pattern == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.compile:(Ljava/lang/String;)Ljava/util/regex/Pattern;");
            separatorPattern = pattern = Pattern.compile(LINE_SEPARATOR_PATTERN);
        }
        return pattern;
    }

    private static Pattern linePattern() {
        Pattern pattern = linePattern;
        RuntimeCostAccounter.recordJump();
        if (pattern == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.compile:(Ljava/lang/String;)Ljava/util/regex/Pattern;");
            linePattern = pattern = Pattern.compile(LINE_PATTERN);
        }
        return pattern;
    }

    private void buildFloatAndDecimalPattern() {
        String string = "([0-9]|(\\p{javaDigit}))";
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("([eE][+-]?");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append("+)?");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string2 = stringBuilder4.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder5 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append("(");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder6.append(this.non0Digit);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder8 = stringBuilder7.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder9 = stringBuilder8.append("?");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder10 = stringBuilder9.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder11 = stringBuilder10.append("?(");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder12 = stringBuilder11.append(this.groupSeparator);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder13 = stringBuilder12.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder14 = stringBuilder13.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder15 = stringBuilder14.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder16 = stringBuilder15.append(")+)");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string3 = stringBuilder16.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder17 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder18 = stringBuilder17.append("((");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder19 = stringBuilder18.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder20 = stringBuilder19.append("++)|");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder21 = stringBuilder20.append(string3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder22 = stringBuilder21.append(")");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string4 = stringBuilder22.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder23 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder24 = stringBuilder23.append("(");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder25 = stringBuilder24.append(string4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder26 = stringBuilder25.append("|");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder27 = stringBuilder26.append(string4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder28 = stringBuilder27.append(this.decimalSeparator);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder29 = stringBuilder28.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder30 = stringBuilder29.append("*+|");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder31 = stringBuilder30.append(this.decimalSeparator);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder32 = stringBuilder31.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder33 = stringBuilder32.append("++)");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string5 = stringBuilder33.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder34 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder35 = stringBuilder34.append("(NaN|");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder36 = stringBuilder35.append(this.nanString);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder37 = stringBuilder36.append("|Infinity|");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder38 = stringBuilder37.append(this.infinityString);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder39 = stringBuilder38.append(")");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string6 = stringBuilder39.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder40 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder41 = stringBuilder40.append("(");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder42 = stringBuilder41.append(this.positivePrefix);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder43 = stringBuilder42.append(string5);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder44 = stringBuilder43.append(this.positiveSuffix);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder45 = stringBuilder44.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder46 = stringBuilder45.append(")");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string7 = stringBuilder46.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder47 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder48 = stringBuilder47.append("(");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder49 = stringBuilder48.append(this.negativePrefix);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder50 = stringBuilder49.append(string5);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder51 = stringBuilder50.append(this.negativeSuffix);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder52 = stringBuilder51.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder53 = stringBuilder52.append(")");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string8 = stringBuilder53.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder54 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder55 = stringBuilder54.append("(([-+]?");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder56 = stringBuilder55.append(string5);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder57 = stringBuilder56.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder58 = stringBuilder57.append(")|");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder59 = stringBuilder58.append(string7);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder60 = stringBuilder59.append("|");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder61 = stringBuilder60.append(string8);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder62 = stringBuilder61.append(")");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string9 = stringBuilder62.toString();
        String string10 = "[-+]?0[xX][0-9a-fA-F]*\\.[0-9a-fA-F]+([pP][-+]?[0-9]+)?";
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder63 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder64 = stringBuilder63.append("(");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder65 = stringBuilder64.append(this.positivePrefix);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder66 = stringBuilder65.append(string6);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder67 = stringBuilder66.append(this.positiveSuffix);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder68 = stringBuilder67.append(")");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string11 = stringBuilder68.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder69 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder70 = stringBuilder69.append("(");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder71 = stringBuilder70.append(this.negativePrefix);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder72 = stringBuilder71.append(string6);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder73 = stringBuilder72.append(this.negativeSuffix);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder74 = stringBuilder73.append(")");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string12 = stringBuilder74.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder75 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder76 = stringBuilder75.append("(([-+]?");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder77 = stringBuilder76.append(string6);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder78 = stringBuilder77.append(")|");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder79 = stringBuilder78.append(string11);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder80 = stringBuilder79.append("|");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder81 = stringBuilder80.append(string12);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder82 = stringBuilder81.append(")");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string13 = stringBuilder82.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder83 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder84 = stringBuilder83.append(string9);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder85 = stringBuilder84.append("|");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder86 = stringBuilder85.append(string10);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder87 = stringBuilder86.append("|");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder88 = stringBuilder87.append(string13);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string14 = stringBuilder88.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.compile:(Ljava/lang/String;)Ljava/util/regex/Pattern;");
        this.floatPattern = Pattern.compile(string14);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.compile:(Ljava/lang/String;)Ljava/util/regex/Pattern;");
        this.decimalPattern = Pattern.compile(string9);
    }

    private Pattern floatPattern() {
        RuntimeCostAccounter.recordJump();
        if (this.floatPattern == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.buildFloatAndDecimalPattern:()V");
            this.buildFloatAndDecimalPattern();
        }
        return this.floatPattern;
    }

    private Pattern decimalPattern() {
        RuntimeCostAccounter.recordJump();
        if (this.decimalPattern == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.buildFloatAndDecimalPattern:()V");
            this.buildFloatAndDecimalPattern();
        }
        return this.decimalPattern;
    }

    private Scanner(Readable readable, Pattern pattern) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.sourceClosed = false;
        this.needInput = false;
        this.skipped = false;
        this.savedScannerPosition = -1;
        this.typeCache = null;
        this.matchValid = false;
        this.closed = false;
        this.radix = 10;
        this.defaultRadix = 10;
        this.locale = null;
        RuntimeCostAccounter.recordAllocation((String)"java/util/Scanner$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner$1.<init>:(Ljava/util/Scanner;I)V");
        this.patternCache = new LRUCache<String, Pattern>(7){
            {
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/LRUCache.<init>:(I)V");
                super(n);
            }

            protected Pattern create(String string) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.compile:(Ljava/lang/String;)Ljava/util/regex/Pattern;");
                return Pattern.compile(string);
            }

            protected boolean hasName(Pattern pattern, String string) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.pattern:()Ljava/lang/String;");
                String string2 = pattern.pattern();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                return string2.equals(string);
            }
        };
        this.groupSeparator = "\\,";
        this.decimalSeparator = "\\.";
        this.nanString = "NaN";
        this.infinityString = "Infinity";
        this.positivePrefix = "";
        this.negativePrefix = "\\-";
        this.positiveSuffix = "";
        this.negativeSuffix = "";
        this.digits = "0123456789abcdefghijklmnopqrstuvwxyz";
        this.non0Digit = "[\\p{javaDigit}&&[^0]]";
        this.SIMPLE_GROUP_INDEX = 5;
        RuntimeCostAccounter.recordJump();
        if (!$assertionsDisabled) {
            RuntimeCostAccounter.recordJump();
            if (readable == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                AssertionError assertionError = new AssertionError((Object)"source should not be null");
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (!$assertionsDisabled) {
            RuntimeCostAccounter.recordJump();
            if (pattern == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                AssertionError assertionError = new AssertionError((Object)"pattern should not be null");
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }
        this.source = readable;
        this.delimPattern = pattern;
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.allocate:(I)Ljava/nio/CharBuffer;");
        this.buf = CharBuffer.allocate((int)1024);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.limit:(I)Ljava/nio/Buffer;");
        this.buf.limit(0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.matcher:(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;");
        this.matcher = this.delimPattern.matcher((CharSequence)this.buf);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.useTransparentBounds:(Z)Ljava/util/regex/Matcher;");
        this.matcher.useTransparentBounds(true);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.useAnchoringBounds:(Z)Ljava/util/regex/Matcher;");
        this.matcher.useAnchoringBounds(false);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.useLocale:(Ljava/util/Locale;)Ljava/util/Scanner;");
        this.useLocale(locale);
    }

    public Scanner(Readable readable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.<init>:(Ljava/lang/Readable;Ljava/util/regex/Pattern;)V");
        this(Objects.requireNonNull(readable, "source"), WHITESPACE_PATTERN);
    }

    public Scanner(InputStream inputStream) {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InputStreamReader");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStreamReader.<init>:(Ljava/io/InputStream;)V");
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.<init>:(Ljava/lang/Readable;Ljava/util/regex/Pattern;)V");
        this(inputStreamReader, WHITESPACE_PATTERN);
    }

    public Scanner(InputStream inputStream, String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.toCharset:(Ljava/lang/String;)Ljava/nio/charset/Charset;");
        Charset charset = Scanner.toCharset(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.makeReadable:(Ljava/io/InputStream;Ljava/nio/charset/Charset;)Ljava/lang/Readable;");
        Readable readable = Scanner.makeReadable(Objects.requireNonNull(inputStream, "source"), charset);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.<init>:(Ljava/lang/Readable;Ljava/util/regex/Pattern;)V");
        this(readable, WHITESPACE_PATTERN);
    }

    private static Charset toCharset(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(string, "charsetName");
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/Charset.forName:(Ljava/lang/String;)Ljava/nio/charset/Charset;");
            return Charset.forName((String)string);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException throwable) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/Throwable;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(throwable);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
    }

    private static Readable makeReadable(InputStream inputStream, Charset charset) {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InputStreamReader");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStreamReader.<init>:(Ljava/io/InputStream;Ljava/nio/charset/Charset;)V");
        return new InputStreamReader(inputStream, charset);
    }

    public Scanner(File file) throws FileNotFoundException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/FileInputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.<init>:(Ljava/io/File;)V");
        FileInputStream fileInputStream = new FileInputStream(file);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.getChannel:()Ljava/nio/channels/FileChannel;");
        FileChannel fileChannel = fileInputStream.getChannel();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.<init>:(Ljava/nio/channels/ReadableByteChannel;)V");
        this((ReadableByteChannel)fileChannel);
    }

    public Scanner(File file, String string) throws FileNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.toDecoder:(Ljava/lang/String;)Ljava/nio/charset/CharsetDecoder;");
        CharsetDecoder charsetDecoder = Scanner.toDecoder(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.<init>:(Ljava/io/File;Ljava/nio/charset/CharsetDecoder;)V");
        this(Objects.requireNonNull(file), charsetDecoder);
    }

    private Scanner(File file, CharsetDecoder charsetDecoder) throws FileNotFoundException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/FileInputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.<init>:(Ljava/io/File;)V");
        FileInputStream fileInputStream = new FileInputStream(file);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.getChannel:()Ljava/nio/channels/FileChannel;");
        FileChannel fileChannel = fileInputStream.getChannel();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.makeReadable:(Ljava/nio/channels/ReadableByteChannel;Ljava/nio/charset/CharsetDecoder;)Ljava/lang/Readable;");
        Readable readable = Scanner.makeReadable((ReadableByteChannel)fileChannel, charsetDecoder);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.<init>:(Ljava/lang/Readable;)V");
        this(readable);
    }

    private static CharsetDecoder toDecoder(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(string, "charsetName");
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/Charset.forName:(Ljava/lang/String;)Ljava/nio/charset/Charset;");
            Charset charset = Charset.forName((String)string);
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/Charset.newDecoder:()Ljava/nio/charset/CharsetDecoder;");
            return charset.newDecoder();
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException throwable) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
    }

    private static Readable makeReadable(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder) {
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/channels/Channels.newReader:(Ljava/nio/channels/ReadableByteChannel;Ljava/nio/charset/CharsetDecoder;I)Ljava/io/Reader;");
        return Channels.newReader((ReadableByteChannel)readableByteChannel, (CharsetDecoder)charsetDecoder, (int)-1);
    }

    public Scanner(Path path) throws IOException {
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
        OpenOption[] openOptionArray = new OpenOption[]{};
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/file/Files.newInputStream:(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/InputStream;");
        InputStream inputStream = Files.newInputStream((Path)path, (OpenOption[])openOptionArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.<init>:(Ljava/io/InputStream;)V");
        this(inputStream);
    }

    public Scanner(Path path, String string) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.toCharset:(Ljava/lang/String;)Ljava/nio/charset/Charset;");
        Charset charset = Scanner.toCharset(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.<init>:(Ljava/nio/file/Path;Ljava/nio/charset/Charset;)V");
        this(Objects.requireNonNull(path), charset);
    }

    private Scanner(Path path, Charset charset) throws IOException {
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
        OpenOption[] openOptionArray = new OpenOption[]{};
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/file/Files.newInputStream:(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/InputStream;");
        InputStream inputStream = Files.newInputStream((Path)path, (OpenOption[])openOptionArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.makeReadable:(Ljava/io/InputStream;Ljava/nio/charset/Charset;)Ljava/lang/Readable;");
        Readable readable = Scanner.makeReadable(inputStream, charset);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.<init>:(Ljava/lang/Readable;)V");
        this(readable);
    }

    public Scanner(String string) {
        RuntimeCostAccounter.recordAllocation((String)"java/io/StringReader");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/StringReader.<init>:(Ljava/lang/String;)V");
        StringReader stringReader = new StringReader(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.<init>:(Ljava/lang/Readable;Ljava/util/regex/Pattern;)V");
        this(stringReader, WHITESPACE_PATTERN);
    }

    public Scanner(ReadableByteChannel readableByteChannel) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.makeReadable:(Ljava/nio/channels/ReadableByteChannel;)Ljava/lang/Readable;");
        Readable readable = Scanner.makeReadable(Objects.requireNonNull(readableByteChannel, "source"));
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.<init>:(Ljava/lang/Readable;Ljava/util/regex/Pattern;)V");
        this(readable, WHITESPACE_PATTERN);
    }

    private static Readable makeReadable(ReadableByteChannel readableByteChannel) {
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/Charset.defaultCharset:()Ljava/nio/charset/Charset;");
        Charset charset = Charset.defaultCharset();
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/Charset.newDecoder:()Ljava/nio/charset/CharsetDecoder;");
        CharsetDecoder charsetDecoder = charset.newDecoder();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.makeReadable:(Ljava/nio/channels/ReadableByteChannel;Ljava/nio/charset/CharsetDecoder;)Ljava/lang/Readable;");
        return Scanner.makeReadable(readableByteChannel, charsetDecoder);
    }

    public Scanner(ReadableByteChannel readableByteChannel, String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.toDecoder:(Ljava/lang/String;)Ljava/nio/charset/CharsetDecoder;");
        CharsetDecoder charsetDecoder = Scanner.toDecoder(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.makeReadable:(Ljava/nio/channels/ReadableByteChannel;Ljava/nio/charset/CharsetDecoder;)Ljava/lang/Readable;");
        Readable readable = Scanner.makeReadable(Objects.requireNonNull(readableByteChannel, "source"), charsetDecoder);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.<init>:(Ljava/lang/Readable;Ljava/util/regex/Pattern;)V");
        this(readable, WHITESPACE_PATTERN);
    }

    private void saveState() {
        this.savedScannerPosition = this.position;
    }

    private void revertState() {
        this.position = this.savedScannerPosition;
        this.savedScannerPosition = -1;
        this.skipped = false;
    }

    private boolean revertState(boolean bl) {
        this.position = this.savedScannerPosition;
        this.savedScannerPosition = -1;
        this.skipped = false;
        return bl;
    }

    private void cacheResult() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:()Ljava/lang/String;");
        this.hasNextResult = this.matcher.group();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.end:()I");
        this.hasNextPosition = this.matcher.end();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.pattern:()Ljava/util/regex/Pattern;");
        this.hasNextPattern = this.matcher.pattern();
    }

    private void cacheResult(String string) {
        this.hasNextResult = string;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.end:()I");
        this.hasNextPosition = this.matcher.end();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.pattern:()Ljava/util/regex/Pattern;");
        this.hasNextPattern = this.matcher.pattern();
    }

    private void clearCaches() {
        this.hasNextPattern = null;
        this.typeCache = null;
    }

    private String getCachedResult() {
        this.position = this.hasNextPosition;
        this.hasNextPattern = null;
        this.typeCache = null;
        return this.hasNextResult;
    }

    private void useTypeCache() {
        RuntimeCostAccounter.recordJump();
        if (this.closed) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException("Scanner closed");
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        this.position = this.hasNextPosition;
        this.hasNextPattern = null;
        this.typeCache = null;
    }

    private void readInput() {
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.limit:()I");
        int n = this.buf.limit();
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.capacity:()I");
        int n2 = this.buf.capacity();
        RuntimeCostAccounter.recordJump();
        if (n == n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.makeSpace:()Z");
            this.makeSpace();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.position:()I");
        int n3 = this.buf.position();
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.limit:()I");
        int n4 = this.buf.limit();
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.position:(I)Ljava/nio/Buffer;");
        this.buf.position(n4);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.capacity:()I");
        int n5 = this.buf.capacity();
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.limit:(I)Ljava/nio/Buffer;");
        this.buf.limit(n5);
        int n6 = 0;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Readable.read:(Ljava/nio/CharBuffer;)I");
            n6 = this.source.read(this.buf);
        }
        catch (IOException iOException) {
            this.lastException = iOException;
            n6 = -1;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordJump();
        if (n6 == -1) {
            this.sourceClosed = true;
            this.needInput = false;
        }
        RuntimeCostAccounter.recordJump();
        if (n6 > 0) {
            this.needInput = false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.position:()I");
        int n7 = this.buf.position();
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.limit:(I)Ljava/nio/Buffer;");
        this.buf.limit(n7);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.position:(I)Ljava/nio/Buffer;");
        this.buf.position(n3);
    }

    private boolean makeSpace() {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        RuntimeCostAccounter.recordJump();
        if (this.savedScannerPosition == -1) {
            n = this.position;
            RuntimeCostAccounter.recordJump();
        } else {
            n = this.savedScannerPosition;
        }
        int n2 = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.position:(I)Ljava/nio/Buffer;");
        this.buf.position(n2);
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.compact:()Ljava/nio/CharBuffer;");
            this.buf.compact();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.translateSavedIndexes:(I)V");
            this.translateSavedIndexes(n2);
            this.position -= n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.flip:()Ljava/nio/Buffer;");
            this.buf.flip();
            return true;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.capacity:()I");
        int n3 = this.buf.capacity() * 2;
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.allocate:(I)Ljava/nio/CharBuffer;");
        CharBuffer charBuffer = CharBuffer.allocate((int)n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.put:(Ljava/nio/CharBuffer;)Ljava/nio/CharBuffer;");
        charBuffer.put(this.buf);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.flip:()Ljava/nio/Buffer;");
        charBuffer.flip();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.translateSavedIndexes:(I)V");
        this.translateSavedIndexes(n2);
        this.position -= n2;
        this.buf = charBuffer;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.reset:(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;");
        this.matcher.reset((CharSequence)this.buf);
        return true;
    }

    private void translateSavedIndexes(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.savedScannerPosition != -1) {
            this.savedScannerPosition -= n;
        }
    }

    private void throwFor() {
        this.skipped = false;
        RuntimeCostAccounter.recordJump();
        if (this.sourceClosed) {
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.limit:()I");
            int n = this.buf.limit();
            RuntimeCostAccounter.recordJump();
            if (this.position == n) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/InputMismatchException");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/InputMismatchException.<init>:()V");
        InputMismatchException inputMismatchException = new InputMismatchException();
        RuntimeCostAccounter.recordThrow();
        throw inputMismatchException;
    }

    private boolean hasTokenInBuffer() {
        this.matchValid = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.usePattern:(Ljava/util/regex/Pattern;)Ljava/util/regex/Matcher;");
        this.matcher.usePattern(this.delimPattern);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.limit:()I");
        int n = this.buf.limit();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.region:(II)Ljava/util/regex/Matcher;");
        this.matcher.region(this.position, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.lookingAt:()Z");
        boolean bl = this.matcher.lookingAt();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.end:()I");
            this.position = this.matcher.end();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.limit:()I");
        int n2 = this.buf.limit();
        RuntimeCostAccounter.recordJump();
        return this.position != n2;
    }

    private String getCompleteTokenInBuffer(Pattern pattern) {
        this.matchValid = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.usePattern:(Ljava/util/regex/Pattern;)Ljava/util/regex/Matcher;");
        this.matcher.usePattern(this.delimPattern);
        RuntimeCostAccounter.recordJump();
        if (!this.skipped) {
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.limit:()I");
            int n = this.buf.limit();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.region:(II)Ljava/util/regex/Matcher;");
            this.matcher.region(this.position, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.lookingAt:()Z");
            boolean bl = this.matcher.lookingAt();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.hitEnd:()Z");
                boolean bl2 = this.matcher.hitEnd();
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordJump();
                    if (!this.sourceClosed) {
                        this.needInput = true;
                        return null;
                    }
                }
                this.skipped = true;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.end:()I");
                this.position = this.matcher.end();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.limit:()I");
        int n = this.buf.limit();
        RuntimeCostAccounter.recordJump();
        if (this.position == n) {
            RuntimeCostAccounter.recordJump();
            if (this.sourceClosed) {
                return null;
            }
            this.needInput = true;
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.limit:()I");
        int n2 = this.buf.limit();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.region:(II)Ljava/util/regex/Matcher;");
        this.matcher.region(this.position, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.find:()Z");
        boolean bl = this.matcher.find();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.end:()I");
            int n3 = this.matcher.end();
            RuntimeCostAccounter.recordJump();
            if (n3 == this.position) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.find:()Z");
                bl = this.matcher.find();
            }
        }
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.requireEnd:()Z");
            boolean bl3 = this.matcher.requireEnd();
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                RuntimeCostAccounter.recordJump();
                if (!this.sourceClosed) {
                    this.needInput = true;
                    return null;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.start:()I");
            int n4 = this.matcher.start();
            RuntimeCostAccounter.recordJump();
            if (pattern == null) {
                pattern = FIND_ANY_PATTERN;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.usePattern:(Ljava/util/regex/Pattern;)Ljava/util/regex/Matcher;");
            this.matcher.usePattern(pattern);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.region:(II)Ljava/util/regex/Matcher;");
            this.matcher.region(this.position, n4);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.matches:()Z");
            boolean bl4 = this.matcher.matches();
            RuntimeCostAccounter.recordJump();
            if (bl4) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:()Ljava/lang/String;");
                String string = this.matcher.group();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.end:()I");
                this.position = this.matcher.end();
                return string;
            }
            return null;
        }
        RuntimeCostAccounter.recordJump();
        if (this.sourceClosed) {
            RuntimeCostAccounter.recordJump();
            if (pattern == null) {
                pattern = FIND_ANY_PATTERN;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.usePattern:(Ljava/util/regex/Pattern;)Ljava/util/regex/Matcher;");
            this.matcher.usePattern(pattern);
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.limit:()I");
            int n5 = this.buf.limit();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.region:(II)Ljava/util/regex/Matcher;");
            this.matcher.region(this.position, n5);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.matches:()Z");
            boolean bl5 = this.matcher.matches();
            RuntimeCostAccounter.recordJump();
            if (bl5) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:()Ljava/lang/String;");
                String string = this.matcher.group();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.end:()I");
                this.position = this.matcher.end();
                return string;
            }
            return null;
        }
        this.needInput = true;
        return null;
    }

    private String findPatternInBuffer(Pattern pattern, int n) {
        block13: {
            block12: {
                this.matchValid = false;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.usePattern:(Ljava/util/regex/Pattern;)Ljava/util/regex/Matcher;");
                this.matcher.usePattern(pattern);
                RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.limit:()I");
                int n2 = this.buf.limit();
                int n3 = -1;
                int n4 = n2;
                RuntimeCostAccounter.recordJump();
                if (n > 0) {
                    n3 = this.position + n;
                    RuntimeCostAccounter.recordJump();
                    if (n3 < n2) {
                        n4 = n3;
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.region:(II)Ljava/util/regex/Matcher;");
                this.matcher.region(this.position, n4);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.find:()Z");
                boolean bl = this.matcher.find();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.hitEnd:()Z");
                    boolean bl2 = this.matcher.hitEnd();
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        RuntimeCostAccounter.recordJump();
                        if (!this.sourceClosed) {
                            RuntimeCostAccounter.recordJump();
                            if (n4 != n3) {
                                this.needInput = true;
                                return null;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (n4 == n3) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.requireEnd:()Z");
                                boolean bl3 = this.matcher.requireEnd();
                                RuntimeCostAccounter.recordJump();
                                if (bl3) {
                                    this.needInput = true;
                                    return null;
                                }
                            }
                        }
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.end:()I");
                    this.position = this.matcher.end();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:()Ljava/lang/String;");
                    return this.matcher.group();
                }
                RuntimeCostAccounter.recordJump();
                if (this.sourceClosed) {
                    return null;
                }
                RuntimeCostAccounter.recordJump();
                if (n == 0) break block12;
                RuntimeCostAccounter.recordJump();
                if (n4 == n3) break block13;
            }
            this.needInput = true;
        }
        return null;
    }

    private String matchPatternInBuffer(Pattern pattern) {
        this.matchValid = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.usePattern:(Ljava/util/regex/Pattern;)Ljava/util/regex/Matcher;");
        this.matcher.usePattern(pattern);
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.limit:()I");
        int n = this.buf.limit();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.region:(II)Ljava/util/regex/Matcher;");
        this.matcher.region(this.position, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.lookingAt:()Z");
        boolean bl = this.matcher.lookingAt();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.hitEnd:()Z");
            boolean bl2 = this.matcher.hitEnd();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordJump();
                if (!this.sourceClosed) {
                    this.needInput = true;
                    return null;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.end:()I");
            this.position = this.matcher.end();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:()Ljava/lang/String;");
            return this.matcher.group();
        }
        RuntimeCostAccounter.recordJump();
        if (this.sourceClosed) {
            return null;
        }
        this.needInput = true;
        return null;
    }

    private void ensureOpen() {
        RuntimeCostAccounter.recordJump();
        if (this.closed) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException("Scanner closed");
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
    }

    @Override
    public void close() {
        RuntimeCostAccounter.recordJump();
        if (this.closed) {
            return;
        }
        boolean bl = this.source instanceof Closeable;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            try {
                Closeable closeable = (Closeable)((Object)this.source);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Closeable.close:()V");
                closeable.close();
            }
            catch (IOException iOException) {
                this.lastException = iOException;
            }
            RuntimeCostAccounter.recordJump();
        }
        this.sourceClosed = true;
        this.source = null;
        this.closed = true;
    }

    public IOException ioException() {
        return this.lastException;
    }

    public Pattern delimiter() {
        return this.delimPattern;
    }

    public Scanner useDelimiter(Pattern pattern) {
        this.delimPattern = pattern;
        return this;
    }

    public Scanner useDelimiter(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/LRUCache.forName:(Ljava/lang/Object;)Ljava/lang/Object;");
        this.delimPattern = (Pattern)this.patternCache.forName((Object)string);
        return this;
    }

    public Locale locale() {
        return this.locale;
    }

    public Scanner useLocale(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.equals:(Ljava/lang/Object;)Z");
        boolean bl = locale.equals(this.locale);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return this;
        }
        this.locale = locale;
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.getNumberInstance:(Ljava/util/Locale;)Ljava/text/NumberFormat;");
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DecimalFormatSymbols.getInstance:(Ljava/util/Locale;)Ljava/text/DecimalFormatSymbols;");
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("\\");
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DecimalFormatSymbols.getGroupingSeparator:()C");
        char c = decimalFormatSymbols.getGroupingSeparator();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(c);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        this.groupSeparator = stringBuilder3.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder4 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append("\\");
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DecimalFormatSymbols.getDecimalSeparator:()C");
        char c2 = decimalFormatSymbols.getDecimalSeparator();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(c2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        this.decimalSeparator = stringBuilder6.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder7 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder8 = stringBuilder7.append("\\Q");
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DecimalFormatSymbols.getNaN:()Ljava/lang/String;");
        String string = decimalFormatSymbols.getNaN();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder9 = stringBuilder8.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder10 = stringBuilder9.append("\\E");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        this.nanString = stringBuilder10.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder11 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder12 = stringBuilder11.append("\\Q");
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DecimalFormatSymbols.getInfinity:()Ljava/lang/String;");
        String string2 = decimalFormatSymbols.getInfinity();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder13 = stringBuilder12.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder14 = stringBuilder13.append("\\E");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        this.infinityString = stringBuilder14.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DecimalFormat.getPositivePrefix:()Ljava/lang/String;");
        this.positivePrefix = decimalFormat.getPositivePrefix();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n = this.positivePrefix.length();
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder15 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder16 = stringBuilder15.append("\\Q");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder17 = stringBuilder16.append(this.positivePrefix);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder18 = stringBuilder17.append("\\E");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            this.positivePrefix = stringBuilder18.toString();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DecimalFormat.getNegativePrefix:()Ljava/lang/String;");
        this.negativePrefix = decimalFormat.getNegativePrefix();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n2 = this.negativePrefix.length();
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder19 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder20 = stringBuilder19.append("\\Q");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder21 = stringBuilder20.append(this.negativePrefix);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder22 = stringBuilder21.append("\\E");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            this.negativePrefix = stringBuilder22.toString();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DecimalFormat.getPositiveSuffix:()Ljava/lang/String;");
        this.positiveSuffix = decimalFormat.getPositiveSuffix();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n3 = this.positiveSuffix.length();
        RuntimeCostAccounter.recordJump();
        if (n3 > 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder23 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder24 = stringBuilder23.append("\\Q");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder25 = stringBuilder24.append(this.positiveSuffix);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder26 = stringBuilder25.append("\\E");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            this.positiveSuffix = stringBuilder26.toString();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DecimalFormat.getNegativeSuffix:()Ljava/lang/String;");
        this.negativeSuffix = decimalFormat.getNegativeSuffix();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n4 = this.negativeSuffix.length();
        RuntimeCostAccounter.recordJump();
        if (n4 > 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder27 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder28 = stringBuilder27.append("\\Q");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder29 = stringBuilder28.append(this.negativeSuffix);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder30 = stringBuilder29.append("\\E");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            this.negativeSuffix = stringBuilder30.toString();
        }
        this.integerPattern = null;
        this.floatPattern = null;
        return this;
    }

    public int radix() {
        return this.defaultRadix;
    }

    public Scanner useRadix(int n) {
        block5: {
            block4: {
                RuntimeCostAccounter.recordJump();
                if (n < 2) break block4;
                RuntimeCostAccounter.recordJump();
                if (n <= 36) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("radix:");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.defaultRadix == n) {
            return this;
        }
        this.defaultRadix = n;
        this.integerPattern = null;
        return this;
    }

    private void setRadix(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.radix != n) {
            this.integerPattern = null;
            this.radix = n;
        }
    }

    public MatchResult match() {
        RuntimeCostAccounter.recordJump();
        if (!this.matchValid) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException("No match result available");
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.toMatchResult:()Ljava/util/regex/MatchResult;");
        return this.matcher.toMatchResult();
    }

    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append("java.util.Scanner");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder2 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append("[delimiters=");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(this.delimPattern);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string = stringBuilder5.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(string);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder6 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder6.append("[position=");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder8 = stringBuilder7.append(this.position);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder9 = stringBuilder8.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string2 = stringBuilder9.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(string2);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder10 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder11 = stringBuilder10.append("[match valid=");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Z)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder12 = stringBuilder11.append(this.matchValid);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder13 = stringBuilder12.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string3 = stringBuilder13.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(string3);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder14 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder15 = stringBuilder14.append("[need input=");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Z)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder16 = stringBuilder15.append(this.needInput);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder17 = stringBuilder16.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string4 = stringBuilder17.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(string4);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder18 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder19 = stringBuilder18.append("[source closed=");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Z)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder20 = stringBuilder19.append(this.sourceClosed);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder21 = stringBuilder20.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string5 = stringBuilder21.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(string5);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder22 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder23 = stringBuilder22.append("[skipped=");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Z)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder24 = stringBuilder23.append(this.skipped);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder25 = stringBuilder24.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string6 = stringBuilder25.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(string6);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder26 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder27 = stringBuilder26.append("[group separator=");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder28 = stringBuilder27.append(this.groupSeparator);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder29 = stringBuilder28.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string7 = stringBuilder29.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(string7);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder30 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder31 = stringBuilder30.append("[decimal separator=");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder32 = stringBuilder31.append(this.decimalSeparator);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder33 = stringBuilder32.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string8 = stringBuilder33.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(string8);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder34 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder35 = stringBuilder34.append("[positive prefix=");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder36 = stringBuilder35.append(this.positivePrefix);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder37 = stringBuilder36.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string9 = stringBuilder37.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(string9);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder38 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder39 = stringBuilder38.append("[negative prefix=");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder40 = stringBuilder39.append(this.negativePrefix);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder41 = stringBuilder40.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string10 = stringBuilder41.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(string10);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder42 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder43 = stringBuilder42.append("[positive suffix=");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder44 = stringBuilder43.append(this.positiveSuffix);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder45 = stringBuilder44.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string11 = stringBuilder45.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(string11);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder46 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder47 = stringBuilder46.append("[negative suffix=");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder48 = stringBuilder47.append(this.negativeSuffix);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder49 = stringBuilder48.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string12 = stringBuilder49.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(string12);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder50 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder51 = stringBuilder50.append("[NaN string=");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder52 = stringBuilder51.append(this.nanString);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder53 = stringBuilder52.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string13 = stringBuilder53.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(string13);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder54 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder55 = stringBuilder54.append("[infinity string=");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder56 = stringBuilder55.append(this.infinityString);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder57 = stringBuilder56.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string14 = stringBuilder57.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder.append(string14);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder.toString();
    }

    @Override
    public boolean hasNext() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.saveState:()V");
        this.saveState();
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (this.sourceClosed) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasTokenInBuffer:()Z");
            boolean bl = this.hasTokenInBuffer();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.revertState:(Z)Z");
                return this.revertState(true);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.readInput:()V");
            this.readInput();
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasTokenInBuffer:()Z");
        boolean bl = this.hasTokenInBuffer();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.revertState:(Z)Z");
        return this.revertState(bl);
    }

    @Override
    public String next() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.getCompleteTokenInBuffer:(Ljava/util/regex/Pattern;)Ljava/lang/String;");
            String string = this.getCompleteTokenInBuffer(null);
            RuntimeCostAccounter.recordJump();
            if (string != null) {
                this.matchValid = true;
                this.skipped = false;
                return string;
            }
            RuntimeCostAccounter.recordJump();
            if (this.needInput) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.readInput:()V");
                this.readInput();
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.throwFor:()V");
                this.throwFor();
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public void remove() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
        RuntimeCostAccounter.recordThrow();
        throw unsupportedOperationException;
    }

    public boolean hasNext(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/LRUCache.forName:(Ljava/lang/Object;)Ljava/lang/Object;");
        Pattern pattern = (Pattern)this.patternCache.forName((Object)string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasNext:(Ljava/util/regex/Pattern;)Z");
        return this.hasNext(pattern);
    }

    public String next(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/LRUCache.forName:(Ljava/lang/Object;)Ljava/lang/Object;");
        Pattern pattern = (Pattern)this.patternCache.forName((Object)string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.next:(Ljava/util/regex/Pattern;)Ljava/lang/String;");
        return this.next(pattern);
    }

    public boolean hasNext(Pattern pattern) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordJump();
        if (pattern == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        this.hasNextPattern = null;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.saveState:()V");
        this.saveState();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.getCompleteTokenInBuffer:(Ljava/util/regex/Pattern;)Ljava/lang/String;");
            String string = this.getCompleteTokenInBuffer(pattern);
            RuntimeCostAccounter.recordJump();
            if (string != null) {
                this.matchValid = true;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.cacheResult:()V");
                this.cacheResult();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.revertState:(Z)Z");
                return this.revertState(true);
            }
            RuntimeCostAccounter.recordJump();
            if (!this.needInput) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.readInput:()V");
            this.readInput();
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.revertState:(Z)Z");
        return this.revertState(false);
    }

    public String next(Pattern pattern) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordJump();
        if (pattern == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.hasNextPattern == pattern) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.getCachedResult:()Ljava/lang/String;");
            return this.getCachedResult();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.getCompleteTokenInBuffer:(Ljava/util/regex/Pattern;)Ljava/lang/String;");
            String string = this.getCompleteTokenInBuffer(pattern);
            RuntimeCostAccounter.recordJump();
            if (string != null) {
                this.matchValid = true;
                this.skipped = false;
                return string;
            }
            RuntimeCostAccounter.recordJump();
            if (this.needInput) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.readInput:()V");
                this.readInput();
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.throwFor:()V");
                this.throwFor();
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    public boolean hasNextLine() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.saveState:()V");
        this.saveState();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.linePattern:()Ljava/util/regex/Pattern;");
        Pattern pattern = Scanner.linePattern();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.findWithinHorizon:(Ljava/util/regex/Pattern;I)Ljava/lang/String;");
        String string = this.findWithinHorizon(pattern, 0);
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.match:()Ljava/util/regex/MatchResult;");
            MatchResult matchResult = this.match();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/MatchResult.group:(I)Ljava/lang/String;");
            String string2 = matchResult.group(1);
            RuntimeCostAccounter.recordJump();
            if (string2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n = string.length();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n2 = n - string2.length();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
                string = string.substring(0, n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.cacheResult:(Ljava/lang/String;)V");
                this.cacheResult(string);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.cacheResult:()V");
                this.cacheResult();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.revertState:()V");
        this.revertState();
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public String nextLine() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.linePattern:()Ljava/util/regex/Pattern;");
        Pattern pattern = Scanner.linePattern();
        RuntimeCostAccounter.recordJump();
        if (this.hasNextPattern == pattern) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.getCachedResult:()Ljava/lang/String;");
            return this.getCachedResult();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.findWithinHorizon:(Ljava/util/regex/Pattern;I)Ljava/lang/String;");
        String string = this.findWithinHorizon(linePattern, 0);
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:(Ljava/lang/String;)V");
            NoSuchElementException noSuchElementException = new NoSuchElementException("No line found");
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.match:()Ljava/util/regex/MatchResult;");
        MatchResult matchResult = this.match();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/MatchResult.group:(I)Ljava/lang/String;");
        String string2 = matchResult.group(1);
        RuntimeCostAccounter.recordJump();
        if (string2 != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n = string.length();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n2 = n - string2.length();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
            string = string.substring(0, n2);
        }
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        return string;
    }

    public String findInLine(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/LRUCache.forName:(Ljava/lang/Object;)Ljava/lang/Object;");
        Pattern pattern = (Pattern)this.patternCache.forName((Object)string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.findInLine:(Ljava/util/regex/Pattern;)Ljava/lang/String;");
        return this.findInLine(pattern);
    }

    public String findInLine(Pattern pattern) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordJump();
        if (pattern == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        int n = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.saveState:()V");
        this.saveState();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.separatorPattern:()Ljava/util/regex/Pattern;");
            Pattern pattern2 = Scanner.separatorPattern();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.findPatternInBuffer:(Ljava/util/regex/Pattern;I)Ljava/lang/String;");
            String string = this.findPatternInBuffer(pattern2, 0);
            RuntimeCostAccounter.recordJump();
            if (string != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.start:()I");
                n = this.matcher.start();
                RuntimeCostAccounter.recordJump();
                break;
            }
            RuntimeCostAccounter.recordJump();
            if (!this.needInput) {
                RuntimeCostAccounter.recordMethodCall((String)"java/nio/CharBuffer.limit:()I");
                n = this.buf.limit();
                RuntimeCostAccounter.recordJump();
                break;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.readInput:()V");
            this.readInput();
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.revertState:()V");
        this.revertState();
        int n2 = n - this.position;
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.findWithinHorizon:(Ljava/util/regex/Pattern;I)Ljava/lang/String;");
        return this.findWithinHorizon(pattern, n2);
    }

    public String findWithinHorizon(String string, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/LRUCache.forName:(Ljava/lang/Object;)Ljava/lang/Object;");
        Pattern pattern = (Pattern)this.patternCache.forName((Object)string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.findWithinHorizon:(Ljava/util/regex/Pattern;I)Ljava/lang/String;");
        return this.findWithinHorizon(pattern, n);
    }

    public String findWithinHorizon(Pattern pattern, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordJump();
        if (pattern == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("horizon < 0");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.findPatternInBuffer:(Ljava/util/regex/Pattern;I)Ljava/lang/String;");
            String string = this.findPatternInBuffer(pattern, n);
            RuntimeCostAccounter.recordJump();
            if (string != null) {
                this.matchValid = true;
                return string;
            }
            RuntimeCostAccounter.recordJump();
            if (!this.needInput) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.readInput:()V");
            this.readInput();
            RuntimeCostAccounter.recordJump();
        }
        return null;
    }

    public Scanner skip(Pattern pattern) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordJump();
        if (pattern == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.matchPatternInBuffer:(Ljava/util/regex/Pattern;)Ljava/lang/String;");
            String string = this.matchPatternInBuffer(pattern);
            RuntimeCostAccounter.recordJump();
            if (string != null) {
                this.matchValid = true;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.end:()I");
                this.position = this.matcher.end();
                return this;
            }
            RuntimeCostAccounter.recordJump();
            if (!this.needInput) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.readInput:()V");
            this.readInput();
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordJump();
        }
    }

    public Scanner skip(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/LRUCache.forName:(Ljava/lang/Object;)Ljava/lang/Object;");
        Pattern pattern = (Pattern)this.patternCache.forName((Object)string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.skip:(Ljava/util/regex/Pattern;)Ljava/util/Scanner;");
        return this.skip(pattern);
    }

    public boolean hasNextBoolean() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.boolPattern:()Ljava/util/regex/Pattern;");
        Pattern pattern = Scanner.boolPattern();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasNext:(Ljava/util/regex/Pattern;)Z");
        return this.hasNext(pattern);
    }

    public boolean nextBoolean() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.boolPattern:()Ljava/util/regex/Pattern;");
        Pattern pattern = Scanner.boolPattern();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.next:(Ljava/util/regex/Pattern;)Ljava/lang/String;");
        String string = this.next(pattern);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Boolean.parseBoolean:(Ljava/lang/String;)Z");
        return Boolean.parseBoolean(string);
    }

    public boolean hasNextByte() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasNextByte:(I)Z");
        return this.hasNextByte(this.defaultRadix);
    }

    public boolean hasNextByte(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.setRadix:(I)V");
        this.setRadix(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.integerPattern:()Ljava/util/regex/Pattern;");
        Pattern pattern = this.integerPattern();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasNext:(Ljava/util/regex/Pattern;)Z");
        boolean bl = this.hasNext(pattern);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            try {
                String string;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                String string2 = this.matcher.group(this.SIMPLE_GROUP_INDEX);
                RuntimeCostAccounter.recordJump();
                if (string2 == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.processIntegerToken:(Ljava/lang/String;)Ljava/lang/String;");
                    string = this.processIntegerToken(this.hasNextResult);
                    RuntimeCostAccounter.recordJump();
                } else {
                    string = this.hasNextResult;
                }
                String string3 = string;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Byte.parseByte:(Ljava/lang/String;I)B");
                byte by = Byte.parseByte(string3, n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Byte.valueOf:(B)Ljava/lang/Byte;");
                this.typeCache = by;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            RuntimeCostAccounter.recordJump();
        }
        return bl;
    }

    public byte nextByte() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.nextByte:(I)B");
        return this.nextByte(this.defaultRadix);
    }

    public byte nextByte(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.typeCache != null) {
            boolean bl = this.typeCache instanceof Byte;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordJump();
                if (this.radix == n) {
                    Byte by = (Byte)this.typeCache;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Byte.byteValue:()B");
                    byte by2 = by;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.useTypeCache:()V");
                    this.useTypeCache();
                    return by2;
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.setRadix:(I)V");
        this.setRadix(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.integerPattern:()Ljava/util/regex/Pattern;");
            Pattern pattern = this.integerPattern();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.next:(Ljava/util/regex/Pattern;)Ljava/lang/String;");
            String string = this.next(pattern);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
            String string2 = this.matcher.group(this.SIMPLE_GROUP_INDEX);
            RuntimeCostAccounter.recordJump();
            if (string2 == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.processIntegerToken:(Ljava/lang/String;)Ljava/lang/String;");
                string = this.processIntegerToken(string);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Byte.parseByte:(Ljava/lang/String;I)B");
            return Byte.parseByte(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.start:()I");
            this.position = this.matcher.start();
            RuntimeCostAccounter.recordAllocation((String)"java/util/InputMismatchException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.getMessage:()Ljava/lang/String;");
            String string = numberFormatException.getMessage();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/InputMismatchException.<init>:(Ljava/lang/String;)V");
            InputMismatchException inputMismatchException = new InputMismatchException(string);
            RuntimeCostAccounter.recordThrow();
            throw inputMismatchException;
        }
    }

    public boolean hasNextShort() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasNextShort:(I)Z");
        return this.hasNextShort(this.defaultRadix);
    }

    public boolean hasNextShort(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.setRadix:(I)V");
        this.setRadix(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.integerPattern:()Ljava/util/regex/Pattern;");
        Pattern pattern = this.integerPattern();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasNext:(Ljava/util/regex/Pattern;)Z");
        boolean bl = this.hasNext(pattern);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            try {
                String string;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                String string2 = this.matcher.group(this.SIMPLE_GROUP_INDEX);
                RuntimeCostAccounter.recordJump();
                if (string2 == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.processIntegerToken:(Ljava/lang/String;)Ljava/lang/String;");
                    string = this.processIntegerToken(this.hasNextResult);
                    RuntimeCostAccounter.recordJump();
                } else {
                    string = this.hasNextResult;
                }
                String string3 = string;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Short.parseShort:(Ljava/lang/String;I)S");
                short s = Short.parseShort(string3, n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Short.valueOf:(S)Ljava/lang/Short;");
                this.typeCache = s;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            RuntimeCostAccounter.recordJump();
        }
        return bl;
    }

    public short nextShort() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.nextShort:(I)S");
        return this.nextShort(this.defaultRadix);
    }

    public short nextShort(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.typeCache != null) {
            boolean bl = this.typeCache instanceof Short;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordJump();
                if (this.radix == n) {
                    Short s = (Short)this.typeCache;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Short.shortValue:()S");
                    short s2 = s;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.useTypeCache:()V");
                    this.useTypeCache();
                    return s2;
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.setRadix:(I)V");
        this.setRadix(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.integerPattern:()Ljava/util/regex/Pattern;");
            Pattern pattern = this.integerPattern();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.next:(Ljava/util/regex/Pattern;)Ljava/lang/String;");
            String string = this.next(pattern);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
            String string2 = this.matcher.group(this.SIMPLE_GROUP_INDEX);
            RuntimeCostAccounter.recordJump();
            if (string2 == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.processIntegerToken:(Ljava/lang/String;)Ljava/lang/String;");
                string = this.processIntegerToken(string);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Short.parseShort:(Ljava/lang/String;I)S");
            return Short.parseShort(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.start:()I");
            this.position = this.matcher.start();
            RuntimeCostAccounter.recordAllocation((String)"java/util/InputMismatchException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.getMessage:()Ljava/lang/String;");
            String string = numberFormatException.getMessage();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/InputMismatchException.<init>:(Ljava/lang/String;)V");
            InputMismatchException inputMismatchException = new InputMismatchException(string);
            RuntimeCostAccounter.recordThrow();
            throw inputMismatchException;
        }
    }

    public boolean hasNextInt() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasNextInt:(I)Z");
        return this.hasNextInt(this.defaultRadix);
    }

    public boolean hasNextInt(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.setRadix:(I)V");
        this.setRadix(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.integerPattern:()Ljava/util/regex/Pattern;");
        Pattern pattern = this.integerPattern();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasNext:(Ljava/util/regex/Pattern;)Z");
        boolean bl = this.hasNext(pattern);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            try {
                String string;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                String string2 = this.matcher.group(this.SIMPLE_GROUP_INDEX);
                RuntimeCostAccounter.recordJump();
                if (string2 == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.processIntegerToken:(Ljava/lang/String;)Ljava/lang/String;");
                    string = this.processIntegerToken(this.hasNextResult);
                    RuntimeCostAccounter.recordJump();
                } else {
                    string = this.hasNextResult;
                }
                String string3 = string;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.parseInt:(Ljava/lang/String;I)I");
                int n2 = Integer.parseInt(string3, n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                this.typeCache = n2;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            RuntimeCostAccounter.recordJump();
        }
        return bl;
    }

    private String processIntegerToken(String string) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(this.groupSeparator);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string2 = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.replaceAll:(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        String string3 = string.replaceAll(string2, "");
        boolean bl = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n = this.negativePrefix.length();
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
            boolean bl2 = string3.startsWith(this.negativePrefix);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                bl = true;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
                string3 = string3.substring(n);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n2 = this.negativeSuffix.length();
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.endsWith:(Ljava/lang/String;)Z");
            boolean bl3 = string3.endsWith(this.negativeSuffix);
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                bl = true;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n3 = string3.length() - n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n4 = string3.length();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
                string3 = string3.substring(n3, n4);
            }
        }
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder4 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append("-");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append(string3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            string3 = stringBuilder6.toString();
        }
        return string3;
    }

    public int nextInt() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.nextInt:(I)I");
        return this.nextInt(this.defaultRadix);
    }

    public int nextInt(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.typeCache != null) {
            boolean bl = this.typeCache instanceof Integer;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordJump();
                if (this.radix == n) {
                    Integer n2 = (Integer)this.typeCache;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                    int n3 = n2;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.useTypeCache:()V");
                    this.useTypeCache();
                    return n3;
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.setRadix:(I)V");
        this.setRadix(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.integerPattern:()Ljava/util/regex/Pattern;");
            Pattern pattern = this.integerPattern();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.next:(Ljava/util/regex/Pattern;)Ljava/lang/String;");
            String string = this.next(pattern);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
            String string2 = this.matcher.group(this.SIMPLE_GROUP_INDEX);
            RuntimeCostAccounter.recordJump();
            if (string2 == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.processIntegerToken:(Ljava/lang/String;)Ljava/lang/String;");
                string = this.processIntegerToken(string);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.parseInt:(Ljava/lang/String;I)I");
            return Integer.parseInt(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.start:()I");
            this.position = this.matcher.start();
            RuntimeCostAccounter.recordAllocation((String)"java/util/InputMismatchException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.getMessage:()Ljava/lang/String;");
            String string = numberFormatException.getMessage();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/InputMismatchException.<init>:(Ljava/lang/String;)V");
            InputMismatchException inputMismatchException = new InputMismatchException(string);
            RuntimeCostAccounter.recordThrow();
            throw inputMismatchException;
        }
    }

    public boolean hasNextLong() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasNextLong:(I)Z");
        return this.hasNextLong(this.defaultRadix);
    }

    public boolean hasNextLong(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.setRadix:(I)V");
        this.setRadix(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.integerPattern:()Ljava/util/regex/Pattern;");
        Pattern pattern = this.integerPattern();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasNext:(Ljava/util/regex/Pattern;)Z");
        boolean bl = this.hasNext(pattern);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            try {
                String string;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                String string2 = this.matcher.group(this.SIMPLE_GROUP_INDEX);
                RuntimeCostAccounter.recordJump();
                if (string2 == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.processIntegerToken:(Ljava/lang/String;)Ljava/lang/String;");
                    string = this.processIntegerToken(this.hasNextResult);
                    RuntimeCostAccounter.recordJump();
                } else {
                    string = this.hasNextResult;
                }
                String string3 = string;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.parseLong:(Ljava/lang/String;I)J");
                long l = Long.parseLong(string3, n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                this.typeCache = l;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            RuntimeCostAccounter.recordJump();
        }
        return bl;
    }

    public long nextLong() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.nextLong:(I)J");
        return this.nextLong(this.defaultRadix);
    }

    public long nextLong(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.typeCache != null) {
            boolean bl = this.typeCache instanceof Long;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordJump();
                if (this.radix == n) {
                    Long l = (Long)this.typeCache;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                    long l2 = l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.useTypeCache:()V");
                    this.useTypeCache();
                    return l2;
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.setRadix:(I)V");
        this.setRadix(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.integerPattern:()Ljava/util/regex/Pattern;");
            Pattern pattern = this.integerPattern();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.next:(Ljava/util/regex/Pattern;)Ljava/lang/String;");
            String string = this.next(pattern);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
            String string2 = this.matcher.group(this.SIMPLE_GROUP_INDEX);
            RuntimeCostAccounter.recordJump();
            if (string2 == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.processIntegerToken:(Ljava/lang/String;)Ljava/lang/String;");
                string = this.processIntegerToken(string);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.parseLong:(Ljava/lang/String;I)J");
            return Long.parseLong(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.start:()I");
            this.position = this.matcher.start();
            RuntimeCostAccounter.recordAllocation((String)"java/util/InputMismatchException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.getMessage:()Ljava/lang/String;");
            String string = numberFormatException.getMessage();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/InputMismatchException.<init>:(Ljava/lang/String;)V");
            InputMismatchException inputMismatchException = new InputMismatchException(string);
            RuntimeCostAccounter.recordThrow();
            throw inputMismatchException;
        }
    }

    private String processFloatToken(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.replaceAll:(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        String string2 = string.replaceAll(this.groupSeparator, "");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        boolean bl = this.decimalSeparator.equals("\\.");
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.replaceAll:(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
            string2 = string2.replaceAll(this.decimalSeparator, ".");
        }
        boolean bl2 = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n = this.negativePrefix.length();
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
            boolean bl3 = string2.startsWith(this.negativePrefix);
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                bl2 = true;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
                string2 = string2.substring(n);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n2 = this.negativeSuffix.length();
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.endsWith:(Ljava/lang/String;)Z");
            boolean bl4 = string2.endsWith(this.negativeSuffix);
            RuntimeCostAccounter.recordJump();
            if (bl4) {
                bl2 = true;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n3 = string2.length() - n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n4 = string2.length();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
                string2 = string2.substring(n3, n4);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        boolean bl5 = string2.equals(this.nanString);
        RuntimeCostAccounter.recordJump();
        if (bl5) {
            string2 = "NaN";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        boolean bl6 = string2.equals(this.infinityString);
        RuntimeCostAccounter.recordJump();
        if (bl6) {
            string2 = "Infinity";
        }
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("-");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            string2 = stringBuilder3.toString();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.matcher:(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;");
        Matcher matcher = NON_ASCII_DIGIT.matcher(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.find:()Z");
        boolean bl7 = matcher.find();
        RuntimeCostAccounter.recordJump();
        if (bl7) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            int n5 = 0;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n6 = string2.length();
                RuntimeCostAccounter.recordJump();
                if (n5 >= n6) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                char c = string2.charAt(n5);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.isDigit:(C)Z");
                boolean bl8 = Character.isDigit(c);
                RuntimeCostAccounter.recordJump();
                if (bl8) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.digit:(CI)I");
                    int n7 = Character.digit(c, 10);
                    RuntimeCostAccounter.recordJump();
                    if (n7 != -1) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                        stringBuilder.append(n7);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                        stringBuilder.append(c);
                    }
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                    stringBuilder.append(c);
                }
                ++n5;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public boolean hasNextFloat() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.setRadix:(I)V");
        this.setRadix(10);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.floatPattern:()Ljava/util/regex/Pattern;");
        Pattern pattern = this.floatPattern();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasNext:(Ljava/util/regex/Pattern;)Z");
        boolean bl = this.hasNext(pattern);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.processFloatToken:(Ljava/lang/String;)Ljava/lang/String;");
                String string = this.processFloatToken(this.hasNextResult);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Float.parseFloat:(Ljava/lang/String;)F");
                float f = Float.parseFloat(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Float.valueOf:(F)Ljava/lang/Float;");
                this.typeCache = Float.valueOf(f);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            RuntimeCostAccounter.recordJump();
        }
        return bl;
    }

    public float nextFloat() {
        RuntimeCostAccounter.recordJump();
        if (this.typeCache != null) {
            boolean bl = this.typeCache instanceof Float;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                Float f = (Float)this.typeCache;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Float.floatValue:()F");
                float f2 = f.floatValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.useTypeCache:()V");
                this.useTypeCache();
                return f2;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.setRadix:(I)V");
        this.setRadix(10);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.floatPattern:()Ljava/util/regex/Pattern;");
            Pattern pattern = this.floatPattern();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.next:(Ljava/util/regex/Pattern;)Ljava/lang/String;");
            String string = this.next(pattern);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.processFloatToken:(Ljava/lang/String;)Ljava/lang/String;");
            String string2 = this.processFloatToken(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Float.parseFloat:(Ljava/lang/String;)F");
            return Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.start:()I");
            this.position = this.matcher.start();
            RuntimeCostAccounter.recordAllocation((String)"java/util/InputMismatchException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.getMessage:()Ljava/lang/String;");
            String string = numberFormatException.getMessage();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/InputMismatchException.<init>:(Ljava/lang/String;)V");
            InputMismatchException inputMismatchException = new InputMismatchException(string);
            RuntimeCostAccounter.recordThrow();
            throw inputMismatchException;
        }
    }

    public boolean hasNextDouble() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.setRadix:(I)V");
        this.setRadix(10);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.floatPattern:()Ljava/util/regex/Pattern;");
        Pattern pattern = this.floatPattern();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasNext:(Ljava/util/regex/Pattern;)Z");
        boolean bl = this.hasNext(pattern);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.processFloatToken:(Ljava/lang/String;)Ljava/lang/String;");
                String string = this.processFloatToken(this.hasNextResult);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.parseDouble:(Ljava/lang/String;)D");
                double d = Double.parseDouble(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.valueOf:(D)Ljava/lang/Double;");
                this.typeCache = d;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            RuntimeCostAccounter.recordJump();
        }
        return bl;
    }

    public double nextDouble() {
        RuntimeCostAccounter.recordJump();
        if (this.typeCache != null) {
            boolean bl = this.typeCache instanceof Double;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                Double d = (Double)this.typeCache;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.doubleValue:()D");
                double d2 = d;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.useTypeCache:()V");
                this.useTypeCache();
                return d2;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.setRadix:(I)V");
        this.setRadix(10);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.floatPattern:()Ljava/util/regex/Pattern;");
            Pattern pattern = this.floatPattern();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.next:(Ljava/util/regex/Pattern;)Ljava/lang/String;");
            String string = this.next(pattern);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.processFloatToken:(Ljava/lang/String;)Ljava/lang/String;");
            String string2 = this.processFloatToken(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.parseDouble:(Ljava/lang/String;)D");
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.start:()I");
            this.position = this.matcher.start();
            RuntimeCostAccounter.recordAllocation((String)"java/util/InputMismatchException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.getMessage:()Ljava/lang/String;");
            String string = numberFormatException.getMessage();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/InputMismatchException.<init>:(Ljava/lang/String;)V");
            InputMismatchException inputMismatchException = new InputMismatchException(string);
            RuntimeCostAccounter.recordThrow();
            throw inputMismatchException;
        }
    }

    public boolean hasNextBigInteger() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasNextBigInteger:(I)Z");
        return this.hasNextBigInteger(this.defaultRadix);
    }

    public boolean hasNextBigInteger(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.setRadix:(I)V");
        this.setRadix(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.integerPattern:()Ljava/util/regex/Pattern;");
        Pattern pattern = this.integerPattern();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasNext:(Ljava/util/regex/Pattern;)Z");
        boolean bl = this.hasNext(pattern);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            try {
                String string;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                String string2 = this.matcher.group(this.SIMPLE_GROUP_INDEX);
                RuntimeCostAccounter.recordJump();
                if (string2 == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.processIntegerToken:(Ljava/lang/String;)Ljava/lang/String;");
                    string = this.processIntegerToken(this.hasNextResult);
                    RuntimeCostAccounter.recordJump();
                } else {
                    string = this.hasNextResult;
                }
                String string3 = string;
                RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:(Ljava/lang/String;I)V");
                this.typeCache = new BigInteger(string3, n);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            RuntimeCostAccounter.recordJump();
        }
        return bl;
    }

    public BigInteger nextBigInteger() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.nextBigInteger:(I)Ljava/math/BigInteger;");
        return this.nextBigInteger(this.defaultRadix);
    }

    public BigInteger nextBigInteger(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.typeCache != null) {
            boolean bl = this.typeCache instanceof BigInteger;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordJump();
                if (this.radix == n) {
                    BigInteger bigInteger = (BigInteger)this.typeCache;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.useTypeCache:()V");
                    this.useTypeCache();
                    return bigInteger;
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.setRadix:(I)V");
        this.setRadix(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.integerPattern:()Ljava/util/regex/Pattern;");
            Pattern pattern = this.integerPattern();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.next:(Ljava/util/regex/Pattern;)Ljava/lang/String;");
            String string = this.next(pattern);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
            String string2 = this.matcher.group(this.SIMPLE_GROUP_INDEX);
            RuntimeCostAccounter.recordJump();
            if (string2 == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.processIntegerToken:(Ljava/lang/String;)Ljava/lang/String;");
                string = this.processIntegerToken(string);
            }
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:(Ljava/lang/String;I)V");
            return new BigInteger(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.start:()I");
            this.position = this.matcher.start();
            RuntimeCostAccounter.recordAllocation((String)"java/util/InputMismatchException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.getMessage:()Ljava/lang/String;");
            String string = numberFormatException.getMessage();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/InputMismatchException.<init>:(Ljava/lang/String;)V");
            InputMismatchException inputMismatchException = new InputMismatchException(string);
            RuntimeCostAccounter.recordThrow();
            throw inputMismatchException;
        }
    }

    public boolean hasNextBigDecimal() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.setRadix:(I)V");
        this.setRadix(10);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.decimalPattern:()Ljava/util/regex/Pattern;");
        Pattern pattern = this.decimalPattern();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.hasNext:(Ljava/util/regex/Pattern;)Z");
        boolean bl = this.hasNext(pattern);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.processFloatToken:(Ljava/lang/String;)Ljava/lang/String;");
                String string = this.processFloatToken(this.hasNextResult);
                RuntimeCostAccounter.recordAllocation((String)"java/math/BigDecimal");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.<init>:(Ljava/lang/String;)V");
                this.typeCache = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            RuntimeCostAccounter.recordJump();
        }
        return bl;
    }

    public BigDecimal nextBigDecimal() {
        RuntimeCostAccounter.recordJump();
        if (this.typeCache != null) {
            boolean bl = this.typeCache instanceof BigDecimal;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                BigDecimal bigDecimal = (BigDecimal)this.typeCache;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.useTypeCache:()V");
                this.useTypeCache();
                return bigDecimal;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.setRadix:(I)V");
        this.setRadix(10);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.decimalPattern:()Ljava/util/regex/Pattern;");
            Pattern pattern = this.decimalPattern();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.next:(Ljava/util/regex/Pattern;)Ljava/lang/String;");
            String string = this.next(pattern);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.processFloatToken:(Ljava/lang/String;)Ljava/lang/String;");
            String string2 = this.processFloatToken(string);
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigDecimal");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.<init>:(Ljava/lang/String;)V");
            return new BigDecimal(string2);
        }
        catch (NumberFormatException numberFormatException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.start:()I");
            this.position = this.matcher.start();
            RuntimeCostAccounter.recordAllocation((String)"java/util/InputMismatchException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.getMessage:()Ljava/lang/String;");
            String string = numberFormatException.getMessage();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/InputMismatchException.<init>:(Ljava/lang/String;)V");
            InputMismatchException inputMismatchException = new InputMismatchException(string);
            RuntimeCostAccounter.recordThrow();
            throw inputMismatchException;
        }
    }

    public Scanner reset() {
        this.delimPattern = WHITESPACE_PATTERN;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.useLocale:(Ljava/util/Locale;)Ljava/util/Scanner;");
        this.useLocale(locale);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.useRadix:(I)Ljava/util/Scanner;");
        this.useRadix(10);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Scanner.clearCaches:()V");
        this.clearCaches();
        return this;
    }

    static {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
        boolean bl2 = Scanner.class.desiredAssertionStatus();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        $assertionsDisabled = bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.compile:(Ljava/lang/String;)Ljava/util/regex/Pattern;");
        WHITESPACE_PATTERN = Pattern.compile("\\p{javaWhitespace}+");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.compile:(Ljava/lang/String;)Ljava/util/regex/Pattern;");
        FIND_ANY_PATTERN = Pattern.compile("(?s).*");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.compile:(Ljava/lang/String;)Ljava/util/regex/Pattern;");
        NON_ASCII_DIGIT = Pattern.compile("[\\p{javaDigit}&&[^0-9]]");
    }
}

