/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInput;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutput;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.DayOfWeek;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalDate;
import sandbox.java.time.LocalDateTime;
import sandbox.java.time.LocalTime;
import sandbox.java.time.Month;
import sandbox.java.time.OffsetTime;
import sandbox.java.time.Ser;
import sandbox.java.time.ZoneId;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.ZonedDateTime;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.chrono.IsoChronology;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.time.zone.ZoneRules;
import sandbox.java.util.Comparator;
import sandbox.java.util.Objects;

public final class OffsetDateTime
implements Temporal,
TemporalAdjuster,
Comparable<OffsetDateTime>,
Serializable {
    public static final OffsetDateTime MIN;
    public static final OffsetDateTime MAX;
    private static final long serialVersionUID = 2287754244819255394L;
    private final LocalDateTime dateTime;
    private final ZoneOffset offset;

    public static Comparator<OffsetDateTime> timeLineOrder() {
        return OffsetDateTime::compareInstant;
    }

    private static int compareInstant(OffsetDateTime offsetDateTime, OffsetDateTime offsetDateTime2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.getOffset:()Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = offsetDateTime.getOffset();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.getOffset:()Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset2 = offsetDateTime2.getOffset();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
        boolean bl = zoneOffset.equals(zoneOffset2);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalDateTime:()Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime = offsetDateTime.toLocalDateTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalDateTime:()Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime2 = offsetDateTime2.toLocalDateTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.compareTo:(Ljava/time/chrono/ChronoLocalDateTime;)I");
            return localDateTime.compareTo(localDateTime2);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toEpochSecond:()J");
        long l = offsetDateTime.toEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toEpochSecond:()J");
        long l2 = offsetDateTime2.toEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.compare:(JJ)I");
        int n = Long.compare(l, l2);
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime = offsetDateTime.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
            int n2 = localTime.getNano();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime2 = offsetDateTime2.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
            n = n2 - localTime2.getNano();
        }
        return n;
    }

    public static OffsetDateTime now() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.now:(Ljava/time/Clock;)Ljava/time/OffsetDateTime;");
        return OffsetDateTime.now(clock);
    }

    public static OffsetDateTime now(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.now:(Ljava/time/Clock;)Ljava/time/OffsetDateTime;");
        return OffsetDateTime.now(clock);
    }

    public static OffsetDateTime now(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(clock, "clock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.instant:()Ljava/time/Instant;");
        Instant instant = clock.instant();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.getZone:()Ljava/time/ZoneId;");
        ZoneId zoneId = clock.getZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
        ZoneRules zoneRules = zoneId.getRules();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getOffset:(Ljava/time/Instant;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.ofInstant:(Ljava/time/Instant;Ljava/time/ZoneId;)Ljava/time/OffsetDateTime;");
        return OffsetDateTime.ofInstant(instant, zoneOffset);
    }

    public static OffsetDateTime of(LocalDate localDate, LocalTime localTime, ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.of:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        RuntimeCostAccounter.recordAllocation((String)"java/time/OffsetDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)V");
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime of(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/OffsetDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)V");
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime of(int n, int n2, int n3, int n4, int n5, int n6, int n7, ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.of:(IIIIIII)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = LocalDateTime.of(n, n2, n3, n4, n5, n6, n7);
        RuntimeCostAccounter.recordAllocation((String)"java/time/OffsetDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)V");
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime ofInstant(Instant instant, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(instant, "instant");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneId, "zone");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
        ZoneRules zoneRules = zoneId.getRules();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getOffset:(Ljava/time/Instant;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getEpochSecond:()J");
        long l = instant.getEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getNano:()I");
        int n = instant.getNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.ofEpochSecond:(JILjava/time/ZoneOffset;)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(l, n, zoneOffset);
        RuntimeCostAccounter.recordAllocation((String)"java/time/OffsetDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)V");
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime from(TemporalAccessor temporalAccessor) {
        boolean bl = temporalAccessor instanceof OffsetDateTime;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (OffsetDateTime)temporalAccessor;
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/ZoneOffset;");
            ZoneOffset zoneOffset = ZoneOffset.from(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localDate:()Ljava/time/temporal/TemporalQuery;");
            TemporalQuery<LocalDate> temporalQuery = TemporalQueries.localDate();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
            LocalDate localDate = temporalAccessor.query(temporalQuery);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localTime:()Ljava/time/temporal/TemporalQuery;");
            TemporalQuery<LocalTime> temporalQuery2 = TemporalQueries.localTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
            LocalTime localTime = temporalAccessor.query(temporalQuery2);
            RuntimeCostAccounter.recordJump();
            if (localDate != null) {
                RuntimeCostAccounter.recordJump();
                if (localTime != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.of:(Ljava/time/LocalDate;Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
                    return OffsetDateTime.of(localDate, localTime, zoneOffset);
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/Instant;");
            Instant instant = Instant.from(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.ofInstant:(Ljava/time/Instant;Ljava/time/ZoneId;)Ljava/time/OffsetDateTime;");
            return OffsetDateTime.ofInstant(instant, zoneOffset);
        }
        catch (DateTimeException dateTimeException) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain OffsetDateTime from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" of type ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
            String string = clazz.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            DateTimeException dateTimeException2 = new DateTimeException(string2, dateTimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException2;
        }
    }

    public static OffsetDateTime parse(CharSequence charSequence) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.parse:(Ljava/lang/CharSequence;Ljava/time/format/DateTimeFormatter;)Ljava/time/OffsetDateTime;");
        return OffsetDateTime.parse(charSequence, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static OffsetDateTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        TemporalQuery<OffsetDateTime> temporalQuery = OffsetDateTime::from;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parse:(Ljava/lang/CharSequence;Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return dateTimeFormatter.parse(charSequence, temporalQuery);
    }

    private OffsetDateTime(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        this.dateTime = Objects.requireNonNull(localDateTime, "dateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        this.offset = Objects.requireNonNull(zoneOffset, "offset");
    }

    private OffsetDateTime with(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordJump();
        if (this.dateTime == localDateTime) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
            boolean bl = this.offset.equals(zoneOffset);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return this;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/OffsetDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)V");
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalField == null) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isSupportedBy:(Ljava/time/temporal/TemporalAccessor;)Z");
            boolean bl2 = temporalField.isSupportedBy(this);
            RuntimeCostAccounter.recordJump();
            if (!bl2) return false;
        }
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalUnit == ChronoUnit.FOREVER) return false;
            boolean bl2 = true;
            RuntimeCostAccounter.recordJump();
            return bl2;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isSupportedBy:(Ljava/time/temporal/Temporal;)Z");
        boolean bl3 = temporalUnit.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        block2: {
            block4: {
                block3: {
                    boolean bl = temporalField instanceof ChronoField;
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block2;
                    RuntimeCostAccounter.recordJump();
                    if (temporalField == ChronoField.INSTANT_SECONDS) break block3;
                    RuntimeCostAccounter.recordJump();
                    if (temporalField != ChronoField.OFFSET_SECONDS) break block4;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.range:()Ljava/time/temporal/ValueRange;");
                return temporalField.range();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
            return this.dateTime.range(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.rangeRefinedBy:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/temporal/ValueRange;");
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
                    UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException("Invalid field 'InstantSeconds' for get() method, use getLong() instead");
                    RuntimeCostAccounter.recordThrow();
                    throw unsupportedTemporalTypeException;
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.getOffset:()Ljava/time/ZoneOffset;");
                    ZoneOffset zoneOffset = this.getOffset();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
                    return zoneOffset.getTotalSeconds();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.get:(Ljava/time/temporal/TemporalField;)I");
            return this.dateTime.get(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.get:(Ljava/time/temporal/TemporalField;)I");
        return Temporal.super.get(temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toEpochSecond:()J");
                    return this.toEpochSecond();
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.getOffset:()Ljava/time/ZoneOffset;");
                    ZoneOffset zoneOffset = this.getOffset();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
                    return zoneOffset.getTotalSeconds();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getLong:(Ljava/time/temporal/TemporalField;)J");
            return this.dateTime.getLong(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public OffsetDateTime withOffsetSameLocal(ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(this.dateTime, zoneOffset);
    }

    public OffsetDateTime withOffsetSameInstant(ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
        boolean bl = zoneOffset.equals(this.offset);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        int n = zoneOffset.getTotalSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        int n2 = n - this.offset.getTotalSeconds();
        long l = n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusSeconds:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusSeconds(l);
        RuntimeCostAccounter.recordAllocation((String)"java/time/OffsetDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)V");
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public LocalDateTime toLocalDateTime() {
        return this.dateTime;
    }

    public LocalDate toLocalDate() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toLocalDate:()Ljava/time/LocalDate;");
        return this.dateTime.toLocalDate();
    }

    public int getYear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getYear:()I");
        return this.dateTime.getYear();
    }

    public int getMonthValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getMonthValue:()I");
        return this.dateTime.getMonthValue();
    }

    public Month getMonth() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getMonth:()Ljava/time/Month;");
        return this.dateTime.getMonth();
    }

    public int getDayOfMonth() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getDayOfMonth:()I");
        return this.dateTime.getDayOfMonth();
    }

    public int getDayOfYear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getDayOfYear:()I");
        return this.dateTime.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getDayOfWeek:()Ljava/time/DayOfWeek;");
        return this.dateTime.getDayOfWeek();
    }

    public LocalTime toLocalTime() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
        return this.dateTime.toLocalTime();
    }

    public int getHour() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getHour:()I");
        return this.dateTime.getHour();
    }

    public int getMinute() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getMinute:()I");
        return this.dateTime.getMinute();
    }

    public int getSecond() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getSecond:()I");
        return this.dateTime.getSecond();
    }

    public int getNano() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getNano:()I");
        return this.dateTime.getNano();
    }

    @Override
    public OffsetDateTime with(TemporalAdjuster temporalAdjuster) {
        block7: {
            block6: {
                boolean bl = temporalAdjuster instanceof LocalDate;
                RuntimeCostAccounter.recordJump();
                if (bl) break block6;
                boolean bl2 = temporalAdjuster instanceof LocalTime;
                RuntimeCostAccounter.recordJump();
                if (bl2) break block6;
                boolean bl3 = temporalAdjuster instanceof LocalDateTime;
                RuntimeCostAccounter.recordJump();
                if (!bl3) break block7;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/temporal/TemporalAdjuster;)Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime = this.dateTime.with(temporalAdjuster);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
            return this.with(localDateTime, this.offset);
        }
        boolean bl = temporalAdjuster instanceof Instant;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            Instant instant = (Instant)temporalAdjuster;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.ofInstant:(Ljava/time/Instant;Ljava/time/ZoneId;)Ljava/time/OffsetDateTime;");
            return OffsetDateTime.ofInstant(instant, this.offset);
        }
        boolean bl4 = temporalAdjuster instanceof ZoneOffset;
        RuntimeCostAccounter.recordJump();
        if (bl4) {
            ZoneOffset zoneOffset = (ZoneOffset)temporalAdjuster;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
            return this.with(this.dateTime, zoneOffset);
        }
        boolean bl5 = temporalAdjuster instanceof OffsetDateTime;
        RuntimeCostAccounter.recordJump();
        if (bl5) {
            return (OffsetDateTime)temporalAdjuster;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjuster.adjustInto:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (OffsetDateTime)temporalAdjuster.adjustInto(this);
    }

    @Override
    public OffsetDateTime with(TemporalField temporalField, long l) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.getNano:()I");
                    long l2 = this.getNano();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.ofEpochSecond:(JJ)Ljava/time/Instant;");
                    Instant instant = Instant.ofEpochSecond(l, l2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.ofInstant:(Ljava/time/Instant;Ljava/time/ZoneId;)Ljava/time/OffsetDateTime;");
                    return OffsetDateTime.ofInstant(instant, this.offset);
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
                    int n = chronoField.checkValidIntValue(l);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
                    ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
                    return this.with(this.dateTime, zoneOffset);
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime = this.dateTime.with(temporalField, l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
            return this.with(localDateTime, this.offset);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.adjustInto:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalField.adjustInto(this, l);
    }

    public OffsetDateTime withYear(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.withYear:(I)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.withYear(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    public OffsetDateTime withMonth(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.withMonth:(I)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.withMonth(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    public OffsetDateTime withDayOfMonth(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.withDayOfMonth:(I)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.withDayOfMonth(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    public OffsetDateTime withDayOfYear(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.withDayOfYear:(I)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.withDayOfYear(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    public OffsetDateTime withHour(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.withHour:(I)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.withHour(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    public OffsetDateTime withMinute(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.withMinute:(I)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.withMinute(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    public OffsetDateTime withSecond(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.withSecond:(I)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.withSecond(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    public OffsetDateTime withNano(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.withNano:(I)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.withNano(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    public OffsetDateTime truncatedTo(TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.truncatedTo:(Ljava/time/temporal/TemporalUnit;)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.truncatedTo(temporalUnit);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    @Override
    public OffsetDateTime plus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.addTo:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (OffsetDateTime)temporalAmount.addTo(this);
    }

    @Override
    public OffsetDateTime plus(long l, TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime = this.dateTime.plus(l, temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
            return this.with(localDateTime, this.offset);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.addTo:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalUnit.addTo(this, l);
    }

    public OffsetDateTime plusYears(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusYears:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusYears(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    public OffsetDateTime plusMonths(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusMonths:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusMonths(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    public OffsetDateTime plusWeeks(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusWeeks:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusWeeks(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    public OffsetDateTime plusDays(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusDays:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusDays(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    public OffsetDateTime plusHours(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusHours:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusHours(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    public OffsetDateTime plusMinutes(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusMinutes:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusMinutes(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    public OffsetDateTime plusSeconds(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusSeconds:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusSeconds(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    public OffsetDateTime plusNanos(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusNanos:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusNanos(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.with:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return this.with(localDateTime, this.offset);
    }

    @Override
    public OffsetDateTime minus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.subtractFrom:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (OffsetDateTime)temporalAmount.subtractFrom(this);
    }

    @Override
    public OffsetDateTime minus(long l, TemporalUnit temporalUnit) {
        OffsetDateTime offsetDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/OffsetDateTime;");
            OffsetDateTime offsetDateTime2 = this.plus(Long.MAX_VALUE, temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/OffsetDateTime;");
            offsetDateTime = offsetDateTime2.plus(1L, temporalUnit);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/OffsetDateTime;");
            offsetDateTime = this.plus(l2, temporalUnit);
        }
        return offsetDateTime;
    }

    public OffsetDateTime minusYears(long l) {
        OffsetDateTime offsetDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusYears:(J)Ljava/time/OffsetDateTime;");
            OffsetDateTime offsetDateTime2 = this.plusYears(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusYears:(J)Ljava/time/OffsetDateTime;");
            offsetDateTime = offsetDateTime2.plusYears(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusYears:(J)Ljava/time/OffsetDateTime;");
            offsetDateTime = this.plusYears(l2);
        }
        return offsetDateTime;
    }

    public OffsetDateTime minusMonths(long l) {
        OffsetDateTime offsetDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusMonths:(J)Ljava/time/OffsetDateTime;");
            OffsetDateTime offsetDateTime2 = this.plusMonths(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusMonths:(J)Ljava/time/OffsetDateTime;");
            offsetDateTime = offsetDateTime2.plusMonths(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusMonths:(J)Ljava/time/OffsetDateTime;");
            offsetDateTime = this.plusMonths(l2);
        }
        return offsetDateTime;
    }

    public OffsetDateTime minusWeeks(long l) {
        OffsetDateTime offsetDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusWeeks:(J)Ljava/time/OffsetDateTime;");
            OffsetDateTime offsetDateTime2 = this.plusWeeks(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusWeeks:(J)Ljava/time/OffsetDateTime;");
            offsetDateTime = offsetDateTime2.plusWeeks(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusWeeks:(J)Ljava/time/OffsetDateTime;");
            offsetDateTime = this.plusWeeks(l2);
        }
        return offsetDateTime;
    }

    public OffsetDateTime minusDays(long l) {
        OffsetDateTime offsetDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusDays:(J)Ljava/time/OffsetDateTime;");
            OffsetDateTime offsetDateTime2 = this.plusDays(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusDays:(J)Ljava/time/OffsetDateTime;");
            offsetDateTime = offsetDateTime2.plusDays(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusDays:(J)Ljava/time/OffsetDateTime;");
            offsetDateTime = this.plusDays(l2);
        }
        return offsetDateTime;
    }

    public OffsetDateTime minusHours(long l) {
        OffsetDateTime offsetDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusHours:(J)Ljava/time/OffsetDateTime;");
            OffsetDateTime offsetDateTime2 = this.plusHours(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusHours:(J)Ljava/time/OffsetDateTime;");
            offsetDateTime = offsetDateTime2.plusHours(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusHours:(J)Ljava/time/OffsetDateTime;");
            offsetDateTime = this.plusHours(l2);
        }
        return offsetDateTime;
    }

    public OffsetDateTime minusMinutes(long l) {
        OffsetDateTime offsetDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusMinutes:(J)Ljava/time/OffsetDateTime;");
            OffsetDateTime offsetDateTime2 = this.plusMinutes(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusMinutes:(J)Ljava/time/OffsetDateTime;");
            offsetDateTime = offsetDateTime2.plusMinutes(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusMinutes:(J)Ljava/time/OffsetDateTime;");
            offsetDateTime = this.plusMinutes(l2);
        }
        return offsetDateTime;
    }

    public OffsetDateTime minusSeconds(long l) {
        OffsetDateTime offsetDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusSeconds:(J)Ljava/time/OffsetDateTime;");
            OffsetDateTime offsetDateTime2 = this.plusSeconds(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusSeconds:(J)Ljava/time/OffsetDateTime;");
            offsetDateTime = offsetDateTime2.plusSeconds(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusSeconds:(J)Ljava/time/OffsetDateTime;");
            offsetDateTime = this.plusSeconds(l2);
        }
        return offsetDateTime;
    }

    public OffsetDateTime minusNanos(long l) {
        OffsetDateTime offsetDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusNanos:(J)Ljava/time/OffsetDateTime;");
            OffsetDateTime offsetDateTime2 = this.plusNanos(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusNanos:(J)Ljava/time/OffsetDateTime;");
            offsetDateTime = offsetDateTime2.plusNanos(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.plusNanos:(J)Ljava/time/OffsetDateTime;");
            offsetDateTime = this.plusNanos(l2);
        }
        return offsetDateTime;
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        block9: {
            block8: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.offset:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneOffset> temporalQuery2 = TemporalQueries.offset();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery2) break block8;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zone:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneId> temporalQuery3 = TemporalQueries.zone();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery != temporalQuery3) break block9;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.getOffset:()Ljava/time/ZoneOffset;");
            return (R)this.getOffset();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zoneId:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<ZoneId> temporalQuery4 = TemporalQueries.zoneId();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery4) {
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localDate:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<LocalDate> temporalQuery5 = TemporalQueries.localDate();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery5) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalDate:()Ljava/time/LocalDate;");
            return (R)this.toLocalDate();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localTime:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<LocalTime> temporalQuery6 = TemporalQueries.localTime();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery6) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalTime:()Ljava/time/LocalTime;");
            return (R)this.toLocalTime();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<Chronology> temporalQuery7 = TemporalQueries.chronology();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery7) {
            return (R)IsoChronology.INSTANCE;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.precision:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<TemporalUnit> temporalQuery8 = TemporalQueries.precision();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery8) {
            return (R)ChronoUnit.NANOS;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQuery.queryFrom:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/Object;");
        return temporalQuery.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalDate:()Ljava/time/LocalDate;");
        LocalDate localDate = this.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.toEpochDay:()J");
        long l = localDate.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
        Temporal temporal2 = temporal.with(ChronoField.EPOCH_DAY, l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime = this.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
        long l2 = localTime.toNanoOfDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
        Temporal temporal3 = temporal2.with(ChronoField.NANO_OF_DAY, l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.getOffset:()Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = this.getOffset();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        long l3 = zoneOffset.getTotalSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
        return temporal3.with(ChronoField.OFFSET_SECONDS, l3);
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/OffsetDateTime;");
        OffsetDateTime offsetDateTime = OffsetDateTime.from(temporal);
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.withOffsetSameInstant:(Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
            offsetDateTime = offsetDateTime.withOffsetSameInstant(this.offset);
            LocalDateTime localDateTime = offsetDateTime.dateTime;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.until:(Ljava/time/temporal/Temporal;Ljava/time/temporal/TemporalUnit;)J");
            return this.dateTime.until(localDateTime, temporalUnit);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.between:(Ljava/time/temporal/Temporal;Ljava/time/temporal/Temporal;)J");
        return temporalUnit.between(this, offsetDateTime);
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.format:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/String;");
        return dateTimeFormatter.format(this);
    }

    public ZonedDateTime atZoneSameInstant(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.ofInstant:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneId;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.ofInstant(this.dateTime, this.offset, zoneId);
    }

    public ZonedDateTime atZoneSimilarLocal(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.ofLocal:(Ljava/time/LocalDateTime;Ljava/time/ZoneId;Ljava/time/ZoneOffset;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.ofLocal(this.dateTime, zoneId, this.offset);
    }

    public OffsetTime toOffsetTime() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime = this.dateTime.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.of:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        return OffsetTime.of(localTime, this.offset);
    }

    public ZonedDateTime toZonedDateTime() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.of:(Ljava/time/LocalDateTime;Ljava/time/ZoneId;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.of(this.dateTime, this.offset);
    }

    public Instant toInstant() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toInstant:(Ljava/time/ZoneOffset;)Ljava/time/Instant;");
        return this.dateTime.toInstant(this.offset);
    }

    public long toEpochSecond() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toEpochSecond:(Ljava/time/ZoneOffset;)J");
        return this.dateTime.toEpochSecond(this.offset);
    }

    @Override
    public int compareTo(OffsetDateTime offsetDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.compareInstant:(Ljava/time/OffsetDateTime;Ljava/time/OffsetDateTime;)I");
        int n = OffsetDateTime.compareInstant(this, offsetDateTime);
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalDateTime:()Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime = this.toLocalDateTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalDateTime:()Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime2 = offsetDateTime.toLocalDateTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.compareTo:(Ljava/time/chrono/ChronoLocalDateTime;)I");
            n = localDateTime.compareTo(localDateTime2);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAfter(OffsetDateTime offsetDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toEpochSecond:()J");
        long l = this.toEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toEpochSecond:()J");
        long l2 = offsetDateTime.toEpochSecond();
        RuntimeCostAccounter.recordJump();
        if (l <= l2) {
            RuntimeCostAccounter.recordJump();
            if (l != l2) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime = this.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
            int n = localTime.getNano();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime2 = offsetDateTime.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
            int n2 = localTime2.getNano();
            RuntimeCostAccounter.recordJump();
            if (n <= n2) return false;
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isBefore(OffsetDateTime offsetDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toEpochSecond:()J");
        long l = this.toEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toEpochSecond:()J");
        long l2 = offsetDateTime.toEpochSecond();
        RuntimeCostAccounter.recordJump();
        if (l >= l2) {
            RuntimeCostAccounter.recordJump();
            if (l != l2) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime = this.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
            int n = localTime.getNano();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime2 = offsetDateTime.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
            int n2 = localTime2.getNano();
            RuntimeCostAccounter.recordJump();
            if (n >= n2) return false;
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEqual(OffsetDateTime offsetDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toEpochSecond:()J");
        long l = this.toEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toEpochSecond:()J");
        long l2 = l - offsetDateTime.toEpochSecond();
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l3 != false) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime = this.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
        int n = localTime.getNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime2 = offsetDateTime.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
        int n2 = localTime2.getNano();
        RuntimeCostAccounter.recordJump();
        if (n != n2) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof OffsetDateTime;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        OffsetDateTime offsetDateTime = (OffsetDateTime)object;
        LocalDateTime localDateTime = offsetDateTime.dateTime;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.equals:(Ljava/lang/Object;)Z");
        boolean bl2 = this.dateTime.equals(localDateTime);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        ZoneOffset zoneOffset = offsetDateTime.offset;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
        boolean bl3 = this.offset.equals(zoneOffset);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.hashCode:()I");
        int n = this.dateTime.hashCode();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.hashCode:()I");
        return n ^ this.offset.hashCode();
    }

    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toString:()Ljava/lang/String;");
        String string = this.dateTime.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.toString:()Ljava/lang/String;");
        String string2 = this.offset.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder3.toString();
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(10, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    void writeExternal(ObjectOutput objectOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.writeExternal:(Ljava/io/DataOutput;)V");
        this.dateTime.writeExternal(objectOutput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.writeExternal:(Ljava/io/DataOutput;)V");
        this.offset.writeExternal(objectOutput);
    }

    static OffsetDateTime readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.readExternal:(Ljava/io/DataInput;)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = LocalDateTime.readExternal(objectInput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.readExternal:(Ljava/io/DataInput;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = ZoneOffset.readExternal(objectInput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.of:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return OffsetDateTime.of(localDateTime, zoneOffset);
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.atOffset:(Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        MIN = LocalDateTime.MIN.atOffset(ZoneOffset.MAX);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.atOffset:(Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        MAX = LocalDateTime.MAX.atOffset(ZoneOffset.MIN);
    }
}

