/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.Duration;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalDate;
import sandbox.java.time.LocalDateTime;
import sandbox.java.time.OffsetTime;
import sandbox.java.time.Ser;
import sandbox.java.time.ZoneId;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.time.zone.ZoneRules;
import sandbox.java.util.Objects;

public final class LocalTime
implements Temporal,
TemporalAdjuster,
Comparable<LocalTime>,
Serializable {
    public static final LocalTime MIN;
    public static final LocalTime MAX;
    public static final LocalTime MIDNIGHT;
    public static final LocalTime NOON;
    private static final LocalTime[] HOURS;
    static final int HOURS_PER_DAY = 24;
    static final int MINUTES_PER_HOUR = 60;
    static final int MINUTES_PER_DAY = 1440;
    static final int SECONDS_PER_MINUTE = 60;
    static final int SECONDS_PER_HOUR = 3600;
    static final int SECONDS_PER_DAY = 86400;
    static final long MILLIS_PER_DAY = 86400000L;
    static final long MICROS_PER_DAY = 86400000000L;
    static final long NANOS_PER_SECOND = 1000000000L;
    static final long NANOS_PER_MINUTE = 60000000000L;
    static final long NANOS_PER_HOUR = 3600000000000L;
    static final long NANOS_PER_DAY = 86400000000000L;
    private static final long serialVersionUID = 6414437269572265201L;
    private final byte hour;
    private final byte minute;
    private final byte second;
    private final int nano;

    public static LocalTime now() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.now:(Ljava/time/Clock;)Ljava/time/LocalTime;");
        return LocalTime.now(clock);
    }

    public static LocalTime now(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.now:(Ljava/time/Clock;)Ljava/time/LocalTime;");
        return LocalTime.now(clock);
    }

    public static LocalTime now(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(clock, "clock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.instant:()Ljava/time/Instant;");
        Instant instant = clock.instant();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.getZone:()Ljava/time/ZoneId;");
        ZoneId zoneId = clock.getZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
        ZoneRules zoneRules = zoneId.getRules();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getOffset:(Ljava/time/Instant;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getEpochSecond:()J");
        long l = instant.getEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        long l2 = l + (long)zoneOffset.getTotalSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
        int n = (int)Math.floorMod(l2, 86400L);
        long l3 = (long)n * 1000000000L;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getNano:()I");
        long l4 = l3 + (long)instant.getNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.ofNanoOfDay:(J)Ljava/time/LocalTime;");
        return LocalTime.ofNanoOfDay(l4);
    }

    public static LocalTime of(int n, int n2) {
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.HOUR_OF_DAY.checkValidValue(l);
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return HOURS[n];
        }
        long l2 = n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.MINUTE_OF_HOUR.checkValidValue(l2);
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.<init>:(IIII)V");
        return new LocalTime(n, n2, 0, 0);
    }

    public static LocalTime of(int n, int n2, int n3) {
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.HOUR_OF_DAY.checkValidValue(l);
        RuntimeCostAccounter.recordJump();
        if ((n2 | n3) == 0) {
            return HOURS[n];
        }
        long l2 = n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.MINUTE_OF_HOUR.checkValidValue(l2);
        long l3 = n3;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.SECOND_OF_MINUTE.checkValidValue(l3);
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.<init>:(IIII)V");
        return new LocalTime(n, n2, n3, 0);
    }

    public static LocalTime of(int n, int n2, int n3, int n4) {
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.HOUR_OF_DAY.checkValidValue(l);
        long l2 = n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.MINUTE_OF_HOUR.checkValidValue(l2);
        long l3 = n3;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.SECOND_OF_MINUTE.checkValidValue(l3);
        long l4 = n4;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.NANO_OF_SECOND.checkValidValue(l4);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.create:(IIII)Ljava/time/LocalTime;");
        return LocalTime.create(n, n2, n3, n4);
    }

    public static LocalTime ofSecondOfDay(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.SECOND_OF_DAY.checkValidValue(l);
        int n = (int)(l / 3600L);
        int n2 = (int)((l -= (long)(n * 3600)) / 60L);
        int n3 = (int)(l -= (long)(n2 * 60));
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.create:(IIII)Ljava/time/LocalTime;");
        return LocalTime.create(n, n2, n3, 0);
    }

    public static LocalTime ofNanoOfDay(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.NANO_OF_DAY.checkValidValue(l);
        int n = (int)(l / 3600000000000L);
        int n2 = (int)((l -= (long)n * 3600000000000L) / 60000000000L);
        int n3 = (int)((l -= (long)n2 * 60000000000L) / 1000000000L);
        int n4 = (int)(l -= (long)n3 * 1000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.create:(IIII)Ljava/time/LocalTime;");
        return LocalTime.create(n, n2, n3, n4);
    }

    public static LocalTime from(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAccessor, "temporal");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localTime:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<LocalTime> temporalQuery = TemporalQueries.localTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        LocalTime localTime = temporalAccessor.query(temporalQuery);
        RuntimeCostAccounter.recordJump();
        if (localTime == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain LocalTime from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" of type ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
            String string = clazz.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string2);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        return localTime;
    }

    public static LocalTime parse(CharSequence charSequence) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.parse:(Ljava/lang/CharSequence;Ljava/time/format/DateTimeFormatter;)Ljava/time/LocalTime;");
        return LocalTime.parse(charSequence, DateTimeFormatter.ISO_LOCAL_TIME);
    }

    public static LocalTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        TemporalQuery<LocalTime> temporalQuery = LocalTime::from;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parse:(Ljava/lang/CharSequence;Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return dateTimeFormatter.parse(charSequence, temporalQuery);
    }

    private static LocalTime create(int n, int n2, int n3, int n4) {
        RuntimeCostAccounter.recordJump();
        if ((n2 | n3 | n4) == 0) {
            return HOURS[n];
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.<init>:(IIII)V");
        return new LocalTime(n, n2, n3, n4);
    }

    private LocalTime(int n, int n2, int n3, int n4) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.hour = (byte)n;
        this.minute = (byte)n2;
        this.second = (byte)n3;
        this.nano = n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isTimeBased:()Z");
            return temporalField.isTimeBased();
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isSupportedBy:(Ljava/time/temporal/TemporalAccessor;)Z");
        boolean bl2 = temporalField.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isTimeBased:()Z");
            return temporalUnit.isTimeBased();
        }
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isSupportedBy:(Ljava/time/temporal/Temporal;)Z");
        boolean bl2 = temporalUnit.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
        return Temporal.super.range(temporalField);
    }

    @Override
    public int get(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.get0:(Ljava/time/temporal/TemporalField;)I");
            return this.get0(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.get:(Ljava/time/temporal/TemporalField;)I");
        return Temporal.super.get(temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalField == ChronoField.NANO_OF_DAY) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
                return this.toNanoOfDay();
            }
            RuntimeCostAccounter.recordJump();
            if (temporalField == ChronoField.MICRO_OF_DAY) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
                return this.toNanoOfDay() / 1000L;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.get0:(Ljava/time/temporal/TemporalField;)I");
            return this.get0(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    private int get0(TemporalField temporalField) {
        ChronoField chronoField = (ChronoField)temporalField;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
        switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
            case 1: {
                return this.nano;
            }
            case 2: {
                RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
                UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException("Invalid field 'NanoOfDay' for get() method, use getLong() instead");
                RuntimeCostAccounter.recordThrow();
                throw unsupportedTemporalTypeException;
            }
            case 3: {
                return this.nano / 1000;
            }
            case 4: {
                RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
                UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException("Invalid field 'MicroOfDay' for get() method, use getLong() instead");
                RuntimeCostAccounter.recordThrow();
                throw unsupportedTemporalTypeException;
            }
            case 5: {
                return this.nano / 1000000;
            }
            case 6: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
                return (int)(this.toNanoOfDay() / 1000000L);
            }
            case 7: {
                return this.second;
            }
            case 8: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toSecondOfDay:()I");
                return this.toSecondOfDay();
            }
            case 9: {
                return this.minute;
            }
            case 10: {
                return this.hour * 60 + this.minute;
            }
            case 11: {
                return this.hour % 12;
            }
            case 12: {
                int n;
                int n2 = this.hour % 12;
                RuntimeCostAccounter.recordJump();
                if (n2 % 12 == 0) {
                    n = 12;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = n2;
                }
                return n;
            }
            case 13: {
                return this.hour;
            }
            case 14: {
                int n;
                RuntimeCostAccounter.recordJump();
                if (this.hour == 0) {
                    n = 24;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = this.hour;
                }
                return n;
            }
            case 15: {
                return this.hour / 12;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
        UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
        RuntimeCostAccounter.recordThrow();
        throw unsupportedTemporalTypeException;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getNano() {
        return this.nano;
    }

    @Override
    public LocalTime with(TemporalAdjuster temporalAdjuster) {
        boolean bl = temporalAdjuster instanceof LocalTime;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (LocalTime)temporalAdjuster;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjuster.adjustInto:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (LocalTime)temporalAdjuster.adjustInto(this);
    }

    @Override
    public LocalTime with(TemporalField temporalField, long l) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
            chronoField.checkValidValue(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 1: {
                    int n = (int)l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.withNano:(I)Ljava/time/LocalTime;");
                    return this.withNano(n);
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.ofNanoOfDay:(J)Ljava/time/LocalTime;");
                    return LocalTime.ofNanoOfDay(l);
                }
                case 3: {
                    int n = (int)l * 1000;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.withNano:(I)Ljava/time/LocalTime;");
                    return this.withNano(n);
                }
                case 4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.ofNanoOfDay:(J)Ljava/time/LocalTime;");
                    return LocalTime.ofNanoOfDay(l * 1000L);
                }
                case 5: {
                    int n = (int)l * 1000000;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.withNano:(I)Ljava/time/LocalTime;");
                    return this.withNano(n);
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.ofNanoOfDay:(J)Ljava/time/LocalTime;");
                    return LocalTime.ofNanoOfDay(l * 1000000L);
                }
                case 7: {
                    int n = (int)l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.withSecond:(I)Ljava/time/LocalTime;");
                    return this.withSecond(n);
                }
                case 8: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toSecondOfDay:()I");
                    long l2 = l - (long)this.toSecondOfDay();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusSeconds:(J)Ljava/time/LocalTime;");
                    return this.plusSeconds(l2);
                }
                case 9: {
                    int n = (int)l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.withMinute:(I)Ljava/time/LocalTime;");
                    return this.withMinute(n);
                }
                case 10: {
                    long l3 = l - (long)(this.hour * 60 + this.minute);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusMinutes:(J)Ljava/time/LocalTime;");
                    return this.plusMinutes(l3);
                }
                case 11: {
                    long l4 = l - (long)(this.hour % 12);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusHours:(J)Ljava/time/LocalTime;");
                    return this.plusHours(l4);
                }
                case 12: {
                    long l5;
                    RuntimeCostAccounter.recordJump();
                    if (l == 12L) {
                        l5 = 0L;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        l5 = l;
                    }
                    long l6 = l5 - (long)(this.hour % 12);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusHours:(J)Ljava/time/LocalTime;");
                    return this.plusHours(l6);
                }
                case 13: {
                    int n = (int)l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.withHour:(I)Ljava/time/LocalTime;");
                    return this.withHour(n);
                }
                case 14: {
                    long l7;
                    RuntimeCostAccounter.recordJump();
                    if (l == 24L) {
                        l7 = 0L;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        l7 = l;
                    }
                    int n = (int)l7;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.withHour:(I)Ljava/time/LocalTime;");
                    return this.withHour(n);
                }
                case 15: {
                    long l8 = (l - (long)(this.hour / 12)) * 12L;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusHours:(J)Ljava/time/LocalTime;");
                    return this.plusHours(l8);
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.adjustInto:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalField.adjustInto(this, l);
    }

    public LocalTime withHour(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.hour == n) {
            return this;
        }
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.HOUR_OF_DAY.checkValidValue(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.create:(IIII)Ljava/time/LocalTime;");
        return LocalTime.create(n, this.minute, this.second, this.nano);
    }

    public LocalTime withMinute(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.minute == n) {
            return this;
        }
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.MINUTE_OF_HOUR.checkValidValue(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.create:(IIII)Ljava/time/LocalTime;");
        return LocalTime.create(this.hour, n, this.second, this.nano);
    }

    public LocalTime withSecond(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.second == n) {
            return this;
        }
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.SECOND_OF_MINUTE.checkValidValue(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.create:(IIII)Ljava/time/LocalTime;");
        return LocalTime.create(this.hour, this.minute, n, this.nano);
    }

    public LocalTime withNano(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.nano == n) {
            return this;
        }
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.NANO_OF_SECOND.checkValidValue(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.create:(IIII)Ljava/time/LocalTime;");
        return LocalTime.create(this.hour, this.minute, this.second, n);
    }

    public LocalTime truncatedTo(TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == ChronoUnit.NANOS) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.getDuration:()Ljava/time/Duration;");
        Duration duration = temporalUnit.getDuration();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.getSeconds:()J");
        long l = duration.getSeconds() - 86400L;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 > 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException("Unit is too large to be used for truncation");
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.toNanos:()J");
        long l3 = duration.toNanos();
        RuntimeCostAccounter.recordJump();
        if (86400000000000L % l3 != 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException("Unit must divide into a standard day without remainder");
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
        long l4 = this.toNanoOfDay();
        long l5 = l4 / l3 * l3;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.ofNanoOfDay:(J)Ljava/time/LocalTime;");
        return LocalTime.ofNanoOfDay(l5);
    }

    @Override
    public LocalTime plus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.addTo:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (LocalTime)temporalAmount.addTo(this);
    }

    @Override
    public LocalTime plus(long l, TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusNanos:(J)Ljava/time/LocalTime;");
                    return this.plusNanos(l);
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusNanos:(J)Ljava/time/LocalTime;");
                    return this.plusNanos(l % 86400000000L * 1000L);
                }
                case 3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusNanos:(J)Ljava/time/LocalTime;");
                    return this.plusNanos(l % 86400000L * 1000000L);
                }
                case 4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusSeconds:(J)Ljava/time/LocalTime;");
                    return this.plusSeconds(l);
                }
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusMinutes:(J)Ljava/time/LocalTime;");
                    return this.plusMinutes(l);
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusHours:(J)Ljava/time/LocalTime;");
                    return this.plusHours(l);
                }
                case 7: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusHours:(J)Ljava/time/LocalTime;");
                    return this.plusHours(l % 2L * 12L);
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.addTo:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalUnit.addTo(this, l);
    }

    public LocalTime plusHours(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        int n = ((int)(l % 24L) + this.hour + 24) % 24;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.create:(IIII)Ljava/time/LocalTime;");
        return LocalTime.create(n, this.minute, this.second, this.nano);
    }

    public LocalTime plusMinutes(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        int n = this.hour * 60 + this.minute;
        int n2 = ((int)(l % 1440L) + n + 1440) % 1440;
        RuntimeCostAccounter.recordJump();
        if (n == n2) {
            return this;
        }
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.create:(IIII)Ljava/time/LocalTime;");
        return LocalTime.create(n3, n4, this.second, this.nano);
    }

    public LocalTime plusSeconds(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        int n = this.hour * 3600 + this.minute * 60 + this.second;
        int n2 = ((int)(l % 86400L) + n + 86400) % 86400;
        RuntimeCostAccounter.recordJump();
        if (n == n2) {
            return this;
        }
        int n3 = n2 / 3600;
        int n4 = n2 / 60 % 60;
        int n5 = n2 % 60;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.create:(IIII)Ljava/time/LocalTime;");
        return LocalTime.create(n3, n4, n5, this.nano);
    }

    public LocalTime plusNanos(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
        long l2 = this.toNanoOfDay();
        long l3 = (l % 86400000000000L + l2 + 86400000000000L) % 86400000000000L;
        RuntimeCostAccounter.recordJump();
        if (l2 == l3) {
            return this;
        }
        int n = (int)(l3 / 3600000000000L);
        int n2 = (int)(l3 / 60000000000L % 60L);
        int n3 = (int)(l3 / 1000000000L % 60L);
        int n4 = (int)(l3 % 1000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.create:(IIII)Ljava/time/LocalTime;");
        return LocalTime.create(n, n2, n3, n4);
    }

    @Override
    public LocalTime minus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.subtractFrom:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (LocalTime)temporalAmount.subtractFrom(this);
    }

    @Override
    public LocalTime minus(long l, TemporalUnit temporalUnit) {
        LocalTime localTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/LocalTime;");
            LocalTime localTime2 = this.plus(Long.MAX_VALUE, temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/LocalTime;");
            localTime = localTime2.plus(1L, temporalUnit);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/LocalTime;");
            localTime = this.plus(l2, temporalUnit);
        }
        return localTime;
    }

    public LocalTime minusHours(long l) {
        long l2 = -(l % 24L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusHours:(J)Ljava/time/LocalTime;");
        return this.plusHours(l2);
    }

    public LocalTime minusMinutes(long l) {
        long l2 = -(l % 1440L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusMinutes:(J)Ljava/time/LocalTime;");
        return this.plusMinutes(l2);
    }

    public LocalTime minusSeconds(long l) {
        long l2 = -(l % 86400L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusSeconds:(J)Ljava/time/LocalTime;");
        return this.plusSeconds(l2);
    }

    public LocalTime minusNanos(long l) {
        long l2 = -(l % 86400000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusNanos:(J)Ljava/time/LocalTime;");
        return this.plusNanos(l2);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        block7: {
            block6: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<Chronology> temporalQuery2 = TemporalQueries.chronology();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery2) break block6;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zoneId:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneId> temporalQuery3 = TemporalQueries.zoneId();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery3) break block6;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zone:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneId> temporalQuery4 = TemporalQueries.zone();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery4) break block6;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.offset:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneOffset> temporalQuery5 = TemporalQueries.offset();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery != temporalQuery5) break block7;
            }
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localTime:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<LocalTime> temporalQuery6 = TemporalQueries.localTime();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery6) {
            return (R)this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localDate:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<LocalDate> temporalQuery7 = TemporalQueries.localDate();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery7) {
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.precision:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<TemporalUnit> temporalQuery8 = TemporalQueries.precision();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery8) {
            return (R)ChronoUnit.NANOS;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQuery.queryFrom:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/Object;");
        return temporalQuery.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
        long l = this.toNanoOfDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
        return temporal.with(ChronoField.NANO_OF_DAY, l);
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalTime;");
        LocalTime localTime = LocalTime.from(temporal);
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
            long l = localTime.toNanoOfDay();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
            long l2 = l - this.toNanoOfDay();
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                case 1: {
                    return l2;
                }
                case 2: {
                    return l2 / 1000L;
                }
                case 3: {
                    return l2 / 1000000L;
                }
                case 4: {
                    return l2 / 1000000000L;
                }
                case 5: {
                    return l2 / 60000000000L;
                }
                case 6: {
                    return l2 / 3600000000000L;
                }
                case 7: {
                    return l2 / 43200000000000L;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.between:(Ljava/time/temporal/Temporal;Ljava/time/temporal/Temporal;)J");
        return temporalUnit.between(this, localTime);
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.format:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/String;");
        return dateTimeFormatter.format(this);
    }

    public LocalDateTime atDate(LocalDate localDate) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.of:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return LocalDateTime.of(localDate, this);
    }

    public OffsetTime atOffset(ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.of:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        return OffsetTime.of(this, zoneOffset);
    }

    public int toSecondOfDay() {
        int n = this.hour * 3600;
        n += this.minute * 60;
        return n += this.second;
    }

    public long toNanoOfDay() {
        long l = (long)this.hour * 3600000000000L;
        l += (long)this.minute * 60000000000L;
        l += (long)this.second * 1000000000L;
        return l += (long)this.nano;
    }

    @Override
    public int compareTo(LocalTime localTime) {
        byte by = localTime.hour;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.compare:(II)I");
        int n = Integer.compare(this.hour, by);
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            byte by2 = localTime.minute;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.compare:(II)I");
            n = Integer.compare(this.minute, by2);
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                byte by3 = localTime.second;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.compare:(II)I");
                n = Integer.compare(this.second, by3);
                RuntimeCostAccounter.recordJump();
                if (n == 0) {
                    int n2 = localTime.nano;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.compare:(II)I");
                    n = Integer.compare(this.nano, n2);
                }
            }
        }
        return n;
    }

    public boolean isAfter(LocalTime localTime) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.compareTo:(Ljava/time/LocalTime;)I");
        int n = this.compareTo(localTime);
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isBefore(LocalTime localTime) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.compareTo:(Ljava/time/LocalTime;)I");
        int n = this.compareTo(localTime);
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof LocalTime;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        LocalTime localTime = (LocalTime)object;
        byte by = localTime.hour;
        RuntimeCostAccounter.recordJump();
        if (this.hour != by) return false;
        byte by2 = localTime.minute;
        RuntimeCostAccounter.recordJump();
        if (this.minute != by2) return false;
        byte by3 = localTime.second;
        RuntimeCostAccounter.recordJump();
        if (this.second != by3) return false;
        int n = localTime.nano;
        RuntimeCostAccounter.recordJump();
        if (this.nano != n) return false;
        boolean bl2 = true;
        RuntimeCostAccounter.recordJump();
        return bl2;
    }

    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
        long l = this.toNanoOfDay();
        return (int)(l ^ l >>> 32);
    }

    public String toString() {
        StringBuilder stringBuilder;
        block15: {
            String string;
            int n;
            byte by;
            block14: {
                String string2;
                String string3;
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:(I)V");
                stringBuilder = new StringBuilder(18);
                byte by2 = this.hour;
                byte by3 = this.minute;
                by = this.second;
                n = this.nano;
                RuntimeCostAccounter.recordJump();
                if (by2 < 10) {
                    string3 = "0";
                    RuntimeCostAccounter.recordJump();
                } else {
                    string3 = "";
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(string3);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(by2);
                RuntimeCostAccounter.recordJump();
                if (by3 < 10) {
                    string2 = ":0";
                    RuntimeCostAccounter.recordJump();
                } else {
                    string2 = ":";
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(string2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                stringBuilder4.append(by3);
                RuntimeCostAccounter.recordJump();
                if (by > 0) break block14;
                RuntimeCostAccounter.recordJump();
                if (n <= 0) break block15;
            }
            RuntimeCostAccounter.recordJump();
            if (by < 10) {
                string = ":0";
                RuntimeCostAccounter.recordJump();
            } else {
                string = ":";
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            stringBuilder5.append(by);
            RuntimeCostAccounter.recordJump();
            if (n > 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                stringBuilder.append('.');
                RuntimeCostAccounter.recordJump();
                if (n % 1000000 == 0) {
                    int n2 = n / 1000000 + 1000;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.toString:(I)Ljava/lang/String;");
                    String string4 = Integer.toString(n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
                    String string5 = string4.substring(1);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    stringBuilder.append(string5);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (n % 1000 == 0) {
                        int n3 = n / 1000 + 1000000;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.toString:(I)Ljava/lang/String;");
                        String string6 = Integer.toString(n3);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
                        String string7 = string6.substring(1);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        stringBuilder.append(string7);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.toString:(I)Ljava/lang/String;");
                        String string8 = Integer.toString(n + 1000000000);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
                        String string9 = string8.substring(1);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        stringBuilder.append(string9);
                    }
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder.toString();
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(4, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.nano == 0) {
            RuntimeCostAccounter.recordJump();
            if (this.second == 0) {
                RuntimeCostAccounter.recordJump();
                if (this.minute == 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
                    dataOutput.writeByte(~this.hour);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
                    dataOutput.writeByte(this.hour);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
                    dataOutput.writeByte(~this.minute);
                    RuntimeCostAccounter.recordJump();
                }
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
                dataOutput.writeByte(this.hour);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
                dataOutput.writeByte(this.minute);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
                dataOutput.writeByte(~this.second);
                RuntimeCostAccounter.recordJump();
            }
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
            dataOutput.writeByte(this.hour);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
            dataOutput.writeByte(this.minute);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
            dataOutput.writeByte(this.second);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
            dataOutput.writeInt(this.nano);
        }
    }

    static LocalTime readExternal(DataInput dataInput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        int n = dataInput.readByte();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            n ^= 0xFFFFFFFF;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
            n2 = dataInput.readByte();
            RuntimeCostAccounter.recordJump();
            if (n2 < 0) {
                n2 ^= 0xFFFFFFFF;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
                n3 = dataInput.readByte();
                RuntimeCostAccounter.recordJump();
                if (n3 < 0) {
                    n3 ^= 0xFFFFFFFF;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
                    n4 = dataInput.readInt();
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.of:(IIII)Ljava/time/LocalTime;");
        return LocalTime.of(n, n2, n3, n4);
    }

    static {
        RuntimeCostAccounter.recordArrayAllocation((int)24, (int)8);
        HOURS = new LocalTime[24];
        int n = 0;
        while (true) {
            int n2 = HOURS.length;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            RuntimeCostAccounter.recordAllocation((String)"java/time/LocalTime");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.<init>:(IIII)V");
            LocalTime.HOURS[n] = new LocalTime(n, 0, 0, 0);
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        MIDNIGHT = HOURS[0];
        NOON = HOURS[12];
        MIN = HOURS[0];
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.<init>:(IIII)V");
        MAX = new LocalTime(23, 59, 59, 999999999);
    }
}

