---
layout: barewithrelated
title: GitHub and Git in the Life Sciences
description: GitHub and Git can be used for data, source code, and authoring collaboration in the Life Sciences area of work and research.
path: usecases/_posts/2013-03-03-git-and-github-in-life-sciences.md
---

## Links via Fernando Perez

* [IiPython Notebook on Version Control](http://nbviewer.ipython.org/urls/github.com/fperez/reprosw/raw/master/Version%2520Control.ipynb)
* [A gallery of interesting IPython Notebooks](https://github.com/ipython/ipython/wiki/A-gallery-of-interesting-IPython-Notebooks)

## Links via Karthik Ram, and Titus Brown, Iain Hrynaszkiewicz

* [Social coding and scholarly communication – open for collaboration](http://blogs.biomedcentral.com/bmcblog/2013/02/28/github-and-biomed-central/)
* [Version control for scientific research](http://blogs.biomedcentral.com/bmcblog/2013/02/28/version-control-for-scientific-research/)
* [Git can facilitate greater reproducibility and increased transparency in science.](http://www.scfbm.org/content/8/1/7/)

## Links via GigaScience

* [Crowdsourcing genomic analyses of ash and ash dieback – power to the people](http://www.gigasciencejournal.com/content/2/1/2/)
* [GitHub crowdsource BGI data](https://github.com/ehec-outbreak-crowdsourced/BGI-data-analysis/wiki)
* [GitHub ash dieback crowdsource data](https://github.com/ash-dieback-crowdsource/data)

## GitHub and Git in Scholarly Communication

Titus Brown’s senior author papers & submissions contain links to a tagged software version on GitHub:

* [Scaling metagenome sequence assembly with probabilistic de Bruijn graphs](http://arxiv.org/abs/1112.4193)
    * [khmer source](https://github.com/ged-lab/khmer)
* [A Reference-Free Algorithm for Computational Normalization of Shotgun Sequencing Data](http://arxiv.org/abs/1203.4802)
* [Illumina Sequencing Artifacts Revealed by Connectivity Analysis of Metagenomic Datasets](http://arxiv.org/abs/1212.0159)
* [Assembling large, complex environmental metagenomes](http://arxiv.org/abs/1212.2832)


## Karthik Ram's Papers and Apps:

* [Karthik Ram's GitHub Repos](https://github.com/karthikram)
* [ROpenSci GitHub Repos](https://github.com/ropensci)
* [Genomics, Evolution, and Development Lab GitHub Repos](https://github.com/ged-lab)
* [Chembl RDF Paper on GitHub](https://github.com/egonw/chembl-rdf-paper/commits/master)
* [Soliciting feedback on manuscripts via GitHub Issues and Pull Requests](https://github.com/karthikram/smb_git/issues/)


## Software Carpentry

Directly quoted from their site:

> Software Carpentry helps researchers be more productive by teaching them basic computing skills. We run boot camps at dozens of sites around the world, and also provide open access material online for self-paced instruction. The benefits are more reliable results and higher productivity: a day a week is common, and a ten-fold improvement isn't rare.

* [Software Carpentry Homepage](http://software-carpentry.org/)
* [Software Carpentry Version Control Lesson](http://software-carpentry.org/4_0/vc/index.html)


## Living Books

* ["Living books" - Wiki-like resources for more open & structured communications](http://ivory.idyll.org/blog/rtd-comments-and-editing.html)
* Titus Brown is particularly fond of [this paper from his lab](http://arxiv.org/abs/1203.4802) in which raw data + three GitHub repos + an Amazon AMI give you the entire paper.
* [Crowd-sourcing of E.coli data](https://github.com/ehec-outbreak-crowdsourced/BGI-data-analysis/wiki).
* [ReadTheDocs](https://readthedocs.org)
* [Example ReadTheDocs book](https://readthedocs.org/projects/a-little-book-of-r-for-time-series/)


## Git in the Life Sciences – A Paper by Karthik Ram
* [Git: A powerful tool to facilitate greater reproducibility and transparency in science. – README](https://github.com/karthikram/smb_git/#readme)
* [Git: A powerful tool to facilitate greater reproducibility and transparency in science. – PDF](https://github.com/karthikram/smb_git/blob/master/git_manuscript.pdf?raw=true)
* [Social media response to Karthik's paper](http://altmetric.com/details.php?citation_id=1270911)

-----------------

### Contributors to This List of Resources
* Titus Brown
    * [Michigan State](http://msu.edu)
    * [Email](mailto:ctb@msu.edu)
    * [Blog](http://ivory.idyll.org/blog/)
    * [Lab](http://ged.msu.edu/)
* Karthik Ram
    * [UC Berkeley](http://berkeley.edu)
    * [Twitter](https://twitter.com/_inundata)
    * [Email](karthik.ram@berkeley.edu)
    * [Blog](http://inundata.org)
    * [Lab](http://nature.berkeley.edu/~kram )
* Iain Hrynaszkiewicz
    * [BMC](http://www.biomedcentral.com)
    * [Twitter](http://twitter.com/iainh_z)
* Arfon Smith
    * [Zooniverse](https://www.zooniverse.org)
* Jan Aerts
    * [University of Leuven](http://www.kuleuven.be/english/)
* Matthew McCullough
    * [GitHub](https://github.com)
    * [Email](matthew@github.com)
