---
layout: bare
title: Private Online Foundations
description: Private Online Foundations Class Notes
tags: [notes,online,private]
path: classnotes/2013-06-07-private.md
eventdate: 2013-06-07
---

## Teachers

* Brent Beer ([Twitter](http://twitter.com/brntbeer), [GitHub](https://github.com/brntbeer))

## Resources

* [Open Source Git Ignore Templates](https://github.com/github/gitignore)
* [Book Authoring on Git and GitHub](http://teach.github.com/articles/book-authoring-using-git-and-github/)
* [Post Receive Hooks](https://help.github.com/articles/post-receive-hooks)
* [GitHub Training Videos](http://training.github.com/resources/videos/)
* [Using Git with Media Temple](http://carl-topham.com/theblog/post/using-git-media-temple/)
* [GitHub Training Feedback and Follow-up Questions](https://github.com/githubtraining/feedback/issues?state=open)
* [GitHub Commit Status API for Continuous Integration](https://github.com/blog/1227-commit-status-api)
* [Git Credential Cache for HTTP](http://teach.github.com/articles/lesson-git-credential-cache/)
* [GitHub Issues Cheatsheet](http://teach.github.com/articles/github-issues-cheatsheet/)
* [Jenkins Git Plugin](https://wiki.jenkins-ci.org/display/JENKINS/Git+Plugin)
* [Open Source Git Ignores](https://github.com/github/gitignore)
* [Ship of Theseus - Related to Similarity Index](http://en.wikipedia.org/wiki/Ship_of_Theseus)
* [git-p4 Perforce Script](http://answers.perforce.com/articles/KB_Article/Git-P4)
* [SHA-1 Hash Collisions](http://git-scm.com/book/ch6-1.html#A-SHORT-NOTE-ABOUT-SHA-1)
* [NPD Git Cheatsheet](http://ndpsoftware.com/git-cheatsheet.html)
* [More Git Cheatsheets](http://teach.github.com/articles/git-cheatsheets/)

## Installation

* Git Installation
    * [The Git-SCM Web Site (All Platforms)](http://git-scm.com)
    * [The GitHub for Windows Client and Command Line](http://windows.github.com)
    * [The GitHub for Mac Client and Command Line](http://mac.github.com)
* Minimum is 1.7.ANYTHING, but can have issues with HTTPS credential prompting.
* Best is 1.8.0 or higher

## Suggested Books, Articles

* [Free ProGit Book](http://git-scm.com/book)
* [Getting started with Version Control](http://teach.github.com/articles/lesson-new-to-version-control/)
* [The GitHub Flow](http://scottchacon.com/2011/08/31/github-flow.html)
* [DVCS Workflows Book](https://github.com/zkessin/dvcs-workflows)
* [Git Cheat Sheets](http://teach.github.com/articles/git-cheatsheets/)
* [Git Workflow Links](https://pinboard.in/u:matthew.mccullough/t:git+workflow)

## Course Materials, Links

* [Git Teaching Materials](http://teach.github.com)
* [Course Slides](http://teach.github.com/presentations/)
* [Course Slides Source](https://github.com/github/teach.github.com/tree/gh-pages/presentations)
* [Free Office Hours Sessions](http://training.github.com/web/free-classes/)

## Command History

    git --version
    git config --global user.name
    git config --global user.email
    git config --global user.name "Brent Beer2"
    git config --global user.name
    git config --global user.name "Brent Beer"
    git config --local user.name "GitHub Student"
    pwd
    git config --list
    git config --global core.editor
    git config --global color.ui "auto"
    git config --global --replace-all color.ui "auto"
    git config --global --core.autocrlf
    git config --global core.autocrlf
    git config --global core.autocrlf
    git init newproject
    ls
    ls -l
    ls -p
    cd newproject/
    ls
    ls -pa
    git config --local --list
    git config --local user.name "GitHub Student"
    git config --local user.email "training+githubstudents@github.com"
    git config user.name
    cd ..
    ls
    git config --local --list
    cd newproject/
    git config --local --list
    git --version
    ls -a
    git init
    git config --global --list
    git status
    git config --local --loist
    git config --local --list
    git status
    vim first.txt
    ls
    ls -a
    git status
    git add first.txt
    git status
    git commit -m "start tracking file for learning commit"
    git config --global core.autocrlf
    git config --global core.autocrlf input
    git status
    git status
    ls
    git help commit
    git help commit
    vim first.txt 
    git status
    git add
    git add .
    git status
    git commit -m"setup proper sentence structure"
    git status
    vim first.txt 
    git status
    git status
    git diff
    git diff
    git diff
    git diff
    git diff
    git add first.txt
    git status
    git diff
    git diff --staged
    git commit
    git commit
    vim first.txt 
    git status
    git add .
    git status
    vim first.txt 
    git status
    git diff
    git diff --staged
    git diff HEAD
    git status
    git add first.txt
    git status
    git diff --staged
    git commit -m "add the very last line"
    vim first.txt 
    git diff --color-words
    git diff --word-diff
    This is the[-very-] last line.
    git diff --stat
    git status
    git checkout -- first.txt
    git status
    git log
    git log --stat
    git log --stat --patch
    git log -1
    git log -1 --stat
    git log -1 --stat --patch
    git log -15
    git log -5
    git log -4
    git log -1 --format=full
    git log -1 --format=fuller
    git log -1 --word-diff
    git log -1 -p --word-diff
    git log -1 -p
    git log --graph
    git log -S "1st"
    git log -S "1st" -p
    git log -S "very" -p
    git log -S "last" -p
    git log -S "This" -p
    git log -S "This"
    git log -S "sentence"
    git log --grep="sentence"
    git log --grep="struct"
    git log --grep="first"
    git log --grep="fixed"
    git log --grep="deleted"
    git log --grep="add"
    git help log
    git log --graph --oneline --decorate --all -10
    git diff HEAD
    git diff f9cea7b
    cat .git/HEAD
    cat .git/refs/heads/master 
    git status
    vim first.txt 
    git diff
    man diff
    diff --git a/first.txt b/first.txt
    git log -1 --format=email
    git log -1 --format=email -p | g
    git status
    git checkout -- first.txt
    vim second.txt
    git status
    git add .
    git status
    git commit -m "greeting from san francisco"
    git status
    vim second.txt 
    git status
    git commit -am "greeting specification with state"
    git status
    vim delete_me.txt
    git status
    git add .
    git commit -m "adding file to later delete"
    git rm delete_me.txt
    git status
    ls
    git diff --staged
    git commit -m"deleted file that needed to be deleted"
    ls
    git status
    vim delete_me1.txt
    git status
    git add .
    git commit -m "prepped for deletion"
    git status
    open .
    git status
    git help add
    git add -u delete_me1.txt
    git status
    git status
    git commit -m"really delete a file this time, manually"
    ls
    git status
    ls
    git mv second.txt greeting.txt
    git status
    git diff --staged
    git status
    git commit -m"rename second to greeting"
    ls -la ~ > home_dir.txt
    ls
    git status
    git add home_dir.txt
    git commit -m "begin tracking home_dir"
    mkdir logs
    mv home_dir.txt logs/
    git status
    git status -u
    mkdir projects
    git status -u
    vim logs/home_dir.txt 
    git status
    git status -u
    git add -A .
    git status
    git commit -m "move home dir to logs and make edits"
    git log -1 -p
    git log -1 --stat
    git log -1 --stat -M80
    git log -1 --stat -M75
    git log -1 --stat -M10
    git log greeting.txt
    git log greeting.txt
    git log --follow greeting.txt
    ls
    ls
    vim .htpass
    git status
    git add .
    git commit -m "accidentally save htpass"
    ls
    ls -a
    touch .gitignore
    git status
    vim .gitignore 
    vim projects/test.rb
    git status
    git status -u
    vim .gitignore 
    git status
    git status -u
    git add .gitignore
    git commit -m "begin ignoring project files"
    vim projects/test.rb 
    git status
    vim .gitignore 
    touch special.md
    git status
    git diff
    git help commit
    git commit -am "ignore special file"
    ls projects/
    touch production.rb
    vim .gitignore 
    git status
    mv production.rb projects/
    git status -u
    vim .gitignore 
    git status -u
    vim .gitignore 
    ls projects/
    git status -u
    git checkout .gitignore
    cd projects/
    vim .gitignore
    git status
    cd ..
    vim .gitignore 
    git status
    vim .gitignore 
    git status
    git status -u
    vim .gitignore 
    vim projects/.gitignore 
    vim .gitignore 
    git status -u
    git add -A .
    git status
    git commit -m "special ignores for projects file"
    ls
    ls -a
    vim .htpass 
    git status
    vim .gitignore 
    git status
    git rm --cached -- .htpass
    git status
    git add .gitignore
    git status
    git diff --staged
    git commit -m"remove htpass from repository and ignore changes"
    ls -l
    ls -a
    git config --global --list
    cat /opt/boxen/config/git/gitignore
    git branch
    ls .git/refs/heads
    git branch feature1
    ls .git/refs/heads
    cat .git/refs/heads/feature1 
    cat .git/refs/heads/master 
    git log --graph --oneline --decorate --all
    git log --graph --oneline --decorate --all -5
    git branch
    git branch test HEAD
    git log --graph --oneline --decorate --all -5
    git branch test1 aab6a17
    git log --graph --oneline --decorate --all -5
    git checkout feature1
    git branch
    git status
    ls
    vim first.txt 
    git status
    git commit -am "remove very, soon to be untrue"
    git status
    git checkout master
    git lol
    git lol -5
    git checkout test1 
    vim greeting.txt 
    git status
    git add .
    git status
    git commit -m"note where I came from"
    git checkout master
    git lol -5
    git log -1 --format=raw
    git show b890e8f --format=raw
    git log b890e8f --format=raw
    git show b890e8f --format=raw
    git lol -5
    git checkout feature1 
    vim .
    git commit -am "added true very last line"
    git lol -5
    git config --global alias.lol "log --graph --oneline --decorate --all"
    git lol -5
    git log --oneline feature1..master
    git log --oneline master..feature1
    git log --oneline master..test1
    git log --oneline master..test1 -p
    git lol -5
    git branch -d test
    git branch -d test1
    git log --oneline master..test1
    git branch -D test1
    git branch test_revive 932aeb0
    git lol -5
    git branch test1 932aeb0
    git lol -5
    git help log
    git help log
    git lol -5
    git checkout master
    git branch -m test1 test_revival
    git branch -m test_revival _test_revive
    git branch -m test_revive _test_revive
    git branch -m master production
    git branch -m production master
    git status
    git lol -5
    git branch -d _test_revive 
    git branch -D _test_revive 
    git lol -5
    git checkout feature1 
    git merge test_revive 
    git lol -5
    git log -1 --format=raw
    git log -1 --format=raw -p

## Command History Day 2

    git config --global alias.lol "log --graph --oneline --decorate--all"
    git config --global --list
    git config --global alias.lol "log --graph --oneline --decorate --all"
    git lol -5
    git branch
    git branch BRANCHNAME && git checkout BRANCHNAME
    git checkout -b BRANCHNAME2
    git branch
    git branch -d BRANCHNAME2
    git checkout feature1 
    git branch -d BRANCHNAME2
    git branch -d BRANCHNAME 
    git lol -5
    git branch -m feature1 greetings-next
    git lol -5
    git branch -d test_revive 
    git lol -10
    git lol -10
    git checkout master
    git status
    git lol -10
    git merge greetings-next
    git lol -10
    git branch
    git branch -d greetings-next 
    ls
    cat .gitignore 
    git checkout -b create-readme
    vim README.md
    git status
    git add README.md
    git status
    git commit -m "begin readme instructions"
    git lol -4
    git checkout master
    vim .htpass 
    git status
    ls
    vim greeting.txt 
    git status
    git commit -am "specification where in central IL"
    git lol -5
    git merge create-readme -m "merge create-readme. combine the paths"
    git lol -5
    git branch -d create-readme 
    git branch
    ls
    cat .gitignore 
    git checkout -b readme-edits
    vim README.md 
    git status
    git commit -am "thank you note at bottom"
    git config --local user.name
    git checkout master
    vim README.md 
    git lol -5
    git commit -am "thanks from github student"
    git lol -5
    git merge readme-edits 
    git status
    vim README.md 
    git status
    git add README.md
    git status
    git diff --staged
    git commit
    git status
    git lol -5
    git show 292ff07
    git show ad1885a
    git status
    git lol -5
    git branch -d readme-edits 
    git checkout -b first-edits
    vim first.txt 
    git status
    git commit -am "signoff for the first.txt"
    git checkout master
    vim first.txt 
    git lol master...first-edits -p
    git log master...first-edits -p
    git status
    git commit -am "goodbye message on first"
    git log master...first-edits -p
    git checkout first-edits 
    git status
    vim first.txt 
    git log -1 -p
    git checkout master
    git merge first-edits 
    git status
    git merge --abort
    git status
    git lol -5
    git log -1 -p
    git reset --soft HEAD~1
    git status
    git diff --staged
    git lol -5
    git status
    git commit -m "goodbye from master on first.txt"
    git lol -5
    git reset HEAD~1
    git status
    git diff
    git status
    git commit -am "goodbye from master for first.txt"
    git status
    git lol -5
    git log -1
    git log -1 -p
    git reset --hard HEAD~1
    git lol -5
    git status
    git merge first-edits 
    git status
    git lol -5
    git reset --hard HEAD~1
    git status
    git lol -5
    git checkout first-edits 
    generaterandomchanges 5 random-first txt
    cat random-first
    cat random-first1.txt 
    git lol -10
    git log -1 -p
    git log -2 -p
    git lol -10
    git reset --soft HEAD~4
    git status
    git commit -am "add some random files"
    vim random-first1.txt 
    git commit -am "changed to 21xxx"
    git status
    vim random-first1.txt 
    git commit -am "added non-random text at bottom"
    vim random-first
    vim random-first1.txt 
    git status
    git commit -am "non-random instead of non random"
    git lol -10
    git reset f66469c
    git lol -5
    git diff
    git status
    git commit -am "reset back some changes of one file"
    git lol -10
    git branch -r
    git branch -a
    git branch
    git remote -v
    cd ..
    git clone https://github.com/githubstudent/hellogitworld.git
    ls
    cd hellogitworld/
    git status
    git config --local --list
    git branch -r
    ls .git/refs/remotes
    ls .git/refs/remotes/origin/
    ls .git/refs/heads/
    ls .git
    git remote -v
    git status
    cd ..
    pwd
    cd hellogitworld/
    git remote -v
    git help remote
    git help remote
    git remote --set-url origin https://github.com/githubstudent/hellogitworld.git
    git remote set-url origin https://github.com/githubstudent/hellogitworld.git
    cd ..
    git status
    git remote -v
    cd hellogitworld/
    cd ..
    git --version
    pw
    pwd
    cd hellogitworld/
    git remote -v
    git branch
    ls
    git checkout -b fix-runme-script
    vim runme.sh 
    ./runme.sh 
    git status
    git commit -am "let people know the truth about groovy"
    git branch
    git status
    git push -u origin fix-runme-script 
    git branch -r
    git config --local --list
    git config --local user.name "GitHub Student"
    git config --local user.email "training+githubstudents@github.com"
    git help credential.helper
    git help credential
    git status
    vim runme.sh 
    ./runme.sh 
    git status
    git commit -am "newline for better readability"
    git status
    git push origin/fix-runme-script
    git push origin fix-runme-script
    git status
    git fetch origin
    git checkout master
    git lol -10
    git checkout -b github-student-greeting
    git status
    ls
    vim github-student.md
    git status
    git add .
    git commit -m "begin the greeting process!
    git commit -m'begin the greeting process!'
    git status
    git branch -r
    git push -u origin github-student-greeting
    git status
    git checkout master
    git status
    git fetch
    git remote -v
    git remote add teacher https://github.com/githubteacher/hellogitworld.git
    git remote -v
    git branch -r
    git fetch 
    git fetch teacher
    git branch
    git branch -r
    git status
    git merge teacher/master
    git status
    git fetch origin
    git push origin master
    git log -1 -p
    git fetch teacher
    git merge teacher/master
    git branch
    git fetch teach
    git fetch teacher
    git fetch teacher
    git fetch
    git fetch teacher
    git status
    git merge teacher/master
    git push origin master
    git status
    cd ..
    git clone https://github.com/githubstudent/hellogitworld.git
    git clone https://github.com/githubstudent/hellogitworld.git hgw-student
    cd hgw-student/
    git checkout -b dev
    generaterandomchanges 3 dev-test rb
    git status
    git remote -v
    git push -u origin dev
    git checkout master
    git checkout -b version1
    git status
    ls
    mkdir release
    cd release/
    generaterandomfiles 4 prod-release zip
    git status
    git status -u
    git add .
    git commit -m "added dummy release files"
    cd ..
    generaterandomchanges 2 prod-test java
    git push -u origin version1
    git push -u origin version1

## Chat History Day 1

    Csaba G.  has left the room (Kicked)
    tim  has left the room (Kicked)
    brntbeer  turned off guest access
    brntbeer  turned on guest access
    Alex G.  Hello
    aspires  There you are
    So w
    're still in final prep
    aspires  But, was there anything in particular you wanted to focus on today?
    brntbeer  We just want to remind you that if there's anything in particular you want to dive into today to just let aspires know and he'll bubble it up to me to dive into more in audio!
    this class is for you guys =) so any questions you have, be sure to ask!
    aspires  Hi everyone!
    Michael K.  +1
    paulb  looks good
    Michael K.  Is there a list of or a command to list all of the modifiable items for config?
    aspires  Michael K `git config -l` is a good start
    Michael K.  thanks!
    Youngjae P.  I tried to do git config --local --list but git gave me an error saying that --local is not available. I am on ubuntu
    Ian G.  same here
    nope, i'm in my project
    Youngjae P.  yeah I don't think I have the git folder, where can I get it?
    Ian G.  1.7.0.4
    Youngjae P.  same
    Ian G.  yes, i have .git in my newproject
    Youngjae P.  same
    Ian G.  OK, I'll try to upgrade my git version after today's class.
    yes, global is fine
    lin h.  i'm using 1.7.12, not 1.8 . hope that won't be a problem
    plus, i don't see hub version#
    aspires  hub is an extra plugin
    lin h.  oh
    aspires  https://github.com/defunkt/hub if you're interested
    lin h.  thanks :)
    Alex G.  View paste 
    I am getting warning: LF will be replaced by CRLF in first.txt.
    The file will have its original line endings in your working directory.
    Mac
    Alex G.  View paste 
    agitelman-lt:newproject agitelman$ git config --global core.autocrlf
    true
    Why would it want to replace those?
    Mac and Unix should just use LF, no?
    I mean, why git want to replace it when I have it as auto?
    ok
    I am just curious why they use CRLF
    for repository
    anyway
    it's ok
    Steven A.  Is there always one top level tree for each commit object?
    View paste 
    Or can it be
    commit
       tree-a
       tree-b
    Steven A.  View paste 
    Does
    git add .
    add everything in the current directory, recursively?
    aspires  Steven A -- It does
    Ian G.  can you say more about the --patch argument ... why "patch"? What does "patch" actually mean in this context?
    brntbeer  the --patch command itself is just a keyword that has stuck around for a while with Git. the "patch" is actually just "what is the change between these two versions of a file
    so, it's not the ENTIRE file, but just the change set between the two
    Michael K.  does git pick up a manually deleted file? As in if I was you deleted a file using the systems rm <filename>, would git pick up on the deletion?
    Michael K.  it seems that when you do git rm on dir/file, is there a way to keep the file from being deleted?
    lin h.  don't have git lol -- maybe that's a new thing in version 1.8
    brntbeer  git config --global alias.lol "log --graph --oneline --decorate --all"
    lin h.  thanks
    Alex G.  is there way to find out refs on branch that has been deleted?
    anant  thanks
    brntbeer  Thanks guys!

## Chat History Day 2

    Alex G.  Good morning
    brntbeer  good morning!
    Alex G.  +1
    can hear
    Steven A.  View paste 
    One of the things I'd really like to talk about today is workflow around branching, and cloned projects.  I have a project that is in production, that I'm working on for the next release (master -> prod; dev -> upcoming release).
    We clone that project to deploy instances of the application.  That's already getting challenging, and we only  have 4 instances.  Soon we'll have more then 20.
    Add to this that the project is also the "master" project for another project with a similar release schedule.
    How do we manage all these branches without getting confused?
    Steven A.  I'm confused, too ;-)
    Is that github.com/githubtraining/feedback ?
    Steven A.  Thanks
    brntbeer  View paste 
    git config --global alias.lol "log --graph --oneline --decorate--all"
    View paste 
    git config --global alias.lol "log --graph --oneline --decorate --all"
    Michael K.  Is anyone else experiencing intermittent white noise that interrupts Brent?
    Alex G.  no noise for me
    Ian G.  nope, sound is fine for me
    Alex G.  sound could be a bit louser
    louder
    Michael K.  I will let you know if it comes back
    Alex G.  my mac is at max but it's still too quiet
    it's ok. I can manage
    paulb  mac speakers are pretty weak sauce, i would suggest getting some headphones or external speakers.
    Alex G.  What is alternative to fast-forward? Rebase?
    Alex G.  So the only difference between fast-forward and recursive is presence of commits on master?
    or other branch
    Ian G.  (now I'm getting that sound problem Michael K. described earlier)
    Michael K.  Im still getting it as well.
    Ian G.  it's intermittent, we'll see
    Alex G.  How does git determine that merge is required? Doe sit keep track of it or just looks at content and markers?
    I guess it answers the question as markers are removed.
    Steven A.  I think conflicts are simplistic line to line compare - if line X is changed in both branches, there's a conflict
    Alex G.  If we reset (soft/mixed) to more than 1 commit back, what will be staged or modified locally?
    Alex G.  And if changes are on the same file? It will just take latest version?
    So it seems that soft reset can be used to delete some intermediate commits
    brntbeer  https://github.com/githubteacher/hellogitworld
    Leah  i need help when you have a chance
    aspires  Leah what are you running into?
    Leah  fatal: bad default revision 'HEAD
    aspires  What commands did you run that threw the error?
    Leah  log
    aspires  ok
    aspires  do you still see this error when you run `git log --all`
    Leah  yes
    aspires  what do you see when you run `git branch`
    Leah  nothing
    aspires  It sounds like there was a clone issue. so running `git pull origin master` may sort it out
    there's no branch for HEAD to be referenced on, which is what the first error means
    Leah  fatal: Origin does not appear to be a git repositry
    I figured that was the problem, that HEAD couldn't point to anything
    Was trying to figure out how to make it point to something
    aspires  what's your output from `git remote -v`, and what's your github profile
    Leah  from the remote -v command, I have origin and upstream
    How do I access my profile?
    aspires  Leah it should be github.com/your-profile-name
    Aditya  I am getting :
    View paste 
    [ asakhuja: ~/gitplace/hellogitworld ]$ git remote -v
    origin  git@github.com:githubstudent/hellogitworld.git (fetch)
    origin  git@github.com:githubstudent/hellogitworld.git (push)
    Were we expecting the https:// protocol
    aspires  git remote --set-url origin https://...
    Alex G.  What if I set it to some unrelated project?
    Steven A.  Using the git protocol is okay, too, right? We don't have to use https, right?
    aspires  Alex -- you wont be able to push or pull with an unrelated remote
    Steven A.  Just made a mistake, that's all
    aspires  No problem
    Aditya  View paste 
    Got it . [ asakhuja: ~/gitplace/hellogitworld ]$ git remote -v
    origin  https://github.com/sakhuja/hellogitworld.git (fetch)
    origin  https://github.com/sakhuja/hellogitworld.git (push)
    thanms
    thanks
    aspires  thats why git remote set-url is easy
    Steven A.  View paste 
    git remote set-url origin https://github.com/sanderson-sfdc/hellogitworld.git
    worked
    Leah  naw -- my system is still hosed. Austin -- is there another chat we can continue to use?
    Leah  version 1.8.1
    aspires  Leah -- going back to your scratch directory, can you remove your existing hellogitworld project?
    Leah  I'm trying the clone again. It's thinking about it.
    aspires  Is the clone still running?
    Leah  yes
    aspires  It should be done by now -- I just cloned your fork as a test
    Leah  kill it?
    aspires  I'd say so
    Steven A.  View paste 
    Would you say every time you start working on a new fix or feature you should create a fix-specific branch, with a name that makes sense for the fix/feature?
    Like you did with fix-runme-script
    aspires  Leah just to double check, you're running `git clone https://github.com/lcutter/hellogitworld.git`, right?
    Leah  just found a typo.
    Alex G.  Is this ok: error: git-credential-osxkeychain died of signal 11
    Other messages suggest that it may have gone through. How do I check?
    View paste 
    agitelman-lt:hellogitworld agitelman$ git push -u origin fix-runme-script
    error: git-credential-osxkeychain died of signal 11
    Username for 'https://github.com': agitelman
    Password for 'https://agitelman@github.com': 
    error: git-credential-osxkeychain died of signal 11
    Counting objects: 5, done.
    Delta compression using up to 4 threads.
    Compressing objects: 100% (3/3), done.
    Writing objects: 100% (3/3), 360 bytes | 0 bytes/s, done.
    Total 3 (delta 1), reused 0 (delta 0)
    To https://github.com/agitelman/hellogitworld.git
     * [new branch]      fix-runme-script -> fix-runme-script
    Branch fix-runme-script set up to track remote branch fix-runme-script from origin.
    agitelman-lt:hellogitworld agitelman$ git --version
    git version 1.8.3
    i see
    brntbeer  git config --local credential.helper cache
    aspires  if you'd like a quick Markdown reference, hit `m` on GitHub.com to pull up some documentation
    aspires  http://www.emoji-cheat-sheet.com/ if you're interested
    aspires  git remote add teacher https://github.com/githubteacher/hellogitworld.git
    lin h.  what app you are drawing with? looks very nice
    aspires  Lin -- http://evernote.com/skitch/
    lin h.  thanks :)
    Steven A.  What was the merge command you used?
    git merge <remote_name>/<branch_name>
    and it merges into the branch I'm on now
    Ah, that's a good distinction, thanks
    paulb  workflow question, lets say you have 2 branches (dev and version1) and you want them both on your laptop at one time so you can run them side by side (say for testing). do you just setup another folder and set the branch on that folder?
    paulb  i need the working files for dev and version1 on the laptop so that I could compile and run them at the same time without having to switch branches. so i can do a side by side comparison.
    Ian G.  Thanks!
    Steven A.  Thanks!
    Alex G.  Thank you
    lin h.  Thanks ~
    Aditya  Anyone has the link to this presentation ?
    brntbeer  Aditya: it's at teach.github.com/presentations/git-foundations.html as i showed at the end of class
    it'll also be included in after class notes
    Aditya  thanks. Somehow I only see the title slides with this link
    I am on chrome
    brntbeer  yes
    hit the "?" key
    you then can move around the slide
    slides*
    its a set of slides on the web
    Aditya  ah fancy
    thanks
    brntbeer  np
