---
layout: bare
title: Aarhus University
description: Aarhus Class Notes
tags: [notes]
path: classnotes/2013-05-14-aarhus.md
eventdate: 2013-05-14
---

## Teachers
* Brent Beer ([Twitter](http://twitter.com/brntbeer), [GitHub](https://github.com/brntbeer))

## Resources

* [GitHub Training Videos](http://training.github.com/resources/videos/)
* [GitHub Training Feedback and Follow-up Questions](https://github.com/githubtraining/feedback/issues?state=open)
* [Git Credential Cache for HTTP](http://teach.github.com/articles/lesson-git-credential-cache/)
* [GitHub Issues Cheatsheet](http://teach.github.com/articles/github-issues-cheatsheet/)
* [Open Source Git Ignores](https://github.com/github/gitignore)
* [git-p4 Perforce Script](http://answers.perforce.com/articles/KB_Article/Git-P4)
* [Unix watch command](http://en.wikipedia.org/wiki/Watch_(Unix\))
* [SHA-1 Hash Collisions](http://git-scm.com/book/ch6-1.html#A-SHORT-NOTE-ABOUT-SHA-1)
* [NPD Git Cheatsheet](http://ndpsoftware.com/git-cheatsheet.html)
* [More Git Cheatsheets](http://teach.github.com/articles/git-cheatsheets/)

## Installation
* Git Installation
    * [The Git-SCM Web Site (All Platforms)](http://git-scm.com)
    * [The GitHub for Windows Client and Command Line](http://windows.github.com)
* Minimum is 1.7.ANYTHING, but can have issues with HTTPS credential prompting.
* Best is 1.8.0 or higher

## Suggested Books, Articles
* [Free ProGit Book](http://git-scm.com/book)
* [Getting started with Version Control](http://teach.github.com/articles/lesson-new-to-version-control/)
* [The GitHub Flow](http://scottchacon.com/2011/08/31/github-flow.html)
* [DVCS Workflows Book](https://github.com/zkessin/dvcs-workflows)
* [Git Cheat Sheets](http://teach.github.com/articles/git-cheatsheets/)
* [Git Workflow Links](https://pinboard.in/u:matthew.mccullough/t:git+workflow)

## Course Materials, Links
* [Git Teaching Materials](http://teach.github.com)
* [Course Slides](http://teach.github.com/presentations/git-for-education-from-svn.html)
* [Free Office Hours Sessions](http://training.github.com/web/free-classes/)

## Command History
    git --version
    cd ..
    cd ~/code/
    git init hellogitworld
    cd hellogitworld/
    git status
    vim hello_denmark.txt
    mvim .
    git status
    git add .
    git commit -m "begin introductions"
    git log -1
    git config --global user.name
    git config --global user.email
    whoami
    vim hello_denmark.txt 
    git status
    git add hello_denmark.txt
    git status
    git diff --staged 
    vim hello_denmark.txt 
    git status
    git add hello_denmark.txt
    git status
    git diff --staged
    git reset HEAD hello_denmark.txt
    git status
    git commit -am "information about where i'm staying"
    cd 
    cd scratch/git/
    git pull origin
    git status
    git checkout master
    git pull origin master
    git log -10
    git log --format=oneline
    git log --oneline
    git log --oneline --author=peff
    git log --author=peff
    git log --author=peff -1 --stat
    git log --author=peff -1 --format=oneline --patch
    git log a22e6f8 -p
    git log -1 --format=raw
    cd 
    cd github/teach.github.com/
    git status
    git brancgh
    git branch
    git checkout 02-06-Custom-Foundations
    git stash
    git checkout 02-06-Custom-Foundations
    git status
    git checkout -
    git checkout -
    git checkout -
    cd -
    cd -
    cd -
    cd -
    git status
    git checkout gh-pages
    vim .
    git status
    git diff presentations/
    git commit -am "change intro"
    git status
    ls
    rm -rf classnotes/
    git status
    git add .
    git status
    git add -u
    git git status
    git status
    git commit -m "whoops"
    git status
    git status
    git fetch
    git status
    git reset --hard origin/gh-pages
    git status
    git reflog -5
    git reflog -10
    git checkout foundations-education-presentation 
    git reflog -10
    git status
    git checkout gh-pages
    git reset --hard 8ace996
    git status
    git reset --hard origin/gh-pages
    git status
    git checkout foundations-education-presentation 
    git status
    git stash list
    git stash pop
    git diff
    git add .
    git status
    git commit -m "fixed readability"
    git status
    git checkout gh-pages
    git merge foundations-education-presentation 
    git status
    git push origin gh-pages
    git branch -d foundations-education-presentation 
    git log --graph --oneline --decorate --all
    git branch foundations-presentations-example ffed9fa
    git log --graph --oneline --decorate --all
    git log -1 --format=raw
    git log --graph --oneline --decorate --all
    cd ~/scratch/
    git clone https://github.com/githubteacher/hellogitworld
    cd hellogitworld/
    git branch feature-aarhus
    git checkout feature-aarhus 
    mvim .
    git status
    git status
    git diff
    git add -p
    git status
    cd 
    cd code/descartes/
    git status
    git status
    git checkout -b env-password-escaped
    git fetch
    git checkout master
    git merge origin/master
    git checkout env-password-escaped 
    git merge master 
    git status
    mvim .
    export $PS1="$"
    git status
    git diff
    git add -p
    git status
    git commit
    git status
    git diff
    git log -1 -p
    git status
    git remote -v
    git status
    git push -u brntbeer env-password-escaped 
    git help remote
    git remote set-url brntbeer https://github.com/obfuscurity/descartes https://github.com/brntbeer/descartes
    git remote set-url brntbeer https://github.com/obfuscurity/descartes https://github.com/brntbeer/descartes.git
    git remote set-url brntbeer https://github.com/brntbeer/descartes https://github.com/obfuscurity/descartes 
    git remote -v
    git push -u brntbeer env-password-escaped 
    cd 
    cd code/hellogitworld/
    git status
    ls
    mkdir features
    git status
    ls
    mv featurethirteen* features/
    ls
    ls features/
    git status
    git status -u
    git add -A 
    git status
    git branch feature-move
    git status
    git checkout feature-move
    git status
    git commit -m "move all features"
    git status
    git checkout master
    git merge origin/master
    git reset --hard origin/master
    git status
    generaterandomchanges 5 denmark txt
    git status
    git log --graph --oneline --decorate --all
    git status
    git checkout feature-move 
    git status
    git rebase -i master
    git reflog
    git reset --hard HEAD@{4}
    git reflog
    git reset --hard HEAD@{6}
    git status
    git help reflog
    git help reset
    git help gc
    git help gc
    cd 
    cd scratch/git/
    vim .git
    got tag
    got tags
    git tag
    git show v1.8.3-rc2
    cd ..
    ls
    cd hellogitworld/
    git tags
    git tag
    git show RELEASE_1.0
    git ls-remote
    cd ..
    mkdir test-aarhus
    cd test-aarhus/
    svn co https://github.com/github/teach.github.com.git

