---
layout: bare
title: Space Apps Git and GitHub Workshop
description: Space Apps (Spaceship) Finland Git and GitHub Workshop Class Notes
tags: [notes,online]
path: classnotes/2013-04-19-spaceapps-github-workshop.md
eventdate: 2013-04-19
---

## Event Links
* [Spaceship, Space Apps GitHub Workshop Annoucement](http://spaceship.fi/content/git-github-training-confirmed)
* [Spaceship Agenda](http://spaceship.fi/agenda)
* [NASA Code](http://code.nasa.gov/project/)
* [Conway's Game of GitHub Contributions](http://gitlife.mrmikea.com)
* [Space Apps Challenge](http://spaceappschallenge.org)

## Event 1: Hands on Git and GitHub Workshop
> Friday, April 19, 17:00-18:00  
> Demola stage / Meeting room (3rd floor)  
> The tool names Git and GitHub are being used all over the world of open source and open science and are even extensively used by NASA. If you haven't yet had time to get familiar with these tools, join us for a hour long getting-started workshop that will have you up and running with both the terminology and the technology of this collaborative working platform and version control system. This workshop will be facilitated by Matthew McCullough of the GitHub Training Team and John Britton of the GitHub Education Team.

## Event 2: The Versatile World of GitHub
> Saturday, April 20, 15:00-15:45  
> Stage 2, 4th Floor  
> When technologists hear the name GitHub, they might often think of programming and open source. That would be accurate, but stops far short of the modern uses of this platform. We're seeing everything from Law Tracking to Book Authoring and 3D Modeling to Biological Data collection performed on this unique collaborative platform. Come get a front-to-back tour of the amazing ways that GitHub is re-shaping development practices, fostering chatops, hosting blogs, tracking homework, storing biological data, proliferating 3D modeling and printing. Along the way, you'll get a first hand tour of how GitHub is facilitating easier collaboration and distributed working from cities around the globe on the ever expanding realm of writing, data and software development. These examples map directly on to tuneups you can make to your school, university, hobby, or job efforts.

## Teachers
* John Britton ([Twitter](http://twitter.com/XX), [GitHub](https://github.com/johndbritton))
* Matthew McCullough ([Twitter](http://twitter.com/matthewmccull), [GitHub](https://github.com/matthewmccullough))

## Resources
* [Open Source Git Ignore Templates](https://github.com/github/gitignore)
* [Book Authoring on Git and GitHub](http://teach.github.com/articles/book-authoring-using-git-and-github/)
* [Post Receive Hooks](https://help.github.com/articles/post-receive-hooks)
* [GitHub Training Videos](http://training.github.com/resources/videos/)
* [Using Git with Media Temple](http://carl-topham.com/theblog/post/using-git-media-temple/)
* [GitHub Training Feedback and Follow-up Questions](https://github.com/githubtraining/feedback/issues?state=open)
* [GitHub Commit Status API for Continuous Integration](https://github.com/blog/1227-commit-status-api)
* [Git Credential Cache for HTTP](http://teach.github.com/articles/lesson-git-credential-cache/)
* [GitHub Issues Cheatsheet](http://teach.github.com/articles/github-issues-cheatsheet/)
* [Jenkins Git Plugin](https://wiki.jenkins-ci.org/display/JENKINS/Git+Plugin)
* [Open Source Git Ignores](https://github.com/github/gitignore)
* [Ship of Theseus - Related to Similarity Index](http://en.wikipedia.org/wiki/Ship_of_Theseus)
* [git-p4 Perforce Script](http://answers.perforce.com/articles/KB_Article/Git-P4)
* [Unix watch command](http://en.wikipedia.org/wiki/Watch_(Unix\))
* [SHA-1 Hash Collisions](http://git-scm.com/book/ch6-1.html#A-SHORT-NOTE-ABOUT-SHA-1)
* [NPD Git Cheatsheet](http://ndpsoftware.com/git-cheatsheet.html)
* [More Git Cheatsheets](http://teach.github.com/articles/git-cheatsheets/)
* [Adding SSL Certificates for GitHub.com (Common for Windows XP)](http://stackoverflow.com/questions/3777075/https-github-access/4454754#4454754)
* Disabling SSL Certificate Checks for Git:

        git config --global http.sslVerify false


## Installation
* Git Installation
    * [The Git-SCM Web Site (All Platforms)](http://git-scm.com)
    * [The GitHub for Windows Client and Command Line](http://windows.github.com)
    * [The GitHub for Mac Client (no Command Line)](http://mac.github.com)
* Minimum is 1.7.ANYTHING, but can have issues with HTTPS credential prompting.
* Best is 1.8.0 or higher

## Suggested Books, Articles
* [Free ProGit Book](http://git-scm.com/book)
* [Getting started with Version Control](http://teach.github.com/articles/lesson-new-to-version-control/)
* [The GitHub Flow](http://scottchacon.com/2011/08/31/github-flow.html)
* [DVCS Workflows Book](https://github.com/zkessin/dvcs-workflows)
* [Git Cheat Sheets](http://teach.github.com/articles/git-cheatsheets/)
* [Git Workflow Links](https://pinboard.in/u:matthew.mccullough/t:git+workflow)

## Course Materials, Links
* [Git Teaching Materials](http://teach.github.com)
* [Course Slides](http://teach.github.com/articles/course-slides/)
* [Post-event Git and GitHub questions](https://github.com/githubtraining/feedback/)
* [Free Office Hours Sessions](http://training.github.com/web/free-classes/)

# Objectives
* GitHub
    * Create an account
* Git
    * Install from http://git-scm.com
* Create a Repo
    * Locally
    * On the Web
* GUI options
    * Platform independent
    * Mac
    * Windows
* Branching
* Merging
* Forks
* Pull Requests
* Success!
