---
layout: bare
title: SIGCSE 2013
description: SIGCSE 2013 Class Notes
tags: [notes,workshop]
path: classnotes/2013-03-06-sigcse-2013.md
eventdate: 2013-03-06
---

## Teachers
* Tim Berglund ([Twitter](http://twitter.com/tlberglund), [GitHub](https://github.com/tlberglund))
* John Britton ([Twitter](http://twitter.com/johndbritton), [GitHub](https://github.com/johndbritton))

## Resources

* [Adding SSL Certificates for GitHub.com (Common for Windows XP)](http://stackoverflow.com/questions/3777075/https-github-access/4454754#4454754)
* Disabling SSL Certificate Checks for Git:

        git config --global http.sslVerify false
* [Open Source Git Ignore Templates](https://github.com/github/gitignore)
* [Book Authoring on Git and GitHub](http://teach.github.com/articles/book-authoring-using-git-and-github/)
* [Post Receive Hooks](https://help.github.com/articles/post-receive-hooks)
* [GitHub Training Videos](http://training.github.com/resources/videos/)
* [Using Git with Media Temple](http://carl-topham.com/theblog/post/using-git-media-temple/)
* [GitHub Training Feedback and Follow-up Questions](https://github.com/githubtraining/feedback/issues?state=open)
* [GitHub Commit Status API for Continuous Integration](https://github.com/blog/1227-commit-status-api)
* [Git Credential Cache for HTTP](http://teach.github.com/articles/lesson-git-credential-cache/)
* [GitHub Issues Cheatsheet](http://teach.github.com/articles/github-issues-cheatsheet/)
* [Jenkins Git Plugin](https://wiki.jenkins-ci.org/display/JENKINS/Git+Plugin)
* [Open Source Git Ignores](https://github.com/github/gitignore)
* [Ship of Theseus - Related to Similarity Index](http://en.wikipedia.org/wiki/Ship_of_Theseus)
* [git-p4 Perforce Script](http://answers.perforce.com/articles/KB_Article/Git-P4)
* [Unix watch command](http://en.wikipedia.org/wiki/Watch_(Unix\))
* [SHA-1 Hash Collisions](http://git-scm.com/book/ch6-1.html#A-SHORT-NOTE-ABOUT-SHA-1)
* [NPD Git Cheatsheet](http://ndpsoftware.com/git-cheatsheet.html)
* [More Git Cheatsheets](http://teach.github.com/articles/git-cheatsheets/)

## Installation
* Git Installation
    * [The Git-SCM Web Site (All Platforms)](http://git-scm.com)
    * [The GitHub for Windows Client and Command Line](http://windows.github.com)
* Minimum is 1.7.ANYTHING, but can have issues with HTTPS credential prompting.
* Best is 1.8.0 or higher

## Suggested Books, Articles
* [Free ProGit Book](http://git-scm.com/book)
* [Getting started with Version Control](http://teach.github.com/articles/lesson-new-to-version-control/)
* [The GitHub Flow](http://scottchacon.com/2011/08/31/github-flow.html)
* [DVCS Workflows Book](https://github.com/zkessin/dvcs-workflows)
* [Git Cheat Sheets](http://teach.github.com/articles/git-cheatsheets/)
* [Git Workflow Links](https://pinboard.in/u:matthew.mccullough/t:git+workflow)

## Course Materials, Links
* [Git Teaching Materials](http://teach.github.com)
* [Course Slides](http://teach.github.com/articles/course-slides/)
* [Post-event Git and GitHub questions](https://github.com/githubtraining/feedback/)
* [Free Office Hours Sessions](http://training.github.com/web/free-classes/)

## Outline

* Sheraton Meeting Rooms
  * ACM13

* GitHub Organization Model
* GitHub Web Flow Beginnings
* Cloning
* Adding and Committing from the Command Line
* Diff and Log
* Delete and Move
* Branching and Merging 
* Resolving Merge Conflicts
* Remotes
* Pull Requests
  * Creating
  * Merging
  * Resolving conflicts
  * Collaboration Platform
* GHfM/GHfW
* Reset
* Common Academic Workflows
  * Distributing Assignments
  * Group work
  * Individiual work
  * Assignment submission
  * Robotic grading
* Optional Advanced Topics
  * Rebasing
  * Reflog
  * Revert
* Teacher User Group
* [Denver Drinkup](https://github.com/blog/1429-denver-drinkup) on Thursday!

## Command History

### Part I - Commands by Tim
```
  git clone https://github.com/githubteachingorg/poetry.git
  ls
  cd poetry
  ls
  ls -la
  tree .git -L 1
  ls -la .git
  tree .git/objects
  ls
  vi caesar.txt
  git status
  git add caesar.txt
  git status
  git commit -m "The noblest man"
  git config --global user.name "Tim Berglund"
  git config --global user.email "tlberglund@github.com"
  git config --global color.ui auto
  vi ~/.gitconfig
  git config --local --list
  cat .git/config
  git status
  git diff
  ls
  vi caesar.txt
  git status
  git diff
  git add caesar.txt
  git status
  git diff
  git diff --staged
  git status
  vi caesar.txt
  git status
  git diff --staged
  git status
  git diff
  git diff HEAD
  git diff --color-words
  git diff --word-diff
  git diff HEAD --word-diff
  ls
  git status
  cat caesar.txt
  git commit -m "Costly blood"
  git status
  git add .
  git status
  git commit -m "Fixed up accent so line scans as iambic penameter"
  git commit --amend -m "Fixed up accent so line scans as iambic pentameter"
  git status
  git log
  git log --stat
  git log --patch
  git log --format=raw
  git log --format=raw -1
  git log --pretty=oneline
  git log --pretty=oneline --abbrev-commit
  git log --pretty=oneline --abbrev-commit --graph
  git log --pretty=oneline --abbrev-commit --graph --decorate
  git log --pretty=oneline --abbrev-commit --graph --decorate --all
  git config --global alias.lol "log --pretty=oneline --abbrev-commit --graph --decorate --all"
  git lol
  tree .git/objects
  tree .git/objects | less
  ls
  git status
  git log
  git hash-object README.md
  cat README.md
  git hash-object README.md
  cat .git/objects/3b/ee18368ebe976702b5264c7cefce365d0636a4
  git show 3bee18368ebe976702b5264c7cefce365d0636a4
  tree .git/objects
  git show ed560af
  git show cd978
  git ls-tree cd978
  git show 3bee18368ebe976702b5264c7cefce365d0636a4
  git status
  mkdir files
  generaterandomfiles 5 file txt
  rmdir files
  git status
  git add .
  git status
  git commit -m "Junk files"
  git log --stat -1
  ls
  git rm file1.txt
  ls
  git status
  rm file2.txt
  git status
  git rm file2.txt
  git status
  open .
  git status
  git add .
  git status
  git add -u .
  git status
  git commit -m "Cleaned up cruft"
  git log --stat -2
  ls
  git lol
  git checkout 07192f9 -- file1.txt
  ls
  git status
  git reset --hard HEAD
  git lol
  ls
  generaterandomfiles 5 file txt
  mkdir files
  ls -l ~ > listing.txt
  ls
  ls -l
  git status
  git add .
  git commit -m "Preparing to move files"
  tree
  git mv file1.txt files/
  tree
  git status
  mv file2.txt files/
  tree
  git status
  git rm file2.txt
  git status
  git add files/file2.txt
  git status
  git add -A .
  git status
  vi listing.txt
  git status
  git add -A .
  git status
  git commit -m "How can this possibly work?"
  git log --stat -2
  git log --stat -2 -M
  git log --stat -2 -M90
  git log --stat -2 -M35
  history
  history | tail
  tr.git
  cd scratch
  cd poetry
  history
  git lol
  git status
  git branch
  git lol
  tree .git/refs
  cat .git/refs/heads/master
  git lol
  tr.git
  cd scratch
  cd poetry
  git loglive
  git branch feature
  git branch
  vi caesar.txt
  git add .
  git commit -m "Ruby lips"
  cat caesar.txt
  git checkout feature
  git branch
  cat caesar.txt
  vi caesar.txt
  git add .
  git commit -m "Added a title to Caesar"
  git lol
  git checkout master
  git merge feature -m "Merged feature branch"
  git lol
  tr.git
  cd scratch/poetry
  git status
  git checkout feature
  git status
  git checkout master
  git branch -d feature
  git log --format=raw -1
  git branch feature2
  git checkout feature2
  ls
  git status
  git branch
  vi caesar.txt
  git add .
  git commit -m "Senseless enhancement of title"
  cat ~/scripts/git-loglive
  git checkout master
  vi caesar.txt
  git add .
  git commit -m "Cursed limbs"
  git lol
  history
  git branch
  git merge feature2
  git branch -d feature2
  vi caesar.txt
  git add .
  git commit -m "Domestic fury"
  git branch feature3 b8b7004
  git checkout feature3
  vi caesar.txt
  vi raven.txt
  git status
  git add .
  git status
  git commit -m "Buggy Shakespeare, correct Poe"
  git loglive -15
  git lol
  git checkout master
  git merge feature3
  git status
  vi caesar.txt
  git add caesar.txt
  git status
  git commit
  git loglive -12
  git lol
  git status
  git reset --hard cb02
  cat caesar.txt
  git merge feature3
  kdiff3
  diff3
  p4merge
  git config --global merge.tool p4merge
  git config --global mergetool.prompt false
  git config --global mergetool.keepBackups false
  git help config
  git config --global mergetool.keepBackup false
  git config --global mergetool.keepTemporaries false
  git config --global --unset mergetool.keepBackups
  git mergetool
  git status
  git commit
  git remote
  git remote -v
  git lol
  git branch -a
  git push
  git config push.default
  git config --global push.default simple
  vi .git/config
  git pull
  vi caesar.txt
  git add .
  git commit -m "Smiley mothers"
  git push
  git fetch
  git lol
  git diff origin/master
  git status
  git merge origin/master
  git push
  git status
  tr.git
  export PS1="$ "
  cd scratch/
  ls
  git clone https://github.com/githubstudent/poetry.git forked-poetry
  ls
  cd forked-poetry
  ls
  git remote -v
  vi caesar.txt
  git add .
  git commit -m "Choked pity"
  git push
  vi caesar.txt
  git add .
  git commit -m "Caesar rage"
  git push
  git config credential.helper
  git lol
  git pull
  git loglive -10
  git fetch 3637e17..4b6ce18
  git fetch https://github.com/githubstudent/poetry.git master
  git merge FETCH_HEAD
  vi caesar.txt
  git add caesar.txt
  git commit
  git push
```

### Part II - Commands by John
```
  cd web-team/
  pwd
  clear
  clear
  ls
  ls -alh 
  git status
  git remote -v
  git remote add team1 git@github.com:githubteachingorg/assignment1-team1.git
  git remote -v
  git remote add team2
  git remote add team2 git@github.com:githubteachingorg/assignment1-team2.git
  git remote rm team2
  git remote add team2 git@github.com:githubteachingorg/assignment1-team2.git
  git remote add team3 git@github.com:githubteachingorg/assignment1-team3.git
  git remote -v
  clear
  git remote -v
  git push team1 gh-pages
  git push team2 gh-pages
  git push team3 gh-pages
  clear
  git status
  touch README.md
  git status
  nano README.md 
  git status
  git add README.md 
  git status
  git commit -, 
  git commit -m 'update: add a readme'
  git push origin gh-pages
  git push team1 gh-pages
  git push team2 gh-pages
  git push team3 gh-pages
  cd ..
  ls
  git clone git@github.com:githubteachingorg/assignment1-team3.git
  git add remote assignment git@github.com:githubteachingorg/assignment1.git
  cd assignment1-team3/
  git add remote assignment git@github.com:githubteachingorg/assignment1.git
  ls
  git status
  git remote add assignment git@github.com:githubteachingorg/assignment1.git
  git remote -v
  git fetch assignment
  git pull assignment
  git pull assignment gh-pages
  git status
  git push origin gh-pages
  cd ..
  cd web-team/
  nano README.md 
  git statu
  git status
  git add .
  git commit -m 'more work for students'
  git push origin gh-pages
  cd ..
  ls
  cd assignment1-team3/
  git status
  git branch team-info
  git branch
  git checkout team-info
  git branch
  subl index.html 
  git status
  git add index.html 
  git status
  git commit -m 'add team info'
  git push origin gh-pages
  git branch
  git push origin team-info
  git status
  ls
  subl index.html 
  git status
  git add index.html 
  git commit -m 'update team name'
  git push origin team-info
  git status
  git status
  git status
  git add index.html 
  git commit -m'more work'
  git push origin team-info
```

