---
layout: bare
title: Git for the Uninitiated at DevNexus
description: Git for the Uninitiated – DevNexus, Atlanta, GA
tags: [notes, online, class]
path: classnotes/2013-02-18-devnexus-talk.md
eventdate: 2013-02-16
---

# Your instructor is:

* Matthew McCullough ([Twitter](http://twitter.com/matthewmccull), [GitHub](https://github.com/matthewmccullough))

# Presentation Overview

You’ve heard about this version control system called Git. Maybe some of your colleagues are using it. But is it here to stay, or just a fad?

We can best answer that by looking at what Distributed Version Control Systems (DVCS) like Git bring to the world of programming and authoring. There are a myriad of benefits ranging from the distributed nature of Git without a central point of failure, to its focus on working locally. These benefits are made possible by Git efficiently communicating over the network only when asked and its Unix-like compositional architecture.

We’ll follow that up with a look at what GitHub, a web service focused on amplifying Git for easier collaboration, brings to this rapidly changing domain of software creation tools.

This talk will enable you to sling the basic Git and GitHub lingo around like an old hat when you get back to the office.

Skill Level: Beginner

## Outline

We've heard you have are interested in:

* Why should you use version control?
    * Safety
    * Clarity
    * Post-session learning
* What will you benefit from putting this weekend's work on GitHub?
    * Marketing yourself
    * GitHub is your new resume
    * Easy contributions
    * Clarity, organization, leading to more controlled project progress
    * Ease of roping in some help
* What's an easy way to start a repository and put changes into it?
    * Server side repo creation
    * Cloning
    * Commits
    * Branching
* How do you get your team members to collaborate with you?
    * Orgs, Teams
    * Collaborators
    * Permissions
    * Pull Requests
* What are some of the challenging points you might see this weekend?
    * Merge conflicts
    * Unpushed changes

## Resources
* [GitHub - A First Look (Slides)](http://teach.github.com/presentations/github-first-look.html)
* [GitHub Foundations (Slides)](http://teach.github.com/presentations/git-foundations.html)
* [GitHub Training Videos](http://training.github.com/resources/videos/)
* [GitHub Training Feedback and Follow-up Questions](https://github.com/githubtraining/feedback/issues?state=open)
* [NPD Git Cheatsheet](http://ndpsoftware.com/git-cheatsheet.html)
* [More Git Cheatsheets](http://teach.github.com/articles/git-cheatsheets/)

## Suggested Books, Articles
* [Free ProGit Book](http://git-scm.com/book)
* [Getting started with Version Control](http://teach.github.com/articles/lesson-new-to-version-control/)
* [The GitHub Flow](http://scottchacon.com/2011/08/31/github-flow.html)
* [DVCS Workflows Book](https://github.com/zkessin/dvcs-workflows)
* [Git Cheat Sheets](http://teach.github.com/articles/git-cheatsheets/)
* [Git Workflow Links](https://pinboard.in/u:matthew.mccullough/t:git+workflow)

## Course Materials, Links
* [Git Teaching Materials](http://teach.github.com)
* [Course Slides](http://teach.github.com/articles/course-slides/)
* [Post-event Git and GitHub questions](https://github.com/githubtraining/feedback/)
* [Free Office Hours Sessions](http://training.github.com/web/free-classes/)




