---
layout: bare
title: University of Washington Git & GitHub Class
description: A discussion and presentation on Git and GitHub
tags: [notes, class]
path: classnotes/2013-01-29-universityofwashington.md
eventdate: 2013-01-29
---

# University of Washington HCDE GitHub Visit
* Visited on 2013-01-30
* Thank you to Human Centered Design and Engineering
* Thank you to [Dr. Jan H. Spyridakis](http://www.hcde.uw.edu/jansp)

# Instructors
* Matthew McCullough ([Twitter](http://twitter.com/matthewmccull), [GitHub](https://github.com/matthewmccullough))

# Resources
* [Free Office Hours](http://training.github.com/web/free-classes/)
* [Ask a Git or GitHub Question](https://github.com/githubtraining/feedback)
* [Cheat Sheets](http://teach.github.com/articles/git-cheatsheets/)
* [Git & GitHub Public Videos](http://www.youtube.com/github)

## Conflicted merges (Diff Tools)
Use graphical diff tools (`difftool` and `mergetool`).

* <http://www.gitguys.com/topics/merging-with-a-gui/>
* <http://gitguru.com/2009/02/22/integrating-git-with-a-visual-merge-tool/>
* <http://git-scm.com/book/en/Customizing-Git-Git-Configuration>
* <http://blog.wuwon.id.au/2010/09/painless-merge-conflict-resolution-in.html>
* [Video on using diff and merge tools](https://www.youtube.com/watch?v=xfh13LcgqIU)
* [`git difftool`](http://git-scm.com/docs/git-difftool)
* [`git mergetool`](http://git-scm.com/docs/git-mergetool)

## Reducing Conflict Resolution with Squashed Merges
Squashing commits into one bit change at merge time can be a simplifying pre-combining step.

* `git merge --squash`
* Won't actually make the final commit
* Needs `git commit` to complete this process.
* Converts a range of commits to one commit.
* [Video on using squashed merge commits](https://www.youtube.com/watch?v=7FlR3qZV_h0)

## Git GUIs
* GitHub for Mac, GitHub for Windows GUIs may not be enough
* Try [SourceTree](http://www.sourcetreeapp.com) for merge conflicts

## Designers
* [A workflow for designers](http://blog.teamtreehouse.com/git-for-designers-part-1)
* [Using the SVN interface](https://github.com/blog/1178-collaborating-on-github-with-subversion)

* The Network graph shows forks in motion
* [Graphical diff](https://github.com/githubtrainer/hellogitworld/commit/7c0ffa9d88616972bb84befbec40a2212478149e) on web site for images

## Office Hours
* <http://training.github.com/web/free-classes/>

## TravisCI Continuous Integration
* <https://www.travis-ci.org/githubtrainer/hellogitworld/builds/4465602>

## Cheat Sheets
* <http://teach.github.com/articles/git-cheatsheets/>

## Slides from Community Talk
* [Slides from University of Washington Talk](https://speakerdeck.com/matthewmccullough/git-and-github-at-washington-university)

## GitHub API
* [API Presentation](http://teach.github.com/presentations/github-api.html)
* [GitHub API Documentation](http://developer.github.com)
* [Adding a Team Member with the API](http://developer.github.com/v3/orgs/teams/#add-team-member)

## Teaching Materials
* [teach.github.com materials](http://teach.github.com)
* [teach.github.com source materials](https://github.com/github/teach.github.com)
* [learn.github.com educational materials](http://learn.github.com)

## OSCON Conference
* New educational track
* Portland, July 2013
* CFP ends on _11:59pm 02/04/2013 PST_
* [OSCON CFP site](http://www.oscon.com/oscon2013/public/cfp/251)
