---
layout: "docs"
page_title: "Documentation"
sidebar_current: "docs-home"
description: |-
  Documentation for Terraform's core open source features, including the
  configuration language, the commands, and the main Terraform providers.
---

# Terraform CLI Documentation

Welcome to the Terraform CLI documentation!

## What's in This Section of the Docs?

This section contains reference documentation for Terraform's core open source
features, including the
[configuration language](/docs/configuration/index.html), the
[command-line tools](/docs/commands/index.html), and the main
[Terraform providers](/docs/providers/index.html). Use the navigation sidebar
to browse the various subsections.

## Who is This For?

The Terraform CLI docs are relevant to _all Terraform users,_ including open
source users and Terraform Cloud users.

Since these docs are reference material, they are mainly written for
_intermediate and advanced users,_ who need to find complete and detailed
information quickly.

- **New user?** Try the
  [Getting Started guide](https://learn.hashicorp.com/terraform/getting-started/install.html)
  at [Learn Terraform](https://learn.hashicorp.com/terraform), then return
  here once you've used Terraform to manage some simple resources.
- **Curious about Terraform?** See [Introduction to Terraform](/intro/index.html)
  for a broad overview of what Terraform is and why people use it.

## What's Elsewhere?

This is not the only section of the Terraform docs! You can find out more at the
[Terraform docs home page](/docs/index.html), or you can jump between sections
using the "Other Docs" area of the navigation sidebar.
