package location

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEndpoints invokes the location.ListEndpoints API synchronously
// api document: https://help.aliyun.com/api/location/listendpoints.html
func (client *Client) ListEndpoints(request *ListEndpointsRequest) (response *ListEndpointsResponse, err error) {
	response = CreateListEndpointsResponse()
	err = client.DoAction(request, response)
	return
}

// ListEndpointsWithChan invokes the location.ListEndpoints API asynchronously
// api document: https://help.aliyun.com/api/location/listendpoints.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListEndpointsWithChan(request *ListEndpointsRequest) (<-chan *ListEndpointsResponse, <-chan error) {
	responseChan := make(chan *ListEndpointsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEndpoints(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEndpointsWithCallback invokes the location.ListEndpoints API asynchronously
// api document: https://help.aliyun.com/api/location/listendpoints.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListEndpointsWithCallback(request *ListEndpointsRequest, callback func(response *ListEndpointsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEndpointsResponse
		var err error
		defer close(result)
		response, err = client.ListEndpoints(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEndpointsRequest is the request struct for api ListEndpoints
type ListEndpointsRequest struct {
	*requests.RpcRequest
	Namespace   string `position:"Query" name:"Namespace"`
	Id          string `position:"Query" name:"Id"`
	SerivceCode string `position:"Query" name:"SerivceCode"`
}

// ListEndpointsResponse is the response struct for api ListEndpoints
type ListEndpointsResponse struct {
	*responses.BaseResponse
	RequestId    string                      `json:"RequestId" xml:"RequestId"`
	Success      bool                        `json:"Success" xml:"Success"`
	EndpointList EndpointListInListEndpoints `json:"EndpointList" xml:"EndpointList"`
}

// CreateListEndpointsRequest creates a request to invoke ListEndpoints API
func CreateListEndpointsRequest() (request *ListEndpointsRequest) {
	request = &ListEndpointsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Location", "2015-06-12", "ListEndpoints", "location", "openAPI")
	return
}

// CreateListEndpointsResponse creates a response to parse from ListEndpoints response
func CreateListEndpointsResponse() (response *ListEndpointsResponse) {
	response = &ListEndpointsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
