package uax29

// This file has been generated -- you probably should NOT EDIT IT !
// 
// BSD License, Copyright (c) 2018, Norbert Pillmayer (norbert@pillmayer.com)

import (
    "strconv"
    "unicode"

    "golang.org/x/text/unicode/rangetable"
)

// Type for UAX#29 code-point classes.
// Must be convertable to int.
type UAX29Class int

// Will be initialized in SetupUAX29Classes()
var rangeFromUAX29Class []*unicode.RangeTable

// These are all the UAX#29 breaking classes.
const ( 
    ALetterClass UAX29Class = 0
    CRClass UAX29Class = 1
    Double_QuoteClass UAX29Class = 2
    ExtendClass UAX29Class = 3
    ExtendNumLetClass UAX29Class = 4
    FormatClass UAX29Class = 5
    Hebrew_LetterClass UAX29Class = 6
    KatakanaClass UAX29Class = 7
    LFClass UAX29Class = 8
    MidLetterClass UAX29Class = 9
    MidNumClass UAX29Class = 10
    MidNumLetClass UAX29Class = 11
    NewlineClass UAX29Class = 12
    NumericClass UAX29Class = 13
    Regional_IndicatorClass UAX29Class = 14
    Single_QuoteClass UAX29Class = 15
    WSegSpaceClass UAX29Class = 16
    ZWJClass UAX29Class = 17

    Other UAX29Class = 999
    sot   UAX29Class = 1000 // pseudo class "start of text"
    eot   UAX29Class = 1001 // pseudo class "end of text"
)

// Range tables for UAX#29 code-point classes.
// Will be initialized with SetupUAX29Classes().
// Clients can check with unicode.Is(..., rune)
var ALetter, CR, Double_Quote, Extend, ExtendNumLet, Format, Hebrew_Letter, Katakana, LF, MidLetter, 
    MidNum, MidNumLet, Newline, Numeric, Regional_Indicator, Single_Quote, WSegSpace, ZWJ, unused *unicode.RangeTable

const _UAX29Class_name = "ALetterClassCRClassDouble_QuoteClassExtendClassExtendNumLetClassFormatClassHebrew_LetterClassKatakanaClassLFClassMidLetterClassMidNumClassMidNumLetClassNewlineClassNumericClassRegional_IndicatorClassSingle_QuoteClassWSegSpaceClassZWJClass"

var _UAX29Class_index = [...]uint16{0, 12, 19, 36, 47, 64, 75, 93, 106, 113,
    127, 138, 152, 164, 176, 199, 216, 230, 238 }

// Stringer for type UAX29Class
func (c UAX29Class) String() string {
    if c == sot {
        return "sot"
    } else if c == eot {
        return "eot"
    } else if c == Other {
        return "Other"
    } else if c < 0 || c >= UAX29Class(len(_UAX29Class_index)-1) {
        return "UAX29Class(" + strconv.FormatInt(int64(c), 10) + ")"
    }
    return _UAX29Class_name[_UAX29Class_index[c]:_UAX29Class_index[c+1]]
}

func setupUAX29Classes() {
    rangeFromUAX29Class = make([]*unicode.RangeTable, int(ZWJClass)+1)

    // Range for UAX#29 class CR
    CR = rangetable.New('\r')
    rangeFromUAX29Class[int(CRClass)] = CR

    // Range for UAX#29 class ExtendNumLet
    ExtendNumLet = rangetable.New('_', '\u202f', '\u203f', '\u2040', '\u2054', '\ufe33', 
    '\ufe34', '\ufe4d', '\ufe4e', '\ufe4f', '\uff3f')
    rangeFromUAX29Class[int(ExtendNumLetClass)] = ExtendNumLet

    // Range for UAX#29 class LF
    LF = rangetable.New('\n')
    rangeFromUAX29Class[int(LFClass)] = LF

    // Range for UAX#29 class Regional_Indicator
    Regional_Indicator = rangetable.New('\U0001f1e6', '\U0001f1e7', '\U0001f1e8', '\U0001f1e9', '\U0001f1ea', '\U0001f1eb', 
    '\U0001f1ec', '\U0001f1ed', '\U0001f1ee', '\U0001f1ef', '\U0001f1f0', '\U0001f1f1', '\U0001f1f2', '\U0001f1f3', 
    '\U0001f1f4', '\U0001f1f5', '\U0001f1f6', '\U0001f1f7', '\U0001f1f8', '\U0001f1f9', '\U0001f1fa', '\U0001f1fb', 
    '\U0001f1fc', '\U0001f1fd', '\U0001f1fe', '\U0001f1ff')
    rangeFromUAX29Class[int(Regional_IndicatorClass)] = Regional_Indicator

    // Range for UAX#29 class Hebrew_Letter
    Hebrew_Letter = rangetable.New('\u05d0', '\u05d1', '\u05d2', '\u05d3', '\u05d4', '\u05d5', 
    '\u05d6', '\u05d7', '\u05d8', '\u05d9', '\u05da', '\u05db', '\u05dc', '\u05dd', 
    '\u05de', '\u05df', '\u05e0', '\u05e1', '\u05e2', '\u05e3', '\u05e4', '\u05e5', 
    '\u05e6', '\u05e7', '\u05e8', '\u05e9', '\u05ea', '\u05ef', '\u05f0', '\u05f1', 
    '\u05f2', '\ufb1d', '\ufb1f', '\ufb20', '\ufb21', '\ufb22', '\ufb23', '\ufb24', 
    '\ufb25', '\ufb26', '\ufb27', '\ufb28', '\ufb2a', '\ufb2b', '\ufb2c', '\ufb2d', 
    '\ufb2e', '\ufb2f', '\ufb30', '\ufb31', '\ufb32', '\ufb33', '\ufb34', '\ufb35', 
    '\ufb36', '\ufb38', '\ufb39', '\ufb3a', '\ufb3b', '\ufb3c', '\ufb3e', '\ufb40', 
    '\ufb41', '\ufb43', '\ufb44', '\ufb46', '\ufb47', '\ufb48', '\ufb49', '\ufb4a', 
    '\ufb4b', '\ufb4c', '\ufb4d', '\ufb4e', '\ufb4f')
    rangeFromUAX29Class[int(Hebrew_LetterClass)] = Hebrew_Letter

    // Range for UAX#29 class Numeric
    Numeric = rangetable.New('0', '1', '2', '3', '4', '5', 
    '6', '7', '8', '9', '\u0660', '\u0661', '\u0662', '\u0663', 
    '\u0664', '\u0665', '\u0666', '\u0667', '\u0668', '\u0669', '\u066b', '\u06f0', 
    '\u06f1', '\u06f2', '\u06f3', '\u06f4', '\u06f5', '\u06f6', '\u06f7', '\u06f8', 
    '\u06f9', '\u07c0', '\u07c1', '\u07c2', '\u07c3', '\u07c4', '\u07c5', '\u07c6', 
    '\u07c7', '\u07c8', '\u07c9', '\u0966', '\u0967', '\u0968', '\u0969', '\u096a', 
    '\u096b', '\u096c', '\u096d', '\u096e', '\u096f', '\u09e6', '\u09e7', '\u09e8', 
    '\u09e9', '\u09ea', '\u09eb', '\u09ec', '\u09ed', '\u09ee', '\u09ef', '\u0a66', 
    '\u0a67', '\u0a68', '\u0a69', '\u0a6a', '\u0a6b', '\u0a6c', '\u0a6d', '\u0a6e', 
    '\u0a6f', '\u0ae6', '\u0ae7', '\u0ae8', '\u0ae9', '\u0aea', '\u0aeb', '\u0aec', 
    '\u0aed', '\u0aee', '\u0aef', '\u0b66', '\u0b67', '\u0b68', '\u0b69', '\u0b6a', 
    '\u0b6b', '\u0b6c', '\u0b6d', '\u0b6e', '\u0b6f', '\u0be6', '\u0be7', '\u0be8', 
    '\u0be9', '\u0bea', '\u0beb', '\u0bec', '\u0bed', '\u0bee', '\u0bef', '\u0c66', 
    '\u0c67', '\u0c68', '\u0c69', '\u0c6a', '\u0c6b', '\u0c6c', '\u0c6d', '\u0c6e', 
    '\u0c6f', '\u0ce6', '\u0ce7', '\u0ce8', '\u0ce9', '\u0cea', '\u0ceb', '\u0cec', 
    '\u0ced', '\u0cee', '\u0cef', '\u0d66', '\u0d67', '\u0d68', '\u0d69', '\u0d6a', 
    '\u0d6b', '\u0d6c', '\u0d6d', '\u0d6e', '\u0d6f', '\u0de6', '\u0de7', '\u0de8', 
    '\u0de9', '\u0dea', '\u0deb', '\u0dec', '\u0ded', '\u0dee', '\u0def', '\u0e50', 
    '\u0e51', '\u0e52', '\u0e53', '\u0e54', '\u0e55', '\u0e56', '\u0e57', '\u0e58', 
    '\u0e59', '\u0ed0', '\u0ed1', '\u0ed2', '\u0ed3', '\u0ed4', '\u0ed5', '\u0ed6', 
    '\u0ed7', '\u0ed8', '\u0ed9', '\u0f20', '\u0f21', '\u0f22', '\u0f23', '\u0f24', 
    '\u0f25', '\u0f26', '\u0f27', '\u0f28', '\u0f29', '\u1040', '\u1041', '\u1042', 
    '\u1043', '\u1044', '\u1045', '\u1046', '\u1047', '\u1048', '\u1049', '\u1090', 
    '\u1091', '\u1092', '\u1093', '\u1094', '\u1095', '\u1096', '\u1097', '\u1098', 
    '\u1099', '\u17e0', '\u17e1', '\u17e2', '\u17e3', '\u17e4', '\u17e5', '\u17e6', 
    '\u17e7', '\u17e8', '\u17e9', '\u1810', '\u1811', '\u1812', '\u1813', '\u1814', 
    '\u1815', '\u1816', '\u1817', '\u1818', '\u1819', '\u1946', '\u1947', '\u1948', 
    '\u1949', '\u194a', '\u194b', '\u194c', '\u194d', '\u194e', '\u194f', '\u19d0', 
    '\u19d1', '\u19d2', '\u19d3', '\u19d4', '\u19d5', '\u19d6', '\u19d7', '\u19d8', 
    '\u19d9', '\u1a80', '\u1a81', '\u1a82', '\u1a83', '\u1a84', '\u1a85', '\u1a86', 
    '\u1a87', '\u1a88', '\u1a89', '\u1a90', '\u1a91', '\u1a92', '\u1a93', '\u1a94', 
    '\u1a95', '\u1a96', '\u1a97', '\u1a98', '\u1a99', '\u1b50', '\u1b51', '\u1b52', 
    '\u1b53', '\u1b54', '\u1b55', '\u1b56', '\u1b57', '\u1b58', '\u1b59', '\u1bb0', 
    '\u1bb1', '\u1bb2', '\u1bb3', '\u1bb4', '\u1bb5', '\u1bb6', '\u1bb7', '\u1bb8', 
    '\u1bb9', '\u1c40', '\u1c41', '\u1c42', '\u1c43', '\u1c44', '\u1c45', '\u1c46', 
    '\u1c47', '\u1c48', '\u1c49', '\u1c50', '\u1c51', '\u1c52', '\u1c53', '\u1c54', 
    '\u1c55', '\u1c56', '\u1c57', '\u1c58', '\u1c59', '\ua620', '\ua621', '\ua622', 
    '\ua623', '\ua624', '\ua625', '\ua626', '\ua627', '\ua628', '\ua629', '\ua8d0', 
    '\ua8d1', '\ua8d2', '\ua8d3', '\ua8d4', '\ua8d5', '\ua8d6', '\ua8d7', '\ua8d8', 
    '\ua8d9', '\ua900', '\ua901', '\ua902', '\ua903', '\ua904', '\ua905', '\ua906', 
    '\ua907', '\ua908', '\ua909', '\ua9d0', '\ua9d1', '\ua9d2', '\ua9d3', '\ua9d4', 
    '\ua9d5', '\ua9d6', '\ua9d7', '\ua9d8', '\ua9d9', '\ua9f0', '\ua9f1', '\ua9f2', 
    '\ua9f3', '\ua9f4', '\ua9f5', '\ua9f6', '\ua9f7', '\ua9f8', '\ua9f9', '\uaa50', 
    '\uaa51', '\uaa52', '\uaa53', '\uaa54', '\uaa55', '\uaa56', '\uaa57', '\uaa58', 
    '\uaa59', '\uabf0', '\uabf1', '\uabf2', '\uabf3', '\uabf4', '\uabf5', '\uabf6', 
    '\uabf7', '\uabf8', '\uabf9', '\U000104a0', '\U000104a1', '\U000104a2', '\U000104a3', '\U000104a4', 
    '\U000104a5', '\U000104a6', '\U000104a7', '\U000104a8', '\U000104a9', '\U00010d30', '\U00010d31', '\U00010d32', 
    '\U00010d33', '\U00010d34', '\U00010d35', '\U00010d36', '\U00010d37', '\U00010d38', '\U00010d39', '\U00011066', 
    '\U00011067', '\U00011068', '\U00011069', '\U0001106a', '\U0001106b', '\U0001106c', '\U0001106d', '\U0001106e', 
    '\U0001106f', '\U000110f0', '\U000110f1', '\U000110f2', '\U000110f3', '\U000110f4', '\U000110f5', '\U000110f6', 
    '\U000110f7', '\U000110f8', '\U000110f9', '\U00011136', '\U00011137', '\U00011138', '\U00011139', '\U0001113a', 
    '\U0001113b', '\U0001113c', '\U0001113d', '\U0001113e', '\U0001113f', '\U000111d0', '\U000111d1', '\U000111d2', 
    '\U000111d3', '\U000111d4', '\U000111d5', '\U000111d6', '\U000111d7', '\U000111d8', '\U000111d9', '\U000112f0', 
    '\U000112f1', '\U000112f2', '\U000112f3', '\U000112f4', '\U000112f5', '\U000112f6', '\U000112f7', '\U000112f8', 
    '\U000112f9', '\U00011450', '\U00011451', '\U00011452', '\U00011453', '\U00011454', '\U00011455', '\U00011456', 
    '\U00011457', '\U00011458', '\U00011459', '\U000114d0', '\U000114d1', '\U000114d2', '\U000114d3', '\U000114d4', 
    '\U000114d5', '\U000114d6', '\U000114d7', '\U000114d8', '\U000114d9', '\U00011650', '\U00011651', '\U00011652', 
    '\U00011653', '\U00011654', '\U00011655', '\U00011656', '\U00011657', '\U00011658', '\U00011659', '\U000116c0', 
    '\U000116c1', '\U000116c2', '\U000116c3', '\U000116c4', '\U000116c5', '\U000116c6', '\U000116c7', '\U000116c8', 
    '\U000116c9', '\U00011730', '\U00011731', '\U00011732', '\U00011733', '\U00011734', '\U00011735', '\U00011736', 
    '\U00011737', '\U00011738', '\U00011739', '\U000118e0', '\U000118e1', '\U000118e2', '\U000118e3', '\U000118e4', 
    '\U000118e5', '\U000118e6', '\U000118e7', '\U000118e8', '\U000118e9', '\U00011c50', '\U00011c51', '\U00011c52', 
    '\U00011c53', '\U00011c54', '\U00011c55', '\U00011c56', '\U00011c57', '\U00011c58', '\U00011c59', '\U00011d50', 
    '\U00011d51', '\U00011d52', '\U00011d53', '\U00011d54', '\U00011d55', '\U00011d56', '\U00011d57', '\U00011d58', 
    '\U00011d59', '\U00011da0', '\U00011da1', '\U00011da2', '\U00011da3', '\U00011da4', '\U00011da5', '\U00011da6', 
    '\U00011da7', '\U00011da8', '\U00011da9', '\U00016a60', '\U00016a61', '\U00016a62', '\U00016a63', '\U00016a64', 
    '\U00016a65', '\U00016a66', '\U00016a67', '\U00016a68', '\U00016a69', '\U00016b50', '\U00016b51', '\U00016b52', 
    '\U00016b53', '\U00016b54', '\U00016b55', '\U00016b56', '\U00016b57', '\U00016b58', '\U00016b59', '\U0001d7ce', 
    '\U0001d7cf', '\U0001d7d0', '\U0001d7d1', '\U0001d7d2', '\U0001d7d3', '\U0001d7d4', '\U0001d7d5', '\U0001d7d6', 
    '\U0001d7d7', '\U0001d7d8', '\U0001d7d9', '\U0001d7da', '\U0001d7db', '\U0001d7dc', '\U0001d7dd', '\U0001d7de', 
    '\U0001d7df', '\U0001d7e0', '\U0001d7e1', '\U0001d7e2', '\U0001d7e3', '\U0001d7e4', '\U0001d7e5', '\U0001d7e6', 
    '\U0001d7e7', '\U0001d7e8', '\U0001d7e9', '\U0001d7ea', '\U0001d7eb', '\U0001d7ec', '\U0001d7ed', '\U0001d7ee', 
    '\U0001d7ef', '\U0001d7f0', '\U0001d7f1', '\U0001d7f2', '\U0001d7f3', '\U0001d7f4', '\U0001d7f5', '\U0001d7f6', 
    '\U0001d7f7', '\U0001d7f8', '\U0001d7f9', '\U0001d7fa', '\U0001d7fb', '\U0001d7fc', '\U0001d7fd', '\U0001d7fe', 
    '\U0001d7ff', '\U0001e950', '\U0001e951', '\U0001e952', '\U0001e953', '\U0001e954', '\U0001e955', '\U0001e956', 
    '\U0001e957', '\U0001e958', '\U0001e959')
    rangeFromUAX29Class[int(NumericClass)] = Numeric

    // Range for UAX#29 class ZWJ
    ZWJ = rangetable.New('\u200d')
    rangeFromUAX29Class[int(ZWJClass)] = ZWJ

    // Range for UAX#29 class MidNum
    MidNum = rangetable.New(',', ';', '\u037e', '\u0589', '\u060c', '\u060d', 
    '\u066c', '\u07f8', '\u2044', '\ufe10', '\ufe14', '\ufe50', '\ufe54', '\uff0c', 
    '\uff1b')
    rangeFromUAX29Class[int(MidNumClass)] = MidNum

    // Range for UAX#29 class Extend
    Extend = rangetable.New('\u0300', '\u0301', '\u0302', '\u0303', '\u0304', '\u0305', 
    '\u0306', '\u0307', '\u0308', '\u0309', '\u030a', '\u030b', '\u030c', '\u030d', 
    '\u030e', '\u030f', '\u0310', '\u0311', '\u0312', '\u0313', '\u0314', '\u0315', 
    '\u0316', '\u0317', '\u0318', '\u0319', '\u031a', '\u031b', '\u031c', '\u031d', 
    '\u031e', '\u031f', '\u0320', '\u0321', '\u0322', '\u0323', '\u0324', '\u0325', 
    '\u0326', '\u0327', '\u0328', '\u0329', '\u032a', '\u032b', '\u032c', '\u032d', 
    '\u032e', '\u032f', '\u0330', '\u0331', '\u0332', '\u0333', '\u0334', '\u0335', 
    '\u0336', '\u0337', '\u0338', '\u0339', '\u033a', '\u033b', '\u033c', '\u033d', 
    '\u033e', '\u033f', '\u0340', '\u0341', '\u0342', '\u0343', '\u0344', '\u0345', 
    '\u0346', '\u0347', '\u0348', '\u0349', '\u034a', '\u034b', '\u034c', '\u034d', 
    '\u034e', '\u034f', '\u0350', '\u0351', '\u0352', '\u0353', '\u0354', '\u0355', 
    '\u0356', '\u0357', '\u0358', '\u0359', '\u035a', '\u035b', '\u035c', '\u035d', 
    '\u035e', '\u035f', '\u0360', '\u0361', '\u0362', '\u0363', '\u0364', '\u0365', 
    '\u0366', '\u0367', '\u0368', '\u0369', '\u036a', '\u036b', '\u036c', '\u036d', 
    '\u036e', '\u036f', '\u0483', '\u0484', '\u0485', '\u0486', '\u0487', '\u0488', 
    '\u0489', '\u0591', '\u0592', '\u0593', '\u0594', '\u0595', '\u0596', '\u0597', 
    '\u0598', '\u0599', '\u059a', '\u059b', '\u059c', '\u059d', '\u059e', '\u059f', 
    '\u05a0', '\u05a1', '\u05a2', '\u05a3', '\u05a4', '\u05a5', '\u05a6', '\u05a7', 
    '\u05a8', '\u05a9', '\u05aa', '\u05ab', '\u05ac', '\u05ad', '\u05ae', '\u05af', 
    '\u05b0', '\u05b1', '\u05b2', '\u05b3', '\u05b4', '\u05b5', '\u05b6', '\u05b7', 
    '\u05b8', '\u05b9', '\u05ba', '\u05bb', '\u05bc', '\u05bd', '\u05bf', '\u05c1', 
    '\u05c2', '\u05c4', '\u05c5', '\u05c7', '\u0610', '\u0611', '\u0612', '\u0613', 
    '\u0614', '\u0615', '\u0616', '\u0617', '\u0618', '\u0619', '\u061a', '\u064b', 
    '\u064c', '\u064d', '\u064e', '\u064f', '\u0650', '\u0651', '\u0652', '\u0653', 
    '\u0654', '\u0655', '\u0656', '\u0657', '\u0658', '\u0659', '\u065a', '\u065b', 
    '\u065c', '\u065d', '\u065e', '\u065f', '\u0670', '\u06d6', '\u06d7', '\u06d8', 
    '\u06d9', '\u06da', '\u06db', '\u06dc', '\u06df', '\u06e0', '\u06e1', '\u06e2', 
    '\u06e3', '\u06e4', '\u06e7', '\u06e8', '\u06ea', '\u06eb', '\u06ec', '\u06ed', 
    '\u0711', '\u0730', '\u0731', '\u0732', '\u0733', '\u0734', '\u0735', '\u0736', 
    '\u0737', '\u0738', '\u0739', '\u073a', '\u073b', '\u073c', '\u073d', '\u073e', 
    '\u073f', '\u0740', '\u0741', '\u0742', '\u0743', '\u0744', '\u0745', '\u0746', 
    '\u0747', '\u0748', '\u0749', '\u074a', '\u07a6', '\u07a7', '\u07a8', '\u07a9', 
    '\u07aa', '\u07ab', '\u07ac', '\u07ad', '\u07ae', '\u07af', '\u07b0', '\u07eb', 
    '\u07ec', '\u07ed', '\u07ee', '\u07ef', '\u07f0', '\u07f1', '\u07f2', '\u07f3', 
    '\u07fd', '\u0816', '\u0817', '\u0818', '\u0819', '\u081b', '\u081c', '\u081d', 
    '\u081e', '\u081f', '\u0820', '\u0821', '\u0822', '\u0823', '\u0825', '\u0826', 
    '\u0827', '\u0829', '\u082a', '\u082b', '\u082c', '\u082d', '\u0859', '\u085a', 
    '\u085b', '\u08d3', '\u08d4', '\u08d5', '\u08d6', '\u08d7', '\u08d8', '\u08d9', 
    '\u08da', '\u08db', '\u08dc', '\u08dd', '\u08de', '\u08df', '\u08e0', '\u08e1', 
    '\u08e3', '\u08e4', '\u08e5', '\u08e6', '\u08e7', '\u08e8', '\u08e9', '\u08ea', 
    '\u08eb', '\u08ec', '\u08ed', '\u08ee', '\u08ef', '\u08f0', '\u08f1', '\u08f2', 
    '\u08f3', '\u08f4', '\u08f5', '\u08f6', '\u08f7', '\u08f8', '\u08f9', '\u08fa', 
    '\u08fb', '\u08fc', '\u08fd', '\u08fe', '\u08ff', '\u0900', '\u0901', '\u0902', 
    '\u0903', '\u093a', '\u093b', '\u093c', '\u093e', '\u093f', '\u0940', '\u0941', 
    '\u0942', '\u0943', '\u0944', '\u0945', '\u0946', '\u0947', '\u0948', '\u0949', 
    '\u094a', '\u094b', '\u094c', '\u094d', '\u094e', '\u094f', '\u0951', '\u0952', 
    '\u0953', '\u0954', '\u0955', '\u0956', '\u0957', '\u0962', '\u0963', '\u0981', 
    '\u0982', '\u0983', '\u09bc', '\u09be', '\u09bf', '\u09c0', '\u09c1', '\u09c2', 
    '\u09c3', '\u09c4', '\u09c7', '\u09c8', '\u09cb', '\u09cc', '\u09cd', '\u09d7', 
    '\u09e2', '\u09e3', '\u09fe', '\u0a01', '\u0a02', '\u0a03', '\u0a3c', '\u0a3e', 
    '\u0a3f', '\u0a40', '\u0a41', '\u0a42', '\u0a47', '\u0a48', '\u0a4b', '\u0a4c', 
    '\u0a4d', '\u0a51', '\u0a70', '\u0a71', '\u0a75', '\u0a81', '\u0a82', '\u0a83', 
    '\u0abc', '\u0abe', '\u0abf', '\u0ac0', '\u0ac1', '\u0ac2', '\u0ac3', '\u0ac4', 
    '\u0ac5', '\u0ac7', '\u0ac8', '\u0ac9', '\u0acb', '\u0acc', '\u0acd', '\u0ae2', 
    '\u0ae3', '\u0afa', '\u0afb', '\u0afc', '\u0afd', '\u0afe', '\u0aff', '\u0b01', 
    '\u0b02', '\u0b03', '\u0b3c', '\u0b3e', '\u0b3f', '\u0b40', '\u0b41', '\u0b42', 
    '\u0b43', '\u0b44', '\u0b47', '\u0b48', '\u0b4b', '\u0b4c', '\u0b4d', '\u0b56', 
    '\u0b57', '\u0b62', '\u0b63', '\u0b82', '\u0bbe', '\u0bbf', '\u0bc0', '\u0bc1', 
    '\u0bc2', '\u0bc6', '\u0bc7', '\u0bc8', '\u0bca', '\u0bcb', '\u0bcc', '\u0bcd', 
    '\u0bd7', '\u0c00', '\u0c01', '\u0c02', '\u0c03', '\u0c04', '\u0c3e', '\u0c3f', 
    '\u0c40', '\u0c41', '\u0c42', '\u0c43', '\u0c44', '\u0c46', '\u0c47', '\u0c48', 
    '\u0c4a', '\u0c4b', '\u0c4c', '\u0c4d', '\u0c55', '\u0c56', '\u0c62', '\u0c63', 
    '\u0c81', '\u0c82', '\u0c83', '\u0cbc', '\u0cbe', '\u0cbf', '\u0cc0', '\u0cc1', 
    '\u0cc2', '\u0cc3', '\u0cc4', '\u0cc6', '\u0cc7', '\u0cc8', '\u0cca', '\u0ccb', 
    '\u0ccc', '\u0ccd', '\u0cd5', '\u0cd6', '\u0ce2', '\u0ce3', '\u0d00', '\u0d01', 
    '\u0d02', '\u0d03', '\u0d3b', '\u0d3c', '\u0d3e', '\u0d3f', '\u0d40', '\u0d41', 
    '\u0d42', '\u0d43', '\u0d44', '\u0d46', '\u0d47', '\u0d48', '\u0d4a', '\u0d4b', 
    '\u0d4c', '\u0d4d', '\u0d57', '\u0d62', '\u0d63', '\u0d82', '\u0d83', '\u0dca', 
    '\u0dcf', '\u0dd0', '\u0dd1', '\u0dd2', '\u0dd3', '\u0dd4', '\u0dd6', '\u0dd8', 
    '\u0dd9', '\u0dda', '\u0ddb', '\u0ddc', '\u0ddd', '\u0dde', '\u0ddf', '\u0df2', 
    '\u0df3', '\u0e31', '\u0e34', '\u0e35', '\u0e36', '\u0e37', '\u0e38', '\u0e39', 
    '\u0e3a', '\u0e47', '\u0e48', '\u0e49', '\u0e4a', '\u0e4b', '\u0e4c', '\u0e4d', 
    '\u0e4e', '\u0eb1', '\u0eb4', '\u0eb5', '\u0eb6', '\u0eb7', '\u0eb8', '\u0eb9', 
    '\u0ebb', '\u0ebc', '\u0ec8', '\u0ec9', '\u0eca', '\u0ecb', '\u0ecc', '\u0ecd', 
    '\u0f18', '\u0f19', '\u0f35', '\u0f37', '\u0f39', '\u0f3e', '\u0f3f', '\u0f71', 
    '\u0f72', '\u0f73', '\u0f74', '\u0f75', '\u0f76', '\u0f77', '\u0f78', '\u0f79', 
    '\u0f7a', '\u0f7b', '\u0f7c', '\u0f7d', '\u0f7e', '\u0f7f', '\u0f80', '\u0f81', 
    '\u0f82', '\u0f83', '\u0f84', '\u0f86', '\u0f87', '\u0f8d', '\u0f8e', '\u0f8f', 
    '\u0f90', '\u0f91', '\u0f92', '\u0f93', '\u0f94', '\u0f95', '\u0f96', '\u0f97', 
    '\u0f99', '\u0f9a', '\u0f9b', '\u0f9c', '\u0f9d', '\u0f9e', '\u0f9f', '\u0fa0', 
    '\u0fa1', '\u0fa2', '\u0fa3', '\u0fa4', '\u0fa5', '\u0fa6', '\u0fa7', '\u0fa8', 
    '\u0fa9', '\u0faa', '\u0fab', '\u0fac', '\u0fad', '\u0fae', '\u0faf', '\u0fb0', 
    '\u0fb1', '\u0fb2', '\u0fb3', '\u0fb4', '\u0fb5', '\u0fb6', '\u0fb7', '\u0fb8', 
    '\u0fb9', '\u0fba', '\u0fbb', '\u0fbc', '\u0fc6', '\u102b', '\u102c', '\u102d', 
    '\u102e', '\u102f', '\u1030', '\u1031', '\u1032', '\u1033', '\u1034', '\u1035', 
    '\u1036', '\u1037', '\u1038', '\u1039', '\u103a', '\u103b', '\u103c', '\u103d', 
    '\u103e', '\u1056', '\u1057', '\u1058', '\u1059', '\u105e', '\u105f', '\u1060', 
    '\u1062', '\u1063', '\u1064', '\u1067', '\u1068', '\u1069', '\u106a', '\u106b', 
    '\u106c', '\u106d', '\u1071', '\u1072', '\u1073', '\u1074', '\u1082', '\u1083', 
    '\u1084', '\u1085', '\u1086', '\u1087', '\u1088', '\u1089', '\u108a', '\u108b', 
    '\u108c', '\u108d', '\u108f', '\u109a', '\u109b', '\u109c', '\u109d', '\u135d', 
    '\u135e', '\u135f', '\u1712', '\u1713', '\u1714', '\u1732', '\u1733', '\u1734', 
    '\u1752', '\u1753', '\u1772', '\u1773', '\u17b4', '\u17b5', '\u17b6', '\u17b7', 
    '\u17b8', '\u17b9', '\u17ba', '\u17bb', '\u17bc', '\u17bd', '\u17be', '\u17bf', 
    '\u17c0', '\u17c1', '\u17c2', '\u17c3', '\u17c4', '\u17c5', '\u17c6', '\u17c7', 
    '\u17c8', '\u17c9', '\u17ca', '\u17cb', '\u17cc', '\u17cd', '\u17ce', '\u17cf', 
    '\u17d0', '\u17d1', '\u17d2', '\u17d3', '\u17dd', '\u180b', '\u180c', '\u180d', 
    '\u1885', '\u1886', '\u18a9', '\u1920', '\u1921', '\u1922', '\u1923', '\u1924', 
    '\u1925', '\u1926', '\u1927', '\u1928', '\u1929', '\u192a', '\u192b', '\u1930', 
    '\u1931', '\u1932', '\u1933', '\u1934', '\u1935', '\u1936', '\u1937', '\u1938', 
    '\u1939', '\u193a', '\u193b', '\u1a17', '\u1a18', '\u1a19', '\u1a1a', '\u1a1b', 
    '\u1a55', '\u1a56', '\u1a57', '\u1a58', '\u1a59', '\u1a5a', '\u1a5b', '\u1a5c', 
    '\u1a5d', '\u1a5e', '\u1a60', '\u1a61', '\u1a62', '\u1a63', '\u1a64', '\u1a65', 
    '\u1a66', '\u1a67', '\u1a68', '\u1a69', '\u1a6a', '\u1a6b', '\u1a6c', '\u1a6d', 
    '\u1a6e', '\u1a6f', '\u1a70', '\u1a71', '\u1a72', '\u1a73', '\u1a74', '\u1a75', 
    '\u1a76', '\u1a77', '\u1a78', '\u1a79', '\u1a7a', '\u1a7b', '\u1a7c', '\u1a7f', 
    '\u1ab0', '\u1ab1', '\u1ab2', '\u1ab3', '\u1ab4', '\u1ab5', '\u1ab6', '\u1ab7', 
    '\u1ab8', '\u1ab9', '\u1aba', '\u1abb', '\u1abc', '\u1abd', '\u1abe', '\u1b00', 
    '\u1b01', '\u1b02', '\u1b03', '\u1b04', '\u1b34', '\u1b35', '\u1b36', '\u1b37', 
    '\u1b38', '\u1b39', '\u1b3a', '\u1b3b', '\u1b3c', '\u1b3d', '\u1b3e', '\u1b3f', 
    '\u1b40', '\u1b41', '\u1b42', '\u1b43', '\u1b44', '\u1b6b', '\u1b6c', '\u1b6d', 
    '\u1b6e', '\u1b6f', '\u1b70', '\u1b71', '\u1b72', '\u1b73', '\u1b80', '\u1b81', 
    '\u1b82', '\u1ba1', '\u1ba2', '\u1ba3', '\u1ba4', '\u1ba5', '\u1ba6', '\u1ba7', 
    '\u1ba8', '\u1ba9', '\u1baa', '\u1bab', '\u1bac', '\u1bad', '\u1be6', '\u1be7', 
    '\u1be8', '\u1be9', '\u1bea', '\u1beb', '\u1bec', '\u1bed', '\u1bee', '\u1bef', 
    '\u1bf0', '\u1bf1', '\u1bf2', '\u1bf3', '\u1c24', '\u1c25', '\u1c26', '\u1c27', 
    '\u1c28', '\u1c29', '\u1c2a', '\u1c2b', '\u1c2c', '\u1c2d', '\u1c2e', '\u1c2f', 
    '\u1c30', '\u1c31', '\u1c32', '\u1c33', '\u1c34', '\u1c35', '\u1c36', '\u1c37', 
    '\u1cd0', '\u1cd1', '\u1cd2', '\u1cd4', '\u1cd5', '\u1cd6', '\u1cd7', '\u1cd8', 
    '\u1cd9', '\u1cda', '\u1cdb', '\u1cdc', '\u1cdd', '\u1cde', '\u1cdf', '\u1ce0', 
    '\u1ce1', '\u1ce2', '\u1ce3', '\u1ce4', '\u1ce5', '\u1ce6', '\u1ce7', '\u1ce8', 
    '\u1ced', '\u1cf2', '\u1cf3', '\u1cf4', '\u1cf7', '\u1cf8', '\u1cf9', '\u1dc0', 
    '\u1dc1', '\u1dc2', '\u1dc3', '\u1dc4', '\u1dc5', '\u1dc6', '\u1dc7', '\u1dc8', 
    '\u1dc9', '\u1dca', '\u1dcb', '\u1dcc', '\u1dcd', '\u1dce', '\u1dcf', '\u1dd0', 
    '\u1dd1', '\u1dd2', '\u1dd3', '\u1dd4', '\u1dd5', '\u1dd6', '\u1dd7', '\u1dd8', 
    '\u1dd9', '\u1dda', '\u1ddb', '\u1ddc', '\u1ddd', '\u1dde', '\u1ddf', '\u1de0', 
    '\u1de1', '\u1de2', '\u1de3', '\u1de4', '\u1de5', '\u1de6', '\u1de7', '\u1de8', 
    '\u1de9', '\u1dea', '\u1deb', '\u1dec', '\u1ded', '\u1dee', '\u1def', '\u1df0', 
    '\u1df1', '\u1df2', '\u1df3', '\u1df4', '\u1df5', '\u1df6', '\u1df7', '\u1df8', 
    '\u1df9', '\u1dfb', '\u1dfc', '\u1dfd', '\u1dfe', '\u1dff', '\u200c', '\u20d0', 
    '\u20d1', '\u20d2', '\u20d3', '\u20d4', '\u20d5', '\u20d6', '\u20d7', '\u20d8', 
    '\u20d9', '\u20da', '\u20db', '\u20dc', '\u20dd', '\u20de', '\u20df', '\u20e0', 
    '\u20e1', '\u20e2', '\u20e3', '\u20e4', '\u20e5', '\u20e6', '\u20e7', '\u20e8', 
    '\u20e9', '\u20ea', '\u20eb', '\u20ec', '\u20ed', '\u20ee', '\u20ef', '\u20f0', 
    '\u2cef', '\u2cf0', '\u2cf1', '\u2d7f', '\u2de0', '\u2de1', '\u2de2', '\u2de3', 
    '\u2de4', '\u2de5', '\u2de6', '\u2de7', '\u2de8', '\u2de9', '\u2dea', '\u2deb', 
    '\u2dec', '\u2ded', '\u2dee', '\u2def', '\u2df0', '\u2df1', '\u2df2', '\u2df3', 
    '\u2df4', '\u2df5', '\u2df6', '\u2df7', '\u2df8', '\u2df9', '\u2dfa', '\u2dfb', 
    '\u2dfc', '\u2dfd', '\u2dfe', '\u2dff', '\u302a', '\u302b', '\u302c', '\u302d', 
    '\u302e', '\u302f', '\u3099', '\u309a', '\ua66f', '\ua670', '\ua671', '\ua672', 
    '\ua674', '\ua675', '\ua676', '\ua677', '\ua678', '\ua679', '\ua67a', '\ua67b', 
    '\ua67c', '\ua67d', '\ua69e', '\ua69f', '\ua6f0', '\ua6f1', '\ua802', '\ua806', 
    '\ua80b', '\ua823', '\ua824', '\ua825', '\ua826', '\ua827', '\ua880', '\ua881', 
    '\ua8b4', '\ua8b5', '\ua8b6', '\ua8b7', '\ua8b8', '\ua8b9', '\ua8ba', '\ua8bb', 
    '\ua8bc', '\ua8bd', '\ua8be', '\ua8bf', '\ua8c0', '\ua8c1', '\ua8c2', '\ua8c3', 
    '\ua8c4', '\ua8c5', '\ua8e0', '\ua8e1', '\ua8e2', '\ua8e3', '\ua8e4', '\ua8e5', 
    '\ua8e6', '\ua8e7', '\ua8e8', '\ua8e9', '\ua8ea', '\ua8eb', '\ua8ec', '\ua8ed', 
    '\ua8ee', '\ua8ef', '\ua8f0', '\ua8f1', '\ua8ff', '\ua926', '\ua927', '\ua928', 
    '\ua929', '\ua92a', '\ua92b', '\ua92c', '\ua92d', '\ua947', '\ua948', '\ua949', 
    '\ua94a', '\ua94b', '\ua94c', '\ua94d', '\ua94e', '\ua94f', '\ua950', '\ua951', 
    '\ua952', '\ua953', '\ua980', '\ua981', '\ua982', '\ua983', '\ua9b3', '\ua9b4', 
    '\ua9b5', '\ua9b6', '\ua9b7', '\ua9b8', '\ua9b9', '\ua9ba', '\ua9bb', '\ua9bc', 
    '\ua9bd', '\ua9be', '\ua9bf', '\ua9c0', '\ua9e5', '\uaa29', '\uaa2a', '\uaa2b', 
    '\uaa2c', '\uaa2d', '\uaa2e', '\uaa2f', '\uaa30', '\uaa31', '\uaa32', '\uaa33', 
    '\uaa34', '\uaa35', '\uaa36', '\uaa43', '\uaa4c', '\uaa4d', '\uaa7b', '\uaa7c', 
    '\uaa7d', '\uaab0', '\uaab2', '\uaab3', '\uaab4', '\uaab7', '\uaab8', '\uaabe', 
    '\uaabf', '\uaac1', '\uaaeb', '\uaaec', '\uaaed', '\uaaee', '\uaaef', '\uaaf5', 
    '\uaaf6', '\uabe3', '\uabe4', '\uabe5', '\uabe6', '\uabe7', '\uabe8', '\uabe9', 
    '\uabea', '\uabec', '\uabed', '\ufb1e', '\ufe00', '\ufe01', '\ufe02', '\ufe03', 
    '\ufe04', '\ufe05', '\ufe06', '\ufe07', '\ufe08', '\ufe09', '\ufe0a', '\ufe0b', 
    '\ufe0c', '\ufe0d', '\ufe0e', '\ufe0f', '\ufe20', '\ufe21', '\ufe22', '\ufe23', 
    '\ufe24', '\ufe25', '\ufe26', '\ufe27', '\ufe28', '\ufe29', '\ufe2a', '\ufe2b', 
    '\ufe2c', '\ufe2d', '\ufe2e', '\ufe2f', '\uff9e', '\uff9f', '\U000101fd', '\U000102e0', 
    '\U00010376', '\U00010377', '\U00010378', '\U00010379', '\U0001037a', '\U00010a01', '\U00010a02', '\U00010a03', 
    '\U00010a05', '\U00010a06', '\U00010a0c', '\U00010a0d', '\U00010a0e', '\U00010a0f', '\U00010a38', '\U00010a39', 
    '\U00010a3a', '\U00010a3f', '\U00010ae5', '\U00010ae6', '\U00010d24', '\U00010d25', '\U00010d26', '\U00010d27', 
    '\U00010f46', '\U00010f47', '\U00010f48', '\U00010f49', '\U00010f4a', '\U00010f4b', '\U00010f4c', '\U00010f4d', 
    '\U00010f4e', '\U00010f4f', '\U00010f50', '\U00011000', '\U00011001', '\U00011002', '\U00011038', '\U00011039', 
    '\U0001103a', '\U0001103b', '\U0001103c', '\U0001103d', '\U0001103e', '\U0001103f', '\U00011040', '\U00011041', 
    '\U00011042', '\U00011043', '\U00011044', '\U00011045', '\U00011046', '\U0001107f', '\U00011080', '\U00011081', 
    '\U00011082', '\U000110b0', '\U000110b1', '\U000110b2', '\U000110b3', '\U000110b4', '\U000110b5', '\U000110b6', 
    '\U000110b7', '\U000110b8', '\U000110b9', '\U000110ba', '\U00011100', '\U00011101', '\U00011102', '\U00011127', 
    '\U00011128', '\U00011129', '\U0001112a', '\U0001112b', '\U0001112c', '\U0001112d', '\U0001112e', '\U0001112f', 
    '\U00011130', '\U00011131', '\U00011132', '\U00011133', '\U00011134', '\U00011145', '\U00011146', '\U00011173', 
    '\U00011180', '\U00011181', '\U00011182', '\U000111b3', '\U000111b4', '\U000111b5', '\U000111b6', '\U000111b7', 
    '\U000111b8', '\U000111b9', '\U000111ba', '\U000111bb', '\U000111bc', '\U000111bd', '\U000111be', '\U000111bf', 
    '\U000111c0', '\U000111c9', '\U000111ca', '\U000111cb', '\U000111cc', '\U0001122c', '\U0001122d', '\U0001122e', 
    '\U0001122f', '\U00011230', '\U00011231', '\U00011232', '\U00011233', '\U00011234', '\U00011235', '\U00011236', 
    '\U00011237', '\U0001123e', '\U000112df', '\U000112e0', '\U000112e1', '\U000112e2', '\U000112e3', '\U000112e4', 
    '\U000112e5', '\U000112e6', '\U000112e7', '\U000112e8', '\U000112e9', '\U000112ea', '\U00011300', '\U00011301', 
    '\U00011302', '\U00011303', '\U0001133b', '\U0001133c', '\U0001133e', '\U0001133f', '\U00011340', '\U00011341', 
    '\U00011342', '\U00011343', '\U00011344', '\U00011347', '\U00011348', '\U0001134b', '\U0001134c', '\U0001134d', 
    '\U00011357', '\U00011362', '\U00011363', '\U00011366', '\U00011367', '\U00011368', '\U00011369', '\U0001136a', 
    '\U0001136b', '\U0001136c', '\U00011370', '\U00011371', '\U00011372', '\U00011373', '\U00011374', '\U00011435', 
    '\U00011436', '\U00011437', '\U00011438', '\U00011439', '\U0001143a', '\U0001143b', '\U0001143c', '\U0001143d', 
    '\U0001143e', '\U0001143f', '\U00011440', '\U00011441', '\U00011442', '\U00011443', '\U00011444', '\U00011445', 
    '\U00011446', '\U0001145e', '\U000114b0', '\U000114b1', '\U000114b2', '\U000114b3', '\U000114b4', '\U000114b5', 
    '\U000114b6', '\U000114b7', '\U000114b8', '\U000114b9', '\U000114ba', '\U000114bb', '\U000114bc', '\U000114bd', 
    '\U000114be', '\U000114bf', '\U000114c0', '\U000114c1', '\U000114c2', '\U000114c3', '\U000115af', '\U000115b0', 
    '\U000115b1', '\U000115b2', '\U000115b3', '\U000115b4', '\U000115b5', '\U000115b8', '\U000115b9', '\U000115ba', 
    '\U000115bb', '\U000115bc', '\U000115bd', '\U000115be', '\U000115bf', '\U000115c0', '\U000115dc', '\U000115dd', 
    '\U00011630', '\U00011631', '\U00011632', '\U00011633', '\U00011634', '\U00011635', '\U00011636', '\U00011637', 
    '\U00011638', '\U00011639', '\U0001163a', '\U0001163b', '\U0001163c', '\U0001163d', '\U0001163e', '\U0001163f', 
    '\U00011640', '\U000116ab', '\U000116ac', '\U000116ad', '\U000116ae', '\U000116af', '\U000116b0', '\U000116b1', 
    '\U000116b2', '\U000116b3', '\U000116b4', '\U000116b5', '\U000116b6', '\U000116b7', '\U0001171d', '\U0001171e', 
    '\U0001171f', '\U00011720', '\U00011721', '\U00011722', '\U00011723', '\U00011724', '\U00011725', '\U00011726', 
    '\U00011727', '\U00011728', '\U00011729', '\U0001172a', '\U0001172b', '\U0001182c', '\U0001182d', '\U0001182e', 
    '\U0001182f', '\U00011830', '\U00011831', '\U00011832', '\U00011833', '\U00011834', '\U00011835', '\U00011836', 
    '\U00011837', '\U00011838', '\U00011839', '\U0001183a', '\U00011a01', '\U00011a02', '\U00011a03', '\U00011a04', 
    '\U00011a05', '\U00011a06', '\U00011a07', '\U00011a08', '\U00011a09', '\U00011a0a', '\U00011a33', '\U00011a34', 
    '\U00011a35', '\U00011a36', '\U00011a37', '\U00011a38', '\U00011a39', '\U00011a3b', '\U00011a3c', '\U00011a3d', 
    '\U00011a3e', '\U00011a47', '\U00011a51', '\U00011a52', '\U00011a53', '\U00011a54', '\U00011a55', '\U00011a56', 
    '\U00011a57', '\U00011a58', '\U00011a59', '\U00011a5a', '\U00011a5b', '\U00011a8a', '\U00011a8b', '\U00011a8c', 
    '\U00011a8d', '\U00011a8e', '\U00011a8f', '\U00011a90', '\U00011a91', '\U00011a92', '\U00011a93', '\U00011a94', 
    '\U00011a95', '\U00011a96', '\U00011a97', '\U00011a98', '\U00011a99', '\U00011c2f', '\U00011c30', '\U00011c31', 
    '\U00011c32', '\U00011c33', '\U00011c34', '\U00011c35', '\U00011c36', '\U00011c38', '\U00011c39', '\U00011c3a', 
    '\U00011c3b', '\U00011c3c', '\U00011c3d', '\U00011c3e', '\U00011c3f', '\U00011c92', '\U00011c93', '\U00011c94', 
    '\U00011c95', '\U00011c96', '\U00011c97', '\U00011c98', '\U00011c99', '\U00011c9a', '\U00011c9b', '\U00011c9c', 
    '\U00011c9d', '\U00011c9e', '\U00011c9f', '\U00011ca0', '\U00011ca1', '\U00011ca2', '\U00011ca3', '\U00011ca4', 
    '\U00011ca5', '\U00011ca6', '\U00011ca7', '\U00011ca9', '\U00011caa', '\U00011cab', '\U00011cac', '\U00011cad', 
    '\U00011cae', '\U00011caf', '\U00011cb0', '\U00011cb1', '\U00011cb2', '\U00011cb3', '\U00011cb4', '\U00011cb5', 
    '\U00011cb6', '\U00011d31', '\U00011d32', '\U00011d33', '\U00011d34', '\U00011d35', '\U00011d36', '\U00011d3a', 
    '\U00011d3c', '\U00011d3d', '\U00011d3f', '\U00011d40', '\U00011d41', '\U00011d42', '\U00011d43', '\U00011d44', 
    '\U00011d45', '\U00011d47', '\U00011d8a', '\U00011d8b', '\U00011d8c', '\U00011d8d', '\U00011d8e', '\U00011d90', 
    '\U00011d91', '\U00011d93', '\U00011d94', '\U00011d95', '\U00011d96', '\U00011d97', '\U00011ef3', '\U00011ef4', 
    '\U00011ef5', '\U00011ef6', '\U00016af0', '\U00016af1', '\U00016af2', '\U00016af3', '\U00016af4', '\U00016b30', 
    '\U00016b31', '\U00016b32', '\U00016b33', '\U00016b34', '\U00016b35', '\U00016b36', '\U00016f51', '\U00016f52', 
    '\U00016f53', '\U00016f54', '\U00016f55', '\U00016f56', '\U00016f57', '\U00016f58', '\U00016f59', '\U00016f5a', 
    '\U00016f5b', '\U00016f5c', '\U00016f5d', '\U00016f5e', '\U00016f5f', '\U00016f60', '\U00016f61', '\U00016f62', 
    '\U00016f63', '\U00016f64', '\U00016f65', '\U00016f66', '\U00016f67', '\U00016f68', '\U00016f69', '\U00016f6a', 
    '\U00016f6b', '\U00016f6c', '\U00016f6d', '\U00016f6e', '\U00016f6f', '\U00016f70', '\U00016f71', '\U00016f72', 
    '\U00016f73', '\U00016f74', '\U00016f75', '\U00016f76', '\U00016f77', '\U00016f78', '\U00016f79', '\U00016f7a', 
    '\U00016f7b', '\U00016f7c', '\U00016f7d', '\U00016f7e', '\U00016f8f', '\U00016f90', '\U00016f91', '\U00016f92', 
    '\U0001bc9d', '\U0001bc9e', '\U0001d165', '\U0001d166', '\U0001d167', '\U0001d168', '\U0001d169', '\U0001d16d', 
    '\U0001d16e', '\U0001d16f', '\U0001d170', '\U0001d171', '\U0001d172', '\U0001d17b', '\U0001d17c', '\U0001d17d', 
    '\U0001d17e', '\U0001d17f', '\U0001d180', '\U0001d181', '\U0001d182', '\U0001d185', '\U0001d186', '\U0001d187', 
    '\U0001d188', '\U0001d189', '\U0001d18a', '\U0001d18b', '\U0001d1aa', '\U0001d1ab', '\U0001d1ac', '\U0001d1ad', 
    '\U0001d242', '\U0001d243', '\U0001d244', '\U0001da00', '\U0001da01', '\U0001da02', '\U0001da03', '\U0001da04', 
    '\U0001da05', '\U0001da06', '\U0001da07', '\U0001da08', '\U0001da09', '\U0001da0a', '\U0001da0b', '\U0001da0c', 
    '\U0001da0d', '\U0001da0e', '\U0001da0f', '\U0001da10', '\U0001da11', '\U0001da12', '\U0001da13', '\U0001da14', 
    '\U0001da15', '\U0001da16', '\U0001da17', '\U0001da18', '\U0001da19', '\U0001da1a', '\U0001da1b', '\U0001da1c', 
    '\U0001da1d', '\U0001da1e', '\U0001da1f', '\U0001da20', '\U0001da21', '\U0001da22', '\U0001da23', '\U0001da24', 
    '\U0001da25', '\U0001da26', '\U0001da27', '\U0001da28', '\U0001da29', '\U0001da2a', '\U0001da2b', '\U0001da2c', 
    '\U0001da2d', '\U0001da2e', '\U0001da2f', '\U0001da30', '\U0001da31', '\U0001da32', '\U0001da33', '\U0001da34', 
    '\U0001da35', '\U0001da36', '\U0001da3b', '\U0001da3c', '\U0001da3d', '\U0001da3e', '\U0001da3f', '\U0001da40', 
    '\U0001da41', '\U0001da42', '\U0001da43', '\U0001da44', '\U0001da45', '\U0001da46', '\U0001da47', '\U0001da48', 
    '\U0001da49', '\U0001da4a', '\U0001da4b', '\U0001da4c', '\U0001da4d', '\U0001da4e', '\U0001da4f', '\U0001da50', 
    '\U0001da51', '\U0001da52', '\U0001da53', '\U0001da54', '\U0001da55', '\U0001da56', '\U0001da57', '\U0001da58', 
    '\U0001da59', '\U0001da5a', '\U0001da5b', '\U0001da5c', '\U0001da5d', '\U0001da5e', '\U0001da5f', '\U0001da60', 
    '\U0001da61', '\U0001da62', '\U0001da63', '\U0001da64', '\U0001da65', '\U0001da66', '\U0001da67', '\U0001da68', 
    '\U0001da69', '\U0001da6a', '\U0001da6b', '\U0001da6c', '\U0001da75', '\U0001da84', '\U0001da9b', '\U0001da9c', 
    '\U0001da9d', '\U0001da9e', '\U0001da9f', '\U0001daa1', '\U0001daa2', '\U0001daa3', '\U0001daa4', '\U0001daa5', 
    '\U0001daa6', '\U0001daa7', '\U0001daa8', '\U0001daa9', '\U0001daaa', '\U0001daab', '\U0001daac', '\U0001daad', 
    '\U0001daae', '\U0001daaf', '\U0001e000', '\U0001e001', '\U0001e002', '\U0001e003', '\U0001e004', '\U0001e005', 
    '\U0001e006', '\U0001e008', '\U0001e009', '\U0001e00a', '\U0001e00b', '\U0001e00c', '\U0001e00d', '\U0001e00e', 
    '\U0001e00f', '\U0001e010', '\U0001e011', '\U0001e012', '\U0001e013', '\U0001e014', '\U0001e015', '\U0001e016', 
    '\U0001e017', '\U0001e018', '\U0001e01b', '\U0001e01c', '\U0001e01d', '\U0001e01e', '\U0001e01f', '\U0001e020', 
    '\U0001e021', '\U0001e023', '\U0001e024', '\U0001e026', '\U0001e027', '\U0001e028', '\U0001e029', '\U0001e02a', 
    '\U0001e8d0', '\U0001e8d1', '\U0001e8d2', '\U0001e8d3', '\U0001e8d4', '\U0001e8d5', '\U0001e8d6', '\U0001e944', 
    '\U0001e945', '\U0001e946', '\U0001e947', '\U0001e948', '\U0001e949', '\U0001e94a', '\U0001f3fb', '\U0001f3fc', 
    '\U0001f3fd', '\U0001f3fe', '\U0001f3ff', '\U000e0020', '\U000e0021', '\U000e0022', '\U000e0023', '\U000e0024', 
    '\U000e0025', '\U000e0026', '\U000e0027', '\U000e0028', '\U000e0029', '\U000e002a', '\U000e002b', '\U000e002c', 
    '\U000e002d', '\U000e002e', '\U000e002f', '\U000e0030', '\U000e0031', '\U000e0032', '\U000e0033', '\U000e0034', 
    '\U000e0035', '\U000e0036', '\U000e0037', '\U000e0038', '\U000e0039', '\U000e003a', '\U000e003b', '\U000e003c', 
    '\U000e003d', '\U000e003e', '\U000e003f', '\U000e0040', '\U000e0041', '\U000e0042', '\U000e0043', '\U000e0044', 
    '\U000e0045', '\U000e0046', '\U000e0047', '\U000e0048', '\U000e0049', '\U000e004a', '\U000e004b', '\U000e004c', 
    '\U000e004d', '\U000e004e', '\U000e004f', '\U000e0050', '\U000e0051', '\U000e0052', '\U000e0053', '\U000e0054', 
    '\U000e0055', '\U000e0056', '\U000e0057', '\U000e0058', '\U000e0059', '\U000e005a', '\U000e005b', '\U000e005c', 
    '\U000e005d', '\U000e005e', '\U000e005f', '\U000e0060', '\U000e0061', '\U000e0062', '\U000e0063', '\U000e0064', 
    '\U000e0065', '\U000e0066', '\U000e0067', '\U000e0068', '\U000e0069', '\U000e006a', '\U000e006b', '\U000e006c', 
    '\U000e006d', '\U000e006e', '\U000e006f', '\U000e0070', '\U000e0071', '\U000e0072', '\U000e0073', '\U000e0074', 
    '\U000e0075', '\U000e0076', '\U000e0077', '\U000e0078', '\U000e0079', '\U000e007a', '\U000e007b', '\U000e007c', 
    '\U000e007d', '\U000e007e', '\U000e007f', '\U000e0100', '\U000e0101', '\U000e0102', '\U000e0103', '\U000e0104', 
    '\U000e0105', '\U000e0106', '\U000e0107', '\U000e0108', '\U000e0109', '\U000e010a', '\U000e010b', '\U000e010c', 
    '\U000e010d', '\U000e010e', '\U000e010f', '\U000e0110', '\U000e0111', '\U000e0112', '\U000e0113', '\U000e0114', 
    '\U000e0115', '\U000e0116', '\U000e0117', '\U000e0118', '\U000e0119', '\U000e011a', '\U000e011b', '\U000e011c', 
    '\U000e011d', '\U000e011e', '\U000e011f', '\U000e0120', '\U000e0121', '\U000e0122', '\U000e0123', '\U000e0124', 
    '\U000e0125', '\U000e0126', '\U000e0127', '\U000e0128', '\U000e0129', '\U000e012a', '\U000e012b', '\U000e012c', 
    '\U000e012d', '\U000e012e', '\U000e012f', '\U000e0130', '\U000e0131', '\U000e0132', '\U000e0133', '\U000e0134', 
    '\U000e0135', '\U000e0136', '\U000e0137', '\U000e0138', '\U000e0139', '\U000e013a', '\U000e013b', '\U000e013c', 
    '\U000e013d', '\U000e013e', '\U000e013f', '\U000e0140', '\U000e0141', '\U000e0142', '\U000e0143', '\U000e0144', 
    '\U000e0145', '\U000e0146', '\U000e0147', '\U000e0148', '\U000e0149', '\U000e014a', '\U000e014b', '\U000e014c', 
    '\U000e014d', '\U000e014e', '\U000e014f', '\U000e0150', '\U000e0151', '\U000e0152', '\U000e0153', '\U000e0154', 
    '\U000e0155', '\U000e0156', '\U000e0157', '\U000e0158', '\U000e0159', '\U000e015a', '\U000e015b', '\U000e015c', 
    '\U000e015d', '\U000e015e', '\U000e015f', '\U000e0160', '\U000e0161', '\U000e0162', '\U000e0163', '\U000e0164', 
    '\U000e0165', '\U000e0166', '\U000e0167', '\U000e0168', '\U000e0169', '\U000e016a', '\U000e016b', '\U000e016c', 
    '\U000e016d', '\U000e016e', '\U000e016f', '\U000e0170', '\U000e0171', '\U000e0172', '\U000e0173', '\U000e0174', 
    '\U000e0175', '\U000e0176', '\U000e0177', '\U000e0178', '\U000e0179', '\U000e017a', '\U000e017b', '\U000e017c', 
    '\U000e017d', '\U000e017e', '\U000e017f', '\U000e0180', '\U000e0181', '\U000e0182', '\U000e0183', '\U000e0184', 
    '\U000e0185', '\U000e0186', '\U000e0187', '\U000e0188', '\U000e0189', '\U000e018a', '\U000e018b', '\U000e018c', 
    '\U000e018d', '\U000e018e', '\U000e018f', '\U000e0190', '\U000e0191', '\U000e0192', '\U000e0193', '\U000e0194', 
    '\U000e0195', '\U000e0196', '\U000e0197', '\U000e0198', '\U000e0199', '\U000e019a', '\U000e019b', '\U000e019c', 
    '\U000e019d', '\U000e019e', '\U000e019f', '\U000e01a0', '\U000e01a1', '\U000e01a2', '\U000e01a3', '\U000e01a4', 
    '\U000e01a5', '\U000e01a6', '\U000e01a7', '\U000e01a8', '\U000e01a9', '\U000e01aa', '\U000e01ab', '\U000e01ac', 
    '\U000e01ad', '\U000e01ae', '\U000e01af', '\U000e01b0', '\U000e01b1', '\U000e01b2', '\U000e01b3', '\U000e01b4', 
    '\U000e01b5', '\U000e01b6', '\U000e01b7', '\U000e01b8', '\U000e01b9', '\U000e01ba', '\U000e01bb', '\U000e01bc', 
    '\U000e01bd', '\U000e01be', '\U000e01bf', '\U000e01c0', '\U000e01c1', '\U000e01c2', '\U000e01c3', '\U000e01c4', 
    '\U000e01c5', '\U000e01c6', '\U000e01c7', '\U000e01c8', '\U000e01c9', '\U000e01ca', '\U000e01cb', '\U000e01cc', 
    '\U000e01cd', '\U000e01ce', '\U000e01cf', '\U000e01d0', '\U000e01d1', '\U000e01d2', '\U000e01d3', '\U000e01d4', 
    '\U000e01d5', '\U000e01d6', '\U000e01d7', '\U000e01d8', '\U000e01d9', '\U000e01da', '\U000e01db', '\U000e01dc', 
    '\U000e01dd', '\U000e01de', '\U000e01df', '\U000e01e0', '\U000e01e1', '\U000e01e2', '\U000e01e3', '\U000e01e4', 
    '\U000e01e5', '\U000e01e6', '\U000e01e7', '\U000e01e8', '\U000e01e9', '\U000e01ea', '\U000e01eb', '\U000e01ec', 
    '\U000e01ed', '\U000e01ee', '\U000e01ef')
    rangeFromUAX29Class[int(ExtendClass)] = Extend

    // Range for UAX#29 class Double_Quote
    Double_Quote = rangetable.New('"')
    rangeFromUAX29Class[int(Double_QuoteClass)] = Double_Quote

    // Range for UAX#29 class ALetter
    ALetter = rangetable.New('A', 'B', 'C', 'D', 'E', 'F', 
    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 
    'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 
    'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 
    'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 
    'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 
    'u', 'v', 'w', 'x', 'y', 'z', '\u00aa', '\u00b5', 
    '\u00ba', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', 
    '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', 
    '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', 
    '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', 
    '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', 
    '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', 
    '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f8', 
    '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff', '\u0100', 
    '\u0101', '\u0102', '\u0103', '\u0104', '\u0105', '\u0106', '\u0107', '\u0108', 
    '\u0109', '\u010a', '\u010b', '\u010c', '\u010d', '\u010e', '\u010f', '\u0110', 
    '\u0111', '\u0112', '\u0113', '\u0114', '\u0115', '\u0116', '\u0117', '\u0118', 
    '\u0119', '\u011a', '\u011b', '\u011c', '\u011d', '\u011e', '\u011f', '\u0120', 
    '\u0121', '\u0122', '\u0123', '\u0124', '\u0125', '\u0126', '\u0127', '\u0128', 
    '\u0129', '\u012a', '\u012b', '\u012c', '\u012d', '\u012e', '\u012f', '\u0130', 
    '\u0131', '\u0132', '\u0133', '\u0134', '\u0135', '\u0136', '\u0137', '\u0138', 
    '\u0139', '\u013a', '\u013b', '\u013c', '\u013d', '\u013e', '\u013f', '\u0140', 
    '\u0141', '\u0142', '\u0143', '\u0144', '\u0145', '\u0146', '\u0147', '\u0148', 
    '\u0149', '\u014a', '\u014b', '\u014c', '\u014d', '\u014e', '\u014f', '\u0150', 
    '\u0151', '\u0152', '\u0153', '\u0154', '\u0155', '\u0156', '\u0157', '\u0158', 
    '\u0159', '\u015a', '\u015b', '\u015c', '\u015d', '\u015e', '\u015f', '\u0160', 
    '\u0161', '\u0162', '\u0163', '\u0164', '\u0165', '\u0166', '\u0167', '\u0168', 
    '\u0169', '\u016a', '\u016b', '\u016c', '\u016d', '\u016e', '\u016f', '\u0170', 
    '\u0171', '\u0172', '\u0173', '\u0174', '\u0175', '\u0176', '\u0177', '\u0178', 
    '\u0179', '\u017a', '\u017b', '\u017c', '\u017d', '\u017e', '\u017f', '\u0180', 
    '\u0181', '\u0182', '\u0183', '\u0184', '\u0185', '\u0186', '\u0187', '\u0188', 
    '\u0189', '\u018a', '\u018b', '\u018c', '\u018d', '\u018e', '\u018f', '\u0190', 
    '\u0191', '\u0192', '\u0193', '\u0194', '\u0195', '\u0196', '\u0197', '\u0198', 
    '\u0199', '\u019a', '\u019b', '\u019c', '\u019d', '\u019e', '\u019f', '\u01a0', 
    '\u01a1', '\u01a2', '\u01a3', '\u01a4', '\u01a5', '\u01a6', '\u01a7', '\u01a8', 
    '\u01a9', '\u01aa', '\u01ab', '\u01ac', '\u01ad', '\u01ae', '\u01af', '\u01b0', 
    '\u01b1', '\u01b2', '\u01b3', '\u01b4', '\u01b5', '\u01b6', '\u01b7', '\u01b8', 
    '\u01b9', '\u01ba', '\u01bb', '\u01bc', '\u01bd', '\u01be', '\u01bf', '\u01c0', 
    '\u01c1', '\u01c2', '\u01c3', '\u01c4', '\u01c5', '\u01c6', '\u01c7', '\u01c8', 
    '\u01c9', '\u01ca', '\u01cb', '\u01cc', '\u01cd', '\u01ce', '\u01cf', '\u01d0', 
    '\u01d1', '\u01d2', '\u01d3', '\u01d4', '\u01d5', '\u01d6', '\u01d7', '\u01d8', 
    '\u01d9', '\u01da', '\u01db', '\u01dc', '\u01dd', '\u01de', '\u01df', '\u01e0', 
    '\u01e1', '\u01e2', '\u01e3', '\u01e4', '\u01e5', '\u01e6', '\u01e7', '\u01e8', 
    '\u01e9', '\u01ea', '\u01eb', '\u01ec', '\u01ed', '\u01ee', '\u01ef', '\u01f0', 
    '\u01f1', '\u01f2', '\u01f3', '\u01f4', '\u01f5', '\u01f6', '\u01f7', '\u01f8', 
    '\u01f9', '\u01fa', '\u01fb', '\u01fc', '\u01fd', '\u01fe', '\u01ff', '\u0200', 
    '\u0201', '\u0202', '\u0203', '\u0204', '\u0205', '\u0206', '\u0207', '\u0208', 
    '\u0209', '\u020a', '\u020b', '\u020c', '\u020d', '\u020e', '\u020f', '\u0210', 
    '\u0211', '\u0212', '\u0213', '\u0214', '\u0215', '\u0216', '\u0217', '\u0218', 
    '\u0219', '\u021a', '\u021b', '\u021c', '\u021d', '\u021e', '\u021f', '\u0220', 
    '\u0221', '\u0222', '\u0223', '\u0224', '\u0225', '\u0226', '\u0227', '\u0228', 
    '\u0229', '\u022a', '\u022b', '\u022c', '\u022d', '\u022e', '\u022f', '\u0230', 
    '\u0231', '\u0232', '\u0233', '\u0234', '\u0235', '\u0236', '\u0237', '\u0238', 
    '\u0239', '\u023a', '\u023b', '\u023c', '\u023d', '\u023e', '\u023f', '\u0240', 
    '\u0241', '\u0242', '\u0243', '\u0244', '\u0245', '\u0246', '\u0247', '\u0248', 
    '\u0249', '\u024a', '\u024b', '\u024c', '\u024d', '\u024e', '\u024f', '\u0250', 
    '\u0251', '\u0252', '\u0253', '\u0254', '\u0255', '\u0256', '\u0257', '\u0258', 
    '\u0259', '\u025a', '\u025b', '\u025c', '\u025d', '\u025e', '\u025f', '\u0260', 
    '\u0261', '\u0262', '\u0263', '\u0264', '\u0265', '\u0266', '\u0267', '\u0268', 
    '\u0269', '\u026a', '\u026b', '\u026c', '\u026d', '\u026e', '\u026f', '\u0270', 
    '\u0271', '\u0272', '\u0273', '\u0274', '\u0275', '\u0276', '\u0277', '\u0278', 
    '\u0279', '\u027a', '\u027b', '\u027c', '\u027d', '\u027e', '\u027f', '\u0280', 
    '\u0281', '\u0282', '\u0283', '\u0284', '\u0285', '\u0286', '\u0287', '\u0288', 
    '\u0289', '\u028a', '\u028b', '\u028c', '\u028d', '\u028e', '\u028f', '\u0290', 
    '\u0291', '\u0292', '\u0293', '\u0294', '\u0295', '\u0296', '\u0297', '\u0298', 
    '\u0299', '\u029a', '\u029b', '\u029c', '\u029d', '\u029e', '\u029f', '\u02a0', 
    '\u02a1', '\u02a2', '\u02a3', '\u02a4', '\u02a5', '\u02a6', '\u02a7', '\u02a8', 
    '\u02a9', '\u02aa', '\u02ab', '\u02ac', '\u02ad', '\u02ae', '\u02af', '\u02b0', 
    '\u02b1', '\u02b2', '\u02b3', '\u02b4', '\u02b5', '\u02b6', '\u02b7', '\u02b8', 
    '\u02b9', '\u02ba', '\u02bb', '\u02bc', '\u02bd', '\u02be', '\u02bf', '\u02c0', 
    '\u02c1', '\u02c2', '\u02c3', '\u02c4', '\u02c5', '\u02c6', '\u02c7', '\u02c8', 
    '\u02c9', '\u02ca', '\u02cb', '\u02cc', '\u02cd', '\u02ce', '\u02cf', '\u02d0', 
    '\u02d1', '\u02d2', '\u02d3', '\u02d4', '\u02d5', '\u02d6', '\u02d7', '\u02de', 
    '\u02df', '\u02e0', '\u02e1', '\u02e2', '\u02e3', '\u02e4', '\u02ec', '\u02ed', 
    '\u02ee', '\u02ef', '\u02f0', '\u02f1', '\u02f2', '\u02f3', '\u02f4', '\u02f5', 
    '\u02f6', '\u02f7', '\u02f8', '\u02f9', '\u02fa', '\u02fb', '\u02fc', '\u02fd', 
    '\u02fe', '\u02ff', '\u0370', '\u0371', '\u0372', '\u0373', '\u0374', '\u0376', 
    '\u0377', '\u037a', '\u037b', '\u037c', '\u037d', '\u037f', '\u0386', '\u0388', 
    '\u0389', '\u038a', '\u038c', '\u038e', '\u038f', '\u0390', '\u0391', '\u0392', 
    '\u0393', '\u0394', '\u0395', '\u0396', '\u0397', '\u0398', '\u0399', '\u039a', 
    '\u039b', '\u039c', '\u039d', '\u039e', '\u039f', '\u03a0', '\u03a1', '\u03a3', 
    '\u03a4', '\u03a5', '\u03a6', '\u03a7', '\u03a8', '\u03a9', '\u03aa', '\u03ab', 
    '\u03ac', '\u03ad', '\u03ae', '\u03af', '\u03b0', '\u03b1', '\u03b2', '\u03b3', 
    '\u03b4', '\u03b5', '\u03b6', '\u03b7', '\u03b8', '\u03b9', '\u03ba', '\u03bb', 
    '\u03bc', '\u03bd', '\u03be', '\u03bf', '\u03c0', '\u03c1', '\u03c2', '\u03c3', 
    '\u03c4', '\u03c5', '\u03c6', '\u03c7', '\u03c8', '\u03c9', '\u03ca', '\u03cb', 
    '\u03cc', '\u03cd', '\u03ce', '\u03cf', '\u03d0', '\u03d1', '\u03d2', '\u03d3', 
    '\u03d4', '\u03d5', '\u03d6', '\u03d7', '\u03d8', '\u03d9', '\u03da', '\u03db', 
    '\u03dc', '\u03dd', '\u03de', '\u03df', '\u03e0', '\u03e1', '\u03e2', '\u03e3', 
    '\u03e4', '\u03e5', '\u03e6', '\u03e7', '\u03e8', '\u03e9', '\u03ea', '\u03eb', 
    '\u03ec', '\u03ed', '\u03ee', '\u03ef', '\u03f0', '\u03f1', '\u03f2', '\u03f3', 
    '\u03f4', '\u03f5', '\u03f7', '\u03f8', '\u03f9', '\u03fa', '\u03fb', '\u03fc', 
    '\u03fd', '\u03fe', '\u03ff', '\u0400', '\u0401', '\u0402', '\u0403', '\u0404', 
    '\u0405', '\u0406', '\u0407', '\u0408', '\u0409', '\u040a', '\u040b', '\u040c', 
    '\u040d', '\u040e', '\u040f', '\u0410', '\u0411', '\u0412', '\u0413', '\u0414', 
    '\u0415', '\u0416', '\u0417', '\u0418', '\u0419', '\u041a', '\u041b', '\u041c', 
    '\u041d', '\u041e', '\u041f', '\u0420', '\u0421', '\u0422', '\u0423', '\u0424', 
    '\u0425', '\u0426', '\u0427', '\u0428', '\u0429', '\u042a', '\u042b', '\u042c', 
    '\u042d', '\u042e', '\u042f', '\u0430', '\u0431', '\u0432', '\u0433', '\u0434', 
    '\u0435', '\u0436', '\u0437', '\u0438', '\u0439', '\u043a', '\u043b', '\u043c', 
    '\u043d', '\u043e', '\u043f', '\u0440', '\u0441', '\u0442', '\u0443', '\u0444', 
    '\u0445', '\u0446', '\u0447', '\u0448', '\u0449', '\u044a', '\u044b', '\u044c', 
    '\u044d', '\u044e', '\u044f', '\u0450', '\u0451', '\u0452', '\u0453', '\u0454', 
    '\u0455', '\u0456', '\u0457', '\u0458', '\u0459', '\u045a', '\u045b', '\u045c', 
    '\u045d', '\u045e', '\u045f', '\u0460', '\u0461', '\u0462', '\u0463', '\u0464', 
    '\u0465', '\u0466', '\u0467', '\u0468', '\u0469', '\u046a', '\u046b', '\u046c', 
    '\u046d', '\u046e', '\u046f', '\u0470', '\u0471', '\u0472', '\u0473', '\u0474', 
    '\u0475', '\u0476', '\u0477', '\u0478', '\u0479', '\u047a', '\u047b', '\u047c', 
    '\u047d', '\u047e', '\u047f', '\u0480', '\u0481', '\u048a', '\u048b', '\u048c', 
    '\u048d', '\u048e', '\u048f', '\u0490', '\u0491', '\u0492', '\u0493', '\u0494', 
    '\u0495', '\u0496', '\u0497', '\u0498', '\u0499', '\u049a', '\u049b', '\u049c', 
    '\u049d', '\u049e', '\u049f', '\u04a0', '\u04a1', '\u04a2', '\u04a3', '\u04a4', 
    '\u04a5', '\u04a6', '\u04a7', '\u04a8', '\u04a9', '\u04aa', '\u04ab', '\u04ac', 
    '\u04ad', '\u04ae', '\u04af', '\u04b0', '\u04b1', '\u04b2', '\u04b3', '\u04b4', 
    '\u04b5', '\u04b6', '\u04b7', '\u04b8', '\u04b9', '\u04ba', '\u04bb', '\u04bc', 
    '\u04bd', '\u04be', '\u04bf', '\u04c0', '\u04c1', '\u04c2', '\u04c3', '\u04c4', 
    '\u04c5', '\u04c6', '\u04c7', '\u04c8', '\u04c9', '\u04ca', '\u04cb', '\u04cc', 
    '\u04cd', '\u04ce', '\u04cf', '\u04d0', '\u04d1', '\u04d2', '\u04d3', '\u04d4', 
    '\u04d5', '\u04d6', '\u04d7', '\u04d8', '\u04d9', '\u04da', '\u04db', '\u04dc', 
    '\u04dd', '\u04de', '\u04df', '\u04e0', '\u04e1', '\u04e2', '\u04e3', '\u04e4', 
    '\u04e5', '\u04e6', '\u04e7', '\u04e8', '\u04e9', '\u04ea', '\u04eb', '\u04ec', 
    '\u04ed', '\u04ee', '\u04ef', '\u04f0', '\u04f1', '\u04f2', '\u04f3', '\u04f4', 
    '\u04f5', '\u04f6', '\u04f7', '\u04f8', '\u04f9', '\u04fa', '\u04fb', '\u04fc', 
    '\u04fd', '\u04fe', '\u04ff', '\u0500', '\u0501', '\u0502', '\u0503', '\u0504', 
    '\u0505', '\u0506', '\u0507', '\u0508', '\u0509', '\u050a', '\u050b', '\u050c', 
    '\u050d', '\u050e', '\u050f', '\u0510', '\u0511', '\u0512', '\u0513', '\u0514', 
    '\u0515', '\u0516', '\u0517', '\u0518', '\u0519', '\u051a', '\u051b', '\u051c', 
    '\u051d', '\u051e', '\u051f', '\u0520', '\u0521', '\u0522', '\u0523', '\u0524', 
    '\u0525', '\u0526', '\u0527', '\u0528', '\u0529', '\u052a', '\u052b', '\u052c', 
    '\u052d', '\u052e', '\u052f', '\u0531', '\u0532', '\u0533', '\u0534', '\u0535', 
    '\u0536', '\u0537', '\u0538', '\u0539', '\u053a', '\u053b', '\u053c', '\u053d', 
    '\u053e', '\u053f', '\u0540', '\u0541', '\u0542', '\u0543', '\u0544', '\u0545', 
    '\u0546', '\u0547', '\u0548', '\u0549', '\u054a', '\u054b', '\u054c', '\u054d', 
    '\u054e', '\u054f', '\u0550', '\u0551', '\u0552', '\u0553', '\u0554', '\u0555', 
    '\u0556', '\u0559', '\u055b', '\u055c', '\u055e', '\u0560', '\u0561', '\u0562', 
    '\u0563', '\u0564', '\u0565', '\u0566', '\u0567', '\u0568', '\u0569', '\u056a', 
    '\u056b', '\u056c', '\u056d', '\u056e', '\u056f', '\u0570', '\u0571', '\u0572', 
    '\u0573', '\u0574', '\u0575', '\u0576', '\u0577', '\u0578', '\u0579', '\u057a', 
    '\u057b', '\u057c', '\u057d', '\u057e', '\u057f', '\u0580', '\u0581', '\u0582', 
    '\u0583', '\u0584', '\u0585', '\u0586', '\u0587', '\u0588', '\u05f3', '\u0620', 
    '\u0621', '\u0622', '\u0623', '\u0624', '\u0625', '\u0626', '\u0627', '\u0628', 
    '\u0629', '\u062a', '\u062b', '\u062c', '\u062d', '\u062e', '\u062f', '\u0630', 
    '\u0631', '\u0632', '\u0633', '\u0634', '\u0635', '\u0636', '\u0637', '\u0638', 
    '\u0639', '\u063a', '\u063b', '\u063c', '\u063d', '\u063e', '\u063f', '\u0640', 
    '\u0641', '\u0642', '\u0643', '\u0644', '\u0645', '\u0646', '\u0647', '\u0648', 
    '\u0649', '\u064a', '\u066e', '\u066f', '\u0671', '\u0672', '\u0673', '\u0674', 
    '\u0675', '\u0676', '\u0677', '\u0678', '\u0679', '\u067a', '\u067b', '\u067c', 
    '\u067d', '\u067e', '\u067f', '\u0680', '\u0681', '\u0682', '\u0683', '\u0684', 
    '\u0685', '\u0686', '\u0687', '\u0688', '\u0689', '\u068a', '\u068b', '\u068c', 
    '\u068d', '\u068e', '\u068f', '\u0690', '\u0691', '\u0692', '\u0693', '\u0694', 
    '\u0695', '\u0696', '\u0697', '\u0698', '\u0699', '\u069a', '\u069b', '\u069c', 
    '\u069d', '\u069e', '\u069f', '\u06a0', '\u06a1', '\u06a2', '\u06a3', '\u06a4', 
    '\u06a5', '\u06a6', '\u06a7', '\u06a8', '\u06a9', '\u06aa', '\u06ab', '\u06ac', 
    '\u06ad', '\u06ae', '\u06af', '\u06b0', '\u06b1', '\u06b2', '\u06b3', '\u06b4', 
    '\u06b5', '\u06b6', '\u06b7', '\u06b8', '\u06b9', '\u06ba', '\u06bb', '\u06bc', 
    '\u06bd', '\u06be', '\u06bf', '\u06c0', '\u06c1', '\u06c2', '\u06c3', '\u06c4', 
    '\u06c5', '\u06c6', '\u06c7', '\u06c8', '\u06c9', '\u06ca', '\u06cb', '\u06cc', 
    '\u06cd', '\u06ce', '\u06cf', '\u06d0', '\u06d1', '\u06d2', '\u06d3', '\u06d5', 
    '\u06e5', '\u06e6', '\u06ee', '\u06ef', '\u06fa', '\u06fb', '\u06fc', '\u06ff', 
    '\u0710', '\u0712', '\u0713', '\u0714', '\u0715', '\u0716', '\u0717', '\u0718', 
    '\u0719', '\u071a', '\u071b', '\u071c', '\u071d', '\u071e', '\u071f', '\u0720', 
    '\u0721', '\u0722', '\u0723', '\u0724', '\u0725', '\u0726', '\u0727', '\u0728', 
    '\u0729', '\u072a', '\u072b', '\u072c', '\u072d', '\u072e', '\u072f', '\u074d', 
    '\u074e', '\u074f', '\u0750', '\u0751', '\u0752', '\u0753', '\u0754', '\u0755', 
    '\u0756', '\u0757', '\u0758', '\u0759', '\u075a', '\u075b', '\u075c', '\u075d', 
    '\u075e', '\u075f', '\u0760', '\u0761', '\u0762', '\u0763', '\u0764', '\u0765', 
    '\u0766', '\u0767', '\u0768', '\u0769', '\u076a', '\u076b', '\u076c', '\u076d', 
    '\u076e', '\u076f', '\u0770', '\u0771', '\u0772', '\u0773', '\u0774', '\u0775', 
    '\u0776', '\u0777', '\u0778', '\u0779', '\u077a', '\u077b', '\u077c', '\u077d', 
    '\u077e', '\u077f', '\u0780', '\u0781', '\u0782', '\u0783', '\u0784', '\u0785', 
    '\u0786', '\u0787', '\u0788', '\u0789', '\u078a', '\u078b', '\u078c', '\u078d', 
    '\u078e', '\u078f', '\u0790', '\u0791', '\u0792', '\u0793', '\u0794', '\u0795', 
    '\u0796', '\u0797', '\u0798', '\u0799', '\u079a', '\u079b', '\u079c', '\u079d', 
    '\u079e', '\u079f', '\u07a0', '\u07a1', '\u07a2', '\u07a3', '\u07a4', '\u07a5', 
    '\u07b1', '\u07ca', '\u07cb', '\u07cc', '\u07cd', '\u07ce', '\u07cf', '\u07d0', 
    '\u07d1', '\u07d2', '\u07d3', '\u07d4', '\u07d5', '\u07d6', '\u07d7', '\u07d8', 
    '\u07d9', '\u07da', '\u07db', '\u07dc', '\u07dd', '\u07de', '\u07df', '\u07e0', 
    '\u07e1', '\u07e2', '\u07e3', '\u07e4', '\u07e5', '\u07e6', '\u07e7', '\u07e8', 
    '\u07e9', '\u07ea', '\u07f4', '\u07f5', '\u07fa', '\u0800', '\u0801', '\u0802', 
    '\u0803', '\u0804', '\u0805', '\u0806', '\u0807', '\u0808', '\u0809', '\u080a', 
    '\u080b', '\u080c', '\u080d', '\u080e', '\u080f', '\u0810', '\u0811', '\u0812', 
    '\u0813', '\u0814', '\u0815', '\u081a', '\u0824', '\u0828', '\u0840', '\u0841', 
    '\u0842', '\u0843', '\u0844', '\u0845', '\u0846', '\u0847', '\u0848', '\u0849', 
    '\u084a', '\u084b', '\u084c', '\u084d', '\u084e', '\u084f', '\u0850', '\u0851', 
    '\u0852', '\u0853', '\u0854', '\u0855', '\u0856', '\u0857', '\u0858', '\u0860', 
    '\u0861', '\u0862', '\u0863', '\u0864', '\u0865', '\u0866', '\u0867', '\u0868', 
    '\u0869', '\u086a', '\u08a0', '\u08a1', '\u08a2', '\u08a3', '\u08a4', '\u08a5', 
    '\u08a6', '\u08a7', '\u08a8', '\u08a9', '\u08aa', '\u08ab', '\u08ac', '\u08ad', 
    '\u08ae', '\u08af', '\u08b0', '\u08b1', '\u08b2', '\u08b3', '\u08b4', '\u08b6', 
    '\u08b7', '\u08b8', '\u08b9', '\u08ba', '\u08bb', '\u08bc', '\u08bd', '\u0904', 
    '\u0905', '\u0906', '\u0907', '\u0908', '\u0909', '\u090a', '\u090b', '\u090c', 
    '\u090d', '\u090e', '\u090f', '\u0910', '\u0911', '\u0912', '\u0913', '\u0914', 
    '\u0915', '\u0916', '\u0917', '\u0918', '\u0919', '\u091a', '\u091b', '\u091c', 
    '\u091d', '\u091e', '\u091f', '\u0920', '\u0921', '\u0922', '\u0923', '\u0924', 
    '\u0925', '\u0926', '\u0927', '\u0928', '\u0929', '\u092a', '\u092b', '\u092c', 
    '\u092d', '\u092e', '\u092f', '\u0930', '\u0931', '\u0932', '\u0933', '\u0934', 
    '\u0935', '\u0936', '\u0937', '\u0938', '\u0939', '\u093d', '\u0950', '\u0958', 
    '\u0959', '\u095a', '\u095b', '\u095c', '\u095d', '\u095e', '\u095f', '\u0960', 
    '\u0961', '\u0971', '\u0972', '\u0973', '\u0974', '\u0975', '\u0976', '\u0977', 
    '\u0978', '\u0979', '\u097a', '\u097b', '\u097c', '\u097d', '\u097e', '\u097f', 
    '\u0980', '\u0985', '\u0986', '\u0987', '\u0988', '\u0989', '\u098a', '\u098b', 
    '\u098c', '\u098f', '\u0990', '\u0993', '\u0994', '\u0995', '\u0996', '\u0997', 
    '\u0998', '\u0999', '\u099a', '\u099b', '\u099c', '\u099d', '\u099e', '\u099f', 
    '\u09a0', '\u09a1', '\u09a2', '\u09a3', '\u09a4', '\u09a5', '\u09a6', '\u09a7', 
    '\u09a8', '\u09aa', '\u09ab', '\u09ac', '\u09ad', '\u09ae', '\u09af', '\u09b0', 
    '\u09b2', '\u09b6', '\u09b7', '\u09b8', '\u09b9', '\u09bd', '\u09ce', '\u09dc', 
    '\u09dd', '\u09df', '\u09e0', '\u09e1', '\u09f0', '\u09f1', '\u09fc', '\u0a05', 
    '\u0a06', '\u0a07', '\u0a08', '\u0a09', '\u0a0a', '\u0a0f', '\u0a10', '\u0a13', 
    '\u0a14', '\u0a15', '\u0a16', '\u0a17', '\u0a18', '\u0a19', '\u0a1a', '\u0a1b', 
    '\u0a1c', '\u0a1d', '\u0a1e', '\u0a1f', '\u0a20', '\u0a21', '\u0a22', '\u0a23', 
    '\u0a24', '\u0a25', '\u0a26', '\u0a27', '\u0a28', '\u0a2a', '\u0a2b', '\u0a2c', 
    '\u0a2d', '\u0a2e', '\u0a2f', '\u0a30', '\u0a32', '\u0a33', '\u0a35', '\u0a36', 
    '\u0a38', '\u0a39', '\u0a59', '\u0a5a', '\u0a5b', '\u0a5c', '\u0a5e', '\u0a72', 
    '\u0a73', '\u0a74', '\u0a85', '\u0a86', '\u0a87', '\u0a88', '\u0a89', '\u0a8a', 
    '\u0a8b', '\u0a8c', '\u0a8d', '\u0a8f', '\u0a90', '\u0a91', '\u0a93', '\u0a94', 
    '\u0a95', '\u0a96', '\u0a97', '\u0a98', '\u0a99', '\u0a9a', '\u0a9b', '\u0a9c', 
    '\u0a9d', '\u0a9e', '\u0a9f', '\u0aa0', '\u0aa1', '\u0aa2', '\u0aa3', '\u0aa4', 
    '\u0aa5', '\u0aa6', '\u0aa7', '\u0aa8', '\u0aaa', '\u0aab', '\u0aac', '\u0aad', 
    '\u0aae', '\u0aaf', '\u0ab0', '\u0ab2', '\u0ab3', '\u0ab5', '\u0ab6', '\u0ab7', 
    '\u0ab8', '\u0ab9', '\u0abd', '\u0ad0', '\u0ae0', '\u0ae1', '\u0af9', '\u0b05', 
    '\u0b06', '\u0b07', '\u0b08', '\u0b09', '\u0b0a', '\u0b0b', '\u0b0c', '\u0b0f', 
    '\u0b10', '\u0b13', '\u0b14', '\u0b15', '\u0b16', '\u0b17', '\u0b18', '\u0b19', 
    '\u0b1a', '\u0b1b', '\u0b1c', '\u0b1d', '\u0b1e', '\u0b1f', '\u0b20', '\u0b21', 
    '\u0b22', '\u0b23', '\u0b24', '\u0b25', '\u0b26', '\u0b27', '\u0b28', '\u0b2a', 
    '\u0b2b', '\u0b2c', '\u0b2d', '\u0b2e', '\u0b2f', '\u0b30', '\u0b32', '\u0b33', 
    '\u0b35', '\u0b36', '\u0b37', '\u0b38', '\u0b39', '\u0b3d', '\u0b5c', '\u0b5d', 
    '\u0b5f', '\u0b60', '\u0b61', '\u0b71', '\u0b83', '\u0b85', '\u0b86', '\u0b87', 
    '\u0b88', '\u0b89', '\u0b8a', '\u0b8e', '\u0b8f', '\u0b90', '\u0b92', '\u0b93', 
    '\u0b94', '\u0b95', '\u0b99', '\u0b9a', '\u0b9c', '\u0b9e', '\u0b9f', '\u0ba3', 
    '\u0ba4', '\u0ba8', '\u0ba9', '\u0baa', '\u0bae', '\u0baf', '\u0bb0', '\u0bb1', 
    '\u0bb2', '\u0bb3', '\u0bb4', '\u0bb5', '\u0bb6', '\u0bb7', '\u0bb8', '\u0bb9', 
    '\u0bd0', '\u0c05', '\u0c06', '\u0c07', '\u0c08', '\u0c09', '\u0c0a', '\u0c0b', 
    '\u0c0c', '\u0c0e', '\u0c0f', '\u0c10', '\u0c12', '\u0c13', '\u0c14', '\u0c15', 
    '\u0c16', '\u0c17', '\u0c18', '\u0c19', '\u0c1a', '\u0c1b', '\u0c1c', '\u0c1d', 
    '\u0c1e', '\u0c1f', '\u0c20', '\u0c21', '\u0c22', '\u0c23', '\u0c24', '\u0c25', 
    '\u0c26', '\u0c27', '\u0c28', '\u0c2a', '\u0c2b', '\u0c2c', '\u0c2d', '\u0c2e', 
    '\u0c2f', '\u0c30', '\u0c31', '\u0c32', '\u0c33', '\u0c34', '\u0c35', '\u0c36', 
    '\u0c37', '\u0c38', '\u0c39', '\u0c3d', '\u0c58', '\u0c59', '\u0c5a', '\u0c60', 
    '\u0c61', '\u0c80', '\u0c85', '\u0c86', '\u0c87', '\u0c88', '\u0c89', '\u0c8a', 
    '\u0c8b', '\u0c8c', '\u0c8e', '\u0c8f', '\u0c90', '\u0c92', '\u0c93', '\u0c94', 
    '\u0c95', '\u0c96', '\u0c97', '\u0c98', '\u0c99', '\u0c9a', '\u0c9b', '\u0c9c', 
    '\u0c9d', '\u0c9e', '\u0c9f', '\u0ca0', '\u0ca1', '\u0ca2', '\u0ca3', '\u0ca4', 
    '\u0ca5', '\u0ca6', '\u0ca7', '\u0ca8', '\u0caa', '\u0cab', '\u0cac', '\u0cad', 
    '\u0cae', '\u0caf', '\u0cb0', '\u0cb1', '\u0cb2', '\u0cb3', '\u0cb5', '\u0cb6', 
    '\u0cb7', '\u0cb8', '\u0cb9', '\u0cbd', '\u0cde', '\u0ce0', '\u0ce1', '\u0cf1', 
    '\u0cf2', '\u0d05', '\u0d06', '\u0d07', '\u0d08', '\u0d09', '\u0d0a', '\u0d0b', 
    '\u0d0c', '\u0d0e', '\u0d0f', '\u0d10', '\u0d12', '\u0d13', '\u0d14', '\u0d15', 
    '\u0d16', '\u0d17', '\u0d18', '\u0d19', '\u0d1a', '\u0d1b', '\u0d1c', '\u0d1d', 
    '\u0d1e', '\u0d1f', '\u0d20', '\u0d21', '\u0d22', '\u0d23', '\u0d24', '\u0d25', 
    '\u0d26', '\u0d27', '\u0d28', '\u0d29', '\u0d2a', '\u0d2b', '\u0d2c', '\u0d2d', 
    '\u0d2e', '\u0d2f', '\u0d30', '\u0d31', '\u0d32', '\u0d33', '\u0d34', '\u0d35', 
    '\u0d36', '\u0d37', '\u0d38', '\u0d39', '\u0d3a', '\u0d3d', '\u0d4e', '\u0d54', 
    '\u0d55', '\u0d56', '\u0d5f', '\u0d60', '\u0d61', '\u0d7a', '\u0d7b', '\u0d7c', 
    '\u0d7d', '\u0d7e', '\u0d7f', '\u0d85', '\u0d86', '\u0d87', '\u0d88', '\u0d89', 
    '\u0d8a', '\u0d8b', '\u0d8c', '\u0d8d', '\u0d8e', '\u0d8f', '\u0d90', '\u0d91', 
    '\u0d92', '\u0d93', '\u0d94', '\u0d95', '\u0d96', '\u0d9a', '\u0d9b', '\u0d9c', 
    '\u0d9d', '\u0d9e', '\u0d9f', '\u0da0', '\u0da1', '\u0da2', '\u0da3', '\u0da4', 
    '\u0da5', '\u0da6', '\u0da7', '\u0da8', '\u0da9', '\u0daa', '\u0dab', '\u0dac', 
    '\u0dad', '\u0dae', '\u0daf', '\u0db0', '\u0db1', '\u0db3', '\u0db4', '\u0db5', 
    '\u0db6', '\u0db7', '\u0db8', '\u0db9', '\u0dba', '\u0dbb', '\u0dbd', '\u0dc0', 
    '\u0dc1', '\u0dc2', '\u0dc3', '\u0dc4', '\u0dc5', '\u0dc6', '\u0f00', '\u0f40', 
    '\u0f41', '\u0f42', '\u0f43', '\u0f44', '\u0f45', '\u0f46', '\u0f47', '\u0f49', 
    '\u0f4a', '\u0f4b', '\u0f4c', '\u0f4d', '\u0f4e', '\u0f4f', '\u0f50', '\u0f51', 
    '\u0f52', '\u0f53', '\u0f54', '\u0f55', '\u0f56', '\u0f57', '\u0f58', '\u0f59', 
    '\u0f5a', '\u0f5b', '\u0f5c', '\u0f5d', '\u0f5e', '\u0f5f', '\u0f60', '\u0f61', 
    '\u0f62', '\u0f63', '\u0f64', '\u0f65', '\u0f66', '\u0f67', '\u0f68', '\u0f69', 
    '\u0f6a', '\u0f6b', '\u0f6c', '\u0f88', '\u0f89', '\u0f8a', '\u0f8b', '\u0f8c', 
    '\u10a0', '\u10a1', '\u10a2', '\u10a3', '\u10a4', '\u10a5', '\u10a6', '\u10a7', 
    '\u10a8', '\u10a9', '\u10aa', '\u10ab', '\u10ac', '\u10ad', '\u10ae', '\u10af', 
    '\u10b0', '\u10b1', '\u10b2', '\u10b3', '\u10b4', '\u10b5', '\u10b6', '\u10b7', 
    '\u10b8', '\u10b9', '\u10ba', '\u10bb', '\u10bc', '\u10bd', '\u10be', '\u10bf', 
    '\u10c0', '\u10c1', '\u10c2', '\u10c3', '\u10c4', '\u10c5', '\u10c7', '\u10cd', 
    '\u10d0', '\u10d1', '\u10d2', '\u10d3', '\u10d4', '\u10d5', '\u10d6', '\u10d7', 
    '\u10d8', '\u10d9', '\u10da', '\u10db', '\u10dc', '\u10dd', '\u10de', '\u10df', 
    '\u10e0', '\u10e1', '\u10e2', '\u10e3', '\u10e4', '\u10e5', '\u10e6', '\u10e7', 
    '\u10e8', '\u10e9', '\u10ea', '\u10eb', '\u10ec', '\u10ed', '\u10ee', '\u10ef', 
    '\u10f0', '\u10f1', '\u10f2', '\u10f3', '\u10f4', '\u10f5', '\u10f6', '\u10f7', 
    '\u10f8', '\u10f9', '\u10fa', '\u10fc', '\u10fd', '\u10fe', '\u10ff', '\u1100', 
    '\u1101', '\u1102', '\u1103', '\u1104', '\u1105', '\u1106', '\u1107', '\u1108', 
    '\u1109', '\u110a', '\u110b', '\u110c', '\u110d', '\u110e', '\u110f', '\u1110', 
    '\u1111', '\u1112', '\u1113', '\u1114', '\u1115', '\u1116', '\u1117', '\u1118', 
    '\u1119', '\u111a', '\u111b', '\u111c', '\u111d', '\u111e', '\u111f', '\u1120', 
    '\u1121', '\u1122', '\u1123', '\u1124', '\u1125', '\u1126', '\u1127', '\u1128', 
    '\u1129', '\u112a', '\u112b', '\u112c', '\u112d', '\u112e', '\u112f', '\u1130', 
    '\u1131', '\u1132', '\u1133', '\u1134', '\u1135', '\u1136', '\u1137', '\u1138', 
    '\u1139', '\u113a', '\u113b', '\u113c', '\u113d', '\u113e', '\u113f', '\u1140', 
    '\u1141', '\u1142', '\u1143', '\u1144', '\u1145', '\u1146', '\u1147', '\u1148', 
    '\u1149', '\u114a', '\u114b', '\u114c', '\u114d', '\u114e', '\u114f', '\u1150', 
    '\u1151', '\u1152', '\u1153', '\u1154', '\u1155', '\u1156', '\u1157', '\u1158', 
    '\u1159', '\u115a', '\u115b', '\u115c', '\u115d', '\u115e', '\u115f', '\u1160', 
    '\u1161', '\u1162', '\u1163', '\u1164', '\u1165', '\u1166', '\u1167', '\u1168', 
    '\u1169', '\u116a', '\u116b', '\u116c', '\u116d', '\u116e', '\u116f', '\u1170', 
    '\u1171', '\u1172', '\u1173', '\u1174', '\u1175', '\u1176', '\u1177', '\u1178', 
    '\u1179', '\u117a', '\u117b', '\u117c', '\u117d', '\u117e', '\u117f', '\u1180', 
    '\u1181', '\u1182', '\u1183', '\u1184', '\u1185', '\u1186', '\u1187', '\u1188', 
    '\u1189', '\u118a', '\u118b', '\u118c', '\u118d', '\u118e', '\u118f', '\u1190', 
    '\u1191', '\u1192', '\u1193', '\u1194', '\u1195', '\u1196', '\u1197', '\u1198', 
    '\u1199', '\u119a', '\u119b', '\u119c', '\u119d', '\u119e', '\u119f', '\u11a0', 
    '\u11a1', '\u11a2', '\u11a3', '\u11a4', '\u11a5', '\u11a6', '\u11a7', '\u11a8', 
    '\u11a9', '\u11aa', '\u11ab', '\u11ac', '\u11ad', '\u11ae', '\u11af', '\u11b0', 
    '\u11b1', '\u11b2', '\u11b3', '\u11b4', '\u11b5', '\u11b6', '\u11b7', '\u11b8', 
    '\u11b9', '\u11ba', '\u11bb', '\u11bc', '\u11bd', '\u11be', '\u11bf', '\u11c0', 
    '\u11c1', '\u11c2', '\u11c3', '\u11c4', '\u11c5', '\u11c6', '\u11c7', '\u11c8', 
    '\u11c9', '\u11ca', '\u11cb', '\u11cc', '\u11cd', '\u11ce', '\u11cf', '\u11d0', 
    '\u11d1', '\u11d2', '\u11d3', '\u11d4', '\u11d5', '\u11d6', '\u11d7', '\u11d8', 
    '\u11d9', '\u11da', '\u11db', '\u11dc', '\u11dd', '\u11de', '\u11df', '\u11e0', 
    '\u11e1', '\u11e2', '\u11e3', '\u11e4', '\u11e5', '\u11e6', '\u11e7', '\u11e8', 
    '\u11e9', '\u11ea', '\u11eb', '\u11ec', '\u11ed', '\u11ee', '\u11ef', '\u11f0', 
    '\u11f1', '\u11f2', '\u11f3', '\u11f4', '\u11f5', '\u11f6', '\u11f7', '\u11f8', 
    '\u11f9', '\u11fa', '\u11fb', '\u11fc', '\u11fd', '\u11fe', '\u11ff', '\u1200', 
    '\u1201', '\u1202', '\u1203', '\u1204', '\u1205', '\u1206', '\u1207', '\u1208', 
    '\u1209', '\u120a', '\u120b', '\u120c', '\u120d', '\u120e', '\u120f', '\u1210', 
    '\u1211', '\u1212', '\u1213', '\u1214', '\u1215', '\u1216', '\u1217', '\u1218', 
    '\u1219', '\u121a', '\u121b', '\u121c', '\u121d', '\u121e', '\u121f', '\u1220', 
    '\u1221', '\u1222', '\u1223', '\u1224', '\u1225', '\u1226', '\u1227', '\u1228', 
    '\u1229', '\u122a', '\u122b', '\u122c', '\u122d', '\u122e', '\u122f', '\u1230', 
    '\u1231', '\u1232', '\u1233', '\u1234', '\u1235', '\u1236', '\u1237', '\u1238', 
    '\u1239', '\u123a', '\u123b', '\u123c', '\u123d', '\u123e', '\u123f', '\u1240', 
    '\u1241', '\u1242', '\u1243', '\u1244', '\u1245', '\u1246', '\u1247', '\u1248', 
    '\u124a', '\u124b', '\u124c', '\u124d', '\u1250', '\u1251', '\u1252', '\u1253', 
    '\u1254', '\u1255', '\u1256', '\u1258', '\u125a', '\u125b', '\u125c', '\u125d', 
    '\u1260', '\u1261', '\u1262', '\u1263', '\u1264', '\u1265', '\u1266', '\u1267', 
    '\u1268', '\u1269', '\u126a', '\u126b', '\u126c', '\u126d', '\u126e', '\u126f', 
    '\u1270', '\u1271', '\u1272', '\u1273', '\u1274', '\u1275', '\u1276', '\u1277', 
    '\u1278', '\u1279', '\u127a', '\u127b', '\u127c', '\u127d', '\u127e', '\u127f', 
    '\u1280', '\u1281', '\u1282', '\u1283', '\u1284', '\u1285', '\u1286', '\u1287', 
    '\u1288', '\u128a', '\u128b', '\u128c', '\u128d', '\u1290', '\u1291', '\u1292', 
    '\u1293', '\u1294', '\u1295', '\u1296', '\u1297', '\u1298', '\u1299', '\u129a', 
    '\u129b', '\u129c', '\u129d', '\u129e', '\u129f', '\u12a0', '\u12a1', '\u12a2', 
    '\u12a3', '\u12a4', '\u12a5', '\u12a6', '\u12a7', '\u12a8', '\u12a9', '\u12aa', 
    '\u12ab', '\u12ac', '\u12ad', '\u12ae', '\u12af', '\u12b0', '\u12b2', '\u12b3', 
    '\u12b4', '\u12b5', '\u12b8', '\u12b9', '\u12ba', '\u12bb', '\u12bc', '\u12bd', 
    '\u12be', '\u12c0', '\u12c2', '\u12c3', '\u12c4', '\u12c5', '\u12c8', '\u12c9', 
    '\u12ca', '\u12cb', '\u12cc', '\u12cd', '\u12ce', '\u12cf', '\u12d0', '\u12d1', 
    '\u12d2', '\u12d3', '\u12d4', '\u12d5', '\u12d6', '\u12d8', '\u12d9', '\u12da', 
    '\u12db', '\u12dc', '\u12dd', '\u12de', '\u12df', '\u12e0', '\u12e1', '\u12e2', 
    '\u12e3', '\u12e4', '\u12e5', '\u12e6', '\u12e7', '\u12e8', '\u12e9', '\u12ea', 
    '\u12eb', '\u12ec', '\u12ed', '\u12ee', '\u12ef', '\u12f0', '\u12f1', '\u12f2', 
    '\u12f3', '\u12f4', '\u12f5', '\u12f6', '\u12f7', '\u12f8', '\u12f9', '\u12fa', 
    '\u12fb', '\u12fc', '\u12fd', '\u12fe', '\u12ff', '\u1300', '\u1301', '\u1302', 
    '\u1303', '\u1304', '\u1305', '\u1306', '\u1307', '\u1308', '\u1309', '\u130a', 
    '\u130b', '\u130c', '\u130d', '\u130e', '\u130f', '\u1310', '\u1312', '\u1313', 
    '\u1314', '\u1315', '\u1318', '\u1319', '\u131a', '\u131b', '\u131c', '\u131d', 
    '\u131e', '\u131f', '\u1320', '\u1321', '\u1322', '\u1323', '\u1324', '\u1325', 
    '\u1326', '\u1327', '\u1328', '\u1329', '\u132a', '\u132b', '\u132c', '\u132d', 
    '\u132e', '\u132f', '\u1330', '\u1331', '\u1332', '\u1333', '\u1334', '\u1335', 
    '\u1336', '\u1337', '\u1338', '\u1339', '\u133a', '\u133b', '\u133c', '\u133d', 
    '\u133e', '\u133f', '\u1340', '\u1341', '\u1342', '\u1343', '\u1344', '\u1345', 
    '\u1346', '\u1347', '\u1348', '\u1349', '\u134a', '\u134b', '\u134c', '\u134d', 
    '\u134e', '\u134f', '\u1350', '\u1351', '\u1352', '\u1353', '\u1354', '\u1355', 
    '\u1356', '\u1357', '\u1358', '\u1359', '\u135a', '\u1380', '\u1381', '\u1382', 
    '\u1383', '\u1384', '\u1385', '\u1386', '\u1387', '\u1388', '\u1389', '\u138a', 
    '\u138b', '\u138c', '\u138d', '\u138e', '\u138f', '\u13a0', '\u13a1', '\u13a2', 
    '\u13a3', '\u13a4', '\u13a5', '\u13a6', '\u13a7', '\u13a8', '\u13a9', '\u13aa', 
    '\u13ab', '\u13ac', '\u13ad', '\u13ae', '\u13af', '\u13b0', '\u13b1', '\u13b2', 
    '\u13b3', '\u13b4', '\u13b5', '\u13b6', '\u13b7', '\u13b8', '\u13b9', '\u13ba', 
    '\u13bb', '\u13bc', '\u13bd', '\u13be', '\u13bf', '\u13c0', '\u13c1', '\u13c2', 
    '\u13c3', '\u13c4', '\u13c5', '\u13c6', '\u13c7', '\u13c8', '\u13c9', '\u13ca', 
    '\u13cb', '\u13cc', '\u13cd', '\u13ce', '\u13cf', '\u13d0', '\u13d1', '\u13d2', 
    '\u13d3', '\u13d4', '\u13d5', '\u13d6', '\u13d7', '\u13d8', '\u13d9', '\u13da', 
    '\u13db', '\u13dc', '\u13dd', '\u13de', '\u13df', '\u13e0', '\u13e1', '\u13e2', 
    '\u13e3', '\u13e4', '\u13e5', '\u13e6', '\u13e7', '\u13e8', '\u13e9', '\u13ea', 
    '\u13eb', '\u13ec', '\u13ed', '\u13ee', '\u13ef', '\u13f0', '\u13f1', '\u13f2', 
    '\u13f3', '\u13f4', '\u13f5', '\u13f8', '\u13f9', '\u13fa', '\u13fb', '\u13fc', 
    '\u13fd', '\u1401', '\u1402', '\u1403', '\u1404', '\u1405', '\u1406', '\u1407', 
    '\u1408', '\u1409', '\u140a', '\u140b', '\u140c', '\u140d', '\u140e', '\u140f', 
    '\u1410', '\u1411', '\u1412', '\u1413', '\u1414', '\u1415', '\u1416', '\u1417', 
    '\u1418', '\u1419', '\u141a', '\u141b', '\u141c', '\u141d', '\u141e', '\u141f', 
    '\u1420', '\u1421', '\u1422', '\u1423', '\u1424', '\u1425', '\u1426', '\u1427', 
    '\u1428', '\u1429', '\u142a', '\u142b', '\u142c', '\u142d', '\u142e', '\u142f', 
    '\u1430', '\u1431', '\u1432', '\u1433', '\u1434', '\u1435', '\u1436', '\u1437', 
    '\u1438', '\u1439', '\u143a', '\u143b', '\u143c', '\u143d', '\u143e', '\u143f', 
    '\u1440', '\u1441', '\u1442', '\u1443', '\u1444', '\u1445', '\u1446', '\u1447', 
    '\u1448', '\u1449', '\u144a', '\u144b', '\u144c', '\u144d', '\u144e', '\u144f', 
    '\u1450', '\u1451', '\u1452', '\u1453', '\u1454', '\u1455', '\u1456', '\u1457', 
    '\u1458', '\u1459', '\u145a', '\u145b', '\u145c', '\u145d', '\u145e', '\u145f', 
    '\u1460', '\u1461', '\u1462', '\u1463', '\u1464', '\u1465', '\u1466', '\u1467', 
    '\u1468', '\u1469', '\u146a', '\u146b', '\u146c', '\u146d', '\u146e', '\u146f', 
    '\u1470', '\u1471', '\u1472', '\u1473', '\u1474', '\u1475', '\u1476', '\u1477', 
    '\u1478', '\u1479', '\u147a', '\u147b', '\u147c', '\u147d', '\u147e', '\u147f', 
    '\u1480', '\u1481', '\u1482', '\u1483', '\u1484', '\u1485', '\u1486', '\u1487', 
    '\u1488', '\u1489', '\u148a', '\u148b', '\u148c', '\u148d', '\u148e', '\u148f', 
    '\u1490', '\u1491', '\u1492', '\u1493', '\u1494', '\u1495', '\u1496', '\u1497', 
    '\u1498', '\u1499', '\u149a', '\u149b', '\u149c', '\u149d', '\u149e', '\u149f', 
    '\u14a0', '\u14a1', '\u14a2', '\u14a3', '\u14a4', '\u14a5', '\u14a6', '\u14a7', 
    '\u14a8', '\u14a9', '\u14aa', '\u14ab', '\u14ac', '\u14ad', '\u14ae', '\u14af', 
    '\u14b0', '\u14b1', '\u14b2', '\u14b3', '\u14b4', '\u14b5', '\u14b6', '\u14b7', 
    '\u14b8', '\u14b9', '\u14ba', '\u14bb', '\u14bc', '\u14bd', '\u14be', '\u14bf', 
    '\u14c0', '\u14c1', '\u14c2', '\u14c3', '\u14c4', '\u14c5', '\u14c6', '\u14c7', 
    '\u14c8', '\u14c9', '\u14ca', '\u14cb', '\u14cc', '\u14cd', '\u14ce', '\u14cf', 
    '\u14d0', '\u14d1', '\u14d2', '\u14d3', '\u14d4', '\u14d5', '\u14d6', '\u14d7', 
    '\u14d8', '\u14d9', '\u14da', '\u14db', '\u14dc', '\u14dd', '\u14de', '\u14df', 
    '\u14e0', '\u14e1', '\u14e2', '\u14e3', '\u14e4', '\u14e5', '\u14e6', '\u14e7', 
    '\u14e8', '\u14e9', '\u14ea', '\u14eb', '\u14ec', '\u14ed', '\u14ee', '\u14ef', 
    '\u14f0', '\u14f1', '\u14f2', '\u14f3', '\u14f4', '\u14f5', '\u14f6', '\u14f7', 
    '\u14f8', '\u14f9', '\u14fa', '\u14fb', '\u14fc', '\u14fd', '\u14fe', '\u14ff', 
    '\u1500', '\u1501', '\u1502', '\u1503', '\u1504', '\u1505', '\u1506', '\u1507', 
    '\u1508', '\u1509', '\u150a', '\u150b', '\u150c', '\u150d', '\u150e', '\u150f', 
    '\u1510', '\u1511', '\u1512', '\u1513', '\u1514', '\u1515', '\u1516', '\u1517', 
    '\u1518', '\u1519', '\u151a', '\u151b', '\u151c', '\u151d', '\u151e', '\u151f', 
    '\u1520', '\u1521', '\u1522', '\u1523', '\u1524', '\u1525', '\u1526', '\u1527', 
    '\u1528', '\u1529', '\u152a', '\u152b', '\u152c', '\u152d', '\u152e', '\u152f', 
    '\u1530', '\u1531', '\u1532', '\u1533', '\u1534', '\u1535', '\u1536', '\u1537', 
    '\u1538', '\u1539', '\u153a', '\u153b', '\u153c', '\u153d', '\u153e', '\u153f', 
    '\u1540', '\u1541', '\u1542', '\u1543', '\u1544', '\u1545', '\u1546', '\u1547', 
    '\u1548', '\u1549', '\u154a', '\u154b', '\u154c', '\u154d', '\u154e', '\u154f', 
    '\u1550', '\u1551', '\u1552', '\u1553', '\u1554', '\u1555', '\u1556', '\u1557', 
    '\u1558', '\u1559', '\u155a', '\u155b', '\u155c', '\u155d', '\u155e', '\u155f', 
    '\u1560', '\u1561', '\u1562', '\u1563', '\u1564', '\u1565', '\u1566', '\u1567', 
    '\u1568', '\u1569', '\u156a', '\u156b', '\u156c', '\u156d', '\u156e', '\u156f', 
    '\u1570', '\u1571', '\u1572', '\u1573', '\u1574', '\u1575', '\u1576', '\u1577', 
    '\u1578', '\u1579', '\u157a', '\u157b', '\u157c', '\u157d', '\u157e', '\u157f', 
    '\u1580', '\u1581', '\u1582', '\u1583', '\u1584', '\u1585', '\u1586', '\u1587', 
    '\u1588', '\u1589', '\u158a', '\u158b', '\u158c', '\u158d', '\u158e', '\u158f', 
    '\u1590', '\u1591', '\u1592', '\u1593', '\u1594', '\u1595', '\u1596', '\u1597', 
    '\u1598', '\u1599', '\u159a', '\u159b', '\u159c', '\u159d', '\u159e', '\u159f', 
    '\u15a0', '\u15a1', '\u15a2', '\u15a3', '\u15a4', '\u15a5', '\u15a6', '\u15a7', 
    '\u15a8', '\u15a9', '\u15aa', '\u15ab', '\u15ac', '\u15ad', '\u15ae', '\u15af', 
    '\u15b0', '\u15b1', '\u15b2', '\u15b3', '\u15b4', '\u15b5', '\u15b6', '\u15b7', 
    '\u15b8', '\u15b9', '\u15ba', '\u15bb', '\u15bc', '\u15bd', '\u15be', '\u15bf', 
    '\u15c0', '\u15c1', '\u15c2', '\u15c3', '\u15c4', '\u15c5', '\u15c6', '\u15c7', 
    '\u15c8', '\u15c9', '\u15ca', '\u15cb', '\u15cc', '\u15cd', '\u15ce', '\u15cf', 
    '\u15d0', '\u15d1', '\u15d2', '\u15d3', '\u15d4', '\u15d5', '\u15d6', '\u15d7', 
    '\u15d8', '\u15d9', '\u15da', '\u15db', '\u15dc', '\u15dd', '\u15de', '\u15df', 
    '\u15e0', '\u15e1', '\u15e2', '\u15e3', '\u15e4', '\u15e5', '\u15e6', '\u15e7', 
    '\u15e8', '\u15e9', '\u15ea', '\u15eb', '\u15ec', '\u15ed', '\u15ee', '\u15ef', 
    '\u15f0', '\u15f1', '\u15f2', '\u15f3', '\u15f4', '\u15f5', '\u15f6', '\u15f7', 
    '\u15f8', '\u15f9', '\u15fa', '\u15fb', '\u15fc', '\u15fd', '\u15fe', '\u15ff', 
    '\u1600', '\u1601', '\u1602', '\u1603', '\u1604', '\u1605', '\u1606', '\u1607', 
    '\u1608', '\u1609', '\u160a', '\u160b', '\u160c', '\u160d', '\u160e', '\u160f', 
    '\u1610', '\u1611', '\u1612', '\u1613', '\u1614', '\u1615', '\u1616', '\u1617', 
    '\u1618', '\u1619', '\u161a', '\u161b', '\u161c', '\u161d', '\u161e', '\u161f', 
    '\u1620', '\u1621', '\u1622', '\u1623', '\u1624', '\u1625', '\u1626', '\u1627', 
    '\u1628', '\u1629', '\u162a', '\u162b', '\u162c', '\u162d', '\u162e', '\u162f', 
    '\u1630', '\u1631', '\u1632', '\u1633', '\u1634', '\u1635', '\u1636', '\u1637', 
    '\u1638', '\u1639', '\u163a', '\u163b', '\u163c', '\u163d', '\u163e', '\u163f', 
    '\u1640', '\u1641', '\u1642', '\u1643', '\u1644', '\u1645', '\u1646', '\u1647', 
    '\u1648', '\u1649', '\u164a', '\u164b', '\u164c', '\u164d', '\u164e', '\u164f', 
    '\u1650', '\u1651', '\u1652', '\u1653', '\u1654', '\u1655', '\u1656', '\u1657', 
    '\u1658', '\u1659', '\u165a', '\u165b', '\u165c', '\u165d', '\u165e', '\u165f', 
    '\u1660', '\u1661', '\u1662', '\u1663', '\u1664', '\u1665', '\u1666', '\u1667', 
    '\u1668', '\u1669', '\u166a', '\u166b', '\u166c', '\u166f', '\u1670', '\u1671', 
    '\u1672', '\u1673', '\u1674', '\u1675', '\u1676', '\u1677', '\u1678', '\u1679', 
    '\u167a', '\u167b', '\u167c', '\u167d', '\u167e', '\u167f', '\u1681', '\u1682', 
    '\u1683', '\u1684', '\u1685', '\u1686', '\u1687', '\u1688', '\u1689', '\u168a', 
    '\u168b', '\u168c', '\u168d', '\u168e', '\u168f', '\u1690', '\u1691', '\u1692', 
    '\u1693', '\u1694', '\u1695', '\u1696', '\u1697', '\u1698', '\u1699', '\u169a', 
    '\u16a0', '\u16a1', '\u16a2', '\u16a3', '\u16a4', '\u16a5', '\u16a6', '\u16a7', 
    '\u16a8', '\u16a9', '\u16aa', '\u16ab', '\u16ac', '\u16ad', '\u16ae', '\u16af', 
    '\u16b0', '\u16b1', '\u16b2', '\u16b3', '\u16b4', '\u16b5', '\u16b6', '\u16b7', 
    '\u16b8', '\u16b9', '\u16ba', '\u16bb', '\u16bc', '\u16bd', '\u16be', '\u16bf', 
    '\u16c0', '\u16c1', '\u16c2', '\u16c3', '\u16c4', '\u16c5', '\u16c6', '\u16c7', 
    '\u16c8', '\u16c9', '\u16ca', '\u16cb', '\u16cc', '\u16cd', '\u16ce', '\u16cf', 
    '\u16d0', '\u16d1', '\u16d2', '\u16d3', '\u16d4', '\u16d5', '\u16d6', '\u16d7', 
    '\u16d8', '\u16d9', '\u16da', '\u16db', '\u16dc', '\u16dd', '\u16de', '\u16df', 
    '\u16e0', '\u16e1', '\u16e2', '\u16e3', '\u16e4', '\u16e5', '\u16e6', '\u16e7', 
    '\u16e8', '\u16e9', '\u16ea', '\u16ee', '\u16ef', '\u16f0', '\u16f1', '\u16f2', 
    '\u16f3', '\u16f4', '\u16f5', '\u16f6', '\u16f7', '\u16f8', '\u1700', '\u1701', 
    '\u1702', '\u1703', '\u1704', '\u1705', '\u1706', '\u1707', '\u1708', '\u1709', 
    '\u170a', '\u170b', '\u170c', '\u170e', '\u170f', '\u1710', '\u1711', '\u1720', 
    '\u1721', '\u1722', '\u1723', '\u1724', '\u1725', '\u1726', '\u1727', '\u1728', 
    '\u1729', '\u172a', '\u172b', '\u172c', '\u172d', '\u172e', '\u172f', '\u1730', 
    '\u1731', '\u1740', '\u1741', '\u1742', '\u1743', '\u1744', '\u1745', '\u1746', 
    '\u1747', '\u1748', '\u1749', '\u174a', '\u174b', '\u174c', '\u174d', '\u174e', 
    '\u174f', '\u1750', '\u1751', '\u1760', '\u1761', '\u1762', '\u1763', '\u1764', 
    '\u1765', '\u1766', '\u1767', '\u1768', '\u1769', '\u176a', '\u176b', '\u176c', 
    '\u176e', '\u176f', '\u1770', '\u1820', '\u1821', '\u1822', '\u1823', '\u1824', 
    '\u1825', '\u1826', '\u1827', '\u1828', '\u1829', '\u182a', '\u182b', '\u182c', 
    '\u182d', '\u182e', '\u182f', '\u1830', '\u1831', '\u1832', '\u1833', '\u1834', 
    '\u1835', '\u1836', '\u1837', '\u1838', '\u1839', '\u183a', '\u183b', '\u183c', 
    '\u183d', '\u183e', '\u183f', '\u1840', '\u1841', '\u1842', '\u1843', '\u1844', 
    '\u1845', '\u1846', '\u1847', '\u1848', '\u1849', '\u184a', '\u184b', '\u184c', 
    '\u184d', '\u184e', '\u184f', '\u1850', '\u1851', '\u1852', '\u1853', '\u1854', 
    '\u1855', '\u1856', '\u1857', '\u1858', '\u1859', '\u185a', '\u185b', '\u185c', 
    '\u185d', '\u185e', '\u185f', '\u1860', '\u1861', '\u1862', '\u1863', '\u1864', 
    '\u1865', '\u1866', '\u1867', '\u1868', '\u1869', '\u186a', '\u186b', '\u186c', 
    '\u186d', '\u186e', '\u186f', '\u1870', '\u1871', '\u1872', '\u1873', '\u1874', 
    '\u1875', '\u1876', '\u1877', '\u1878', '\u1880', '\u1881', '\u1882', '\u1883', 
    '\u1884', '\u1887', '\u1888', '\u1889', '\u188a', '\u188b', '\u188c', '\u188d', 
    '\u188e', '\u188f', '\u1890', '\u1891', '\u1892', '\u1893', '\u1894', '\u1895', 
    '\u1896', '\u1897', '\u1898', '\u1899', '\u189a', '\u189b', '\u189c', '\u189d', 
    '\u189e', '\u189f', '\u18a0', '\u18a1', '\u18a2', '\u18a3', '\u18a4', '\u18a5', 
    '\u18a6', '\u18a7', '\u18a8', '\u18aa', '\u18b0', '\u18b1', '\u18b2', '\u18b3', 
    '\u18b4', '\u18b5', '\u18b6', '\u18b7', '\u18b8', '\u18b9', '\u18ba', '\u18bb', 
    '\u18bc', '\u18bd', '\u18be', '\u18bf', '\u18c0', '\u18c1', '\u18c2', '\u18c3', 
    '\u18c4', '\u18c5', '\u18c6', '\u18c7', '\u18c8', '\u18c9', '\u18ca', '\u18cb', 
    '\u18cc', '\u18cd', '\u18ce', '\u18cf', '\u18d0', '\u18d1', '\u18d2', '\u18d3', 
    '\u18d4', '\u18d5', '\u18d6', '\u18d7', '\u18d8', '\u18d9', '\u18da', '\u18db', 
    '\u18dc', '\u18dd', '\u18de', '\u18df', '\u18e0', '\u18e1', '\u18e2', '\u18e3', 
    '\u18e4', '\u18e5', '\u18e6', '\u18e7', '\u18e8', '\u18e9', '\u18ea', '\u18eb', 
    '\u18ec', '\u18ed', '\u18ee', '\u18ef', '\u18f0', '\u18f1', '\u18f2', '\u18f3', 
    '\u18f4', '\u18f5', '\u1900', '\u1901', '\u1902', '\u1903', '\u1904', '\u1905', 
    '\u1906', '\u1907', '\u1908', '\u1909', '\u190a', '\u190b', '\u190c', '\u190d', 
    '\u190e', '\u190f', '\u1910', '\u1911', '\u1912', '\u1913', '\u1914', '\u1915', 
    '\u1916', '\u1917', '\u1918', '\u1919', '\u191a', '\u191b', '\u191c', '\u191d', 
    '\u191e', '\u1a00', '\u1a01', '\u1a02', '\u1a03', '\u1a04', '\u1a05', '\u1a06', 
    '\u1a07', '\u1a08', '\u1a09', '\u1a0a', '\u1a0b', '\u1a0c', '\u1a0d', '\u1a0e', 
    '\u1a0f', '\u1a10', '\u1a11', '\u1a12', '\u1a13', '\u1a14', '\u1a15', '\u1a16', 
    '\u1b05', '\u1b06', '\u1b07', '\u1b08', '\u1b09', '\u1b0a', '\u1b0b', '\u1b0c', 
    '\u1b0d', '\u1b0e', '\u1b0f', '\u1b10', '\u1b11', '\u1b12', '\u1b13', '\u1b14', 
    '\u1b15', '\u1b16', '\u1b17', '\u1b18', '\u1b19', '\u1b1a', '\u1b1b', '\u1b1c', 
    '\u1b1d', '\u1b1e', '\u1b1f', '\u1b20', '\u1b21', '\u1b22', '\u1b23', '\u1b24', 
    '\u1b25', '\u1b26', '\u1b27', '\u1b28', '\u1b29', '\u1b2a', '\u1b2b', '\u1b2c', 
    '\u1b2d', '\u1b2e', '\u1b2f', '\u1b30', '\u1b31', '\u1b32', '\u1b33', '\u1b45', 
    '\u1b46', '\u1b47', '\u1b48', '\u1b49', '\u1b4a', '\u1b4b', '\u1b83', '\u1b84', 
    '\u1b85', '\u1b86', '\u1b87', '\u1b88', '\u1b89', '\u1b8a', '\u1b8b', '\u1b8c', 
    '\u1b8d', '\u1b8e', '\u1b8f', '\u1b90', '\u1b91', '\u1b92', '\u1b93', '\u1b94', 
    '\u1b95', '\u1b96', '\u1b97', '\u1b98', '\u1b99', '\u1b9a', '\u1b9b', '\u1b9c', 
    '\u1b9d', '\u1b9e', '\u1b9f', '\u1ba0', '\u1bae', '\u1baf', '\u1bba', '\u1bbb', 
    '\u1bbc', '\u1bbd', '\u1bbe', '\u1bbf', '\u1bc0', '\u1bc1', '\u1bc2', '\u1bc3', 
    '\u1bc4', '\u1bc5', '\u1bc6', '\u1bc7', '\u1bc8', '\u1bc9', '\u1bca', '\u1bcb', 
    '\u1bcc', '\u1bcd', '\u1bce', '\u1bcf', '\u1bd0', '\u1bd1', '\u1bd2', '\u1bd3', 
    '\u1bd4', '\u1bd5', '\u1bd6', '\u1bd7', '\u1bd8', '\u1bd9', '\u1bda', '\u1bdb', 
    '\u1bdc', '\u1bdd', '\u1bde', '\u1bdf', '\u1be0', '\u1be1', '\u1be2', '\u1be3', 
    '\u1be4', '\u1be5', '\u1c00', '\u1c01', '\u1c02', '\u1c03', '\u1c04', '\u1c05', 
    '\u1c06', '\u1c07', '\u1c08', '\u1c09', '\u1c0a', '\u1c0b', '\u1c0c', '\u1c0d', 
    '\u1c0e', '\u1c0f', '\u1c10', '\u1c11', '\u1c12', '\u1c13', '\u1c14', '\u1c15', 
    '\u1c16', '\u1c17', '\u1c18', '\u1c19', '\u1c1a', '\u1c1b', '\u1c1c', '\u1c1d', 
    '\u1c1e', '\u1c1f', '\u1c20', '\u1c21', '\u1c22', '\u1c23', '\u1c4d', '\u1c4e', 
    '\u1c4f', '\u1c5a', '\u1c5b', '\u1c5c', '\u1c5d', '\u1c5e', '\u1c5f', '\u1c60', 
    '\u1c61', '\u1c62', '\u1c63', '\u1c64', '\u1c65', '\u1c66', '\u1c67', '\u1c68', 
    '\u1c69', '\u1c6a', '\u1c6b', '\u1c6c', '\u1c6d', '\u1c6e', '\u1c6f', '\u1c70', 
    '\u1c71', '\u1c72', '\u1c73', '\u1c74', '\u1c75', '\u1c76', '\u1c77', '\u1c78', 
    '\u1c79', '\u1c7a', '\u1c7b', '\u1c7c', '\u1c7d', '\u1c80', '\u1c81', '\u1c82', 
    '\u1c83', '\u1c84', '\u1c85', '\u1c86', '\u1c87', '\u1c88', '\u1c90', '\u1c91', 
    '\u1c92', '\u1c93', '\u1c94', '\u1c95', '\u1c96', '\u1c97', '\u1c98', '\u1c99', 
    '\u1c9a', '\u1c9b', '\u1c9c', '\u1c9d', '\u1c9e', '\u1c9f', '\u1ca0', '\u1ca1', 
    '\u1ca2', '\u1ca3', '\u1ca4', '\u1ca5', '\u1ca6', '\u1ca7', '\u1ca8', '\u1ca9', 
    '\u1caa', '\u1cab', '\u1cac', '\u1cad', '\u1cae', '\u1caf', '\u1cb0', '\u1cb1', 
    '\u1cb2', '\u1cb3', '\u1cb4', '\u1cb5', '\u1cb6', '\u1cb7', '\u1cb8', '\u1cb9', 
    '\u1cba', '\u1cbd', '\u1cbe', '\u1cbf', '\u1ce9', '\u1cea', '\u1ceb', '\u1cec', 
    '\u1cee', '\u1cef', '\u1cf0', '\u1cf1', '\u1cf5', '\u1cf6', '\u1d00', '\u1d01', 
    '\u1d02', '\u1d03', '\u1d04', '\u1d05', '\u1d06', '\u1d07', '\u1d08', '\u1d09', 
    '\u1d0a', '\u1d0b', '\u1d0c', '\u1d0d', '\u1d0e', '\u1d0f', '\u1d10', '\u1d11', 
    '\u1d12', '\u1d13', '\u1d14', '\u1d15', '\u1d16', '\u1d17', '\u1d18', '\u1d19', 
    '\u1d1a', '\u1d1b', '\u1d1c', '\u1d1d', '\u1d1e', '\u1d1f', '\u1d20', '\u1d21', 
    '\u1d22', '\u1d23', '\u1d24', '\u1d25', '\u1d26', '\u1d27', '\u1d28', '\u1d29', 
    '\u1d2a', '\u1d2b', '\u1d2c', '\u1d2d', '\u1d2e', '\u1d2f', '\u1d30', '\u1d31', 
    '\u1d32', '\u1d33', '\u1d34', '\u1d35', '\u1d36', '\u1d37', '\u1d38', '\u1d39', 
    '\u1d3a', '\u1d3b', '\u1d3c', '\u1d3d', '\u1d3e', '\u1d3f', '\u1d40', '\u1d41', 
    '\u1d42', '\u1d43', '\u1d44', '\u1d45', '\u1d46', '\u1d47', '\u1d48', '\u1d49', 
    '\u1d4a', '\u1d4b', '\u1d4c', '\u1d4d', '\u1d4e', '\u1d4f', '\u1d50', '\u1d51', 
    '\u1d52', '\u1d53', '\u1d54', '\u1d55', '\u1d56', '\u1d57', '\u1d58', '\u1d59', 
    '\u1d5a', '\u1d5b', '\u1d5c', '\u1d5d', '\u1d5e', '\u1d5f', '\u1d60', '\u1d61', 
    '\u1d62', '\u1d63', '\u1d64', '\u1d65', '\u1d66', '\u1d67', '\u1d68', '\u1d69', 
    '\u1d6a', '\u1d6b', '\u1d6c', '\u1d6d', '\u1d6e', '\u1d6f', '\u1d70', '\u1d71', 
    '\u1d72', '\u1d73', '\u1d74', '\u1d75', '\u1d76', '\u1d77', '\u1d78', '\u1d79', 
    '\u1d7a', '\u1d7b', '\u1d7c', '\u1d7d', '\u1d7e', '\u1d7f', '\u1d80', '\u1d81', 
    '\u1d82', '\u1d83', '\u1d84', '\u1d85', '\u1d86', '\u1d87', '\u1d88', '\u1d89', 
    '\u1d8a', '\u1d8b', '\u1d8c', '\u1d8d', '\u1d8e', '\u1d8f', '\u1d90', '\u1d91', 
    '\u1d92', '\u1d93', '\u1d94', '\u1d95', '\u1d96', '\u1d97', '\u1d98', '\u1d99', 
    '\u1d9a', '\u1d9b', '\u1d9c', '\u1d9d', '\u1d9e', '\u1d9f', '\u1da0', '\u1da1', 
    '\u1da2', '\u1da3', '\u1da4', '\u1da5', '\u1da6', '\u1da7', '\u1da8', '\u1da9', 
    '\u1daa', '\u1dab', '\u1dac', '\u1dad', '\u1dae', '\u1daf', '\u1db0', '\u1db1', 
    '\u1db2', '\u1db3', '\u1db4', '\u1db5', '\u1db6', '\u1db7', '\u1db8', '\u1db9', 
    '\u1dba', '\u1dbb', '\u1dbc', '\u1dbd', '\u1dbe', '\u1dbf', '\u1e00', '\u1e01', 
    '\u1e02', '\u1e03', '\u1e04', '\u1e05', '\u1e06', '\u1e07', '\u1e08', '\u1e09', 
    '\u1e0a', '\u1e0b', '\u1e0c', '\u1e0d', '\u1e0e', '\u1e0f', '\u1e10', '\u1e11', 
    '\u1e12', '\u1e13', '\u1e14', '\u1e15', '\u1e16', '\u1e17', '\u1e18', '\u1e19', 
    '\u1e1a', '\u1e1b', '\u1e1c', '\u1e1d', '\u1e1e', '\u1e1f', '\u1e20', '\u1e21', 
    '\u1e22', '\u1e23', '\u1e24', '\u1e25', '\u1e26', '\u1e27', '\u1e28', '\u1e29', 
    '\u1e2a', '\u1e2b', '\u1e2c', '\u1e2d', '\u1e2e', '\u1e2f', '\u1e30', '\u1e31', 
    '\u1e32', '\u1e33', '\u1e34', '\u1e35', '\u1e36', '\u1e37', '\u1e38', '\u1e39', 
    '\u1e3a', '\u1e3b', '\u1e3c', '\u1e3d', '\u1e3e', '\u1e3f', '\u1e40', '\u1e41', 
    '\u1e42', '\u1e43', '\u1e44', '\u1e45', '\u1e46', '\u1e47', '\u1e48', '\u1e49', 
    '\u1e4a', '\u1e4b', '\u1e4c', '\u1e4d', '\u1e4e', '\u1e4f', '\u1e50', '\u1e51', 
    '\u1e52', '\u1e53', '\u1e54', '\u1e55', '\u1e56', '\u1e57', '\u1e58', '\u1e59', 
    '\u1e5a', '\u1e5b', '\u1e5c', '\u1e5d', '\u1e5e', '\u1e5f', '\u1e60', '\u1e61', 
    '\u1e62', '\u1e63', '\u1e64', '\u1e65', '\u1e66', '\u1e67', '\u1e68', '\u1e69', 
    '\u1e6a', '\u1e6b', '\u1e6c', '\u1e6d', '\u1e6e', '\u1e6f', '\u1e70', '\u1e71', 
    '\u1e72', '\u1e73', '\u1e74', '\u1e75', '\u1e76', '\u1e77', '\u1e78', '\u1e79', 
    '\u1e7a', '\u1e7b', '\u1e7c', '\u1e7d', '\u1e7e', '\u1e7f', '\u1e80', '\u1e81', 
    '\u1e82', '\u1e83', '\u1e84', '\u1e85', '\u1e86', '\u1e87', '\u1e88', '\u1e89', 
    '\u1e8a', '\u1e8b', '\u1e8c', '\u1e8d', '\u1e8e', '\u1e8f', '\u1e90', '\u1e91', 
    '\u1e92', '\u1e93', '\u1e94', '\u1e95', '\u1e96', '\u1e97', '\u1e98', '\u1e99', 
    '\u1e9a', '\u1e9b', '\u1e9c', '\u1e9d', '\u1e9e', '\u1e9f', '\u1ea0', '\u1ea1', 
    '\u1ea2', '\u1ea3', '\u1ea4', '\u1ea5', '\u1ea6', '\u1ea7', '\u1ea8', '\u1ea9', 
    '\u1eaa', '\u1eab', '\u1eac', '\u1ead', '\u1eae', '\u1eaf', '\u1eb0', '\u1eb1', 
    '\u1eb2', '\u1eb3', '\u1eb4', '\u1eb5', '\u1eb6', '\u1eb7', '\u1eb8', '\u1eb9', 
    '\u1eba', '\u1ebb', '\u1ebc', '\u1ebd', '\u1ebe', '\u1ebf', '\u1ec0', '\u1ec1', 
    '\u1ec2', '\u1ec3', '\u1ec4', '\u1ec5', '\u1ec6', '\u1ec7', '\u1ec8', '\u1ec9', 
    '\u1eca', '\u1ecb', '\u1ecc', '\u1ecd', '\u1ece', '\u1ecf', '\u1ed0', '\u1ed1', 
    '\u1ed2', '\u1ed3', '\u1ed4', '\u1ed5', '\u1ed6', '\u1ed7', '\u1ed8', '\u1ed9', 
    '\u1eda', '\u1edb', '\u1edc', '\u1edd', '\u1ede', '\u1edf', '\u1ee0', '\u1ee1', 
    '\u1ee2', '\u1ee3', '\u1ee4', '\u1ee5', '\u1ee6', '\u1ee7', '\u1ee8', '\u1ee9', 
    '\u1eea', '\u1eeb', '\u1eec', '\u1eed', '\u1eee', '\u1eef', '\u1ef0', '\u1ef1', 
    '\u1ef2', '\u1ef3', '\u1ef4', '\u1ef5', '\u1ef6', '\u1ef7', '\u1ef8', '\u1ef9', 
    '\u1efa', '\u1efb', '\u1efc', '\u1efd', '\u1efe', '\u1eff', '\u1f00', '\u1f01', 
    '\u1f02', '\u1f03', '\u1f04', '\u1f05', '\u1f06', '\u1f07', '\u1f08', '\u1f09', 
    '\u1f0a', '\u1f0b', '\u1f0c', '\u1f0d', '\u1f0e', '\u1f0f', '\u1f10', '\u1f11', 
    '\u1f12', '\u1f13', '\u1f14', '\u1f15', '\u1f18', '\u1f19', '\u1f1a', '\u1f1b', 
    '\u1f1c', '\u1f1d', '\u1f20', '\u1f21', '\u1f22', '\u1f23', '\u1f24', '\u1f25', 
    '\u1f26', '\u1f27', '\u1f28', '\u1f29', '\u1f2a', '\u1f2b', '\u1f2c', '\u1f2d', 
    '\u1f2e', '\u1f2f', '\u1f30', '\u1f31', '\u1f32', '\u1f33', '\u1f34', '\u1f35', 
    '\u1f36', '\u1f37', '\u1f38', '\u1f39', '\u1f3a', '\u1f3b', '\u1f3c', '\u1f3d', 
    '\u1f3e', '\u1f3f', '\u1f40', '\u1f41', '\u1f42', '\u1f43', '\u1f44', '\u1f45', 
    '\u1f48', '\u1f49', '\u1f4a', '\u1f4b', '\u1f4c', '\u1f4d', '\u1f50', '\u1f51', 
    '\u1f52', '\u1f53', '\u1f54', '\u1f55', '\u1f56', '\u1f57', '\u1f59', '\u1f5b', 
    '\u1f5d', '\u1f5f', '\u1f60', '\u1f61', '\u1f62', '\u1f63', '\u1f64', '\u1f65', 
    '\u1f66', '\u1f67', '\u1f68', '\u1f69', '\u1f6a', '\u1f6b', '\u1f6c', '\u1f6d', 
    '\u1f6e', '\u1f6f', '\u1f70', '\u1f71', '\u1f72', '\u1f73', '\u1f74', '\u1f75', 
    '\u1f76', '\u1f77', '\u1f78', '\u1f79', '\u1f7a', '\u1f7b', '\u1f7c', '\u1f7d', 
    '\u1f80', '\u1f81', '\u1f82', '\u1f83', '\u1f84', '\u1f85', '\u1f86', '\u1f87', 
    '\u1f88', '\u1f89', '\u1f8a', '\u1f8b', '\u1f8c', '\u1f8d', '\u1f8e', '\u1f8f', 
    '\u1f90', '\u1f91', '\u1f92', '\u1f93', '\u1f94', '\u1f95', '\u1f96', '\u1f97', 
    '\u1f98', '\u1f99', '\u1f9a', '\u1f9b', '\u1f9c', '\u1f9d', '\u1f9e', '\u1f9f', 
    '\u1fa0', '\u1fa1', '\u1fa2', '\u1fa3', '\u1fa4', '\u1fa5', '\u1fa6', '\u1fa7', 
    '\u1fa8', '\u1fa9', '\u1faa', '\u1fab', '\u1fac', '\u1fad', '\u1fae', '\u1faf', 
    '\u1fb0', '\u1fb1', '\u1fb2', '\u1fb3', '\u1fb4', '\u1fb6', '\u1fb7', '\u1fb8', 
    '\u1fb9', '\u1fba', '\u1fbb', '\u1fbc', '\u1fbe', '\u1fc2', '\u1fc3', '\u1fc4', 
    '\u1fc6', '\u1fc7', '\u1fc8', '\u1fc9', '\u1fca', '\u1fcb', '\u1fcc', '\u1fd0', 
    '\u1fd1', '\u1fd2', '\u1fd3', '\u1fd6', '\u1fd7', '\u1fd8', '\u1fd9', '\u1fda', 
    '\u1fdb', '\u1fe0', '\u1fe1', '\u1fe2', '\u1fe3', '\u1fe4', '\u1fe5', '\u1fe6', 
    '\u1fe7', '\u1fe8', '\u1fe9', '\u1fea', '\u1feb', '\u1fec', '\u1ff2', '\u1ff3', 
    '\u1ff4', '\u1ff6', '\u1ff7', '\u1ff8', '\u1ff9', '\u1ffa', '\u1ffb', '\u1ffc', 
    '\u2071', '\u207f', '\u2090', '\u2091', '\u2092', '\u2093', '\u2094', '\u2095', 
    '\u2096', '\u2097', '\u2098', '\u2099', '\u209a', '\u209b', '\u209c', '\u2102', 
    '\u2107', '\u210a', '\u210b', '\u210c', '\u210d', '\u210e', '\u210f', '\u2110', 
    '\u2111', '\u2112', '\u2113', '\u2115', '\u2119', '\u211a', '\u211b', '\u211c', 
    '\u211d', '\u2124', '\u2126', '\u2128', '\u212a', '\u212b', '\u212c', '\u212d', 
    '\u212f', '\u2130', '\u2131', '\u2132', '\u2133', '\u2134', '\u2135', '\u2136', 
    '\u2137', '\u2138', '\u2139', '\u213c', '\u213d', '\u213e', '\u213f', '\u2145', 
    '\u2146', '\u2147', '\u2148', '\u2149', '\u214e', '\u2160', '\u2161', '\u2162', 
    '\u2163', '\u2164', '\u2165', '\u2166', '\u2167', '\u2168', '\u2169', '\u216a', 
    '\u216b', '\u216c', '\u216d', '\u216e', '\u216f', '\u2170', '\u2171', '\u2172', 
    '\u2173', '\u2174', '\u2175', '\u2176', '\u2177', '\u2178', '\u2179', '\u217a', 
    '\u217b', '\u217c', '\u217d', '\u217e', '\u217f', '\u2180', '\u2181', '\u2182', 
    '\u2183', '\u2184', '\u2185', '\u2186', '\u2187', '\u2188', '\u24b6', '\u24b7', 
    '\u24b8', '\u24b9', '\u24ba', '\u24bb', '\u24bc', '\u24bd', '\u24be', '\u24bf', 
    '\u24c0', '\u24c1', '\u24c2', '\u24c3', '\u24c4', '\u24c5', '\u24c6', '\u24c7', 
    '\u24c8', '\u24c9', '\u24ca', '\u24cb', '\u24cc', '\u24cd', '\u24ce', '\u24cf', 
    '\u24d0', '\u24d1', '\u24d2', '\u24d3', '\u24d4', '\u24d5', '\u24d6', '\u24d7', 
    '\u24d8', '\u24d9', '\u24da', '\u24db', '\u24dc', '\u24dd', '\u24de', '\u24df', 
    '\u24e0', '\u24e1', '\u24e2', '\u24e3', '\u24e4', '\u24e5', '\u24e6', '\u24e7', 
    '\u24e8', '\u24e9', '\u2c00', '\u2c01', '\u2c02', '\u2c03', '\u2c04', '\u2c05', 
    '\u2c06', '\u2c07', '\u2c08', '\u2c09', '\u2c0a', '\u2c0b', '\u2c0c', '\u2c0d', 
    '\u2c0e', '\u2c0f', '\u2c10', '\u2c11', '\u2c12', '\u2c13', '\u2c14', '\u2c15', 
    '\u2c16', '\u2c17', '\u2c18', '\u2c19', '\u2c1a', '\u2c1b', '\u2c1c', '\u2c1d', 
    '\u2c1e', '\u2c1f', '\u2c20', '\u2c21', '\u2c22', '\u2c23', '\u2c24', '\u2c25', 
    '\u2c26', '\u2c27', '\u2c28', '\u2c29', '\u2c2a', '\u2c2b', '\u2c2c', '\u2c2d', 
    '\u2c2e', '\u2c30', '\u2c31', '\u2c32', '\u2c33', '\u2c34', '\u2c35', '\u2c36', 
    '\u2c37', '\u2c38', '\u2c39', '\u2c3a', '\u2c3b', '\u2c3c', '\u2c3d', '\u2c3e', 
    '\u2c3f', '\u2c40', '\u2c41', '\u2c42', '\u2c43', '\u2c44', '\u2c45', '\u2c46', 
    '\u2c47', '\u2c48', '\u2c49', '\u2c4a', '\u2c4b', '\u2c4c', '\u2c4d', '\u2c4e', 
    '\u2c4f', '\u2c50', '\u2c51', '\u2c52', '\u2c53', '\u2c54', '\u2c55', '\u2c56', 
    '\u2c57', '\u2c58', '\u2c59', '\u2c5a', '\u2c5b', '\u2c5c', '\u2c5d', '\u2c5e', 
    '\u2c60', '\u2c61', '\u2c62', '\u2c63', '\u2c64', '\u2c65', '\u2c66', '\u2c67', 
    '\u2c68', '\u2c69', '\u2c6a', '\u2c6b', '\u2c6c', '\u2c6d', '\u2c6e', '\u2c6f', 
    '\u2c70', '\u2c71', '\u2c72', '\u2c73', '\u2c74', '\u2c75', '\u2c76', '\u2c77', 
    '\u2c78', '\u2c79', '\u2c7a', '\u2c7b', '\u2c7c', '\u2c7d', '\u2c7e', '\u2c7f', 
    '\u2c80', '\u2c81', '\u2c82', '\u2c83', '\u2c84', '\u2c85', '\u2c86', '\u2c87', 
    '\u2c88', '\u2c89', '\u2c8a', '\u2c8b', '\u2c8c', '\u2c8d', '\u2c8e', '\u2c8f', 
    '\u2c90', '\u2c91', '\u2c92', '\u2c93', '\u2c94', '\u2c95', '\u2c96', '\u2c97', 
    '\u2c98', '\u2c99', '\u2c9a', '\u2c9b', '\u2c9c', '\u2c9d', '\u2c9e', '\u2c9f', 
    '\u2ca0', '\u2ca1', '\u2ca2', '\u2ca3', '\u2ca4', '\u2ca5', '\u2ca6', '\u2ca7', 
    '\u2ca8', '\u2ca9', '\u2caa', '\u2cab', '\u2cac', '\u2cad', '\u2cae', '\u2caf', 
    '\u2cb0', '\u2cb1', '\u2cb2', '\u2cb3', '\u2cb4', '\u2cb5', '\u2cb6', '\u2cb7', 
    '\u2cb8', '\u2cb9', '\u2cba', '\u2cbb', '\u2cbc', '\u2cbd', '\u2cbe', '\u2cbf', 
    '\u2cc0', '\u2cc1', '\u2cc2', '\u2cc3', '\u2cc4', '\u2cc5', '\u2cc6', '\u2cc7', 
    '\u2cc8', '\u2cc9', '\u2cca', '\u2ccb', '\u2ccc', '\u2ccd', '\u2cce', '\u2ccf', 
    '\u2cd0', '\u2cd1', '\u2cd2', '\u2cd3', '\u2cd4', '\u2cd5', '\u2cd6', '\u2cd7', 
    '\u2cd8', '\u2cd9', '\u2cda', '\u2cdb', '\u2cdc', '\u2cdd', '\u2cde', '\u2cdf', 
    '\u2ce0', '\u2ce1', '\u2ce2', '\u2ce3', '\u2ce4', '\u2ceb', '\u2cec', '\u2ced', 
    '\u2cee', '\u2cf2', '\u2cf3', '\u2d00', '\u2d01', '\u2d02', '\u2d03', '\u2d04', 
    '\u2d05', '\u2d06', '\u2d07', '\u2d08', '\u2d09', '\u2d0a', '\u2d0b', '\u2d0c', 
    '\u2d0d', '\u2d0e', '\u2d0f', '\u2d10', '\u2d11', '\u2d12', '\u2d13', '\u2d14', 
    '\u2d15', '\u2d16', '\u2d17', '\u2d18', '\u2d19', '\u2d1a', '\u2d1b', '\u2d1c', 
    '\u2d1d', '\u2d1e', '\u2d1f', '\u2d20', '\u2d21', '\u2d22', '\u2d23', '\u2d24', 
    '\u2d25', '\u2d27', '\u2d2d', '\u2d30', '\u2d31', '\u2d32', '\u2d33', '\u2d34', 
    '\u2d35', '\u2d36', '\u2d37', '\u2d38', '\u2d39', '\u2d3a', '\u2d3b', '\u2d3c', 
    '\u2d3d', '\u2d3e', '\u2d3f', '\u2d40', '\u2d41', '\u2d42', '\u2d43', '\u2d44', 
    '\u2d45', '\u2d46', '\u2d47', '\u2d48', '\u2d49', '\u2d4a', '\u2d4b', '\u2d4c', 
    '\u2d4d', '\u2d4e', '\u2d4f', '\u2d50', '\u2d51', '\u2d52', '\u2d53', '\u2d54', 
    '\u2d55', '\u2d56', '\u2d57', '\u2d58', '\u2d59', '\u2d5a', '\u2d5b', '\u2d5c', 
    '\u2d5d', '\u2d5e', '\u2d5f', '\u2d60', '\u2d61', '\u2d62', '\u2d63', '\u2d64', 
    '\u2d65', '\u2d66', '\u2d67', '\u2d6f', '\u2d80', '\u2d81', '\u2d82', '\u2d83', 
    '\u2d84', '\u2d85', '\u2d86', '\u2d87', '\u2d88', '\u2d89', '\u2d8a', '\u2d8b', 
    '\u2d8c', '\u2d8d', '\u2d8e', '\u2d8f', '\u2d90', '\u2d91', '\u2d92', '\u2d93', 
    '\u2d94', '\u2d95', '\u2d96', '\u2da0', '\u2da1', '\u2da2', '\u2da3', '\u2da4', 
    '\u2da5', '\u2da6', '\u2da8', '\u2da9', '\u2daa', '\u2dab', '\u2dac', '\u2dad', 
    '\u2dae', '\u2db0', '\u2db1', '\u2db2', '\u2db3', '\u2db4', '\u2db5', '\u2db6', 
    '\u2db8', '\u2db9', '\u2dba', '\u2dbb', '\u2dbc', '\u2dbd', '\u2dbe', '\u2dc0', 
    '\u2dc1', '\u2dc2', '\u2dc3', '\u2dc4', '\u2dc5', '\u2dc6', '\u2dc8', '\u2dc9', 
    '\u2dca', '\u2dcb', '\u2dcc', '\u2dcd', '\u2dce', '\u2dd0', '\u2dd1', '\u2dd2', 
    '\u2dd3', '\u2dd4', '\u2dd5', '\u2dd6', '\u2dd8', '\u2dd9', '\u2dda', '\u2ddb', 
    '\u2ddc', '\u2ddd', '\u2dde', '\u2e2f', '\u3005', '\u303b', '\u303c', '\u3105', 
    '\u3106', '\u3107', '\u3108', '\u3109', '\u310a', '\u310b', '\u310c', '\u310d', 
    '\u310e', '\u310f', '\u3110', '\u3111', '\u3112', '\u3113', '\u3114', '\u3115', 
    '\u3116', '\u3117', '\u3118', '\u3119', '\u311a', '\u311b', '\u311c', '\u311d', 
    '\u311e', '\u311f', '\u3120', '\u3121', '\u3122', '\u3123', '\u3124', '\u3125', 
    '\u3126', '\u3127', '\u3128', '\u3129', '\u312a', '\u312b', '\u312c', '\u312d', 
    '\u312e', '\u312f', '\u3131', '\u3132', '\u3133', '\u3134', '\u3135', '\u3136', 
    '\u3137', '\u3138', '\u3139', '\u313a', '\u313b', '\u313c', '\u313d', '\u313e', 
    '\u313f', '\u3140', '\u3141', '\u3142', '\u3143', '\u3144', '\u3145', '\u3146', 
    '\u3147', '\u3148', '\u3149', '\u314a', '\u314b', '\u314c', '\u314d', '\u314e', 
    '\u314f', '\u3150', '\u3151', '\u3152', '\u3153', '\u3154', '\u3155', '\u3156', 
    '\u3157', '\u3158', '\u3159', '\u315a', '\u315b', '\u315c', '\u315d', '\u315e', 
    '\u315f', '\u3160', '\u3161', '\u3162', '\u3163', '\u3164', '\u3165', '\u3166', 
    '\u3167', '\u3168', '\u3169', '\u316a', '\u316b', '\u316c', '\u316d', '\u316e', 
    '\u316f', '\u3170', '\u3171', '\u3172', '\u3173', '\u3174', '\u3175', '\u3176', 
    '\u3177', '\u3178', '\u3179', '\u317a', '\u317b', '\u317c', '\u317d', '\u317e', 
    '\u317f', '\u3180', '\u3181', '\u3182', '\u3183', '\u3184', '\u3185', '\u3186', 
    '\u3187', '\u3188', '\u3189', '\u318a', '\u318b', '\u318c', '\u318d', '\u318e', 
    '\u31a0', '\u31a1', '\u31a2', '\u31a3', '\u31a4', '\u31a5', '\u31a6', '\u31a7', 
    '\u31a8', '\u31a9', '\u31aa', '\u31ab', '\u31ac', '\u31ad', '\u31ae', '\u31af', 
    '\u31b0', '\u31b1', '\u31b2', '\u31b3', '\u31b4', '\u31b5', '\u31b6', '\u31b7', 
    '\u31b8', '\u31b9', '\u31ba', '\ua000', '\ua001', '\ua002', '\ua003', '\ua004', 
    '\ua005', '\ua006', '\ua007', '\ua008', '\ua009', '\ua00a', '\ua00b', '\ua00c', 
    '\ua00d', '\ua00e', '\ua00f', '\ua010', '\ua011', '\ua012', '\ua013', '\ua014', 
    '\ua015', '\ua016', '\ua017', '\ua018', '\ua019', '\ua01a', '\ua01b', '\ua01c', 
    '\ua01d', '\ua01e', '\ua01f', '\ua020', '\ua021', '\ua022', '\ua023', '\ua024', 
    '\ua025', '\ua026', '\ua027', '\ua028', '\ua029', '\ua02a', '\ua02b', '\ua02c', 
    '\ua02d', '\ua02e', '\ua02f', '\ua030', '\ua031', '\ua032', '\ua033', '\ua034', 
    '\ua035', '\ua036', '\ua037', '\ua038', '\ua039', '\ua03a', '\ua03b', '\ua03c', 
    '\ua03d', '\ua03e', '\ua03f', '\ua040', '\ua041', '\ua042', '\ua043', '\ua044', 
    '\ua045', '\ua046', '\ua047', '\ua048', '\ua049', '\ua04a', '\ua04b', '\ua04c', 
    '\ua04d', '\ua04e', '\ua04f', '\ua050', '\ua051', '\ua052', '\ua053', '\ua054', 
    '\ua055', '\ua056', '\ua057', '\ua058', '\ua059', '\ua05a', '\ua05b', '\ua05c', 
    '\ua05d', '\ua05e', '\ua05f', '\ua060', '\ua061', '\ua062', '\ua063', '\ua064', 
    '\ua065', '\ua066', '\ua067', '\ua068', '\ua069', '\ua06a', '\ua06b', '\ua06c', 
    '\ua06d', '\ua06e', '\ua06f', '\ua070', '\ua071', '\ua072', '\ua073', '\ua074', 
    '\ua075', '\ua076', '\ua077', '\ua078', '\ua079', '\ua07a', '\ua07b', '\ua07c', 
    '\ua07d', '\ua07e', '\ua07f', '\ua080', '\ua081', '\ua082', '\ua083', '\ua084', 
    '\ua085', '\ua086', '\ua087', '\ua088', '\ua089', '\ua08a', '\ua08b', '\ua08c', 
    '\ua08d', '\ua08e', '\ua08f', '\ua090', '\ua091', '\ua092', '\ua093', '\ua094', 
    '\ua095', '\ua096', '\ua097', '\ua098', '\ua099', '\ua09a', '\ua09b', '\ua09c', 
    '\ua09d', '\ua09e', '\ua09f', '\ua0a0', '\ua0a1', '\ua0a2', '\ua0a3', '\ua0a4', 
    '\ua0a5', '\ua0a6', '\ua0a7', '\ua0a8', '\ua0a9', '\ua0aa', '\ua0ab', '\ua0ac', 
    '\ua0ad', '\ua0ae', '\ua0af', '\ua0b0', '\ua0b1', '\ua0b2', '\ua0b3', '\ua0b4', 
    '\ua0b5', '\ua0b6', '\ua0b7', '\ua0b8', '\ua0b9', '\ua0ba', '\ua0bb', '\ua0bc', 
    '\ua0bd', '\ua0be', '\ua0bf', '\ua0c0', '\ua0c1', '\ua0c2', '\ua0c3', '\ua0c4', 
    '\ua0c5', '\ua0c6', '\ua0c7', '\ua0c8', '\ua0c9', '\ua0ca', '\ua0cb', '\ua0cc', 
    '\ua0cd', '\ua0ce', '\ua0cf', '\ua0d0', '\ua0d1', '\ua0d2', '\ua0d3', '\ua0d4', 
    '\ua0d5', '\ua0d6', '\ua0d7', '\ua0d8', '\ua0d9', '\ua0da', '\ua0db', '\ua0dc', 
    '\ua0dd', '\ua0de', '\ua0df', '\ua0e0', '\ua0e1', '\ua0e2', '\ua0e3', '\ua0e4', 
    '\ua0e5', '\ua0e6', '\ua0e7', '\ua0e8', '\ua0e9', '\ua0ea', '\ua0eb', '\ua0ec', 
    '\ua0ed', '\ua0ee', '\ua0ef', '\ua0f0', '\ua0f1', '\ua0f2', '\ua0f3', '\ua0f4', 
    '\ua0f5', '\ua0f6', '\ua0f7', '\ua0f8', '\ua0f9', '\ua0fa', '\ua0fb', '\ua0fc', 
    '\ua0fd', '\ua0fe', '\ua0ff', '\ua100', '\ua101', '\ua102', '\ua103', '\ua104', 
    '\ua105', '\ua106', '\ua107', '\ua108', '\ua109', '\ua10a', '\ua10b', '\ua10c', 
    '\ua10d', '\ua10e', '\ua10f', '\ua110', '\ua111', '\ua112', '\ua113', '\ua114', 
    '\ua115', '\ua116', '\ua117', '\ua118', '\ua119', '\ua11a', '\ua11b', '\ua11c', 
    '\ua11d', '\ua11e', '\ua11f', '\ua120', '\ua121', '\ua122', '\ua123', '\ua124', 
    '\ua125', '\ua126', '\ua127', '\ua128', '\ua129', '\ua12a', '\ua12b', '\ua12c', 
    '\ua12d', '\ua12e', '\ua12f', '\ua130', '\ua131', '\ua132', '\ua133', '\ua134', 
    '\ua135', '\ua136', '\ua137', '\ua138', '\ua139', '\ua13a', '\ua13b', '\ua13c', 
    '\ua13d', '\ua13e', '\ua13f', '\ua140', '\ua141', '\ua142', '\ua143', '\ua144', 
    '\ua145', '\ua146', '\ua147', '\ua148', '\ua149', '\ua14a', '\ua14b', '\ua14c', 
    '\ua14d', '\ua14e', '\ua14f', '\ua150', '\ua151', '\ua152', '\ua153', '\ua154', 
    '\ua155', '\ua156', '\ua157', '\ua158', '\ua159', '\ua15a', '\ua15b', '\ua15c', 
    '\ua15d', '\ua15e', '\ua15f', '\ua160', '\ua161', '\ua162', '\ua163', '\ua164', 
    '\ua165', '\ua166', '\ua167', '\ua168', '\ua169', '\ua16a', '\ua16b', '\ua16c', 
    '\ua16d', '\ua16e', '\ua16f', '\ua170', '\ua171', '\ua172', '\ua173', '\ua174', 
    '\ua175', '\ua176', '\ua177', '\ua178', '\ua179', '\ua17a', '\ua17b', '\ua17c', 
    '\ua17d', '\ua17e', '\ua17f', '\ua180', '\ua181', '\ua182', '\ua183', '\ua184', 
    '\ua185', '\ua186', '\ua187', '\ua188', '\ua189', '\ua18a', '\ua18b', '\ua18c', 
    '\ua18d', '\ua18e', '\ua18f', '\ua190', '\ua191', '\ua192', '\ua193', '\ua194', 
    '\ua195', '\ua196', '\ua197', '\ua198', '\ua199', '\ua19a', '\ua19b', '\ua19c', 
    '\ua19d', '\ua19e', '\ua19f', '\ua1a0', '\ua1a1', '\ua1a2', '\ua1a3', '\ua1a4', 
    '\ua1a5', '\ua1a6', '\ua1a7', '\ua1a8', '\ua1a9', '\ua1aa', '\ua1ab', '\ua1ac', 
    '\ua1ad', '\ua1ae', '\ua1af', '\ua1b0', '\ua1b1', '\ua1b2', '\ua1b3', '\ua1b4', 
    '\ua1b5', '\ua1b6', '\ua1b7', '\ua1b8', '\ua1b9', '\ua1ba', '\ua1bb', '\ua1bc', 
    '\ua1bd', '\ua1be', '\ua1bf', '\ua1c0', '\ua1c1', '\ua1c2', '\ua1c3', '\ua1c4', 
    '\ua1c5', '\ua1c6', '\ua1c7', '\ua1c8', '\ua1c9', '\ua1ca', '\ua1cb', '\ua1cc', 
    '\ua1cd', '\ua1ce', '\ua1cf', '\ua1d0', '\ua1d1', '\ua1d2', '\ua1d3', '\ua1d4', 
    '\ua1d5', '\ua1d6', '\ua1d7', '\ua1d8', '\ua1d9', '\ua1da', '\ua1db', '\ua1dc', 
    '\ua1dd', '\ua1de', '\ua1df', '\ua1e0', '\ua1e1', '\ua1e2', '\ua1e3', '\ua1e4', 
    '\ua1e5', '\ua1e6', '\ua1e7', '\ua1e8', '\ua1e9', '\ua1ea', '\ua1eb', '\ua1ec', 
    '\ua1ed', '\ua1ee', '\ua1ef', '\ua1f0', '\ua1f1', '\ua1f2', '\ua1f3', '\ua1f4', 
    '\ua1f5', '\ua1f6', '\ua1f7', '\ua1f8', '\ua1f9', '\ua1fa', '\ua1fb', '\ua1fc', 
    '\ua1fd', '\ua1fe', '\ua1ff', '\ua200', '\ua201', '\ua202', '\ua203', '\ua204', 
    '\ua205', '\ua206', '\ua207', '\ua208', '\ua209', '\ua20a', '\ua20b', '\ua20c', 
    '\ua20d', '\ua20e', '\ua20f', '\ua210', '\ua211', '\ua212', '\ua213', '\ua214', 
    '\ua215', '\ua216', '\ua217', '\ua218', '\ua219', '\ua21a', '\ua21b', '\ua21c', 
    '\ua21d', '\ua21e', '\ua21f', '\ua220', '\ua221', '\ua222', '\ua223', '\ua224', 
    '\ua225', '\ua226', '\ua227', '\ua228', '\ua229', '\ua22a', '\ua22b', '\ua22c', 
    '\ua22d', '\ua22e', '\ua22f', '\ua230', '\ua231', '\ua232', '\ua233', '\ua234', 
    '\ua235', '\ua236', '\ua237', '\ua238', '\ua239', '\ua23a', '\ua23b', '\ua23c', 
    '\ua23d', '\ua23e', '\ua23f', '\ua240', '\ua241', '\ua242', '\ua243', '\ua244', 
    '\ua245', '\ua246', '\ua247', '\ua248', '\ua249', '\ua24a', '\ua24b', '\ua24c', 
    '\ua24d', '\ua24e', '\ua24f', '\ua250', '\ua251', '\ua252', '\ua253', '\ua254', 
    '\ua255', '\ua256', '\ua257', '\ua258', '\ua259', '\ua25a', '\ua25b', '\ua25c', 
    '\ua25d', '\ua25e', '\ua25f', '\ua260', '\ua261', '\ua262', '\ua263', '\ua264', 
    '\ua265', '\ua266', '\ua267', '\ua268', '\ua269', '\ua26a', '\ua26b', '\ua26c', 
    '\ua26d', '\ua26e', '\ua26f', '\ua270', '\ua271', '\ua272', '\ua273', '\ua274', 
    '\ua275', '\ua276', '\ua277', '\ua278', '\ua279', '\ua27a', '\ua27b', '\ua27c', 
    '\ua27d', '\ua27e', '\ua27f', '\ua280', '\ua281', '\ua282', '\ua283', '\ua284', 
    '\ua285', '\ua286', '\ua287', '\ua288', '\ua289', '\ua28a', '\ua28b', '\ua28c', 
    '\ua28d', '\ua28e', '\ua28f', '\ua290', '\ua291', '\ua292', '\ua293', '\ua294', 
    '\ua295', '\ua296', '\ua297', '\ua298', '\ua299', '\ua29a', '\ua29b', '\ua29c', 
    '\ua29d', '\ua29e', '\ua29f', '\ua2a0', '\ua2a1', '\ua2a2', '\ua2a3', '\ua2a4', 
    '\ua2a5', '\ua2a6', '\ua2a7', '\ua2a8', '\ua2a9', '\ua2aa', '\ua2ab', '\ua2ac', 
    '\ua2ad', '\ua2ae', '\ua2af', '\ua2b0', '\ua2b1', '\ua2b2', '\ua2b3', '\ua2b4', 
    '\ua2b5', '\ua2b6', '\ua2b7', '\ua2b8', '\ua2b9', '\ua2ba', '\ua2bb', '\ua2bc', 
    '\ua2bd', '\ua2be', '\ua2bf', '\ua2c0', '\ua2c1', '\ua2c2', '\ua2c3', '\ua2c4', 
    '\ua2c5', '\ua2c6', '\ua2c7', '\ua2c8', '\ua2c9', '\ua2ca', '\ua2cb', '\ua2cc', 
    '\ua2cd', '\ua2ce', '\ua2cf', '\ua2d0', '\ua2d1', '\ua2d2', '\ua2d3', '\ua2d4', 
    '\ua2d5', '\ua2d6', '\ua2d7', '\ua2d8', '\ua2d9', '\ua2da', '\ua2db', '\ua2dc', 
    '\ua2dd', '\ua2de', '\ua2df', '\ua2e0', '\ua2e1', '\ua2e2', '\ua2e3', '\ua2e4', 
    '\ua2e5', '\ua2e6', '\ua2e7', '\ua2e8', '\ua2e9', '\ua2ea', '\ua2eb', '\ua2ec', 
    '\ua2ed', '\ua2ee', '\ua2ef', '\ua2f0', '\ua2f1', '\ua2f2', '\ua2f3', '\ua2f4', 
    '\ua2f5', '\ua2f6', '\ua2f7', '\ua2f8', '\ua2f9', '\ua2fa', '\ua2fb', '\ua2fc', 
    '\ua2fd', '\ua2fe', '\ua2ff', '\ua300', '\ua301', '\ua302', '\ua303', '\ua304', 
    '\ua305', '\ua306', '\ua307', '\ua308', '\ua309', '\ua30a', '\ua30b', '\ua30c', 
    '\ua30d', '\ua30e', '\ua30f', '\ua310', '\ua311', '\ua312', '\ua313', '\ua314', 
    '\ua315', '\ua316', '\ua317', '\ua318', '\ua319', '\ua31a', '\ua31b', '\ua31c', 
    '\ua31d', '\ua31e', '\ua31f', '\ua320', '\ua321', '\ua322', '\ua323', '\ua324', 
    '\ua325', '\ua326', '\ua327', '\ua328', '\ua329', '\ua32a', '\ua32b', '\ua32c', 
    '\ua32d', '\ua32e', '\ua32f', '\ua330', '\ua331', '\ua332', '\ua333', '\ua334', 
    '\ua335', '\ua336', '\ua337', '\ua338', '\ua339', '\ua33a', '\ua33b', '\ua33c', 
    '\ua33d', '\ua33e', '\ua33f', '\ua340', '\ua341', '\ua342', '\ua343', '\ua344', 
    '\ua345', '\ua346', '\ua347', '\ua348', '\ua349', '\ua34a', '\ua34b', '\ua34c', 
    '\ua34d', '\ua34e', '\ua34f', '\ua350', '\ua351', '\ua352', '\ua353', '\ua354', 
    '\ua355', '\ua356', '\ua357', '\ua358', '\ua359', '\ua35a', '\ua35b', '\ua35c', 
    '\ua35d', '\ua35e', '\ua35f', '\ua360', '\ua361', '\ua362', '\ua363', '\ua364', 
    '\ua365', '\ua366', '\ua367', '\ua368', '\ua369', '\ua36a', '\ua36b', '\ua36c', 
    '\ua36d', '\ua36e', '\ua36f', '\ua370', '\ua371', '\ua372', '\ua373', '\ua374', 
    '\ua375', '\ua376', '\ua377', '\ua378', '\ua379', '\ua37a', '\ua37b', '\ua37c', 
    '\ua37d', '\ua37e', '\ua37f', '\ua380', '\ua381', '\ua382', '\ua383', '\ua384', 
    '\ua385', '\ua386', '\ua387', '\ua388', '\ua389', '\ua38a', '\ua38b', '\ua38c', 
    '\ua38d', '\ua38e', '\ua38f', '\ua390', '\ua391', '\ua392', '\ua393', '\ua394', 
    '\ua395', '\ua396', '\ua397', '\ua398', '\ua399', '\ua39a', '\ua39b', '\ua39c', 
    '\ua39d', '\ua39e', '\ua39f', '\ua3a0', '\ua3a1', '\ua3a2', '\ua3a3', '\ua3a4', 
    '\ua3a5', '\ua3a6', '\ua3a7', '\ua3a8', '\ua3a9', '\ua3aa', '\ua3ab', '\ua3ac', 
    '\ua3ad', '\ua3ae', '\ua3af', '\ua3b0', '\ua3b1', '\ua3b2', '\ua3b3', '\ua3b4', 
    '\ua3b5', '\ua3b6', '\ua3b7', '\ua3b8', '\ua3b9', '\ua3ba', '\ua3bb', '\ua3bc', 
    '\ua3bd', '\ua3be', '\ua3bf', '\ua3c0', '\ua3c1', '\ua3c2', '\ua3c3', '\ua3c4', 
    '\ua3c5', '\ua3c6', '\ua3c7', '\ua3c8', '\ua3c9', '\ua3ca', '\ua3cb', '\ua3cc', 
    '\ua3cd', '\ua3ce', '\ua3cf', '\ua3d0', '\ua3d1', '\ua3d2', '\ua3d3', '\ua3d4', 
    '\ua3d5', '\ua3d6', '\ua3d7', '\ua3d8', '\ua3d9', '\ua3da', '\ua3db', '\ua3dc', 
    '\ua3dd', '\ua3de', '\ua3df', '\ua3e0', '\ua3e1', '\ua3e2', '\ua3e3', '\ua3e4', 
    '\ua3e5', '\ua3e6', '\ua3e7', '\ua3e8', '\ua3e9', '\ua3ea', '\ua3eb', '\ua3ec', 
    '\ua3ed', '\ua3ee', '\ua3ef', '\ua3f0', '\ua3f1', '\ua3f2', '\ua3f3', '\ua3f4', 
    '\ua3f5', '\ua3f6', '\ua3f7', '\ua3f8', '\ua3f9', '\ua3fa', '\ua3fb', '\ua3fc', 
    '\ua3fd', '\ua3fe', '\ua3ff', '\ua400', '\ua401', '\ua402', '\ua403', '\ua404', 
    '\ua405', '\ua406', '\ua407', '\ua408', '\ua409', '\ua40a', '\ua40b', '\ua40c', 
    '\ua40d', '\ua40e', '\ua40f', '\ua410', '\ua411', '\ua412', '\ua413', '\ua414', 
    '\ua415', '\ua416', '\ua417', '\ua418', '\ua419', '\ua41a', '\ua41b', '\ua41c', 
    '\ua41d', '\ua41e', '\ua41f', '\ua420', '\ua421', '\ua422', '\ua423', '\ua424', 
    '\ua425', '\ua426', '\ua427', '\ua428', '\ua429', '\ua42a', '\ua42b', '\ua42c', 
    '\ua42d', '\ua42e', '\ua42f', '\ua430', '\ua431', '\ua432', '\ua433', '\ua434', 
    '\ua435', '\ua436', '\ua437', '\ua438', '\ua439', '\ua43a', '\ua43b', '\ua43c', 
    '\ua43d', '\ua43e', '\ua43f', '\ua440', '\ua441', '\ua442', '\ua443', '\ua444', 
    '\ua445', '\ua446', '\ua447', '\ua448', '\ua449', '\ua44a', '\ua44b', '\ua44c', 
    '\ua44d', '\ua44e', '\ua44f', '\ua450', '\ua451', '\ua452', '\ua453', '\ua454', 
    '\ua455', '\ua456', '\ua457', '\ua458', '\ua459', '\ua45a', '\ua45b', '\ua45c', 
    '\ua45d', '\ua45e', '\ua45f', '\ua460', '\ua461', '\ua462', '\ua463', '\ua464', 
    '\ua465', '\ua466', '\ua467', '\ua468', '\ua469', '\ua46a', '\ua46b', '\ua46c', 
    '\ua46d', '\ua46e', '\ua46f', '\ua470', '\ua471', '\ua472', '\ua473', '\ua474', 
    '\ua475', '\ua476', '\ua477', '\ua478', '\ua479', '\ua47a', '\ua47b', '\ua47c', 
    '\ua47d', '\ua47e', '\ua47f', '\ua480', '\ua481', '\ua482', '\ua483', '\ua484', 
    '\ua485', '\ua486', '\ua487', '\ua488', '\ua489', '\ua48a', '\ua48b', '\ua48c', 
    '\ua4d0', '\ua4d1', '\ua4d2', '\ua4d3', '\ua4d4', '\ua4d5', '\ua4d6', '\ua4d7', 
    '\ua4d8', '\ua4d9', '\ua4da', '\ua4db', '\ua4dc', '\ua4dd', '\ua4de', '\ua4df', 
    '\ua4e0', '\ua4e1', '\ua4e2', '\ua4e3', '\ua4e4', '\ua4e5', '\ua4e6', '\ua4e7', 
    '\ua4e8', '\ua4e9', '\ua4ea', '\ua4eb', '\ua4ec', '\ua4ed', '\ua4ee', '\ua4ef', 
    '\ua4f0', '\ua4f1', '\ua4f2', '\ua4f3', '\ua4f4', '\ua4f5', '\ua4f6', '\ua4f7', 
    '\ua4f8', '\ua4f9', '\ua4fa', '\ua4fb', '\ua4fc', '\ua4fd', '\ua500', '\ua501', 
    '\ua502', '\ua503', '\ua504', '\ua505', '\ua506', '\ua507', '\ua508', '\ua509', 
    '\ua50a', '\ua50b', '\ua50c', '\ua50d', '\ua50e', '\ua50f', '\ua510', '\ua511', 
    '\ua512', '\ua513', '\ua514', '\ua515', '\ua516', '\ua517', '\ua518', '\ua519', 
    '\ua51a', '\ua51b', '\ua51c', '\ua51d', '\ua51e', '\ua51f', '\ua520', '\ua521', 
    '\ua522', '\ua523', '\ua524', '\ua525', '\ua526', '\ua527', '\ua528', '\ua529', 
    '\ua52a', '\ua52b', '\ua52c', '\ua52d', '\ua52e', '\ua52f', '\ua530', '\ua531', 
    '\ua532', '\ua533', '\ua534', '\ua535', '\ua536', '\ua537', '\ua538', '\ua539', 
    '\ua53a', '\ua53b', '\ua53c', '\ua53d', '\ua53e', '\ua53f', '\ua540', '\ua541', 
    '\ua542', '\ua543', '\ua544', '\ua545', '\ua546', '\ua547', '\ua548', '\ua549', 
    '\ua54a', '\ua54b', '\ua54c', '\ua54d', '\ua54e', '\ua54f', '\ua550', '\ua551', 
    '\ua552', '\ua553', '\ua554', '\ua555', '\ua556', '\ua557', '\ua558', '\ua559', 
    '\ua55a', '\ua55b', '\ua55c', '\ua55d', '\ua55e', '\ua55f', '\ua560', '\ua561', 
    '\ua562', '\ua563', '\ua564', '\ua565', '\ua566', '\ua567', '\ua568', '\ua569', 
    '\ua56a', '\ua56b', '\ua56c', '\ua56d', '\ua56e', '\ua56f', '\ua570', '\ua571', 
    '\ua572', '\ua573', '\ua574', '\ua575', '\ua576', '\ua577', '\ua578', '\ua579', 
    '\ua57a', '\ua57b', '\ua57c', '\ua57d', '\ua57e', '\ua57f', '\ua580', '\ua581', 
    '\ua582', '\ua583', '\ua584', '\ua585', '\ua586', '\ua587', '\ua588', '\ua589', 
    '\ua58a', '\ua58b', '\ua58c', '\ua58d', '\ua58e', '\ua58f', '\ua590', '\ua591', 
    '\ua592', '\ua593', '\ua594', '\ua595', '\ua596', '\ua597', '\ua598', '\ua599', 
    '\ua59a', '\ua59b', '\ua59c', '\ua59d', '\ua59e', '\ua59f', '\ua5a0', '\ua5a1', 
    '\ua5a2', '\ua5a3', '\ua5a4', '\ua5a5', '\ua5a6', '\ua5a7', '\ua5a8', '\ua5a9', 
    '\ua5aa', '\ua5ab', '\ua5ac', '\ua5ad', '\ua5ae', '\ua5af', '\ua5b0', '\ua5b1', 
    '\ua5b2', '\ua5b3', '\ua5b4', '\ua5b5', '\ua5b6', '\ua5b7', '\ua5b8', '\ua5b9', 
    '\ua5ba', '\ua5bb', '\ua5bc', '\ua5bd', '\ua5be', '\ua5bf', '\ua5c0', '\ua5c1', 
    '\ua5c2', '\ua5c3', '\ua5c4', '\ua5c5', '\ua5c6', '\ua5c7', '\ua5c8', '\ua5c9', 
    '\ua5ca', '\ua5cb', '\ua5cc', '\ua5cd', '\ua5ce', '\ua5cf', '\ua5d0', '\ua5d1', 
    '\ua5d2', '\ua5d3', '\ua5d4', '\ua5d5', '\ua5d6', '\ua5d7', '\ua5d8', '\ua5d9', 
    '\ua5da', '\ua5db', '\ua5dc', '\ua5dd', '\ua5de', '\ua5df', '\ua5e0', '\ua5e1', 
    '\ua5e2', '\ua5e3', '\ua5e4', '\ua5e5', '\ua5e6', '\ua5e7', '\ua5e8', '\ua5e9', 
    '\ua5ea', '\ua5eb', '\ua5ec', '\ua5ed', '\ua5ee', '\ua5ef', '\ua5f0', '\ua5f1', 
    '\ua5f2', '\ua5f3', '\ua5f4', '\ua5f5', '\ua5f6', '\ua5f7', '\ua5f8', '\ua5f9', 
    '\ua5fa', '\ua5fb', '\ua5fc', '\ua5fd', '\ua5fe', '\ua5ff', '\ua600', '\ua601', 
    '\ua602', '\ua603', '\ua604', '\ua605', '\ua606', '\ua607', '\ua608', '\ua609', 
    '\ua60a', '\ua60b', '\ua60c', '\ua610', '\ua611', '\ua612', '\ua613', '\ua614', 
    '\ua615', '\ua616', '\ua617', '\ua618', '\ua619', '\ua61a', '\ua61b', '\ua61c', 
    '\ua61d', '\ua61e', '\ua61f', '\ua62a', '\ua62b', '\ua640', '\ua641', '\ua642', 
    '\ua643', '\ua644', '\ua645', '\ua646', '\ua647', '\ua648', '\ua649', '\ua64a', 
    '\ua64b', '\ua64c', '\ua64d', '\ua64e', '\ua64f', '\ua650', '\ua651', '\ua652', 
    '\ua653', '\ua654', '\ua655', '\ua656', '\ua657', '\ua658', '\ua659', '\ua65a', 
    '\ua65b', '\ua65c', '\ua65d', '\ua65e', '\ua65f', '\ua660', '\ua661', '\ua662', 
    '\ua663', '\ua664', '\ua665', '\ua666', '\ua667', '\ua668', '\ua669', '\ua66a', 
    '\ua66b', '\ua66c', '\ua66d', '\ua66e', '\ua67f', '\ua680', '\ua681', '\ua682', 
    '\ua683', '\ua684', '\ua685', '\ua686', '\ua687', '\ua688', '\ua689', '\ua68a', 
    '\ua68b', '\ua68c', '\ua68d', '\ua68e', '\ua68f', '\ua690', '\ua691', '\ua692', 
    '\ua693', '\ua694', '\ua695', '\ua696', '\ua697', '\ua698', '\ua699', '\ua69a', 
    '\ua69b', '\ua69c', '\ua69d', '\ua6a0', '\ua6a1', '\ua6a2', '\ua6a3', '\ua6a4', 
    '\ua6a5', '\ua6a6', '\ua6a7', '\ua6a8', '\ua6a9', '\ua6aa', '\ua6ab', '\ua6ac', 
    '\ua6ad', '\ua6ae', '\ua6af', '\ua6b0', '\ua6b1', '\ua6b2', '\ua6b3', '\ua6b4', 
    '\ua6b5', '\ua6b6', '\ua6b7', '\ua6b8', '\ua6b9', '\ua6ba', '\ua6bb', '\ua6bc', 
    '\ua6bd', '\ua6be', '\ua6bf', '\ua6c0', '\ua6c1', '\ua6c2', '\ua6c3', '\ua6c4', 
    '\ua6c5', '\ua6c6', '\ua6c7', '\ua6c8', '\ua6c9', '\ua6ca', '\ua6cb', '\ua6cc', 
    '\ua6cd', '\ua6ce', '\ua6cf', '\ua6d0', '\ua6d1', '\ua6d2', '\ua6d3', '\ua6d4', 
    '\ua6d5', '\ua6d6', '\ua6d7', '\ua6d8', '\ua6d9', '\ua6da', '\ua6db', '\ua6dc', 
    '\ua6dd', '\ua6de', '\ua6df', '\ua6e0', '\ua6e1', '\ua6e2', '\ua6e3', '\ua6e4', 
    '\ua6e5', '\ua6e6', '\ua6e7', '\ua6e8', '\ua6e9', '\ua6ea', '\ua6eb', '\ua6ec', 
    '\ua6ed', '\ua6ee', '\ua6ef', '\ua717', '\ua718', '\ua719', '\ua71a', '\ua71b', 
    '\ua71c', '\ua71d', '\ua71e', '\ua71f', '\ua720', '\ua721', '\ua722', '\ua723', 
    '\ua724', '\ua725', '\ua726', '\ua727', '\ua728', '\ua729', '\ua72a', '\ua72b', 
    '\ua72c', '\ua72d', '\ua72e', '\ua72f', '\ua730', '\ua731', '\ua732', '\ua733', 
    '\ua734', '\ua735', '\ua736', '\ua737', '\ua738', '\ua739', '\ua73a', '\ua73b', 
    '\ua73c', '\ua73d', '\ua73e', '\ua73f', '\ua740', '\ua741', '\ua742', '\ua743', 
    '\ua744', '\ua745', '\ua746', '\ua747', '\ua748', '\ua749', '\ua74a', '\ua74b', 
    '\ua74c', '\ua74d', '\ua74e', '\ua74f', '\ua750', '\ua751', '\ua752', '\ua753', 
    '\ua754', '\ua755', '\ua756', '\ua757', '\ua758', '\ua759', '\ua75a', '\ua75b', 
    '\ua75c', '\ua75d', '\ua75e', '\ua75f', '\ua760', '\ua761', '\ua762', '\ua763', 
    '\ua764', '\ua765', '\ua766', '\ua767', '\ua768', '\ua769', '\ua76a', '\ua76b', 
    '\ua76c', '\ua76d', '\ua76e', '\ua76f', '\ua770', '\ua771', '\ua772', '\ua773', 
    '\ua774', '\ua775', '\ua776', '\ua777', '\ua778', '\ua779', '\ua77a', '\ua77b', 
    '\ua77c', '\ua77d', '\ua77e', '\ua77f', '\ua780', '\ua781', '\ua782', '\ua783', 
    '\ua784', '\ua785', '\ua786', '\ua787', '\ua788', '\ua789', '\ua78a', '\ua78b', 
    '\ua78c', '\ua78d', '\ua78e', '\ua78f', '\ua790', '\ua791', '\ua792', '\ua793', 
    '\ua794', '\ua795', '\ua796', '\ua797', '\ua798', '\ua799', '\ua79a', '\ua79b', 
    '\ua79c', '\ua79d', '\ua79e', '\ua79f', '\ua7a0', '\ua7a1', '\ua7a2', '\ua7a3', 
    '\ua7a4', '\ua7a5', '\ua7a6', '\ua7a7', '\ua7a8', '\ua7a9', '\ua7aa', '\ua7ab', 
    '\ua7ac', '\ua7ad', '\ua7ae', '\ua7af', '\ua7b0', '\ua7b1', '\ua7b2', '\ua7b3', 
    '\ua7b4', '\ua7b5', '\ua7b6', '\ua7b7', '\ua7b8', '\ua7b9', '\ua7f7', '\ua7f8', 
    '\ua7f9', '\ua7fa', '\ua7fb', '\ua7fc', '\ua7fd', '\ua7fe', '\ua7ff', '\ua800', 
    '\ua801', '\ua803', '\ua804', '\ua805', '\ua807', '\ua808', '\ua809', '\ua80a', 
    '\ua80c', '\ua80d', '\ua80e', '\ua80f', '\ua810', '\ua811', '\ua812', '\ua813', 
    '\ua814', '\ua815', '\ua816', '\ua817', '\ua818', '\ua819', '\ua81a', '\ua81b', 
    '\ua81c', '\ua81d', '\ua81e', '\ua81f', '\ua820', '\ua821', '\ua822', '\ua840', 
    '\ua841', '\ua842', '\ua843', '\ua844', '\ua845', '\ua846', '\ua847', '\ua848', 
    '\ua849', '\ua84a', '\ua84b', '\ua84c', '\ua84d', '\ua84e', '\ua84f', '\ua850', 
    '\ua851', '\ua852', '\ua853', '\ua854', '\ua855', '\ua856', '\ua857', '\ua858', 
    '\ua859', '\ua85a', '\ua85b', '\ua85c', '\ua85d', '\ua85e', '\ua85f', '\ua860', 
    '\ua861', '\ua862', '\ua863', '\ua864', '\ua865', '\ua866', '\ua867', '\ua868', 
    '\ua869', '\ua86a', '\ua86b', '\ua86c', '\ua86d', '\ua86e', '\ua86f', '\ua870', 
    '\ua871', '\ua872', '\ua873', '\ua882', '\ua883', '\ua884', '\ua885', '\ua886', 
    '\ua887', '\ua888', '\ua889', '\ua88a', '\ua88b', '\ua88c', '\ua88d', '\ua88e', 
    '\ua88f', '\ua890', '\ua891', '\ua892', '\ua893', '\ua894', '\ua895', '\ua896', 
    '\ua897', '\ua898', '\ua899', '\ua89a', '\ua89b', '\ua89c', '\ua89d', '\ua89e', 
    '\ua89f', '\ua8a0', '\ua8a1', '\ua8a2', '\ua8a3', '\ua8a4', '\ua8a5', '\ua8a6', 
    '\ua8a7', '\ua8a8', '\ua8a9', '\ua8aa', '\ua8ab', '\ua8ac', '\ua8ad', '\ua8ae', 
    '\ua8af', '\ua8b0', '\ua8b1', '\ua8b2', '\ua8b3', '\ua8f2', '\ua8f3', '\ua8f4', 
    '\ua8f5', '\ua8f6', '\ua8f7', '\ua8fb', '\ua8fd', '\ua8fe', '\ua90a', '\ua90b', 
    '\ua90c', '\ua90d', '\ua90e', '\ua90f', '\ua910', '\ua911', '\ua912', '\ua913', 
    '\ua914', '\ua915', '\ua916', '\ua917', '\ua918', '\ua919', '\ua91a', '\ua91b', 
    '\ua91c', '\ua91d', '\ua91e', '\ua91f', '\ua920', '\ua921', '\ua922', '\ua923', 
    '\ua924', '\ua925', '\ua930', '\ua931', '\ua932', '\ua933', '\ua934', '\ua935', 
    '\ua936', '\ua937', '\ua938', '\ua939', '\ua93a', '\ua93b', '\ua93c', '\ua93d', 
    '\ua93e', '\ua93f', '\ua940', '\ua941', '\ua942', '\ua943', '\ua944', '\ua945', 
    '\ua946', '\ua960', '\ua961', '\ua962', '\ua963', '\ua964', '\ua965', '\ua966', 
    '\ua967', '\ua968', '\ua969', '\ua96a', '\ua96b', '\ua96c', '\ua96d', '\ua96e', 
    '\ua96f', '\ua970', '\ua971', '\ua972', '\ua973', '\ua974', '\ua975', '\ua976', 
    '\ua977', '\ua978', '\ua979', '\ua97a', '\ua97b', '\ua97c', '\ua984', '\ua985', 
    '\ua986', '\ua987', '\ua988', '\ua989', '\ua98a', '\ua98b', '\ua98c', '\ua98d', 
    '\ua98e', '\ua98f', '\ua990', '\ua991', '\ua992', '\ua993', '\ua994', '\ua995', 
    '\ua996', '\ua997', '\ua998', '\ua999', '\ua99a', '\ua99b', '\ua99c', '\ua99d', 
    '\ua99e', '\ua99f', '\ua9a0', '\ua9a1', '\ua9a2', '\ua9a3', '\ua9a4', '\ua9a5', 
    '\ua9a6', '\ua9a7', '\ua9a8', '\ua9a9', '\ua9aa', '\ua9ab', '\ua9ac', '\ua9ad', 
    '\ua9ae', '\ua9af', '\ua9b0', '\ua9b1', '\ua9b2', '\ua9cf', '\uaa00', '\uaa01', 
    '\uaa02', '\uaa03', '\uaa04', '\uaa05', '\uaa06', '\uaa07', '\uaa08', '\uaa09', 
    '\uaa0a', '\uaa0b', '\uaa0c', '\uaa0d', '\uaa0e', '\uaa0f', '\uaa10', '\uaa11', 
    '\uaa12', '\uaa13', '\uaa14', '\uaa15', '\uaa16', '\uaa17', '\uaa18', '\uaa19', 
    '\uaa1a', '\uaa1b', '\uaa1c', '\uaa1d', '\uaa1e', '\uaa1f', '\uaa20', '\uaa21', 
    '\uaa22', '\uaa23', '\uaa24', '\uaa25', '\uaa26', '\uaa27', '\uaa28', '\uaa40', 
    '\uaa41', '\uaa42', '\uaa44', '\uaa45', '\uaa46', '\uaa47', '\uaa48', '\uaa49', 
    '\uaa4a', '\uaa4b', '\uaae0', '\uaae1', '\uaae2', '\uaae3', '\uaae4', '\uaae5', 
    '\uaae6', '\uaae7', '\uaae8', '\uaae9', '\uaaea', '\uaaf2', '\uaaf3', '\uaaf4', 
    '\uab01', '\uab02', '\uab03', '\uab04', '\uab05', '\uab06', '\uab09', '\uab0a', 
    '\uab0b', '\uab0c', '\uab0d', '\uab0e', '\uab11', '\uab12', '\uab13', '\uab14', 
    '\uab15', '\uab16', '\uab20', '\uab21', '\uab22', '\uab23', '\uab24', '\uab25', 
    '\uab26', '\uab28', '\uab29', '\uab2a', '\uab2b', '\uab2c', '\uab2d', '\uab2e', 
    '\uab30', '\uab31', '\uab32', '\uab33', '\uab34', '\uab35', '\uab36', '\uab37', 
    '\uab38', '\uab39', '\uab3a', '\uab3b', '\uab3c', '\uab3d', '\uab3e', '\uab3f', 
    '\uab40', '\uab41', '\uab42', '\uab43', '\uab44', '\uab45', '\uab46', '\uab47', 
    '\uab48', '\uab49', '\uab4a', '\uab4b', '\uab4c', '\uab4d', '\uab4e', '\uab4f', 
    '\uab50', '\uab51', '\uab52', '\uab53', '\uab54', '\uab55', '\uab56', '\uab57', 
    '\uab58', '\uab59', '\uab5a', '\uab5b', '\uab5c', '\uab5d', '\uab5e', '\uab5f', 
    '\uab60', '\uab61', '\uab62', '\uab63', '\uab64', '\uab65', '\uab70', '\uab71', 
    '\uab72', '\uab73', '\uab74', '\uab75', '\uab76', '\uab77', '\uab78', '\uab79', 
    '\uab7a', '\uab7b', '\uab7c', '\uab7d', '\uab7e', '\uab7f', '\uab80', '\uab81', 
    '\uab82', '\uab83', '\uab84', '\uab85', '\uab86', '\uab87', '\uab88', '\uab89', 
    '\uab8a', '\uab8b', '\uab8c', '\uab8d', '\uab8e', '\uab8f', '\uab90', '\uab91', 
    '\uab92', '\uab93', '\uab94', '\uab95', '\uab96', '\uab97', '\uab98', '\uab99', 
    '\uab9a', '\uab9b', '\uab9c', '\uab9d', '\uab9e', '\uab9f', '\uaba0', '\uaba1', 
    '\uaba2', '\uaba3', '\uaba4', '\uaba5', '\uaba6', '\uaba7', '\uaba8', '\uaba9', 
    '\uabaa', '\uabab', '\uabac', '\uabad', '\uabae', '\uabaf', '\uabb0', '\uabb1', 
    '\uabb2', '\uabb3', '\uabb4', '\uabb5', '\uabb6', '\uabb7', '\uabb8', '\uabb9', 
    '\uabba', '\uabbb', '\uabbc', '\uabbd', '\uabbe', '\uabbf', '\uabc0', '\uabc1', 
    '\uabc2', '\uabc3', '\uabc4', '\uabc5', '\uabc6', '\uabc7', '\uabc8', '\uabc9', 
    '\uabca', '\uabcb', '\uabcc', '\uabcd', '\uabce', '\uabcf', '\uabd0', '\uabd1', 
    '\uabd2', '\uabd3', '\uabd4', '\uabd5', '\uabd6', '\uabd7', '\uabd8', '\uabd9', 
    '\uabda', '\uabdb', '\uabdc', '\uabdd', '\uabde', '\uabdf', '\uabe0', '\uabe1', 
    '\uabe2', '\uac00', '\uac01', '\uac02', '\uac03', '\uac04', '\uac05', '\uac06', 
    '\uac07', '\uac08', '\uac09', '\uac0a', '\uac0b', '\uac0c', '\uac0d', '\uac0e', 
    '\uac0f', '\uac10', '\uac11', '\uac12', '\uac13', '\uac14', '\uac15', '\uac16', 
    '\uac17', '\uac18', '\uac19', '\uac1a', '\uac1b', '\uac1c', '\uac1d', '\uac1e', 
    '\uac1f', '\uac20', '\uac21', '\uac22', '\uac23', '\uac24', '\uac25', '\uac26', 
    '\uac27', '\uac28', '\uac29', '\uac2a', '\uac2b', '\uac2c', '\uac2d', '\uac2e', 
    '\uac2f', '\uac30', '\uac31', '\uac32', '\uac33', '\uac34', '\uac35', '\uac36', 
    '\uac37', '\uac38', '\uac39', '\uac3a', '\uac3b', '\uac3c', '\uac3d', '\uac3e', 
    '\uac3f', '\uac40', '\uac41', '\uac42', '\uac43', '\uac44', '\uac45', '\uac46', 
    '\uac47', '\uac48', '\uac49', '\uac4a', '\uac4b', '\uac4c', '\uac4d', '\uac4e', 
    '\uac4f', '\uac50', '\uac51', '\uac52', '\uac53', '\uac54', '\uac55', '\uac56', 
    '\uac57', '\uac58', '\uac59', '\uac5a', '\uac5b', '\uac5c', '\uac5d', '\uac5e', 
    '\uac5f', '\uac60', '\uac61', '\uac62', '\uac63', '\uac64', '\uac65', '\uac66', 
    '\uac67', '\uac68', '\uac69', '\uac6a', '\uac6b', '\uac6c', '\uac6d', '\uac6e', 
    '\uac6f', '\uac70', '\uac71', '\uac72', '\uac73', '\uac74', '\uac75', '\uac76', 
    '\uac77', '\uac78', '\uac79', '\uac7a', '\uac7b', '\uac7c', '\uac7d', '\uac7e', 
    '\uac7f', '\uac80', '\uac81', '\uac82', '\uac83', '\uac84', '\uac85', '\uac86', 
    '\uac87', '\uac88', '\uac89', '\uac8a', '\uac8b', '\uac8c', '\uac8d', '\uac8e', 
    '\uac8f', '\uac90', '\uac91', '\uac92', '\uac93', '\uac94', '\uac95', '\uac96', 
    '\uac97', '\uac98', '\uac99', '\uac9a', '\uac9b', '\uac9c', '\uac9d', '\uac9e', 
    '\uac9f', '\uaca0', '\uaca1', '\uaca2', '\uaca3', '\uaca4', '\uaca5', '\uaca6', 
    '\uaca7', '\uaca8', '\uaca9', '\uacaa', '\uacab', '\uacac', '\uacad', '\uacae', 
    '\uacaf', '\uacb0', '\uacb1', '\uacb2', '\uacb3', '\uacb4', '\uacb5', '\uacb6', 
    '\uacb7', '\uacb8', '\uacb9', '\uacba', '\uacbb', '\uacbc', '\uacbd', '\uacbe', 
    '\uacbf', '\uacc0', '\uacc1', '\uacc2', '\uacc3', '\uacc4', '\uacc5', '\uacc6', 
    '\uacc7', '\uacc8', '\uacc9', '\uacca', '\uaccb', '\uaccc', '\uaccd', '\uacce', 
    '\uaccf', '\uacd0', '\uacd1', '\uacd2', '\uacd3', '\uacd4', '\uacd5', '\uacd6', 
    '\uacd7', '\uacd8', '\uacd9', '\uacda', '\uacdb', '\uacdc', '\uacdd', '\uacde', 
    '\uacdf', '\uace0', '\uace1', '\uace2', '\uace3', '\uace4', '\uace5', '\uace6', 
    '\uace7', '\uace8', '\uace9', '\uacea', '\uaceb', '\uacec', '\uaced', '\uacee', 
    '\uacef', '\uacf0', '\uacf1', '\uacf2', '\uacf3', '\uacf4', '\uacf5', '\uacf6', 
    '\uacf7', '\uacf8', '\uacf9', '\uacfa', '\uacfb', '\uacfc', '\uacfd', '\uacfe', 
    '\uacff', '\uad00', '\uad01', '\uad02', '\uad03', '\uad04', '\uad05', '\uad06', 
    '\uad07', '\uad08', '\uad09', '\uad0a', '\uad0b', '\uad0c', '\uad0d', '\uad0e', 
    '\uad0f', '\uad10', '\uad11', '\uad12', '\uad13', '\uad14', '\uad15', '\uad16', 
    '\uad17', '\uad18', '\uad19', '\uad1a', '\uad1b', '\uad1c', '\uad1d', '\uad1e', 
    '\uad1f', '\uad20', '\uad21', '\uad22', '\uad23', '\uad24', '\uad25', '\uad26', 
    '\uad27', '\uad28', '\uad29', '\uad2a', '\uad2b', '\uad2c', '\uad2d', '\uad2e', 
    '\uad2f', '\uad30', '\uad31', '\uad32', '\uad33', '\uad34', '\uad35', '\uad36', 
    '\uad37', '\uad38', '\uad39', '\uad3a', '\uad3b', '\uad3c', '\uad3d', '\uad3e', 
    '\uad3f', '\uad40', '\uad41', '\uad42', '\uad43', '\uad44', '\uad45', '\uad46', 
    '\uad47', '\uad48', '\uad49', '\uad4a', '\uad4b', '\uad4c', '\uad4d', '\uad4e', 
    '\uad4f', '\uad50', '\uad51', '\uad52', '\uad53', '\uad54', '\uad55', '\uad56', 
    '\uad57', '\uad58', '\uad59', '\uad5a', '\uad5b', '\uad5c', '\uad5d', '\uad5e', 
    '\uad5f', '\uad60', '\uad61', '\uad62', '\uad63', '\uad64', '\uad65', '\uad66', 
    '\uad67', '\uad68', '\uad69', '\uad6a', '\uad6b', '\uad6c', '\uad6d', '\uad6e', 
    '\uad6f', '\uad70', '\uad71', '\uad72', '\uad73', '\uad74', '\uad75', '\uad76', 
    '\uad77', '\uad78', '\uad79', '\uad7a', '\uad7b', '\uad7c', '\uad7d', '\uad7e', 
    '\uad7f', '\uad80', '\uad81', '\uad82', '\uad83', '\uad84', '\uad85', '\uad86', 
    '\uad87', '\uad88', '\uad89', '\uad8a', '\uad8b', '\uad8c', '\uad8d', '\uad8e', 
    '\uad8f', '\uad90', '\uad91', '\uad92', '\uad93', '\uad94', '\uad95', '\uad96', 
    '\uad97', '\uad98', '\uad99', '\uad9a', '\uad9b', '\uad9c', '\uad9d', '\uad9e', 
    '\uad9f', '\uada0', '\uada1', '\uada2', '\uada3', '\uada4', '\uada5', '\uada6', 
    '\uada7', '\uada8', '\uada9', '\uadaa', '\uadab', '\uadac', '\uadad', '\uadae', 
    '\uadaf', '\uadb0', '\uadb1', '\uadb2', '\uadb3', '\uadb4', '\uadb5', '\uadb6', 
    '\uadb7', '\uadb8', '\uadb9', '\uadba', '\uadbb', '\uadbc', '\uadbd', '\uadbe', 
    '\uadbf', '\uadc0', '\uadc1', '\uadc2', '\uadc3', '\uadc4', '\uadc5', '\uadc6', 
    '\uadc7', '\uadc8', '\uadc9', '\uadca', '\uadcb', '\uadcc', '\uadcd', '\uadce', 
    '\uadcf', '\uadd0', '\uadd1', '\uadd2', '\uadd3', '\uadd4', '\uadd5', '\uadd6', 
    '\uadd7', '\uadd8', '\uadd9', '\uadda', '\uaddb', '\uaddc', '\uaddd', '\uadde', 
    '\uaddf', '\uade0', '\uade1', '\uade2', '\uade3', '\uade4', '\uade5', '\uade6', 
    '\uade7', '\uade8', '\uade9', '\uadea', '\uadeb', '\uadec', '\uaded', '\uadee', 
    '\uadef', '\uadf0', '\uadf1', '\uadf2', '\uadf3', '\uadf4', '\uadf5', '\uadf6', 
    '\uadf7', '\uadf8', '\uadf9', '\uadfa', '\uadfb', '\uadfc', '\uadfd', '\uadfe', 
    '\uadff', '\uae00', '\uae01', '\uae02', '\uae03', '\uae04', '\uae05', '\uae06', 
    '\uae07', '\uae08', '\uae09', '\uae0a', '\uae0b', '\uae0c', '\uae0d', '\uae0e', 
    '\uae0f', '\uae10', '\uae11', '\uae12', '\uae13', '\uae14', '\uae15', '\uae16', 
    '\uae17', '\uae18', '\uae19', '\uae1a', '\uae1b', '\uae1c', '\uae1d', '\uae1e', 
    '\uae1f', '\uae20', '\uae21', '\uae22', '\uae23', '\uae24', '\uae25', '\uae26', 
    '\uae27', '\uae28', '\uae29', '\uae2a', '\uae2b', '\uae2c', '\uae2d', '\uae2e', 
    '\uae2f', '\uae30', '\uae31', '\uae32', '\uae33', '\uae34', '\uae35', '\uae36', 
    '\uae37', '\uae38', '\uae39', '\uae3a', '\uae3b', '\uae3c', '\uae3d', '\uae3e', 
    '\uae3f', '\uae40', '\uae41', '\uae42', '\uae43', '\uae44', '\uae45', '\uae46', 
    '\uae47', '\uae48', '\uae49', '\uae4a', '\uae4b', '\uae4c', '\uae4d', '\uae4e', 
    '\uae4f', '\uae50', '\uae51', '\uae52', '\uae53', '\uae54', '\uae55', '\uae56', 
    '\uae57', '\uae58', '\uae59', '\uae5a', '\uae5b', '\uae5c', '\uae5d', '\uae5e', 
    '\uae5f', '\uae60', '\uae61', '\uae62', '\uae63', '\uae64', '\uae65', '\uae66', 
    '\uae67', '\uae68', '\uae69', '\uae6a', '\uae6b', '\uae6c', '\uae6d', '\uae6e', 
    '\uae6f', '\uae70', '\uae71', '\uae72', '\uae73', '\uae74', '\uae75', '\uae76', 
    '\uae77', '\uae78', '\uae79', '\uae7a', '\uae7b', '\uae7c', '\uae7d', '\uae7e', 
    '\uae7f', '\uae80', '\uae81', '\uae82', '\uae83', '\uae84', '\uae85', '\uae86', 
    '\uae87', '\uae88', '\uae89', '\uae8a', '\uae8b', '\uae8c', '\uae8d', '\uae8e', 
    '\uae8f', '\uae90', '\uae91', '\uae92', '\uae93', '\uae94', '\uae95', '\uae96', 
    '\uae97', '\uae98', '\uae99', '\uae9a', '\uae9b', '\uae9c', '\uae9d', '\uae9e', 
    '\uae9f', '\uaea0', '\uaea1', '\uaea2', '\uaea3', '\uaea4', '\uaea5', '\uaea6', 
    '\uaea7', '\uaea8', '\uaea9', '\uaeaa', '\uaeab', '\uaeac', '\uaead', '\uaeae', 
    '\uaeaf', '\uaeb0', '\uaeb1', '\uaeb2', '\uaeb3', '\uaeb4', '\uaeb5', '\uaeb6', 
    '\uaeb7', '\uaeb8', '\uaeb9', '\uaeba', '\uaebb', '\uaebc', '\uaebd', '\uaebe', 
    '\uaebf', '\uaec0', '\uaec1', '\uaec2', '\uaec3', '\uaec4', '\uaec5', '\uaec6', 
    '\uaec7', '\uaec8', '\uaec9', '\uaeca', '\uaecb', '\uaecc', '\uaecd', '\uaece', 
    '\uaecf', '\uaed0', '\uaed1', '\uaed2', '\uaed3', '\uaed4', '\uaed5', '\uaed6', 
    '\uaed7', '\uaed8', '\uaed9', '\uaeda', '\uaedb', '\uaedc', '\uaedd', '\uaede', 
    '\uaedf', '\uaee0', '\uaee1', '\uaee2', '\uaee3', '\uaee4', '\uaee5', '\uaee6', 
    '\uaee7', '\uaee8', '\uaee9', '\uaeea', '\uaeeb', '\uaeec', '\uaeed', '\uaeee', 
    '\uaeef', '\uaef0', '\uaef1', '\uaef2', '\uaef3', '\uaef4', '\uaef5', '\uaef6', 
    '\uaef7', '\uaef8', '\uaef9', '\uaefa', '\uaefb', '\uaefc', '\uaefd', '\uaefe', 
    '\uaeff', '\uaf00', '\uaf01', '\uaf02', '\uaf03', '\uaf04', '\uaf05', '\uaf06', 
    '\uaf07', '\uaf08', '\uaf09', '\uaf0a', '\uaf0b', '\uaf0c', '\uaf0d', '\uaf0e', 
    '\uaf0f', '\uaf10', '\uaf11', '\uaf12', '\uaf13', '\uaf14', '\uaf15', '\uaf16', 
    '\uaf17', '\uaf18', '\uaf19', '\uaf1a', '\uaf1b', '\uaf1c', '\uaf1d', '\uaf1e', 
    '\uaf1f', '\uaf20', '\uaf21', '\uaf22', '\uaf23', '\uaf24', '\uaf25', '\uaf26', 
    '\uaf27', '\uaf28', '\uaf29', '\uaf2a', '\uaf2b', '\uaf2c', '\uaf2d', '\uaf2e', 
    '\uaf2f', '\uaf30', '\uaf31', '\uaf32', '\uaf33', '\uaf34', '\uaf35', '\uaf36', 
    '\uaf37', '\uaf38', '\uaf39', '\uaf3a', '\uaf3b', '\uaf3c', '\uaf3d', '\uaf3e', 
    '\uaf3f', '\uaf40', '\uaf41', '\uaf42', '\uaf43', '\uaf44', '\uaf45', '\uaf46', 
    '\uaf47', '\uaf48', '\uaf49', '\uaf4a', '\uaf4b', '\uaf4c', '\uaf4d', '\uaf4e', 
    '\uaf4f', '\uaf50', '\uaf51', '\uaf52', '\uaf53', '\uaf54', '\uaf55', '\uaf56', 
    '\uaf57', '\uaf58', '\uaf59', '\uaf5a', '\uaf5b', '\uaf5c', '\uaf5d', '\uaf5e', 
    '\uaf5f', '\uaf60', '\uaf61', '\uaf62', '\uaf63', '\uaf64', '\uaf65', '\uaf66', 
    '\uaf67', '\uaf68', '\uaf69', '\uaf6a', '\uaf6b', '\uaf6c', '\uaf6d', '\uaf6e', 
    '\uaf6f', '\uaf70', '\uaf71', '\uaf72', '\uaf73', '\uaf74', '\uaf75', '\uaf76', 
    '\uaf77', '\uaf78', '\uaf79', '\uaf7a', '\uaf7b', '\uaf7c', '\uaf7d', '\uaf7e', 
    '\uaf7f', '\uaf80', '\uaf81', '\uaf82', '\uaf83', '\uaf84', '\uaf85', '\uaf86', 
    '\uaf87', '\uaf88', '\uaf89', '\uaf8a', '\uaf8b', '\uaf8c', '\uaf8d', '\uaf8e', 
    '\uaf8f', '\uaf90', '\uaf91', '\uaf92', '\uaf93', '\uaf94', '\uaf95', '\uaf96', 
    '\uaf97', '\uaf98', '\uaf99', '\uaf9a', '\uaf9b', '\uaf9c', '\uaf9d', '\uaf9e', 
    '\uaf9f', '\uafa0', '\uafa1', '\uafa2', '\uafa3', '\uafa4', '\uafa5', '\uafa6', 
    '\uafa7', '\uafa8', '\uafa9', '\uafaa', '\uafab', '\uafac', '\uafad', '\uafae', 
    '\uafaf', '\uafb0', '\uafb1', '\uafb2', '\uafb3', '\uafb4', '\uafb5', '\uafb6', 
    '\uafb7', '\uafb8', '\uafb9', '\uafba', '\uafbb', '\uafbc', '\uafbd', '\uafbe', 
    '\uafbf', '\uafc0', '\uafc1', '\uafc2', '\uafc3', '\uafc4', '\uafc5', '\uafc6', 
    '\uafc7', '\uafc8', '\uafc9', '\uafca', '\uafcb', '\uafcc', '\uafcd', '\uafce', 
    '\uafcf', '\uafd0', '\uafd1', '\uafd2', '\uafd3', '\uafd4', '\uafd5', '\uafd6', 
    '\uafd7', '\uafd8', '\uafd9', '\uafda', '\uafdb', '\uafdc', '\uafdd', '\uafde', 
    '\uafdf', '\uafe0', '\uafe1', '\uafe2', '\uafe3', '\uafe4', '\uafe5', '\uafe6', 
    '\uafe7', '\uafe8', '\uafe9', '\uafea', '\uafeb', '\uafec', '\uafed', '\uafee', 
    '\uafef', '\uaff0', '\uaff1', '\uaff2', '\uaff3', '\uaff4', '\uaff5', '\uaff6', 
    '\uaff7', '\uaff8', '\uaff9', '\uaffa', '\uaffb', '\uaffc', '\uaffd', '\uaffe', 
    '\uafff', '\ub000', '\ub001', '\ub002', '\ub003', '\ub004', '\ub005', '\ub006', 
    '\ub007', '\ub008', '\ub009', '\ub00a', '\ub00b', '\ub00c', '\ub00d', '\ub00e', 
    '\ub00f', '\ub010', '\ub011', '\ub012', '\ub013', '\ub014', '\ub015', '\ub016', 
    '\ub017', '\ub018', '\ub019', '\ub01a', '\ub01b', '\ub01c', '\ub01d', '\ub01e', 
    '\ub01f', '\ub020', '\ub021', '\ub022', '\ub023', '\ub024', '\ub025', '\ub026', 
    '\ub027', '\ub028', '\ub029', '\ub02a', '\ub02b', '\ub02c', '\ub02d', '\ub02e', 
    '\ub02f', '\ub030', '\ub031', '\ub032', '\ub033', '\ub034', '\ub035', '\ub036', 
    '\ub037', '\ub038', '\ub039', '\ub03a', '\ub03b', '\ub03c', '\ub03d', '\ub03e', 
    '\ub03f', '\ub040', '\ub041', '\ub042', '\ub043', '\ub044', '\ub045', '\ub046', 
    '\ub047', '\ub048', '\ub049', '\ub04a', '\ub04b', '\ub04c', '\ub04d', '\ub04e', 
    '\ub04f', '\ub050', '\ub051', '\ub052', '\ub053', '\ub054', '\ub055', '\ub056', 
    '\ub057', '\ub058', '\ub059', '\ub05a', '\ub05b', '\ub05c', '\ub05d', '\ub05e', 
    '\ub05f', '\ub060', '\ub061', '\ub062', '\ub063', '\ub064', '\ub065', '\ub066', 
    '\ub067', '\ub068', '\ub069', '\ub06a', '\ub06b', '\ub06c', '\ub06d', '\ub06e', 
    '\ub06f', '\ub070', '\ub071', '\ub072', '\ub073', '\ub074', '\ub075', '\ub076', 
    '\ub077', '\ub078', '\ub079', '\ub07a', '\ub07b', '\ub07c', '\ub07d', '\ub07e', 
    '\ub07f', '\ub080', '\ub081', '\ub082', '\ub083', '\ub084', '\ub085', '\ub086', 
    '\ub087', '\ub088', '\ub089', '\ub08a', '\ub08b', '\ub08c', '\ub08d', '\ub08e', 
    '\ub08f', '\ub090', '\ub091', '\ub092', '\ub093', '\ub094', '\ub095', '\ub096', 
    '\ub097', '\ub098', '\ub099', '\ub09a', '\ub09b', '\ub09c', '\ub09d', '\ub09e', 
    '\ub09f', '\ub0a0', '\ub0a1', '\ub0a2', '\ub0a3', '\ub0a4', '\ub0a5', '\ub0a6', 
    '\ub0a7', '\ub0a8', '\ub0a9', '\ub0aa', '\ub0ab', '\ub0ac', '\ub0ad', '\ub0ae', 
    '\ub0af', '\ub0b0', '\ub0b1', '\ub0b2', '\ub0b3', '\ub0b4', '\ub0b5', '\ub0b6', 
    '\ub0b7', '\ub0b8', '\ub0b9', '\ub0ba', '\ub0bb', '\ub0bc', '\ub0bd', '\ub0be', 
    '\ub0bf', '\ub0c0', '\ub0c1', '\ub0c2', '\ub0c3', '\ub0c4', '\ub0c5', '\ub0c6', 
    '\ub0c7', '\ub0c8', '\ub0c9', '\ub0ca', '\ub0cb', '\ub0cc', '\ub0cd', '\ub0ce', 
    '\ub0cf', '\ub0d0', '\ub0d1', '\ub0d2', '\ub0d3', '\ub0d4', '\ub0d5', '\ub0d6', 
    '\ub0d7', '\ub0d8', '\ub0d9', '\ub0da', '\ub0db', '\ub0dc', '\ub0dd', '\ub0de', 
    '\ub0df', '\ub0e0', '\ub0e1', '\ub0e2', '\ub0e3', '\ub0e4', '\ub0e5', '\ub0e6', 
    '\ub0e7', '\ub0e8', '\ub0e9', '\ub0ea', '\ub0eb', '\ub0ec', '\ub0ed', '\ub0ee', 
    '\ub0ef', '\ub0f0', '\ub0f1', '\ub0f2', '\ub0f3', '\ub0f4', '\ub0f5', '\ub0f6', 
    '\ub0f7', '\ub0f8', '\ub0f9', '\ub0fa', '\ub0fb', '\ub0fc', '\ub0fd', '\ub0fe', 
    '\ub0ff', '\ub100', '\ub101', '\ub102', '\ub103', '\ub104', '\ub105', '\ub106', 
    '\ub107', '\ub108', '\ub109', '\ub10a', '\ub10b', '\ub10c', '\ub10d', '\ub10e', 
    '\ub10f', '\ub110', '\ub111', '\ub112', '\ub113', '\ub114', '\ub115', '\ub116', 
    '\ub117', '\ub118', '\ub119', '\ub11a', '\ub11b', '\ub11c', '\ub11d', '\ub11e', 
    '\ub11f', '\ub120', '\ub121', '\ub122', '\ub123', '\ub124', '\ub125', '\ub126', 
    '\ub127', '\ub128', '\ub129', '\ub12a', '\ub12b', '\ub12c', '\ub12d', '\ub12e', 
    '\ub12f', '\ub130', '\ub131', '\ub132', '\ub133', '\ub134', '\ub135', '\ub136', 
    '\ub137', '\ub138', '\ub139', '\ub13a', '\ub13b', '\ub13c', '\ub13d', '\ub13e', 
    '\ub13f', '\ub140', '\ub141', '\ub142', '\ub143', '\ub144', '\ub145', '\ub146', 
    '\ub147', '\ub148', '\ub149', '\ub14a', '\ub14b', '\ub14c', '\ub14d', '\ub14e', 
    '\ub14f', '\ub150', '\ub151', '\ub152', '\ub153', '\ub154', '\ub155', '\ub156', 
    '\ub157', '\ub158', '\ub159', '\ub15a', '\ub15b', '\ub15c', '\ub15d', '\ub15e', 
    '\ub15f', '\ub160', '\ub161', '\ub162', '\ub163', '\ub164', '\ub165', '\ub166', 
    '\ub167', '\ub168', '\ub169', '\ub16a', '\ub16b', '\ub16c', '\ub16d', '\ub16e', 
    '\ub16f', '\ub170', '\ub171', '\ub172', '\ub173', '\ub174', '\ub175', '\ub176', 
    '\ub177', '\ub178', '\ub179', '\ub17a', '\ub17b', '\ub17c', '\ub17d', '\ub17e', 
    '\ub17f', '\ub180', '\ub181', '\ub182', '\ub183', '\ub184', '\ub185', '\ub186', 
    '\ub187', '\ub188', '\ub189', '\ub18a', '\ub18b', '\ub18c', '\ub18d', '\ub18e', 
    '\ub18f', '\ub190', '\ub191', '\ub192', '\ub193', '\ub194', '\ub195', '\ub196', 
    '\ub197', '\ub198', '\ub199', '\ub19a', '\ub19b', '\ub19c', '\ub19d', '\ub19e', 
    '\ub19f', '\ub1a0', '\ub1a1', '\ub1a2', '\ub1a3', '\ub1a4', '\ub1a5', '\ub1a6', 
    '\ub1a7', '\ub1a8', '\ub1a9', '\ub1aa', '\ub1ab', '\ub1ac', '\ub1ad', '\ub1ae', 
    '\ub1af', '\ub1b0', '\ub1b1', '\ub1b2', '\ub1b3', '\ub1b4', '\ub1b5', '\ub1b6', 
    '\ub1b7', '\ub1b8', '\ub1b9', '\ub1ba', '\ub1bb', '\ub1bc', '\ub1bd', '\ub1be', 
    '\ub1bf', '\ub1c0', '\ub1c1', '\ub1c2', '\ub1c3', '\ub1c4', '\ub1c5', '\ub1c6', 
    '\ub1c7', '\ub1c8', '\ub1c9', '\ub1ca', '\ub1cb', '\ub1cc', '\ub1cd', '\ub1ce', 
    '\ub1cf', '\ub1d0', '\ub1d1', '\ub1d2', '\ub1d3', '\ub1d4', '\ub1d5', '\ub1d6', 
    '\ub1d7', '\ub1d8', '\ub1d9', '\ub1da', '\ub1db', '\ub1dc', '\ub1dd', '\ub1de', 
    '\ub1df', '\ub1e0', '\ub1e1', '\ub1e2', '\ub1e3', '\ub1e4', '\ub1e5', '\ub1e6', 
    '\ub1e7', '\ub1e8', '\ub1e9', '\ub1ea', '\ub1eb', '\ub1ec', '\ub1ed', '\ub1ee', 
    '\ub1ef', '\ub1f0', '\ub1f1', '\ub1f2', '\ub1f3', '\ub1f4', '\ub1f5', '\ub1f6', 
    '\ub1f7', '\ub1f8', '\ub1f9', '\ub1fa', '\ub1fb', '\ub1fc', '\ub1fd', '\ub1fe', 
    '\ub1ff', '\ub200', '\ub201', '\ub202', '\ub203', '\ub204', '\ub205', '\ub206', 
    '\ub207', '\ub208', '\ub209', '\ub20a', '\ub20b', '\ub20c', '\ub20d', '\ub20e', 
    '\ub20f', '\ub210', '\ub211', '\ub212', '\ub213', '\ub214', '\ub215', '\ub216', 
    '\ub217', '\ub218', '\ub219', '\ub21a', '\ub21b', '\ub21c', '\ub21d', '\ub21e', 
    '\ub21f', '\ub220', '\ub221', '\ub222', '\ub223', '\ub224', '\ub225', '\ub226', 
    '\ub227', '\ub228', '\ub229', '\ub22a', '\ub22b', '\ub22c', '\ub22d', '\ub22e', 
    '\ub22f', '\ub230', '\ub231', '\ub232', '\ub233', '\ub234', '\ub235', '\ub236', 
    '\ub237', '\ub238', '\ub239', '\ub23a', '\ub23b', '\ub23c', '\ub23d', '\ub23e', 
    '\ub23f', '\ub240', '\ub241', '\ub242', '\ub243', '\ub244', '\ub245', '\ub246', 
    '\ub247', '\ub248', '\ub249', '\ub24a', '\ub24b', '\ub24c', '\ub24d', '\ub24e', 
    '\ub24f', '\ub250', '\ub251', '\ub252', '\ub253', '\ub254', '\ub255', '\ub256', 
    '\ub257', '\ub258', '\ub259', '\ub25a', '\ub25b', '\ub25c', '\ub25d', '\ub25e', 
    '\ub25f', '\ub260', '\ub261', '\ub262', '\ub263', '\ub264', '\ub265', '\ub266', 
    '\ub267', '\ub268', '\ub269', '\ub26a', '\ub26b', '\ub26c', '\ub26d', '\ub26e', 
    '\ub26f', '\ub270', '\ub271', '\ub272', '\ub273', '\ub274', '\ub275', '\ub276', 
    '\ub277', '\ub278', '\ub279', '\ub27a', '\ub27b', '\ub27c', '\ub27d', '\ub27e', 
    '\ub27f', '\ub280', '\ub281', '\ub282', '\ub283', '\ub284', '\ub285', '\ub286', 
    '\ub287', '\ub288', '\ub289', '\ub28a', '\ub28b', '\ub28c', '\ub28d', '\ub28e', 
    '\ub28f', '\ub290', '\ub291', '\ub292', '\ub293', '\ub294', '\ub295', '\ub296', 
    '\ub297', '\ub298', '\ub299', '\ub29a', '\ub29b', '\ub29c', '\ub29d', '\ub29e', 
    '\ub29f', '\ub2a0', '\ub2a1', '\ub2a2', '\ub2a3', '\ub2a4', '\ub2a5', '\ub2a6', 
    '\ub2a7', '\ub2a8', '\ub2a9', '\ub2aa', '\ub2ab', '\ub2ac', '\ub2ad', '\ub2ae', 
    '\ub2af', '\ub2b0', '\ub2b1', '\ub2b2', '\ub2b3', '\ub2b4', '\ub2b5', '\ub2b6', 
    '\ub2b7', '\ub2b8', '\ub2b9', '\ub2ba', '\ub2bb', '\ub2bc', '\ub2bd', '\ub2be', 
    '\ub2bf', '\ub2c0', '\ub2c1', '\ub2c2', '\ub2c3', '\ub2c4', '\ub2c5', '\ub2c6', 
    '\ub2c7', '\ub2c8', '\ub2c9', '\ub2ca', '\ub2cb', '\ub2cc', '\ub2cd', '\ub2ce', 
    '\ub2cf', '\ub2d0', '\ub2d1', '\ub2d2', '\ub2d3', '\ub2d4', '\ub2d5', '\ub2d6', 
    '\ub2d7', '\ub2d8', '\ub2d9', '\ub2da', '\ub2db', '\ub2dc', '\ub2dd', '\ub2de', 
    '\ub2df', '\ub2e0', '\ub2e1', '\ub2e2', '\ub2e3', '\ub2e4', '\ub2e5', '\ub2e6', 
    '\ub2e7', '\ub2e8', '\ub2e9', '\ub2ea', '\ub2eb', '\ub2ec', '\ub2ed', '\ub2ee', 
    '\ub2ef', '\ub2f0', '\ub2f1', '\ub2f2', '\ub2f3', '\ub2f4', '\ub2f5', '\ub2f6', 
    '\ub2f7', '\ub2f8', '\ub2f9', '\ub2fa', '\ub2fb', '\ub2fc', '\ub2fd', '\ub2fe', 
    '\ub2ff', '\ub300', '\ub301', '\ub302', '\ub303', '\ub304', '\ub305', '\ub306', 
    '\ub307', '\ub308', '\ub309', '\ub30a', '\ub30b', '\ub30c', '\ub30d', '\ub30e', 
    '\ub30f', '\ub310', '\ub311', '\ub312', '\ub313', '\ub314', '\ub315', '\ub316', 
    '\ub317', '\ub318', '\ub319', '\ub31a', '\ub31b', '\ub31c', '\ub31d', '\ub31e', 
    '\ub31f', '\ub320', '\ub321', '\ub322', '\ub323', '\ub324', '\ub325', '\ub326', 
    '\ub327', '\ub328', '\ub329', '\ub32a', '\ub32b', '\ub32c', '\ub32d', '\ub32e', 
    '\ub32f', '\ub330', '\ub331', '\ub332', '\ub333', '\ub334', '\ub335', '\ub336', 
    '\ub337', '\ub338', '\ub339', '\ub33a', '\ub33b', '\ub33c', '\ub33d', '\ub33e', 
    '\ub33f', '\ub340', '\ub341', '\ub342', '\ub343', '\ub344', '\ub345', '\ub346', 
    '\ub347', '\ub348', '\ub349', '\ub34a', '\ub34b', '\ub34c', '\ub34d', '\ub34e', 
    '\ub34f', '\ub350', '\ub351', '\ub352', '\ub353', '\ub354', '\ub355', '\ub356', 
    '\ub357', '\ub358', '\ub359', '\ub35a', '\ub35b', '\ub35c', '\ub35d', '\ub35e', 
    '\ub35f', '\ub360', '\ub361', '\ub362', '\ub363', '\ub364', '\ub365', '\ub366', 
    '\ub367', '\ub368', '\ub369', '\ub36a', '\ub36b', '\ub36c', '\ub36d', '\ub36e', 
    '\ub36f', '\ub370', '\ub371', '\ub372', '\ub373', '\ub374', '\ub375', '\ub376', 
    '\ub377', '\ub378', '\ub379', '\ub37a', '\ub37b', '\ub37c', '\ub37d', '\ub37e', 
    '\ub37f', '\ub380', '\ub381', '\ub382', '\ub383', '\ub384', '\ub385', '\ub386', 
    '\ub387', '\ub388', '\ub389', '\ub38a', '\ub38b', '\ub38c', '\ub38d', '\ub38e', 
    '\ub38f', '\ub390', '\ub391', '\ub392', '\ub393', '\ub394', '\ub395', '\ub396', 
    '\ub397', '\ub398', '\ub399', '\ub39a', '\ub39b', '\ub39c', '\ub39d', '\ub39e', 
    '\ub39f', '\ub3a0', '\ub3a1', '\ub3a2', '\ub3a3', '\ub3a4', '\ub3a5', '\ub3a6', 
    '\ub3a7', '\ub3a8', '\ub3a9', '\ub3aa', '\ub3ab', '\ub3ac', '\ub3ad', '\ub3ae', 
    '\ub3af', '\ub3b0', '\ub3b1', '\ub3b2', '\ub3b3', '\ub3b4', '\ub3b5', '\ub3b6', 
    '\ub3b7', '\ub3b8', '\ub3b9', '\ub3ba', '\ub3bb', '\ub3bc', '\ub3bd', '\ub3be', 
    '\ub3bf', '\ub3c0', '\ub3c1', '\ub3c2', '\ub3c3', '\ub3c4', '\ub3c5', '\ub3c6', 
    '\ub3c7', '\ub3c8', '\ub3c9', '\ub3ca', '\ub3cb', '\ub3cc', '\ub3cd', '\ub3ce', 
    '\ub3cf', '\ub3d0', '\ub3d1', '\ub3d2', '\ub3d3', '\ub3d4', '\ub3d5', '\ub3d6', 
    '\ub3d7', '\ub3d8', '\ub3d9', '\ub3da', '\ub3db', '\ub3dc', '\ub3dd', '\ub3de', 
    '\ub3df', '\ub3e0', '\ub3e1', '\ub3e2', '\ub3e3', '\ub3e4', '\ub3e5', '\ub3e6', 
    '\ub3e7', '\ub3e8', '\ub3e9', '\ub3ea', '\ub3eb', '\ub3ec', '\ub3ed', '\ub3ee', 
    '\ub3ef', '\ub3f0', '\ub3f1', '\ub3f2', '\ub3f3', '\ub3f4', '\ub3f5', '\ub3f6', 
    '\ub3f7', '\ub3f8', '\ub3f9', '\ub3fa', '\ub3fb', '\ub3fc', '\ub3fd', '\ub3fe', 
    '\ub3ff', '\ub400', '\ub401', '\ub402', '\ub403', '\ub404', '\ub405', '\ub406', 
    '\ub407', '\ub408', '\ub409', '\ub40a', '\ub40b', '\ub40c', '\ub40d', '\ub40e', 
    '\ub40f', '\ub410', '\ub411', '\ub412', '\ub413', '\ub414', '\ub415', '\ub416', 
    '\ub417', '\ub418', '\ub419', '\ub41a', '\ub41b', '\ub41c', '\ub41d', '\ub41e', 
    '\ub41f', '\ub420', '\ub421', '\ub422', '\ub423', '\ub424', '\ub425', '\ub426', 
    '\ub427', '\ub428', '\ub429', '\ub42a', '\ub42b', '\ub42c', '\ub42d', '\ub42e', 
    '\ub42f', '\ub430', '\ub431', '\ub432', '\ub433', '\ub434', '\ub435', '\ub436', 
    '\ub437', '\ub438', '\ub439', '\ub43a', '\ub43b', '\ub43c', '\ub43d', '\ub43e', 
    '\ub43f', '\ub440', '\ub441', '\ub442', '\ub443', '\ub444', '\ub445', '\ub446', 
    '\ub447', '\ub448', '\ub449', '\ub44a', '\ub44b', '\ub44c', '\ub44d', '\ub44e', 
    '\ub44f', '\ub450', '\ub451', '\ub452', '\ub453', '\ub454', '\ub455', '\ub456', 
    '\ub457', '\ub458', '\ub459', '\ub45a', '\ub45b', '\ub45c', '\ub45d', '\ub45e', 
    '\ub45f', '\ub460', '\ub461', '\ub462', '\ub463', '\ub464', '\ub465', '\ub466', 
    '\ub467', '\ub468', '\ub469', '\ub46a', '\ub46b', '\ub46c', '\ub46d', '\ub46e', 
    '\ub46f', '\ub470', '\ub471', '\ub472', '\ub473', '\ub474', '\ub475', '\ub476', 
    '\ub477', '\ub478', '\ub479', '\ub47a', '\ub47b', '\ub47c', '\ub47d', '\ub47e', 
    '\ub47f', '\ub480', '\ub481', '\ub482', '\ub483', '\ub484', '\ub485', '\ub486', 
    '\ub487', '\ub488', '\ub489', '\ub48a', '\ub48b', '\ub48c', '\ub48d', '\ub48e', 
    '\ub48f', '\ub490', '\ub491', '\ub492', '\ub493', '\ub494', '\ub495', '\ub496', 
    '\ub497', '\ub498', '\ub499', '\ub49a', '\ub49b', '\ub49c', '\ub49d', '\ub49e', 
    '\ub49f', '\ub4a0', '\ub4a1', '\ub4a2', '\ub4a3', '\ub4a4', '\ub4a5', '\ub4a6', 
    '\ub4a7', '\ub4a8', '\ub4a9', '\ub4aa', '\ub4ab', '\ub4ac', '\ub4ad', '\ub4ae', 
    '\ub4af', '\ub4b0', '\ub4b1', '\ub4b2', '\ub4b3', '\ub4b4', '\ub4b5', '\ub4b6', 
    '\ub4b7', '\ub4b8', '\ub4b9', '\ub4ba', '\ub4bb', '\ub4bc', '\ub4bd', '\ub4be', 
    '\ub4bf', '\ub4c0', '\ub4c1', '\ub4c2', '\ub4c3', '\ub4c4', '\ub4c5', '\ub4c6', 
    '\ub4c7', '\ub4c8', '\ub4c9', '\ub4ca', '\ub4cb', '\ub4cc', '\ub4cd', '\ub4ce', 
    '\ub4cf', '\ub4d0', '\ub4d1', '\ub4d2', '\ub4d3', '\ub4d4', '\ub4d5', '\ub4d6', 
    '\ub4d7', '\ub4d8', '\ub4d9', '\ub4da', '\ub4db', '\ub4dc', '\ub4dd', '\ub4de', 
    '\ub4df', '\ub4e0', '\ub4e1', '\ub4e2', '\ub4e3', '\ub4e4', '\ub4e5', '\ub4e6', 
    '\ub4e7', '\ub4e8', '\ub4e9', '\ub4ea', '\ub4eb', '\ub4ec', '\ub4ed', '\ub4ee', 
    '\ub4ef', '\ub4f0', '\ub4f1', '\ub4f2', '\ub4f3', '\ub4f4', '\ub4f5', '\ub4f6', 
    '\ub4f7', '\ub4f8', '\ub4f9', '\ub4fa', '\ub4fb', '\ub4fc', '\ub4fd', '\ub4fe', 
    '\ub4ff', '\ub500', '\ub501', '\ub502', '\ub503', '\ub504', '\ub505', '\ub506', 
    '\ub507', '\ub508', '\ub509', '\ub50a', '\ub50b', '\ub50c', '\ub50d', '\ub50e', 
    '\ub50f', '\ub510', '\ub511', '\ub512', '\ub513', '\ub514', '\ub515', '\ub516', 
    '\ub517', '\ub518', '\ub519', '\ub51a', '\ub51b', '\ub51c', '\ub51d', '\ub51e', 
    '\ub51f', '\ub520', '\ub521', '\ub522', '\ub523', '\ub524', '\ub525', '\ub526', 
    '\ub527', '\ub528', '\ub529', '\ub52a', '\ub52b', '\ub52c', '\ub52d', '\ub52e', 
    '\ub52f', '\ub530', '\ub531', '\ub532', '\ub533', '\ub534', '\ub535', '\ub536', 
    '\ub537', '\ub538', '\ub539', '\ub53a', '\ub53b', '\ub53c', '\ub53d', '\ub53e', 
    '\ub53f', '\ub540', '\ub541', '\ub542', '\ub543', '\ub544', '\ub545', '\ub546', 
    '\ub547', '\ub548', '\ub549', '\ub54a', '\ub54b', '\ub54c', '\ub54d', '\ub54e', 
    '\ub54f', '\ub550', '\ub551', '\ub552', '\ub553', '\ub554', '\ub555', '\ub556', 
    '\ub557', '\ub558', '\ub559', '\ub55a', '\ub55b', '\ub55c', '\ub55d', '\ub55e', 
    '\ub55f', '\ub560', '\ub561', '\ub562', '\ub563', '\ub564', '\ub565', '\ub566', 
    '\ub567', '\ub568', '\ub569', '\ub56a', '\ub56b', '\ub56c', '\ub56d', '\ub56e', 
    '\ub56f', '\ub570', '\ub571', '\ub572', '\ub573', '\ub574', '\ub575', '\ub576', 
    '\ub577', '\ub578', '\ub579', '\ub57a', '\ub57b', '\ub57c', '\ub57d', '\ub57e', 
    '\ub57f', '\ub580', '\ub581', '\ub582', '\ub583', '\ub584', '\ub585', '\ub586', 
    '\ub587', '\ub588', '\ub589', '\ub58a', '\ub58b', '\ub58c', '\ub58d', '\ub58e', 
    '\ub58f', '\ub590', '\ub591', '\ub592', '\ub593', '\ub594', '\ub595', '\ub596', 
    '\ub597', '\ub598', '\ub599', '\ub59a', '\ub59b', '\ub59c', '\ub59d', '\ub59e', 
    '\ub59f', '\ub5a0', '\ub5a1', '\ub5a2', '\ub5a3', '\ub5a4', '\ub5a5', '\ub5a6', 
    '\ub5a7', '\ub5a8', '\ub5a9', '\ub5aa', '\ub5ab', '\ub5ac', '\ub5ad', '\ub5ae', 
    '\ub5af', '\ub5b0', '\ub5b1', '\ub5b2', '\ub5b3', '\ub5b4', '\ub5b5', '\ub5b6', 
    '\ub5b7', '\ub5b8', '\ub5b9', '\ub5ba', '\ub5bb', '\ub5bc', '\ub5bd', '\ub5be', 
    '\ub5bf', '\ub5c0', '\ub5c1', '\ub5c2', '\ub5c3', '\ub5c4', '\ub5c5', '\ub5c6', 
    '\ub5c7', '\ub5c8', '\ub5c9', '\ub5ca', '\ub5cb', '\ub5cc', '\ub5cd', '\ub5ce', 
    '\ub5cf', '\ub5d0', '\ub5d1', '\ub5d2', '\ub5d3', '\ub5d4', '\ub5d5', '\ub5d6', 
    '\ub5d7', '\ub5d8', '\ub5d9', '\ub5da', '\ub5db', '\ub5dc', '\ub5dd', '\ub5de', 
    '\ub5df', '\ub5e0', '\ub5e1', '\ub5e2', '\ub5e3', '\ub5e4', '\ub5e5', '\ub5e6', 
    '\ub5e7', '\ub5e8', '\ub5e9', '\ub5ea', '\ub5eb', '\ub5ec', '\ub5ed', '\ub5ee', 
    '\ub5ef', '\ub5f0', '\ub5f1', '\ub5f2', '\ub5f3', '\ub5f4', '\ub5f5', '\ub5f6', 
    '\ub5f7', '\ub5f8', '\ub5f9', '\ub5fa', '\ub5fb', '\ub5fc', '\ub5fd', '\ub5fe', 
    '\ub5ff', '\ub600', '\ub601', '\ub602', '\ub603', '\ub604', '\ub605', '\ub606', 
    '\ub607', '\ub608', '\ub609', '\ub60a', '\ub60b', '\ub60c', '\ub60d', '\ub60e', 
    '\ub60f', '\ub610', '\ub611', '\ub612', '\ub613', '\ub614', '\ub615', '\ub616', 
    '\ub617', '\ub618', '\ub619', '\ub61a', '\ub61b', '\ub61c', '\ub61d', '\ub61e', 
    '\ub61f', '\ub620', '\ub621', '\ub622', '\ub623', '\ub624', '\ub625', '\ub626', 
    '\ub627', '\ub628', '\ub629', '\ub62a', '\ub62b', '\ub62c', '\ub62d', '\ub62e', 
    '\ub62f', '\ub630', '\ub631', '\ub632', '\ub633', '\ub634', '\ub635', '\ub636', 
    '\ub637', '\ub638', '\ub639', '\ub63a', '\ub63b', '\ub63c', '\ub63d', '\ub63e', 
    '\ub63f', '\ub640', '\ub641', '\ub642', '\ub643', '\ub644', '\ub645', '\ub646', 
    '\ub647', '\ub648', '\ub649', '\ub64a', '\ub64b', '\ub64c', '\ub64d', '\ub64e', 
    '\ub64f', '\ub650', '\ub651', '\ub652', '\ub653', '\ub654', '\ub655', '\ub656', 
    '\ub657', '\ub658', '\ub659', '\ub65a', '\ub65b', '\ub65c', '\ub65d', '\ub65e', 
    '\ub65f', '\ub660', '\ub661', '\ub662', '\ub663', '\ub664', '\ub665', '\ub666', 
    '\ub667', '\ub668', '\ub669', '\ub66a', '\ub66b', '\ub66c', '\ub66d', '\ub66e', 
    '\ub66f', '\ub670', '\ub671', '\ub672', '\ub673', '\ub674', '\ub675', '\ub676', 
    '\ub677', '\ub678', '\ub679', '\ub67a', '\ub67b', '\ub67c', '\ub67d', '\ub67e', 
    '\ub67f', '\ub680', '\ub681', '\ub682', '\ub683', '\ub684', '\ub685', '\ub686', 
    '\ub687', '\ub688', '\ub689', '\ub68a', '\ub68b', '\ub68c', '\ub68d', '\ub68e', 
    '\ub68f', '\ub690', '\ub691', '\ub692', '\ub693', '\ub694', '\ub695', '\ub696', 
    '\ub697', '\ub698', '\ub699', '\ub69a', '\ub69b', '\ub69c', '\ub69d', '\ub69e', 
    '\ub69f', '\ub6a0', '\ub6a1', '\ub6a2', '\ub6a3', '\ub6a4', '\ub6a5', '\ub6a6', 
    '\ub6a7', '\ub6a8', '\ub6a9', '\ub6aa', '\ub6ab', '\ub6ac', '\ub6ad', '\ub6ae', 
    '\ub6af', '\ub6b0', '\ub6b1', '\ub6b2', '\ub6b3', '\ub6b4', '\ub6b5', '\ub6b6', 
    '\ub6b7', '\ub6b8', '\ub6b9', '\ub6ba', '\ub6bb', '\ub6bc', '\ub6bd', '\ub6be', 
    '\ub6bf', '\ub6c0', '\ub6c1', '\ub6c2', '\ub6c3', '\ub6c4', '\ub6c5', '\ub6c6', 
    '\ub6c7', '\ub6c8', '\ub6c9', '\ub6ca', '\ub6cb', '\ub6cc', '\ub6cd', '\ub6ce', 
    '\ub6cf', '\ub6d0', '\ub6d1', '\ub6d2', '\ub6d3', '\ub6d4', '\ub6d5', '\ub6d6', 
    '\ub6d7', '\ub6d8', '\ub6d9', '\ub6da', '\ub6db', '\ub6dc', '\ub6dd', '\ub6de', 
    '\ub6df', '\ub6e0', '\ub6e1', '\ub6e2', '\ub6e3', '\ub6e4', '\ub6e5', '\ub6e6', 
    '\ub6e7', '\ub6e8', '\ub6e9', '\ub6ea', '\ub6eb', '\ub6ec', '\ub6ed', '\ub6ee', 
    '\ub6ef', '\ub6f0', '\ub6f1', '\ub6f2', '\ub6f3', '\ub6f4', '\ub6f5', '\ub6f6', 
    '\ub6f7', '\ub6f8', '\ub6f9', '\ub6fa', '\ub6fb', '\ub6fc', '\ub6fd', '\ub6fe', 
    '\ub6ff', '\ub700', '\ub701', '\ub702', '\ub703', '\ub704', '\ub705', '\ub706', 
    '\ub707', '\ub708', '\ub709', '\ub70a', '\ub70b', '\ub70c', '\ub70d', '\ub70e', 
    '\ub70f', '\ub710', '\ub711', '\ub712', '\ub713', '\ub714', '\ub715', '\ub716', 
    '\ub717', '\ub718', '\ub719', '\ub71a', '\ub71b', '\ub71c', '\ub71d', '\ub71e', 
    '\ub71f', '\ub720', '\ub721', '\ub722', '\ub723', '\ub724', '\ub725', '\ub726', 
    '\ub727', '\ub728', '\ub729', '\ub72a', '\ub72b', '\ub72c', '\ub72d', '\ub72e', 
    '\ub72f', '\ub730', '\ub731', '\ub732', '\ub733', '\ub734', '\ub735', '\ub736', 
    '\ub737', '\ub738', '\ub739', '\ub73a', '\ub73b', '\ub73c', '\ub73d', '\ub73e', 
    '\ub73f', '\ub740', '\ub741', '\ub742', '\ub743', '\ub744', '\ub745', '\ub746', 
    '\ub747', '\ub748', '\ub749', '\ub74a', '\ub74b', '\ub74c', '\ub74d', '\ub74e', 
    '\ub74f', '\ub750', '\ub751', '\ub752', '\ub753', '\ub754', '\ub755', '\ub756', 
    '\ub757', '\ub758', '\ub759', '\ub75a', '\ub75b', '\ub75c', '\ub75d', '\ub75e', 
    '\ub75f', '\ub760', '\ub761', '\ub762', '\ub763', '\ub764', '\ub765', '\ub766', 
    '\ub767', '\ub768', '\ub769', '\ub76a', '\ub76b', '\ub76c', '\ub76d', '\ub76e', 
    '\ub76f', '\ub770', '\ub771', '\ub772', '\ub773', '\ub774', '\ub775', '\ub776', 
    '\ub777', '\ub778', '\ub779', '\ub77a', '\ub77b', '\ub77c', '\ub77d', '\ub77e', 
    '\ub77f', '\ub780', '\ub781', '\ub782', '\ub783', '\ub784', '\ub785', '\ub786', 
    '\ub787', '\ub788', '\ub789', '\ub78a', '\ub78b', '\ub78c', '\ub78d', '\ub78e', 
    '\ub78f', '\ub790', '\ub791', '\ub792', '\ub793', '\ub794', '\ub795', '\ub796', 
    '\ub797', '\ub798', '\ub799', '\ub79a', '\ub79b', '\ub79c', '\ub79d', '\ub79e', 
    '\ub79f', '\ub7a0', '\ub7a1', '\ub7a2', '\ub7a3', '\ub7a4', '\ub7a5', '\ub7a6', 
    '\ub7a7', '\ub7a8', '\ub7a9', '\ub7aa', '\ub7ab', '\ub7ac', '\ub7ad', '\ub7ae', 
    '\ub7af', '\ub7b0', '\ub7b1', '\ub7b2', '\ub7b3', '\ub7b4', '\ub7b5', '\ub7b6', 
    '\ub7b7', '\ub7b8', '\ub7b9', '\ub7ba', '\ub7bb', '\ub7bc', '\ub7bd', '\ub7be', 
    '\ub7bf', '\ub7c0', '\ub7c1', '\ub7c2', '\ub7c3', '\ub7c4', '\ub7c5', '\ub7c6', 
    '\ub7c7', '\ub7c8', '\ub7c9', '\ub7ca', '\ub7cb', '\ub7cc', '\ub7cd', '\ub7ce', 
    '\ub7cf', '\ub7d0', '\ub7d1', '\ub7d2', '\ub7d3', '\ub7d4', '\ub7d5', '\ub7d6', 
    '\ub7d7', '\ub7d8', '\ub7d9', '\ub7da', '\ub7db', '\ub7dc', '\ub7dd', '\ub7de', 
    '\ub7df', '\ub7e0', '\ub7e1', '\ub7e2', '\ub7e3', '\ub7e4', '\ub7e5', '\ub7e6', 
    '\ub7e7', '\ub7e8', '\ub7e9', '\ub7ea', '\ub7eb', '\ub7ec', '\ub7ed', '\ub7ee', 
    '\ub7ef', '\ub7f0', '\ub7f1', '\ub7f2', '\ub7f3', '\ub7f4', '\ub7f5', '\ub7f6', 
    '\ub7f7', '\ub7f8', '\ub7f9', '\ub7fa', '\ub7fb', '\ub7fc', '\ub7fd', '\ub7fe', 
    '\ub7ff', '\ub800', '\ub801', '\ub802', '\ub803', '\ub804', '\ub805', '\ub806', 
    '\ub807', '\ub808', '\ub809', '\ub80a', '\ub80b', '\ub80c', '\ub80d', '\ub80e', 
    '\ub80f', '\ub810', '\ub811', '\ub812', '\ub813', '\ub814', '\ub815', '\ub816', 
    '\ub817', '\ub818', '\ub819', '\ub81a', '\ub81b', '\ub81c', '\ub81d', '\ub81e', 
    '\ub81f', '\ub820', '\ub821', '\ub822', '\ub823', '\ub824', '\ub825', '\ub826', 
    '\ub827', '\ub828', '\ub829', '\ub82a', '\ub82b', '\ub82c', '\ub82d', '\ub82e', 
    '\ub82f', '\ub830', '\ub831', '\ub832', '\ub833', '\ub834', '\ub835', '\ub836', 
    '\ub837', '\ub838', '\ub839', '\ub83a', '\ub83b', '\ub83c', '\ub83d', '\ub83e', 
    '\ub83f', '\ub840', '\ub841', '\ub842', '\ub843', '\ub844', '\ub845', '\ub846', 
    '\ub847', '\ub848', '\ub849', '\ub84a', '\ub84b', '\ub84c', '\ub84d', '\ub84e', 
    '\ub84f', '\ub850', '\ub851', '\ub852', '\ub853', '\ub854', '\ub855', '\ub856', 
    '\ub857', '\ub858', '\ub859', '\ub85a', '\ub85b', '\ub85c', '\ub85d', '\ub85e', 
    '\ub85f', '\ub860', '\ub861', '\ub862', '\ub863', '\ub864', '\ub865', '\ub866', 
    '\ub867', '\ub868', '\ub869', '\ub86a', '\ub86b', '\ub86c', '\ub86d', '\ub86e', 
    '\ub86f', '\ub870', '\ub871', '\ub872', '\ub873', '\ub874', '\ub875', '\ub876', 
    '\ub877', '\ub878', '\ub879', '\ub87a', '\ub87b', '\ub87c', '\ub87d', '\ub87e', 
    '\ub87f', '\ub880', '\ub881', '\ub882', '\ub883', '\ub884', '\ub885', '\ub886', 
    '\ub887', '\ub888', '\ub889', '\ub88a', '\ub88b', '\ub88c', '\ub88d', '\ub88e', 
    '\ub88f', '\ub890', '\ub891', '\ub892', '\ub893', '\ub894', '\ub895', '\ub896', 
    '\ub897', '\ub898', '\ub899', '\ub89a', '\ub89b', '\ub89c', '\ub89d', '\ub89e', 
    '\ub89f', '\ub8a0', '\ub8a1', '\ub8a2', '\ub8a3', '\ub8a4', '\ub8a5', '\ub8a6', 
    '\ub8a7', '\ub8a8', '\ub8a9', '\ub8aa', '\ub8ab', '\ub8ac', '\ub8ad', '\ub8ae', 
    '\ub8af', '\ub8b0', '\ub8b1', '\ub8b2', '\ub8b3', '\ub8b4', '\ub8b5', '\ub8b6', 
    '\ub8b7', '\ub8b8', '\ub8b9', '\ub8ba', '\ub8bb', '\ub8bc', '\ub8bd', '\ub8be', 
    '\ub8bf', '\ub8c0', '\ub8c1', '\ub8c2', '\ub8c3', '\ub8c4', '\ub8c5', '\ub8c6', 
    '\ub8c7', '\ub8c8', '\ub8c9', '\ub8ca', '\ub8cb', '\ub8cc', '\ub8cd', '\ub8ce', 
    '\ub8cf', '\ub8d0', '\ub8d1', '\ub8d2', '\ub8d3', '\ub8d4', '\ub8d5', '\ub8d6', 
    '\ub8d7', '\ub8d8', '\ub8d9', '\ub8da', '\ub8db', '\ub8dc', '\ub8dd', '\ub8de', 
    '\ub8df', '\ub8e0', '\ub8e1', '\ub8e2', '\ub8e3', '\ub8e4', '\ub8e5', '\ub8e6', 
    '\ub8e7', '\ub8e8', '\ub8e9', '\ub8ea', '\ub8eb', '\ub8ec', '\ub8ed', '\ub8ee', 
    '\ub8ef', '\ub8f0', '\ub8f1', '\ub8f2', '\ub8f3', '\ub8f4', '\ub8f5', '\ub8f6', 
    '\ub8f7', '\ub8f8', '\ub8f9', '\ub8fa', '\ub8fb', '\ub8fc', '\ub8fd', '\ub8fe', 
    '\ub8ff', '\ub900', '\ub901', '\ub902', '\ub903', '\ub904', '\ub905', '\ub906', 
    '\ub907', '\ub908', '\ub909', '\ub90a', '\ub90b', '\ub90c', '\ub90d', '\ub90e', 
    '\ub90f', '\ub910', '\ub911', '\ub912', '\ub913', '\ub914', '\ub915', '\ub916', 
    '\ub917', '\ub918', '\ub919', '\ub91a', '\ub91b', '\ub91c', '\ub91d', '\ub91e', 
    '\ub91f', '\ub920', '\ub921', '\ub922', '\ub923', '\ub924', '\ub925', '\ub926', 
    '\ub927', '\ub928', '\ub929', '\ub92a', '\ub92b', '\ub92c', '\ub92d', '\ub92e', 
    '\ub92f', '\ub930', '\ub931', '\ub932', '\ub933', '\ub934', '\ub935', '\ub936', 
    '\ub937', '\ub938', '\ub939', '\ub93a', '\ub93b', '\ub93c', '\ub93d', '\ub93e', 
    '\ub93f', '\ub940', '\ub941', '\ub942', '\ub943', '\ub944', '\ub945', '\ub946', 
    '\ub947', '\ub948', '\ub949', '\ub94a', '\ub94b', '\ub94c', '\ub94d', '\ub94e', 
    '\ub94f', '\ub950', '\ub951', '\ub952', '\ub953', '\ub954', '\ub955', '\ub956', 
    '\ub957', '\ub958', '\ub959', '\ub95a', '\ub95b', '\ub95c', '\ub95d', '\ub95e', 
    '\ub95f', '\ub960', '\ub961', '\ub962', '\ub963', '\ub964', '\ub965', '\ub966', 
    '\ub967', '\ub968', '\ub969', '\ub96a', '\ub96b', '\ub96c', '\ub96d', '\ub96e', 
    '\ub96f', '\ub970', '\ub971', '\ub972', '\ub973', '\ub974', '\ub975', '\ub976', 
    '\ub977', '\ub978', '\ub979', '\ub97a', '\ub97b', '\ub97c', '\ub97d', '\ub97e', 
    '\ub97f', '\ub980', '\ub981', '\ub982', '\ub983', '\ub984', '\ub985', '\ub986', 
    '\ub987', '\ub988', '\ub989', '\ub98a', '\ub98b', '\ub98c', '\ub98d', '\ub98e', 
    '\ub98f', '\ub990', '\ub991', '\ub992', '\ub993', '\ub994', '\ub995', '\ub996', 
    '\ub997', '\ub998', '\ub999', '\ub99a', '\ub99b', '\ub99c', '\ub99d', '\ub99e', 
    '\ub99f', '\ub9a0', '\ub9a1', '\ub9a2', '\ub9a3', '\ub9a4', '\ub9a5', '\ub9a6', 
    '\ub9a7', '\ub9a8', '\ub9a9', '\ub9aa', '\ub9ab', '\ub9ac', '\ub9ad', '\ub9ae', 
    '\ub9af', '\ub9b0', '\ub9b1', '\ub9b2', '\ub9b3', '\ub9b4', '\ub9b5', '\ub9b6', 
    '\ub9b7', '\ub9b8', '\ub9b9', '\ub9ba', '\ub9bb', '\ub9bc', '\ub9bd', '\ub9be', 
    '\ub9bf', '\ub9c0', '\ub9c1', '\ub9c2', '\ub9c3', '\ub9c4', '\ub9c5', '\ub9c6', 
    '\ub9c7', '\ub9c8', '\ub9c9', '\ub9ca', '\ub9cb', '\ub9cc', '\ub9cd', '\ub9ce', 
    '\ub9cf', '\ub9d0', '\ub9d1', '\ub9d2', '\ub9d3', '\ub9d4', '\ub9d5', '\ub9d6', 
    '\ub9d7', '\ub9d8', '\ub9d9', '\ub9da', '\ub9db', '\ub9dc', '\ub9dd', '\ub9de', 
    '\ub9df', '\ub9e0', '\ub9e1', '\ub9e2', '\ub9e3', '\ub9e4', '\ub9e5', '\ub9e6', 
    '\ub9e7', '\ub9e8', '\ub9e9', '\ub9ea', '\ub9eb', '\ub9ec', '\ub9ed', '\ub9ee', 
    '\ub9ef', '\ub9f0', '\ub9f1', '\ub9f2', '\ub9f3', '\ub9f4', '\ub9f5', '\ub9f6', 
    '\ub9f7', '\ub9f8', '\ub9f9', '\ub9fa', '\ub9fb', '\ub9fc', '\ub9fd', '\ub9fe', 
    '\ub9ff', '\uba00', '\uba01', '\uba02', '\uba03', '\uba04', '\uba05', '\uba06', 
    '\uba07', '\uba08', '\uba09', '\uba0a', '\uba0b', '\uba0c', '\uba0d', '\uba0e', 
    '\uba0f', '\uba10', '\uba11', '\uba12', '\uba13', '\uba14', '\uba15', '\uba16', 
    '\uba17', '\uba18', '\uba19', '\uba1a', '\uba1b', '\uba1c', '\uba1d', '\uba1e', 
    '\uba1f', '\uba20', '\uba21', '\uba22', '\uba23', '\uba24', '\uba25', '\uba26', 
    '\uba27', '\uba28', '\uba29', '\uba2a', '\uba2b', '\uba2c', '\uba2d', '\uba2e', 
    '\uba2f', '\uba30', '\uba31', '\uba32', '\uba33', '\uba34', '\uba35', '\uba36', 
    '\uba37', '\uba38', '\uba39', '\uba3a', '\uba3b', '\uba3c', '\uba3d', '\uba3e', 
    '\uba3f', '\uba40', '\uba41', '\uba42', '\uba43', '\uba44', '\uba45', '\uba46', 
    '\uba47', '\uba48', '\uba49', '\uba4a', '\uba4b', '\uba4c', '\uba4d', '\uba4e', 
    '\uba4f', '\uba50', '\uba51', '\uba52', '\uba53', '\uba54', '\uba55', '\uba56', 
    '\uba57', '\uba58', '\uba59', '\uba5a', '\uba5b', '\uba5c', '\uba5d', '\uba5e', 
    '\uba5f', '\uba60', '\uba61', '\uba62', '\uba63', '\uba64', '\uba65', '\uba66', 
    '\uba67', '\uba68', '\uba69', '\uba6a', '\uba6b', '\uba6c', '\uba6d', '\uba6e', 
    '\uba6f', '\uba70', '\uba71', '\uba72', '\uba73', '\uba74', '\uba75', '\uba76', 
    '\uba77', '\uba78', '\uba79', '\uba7a', '\uba7b', '\uba7c', '\uba7d', '\uba7e', 
    '\uba7f', '\uba80', '\uba81', '\uba82', '\uba83', '\uba84', '\uba85', '\uba86', 
    '\uba87', '\uba88', '\uba89', '\uba8a', '\uba8b', '\uba8c', '\uba8d', '\uba8e', 
    '\uba8f', '\uba90', '\uba91', '\uba92', '\uba93', '\uba94', '\uba95', '\uba96', 
    '\uba97', '\uba98', '\uba99', '\uba9a', '\uba9b', '\uba9c', '\uba9d', '\uba9e', 
    '\uba9f', '\ubaa0', '\ubaa1', '\ubaa2', '\ubaa3', '\ubaa4', '\ubaa5', '\ubaa6', 
    '\ubaa7', '\ubaa8', '\ubaa9', '\ubaaa', '\ubaab', '\ubaac', '\ubaad', '\ubaae', 
    '\ubaaf', '\ubab0', '\ubab1', '\ubab2', '\ubab3', '\ubab4', '\ubab5', '\ubab6', 
    '\ubab7', '\ubab8', '\ubab9', '\ubaba', '\ubabb', '\ubabc', '\ubabd', '\ubabe', 
    '\ubabf', '\ubac0', '\ubac1', '\ubac2', '\ubac3', '\ubac4', '\ubac5', '\ubac6', 
    '\ubac7', '\ubac8', '\ubac9', '\ubaca', '\ubacb', '\ubacc', '\ubacd', '\ubace', 
    '\ubacf', '\ubad0', '\ubad1', '\ubad2', '\ubad3', '\ubad4', '\ubad5', '\ubad6', 
    '\ubad7', '\ubad8', '\ubad9', '\ubada', '\ubadb', '\ubadc', '\ubadd', '\ubade', 
    '\ubadf', '\ubae0', '\ubae1', '\ubae2', '\ubae3', '\ubae4', '\ubae5', '\ubae6', 
    '\ubae7', '\ubae8', '\ubae9', '\ubaea', '\ubaeb', '\ubaec', '\ubaed', '\ubaee', 
    '\ubaef', '\ubaf0', '\ubaf1', '\ubaf2', '\ubaf3', '\ubaf4', '\ubaf5', '\ubaf6', 
    '\ubaf7', '\ubaf8', '\ubaf9', '\ubafa', '\ubafb', '\ubafc', '\ubafd', '\ubafe', 
    '\ubaff', '\ubb00', '\ubb01', '\ubb02', '\ubb03', '\ubb04', '\ubb05', '\ubb06', 
    '\ubb07', '\ubb08', '\ubb09', '\ubb0a', '\ubb0b', '\ubb0c', '\ubb0d', '\ubb0e', 
    '\ubb0f', '\ubb10', '\ubb11', '\ubb12', '\ubb13', '\ubb14', '\ubb15', '\ubb16', 
    '\ubb17', '\ubb18', '\ubb19', '\ubb1a', '\ubb1b', '\ubb1c', '\ubb1d', '\ubb1e', 
    '\ubb1f', '\ubb20', '\ubb21', '\ubb22', '\ubb23', '\ubb24', '\ubb25', '\ubb26', 
    '\ubb27', '\ubb28', '\ubb29', '\ubb2a', '\ubb2b', '\ubb2c', '\ubb2d', '\ubb2e', 
    '\ubb2f', '\ubb30', '\ubb31', '\ubb32', '\ubb33', '\ubb34', '\ubb35', '\ubb36', 
    '\ubb37', '\ubb38', '\ubb39', '\ubb3a', '\ubb3b', '\ubb3c', '\ubb3d', '\ubb3e', 
    '\ubb3f', '\ubb40', '\ubb41', '\ubb42', '\ubb43', '\ubb44', '\ubb45', '\ubb46', 
    '\ubb47', '\ubb48', '\ubb49', '\ubb4a', '\ubb4b', '\ubb4c', '\ubb4d', '\ubb4e', 
    '\ubb4f', '\ubb50', '\ubb51', '\ubb52', '\ubb53', '\ubb54', '\ubb55', '\ubb56', 
    '\ubb57', '\ubb58', '\ubb59', '\ubb5a', '\ubb5b', '\ubb5c', '\ubb5d', '\ubb5e', 
    '\ubb5f', '\ubb60', '\ubb61', '\ubb62', '\ubb63', '\ubb64', '\ubb65', '\ubb66', 
    '\ubb67', '\ubb68', '\ubb69', '\ubb6a', '\ubb6b', '\ubb6c', '\ubb6d', '\ubb6e', 
    '\ubb6f', '\ubb70', '\ubb71', '\ubb72', '\ubb73', '\ubb74', '\ubb75', '\ubb76', 
    '\ubb77', '\ubb78', '\ubb79', '\ubb7a', '\ubb7b', '\ubb7c', '\ubb7d', '\ubb7e', 
    '\ubb7f', '\ubb80', '\ubb81', '\ubb82', '\ubb83', '\ubb84', '\ubb85', '\ubb86', 
    '\ubb87', '\ubb88', '\ubb89', '\ubb8a', '\ubb8b', '\ubb8c', '\ubb8d', '\ubb8e', 
    '\ubb8f', '\ubb90', '\ubb91', '\ubb92', '\ubb93', '\ubb94', '\ubb95', '\ubb96', 
    '\ubb97', '\ubb98', '\ubb99', '\ubb9a', '\ubb9b', '\ubb9c', '\ubb9d', '\ubb9e', 
    '\ubb9f', '\ubba0', '\ubba1', '\ubba2', '\ubba3', '\ubba4', '\ubba5', '\ubba6', 
    '\ubba7', '\ubba8', '\ubba9', '\ubbaa', '\ubbab', '\ubbac', '\ubbad', '\ubbae', 
    '\ubbaf', '\ubbb0', '\ubbb1', '\ubbb2', '\ubbb3', '\ubbb4', '\ubbb5', '\ubbb6', 
    '\ubbb7', '\ubbb8', '\ubbb9', '\ubbba', '\ubbbb', '\ubbbc', '\ubbbd', '\ubbbe', 
    '\ubbbf', '\ubbc0', '\ubbc1', '\ubbc2', '\ubbc3', '\ubbc4', '\ubbc5', '\ubbc6', 
    '\ubbc7', '\ubbc8', '\ubbc9', '\ubbca', '\ubbcb', '\ubbcc', '\ubbcd', '\ubbce', 
    '\ubbcf', '\ubbd0', '\ubbd1', '\ubbd2', '\ubbd3', '\ubbd4', '\ubbd5', '\ubbd6', 
    '\ubbd7', '\ubbd8', '\ubbd9', '\ubbda', '\ubbdb', '\ubbdc', '\ubbdd', '\ubbde', 
    '\ubbdf', '\ubbe0', '\ubbe1', '\ubbe2', '\ubbe3', '\ubbe4', '\ubbe5', '\ubbe6', 
    '\ubbe7', '\ubbe8', '\ubbe9', '\ubbea', '\ubbeb', '\ubbec', '\ubbed', '\ubbee', 
    '\ubbef', '\ubbf0', '\ubbf1', '\ubbf2', '\ubbf3', '\ubbf4', '\ubbf5', '\ubbf6', 
    '\ubbf7', '\ubbf8', '\ubbf9', '\ubbfa', '\ubbfb', '\ubbfc', '\ubbfd', '\ubbfe', 
    '\ubbff', '\ubc00', '\ubc01', '\ubc02', '\ubc03', '\ubc04', '\ubc05', '\ubc06', 
    '\ubc07', '\ubc08', '\ubc09', '\ubc0a', '\ubc0b', '\ubc0c', '\ubc0d', '\ubc0e', 
    '\ubc0f', '\ubc10', '\ubc11', '\ubc12', '\ubc13', '\ubc14', '\ubc15', '\ubc16', 
    '\ubc17', '\ubc18', '\ubc19', '\ubc1a', '\ubc1b', '\ubc1c', '\ubc1d', '\ubc1e', 
    '\ubc1f', '\ubc20', '\ubc21', '\ubc22', '\ubc23', '\ubc24', '\ubc25', '\ubc26', 
    '\ubc27', '\ubc28', '\ubc29', '\ubc2a', '\ubc2b', '\ubc2c', '\ubc2d', '\ubc2e', 
    '\ubc2f', '\ubc30', '\ubc31', '\ubc32', '\ubc33', '\ubc34', '\ubc35', '\ubc36', 
    '\ubc37', '\ubc38', '\ubc39', '\ubc3a', '\ubc3b', '\ubc3c', '\ubc3d', '\ubc3e', 
    '\ubc3f', '\ubc40', '\ubc41', '\ubc42', '\ubc43', '\ubc44', '\ubc45', '\ubc46', 
    '\ubc47', '\ubc48', '\ubc49', '\ubc4a', '\ubc4b', '\ubc4c', '\ubc4d', '\ubc4e', 
    '\ubc4f', '\ubc50', '\ubc51', '\ubc52', '\ubc53', '\ubc54', '\ubc55', '\ubc56', 
    '\ubc57', '\ubc58', '\ubc59', '\ubc5a', '\ubc5b', '\ubc5c', '\ubc5d', '\ubc5e', 
    '\ubc5f', '\ubc60', '\ubc61', '\ubc62', '\ubc63', '\ubc64', '\ubc65', '\ubc66', 
    '\ubc67', '\ubc68', '\ubc69', '\ubc6a', '\ubc6b', '\ubc6c', '\ubc6d', '\ubc6e', 
    '\ubc6f', '\ubc70', '\ubc71', '\ubc72', '\ubc73', '\ubc74', '\ubc75', '\ubc76', 
    '\ubc77', '\ubc78', '\ubc79', '\ubc7a', '\ubc7b', '\ubc7c', '\ubc7d', '\ubc7e', 
    '\ubc7f', '\ubc80', '\ubc81', '\ubc82', '\ubc83', '\ubc84', '\ubc85', '\ubc86', 
    '\ubc87', '\ubc88', '\ubc89', '\ubc8a', '\ubc8b', '\ubc8c', '\ubc8d', '\ubc8e', 
    '\ubc8f', '\ubc90', '\ubc91', '\ubc92', '\ubc93', '\ubc94', '\ubc95', '\ubc96', 
    '\ubc97', '\ubc98', '\ubc99', '\ubc9a', '\ubc9b', '\ubc9c', '\ubc9d', '\ubc9e', 
    '\ubc9f', '\ubca0', '\ubca1', '\ubca2', '\ubca3', '\ubca4', '\ubca5', '\ubca6', 
    '\ubca7', '\ubca8', '\ubca9', '\ubcaa', '\ubcab', '\ubcac', '\ubcad', '\ubcae', 
    '\ubcaf', '\ubcb0', '\ubcb1', '\ubcb2', '\ubcb3', '\ubcb4', '\ubcb5', '\ubcb6', 
    '\ubcb7', '\ubcb8', '\ubcb9', '\ubcba', '\ubcbb', '\ubcbc', '\ubcbd', '\ubcbe', 
    '\ubcbf', '\ubcc0', '\ubcc1', '\ubcc2', '\ubcc3', '\ubcc4', '\ubcc5', '\ubcc6', 
    '\ubcc7', '\ubcc8', '\ubcc9', '\ubcca', '\ubccb', '\ubccc', '\ubccd', '\ubcce', 
    '\ubccf', '\ubcd0', '\ubcd1', '\ubcd2', '\ubcd3', '\ubcd4', '\ubcd5', '\ubcd6', 
    '\ubcd7', '\ubcd8', '\ubcd9', '\ubcda', '\ubcdb', '\ubcdc', '\ubcdd', '\ubcde', 
    '\ubcdf', '\ubce0', '\ubce1', '\ubce2', '\ubce3', '\ubce4', '\ubce5', '\ubce6', 
    '\ubce7', '\ubce8', '\ubce9', '\ubcea', '\ubceb', '\ubcec', '\ubced', '\ubcee', 
    '\ubcef', '\ubcf0', '\ubcf1', '\ubcf2', '\ubcf3', '\ubcf4', '\ubcf5', '\ubcf6', 
    '\ubcf7', '\ubcf8', '\ubcf9', '\ubcfa', '\ubcfb', '\ubcfc', '\ubcfd', '\ubcfe', 
    '\ubcff', '\ubd00', '\ubd01', '\ubd02', '\ubd03', '\ubd04', '\ubd05', '\ubd06', 
    '\ubd07', '\ubd08', '\ubd09', '\ubd0a', '\ubd0b', '\ubd0c', '\ubd0d', '\ubd0e', 
    '\ubd0f', '\ubd10', '\ubd11', '\ubd12', '\ubd13', '\ubd14', '\ubd15', '\ubd16', 
    '\ubd17', '\ubd18', '\ubd19', '\ubd1a', '\ubd1b', '\ubd1c', '\ubd1d', '\ubd1e', 
    '\ubd1f', '\ubd20', '\ubd21', '\ubd22', '\ubd23', '\ubd24', '\ubd25', '\ubd26', 
    '\ubd27', '\ubd28', '\ubd29', '\ubd2a', '\ubd2b', '\ubd2c', '\ubd2d', '\ubd2e', 
    '\ubd2f', '\ubd30', '\ubd31', '\ubd32', '\ubd33', '\ubd34', '\ubd35', '\ubd36', 
    '\ubd37', '\ubd38', '\ubd39', '\ubd3a', '\ubd3b', '\ubd3c', '\ubd3d', '\ubd3e', 
    '\ubd3f', '\ubd40', '\ubd41', '\ubd42', '\ubd43', '\ubd44', '\ubd45', '\ubd46', 
    '\ubd47', '\ubd48', '\ubd49', '\ubd4a', '\ubd4b', '\ubd4c', '\ubd4d', '\ubd4e', 
    '\ubd4f', '\ubd50', '\ubd51', '\ubd52', '\ubd53', '\ubd54', '\ubd55', '\ubd56', 
    '\ubd57', '\ubd58', '\ubd59', '\ubd5a', '\ubd5b', '\ubd5c', '\ubd5d', '\ubd5e', 
    '\ubd5f', '\ubd60', '\ubd61', '\ubd62', '\ubd63', '\ubd64', '\ubd65', '\ubd66', 
    '\ubd67', '\ubd68', '\ubd69', '\ubd6a', '\ubd6b', '\ubd6c', '\ubd6d', '\ubd6e', 
    '\ubd6f', '\ubd70', '\ubd71', '\ubd72', '\ubd73', '\ubd74', '\ubd75', '\ubd76', 
    '\ubd77', '\ubd78', '\ubd79', '\ubd7a', '\ubd7b', '\ubd7c', '\ubd7d', '\ubd7e', 
    '\ubd7f', '\ubd80', '\ubd81', '\ubd82', '\ubd83', '\ubd84', '\ubd85', '\ubd86', 
    '\ubd87', '\ubd88', '\ubd89', '\ubd8a', '\ubd8b', '\ubd8c', '\ubd8d', '\ubd8e', 
    '\ubd8f', '\ubd90', '\ubd91', '\ubd92', '\ubd93', '\ubd94', '\ubd95', '\ubd96', 
    '\ubd97', '\ubd98', '\ubd99', '\ubd9a', '\ubd9b', '\ubd9c', '\ubd9d', '\ubd9e', 
    '\ubd9f', '\ubda0', '\ubda1', '\ubda2', '\ubda3', '\ubda4', '\ubda5', '\ubda6', 
    '\ubda7', '\ubda8', '\ubda9', '\ubdaa', '\ubdab', '\ubdac', '\ubdad', '\ubdae', 
    '\ubdaf', '\ubdb0', '\ubdb1', '\ubdb2', '\ubdb3', '\ubdb4', '\ubdb5', '\ubdb6', 
    '\ubdb7', '\ubdb8', '\ubdb9', '\ubdba', '\ubdbb', '\ubdbc', '\ubdbd', '\ubdbe', 
    '\ubdbf', '\ubdc0', '\ubdc1', '\ubdc2', '\ubdc3', '\ubdc4', '\ubdc5', '\ubdc6', 
    '\ubdc7', '\ubdc8', '\ubdc9', '\ubdca', '\ubdcb', '\ubdcc', '\ubdcd', '\ubdce', 
    '\ubdcf', '\ubdd0', '\ubdd1', '\ubdd2', '\ubdd3', '\ubdd4', '\ubdd5', '\ubdd6', 
    '\ubdd7', '\ubdd8', '\ubdd9', '\ubdda', '\ubddb', '\ubddc', '\ubddd', '\ubdde', 
    '\ubddf', '\ubde0', '\ubde1', '\ubde2', '\ubde3', '\ubde4', '\ubde5', '\ubde6', 
    '\ubde7', '\ubde8', '\ubde9', '\ubdea', '\ubdeb', '\ubdec', '\ubded', '\ubdee', 
    '\ubdef', '\ubdf0', '\ubdf1', '\ubdf2', '\ubdf3', '\ubdf4', '\ubdf5', '\ubdf6', 
    '\ubdf7', '\ubdf8', '\ubdf9', '\ubdfa', '\ubdfb', '\ubdfc', '\ubdfd', '\ubdfe', 
    '\ubdff', '\ube00', '\ube01', '\ube02', '\ube03', '\ube04', '\ube05', '\ube06', 
    '\ube07', '\ube08', '\ube09', '\ube0a', '\ube0b', '\ube0c', '\ube0d', '\ube0e', 
    '\ube0f', '\ube10', '\ube11', '\ube12', '\ube13', '\ube14', '\ube15', '\ube16', 
    '\ube17', '\ube18', '\ube19', '\ube1a', '\ube1b', '\ube1c', '\ube1d', '\ube1e', 
    '\ube1f', '\ube20', '\ube21', '\ube22', '\ube23', '\ube24', '\ube25', '\ube26', 
    '\ube27', '\ube28', '\ube29', '\ube2a', '\ube2b', '\ube2c', '\ube2d', '\ube2e', 
    '\ube2f', '\ube30', '\ube31', '\ube32', '\ube33', '\ube34', '\ube35', '\ube36', 
    '\ube37', '\ube38', '\ube39', '\ube3a', '\ube3b', '\ube3c', '\ube3d', '\ube3e', 
    '\ube3f', '\ube40', '\ube41', '\ube42', '\ube43', '\ube44', '\ube45', '\ube46', 
    '\ube47', '\ube48', '\ube49', '\ube4a', '\ube4b', '\ube4c', '\ube4d', '\ube4e', 
    '\ube4f', '\ube50', '\ube51', '\ube52', '\ube53', '\ube54', '\ube55', '\ube56', 
    '\ube57', '\ube58', '\ube59', '\ube5a', '\ube5b', '\ube5c', '\ube5d', '\ube5e', 
    '\ube5f', '\ube60', '\ube61', '\ube62', '\ube63', '\ube64', '\ube65', '\ube66', 
    '\ube67', '\ube68', '\ube69', '\ube6a', '\ube6b', '\ube6c', '\ube6d', '\ube6e', 
    '\ube6f', '\ube70', '\ube71', '\ube72', '\ube73', '\ube74', '\ube75', '\ube76', 
    '\ube77', '\ube78', '\ube79', '\ube7a', '\ube7b', '\ube7c', '\ube7d', '\ube7e', 
    '\ube7f', '\ube80', '\ube81', '\ube82', '\ube83', '\ube84', '\ube85', '\ube86', 
    '\ube87', '\ube88', '\ube89', '\ube8a', '\ube8b', '\ube8c', '\ube8d', '\ube8e', 
    '\ube8f', '\ube90', '\ube91', '\ube92', '\ube93', '\ube94', '\ube95', '\ube96', 
    '\ube97', '\ube98', '\ube99', '\ube9a', '\ube9b', '\ube9c', '\ube9d', '\ube9e', 
    '\ube9f', '\ubea0', '\ubea1', '\ubea2', '\ubea3', '\ubea4', '\ubea5', '\ubea6', 
    '\ubea7', '\ubea8', '\ubea9', '\ubeaa', '\ubeab', '\ubeac', '\ubead', '\ubeae', 
    '\ubeaf', '\ubeb0', '\ubeb1', '\ubeb2', '\ubeb3', '\ubeb4', '\ubeb5', '\ubeb6', 
    '\ubeb7', '\ubeb8', '\ubeb9', '\ubeba', '\ubebb', '\ubebc', '\ubebd', '\ubebe', 
    '\ubebf', '\ubec0', '\ubec1', '\ubec2', '\ubec3', '\ubec4', '\ubec5', '\ubec6', 
    '\ubec7', '\ubec8', '\ubec9', '\ubeca', '\ubecb', '\ubecc', '\ubecd', '\ubece', 
    '\ubecf', '\ubed0', '\ubed1', '\ubed2', '\ubed3', '\ubed4', '\ubed5', '\ubed6', 
    '\ubed7', '\ubed8', '\ubed9', '\ubeda', '\ubedb', '\ubedc', '\ubedd', '\ubede', 
    '\ubedf', '\ubee0', '\ubee1', '\ubee2', '\ubee3', '\ubee4', '\ubee5', '\ubee6', 
    '\ubee7', '\ubee8', '\ubee9', '\ubeea', '\ubeeb', '\ubeec', '\ubeed', '\ubeee', 
    '\ubeef', '\ubef0', '\ubef1', '\ubef2', '\ubef3', '\ubef4', '\ubef5', '\ubef6', 
    '\ubef7', '\ubef8', '\ubef9', '\ubefa', '\ubefb', '\ubefc', '\ubefd', '\ubefe', 
    '\ubeff', '\ubf00', '\ubf01', '\ubf02', '\ubf03', '\ubf04', '\ubf05', '\ubf06', 
    '\ubf07', '\ubf08', '\ubf09', '\ubf0a', '\ubf0b', '\ubf0c', '\ubf0d', '\ubf0e', 
    '\ubf0f', '\ubf10', '\ubf11', '\ubf12', '\ubf13', '\ubf14', '\ubf15', '\ubf16', 
    '\ubf17', '\ubf18', '\ubf19', '\ubf1a', '\ubf1b', '\ubf1c', '\ubf1d', '\ubf1e', 
    '\ubf1f', '\ubf20', '\ubf21', '\ubf22', '\ubf23', '\ubf24', '\ubf25', '\ubf26', 
    '\ubf27', '\ubf28', '\ubf29', '\ubf2a', '\ubf2b', '\ubf2c', '\ubf2d', '\ubf2e', 
    '\ubf2f', '\ubf30', '\ubf31', '\ubf32', '\ubf33', '\ubf34', '\ubf35', '\ubf36', 
    '\ubf37', '\ubf38', '\ubf39', '\ubf3a', '\ubf3b', '\ubf3c', '\ubf3d', '\ubf3e', 
    '\ubf3f', '\ubf40', '\ubf41', '\ubf42', '\ubf43', '\ubf44', '\ubf45', '\ubf46', 
    '\ubf47', '\ubf48', '\ubf49', '\ubf4a', '\ubf4b', '\ubf4c', '\ubf4d', '\ubf4e', 
    '\ubf4f', '\ubf50', '\ubf51', '\ubf52', '\ubf53', '\ubf54', '\ubf55', '\ubf56', 
    '\ubf57', '\ubf58', '\ubf59', '\ubf5a', '\ubf5b', '\ubf5c', '\ubf5d', '\ubf5e', 
    '\ubf5f', '\ubf60', '\ubf61', '\ubf62', '\ubf63', '\ubf64', '\ubf65', '\ubf66', 
    '\ubf67', '\ubf68', '\ubf69', '\ubf6a', '\ubf6b', '\ubf6c', '\ubf6d', '\ubf6e', 
    '\ubf6f', '\ubf70', '\ubf71', '\ubf72', '\ubf73', '\ubf74', '\ubf75', '\ubf76', 
    '\ubf77', '\ubf78', '\ubf79', '\ubf7a', '\ubf7b', '\ubf7c', '\ubf7d', '\ubf7e', 
    '\ubf7f', '\ubf80', '\ubf81', '\ubf82', '\ubf83', '\ubf84', '\ubf85', '\ubf86', 
    '\ubf87', '\ubf88', '\ubf89', '\ubf8a', '\ubf8b', '\ubf8c', '\ubf8d', '\ubf8e', 
    '\ubf8f', '\ubf90', '\ubf91', '\ubf92', '\ubf93', '\ubf94', '\ubf95', '\ubf96', 
    '\ubf97', '\ubf98', '\ubf99', '\ubf9a', '\ubf9b', '\ubf9c', '\ubf9d', '\ubf9e', 
    '\ubf9f', '\ubfa0', '\ubfa1', '\ubfa2', '\ubfa3', '\ubfa4', '\ubfa5', '\ubfa6', 
    '\ubfa7', '\ubfa8', '\ubfa9', '\ubfaa', '\ubfab', '\ubfac', '\ubfad', '\ubfae', 
    '\ubfaf', '\ubfb0', '\ubfb1', '\ubfb2', '\ubfb3', '\ubfb4', '\ubfb5', '\ubfb6', 
    '\ubfb7', '\ubfb8', '\ubfb9', '\ubfba', '\ubfbb', '\ubfbc', '\ubfbd', '\ubfbe', 
    '\ubfbf', '\ubfc0', '\ubfc1', '\ubfc2', '\ubfc3', '\ubfc4', '\ubfc5', '\ubfc6', 
    '\ubfc7', '\ubfc8', '\ubfc9', '\ubfca', '\ubfcb', '\ubfcc', '\ubfcd', '\ubfce', 
    '\ubfcf', '\ubfd0', '\ubfd1', '\ubfd2', '\ubfd3', '\ubfd4', '\ubfd5', '\ubfd6', 
    '\ubfd7', '\ubfd8', '\ubfd9', '\ubfda', '\ubfdb', '\ubfdc', '\ubfdd', '\ubfde', 
    '\ubfdf', '\ubfe0', '\ubfe1', '\ubfe2', '\ubfe3', '\ubfe4', '\ubfe5', '\ubfe6', 
    '\ubfe7', '\ubfe8', '\ubfe9', '\ubfea', '\ubfeb', '\ubfec', '\ubfed', '\ubfee', 
    '\ubfef', '\ubff0', '\ubff1', '\ubff2', '\ubff3', '\ubff4', '\ubff5', '\ubff6', 
    '\ubff7', '\ubff8', '\ubff9', '\ubffa', '\ubffb', '\ubffc', '\ubffd', '\ubffe', 
    '\ubfff', '\uc000', '\uc001', '\uc002', '\uc003', '\uc004', '\uc005', '\uc006', 
    '\uc007', '\uc008', '\uc009', '\uc00a', '\uc00b', '\uc00c', '\uc00d', '\uc00e', 
    '\uc00f', '\uc010', '\uc011', '\uc012', '\uc013', '\uc014', '\uc015', '\uc016', 
    '\uc017', '\uc018', '\uc019', '\uc01a', '\uc01b', '\uc01c', '\uc01d', '\uc01e', 
    '\uc01f', '\uc020', '\uc021', '\uc022', '\uc023', '\uc024', '\uc025', '\uc026', 
    '\uc027', '\uc028', '\uc029', '\uc02a', '\uc02b', '\uc02c', '\uc02d', '\uc02e', 
    '\uc02f', '\uc030', '\uc031', '\uc032', '\uc033', '\uc034', '\uc035', '\uc036', 
    '\uc037', '\uc038', '\uc039', '\uc03a', '\uc03b', '\uc03c', '\uc03d', '\uc03e', 
    '\uc03f', '\uc040', '\uc041', '\uc042', '\uc043', '\uc044', '\uc045', '\uc046', 
    '\uc047', '\uc048', '\uc049', '\uc04a', '\uc04b', '\uc04c', '\uc04d', '\uc04e', 
    '\uc04f', '\uc050', '\uc051', '\uc052', '\uc053', '\uc054', '\uc055', '\uc056', 
    '\uc057', '\uc058', '\uc059', '\uc05a', '\uc05b', '\uc05c', '\uc05d', '\uc05e', 
    '\uc05f', '\uc060', '\uc061', '\uc062', '\uc063', '\uc064', '\uc065', '\uc066', 
    '\uc067', '\uc068', '\uc069', '\uc06a', '\uc06b', '\uc06c', '\uc06d', '\uc06e', 
    '\uc06f', '\uc070', '\uc071', '\uc072', '\uc073', '\uc074', '\uc075', '\uc076', 
    '\uc077', '\uc078', '\uc079', '\uc07a', '\uc07b', '\uc07c', '\uc07d', '\uc07e', 
    '\uc07f', '\uc080', '\uc081', '\uc082', '\uc083', '\uc084', '\uc085', '\uc086', 
    '\uc087', '\uc088', '\uc089', '\uc08a', '\uc08b', '\uc08c', '\uc08d', '\uc08e', 
    '\uc08f', '\uc090', '\uc091', '\uc092', '\uc093', '\uc094', '\uc095', '\uc096', 
    '\uc097', '\uc098', '\uc099', '\uc09a', '\uc09b', '\uc09c', '\uc09d', '\uc09e', 
    '\uc09f', '\uc0a0', '\uc0a1', '\uc0a2', '\uc0a3', '\uc0a4', '\uc0a5', '\uc0a6', 
    '\uc0a7', '\uc0a8', '\uc0a9', '\uc0aa', '\uc0ab', '\uc0ac', '\uc0ad', '\uc0ae', 
    '\uc0af', '\uc0b0', '\uc0b1', '\uc0b2', '\uc0b3', '\uc0b4', '\uc0b5', '\uc0b6', 
    '\uc0b7', '\uc0b8', '\uc0b9', '\uc0ba', '\uc0bb', '\uc0bc', '\uc0bd', '\uc0be', 
    '\uc0bf', '\uc0c0', '\uc0c1', '\uc0c2', '\uc0c3', '\uc0c4', '\uc0c5', '\uc0c6', 
    '\uc0c7', '\uc0c8', '\uc0c9', '\uc0ca', '\uc0cb', '\uc0cc', '\uc0cd', '\uc0ce', 
    '\uc0cf', '\uc0d0', '\uc0d1', '\uc0d2', '\uc0d3', '\uc0d4', '\uc0d5', '\uc0d6', 
    '\uc0d7', '\uc0d8', '\uc0d9', '\uc0da', '\uc0db', '\uc0dc', '\uc0dd', '\uc0de', 
    '\uc0df', '\uc0e0', '\uc0e1', '\uc0e2', '\uc0e3', '\uc0e4', '\uc0e5', '\uc0e6', 
    '\uc0e7', '\uc0e8', '\uc0e9', '\uc0ea', '\uc0eb', '\uc0ec', '\uc0ed', '\uc0ee', 
    '\uc0ef', '\uc0f0', '\uc0f1', '\uc0f2', '\uc0f3', '\uc0f4', '\uc0f5', '\uc0f6', 
    '\uc0f7', '\uc0f8', '\uc0f9', '\uc0fa', '\uc0fb', '\uc0fc', '\uc0fd', '\uc0fe', 
    '\uc0ff', '\uc100', '\uc101', '\uc102', '\uc103', '\uc104', '\uc105', '\uc106', 
    '\uc107', '\uc108', '\uc109', '\uc10a', '\uc10b', '\uc10c', '\uc10d', '\uc10e', 
    '\uc10f', '\uc110', '\uc111', '\uc112', '\uc113', '\uc114', '\uc115', '\uc116', 
    '\uc117', '\uc118', '\uc119', '\uc11a', '\uc11b', '\uc11c', '\uc11d', '\uc11e', 
    '\uc11f', '\uc120', '\uc121', '\uc122', '\uc123', '\uc124', '\uc125', '\uc126', 
    '\uc127', '\uc128', '\uc129', '\uc12a', '\uc12b', '\uc12c', '\uc12d', '\uc12e', 
    '\uc12f', '\uc130', '\uc131', '\uc132', '\uc133', '\uc134', '\uc135', '\uc136', 
    '\uc137', '\uc138', '\uc139', '\uc13a', '\uc13b', '\uc13c', '\uc13d', '\uc13e', 
    '\uc13f', '\uc140', '\uc141', '\uc142', '\uc143', '\uc144', '\uc145', '\uc146', 
    '\uc147', '\uc148', '\uc149', '\uc14a', '\uc14b', '\uc14c', '\uc14d', '\uc14e', 
    '\uc14f', '\uc150', '\uc151', '\uc152', '\uc153', '\uc154', '\uc155', '\uc156', 
    '\uc157', '\uc158', '\uc159', '\uc15a', '\uc15b', '\uc15c', '\uc15d', '\uc15e', 
    '\uc15f', '\uc160', '\uc161', '\uc162', '\uc163', '\uc164', '\uc165', '\uc166', 
    '\uc167', '\uc168', '\uc169', '\uc16a', '\uc16b', '\uc16c', '\uc16d', '\uc16e', 
    '\uc16f', '\uc170', '\uc171', '\uc172', '\uc173', '\uc174', '\uc175', '\uc176', 
    '\uc177', '\uc178', '\uc179', '\uc17a', '\uc17b', '\uc17c', '\uc17d', '\uc17e', 
    '\uc17f', '\uc180', '\uc181', '\uc182', '\uc183', '\uc184', '\uc185', '\uc186', 
    '\uc187', '\uc188', '\uc189', '\uc18a', '\uc18b', '\uc18c', '\uc18d', '\uc18e', 
    '\uc18f', '\uc190', '\uc191', '\uc192', '\uc193', '\uc194', '\uc195', '\uc196', 
    '\uc197', '\uc198', '\uc199', '\uc19a', '\uc19b', '\uc19c', '\uc19d', '\uc19e', 
    '\uc19f', '\uc1a0', '\uc1a1', '\uc1a2', '\uc1a3', '\uc1a4', '\uc1a5', '\uc1a6', 
    '\uc1a7', '\uc1a8', '\uc1a9', '\uc1aa', '\uc1ab', '\uc1ac', '\uc1ad', '\uc1ae', 
    '\uc1af', '\uc1b0', '\uc1b1', '\uc1b2', '\uc1b3', '\uc1b4', '\uc1b5', '\uc1b6', 
    '\uc1b7', '\uc1b8', '\uc1b9', '\uc1ba', '\uc1bb', '\uc1bc', '\uc1bd', '\uc1be', 
    '\uc1bf', '\uc1c0', '\uc1c1', '\uc1c2', '\uc1c3', '\uc1c4', '\uc1c5', '\uc1c6', 
    '\uc1c7', '\uc1c8', '\uc1c9', '\uc1ca', '\uc1cb', '\uc1cc', '\uc1cd', '\uc1ce', 
    '\uc1cf', '\uc1d0', '\uc1d1', '\uc1d2', '\uc1d3', '\uc1d4', '\uc1d5', '\uc1d6', 
    '\uc1d7', '\uc1d8', '\uc1d9', '\uc1da', '\uc1db', '\uc1dc', '\uc1dd', '\uc1de', 
    '\uc1df', '\uc1e0', '\uc1e1', '\uc1e2', '\uc1e3', '\uc1e4', '\uc1e5', '\uc1e6', 
    '\uc1e7', '\uc1e8', '\uc1e9', '\uc1ea', '\uc1eb', '\uc1ec', '\uc1ed', '\uc1ee', 
    '\uc1ef', '\uc1f0', '\uc1f1', '\uc1f2', '\uc1f3', '\uc1f4', '\uc1f5', '\uc1f6', 
    '\uc1f7', '\uc1f8', '\uc1f9', '\uc1fa', '\uc1fb', '\uc1fc', '\uc1fd', '\uc1fe', 
    '\uc1ff', '\uc200', '\uc201', '\uc202', '\uc203', '\uc204', '\uc205', '\uc206', 
    '\uc207', '\uc208', '\uc209', '\uc20a', '\uc20b', '\uc20c', '\uc20d', '\uc20e', 
    '\uc20f', '\uc210', '\uc211', '\uc212', '\uc213', '\uc214', '\uc215', '\uc216', 
    '\uc217', '\uc218', '\uc219', '\uc21a', '\uc21b', '\uc21c', '\uc21d', '\uc21e', 
    '\uc21f', '\uc220', '\uc221', '\uc222', '\uc223', '\uc224', '\uc225', '\uc226', 
    '\uc227', '\uc228', '\uc229', '\uc22a', '\uc22b', '\uc22c', '\uc22d', '\uc22e', 
    '\uc22f', '\uc230', '\uc231', '\uc232', '\uc233', '\uc234', '\uc235', '\uc236', 
    '\uc237', '\uc238', '\uc239', '\uc23a', '\uc23b', '\uc23c', '\uc23d', '\uc23e', 
    '\uc23f', '\uc240', '\uc241', '\uc242', '\uc243', '\uc244', '\uc245', '\uc246', 
    '\uc247', '\uc248', '\uc249', '\uc24a', '\uc24b', '\uc24c', '\uc24d', '\uc24e', 
    '\uc24f', '\uc250', '\uc251', '\uc252', '\uc253', '\uc254', '\uc255', '\uc256', 
    '\uc257', '\uc258', '\uc259', '\uc25a', '\uc25b', '\uc25c', '\uc25d', '\uc25e', 
    '\uc25f', '\uc260', '\uc261', '\uc262', '\uc263', '\uc264', '\uc265', '\uc266', 
    '\uc267', '\uc268', '\uc269', '\uc26a', '\uc26b', '\uc26c', '\uc26d', '\uc26e', 
    '\uc26f', '\uc270', '\uc271', '\uc272', '\uc273', '\uc274', '\uc275', '\uc276', 
    '\uc277', '\uc278', '\uc279', '\uc27a', '\uc27b', '\uc27c', '\uc27d', '\uc27e', 
    '\uc27f', '\uc280', '\uc281', '\uc282', '\uc283', '\uc284', '\uc285', '\uc286', 
    '\uc287', '\uc288', '\uc289', '\uc28a', '\uc28b', '\uc28c', '\uc28d', '\uc28e', 
    '\uc28f', '\uc290', '\uc291', '\uc292', '\uc293', '\uc294', '\uc295', '\uc296', 
    '\uc297', '\uc298', '\uc299', '\uc29a', '\uc29b', '\uc29c', '\uc29d', '\uc29e', 
    '\uc29f', '\uc2a0', '\uc2a1', '\uc2a2', '\uc2a3', '\uc2a4', '\uc2a5', '\uc2a6', 
    '\uc2a7', '\uc2a8', '\uc2a9', '\uc2aa', '\uc2ab', '\uc2ac', '\uc2ad', '\uc2ae', 
    '\uc2af', '\uc2b0', '\uc2b1', '\uc2b2', '\uc2b3', '\uc2b4', '\uc2b5', '\uc2b6', 
    '\uc2b7', '\uc2b8', '\uc2b9', '\uc2ba', '\uc2bb', '\uc2bc', '\uc2bd', '\uc2be', 
    '\uc2bf', '\uc2c0', '\uc2c1', '\uc2c2', '\uc2c3', '\uc2c4', '\uc2c5', '\uc2c6', 
    '\uc2c7', '\uc2c8', '\uc2c9', '\uc2ca', '\uc2cb', '\uc2cc', '\uc2cd', '\uc2ce', 
    '\uc2cf', '\uc2d0', '\uc2d1', '\uc2d2', '\uc2d3', '\uc2d4', '\uc2d5', '\uc2d6', 
    '\uc2d7', '\uc2d8', '\uc2d9', '\uc2da', '\uc2db', '\uc2dc', '\uc2dd', '\uc2de', 
    '\uc2df', '\uc2e0', '\uc2e1', '\uc2e2', '\uc2e3', '\uc2e4', '\uc2e5', '\uc2e6', 
    '\uc2e7', '\uc2e8', '\uc2e9', '\uc2ea', '\uc2eb', '\uc2ec', '\uc2ed', '\uc2ee', 
    '\uc2ef', '\uc2f0', '\uc2f1', '\uc2f2', '\uc2f3', '\uc2f4', '\uc2f5', '\uc2f6', 
    '\uc2f7', '\uc2f8', '\uc2f9', '\uc2fa', '\uc2fb', '\uc2fc', '\uc2fd', '\uc2fe', 
    '\uc2ff', '\uc300', '\uc301', '\uc302', '\uc303', '\uc304', '\uc305', '\uc306', 
    '\uc307', '\uc308', '\uc309', '\uc30a', '\uc30b', '\uc30c', '\uc30d', '\uc30e', 
    '\uc30f', '\uc310', '\uc311', '\uc312', '\uc313', '\uc314', '\uc315', '\uc316', 
    '\uc317', '\uc318', '\uc319', '\uc31a', '\uc31b', '\uc31c', '\uc31d', '\uc31e', 
    '\uc31f', '\uc320', '\uc321', '\uc322', '\uc323', '\uc324', '\uc325', '\uc326', 
    '\uc327', '\uc328', '\uc329', '\uc32a', '\uc32b', '\uc32c', '\uc32d', '\uc32e', 
    '\uc32f', '\uc330', '\uc331', '\uc332', '\uc333', '\uc334', '\uc335', '\uc336', 
    '\uc337', '\uc338', '\uc339', '\uc33a', '\uc33b', '\uc33c', '\uc33d', '\uc33e', 
    '\uc33f', '\uc340', '\uc341', '\uc342', '\uc343', '\uc344', '\uc345', '\uc346', 
    '\uc347', '\uc348', '\uc349', '\uc34a', '\uc34b', '\uc34c', '\uc34d', '\uc34e', 
    '\uc34f', '\uc350', '\uc351', '\uc352', '\uc353', '\uc354', '\uc355', '\uc356', 
    '\uc357', '\uc358', '\uc359', '\uc35a', '\uc35b', '\uc35c', '\uc35d', '\uc35e', 
    '\uc35f', '\uc360', '\uc361', '\uc362', '\uc363', '\uc364', '\uc365', '\uc366', 
    '\uc367', '\uc368', '\uc369', '\uc36a', '\uc36b', '\uc36c', '\uc36d', '\uc36e', 
    '\uc36f', '\uc370', '\uc371', '\uc372', '\uc373', '\uc374', '\uc375', '\uc376', 
    '\uc377', '\uc378', '\uc379', '\uc37a', '\uc37b', '\uc37c', '\uc37d', '\uc37e', 
    '\uc37f', '\uc380', '\uc381', '\uc382', '\uc383', '\uc384', '\uc385', '\uc386', 
    '\uc387', '\uc388', '\uc389', '\uc38a', '\uc38b', '\uc38c', '\uc38d', '\uc38e', 
    '\uc38f', '\uc390', '\uc391', '\uc392', '\uc393', '\uc394', '\uc395', '\uc396', 
    '\uc397', '\uc398', '\uc399', '\uc39a', '\uc39b', '\uc39c', '\uc39d', '\uc39e', 
    '\uc39f', '\uc3a0', '\uc3a1', '\uc3a2', '\uc3a3', '\uc3a4', '\uc3a5', '\uc3a6', 
    '\uc3a7', '\uc3a8', '\uc3a9', '\uc3aa', '\uc3ab', '\uc3ac', '\uc3ad', '\uc3ae', 
    '\uc3af', '\uc3b0', '\uc3b1', '\uc3b2', '\uc3b3', '\uc3b4', '\uc3b5', '\uc3b6', 
    '\uc3b7', '\uc3b8', '\uc3b9', '\uc3ba', '\uc3bb', '\uc3bc', '\uc3bd', '\uc3be', 
    '\uc3bf', '\uc3c0', '\uc3c1', '\uc3c2', '\uc3c3', '\uc3c4', '\uc3c5', '\uc3c6', 
    '\uc3c7', '\uc3c8', '\uc3c9', '\uc3ca', '\uc3cb', '\uc3cc', '\uc3cd', '\uc3ce', 
    '\uc3cf', '\uc3d0', '\uc3d1', '\uc3d2', '\uc3d3', '\uc3d4', '\uc3d5', '\uc3d6', 
    '\uc3d7', '\uc3d8', '\uc3d9', '\uc3da', '\uc3db', '\uc3dc', '\uc3dd', '\uc3de', 
    '\uc3df', '\uc3e0', '\uc3e1', '\uc3e2', '\uc3e3', '\uc3e4', '\uc3e5', '\uc3e6', 
    '\uc3e7', '\uc3e8', '\uc3e9', '\uc3ea', '\uc3eb', '\uc3ec', '\uc3ed', '\uc3ee', 
    '\uc3ef', '\uc3f0', '\uc3f1', '\uc3f2', '\uc3f3', '\uc3f4', '\uc3f5', '\uc3f6', 
    '\uc3f7', '\uc3f8', '\uc3f9', '\uc3fa', '\uc3fb', '\uc3fc', '\uc3fd', '\uc3fe', 
    '\uc3ff', '\uc400', '\uc401', '\uc402', '\uc403', '\uc404', '\uc405', '\uc406', 
    '\uc407', '\uc408', '\uc409', '\uc40a', '\uc40b', '\uc40c', '\uc40d', '\uc40e', 
    '\uc40f', '\uc410', '\uc411', '\uc412', '\uc413', '\uc414', '\uc415', '\uc416', 
    '\uc417', '\uc418', '\uc419', '\uc41a', '\uc41b', '\uc41c', '\uc41d', '\uc41e', 
    '\uc41f', '\uc420', '\uc421', '\uc422', '\uc423', '\uc424', '\uc425', '\uc426', 
    '\uc427', '\uc428', '\uc429', '\uc42a', '\uc42b', '\uc42c', '\uc42d', '\uc42e', 
    '\uc42f', '\uc430', '\uc431', '\uc432', '\uc433', '\uc434', '\uc435', '\uc436', 
    '\uc437', '\uc438', '\uc439', '\uc43a', '\uc43b', '\uc43c', '\uc43d', '\uc43e', 
    '\uc43f', '\uc440', '\uc441', '\uc442', '\uc443', '\uc444', '\uc445', '\uc446', 
    '\uc447', '\uc448', '\uc449', '\uc44a', '\uc44b', '\uc44c', '\uc44d', '\uc44e', 
    '\uc44f', '\uc450', '\uc451', '\uc452', '\uc453', '\uc454', '\uc455', '\uc456', 
    '\uc457', '\uc458', '\uc459', '\uc45a', '\uc45b', '\uc45c', '\uc45d', '\uc45e', 
    '\uc45f', '\uc460', '\uc461', '\uc462', '\uc463', '\uc464', '\uc465', '\uc466', 
    '\uc467', '\uc468', '\uc469', '\uc46a', '\uc46b', '\uc46c', '\uc46d', '\uc46e', 
    '\uc46f', '\uc470', '\uc471', '\uc472', '\uc473', '\uc474', '\uc475', '\uc476', 
    '\uc477', '\uc478', '\uc479', '\uc47a', '\uc47b', '\uc47c', '\uc47d', '\uc47e', 
    '\uc47f', '\uc480', '\uc481', '\uc482', '\uc483', '\uc484', '\uc485', '\uc486', 
    '\uc487', '\uc488', '\uc489', '\uc48a', '\uc48b', '\uc48c', '\uc48d', '\uc48e', 
    '\uc48f', '\uc490', '\uc491', '\uc492', '\uc493', '\uc494', '\uc495', '\uc496', 
    '\uc497', '\uc498', '\uc499', '\uc49a', '\uc49b', '\uc49c', '\uc49d', '\uc49e', 
    '\uc49f', '\uc4a0', '\uc4a1', '\uc4a2', '\uc4a3', '\uc4a4', '\uc4a5', '\uc4a6', 
    '\uc4a7', '\uc4a8', '\uc4a9', '\uc4aa', '\uc4ab', '\uc4ac', '\uc4ad', '\uc4ae', 
    '\uc4af', '\uc4b0', '\uc4b1', '\uc4b2', '\uc4b3', '\uc4b4', '\uc4b5', '\uc4b6', 
    '\uc4b7', '\uc4b8', '\uc4b9', '\uc4ba', '\uc4bb', '\uc4bc', '\uc4bd', '\uc4be', 
    '\uc4bf', '\uc4c0', '\uc4c1', '\uc4c2', '\uc4c3', '\uc4c4', '\uc4c5', '\uc4c6', 
    '\uc4c7', '\uc4c8', '\uc4c9', '\uc4ca', '\uc4cb', '\uc4cc', '\uc4cd', '\uc4ce', 
    '\uc4cf', '\uc4d0', '\uc4d1', '\uc4d2', '\uc4d3', '\uc4d4', '\uc4d5', '\uc4d6', 
    '\uc4d7', '\uc4d8', '\uc4d9', '\uc4da', '\uc4db', '\uc4dc', '\uc4dd', '\uc4de', 
    '\uc4df', '\uc4e0', '\uc4e1', '\uc4e2', '\uc4e3', '\uc4e4', '\uc4e5', '\uc4e6', 
    '\uc4e7', '\uc4e8', '\uc4e9', '\uc4ea', '\uc4eb', '\uc4ec', '\uc4ed', '\uc4ee', 
    '\uc4ef', '\uc4f0', '\uc4f1', '\uc4f2', '\uc4f3', '\uc4f4', '\uc4f5', '\uc4f6', 
    '\uc4f7', '\uc4f8', '\uc4f9', '\uc4fa', '\uc4fb', '\uc4fc', '\uc4fd', '\uc4fe', 
    '\uc4ff', '\uc500', '\uc501', '\uc502', '\uc503', '\uc504', '\uc505', '\uc506', 
    '\uc507', '\uc508', '\uc509', '\uc50a', '\uc50b', '\uc50c', '\uc50d', '\uc50e', 
    '\uc50f', '\uc510', '\uc511', '\uc512', '\uc513', '\uc514', '\uc515', '\uc516', 
    '\uc517', '\uc518', '\uc519', '\uc51a', '\uc51b', '\uc51c', '\uc51d', '\uc51e', 
    '\uc51f', '\uc520', '\uc521', '\uc522', '\uc523', '\uc524', '\uc525', '\uc526', 
    '\uc527', '\uc528', '\uc529', '\uc52a', '\uc52b', '\uc52c', '\uc52d', '\uc52e', 
    '\uc52f', '\uc530', '\uc531', '\uc532', '\uc533', '\uc534', '\uc535', '\uc536', 
    '\uc537', '\uc538', '\uc539', '\uc53a', '\uc53b', '\uc53c', '\uc53d', '\uc53e', 
    '\uc53f', '\uc540', '\uc541', '\uc542', '\uc543', '\uc544', '\uc545', '\uc546', 
    '\uc547', '\uc548', '\uc549', '\uc54a', '\uc54b', '\uc54c', '\uc54d', '\uc54e', 
    '\uc54f', '\uc550', '\uc551', '\uc552', '\uc553', '\uc554', '\uc555', '\uc556', 
    '\uc557', '\uc558', '\uc559', '\uc55a', '\uc55b', '\uc55c', '\uc55d', '\uc55e', 
    '\uc55f', '\uc560', '\uc561', '\uc562', '\uc563', '\uc564', '\uc565', '\uc566', 
    '\uc567', '\uc568', '\uc569', '\uc56a', '\uc56b', '\uc56c', '\uc56d', '\uc56e', 
    '\uc56f', '\uc570', '\uc571', '\uc572', '\uc573', '\uc574', '\uc575', '\uc576', 
    '\uc577', '\uc578', '\uc579', '\uc57a', '\uc57b', '\uc57c', '\uc57d', '\uc57e', 
    '\uc57f', '\uc580', '\uc581', '\uc582', '\uc583', '\uc584', '\uc585', '\uc586', 
    '\uc587', '\uc588', '\uc589', '\uc58a', '\uc58b', '\uc58c', '\uc58d', '\uc58e', 
    '\uc58f', '\uc590', '\uc591', '\uc592', '\uc593', '\uc594', '\uc595', '\uc596', 
    '\uc597', '\uc598', '\uc599', '\uc59a', '\uc59b', '\uc59c', '\uc59d', '\uc59e', 
    '\uc59f', '\uc5a0', '\uc5a1', '\uc5a2', '\uc5a3', '\uc5a4', '\uc5a5', '\uc5a6', 
    '\uc5a7', '\uc5a8', '\uc5a9', '\uc5aa', '\uc5ab', '\uc5ac', '\uc5ad', '\uc5ae', 
    '\uc5af', '\uc5b0', '\uc5b1', '\uc5b2', '\uc5b3', '\uc5b4', '\uc5b5', '\uc5b6', 
    '\uc5b7', '\uc5b8', '\uc5b9', '\uc5ba', '\uc5bb', '\uc5bc', '\uc5bd', '\uc5be', 
    '\uc5bf', '\uc5c0', '\uc5c1', '\uc5c2', '\uc5c3', '\uc5c4', '\uc5c5', '\uc5c6', 
    '\uc5c7', '\uc5c8', '\uc5c9', '\uc5ca', '\uc5cb', '\uc5cc', '\uc5cd', '\uc5ce', 
    '\uc5cf', '\uc5d0', '\uc5d1', '\uc5d2', '\uc5d3', '\uc5d4', '\uc5d5', '\uc5d6', 
    '\uc5d7', '\uc5d8', '\uc5d9', '\uc5da', '\uc5db', '\uc5dc', '\uc5dd', '\uc5de', 
    '\uc5df', '\uc5e0', '\uc5e1', '\uc5e2', '\uc5e3', '\uc5e4', '\uc5e5', '\uc5e6', 
    '\uc5e7', '\uc5e8', '\uc5e9', '\uc5ea', '\uc5eb', '\uc5ec', '\uc5ed', '\uc5ee', 
    '\uc5ef', '\uc5f0', '\uc5f1', '\uc5f2', '\uc5f3', '\uc5f4', '\uc5f5', '\uc5f6', 
    '\uc5f7', '\uc5f8', '\uc5f9', '\uc5fa', '\uc5fb', '\uc5fc', '\uc5fd', '\uc5fe', 
    '\uc5ff', '\uc600', '\uc601', '\uc602', '\uc603', '\uc604', '\uc605', '\uc606', 
    '\uc607', '\uc608', '\uc609', '\uc60a', '\uc60b', '\uc60c', '\uc60d', '\uc60e', 
    '\uc60f', '\uc610', '\uc611', '\uc612', '\uc613', '\uc614', '\uc615', '\uc616', 
    '\uc617', '\uc618', '\uc619', '\uc61a', '\uc61b', '\uc61c', '\uc61d', '\uc61e', 
    '\uc61f', '\uc620', '\uc621', '\uc622', '\uc623', '\uc624', '\uc625', '\uc626', 
    '\uc627', '\uc628', '\uc629', '\uc62a', '\uc62b', '\uc62c', '\uc62d', '\uc62e', 
    '\uc62f', '\uc630', '\uc631', '\uc632', '\uc633', '\uc634', '\uc635', '\uc636', 
    '\uc637', '\uc638', '\uc639', '\uc63a', '\uc63b', '\uc63c', '\uc63d', '\uc63e', 
    '\uc63f', '\uc640', '\uc641', '\uc642', '\uc643', '\uc644', '\uc645', '\uc646', 
    '\uc647', '\uc648', '\uc649', '\uc64a', '\uc64b', '\uc64c', '\uc64d', '\uc64e', 
    '\uc64f', '\uc650', '\uc651', '\uc652', '\uc653', '\uc654', '\uc655', '\uc656', 
    '\uc657', '\uc658', '\uc659', '\uc65a', '\uc65b', '\uc65c', '\uc65d', '\uc65e', 
    '\uc65f', '\uc660', '\uc661', '\uc662', '\uc663', '\uc664', '\uc665', '\uc666', 
    '\uc667', '\uc668', '\uc669', '\uc66a', '\uc66b', '\uc66c', '\uc66d', '\uc66e', 
    '\uc66f', '\uc670', '\uc671', '\uc672', '\uc673', '\uc674', '\uc675', '\uc676', 
    '\uc677', '\uc678', '\uc679', '\uc67a', '\uc67b', '\uc67c', '\uc67d', '\uc67e', 
    '\uc67f', '\uc680', '\uc681', '\uc682', '\uc683', '\uc684', '\uc685', '\uc686', 
    '\uc687', '\uc688', '\uc689', '\uc68a', '\uc68b', '\uc68c', '\uc68d', '\uc68e', 
    '\uc68f', '\uc690', '\uc691', '\uc692', '\uc693', '\uc694', '\uc695', '\uc696', 
    '\uc697', '\uc698', '\uc699', '\uc69a', '\uc69b', '\uc69c', '\uc69d', '\uc69e', 
    '\uc69f', '\uc6a0', '\uc6a1', '\uc6a2', '\uc6a3', '\uc6a4', '\uc6a5', '\uc6a6', 
    '\uc6a7', '\uc6a8', '\uc6a9', '\uc6aa', '\uc6ab', '\uc6ac', '\uc6ad', '\uc6ae', 
    '\uc6af', '\uc6b0', '\uc6b1', '\uc6b2', '\uc6b3', '\uc6b4', '\uc6b5', '\uc6b6', 
    '\uc6b7', '\uc6b8', '\uc6b9', '\uc6ba', '\uc6bb', '\uc6bc', '\uc6bd', '\uc6be', 
    '\uc6bf', '\uc6c0', '\uc6c1', '\uc6c2', '\uc6c3', '\uc6c4', '\uc6c5', '\uc6c6', 
    '\uc6c7', '\uc6c8', '\uc6c9', '\uc6ca', '\uc6cb', '\uc6cc', '\uc6cd', '\uc6ce', 
    '\uc6cf', '\uc6d0', '\uc6d1', '\uc6d2', '\uc6d3', '\uc6d4', '\uc6d5', '\uc6d6', 
    '\uc6d7', '\uc6d8', '\uc6d9', '\uc6da', '\uc6db', '\uc6dc', '\uc6dd', '\uc6de', 
    '\uc6df', '\uc6e0', '\uc6e1', '\uc6e2', '\uc6e3', '\uc6e4', '\uc6e5', '\uc6e6', 
    '\uc6e7', '\uc6e8', '\uc6e9', '\uc6ea', '\uc6eb', '\uc6ec', '\uc6ed', '\uc6ee', 
    '\uc6ef', '\uc6f0', '\uc6f1', '\uc6f2', '\uc6f3', '\uc6f4', '\uc6f5', '\uc6f6', 
    '\uc6f7', '\uc6f8', '\uc6f9', '\uc6fa', '\uc6fb', '\uc6fc', '\uc6fd', '\uc6fe', 
    '\uc6ff', '\uc700', '\uc701', '\uc702', '\uc703', '\uc704', '\uc705', '\uc706', 
    '\uc707', '\uc708', '\uc709', '\uc70a', '\uc70b', '\uc70c', '\uc70d', '\uc70e', 
    '\uc70f', '\uc710', '\uc711', '\uc712', '\uc713', '\uc714', '\uc715', '\uc716', 
    '\uc717', '\uc718', '\uc719', '\uc71a', '\uc71b', '\uc71c', '\uc71d', '\uc71e', 
    '\uc71f', '\uc720', '\uc721', '\uc722', '\uc723', '\uc724', '\uc725', '\uc726', 
    '\uc727', '\uc728', '\uc729', '\uc72a', '\uc72b', '\uc72c', '\uc72d', '\uc72e', 
    '\uc72f', '\uc730', '\uc731', '\uc732', '\uc733', '\uc734', '\uc735', '\uc736', 
    '\uc737', '\uc738', '\uc739', '\uc73a', '\uc73b', '\uc73c', '\uc73d', '\uc73e', 
    '\uc73f', '\uc740', '\uc741', '\uc742', '\uc743', '\uc744', '\uc745', '\uc746', 
    '\uc747', '\uc748', '\uc749', '\uc74a', '\uc74b', '\uc74c', '\uc74d', '\uc74e', 
    '\uc74f', '\uc750', '\uc751', '\uc752', '\uc753', '\uc754', '\uc755', '\uc756', 
    '\uc757', '\uc758', '\uc759', '\uc75a', '\uc75b', '\uc75c', '\uc75d', '\uc75e', 
    '\uc75f', '\uc760', '\uc761', '\uc762', '\uc763', '\uc764', '\uc765', '\uc766', 
    '\uc767', '\uc768', '\uc769', '\uc76a', '\uc76b', '\uc76c', '\uc76d', '\uc76e', 
    '\uc76f', '\uc770', '\uc771', '\uc772', '\uc773', '\uc774', '\uc775', '\uc776', 
    '\uc777', '\uc778', '\uc779', '\uc77a', '\uc77b', '\uc77c', '\uc77d', '\uc77e', 
    '\uc77f', '\uc780', '\uc781', '\uc782', '\uc783', '\uc784', '\uc785', '\uc786', 
    '\uc787', '\uc788', '\uc789', '\uc78a', '\uc78b', '\uc78c', '\uc78d', '\uc78e', 
    '\uc78f', '\uc790', '\uc791', '\uc792', '\uc793', '\uc794', '\uc795', '\uc796', 
    '\uc797', '\uc798', '\uc799', '\uc79a', '\uc79b', '\uc79c', '\uc79d', '\uc79e', 
    '\uc79f', '\uc7a0', '\uc7a1', '\uc7a2', '\uc7a3', '\uc7a4', '\uc7a5', '\uc7a6', 
    '\uc7a7', '\uc7a8', '\uc7a9', '\uc7aa', '\uc7ab', '\uc7ac', '\uc7ad', '\uc7ae', 
    '\uc7af', '\uc7b0', '\uc7b1', '\uc7b2', '\uc7b3', '\uc7b4', '\uc7b5', '\uc7b6', 
    '\uc7b7', '\uc7b8', '\uc7b9', '\uc7ba', '\uc7bb', '\uc7bc', '\uc7bd', '\uc7be', 
    '\uc7bf', '\uc7c0', '\uc7c1', '\uc7c2', '\uc7c3', '\uc7c4', '\uc7c5', '\uc7c6', 
    '\uc7c7', '\uc7c8', '\uc7c9', '\uc7ca', '\uc7cb', '\uc7cc', '\uc7cd', '\uc7ce', 
    '\uc7cf', '\uc7d0', '\uc7d1', '\uc7d2', '\uc7d3', '\uc7d4', '\uc7d5', '\uc7d6', 
    '\uc7d7', '\uc7d8', '\uc7d9', '\uc7da', '\uc7db', '\uc7dc', '\uc7dd', '\uc7de', 
    '\uc7df', '\uc7e0', '\uc7e1', '\uc7e2', '\uc7e3', '\uc7e4', '\uc7e5', '\uc7e6', 
    '\uc7e7', '\uc7e8', '\uc7e9', '\uc7ea', '\uc7eb', '\uc7ec', '\uc7ed', '\uc7ee', 
    '\uc7ef', '\uc7f0', '\uc7f1', '\uc7f2', '\uc7f3', '\uc7f4', '\uc7f5', '\uc7f6', 
    '\uc7f7', '\uc7f8', '\uc7f9', '\uc7fa', '\uc7fb', '\uc7fc', '\uc7fd', '\uc7fe', 
    '\uc7ff', '\uc800', '\uc801', '\uc802', '\uc803', '\uc804', '\uc805', '\uc806', 
    '\uc807', '\uc808', '\uc809', '\uc80a', '\uc80b', '\uc80c', '\uc80d', '\uc80e', 
    '\uc80f', '\uc810', '\uc811', '\uc812', '\uc813', '\uc814', '\uc815', '\uc816', 
    '\uc817', '\uc818', '\uc819', '\uc81a', '\uc81b', '\uc81c', '\uc81d', '\uc81e', 
    '\uc81f', '\uc820', '\uc821', '\uc822', '\uc823', '\uc824', '\uc825', '\uc826', 
    '\uc827', '\uc828', '\uc829', '\uc82a', '\uc82b', '\uc82c', '\uc82d', '\uc82e', 
    '\uc82f', '\uc830', '\uc831', '\uc832', '\uc833', '\uc834', '\uc835', '\uc836', 
    '\uc837', '\uc838', '\uc839', '\uc83a', '\uc83b', '\uc83c', '\uc83d', '\uc83e', 
    '\uc83f', '\uc840', '\uc841', '\uc842', '\uc843', '\uc844', '\uc845', '\uc846', 
    '\uc847', '\uc848', '\uc849', '\uc84a', '\uc84b', '\uc84c', '\uc84d', '\uc84e', 
    '\uc84f', '\uc850', '\uc851', '\uc852', '\uc853', '\uc854', '\uc855', '\uc856', 
    '\uc857', '\uc858', '\uc859', '\uc85a', '\uc85b', '\uc85c', '\uc85d', '\uc85e', 
    '\uc85f', '\uc860', '\uc861', '\uc862', '\uc863', '\uc864', '\uc865', '\uc866', 
    '\uc867', '\uc868', '\uc869', '\uc86a', '\uc86b', '\uc86c', '\uc86d', '\uc86e', 
    '\uc86f', '\uc870', '\uc871', '\uc872', '\uc873', '\uc874', '\uc875', '\uc876', 
    '\uc877', '\uc878', '\uc879', '\uc87a', '\uc87b', '\uc87c', '\uc87d', '\uc87e', 
    '\uc87f', '\uc880', '\uc881', '\uc882', '\uc883', '\uc884', '\uc885', '\uc886', 
    '\uc887', '\uc888', '\uc889', '\uc88a', '\uc88b', '\uc88c', '\uc88d', '\uc88e', 
    '\uc88f', '\uc890', '\uc891', '\uc892', '\uc893', '\uc894', '\uc895', '\uc896', 
    '\uc897', '\uc898', '\uc899', '\uc89a', '\uc89b', '\uc89c', '\uc89d', '\uc89e', 
    '\uc89f', '\uc8a0', '\uc8a1', '\uc8a2', '\uc8a3', '\uc8a4', '\uc8a5', '\uc8a6', 
    '\uc8a7', '\uc8a8', '\uc8a9', '\uc8aa', '\uc8ab', '\uc8ac', '\uc8ad', '\uc8ae', 
    '\uc8af', '\uc8b0', '\uc8b1', '\uc8b2', '\uc8b3', '\uc8b4', '\uc8b5', '\uc8b6', 
    '\uc8b7', '\uc8b8', '\uc8b9', '\uc8ba', '\uc8bb', '\uc8bc', '\uc8bd', '\uc8be', 
    '\uc8bf', '\uc8c0', '\uc8c1', '\uc8c2', '\uc8c3', '\uc8c4', '\uc8c5', '\uc8c6', 
    '\uc8c7', '\uc8c8', '\uc8c9', '\uc8ca', '\uc8cb', '\uc8cc', '\uc8cd', '\uc8ce', 
    '\uc8cf', '\uc8d0', '\uc8d1', '\uc8d2', '\uc8d3', '\uc8d4', '\uc8d5', '\uc8d6', 
    '\uc8d7', '\uc8d8', '\uc8d9', '\uc8da', '\uc8db', '\uc8dc', '\uc8dd', '\uc8de', 
    '\uc8df', '\uc8e0', '\uc8e1', '\uc8e2', '\uc8e3', '\uc8e4', '\uc8e5', '\uc8e6', 
    '\uc8e7', '\uc8e8', '\uc8e9', '\uc8ea', '\uc8eb', '\uc8ec', '\uc8ed', '\uc8ee', 
    '\uc8ef', '\uc8f0', '\uc8f1', '\uc8f2', '\uc8f3', '\uc8f4', '\uc8f5', '\uc8f6', 
    '\uc8f7', '\uc8f8', '\uc8f9', '\uc8fa', '\uc8fb', '\uc8fc', '\uc8fd', '\uc8fe', 
    '\uc8ff', '\uc900', '\uc901', '\uc902', '\uc903', '\uc904', '\uc905', '\uc906', 
    '\uc907', '\uc908', '\uc909', '\uc90a', '\uc90b', '\uc90c', '\uc90d', '\uc90e', 
    '\uc90f', '\uc910', '\uc911', '\uc912', '\uc913', '\uc914', '\uc915', '\uc916', 
    '\uc917', '\uc918', '\uc919', '\uc91a', '\uc91b', '\uc91c', '\uc91d', '\uc91e', 
    '\uc91f', '\uc920', '\uc921', '\uc922', '\uc923', '\uc924', '\uc925', '\uc926', 
    '\uc927', '\uc928', '\uc929', '\uc92a', '\uc92b', '\uc92c', '\uc92d', '\uc92e', 
    '\uc92f', '\uc930', '\uc931', '\uc932', '\uc933', '\uc934', '\uc935', '\uc936', 
    '\uc937', '\uc938', '\uc939', '\uc93a', '\uc93b', '\uc93c', '\uc93d', '\uc93e', 
    '\uc93f', '\uc940', '\uc941', '\uc942', '\uc943', '\uc944', '\uc945', '\uc946', 
    '\uc947', '\uc948', '\uc949', '\uc94a', '\uc94b', '\uc94c', '\uc94d', '\uc94e', 
    '\uc94f', '\uc950', '\uc951', '\uc952', '\uc953', '\uc954', '\uc955', '\uc956', 
    '\uc957', '\uc958', '\uc959', '\uc95a', '\uc95b', '\uc95c', '\uc95d', '\uc95e', 
    '\uc95f', '\uc960', '\uc961', '\uc962', '\uc963', '\uc964', '\uc965', '\uc966', 
    '\uc967', '\uc968', '\uc969', '\uc96a', '\uc96b', '\uc96c', '\uc96d', '\uc96e', 
    '\uc96f', '\uc970', '\uc971', '\uc972', '\uc973', '\uc974', '\uc975', '\uc976', 
    '\uc977', '\uc978', '\uc979', '\uc97a', '\uc97b', '\uc97c', '\uc97d', '\uc97e', 
    '\uc97f', '\uc980', '\uc981', '\uc982', '\uc983', '\uc984', '\uc985', '\uc986', 
    '\uc987', '\uc988', '\uc989', '\uc98a', '\uc98b', '\uc98c', '\uc98d', '\uc98e', 
    '\uc98f', '\uc990', '\uc991', '\uc992', '\uc993', '\uc994', '\uc995', '\uc996', 
    '\uc997', '\uc998', '\uc999', '\uc99a', '\uc99b', '\uc99c', '\uc99d', '\uc99e', 
    '\uc99f', '\uc9a0', '\uc9a1', '\uc9a2', '\uc9a3', '\uc9a4', '\uc9a5', '\uc9a6', 
    '\uc9a7', '\uc9a8', '\uc9a9', '\uc9aa', '\uc9ab', '\uc9ac', '\uc9ad', '\uc9ae', 
    '\uc9af', '\uc9b0', '\uc9b1', '\uc9b2', '\uc9b3', '\uc9b4', '\uc9b5', '\uc9b6', 
    '\uc9b7', '\uc9b8', '\uc9b9', '\uc9ba', '\uc9bb', '\uc9bc', '\uc9bd', '\uc9be', 
    '\uc9bf', '\uc9c0', '\uc9c1', '\uc9c2', '\uc9c3', '\uc9c4', '\uc9c5', '\uc9c6', 
    '\uc9c7', '\uc9c8', '\uc9c9', '\uc9ca', '\uc9cb', '\uc9cc', '\uc9cd', '\uc9ce', 
    '\uc9cf', '\uc9d0', '\uc9d1', '\uc9d2', '\uc9d3', '\uc9d4', '\uc9d5', '\uc9d6', 
    '\uc9d7', '\uc9d8', '\uc9d9', '\uc9da', '\uc9db', '\uc9dc', '\uc9dd', '\uc9de', 
    '\uc9df', '\uc9e0', '\uc9e1', '\uc9e2', '\uc9e3', '\uc9e4', '\uc9e5', '\uc9e6', 
    '\uc9e7', '\uc9e8', '\uc9e9', '\uc9ea', '\uc9eb', '\uc9ec', '\uc9ed', '\uc9ee', 
    '\uc9ef', '\uc9f0', '\uc9f1', '\uc9f2', '\uc9f3', '\uc9f4', '\uc9f5', '\uc9f6', 
    '\uc9f7', '\uc9f8', '\uc9f9', '\uc9fa', '\uc9fb', '\uc9fc', '\uc9fd', '\uc9fe', 
    '\uc9ff', '\uca00', '\uca01', '\uca02', '\uca03', '\uca04', '\uca05', '\uca06', 
    '\uca07', '\uca08', '\uca09', '\uca0a', '\uca0b', '\uca0c', '\uca0d', '\uca0e', 
    '\uca0f', '\uca10', '\uca11', '\uca12', '\uca13', '\uca14', '\uca15', '\uca16', 
    '\uca17', '\uca18', '\uca19', '\uca1a', '\uca1b', '\uca1c', '\uca1d', '\uca1e', 
    '\uca1f', '\uca20', '\uca21', '\uca22', '\uca23', '\uca24', '\uca25', '\uca26', 
    '\uca27', '\uca28', '\uca29', '\uca2a', '\uca2b', '\uca2c', '\uca2d', '\uca2e', 
    '\uca2f', '\uca30', '\uca31', '\uca32', '\uca33', '\uca34', '\uca35', '\uca36', 
    '\uca37', '\uca38', '\uca39', '\uca3a', '\uca3b', '\uca3c', '\uca3d', '\uca3e', 
    '\uca3f', '\uca40', '\uca41', '\uca42', '\uca43', '\uca44', '\uca45', '\uca46', 
    '\uca47', '\uca48', '\uca49', '\uca4a', '\uca4b', '\uca4c', '\uca4d', '\uca4e', 
    '\uca4f', '\uca50', '\uca51', '\uca52', '\uca53', '\uca54', '\uca55', '\uca56', 
    '\uca57', '\uca58', '\uca59', '\uca5a', '\uca5b', '\uca5c', '\uca5d', '\uca5e', 
    '\uca5f', '\uca60', '\uca61', '\uca62', '\uca63', '\uca64', '\uca65', '\uca66', 
    '\uca67', '\uca68', '\uca69', '\uca6a', '\uca6b', '\uca6c', '\uca6d', '\uca6e', 
    '\uca6f', '\uca70', '\uca71', '\uca72', '\uca73', '\uca74', '\uca75', '\uca76', 
    '\uca77', '\uca78', '\uca79', '\uca7a', '\uca7b', '\uca7c', '\uca7d', '\uca7e', 
    '\uca7f', '\uca80', '\uca81', '\uca82', '\uca83', '\uca84', '\uca85', '\uca86', 
    '\uca87', '\uca88', '\uca89', '\uca8a', '\uca8b', '\uca8c', '\uca8d', '\uca8e', 
    '\uca8f', '\uca90', '\uca91', '\uca92', '\uca93', '\uca94', '\uca95', '\uca96', 
    '\uca97', '\uca98', '\uca99', '\uca9a', '\uca9b', '\uca9c', '\uca9d', '\uca9e', 
    '\uca9f', '\ucaa0', '\ucaa1', '\ucaa2', '\ucaa3', '\ucaa4', '\ucaa5', '\ucaa6', 
    '\ucaa7', '\ucaa8', '\ucaa9', '\ucaaa', '\ucaab', '\ucaac', '\ucaad', '\ucaae', 
    '\ucaaf', '\ucab0', '\ucab1', '\ucab2', '\ucab3', '\ucab4', '\ucab5', '\ucab6', 
    '\ucab7', '\ucab8', '\ucab9', '\ucaba', '\ucabb', '\ucabc', '\ucabd', '\ucabe', 
    '\ucabf', '\ucac0', '\ucac1', '\ucac2', '\ucac3', '\ucac4', '\ucac5', '\ucac6', 
    '\ucac7', '\ucac8', '\ucac9', '\ucaca', '\ucacb', '\ucacc', '\ucacd', '\ucace', 
    '\ucacf', '\ucad0', '\ucad1', '\ucad2', '\ucad3', '\ucad4', '\ucad5', '\ucad6', 
    '\ucad7', '\ucad8', '\ucad9', '\ucada', '\ucadb', '\ucadc', '\ucadd', '\ucade', 
    '\ucadf', '\ucae0', '\ucae1', '\ucae2', '\ucae3', '\ucae4', '\ucae5', '\ucae6', 
    '\ucae7', '\ucae8', '\ucae9', '\ucaea', '\ucaeb', '\ucaec', '\ucaed', '\ucaee', 
    '\ucaef', '\ucaf0', '\ucaf1', '\ucaf2', '\ucaf3', '\ucaf4', '\ucaf5', '\ucaf6', 
    '\ucaf7', '\ucaf8', '\ucaf9', '\ucafa', '\ucafb', '\ucafc', '\ucafd', '\ucafe', 
    '\ucaff', '\ucb00', '\ucb01', '\ucb02', '\ucb03', '\ucb04', '\ucb05', '\ucb06', 
    '\ucb07', '\ucb08', '\ucb09', '\ucb0a', '\ucb0b', '\ucb0c', '\ucb0d', '\ucb0e', 
    '\ucb0f', '\ucb10', '\ucb11', '\ucb12', '\ucb13', '\ucb14', '\ucb15', '\ucb16', 
    '\ucb17', '\ucb18', '\ucb19', '\ucb1a', '\ucb1b', '\ucb1c', '\ucb1d', '\ucb1e', 
    '\ucb1f', '\ucb20', '\ucb21', '\ucb22', '\ucb23', '\ucb24', '\ucb25', '\ucb26', 
    '\ucb27', '\ucb28', '\ucb29', '\ucb2a', '\ucb2b', '\ucb2c', '\ucb2d', '\ucb2e', 
    '\ucb2f', '\ucb30', '\ucb31', '\ucb32', '\ucb33', '\ucb34', '\ucb35', '\ucb36', 
    '\ucb37', '\ucb38', '\ucb39', '\ucb3a', '\ucb3b', '\ucb3c', '\ucb3d', '\ucb3e', 
    '\ucb3f', '\ucb40', '\ucb41', '\ucb42', '\ucb43', '\ucb44', '\ucb45', '\ucb46', 
    '\ucb47', '\ucb48', '\ucb49', '\ucb4a', '\ucb4b', '\ucb4c', '\ucb4d', '\ucb4e', 
    '\ucb4f', '\ucb50', '\ucb51', '\ucb52', '\ucb53', '\ucb54', '\ucb55', '\ucb56', 
    '\ucb57', '\ucb58', '\ucb59', '\ucb5a', '\ucb5b', '\ucb5c', '\ucb5d', '\ucb5e', 
    '\ucb5f', '\ucb60', '\ucb61', '\ucb62', '\ucb63', '\ucb64', '\ucb65', '\ucb66', 
    '\ucb67', '\ucb68', '\ucb69', '\ucb6a', '\ucb6b', '\ucb6c', '\ucb6d', '\ucb6e', 
    '\ucb6f', '\ucb70', '\ucb71', '\ucb72', '\ucb73', '\ucb74', '\ucb75', '\ucb76', 
    '\ucb77', '\ucb78', '\ucb79', '\ucb7a', '\ucb7b', '\ucb7c', '\ucb7d', '\ucb7e', 
    '\ucb7f', '\ucb80', '\ucb81', '\ucb82', '\ucb83', '\ucb84', '\ucb85', '\ucb86', 
    '\ucb87', '\ucb88', '\ucb89', '\ucb8a', '\ucb8b', '\ucb8c', '\ucb8d', '\ucb8e', 
    '\ucb8f', '\ucb90', '\ucb91', '\ucb92', '\ucb93', '\ucb94', '\ucb95', '\ucb96', 
    '\ucb97', '\ucb98', '\ucb99', '\ucb9a', '\ucb9b', '\ucb9c', '\ucb9d', '\ucb9e', 
    '\ucb9f', '\ucba0', '\ucba1', '\ucba2', '\ucba3', '\ucba4', '\ucba5', '\ucba6', 
    '\ucba7', '\ucba8', '\ucba9', '\ucbaa', '\ucbab', '\ucbac', '\ucbad', '\ucbae', 
    '\ucbaf', '\ucbb0', '\ucbb1', '\ucbb2', '\ucbb3', '\ucbb4', '\ucbb5', '\ucbb6', 
    '\ucbb7', '\ucbb8', '\ucbb9', '\ucbba', '\ucbbb', '\ucbbc', '\ucbbd', '\ucbbe', 
    '\ucbbf', '\ucbc0', '\ucbc1', '\ucbc2', '\ucbc3', '\ucbc4', '\ucbc5', '\ucbc6', 
    '\ucbc7', '\ucbc8', '\ucbc9', '\ucbca', '\ucbcb', '\ucbcc', '\ucbcd', '\ucbce', 
    '\ucbcf', '\ucbd0', '\ucbd1', '\ucbd2', '\ucbd3', '\ucbd4', '\ucbd5', '\ucbd6', 
    '\ucbd7', '\ucbd8', '\ucbd9', '\ucbda', '\ucbdb', '\ucbdc', '\ucbdd', '\ucbde', 
    '\ucbdf', '\ucbe0', '\ucbe1', '\ucbe2', '\ucbe3', '\ucbe4', '\ucbe5', '\ucbe6', 
    '\ucbe7', '\ucbe8', '\ucbe9', '\ucbea', '\ucbeb', '\ucbec', '\ucbed', '\ucbee', 
    '\ucbef', '\ucbf0', '\ucbf1', '\ucbf2', '\ucbf3', '\ucbf4', '\ucbf5', '\ucbf6', 
    '\ucbf7', '\ucbf8', '\ucbf9', '\ucbfa', '\ucbfb', '\ucbfc', '\ucbfd', '\ucbfe', 
    '\ucbff', '\ucc00', '\ucc01', '\ucc02', '\ucc03', '\ucc04', '\ucc05', '\ucc06', 
    '\ucc07', '\ucc08', '\ucc09', '\ucc0a', '\ucc0b', '\ucc0c', '\ucc0d', '\ucc0e', 
    '\ucc0f', '\ucc10', '\ucc11', '\ucc12', '\ucc13', '\ucc14', '\ucc15', '\ucc16', 
    '\ucc17', '\ucc18', '\ucc19', '\ucc1a', '\ucc1b', '\ucc1c', '\ucc1d', '\ucc1e', 
    '\ucc1f', '\ucc20', '\ucc21', '\ucc22', '\ucc23', '\ucc24', '\ucc25', '\ucc26', 
    '\ucc27', '\ucc28', '\ucc29', '\ucc2a', '\ucc2b', '\ucc2c', '\ucc2d', '\ucc2e', 
    '\ucc2f', '\ucc30', '\ucc31', '\ucc32', '\ucc33', '\ucc34', '\ucc35', '\ucc36', 
    '\ucc37', '\ucc38', '\ucc39', '\ucc3a', '\ucc3b', '\ucc3c', '\ucc3d', '\ucc3e', 
    '\ucc3f', '\ucc40', '\ucc41', '\ucc42', '\ucc43', '\ucc44', '\ucc45', '\ucc46', 
    '\ucc47', '\ucc48', '\ucc49', '\ucc4a', '\ucc4b', '\ucc4c', '\ucc4d', '\ucc4e', 
    '\ucc4f', '\ucc50', '\ucc51', '\ucc52', '\ucc53', '\ucc54', '\ucc55', '\ucc56', 
    '\ucc57', '\ucc58', '\ucc59', '\ucc5a', '\ucc5b', '\ucc5c', '\ucc5d', '\ucc5e', 
    '\ucc5f', '\ucc60', '\ucc61', '\ucc62', '\ucc63', '\ucc64', '\ucc65', '\ucc66', 
    '\ucc67', '\ucc68', '\ucc69', '\ucc6a', '\ucc6b', '\ucc6c', '\ucc6d', '\ucc6e', 
    '\ucc6f', '\ucc70', '\ucc71', '\ucc72', '\ucc73', '\ucc74', '\ucc75', '\ucc76', 
    '\ucc77', '\ucc78', '\ucc79', '\ucc7a', '\ucc7b', '\ucc7c', '\ucc7d', '\ucc7e', 
    '\ucc7f', '\ucc80', '\ucc81', '\ucc82', '\ucc83', '\ucc84', '\ucc85', '\ucc86', 
    '\ucc87', '\ucc88', '\ucc89', '\ucc8a', '\ucc8b', '\ucc8c', '\ucc8d', '\ucc8e', 
    '\ucc8f', '\ucc90', '\ucc91', '\ucc92', '\ucc93', '\ucc94', '\ucc95', '\ucc96', 
    '\ucc97', '\ucc98', '\ucc99', '\ucc9a', '\ucc9b', '\ucc9c', '\ucc9d', '\ucc9e', 
    '\ucc9f', '\ucca0', '\ucca1', '\ucca2', '\ucca3', '\ucca4', '\ucca5', '\ucca6', 
    '\ucca7', '\ucca8', '\ucca9', '\uccaa', '\uccab', '\uccac', '\uccad', '\uccae', 
    '\uccaf', '\uccb0', '\uccb1', '\uccb2', '\uccb3', '\uccb4', '\uccb5', '\uccb6', 
    '\uccb7', '\uccb8', '\uccb9', '\uccba', '\uccbb', '\uccbc', '\uccbd', '\uccbe', 
    '\uccbf', '\uccc0', '\uccc1', '\uccc2', '\uccc3', '\uccc4', '\uccc5', '\uccc6', 
    '\uccc7', '\uccc8', '\uccc9', '\uccca', '\ucccb', '\ucccc', '\ucccd', '\uccce', 
    '\ucccf', '\uccd0', '\uccd1', '\uccd2', '\uccd3', '\uccd4', '\uccd5', '\uccd6', 
    '\uccd7', '\uccd8', '\uccd9', '\uccda', '\uccdb', '\uccdc', '\uccdd', '\uccde', 
    '\uccdf', '\ucce0', '\ucce1', '\ucce2', '\ucce3', '\ucce4', '\ucce5', '\ucce6', 
    '\ucce7', '\ucce8', '\ucce9', '\uccea', '\ucceb', '\uccec', '\ucced', '\uccee', 
    '\uccef', '\uccf0', '\uccf1', '\uccf2', '\uccf3', '\uccf4', '\uccf5', '\uccf6', 
    '\uccf7', '\uccf8', '\uccf9', '\uccfa', '\uccfb', '\uccfc', '\uccfd', '\uccfe', 
    '\uccff', '\ucd00', '\ucd01', '\ucd02', '\ucd03', '\ucd04', '\ucd05', '\ucd06', 
    '\ucd07', '\ucd08', '\ucd09', '\ucd0a', '\ucd0b', '\ucd0c', '\ucd0d', '\ucd0e', 
    '\ucd0f', '\ucd10', '\ucd11', '\ucd12', '\ucd13', '\ucd14', '\ucd15', '\ucd16', 
    '\ucd17', '\ucd18', '\ucd19', '\ucd1a', '\ucd1b', '\ucd1c', '\ucd1d', '\ucd1e', 
    '\ucd1f', '\ucd20', '\ucd21', '\ucd22', '\ucd23', '\ucd24', '\ucd25', '\ucd26', 
    '\ucd27', '\ucd28', '\ucd29', '\ucd2a', '\ucd2b', '\ucd2c', '\ucd2d', '\ucd2e', 
    '\ucd2f', '\ucd30', '\ucd31', '\ucd32', '\ucd33', '\ucd34', '\ucd35', '\ucd36', 
    '\ucd37', '\ucd38', '\ucd39', '\ucd3a', '\ucd3b', '\ucd3c', '\ucd3d', '\ucd3e', 
    '\ucd3f', '\ucd40', '\ucd41', '\ucd42', '\ucd43', '\ucd44', '\ucd45', '\ucd46', 
    '\ucd47', '\ucd48', '\ucd49', '\ucd4a', '\ucd4b', '\ucd4c', '\ucd4d', '\ucd4e', 
    '\ucd4f', '\ucd50', '\ucd51', '\ucd52', '\ucd53', '\ucd54', '\ucd55', '\ucd56', 
    '\ucd57', '\ucd58', '\ucd59', '\ucd5a', '\ucd5b', '\ucd5c', '\ucd5d', '\ucd5e', 
    '\ucd5f', '\ucd60', '\ucd61', '\ucd62', '\ucd63', '\ucd64', '\ucd65', '\ucd66', 
    '\ucd67', '\ucd68', '\ucd69', '\ucd6a', '\ucd6b', '\ucd6c', '\ucd6d', '\ucd6e', 
    '\ucd6f', '\ucd70', '\ucd71', '\ucd72', '\ucd73', '\ucd74', '\ucd75', '\ucd76', 
    '\ucd77', '\ucd78', '\ucd79', '\ucd7a', '\ucd7b', '\ucd7c', '\ucd7d', '\ucd7e', 
    '\ucd7f', '\ucd80', '\ucd81', '\ucd82', '\ucd83', '\ucd84', '\ucd85', '\ucd86', 
    '\ucd87', '\ucd88', '\ucd89', '\ucd8a', '\ucd8b', '\ucd8c', '\ucd8d', '\ucd8e', 
    '\ucd8f', '\ucd90', '\ucd91', '\ucd92', '\ucd93', '\ucd94', '\ucd95', '\ucd96', 
    '\ucd97', '\ucd98', '\ucd99', '\ucd9a', '\ucd9b', '\ucd9c', '\ucd9d', '\ucd9e', 
    '\ucd9f', '\ucda0', '\ucda1', '\ucda2', '\ucda3', '\ucda4', '\ucda5', '\ucda6', 
    '\ucda7', '\ucda8', '\ucda9', '\ucdaa', '\ucdab', '\ucdac', '\ucdad', '\ucdae', 
    '\ucdaf', '\ucdb0', '\ucdb1', '\ucdb2', '\ucdb3', '\ucdb4', '\ucdb5', '\ucdb6', 
    '\ucdb7', '\ucdb8', '\ucdb9', '\ucdba', '\ucdbb', '\ucdbc', '\ucdbd', '\ucdbe', 
    '\ucdbf', '\ucdc0', '\ucdc1', '\ucdc2', '\ucdc3', '\ucdc4', '\ucdc5', '\ucdc6', 
    '\ucdc7', '\ucdc8', '\ucdc9', '\ucdca', '\ucdcb', '\ucdcc', '\ucdcd', '\ucdce', 
    '\ucdcf', '\ucdd0', '\ucdd1', '\ucdd2', '\ucdd3', '\ucdd4', '\ucdd5', '\ucdd6', 
    '\ucdd7', '\ucdd8', '\ucdd9', '\ucdda', '\ucddb', '\ucddc', '\ucddd', '\ucdde', 
    '\ucddf', '\ucde0', '\ucde1', '\ucde2', '\ucde3', '\ucde4', '\ucde5', '\ucde6', 
    '\ucde7', '\ucde8', '\ucde9', '\ucdea', '\ucdeb', '\ucdec', '\ucded', '\ucdee', 
    '\ucdef', '\ucdf0', '\ucdf1', '\ucdf2', '\ucdf3', '\ucdf4', '\ucdf5', '\ucdf6', 
    '\ucdf7', '\ucdf8', '\ucdf9', '\ucdfa', '\ucdfb', '\ucdfc', '\ucdfd', '\ucdfe', 
    '\ucdff', '\uce00', '\uce01', '\uce02', '\uce03', '\uce04', '\uce05', '\uce06', 
    '\uce07', '\uce08', '\uce09', '\uce0a', '\uce0b', '\uce0c', '\uce0d', '\uce0e', 
    '\uce0f', '\uce10', '\uce11', '\uce12', '\uce13', '\uce14', '\uce15', '\uce16', 
    '\uce17', '\uce18', '\uce19', '\uce1a', '\uce1b', '\uce1c', '\uce1d', '\uce1e', 
    '\uce1f', '\uce20', '\uce21', '\uce22', '\uce23', '\uce24', '\uce25', '\uce26', 
    '\uce27', '\uce28', '\uce29', '\uce2a', '\uce2b', '\uce2c', '\uce2d', '\uce2e', 
    '\uce2f', '\uce30', '\uce31', '\uce32', '\uce33', '\uce34', '\uce35', '\uce36', 
    '\uce37', '\uce38', '\uce39', '\uce3a', '\uce3b', '\uce3c', '\uce3d', '\uce3e', 
    '\uce3f', '\uce40', '\uce41', '\uce42', '\uce43', '\uce44', '\uce45', '\uce46', 
    '\uce47', '\uce48', '\uce49', '\uce4a', '\uce4b', '\uce4c', '\uce4d', '\uce4e', 
    '\uce4f', '\uce50', '\uce51', '\uce52', '\uce53', '\uce54', '\uce55', '\uce56', 
    '\uce57', '\uce58', '\uce59', '\uce5a', '\uce5b', '\uce5c', '\uce5d', '\uce5e', 
    '\uce5f', '\uce60', '\uce61', '\uce62', '\uce63', '\uce64', '\uce65', '\uce66', 
    '\uce67', '\uce68', '\uce69', '\uce6a', '\uce6b', '\uce6c', '\uce6d', '\uce6e', 
    '\uce6f', '\uce70', '\uce71', '\uce72', '\uce73', '\uce74', '\uce75', '\uce76', 
    '\uce77', '\uce78', '\uce79', '\uce7a', '\uce7b', '\uce7c', '\uce7d', '\uce7e', 
    '\uce7f', '\uce80', '\uce81', '\uce82', '\uce83', '\uce84', '\uce85', '\uce86', 
    '\uce87', '\uce88', '\uce89', '\uce8a', '\uce8b', '\uce8c', '\uce8d', '\uce8e', 
    '\uce8f', '\uce90', '\uce91', '\uce92', '\uce93', '\uce94', '\uce95', '\uce96', 
    '\uce97', '\uce98', '\uce99', '\uce9a', '\uce9b', '\uce9c', '\uce9d', '\uce9e', 
    '\uce9f', '\ucea0', '\ucea1', '\ucea2', '\ucea3', '\ucea4', '\ucea5', '\ucea6', 
    '\ucea7', '\ucea8', '\ucea9', '\uceaa', '\uceab', '\uceac', '\ucead', '\uceae', 
    '\uceaf', '\uceb0', '\uceb1', '\uceb2', '\uceb3', '\uceb4', '\uceb5', '\uceb6', 
    '\uceb7', '\uceb8', '\uceb9', '\uceba', '\ucebb', '\ucebc', '\ucebd', '\ucebe', 
    '\ucebf', '\ucec0', '\ucec1', '\ucec2', '\ucec3', '\ucec4', '\ucec5', '\ucec6', 
    '\ucec7', '\ucec8', '\ucec9', '\uceca', '\ucecb', '\ucecc', '\ucecd', '\ucece', 
    '\ucecf', '\uced0', '\uced1', '\uced2', '\uced3', '\uced4', '\uced5', '\uced6', 
    '\uced7', '\uced8', '\uced9', '\uceda', '\ucedb', '\ucedc', '\ucedd', '\ucede', 
    '\ucedf', '\ucee0', '\ucee1', '\ucee2', '\ucee3', '\ucee4', '\ucee5', '\ucee6', 
    '\ucee7', '\ucee8', '\ucee9', '\uceea', '\uceeb', '\uceec', '\uceed', '\uceee', 
    '\uceef', '\ucef0', '\ucef1', '\ucef2', '\ucef3', '\ucef4', '\ucef5', '\ucef6', 
    '\ucef7', '\ucef8', '\ucef9', '\ucefa', '\ucefb', '\ucefc', '\ucefd', '\ucefe', 
    '\uceff', '\ucf00', '\ucf01', '\ucf02', '\ucf03', '\ucf04', '\ucf05', '\ucf06', 
    '\ucf07', '\ucf08', '\ucf09', '\ucf0a', '\ucf0b', '\ucf0c', '\ucf0d', '\ucf0e', 
    '\ucf0f', '\ucf10', '\ucf11', '\ucf12', '\ucf13', '\ucf14', '\ucf15', '\ucf16', 
    '\ucf17', '\ucf18', '\ucf19', '\ucf1a', '\ucf1b', '\ucf1c', '\ucf1d', '\ucf1e', 
    '\ucf1f', '\ucf20', '\ucf21', '\ucf22', '\ucf23', '\ucf24', '\ucf25', '\ucf26', 
    '\ucf27', '\ucf28', '\ucf29', '\ucf2a', '\ucf2b', '\ucf2c', '\ucf2d', '\ucf2e', 
    '\ucf2f', '\ucf30', '\ucf31', '\ucf32', '\ucf33', '\ucf34', '\ucf35', '\ucf36', 
    '\ucf37', '\ucf38', '\ucf39', '\ucf3a', '\ucf3b', '\ucf3c', '\ucf3d', '\ucf3e', 
    '\ucf3f', '\ucf40', '\ucf41', '\ucf42', '\ucf43', '\ucf44', '\ucf45', '\ucf46', 
    '\ucf47', '\ucf48', '\ucf49', '\ucf4a', '\ucf4b', '\ucf4c', '\ucf4d', '\ucf4e', 
    '\ucf4f', '\ucf50', '\ucf51', '\ucf52', '\ucf53', '\ucf54', '\ucf55', '\ucf56', 
    '\ucf57', '\ucf58', '\ucf59', '\ucf5a', '\ucf5b', '\ucf5c', '\ucf5d', '\ucf5e', 
    '\ucf5f', '\ucf60', '\ucf61', '\ucf62', '\ucf63', '\ucf64', '\ucf65', '\ucf66', 
    '\ucf67', '\ucf68', '\ucf69', '\ucf6a', '\ucf6b', '\ucf6c', '\ucf6d', '\ucf6e', 
    '\ucf6f', '\ucf70', '\ucf71', '\ucf72', '\ucf73', '\ucf74', '\ucf75', '\ucf76', 
    '\ucf77', '\ucf78', '\ucf79', '\ucf7a', '\ucf7b', '\ucf7c', '\ucf7d', '\ucf7e', 
    '\ucf7f', '\ucf80', '\ucf81', '\ucf82', '\ucf83', '\ucf84', '\ucf85', '\ucf86', 
    '\ucf87', '\ucf88', '\ucf89', '\ucf8a', '\ucf8b', '\ucf8c', '\ucf8d', '\ucf8e', 
    '\ucf8f', '\ucf90', '\ucf91', '\ucf92', '\ucf93', '\ucf94', '\ucf95', '\ucf96', 
    '\ucf97', '\ucf98', '\ucf99', '\ucf9a', '\ucf9b', '\ucf9c', '\ucf9d', '\ucf9e', 
    '\ucf9f', '\ucfa0', '\ucfa1', '\ucfa2', '\ucfa3', '\ucfa4', '\ucfa5', '\ucfa6', 
    '\ucfa7', '\ucfa8', '\ucfa9', '\ucfaa', '\ucfab', '\ucfac', '\ucfad', '\ucfae', 
    '\ucfaf', '\ucfb0', '\ucfb1', '\ucfb2', '\ucfb3', '\ucfb4', '\ucfb5', '\ucfb6', 
    '\ucfb7', '\ucfb8', '\ucfb9', '\ucfba', '\ucfbb', '\ucfbc', '\ucfbd', '\ucfbe', 
    '\ucfbf', '\ucfc0', '\ucfc1', '\ucfc2', '\ucfc3', '\ucfc4', '\ucfc5', '\ucfc6', 
    '\ucfc7', '\ucfc8', '\ucfc9', '\ucfca', '\ucfcb', '\ucfcc', '\ucfcd', '\ucfce', 
    '\ucfcf', '\ucfd0', '\ucfd1', '\ucfd2', '\ucfd3', '\ucfd4', '\ucfd5', '\ucfd6', 
    '\ucfd7', '\ucfd8', '\ucfd9', '\ucfda', '\ucfdb', '\ucfdc', '\ucfdd', '\ucfde', 
    '\ucfdf', '\ucfe0', '\ucfe1', '\ucfe2', '\ucfe3', '\ucfe4', '\ucfe5', '\ucfe6', 
    '\ucfe7', '\ucfe8', '\ucfe9', '\ucfea', '\ucfeb', '\ucfec', '\ucfed', '\ucfee', 
    '\ucfef', '\ucff0', '\ucff1', '\ucff2', '\ucff3', '\ucff4', '\ucff5', '\ucff6', 
    '\ucff7', '\ucff8', '\ucff9', '\ucffa', '\ucffb', '\ucffc', '\ucffd', '\ucffe', 
    '\ucfff', '\ud000', '\ud001', '\ud002', '\ud003', '\ud004', '\ud005', '\ud006', 
    '\ud007', '\ud008', '\ud009', '\ud00a', '\ud00b', '\ud00c', '\ud00d', '\ud00e', 
    '\ud00f', '\ud010', '\ud011', '\ud012', '\ud013', '\ud014', '\ud015', '\ud016', 
    '\ud017', '\ud018', '\ud019', '\ud01a', '\ud01b', '\ud01c', '\ud01d', '\ud01e', 
    '\ud01f', '\ud020', '\ud021', '\ud022', '\ud023', '\ud024', '\ud025', '\ud026', 
    '\ud027', '\ud028', '\ud029', '\ud02a', '\ud02b', '\ud02c', '\ud02d', '\ud02e', 
    '\ud02f', '\ud030', '\ud031', '\ud032', '\ud033', '\ud034', '\ud035', '\ud036', 
    '\ud037', '\ud038', '\ud039', '\ud03a', '\ud03b', '\ud03c', '\ud03d', '\ud03e', 
    '\ud03f', '\ud040', '\ud041', '\ud042', '\ud043', '\ud044', '\ud045', '\ud046', 
    '\ud047', '\ud048', '\ud049', '\ud04a', '\ud04b', '\ud04c', '\ud04d', '\ud04e', 
    '\ud04f', '\ud050', '\ud051', '\ud052', '\ud053', '\ud054', '\ud055', '\ud056', 
    '\ud057', '\ud058', '\ud059', '\ud05a', '\ud05b', '\ud05c', '\ud05d', '\ud05e', 
    '\ud05f', '\ud060', '\ud061', '\ud062', '\ud063', '\ud064', '\ud065', '\ud066', 
    '\ud067', '\ud068', '\ud069', '\ud06a', '\ud06b', '\ud06c', '\ud06d', '\ud06e', 
    '\ud06f', '\ud070', '\ud071', '\ud072', '\ud073', '\ud074', '\ud075', '\ud076', 
    '\ud077', '\ud078', '\ud079', '\ud07a', '\ud07b', '\ud07c', '\ud07d', '\ud07e', 
    '\ud07f', '\ud080', '\ud081', '\ud082', '\ud083', '\ud084', '\ud085', '\ud086', 
    '\ud087', '\ud088', '\ud089', '\ud08a', '\ud08b', '\ud08c', '\ud08d', '\ud08e', 
    '\ud08f', '\ud090', '\ud091', '\ud092', '\ud093', '\ud094', '\ud095', '\ud096', 
    '\ud097', '\ud098', '\ud099', '\ud09a', '\ud09b', '\ud09c', '\ud09d', '\ud09e', 
    '\ud09f', '\ud0a0', '\ud0a1', '\ud0a2', '\ud0a3', '\ud0a4', '\ud0a5', '\ud0a6', 
    '\ud0a7', '\ud0a8', '\ud0a9', '\ud0aa', '\ud0ab', '\ud0ac', '\ud0ad', '\ud0ae', 
    '\ud0af', '\ud0b0', '\ud0b1', '\ud0b2', '\ud0b3', '\ud0b4', '\ud0b5', '\ud0b6', 
    '\ud0b7', '\ud0b8', '\ud0b9', '\ud0ba', '\ud0bb', '\ud0bc', '\ud0bd', '\ud0be', 
    '\ud0bf', '\ud0c0', '\ud0c1', '\ud0c2', '\ud0c3', '\ud0c4', '\ud0c5', '\ud0c6', 
    '\ud0c7', '\ud0c8', '\ud0c9', '\ud0ca', '\ud0cb', '\ud0cc', '\ud0cd', '\ud0ce', 
    '\ud0cf', '\ud0d0', '\ud0d1', '\ud0d2', '\ud0d3', '\ud0d4', '\ud0d5', '\ud0d6', 
    '\ud0d7', '\ud0d8', '\ud0d9', '\ud0da', '\ud0db', '\ud0dc', '\ud0dd', '\ud0de', 
    '\ud0df', '\ud0e0', '\ud0e1', '\ud0e2', '\ud0e3', '\ud0e4', '\ud0e5', '\ud0e6', 
    '\ud0e7', '\ud0e8', '\ud0e9', '\ud0ea', '\ud0eb', '\ud0ec', '\ud0ed', '\ud0ee', 
    '\ud0ef', '\ud0f0', '\ud0f1', '\ud0f2', '\ud0f3', '\ud0f4', '\ud0f5', '\ud0f6', 
    '\ud0f7', '\ud0f8', '\ud0f9', '\ud0fa', '\ud0fb', '\ud0fc', '\ud0fd', '\ud0fe', 
    '\ud0ff', '\ud100', '\ud101', '\ud102', '\ud103', '\ud104', '\ud105', '\ud106', 
    '\ud107', '\ud108', '\ud109', '\ud10a', '\ud10b', '\ud10c', '\ud10d', '\ud10e', 
    '\ud10f', '\ud110', '\ud111', '\ud112', '\ud113', '\ud114', '\ud115', '\ud116', 
    '\ud117', '\ud118', '\ud119', '\ud11a', '\ud11b', '\ud11c', '\ud11d', '\ud11e', 
    '\ud11f', '\ud120', '\ud121', '\ud122', '\ud123', '\ud124', '\ud125', '\ud126', 
    '\ud127', '\ud128', '\ud129', '\ud12a', '\ud12b', '\ud12c', '\ud12d', '\ud12e', 
    '\ud12f', '\ud130', '\ud131', '\ud132', '\ud133', '\ud134', '\ud135', '\ud136', 
    '\ud137', '\ud138', '\ud139', '\ud13a', '\ud13b', '\ud13c', '\ud13d', '\ud13e', 
    '\ud13f', '\ud140', '\ud141', '\ud142', '\ud143', '\ud144', '\ud145', '\ud146', 
    '\ud147', '\ud148', '\ud149', '\ud14a', '\ud14b', '\ud14c', '\ud14d', '\ud14e', 
    '\ud14f', '\ud150', '\ud151', '\ud152', '\ud153', '\ud154', '\ud155', '\ud156', 
    '\ud157', '\ud158', '\ud159', '\ud15a', '\ud15b', '\ud15c', '\ud15d', '\ud15e', 
    '\ud15f', '\ud160', '\ud161', '\ud162', '\ud163', '\ud164', '\ud165', '\ud166', 
    '\ud167', '\ud168', '\ud169', '\ud16a', '\ud16b', '\ud16c', '\ud16d', '\ud16e', 
    '\ud16f', '\ud170', '\ud171', '\ud172', '\ud173', '\ud174', '\ud175', '\ud176', 
    '\ud177', '\ud178', '\ud179', '\ud17a', '\ud17b', '\ud17c', '\ud17d', '\ud17e', 
    '\ud17f', '\ud180', '\ud181', '\ud182', '\ud183', '\ud184', '\ud185', '\ud186', 
    '\ud187', '\ud188', '\ud189', '\ud18a', '\ud18b', '\ud18c', '\ud18d', '\ud18e', 
    '\ud18f', '\ud190', '\ud191', '\ud192', '\ud193', '\ud194', '\ud195', '\ud196', 
    '\ud197', '\ud198', '\ud199', '\ud19a', '\ud19b', '\ud19c', '\ud19d', '\ud19e', 
    '\ud19f', '\ud1a0', '\ud1a1', '\ud1a2', '\ud1a3', '\ud1a4', '\ud1a5', '\ud1a6', 
    '\ud1a7', '\ud1a8', '\ud1a9', '\ud1aa', '\ud1ab', '\ud1ac', '\ud1ad', '\ud1ae', 
    '\ud1af', '\ud1b0', '\ud1b1', '\ud1b2', '\ud1b3', '\ud1b4', '\ud1b5', '\ud1b6', 
    '\ud1b7', '\ud1b8', '\ud1b9', '\ud1ba', '\ud1bb', '\ud1bc', '\ud1bd', '\ud1be', 
    '\ud1bf', '\ud1c0', '\ud1c1', '\ud1c2', '\ud1c3', '\ud1c4', '\ud1c5', '\ud1c6', 
    '\ud1c7', '\ud1c8', '\ud1c9', '\ud1ca', '\ud1cb', '\ud1cc', '\ud1cd', '\ud1ce', 
    '\ud1cf', '\ud1d0', '\ud1d1', '\ud1d2', '\ud1d3', '\ud1d4', '\ud1d5', '\ud1d6', 
    '\ud1d7', '\ud1d8', '\ud1d9', '\ud1da', '\ud1db', '\ud1dc', '\ud1dd', '\ud1de', 
    '\ud1df', '\ud1e0', '\ud1e1', '\ud1e2', '\ud1e3', '\ud1e4', '\ud1e5', '\ud1e6', 
    '\ud1e7', '\ud1e8', '\ud1e9', '\ud1ea', '\ud1eb', '\ud1ec', '\ud1ed', '\ud1ee', 
    '\ud1ef', '\ud1f0', '\ud1f1', '\ud1f2', '\ud1f3', '\ud1f4', '\ud1f5', '\ud1f6', 
    '\ud1f7', '\ud1f8', '\ud1f9', '\ud1fa', '\ud1fb', '\ud1fc', '\ud1fd', '\ud1fe', 
    '\ud1ff', '\ud200', '\ud201', '\ud202', '\ud203', '\ud204', '\ud205', '\ud206', 
    '\ud207', '\ud208', '\ud209', '\ud20a', '\ud20b', '\ud20c', '\ud20d', '\ud20e', 
    '\ud20f', '\ud210', '\ud211', '\ud212', '\ud213', '\ud214', '\ud215', '\ud216', 
    '\ud217', '\ud218', '\ud219', '\ud21a', '\ud21b', '\ud21c', '\ud21d', '\ud21e', 
    '\ud21f', '\ud220', '\ud221', '\ud222', '\ud223', '\ud224', '\ud225', '\ud226', 
    '\ud227', '\ud228', '\ud229', '\ud22a', '\ud22b', '\ud22c', '\ud22d', '\ud22e', 
    '\ud22f', '\ud230', '\ud231', '\ud232', '\ud233', '\ud234', '\ud235', '\ud236', 
    '\ud237', '\ud238', '\ud239', '\ud23a', '\ud23b', '\ud23c', '\ud23d', '\ud23e', 
    '\ud23f', '\ud240', '\ud241', '\ud242', '\ud243', '\ud244', '\ud245', '\ud246', 
    '\ud247', '\ud248', '\ud249', '\ud24a', '\ud24b', '\ud24c', '\ud24d', '\ud24e', 
    '\ud24f', '\ud250', '\ud251', '\ud252', '\ud253', '\ud254', '\ud255', '\ud256', 
    '\ud257', '\ud258', '\ud259', '\ud25a', '\ud25b', '\ud25c', '\ud25d', '\ud25e', 
    '\ud25f', '\ud260', '\ud261', '\ud262', '\ud263', '\ud264', '\ud265', '\ud266', 
    '\ud267', '\ud268', '\ud269', '\ud26a', '\ud26b', '\ud26c', '\ud26d', '\ud26e', 
    '\ud26f', '\ud270', '\ud271', '\ud272', '\ud273', '\ud274', '\ud275', '\ud276', 
    '\ud277', '\ud278', '\ud279', '\ud27a', '\ud27b', '\ud27c', '\ud27d', '\ud27e', 
    '\ud27f', '\ud280', '\ud281', '\ud282', '\ud283', '\ud284', '\ud285', '\ud286', 
    '\ud287', '\ud288', '\ud289', '\ud28a', '\ud28b', '\ud28c', '\ud28d', '\ud28e', 
    '\ud28f', '\ud290', '\ud291', '\ud292', '\ud293', '\ud294', '\ud295', '\ud296', 
    '\ud297', '\ud298', '\ud299', '\ud29a', '\ud29b', '\ud29c', '\ud29d', '\ud29e', 
    '\ud29f', '\ud2a0', '\ud2a1', '\ud2a2', '\ud2a3', '\ud2a4', '\ud2a5', '\ud2a6', 
    '\ud2a7', '\ud2a8', '\ud2a9', '\ud2aa', '\ud2ab', '\ud2ac', '\ud2ad', '\ud2ae', 
    '\ud2af', '\ud2b0', '\ud2b1', '\ud2b2', '\ud2b3', '\ud2b4', '\ud2b5', '\ud2b6', 
    '\ud2b7', '\ud2b8', '\ud2b9', '\ud2ba', '\ud2bb', '\ud2bc', '\ud2bd', '\ud2be', 
    '\ud2bf', '\ud2c0', '\ud2c1', '\ud2c2', '\ud2c3', '\ud2c4', '\ud2c5', '\ud2c6', 
    '\ud2c7', '\ud2c8', '\ud2c9', '\ud2ca', '\ud2cb', '\ud2cc', '\ud2cd', '\ud2ce', 
    '\ud2cf', '\ud2d0', '\ud2d1', '\ud2d2', '\ud2d3', '\ud2d4', '\ud2d5', '\ud2d6', 
    '\ud2d7', '\ud2d8', '\ud2d9', '\ud2da', '\ud2db', '\ud2dc', '\ud2dd', '\ud2de', 
    '\ud2df', '\ud2e0', '\ud2e1', '\ud2e2', '\ud2e3', '\ud2e4', '\ud2e5', '\ud2e6', 
    '\ud2e7', '\ud2e8', '\ud2e9', '\ud2ea', '\ud2eb', '\ud2ec', '\ud2ed', '\ud2ee', 
    '\ud2ef', '\ud2f0', '\ud2f1', '\ud2f2', '\ud2f3', '\ud2f4', '\ud2f5', '\ud2f6', 
    '\ud2f7', '\ud2f8', '\ud2f9', '\ud2fa', '\ud2fb', '\ud2fc', '\ud2fd', '\ud2fe', 
    '\ud2ff', '\ud300', '\ud301', '\ud302', '\ud303', '\ud304', '\ud305', '\ud306', 
    '\ud307', '\ud308', '\ud309', '\ud30a', '\ud30b', '\ud30c', '\ud30d', '\ud30e', 
    '\ud30f', '\ud310', '\ud311', '\ud312', '\ud313', '\ud314', '\ud315', '\ud316', 
    '\ud317', '\ud318', '\ud319', '\ud31a', '\ud31b', '\ud31c', '\ud31d', '\ud31e', 
    '\ud31f', '\ud320', '\ud321', '\ud322', '\ud323', '\ud324', '\ud325', '\ud326', 
    '\ud327', '\ud328', '\ud329', '\ud32a', '\ud32b', '\ud32c', '\ud32d', '\ud32e', 
    '\ud32f', '\ud330', '\ud331', '\ud332', '\ud333', '\ud334', '\ud335', '\ud336', 
    '\ud337', '\ud338', '\ud339', '\ud33a', '\ud33b', '\ud33c', '\ud33d', '\ud33e', 
    '\ud33f', '\ud340', '\ud341', '\ud342', '\ud343', '\ud344', '\ud345', '\ud346', 
    '\ud347', '\ud348', '\ud349', '\ud34a', '\ud34b', '\ud34c', '\ud34d', '\ud34e', 
    '\ud34f', '\ud350', '\ud351', '\ud352', '\ud353', '\ud354', '\ud355', '\ud356', 
    '\ud357', '\ud358', '\ud359', '\ud35a', '\ud35b', '\ud35c', '\ud35d', '\ud35e', 
    '\ud35f', '\ud360', '\ud361', '\ud362', '\ud363', '\ud364', '\ud365', '\ud366', 
    '\ud367', '\ud368', '\ud369', '\ud36a', '\ud36b', '\ud36c', '\ud36d', '\ud36e', 
    '\ud36f', '\ud370', '\ud371', '\ud372', '\ud373', '\ud374', '\ud375', '\ud376', 
    '\ud377', '\ud378', '\ud379', '\ud37a', '\ud37b', '\ud37c', '\ud37d', '\ud37e', 
    '\ud37f', '\ud380', '\ud381', '\ud382', '\ud383', '\ud384', '\ud385', '\ud386', 
    '\ud387', '\ud388', '\ud389', '\ud38a', '\ud38b', '\ud38c', '\ud38d', '\ud38e', 
    '\ud38f', '\ud390', '\ud391', '\ud392', '\ud393', '\ud394', '\ud395', '\ud396', 
    '\ud397', '\ud398', '\ud399', '\ud39a', '\ud39b', '\ud39c', '\ud39d', '\ud39e', 
    '\ud39f', '\ud3a0', '\ud3a1', '\ud3a2', '\ud3a3', '\ud3a4', '\ud3a5', '\ud3a6', 
    '\ud3a7', '\ud3a8', '\ud3a9', '\ud3aa', '\ud3ab', '\ud3ac', '\ud3ad', '\ud3ae', 
    '\ud3af', '\ud3b0', '\ud3b1', '\ud3b2', '\ud3b3', '\ud3b4', '\ud3b5', '\ud3b6', 
    '\ud3b7', '\ud3b8', '\ud3b9', '\ud3ba', '\ud3bb', '\ud3bc', '\ud3bd', '\ud3be', 
    '\ud3bf', '\ud3c0', '\ud3c1', '\ud3c2', '\ud3c3', '\ud3c4', '\ud3c5', '\ud3c6', 
    '\ud3c7', '\ud3c8', '\ud3c9', '\ud3ca', '\ud3cb', '\ud3cc', '\ud3cd', '\ud3ce', 
    '\ud3cf', '\ud3d0', '\ud3d1', '\ud3d2', '\ud3d3', '\ud3d4', '\ud3d5', '\ud3d6', 
    '\ud3d7', '\ud3d8', '\ud3d9', '\ud3da', '\ud3db', '\ud3dc', '\ud3dd', '\ud3de', 
    '\ud3df', '\ud3e0', '\ud3e1', '\ud3e2', '\ud3e3', '\ud3e4', '\ud3e5', '\ud3e6', 
    '\ud3e7', '\ud3e8', '\ud3e9', '\ud3ea', '\ud3eb', '\ud3ec', '\ud3ed', '\ud3ee', 
    '\ud3ef', '\ud3f0', '\ud3f1', '\ud3f2', '\ud3f3', '\ud3f4', '\ud3f5', '\ud3f6', 
    '\ud3f7', '\ud3f8', '\ud3f9', '\ud3fa', '\ud3fb', '\ud3fc', '\ud3fd', '\ud3fe', 
    '\ud3ff', '\ud400', '\ud401', '\ud402', '\ud403', '\ud404', '\ud405', '\ud406', 
    '\ud407', '\ud408', '\ud409', '\ud40a', '\ud40b', '\ud40c', '\ud40d', '\ud40e', 
    '\ud40f', '\ud410', '\ud411', '\ud412', '\ud413', '\ud414', '\ud415', '\ud416', 
    '\ud417', '\ud418', '\ud419', '\ud41a', '\ud41b', '\ud41c', '\ud41d', '\ud41e', 
    '\ud41f', '\ud420', '\ud421', '\ud422', '\ud423', '\ud424', '\ud425', '\ud426', 
    '\ud427', '\ud428', '\ud429', '\ud42a', '\ud42b', '\ud42c', '\ud42d', '\ud42e', 
    '\ud42f', '\ud430', '\ud431', '\ud432', '\ud433', '\ud434', '\ud435', '\ud436', 
    '\ud437', '\ud438', '\ud439', '\ud43a', '\ud43b', '\ud43c', '\ud43d', '\ud43e', 
    '\ud43f', '\ud440', '\ud441', '\ud442', '\ud443', '\ud444', '\ud445', '\ud446', 
    '\ud447', '\ud448', '\ud449', '\ud44a', '\ud44b', '\ud44c', '\ud44d', '\ud44e', 
    '\ud44f', '\ud450', '\ud451', '\ud452', '\ud453', '\ud454', '\ud455', '\ud456', 
    '\ud457', '\ud458', '\ud459', '\ud45a', '\ud45b', '\ud45c', '\ud45d', '\ud45e', 
    '\ud45f', '\ud460', '\ud461', '\ud462', '\ud463', '\ud464', '\ud465', '\ud466', 
    '\ud467', '\ud468', '\ud469', '\ud46a', '\ud46b', '\ud46c', '\ud46d', '\ud46e', 
    '\ud46f', '\ud470', '\ud471', '\ud472', '\ud473', '\ud474', '\ud475', '\ud476', 
    '\ud477', '\ud478', '\ud479', '\ud47a', '\ud47b', '\ud47c', '\ud47d', '\ud47e', 
    '\ud47f', '\ud480', '\ud481', '\ud482', '\ud483', '\ud484', '\ud485', '\ud486', 
    '\ud487', '\ud488', '\ud489', '\ud48a', '\ud48b', '\ud48c', '\ud48d', '\ud48e', 
    '\ud48f', '\ud490', '\ud491', '\ud492', '\ud493', '\ud494', '\ud495', '\ud496', 
    '\ud497', '\ud498', '\ud499', '\ud49a', '\ud49b', '\ud49c', '\ud49d', '\ud49e', 
    '\ud49f', '\ud4a0', '\ud4a1', '\ud4a2', '\ud4a3', '\ud4a4', '\ud4a5', '\ud4a6', 
    '\ud4a7', '\ud4a8', '\ud4a9', '\ud4aa', '\ud4ab', '\ud4ac', '\ud4ad', '\ud4ae', 
    '\ud4af', '\ud4b0', '\ud4b1', '\ud4b2', '\ud4b3', '\ud4b4', '\ud4b5', '\ud4b6', 
    '\ud4b7', '\ud4b8', '\ud4b9', '\ud4ba', '\ud4bb', '\ud4bc', '\ud4bd', '\ud4be', 
    '\ud4bf', '\ud4c0', '\ud4c1', '\ud4c2', '\ud4c3', '\ud4c4', '\ud4c5', '\ud4c6', 
    '\ud4c7', '\ud4c8', '\ud4c9', '\ud4ca', '\ud4cb', '\ud4cc', '\ud4cd', '\ud4ce', 
    '\ud4cf', '\ud4d0', '\ud4d1', '\ud4d2', '\ud4d3', '\ud4d4', '\ud4d5', '\ud4d6', 
    '\ud4d7', '\ud4d8', '\ud4d9', '\ud4da', '\ud4db', '\ud4dc', '\ud4dd', '\ud4de', 
    '\ud4df', '\ud4e0', '\ud4e1', '\ud4e2', '\ud4e3', '\ud4e4', '\ud4e5', '\ud4e6', 
    '\ud4e7', '\ud4e8', '\ud4e9', '\ud4ea', '\ud4eb', '\ud4ec', '\ud4ed', '\ud4ee', 
    '\ud4ef', '\ud4f0', '\ud4f1', '\ud4f2', '\ud4f3', '\ud4f4', '\ud4f5', '\ud4f6', 
    '\ud4f7', '\ud4f8', '\ud4f9', '\ud4fa', '\ud4fb', '\ud4fc', '\ud4fd', '\ud4fe', 
    '\ud4ff', '\ud500', '\ud501', '\ud502', '\ud503', '\ud504', '\ud505', '\ud506', 
    '\ud507', '\ud508', '\ud509', '\ud50a', '\ud50b', '\ud50c', '\ud50d', '\ud50e', 
    '\ud50f', '\ud510', '\ud511', '\ud512', '\ud513', '\ud514', '\ud515', '\ud516', 
    '\ud517', '\ud518', '\ud519', '\ud51a', '\ud51b', '\ud51c', '\ud51d', '\ud51e', 
    '\ud51f', '\ud520', '\ud521', '\ud522', '\ud523', '\ud524', '\ud525', '\ud526', 
    '\ud527', '\ud528', '\ud529', '\ud52a', '\ud52b', '\ud52c', '\ud52d', '\ud52e', 
    '\ud52f', '\ud530', '\ud531', '\ud532', '\ud533', '\ud534', '\ud535', '\ud536', 
    '\ud537', '\ud538', '\ud539', '\ud53a', '\ud53b', '\ud53c', '\ud53d', '\ud53e', 
    '\ud53f', '\ud540', '\ud541', '\ud542', '\ud543', '\ud544', '\ud545', '\ud546', 
    '\ud547', '\ud548', '\ud549', '\ud54a', '\ud54b', '\ud54c', '\ud54d', '\ud54e', 
    '\ud54f', '\ud550', '\ud551', '\ud552', '\ud553', '\ud554', '\ud555', '\ud556', 
    '\ud557', '\ud558', '\ud559', '\ud55a', '\ud55b', '\ud55c', '\ud55d', '\ud55e', 
    '\ud55f', '\ud560', '\ud561', '\ud562', '\ud563', '\ud564', '\ud565', '\ud566', 
    '\ud567', '\ud568', '\ud569', '\ud56a', '\ud56b', '\ud56c', '\ud56d', '\ud56e', 
    '\ud56f', '\ud570', '\ud571', '\ud572', '\ud573', '\ud574', '\ud575', '\ud576', 
    '\ud577', '\ud578', '\ud579', '\ud57a', '\ud57b', '\ud57c', '\ud57d', '\ud57e', 
    '\ud57f', '\ud580', '\ud581', '\ud582', '\ud583', '\ud584', '\ud585', '\ud586', 
    '\ud587', '\ud588', '\ud589', '\ud58a', '\ud58b', '\ud58c', '\ud58d', '\ud58e', 
    '\ud58f', '\ud590', '\ud591', '\ud592', '\ud593', '\ud594', '\ud595', '\ud596', 
    '\ud597', '\ud598', '\ud599', '\ud59a', '\ud59b', '\ud59c', '\ud59d', '\ud59e', 
    '\ud59f', '\ud5a0', '\ud5a1', '\ud5a2', '\ud5a3', '\ud5a4', '\ud5a5', '\ud5a6', 
    '\ud5a7', '\ud5a8', '\ud5a9', '\ud5aa', '\ud5ab', '\ud5ac', '\ud5ad', '\ud5ae', 
    '\ud5af', '\ud5b0', '\ud5b1', '\ud5b2', '\ud5b3', '\ud5b4', '\ud5b5', '\ud5b6', 
    '\ud5b7', '\ud5b8', '\ud5b9', '\ud5ba', '\ud5bb', '\ud5bc', '\ud5bd', '\ud5be', 
    '\ud5bf', '\ud5c0', '\ud5c1', '\ud5c2', '\ud5c3', '\ud5c4', '\ud5c5', '\ud5c6', 
    '\ud5c7', '\ud5c8', '\ud5c9', '\ud5ca', '\ud5cb', '\ud5cc', '\ud5cd', '\ud5ce', 
    '\ud5cf', '\ud5d0', '\ud5d1', '\ud5d2', '\ud5d3', '\ud5d4', '\ud5d5', '\ud5d6', 
    '\ud5d7', '\ud5d8', '\ud5d9', '\ud5da', '\ud5db', '\ud5dc', '\ud5dd', '\ud5de', 
    '\ud5df', '\ud5e0', '\ud5e1', '\ud5e2', '\ud5e3', '\ud5e4', '\ud5e5', '\ud5e6', 
    '\ud5e7', '\ud5e8', '\ud5e9', '\ud5ea', '\ud5eb', '\ud5ec', '\ud5ed', '\ud5ee', 
    '\ud5ef', '\ud5f0', '\ud5f1', '\ud5f2', '\ud5f3', '\ud5f4', '\ud5f5', '\ud5f6', 
    '\ud5f7', '\ud5f8', '\ud5f9', '\ud5fa', '\ud5fb', '\ud5fc', '\ud5fd', '\ud5fe', 
    '\ud5ff', '\ud600', '\ud601', '\ud602', '\ud603', '\ud604', '\ud605', '\ud606', 
    '\ud607', '\ud608', '\ud609', '\ud60a', '\ud60b', '\ud60c', '\ud60d', '\ud60e', 
    '\ud60f', '\ud610', '\ud611', '\ud612', '\ud613', '\ud614', '\ud615', '\ud616', 
    '\ud617', '\ud618', '\ud619', '\ud61a', '\ud61b', '\ud61c', '\ud61d', '\ud61e', 
    '\ud61f', '\ud620', '\ud621', '\ud622', '\ud623', '\ud624', '\ud625', '\ud626', 
    '\ud627', '\ud628', '\ud629', '\ud62a', '\ud62b', '\ud62c', '\ud62d', '\ud62e', 
    '\ud62f', '\ud630', '\ud631', '\ud632', '\ud633', '\ud634', '\ud635', '\ud636', 
    '\ud637', '\ud638', '\ud639', '\ud63a', '\ud63b', '\ud63c', '\ud63d', '\ud63e', 
    '\ud63f', '\ud640', '\ud641', '\ud642', '\ud643', '\ud644', '\ud645', '\ud646', 
    '\ud647', '\ud648', '\ud649', '\ud64a', '\ud64b', '\ud64c', '\ud64d', '\ud64e', 
    '\ud64f', '\ud650', '\ud651', '\ud652', '\ud653', '\ud654', '\ud655', '\ud656', 
    '\ud657', '\ud658', '\ud659', '\ud65a', '\ud65b', '\ud65c', '\ud65d', '\ud65e', 
    '\ud65f', '\ud660', '\ud661', '\ud662', '\ud663', '\ud664', '\ud665', '\ud666', 
    '\ud667', '\ud668', '\ud669', '\ud66a', '\ud66b', '\ud66c', '\ud66d', '\ud66e', 
    '\ud66f', '\ud670', '\ud671', '\ud672', '\ud673', '\ud674', '\ud675', '\ud676', 
    '\ud677', '\ud678', '\ud679', '\ud67a', '\ud67b', '\ud67c', '\ud67d', '\ud67e', 
    '\ud67f', '\ud680', '\ud681', '\ud682', '\ud683', '\ud684', '\ud685', '\ud686', 
    '\ud687', '\ud688', '\ud689', '\ud68a', '\ud68b', '\ud68c', '\ud68d', '\ud68e', 
    '\ud68f', '\ud690', '\ud691', '\ud692', '\ud693', '\ud694', '\ud695', '\ud696', 
    '\ud697', '\ud698', '\ud699', '\ud69a', '\ud69b', '\ud69c', '\ud69d', '\ud69e', 
    '\ud69f', '\ud6a0', '\ud6a1', '\ud6a2', '\ud6a3', '\ud6a4', '\ud6a5', '\ud6a6', 
    '\ud6a7', '\ud6a8', '\ud6a9', '\ud6aa', '\ud6ab', '\ud6ac', '\ud6ad', '\ud6ae', 
    '\ud6af', '\ud6b0', '\ud6b1', '\ud6b2', '\ud6b3', '\ud6b4', '\ud6b5', '\ud6b6', 
    '\ud6b7', '\ud6b8', '\ud6b9', '\ud6ba', '\ud6bb', '\ud6bc', '\ud6bd', '\ud6be', 
    '\ud6bf', '\ud6c0', '\ud6c1', '\ud6c2', '\ud6c3', '\ud6c4', '\ud6c5', '\ud6c6', 
    '\ud6c7', '\ud6c8', '\ud6c9', '\ud6ca', '\ud6cb', '\ud6cc', '\ud6cd', '\ud6ce', 
    '\ud6cf', '\ud6d0', '\ud6d1', '\ud6d2', '\ud6d3', '\ud6d4', '\ud6d5', '\ud6d6', 
    '\ud6d7', '\ud6d8', '\ud6d9', '\ud6da', '\ud6db', '\ud6dc', '\ud6dd', '\ud6de', 
    '\ud6df', '\ud6e0', '\ud6e1', '\ud6e2', '\ud6e3', '\ud6e4', '\ud6e5', '\ud6e6', 
    '\ud6e7', '\ud6e8', '\ud6e9', '\ud6ea', '\ud6eb', '\ud6ec', '\ud6ed', '\ud6ee', 
    '\ud6ef', '\ud6f0', '\ud6f1', '\ud6f2', '\ud6f3', '\ud6f4', '\ud6f5', '\ud6f6', 
    '\ud6f7', '\ud6f8', '\ud6f9', '\ud6fa', '\ud6fb', '\ud6fc', '\ud6fd', '\ud6fe', 
    '\ud6ff', '\ud700', '\ud701', '\ud702', '\ud703', '\ud704', '\ud705', '\ud706', 
    '\ud707', '\ud708', '\ud709', '\ud70a', '\ud70b', '\ud70c', '\ud70d', '\ud70e', 
    '\ud70f', '\ud710', '\ud711', '\ud712', '\ud713', '\ud714', '\ud715', '\ud716', 
    '\ud717', '\ud718', '\ud719', '\ud71a', '\ud71b', '\ud71c', '\ud71d', '\ud71e', 
    '\ud71f', '\ud720', '\ud721', '\ud722', '\ud723', '\ud724', '\ud725', '\ud726', 
    '\ud727', '\ud728', '\ud729', '\ud72a', '\ud72b', '\ud72c', '\ud72d', '\ud72e', 
    '\ud72f', '\ud730', '\ud731', '\ud732', '\ud733', '\ud734', '\ud735', '\ud736', 
    '\ud737', '\ud738', '\ud739', '\ud73a', '\ud73b', '\ud73c', '\ud73d', '\ud73e', 
    '\ud73f', '\ud740', '\ud741', '\ud742', '\ud743', '\ud744', '\ud745', '\ud746', 
    '\ud747', '\ud748', '\ud749', '\ud74a', '\ud74b', '\ud74c', '\ud74d', '\ud74e', 
    '\ud74f', '\ud750', '\ud751', '\ud752', '\ud753', '\ud754', '\ud755', '\ud756', 
    '\ud757', '\ud758', '\ud759', '\ud75a', '\ud75b', '\ud75c', '\ud75d', '\ud75e', 
    '\ud75f', '\ud760', '\ud761', '\ud762', '\ud763', '\ud764', '\ud765', '\ud766', 
    '\ud767', '\ud768', '\ud769', '\ud76a', '\ud76b', '\ud76c', '\ud76d', '\ud76e', 
    '\ud76f', '\ud770', '\ud771', '\ud772', '\ud773', '\ud774', '\ud775', '\ud776', 
    '\ud777', '\ud778', '\ud779', '\ud77a', '\ud77b', '\ud77c', '\ud77d', '\ud77e', 
    '\ud77f', '\ud780', '\ud781', '\ud782', '\ud783', '\ud784', '\ud785', '\ud786', 
    '\ud787', '\ud788', '\ud789', '\ud78a', '\ud78b', '\ud78c', '\ud78d', '\ud78e', 
    '\ud78f', '\ud790', '\ud791', '\ud792', '\ud793', '\ud794', '\ud795', '\ud796', 
    '\ud797', '\ud798', '\ud799', '\ud79a', '\ud79b', '\ud79c', '\ud79d', '\ud79e', 
    '\ud79f', '\ud7a0', '\ud7a1', '\ud7a2', '\ud7a3', '\ud7b0', '\ud7b1', '\ud7b2', 
    '\ud7b3', '\ud7b4', '\ud7b5', '\ud7b6', '\ud7b7', '\ud7b8', '\ud7b9', '\ud7ba', 
    '\ud7bb', '\ud7bc', '\ud7bd', '\ud7be', '\ud7bf', '\ud7c0', '\ud7c1', '\ud7c2', 
    '\ud7c3', '\ud7c4', '\ud7c5', '\ud7c6', '\ud7cb', '\ud7cc', '\ud7cd', '\ud7ce', 
    '\ud7cf', '\ud7d0', '\ud7d1', '\ud7d2', '\ud7d3', '\ud7d4', '\ud7d5', '\ud7d6', 
    '\ud7d7', '\ud7d8', '\ud7d9', '\ud7da', '\ud7db', '\ud7dc', '\ud7dd', '\ud7de', 
    '\ud7df', '\ud7e0', '\ud7e1', '\ud7e2', '\ud7e3', '\ud7e4', '\ud7e5', '\ud7e6', 
    '\ud7e7', '\ud7e8', '\ud7e9', '\ud7ea', '\ud7eb', '\ud7ec', '\ud7ed', '\ud7ee', 
    '\ud7ef', '\ud7f0', '\ud7f1', '\ud7f2', '\ud7f3', '\ud7f4', '\ud7f5', '\ud7f6', 
    '\ud7f7', '\ud7f8', '\ud7f9', '\ud7fa', '\ud7fb', '\ufb00', '\ufb01', '\ufb02', 
    '\ufb03', '\ufb04', '\ufb05', '\ufb06', '\ufb13', '\ufb14', '\ufb15', '\ufb16', 
    '\ufb17', '\ufb50', '\ufb51', '\ufb52', '\ufb53', '\ufb54', '\ufb55', '\ufb56', 
    '\ufb57', '\ufb58', '\ufb59', '\ufb5a', '\ufb5b', '\ufb5c', '\ufb5d', '\ufb5e', 
    '\ufb5f', '\ufb60', '\ufb61', '\ufb62', '\ufb63', '\ufb64', '\ufb65', '\ufb66', 
    '\ufb67', '\ufb68', '\ufb69', '\ufb6a', '\ufb6b', '\ufb6c', '\ufb6d', '\ufb6e', 
    '\ufb6f', '\ufb70', '\ufb71', '\ufb72', '\ufb73', '\ufb74', '\ufb75', '\ufb76', 
    '\ufb77', '\ufb78', '\ufb79', '\ufb7a', '\ufb7b', '\ufb7c', '\ufb7d', '\ufb7e', 
    '\ufb7f', '\ufb80', '\ufb81', '\ufb82', '\ufb83', '\ufb84', '\ufb85', '\ufb86', 
    '\ufb87', '\ufb88', '\ufb89', '\ufb8a', '\ufb8b', '\ufb8c', '\ufb8d', '\ufb8e', 
    '\ufb8f', '\ufb90', '\ufb91', '\ufb92', '\ufb93', '\ufb94', '\ufb95', '\ufb96', 
    '\ufb97', '\ufb98', '\ufb99', '\ufb9a', '\ufb9b', '\ufb9c', '\ufb9d', '\ufb9e', 
    '\ufb9f', '\ufba0', '\ufba1', '\ufba2', '\ufba3', '\ufba4', '\ufba5', '\ufba6', 
    '\ufba7', '\ufba8', '\ufba9', '\ufbaa', '\ufbab', '\ufbac', '\ufbad', '\ufbae', 
    '\ufbaf', '\ufbb0', '\ufbb1', '\ufbd3', '\ufbd4', '\ufbd5', '\ufbd6', '\ufbd7', 
    '\ufbd8', '\ufbd9', '\ufbda', '\ufbdb', '\ufbdc', '\ufbdd', '\ufbde', '\ufbdf', 
    '\ufbe0', '\ufbe1', '\ufbe2', '\ufbe3', '\ufbe4', '\ufbe5', '\ufbe6', '\ufbe7', 
    '\ufbe8', '\ufbe9', '\ufbea', '\ufbeb', '\ufbec', '\ufbed', '\ufbee', '\ufbef', 
    '\ufbf0', '\ufbf1', '\ufbf2', '\ufbf3', '\ufbf4', '\ufbf5', '\ufbf6', '\ufbf7', 
    '\ufbf8', '\ufbf9', '\ufbfa', '\ufbfb', '\ufbfc', '\ufbfd', '\ufbfe', '\ufbff', 
    '\ufc00', '\ufc01', '\ufc02', '\ufc03', '\ufc04', '\ufc05', '\ufc06', '\ufc07', 
    '\ufc08', '\ufc09', '\ufc0a', '\ufc0b', '\ufc0c', '\ufc0d', '\ufc0e', '\ufc0f', 
    '\ufc10', '\ufc11', '\ufc12', '\ufc13', '\ufc14', '\ufc15', '\ufc16', '\ufc17', 
    '\ufc18', '\ufc19', '\ufc1a', '\ufc1b', '\ufc1c', '\ufc1d', '\ufc1e', '\ufc1f', 
    '\ufc20', '\ufc21', '\ufc22', '\ufc23', '\ufc24', '\ufc25', '\ufc26', '\ufc27', 
    '\ufc28', '\ufc29', '\ufc2a', '\ufc2b', '\ufc2c', '\ufc2d', '\ufc2e', '\ufc2f', 
    '\ufc30', '\ufc31', '\ufc32', '\ufc33', '\ufc34', '\ufc35', '\ufc36', '\ufc37', 
    '\ufc38', '\ufc39', '\ufc3a', '\ufc3b', '\ufc3c', '\ufc3d', '\ufc3e', '\ufc3f', 
    '\ufc40', '\ufc41', '\ufc42', '\ufc43', '\ufc44', '\ufc45', '\ufc46', '\ufc47', 
    '\ufc48', '\ufc49', '\ufc4a', '\ufc4b', '\ufc4c', '\ufc4d', '\ufc4e', '\ufc4f', 
    '\ufc50', '\ufc51', '\ufc52', '\ufc53', '\ufc54', '\ufc55', '\ufc56', '\ufc57', 
    '\ufc58', '\ufc59', '\ufc5a', '\ufc5b', '\ufc5c', '\ufc5d', '\ufc5e', '\ufc5f', 
    '\ufc60', '\ufc61', '\ufc62', '\ufc63', '\ufc64', '\ufc65', '\ufc66', '\ufc67', 
    '\ufc68', '\ufc69', '\ufc6a', '\ufc6b', '\ufc6c', '\ufc6d', '\ufc6e', '\ufc6f', 
    '\ufc70', '\ufc71', '\ufc72', '\ufc73', '\ufc74', '\ufc75', '\ufc76', '\ufc77', 
    '\ufc78', '\ufc79', '\ufc7a', '\ufc7b', '\ufc7c', '\ufc7d', '\ufc7e', '\ufc7f', 
    '\ufc80', '\ufc81', '\ufc82', '\ufc83', '\ufc84', '\ufc85', '\ufc86', '\ufc87', 
    '\ufc88', '\ufc89', '\ufc8a', '\ufc8b', '\ufc8c', '\ufc8d', '\ufc8e', '\ufc8f', 
    '\ufc90', '\ufc91', '\ufc92', '\ufc93', '\ufc94', '\ufc95', '\ufc96', '\ufc97', 
    '\ufc98', '\ufc99', '\ufc9a', '\ufc9b', '\ufc9c', '\ufc9d', '\ufc9e', '\ufc9f', 
    '\ufca0', '\ufca1', '\ufca2', '\ufca3', '\ufca4', '\ufca5', '\ufca6', '\ufca7', 
    '\ufca8', '\ufca9', '\ufcaa', '\ufcab', '\ufcac', '\ufcad', '\ufcae', '\ufcaf', 
    '\ufcb0', '\ufcb1', '\ufcb2', '\ufcb3', '\ufcb4', '\ufcb5', '\ufcb6', '\ufcb7', 
    '\ufcb8', '\ufcb9', '\ufcba', '\ufcbb', '\ufcbc', '\ufcbd', '\ufcbe', '\ufcbf', 
    '\ufcc0', '\ufcc1', '\ufcc2', '\ufcc3', '\ufcc4', '\ufcc5', '\ufcc6', '\ufcc7', 
    '\ufcc8', '\ufcc9', '\ufcca', '\ufccb', '\ufccc', '\ufccd', '\ufcce', '\ufccf', 
    '\ufcd0', '\ufcd1', '\ufcd2', '\ufcd3', '\ufcd4', '\ufcd5', '\ufcd6', '\ufcd7', 
    '\ufcd8', '\ufcd9', '\ufcda', '\ufcdb', '\ufcdc', '\ufcdd', '\ufcde', '\ufcdf', 
    '\ufce0', '\ufce1', '\ufce2', '\ufce3', '\ufce4', '\ufce5', '\ufce6', '\ufce7', 
    '\ufce8', '\ufce9', '\ufcea', '\ufceb', '\ufcec', '\ufced', '\ufcee', '\ufcef', 
    '\ufcf0', '\ufcf1', '\ufcf2', '\ufcf3', '\ufcf4', '\ufcf5', '\ufcf6', '\ufcf7', 
    '\ufcf8', '\ufcf9', '\ufcfa', '\ufcfb', '\ufcfc', '\ufcfd', '\ufcfe', '\ufcff', 
    '\ufd00', '\ufd01', '\ufd02', '\ufd03', '\ufd04', '\ufd05', '\ufd06', '\ufd07', 
    '\ufd08', '\ufd09', '\ufd0a', '\ufd0b', '\ufd0c', '\ufd0d', '\ufd0e', '\ufd0f', 
    '\ufd10', '\ufd11', '\ufd12', '\ufd13', '\ufd14', '\ufd15', '\ufd16', '\ufd17', 
    '\ufd18', '\ufd19', '\ufd1a', '\ufd1b', '\ufd1c', '\ufd1d', '\ufd1e', '\ufd1f', 
    '\ufd20', '\ufd21', '\ufd22', '\ufd23', '\ufd24', '\ufd25', '\ufd26', '\ufd27', 
    '\ufd28', '\ufd29', '\ufd2a', '\ufd2b', '\ufd2c', '\ufd2d', '\ufd2e', '\ufd2f', 
    '\ufd30', '\ufd31', '\ufd32', '\ufd33', '\ufd34', '\ufd35', '\ufd36', '\ufd37', 
    '\ufd38', '\ufd39', '\ufd3a', '\ufd3b', '\ufd3c', '\ufd3d', '\ufd50', '\ufd51', 
    '\ufd52', '\ufd53', '\ufd54', '\ufd55', '\ufd56', '\ufd57', '\ufd58', '\ufd59', 
    '\ufd5a', '\ufd5b', '\ufd5c', '\ufd5d', '\ufd5e', '\ufd5f', '\ufd60', '\ufd61', 
    '\ufd62', '\ufd63', '\ufd64', '\ufd65', '\ufd66', '\ufd67', '\ufd68', '\ufd69', 
    '\ufd6a', '\ufd6b', '\ufd6c', '\ufd6d', '\ufd6e', '\ufd6f', '\ufd70', '\ufd71', 
    '\ufd72', '\ufd73', '\ufd74', '\ufd75', '\ufd76', '\ufd77', '\ufd78', '\ufd79', 
    '\ufd7a', '\ufd7b', '\ufd7c', '\ufd7d', '\ufd7e', '\ufd7f', '\ufd80', '\ufd81', 
    '\ufd82', '\ufd83', '\ufd84', '\ufd85', '\ufd86', '\ufd87', '\ufd88', '\ufd89', 
    '\ufd8a', '\ufd8b', '\ufd8c', '\ufd8d', '\ufd8e', '\ufd8f', '\ufd92', '\ufd93', 
    '\ufd94', '\ufd95', '\ufd96', '\ufd97', '\ufd98', '\ufd99', '\ufd9a', '\ufd9b', 
    '\ufd9c', '\ufd9d', '\ufd9e', '\ufd9f', '\ufda0', '\ufda1', '\ufda2', '\ufda3', 
    '\ufda4', '\ufda5', '\ufda6', '\ufda7', '\ufda8', '\ufda9', '\ufdaa', '\ufdab', 
    '\ufdac', '\ufdad', '\ufdae', '\ufdaf', '\ufdb0', '\ufdb1', '\ufdb2', '\ufdb3', 
    '\ufdb4', '\ufdb5', '\ufdb6', '\ufdb7', '\ufdb8', '\ufdb9', '\ufdba', '\ufdbb', 
    '\ufdbc', '\ufdbd', '\ufdbe', '\ufdbf', '\ufdc0', '\ufdc1', '\ufdc2', '\ufdc3', 
    '\ufdc4', '\ufdc5', '\ufdc6', '\ufdc7', '\ufdf0', '\ufdf1', '\ufdf2', '\ufdf3', 
    '\ufdf4', '\ufdf5', '\ufdf6', '\ufdf7', '\ufdf8', '\ufdf9', '\ufdfa', '\ufdfb', 
    '\ufe70', '\ufe71', '\ufe72', '\ufe73', '\ufe74', '\ufe76', '\ufe77', '\ufe78', 
    '\ufe79', '\ufe7a', '\ufe7b', '\ufe7c', '\ufe7d', '\ufe7e', '\ufe7f', '\ufe80', 
    '\ufe81', '\ufe82', '\ufe83', '\ufe84', '\ufe85', '\ufe86', '\ufe87', '\ufe88', 
    '\ufe89', '\ufe8a', '\ufe8b', '\ufe8c', '\ufe8d', '\ufe8e', '\ufe8f', '\ufe90', 
    '\ufe91', '\ufe92', '\ufe93', '\ufe94', '\ufe95', '\ufe96', '\ufe97', '\ufe98', 
    '\ufe99', '\ufe9a', '\ufe9b', '\ufe9c', '\ufe9d', '\ufe9e', '\ufe9f', '\ufea0', 
    '\ufea1', '\ufea2', '\ufea3', '\ufea4', '\ufea5', '\ufea6', '\ufea7', '\ufea8', 
    '\ufea9', '\ufeaa', '\ufeab', '\ufeac', '\ufead', '\ufeae', '\ufeaf', '\ufeb0', 
    '\ufeb1', '\ufeb2', '\ufeb3', '\ufeb4', '\ufeb5', '\ufeb6', '\ufeb7', '\ufeb8', 
    '\ufeb9', '\ufeba', '\ufebb', '\ufebc', '\ufebd', '\ufebe', '\ufebf', '\ufec0', 
    '\ufec1', '\ufec2', '\ufec3', '\ufec4', '\ufec5', '\ufec6', '\ufec7', '\ufec8', 
    '\ufec9', '\ufeca', '\ufecb', '\ufecc', '\ufecd', '\ufece', '\ufecf', '\ufed0', 
    '\ufed1', '\ufed2', '\ufed3', '\ufed4', '\ufed5', '\ufed6', '\ufed7', '\ufed8', 
    '\ufed9', '\ufeda', '\ufedb', '\ufedc', '\ufedd', '\ufede', '\ufedf', '\ufee0', 
    '\ufee1', '\ufee2', '\ufee3', '\ufee4', '\ufee5', '\ufee6', '\ufee7', '\ufee8', 
    '\ufee9', '\ufeea', '\ufeeb', '\ufeec', '\ufeed', '\ufeee', '\ufeef', '\ufef0', 
    '\ufef1', '\ufef2', '\ufef3', '\ufef4', '\ufef5', '\ufef6', '\ufef7', '\ufef8', 
    '\ufef9', '\ufefa', '\ufefb', '\ufefc', '\uff21', '\uff22', '\uff23', '\uff24', 
    '\uff25', '\uff26', '\uff27', '\uff28', '\uff29', '\uff2a', '\uff2b', '\uff2c', 
    '\uff2d', '\uff2e', '\uff2f', '\uff30', '\uff31', '\uff32', '\uff33', '\uff34', 
    '\uff35', '\uff36', '\uff37', '\uff38', '\uff39', '\uff3a', '\uff41', '\uff42', 
    '\uff43', '\uff44', '\uff45', '\uff46', '\uff47', '\uff48', '\uff49', '\uff4a', 
    '\uff4b', '\uff4c', '\uff4d', '\uff4e', '\uff4f', '\uff50', '\uff51', '\uff52', 
    '\uff53', '\uff54', '\uff55', '\uff56', '\uff57', '\uff58', '\uff59', '\uff5a', 
    '\uffa0', '\uffa1', '\uffa2', '\uffa3', '\uffa4', '\uffa5', '\uffa6', '\uffa7', 
    '\uffa8', '\uffa9', '\uffaa', '\uffab', '\uffac', '\uffad', '\uffae', '\uffaf', 
    '\uffb0', '\uffb1', '\uffb2', '\uffb3', '\uffb4', '\uffb5', '\uffb6', '\uffb7', 
    '\uffb8', '\uffb9', '\uffba', '\uffbb', '\uffbc', '\uffbd', '\uffbe', '\uffc2', 
    '\uffc3', '\uffc4', '\uffc5', '\uffc6', '\uffc7', '\uffca', '\uffcb', '\uffcc', 
    '\uffcd', '\uffce', '\uffcf', '\uffd2', '\uffd3', '\uffd4', '\uffd5', '\uffd6', 
    '\uffd7', '\uffda', '\uffdb', '\uffdc', '\U00010000', '\U00010001', '\U00010002', '\U00010003', 
    '\U00010004', '\U00010005', '\U00010006', '\U00010007', '\U00010008', '\U00010009', '\U0001000a', '\U0001000b', 
    '\U0001000d', '\U0001000e', '\U0001000f', '\U00010010', '\U00010011', '\U00010012', '\U00010013', '\U00010014', 
    '\U00010015', '\U00010016', '\U00010017', '\U00010018', '\U00010019', '\U0001001a', '\U0001001b', '\U0001001c', 
    '\U0001001d', '\U0001001e', '\U0001001f', '\U00010020', '\U00010021', '\U00010022', '\U00010023', '\U00010024', 
    '\U00010025', '\U00010026', '\U00010028', '\U00010029', '\U0001002a', '\U0001002b', '\U0001002c', '\U0001002d', 
    '\U0001002e', '\U0001002f', '\U00010030', '\U00010031', '\U00010032', '\U00010033', '\U00010034', '\U00010035', 
    '\U00010036', '\U00010037', '\U00010038', '\U00010039', '\U0001003a', '\U0001003c', '\U0001003d', '\U0001003f', 
    '\U00010040', '\U00010041', '\U00010042', '\U00010043', '\U00010044', '\U00010045', '\U00010046', '\U00010047', 
    '\U00010048', '\U00010049', '\U0001004a', '\U0001004b', '\U0001004c', '\U0001004d', '\U00010050', '\U00010051', 
    '\U00010052', '\U00010053', '\U00010054', '\U00010055', '\U00010056', '\U00010057', '\U00010058', '\U00010059', 
    '\U0001005a', '\U0001005b', '\U0001005c', '\U0001005d', '\U00010080', '\U00010081', '\U00010082', '\U00010083', 
    '\U00010084', '\U00010085', '\U00010086', '\U00010087', '\U00010088', '\U00010089', '\U0001008a', '\U0001008b', 
    '\U0001008c', '\U0001008d', '\U0001008e', '\U0001008f', '\U00010090', '\U00010091', '\U00010092', '\U00010093', 
    '\U00010094', '\U00010095', '\U00010096', '\U00010097', '\U00010098', '\U00010099', '\U0001009a', '\U0001009b', 
    '\U0001009c', '\U0001009d', '\U0001009e', '\U0001009f', '\U000100a0', '\U000100a1', '\U000100a2', '\U000100a3', 
    '\U000100a4', '\U000100a5', '\U000100a6', '\U000100a7', '\U000100a8', '\U000100a9', '\U000100aa', '\U000100ab', 
    '\U000100ac', '\U000100ad', '\U000100ae', '\U000100af', '\U000100b0', '\U000100b1', '\U000100b2', '\U000100b3', 
    '\U000100b4', '\U000100b5', '\U000100b6', '\U000100b7', '\U000100b8', '\U000100b9', '\U000100ba', '\U000100bb', 
    '\U000100bc', '\U000100bd', '\U000100be', '\U000100bf', '\U000100c0', '\U000100c1', '\U000100c2', '\U000100c3', 
    '\U000100c4', '\U000100c5', '\U000100c6', '\U000100c7', '\U000100c8', '\U000100c9', '\U000100ca', '\U000100cb', 
    '\U000100cc', '\U000100cd', '\U000100ce', '\U000100cf', '\U000100d0', '\U000100d1', '\U000100d2', '\U000100d3', 
    '\U000100d4', '\U000100d5', '\U000100d6', '\U000100d7', '\U000100d8', '\U000100d9', '\U000100da', '\U000100db', 
    '\U000100dc', '\U000100dd', '\U000100de', '\U000100df', '\U000100e0', '\U000100e1', '\U000100e2', '\U000100e3', 
    '\U000100e4', '\U000100e5', '\U000100e6', '\U000100e7', '\U000100e8', '\U000100e9', '\U000100ea', '\U000100eb', 
    '\U000100ec', '\U000100ed', '\U000100ee', '\U000100ef', '\U000100f0', '\U000100f1', '\U000100f2', '\U000100f3', 
    '\U000100f4', '\U000100f5', '\U000100f6', '\U000100f7', '\U000100f8', '\U000100f9', '\U000100fa', '\U00010140', 
    '\U00010141', '\U00010142', '\U00010143', '\U00010144', '\U00010145', '\U00010146', '\U00010147', '\U00010148', 
    '\U00010149', '\U0001014a', '\U0001014b', '\U0001014c', '\U0001014d', '\U0001014e', '\U0001014f', '\U00010150', 
    '\U00010151', '\U00010152', '\U00010153', '\U00010154', '\U00010155', '\U00010156', '\U00010157', '\U00010158', 
    '\U00010159', '\U0001015a', '\U0001015b', '\U0001015c', '\U0001015d', '\U0001015e', '\U0001015f', '\U00010160', 
    '\U00010161', '\U00010162', '\U00010163', '\U00010164', '\U00010165', '\U00010166', '\U00010167', '\U00010168', 
    '\U00010169', '\U0001016a', '\U0001016b', '\U0001016c', '\U0001016d', '\U0001016e', '\U0001016f', '\U00010170', 
    '\U00010171', '\U00010172', '\U00010173', '\U00010174', '\U00010280', '\U00010281', '\U00010282', '\U00010283', 
    '\U00010284', '\U00010285', '\U00010286', '\U00010287', '\U00010288', '\U00010289', '\U0001028a', '\U0001028b', 
    '\U0001028c', '\U0001028d', '\U0001028e', '\U0001028f', '\U00010290', '\U00010291', '\U00010292', '\U00010293', 
    '\U00010294', '\U00010295', '\U00010296', '\U00010297', '\U00010298', '\U00010299', '\U0001029a', '\U0001029b', 
    '\U0001029c', '\U000102a0', '\U000102a1', '\U000102a2', '\U000102a3', '\U000102a4', '\U000102a5', '\U000102a6', 
    '\U000102a7', '\U000102a8', '\U000102a9', '\U000102aa', '\U000102ab', '\U000102ac', '\U000102ad', '\U000102ae', 
    '\U000102af', '\U000102b0', '\U000102b1', '\U000102b2', '\U000102b3', '\U000102b4', '\U000102b5', '\U000102b6', 
    '\U000102b7', '\U000102b8', '\U000102b9', '\U000102ba', '\U000102bb', '\U000102bc', '\U000102bd', '\U000102be', 
    '\U000102bf', '\U000102c0', '\U000102c1', '\U000102c2', '\U000102c3', '\U000102c4', '\U000102c5', '\U000102c6', 
    '\U000102c7', '\U000102c8', '\U000102c9', '\U000102ca', '\U000102cb', '\U000102cc', '\U000102cd', '\U000102ce', 
    '\U000102cf', '\U000102d0', '\U00010300', '\U00010301', '\U00010302', '\U00010303', '\U00010304', '\U00010305', 
    '\U00010306', '\U00010307', '\U00010308', '\U00010309', '\U0001030a', '\U0001030b', '\U0001030c', '\U0001030d', 
    '\U0001030e', '\U0001030f', '\U00010310', '\U00010311', '\U00010312', '\U00010313', '\U00010314', '\U00010315', 
    '\U00010316', '\U00010317', '\U00010318', '\U00010319', '\U0001031a', '\U0001031b', '\U0001031c', '\U0001031d', 
    '\U0001031e', '\U0001031f', '\U0001032d', '\U0001032e', '\U0001032f', '\U00010330', '\U00010331', '\U00010332', 
    '\U00010333', '\U00010334', '\U00010335', '\U00010336', '\U00010337', '\U00010338', '\U00010339', '\U0001033a', 
    '\U0001033b', '\U0001033c', '\U0001033d', '\U0001033e', '\U0001033f', '\U00010340', '\U00010341', '\U00010342', 
    '\U00010343', '\U00010344', '\U00010345', '\U00010346', '\U00010347', '\U00010348', '\U00010349', '\U0001034a', 
    '\U00010350', '\U00010351', '\U00010352', '\U00010353', '\U00010354', '\U00010355', '\U00010356', '\U00010357', 
    '\U00010358', '\U00010359', '\U0001035a', '\U0001035b', '\U0001035c', '\U0001035d', '\U0001035e', '\U0001035f', 
    '\U00010360', '\U00010361', '\U00010362', '\U00010363', '\U00010364', '\U00010365', '\U00010366', '\U00010367', 
    '\U00010368', '\U00010369', '\U0001036a', '\U0001036b', '\U0001036c', '\U0001036d', '\U0001036e', '\U0001036f', 
    '\U00010370', '\U00010371', '\U00010372', '\U00010373', '\U00010374', '\U00010375', '\U00010380', '\U00010381', 
    '\U00010382', '\U00010383', '\U00010384', '\U00010385', '\U00010386', '\U00010387', '\U00010388', '\U00010389', 
    '\U0001038a', '\U0001038b', '\U0001038c', '\U0001038d', '\U0001038e', '\U0001038f', '\U00010390', '\U00010391', 
    '\U00010392', '\U00010393', '\U00010394', '\U00010395', '\U00010396', '\U00010397', '\U00010398', '\U00010399', 
    '\U0001039a', '\U0001039b', '\U0001039c', '\U0001039d', '\U000103a0', '\U000103a1', '\U000103a2', '\U000103a3', 
    '\U000103a4', '\U000103a5', '\U000103a6', '\U000103a7', '\U000103a8', '\U000103a9', '\U000103aa', '\U000103ab', 
    '\U000103ac', '\U000103ad', '\U000103ae', '\U000103af', '\U000103b0', '\U000103b1', '\U000103b2', '\U000103b3', 
    '\U000103b4', '\U000103b5', '\U000103b6', '\U000103b7', '\U000103b8', '\U000103b9', '\U000103ba', '\U000103bb', 
    '\U000103bc', '\U000103bd', '\U000103be', '\U000103bf', '\U000103c0', '\U000103c1', '\U000103c2', '\U000103c3', 
    '\U000103c8', '\U000103c9', '\U000103ca', '\U000103cb', '\U000103cc', '\U000103cd', '\U000103ce', '\U000103cf', 
    '\U000103d1', '\U000103d2', '\U000103d3', '\U000103d4', '\U000103d5', '\U00010400', '\U00010401', '\U00010402', 
    '\U00010403', '\U00010404', '\U00010405', '\U00010406', '\U00010407', '\U00010408', '\U00010409', '\U0001040a', 
    '\U0001040b', '\U0001040c', '\U0001040d', '\U0001040e', '\U0001040f', '\U00010410', '\U00010411', '\U00010412', 
    '\U00010413', '\U00010414', '\U00010415', '\U00010416', '\U00010417', '\U00010418', '\U00010419', '\U0001041a', 
    '\U0001041b', '\U0001041c', '\U0001041d', '\U0001041e', '\U0001041f', '\U00010420', '\U00010421', '\U00010422', 
    '\U00010423', '\U00010424', '\U00010425', '\U00010426', '\U00010427', '\U00010428', '\U00010429', '\U0001042a', 
    '\U0001042b', '\U0001042c', '\U0001042d', '\U0001042e', '\U0001042f', '\U00010430', '\U00010431', '\U00010432', 
    '\U00010433', '\U00010434', '\U00010435', '\U00010436', '\U00010437', '\U00010438', '\U00010439', '\U0001043a', 
    '\U0001043b', '\U0001043c', '\U0001043d', '\U0001043e', '\U0001043f', '\U00010440', '\U00010441', '\U00010442', 
    '\U00010443', '\U00010444', '\U00010445', '\U00010446', '\U00010447', '\U00010448', '\U00010449', '\U0001044a', 
    '\U0001044b', '\U0001044c', '\U0001044d', '\U0001044e', '\U0001044f', '\U00010450', '\U00010451', '\U00010452', 
    '\U00010453', '\U00010454', '\U00010455', '\U00010456', '\U00010457', '\U00010458', '\U00010459', '\U0001045a', 
    '\U0001045b', '\U0001045c', '\U0001045d', '\U0001045e', '\U0001045f', '\U00010460', '\U00010461', '\U00010462', 
    '\U00010463', '\U00010464', '\U00010465', '\U00010466', '\U00010467', '\U00010468', '\U00010469', '\U0001046a', 
    '\U0001046b', '\U0001046c', '\U0001046d', '\U0001046e', '\U0001046f', '\U00010470', '\U00010471', '\U00010472', 
    '\U00010473', '\U00010474', '\U00010475', '\U00010476', '\U00010477', '\U00010478', '\U00010479', '\U0001047a', 
    '\U0001047b', '\U0001047c', '\U0001047d', '\U0001047e', '\U0001047f', '\U00010480', '\U00010481', '\U00010482', 
    '\U00010483', '\U00010484', '\U00010485', '\U00010486', '\U00010487', '\U00010488', '\U00010489', '\U0001048a', 
    '\U0001048b', '\U0001048c', '\U0001048d', '\U0001048e', '\U0001048f', '\U00010490', '\U00010491', '\U00010492', 
    '\U00010493', '\U00010494', '\U00010495', '\U00010496', '\U00010497', '\U00010498', '\U00010499', '\U0001049a', 
    '\U0001049b', '\U0001049c', '\U0001049d', '\U000104b0', '\U000104b1', '\U000104b2', '\U000104b3', '\U000104b4', 
    '\U000104b5', '\U000104b6', '\U000104b7', '\U000104b8', '\U000104b9', '\U000104ba', '\U000104bb', '\U000104bc', 
    '\U000104bd', '\U000104be', '\U000104bf', '\U000104c0', '\U000104c1', '\U000104c2', '\U000104c3', '\U000104c4', 
    '\U000104c5', '\U000104c6', '\U000104c7', '\U000104c8', '\U000104c9', '\U000104ca', '\U000104cb', '\U000104cc', 
    '\U000104cd', '\U000104ce', '\U000104cf', '\U000104d0', '\U000104d1', '\U000104d2', '\U000104d3', '\U000104d8', 
    '\U000104d9', '\U000104da', '\U000104db', '\U000104dc', '\U000104dd', '\U000104de', '\U000104df', '\U000104e0', 
    '\U000104e1', '\U000104e2', '\U000104e3', '\U000104e4', '\U000104e5', '\U000104e6', '\U000104e7', '\U000104e8', 
    '\U000104e9', '\U000104ea', '\U000104eb', '\U000104ec', '\U000104ed', '\U000104ee', '\U000104ef', '\U000104f0', 
    '\U000104f1', '\U000104f2', '\U000104f3', '\U000104f4', '\U000104f5', '\U000104f6', '\U000104f7', '\U000104f8', 
    '\U000104f9', '\U000104fa', '\U000104fb', '\U00010500', '\U00010501', '\U00010502', '\U00010503', '\U00010504', 
    '\U00010505', '\U00010506', '\U00010507', '\U00010508', '\U00010509', '\U0001050a', '\U0001050b', '\U0001050c', 
    '\U0001050d', '\U0001050e', '\U0001050f', '\U00010510', '\U00010511', '\U00010512', '\U00010513', '\U00010514', 
    '\U00010515', '\U00010516', '\U00010517', '\U00010518', '\U00010519', '\U0001051a', '\U0001051b', '\U0001051c', 
    '\U0001051d', '\U0001051e', '\U0001051f', '\U00010520', '\U00010521', '\U00010522', '\U00010523', '\U00010524', 
    '\U00010525', '\U00010526', '\U00010527', '\U00010530', '\U00010531', '\U00010532', '\U00010533', '\U00010534', 
    '\U00010535', '\U00010536', '\U00010537', '\U00010538', '\U00010539', '\U0001053a', '\U0001053b', '\U0001053c', 
    '\U0001053d', '\U0001053e', '\U0001053f', '\U00010540', '\U00010541', '\U00010542', '\U00010543', '\U00010544', 
    '\U00010545', '\U00010546', '\U00010547', '\U00010548', '\U00010549', '\U0001054a', '\U0001054b', '\U0001054c', 
    '\U0001054d', '\U0001054e', '\U0001054f', '\U00010550', '\U00010551', '\U00010552', '\U00010553', '\U00010554', 
    '\U00010555', '\U00010556', '\U00010557', '\U00010558', '\U00010559', '\U0001055a', '\U0001055b', '\U0001055c', 
    '\U0001055d', '\U0001055e', '\U0001055f', '\U00010560', '\U00010561', '\U00010562', '\U00010563', '\U00010600', 
    '\U00010601', '\U00010602', '\U00010603', '\U00010604', '\U00010605', '\U00010606', '\U00010607', '\U00010608', 
    '\U00010609', '\U0001060a', '\U0001060b', '\U0001060c', '\U0001060d', '\U0001060e', '\U0001060f', '\U00010610', 
    '\U00010611', '\U00010612', '\U00010613', '\U00010614', '\U00010615', '\U00010616', '\U00010617', '\U00010618', 
    '\U00010619', '\U0001061a', '\U0001061b', '\U0001061c', '\U0001061d', '\U0001061e', '\U0001061f', '\U00010620', 
    '\U00010621', '\U00010622', '\U00010623', '\U00010624', '\U00010625', '\U00010626', '\U00010627', '\U00010628', 
    '\U00010629', '\U0001062a', '\U0001062b', '\U0001062c', '\U0001062d', '\U0001062e', '\U0001062f', '\U00010630', 
    '\U00010631', '\U00010632', '\U00010633', '\U00010634', '\U00010635', '\U00010636', '\U00010637', '\U00010638', 
    '\U00010639', '\U0001063a', '\U0001063b', '\U0001063c', '\U0001063d', '\U0001063e', '\U0001063f', '\U00010640', 
    '\U00010641', '\U00010642', '\U00010643', '\U00010644', '\U00010645', '\U00010646', '\U00010647', '\U00010648', 
    '\U00010649', '\U0001064a', '\U0001064b', '\U0001064c', '\U0001064d', '\U0001064e', '\U0001064f', '\U00010650', 
    '\U00010651', '\U00010652', '\U00010653', '\U00010654', '\U00010655', '\U00010656', '\U00010657', '\U00010658', 
    '\U00010659', '\U0001065a', '\U0001065b', '\U0001065c', '\U0001065d', '\U0001065e', '\U0001065f', '\U00010660', 
    '\U00010661', '\U00010662', '\U00010663', '\U00010664', '\U00010665', '\U00010666', '\U00010667', '\U00010668', 
    '\U00010669', '\U0001066a', '\U0001066b', '\U0001066c', '\U0001066d', '\U0001066e', '\U0001066f', '\U00010670', 
    '\U00010671', '\U00010672', '\U00010673', '\U00010674', '\U00010675', '\U00010676', '\U00010677', '\U00010678', 
    '\U00010679', '\U0001067a', '\U0001067b', '\U0001067c', '\U0001067d', '\U0001067e', '\U0001067f', '\U00010680', 
    '\U00010681', '\U00010682', '\U00010683', '\U00010684', '\U00010685', '\U00010686', '\U00010687', '\U00010688', 
    '\U00010689', '\U0001068a', '\U0001068b', '\U0001068c', '\U0001068d', '\U0001068e', '\U0001068f', '\U00010690', 
    '\U00010691', '\U00010692', '\U00010693', '\U00010694', '\U00010695', '\U00010696', '\U00010697', '\U00010698', 
    '\U00010699', '\U0001069a', '\U0001069b', '\U0001069c', '\U0001069d', '\U0001069e', '\U0001069f', '\U000106a0', 
    '\U000106a1', '\U000106a2', '\U000106a3', '\U000106a4', '\U000106a5', '\U000106a6', '\U000106a7', '\U000106a8', 
    '\U000106a9', '\U000106aa', '\U000106ab', '\U000106ac', '\U000106ad', '\U000106ae', '\U000106af', '\U000106b0', 
    '\U000106b1', '\U000106b2', '\U000106b3', '\U000106b4', '\U000106b5', '\U000106b6', '\U000106b7', '\U000106b8', 
    '\U000106b9', '\U000106ba', '\U000106bb', '\U000106bc', '\U000106bd', '\U000106be', '\U000106bf', '\U000106c0', 
    '\U000106c1', '\U000106c2', '\U000106c3', '\U000106c4', '\U000106c5', '\U000106c6', '\U000106c7', '\U000106c8', 
    '\U000106c9', '\U000106ca', '\U000106cb', '\U000106cc', '\U000106cd', '\U000106ce', '\U000106cf', '\U000106d0', 
    '\U000106d1', '\U000106d2', '\U000106d3', '\U000106d4', '\U000106d5', '\U000106d6', '\U000106d7', '\U000106d8', 
    '\U000106d9', '\U000106da', '\U000106db', '\U000106dc', '\U000106dd', '\U000106de', '\U000106df', '\U000106e0', 
    '\U000106e1', '\U000106e2', '\U000106e3', '\U000106e4', '\U000106e5', '\U000106e6', '\U000106e7', '\U000106e8', 
    '\U000106e9', '\U000106ea', '\U000106eb', '\U000106ec', '\U000106ed', '\U000106ee', '\U000106ef', '\U000106f0', 
    '\U000106f1', '\U000106f2', '\U000106f3', '\U000106f4', '\U000106f5', '\U000106f6', '\U000106f7', '\U000106f8', 
    '\U000106f9', '\U000106fa', '\U000106fb', '\U000106fc', '\U000106fd', '\U000106fe', '\U000106ff', '\U00010700', 
    '\U00010701', '\U00010702', '\U00010703', '\U00010704', '\U00010705', '\U00010706', '\U00010707', '\U00010708', 
    '\U00010709', '\U0001070a', '\U0001070b', '\U0001070c', '\U0001070d', '\U0001070e', '\U0001070f', '\U00010710', 
    '\U00010711', '\U00010712', '\U00010713', '\U00010714', '\U00010715', '\U00010716', '\U00010717', '\U00010718', 
    '\U00010719', '\U0001071a', '\U0001071b', '\U0001071c', '\U0001071d', '\U0001071e', '\U0001071f', '\U00010720', 
    '\U00010721', '\U00010722', '\U00010723', '\U00010724', '\U00010725', '\U00010726', '\U00010727', '\U00010728', 
    '\U00010729', '\U0001072a', '\U0001072b', '\U0001072c', '\U0001072d', '\U0001072e', '\U0001072f', '\U00010730', 
    '\U00010731', '\U00010732', '\U00010733', '\U00010734', '\U00010735', '\U00010736', '\U00010740', '\U00010741', 
    '\U00010742', '\U00010743', '\U00010744', '\U00010745', '\U00010746', '\U00010747', '\U00010748', '\U00010749', 
    '\U0001074a', '\U0001074b', '\U0001074c', '\U0001074d', '\U0001074e', '\U0001074f', '\U00010750', '\U00010751', 
    '\U00010752', '\U00010753', '\U00010754', '\U00010755', '\U00010760', '\U00010761', '\U00010762', '\U00010763', 
    '\U00010764', '\U00010765', '\U00010766', '\U00010767', '\U00010800', '\U00010801', '\U00010802', '\U00010803', 
    '\U00010804', '\U00010805', '\U00010808', '\U0001080a', '\U0001080b', '\U0001080c', '\U0001080d', '\U0001080e', 
    '\U0001080f', '\U00010810', '\U00010811', '\U00010812', '\U00010813', '\U00010814', '\U00010815', '\U00010816', 
    '\U00010817', '\U00010818', '\U00010819', '\U0001081a', '\U0001081b', '\U0001081c', '\U0001081d', '\U0001081e', 
    '\U0001081f', '\U00010820', '\U00010821', '\U00010822', '\U00010823', '\U00010824', '\U00010825', '\U00010826', 
    '\U00010827', '\U00010828', '\U00010829', '\U0001082a', '\U0001082b', '\U0001082c', '\U0001082d', '\U0001082e', 
    '\U0001082f', '\U00010830', '\U00010831', '\U00010832', '\U00010833', '\U00010834', '\U00010835', '\U00010837', 
    '\U00010838', '\U0001083c', '\U0001083f', '\U00010840', '\U00010841', '\U00010842', '\U00010843', '\U00010844', 
    '\U00010845', '\U00010846', '\U00010847', '\U00010848', '\U00010849', '\U0001084a', '\U0001084b', '\U0001084c', 
    '\U0001084d', '\U0001084e', '\U0001084f', '\U00010850', '\U00010851', '\U00010852', '\U00010853', '\U00010854', 
    '\U00010855', '\U00010860', '\U00010861', '\U00010862', '\U00010863', '\U00010864', '\U00010865', '\U00010866', 
    '\U00010867', '\U00010868', '\U00010869', '\U0001086a', '\U0001086b', '\U0001086c', '\U0001086d', '\U0001086e', 
    '\U0001086f', '\U00010870', '\U00010871', '\U00010872', '\U00010873', '\U00010874', '\U00010875', '\U00010876', 
    '\U00010880', '\U00010881', '\U00010882', '\U00010883', '\U00010884', '\U00010885', '\U00010886', '\U00010887', 
    '\U00010888', '\U00010889', '\U0001088a', '\U0001088b', '\U0001088c', '\U0001088d', '\U0001088e', '\U0001088f', 
    '\U00010890', '\U00010891', '\U00010892', '\U00010893', '\U00010894', '\U00010895', '\U00010896', '\U00010897', 
    '\U00010898', '\U00010899', '\U0001089a', '\U0001089b', '\U0001089c', '\U0001089d', '\U0001089e', '\U000108e0', 
    '\U000108e1', '\U000108e2', '\U000108e3', '\U000108e4', '\U000108e5', '\U000108e6', '\U000108e7', '\U000108e8', 
    '\U000108e9', '\U000108ea', '\U000108eb', '\U000108ec', '\U000108ed', '\U000108ee', '\U000108ef', '\U000108f0', 
    '\U000108f1', '\U000108f2', '\U000108f4', '\U000108f5', '\U00010900', '\U00010901', '\U00010902', '\U00010903', 
    '\U00010904', '\U00010905', '\U00010906', '\U00010907', '\U00010908', '\U00010909', '\U0001090a', '\U0001090b', 
    '\U0001090c', '\U0001090d', '\U0001090e', '\U0001090f', '\U00010910', '\U00010911', '\U00010912', '\U00010913', 
    '\U00010914', '\U00010915', '\U00010920', '\U00010921', '\U00010922', '\U00010923', '\U00010924', '\U00010925', 
    '\U00010926', '\U00010927', '\U00010928', '\U00010929', '\U0001092a', '\U0001092b', '\U0001092c', '\U0001092d', 
    '\U0001092e', '\U0001092f', '\U00010930', '\U00010931', '\U00010932', '\U00010933', '\U00010934', '\U00010935', 
    '\U00010936', '\U00010937', '\U00010938', '\U00010939', '\U00010980', '\U00010981', '\U00010982', '\U00010983', 
    '\U00010984', '\U00010985', '\U00010986', '\U00010987', '\U00010988', '\U00010989', '\U0001098a', '\U0001098b', 
    '\U0001098c', '\U0001098d', '\U0001098e', '\U0001098f', '\U00010990', '\U00010991', '\U00010992', '\U00010993', 
    '\U00010994', '\U00010995', '\U00010996', '\U00010997', '\U00010998', '\U00010999', '\U0001099a', '\U0001099b', 
    '\U0001099c', '\U0001099d', '\U0001099e', '\U0001099f', '\U000109a0', '\U000109a1', '\U000109a2', '\U000109a3', 
    '\U000109a4', '\U000109a5', '\U000109a6', '\U000109a7', '\U000109a8', '\U000109a9', '\U000109aa', '\U000109ab', 
    '\U000109ac', '\U000109ad', '\U000109ae', '\U000109af', '\U000109b0', '\U000109b1', '\U000109b2', '\U000109b3', 
    '\U000109b4', '\U000109b5', '\U000109b6', '\U000109b7', '\U000109be', '\U000109bf', '\U00010a00', '\U00010a10', 
    '\U00010a11', '\U00010a12', '\U00010a13', '\U00010a15', '\U00010a16', '\U00010a17', '\U00010a19', '\U00010a1a', 
    '\U00010a1b', '\U00010a1c', '\U00010a1d', '\U00010a1e', '\U00010a1f', '\U00010a20', '\U00010a21', '\U00010a22', 
    '\U00010a23', '\U00010a24', '\U00010a25', '\U00010a26', '\U00010a27', '\U00010a28', '\U00010a29', '\U00010a2a', 
    '\U00010a2b', '\U00010a2c', '\U00010a2d', '\U00010a2e', '\U00010a2f', '\U00010a30', '\U00010a31', '\U00010a32', 
    '\U00010a33', '\U00010a34', '\U00010a35', '\U00010a60', '\U00010a61', '\U00010a62', '\U00010a63', '\U00010a64', 
    '\U00010a65', '\U00010a66', '\U00010a67', '\U00010a68', '\U00010a69', '\U00010a6a', '\U00010a6b', '\U00010a6c', 
    '\U00010a6d', '\U00010a6e', '\U00010a6f', '\U00010a70', '\U00010a71', '\U00010a72', '\U00010a73', '\U00010a74', 
    '\U00010a75', '\U00010a76', '\U00010a77', '\U00010a78', '\U00010a79', '\U00010a7a', '\U00010a7b', '\U00010a7c', 
    '\U00010a80', '\U00010a81', '\U00010a82', '\U00010a83', '\U00010a84', '\U00010a85', '\U00010a86', '\U00010a87', 
    '\U00010a88', '\U00010a89', '\U00010a8a', '\U00010a8b', '\U00010a8c', '\U00010a8d', '\U00010a8e', '\U00010a8f', 
    '\U00010a90', '\U00010a91', '\U00010a92', '\U00010a93', '\U00010a94', '\U00010a95', '\U00010a96', '\U00010a97', 
    '\U00010a98', '\U00010a99', '\U00010a9a', '\U00010a9b', '\U00010a9c', '\U00010ac0', '\U00010ac1', '\U00010ac2', 
    '\U00010ac3', '\U00010ac4', '\U00010ac5', '\U00010ac6', '\U00010ac7', '\U00010ac9', '\U00010aca', '\U00010acb', 
    '\U00010acc', '\U00010acd', '\U00010ace', '\U00010acf', '\U00010ad0', '\U00010ad1', '\U00010ad2', '\U00010ad3', 
    '\U00010ad4', '\U00010ad5', '\U00010ad6', '\U00010ad7', '\U00010ad8', '\U00010ad9', '\U00010ada', '\U00010adb', 
    '\U00010adc', '\U00010add', '\U00010ade', '\U00010adf', '\U00010ae0', '\U00010ae1', '\U00010ae2', '\U00010ae3', 
    '\U00010ae4', '\U00010b00', '\U00010b01', '\U00010b02', '\U00010b03', '\U00010b04', '\U00010b05', '\U00010b06', 
    '\U00010b07', '\U00010b08', '\U00010b09', '\U00010b0a', '\U00010b0b', '\U00010b0c', '\U00010b0d', '\U00010b0e', 
    '\U00010b0f', '\U00010b10', '\U00010b11', '\U00010b12', '\U00010b13', '\U00010b14', '\U00010b15', '\U00010b16', 
    '\U00010b17', '\U00010b18', '\U00010b19', '\U00010b1a', '\U00010b1b', '\U00010b1c', '\U00010b1d', '\U00010b1e', 
    '\U00010b1f', '\U00010b20', '\U00010b21', '\U00010b22', '\U00010b23', '\U00010b24', '\U00010b25', '\U00010b26', 
    '\U00010b27', '\U00010b28', '\U00010b29', '\U00010b2a', '\U00010b2b', '\U00010b2c', '\U00010b2d', '\U00010b2e', 
    '\U00010b2f', '\U00010b30', '\U00010b31', '\U00010b32', '\U00010b33', '\U00010b34', '\U00010b35', '\U00010b40', 
    '\U00010b41', '\U00010b42', '\U00010b43', '\U00010b44', '\U00010b45', '\U00010b46', '\U00010b47', '\U00010b48', 
    '\U00010b49', '\U00010b4a', '\U00010b4b', '\U00010b4c', '\U00010b4d', '\U00010b4e', '\U00010b4f', '\U00010b50', 
    '\U00010b51', '\U00010b52', '\U00010b53', '\U00010b54', '\U00010b55', '\U00010b60', '\U00010b61', '\U00010b62', 
    '\U00010b63', '\U00010b64', '\U00010b65', '\U00010b66', '\U00010b67', '\U00010b68', '\U00010b69', '\U00010b6a', 
    '\U00010b6b', '\U00010b6c', '\U00010b6d', '\U00010b6e', '\U00010b6f', '\U00010b70', '\U00010b71', '\U00010b72', 
    '\U00010b80', '\U00010b81', '\U00010b82', '\U00010b83', '\U00010b84', '\U00010b85', '\U00010b86', '\U00010b87', 
    '\U00010b88', '\U00010b89', '\U00010b8a', '\U00010b8b', '\U00010b8c', '\U00010b8d', '\U00010b8e', '\U00010b8f', 
    '\U00010b90', '\U00010b91', '\U00010c00', '\U00010c01', '\U00010c02', '\U00010c03', '\U00010c04', '\U00010c05', 
    '\U00010c06', '\U00010c07', '\U00010c08', '\U00010c09', '\U00010c0a', '\U00010c0b', '\U00010c0c', '\U00010c0d', 
    '\U00010c0e', '\U00010c0f', '\U00010c10', '\U00010c11', '\U00010c12', '\U00010c13', '\U00010c14', '\U00010c15', 
    '\U00010c16', '\U00010c17', '\U00010c18', '\U00010c19', '\U00010c1a', '\U00010c1b', '\U00010c1c', '\U00010c1d', 
    '\U00010c1e', '\U00010c1f', '\U00010c20', '\U00010c21', '\U00010c22', '\U00010c23', '\U00010c24', '\U00010c25', 
    '\U00010c26', '\U00010c27', '\U00010c28', '\U00010c29', '\U00010c2a', '\U00010c2b', '\U00010c2c', '\U00010c2d', 
    '\U00010c2e', '\U00010c2f', '\U00010c30', '\U00010c31', '\U00010c32', '\U00010c33', '\U00010c34', '\U00010c35', 
    '\U00010c36', '\U00010c37', '\U00010c38', '\U00010c39', '\U00010c3a', '\U00010c3b', '\U00010c3c', '\U00010c3d', 
    '\U00010c3e', '\U00010c3f', '\U00010c40', '\U00010c41', '\U00010c42', '\U00010c43', '\U00010c44', '\U00010c45', 
    '\U00010c46', '\U00010c47', '\U00010c48', '\U00010c80', '\U00010c81', '\U00010c82', '\U00010c83', '\U00010c84', 
    '\U00010c85', '\U00010c86', '\U00010c87', '\U00010c88', '\U00010c89', '\U00010c8a', '\U00010c8b', '\U00010c8c', 
    '\U00010c8d', '\U00010c8e', '\U00010c8f', '\U00010c90', '\U00010c91', '\U00010c92', '\U00010c93', '\U00010c94', 
    '\U00010c95', '\U00010c96', '\U00010c97', '\U00010c98', '\U00010c99', '\U00010c9a', '\U00010c9b', '\U00010c9c', 
    '\U00010c9d', '\U00010c9e', '\U00010c9f', '\U00010ca0', '\U00010ca1', '\U00010ca2', '\U00010ca3', '\U00010ca4', 
    '\U00010ca5', '\U00010ca6', '\U00010ca7', '\U00010ca8', '\U00010ca9', '\U00010caa', '\U00010cab', '\U00010cac', 
    '\U00010cad', '\U00010cae', '\U00010caf', '\U00010cb0', '\U00010cb1', '\U00010cb2', '\U00010cc0', '\U00010cc1', 
    '\U00010cc2', '\U00010cc3', '\U00010cc4', '\U00010cc5', '\U00010cc6', '\U00010cc7', '\U00010cc8', '\U00010cc9', 
    '\U00010cca', '\U00010ccb', '\U00010ccc', '\U00010ccd', '\U00010cce', '\U00010ccf', '\U00010cd0', '\U00010cd1', 
    '\U00010cd2', '\U00010cd3', '\U00010cd4', '\U00010cd5', '\U00010cd6', '\U00010cd7', '\U00010cd8', '\U00010cd9', 
    '\U00010cda', '\U00010cdb', '\U00010cdc', '\U00010cdd', '\U00010cde', '\U00010cdf', '\U00010ce0', '\U00010ce1', 
    '\U00010ce2', '\U00010ce3', '\U00010ce4', '\U00010ce5', '\U00010ce6', '\U00010ce7', '\U00010ce8', '\U00010ce9', 
    '\U00010cea', '\U00010ceb', '\U00010cec', '\U00010ced', '\U00010cee', '\U00010cef', '\U00010cf0', '\U00010cf1', 
    '\U00010cf2', '\U00010d00', '\U00010d01', '\U00010d02', '\U00010d03', '\U00010d04', '\U00010d05', '\U00010d06', 
    '\U00010d07', '\U00010d08', '\U00010d09', '\U00010d0a', '\U00010d0b', '\U00010d0c', '\U00010d0d', '\U00010d0e', 
    '\U00010d0f', '\U00010d10', '\U00010d11', '\U00010d12', '\U00010d13', '\U00010d14', '\U00010d15', '\U00010d16', 
    '\U00010d17', '\U00010d18', '\U00010d19', '\U00010d1a', '\U00010d1b', '\U00010d1c', '\U00010d1d', '\U00010d1e', 
    '\U00010d1f', '\U00010d20', '\U00010d21', '\U00010d22', '\U00010d23', '\U00010f00', '\U00010f01', '\U00010f02', 
    '\U00010f03', '\U00010f04', '\U00010f05', '\U00010f06', '\U00010f07', '\U00010f08', '\U00010f09', '\U00010f0a', 
    '\U00010f0b', '\U00010f0c', '\U00010f0d', '\U00010f0e', '\U00010f0f', '\U00010f10', '\U00010f11', '\U00010f12', 
    '\U00010f13', '\U00010f14', '\U00010f15', '\U00010f16', '\U00010f17', '\U00010f18', '\U00010f19', '\U00010f1a', 
    '\U00010f1b', '\U00010f1c', '\U00010f27', '\U00010f30', '\U00010f31', '\U00010f32', '\U00010f33', '\U00010f34', 
    '\U00010f35', '\U00010f36', '\U00010f37', '\U00010f38', '\U00010f39', '\U00010f3a', '\U00010f3b', '\U00010f3c', 
    '\U00010f3d', '\U00010f3e', '\U00010f3f', '\U00010f40', '\U00010f41', '\U00010f42', '\U00010f43', '\U00010f44', 
    '\U00010f45', '\U00011003', '\U00011004', '\U00011005', '\U00011006', '\U00011007', '\U00011008', '\U00011009', 
    '\U0001100a', '\U0001100b', '\U0001100c', '\U0001100d', '\U0001100e', '\U0001100f', '\U00011010', '\U00011011', 
    '\U00011012', '\U00011013', '\U00011014', '\U00011015', '\U00011016', '\U00011017', '\U00011018', '\U00011019', 
    '\U0001101a', '\U0001101b', '\U0001101c', '\U0001101d', '\U0001101e', '\U0001101f', '\U00011020', '\U00011021', 
    '\U00011022', '\U00011023', '\U00011024', '\U00011025', '\U00011026', '\U00011027', '\U00011028', '\U00011029', 
    '\U0001102a', '\U0001102b', '\U0001102c', '\U0001102d', '\U0001102e', '\U0001102f', '\U00011030', '\U00011031', 
    '\U00011032', '\U00011033', '\U00011034', '\U00011035', '\U00011036', '\U00011037', '\U00011083', '\U00011084', 
    '\U00011085', '\U00011086', '\U00011087', '\U00011088', '\U00011089', '\U0001108a', '\U0001108b', '\U0001108c', 
    '\U0001108d', '\U0001108e', '\U0001108f', '\U00011090', '\U00011091', '\U00011092', '\U00011093', '\U00011094', 
    '\U00011095', '\U00011096', '\U00011097', '\U00011098', '\U00011099', '\U0001109a', '\U0001109b', '\U0001109c', 
    '\U0001109d', '\U0001109e', '\U0001109f', '\U000110a0', '\U000110a1', '\U000110a2', '\U000110a3', '\U000110a4', 
    '\U000110a5', '\U000110a6', '\U000110a7', '\U000110a8', '\U000110a9', '\U000110aa', '\U000110ab', '\U000110ac', 
    '\U000110ad', '\U000110ae', '\U000110af', '\U000110d0', '\U000110d1', '\U000110d2', '\U000110d3', '\U000110d4', 
    '\U000110d5', '\U000110d6', '\U000110d7', '\U000110d8', '\U000110d9', '\U000110da', '\U000110db', '\U000110dc', 
    '\U000110dd', '\U000110de', '\U000110df', '\U000110e0', '\U000110e1', '\U000110e2', '\U000110e3', '\U000110e4', 
    '\U000110e5', '\U000110e6', '\U000110e7', '\U000110e8', '\U00011103', '\U00011104', '\U00011105', '\U00011106', 
    '\U00011107', '\U00011108', '\U00011109', '\U0001110a', '\U0001110b', '\U0001110c', '\U0001110d', '\U0001110e', 
    '\U0001110f', '\U00011110', '\U00011111', '\U00011112', '\U00011113', '\U00011114', '\U00011115', '\U00011116', 
    '\U00011117', '\U00011118', '\U00011119', '\U0001111a', '\U0001111b', '\U0001111c', '\U0001111d', '\U0001111e', 
    '\U0001111f', '\U00011120', '\U00011121', '\U00011122', '\U00011123', '\U00011124', '\U00011125', '\U00011126', 
    '\U00011144', '\U00011150', '\U00011151', '\U00011152', '\U00011153', '\U00011154', '\U00011155', '\U00011156', 
    '\U00011157', '\U00011158', '\U00011159', '\U0001115a', '\U0001115b', '\U0001115c', '\U0001115d', '\U0001115e', 
    '\U0001115f', '\U00011160', '\U00011161', '\U00011162', '\U00011163', '\U00011164', '\U00011165', '\U00011166', 
    '\U00011167', '\U00011168', '\U00011169', '\U0001116a', '\U0001116b', '\U0001116c', '\U0001116d', '\U0001116e', 
    '\U0001116f', '\U00011170', '\U00011171', '\U00011172', '\U00011176', '\U00011183', '\U00011184', '\U00011185', 
    '\U00011186', '\U00011187', '\U00011188', '\U00011189', '\U0001118a', '\U0001118b', '\U0001118c', '\U0001118d', 
    '\U0001118e', '\U0001118f', '\U00011190', '\U00011191', '\U00011192', '\U00011193', '\U00011194', '\U00011195', 
    '\U00011196', '\U00011197', '\U00011198', '\U00011199', '\U0001119a', '\U0001119b', '\U0001119c', '\U0001119d', 
    '\U0001119e', '\U0001119f', '\U000111a0', '\U000111a1', '\U000111a2', '\U000111a3', '\U000111a4', '\U000111a5', 
    '\U000111a6', '\U000111a7', '\U000111a8', '\U000111a9', '\U000111aa', '\U000111ab', '\U000111ac', '\U000111ad', 
    '\U000111ae', '\U000111af', '\U000111b0', '\U000111b1', '\U000111b2', '\U000111c1', '\U000111c2', '\U000111c3', 
    '\U000111c4', '\U000111da', '\U000111dc', '\U00011200', '\U00011201', '\U00011202', '\U00011203', '\U00011204', 
    '\U00011205', '\U00011206', '\U00011207', '\U00011208', '\U00011209', '\U0001120a', '\U0001120b', '\U0001120c', 
    '\U0001120d', '\U0001120e', '\U0001120f', '\U00011210', '\U00011211', '\U00011213', '\U00011214', '\U00011215', 
    '\U00011216', '\U00011217', '\U00011218', '\U00011219', '\U0001121a', '\U0001121b', '\U0001121c', '\U0001121d', 
    '\U0001121e', '\U0001121f', '\U00011220', '\U00011221', '\U00011222', '\U00011223', '\U00011224', '\U00011225', 
    '\U00011226', '\U00011227', '\U00011228', '\U00011229', '\U0001122a', '\U0001122b', '\U00011280', '\U00011281', 
    '\U00011282', '\U00011283', '\U00011284', '\U00011285', '\U00011286', '\U00011288', '\U0001128a', '\U0001128b', 
    '\U0001128c', '\U0001128d', '\U0001128f', '\U00011290', '\U00011291', '\U00011292', '\U00011293', '\U00011294', 
    '\U00011295', '\U00011296', '\U00011297', '\U00011298', '\U00011299', '\U0001129a', '\U0001129b', '\U0001129c', 
    '\U0001129d', '\U0001129f', '\U000112a0', '\U000112a1', '\U000112a2', '\U000112a3', '\U000112a4', '\U000112a5', 
    '\U000112a6', '\U000112a7', '\U000112a8', '\U000112b0', '\U000112b1', '\U000112b2', '\U000112b3', '\U000112b4', 
    '\U000112b5', '\U000112b6', '\U000112b7', '\U000112b8', '\U000112b9', '\U000112ba', '\U000112bb', '\U000112bc', 
    '\U000112bd', '\U000112be', '\U000112bf', '\U000112c0', '\U000112c1', '\U000112c2', '\U000112c3', '\U000112c4', 
    '\U000112c5', '\U000112c6', '\U000112c7', '\U000112c8', '\U000112c9', '\U000112ca', '\U000112cb', '\U000112cc', 
    '\U000112cd', '\U000112ce', '\U000112cf', '\U000112d0', '\U000112d1', '\U000112d2', '\U000112d3', '\U000112d4', 
    '\U000112d5', '\U000112d6', '\U000112d7', '\U000112d8', '\U000112d9', '\U000112da', '\U000112db', '\U000112dc', 
    '\U000112dd', '\U000112de', '\U00011305', '\U00011306', '\U00011307', '\U00011308', '\U00011309', '\U0001130a', 
    '\U0001130b', '\U0001130c', '\U0001130f', '\U00011310', '\U00011313', '\U00011314', '\U00011315', '\U00011316', 
    '\U00011317', '\U00011318', '\U00011319', '\U0001131a', '\U0001131b', '\U0001131c', '\U0001131d', '\U0001131e', 
    '\U0001131f', '\U00011320', '\U00011321', '\U00011322', '\U00011323', '\U00011324', '\U00011325', '\U00011326', 
    '\U00011327', '\U00011328', '\U0001132a', '\U0001132b', '\U0001132c', '\U0001132d', '\U0001132e', '\U0001132f', 
    '\U00011330', '\U00011332', '\U00011333', '\U00011335', '\U00011336', '\U00011337', '\U00011338', '\U00011339', 
    '\U0001133d', '\U00011350', '\U0001135d', '\U0001135e', '\U0001135f', '\U00011360', '\U00011361', '\U00011400', 
    '\U00011401', '\U00011402', '\U00011403', '\U00011404', '\U00011405', '\U00011406', '\U00011407', '\U00011408', 
    '\U00011409', '\U0001140a', '\U0001140b', '\U0001140c', '\U0001140d', '\U0001140e', '\U0001140f', '\U00011410', 
    '\U00011411', '\U00011412', '\U00011413', '\U00011414', '\U00011415', '\U00011416', '\U00011417', '\U00011418', 
    '\U00011419', '\U0001141a', '\U0001141b', '\U0001141c', '\U0001141d', '\U0001141e', '\U0001141f', '\U00011420', 
    '\U00011421', '\U00011422', '\U00011423', '\U00011424', '\U00011425', '\U00011426', '\U00011427', '\U00011428', 
    '\U00011429', '\U0001142a', '\U0001142b', '\U0001142c', '\U0001142d', '\U0001142e', '\U0001142f', '\U00011430', 
    '\U00011431', '\U00011432', '\U00011433', '\U00011434', '\U00011447', '\U00011448', '\U00011449', '\U0001144a', 
    '\U00011480', '\U00011481', '\U00011482', '\U00011483', '\U00011484', '\U00011485', '\U00011486', '\U00011487', 
    '\U00011488', '\U00011489', '\U0001148a', '\U0001148b', '\U0001148c', '\U0001148d', '\U0001148e', '\U0001148f', 
    '\U00011490', '\U00011491', '\U00011492', '\U00011493', '\U00011494', '\U00011495', '\U00011496', '\U00011497', 
    '\U00011498', '\U00011499', '\U0001149a', '\U0001149b', '\U0001149c', '\U0001149d', '\U0001149e', '\U0001149f', 
    '\U000114a0', '\U000114a1', '\U000114a2', '\U000114a3', '\U000114a4', '\U000114a5', '\U000114a6', '\U000114a7', 
    '\U000114a8', '\U000114a9', '\U000114aa', '\U000114ab', '\U000114ac', '\U000114ad', '\U000114ae', '\U000114af', 
    '\U000114c4', '\U000114c5', '\U000114c7', '\U00011580', '\U00011581', '\U00011582', '\U00011583', '\U00011584', 
    '\U00011585', '\U00011586', '\U00011587', '\U00011588', '\U00011589', '\U0001158a', '\U0001158b', '\U0001158c', 
    '\U0001158d', '\U0001158e', '\U0001158f', '\U00011590', '\U00011591', '\U00011592', '\U00011593', '\U00011594', 
    '\U00011595', '\U00011596', '\U00011597', '\U00011598', '\U00011599', '\U0001159a', '\U0001159b', '\U0001159c', 
    '\U0001159d', '\U0001159e', '\U0001159f', '\U000115a0', '\U000115a1', '\U000115a2', '\U000115a3', '\U000115a4', 
    '\U000115a5', '\U000115a6', '\U000115a7', '\U000115a8', '\U000115a9', '\U000115aa', '\U000115ab', '\U000115ac', 
    '\U000115ad', '\U000115ae', '\U000115d8', '\U000115d9', '\U000115da', '\U000115db', '\U00011600', '\U00011601', 
    '\U00011602', '\U00011603', '\U00011604', '\U00011605', '\U00011606', '\U00011607', '\U00011608', '\U00011609', 
    '\U0001160a', '\U0001160b', '\U0001160c', '\U0001160d', '\U0001160e', '\U0001160f', '\U00011610', '\U00011611', 
    '\U00011612', '\U00011613', '\U00011614', '\U00011615', '\U00011616', '\U00011617', '\U00011618', '\U00011619', 
    '\U0001161a', '\U0001161b', '\U0001161c', '\U0001161d', '\U0001161e', '\U0001161f', '\U00011620', '\U00011621', 
    '\U00011622', '\U00011623', '\U00011624', '\U00011625', '\U00011626', '\U00011627', '\U00011628', '\U00011629', 
    '\U0001162a', '\U0001162b', '\U0001162c', '\U0001162d', '\U0001162e', '\U0001162f', '\U00011644', '\U00011680', 
    '\U00011681', '\U00011682', '\U00011683', '\U00011684', '\U00011685', '\U00011686', '\U00011687', '\U00011688', 
    '\U00011689', '\U0001168a', '\U0001168b', '\U0001168c', '\U0001168d', '\U0001168e', '\U0001168f', '\U00011690', 
    '\U00011691', '\U00011692', '\U00011693', '\U00011694', '\U00011695', '\U00011696', '\U00011697', '\U00011698', 
    '\U00011699', '\U0001169a', '\U0001169b', '\U0001169c', '\U0001169d', '\U0001169e', '\U0001169f', '\U000116a0', 
    '\U000116a1', '\U000116a2', '\U000116a3', '\U000116a4', '\U000116a5', '\U000116a6', '\U000116a7', '\U000116a8', 
    '\U000116a9', '\U000116aa', '\U00011800', '\U00011801', '\U00011802', '\U00011803', '\U00011804', '\U00011805', 
    '\U00011806', '\U00011807', '\U00011808', '\U00011809', '\U0001180a', '\U0001180b', '\U0001180c', '\U0001180d', 
    '\U0001180e', '\U0001180f', '\U00011810', '\U00011811', '\U00011812', '\U00011813', '\U00011814', '\U00011815', 
    '\U00011816', '\U00011817', '\U00011818', '\U00011819', '\U0001181a', '\U0001181b', '\U0001181c', '\U0001181d', 
    '\U0001181e', '\U0001181f', '\U00011820', '\U00011821', '\U00011822', '\U00011823', '\U00011824', '\U00011825', 
    '\U00011826', '\U00011827', '\U00011828', '\U00011829', '\U0001182a', '\U0001182b', '\U000118a0', '\U000118a1', 
    '\U000118a2', '\U000118a3', '\U000118a4', '\U000118a5', '\U000118a6', '\U000118a7', '\U000118a8', '\U000118a9', 
    '\U000118aa', '\U000118ab', '\U000118ac', '\U000118ad', '\U000118ae', '\U000118af', '\U000118b0', '\U000118b1', 
    '\U000118b2', '\U000118b3', '\U000118b4', '\U000118b5', '\U000118b6', '\U000118b7', '\U000118b8', '\U000118b9', 
    '\U000118ba', '\U000118bb', '\U000118bc', '\U000118bd', '\U000118be', '\U000118bf', '\U000118c0', '\U000118c1', 
    '\U000118c2', '\U000118c3', '\U000118c4', '\U000118c5', '\U000118c6', '\U000118c7', '\U000118c8', '\U000118c9', 
    '\U000118ca', '\U000118cb', '\U000118cc', '\U000118cd', '\U000118ce', '\U000118cf', '\U000118d0', '\U000118d1', 
    '\U000118d2', '\U000118d3', '\U000118d4', '\U000118d5', '\U000118d6', '\U000118d7', '\U000118d8', '\U000118d9', 
    '\U000118da', '\U000118db', '\U000118dc', '\U000118dd', '\U000118de', '\U000118df', '\U000118ff', '\U00011a00', 
    '\U00011a0b', '\U00011a0c', '\U00011a0d', '\U00011a0e', '\U00011a0f', '\U00011a10', '\U00011a11', '\U00011a12', 
    '\U00011a13', '\U00011a14', '\U00011a15', '\U00011a16', '\U00011a17', '\U00011a18', '\U00011a19', '\U00011a1a', 
    '\U00011a1b', '\U00011a1c', '\U00011a1d', '\U00011a1e', '\U00011a1f', '\U00011a20', '\U00011a21', '\U00011a22', 
    '\U00011a23', '\U00011a24', '\U00011a25', '\U00011a26', '\U00011a27', '\U00011a28', '\U00011a29', '\U00011a2a', 
    '\U00011a2b', '\U00011a2c', '\U00011a2d', '\U00011a2e', '\U00011a2f', '\U00011a30', '\U00011a31', '\U00011a32', 
    '\U00011a3a', '\U00011a50', '\U00011a5c', '\U00011a5d', '\U00011a5e', '\U00011a5f', '\U00011a60', '\U00011a61', 
    '\U00011a62', '\U00011a63', '\U00011a64', '\U00011a65', '\U00011a66', '\U00011a67', '\U00011a68', '\U00011a69', 
    '\U00011a6a', '\U00011a6b', '\U00011a6c', '\U00011a6d', '\U00011a6e', '\U00011a6f', '\U00011a70', '\U00011a71', 
    '\U00011a72', '\U00011a73', '\U00011a74', '\U00011a75', '\U00011a76', '\U00011a77', '\U00011a78', '\U00011a79', 
    '\U00011a7a', '\U00011a7b', '\U00011a7c', '\U00011a7d', '\U00011a7e', '\U00011a7f', '\U00011a80', '\U00011a81', 
    '\U00011a82', '\U00011a83', '\U00011a86', '\U00011a87', '\U00011a88', '\U00011a89', '\U00011a9d', '\U00011ac0', 
    '\U00011ac1', '\U00011ac2', '\U00011ac3', '\U00011ac4', '\U00011ac5', '\U00011ac6', '\U00011ac7', '\U00011ac8', 
    '\U00011ac9', '\U00011aca', '\U00011acb', '\U00011acc', '\U00011acd', '\U00011ace', '\U00011acf', '\U00011ad0', 
    '\U00011ad1', '\U00011ad2', '\U00011ad3', '\U00011ad4', '\U00011ad5', '\U00011ad6', '\U00011ad7', '\U00011ad8', 
    '\U00011ad9', '\U00011ada', '\U00011adb', '\U00011adc', '\U00011add', '\U00011ade', '\U00011adf', '\U00011ae0', 
    '\U00011ae1', '\U00011ae2', '\U00011ae3', '\U00011ae4', '\U00011ae5', '\U00011ae6', '\U00011ae7', '\U00011ae8', 
    '\U00011ae9', '\U00011aea', '\U00011aeb', '\U00011aec', '\U00011aed', '\U00011aee', '\U00011aef', '\U00011af0', 
    '\U00011af1', '\U00011af2', '\U00011af3', '\U00011af4', '\U00011af5', '\U00011af6', '\U00011af7', '\U00011af8', 
    '\U00011c00', '\U00011c01', '\U00011c02', '\U00011c03', '\U00011c04', '\U00011c05', '\U00011c06', '\U00011c07', 
    '\U00011c08', '\U00011c0a', '\U00011c0b', '\U00011c0c', '\U00011c0d', '\U00011c0e', '\U00011c0f', '\U00011c10', 
    '\U00011c11', '\U00011c12', '\U00011c13', '\U00011c14', '\U00011c15', '\U00011c16', '\U00011c17', '\U00011c18', 
    '\U00011c19', '\U00011c1a', '\U00011c1b', '\U00011c1c', '\U00011c1d', '\U00011c1e', '\U00011c1f', '\U00011c20', 
    '\U00011c21', '\U00011c22', '\U00011c23', '\U00011c24', '\U00011c25', '\U00011c26', '\U00011c27', '\U00011c28', 
    '\U00011c29', '\U00011c2a', '\U00011c2b', '\U00011c2c', '\U00011c2d', '\U00011c2e', '\U00011c40', '\U00011c72', 
    '\U00011c73', '\U00011c74', '\U00011c75', '\U00011c76', '\U00011c77', '\U00011c78', '\U00011c79', '\U00011c7a', 
    '\U00011c7b', '\U00011c7c', '\U00011c7d', '\U00011c7e', '\U00011c7f', '\U00011c80', '\U00011c81', '\U00011c82', 
    '\U00011c83', '\U00011c84', '\U00011c85', '\U00011c86', '\U00011c87', '\U00011c88', '\U00011c89', '\U00011c8a', 
    '\U00011c8b', '\U00011c8c', '\U00011c8d', '\U00011c8e', '\U00011c8f', '\U00011d00', '\U00011d01', '\U00011d02', 
    '\U00011d03', '\U00011d04', '\U00011d05', '\U00011d06', '\U00011d08', '\U00011d09', '\U00011d0b', '\U00011d0c', 
    '\U00011d0d', '\U00011d0e', '\U00011d0f', '\U00011d10', '\U00011d11', '\U00011d12', '\U00011d13', '\U00011d14', 
    '\U00011d15', '\U00011d16', '\U00011d17', '\U00011d18', '\U00011d19', '\U00011d1a', '\U00011d1b', '\U00011d1c', 
    '\U00011d1d', '\U00011d1e', '\U00011d1f', '\U00011d20', '\U00011d21', '\U00011d22', '\U00011d23', '\U00011d24', 
    '\U00011d25', '\U00011d26', '\U00011d27', '\U00011d28', '\U00011d29', '\U00011d2a', '\U00011d2b', '\U00011d2c', 
    '\U00011d2d', '\U00011d2e', '\U00011d2f', '\U00011d30', '\U00011d46', '\U00011d60', '\U00011d61', '\U00011d62', 
    '\U00011d63', '\U00011d64', '\U00011d65', '\U00011d67', '\U00011d68', '\U00011d6a', '\U00011d6b', '\U00011d6c', 
    '\U00011d6d', '\U00011d6e', '\U00011d6f', '\U00011d70', '\U00011d71', '\U00011d72', '\U00011d73', '\U00011d74', 
    '\U00011d75', '\U00011d76', '\U00011d77', '\U00011d78', '\U00011d79', '\U00011d7a', '\U00011d7b', '\U00011d7c', 
    '\U00011d7d', '\U00011d7e', '\U00011d7f', '\U00011d80', '\U00011d81', '\U00011d82', '\U00011d83', '\U00011d84', 
    '\U00011d85', '\U00011d86', '\U00011d87', '\U00011d88', '\U00011d89', '\U00011d98', '\U00011ee0', '\U00011ee1', 
    '\U00011ee2', '\U00011ee3', '\U00011ee4', '\U00011ee5', '\U00011ee6', '\U00011ee7', '\U00011ee8', '\U00011ee9', 
    '\U00011eea', '\U00011eeb', '\U00011eec', '\U00011eed', '\U00011eee', '\U00011eef', '\U00011ef0', '\U00011ef1', 
    '\U00011ef2', '\U00012000', '\U00012001', '\U00012002', '\U00012003', '\U00012004', '\U00012005', '\U00012006', 
    '\U00012007', '\U00012008', '\U00012009', '\U0001200a', '\U0001200b', '\U0001200c', '\U0001200d', '\U0001200e', 
    '\U0001200f', '\U00012010', '\U00012011', '\U00012012', '\U00012013', '\U00012014', '\U00012015', '\U00012016', 
    '\U00012017', '\U00012018', '\U00012019', '\U0001201a', '\U0001201b', '\U0001201c', '\U0001201d', '\U0001201e', 
    '\U0001201f', '\U00012020', '\U00012021', '\U00012022', '\U00012023', '\U00012024', '\U00012025', '\U00012026', 
    '\U00012027', '\U00012028', '\U00012029', '\U0001202a', '\U0001202b', '\U0001202c', '\U0001202d', '\U0001202e', 
    '\U0001202f', '\U00012030', '\U00012031', '\U00012032', '\U00012033', '\U00012034', '\U00012035', '\U00012036', 
    '\U00012037', '\U00012038', '\U00012039', '\U0001203a', '\U0001203b', '\U0001203c', '\U0001203d', '\U0001203e', 
    '\U0001203f', '\U00012040', '\U00012041', '\U00012042', '\U00012043', '\U00012044', '\U00012045', '\U00012046', 
    '\U00012047', '\U00012048', '\U00012049', '\U0001204a', '\U0001204b', '\U0001204c', '\U0001204d', '\U0001204e', 
    '\U0001204f', '\U00012050', '\U00012051', '\U00012052', '\U00012053', '\U00012054', '\U00012055', '\U00012056', 
    '\U00012057', '\U00012058', '\U00012059', '\U0001205a', '\U0001205b', '\U0001205c', '\U0001205d', '\U0001205e', 
    '\U0001205f', '\U00012060', '\U00012061', '\U00012062', '\U00012063', '\U00012064', '\U00012065', '\U00012066', 
    '\U00012067', '\U00012068', '\U00012069', '\U0001206a', '\U0001206b', '\U0001206c', '\U0001206d', '\U0001206e', 
    '\U0001206f', '\U00012070', '\U00012071', '\U00012072', '\U00012073', '\U00012074', '\U00012075', '\U00012076', 
    '\U00012077', '\U00012078', '\U00012079', '\U0001207a', '\U0001207b', '\U0001207c', '\U0001207d', '\U0001207e', 
    '\U0001207f', '\U00012080', '\U00012081', '\U00012082', '\U00012083', '\U00012084', '\U00012085', '\U00012086', 
    '\U00012087', '\U00012088', '\U00012089', '\U0001208a', '\U0001208b', '\U0001208c', '\U0001208d', '\U0001208e', 
    '\U0001208f', '\U00012090', '\U00012091', '\U00012092', '\U00012093', '\U00012094', '\U00012095', '\U00012096', 
    '\U00012097', '\U00012098', '\U00012099', '\U0001209a', '\U0001209b', '\U0001209c', '\U0001209d', '\U0001209e', 
    '\U0001209f', '\U000120a0', '\U000120a1', '\U000120a2', '\U000120a3', '\U000120a4', '\U000120a5', '\U000120a6', 
    '\U000120a7', '\U000120a8', '\U000120a9', '\U000120aa', '\U000120ab', '\U000120ac', '\U000120ad', '\U000120ae', 
    '\U000120af', '\U000120b0', '\U000120b1', '\U000120b2', '\U000120b3', '\U000120b4', '\U000120b5', '\U000120b6', 
    '\U000120b7', '\U000120b8', '\U000120b9', '\U000120ba', '\U000120bb', '\U000120bc', '\U000120bd', '\U000120be', 
    '\U000120bf', '\U000120c0', '\U000120c1', '\U000120c2', '\U000120c3', '\U000120c4', '\U000120c5', '\U000120c6', 
    '\U000120c7', '\U000120c8', '\U000120c9', '\U000120ca', '\U000120cb', '\U000120cc', '\U000120cd', '\U000120ce', 
    '\U000120cf', '\U000120d0', '\U000120d1', '\U000120d2', '\U000120d3', '\U000120d4', '\U000120d5', '\U000120d6', 
    '\U000120d7', '\U000120d8', '\U000120d9', '\U000120da', '\U000120db', '\U000120dc', '\U000120dd', '\U000120de', 
    '\U000120df', '\U000120e0', '\U000120e1', '\U000120e2', '\U000120e3', '\U000120e4', '\U000120e5', '\U000120e6', 
    '\U000120e7', '\U000120e8', '\U000120e9', '\U000120ea', '\U000120eb', '\U000120ec', '\U000120ed', '\U000120ee', 
    '\U000120ef', '\U000120f0', '\U000120f1', '\U000120f2', '\U000120f3', '\U000120f4', '\U000120f5', '\U000120f6', 
    '\U000120f7', '\U000120f8', '\U000120f9', '\U000120fa', '\U000120fb', '\U000120fc', '\U000120fd', '\U000120fe', 
    '\U000120ff', '\U00012100', '\U00012101', '\U00012102', '\U00012103', '\U00012104', '\U00012105', '\U00012106', 
    '\U00012107', '\U00012108', '\U00012109', '\U0001210a', '\U0001210b', '\U0001210c', '\U0001210d', '\U0001210e', 
    '\U0001210f', '\U00012110', '\U00012111', '\U00012112', '\U00012113', '\U00012114', '\U00012115', '\U00012116', 
    '\U00012117', '\U00012118', '\U00012119', '\U0001211a', '\U0001211b', '\U0001211c', '\U0001211d', '\U0001211e', 
    '\U0001211f', '\U00012120', '\U00012121', '\U00012122', '\U00012123', '\U00012124', '\U00012125', '\U00012126', 
    '\U00012127', '\U00012128', '\U00012129', '\U0001212a', '\U0001212b', '\U0001212c', '\U0001212d', '\U0001212e', 
    '\U0001212f', '\U00012130', '\U00012131', '\U00012132', '\U00012133', '\U00012134', '\U00012135', '\U00012136', 
    '\U00012137', '\U00012138', '\U00012139', '\U0001213a', '\U0001213b', '\U0001213c', '\U0001213d', '\U0001213e', 
    '\U0001213f', '\U00012140', '\U00012141', '\U00012142', '\U00012143', '\U00012144', '\U00012145', '\U00012146', 
    '\U00012147', '\U00012148', '\U00012149', '\U0001214a', '\U0001214b', '\U0001214c', '\U0001214d', '\U0001214e', 
    '\U0001214f', '\U00012150', '\U00012151', '\U00012152', '\U00012153', '\U00012154', '\U00012155', '\U00012156', 
    '\U00012157', '\U00012158', '\U00012159', '\U0001215a', '\U0001215b', '\U0001215c', '\U0001215d', '\U0001215e', 
    '\U0001215f', '\U00012160', '\U00012161', '\U00012162', '\U00012163', '\U00012164', '\U00012165', '\U00012166', 
    '\U00012167', '\U00012168', '\U00012169', '\U0001216a', '\U0001216b', '\U0001216c', '\U0001216d', '\U0001216e', 
    '\U0001216f', '\U00012170', '\U00012171', '\U00012172', '\U00012173', '\U00012174', '\U00012175', '\U00012176', 
    '\U00012177', '\U00012178', '\U00012179', '\U0001217a', '\U0001217b', '\U0001217c', '\U0001217d', '\U0001217e', 
    '\U0001217f', '\U00012180', '\U00012181', '\U00012182', '\U00012183', '\U00012184', '\U00012185', '\U00012186', 
    '\U00012187', '\U00012188', '\U00012189', '\U0001218a', '\U0001218b', '\U0001218c', '\U0001218d', '\U0001218e', 
    '\U0001218f', '\U00012190', '\U00012191', '\U00012192', '\U00012193', '\U00012194', '\U00012195', '\U00012196', 
    '\U00012197', '\U00012198', '\U00012199', '\U0001219a', '\U0001219b', '\U0001219c', '\U0001219d', '\U0001219e', 
    '\U0001219f', '\U000121a0', '\U000121a1', '\U000121a2', '\U000121a3', '\U000121a4', '\U000121a5', '\U000121a6', 
    '\U000121a7', '\U000121a8', '\U000121a9', '\U000121aa', '\U000121ab', '\U000121ac', '\U000121ad', '\U000121ae', 
    '\U000121af', '\U000121b0', '\U000121b1', '\U000121b2', '\U000121b3', '\U000121b4', '\U000121b5', '\U000121b6', 
    '\U000121b7', '\U000121b8', '\U000121b9', '\U000121ba', '\U000121bb', '\U000121bc', '\U000121bd', '\U000121be', 
    '\U000121bf', '\U000121c0', '\U000121c1', '\U000121c2', '\U000121c3', '\U000121c4', '\U000121c5', '\U000121c6', 
    '\U000121c7', '\U000121c8', '\U000121c9', '\U000121ca', '\U000121cb', '\U000121cc', '\U000121cd', '\U000121ce', 
    '\U000121cf', '\U000121d0', '\U000121d1', '\U000121d2', '\U000121d3', '\U000121d4', '\U000121d5', '\U000121d6', 
    '\U000121d7', '\U000121d8', '\U000121d9', '\U000121da', '\U000121db', '\U000121dc', '\U000121dd', '\U000121de', 
    '\U000121df', '\U000121e0', '\U000121e1', '\U000121e2', '\U000121e3', '\U000121e4', '\U000121e5', '\U000121e6', 
    '\U000121e7', '\U000121e8', '\U000121e9', '\U000121ea', '\U000121eb', '\U000121ec', '\U000121ed', '\U000121ee', 
    '\U000121ef', '\U000121f0', '\U000121f1', '\U000121f2', '\U000121f3', '\U000121f4', '\U000121f5', '\U000121f6', 
    '\U000121f7', '\U000121f8', '\U000121f9', '\U000121fa', '\U000121fb', '\U000121fc', '\U000121fd', '\U000121fe', 
    '\U000121ff', '\U00012200', '\U00012201', '\U00012202', '\U00012203', '\U00012204', '\U00012205', '\U00012206', 
    '\U00012207', '\U00012208', '\U00012209', '\U0001220a', '\U0001220b', '\U0001220c', '\U0001220d', '\U0001220e', 
    '\U0001220f', '\U00012210', '\U00012211', '\U00012212', '\U00012213', '\U00012214', '\U00012215', '\U00012216', 
    '\U00012217', '\U00012218', '\U00012219', '\U0001221a', '\U0001221b', '\U0001221c', '\U0001221d', '\U0001221e', 
    '\U0001221f', '\U00012220', '\U00012221', '\U00012222', '\U00012223', '\U00012224', '\U00012225', '\U00012226', 
    '\U00012227', '\U00012228', '\U00012229', '\U0001222a', '\U0001222b', '\U0001222c', '\U0001222d', '\U0001222e', 
    '\U0001222f', '\U00012230', '\U00012231', '\U00012232', '\U00012233', '\U00012234', '\U00012235', '\U00012236', 
    '\U00012237', '\U00012238', '\U00012239', '\U0001223a', '\U0001223b', '\U0001223c', '\U0001223d', '\U0001223e', 
    '\U0001223f', '\U00012240', '\U00012241', '\U00012242', '\U00012243', '\U00012244', '\U00012245', '\U00012246', 
    '\U00012247', '\U00012248', '\U00012249', '\U0001224a', '\U0001224b', '\U0001224c', '\U0001224d', '\U0001224e', 
    '\U0001224f', '\U00012250', '\U00012251', '\U00012252', '\U00012253', '\U00012254', '\U00012255', '\U00012256', 
    '\U00012257', '\U00012258', '\U00012259', '\U0001225a', '\U0001225b', '\U0001225c', '\U0001225d', '\U0001225e', 
    '\U0001225f', '\U00012260', '\U00012261', '\U00012262', '\U00012263', '\U00012264', '\U00012265', '\U00012266', 
    '\U00012267', '\U00012268', '\U00012269', '\U0001226a', '\U0001226b', '\U0001226c', '\U0001226d', '\U0001226e', 
    '\U0001226f', '\U00012270', '\U00012271', '\U00012272', '\U00012273', '\U00012274', '\U00012275', '\U00012276', 
    '\U00012277', '\U00012278', '\U00012279', '\U0001227a', '\U0001227b', '\U0001227c', '\U0001227d', '\U0001227e', 
    '\U0001227f', '\U00012280', '\U00012281', '\U00012282', '\U00012283', '\U00012284', '\U00012285', '\U00012286', 
    '\U00012287', '\U00012288', '\U00012289', '\U0001228a', '\U0001228b', '\U0001228c', '\U0001228d', '\U0001228e', 
    '\U0001228f', '\U00012290', '\U00012291', '\U00012292', '\U00012293', '\U00012294', '\U00012295', '\U00012296', 
    '\U00012297', '\U00012298', '\U00012299', '\U0001229a', '\U0001229b', '\U0001229c', '\U0001229d', '\U0001229e', 
    '\U0001229f', '\U000122a0', '\U000122a1', '\U000122a2', '\U000122a3', '\U000122a4', '\U000122a5', '\U000122a6', 
    '\U000122a7', '\U000122a8', '\U000122a9', '\U000122aa', '\U000122ab', '\U000122ac', '\U000122ad', '\U000122ae', 
    '\U000122af', '\U000122b0', '\U000122b1', '\U000122b2', '\U000122b3', '\U000122b4', '\U000122b5', '\U000122b6', 
    '\U000122b7', '\U000122b8', '\U000122b9', '\U000122ba', '\U000122bb', '\U000122bc', '\U000122bd', '\U000122be', 
    '\U000122bf', '\U000122c0', '\U000122c1', '\U000122c2', '\U000122c3', '\U000122c4', '\U000122c5', '\U000122c6', 
    '\U000122c7', '\U000122c8', '\U000122c9', '\U000122ca', '\U000122cb', '\U000122cc', '\U000122cd', '\U000122ce', 
    '\U000122cf', '\U000122d0', '\U000122d1', '\U000122d2', '\U000122d3', '\U000122d4', '\U000122d5', '\U000122d6', 
    '\U000122d7', '\U000122d8', '\U000122d9', '\U000122da', '\U000122db', '\U000122dc', '\U000122dd', '\U000122de', 
    '\U000122df', '\U000122e0', '\U000122e1', '\U000122e2', '\U000122e3', '\U000122e4', '\U000122e5', '\U000122e6', 
    '\U000122e7', '\U000122e8', '\U000122e9', '\U000122ea', '\U000122eb', '\U000122ec', '\U000122ed', '\U000122ee', 
    '\U000122ef', '\U000122f0', '\U000122f1', '\U000122f2', '\U000122f3', '\U000122f4', '\U000122f5', '\U000122f6', 
    '\U000122f7', '\U000122f8', '\U000122f9', '\U000122fa', '\U000122fb', '\U000122fc', '\U000122fd', '\U000122fe', 
    '\U000122ff', '\U00012300', '\U00012301', '\U00012302', '\U00012303', '\U00012304', '\U00012305', '\U00012306', 
    '\U00012307', '\U00012308', '\U00012309', '\U0001230a', '\U0001230b', '\U0001230c', '\U0001230d', '\U0001230e', 
    '\U0001230f', '\U00012310', '\U00012311', '\U00012312', '\U00012313', '\U00012314', '\U00012315', '\U00012316', 
    '\U00012317', '\U00012318', '\U00012319', '\U0001231a', '\U0001231b', '\U0001231c', '\U0001231d', '\U0001231e', 
    '\U0001231f', '\U00012320', '\U00012321', '\U00012322', '\U00012323', '\U00012324', '\U00012325', '\U00012326', 
    '\U00012327', '\U00012328', '\U00012329', '\U0001232a', '\U0001232b', '\U0001232c', '\U0001232d', '\U0001232e', 
    '\U0001232f', '\U00012330', '\U00012331', '\U00012332', '\U00012333', '\U00012334', '\U00012335', '\U00012336', 
    '\U00012337', '\U00012338', '\U00012339', '\U0001233a', '\U0001233b', '\U0001233c', '\U0001233d', '\U0001233e', 
    '\U0001233f', '\U00012340', '\U00012341', '\U00012342', '\U00012343', '\U00012344', '\U00012345', '\U00012346', 
    '\U00012347', '\U00012348', '\U00012349', '\U0001234a', '\U0001234b', '\U0001234c', '\U0001234d', '\U0001234e', 
    '\U0001234f', '\U00012350', '\U00012351', '\U00012352', '\U00012353', '\U00012354', '\U00012355', '\U00012356', 
    '\U00012357', '\U00012358', '\U00012359', '\U0001235a', '\U0001235b', '\U0001235c', '\U0001235d', '\U0001235e', 
    '\U0001235f', '\U00012360', '\U00012361', '\U00012362', '\U00012363', '\U00012364', '\U00012365', '\U00012366', 
    '\U00012367', '\U00012368', '\U00012369', '\U0001236a', '\U0001236b', '\U0001236c', '\U0001236d', '\U0001236e', 
    '\U0001236f', '\U00012370', '\U00012371', '\U00012372', '\U00012373', '\U00012374', '\U00012375', '\U00012376', 
    '\U00012377', '\U00012378', '\U00012379', '\U0001237a', '\U0001237b', '\U0001237c', '\U0001237d', '\U0001237e', 
    '\U0001237f', '\U00012380', '\U00012381', '\U00012382', '\U00012383', '\U00012384', '\U00012385', '\U00012386', 
    '\U00012387', '\U00012388', '\U00012389', '\U0001238a', '\U0001238b', '\U0001238c', '\U0001238d', '\U0001238e', 
    '\U0001238f', '\U00012390', '\U00012391', '\U00012392', '\U00012393', '\U00012394', '\U00012395', '\U00012396', 
    '\U00012397', '\U00012398', '\U00012399', '\U00012400', '\U00012401', '\U00012402', '\U00012403', '\U00012404', 
    '\U00012405', '\U00012406', '\U00012407', '\U00012408', '\U00012409', '\U0001240a', '\U0001240b', '\U0001240c', 
    '\U0001240d', '\U0001240e', '\U0001240f', '\U00012410', '\U00012411', '\U00012412', '\U00012413', '\U00012414', 
    '\U00012415', '\U00012416', '\U00012417', '\U00012418', '\U00012419', '\U0001241a', '\U0001241b', '\U0001241c', 
    '\U0001241d', '\U0001241e', '\U0001241f', '\U00012420', '\U00012421', '\U00012422', '\U00012423', '\U00012424', 
    '\U00012425', '\U00012426', '\U00012427', '\U00012428', '\U00012429', '\U0001242a', '\U0001242b', '\U0001242c', 
    '\U0001242d', '\U0001242e', '\U0001242f', '\U00012430', '\U00012431', '\U00012432', '\U00012433', '\U00012434', 
    '\U00012435', '\U00012436', '\U00012437', '\U00012438', '\U00012439', '\U0001243a', '\U0001243b', '\U0001243c', 
    '\U0001243d', '\U0001243e', '\U0001243f', '\U00012440', '\U00012441', '\U00012442', '\U00012443', '\U00012444', 
    '\U00012445', '\U00012446', '\U00012447', '\U00012448', '\U00012449', '\U0001244a', '\U0001244b', '\U0001244c', 
    '\U0001244d', '\U0001244e', '\U0001244f', '\U00012450', '\U00012451', '\U00012452', '\U00012453', '\U00012454', 
    '\U00012455', '\U00012456', '\U00012457', '\U00012458', '\U00012459', '\U0001245a', '\U0001245b', '\U0001245c', 
    '\U0001245d', '\U0001245e', '\U0001245f', '\U00012460', '\U00012461', '\U00012462', '\U00012463', '\U00012464', 
    '\U00012465', '\U00012466', '\U00012467', '\U00012468', '\U00012469', '\U0001246a', '\U0001246b', '\U0001246c', 
    '\U0001246d', '\U0001246e', '\U00012480', '\U00012481', '\U00012482', '\U00012483', '\U00012484', '\U00012485', 
    '\U00012486', '\U00012487', '\U00012488', '\U00012489', '\U0001248a', '\U0001248b', '\U0001248c', '\U0001248d', 
    '\U0001248e', '\U0001248f', '\U00012490', '\U00012491', '\U00012492', '\U00012493', '\U00012494', '\U00012495', 
    '\U00012496', '\U00012497', '\U00012498', '\U00012499', '\U0001249a', '\U0001249b', '\U0001249c', '\U0001249d', 
    '\U0001249e', '\U0001249f', '\U000124a0', '\U000124a1', '\U000124a2', '\U000124a3', '\U000124a4', '\U000124a5', 
    '\U000124a6', '\U000124a7', '\U000124a8', '\U000124a9', '\U000124aa', '\U000124ab', '\U000124ac', '\U000124ad', 
    '\U000124ae', '\U000124af', '\U000124b0', '\U000124b1', '\U000124b2', '\U000124b3', '\U000124b4', '\U000124b5', 
    '\U000124b6', '\U000124b7', '\U000124b8', '\U000124b9', '\U000124ba', '\U000124bb', '\U000124bc', '\U000124bd', 
    '\U000124be', '\U000124bf', '\U000124c0', '\U000124c1', '\U000124c2', '\U000124c3', '\U000124c4', '\U000124c5', 
    '\U000124c6', '\U000124c7', '\U000124c8', '\U000124c9', '\U000124ca', '\U000124cb', '\U000124cc', '\U000124cd', 
    '\U000124ce', '\U000124cf', '\U000124d0', '\U000124d1', '\U000124d2', '\U000124d3', '\U000124d4', '\U000124d5', 
    '\U000124d6', '\U000124d7', '\U000124d8', '\U000124d9', '\U000124da', '\U000124db', '\U000124dc', '\U000124dd', 
    '\U000124de', '\U000124df', '\U000124e0', '\U000124e1', '\U000124e2', '\U000124e3', '\U000124e4', '\U000124e5', 
    '\U000124e6', '\U000124e7', '\U000124e8', '\U000124e9', '\U000124ea', '\U000124eb', '\U000124ec', '\U000124ed', 
    '\U000124ee', '\U000124ef', '\U000124f0', '\U000124f1', '\U000124f2', '\U000124f3', '\U000124f4', '\U000124f5', 
    '\U000124f6', '\U000124f7', '\U000124f8', '\U000124f9', '\U000124fa', '\U000124fb', '\U000124fc', '\U000124fd', 
    '\U000124fe', '\U000124ff', '\U00012500', '\U00012501', '\U00012502', '\U00012503', '\U00012504', '\U00012505', 
    '\U00012506', '\U00012507', '\U00012508', '\U00012509', '\U0001250a', '\U0001250b', '\U0001250c', '\U0001250d', 
    '\U0001250e', '\U0001250f', '\U00012510', '\U00012511', '\U00012512', '\U00012513', '\U00012514', '\U00012515', 
    '\U00012516', '\U00012517', '\U00012518', '\U00012519', '\U0001251a', '\U0001251b', '\U0001251c', '\U0001251d', 
    '\U0001251e', '\U0001251f', '\U00012520', '\U00012521', '\U00012522', '\U00012523', '\U00012524', '\U00012525', 
    '\U00012526', '\U00012527', '\U00012528', '\U00012529', '\U0001252a', '\U0001252b', '\U0001252c', '\U0001252d', 
    '\U0001252e', '\U0001252f', '\U00012530', '\U00012531', '\U00012532', '\U00012533', '\U00012534', '\U00012535', 
    '\U00012536', '\U00012537', '\U00012538', '\U00012539', '\U0001253a', '\U0001253b', '\U0001253c', '\U0001253d', 
    '\U0001253e', '\U0001253f', '\U00012540', '\U00012541', '\U00012542', '\U00012543', '\U00013000', '\U00013001', 
    '\U00013002', '\U00013003', '\U00013004', '\U00013005', '\U00013006', '\U00013007', '\U00013008', '\U00013009', 
    '\U0001300a', '\U0001300b', '\U0001300c', '\U0001300d', '\U0001300e', '\U0001300f', '\U00013010', '\U00013011', 
    '\U00013012', '\U00013013', '\U00013014', '\U00013015', '\U00013016', '\U00013017', '\U00013018', '\U00013019', 
    '\U0001301a', '\U0001301b', '\U0001301c', '\U0001301d', '\U0001301e', '\U0001301f', '\U00013020', '\U00013021', 
    '\U00013022', '\U00013023', '\U00013024', '\U00013025', '\U00013026', '\U00013027', '\U00013028', '\U00013029', 
    '\U0001302a', '\U0001302b', '\U0001302c', '\U0001302d', '\U0001302e', '\U0001302f', '\U00013030', '\U00013031', 
    '\U00013032', '\U00013033', '\U00013034', '\U00013035', '\U00013036', '\U00013037', '\U00013038', '\U00013039', 
    '\U0001303a', '\U0001303b', '\U0001303c', '\U0001303d', '\U0001303e', '\U0001303f', '\U00013040', '\U00013041', 
    '\U00013042', '\U00013043', '\U00013044', '\U00013045', '\U00013046', '\U00013047', '\U00013048', '\U00013049', 
    '\U0001304a', '\U0001304b', '\U0001304c', '\U0001304d', '\U0001304e', '\U0001304f', '\U00013050', '\U00013051', 
    '\U00013052', '\U00013053', '\U00013054', '\U00013055', '\U00013056', '\U00013057', '\U00013058', '\U00013059', 
    '\U0001305a', '\U0001305b', '\U0001305c', '\U0001305d', '\U0001305e', '\U0001305f', '\U00013060', '\U00013061', 
    '\U00013062', '\U00013063', '\U00013064', '\U00013065', '\U00013066', '\U00013067', '\U00013068', '\U00013069', 
    '\U0001306a', '\U0001306b', '\U0001306c', '\U0001306d', '\U0001306e', '\U0001306f', '\U00013070', '\U00013071', 
    '\U00013072', '\U00013073', '\U00013074', '\U00013075', '\U00013076', '\U00013077', '\U00013078', '\U00013079', 
    '\U0001307a', '\U0001307b', '\U0001307c', '\U0001307d', '\U0001307e', '\U0001307f', '\U00013080', '\U00013081', 
    '\U00013082', '\U00013083', '\U00013084', '\U00013085', '\U00013086', '\U00013087', '\U00013088', '\U00013089', 
    '\U0001308a', '\U0001308b', '\U0001308c', '\U0001308d', '\U0001308e', '\U0001308f', '\U00013090', '\U00013091', 
    '\U00013092', '\U00013093', '\U00013094', '\U00013095', '\U00013096', '\U00013097', '\U00013098', '\U00013099', 
    '\U0001309a', '\U0001309b', '\U0001309c', '\U0001309d', '\U0001309e', '\U0001309f', '\U000130a0', '\U000130a1', 
    '\U000130a2', '\U000130a3', '\U000130a4', '\U000130a5', '\U000130a6', '\U000130a7', '\U000130a8', '\U000130a9', 
    '\U000130aa', '\U000130ab', '\U000130ac', '\U000130ad', '\U000130ae', '\U000130af', '\U000130b0', '\U000130b1', 
    '\U000130b2', '\U000130b3', '\U000130b4', '\U000130b5', '\U000130b6', '\U000130b7', '\U000130b8', '\U000130b9', 
    '\U000130ba', '\U000130bb', '\U000130bc', '\U000130bd', '\U000130be', '\U000130bf', '\U000130c0', '\U000130c1', 
    '\U000130c2', '\U000130c3', '\U000130c4', '\U000130c5', '\U000130c6', '\U000130c7', '\U000130c8', '\U000130c9', 
    '\U000130ca', '\U000130cb', '\U000130cc', '\U000130cd', '\U000130ce', '\U000130cf', '\U000130d0', '\U000130d1', 
    '\U000130d2', '\U000130d3', '\U000130d4', '\U000130d5', '\U000130d6', '\U000130d7', '\U000130d8', '\U000130d9', 
    '\U000130da', '\U000130db', '\U000130dc', '\U000130dd', '\U000130de', '\U000130df', '\U000130e0', '\U000130e1', 
    '\U000130e2', '\U000130e3', '\U000130e4', '\U000130e5', '\U000130e6', '\U000130e7', '\U000130e8', '\U000130e9', 
    '\U000130ea', '\U000130eb', '\U000130ec', '\U000130ed', '\U000130ee', '\U000130ef', '\U000130f0', '\U000130f1', 
    '\U000130f2', '\U000130f3', '\U000130f4', '\U000130f5', '\U000130f6', '\U000130f7', '\U000130f8', '\U000130f9', 
    '\U000130fa', '\U000130fb', '\U000130fc', '\U000130fd', '\U000130fe', '\U000130ff', '\U00013100', '\U00013101', 
    '\U00013102', '\U00013103', '\U00013104', '\U00013105', '\U00013106', '\U00013107', '\U00013108', '\U00013109', 
    '\U0001310a', '\U0001310b', '\U0001310c', '\U0001310d', '\U0001310e', '\U0001310f', '\U00013110', '\U00013111', 
    '\U00013112', '\U00013113', '\U00013114', '\U00013115', '\U00013116', '\U00013117', '\U00013118', '\U00013119', 
    '\U0001311a', '\U0001311b', '\U0001311c', '\U0001311d', '\U0001311e', '\U0001311f', '\U00013120', '\U00013121', 
    '\U00013122', '\U00013123', '\U00013124', '\U00013125', '\U00013126', '\U00013127', '\U00013128', '\U00013129', 
    '\U0001312a', '\U0001312b', '\U0001312c', '\U0001312d', '\U0001312e', '\U0001312f', '\U00013130', '\U00013131', 
    '\U00013132', '\U00013133', '\U00013134', '\U00013135', '\U00013136', '\U00013137', '\U00013138', '\U00013139', 
    '\U0001313a', '\U0001313b', '\U0001313c', '\U0001313d', '\U0001313e', '\U0001313f', '\U00013140', '\U00013141', 
    '\U00013142', '\U00013143', '\U00013144', '\U00013145', '\U00013146', '\U00013147', '\U00013148', '\U00013149', 
    '\U0001314a', '\U0001314b', '\U0001314c', '\U0001314d', '\U0001314e', '\U0001314f', '\U00013150', '\U00013151', 
    '\U00013152', '\U00013153', '\U00013154', '\U00013155', '\U00013156', '\U00013157', '\U00013158', '\U00013159', 
    '\U0001315a', '\U0001315b', '\U0001315c', '\U0001315d', '\U0001315e', '\U0001315f', '\U00013160', '\U00013161', 
    '\U00013162', '\U00013163', '\U00013164', '\U00013165', '\U00013166', '\U00013167', '\U00013168', '\U00013169', 
    '\U0001316a', '\U0001316b', '\U0001316c', '\U0001316d', '\U0001316e', '\U0001316f', '\U00013170', '\U00013171', 
    '\U00013172', '\U00013173', '\U00013174', '\U00013175', '\U00013176', '\U00013177', '\U00013178', '\U00013179', 
    '\U0001317a', '\U0001317b', '\U0001317c', '\U0001317d', '\U0001317e', '\U0001317f', '\U00013180', '\U00013181', 
    '\U00013182', '\U00013183', '\U00013184', '\U00013185', '\U00013186', '\U00013187', '\U00013188', '\U00013189', 
    '\U0001318a', '\U0001318b', '\U0001318c', '\U0001318d', '\U0001318e', '\U0001318f', '\U00013190', '\U00013191', 
    '\U00013192', '\U00013193', '\U00013194', '\U00013195', '\U00013196', '\U00013197', '\U00013198', '\U00013199', 
    '\U0001319a', '\U0001319b', '\U0001319c', '\U0001319d', '\U0001319e', '\U0001319f', '\U000131a0', '\U000131a1', 
    '\U000131a2', '\U000131a3', '\U000131a4', '\U000131a5', '\U000131a6', '\U000131a7', '\U000131a8', '\U000131a9', 
    '\U000131aa', '\U000131ab', '\U000131ac', '\U000131ad', '\U000131ae', '\U000131af', '\U000131b0', '\U000131b1', 
    '\U000131b2', '\U000131b3', '\U000131b4', '\U000131b5', '\U000131b6', '\U000131b7', '\U000131b8', '\U000131b9', 
    '\U000131ba', '\U000131bb', '\U000131bc', '\U000131bd', '\U000131be', '\U000131bf', '\U000131c0', '\U000131c1', 
    '\U000131c2', '\U000131c3', '\U000131c4', '\U000131c5', '\U000131c6', '\U000131c7', '\U000131c8', '\U000131c9', 
    '\U000131ca', '\U000131cb', '\U000131cc', '\U000131cd', '\U000131ce', '\U000131cf', '\U000131d0', '\U000131d1', 
    '\U000131d2', '\U000131d3', '\U000131d4', '\U000131d5', '\U000131d6', '\U000131d7', '\U000131d8', '\U000131d9', 
    '\U000131da', '\U000131db', '\U000131dc', '\U000131dd', '\U000131de', '\U000131df', '\U000131e0', '\U000131e1', 
    '\U000131e2', '\U000131e3', '\U000131e4', '\U000131e5', '\U000131e6', '\U000131e7', '\U000131e8', '\U000131e9', 
    '\U000131ea', '\U000131eb', '\U000131ec', '\U000131ed', '\U000131ee', '\U000131ef', '\U000131f0', '\U000131f1', 
    '\U000131f2', '\U000131f3', '\U000131f4', '\U000131f5', '\U000131f6', '\U000131f7', '\U000131f8', '\U000131f9', 
    '\U000131fa', '\U000131fb', '\U000131fc', '\U000131fd', '\U000131fe', '\U000131ff', '\U00013200', '\U00013201', 
    '\U00013202', '\U00013203', '\U00013204', '\U00013205', '\U00013206', '\U00013207', '\U00013208', '\U00013209', 
    '\U0001320a', '\U0001320b', '\U0001320c', '\U0001320d', '\U0001320e', '\U0001320f', '\U00013210', '\U00013211', 
    '\U00013212', '\U00013213', '\U00013214', '\U00013215', '\U00013216', '\U00013217', '\U00013218', '\U00013219', 
    '\U0001321a', '\U0001321b', '\U0001321c', '\U0001321d', '\U0001321e', '\U0001321f', '\U00013220', '\U00013221', 
    '\U00013222', '\U00013223', '\U00013224', '\U00013225', '\U00013226', '\U00013227', '\U00013228', '\U00013229', 
    '\U0001322a', '\U0001322b', '\U0001322c', '\U0001322d', '\U0001322e', '\U0001322f', '\U00013230', '\U00013231', 
    '\U00013232', '\U00013233', '\U00013234', '\U00013235', '\U00013236', '\U00013237', '\U00013238', '\U00013239', 
    '\U0001323a', '\U0001323b', '\U0001323c', '\U0001323d', '\U0001323e', '\U0001323f', '\U00013240', '\U00013241', 
    '\U00013242', '\U00013243', '\U00013244', '\U00013245', '\U00013246', '\U00013247', '\U00013248', '\U00013249', 
    '\U0001324a', '\U0001324b', '\U0001324c', '\U0001324d', '\U0001324e', '\U0001324f', '\U00013250', '\U00013251', 
    '\U00013252', '\U00013253', '\U00013254', '\U00013255', '\U00013256', '\U00013257', '\U00013258', '\U00013259', 
    '\U0001325a', '\U0001325b', '\U0001325c', '\U0001325d', '\U0001325e', '\U0001325f', '\U00013260', '\U00013261', 
    '\U00013262', '\U00013263', '\U00013264', '\U00013265', '\U00013266', '\U00013267', '\U00013268', '\U00013269', 
    '\U0001326a', '\U0001326b', '\U0001326c', '\U0001326d', '\U0001326e', '\U0001326f', '\U00013270', '\U00013271', 
    '\U00013272', '\U00013273', '\U00013274', '\U00013275', '\U00013276', '\U00013277', '\U00013278', '\U00013279', 
    '\U0001327a', '\U0001327b', '\U0001327c', '\U0001327d', '\U0001327e', '\U0001327f', '\U00013280', '\U00013281', 
    '\U00013282', '\U00013283', '\U00013284', '\U00013285', '\U00013286', '\U00013287', '\U00013288', '\U00013289', 
    '\U0001328a', '\U0001328b', '\U0001328c', '\U0001328d', '\U0001328e', '\U0001328f', '\U00013290', '\U00013291', 
    '\U00013292', '\U00013293', '\U00013294', '\U00013295', '\U00013296', '\U00013297', '\U00013298', '\U00013299', 
    '\U0001329a', '\U0001329b', '\U0001329c', '\U0001329d', '\U0001329e', '\U0001329f', '\U000132a0', '\U000132a1', 
    '\U000132a2', '\U000132a3', '\U000132a4', '\U000132a5', '\U000132a6', '\U000132a7', '\U000132a8', '\U000132a9', 
    '\U000132aa', '\U000132ab', '\U000132ac', '\U000132ad', '\U000132ae', '\U000132af', '\U000132b0', '\U000132b1', 
    '\U000132b2', '\U000132b3', '\U000132b4', '\U000132b5', '\U000132b6', '\U000132b7', '\U000132b8', '\U000132b9', 
    '\U000132ba', '\U000132bb', '\U000132bc', '\U000132bd', '\U000132be', '\U000132bf', '\U000132c0', '\U000132c1', 
    '\U000132c2', '\U000132c3', '\U000132c4', '\U000132c5', '\U000132c6', '\U000132c7', '\U000132c8', '\U000132c9', 
    '\U000132ca', '\U000132cb', '\U000132cc', '\U000132cd', '\U000132ce', '\U000132cf', '\U000132d0', '\U000132d1', 
    '\U000132d2', '\U000132d3', '\U000132d4', '\U000132d5', '\U000132d6', '\U000132d7', '\U000132d8', '\U000132d9', 
    '\U000132da', '\U000132db', '\U000132dc', '\U000132dd', '\U000132de', '\U000132df', '\U000132e0', '\U000132e1', 
    '\U000132e2', '\U000132e3', '\U000132e4', '\U000132e5', '\U000132e6', '\U000132e7', '\U000132e8', '\U000132e9', 
    '\U000132ea', '\U000132eb', '\U000132ec', '\U000132ed', '\U000132ee', '\U000132ef', '\U000132f0', '\U000132f1', 
    '\U000132f2', '\U000132f3', '\U000132f4', '\U000132f5', '\U000132f6', '\U000132f7', '\U000132f8', '\U000132f9', 
    '\U000132fa', '\U000132fb', '\U000132fc', '\U000132fd', '\U000132fe', '\U000132ff', '\U00013300', '\U00013301', 
    '\U00013302', '\U00013303', '\U00013304', '\U00013305', '\U00013306', '\U00013307', '\U00013308', '\U00013309', 
    '\U0001330a', '\U0001330b', '\U0001330c', '\U0001330d', '\U0001330e', '\U0001330f', '\U00013310', '\U00013311', 
    '\U00013312', '\U00013313', '\U00013314', '\U00013315', '\U00013316', '\U00013317', '\U00013318', '\U00013319', 
    '\U0001331a', '\U0001331b', '\U0001331c', '\U0001331d', '\U0001331e', '\U0001331f', '\U00013320', '\U00013321', 
    '\U00013322', '\U00013323', '\U00013324', '\U00013325', '\U00013326', '\U00013327', '\U00013328', '\U00013329', 
    '\U0001332a', '\U0001332b', '\U0001332c', '\U0001332d', '\U0001332e', '\U0001332f', '\U00013330', '\U00013331', 
    '\U00013332', '\U00013333', '\U00013334', '\U00013335', '\U00013336', '\U00013337', '\U00013338', '\U00013339', 
    '\U0001333a', '\U0001333b', '\U0001333c', '\U0001333d', '\U0001333e', '\U0001333f', '\U00013340', '\U00013341', 
    '\U00013342', '\U00013343', '\U00013344', '\U00013345', '\U00013346', '\U00013347', '\U00013348', '\U00013349', 
    '\U0001334a', '\U0001334b', '\U0001334c', '\U0001334d', '\U0001334e', '\U0001334f', '\U00013350', '\U00013351', 
    '\U00013352', '\U00013353', '\U00013354', '\U00013355', '\U00013356', '\U00013357', '\U00013358', '\U00013359', 
    '\U0001335a', '\U0001335b', '\U0001335c', '\U0001335d', '\U0001335e', '\U0001335f', '\U00013360', '\U00013361', 
    '\U00013362', '\U00013363', '\U00013364', '\U00013365', '\U00013366', '\U00013367', '\U00013368', '\U00013369', 
    '\U0001336a', '\U0001336b', '\U0001336c', '\U0001336d', '\U0001336e', '\U0001336f', '\U00013370', '\U00013371', 
    '\U00013372', '\U00013373', '\U00013374', '\U00013375', '\U00013376', '\U00013377', '\U00013378', '\U00013379', 
    '\U0001337a', '\U0001337b', '\U0001337c', '\U0001337d', '\U0001337e', '\U0001337f', '\U00013380', '\U00013381', 
    '\U00013382', '\U00013383', '\U00013384', '\U00013385', '\U00013386', '\U00013387', '\U00013388', '\U00013389', 
    '\U0001338a', '\U0001338b', '\U0001338c', '\U0001338d', '\U0001338e', '\U0001338f', '\U00013390', '\U00013391', 
    '\U00013392', '\U00013393', '\U00013394', '\U00013395', '\U00013396', '\U00013397', '\U00013398', '\U00013399', 
    '\U0001339a', '\U0001339b', '\U0001339c', '\U0001339d', '\U0001339e', '\U0001339f', '\U000133a0', '\U000133a1', 
    '\U000133a2', '\U000133a3', '\U000133a4', '\U000133a5', '\U000133a6', '\U000133a7', '\U000133a8', '\U000133a9', 
    '\U000133aa', '\U000133ab', '\U000133ac', '\U000133ad', '\U000133ae', '\U000133af', '\U000133b0', '\U000133b1', 
    '\U000133b2', '\U000133b3', '\U000133b4', '\U000133b5', '\U000133b6', '\U000133b7', '\U000133b8', '\U000133b9', 
    '\U000133ba', '\U000133bb', '\U000133bc', '\U000133bd', '\U000133be', '\U000133bf', '\U000133c0', '\U000133c1', 
    '\U000133c2', '\U000133c3', '\U000133c4', '\U000133c5', '\U000133c6', '\U000133c7', '\U000133c8', '\U000133c9', 
    '\U000133ca', '\U000133cb', '\U000133cc', '\U000133cd', '\U000133ce', '\U000133cf', '\U000133d0', '\U000133d1', 
    '\U000133d2', '\U000133d3', '\U000133d4', '\U000133d5', '\U000133d6', '\U000133d7', '\U000133d8', '\U000133d9', 
    '\U000133da', '\U000133db', '\U000133dc', '\U000133dd', '\U000133de', '\U000133df', '\U000133e0', '\U000133e1', 
    '\U000133e2', '\U000133e3', '\U000133e4', '\U000133e5', '\U000133e6', '\U000133e7', '\U000133e8', '\U000133e9', 
    '\U000133ea', '\U000133eb', '\U000133ec', '\U000133ed', '\U000133ee', '\U000133ef', '\U000133f0', '\U000133f1', 
    '\U000133f2', '\U000133f3', '\U000133f4', '\U000133f5', '\U000133f6', '\U000133f7', '\U000133f8', '\U000133f9', 
    '\U000133fa', '\U000133fb', '\U000133fc', '\U000133fd', '\U000133fe', '\U000133ff', '\U00013400', '\U00013401', 
    '\U00013402', '\U00013403', '\U00013404', '\U00013405', '\U00013406', '\U00013407', '\U00013408', '\U00013409', 
    '\U0001340a', '\U0001340b', '\U0001340c', '\U0001340d', '\U0001340e', '\U0001340f', '\U00013410', '\U00013411', 
    '\U00013412', '\U00013413', '\U00013414', '\U00013415', '\U00013416', '\U00013417', '\U00013418', '\U00013419', 
    '\U0001341a', '\U0001341b', '\U0001341c', '\U0001341d', '\U0001341e', '\U0001341f', '\U00013420', '\U00013421', 
    '\U00013422', '\U00013423', '\U00013424', '\U00013425', '\U00013426', '\U00013427', '\U00013428', '\U00013429', 
    '\U0001342a', '\U0001342b', '\U0001342c', '\U0001342d', '\U0001342e', '\U00014400', '\U00014401', '\U00014402', 
    '\U00014403', '\U00014404', '\U00014405', '\U00014406', '\U00014407', '\U00014408', '\U00014409', '\U0001440a', 
    '\U0001440b', '\U0001440c', '\U0001440d', '\U0001440e', '\U0001440f', '\U00014410', '\U00014411', '\U00014412', 
    '\U00014413', '\U00014414', '\U00014415', '\U00014416', '\U00014417', '\U00014418', '\U00014419', '\U0001441a', 
    '\U0001441b', '\U0001441c', '\U0001441d', '\U0001441e', '\U0001441f', '\U00014420', '\U00014421', '\U00014422', 
    '\U00014423', '\U00014424', '\U00014425', '\U00014426', '\U00014427', '\U00014428', '\U00014429', '\U0001442a', 
    '\U0001442b', '\U0001442c', '\U0001442d', '\U0001442e', '\U0001442f', '\U00014430', '\U00014431', '\U00014432', 
    '\U00014433', '\U00014434', '\U00014435', '\U00014436', '\U00014437', '\U00014438', '\U00014439', '\U0001443a', 
    '\U0001443b', '\U0001443c', '\U0001443d', '\U0001443e', '\U0001443f', '\U00014440', '\U00014441', '\U00014442', 
    '\U00014443', '\U00014444', '\U00014445', '\U00014446', '\U00014447', '\U00014448', '\U00014449', '\U0001444a', 
    '\U0001444b', '\U0001444c', '\U0001444d', '\U0001444e', '\U0001444f', '\U00014450', '\U00014451', '\U00014452', 
    '\U00014453', '\U00014454', '\U00014455', '\U00014456', '\U00014457', '\U00014458', '\U00014459', '\U0001445a', 
    '\U0001445b', '\U0001445c', '\U0001445d', '\U0001445e', '\U0001445f', '\U00014460', '\U00014461', '\U00014462', 
    '\U00014463', '\U00014464', '\U00014465', '\U00014466', '\U00014467', '\U00014468', '\U00014469', '\U0001446a', 
    '\U0001446b', '\U0001446c', '\U0001446d', '\U0001446e', '\U0001446f', '\U00014470', '\U00014471', '\U00014472', 
    '\U00014473', '\U00014474', '\U00014475', '\U00014476', '\U00014477', '\U00014478', '\U00014479', '\U0001447a', 
    '\U0001447b', '\U0001447c', '\U0001447d', '\U0001447e', '\U0001447f', '\U00014480', '\U00014481', '\U00014482', 
    '\U00014483', '\U00014484', '\U00014485', '\U00014486', '\U00014487', '\U00014488', '\U00014489', '\U0001448a', 
    '\U0001448b', '\U0001448c', '\U0001448d', '\U0001448e', '\U0001448f', '\U00014490', '\U00014491', '\U00014492', 
    '\U00014493', '\U00014494', '\U00014495', '\U00014496', '\U00014497', '\U00014498', '\U00014499', '\U0001449a', 
    '\U0001449b', '\U0001449c', '\U0001449d', '\U0001449e', '\U0001449f', '\U000144a0', '\U000144a1', '\U000144a2', 
    '\U000144a3', '\U000144a4', '\U000144a5', '\U000144a6', '\U000144a7', '\U000144a8', '\U000144a9', '\U000144aa', 
    '\U000144ab', '\U000144ac', '\U000144ad', '\U000144ae', '\U000144af', '\U000144b0', '\U000144b1', '\U000144b2', 
    '\U000144b3', '\U000144b4', '\U000144b5', '\U000144b6', '\U000144b7', '\U000144b8', '\U000144b9', '\U000144ba', 
    '\U000144bb', '\U000144bc', '\U000144bd', '\U000144be', '\U000144bf', '\U000144c0', '\U000144c1', '\U000144c2', 
    '\U000144c3', '\U000144c4', '\U000144c5', '\U000144c6', '\U000144c7', '\U000144c8', '\U000144c9', '\U000144ca', 
    '\U000144cb', '\U000144cc', '\U000144cd', '\U000144ce', '\U000144cf', '\U000144d0', '\U000144d1', '\U000144d2', 
    '\U000144d3', '\U000144d4', '\U000144d5', '\U000144d6', '\U000144d7', '\U000144d8', '\U000144d9', '\U000144da', 
    '\U000144db', '\U000144dc', '\U000144dd', '\U000144de', '\U000144df', '\U000144e0', '\U000144e1', '\U000144e2', 
    '\U000144e3', '\U000144e4', '\U000144e5', '\U000144e6', '\U000144e7', '\U000144e8', '\U000144e9', '\U000144ea', 
    '\U000144eb', '\U000144ec', '\U000144ed', '\U000144ee', '\U000144ef', '\U000144f0', '\U000144f1', '\U000144f2', 
    '\U000144f3', '\U000144f4', '\U000144f5', '\U000144f6', '\U000144f7', '\U000144f8', '\U000144f9', '\U000144fa', 
    '\U000144fb', '\U000144fc', '\U000144fd', '\U000144fe', '\U000144ff', '\U00014500', '\U00014501', '\U00014502', 
    '\U00014503', '\U00014504', '\U00014505', '\U00014506', '\U00014507', '\U00014508', '\U00014509', '\U0001450a', 
    '\U0001450b', '\U0001450c', '\U0001450d', '\U0001450e', '\U0001450f', '\U00014510', '\U00014511', '\U00014512', 
    '\U00014513', '\U00014514', '\U00014515', '\U00014516', '\U00014517', '\U00014518', '\U00014519', '\U0001451a', 
    '\U0001451b', '\U0001451c', '\U0001451d', '\U0001451e', '\U0001451f', '\U00014520', '\U00014521', '\U00014522', 
    '\U00014523', '\U00014524', '\U00014525', '\U00014526', '\U00014527', '\U00014528', '\U00014529', '\U0001452a', 
    '\U0001452b', '\U0001452c', '\U0001452d', '\U0001452e', '\U0001452f', '\U00014530', '\U00014531', '\U00014532', 
    '\U00014533', '\U00014534', '\U00014535', '\U00014536', '\U00014537', '\U00014538', '\U00014539', '\U0001453a', 
    '\U0001453b', '\U0001453c', '\U0001453d', '\U0001453e', '\U0001453f', '\U00014540', '\U00014541', '\U00014542', 
    '\U00014543', '\U00014544', '\U00014545', '\U00014546', '\U00014547', '\U00014548', '\U00014549', '\U0001454a', 
    '\U0001454b', '\U0001454c', '\U0001454d', '\U0001454e', '\U0001454f', '\U00014550', '\U00014551', '\U00014552', 
    '\U00014553', '\U00014554', '\U00014555', '\U00014556', '\U00014557', '\U00014558', '\U00014559', '\U0001455a', 
    '\U0001455b', '\U0001455c', '\U0001455d', '\U0001455e', '\U0001455f', '\U00014560', '\U00014561', '\U00014562', 
    '\U00014563', '\U00014564', '\U00014565', '\U00014566', '\U00014567', '\U00014568', '\U00014569', '\U0001456a', 
    '\U0001456b', '\U0001456c', '\U0001456d', '\U0001456e', '\U0001456f', '\U00014570', '\U00014571', '\U00014572', 
    '\U00014573', '\U00014574', '\U00014575', '\U00014576', '\U00014577', '\U00014578', '\U00014579', '\U0001457a', 
    '\U0001457b', '\U0001457c', '\U0001457d', '\U0001457e', '\U0001457f', '\U00014580', '\U00014581', '\U00014582', 
    '\U00014583', '\U00014584', '\U00014585', '\U00014586', '\U00014587', '\U00014588', '\U00014589', '\U0001458a', 
    '\U0001458b', '\U0001458c', '\U0001458d', '\U0001458e', '\U0001458f', '\U00014590', '\U00014591', '\U00014592', 
    '\U00014593', '\U00014594', '\U00014595', '\U00014596', '\U00014597', '\U00014598', '\U00014599', '\U0001459a', 
    '\U0001459b', '\U0001459c', '\U0001459d', '\U0001459e', '\U0001459f', '\U000145a0', '\U000145a1', '\U000145a2', 
    '\U000145a3', '\U000145a4', '\U000145a5', '\U000145a6', '\U000145a7', '\U000145a8', '\U000145a9', '\U000145aa', 
    '\U000145ab', '\U000145ac', '\U000145ad', '\U000145ae', '\U000145af', '\U000145b0', '\U000145b1', '\U000145b2', 
    '\U000145b3', '\U000145b4', '\U000145b5', '\U000145b6', '\U000145b7', '\U000145b8', '\U000145b9', '\U000145ba', 
    '\U000145bb', '\U000145bc', '\U000145bd', '\U000145be', '\U000145bf', '\U000145c0', '\U000145c1', '\U000145c2', 
    '\U000145c3', '\U000145c4', '\U000145c5', '\U000145c6', '\U000145c7', '\U000145c8', '\U000145c9', '\U000145ca', 
    '\U000145cb', '\U000145cc', '\U000145cd', '\U000145ce', '\U000145cf', '\U000145d0', '\U000145d1', '\U000145d2', 
    '\U000145d3', '\U000145d4', '\U000145d5', '\U000145d6', '\U000145d7', '\U000145d8', '\U000145d9', '\U000145da', 
    '\U000145db', '\U000145dc', '\U000145dd', '\U000145de', '\U000145df', '\U000145e0', '\U000145e1', '\U000145e2', 
    '\U000145e3', '\U000145e4', '\U000145e5', '\U000145e6', '\U000145e7', '\U000145e8', '\U000145e9', '\U000145ea', 
    '\U000145eb', '\U000145ec', '\U000145ed', '\U000145ee', '\U000145ef', '\U000145f0', '\U000145f1', '\U000145f2', 
    '\U000145f3', '\U000145f4', '\U000145f5', '\U000145f6', '\U000145f7', '\U000145f8', '\U000145f9', '\U000145fa', 
    '\U000145fb', '\U000145fc', '\U000145fd', '\U000145fe', '\U000145ff', '\U00014600', '\U00014601', '\U00014602', 
    '\U00014603', '\U00014604', '\U00014605', '\U00014606', '\U00014607', '\U00014608', '\U00014609', '\U0001460a', 
    '\U0001460b', '\U0001460c', '\U0001460d', '\U0001460e', '\U0001460f', '\U00014610', '\U00014611', '\U00014612', 
    '\U00014613', '\U00014614', '\U00014615', '\U00014616', '\U00014617', '\U00014618', '\U00014619', '\U0001461a', 
    '\U0001461b', '\U0001461c', '\U0001461d', '\U0001461e', '\U0001461f', '\U00014620', '\U00014621', '\U00014622', 
    '\U00014623', '\U00014624', '\U00014625', '\U00014626', '\U00014627', '\U00014628', '\U00014629', '\U0001462a', 
    '\U0001462b', '\U0001462c', '\U0001462d', '\U0001462e', '\U0001462f', '\U00014630', '\U00014631', '\U00014632', 
    '\U00014633', '\U00014634', '\U00014635', '\U00014636', '\U00014637', '\U00014638', '\U00014639', '\U0001463a', 
    '\U0001463b', '\U0001463c', '\U0001463d', '\U0001463e', '\U0001463f', '\U00014640', '\U00014641', '\U00014642', 
    '\U00014643', '\U00014644', '\U00014645', '\U00014646', '\U00016800', '\U00016801', '\U00016802', '\U00016803', 
    '\U00016804', '\U00016805', '\U00016806', '\U00016807', '\U00016808', '\U00016809', '\U0001680a', '\U0001680b', 
    '\U0001680c', '\U0001680d', '\U0001680e', '\U0001680f', '\U00016810', '\U00016811', '\U00016812', '\U00016813', 
    '\U00016814', '\U00016815', '\U00016816', '\U00016817', '\U00016818', '\U00016819', '\U0001681a', '\U0001681b', 
    '\U0001681c', '\U0001681d', '\U0001681e', '\U0001681f', '\U00016820', '\U00016821', '\U00016822', '\U00016823', 
    '\U00016824', '\U00016825', '\U00016826', '\U00016827', '\U00016828', '\U00016829', '\U0001682a', '\U0001682b', 
    '\U0001682c', '\U0001682d', '\U0001682e', '\U0001682f', '\U00016830', '\U00016831', '\U00016832', '\U00016833', 
    '\U00016834', '\U00016835', '\U00016836', '\U00016837', '\U00016838', '\U00016839', '\U0001683a', '\U0001683b', 
    '\U0001683c', '\U0001683d', '\U0001683e', '\U0001683f', '\U00016840', '\U00016841', '\U00016842', '\U00016843', 
    '\U00016844', '\U00016845', '\U00016846', '\U00016847', '\U00016848', '\U00016849', '\U0001684a', '\U0001684b', 
    '\U0001684c', '\U0001684d', '\U0001684e', '\U0001684f', '\U00016850', '\U00016851', '\U00016852', '\U00016853', 
    '\U00016854', '\U00016855', '\U00016856', '\U00016857', '\U00016858', '\U00016859', '\U0001685a', '\U0001685b', 
    '\U0001685c', '\U0001685d', '\U0001685e', '\U0001685f', '\U00016860', '\U00016861', '\U00016862', '\U00016863', 
    '\U00016864', '\U00016865', '\U00016866', '\U00016867', '\U00016868', '\U00016869', '\U0001686a', '\U0001686b', 
    '\U0001686c', '\U0001686d', '\U0001686e', '\U0001686f', '\U00016870', '\U00016871', '\U00016872', '\U00016873', 
    '\U00016874', '\U00016875', '\U00016876', '\U00016877', '\U00016878', '\U00016879', '\U0001687a', '\U0001687b', 
    '\U0001687c', '\U0001687d', '\U0001687e', '\U0001687f', '\U00016880', '\U00016881', '\U00016882', '\U00016883', 
    '\U00016884', '\U00016885', '\U00016886', '\U00016887', '\U00016888', '\U00016889', '\U0001688a', '\U0001688b', 
    '\U0001688c', '\U0001688d', '\U0001688e', '\U0001688f', '\U00016890', '\U00016891', '\U00016892', '\U00016893', 
    '\U00016894', '\U00016895', '\U00016896', '\U00016897', '\U00016898', '\U00016899', '\U0001689a', '\U0001689b', 
    '\U0001689c', '\U0001689d', '\U0001689e', '\U0001689f', '\U000168a0', '\U000168a1', '\U000168a2', '\U000168a3', 
    '\U000168a4', '\U000168a5', '\U000168a6', '\U000168a7', '\U000168a8', '\U000168a9', '\U000168aa', '\U000168ab', 
    '\U000168ac', '\U000168ad', '\U000168ae', '\U000168af', '\U000168b0', '\U000168b1', '\U000168b2', '\U000168b3', 
    '\U000168b4', '\U000168b5', '\U000168b6', '\U000168b7', '\U000168b8', '\U000168b9', '\U000168ba', '\U000168bb', 
    '\U000168bc', '\U000168bd', '\U000168be', '\U000168bf', '\U000168c0', '\U000168c1', '\U000168c2', '\U000168c3', 
    '\U000168c4', '\U000168c5', '\U000168c6', '\U000168c7', '\U000168c8', '\U000168c9', '\U000168ca', '\U000168cb', 
    '\U000168cc', '\U000168cd', '\U000168ce', '\U000168cf', '\U000168d0', '\U000168d1', '\U000168d2', '\U000168d3', 
    '\U000168d4', '\U000168d5', '\U000168d6', '\U000168d7', '\U000168d8', '\U000168d9', '\U000168da', '\U000168db', 
    '\U000168dc', '\U000168dd', '\U000168de', '\U000168df', '\U000168e0', '\U000168e1', '\U000168e2', '\U000168e3', 
    '\U000168e4', '\U000168e5', '\U000168e6', '\U000168e7', '\U000168e8', '\U000168e9', '\U000168ea', '\U000168eb', 
    '\U000168ec', '\U000168ed', '\U000168ee', '\U000168ef', '\U000168f0', '\U000168f1', '\U000168f2', '\U000168f3', 
    '\U000168f4', '\U000168f5', '\U000168f6', '\U000168f7', '\U000168f8', '\U000168f9', '\U000168fa', '\U000168fb', 
    '\U000168fc', '\U000168fd', '\U000168fe', '\U000168ff', '\U00016900', '\U00016901', '\U00016902', '\U00016903', 
    '\U00016904', '\U00016905', '\U00016906', '\U00016907', '\U00016908', '\U00016909', '\U0001690a', '\U0001690b', 
    '\U0001690c', '\U0001690d', '\U0001690e', '\U0001690f', '\U00016910', '\U00016911', '\U00016912', '\U00016913', 
    '\U00016914', '\U00016915', '\U00016916', '\U00016917', '\U00016918', '\U00016919', '\U0001691a', '\U0001691b', 
    '\U0001691c', '\U0001691d', '\U0001691e', '\U0001691f', '\U00016920', '\U00016921', '\U00016922', '\U00016923', 
    '\U00016924', '\U00016925', '\U00016926', '\U00016927', '\U00016928', '\U00016929', '\U0001692a', '\U0001692b', 
    '\U0001692c', '\U0001692d', '\U0001692e', '\U0001692f', '\U00016930', '\U00016931', '\U00016932', '\U00016933', 
    '\U00016934', '\U00016935', '\U00016936', '\U00016937', '\U00016938', '\U00016939', '\U0001693a', '\U0001693b', 
    '\U0001693c', '\U0001693d', '\U0001693e', '\U0001693f', '\U00016940', '\U00016941', '\U00016942', '\U00016943', 
    '\U00016944', '\U00016945', '\U00016946', '\U00016947', '\U00016948', '\U00016949', '\U0001694a', '\U0001694b', 
    '\U0001694c', '\U0001694d', '\U0001694e', '\U0001694f', '\U00016950', '\U00016951', '\U00016952', '\U00016953', 
    '\U00016954', '\U00016955', '\U00016956', '\U00016957', '\U00016958', '\U00016959', '\U0001695a', '\U0001695b', 
    '\U0001695c', '\U0001695d', '\U0001695e', '\U0001695f', '\U00016960', '\U00016961', '\U00016962', '\U00016963', 
    '\U00016964', '\U00016965', '\U00016966', '\U00016967', '\U00016968', '\U00016969', '\U0001696a', '\U0001696b', 
    '\U0001696c', '\U0001696d', '\U0001696e', '\U0001696f', '\U00016970', '\U00016971', '\U00016972', '\U00016973', 
    '\U00016974', '\U00016975', '\U00016976', '\U00016977', '\U00016978', '\U00016979', '\U0001697a', '\U0001697b', 
    '\U0001697c', '\U0001697d', '\U0001697e', '\U0001697f', '\U00016980', '\U00016981', '\U00016982', '\U00016983', 
    '\U00016984', '\U00016985', '\U00016986', '\U00016987', '\U00016988', '\U00016989', '\U0001698a', '\U0001698b', 
    '\U0001698c', '\U0001698d', '\U0001698e', '\U0001698f', '\U00016990', '\U00016991', '\U00016992', '\U00016993', 
    '\U00016994', '\U00016995', '\U00016996', '\U00016997', '\U00016998', '\U00016999', '\U0001699a', '\U0001699b', 
    '\U0001699c', '\U0001699d', '\U0001699e', '\U0001699f', '\U000169a0', '\U000169a1', '\U000169a2', '\U000169a3', 
    '\U000169a4', '\U000169a5', '\U000169a6', '\U000169a7', '\U000169a8', '\U000169a9', '\U000169aa', '\U000169ab', 
    '\U000169ac', '\U000169ad', '\U000169ae', '\U000169af', '\U000169b0', '\U000169b1', '\U000169b2', '\U000169b3', 
    '\U000169b4', '\U000169b5', '\U000169b6', '\U000169b7', '\U000169b8', '\U000169b9', '\U000169ba', '\U000169bb', 
    '\U000169bc', '\U000169bd', '\U000169be', '\U000169bf', '\U000169c0', '\U000169c1', '\U000169c2', '\U000169c3', 
    '\U000169c4', '\U000169c5', '\U000169c6', '\U000169c7', '\U000169c8', '\U000169c9', '\U000169ca', '\U000169cb', 
    '\U000169cc', '\U000169cd', '\U000169ce', '\U000169cf', '\U000169d0', '\U000169d1', '\U000169d2', '\U000169d3', 
    '\U000169d4', '\U000169d5', '\U000169d6', '\U000169d7', '\U000169d8', '\U000169d9', '\U000169da', '\U000169db', 
    '\U000169dc', '\U000169dd', '\U000169de', '\U000169df', '\U000169e0', '\U000169e1', '\U000169e2', '\U000169e3', 
    '\U000169e4', '\U000169e5', '\U000169e6', '\U000169e7', '\U000169e8', '\U000169e9', '\U000169ea', '\U000169eb', 
    '\U000169ec', '\U000169ed', '\U000169ee', '\U000169ef', '\U000169f0', '\U000169f1', '\U000169f2', '\U000169f3', 
    '\U000169f4', '\U000169f5', '\U000169f6', '\U000169f7', '\U000169f8', '\U000169f9', '\U000169fa', '\U000169fb', 
    '\U000169fc', '\U000169fd', '\U000169fe', '\U000169ff', '\U00016a00', '\U00016a01', '\U00016a02', '\U00016a03', 
    '\U00016a04', '\U00016a05', '\U00016a06', '\U00016a07', '\U00016a08', '\U00016a09', '\U00016a0a', '\U00016a0b', 
    '\U00016a0c', '\U00016a0d', '\U00016a0e', '\U00016a0f', '\U00016a10', '\U00016a11', '\U00016a12', '\U00016a13', 
    '\U00016a14', '\U00016a15', '\U00016a16', '\U00016a17', '\U00016a18', '\U00016a19', '\U00016a1a', '\U00016a1b', 
    '\U00016a1c', '\U00016a1d', '\U00016a1e', '\U00016a1f', '\U00016a20', '\U00016a21', '\U00016a22', '\U00016a23', 
    '\U00016a24', '\U00016a25', '\U00016a26', '\U00016a27', '\U00016a28', '\U00016a29', '\U00016a2a', '\U00016a2b', 
    '\U00016a2c', '\U00016a2d', '\U00016a2e', '\U00016a2f', '\U00016a30', '\U00016a31', '\U00016a32', '\U00016a33', 
    '\U00016a34', '\U00016a35', '\U00016a36', '\U00016a37', '\U00016a38', '\U00016a40', '\U00016a41', '\U00016a42', 
    '\U00016a43', '\U00016a44', '\U00016a45', '\U00016a46', '\U00016a47', '\U00016a48', '\U00016a49', '\U00016a4a', 
    '\U00016a4b', '\U00016a4c', '\U00016a4d', '\U00016a4e', '\U00016a4f', '\U00016a50', '\U00016a51', '\U00016a52', 
    '\U00016a53', '\U00016a54', '\U00016a55', '\U00016a56', '\U00016a57', '\U00016a58', '\U00016a59', '\U00016a5a', 
    '\U00016a5b', '\U00016a5c', '\U00016a5d', '\U00016a5e', '\U00016ad0', '\U00016ad1', '\U00016ad2', '\U00016ad3', 
    '\U00016ad4', '\U00016ad5', '\U00016ad6', '\U00016ad7', '\U00016ad8', '\U00016ad9', '\U00016ada', '\U00016adb', 
    '\U00016adc', '\U00016add', '\U00016ade', '\U00016adf', '\U00016ae0', '\U00016ae1', '\U00016ae2', '\U00016ae3', 
    '\U00016ae4', '\U00016ae5', '\U00016ae6', '\U00016ae7', '\U00016ae8', '\U00016ae9', '\U00016aea', '\U00016aeb', 
    '\U00016aec', '\U00016aed', '\U00016b00', '\U00016b01', '\U00016b02', '\U00016b03', '\U00016b04', '\U00016b05', 
    '\U00016b06', '\U00016b07', '\U00016b08', '\U00016b09', '\U00016b0a', '\U00016b0b', '\U00016b0c', '\U00016b0d', 
    '\U00016b0e', '\U00016b0f', '\U00016b10', '\U00016b11', '\U00016b12', '\U00016b13', '\U00016b14', '\U00016b15', 
    '\U00016b16', '\U00016b17', '\U00016b18', '\U00016b19', '\U00016b1a', '\U00016b1b', '\U00016b1c', '\U00016b1d', 
    '\U00016b1e', '\U00016b1f', '\U00016b20', '\U00016b21', '\U00016b22', '\U00016b23', '\U00016b24', '\U00016b25', 
    '\U00016b26', '\U00016b27', '\U00016b28', '\U00016b29', '\U00016b2a', '\U00016b2b', '\U00016b2c', '\U00016b2d', 
    '\U00016b2e', '\U00016b2f', '\U00016b40', '\U00016b41', '\U00016b42', '\U00016b43', '\U00016b63', '\U00016b64', 
    '\U00016b65', '\U00016b66', '\U00016b67', '\U00016b68', '\U00016b69', '\U00016b6a', '\U00016b6b', '\U00016b6c', 
    '\U00016b6d', '\U00016b6e', '\U00016b6f', '\U00016b70', '\U00016b71', '\U00016b72', '\U00016b73', '\U00016b74', 
    '\U00016b75', '\U00016b76', '\U00016b77', '\U00016b7d', '\U00016b7e', '\U00016b7f', '\U00016b80', '\U00016b81', 
    '\U00016b82', '\U00016b83', '\U00016b84', '\U00016b85', '\U00016b86', '\U00016b87', '\U00016b88', '\U00016b89', 
    '\U00016b8a', '\U00016b8b', '\U00016b8c', '\U00016b8d', '\U00016b8e', '\U00016b8f', '\U00016e40', '\U00016e41', 
    '\U00016e42', '\U00016e43', '\U00016e44', '\U00016e45', '\U00016e46', '\U00016e47', '\U00016e48', '\U00016e49', 
    '\U00016e4a', '\U00016e4b', '\U00016e4c', '\U00016e4d', '\U00016e4e', '\U00016e4f', '\U00016e50', '\U00016e51', 
    '\U00016e52', '\U00016e53', '\U00016e54', '\U00016e55', '\U00016e56', '\U00016e57', '\U00016e58', '\U00016e59', 
    '\U00016e5a', '\U00016e5b', '\U00016e5c', '\U00016e5d', '\U00016e5e', '\U00016e5f', '\U00016e60', '\U00016e61', 
    '\U00016e62', '\U00016e63', '\U00016e64', '\U00016e65', '\U00016e66', '\U00016e67', '\U00016e68', '\U00016e69', 
    '\U00016e6a', '\U00016e6b', '\U00016e6c', '\U00016e6d', '\U00016e6e', '\U00016e6f', '\U00016e70', '\U00016e71', 
    '\U00016e72', '\U00016e73', '\U00016e74', '\U00016e75', '\U00016e76', '\U00016e77', '\U00016e78', '\U00016e79', 
    '\U00016e7a', '\U00016e7b', '\U00016e7c', '\U00016e7d', '\U00016e7e', '\U00016e7f', '\U00016f00', '\U00016f01', 
    '\U00016f02', '\U00016f03', '\U00016f04', '\U00016f05', '\U00016f06', '\U00016f07', '\U00016f08', '\U00016f09', 
    '\U00016f0a', '\U00016f0b', '\U00016f0c', '\U00016f0d', '\U00016f0e', '\U00016f0f', '\U00016f10', '\U00016f11', 
    '\U00016f12', '\U00016f13', '\U00016f14', '\U00016f15', '\U00016f16', '\U00016f17', '\U00016f18', '\U00016f19', 
    '\U00016f1a', '\U00016f1b', '\U00016f1c', '\U00016f1d', '\U00016f1e', '\U00016f1f', '\U00016f20', '\U00016f21', 
    '\U00016f22', '\U00016f23', '\U00016f24', '\U00016f25', '\U00016f26', '\U00016f27', '\U00016f28', '\U00016f29', 
    '\U00016f2a', '\U00016f2b', '\U00016f2c', '\U00016f2d', '\U00016f2e', '\U00016f2f', '\U00016f30', '\U00016f31', 
    '\U00016f32', '\U00016f33', '\U00016f34', '\U00016f35', '\U00016f36', '\U00016f37', '\U00016f38', '\U00016f39', 
    '\U00016f3a', '\U00016f3b', '\U00016f3c', '\U00016f3d', '\U00016f3e', '\U00016f3f', '\U00016f40', '\U00016f41', 
    '\U00016f42', '\U00016f43', '\U00016f44', '\U00016f50', '\U00016f93', '\U00016f94', '\U00016f95', '\U00016f96', 
    '\U00016f97', '\U00016f98', '\U00016f99', '\U00016f9a', '\U00016f9b', '\U00016f9c', '\U00016f9d', '\U00016f9e', 
    '\U00016f9f', '\U00016fe0', '\U00016fe1', '\U0001bc00', '\U0001bc01', '\U0001bc02', '\U0001bc03', '\U0001bc04', 
    '\U0001bc05', '\U0001bc06', '\U0001bc07', '\U0001bc08', '\U0001bc09', '\U0001bc0a', '\U0001bc0b', '\U0001bc0c', 
    '\U0001bc0d', '\U0001bc0e', '\U0001bc0f', '\U0001bc10', '\U0001bc11', '\U0001bc12', '\U0001bc13', '\U0001bc14', 
    '\U0001bc15', '\U0001bc16', '\U0001bc17', '\U0001bc18', '\U0001bc19', '\U0001bc1a', '\U0001bc1b', '\U0001bc1c', 
    '\U0001bc1d', '\U0001bc1e', '\U0001bc1f', '\U0001bc20', '\U0001bc21', '\U0001bc22', '\U0001bc23', '\U0001bc24', 
    '\U0001bc25', '\U0001bc26', '\U0001bc27', '\U0001bc28', '\U0001bc29', '\U0001bc2a', '\U0001bc2b', '\U0001bc2c', 
    '\U0001bc2d', '\U0001bc2e', '\U0001bc2f', '\U0001bc30', '\U0001bc31', '\U0001bc32', '\U0001bc33', '\U0001bc34', 
    '\U0001bc35', '\U0001bc36', '\U0001bc37', '\U0001bc38', '\U0001bc39', '\U0001bc3a', '\U0001bc3b', '\U0001bc3c', 
    '\U0001bc3d', '\U0001bc3e', '\U0001bc3f', '\U0001bc40', '\U0001bc41', '\U0001bc42', '\U0001bc43', '\U0001bc44', 
    '\U0001bc45', '\U0001bc46', '\U0001bc47', '\U0001bc48', '\U0001bc49', '\U0001bc4a', '\U0001bc4b', '\U0001bc4c', 
    '\U0001bc4d', '\U0001bc4e', '\U0001bc4f', '\U0001bc50', '\U0001bc51', '\U0001bc52', '\U0001bc53', '\U0001bc54', 
    '\U0001bc55', '\U0001bc56', '\U0001bc57', '\U0001bc58', '\U0001bc59', '\U0001bc5a', '\U0001bc5b', '\U0001bc5c', 
    '\U0001bc5d', '\U0001bc5e', '\U0001bc5f', '\U0001bc60', '\U0001bc61', '\U0001bc62', '\U0001bc63', '\U0001bc64', 
    '\U0001bc65', '\U0001bc66', '\U0001bc67', '\U0001bc68', '\U0001bc69', '\U0001bc6a', '\U0001bc70', '\U0001bc71', 
    '\U0001bc72', '\U0001bc73', '\U0001bc74', '\U0001bc75', '\U0001bc76', '\U0001bc77', '\U0001bc78', '\U0001bc79', 
    '\U0001bc7a', '\U0001bc7b', '\U0001bc7c', '\U0001bc80', '\U0001bc81', '\U0001bc82', '\U0001bc83', '\U0001bc84', 
    '\U0001bc85', '\U0001bc86', '\U0001bc87', '\U0001bc88', '\U0001bc90', '\U0001bc91', '\U0001bc92', '\U0001bc93', 
    '\U0001bc94', '\U0001bc95', '\U0001bc96', '\U0001bc97', '\U0001bc98', '\U0001bc99', '\U0001d400', '\U0001d401', 
    '\U0001d402', '\U0001d403', '\U0001d404', '\U0001d405', '\U0001d406', '\U0001d407', '\U0001d408', '\U0001d409', 
    '\U0001d40a', '\U0001d40b', '\U0001d40c', '\U0001d40d', '\U0001d40e', '\U0001d40f', '\U0001d410', '\U0001d411', 
    '\U0001d412', '\U0001d413', '\U0001d414', '\U0001d415', '\U0001d416', '\U0001d417', '\U0001d418', '\U0001d419', 
    '\U0001d41a', '\U0001d41b', '\U0001d41c', '\U0001d41d', '\U0001d41e', '\U0001d41f', '\U0001d420', '\U0001d421', 
    '\U0001d422', '\U0001d423', '\U0001d424', '\U0001d425', '\U0001d426', '\U0001d427', '\U0001d428', '\U0001d429', 
    '\U0001d42a', '\U0001d42b', '\U0001d42c', '\U0001d42d', '\U0001d42e', '\U0001d42f', '\U0001d430', '\U0001d431', 
    '\U0001d432', '\U0001d433', '\U0001d434', '\U0001d435', '\U0001d436', '\U0001d437', '\U0001d438', '\U0001d439', 
    '\U0001d43a', '\U0001d43b', '\U0001d43c', '\U0001d43d', '\U0001d43e', '\U0001d43f', '\U0001d440', '\U0001d441', 
    '\U0001d442', '\U0001d443', '\U0001d444', '\U0001d445', '\U0001d446', '\U0001d447', '\U0001d448', '\U0001d449', 
    '\U0001d44a', '\U0001d44b', '\U0001d44c', '\U0001d44d', '\U0001d44e', '\U0001d44f', '\U0001d450', '\U0001d451', 
    '\U0001d452', '\U0001d453', '\U0001d454', '\U0001d456', '\U0001d457', '\U0001d458', '\U0001d459', '\U0001d45a', 
    '\U0001d45b', '\U0001d45c', '\U0001d45d', '\U0001d45e', '\U0001d45f', '\U0001d460', '\U0001d461', '\U0001d462', 
    '\U0001d463', '\U0001d464', '\U0001d465', '\U0001d466', '\U0001d467', '\U0001d468', '\U0001d469', '\U0001d46a', 
    '\U0001d46b', '\U0001d46c', '\U0001d46d', '\U0001d46e', '\U0001d46f', '\U0001d470', '\U0001d471', '\U0001d472', 
    '\U0001d473', '\U0001d474', '\U0001d475', '\U0001d476', '\U0001d477', '\U0001d478', '\U0001d479', '\U0001d47a', 
    '\U0001d47b', '\U0001d47c', '\U0001d47d', '\U0001d47e', '\U0001d47f', '\U0001d480', '\U0001d481', '\U0001d482', 
    '\U0001d483', '\U0001d484', '\U0001d485', '\U0001d486', '\U0001d487', '\U0001d488', '\U0001d489', '\U0001d48a', 
    '\U0001d48b', '\U0001d48c', '\U0001d48d', '\U0001d48e', '\U0001d48f', '\U0001d490', '\U0001d491', '\U0001d492', 
    '\U0001d493', '\U0001d494', '\U0001d495', '\U0001d496', '\U0001d497', '\U0001d498', '\U0001d499', '\U0001d49a', 
    '\U0001d49b', '\U0001d49c', '\U0001d49e', '\U0001d49f', '\U0001d4a2', '\U0001d4a5', '\U0001d4a6', '\U0001d4a9', 
    '\U0001d4aa', '\U0001d4ab', '\U0001d4ac', '\U0001d4ae', '\U0001d4af', '\U0001d4b0', '\U0001d4b1', '\U0001d4b2', 
    '\U0001d4b3', '\U0001d4b4', '\U0001d4b5', '\U0001d4b6', '\U0001d4b7', '\U0001d4b8', '\U0001d4b9', '\U0001d4bb', 
    '\U0001d4bd', '\U0001d4be', '\U0001d4bf', '\U0001d4c0', '\U0001d4c1', '\U0001d4c2', '\U0001d4c3', '\U0001d4c5', 
    '\U0001d4c6', '\U0001d4c7', '\U0001d4c8', '\U0001d4c9', '\U0001d4ca', '\U0001d4cb', '\U0001d4cc', '\U0001d4cd', 
    '\U0001d4ce', '\U0001d4cf', '\U0001d4d0', '\U0001d4d1', '\U0001d4d2', '\U0001d4d3', '\U0001d4d4', '\U0001d4d5', 
    '\U0001d4d6', '\U0001d4d7', '\U0001d4d8', '\U0001d4d9', '\U0001d4da', '\U0001d4db', '\U0001d4dc', '\U0001d4dd', 
    '\U0001d4de', '\U0001d4df', '\U0001d4e0', '\U0001d4e1', '\U0001d4e2', '\U0001d4e3', '\U0001d4e4', '\U0001d4e5', 
    '\U0001d4e6', '\U0001d4e7', '\U0001d4e8', '\U0001d4e9', '\U0001d4ea', '\U0001d4eb', '\U0001d4ec', '\U0001d4ed', 
    '\U0001d4ee', '\U0001d4ef', '\U0001d4f0', '\U0001d4f1', '\U0001d4f2', '\U0001d4f3', '\U0001d4f4', '\U0001d4f5', 
    '\U0001d4f6', '\U0001d4f7', '\U0001d4f8', '\U0001d4f9', '\U0001d4fa', '\U0001d4fb', '\U0001d4fc', '\U0001d4fd', 
    '\U0001d4fe', '\U0001d4ff', '\U0001d500', '\U0001d501', '\U0001d502', '\U0001d503', '\U0001d504', '\U0001d505', 
    '\U0001d507', '\U0001d508', '\U0001d509', '\U0001d50a', '\U0001d50d', '\U0001d50e', '\U0001d50f', '\U0001d510', 
    '\U0001d511', '\U0001d512', '\U0001d513', '\U0001d514', '\U0001d516', '\U0001d517', '\U0001d518', '\U0001d519', 
    '\U0001d51a', '\U0001d51b', '\U0001d51c', '\U0001d51e', '\U0001d51f', '\U0001d520', '\U0001d521', '\U0001d522', 
    '\U0001d523', '\U0001d524', '\U0001d525', '\U0001d526', '\U0001d527', '\U0001d528', '\U0001d529', '\U0001d52a', 
    '\U0001d52b', '\U0001d52c', '\U0001d52d', '\U0001d52e', '\U0001d52f', '\U0001d530', '\U0001d531', '\U0001d532', 
    '\U0001d533', '\U0001d534', '\U0001d535', '\U0001d536', '\U0001d537', '\U0001d538', '\U0001d539', '\U0001d53b', 
    '\U0001d53c', '\U0001d53d', '\U0001d53e', '\U0001d540', '\U0001d541', '\U0001d542', '\U0001d543', '\U0001d544', 
    '\U0001d546', '\U0001d54a', '\U0001d54b', '\U0001d54c', '\U0001d54d', '\U0001d54e', '\U0001d54f', '\U0001d550', 
    '\U0001d552', '\U0001d553', '\U0001d554', '\U0001d555', '\U0001d556', '\U0001d557', '\U0001d558', '\U0001d559', 
    '\U0001d55a', '\U0001d55b', '\U0001d55c', '\U0001d55d', '\U0001d55e', '\U0001d55f', '\U0001d560', '\U0001d561', 
    '\U0001d562', '\U0001d563', '\U0001d564', '\U0001d565', '\U0001d566', '\U0001d567', '\U0001d568', '\U0001d569', 
    '\U0001d56a', '\U0001d56b', '\U0001d56c', '\U0001d56d', '\U0001d56e', '\U0001d56f', '\U0001d570', '\U0001d571', 
    '\U0001d572', '\U0001d573', '\U0001d574', '\U0001d575', '\U0001d576', '\U0001d577', '\U0001d578', '\U0001d579', 
    '\U0001d57a', '\U0001d57b', '\U0001d57c', '\U0001d57d', '\U0001d57e', '\U0001d57f', '\U0001d580', '\U0001d581', 
    '\U0001d582', '\U0001d583', '\U0001d584', '\U0001d585', '\U0001d586', '\U0001d587', '\U0001d588', '\U0001d589', 
    '\U0001d58a', '\U0001d58b', '\U0001d58c', '\U0001d58d', '\U0001d58e', '\U0001d58f', '\U0001d590', '\U0001d591', 
    '\U0001d592', '\U0001d593', '\U0001d594', '\U0001d595', '\U0001d596', '\U0001d597', '\U0001d598', '\U0001d599', 
    '\U0001d59a', '\U0001d59b', '\U0001d59c', '\U0001d59d', '\U0001d59e', '\U0001d59f', '\U0001d5a0', '\U0001d5a1', 
    '\U0001d5a2', '\U0001d5a3', '\U0001d5a4', '\U0001d5a5', '\U0001d5a6', '\U0001d5a7', '\U0001d5a8', '\U0001d5a9', 
    '\U0001d5aa', '\U0001d5ab', '\U0001d5ac', '\U0001d5ad', '\U0001d5ae', '\U0001d5af', '\U0001d5b0', '\U0001d5b1', 
    '\U0001d5b2', '\U0001d5b3', '\U0001d5b4', '\U0001d5b5', '\U0001d5b6', '\U0001d5b7', '\U0001d5b8', '\U0001d5b9', 
    '\U0001d5ba', '\U0001d5bb', '\U0001d5bc', '\U0001d5bd', '\U0001d5be', '\U0001d5bf', '\U0001d5c0', '\U0001d5c1', 
    '\U0001d5c2', '\U0001d5c3', '\U0001d5c4', '\U0001d5c5', '\U0001d5c6', '\U0001d5c7', '\U0001d5c8', '\U0001d5c9', 
    '\U0001d5ca', '\U0001d5cb', '\U0001d5cc', '\U0001d5cd', '\U0001d5ce', '\U0001d5cf', '\U0001d5d0', '\U0001d5d1', 
    '\U0001d5d2', '\U0001d5d3', '\U0001d5d4', '\U0001d5d5', '\U0001d5d6', '\U0001d5d7', '\U0001d5d8', '\U0001d5d9', 
    '\U0001d5da', '\U0001d5db', '\U0001d5dc', '\U0001d5dd', '\U0001d5de', '\U0001d5df', '\U0001d5e0', '\U0001d5e1', 
    '\U0001d5e2', '\U0001d5e3', '\U0001d5e4', '\U0001d5e5', '\U0001d5e6', '\U0001d5e7', '\U0001d5e8', '\U0001d5e9', 
    '\U0001d5ea', '\U0001d5eb', '\U0001d5ec', '\U0001d5ed', '\U0001d5ee', '\U0001d5ef', '\U0001d5f0', '\U0001d5f1', 
    '\U0001d5f2', '\U0001d5f3', '\U0001d5f4', '\U0001d5f5', '\U0001d5f6', '\U0001d5f7', '\U0001d5f8', '\U0001d5f9', 
    '\U0001d5fa', '\U0001d5fb', '\U0001d5fc', '\U0001d5fd', '\U0001d5fe', '\U0001d5ff', '\U0001d600', '\U0001d601', 
    '\U0001d602', '\U0001d603', '\U0001d604', '\U0001d605', '\U0001d606', '\U0001d607', '\U0001d608', '\U0001d609', 
    '\U0001d60a', '\U0001d60b', '\U0001d60c', '\U0001d60d', '\U0001d60e', '\U0001d60f', '\U0001d610', '\U0001d611', 
    '\U0001d612', '\U0001d613', '\U0001d614', '\U0001d615', '\U0001d616', '\U0001d617', '\U0001d618', '\U0001d619', 
    '\U0001d61a', '\U0001d61b', '\U0001d61c', '\U0001d61d', '\U0001d61e', '\U0001d61f', '\U0001d620', '\U0001d621', 
    '\U0001d622', '\U0001d623', '\U0001d624', '\U0001d625', '\U0001d626', '\U0001d627', '\U0001d628', '\U0001d629', 
    '\U0001d62a', '\U0001d62b', '\U0001d62c', '\U0001d62d', '\U0001d62e', '\U0001d62f', '\U0001d630', '\U0001d631', 
    '\U0001d632', '\U0001d633', '\U0001d634', '\U0001d635', '\U0001d636', '\U0001d637', '\U0001d638', '\U0001d639', 
    '\U0001d63a', '\U0001d63b', '\U0001d63c', '\U0001d63d', '\U0001d63e', '\U0001d63f', '\U0001d640', '\U0001d641', 
    '\U0001d642', '\U0001d643', '\U0001d644', '\U0001d645', '\U0001d646', '\U0001d647', '\U0001d648', '\U0001d649', 
    '\U0001d64a', '\U0001d64b', '\U0001d64c', '\U0001d64d', '\U0001d64e', '\U0001d64f', '\U0001d650', '\U0001d651', 
    '\U0001d652', '\U0001d653', '\U0001d654', '\U0001d655', '\U0001d656', '\U0001d657', '\U0001d658', '\U0001d659', 
    '\U0001d65a', '\U0001d65b', '\U0001d65c', '\U0001d65d', '\U0001d65e', '\U0001d65f', '\U0001d660', '\U0001d661', 
    '\U0001d662', '\U0001d663', '\U0001d664', '\U0001d665', '\U0001d666', '\U0001d667', '\U0001d668', '\U0001d669', 
    '\U0001d66a', '\U0001d66b', '\U0001d66c', '\U0001d66d', '\U0001d66e', '\U0001d66f', '\U0001d670', '\U0001d671', 
    '\U0001d672', '\U0001d673', '\U0001d674', '\U0001d675', '\U0001d676', '\U0001d677', '\U0001d678', '\U0001d679', 
    '\U0001d67a', '\U0001d67b', '\U0001d67c', '\U0001d67d', '\U0001d67e', '\U0001d67f', '\U0001d680', '\U0001d681', 
    '\U0001d682', '\U0001d683', '\U0001d684', '\U0001d685', '\U0001d686', '\U0001d687', '\U0001d688', '\U0001d689', 
    '\U0001d68a', '\U0001d68b', '\U0001d68c', '\U0001d68d', '\U0001d68e', '\U0001d68f', '\U0001d690', '\U0001d691', 
    '\U0001d692', '\U0001d693', '\U0001d694', '\U0001d695', '\U0001d696', '\U0001d697', '\U0001d698', '\U0001d699', 
    '\U0001d69a', '\U0001d69b', '\U0001d69c', '\U0001d69d', '\U0001d69e', '\U0001d69f', '\U0001d6a0', '\U0001d6a1', 
    '\U0001d6a2', '\U0001d6a3', '\U0001d6a4', '\U0001d6a5', '\U0001d6a8', '\U0001d6a9', '\U0001d6aa', '\U0001d6ab', 
    '\U0001d6ac', '\U0001d6ad', '\U0001d6ae', '\U0001d6af', '\U0001d6b0', '\U0001d6b1', '\U0001d6b2', '\U0001d6b3', 
    '\U0001d6b4', '\U0001d6b5', '\U0001d6b6', '\U0001d6b7', '\U0001d6b8', '\U0001d6b9', '\U0001d6ba', '\U0001d6bb', 
    '\U0001d6bc', '\U0001d6bd', '\U0001d6be', '\U0001d6bf', '\U0001d6c0', '\U0001d6c2', '\U0001d6c3', '\U0001d6c4', 
    '\U0001d6c5', '\U0001d6c6', '\U0001d6c7', '\U0001d6c8', '\U0001d6c9', '\U0001d6ca', '\U0001d6cb', '\U0001d6cc', 
    '\U0001d6cd', '\U0001d6ce', '\U0001d6cf', '\U0001d6d0', '\U0001d6d1', '\U0001d6d2', '\U0001d6d3', '\U0001d6d4', 
    '\U0001d6d5', '\U0001d6d6', '\U0001d6d7', '\U0001d6d8', '\U0001d6d9', '\U0001d6da', '\U0001d6dc', '\U0001d6dd', 
    '\U0001d6de', '\U0001d6df', '\U0001d6e0', '\U0001d6e1', '\U0001d6e2', '\U0001d6e3', '\U0001d6e4', '\U0001d6e5', 
    '\U0001d6e6', '\U0001d6e7', '\U0001d6e8', '\U0001d6e9', '\U0001d6ea', '\U0001d6eb', '\U0001d6ec', '\U0001d6ed', 
    '\U0001d6ee', '\U0001d6ef', '\U0001d6f0', '\U0001d6f1', '\U0001d6f2', '\U0001d6f3', '\U0001d6f4', '\U0001d6f5', 
    '\U0001d6f6', '\U0001d6f7', '\U0001d6f8', '\U0001d6f9', '\U0001d6fa', '\U0001d6fc', '\U0001d6fd', '\U0001d6fe', 
    '\U0001d6ff', '\U0001d700', '\U0001d701', '\U0001d702', '\U0001d703', '\U0001d704', '\U0001d705', '\U0001d706', 
    '\U0001d707', '\U0001d708', '\U0001d709', '\U0001d70a', '\U0001d70b', '\U0001d70c', '\U0001d70d', '\U0001d70e', 
    '\U0001d70f', '\U0001d710', '\U0001d711', '\U0001d712', '\U0001d713', '\U0001d714', '\U0001d716', '\U0001d717', 
    '\U0001d718', '\U0001d719', '\U0001d71a', '\U0001d71b', '\U0001d71c', '\U0001d71d', '\U0001d71e', '\U0001d71f', 
    '\U0001d720', '\U0001d721', '\U0001d722', '\U0001d723', '\U0001d724', '\U0001d725', '\U0001d726', '\U0001d727', 
    '\U0001d728', '\U0001d729', '\U0001d72a', '\U0001d72b', '\U0001d72c', '\U0001d72d', '\U0001d72e', '\U0001d72f', 
    '\U0001d730', '\U0001d731', '\U0001d732', '\U0001d733', '\U0001d734', '\U0001d736', '\U0001d737', '\U0001d738', 
    '\U0001d739', '\U0001d73a', '\U0001d73b', '\U0001d73c', '\U0001d73d', '\U0001d73e', '\U0001d73f', '\U0001d740', 
    '\U0001d741', '\U0001d742', '\U0001d743', '\U0001d744', '\U0001d745', '\U0001d746', '\U0001d747', '\U0001d748', 
    '\U0001d749', '\U0001d74a', '\U0001d74b', '\U0001d74c', '\U0001d74d', '\U0001d74e', '\U0001d750', '\U0001d751', 
    '\U0001d752', '\U0001d753', '\U0001d754', '\U0001d755', '\U0001d756', '\U0001d757', '\U0001d758', '\U0001d759', 
    '\U0001d75a', '\U0001d75b', '\U0001d75c', '\U0001d75d', '\U0001d75e', '\U0001d75f', '\U0001d760', '\U0001d761', 
    '\U0001d762', '\U0001d763', '\U0001d764', '\U0001d765', '\U0001d766', '\U0001d767', '\U0001d768', '\U0001d769', 
    '\U0001d76a', '\U0001d76b', '\U0001d76c', '\U0001d76d', '\U0001d76e', '\U0001d770', '\U0001d771', '\U0001d772', 
    '\U0001d773', '\U0001d774', '\U0001d775', '\U0001d776', '\U0001d777', '\U0001d778', '\U0001d779', '\U0001d77a', 
    '\U0001d77b', '\U0001d77c', '\U0001d77d', '\U0001d77e', '\U0001d77f', '\U0001d780', '\U0001d781', '\U0001d782', 
    '\U0001d783', '\U0001d784', '\U0001d785', '\U0001d786', '\U0001d787', '\U0001d788', '\U0001d78a', '\U0001d78b', 
    '\U0001d78c', '\U0001d78d', '\U0001d78e', '\U0001d78f', '\U0001d790', '\U0001d791', '\U0001d792', '\U0001d793', 
    '\U0001d794', '\U0001d795', '\U0001d796', '\U0001d797', '\U0001d798', '\U0001d799', '\U0001d79a', '\U0001d79b', 
    '\U0001d79c', '\U0001d79d', '\U0001d79e', '\U0001d79f', '\U0001d7a0', '\U0001d7a1', '\U0001d7a2', '\U0001d7a3', 
    '\U0001d7a4', '\U0001d7a5', '\U0001d7a6', '\U0001d7a7', '\U0001d7a8', '\U0001d7aa', '\U0001d7ab', '\U0001d7ac', 
    '\U0001d7ad', '\U0001d7ae', '\U0001d7af', '\U0001d7b0', '\U0001d7b1', '\U0001d7b2', '\U0001d7b3', '\U0001d7b4', 
    '\U0001d7b5', '\U0001d7b6', '\U0001d7b7', '\U0001d7b8', '\U0001d7b9', '\U0001d7ba', '\U0001d7bb', '\U0001d7bc', 
    '\U0001d7bd', '\U0001d7be', '\U0001d7bf', '\U0001d7c0', '\U0001d7c1', '\U0001d7c2', '\U0001d7c4', '\U0001d7c5', 
    '\U0001d7c6', '\U0001d7c7', '\U0001d7c8', '\U0001d7c9', '\U0001d7ca', '\U0001d7cb', '\U0001e800', '\U0001e801', 
    '\U0001e802', '\U0001e803', '\U0001e804', '\U0001e805', '\U0001e806', '\U0001e807', '\U0001e808', '\U0001e809', 
    '\U0001e80a', '\U0001e80b', '\U0001e80c', '\U0001e80d', '\U0001e80e', '\U0001e80f', '\U0001e810', '\U0001e811', 
    '\U0001e812', '\U0001e813', '\U0001e814', '\U0001e815', '\U0001e816', '\U0001e817', '\U0001e818', '\U0001e819', 
    '\U0001e81a', '\U0001e81b', '\U0001e81c', '\U0001e81d', '\U0001e81e', '\U0001e81f', '\U0001e820', '\U0001e821', 
    '\U0001e822', '\U0001e823', '\U0001e824', '\U0001e825', '\U0001e826', '\U0001e827', '\U0001e828', '\U0001e829', 
    '\U0001e82a', '\U0001e82b', '\U0001e82c', '\U0001e82d', '\U0001e82e', '\U0001e82f', '\U0001e830', '\U0001e831', 
    '\U0001e832', '\U0001e833', '\U0001e834', '\U0001e835', '\U0001e836', '\U0001e837', '\U0001e838', '\U0001e839', 
    '\U0001e83a', '\U0001e83b', '\U0001e83c', '\U0001e83d', '\U0001e83e', '\U0001e83f', '\U0001e840', '\U0001e841', 
    '\U0001e842', '\U0001e843', '\U0001e844', '\U0001e845', '\U0001e846', '\U0001e847', '\U0001e848', '\U0001e849', 
    '\U0001e84a', '\U0001e84b', '\U0001e84c', '\U0001e84d', '\U0001e84e', '\U0001e84f', '\U0001e850', '\U0001e851', 
    '\U0001e852', '\U0001e853', '\U0001e854', '\U0001e855', '\U0001e856', '\U0001e857', '\U0001e858', '\U0001e859', 
    '\U0001e85a', '\U0001e85b', '\U0001e85c', '\U0001e85d', '\U0001e85e', '\U0001e85f', '\U0001e860', '\U0001e861', 
    '\U0001e862', '\U0001e863', '\U0001e864', '\U0001e865', '\U0001e866', '\U0001e867', '\U0001e868', '\U0001e869', 
    '\U0001e86a', '\U0001e86b', '\U0001e86c', '\U0001e86d', '\U0001e86e', '\U0001e86f', '\U0001e870', '\U0001e871', 
    '\U0001e872', '\U0001e873', '\U0001e874', '\U0001e875', '\U0001e876', '\U0001e877', '\U0001e878', '\U0001e879', 
    '\U0001e87a', '\U0001e87b', '\U0001e87c', '\U0001e87d', '\U0001e87e', '\U0001e87f', '\U0001e880', '\U0001e881', 
    '\U0001e882', '\U0001e883', '\U0001e884', '\U0001e885', '\U0001e886', '\U0001e887', '\U0001e888', '\U0001e889', 
    '\U0001e88a', '\U0001e88b', '\U0001e88c', '\U0001e88d', '\U0001e88e', '\U0001e88f', '\U0001e890', '\U0001e891', 
    '\U0001e892', '\U0001e893', '\U0001e894', '\U0001e895', '\U0001e896', '\U0001e897', '\U0001e898', '\U0001e899', 
    '\U0001e89a', '\U0001e89b', '\U0001e89c', '\U0001e89d', '\U0001e89e', '\U0001e89f', '\U0001e8a0', '\U0001e8a1', 
    '\U0001e8a2', '\U0001e8a3', '\U0001e8a4', '\U0001e8a5', '\U0001e8a6', '\U0001e8a7', '\U0001e8a8', '\U0001e8a9', 
    '\U0001e8aa', '\U0001e8ab', '\U0001e8ac', '\U0001e8ad', '\U0001e8ae', '\U0001e8af', '\U0001e8b0', '\U0001e8b1', 
    '\U0001e8b2', '\U0001e8b3', '\U0001e8b4', '\U0001e8b5', '\U0001e8b6', '\U0001e8b7', '\U0001e8b8', '\U0001e8b9', 
    '\U0001e8ba', '\U0001e8bb', '\U0001e8bc', '\U0001e8bd', '\U0001e8be', '\U0001e8bf', '\U0001e8c0', '\U0001e8c1', 
    '\U0001e8c2', '\U0001e8c3', '\U0001e8c4', '\U0001e900', '\U0001e901', '\U0001e902', '\U0001e903', '\U0001e904', 
    '\U0001e905', '\U0001e906', '\U0001e907', '\U0001e908', '\U0001e909', '\U0001e90a', '\U0001e90b', '\U0001e90c', 
    '\U0001e90d', '\U0001e90e', '\U0001e90f', '\U0001e910', '\U0001e911', '\U0001e912', '\U0001e913', '\U0001e914', 
    '\U0001e915', '\U0001e916', '\U0001e917', '\U0001e918', '\U0001e919', '\U0001e91a', '\U0001e91b', '\U0001e91c', 
    '\U0001e91d', '\U0001e91e', '\U0001e91f', '\U0001e920', '\U0001e921', '\U0001e922', '\U0001e923', '\U0001e924', 
    '\U0001e925', '\U0001e926', '\U0001e927', '\U0001e928', '\U0001e929', '\U0001e92a', '\U0001e92b', '\U0001e92c', 
    '\U0001e92d', '\U0001e92e', '\U0001e92f', '\U0001e930', '\U0001e931', '\U0001e932', '\U0001e933', '\U0001e934', 
    '\U0001e935', '\U0001e936', '\U0001e937', '\U0001e938', '\U0001e939', '\U0001e93a', '\U0001e93b', '\U0001e93c', 
    '\U0001e93d', '\U0001e93e', '\U0001e93f', '\U0001e940', '\U0001e941', '\U0001e942', '\U0001e943', '\U0001ee00', 
    '\U0001ee01', '\U0001ee02', '\U0001ee03', '\U0001ee05', '\U0001ee06', '\U0001ee07', '\U0001ee08', '\U0001ee09', 
    '\U0001ee0a', '\U0001ee0b', '\U0001ee0c', '\U0001ee0d', '\U0001ee0e', '\U0001ee0f', '\U0001ee10', '\U0001ee11', 
    '\U0001ee12', '\U0001ee13', '\U0001ee14', '\U0001ee15', '\U0001ee16', '\U0001ee17', '\U0001ee18', '\U0001ee19', 
    '\U0001ee1a', '\U0001ee1b', '\U0001ee1c', '\U0001ee1d', '\U0001ee1e', '\U0001ee1f', '\U0001ee21', '\U0001ee22', 
    '\U0001ee24', '\U0001ee27', '\U0001ee29', '\U0001ee2a', '\U0001ee2b', '\U0001ee2c', '\U0001ee2d', '\U0001ee2e', 
    '\U0001ee2f', '\U0001ee30', '\U0001ee31', '\U0001ee32', '\U0001ee34', '\U0001ee35', '\U0001ee36', '\U0001ee37', 
    '\U0001ee39', '\U0001ee3b', '\U0001ee42', '\U0001ee47', '\U0001ee49', '\U0001ee4b', '\U0001ee4d', '\U0001ee4e', 
    '\U0001ee4f', '\U0001ee51', '\U0001ee52', '\U0001ee54', '\U0001ee57', '\U0001ee59', '\U0001ee5b', '\U0001ee5d', 
    '\U0001ee5f', '\U0001ee61', '\U0001ee62', '\U0001ee64', '\U0001ee67', '\U0001ee68', '\U0001ee69', '\U0001ee6a', 
    '\U0001ee6c', '\U0001ee6d', '\U0001ee6e', '\U0001ee6f', '\U0001ee70', '\U0001ee71', '\U0001ee72', '\U0001ee74', 
    '\U0001ee75', '\U0001ee76', '\U0001ee77', '\U0001ee79', '\U0001ee7a', '\U0001ee7b', '\U0001ee7c', '\U0001ee7e', 
    '\U0001ee80', '\U0001ee81', '\U0001ee82', '\U0001ee83', '\U0001ee84', '\U0001ee85', '\U0001ee86', '\U0001ee87', 
    '\U0001ee88', '\U0001ee89', '\U0001ee8b', '\U0001ee8c', '\U0001ee8d', '\U0001ee8e', '\U0001ee8f', '\U0001ee90', 
    '\U0001ee91', '\U0001ee92', '\U0001ee93', '\U0001ee94', '\U0001ee95', '\U0001ee96', '\U0001ee97', '\U0001ee98', 
    '\U0001ee99', '\U0001ee9a', '\U0001ee9b', '\U0001eea1', '\U0001eea2', '\U0001eea3', '\U0001eea5', '\U0001eea6', 
    '\U0001eea7', '\U0001eea8', '\U0001eea9', '\U0001eeab', '\U0001eeac', '\U0001eead', '\U0001eeae', '\U0001eeaf', 
    '\U0001eeb0', '\U0001eeb1', '\U0001eeb2', '\U0001eeb3', '\U0001eeb4', '\U0001eeb5', '\U0001eeb6', '\U0001eeb7', 
    '\U0001eeb8', '\U0001eeb9', '\U0001eeba', '\U0001eebb', '\U0001f130', '\U0001f131', '\U0001f132', '\U0001f133', 
    '\U0001f134', '\U0001f135', '\U0001f136', '\U0001f137', '\U0001f138', '\U0001f139', '\U0001f13a', '\U0001f13b', 
    '\U0001f13c', '\U0001f13d', '\U0001f13e', '\U0001f13f', '\U0001f140', '\U0001f141', '\U0001f142', '\U0001f143', 
    '\U0001f144', '\U0001f145', '\U0001f146', '\U0001f147', '\U0001f148', '\U0001f149', '\U0001f150', '\U0001f151', 
    '\U0001f152', '\U0001f153', '\U0001f154', '\U0001f155', '\U0001f156', '\U0001f157', '\U0001f158', '\U0001f159', 
    '\U0001f15a', '\U0001f15b', '\U0001f15c', '\U0001f15d', '\U0001f15e', '\U0001f15f', '\U0001f160', '\U0001f161', 
    '\U0001f162', '\U0001f163', '\U0001f164', '\U0001f165', '\U0001f166', '\U0001f167', '\U0001f168', '\U0001f169', 
    '\U0001f170', '\U0001f171', '\U0001f172', '\U0001f173', '\U0001f174', '\U0001f175', '\U0001f176', '\U0001f177', 
    '\U0001f178', '\U0001f179', '\U0001f17a', '\U0001f17b', '\U0001f17c', '\U0001f17d', '\U0001f17e', '\U0001f17f', 
    '\U0001f180', '\U0001f181', '\U0001f182', '\U0001f183', '\U0001f184', '\U0001f185', '\U0001f186', '\U0001f187', 
    '\U0001f188', '\U0001f189')
    rangeFromUAX29Class[int(ALetterClass)] = ALetter

    // Range for UAX#29 class WSegSpace
    WSegSpace = rangetable.New(' ', '\u1680', '\u2000', '\u2001', '\u2002', '\u2003', 
    '\u2004', '\u2005', '\u2006', '\u2008', '\u2009', '\u200a', '\u205f', '\u3000')
    rangeFromUAX29Class[int(WSegSpaceClass)] = WSegSpace

    // Range for UAX#29 class Single_Quote
    Single_Quote = rangetable.New('\'')
    rangeFromUAX29Class[int(Single_QuoteClass)] = Single_Quote

    // Range for UAX#29 class Newline
    Newline = rangetable.New('\v', '\f', '\u0085', '\u2028', '\u2029')
    rangeFromUAX29Class[int(NewlineClass)] = Newline

    // Range for UAX#29 class Katakana
    Katakana = rangetable.New('\u3031', '\u3032', '\u3033', '\u3034', '\u3035', '\u309b', 
    '\u309c', '\u30a0', '\u30a1', '\u30a2', '\u30a3', '\u30a4', '\u30a5', '\u30a6', 
    '\u30a7', '\u30a8', '\u30a9', '\u30aa', '\u30ab', '\u30ac', '\u30ad', '\u30ae', 
    '\u30af', '\u30b0', '\u30b1', '\u30b2', '\u30b3', '\u30b4', '\u30b5', '\u30b6', 
    '\u30b7', '\u30b8', '\u30b9', '\u30ba', '\u30bb', '\u30bc', '\u30bd', '\u30be', 
    '\u30bf', '\u30c0', '\u30c1', '\u30c2', '\u30c3', '\u30c4', '\u30c5', '\u30c6', 
    '\u30c7', '\u30c8', '\u30c9', '\u30ca', '\u30cb', '\u30cc', '\u30cd', '\u30ce', 
    '\u30cf', '\u30d0', '\u30d1', '\u30d2', '\u30d3', '\u30d4', '\u30d5', '\u30d6', 
    '\u30d7', '\u30d8', '\u30d9', '\u30da', '\u30db', '\u30dc', '\u30dd', '\u30de', 
    '\u30df', '\u30e0', '\u30e1', '\u30e2', '\u30e3', '\u30e4', '\u30e5', '\u30e6', 
    '\u30e7', '\u30e8', '\u30e9', '\u30ea', '\u30eb', '\u30ec', '\u30ed', '\u30ee', 
    '\u30ef', '\u30f0', '\u30f1', '\u30f2', '\u30f3', '\u30f4', '\u30f5', '\u30f6', 
    '\u30f7', '\u30f8', '\u30f9', '\u30fa', '\u30fc', '\u30fd', '\u30fe', '\u30ff', 
    '\u31f0', '\u31f1', '\u31f2', '\u31f3', '\u31f4', '\u31f5', '\u31f6', '\u31f7', 
    '\u31f8', '\u31f9', '\u31fa', '\u31fb', '\u31fc', '\u31fd', '\u31fe', '\u31ff', 
    '\u32d0', '\u32d1', '\u32d2', '\u32d3', '\u32d4', '\u32d5', '\u32d6', '\u32d7', 
    '\u32d8', '\u32d9', '\u32da', '\u32db', '\u32dc', '\u32dd', '\u32de', '\u32df', 
    '\u32e0', '\u32e1', '\u32e2', '\u32e3', '\u32e4', '\u32e5', '\u32e6', '\u32e7', 
    '\u32e8', '\u32e9', '\u32ea', '\u32eb', '\u32ec', '\u32ed', '\u32ee', '\u32ef', 
    '\u32f0', '\u32f1', '\u32f2', '\u32f3', '\u32f4', '\u32f5', '\u32f6', '\u32f7', 
    '\u32f8', '\u32f9', '\u32fa', '\u32fb', '\u32fc', '\u32fd', '\u32fe', '\u3300', 
    '\u3301', '\u3302', '\u3303', '\u3304', '\u3305', '\u3306', '\u3307', '\u3308', 
    '\u3309', '\u330a', '\u330b', '\u330c', '\u330d', '\u330e', '\u330f', '\u3310', 
    '\u3311', '\u3312', '\u3313', '\u3314', '\u3315', '\u3316', '\u3317', '\u3318', 
    '\u3319', '\u331a', '\u331b', '\u331c', '\u331d', '\u331e', '\u331f', '\u3320', 
    '\u3321', '\u3322', '\u3323', '\u3324', '\u3325', '\u3326', '\u3327', '\u3328', 
    '\u3329', '\u332a', '\u332b', '\u332c', '\u332d', '\u332e', '\u332f', '\u3330', 
    '\u3331', '\u3332', '\u3333', '\u3334', '\u3335', '\u3336', '\u3337', '\u3338', 
    '\u3339', '\u333a', '\u333b', '\u333c', '\u333d', '\u333e', '\u333f', '\u3340', 
    '\u3341', '\u3342', '\u3343', '\u3344', '\u3345', '\u3346', '\u3347', '\u3348', 
    '\u3349', '\u334a', '\u334b', '\u334c', '\u334d', '\u334e', '\u334f', '\u3350', 
    '\u3351', '\u3352', '\u3353', '\u3354', '\u3355', '\u3356', '\u3357', '\uff66', 
    '\uff67', '\uff68', '\uff69', '\uff6a', '\uff6b', '\uff6c', '\uff6d', '\uff6e', 
    '\uff6f', '\uff70', '\uff71', '\uff72', '\uff73', '\uff74', '\uff75', '\uff76', 
    '\uff77', '\uff78', '\uff79', '\uff7a', '\uff7b', '\uff7c', '\uff7d', '\uff7e', 
    '\uff7f', '\uff80', '\uff81', '\uff82', '\uff83', '\uff84', '\uff85', '\uff86', 
    '\uff87', '\uff88', '\uff89', '\uff8a', '\uff8b', '\uff8c', '\uff8d', '\uff8e', 
    '\uff8f', '\uff90', '\uff91', '\uff92', '\uff93', '\uff94', '\uff95', '\uff96', 
    '\uff97', '\uff98', '\uff99', '\uff9a', '\uff9b', '\uff9c', '\uff9d', '\U0001b000')
    rangeFromUAX29Class[int(KatakanaClass)] = Katakana

    // Range for UAX#29 class MidLetter
    MidLetter = rangetable.New(':', '\u00b7', '\u0387', '\u05f4', '\u2027', '\ufe13', 
    '\ufe55', '\uff1a')
    rangeFromUAX29Class[int(MidLetterClass)] = MidLetter

    // Range for UAX#29 class Format
    Format = rangetable.New('\u00ad', '\u0600', '\u0601', '\u0602', '\u0603', '\u0604', 
    '\u0605', '\u061c', '\u06dd', '\u070f', '\u08e2', '\u180e', '\u200e', '\u200f', 
    '\u202a', '\u202b', '\u202c', '\u202d', '\u202e', '\u2060', '\u2061', '\u2062', 
    '\u2063', '\u2064', '\u2066', '\u2067', '\u2068', '\u2069', '\u206a', '\u206b', 
    '\u206c', '\u206d', '\u206e', '\u206f', '\ufeff', '\ufff9', '\ufffa', '\ufffb', 
    '\U000110bd', '\U000110cd', '\U0001bca0', '\U0001bca1', '\U0001bca2', '\U0001bca3', '\U0001d173', '\U0001d174', 
    '\U0001d175', '\U0001d176', '\U0001d177', '\U0001d178', '\U0001d179', '\U0001d17a', '\U000e0001')
    rangeFromUAX29Class[int(FormatClass)] = Format

    // Range for UAX#29 class MidNumLet
    MidNumLet = rangetable.New('.', '\u2018', '\u2019', '\u2024', '\ufe52', '\uff07', 
    '\uff0e')
    rangeFromUAX29Class[int(MidNumLetClass)] = MidNumLet
}
