package grapheme

// This file has been generated -- you probably should NOT EDIT IT !
// 
// BSD License, Copyright (c) 2018, Norbert Pillmayer (norbert@pillmayer.com)

import (
    "strconv"
    "unicode"

    "golang.org/x/text/unicode/rangetable"
)

// Type for UAX#29 grapheme code-point classes.
// Must be convertable to int.
type GraphemeClass int

// Will be initialized in SetupGraphemeClasses()
var rangeFromGraphemeClass []*unicode.RangeTable

// These are all the grapheme breaking classes.
const ( 
    CRClass GraphemeClass = 0
    LFClass GraphemeClass = 1
    PrependClass GraphemeClass = 2
    ControlClass GraphemeClass = 3
    ExtendClass GraphemeClass = 4
    Regional_IndicatorClass GraphemeClass = 5
    SpacingMarkClass GraphemeClass = 6
    LClass GraphemeClass = 7
    VClass GraphemeClass = 8
    TClass GraphemeClass = 9
    LVClass GraphemeClass = 10
    LVTClass GraphemeClass = 11
    ZWJClass GraphemeClass = 12

	Any GraphemeClass = 999
    sot GraphemeClass = 1000 // pseudo class "start of text"
    eot GraphemeClass = 1001 // pseudo class "end of text"
)

// Range tables for grapheme code-point classes.
// Will be initialized with SetupGraphemeClasses().
// Clients can check with unicode.Is(..., rune)
var CR, LF, Prepend, Control, Extend, Regional_Indicator, SpacingMark, L, V, T, 
    LV, LVT, ZWJ, unused *unicode.RangeTable

const _GraphemeClass_name = "CRClassLFClassPrependClassControlClassExtendClassRegional_IndicatorClassSpacingMarkClassLClassVClassTClassLVClassLVTClassZWJClass"

var _GraphemeClass_index = [...]uint16{0, 7, 14, 26, 38, 49, 72, 88, 94, 100,
    106, 113, 121, 129 }

// Stringer for type GraphemeClass
func (c GraphemeClass) String() string {
    if c == sot {
        return "sot"
    } else if c == eot {
        return "eot"
    } else if c == Any {
    	return "Any"
    } else if c < 0 || c >= GraphemeClass(len(_GraphemeClass_index)-1) {
        return "GraphemeClass(" + strconv.FormatInt(int64(c), 10) + ")"
    }
    return _GraphemeClass_name[_GraphemeClass_index[c]:_GraphemeClass_index[c+1]]
}

func setupGraphemeClasses() {
    rangeFromGraphemeClass = make([]*unicode.RangeTable, int(ZWJClass)+1)

    // Range for Grapheme class CR
    CR = rangetable.New('\r')
    rangeFromGraphemeClass[int(CRClass)] = CR

    // Range for Grapheme class LF
    LF = rangetable.New('\n')
    rangeFromGraphemeClass[int(LFClass)] = LF

    // Range for Grapheme class Extend
    Extend = rangetable.New('\u0300', '\u0301', '\u0302', '\u0303', '\u0304', '\u0305', 
    '\u0306', '\u0307', '\u0308', '\u0309', '\u030a', '\u030b', '\u030c', '\u030d', 
    '\u030e', '\u030f', '\u0310', '\u0311', '\u0312', '\u0313', '\u0314', '\u0315', 
    '\u0316', '\u0317', '\u0318', '\u0319', '\u031a', '\u031b', '\u031c', '\u031d', 
    '\u031e', '\u031f', '\u0320', '\u0321', '\u0322', '\u0323', '\u0324', '\u0325', 
    '\u0326', '\u0327', '\u0328', '\u0329', '\u032a', '\u032b', '\u032c', '\u032d', 
    '\u032e', '\u032f', '\u0330', '\u0331', '\u0332', '\u0333', '\u0334', '\u0335', 
    '\u0336', '\u0337', '\u0338', '\u0339', '\u033a', '\u033b', '\u033c', '\u033d', 
    '\u033e', '\u033f', '\u0340', '\u0341', '\u0342', '\u0343', '\u0344', '\u0345', 
    '\u0346', '\u0347', '\u0348', '\u0349', '\u034a', '\u034b', '\u034c', '\u034d', 
    '\u034e', '\u034f', '\u0350', '\u0351', '\u0352', '\u0353', '\u0354', '\u0355', 
    '\u0356', '\u0357', '\u0358', '\u0359', '\u035a', '\u035b', '\u035c', '\u035d', 
    '\u035e', '\u035f', '\u0360', '\u0361', '\u0362', '\u0363', '\u0364', '\u0365', 
    '\u0366', '\u0367', '\u0368', '\u0369', '\u036a', '\u036b', '\u036c', '\u036d', 
    '\u036e', '\u036f', '\u0483', '\u0484', '\u0485', '\u0486', '\u0487', '\u0488', 
    '\u0489', '\u0591', '\u0592', '\u0593', '\u0594', '\u0595', '\u0596', '\u0597', 
    '\u0598', '\u0599', '\u059a', '\u059b', '\u059c', '\u059d', '\u059e', '\u059f', 
    '\u05a0', '\u05a1', '\u05a2', '\u05a3', '\u05a4', '\u05a5', '\u05a6', '\u05a7', 
    '\u05a8', '\u05a9', '\u05aa', '\u05ab', '\u05ac', '\u05ad', '\u05ae', '\u05af', 
    '\u05b0', '\u05b1', '\u05b2', '\u05b3', '\u05b4', '\u05b5', '\u05b6', '\u05b7', 
    '\u05b8', '\u05b9', '\u05ba', '\u05bb', '\u05bc', '\u05bd', '\u05bf', '\u05c1', 
    '\u05c2', '\u05c4', '\u05c5', '\u05c7', '\u0610', '\u0611', '\u0612', '\u0613', 
    '\u0614', '\u0615', '\u0616', '\u0617', '\u0618', '\u0619', '\u061a', '\u064b', 
    '\u064c', '\u064d', '\u064e', '\u064f', '\u0650', '\u0651', '\u0652', '\u0653', 
    '\u0654', '\u0655', '\u0656', '\u0657', '\u0658', '\u0659', '\u065a', '\u065b', 
    '\u065c', '\u065d', '\u065e', '\u065f', '\u0670', '\u06d6', '\u06d7', '\u06d8', 
    '\u06d9', '\u06da', '\u06db', '\u06dc', '\u06df', '\u06e0', '\u06e1', '\u06e2', 
    '\u06e3', '\u06e4', '\u06e7', '\u06e8', '\u06ea', '\u06eb', '\u06ec', '\u06ed', 
    '\u0711', '\u0730', '\u0731', '\u0732', '\u0733', '\u0734', '\u0735', '\u0736', 
    '\u0737', '\u0738', '\u0739', '\u073a', '\u073b', '\u073c', '\u073d', '\u073e', 
    '\u073f', '\u0740', '\u0741', '\u0742', '\u0743', '\u0744', '\u0745', '\u0746', 
    '\u0747', '\u0748', '\u0749', '\u074a', '\u07a6', '\u07a7', '\u07a8', '\u07a9', 
    '\u07aa', '\u07ab', '\u07ac', '\u07ad', '\u07ae', '\u07af', '\u07b0', '\u07eb', 
    '\u07ec', '\u07ed', '\u07ee', '\u07ef', '\u07f0', '\u07f1', '\u07f2', '\u07f3', 
    '\u07fd', '\u0816', '\u0817', '\u0818', '\u0819', '\u081b', '\u081c', '\u081d', 
    '\u081e', '\u081f', '\u0820', '\u0821', '\u0822', '\u0823', '\u0825', '\u0826', 
    '\u0827', '\u0829', '\u082a', '\u082b', '\u082c', '\u082d', '\u0859', '\u085a', 
    '\u085b', '\u08d3', '\u08d4', '\u08d5', '\u08d6', '\u08d7', '\u08d8', '\u08d9', 
    '\u08da', '\u08db', '\u08dc', '\u08dd', '\u08de', '\u08df', '\u08e0', '\u08e1', 
    '\u08e3', '\u08e4', '\u08e5', '\u08e6', '\u08e7', '\u08e8', '\u08e9', '\u08ea', 
    '\u08eb', '\u08ec', '\u08ed', '\u08ee', '\u08ef', '\u08f0', '\u08f1', '\u08f2', 
    '\u08f3', '\u08f4', '\u08f5', '\u08f6', '\u08f7', '\u08f8', '\u08f9', '\u08fa', 
    '\u08fb', '\u08fc', '\u08fd', '\u08fe', '\u08ff', '\u0900', '\u0901', '\u0902', 
    '\u093a', '\u093c', '\u0941', '\u0942', '\u0943', '\u0944', '\u0945', '\u0946', 
    '\u0947', '\u0948', '\u094d', '\u0951', '\u0952', '\u0953', '\u0954', '\u0955', 
    '\u0956', '\u0957', '\u0962', '\u0963', '\u0981', '\u09bc', '\u09be', '\u09c1', 
    '\u09c2', '\u09c3', '\u09c4', '\u09cd', '\u09d7', '\u09e2', '\u09e3', '\u09fe', 
    '\u0a01', '\u0a02', '\u0a3c', '\u0a41', '\u0a42', '\u0a47', '\u0a48', '\u0a4b', 
    '\u0a4c', '\u0a4d', '\u0a51', '\u0a70', '\u0a71', '\u0a75', '\u0a81', '\u0a82', 
    '\u0abc', '\u0ac1', '\u0ac2', '\u0ac3', '\u0ac4', '\u0ac5', '\u0ac7', '\u0ac8', 
    '\u0acd', '\u0ae2', '\u0ae3', '\u0afa', '\u0afb', '\u0afc', '\u0afd', '\u0afe', 
    '\u0aff', '\u0b01', '\u0b3c', '\u0b3e', '\u0b3f', '\u0b41', '\u0b42', '\u0b43', 
    '\u0b44', '\u0b4d', '\u0b56', '\u0b57', '\u0b62', '\u0b63', '\u0b82', '\u0bbe', 
    '\u0bc0', '\u0bcd', '\u0bd7', '\u0c00', '\u0c04', '\u0c3e', '\u0c3f', '\u0c40', 
    '\u0c46', '\u0c47', '\u0c48', '\u0c4a', '\u0c4b', '\u0c4c', '\u0c4d', '\u0c55', 
    '\u0c56', '\u0c62', '\u0c63', '\u0c81', '\u0cbc', '\u0cbf', '\u0cc2', '\u0cc6', 
    '\u0ccc', '\u0ccd', '\u0cd5', '\u0cd6', '\u0ce2', '\u0ce3', '\u0d00', '\u0d01', 
    '\u0d3b', '\u0d3c', '\u0d3e', '\u0d41', '\u0d42', '\u0d43', '\u0d44', '\u0d4d', 
    '\u0d57', '\u0d62', '\u0d63', '\u0dca', '\u0dcf', '\u0dd2', '\u0dd3', '\u0dd4', 
    '\u0dd6', '\u0ddf', '\u0e31', '\u0e34', '\u0e35', '\u0e36', '\u0e37', '\u0e38', 
    '\u0e39', '\u0e3a', '\u0e47', '\u0e48', '\u0e49', '\u0e4a', '\u0e4b', '\u0e4c', 
    '\u0e4d', '\u0e4e', '\u0eb1', '\u0eb4', '\u0eb5', '\u0eb6', '\u0eb7', '\u0eb8', 
    '\u0eb9', '\u0ebb', '\u0ebc', '\u0ec8', '\u0ec9', '\u0eca', '\u0ecb', '\u0ecc', 
    '\u0ecd', '\u0f18', '\u0f19', '\u0f35', '\u0f37', '\u0f39', '\u0f71', '\u0f72', 
    '\u0f73', '\u0f74', '\u0f75', '\u0f76', '\u0f77', '\u0f78', '\u0f79', '\u0f7a', 
    '\u0f7b', '\u0f7c', '\u0f7d', '\u0f7e', '\u0f80', '\u0f81', '\u0f82', '\u0f83', 
    '\u0f84', '\u0f86', '\u0f87', '\u0f8d', '\u0f8e', '\u0f8f', '\u0f90', '\u0f91', 
    '\u0f92', '\u0f93', '\u0f94', '\u0f95', '\u0f96', '\u0f97', '\u0f99', '\u0f9a', 
    '\u0f9b', '\u0f9c', '\u0f9d', '\u0f9e', '\u0f9f', '\u0fa0', '\u0fa1', '\u0fa2', 
    '\u0fa3', '\u0fa4', '\u0fa5', '\u0fa6', '\u0fa7', '\u0fa8', '\u0fa9', '\u0faa', 
    '\u0fab', '\u0fac', '\u0fad', '\u0fae', '\u0faf', '\u0fb0', '\u0fb1', '\u0fb2', 
    '\u0fb3', '\u0fb4', '\u0fb5', '\u0fb6', '\u0fb7', '\u0fb8', '\u0fb9', '\u0fba', 
    '\u0fbb', '\u0fbc', '\u0fc6', '\u102d', '\u102e', '\u102f', '\u1030', '\u1032', 
    '\u1033', '\u1034', '\u1035', '\u1036', '\u1037', '\u1039', '\u103a', '\u103d', 
    '\u103e', '\u1058', '\u1059', '\u105e', '\u105f', '\u1060', '\u1071', '\u1072', 
    '\u1073', '\u1074', '\u1082', '\u1085', '\u1086', '\u108d', '\u109d', '\u135d', 
    '\u135e', '\u135f', '\u1712', '\u1713', '\u1714', '\u1732', '\u1733', '\u1734', 
    '\u1752', '\u1753', '\u1772', '\u1773', '\u17b4', '\u17b5', '\u17b7', '\u17b8', 
    '\u17b9', '\u17ba', '\u17bb', '\u17bc', '\u17bd', '\u17c6', '\u17c9', '\u17ca', 
    '\u17cb', '\u17cc', '\u17cd', '\u17ce', '\u17cf', '\u17d0', '\u17d1', '\u17d2', 
    '\u17d3', '\u17dd', '\u180b', '\u180c', '\u180d', '\u1885', '\u1886', '\u18a9', 
    '\u1920', '\u1921', '\u1922', '\u1927', '\u1928', '\u1932', '\u1939', '\u193a', 
    '\u193b', '\u1a17', '\u1a18', '\u1a1b', '\u1a56', '\u1a58', '\u1a59', '\u1a5a', 
    '\u1a5b', '\u1a5c', '\u1a5d', '\u1a5e', '\u1a60', '\u1a62', '\u1a65', '\u1a66', 
    '\u1a67', '\u1a68', '\u1a69', '\u1a6a', '\u1a6b', '\u1a6c', '\u1a73', '\u1a74', 
    '\u1a75', '\u1a76', '\u1a77', '\u1a78', '\u1a79', '\u1a7a', '\u1a7b', '\u1a7c', 
    '\u1a7f', '\u1ab0', '\u1ab1', '\u1ab2', '\u1ab3', '\u1ab4', '\u1ab5', '\u1ab6', 
    '\u1ab7', '\u1ab8', '\u1ab9', '\u1aba', '\u1abb', '\u1abc', '\u1abd', '\u1abe', 
    '\u1b00', '\u1b01', '\u1b02', '\u1b03', '\u1b34', '\u1b36', '\u1b37', '\u1b38', 
    '\u1b39', '\u1b3a', '\u1b3c', '\u1b42', '\u1b6b', '\u1b6c', '\u1b6d', '\u1b6e', 
    '\u1b6f', '\u1b70', '\u1b71', '\u1b72', '\u1b73', '\u1b80', '\u1b81', '\u1ba2', 
    '\u1ba3', '\u1ba4', '\u1ba5', '\u1ba8', '\u1ba9', '\u1bab', '\u1bac', '\u1bad', 
    '\u1be6', '\u1be8', '\u1be9', '\u1bed', '\u1bef', '\u1bf0', '\u1bf1', '\u1c2c', 
    '\u1c2d', '\u1c2e', '\u1c2f', '\u1c30', '\u1c31', '\u1c32', '\u1c33', '\u1c36', 
    '\u1c37', '\u1cd0', '\u1cd1', '\u1cd2', '\u1cd4', '\u1cd5', '\u1cd6', '\u1cd7', 
    '\u1cd8', '\u1cd9', '\u1cda', '\u1cdb', '\u1cdc', '\u1cdd', '\u1cde', '\u1cdf', 
    '\u1ce0', '\u1ce2', '\u1ce3', '\u1ce4', '\u1ce5', '\u1ce6', '\u1ce7', '\u1ce8', 
    '\u1ced', '\u1cf4', '\u1cf8', '\u1cf9', '\u1dc0', '\u1dc1', '\u1dc2', '\u1dc3', 
    '\u1dc4', '\u1dc5', '\u1dc6', '\u1dc7', '\u1dc8', '\u1dc9', '\u1dca', '\u1dcb', 
    '\u1dcc', '\u1dcd', '\u1dce', '\u1dcf', '\u1dd0', '\u1dd1', '\u1dd2', '\u1dd3', 
    '\u1dd4', '\u1dd5', '\u1dd6', '\u1dd7', '\u1dd8', '\u1dd9', '\u1dda', '\u1ddb', 
    '\u1ddc', '\u1ddd', '\u1dde', '\u1ddf', '\u1de0', '\u1de1', '\u1de2', '\u1de3', 
    '\u1de4', '\u1de5', '\u1de6', '\u1de7', '\u1de8', '\u1de9', '\u1dea', '\u1deb', 
    '\u1dec', '\u1ded', '\u1dee', '\u1def', '\u1df0', '\u1df1', '\u1df2', '\u1df3', 
    '\u1df4', '\u1df5', '\u1df6', '\u1df7', '\u1df8', '\u1df9', '\u1dfb', '\u1dfc', 
    '\u1dfd', '\u1dfe', '\u1dff', '\u200c', '\u20d0', '\u20d1', '\u20d2', '\u20d3', 
    '\u20d4', '\u20d5', '\u20d6', '\u20d7', '\u20d8', '\u20d9', '\u20da', '\u20db', 
    '\u20dc', '\u20dd', '\u20de', '\u20df', '\u20e0', '\u20e1', '\u20e2', '\u20e3', 
    '\u20e4', '\u20e5', '\u20e6', '\u20e7', '\u20e8', '\u20e9', '\u20ea', '\u20eb', 
    '\u20ec', '\u20ed', '\u20ee', '\u20ef', '\u20f0', '\u2cef', '\u2cf0', '\u2cf1', 
    '\u2d7f', '\u2de0', '\u2de1', '\u2de2', '\u2de3', '\u2de4', '\u2de5', '\u2de6', 
    '\u2de7', '\u2de8', '\u2de9', '\u2dea', '\u2deb', '\u2dec', '\u2ded', '\u2dee', 
    '\u2def', '\u2df0', '\u2df1', '\u2df2', '\u2df3', '\u2df4', '\u2df5', '\u2df6', 
    '\u2df7', '\u2df8', '\u2df9', '\u2dfa', '\u2dfb', '\u2dfc', '\u2dfd', '\u2dfe', 
    '\u2dff', '\u302a', '\u302b', '\u302c', '\u302d', '\u302e', '\u302f', '\u3099', 
    '\u309a', '\ua66f', '\ua670', '\ua671', '\ua672', '\ua674', '\ua675', '\ua676', 
    '\ua677', '\ua678', '\ua679', '\ua67a', '\ua67b', '\ua67c', '\ua67d', '\ua69e', 
    '\ua69f', '\ua6f0', '\ua6f1', '\ua802', '\ua806', '\ua80b', '\ua825', '\ua826', 
    '\ua8c4', '\ua8c5', '\ua8e0', '\ua8e1', '\ua8e2', '\ua8e3', '\ua8e4', '\ua8e5', 
    '\ua8e6', '\ua8e7', '\ua8e8', '\ua8e9', '\ua8ea', '\ua8eb', '\ua8ec', '\ua8ed', 
    '\ua8ee', '\ua8ef', '\ua8f0', '\ua8f1', '\ua8ff', '\ua926', '\ua927', '\ua928', 
    '\ua929', '\ua92a', '\ua92b', '\ua92c', '\ua92d', '\ua947', '\ua948', '\ua949', 
    '\ua94a', '\ua94b', '\ua94c', '\ua94d', '\ua94e', '\ua94f', '\ua950', '\ua951', 
    '\ua980', '\ua981', '\ua982', '\ua9b3', '\ua9b6', '\ua9b7', '\ua9b8', '\ua9b9', 
    '\ua9bc', '\ua9e5', '\uaa29', '\uaa2a', '\uaa2b', '\uaa2c', '\uaa2d', '\uaa2e', 
    '\uaa31', '\uaa32', '\uaa35', '\uaa36', '\uaa43', '\uaa4c', '\uaa7c', '\uaab0', 
    '\uaab2', '\uaab3', '\uaab4', '\uaab7', '\uaab8', '\uaabe', '\uaabf', '\uaac1', 
    '\uaaec', '\uaaed', '\uaaf6', '\uabe5', '\uabe8', '\uabed', '\ufb1e', '\ufe00', 
    '\ufe01', '\ufe02', '\ufe03', '\ufe04', '\ufe05', '\ufe06', '\ufe07', '\ufe08', 
    '\ufe09', '\ufe0a', '\ufe0b', '\ufe0c', '\ufe0d', '\ufe0e', '\ufe0f', '\ufe20', 
    '\ufe21', '\ufe22', '\ufe23', '\ufe24', '\ufe25', '\ufe26', '\ufe27', '\ufe28', 
    '\ufe29', '\ufe2a', '\ufe2b', '\ufe2c', '\ufe2d', '\ufe2e', '\ufe2f', '\uff9e', 
    '\uff9f', '\U000101fd', '\U000102e0', '\U00010376', '\U00010377', '\U00010378', '\U00010379', '\U0001037a', 
    '\U00010a01', '\U00010a02', '\U00010a03', '\U00010a05', '\U00010a06', '\U00010a0c', '\U00010a0d', '\U00010a0e', 
    '\U00010a0f', '\U00010a38', '\U00010a39', '\U00010a3a', '\U00010a3f', '\U00010ae5', '\U00010ae6', '\U00010d24', 
    '\U00010d25', '\U00010d26', '\U00010d27', '\U00010f46', '\U00010f47', '\U00010f48', '\U00010f49', '\U00010f4a', 
    '\U00010f4b', '\U00010f4c', '\U00010f4d', '\U00010f4e', '\U00010f4f', '\U00010f50', '\U00011001', '\U00011038', 
    '\U00011039', '\U0001103a', '\U0001103b', '\U0001103c', '\U0001103d', '\U0001103e', '\U0001103f', '\U00011040', 
    '\U00011041', '\U00011042', '\U00011043', '\U00011044', '\U00011045', '\U00011046', '\U0001107f', '\U00011080', 
    '\U00011081', '\U000110b3', '\U000110b4', '\U000110b5', '\U000110b6', '\U000110b9', '\U000110ba', '\U00011100', 
    '\U00011101', '\U00011102', '\U00011127', '\U00011128', '\U00011129', '\U0001112a', '\U0001112b', '\U0001112d', 
    '\U0001112e', '\U0001112f', '\U00011130', '\U00011131', '\U00011132', '\U00011133', '\U00011134', '\U00011173', 
    '\U00011180', '\U00011181', '\U000111b6', '\U000111b7', '\U000111b8', '\U000111b9', '\U000111ba', '\U000111bb', 
    '\U000111bc', '\U000111bd', '\U000111be', '\U000111c9', '\U000111ca', '\U000111cb', '\U000111cc', '\U0001122f', 
    '\U00011230', '\U00011231', '\U00011234', '\U00011236', '\U00011237', '\U0001123e', '\U000112df', '\U000112e3', 
    '\U000112e4', '\U000112e5', '\U000112e6', '\U000112e7', '\U000112e8', '\U000112e9', '\U000112ea', '\U00011300', 
    '\U00011301', '\U0001133b', '\U0001133c', '\U0001133e', '\U00011340', '\U00011357', '\U00011366', '\U00011367', 
    '\U00011368', '\U00011369', '\U0001136a', '\U0001136b', '\U0001136c', '\U00011370', '\U00011371', '\U00011372', 
    '\U00011373', '\U00011374', '\U00011438', '\U00011439', '\U0001143a', '\U0001143b', '\U0001143c', '\U0001143d', 
    '\U0001143e', '\U0001143f', '\U00011442', '\U00011443', '\U00011444', '\U00011446', '\U0001145e', '\U000114b0', 
    '\U000114b3', '\U000114b4', '\U000114b5', '\U000114b6', '\U000114b7', '\U000114b8', '\U000114ba', '\U000114bd', 
    '\U000114bf', '\U000114c0', '\U000114c2', '\U000114c3', '\U000115af', '\U000115b2', '\U000115b3', '\U000115b4', 
    '\U000115b5', '\U000115bc', '\U000115bd', '\U000115bf', '\U000115c0', '\U000115dc', '\U000115dd', '\U00011633', 
    '\U00011634', '\U00011635', '\U00011636', '\U00011637', '\U00011638', '\U00011639', '\U0001163a', '\U0001163d', 
    '\U0001163f', '\U00011640', '\U000116ab', '\U000116ad', '\U000116b0', '\U000116b1', '\U000116b2', '\U000116b3', 
    '\U000116b4', '\U000116b5', '\U000116b7', '\U0001171d', '\U0001171e', '\U0001171f', '\U00011722', '\U00011723', 
    '\U00011724', '\U00011725', '\U00011727', '\U00011728', '\U00011729', '\U0001172a', '\U0001172b', '\U0001182f', 
    '\U00011830', '\U00011831', '\U00011832', '\U00011833', '\U00011834', '\U00011835', '\U00011836', '\U00011837', 
    '\U00011839', '\U0001183a', '\U00011a01', '\U00011a02', '\U00011a03', '\U00011a04', '\U00011a05', '\U00011a06', 
    '\U00011a07', '\U00011a08', '\U00011a09', '\U00011a0a', '\U00011a33', '\U00011a34', '\U00011a35', '\U00011a36', 
    '\U00011a37', '\U00011a38', '\U00011a3b', '\U00011a3c', '\U00011a3d', '\U00011a3e', '\U00011a47', '\U00011a51', 
    '\U00011a52', '\U00011a53', '\U00011a54', '\U00011a55', '\U00011a56', '\U00011a59', '\U00011a5a', '\U00011a5b', 
    '\U00011a8a', '\U00011a8b', '\U00011a8c', '\U00011a8d', '\U00011a8e', '\U00011a8f', '\U00011a90', '\U00011a91', 
    '\U00011a92', '\U00011a93', '\U00011a94', '\U00011a95', '\U00011a96', '\U00011a98', '\U00011a99', '\U00011c30', 
    '\U00011c31', '\U00011c32', '\U00011c33', '\U00011c34', '\U00011c35', '\U00011c36', '\U00011c38', '\U00011c39', 
    '\U00011c3a', '\U00011c3b', '\U00011c3c', '\U00011c3d', '\U00011c3f', '\U00011c92', '\U00011c93', '\U00011c94', 
    '\U00011c95', '\U00011c96', '\U00011c97', '\U00011c98', '\U00011c99', '\U00011c9a', '\U00011c9b', '\U00011c9c', 
    '\U00011c9d', '\U00011c9e', '\U00011c9f', '\U00011ca0', '\U00011ca1', '\U00011ca2', '\U00011ca3', '\U00011ca4', 
    '\U00011ca5', '\U00011ca6', '\U00011ca7', '\U00011caa', '\U00011cab', '\U00011cac', '\U00011cad', '\U00011cae', 
    '\U00011caf', '\U00011cb0', '\U00011cb2', '\U00011cb3', '\U00011cb5', '\U00011cb6', '\U00011d31', '\U00011d32', 
    '\U00011d33', '\U00011d34', '\U00011d35', '\U00011d36', '\U00011d3a', '\U00011d3c', '\U00011d3d', '\U00011d3f', 
    '\U00011d40', '\U00011d41', '\U00011d42', '\U00011d43', '\U00011d44', '\U00011d45', '\U00011d47', '\U00011d90', 
    '\U00011d91', '\U00011d95', '\U00011d97', '\U00011ef3', '\U00011ef4', '\U00016af0', '\U00016af1', '\U00016af2', 
    '\U00016af3', '\U00016af4', '\U00016b30', '\U00016b31', '\U00016b32', '\U00016b33', '\U00016b34', '\U00016b35', 
    '\U00016b36', '\U00016f8f', '\U00016f90', '\U00016f91', '\U00016f92', '\U0001bc9d', '\U0001bc9e', '\U0001d165', 
    '\U0001d167', '\U0001d168', '\U0001d169', '\U0001d16e', '\U0001d16f', '\U0001d170', '\U0001d171', '\U0001d172', 
    '\U0001d17b', '\U0001d17c', '\U0001d17d', '\U0001d17e', '\U0001d17f', '\U0001d180', '\U0001d181', '\U0001d182', 
    '\U0001d185', '\U0001d186', '\U0001d187', '\U0001d188', '\U0001d189', '\U0001d18a', '\U0001d18b', '\U0001d1aa', 
    '\U0001d1ab', '\U0001d1ac', '\U0001d1ad', '\U0001d242', '\U0001d243', '\U0001d244', '\U0001da00', '\U0001da01', 
    '\U0001da02', '\U0001da03', '\U0001da04', '\U0001da05', '\U0001da06', '\U0001da07', '\U0001da08', '\U0001da09', 
    '\U0001da0a', '\U0001da0b', '\U0001da0c', '\U0001da0d', '\U0001da0e', '\U0001da0f', '\U0001da10', '\U0001da11', 
    '\U0001da12', '\U0001da13', '\U0001da14', '\U0001da15', '\U0001da16', '\U0001da17', '\U0001da18', '\U0001da19', 
    '\U0001da1a', '\U0001da1b', '\U0001da1c', '\U0001da1d', '\U0001da1e', '\U0001da1f', '\U0001da20', '\U0001da21', 
    '\U0001da22', '\U0001da23', '\U0001da24', '\U0001da25', '\U0001da26', '\U0001da27', '\U0001da28', '\U0001da29', 
    '\U0001da2a', '\U0001da2b', '\U0001da2c', '\U0001da2d', '\U0001da2e', '\U0001da2f', '\U0001da30', '\U0001da31', 
    '\U0001da32', '\U0001da33', '\U0001da34', '\U0001da35', '\U0001da36', '\U0001da3b', '\U0001da3c', '\U0001da3d', 
    '\U0001da3e', '\U0001da3f', '\U0001da40', '\U0001da41', '\U0001da42', '\U0001da43', '\U0001da44', '\U0001da45', 
    '\U0001da46', '\U0001da47', '\U0001da48', '\U0001da49', '\U0001da4a', '\U0001da4b', '\U0001da4c', '\U0001da4d', 
    '\U0001da4e', '\U0001da4f', '\U0001da50', '\U0001da51', '\U0001da52', '\U0001da53', '\U0001da54', '\U0001da55', 
    '\U0001da56', '\U0001da57', '\U0001da58', '\U0001da59', '\U0001da5a', '\U0001da5b', '\U0001da5c', '\U0001da5d', 
    '\U0001da5e', '\U0001da5f', '\U0001da60', '\U0001da61', '\U0001da62', '\U0001da63', '\U0001da64', '\U0001da65', 
    '\U0001da66', '\U0001da67', '\U0001da68', '\U0001da69', '\U0001da6a', '\U0001da6b', '\U0001da6c', '\U0001da75', 
    '\U0001da84', '\U0001da9b', '\U0001da9c', '\U0001da9d', '\U0001da9e', '\U0001da9f', '\U0001daa1', '\U0001daa2', 
    '\U0001daa3', '\U0001daa4', '\U0001daa5', '\U0001daa6', '\U0001daa7', '\U0001daa8', '\U0001daa9', '\U0001daaa', 
    '\U0001daab', '\U0001daac', '\U0001daad', '\U0001daae', '\U0001daaf', '\U0001e000', '\U0001e001', '\U0001e002', 
    '\U0001e003', '\U0001e004', '\U0001e005', '\U0001e006', '\U0001e008', '\U0001e009', '\U0001e00a', '\U0001e00b', 
    '\U0001e00c', '\U0001e00d', '\U0001e00e', '\U0001e00f', '\U0001e010', '\U0001e011', '\U0001e012', '\U0001e013', 
    '\U0001e014', '\U0001e015', '\U0001e016', '\U0001e017', '\U0001e018', '\U0001e01b', '\U0001e01c', '\U0001e01d', 
    '\U0001e01e', '\U0001e01f', '\U0001e020', '\U0001e021', '\U0001e023', '\U0001e024', '\U0001e026', '\U0001e027', 
    '\U0001e028', '\U0001e029', '\U0001e02a', '\U0001e8d0', '\U0001e8d1', '\U0001e8d2', '\U0001e8d3', '\U0001e8d4', 
    '\U0001e8d5', '\U0001e8d6', '\U0001e944', '\U0001e945', '\U0001e946', '\U0001e947', '\U0001e948', '\U0001e949', 
    '\U0001e94a', '\U0001f3fb', '\U0001f3fc', '\U0001f3fd', '\U0001f3fe', '\U0001f3ff', '\U000e0020', '\U000e0021', 
    '\U000e0022', '\U000e0023', '\U000e0024', '\U000e0025', '\U000e0026', '\U000e0027', '\U000e0028', '\U000e0029', 
    '\U000e002a', '\U000e002b', '\U000e002c', '\U000e002d', '\U000e002e', '\U000e002f', '\U000e0030', '\U000e0031', 
    '\U000e0032', '\U000e0033', '\U000e0034', '\U000e0035', '\U000e0036', '\U000e0037', '\U000e0038', '\U000e0039', 
    '\U000e003a', '\U000e003b', '\U000e003c', '\U000e003d', '\U000e003e', '\U000e003f', '\U000e0040', '\U000e0041', 
    '\U000e0042', '\U000e0043', '\U000e0044', '\U000e0045', '\U000e0046', '\U000e0047', '\U000e0048', '\U000e0049', 
    '\U000e004a', '\U000e004b', '\U000e004c', '\U000e004d', '\U000e004e', '\U000e004f', '\U000e0050', '\U000e0051', 
    '\U000e0052', '\U000e0053', '\U000e0054', '\U000e0055', '\U000e0056', '\U000e0057', '\U000e0058', '\U000e0059', 
    '\U000e005a', '\U000e005b', '\U000e005c', '\U000e005d', '\U000e005e', '\U000e005f', '\U000e0060', '\U000e0061', 
    '\U000e0062', '\U000e0063', '\U000e0064', '\U000e0065', '\U000e0066', '\U000e0067', '\U000e0068', '\U000e0069', 
    '\U000e006a', '\U000e006b', '\U000e006c', '\U000e006d', '\U000e006e', '\U000e006f', '\U000e0070', '\U000e0071', 
    '\U000e0072', '\U000e0073', '\U000e0074', '\U000e0075', '\U000e0076', '\U000e0077', '\U000e0078', '\U000e0079', 
    '\U000e007a', '\U000e007b', '\U000e007c', '\U000e007d', '\U000e007e', '\U000e007f', '\U000e0100', '\U000e0101', 
    '\U000e0102', '\U000e0103', '\U000e0104', '\U000e0105', '\U000e0106', '\U000e0107', '\U000e0108', '\U000e0109', 
    '\U000e010a', '\U000e010b', '\U000e010c', '\U000e010d', '\U000e010e', '\U000e010f', '\U000e0110', '\U000e0111', 
    '\U000e0112', '\U000e0113', '\U000e0114', '\U000e0115', '\U000e0116', '\U000e0117', '\U000e0118', '\U000e0119', 
    '\U000e011a', '\U000e011b', '\U000e011c', '\U000e011d', '\U000e011e', '\U000e011f', '\U000e0120', '\U000e0121', 
    '\U000e0122', '\U000e0123', '\U000e0124', '\U000e0125', '\U000e0126', '\U000e0127', '\U000e0128', '\U000e0129', 
    '\U000e012a', '\U000e012b', '\U000e012c', '\U000e012d', '\U000e012e', '\U000e012f', '\U000e0130', '\U000e0131', 
    '\U000e0132', '\U000e0133', '\U000e0134', '\U000e0135', '\U000e0136', '\U000e0137', '\U000e0138', '\U000e0139', 
    '\U000e013a', '\U000e013b', '\U000e013c', '\U000e013d', '\U000e013e', '\U000e013f', '\U000e0140', '\U000e0141', 
    '\U000e0142', '\U000e0143', '\U000e0144', '\U000e0145', '\U000e0146', '\U000e0147', '\U000e0148', '\U000e0149', 
    '\U000e014a', '\U000e014b', '\U000e014c', '\U000e014d', '\U000e014e', '\U000e014f', '\U000e0150', '\U000e0151', 
    '\U000e0152', '\U000e0153', '\U000e0154', '\U000e0155', '\U000e0156', '\U000e0157', '\U000e0158', '\U000e0159', 
    '\U000e015a', '\U000e015b', '\U000e015c', '\U000e015d', '\U000e015e', '\U000e015f', '\U000e0160', '\U000e0161', 
    '\U000e0162', '\U000e0163', '\U000e0164', '\U000e0165', '\U000e0166', '\U000e0167', '\U000e0168', '\U000e0169', 
    '\U000e016a', '\U000e016b', '\U000e016c', '\U000e016d', '\U000e016e', '\U000e016f', '\U000e0170', '\U000e0171', 
    '\U000e0172', '\U000e0173', '\U000e0174', '\U000e0175', '\U000e0176', '\U000e0177', '\U000e0178', '\U000e0179', 
    '\U000e017a', '\U000e017b', '\U000e017c', '\U000e017d', '\U000e017e', '\U000e017f', '\U000e0180', '\U000e0181', 
    '\U000e0182', '\U000e0183', '\U000e0184', '\U000e0185', '\U000e0186', '\U000e0187', '\U000e0188', '\U000e0189', 
    '\U000e018a', '\U000e018b', '\U000e018c', '\U000e018d', '\U000e018e', '\U000e018f', '\U000e0190', '\U000e0191', 
    '\U000e0192', '\U000e0193', '\U000e0194', '\U000e0195', '\U000e0196', '\U000e0197', '\U000e0198', '\U000e0199', 
    '\U000e019a', '\U000e019b', '\U000e019c', '\U000e019d', '\U000e019e', '\U000e019f', '\U000e01a0', '\U000e01a1', 
    '\U000e01a2', '\U000e01a3', '\U000e01a4', '\U000e01a5', '\U000e01a6', '\U000e01a7', '\U000e01a8', '\U000e01a9', 
    '\U000e01aa', '\U000e01ab', '\U000e01ac', '\U000e01ad', '\U000e01ae', '\U000e01af', '\U000e01b0', '\U000e01b1', 
    '\U000e01b2', '\U000e01b3', '\U000e01b4', '\U000e01b5', '\U000e01b6', '\U000e01b7', '\U000e01b8', '\U000e01b9', 
    '\U000e01ba', '\U000e01bb', '\U000e01bc', '\U000e01bd', '\U000e01be', '\U000e01bf', '\U000e01c0', '\U000e01c1', 
    '\U000e01c2', '\U000e01c3', '\U000e01c4', '\U000e01c5', '\U000e01c6', '\U000e01c7', '\U000e01c8', '\U000e01c9', 
    '\U000e01ca', '\U000e01cb', '\U000e01cc', '\U000e01cd', '\U000e01ce', '\U000e01cf', '\U000e01d0', '\U000e01d1', 
    '\U000e01d2', '\U000e01d3', '\U000e01d4', '\U000e01d5', '\U000e01d6', '\U000e01d7', '\U000e01d8', '\U000e01d9', 
    '\U000e01da', '\U000e01db', '\U000e01dc', '\U000e01dd', '\U000e01de', '\U000e01df', '\U000e01e0', '\U000e01e1', 
    '\U000e01e2', '\U000e01e3', '\U000e01e4', '\U000e01e5', '\U000e01e6', '\U000e01e7', '\U000e01e8', '\U000e01e9', 
    '\U000e01ea', '\U000e01eb', '\U000e01ec', '\U000e01ed', '\U000e01ee', '\U000e01ef')
    rangeFromGraphemeClass[int(ExtendClass)] = Extend

    // Range for Grapheme class Regional_Indicator
    Regional_Indicator = rangetable.New('\U0001f1e6', '\U0001f1e7', '\U0001f1e8', '\U0001f1e9', '\U0001f1ea', '\U0001f1eb', 
    '\U0001f1ec', '\U0001f1ed', '\U0001f1ee', '\U0001f1ef', '\U0001f1f0', '\U0001f1f1', '\U0001f1f2', '\U0001f1f3', 
    '\U0001f1f4', '\U0001f1f5', '\U0001f1f6', '\U0001f1f7', '\U0001f1f8', '\U0001f1f9', '\U0001f1fa', '\U0001f1fb', 
    '\U0001f1fc', '\U0001f1fd', '\U0001f1fe', '\U0001f1ff')
    rangeFromGraphemeClass[int(Regional_IndicatorClass)] = Regional_Indicator

    // Range for Grapheme class L
    L = rangetable.New('\u1100', '\u1101', '\u1102', '\u1103', '\u1104', '\u1105', 
    '\u1106', '\u1107', '\u1108', '\u1109', '\u110a', '\u110b', '\u110c', '\u110d', 
    '\u110e', '\u110f', '\u1110', '\u1111', '\u1112', '\u1113', '\u1114', '\u1115', 
    '\u1116', '\u1117', '\u1118', '\u1119', '\u111a', '\u111b', '\u111c', '\u111d', 
    '\u111e', '\u111f', '\u1120', '\u1121', '\u1122', '\u1123', '\u1124', '\u1125', 
    '\u1126', '\u1127', '\u1128', '\u1129', '\u112a', '\u112b', '\u112c', '\u112d', 
    '\u112e', '\u112f', '\u1130', '\u1131', '\u1132', '\u1133', '\u1134', '\u1135', 
    '\u1136', '\u1137', '\u1138', '\u1139', '\u113a', '\u113b', '\u113c', '\u113d', 
    '\u113e', '\u113f', '\u1140', '\u1141', '\u1142', '\u1143', '\u1144', '\u1145', 
    '\u1146', '\u1147', '\u1148', '\u1149', '\u114a', '\u114b', '\u114c', '\u114d', 
    '\u114e', '\u114f', '\u1150', '\u1151', '\u1152', '\u1153', '\u1154', '\u1155', 
    '\u1156', '\u1157', '\u1158', '\u1159', '\u115a', '\u115b', '\u115c', '\u115d', 
    '\u115e', '\u115f', '\ua960', '\ua961', '\ua962', '\ua963', '\ua964', '\ua965', 
    '\ua966', '\ua967', '\ua968', '\ua969', '\ua96a', '\ua96b', '\ua96c', '\ua96d', 
    '\ua96e', '\ua96f', '\ua970', '\ua971', '\ua972', '\ua973', '\ua974', '\ua975', 
    '\ua976', '\ua977', '\ua978', '\ua979', '\ua97a', '\ua97b', '\ua97c')
    rangeFromGraphemeClass[int(LClass)] = L

    // Range for Grapheme class T
    T = rangetable.New('\u11a8', '\u11a9', '\u11aa', '\u11ab', '\u11ac', '\u11ad', 
    '\u11ae', '\u11af', '\u11b0', '\u11b1', '\u11b2', '\u11b3', '\u11b4', '\u11b5', 
    '\u11b6', '\u11b7', '\u11b8', '\u11b9', '\u11ba', '\u11bb', '\u11bc', '\u11bd', 
    '\u11be', '\u11bf', '\u11c0', '\u11c1', '\u11c2', '\u11c3', '\u11c4', '\u11c5', 
    '\u11c6', '\u11c7', '\u11c8', '\u11c9', '\u11ca', '\u11cb', '\u11cc', '\u11cd', 
    '\u11ce', '\u11cf', '\u11d0', '\u11d1', '\u11d2', '\u11d3', '\u11d4', '\u11d5', 
    '\u11d6', '\u11d7', '\u11d8', '\u11d9', '\u11da', '\u11db', '\u11dc', '\u11dd', 
    '\u11de', '\u11df', '\u11e0', '\u11e1', '\u11e2', '\u11e3', '\u11e4', '\u11e5', 
    '\u11e6', '\u11e7', '\u11e8', '\u11e9', '\u11ea', '\u11eb', '\u11ec', '\u11ed', 
    '\u11ee', '\u11ef', '\u11f0', '\u11f1', '\u11f2', '\u11f3', '\u11f4', '\u11f5', 
    '\u11f6', '\u11f7', '\u11f8', '\u11f9', '\u11fa', '\u11fb', '\u11fc', '\u11fd', 
    '\u11fe', '\u11ff', '\ud7cb', '\ud7cc', '\ud7cd', '\ud7ce', '\ud7cf', '\ud7d0', 
    '\ud7d1', '\ud7d2', '\ud7d3', '\ud7d4', '\ud7d5', '\ud7d6', '\ud7d7', '\ud7d8', 
    '\ud7d9', '\ud7da', '\ud7db', '\ud7dc', '\ud7dd', '\ud7de', '\ud7df', '\ud7e0', 
    '\ud7e1', '\ud7e2', '\ud7e3', '\ud7e4', '\ud7e5', '\ud7e6', '\ud7e7', '\ud7e8', 
    '\ud7e9', '\ud7ea', '\ud7eb', '\ud7ec', '\ud7ed', '\ud7ee', '\ud7ef', '\ud7f0', 
    '\ud7f1', '\ud7f2', '\ud7f3', '\ud7f4', '\ud7f5', '\ud7f6', '\ud7f7', '\ud7f8', 
    '\ud7f9', '\ud7fa', '\ud7fb')
    rangeFromGraphemeClass[int(TClass)] = T

    // Range for Grapheme class Control
    Control = rangetable.New('\x00', '\x01', '\x02', '\x03', '\x04', '\x05', 
    '\x06', '\a', '\b', '\t', '\v', '\f', '\x0e', '\x0f', 
    '\x10', '\x11', '\x12', '\x13', '\x14', '\x15', '\x16', '\x17', 
    '\x18', '\x19', '\x1a', '\x1b', '\x1c', '\x1d', '\x1e', '\x1f', 
    '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', 
    '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', 
    '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', 
    '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', 
    '\u009f', '\u00ad', '\u061c', '\u180e', '\u200b', '\u200e', '\u200f', '\u2028', 
    '\u2029', '\u202a', '\u202b', '\u202c', '\u202d', '\u202e', '\u2060', '\u2061', 
    '\u2062', '\u2063', '\u2064', '\u2065', '\u2066', '\u2067', '\u2068', '\u2069', 
    '\u206a', '\u206b', '\u206c', '\u206d', '\u206e', '\u206f', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', 
    '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufeff', '\ufff0', 
    '\ufff1', '\ufff2', '\ufff3', '\ufff4', '\ufff5', '\ufff6', '\ufff7', '\ufff8', 
    '\ufff9', '\ufffa', '\ufffb', '\U0001bca0', '\U0001bca1', '\U0001bca2', '\U0001bca3', '\U0001d173', 
    '\U0001d174', '\U0001d175', '\U0001d176', '\U0001d177', '\U0001d178', '\U0001d179', '\U0001d17a', '\U000e0000', 
    '\U000e0001', '\U000e0002', '\U000e0003', '\U000e0004', '\U000e0005', '\U000e0006', '\U000e0007', '\U000e0008', 
    '\U000e0009', '\U000e000a', '\U000e000b', '\U000e000c', '\U000e000d', '\U000e000e', '\U000e000f', '\U000e0010', 
    '\U000e0011', '\U000e0012', '\U000e0013', '\U000e0014', '\U000e0015', '\U000e0016', '\U000e0017', '\U000e0018', 
    '\U000e0019', '\U000e001a', '\U000e001b', '\U000e001c', '\U000e001d', '\U000e001e', '\U000e001f', '\U000e0080', 
    '\U000e0081', '\U000e0082', '\U000e0083', '\U000e0084', '\U000e0085', '\U000e0086', '\U000e0087', '\U000e0088', 
    '\U000e0089', '\U000e008a', '\U000e008b', '\U000e008c', '\U000e008d', '\U000e008e', '\U000e008f', '\U000e0090', 
    '\U000e0091', '\U000e0092', '\U000e0093', '\U000e0094', '\U000e0095', '\U000e0096', '\U000e0097', '\U000e0098', 
    '\U000e0099', '\U000e009a', '\U000e009b', '\U000e009c', '\U000e009d', '\U000e009e', '\U000e009f', '\U000e00a0', 
    '\U000e00a1', '\U000e00a2', '\U000e00a3', '\U000e00a4', '\U000e00a5', '\U000e00a6', '\U000e00a7', '\U000e00a8', 
    '\U000e00a9', '\U000e00aa', '\U000e00ab', '\U000e00ac', '\U000e00ad', '\U000e00ae', '\U000e00af', '\U000e00b0', 
    '\U000e00b1', '\U000e00b2', '\U000e00b3', '\U000e00b4', '\U000e00b5', '\U000e00b6', '\U000e00b7', '\U000e00b8', 
    '\U000e00b9', '\U000e00ba', '\U000e00bb', '\U000e00bc', '\U000e00bd', '\U000e00be', '\U000e00bf', '\U000e00c0', 
    '\U000e00c1', '\U000e00c2', '\U000e00c3', '\U000e00c4', '\U000e00c5', '\U000e00c6', '\U000e00c7', '\U000e00c8', 
    '\U000e00c9', '\U000e00ca', '\U000e00cb', '\U000e00cc', '\U000e00cd', '\U000e00ce', '\U000e00cf', '\U000e00d0', 
    '\U000e00d1', '\U000e00d2', '\U000e00d3', '\U000e00d4', '\U000e00d5', '\U000e00d6', '\U000e00d7', '\U000e00d8', 
    '\U000e00d9', '\U000e00da', '\U000e00db', '\U000e00dc', '\U000e00dd', '\U000e00de', '\U000e00df', '\U000e00e0', 
    '\U000e00e1', '\U000e00e2', '\U000e00e3', '\U000e00e4', '\U000e00e5', '\U000e00e6', '\U000e00e7', '\U000e00e8', 
    '\U000e00e9', '\U000e00ea', '\U000e00eb', '\U000e00ec', '\U000e00ed', '\U000e00ee', '\U000e00ef', '\U000e00f0', 
    '\U000e00f1', '\U000e00f2', '\U000e00f3', '\U000e00f4', '\U000e00f5', '\U000e00f6', '\U000e00f7', '\U000e00f8', 
    '\U000e00f9', '\U000e00fa', '\U000e00fb', '\U000e00fc', '\U000e00fd', '\U000e00fe', '\U000e00ff', '\U000e01f0', 
    '\U000e01f1', '\U000e01f2', '\U000e01f3', '\U000e01f4', '\U000e01f5', '\U000e01f6', '\U000e01f7', '\U000e01f8', 
    '\U000e01f9', '\U000e01fa', '\U000e01fb', '\U000e01fc', '\U000e01fd', '\U000e01fe', '\U000e01ff', '\U000e0200', 
    '\U000e0201', '\U000e0202', '\U000e0203', '\U000e0204', '\U000e0205', '\U000e0206', '\U000e0207', '\U000e0208', 
    '\U000e0209', '\U000e020a', '\U000e020b', '\U000e020c', '\U000e020d', '\U000e020e', '\U000e020f', '\U000e0210', 
    '\U000e0211', '\U000e0212', '\U000e0213', '\U000e0214', '\U000e0215', '\U000e0216', '\U000e0217', '\U000e0218', 
    '\U000e0219', '\U000e021a', '\U000e021b', '\U000e021c', '\U000e021d', '\U000e021e', '\U000e021f', '\U000e0220', 
    '\U000e0221', '\U000e0222', '\U000e0223', '\U000e0224', '\U000e0225', '\U000e0226', '\U000e0227', '\U000e0228', 
    '\U000e0229', '\U000e022a', '\U000e022b', '\U000e022c', '\U000e022d', '\U000e022e', '\U000e022f', '\U000e0230', 
    '\U000e0231', '\U000e0232', '\U000e0233', '\U000e0234', '\U000e0235', '\U000e0236', '\U000e0237', '\U000e0238', 
    '\U000e0239', '\U000e023a', '\U000e023b', '\U000e023c', '\U000e023d', '\U000e023e', '\U000e023f', '\U000e0240', 
    '\U000e0241', '\U000e0242', '\U000e0243', '\U000e0244', '\U000e0245', '\U000e0246', '\U000e0247', '\U000e0248', 
    '\U000e0249', '\U000e024a', '\U000e024b', '\U000e024c', '\U000e024d', '\U000e024e', '\U000e024f', '\U000e0250', 
    '\U000e0251', '\U000e0252', '\U000e0253', '\U000e0254', '\U000e0255', '\U000e0256', '\U000e0257', '\U000e0258', 
    '\U000e0259', '\U000e025a', '\U000e025b', '\U000e025c', '\U000e025d', '\U000e025e', '\U000e025f', '\U000e0260', 
    '\U000e0261', '\U000e0262', '\U000e0263', '\U000e0264', '\U000e0265', '\U000e0266', '\U000e0267', '\U000e0268', 
    '\U000e0269', '\U000e026a', '\U000e026b', '\U000e026c', '\U000e026d', '\U000e026e', '\U000e026f', '\U000e0270', 
    '\U000e0271', '\U000e0272', '\U000e0273', '\U000e0274', '\U000e0275', '\U000e0276', '\U000e0277', '\U000e0278', 
    '\U000e0279', '\U000e027a', '\U000e027b', '\U000e027c', '\U000e027d', '\U000e027e', '\U000e027f', '\U000e0280', 
    '\U000e0281', '\U000e0282', '\U000e0283', '\U000e0284', '\U000e0285', '\U000e0286', '\U000e0287', '\U000e0288', 
    '\U000e0289', '\U000e028a', '\U000e028b', '\U000e028c', '\U000e028d', '\U000e028e', '\U000e028f', '\U000e0290', 
    '\U000e0291', '\U000e0292', '\U000e0293', '\U000e0294', '\U000e0295', '\U000e0296', '\U000e0297', '\U000e0298', 
    '\U000e0299', '\U000e029a', '\U000e029b', '\U000e029c', '\U000e029d', '\U000e029e', '\U000e029f', '\U000e02a0', 
    '\U000e02a1', '\U000e02a2', '\U000e02a3', '\U000e02a4', '\U000e02a5', '\U000e02a6', '\U000e02a7', '\U000e02a8', 
    '\U000e02a9', '\U000e02aa', '\U000e02ab', '\U000e02ac', '\U000e02ad', '\U000e02ae', '\U000e02af', '\U000e02b0', 
    '\U000e02b1', '\U000e02b2', '\U000e02b3', '\U000e02b4', '\U000e02b5', '\U000e02b6', '\U000e02b7', '\U000e02b8', 
    '\U000e02b9', '\U000e02ba', '\U000e02bb', '\U000e02bc', '\U000e02bd', '\U000e02be', '\U000e02bf', '\U000e02c0', 
    '\U000e02c1', '\U000e02c2', '\U000e02c3', '\U000e02c4', '\U000e02c5', '\U000e02c6', '\U000e02c7', '\U000e02c8', 
    '\U000e02c9', '\U000e02ca', '\U000e02cb', '\U000e02cc', '\U000e02cd', '\U000e02ce', '\U000e02cf', '\U000e02d0', 
    '\U000e02d1', '\U000e02d2', '\U000e02d3', '\U000e02d4', '\U000e02d5', '\U000e02d6', '\U000e02d7', '\U000e02d8', 
    '\U000e02d9', '\U000e02da', '\U000e02db', '\U000e02dc', '\U000e02dd', '\U000e02de', '\U000e02df', '\U000e02e0', 
    '\U000e02e1', '\U000e02e2', '\U000e02e3', '\U000e02e4', '\U000e02e5', '\U000e02e6', '\U000e02e7', '\U000e02e8', 
    '\U000e02e9', '\U000e02ea', '\U000e02eb', '\U000e02ec', '\U000e02ed', '\U000e02ee', '\U000e02ef', '\U000e02f0', 
    '\U000e02f1', '\U000e02f2', '\U000e02f3', '\U000e02f4', '\U000e02f5', '\U000e02f6', '\U000e02f7', '\U000e02f8', 
    '\U000e02f9', '\U000e02fa', '\U000e02fb', '\U000e02fc', '\U000e02fd', '\U000e02fe', '\U000e02ff', '\U000e0300', 
    '\U000e0301', '\U000e0302', '\U000e0303', '\U000e0304', '\U000e0305', '\U000e0306', '\U000e0307', '\U000e0308', 
    '\U000e0309', '\U000e030a', '\U000e030b', '\U000e030c', '\U000e030d', '\U000e030e', '\U000e030f', '\U000e0310', 
    '\U000e0311', '\U000e0312', '\U000e0313', '\U000e0314', '\U000e0315', '\U000e0316', '\U000e0317', '\U000e0318', 
    '\U000e0319', '\U000e031a', '\U000e031b', '\U000e031c', '\U000e031d', '\U000e031e', '\U000e031f', '\U000e0320', 
    '\U000e0321', '\U000e0322', '\U000e0323', '\U000e0324', '\U000e0325', '\U000e0326', '\U000e0327', '\U000e0328', 
    '\U000e0329', '\U000e032a', '\U000e032b', '\U000e032c', '\U000e032d', '\U000e032e', '\U000e032f', '\U000e0330', 
    '\U000e0331', '\U000e0332', '\U000e0333', '\U000e0334', '\U000e0335', '\U000e0336', '\U000e0337', '\U000e0338', 
    '\U000e0339', '\U000e033a', '\U000e033b', '\U000e033c', '\U000e033d', '\U000e033e', '\U000e033f', '\U000e0340', 
    '\U000e0341', '\U000e0342', '\U000e0343', '\U000e0344', '\U000e0345', '\U000e0346', '\U000e0347', '\U000e0348', 
    '\U000e0349', '\U000e034a', '\U000e034b', '\U000e034c', '\U000e034d', '\U000e034e', '\U000e034f', '\U000e0350', 
    '\U000e0351', '\U000e0352', '\U000e0353', '\U000e0354', '\U000e0355', '\U000e0356', '\U000e0357', '\U000e0358', 
    '\U000e0359', '\U000e035a', '\U000e035b', '\U000e035c', '\U000e035d', '\U000e035e', '\U000e035f', '\U000e0360', 
    '\U000e0361', '\U000e0362', '\U000e0363', '\U000e0364', '\U000e0365', '\U000e0366', '\U000e0367', '\U000e0368', 
    '\U000e0369', '\U000e036a', '\U000e036b', '\U000e036c', '\U000e036d', '\U000e036e', '\U000e036f', '\U000e0370', 
    '\U000e0371', '\U000e0372', '\U000e0373', '\U000e0374', '\U000e0375', '\U000e0376', '\U000e0377', '\U000e0378', 
    '\U000e0379', '\U000e037a', '\U000e037b', '\U000e037c', '\U000e037d', '\U000e037e', '\U000e037f', '\U000e0380', 
    '\U000e0381', '\U000e0382', '\U000e0383', '\U000e0384', '\U000e0385', '\U000e0386', '\U000e0387', '\U000e0388', 
    '\U000e0389', '\U000e038a', '\U000e038b', '\U000e038c', '\U000e038d', '\U000e038e', '\U000e038f', '\U000e0390', 
    '\U000e0391', '\U000e0392', '\U000e0393', '\U000e0394', '\U000e0395', '\U000e0396', '\U000e0397', '\U000e0398', 
    '\U000e0399', '\U000e039a', '\U000e039b', '\U000e039c', '\U000e039d', '\U000e039e', '\U000e039f', '\U000e03a0', 
    '\U000e03a1', '\U000e03a2', '\U000e03a3', '\U000e03a4', '\U000e03a5', '\U000e03a6', '\U000e03a7', '\U000e03a8', 
    '\U000e03a9', '\U000e03aa', '\U000e03ab', '\U000e03ac', '\U000e03ad', '\U000e03ae', '\U000e03af', '\U000e03b0', 
    '\U000e03b1', '\U000e03b2', '\U000e03b3', '\U000e03b4', '\U000e03b5', '\U000e03b6', '\U000e03b7', '\U000e03b8', 
    '\U000e03b9', '\U000e03ba', '\U000e03bb', '\U000e03bc', '\U000e03bd', '\U000e03be', '\U000e03bf', '\U000e03c0', 
    '\U000e03c1', '\U000e03c2', '\U000e03c3', '\U000e03c4', '\U000e03c5', '\U000e03c6', '\U000e03c7', '\U000e03c8', 
    '\U000e03c9', '\U000e03ca', '\U000e03cb', '\U000e03cc', '\U000e03cd', '\U000e03ce', '\U000e03cf', '\U000e03d0', 
    '\U000e03d1', '\U000e03d2', '\U000e03d3', '\U000e03d4', '\U000e03d5', '\U000e03d6', '\U000e03d7', '\U000e03d8', 
    '\U000e03d9', '\U000e03da', '\U000e03db', '\U000e03dc', '\U000e03dd', '\U000e03de', '\U000e03df', '\U000e03e0', 
    '\U000e03e1', '\U000e03e2', '\U000e03e3', '\U000e03e4', '\U000e03e5', '\U000e03e6', '\U000e03e7', '\U000e03e8', 
    '\U000e03e9', '\U000e03ea', '\U000e03eb', '\U000e03ec', '\U000e03ed', '\U000e03ee', '\U000e03ef', '\U000e03f0', 
    '\U000e03f1', '\U000e03f2', '\U000e03f3', '\U000e03f4', '\U000e03f5', '\U000e03f6', '\U000e03f7', '\U000e03f8', 
    '\U000e03f9', '\U000e03fa', '\U000e03fb', '\U000e03fc', '\U000e03fd', '\U000e03fe', '\U000e03ff', '\U000e0400', 
    '\U000e0401', '\U000e0402', '\U000e0403', '\U000e0404', '\U000e0405', '\U000e0406', '\U000e0407', '\U000e0408', 
    '\U000e0409', '\U000e040a', '\U000e040b', '\U000e040c', '\U000e040d', '\U000e040e', '\U000e040f', '\U000e0410', 
    '\U000e0411', '\U000e0412', '\U000e0413', '\U000e0414', '\U000e0415', '\U000e0416', '\U000e0417', '\U000e0418', 
    '\U000e0419', '\U000e041a', '\U000e041b', '\U000e041c', '\U000e041d', '\U000e041e', '\U000e041f', '\U000e0420', 
    '\U000e0421', '\U000e0422', '\U000e0423', '\U000e0424', '\U000e0425', '\U000e0426', '\U000e0427', '\U000e0428', 
    '\U000e0429', '\U000e042a', '\U000e042b', '\U000e042c', '\U000e042d', '\U000e042e', '\U000e042f', '\U000e0430', 
    '\U000e0431', '\U000e0432', '\U000e0433', '\U000e0434', '\U000e0435', '\U000e0436', '\U000e0437', '\U000e0438', 
    '\U000e0439', '\U000e043a', '\U000e043b', '\U000e043c', '\U000e043d', '\U000e043e', '\U000e043f', '\U000e0440', 
    '\U000e0441', '\U000e0442', '\U000e0443', '\U000e0444', '\U000e0445', '\U000e0446', '\U000e0447', '\U000e0448', 
    '\U000e0449', '\U000e044a', '\U000e044b', '\U000e044c', '\U000e044d', '\U000e044e', '\U000e044f', '\U000e0450', 
    '\U000e0451', '\U000e0452', '\U000e0453', '\U000e0454', '\U000e0455', '\U000e0456', '\U000e0457', '\U000e0458', 
    '\U000e0459', '\U000e045a', '\U000e045b', '\U000e045c', '\U000e045d', '\U000e045e', '\U000e045f', '\U000e0460', 
    '\U000e0461', '\U000e0462', '\U000e0463', '\U000e0464', '\U000e0465', '\U000e0466', '\U000e0467', '\U000e0468', 
    '\U000e0469', '\U000e046a', '\U000e046b', '\U000e046c', '\U000e046d', '\U000e046e', '\U000e046f', '\U000e0470', 
    '\U000e0471', '\U000e0472', '\U000e0473', '\U000e0474', '\U000e0475', '\U000e0476', '\U000e0477', '\U000e0478', 
    '\U000e0479', '\U000e047a', '\U000e047b', '\U000e047c', '\U000e047d', '\U000e047e', '\U000e047f', '\U000e0480', 
    '\U000e0481', '\U000e0482', '\U000e0483', '\U000e0484', '\U000e0485', '\U000e0486', '\U000e0487', '\U000e0488', 
    '\U000e0489', '\U000e048a', '\U000e048b', '\U000e048c', '\U000e048d', '\U000e048e', '\U000e048f', '\U000e0490', 
    '\U000e0491', '\U000e0492', '\U000e0493', '\U000e0494', '\U000e0495', '\U000e0496', '\U000e0497', '\U000e0498', 
    '\U000e0499', '\U000e049a', '\U000e049b', '\U000e049c', '\U000e049d', '\U000e049e', '\U000e049f', '\U000e04a0', 
    '\U000e04a1', '\U000e04a2', '\U000e04a3', '\U000e04a4', '\U000e04a5', '\U000e04a6', '\U000e04a7', '\U000e04a8', 
    '\U000e04a9', '\U000e04aa', '\U000e04ab', '\U000e04ac', '\U000e04ad', '\U000e04ae', '\U000e04af', '\U000e04b0', 
    '\U000e04b1', '\U000e04b2', '\U000e04b3', '\U000e04b4', '\U000e04b5', '\U000e04b6', '\U000e04b7', '\U000e04b8', 
    '\U000e04b9', '\U000e04ba', '\U000e04bb', '\U000e04bc', '\U000e04bd', '\U000e04be', '\U000e04bf', '\U000e04c0', 
    '\U000e04c1', '\U000e04c2', '\U000e04c3', '\U000e04c4', '\U000e04c5', '\U000e04c6', '\U000e04c7', '\U000e04c8', 
    '\U000e04c9', '\U000e04ca', '\U000e04cb', '\U000e04cc', '\U000e04cd', '\U000e04ce', '\U000e04cf', '\U000e04d0', 
    '\U000e04d1', '\U000e04d2', '\U000e04d3', '\U000e04d4', '\U000e04d5', '\U000e04d6', '\U000e04d7', '\U000e04d8', 
    '\U000e04d9', '\U000e04da', '\U000e04db', '\U000e04dc', '\U000e04dd', '\U000e04de', '\U000e04df', '\U000e04e0', 
    '\U000e04e1', '\U000e04e2', '\U000e04e3', '\U000e04e4', '\U000e04e5', '\U000e04e6', '\U000e04e7', '\U000e04e8', 
    '\U000e04e9', '\U000e04ea', '\U000e04eb', '\U000e04ec', '\U000e04ed', '\U000e04ee', '\U000e04ef', '\U000e04f0', 
    '\U000e04f1', '\U000e04f2', '\U000e04f3', '\U000e04f4', '\U000e04f5', '\U000e04f6', '\U000e04f7', '\U000e04f8', 
    '\U000e04f9', '\U000e04fa', '\U000e04fb', '\U000e04fc', '\U000e04fd', '\U000e04fe', '\U000e04ff', '\U000e0500', 
    '\U000e0501', '\U000e0502', '\U000e0503', '\U000e0504', '\U000e0505', '\U000e0506', '\U000e0507', '\U000e0508', 
    '\U000e0509', '\U000e050a', '\U000e050b', '\U000e050c', '\U000e050d', '\U000e050e', '\U000e050f', '\U000e0510', 
    '\U000e0511', '\U000e0512', '\U000e0513', '\U000e0514', '\U000e0515', '\U000e0516', '\U000e0517', '\U000e0518', 
    '\U000e0519', '\U000e051a', '\U000e051b', '\U000e051c', '\U000e051d', '\U000e051e', '\U000e051f', '\U000e0520', 
    '\U000e0521', '\U000e0522', '\U000e0523', '\U000e0524', '\U000e0525', '\U000e0526', '\U000e0527', '\U000e0528', 
    '\U000e0529', '\U000e052a', '\U000e052b', '\U000e052c', '\U000e052d', '\U000e052e', '\U000e052f', '\U000e0530', 
    '\U000e0531', '\U000e0532', '\U000e0533', '\U000e0534', '\U000e0535', '\U000e0536', '\U000e0537', '\U000e0538', 
    '\U000e0539', '\U000e053a', '\U000e053b', '\U000e053c', '\U000e053d', '\U000e053e', '\U000e053f', '\U000e0540', 
    '\U000e0541', '\U000e0542', '\U000e0543', '\U000e0544', '\U000e0545', '\U000e0546', '\U000e0547', '\U000e0548', 
    '\U000e0549', '\U000e054a', '\U000e054b', '\U000e054c', '\U000e054d', '\U000e054e', '\U000e054f', '\U000e0550', 
    '\U000e0551', '\U000e0552', '\U000e0553', '\U000e0554', '\U000e0555', '\U000e0556', '\U000e0557', '\U000e0558', 
    '\U000e0559', '\U000e055a', '\U000e055b', '\U000e055c', '\U000e055d', '\U000e055e', '\U000e055f', '\U000e0560', 
    '\U000e0561', '\U000e0562', '\U000e0563', '\U000e0564', '\U000e0565', '\U000e0566', '\U000e0567', '\U000e0568', 
    '\U000e0569', '\U000e056a', '\U000e056b', '\U000e056c', '\U000e056d', '\U000e056e', '\U000e056f', '\U000e0570', 
    '\U000e0571', '\U000e0572', '\U000e0573', '\U000e0574', '\U000e0575', '\U000e0576', '\U000e0577', '\U000e0578', 
    '\U000e0579', '\U000e057a', '\U000e057b', '\U000e057c', '\U000e057d', '\U000e057e', '\U000e057f', '\U000e0580', 
    '\U000e0581', '\U000e0582', '\U000e0583', '\U000e0584', '\U000e0585', '\U000e0586', '\U000e0587', '\U000e0588', 
    '\U000e0589', '\U000e058a', '\U000e058b', '\U000e058c', '\U000e058d', '\U000e058e', '\U000e058f', '\U000e0590', 
    '\U000e0591', '\U000e0592', '\U000e0593', '\U000e0594', '\U000e0595', '\U000e0596', '\U000e0597', '\U000e0598', 
    '\U000e0599', '\U000e059a', '\U000e059b', '\U000e059c', '\U000e059d', '\U000e059e', '\U000e059f', '\U000e05a0', 
    '\U000e05a1', '\U000e05a2', '\U000e05a3', '\U000e05a4', '\U000e05a5', '\U000e05a6', '\U000e05a7', '\U000e05a8', 
    '\U000e05a9', '\U000e05aa', '\U000e05ab', '\U000e05ac', '\U000e05ad', '\U000e05ae', '\U000e05af', '\U000e05b0', 
    '\U000e05b1', '\U000e05b2', '\U000e05b3', '\U000e05b4', '\U000e05b5', '\U000e05b6', '\U000e05b7', '\U000e05b8', 
    '\U000e05b9', '\U000e05ba', '\U000e05bb', '\U000e05bc', '\U000e05bd', '\U000e05be', '\U000e05bf', '\U000e05c0', 
    '\U000e05c1', '\U000e05c2', '\U000e05c3', '\U000e05c4', '\U000e05c5', '\U000e05c6', '\U000e05c7', '\U000e05c8', 
    '\U000e05c9', '\U000e05ca', '\U000e05cb', '\U000e05cc', '\U000e05cd', '\U000e05ce', '\U000e05cf', '\U000e05d0', 
    '\U000e05d1', '\U000e05d2', '\U000e05d3', '\U000e05d4', '\U000e05d5', '\U000e05d6', '\U000e05d7', '\U000e05d8', 
    '\U000e05d9', '\U000e05da', '\U000e05db', '\U000e05dc', '\U000e05dd', '\U000e05de', '\U000e05df', '\U000e05e0', 
    '\U000e05e1', '\U000e05e2', '\U000e05e3', '\U000e05e4', '\U000e05e5', '\U000e05e6', '\U000e05e7', '\U000e05e8', 
    '\U000e05e9', '\U000e05ea', '\U000e05eb', '\U000e05ec', '\U000e05ed', '\U000e05ee', '\U000e05ef', '\U000e05f0', 
    '\U000e05f1', '\U000e05f2', '\U000e05f3', '\U000e05f4', '\U000e05f5', '\U000e05f6', '\U000e05f7', '\U000e05f8', 
    '\U000e05f9', '\U000e05fa', '\U000e05fb', '\U000e05fc', '\U000e05fd', '\U000e05fe', '\U000e05ff', '\U000e0600', 
    '\U000e0601', '\U000e0602', '\U000e0603', '\U000e0604', '\U000e0605', '\U000e0606', '\U000e0607', '\U000e0608', 
    '\U000e0609', '\U000e060a', '\U000e060b', '\U000e060c', '\U000e060d', '\U000e060e', '\U000e060f', '\U000e0610', 
    '\U000e0611', '\U000e0612', '\U000e0613', '\U000e0614', '\U000e0615', '\U000e0616', '\U000e0617', '\U000e0618', 
    '\U000e0619', '\U000e061a', '\U000e061b', '\U000e061c', '\U000e061d', '\U000e061e', '\U000e061f', '\U000e0620', 
    '\U000e0621', '\U000e0622', '\U000e0623', '\U000e0624', '\U000e0625', '\U000e0626', '\U000e0627', '\U000e0628', 
    '\U000e0629', '\U000e062a', '\U000e062b', '\U000e062c', '\U000e062d', '\U000e062e', '\U000e062f', '\U000e0630', 
    '\U000e0631', '\U000e0632', '\U000e0633', '\U000e0634', '\U000e0635', '\U000e0636', '\U000e0637', '\U000e0638', 
    '\U000e0639', '\U000e063a', '\U000e063b', '\U000e063c', '\U000e063d', '\U000e063e', '\U000e063f', '\U000e0640', 
    '\U000e0641', '\U000e0642', '\U000e0643', '\U000e0644', '\U000e0645', '\U000e0646', '\U000e0647', '\U000e0648', 
    '\U000e0649', '\U000e064a', '\U000e064b', '\U000e064c', '\U000e064d', '\U000e064e', '\U000e064f', '\U000e0650', 
    '\U000e0651', '\U000e0652', '\U000e0653', '\U000e0654', '\U000e0655', '\U000e0656', '\U000e0657', '\U000e0658', 
    '\U000e0659', '\U000e065a', '\U000e065b', '\U000e065c', '\U000e065d', '\U000e065e', '\U000e065f', '\U000e0660', 
    '\U000e0661', '\U000e0662', '\U000e0663', '\U000e0664', '\U000e0665', '\U000e0666', '\U000e0667', '\U000e0668', 
    '\U000e0669', '\U000e066a', '\U000e066b', '\U000e066c', '\U000e066d', '\U000e066e', '\U000e066f', '\U000e0670', 
    '\U000e0671', '\U000e0672', '\U000e0673', '\U000e0674', '\U000e0675', '\U000e0676', '\U000e0677', '\U000e0678', 
    '\U000e0679', '\U000e067a', '\U000e067b', '\U000e067c', '\U000e067d', '\U000e067e', '\U000e067f', '\U000e0680', 
    '\U000e0681', '\U000e0682', '\U000e0683', '\U000e0684', '\U000e0685', '\U000e0686', '\U000e0687', '\U000e0688', 
    '\U000e0689', '\U000e068a', '\U000e068b', '\U000e068c', '\U000e068d', '\U000e068e', '\U000e068f', '\U000e0690', 
    '\U000e0691', '\U000e0692', '\U000e0693', '\U000e0694', '\U000e0695', '\U000e0696', '\U000e0697', '\U000e0698', 
    '\U000e0699', '\U000e069a', '\U000e069b', '\U000e069c', '\U000e069d', '\U000e069e', '\U000e069f', '\U000e06a0', 
    '\U000e06a1', '\U000e06a2', '\U000e06a3', '\U000e06a4', '\U000e06a5', '\U000e06a6', '\U000e06a7', '\U000e06a8', 
    '\U000e06a9', '\U000e06aa', '\U000e06ab', '\U000e06ac', '\U000e06ad', '\U000e06ae', '\U000e06af', '\U000e06b0', 
    '\U000e06b1', '\U000e06b2', '\U000e06b3', '\U000e06b4', '\U000e06b5', '\U000e06b6', '\U000e06b7', '\U000e06b8', 
    '\U000e06b9', '\U000e06ba', '\U000e06bb', '\U000e06bc', '\U000e06bd', '\U000e06be', '\U000e06bf', '\U000e06c0', 
    '\U000e06c1', '\U000e06c2', '\U000e06c3', '\U000e06c4', '\U000e06c5', '\U000e06c6', '\U000e06c7', '\U000e06c8', 
    '\U000e06c9', '\U000e06ca', '\U000e06cb', '\U000e06cc', '\U000e06cd', '\U000e06ce', '\U000e06cf', '\U000e06d0', 
    '\U000e06d1', '\U000e06d2', '\U000e06d3', '\U000e06d4', '\U000e06d5', '\U000e06d6', '\U000e06d7', '\U000e06d8', 
    '\U000e06d9', '\U000e06da', '\U000e06db', '\U000e06dc', '\U000e06dd', '\U000e06de', '\U000e06df', '\U000e06e0', 
    '\U000e06e1', '\U000e06e2', '\U000e06e3', '\U000e06e4', '\U000e06e5', '\U000e06e6', '\U000e06e7', '\U000e06e8', 
    '\U000e06e9', '\U000e06ea', '\U000e06eb', '\U000e06ec', '\U000e06ed', '\U000e06ee', '\U000e06ef', '\U000e06f0', 
    '\U000e06f1', '\U000e06f2', '\U000e06f3', '\U000e06f4', '\U000e06f5', '\U000e06f6', '\U000e06f7', '\U000e06f8', 
    '\U000e06f9', '\U000e06fa', '\U000e06fb', '\U000e06fc', '\U000e06fd', '\U000e06fe', '\U000e06ff', '\U000e0700', 
    '\U000e0701', '\U000e0702', '\U000e0703', '\U000e0704', '\U000e0705', '\U000e0706', '\U000e0707', '\U000e0708', 
    '\U000e0709', '\U000e070a', '\U000e070b', '\U000e070c', '\U000e070d', '\U000e070e', '\U000e070f', '\U000e0710', 
    '\U000e0711', '\U000e0712', '\U000e0713', '\U000e0714', '\U000e0715', '\U000e0716', '\U000e0717', '\U000e0718', 
    '\U000e0719', '\U000e071a', '\U000e071b', '\U000e071c', '\U000e071d', '\U000e071e', '\U000e071f', '\U000e0720', 
    '\U000e0721', '\U000e0722', '\U000e0723', '\U000e0724', '\U000e0725', '\U000e0726', '\U000e0727', '\U000e0728', 
    '\U000e0729', '\U000e072a', '\U000e072b', '\U000e072c', '\U000e072d', '\U000e072e', '\U000e072f', '\U000e0730', 
    '\U000e0731', '\U000e0732', '\U000e0733', '\U000e0734', '\U000e0735', '\U000e0736', '\U000e0737', '\U000e0738', 
    '\U000e0739', '\U000e073a', '\U000e073b', '\U000e073c', '\U000e073d', '\U000e073e', '\U000e073f', '\U000e0740', 
    '\U000e0741', '\U000e0742', '\U000e0743', '\U000e0744', '\U000e0745', '\U000e0746', '\U000e0747', '\U000e0748', 
    '\U000e0749', '\U000e074a', '\U000e074b', '\U000e074c', '\U000e074d', '\U000e074e', '\U000e074f', '\U000e0750', 
    '\U000e0751', '\U000e0752', '\U000e0753', '\U000e0754', '\U000e0755', '\U000e0756', '\U000e0757', '\U000e0758', 
    '\U000e0759', '\U000e075a', '\U000e075b', '\U000e075c', '\U000e075d', '\U000e075e', '\U000e075f', '\U000e0760', 
    '\U000e0761', '\U000e0762', '\U000e0763', '\U000e0764', '\U000e0765', '\U000e0766', '\U000e0767', '\U000e0768', 
    '\U000e0769', '\U000e076a', '\U000e076b', '\U000e076c', '\U000e076d', '\U000e076e', '\U000e076f', '\U000e0770', 
    '\U000e0771', '\U000e0772', '\U000e0773', '\U000e0774', '\U000e0775', '\U000e0776', '\U000e0777', '\U000e0778', 
    '\U000e0779', '\U000e077a', '\U000e077b', '\U000e077c', '\U000e077d', '\U000e077e', '\U000e077f', '\U000e0780', 
    '\U000e0781', '\U000e0782', '\U000e0783', '\U000e0784', '\U000e0785', '\U000e0786', '\U000e0787', '\U000e0788', 
    '\U000e0789', '\U000e078a', '\U000e078b', '\U000e078c', '\U000e078d', '\U000e078e', '\U000e078f', '\U000e0790', 
    '\U000e0791', '\U000e0792', '\U000e0793', '\U000e0794', '\U000e0795', '\U000e0796', '\U000e0797', '\U000e0798', 
    '\U000e0799', '\U000e079a', '\U000e079b', '\U000e079c', '\U000e079d', '\U000e079e', '\U000e079f', '\U000e07a0', 
    '\U000e07a1', '\U000e07a2', '\U000e07a3', '\U000e07a4', '\U000e07a5', '\U000e07a6', '\U000e07a7', '\U000e07a8', 
    '\U000e07a9', '\U000e07aa', '\U000e07ab', '\U000e07ac', '\U000e07ad', '\U000e07ae', '\U000e07af', '\U000e07b0', 
    '\U000e07b1', '\U000e07b2', '\U000e07b3', '\U000e07b4', '\U000e07b5', '\U000e07b6', '\U000e07b7', '\U000e07b8', 
    '\U000e07b9', '\U000e07ba', '\U000e07bb', '\U000e07bc', '\U000e07bd', '\U000e07be', '\U000e07bf', '\U000e07c0', 
    '\U000e07c1', '\U000e07c2', '\U000e07c3', '\U000e07c4', '\U000e07c5', '\U000e07c6', '\U000e07c7', '\U000e07c8', 
    '\U000e07c9', '\U000e07ca', '\U000e07cb', '\U000e07cc', '\U000e07cd', '\U000e07ce', '\U000e07cf', '\U000e07d0', 
    '\U000e07d1', '\U000e07d2', '\U000e07d3', '\U000e07d4', '\U000e07d5', '\U000e07d6', '\U000e07d7', '\U000e07d8', 
    '\U000e07d9', '\U000e07da', '\U000e07db', '\U000e07dc', '\U000e07dd', '\U000e07de', '\U000e07df', '\U000e07e0', 
    '\U000e07e1', '\U000e07e2', '\U000e07e3', '\U000e07e4', '\U000e07e5', '\U000e07e6', '\U000e07e7', '\U000e07e8', 
    '\U000e07e9', '\U000e07ea', '\U000e07eb', '\U000e07ec', '\U000e07ed', '\U000e07ee', '\U000e07ef', '\U000e07f0', 
    '\U000e07f1', '\U000e07f2', '\U000e07f3', '\U000e07f4', '\U000e07f5', '\U000e07f6', '\U000e07f7', '\U000e07f8', 
    '\U000e07f9', '\U000e07fa', '\U000e07fb', '\U000e07fc', '\U000e07fd', '\U000e07fe', '\U000e07ff', '\U000e0800', 
    '\U000e0801', '\U000e0802', '\U000e0803', '\U000e0804', '\U000e0805', '\U000e0806', '\U000e0807', '\U000e0808', 
    '\U000e0809', '\U000e080a', '\U000e080b', '\U000e080c', '\U000e080d', '\U000e080e', '\U000e080f', '\U000e0810', 
    '\U000e0811', '\U000e0812', '\U000e0813', '\U000e0814', '\U000e0815', '\U000e0816', '\U000e0817', '\U000e0818', 
    '\U000e0819', '\U000e081a', '\U000e081b', '\U000e081c', '\U000e081d', '\U000e081e', '\U000e081f', '\U000e0820', 
    '\U000e0821', '\U000e0822', '\U000e0823', '\U000e0824', '\U000e0825', '\U000e0826', '\U000e0827', '\U000e0828', 
    '\U000e0829', '\U000e082a', '\U000e082b', '\U000e082c', '\U000e082d', '\U000e082e', '\U000e082f', '\U000e0830', 
    '\U000e0831', '\U000e0832', '\U000e0833', '\U000e0834', '\U000e0835', '\U000e0836', '\U000e0837', '\U000e0838', 
    '\U000e0839', '\U000e083a', '\U000e083b', '\U000e083c', '\U000e083d', '\U000e083e', '\U000e083f', '\U000e0840', 
    '\U000e0841', '\U000e0842', '\U000e0843', '\U000e0844', '\U000e0845', '\U000e0846', '\U000e0847', '\U000e0848', 
    '\U000e0849', '\U000e084a', '\U000e084b', '\U000e084c', '\U000e084d', '\U000e084e', '\U000e084f', '\U000e0850', 
    '\U000e0851', '\U000e0852', '\U000e0853', '\U000e0854', '\U000e0855', '\U000e0856', '\U000e0857', '\U000e0858', 
    '\U000e0859', '\U000e085a', '\U000e085b', '\U000e085c', '\U000e085d', '\U000e085e', '\U000e085f', '\U000e0860', 
    '\U000e0861', '\U000e0862', '\U000e0863', '\U000e0864', '\U000e0865', '\U000e0866', '\U000e0867', '\U000e0868', 
    '\U000e0869', '\U000e086a', '\U000e086b', '\U000e086c', '\U000e086d', '\U000e086e', '\U000e086f', '\U000e0870', 
    '\U000e0871', '\U000e0872', '\U000e0873', '\U000e0874', '\U000e0875', '\U000e0876', '\U000e0877', '\U000e0878', 
    '\U000e0879', '\U000e087a', '\U000e087b', '\U000e087c', '\U000e087d', '\U000e087e', '\U000e087f', '\U000e0880', 
    '\U000e0881', '\U000e0882', '\U000e0883', '\U000e0884', '\U000e0885', '\U000e0886', '\U000e0887', '\U000e0888', 
    '\U000e0889', '\U000e088a', '\U000e088b', '\U000e088c', '\U000e088d', '\U000e088e', '\U000e088f', '\U000e0890', 
    '\U000e0891', '\U000e0892', '\U000e0893', '\U000e0894', '\U000e0895', '\U000e0896', '\U000e0897', '\U000e0898', 
    '\U000e0899', '\U000e089a', '\U000e089b', '\U000e089c', '\U000e089d', '\U000e089e', '\U000e089f', '\U000e08a0', 
    '\U000e08a1', '\U000e08a2', '\U000e08a3', '\U000e08a4', '\U000e08a5', '\U000e08a6', '\U000e08a7', '\U000e08a8', 
    '\U000e08a9', '\U000e08aa', '\U000e08ab', '\U000e08ac', '\U000e08ad', '\U000e08ae', '\U000e08af', '\U000e08b0', 
    '\U000e08b1', '\U000e08b2', '\U000e08b3', '\U000e08b4', '\U000e08b5', '\U000e08b6', '\U000e08b7', '\U000e08b8', 
    '\U000e08b9', '\U000e08ba', '\U000e08bb', '\U000e08bc', '\U000e08bd', '\U000e08be', '\U000e08bf', '\U000e08c0', 
    '\U000e08c1', '\U000e08c2', '\U000e08c3', '\U000e08c4', '\U000e08c5', '\U000e08c6', '\U000e08c7', '\U000e08c8', 
    '\U000e08c9', '\U000e08ca', '\U000e08cb', '\U000e08cc', '\U000e08cd', '\U000e08ce', '\U000e08cf', '\U000e08d0', 
    '\U000e08d1', '\U000e08d2', '\U000e08d3', '\U000e08d4', '\U000e08d5', '\U000e08d6', '\U000e08d7', '\U000e08d8', 
    '\U000e08d9', '\U000e08da', '\U000e08db', '\U000e08dc', '\U000e08dd', '\U000e08de', '\U000e08df', '\U000e08e0', 
    '\U000e08e1', '\U000e08e2', '\U000e08e3', '\U000e08e4', '\U000e08e5', '\U000e08e6', '\U000e08e7', '\U000e08e8', 
    '\U000e08e9', '\U000e08ea', '\U000e08eb', '\U000e08ec', '\U000e08ed', '\U000e08ee', '\U000e08ef', '\U000e08f0', 
    '\U000e08f1', '\U000e08f2', '\U000e08f3', '\U000e08f4', '\U000e08f5', '\U000e08f6', '\U000e08f7', '\U000e08f8', 
    '\U000e08f9', '\U000e08fa', '\U000e08fb', '\U000e08fc', '\U000e08fd', '\U000e08fe', '\U000e08ff', '\U000e0900', 
    '\U000e0901', '\U000e0902', '\U000e0903', '\U000e0904', '\U000e0905', '\U000e0906', '\U000e0907', '\U000e0908', 
    '\U000e0909', '\U000e090a', '\U000e090b', '\U000e090c', '\U000e090d', '\U000e090e', '\U000e090f', '\U000e0910', 
    '\U000e0911', '\U000e0912', '\U000e0913', '\U000e0914', '\U000e0915', '\U000e0916', '\U000e0917', '\U000e0918', 
    '\U000e0919', '\U000e091a', '\U000e091b', '\U000e091c', '\U000e091d', '\U000e091e', '\U000e091f', '\U000e0920', 
    '\U000e0921', '\U000e0922', '\U000e0923', '\U000e0924', '\U000e0925', '\U000e0926', '\U000e0927', '\U000e0928', 
    '\U000e0929', '\U000e092a', '\U000e092b', '\U000e092c', '\U000e092d', '\U000e092e', '\U000e092f', '\U000e0930', 
    '\U000e0931', '\U000e0932', '\U000e0933', '\U000e0934', '\U000e0935', '\U000e0936', '\U000e0937', '\U000e0938', 
    '\U000e0939', '\U000e093a', '\U000e093b', '\U000e093c', '\U000e093d', '\U000e093e', '\U000e093f', '\U000e0940', 
    '\U000e0941', '\U000e0942', '\U000e0943', '\U000e0944', '\U000e0945', '\U000e0946', '\U000e0947', '\U000e0948', 
    '\U000e0949', '\U000e094a', '\U000e094b', '\U000e094c', '\U000e094d', '\U000e094e', '\U000e094f', '\U000e0950', 
    '\U000e0951', '\U000e0952', '\U000e0953', '\U000e0954', '\U000e0955', '\U000e0956', '\U000e0957', '\U000e0958', 
    '\U000e0959', '\U000e095a', '\U000e095b', '\U000e095c', '\U000e095d', '\U000e095e', '\U000e095f', '\U000e0960', 
    '\U000e0961', '\U000e0962', '\U000e0963', '\U000e0964', '\U000e0965', '\U000e0966', '\U000e0967', '\U000e0968', 
    '\U000e0969', '\U000e096a', '\U000e096b', '\U000e096c', '\U000e096d', '\U000e096e', '\U000e096f', '\U000e0970', 
    '\U000e0971', '\U000e0972', '\U000e0973', '\U000e0974', '\U000e0975', '\U000e0976', '\U000e0977', '\U000e0978', 
    '\U000e0979', '\U000e097a', '\U000e097b', '\U000e097c', '\U000e097d', '\U000e097e', '\U000e097f', '\U000e0980', 
    '\U000e0981', '\U000e0982', '\U000e0983', '\U000e0984', '\U000e0985', '\U000e0986', '\U000e0987', '\U000e0988', 
    '\U000e0989', '\U000e098a', '\U000e098b', '\U000e098c', '\U000e098d', '\U000e098e', '\U000e098f', '\U000e0990', 
    '\U000e0991', '\U000e0992', '\U000e0993', '\U000e0994', '\U000e0995', '\U000e0996', '\U000e0997', '\U000e0998', 
    '\U000e0999', '\U000e099a', '\U000e099b', '\U000e099c', '\U000e099d', '\U000e099e', '\U000e099f', '\U000e09a0', 
    '\U000e09a1', '\U000e09a2', '\U000e09a3', '\U000e09a4', '\U000e09a5', '\U000e09a6', '\U000e09a7', '\U000e09a8', 
    '\U000e09a9', '\U000e09aa', '\U000e09ab', '\U000e09ac', '\U000e09ad', '\U000e09ae', '\U000e09af', '\U000e09b0', 
    '\U000e09b1', '\U000e09b2', '\U000e09b3', '\U000e09b4', '\U000e09b5', '\U000e09b6', '\U000e09b7', '\U000e09b8', 
    '\U000e09b9', '\U000e09ba', '\U000e09bb', '\U000e09bc', '\U000e09bd', '\U000e09be', '\U000e09bf', '\U000e09c0', 
    '\U000e09c1', '\U000e09c2', '\U000e09c3', '\U000e09c4', '\U000e09c5', '\U000e09c6', '\U000e09c7', '\U000e09c8', 
    '\U000e09c9', '\U000e09ca', '\U000e09cb', '\U000e09cc', '\U000e09cd', '\U000e09ce', '\U000e09cf', '\U000e09d0', 
    '\U000e09d1', '\U000e09d2', '\U000e09d3', '\U000e09d4', '\U000e09d5', '\U000e09d6', '\U000e09d7', '\U000e09d8', 
    '\U000e09d9', '\U000e09da', '\U000e09db', '\U000e09dc', '\U000e09dd', '\U000e09de', '\U000e09df', '\U000e09e0', 
    '\U000e09e1', '\U000e09e2', '\U000e09e3', '\U000e09e4', '\U000e09e5', '\U000e09e6', '\U000e09e7', '\U000e09e8', 
    '\U000e09e9', '\U000e09ea', '\U000e09eb', '\U000e09ec', '\U000e09ed', '\U000e09ee', '\U000e09ef', '\U000e09f0', 
    '\U000e09f1', '\U000e09f2', '\U000e09f3', '\U000e09f4', '\U000e09f5', '\U000e09f6', '\U000e09f7', '\U000e09f8', 
    '\U000e09f9', '\U000e09fa', '\U000e09fb', '\U000e09fc', '\U000e09fd', '\U000e09fe', '\U000e09ff', '\U000e0a00', 
    '\U000e0a01', '\U000e0a02', '\U000e0a03', '\U000e0a04', '\U000e0a05', '\U000e0a06', '\U000e0a07', '\U000e0a08', 
    '\U000e0a09', '\U000e0a0a', '\U000e0a0b', '\U000e0a0c', '\U000e0a0d', '\U000e0a0e', '\U000e0a0f', '\U000e0a10', 
    '\U000e0a11', '\U000e0a12', '\U000e0a13', '\U000e0a14', '\U000e0a15', '\U000e0a16', '\U000e0a17', '\U000e0a18', 
    '\U000e0a19', '\U000e0a1a', '\U000e0a1b', '\U000e0a1c', '\U000e0a1d', '\U000e0a1e', '\U000e0a1f', '\U000e0a20', 
    '\U000e0a21', '\U000e0a22', '\U000e0a23', '\U000e0a24', '\U000e0a25', '\U000e0a26', '\U000e0a27', '\U000e0a28', 
    '\U000e0a29', '\U000e0a2a', '\U000e0a2b', '\U000e0a2c', '\U000e0a2d', '\U000e0a2e', '\U000e0a2f', '\U000e0a30', 
    '\U000e0a31', '\U000e0a32', '\U000e0a33', '\U000e0a34', '\U000e0a35', '\U000e0a36', '\U000e0a37', '\U000e0a38', 
    '\U000e0a39', '\U000e0a3a', '\U000e0a3b', '\U000e0a3c', '\U000e0a3d', '\U000e0a3e', '\U000e0a3f', '\U000e0a40', 
    '\U000e0a41', '\U000e0a42', '\U000e0a43', '\U000e0a44', '\U000e0a45', '\U000e0a46', '\U000e0a47', '\U000e0a48', 
    '\U000e0a49', '\U000e0a4a', '\U000e0a4b', '\U000e0a4c', '\U000e0a4d', '\U000e0a4e', '\U000e0a4f', '\U000e0a50', 
    '\U000e0a51', '\U000e0a52', '\U000e0a53', '\U000e0a54', '\U000e0a55', '\U000e0a56', '\U000e0a57', '\U000e0a58', 
    '\U000e0a59', '\U000e0a5a', '\U000e0a5b', '\U000e0a5c', '\U000e0a5d', '\U000e0a5e', '\U000e0a5f', '\U000e0a60', 
    '\U000e0a61', '\U000e0a62', '\U000e0a63', '\U000e0a64', '\U000e0a65', '\U000e0a66', '\U000e0a67', '\U000e0a68', 
    '\U000e0a69', '\U000e0a6a', '\U000e0a6b', '\U000e0a6c', '\U000e0a6d', '\U000e0a6e', '\U000e0a6f', '\U000e0a70', 
    '\U000e0a71', '\U000e0a72', '\U000e0a73', '\U000e0a74', '\U000e0a75', '\U000e0a76', '\U000e0a77', '\U000e0a78', 
    '\U000e0a79', '\U000e0a7a', '\U000e0a7b', '\U000e0a7c', '\U000e0a7d', '\U000e0a7e', '\U000e0a7f', '\U000e0a80', 
    '\U000e0a81', '\U000e0a82', '\U000e0a83', '\U000e0a84', '\U000e0a85', '\U000e0a86', '\U000e0a87', '\U000e0a88', 
    '\U000e0a89', '\U000e0a8a', '\U000e0a8b', '\U000e0a8c', '\U000e0a8d', '\U000e0a8e', '\U000e0a8f', '\U000e0a90', 
    '\U000e0a91', '\U000e0a92', '\U000e0a93', '\U000e0a94', '\U000e0a95', '\U000e0a96', '\U000e0a97', '\U000e0a98', 
    '\U000e0a99', '\U000e0a9a', '\U000e0a9b', '\U000e0a9c', '\U000e0a9d', '\U000e0a9e', '\U000e0a9f', '\U000e0aa0', 
    '\U000e0aa1', '\U000e0aa2', '\U000e0aa3', '\U000e0aa4', '\U000e0aa5', '\U000e0aa6', '\U000e0aa7', '\U000e0aa8', 
    '\U000e0aa9', '\U000e0aaa', '\U000e0aab', '\U000e0aac', '\U000e0aad', '\U000e0aae', '\U000e0aaf', '\U000e0ab0', 
    '\U000e0ab1', '\U000e0ab2', '\U000e0ab3', '\U000e0ab4', '\U000e0ab5', '\U000e0ab6', '\U000e0ab7', '\U000e0ab8', 
    '\U000e0ab9', '\U000e0aba', '\U000e0abb', '\U000e0abc', '\U000e0abd', '\U000e0abe', '\U000e0abf', '\U000e0ac0', 
    '\U000e0ac1', '\U000e0ac2', '\U000e0ac3', '\U000e0ac4', '\U000e0ac5', '\U000e0ac6', '\U000e0ac7', '\U000e0ac8', 
    '\U000e0ac9', '\U000e0aca', '\U000e0acb', '\U000e0acc', '\U000e0acd', '\U000e0ace', '\U000e0acf', '\U000e0ad0', 
    '\U000e0ad1', '\U000e0ad2', '\U000e0ad3', '\U000e0ad4', '\U000e0ad5', '\U000e0ad6', '\U000e0ad7', '\U000e0ad8', 
    '\U000e0ad9', '\U000e0ada', '\U000e0adb', '\U000e0adc', '\U000e0add', '\U000e0ade', '\U000e0adf', '\U000e0ae0', 
    '\U000e0ae1', '\U000e0ae2', '\U000e0ae3', '\U000e0ae4', '\U000e0ae5', '\U000e0ae6', '\U000e0ae7', '\U000e0ae8', 
    '\U000e0ae9', '\U000e0aea', '\U000e0aeb', '\U000e0aec', '\U000e0aed', '\U000e0aee', '\U000e0aef', '\U000e0af0', 
    '\U000e0af1', '\U000e0af2', '\U000e0af3', '\U000e0af4', '\U000e0af5', '\U000e0af6', '\U000e0af7', '\U000e0af8', 
    '\U000e0af9', '\U000e0afa', '\U000e0afb', '\U000e0afc', '\U000e0afd', '\U000e0afe', '\U000e0aff', '\U000e0b00', 
    '\U000e0b01', '\U000e0b02', '\U000e0b03', '\U000e0b04', '\U000e0b05', '\U000e0b06', '\U000e0b07', '\U000e0b08', 
    '\U000e0b09', '\U000e0b0a', '\U000e0b0b', '\U000e0b0c', '\U000e0b0d', '\U000e0b0e', '\U000e0b0f', '\U000e0b10', 
    '\U000e0b11', '\U000e0b12', '\U000e0b13', '\U000e0b14', '\U000e0b15', '\U000e0b16', '\U000e0b17', '\U000e0b18', 
    '\U000e0b19', '\U000e0b1a', '\U000e0b1b', '\U000e0b1c', '\U000e0b1d', '\U000e0b1e', '\U000e0b1f', '\U000e0b20', 
    '\U000e0b21', '\U000e0b22', '\U000e0b23', '\U000e0b24', '\U000e0b25', '\U000e0b26', '\U000e0b27', '\U000e0b28', 
    '\U000e0b29', '\U000e0b2a', '\U000e0b2b', '\U000e0b2c', '\U000e0b2d', '\U000e0b2e', '\U000e0b2f', '\U000e0b30', 
    '\U000e0b31', '\U000e0b32', '\U000e0b33', '\U000e0b34', '\U000e0b35', '\U000e0b36', '\U000e0b37', '\U000e0b38', 
    '\U000e0b39', '\U000e0b3a', '\U000e0b3b', '\U000e0b3c', '\U000e0b3d', '\U000e0b3e', '\U000e0b3f', '\U000e0b40', 
    '\U000e0b41', '\U000e0b42', '\U000e0b43', '\U000e0b44', '\U000e0b45', '\U000e0b46', '\U000e0b47', '\U000e0b48', 
    '\U000e0b49', '\U000e0b4a', '\U000e0b4b', '\U000e0b4c', '\U000e0b4d', '\U000e0b4e', '\U000e0b4f', '\U000e0b50', 
    '\U000e0b51', '\U000e0b52', '\U000e0b53', '\U000e0b54', '\U000e0b55', '\U000e0b56', '\U000e0b57', '\U000e0b58', 
    '\U000e0b59', '\U000e0b5a', '\U000e0b5b', '\U000e0b5c', '\U000e0b5d', '\U000e0b5e', '\U000e0b5f', '\U000e0b60', 
    '\U000e0b61', '\U000e0b62', '\U000e0b63', '\U000e0b64', '\U000e0b65', '\U000e0b66', '\U000e0b67', '\U000e0b68', 
    '\U000e0b69', '\U000e0b6a', '\U000e0b6b', '\U000e0b6c', '\U000e0b6d', '\U000e0b6e', '\U000e0b6f', '\U000e0b70', 
    '\U000e0b71', '\U000e0b72', '\U000e0b73', '\U000e0b74', '\U000e0b75', '\U000e0b76', '\U000e0b77', '\U000e0b78', 
    '\U000e0b79', '\U000e0b7a', '\U000e0b7b', '\U000e0b7c', '\U000e0b7d', '\U000e0b7e', '\U000e0b7f', '\U000e0b80', 
    '\U000e0b81', '\U000e0b82', '\U000e0b83', '\U000e0b84', '\U000e0b85', '\U000e0b86', '\U000e0b87', '\U000e0b88', 
    '\U000e0b89', '\U000e0b8a', '\U000e0b8b', '\U000e0b8c', '\U000e0b8d', '\U000e0b8e', '\U000e0b8f', '\U000e0b90', 
    '\U000e0b91', '\U000e0b92', '\U000e0b93', '\U000e0b94', '\U000e0b95', '\U000e0b96', '\U000e0b97', '\U000e0b98', 
    '\U000e0b99', '\U000e0b9a', '\U000e0b9b', '\U000e0b9c', '\U000e0b9d', '\U000e0b9e', '\U000e0b9f', '\U000e0ba0', 
    '\U000e0ba1', '\U000e0ba2', '\U000e0ba3', '\U000e0ba4', '\U000e0ba5', '\U000e0ba6', '\U000e0ba7', '\U000e0ba8', 
    '\U000e0ba9', '\U000e0baa', '\U000e0bab', '\U000e0bac', '\U000e0bad', '\U000e0bae', '\U000e0baf', '\U000e0bb0', 
    '\U000e0bb1', '\U000e0bb2', '\U000e0bb3', '\U000e0bb4', '\U000e0bb5', '\U000e0bb6', '\U000e0bb7', '\U000e0bb8', 
    '\U000e0bb9', '\U000e0bba', '\U000e0bbb', '\U000e0bbc', '\U000e0bbd', '\U000e0bbe', '\U000e0bbf', '\U000e0bc0', 
    '\U000e0bc1', '\U000e0bc2', '\U000e0bc3', '\U000e0bc4', '\U000e0bc5', '\U000e0bc6', '\U000e0bc7', '\U000e0bc8', 
    '\U000e0bc9', '\U000e0bca', '\U000e0bcb', '\U000e0bcc', '\U000e0bcd', '\U000e0bce', '\U000e0bcf', '\U000e0bd0', 
    '\U000e0bd1', '\U000e0bd2', '\U000e0bd3', '\U000e0bd4', '\U000e0bd5', '\U000e0bd6', '\U000e0bd7', '\U000e0bd8', 
    '\U000e0bd9', '\U000e0bda', '\U000e0bdb', '\U000e0bdc', '\U000e0bdd', '\U000e0bde', '\U000e0bdf', '\U000e0be0', 
    '\U000e0be1', '\U000e0be2', '\U000e0be3', '\U000e0be4', '\U000e0be5', '\U000e0be6', '\U000e0be7', '\U000e0be8', 
    '\U000e0be9', '\U000e0bea', '\U000e0beb', '\U000e0bec', '\U000e0bed', '\U000e0bee', '\U000e0bef', '\U000e0bf0', 
    '\U000e0bf1', '\U000e0bf2', '\U000e0bf3', '\U000e0bf4', '\U000e0bf5', '\U000e0bf6', '\U000e0bf7', '\U000e0bf8', 
    '\U000e0bf9', '\U000e0bfa', '\U000e0bfb', '\U000e0bfc', '\U000e0bfd', '\U000e0bfe', '\U000e0bff', '\U000e0c00', 
    '\U000e0c01', '\U000e0c02', '\U000e0c03', '\U000e0c04', '\U000e0c05', '\U000e0c06', '\U000e0c07', '\U000e0c08', 
    '\U000e0c09', '\U000e0c0a', '\U000e0c0b', '\U000e0c0c', '\U000e0c0d', '\U000e0c0e', '\U000e0c0f', '\U000e0c10', 
    '\U000e0c11', '\U000e0c12', '\U000e0c13', '\U000e0c14', '\U000e0c15', '\U000e0c16', '\U000e0c17', '\U000e0c18', 
    '\U000e0c19', '\U000e0c1a', '\U000e0c1b', '\U000e0c1c', '\U000e0c1d', '\U000e0c1e', '\U000e0c1f', '\U000e0c20', 
    '\U000e0c21', '\U000e0c22', '\U000e0c23', '\U000e0c24', '\U000e0c25', '\U000e0c26', '\U000e0c27', '\U000e0c28', 
    '\U000e0c29', '\U000e0c2a', '\U000e0c2b', '\U000e0c2c', '\U000e0c2d', '\U000e0c2e', '\U000e0c2f', '\U000e0c30', 
    '\U000e0c31', '\U000e0c32', '\U000e0c33', '\U000e0c34', '\U000e0c35', '\U000e0c36', '\U000e0c37', '\U000e0c38', 
    '\U000e0c39', '\U000e0c3a', '\U000e0c3b', '\U000e0c3c', '\U000e0c3d', '\U000e0c3e', '\U000e0c3f', '\U000e0c40', 
    '\U000e0c41', '\U000e0c42', '\U000e0c43', '\U000e0c44', '\U000e0c45', '\U000e0c46', '\U000e0c47', '\U000e0c48', 
    '\U000e0c49', '\U000e0c4a', '\U000e0c4b', '\U000e0c4c', '\U000e0c4d', '\U000e0c4e', '\U000e0c4f', '\U000e0c50', 
    '\U000e0c51', '\U000e0c52', '\U000e0c53', '\U000e0c54', '\U000e0c55', '\U000e0c56', '\U000e0c57', '\U000e0c58', 
    '\U000e0c59', '\U000e0c5a', '\U000e0c5b', '\U000e0c5c', '\U000e0c5d', '\U000e0c5e', '\U000e0c5f', '\U000e0c60', 
    '\U000e0c61', '\U000e0c62', '\U000e0c63', '\U000e0c64', '\U000e0c65', '\U000e0c66', '\U000e0c67', '\U000e0c68', 
    '\U000e0c69', '\U000e0c6a', '\U000e0c6b', '\U000e0c6c', '\U000e0c6d', '\U000e0c6e', '\U000e0c6f', '\U000e0c70', 
    '\U000e0c71', '\U000e0c72', '\U000e0c73', '\U000e0c74', '\U000e0c75', '\U000e0c76', '\U000e0c77', '\U000e0c78', 
    '\U000e0c79', '\U000e0c7a', '\U000e0c7b', '\U000e0c7c', '\U000e0c7d', '\U000e0c7e', '\U000e0c7f', '\U000e0c80', 
    '\U000e0c81', '\U000e0c82', '\U000e0c83', '\U000e0c84', '\U000e0c85', '\U000e0c86', '\U000e0c87', '\U000e0c88', 
    '\U000e0c89', '\U000e0c8a', '\U000e0c8b', '\U000e0c8c', '\U000e0c8d', '\U000e0c8e', '\U000e0c8f', '\U000e0c90', 
    '\U000e0c91', '\U000e0c92', '\U000e0c93', '\U000e0c94', '\U000e0c95', '\U000e0c96', '\U000e0c97', '\U000e0c98', 
    '\U000e0c99', '\U000e0c9a', '\U000e0c9b', '\U000e0c9c', '\U000e0c9d', '\U000e0c9e', '\U000e0c9f', '\U000e0ca0', 
    '\U000e0ca1', '\U000e0ca2', '\U000e0ca3', '\U000e0ca4', '\U000e0ca5', '\U000e0ca6', '\U000e0ca7', '\U000e0ca8', 
    '\U000e0ca9', '\U000e0caa', '\U000e0cab', '\U000e0cac', '\U000e0cad', '\U000e0cae', '\U000e0caf', '\U000e0cb0', 
    '\U000e0cb1', '\U000e0cb2', '\U000e0cb3', '\U000e0cb4', '\U000e0cb5', '\U000e0cb6', '\U000e0cb7', '\U000e0cb8', 
    '\U000e0cb9', '\U000e0cba', '\U000e0cbb', '\U000e0cbc', '\U000e0cbd', '\U000e0cbe', '\U000e0cbf', '\U000e0cc0', 
    '\U000e0cc1', '\U000e0cc2', '\U000e0cc3', '\U000e0cc4', '\U000e0cc5', '\U000e0cc6', '\U000e0cc7', '\U000e0cc8', 
    '\U000e0cc9', '\U000e0cca', '\U000e0ccb', '\U000e0ccc', '\U000e0ccd', '\U000e0cce', '\U000e0ccf', '\U000e0cd0', 
    '\U000e0cd1', '\U000e0cd2', '\U000e0cd3', '\U000e0cd4', '\U000e0cd5', '\U000e0cd6', '\U000e0cd7', '\U000e0cd8', 
    '\U000e0cd9', '\U000e0cda', '\U000e0cdb', '\U000e0cdc', '\U000e0cdd', '\U000e0cde', '\U000e0cdf', '\U000e0ce0', 
    '\U000e0ce1', '\U000e0ce2', '\U000e0ce3', '\U000e0ce4', '\U000e0ce5', '\U000e0ce6', '\U000e0ce7', '\U000e0ce8', 
    '\U000e0ce9', '\U000e0cea', '\U000e0ceb', '\U000e0cec', '\U000e0ced', '\U000e0cee', '\U000e0cef', '\U000e0cf0', 
    '\U000e0cf1', '\U000e0cf2', '\U000e0cf3', '\U000e0cf4', '\U000e0cf5', '\U000e0cf6', '\U000e0cf7', '\U000e0cf8', 
    '\U000e0cf9', '\U000e0cfa', '\U000e0cfb', '\U000e0cfc', '\U000e0cfd', '\U000e0cfe', '\U000e0cff', '\U000e0d00', 
    '\U000e0d01', '\U000e0d02', '\U000e0d03', '\U000e0d04', '\U000e0d05', '\U000e0d06', '\U000e0d07', '\U000e0d08', 
    '\U000e0d09', '\U000e0d0a', '\U000e0d0b', '\U000e0d0c', '\U000e0d0d', '\U000e0d0e', '\U000e0d0f', '\U000e0d10', 
    '\U000e0d11', '\U000e0d12', '\U000e0d13', '\U000e0d14', '\U000e0d15', '\U000e0d16', '\U000e0d17', '\U000e0d18', 
    '\U000e0d19', '\U000e0d1a', '\U000e0d1b', '\U000e0d1c', '\U000e0d1d', '\U000e0d1e', '\U000e0d1f', '\U000e0d20', 
    '\U000e0d21', '\U000e0d22', '\U000e0d23', '\U000e0d24', '\U000e0d25', '\U000e0d26', '\U000e0d27', '\U000e0d28', 
    '\U000e0d29', '\U000e0d2a', '\U000e0d2b', '\U000e0d2c', '\U000e0d2d', '\U000e0d2e', '\U000e0d2f', '\U000e0d30', 
    '\U000e0d31', '\U000e0d32', '\U000e0d33', '\U000e0d34', '\U000e0d35', '\U000e0d36', '\U000e0d37', '\U000e0d38', 
    '\U000e0d39', '\U000e0d3a', '\U000e0d3b', '\U000e0d3c', '\U000e0d3d', '\U000e0d3e', '\U000e0d3f', '\U000e0d40', 
    '\U000e0d41', '\U000e0d42', '\U000e0d43', '\U000e0d44', '\U000e0d45', '\U000e0d46', '\U000e0d47', '\U000e0d48', 
    '\U000e0d49', '\U000e0d4a', '\U000e0d4b', '\U000e0d4c', '\U000e0d4d', '\U000e0d4e', '\U000e0d4f', '\U000e0d50', 
    '\U000e0d51', '\U000e0d52', '\U000e0d53', '\U000e0d54', '\U000e0d55', '\U000e0d56', '\U000e0d57', '\U000e0d58', 
    '\U000e0d59', '\U000e0d5a', '\U000e0d5b', '\U000e0d5c', '\U000e0d5d', '\U000e0d5e', '\U000e0d5f', '\U000e0d60', 
    '\U000e0d61', '\U000e0d62', '\U000e0d63', '\U000e0d64', '\U000e0d65', '\U000e0d66', '\U000e0d67', '\U000e0d68', 
    '\U000e0d69', '\U000e0d6a', '\U000e0d6b', '\U000e0d6c', '\U000e0d6d', '\U000e0d6e', '\U000e0d6f', '\U000e0d70', 
    '\U000e0d71', '\U000e0d72', '\U000e0d73', '\U000e0d74', '\U000e0d75', '\U000e0d76', '\U000e0d77', '\U000e0d78', 
    '\U000e0d79', '\U000e0d7a', '\U000e0d7b', '\U000e0d7c', '\U000e0d7d', '\U000e0d7e', '\U000e0d7f', '\U000e0d80', 
    '\U000e0d81', '\U000e0d82', '\U000e0d83', '\U000e0d84', '\U000e0d85', '\U000e0d86', '\U000e0d87', '\U000e0d88', 
    '\U000e0d89', '\U000e0d8a', '\U000e0d8b', '\U000e0d8c', '\U000e0d8d', '\U000e0d8e', '\U000e0d8f', '\U000e0d90', 
    '\U000e0d91', '\U000e0d92', '\U000e0d93', '\U000e0d94', '\U000e0d95', '\U000e0d96', '\U000e0d97', '\U000e0d98', 
    '\U000e0d99', '\U000e0d9a', '\U000e0d9b', '\U000e0d9c', '\U000e0d9d', '\U000e0d9e', '\U000e0d9f', '\U000e0da0', 
    '\U000e0da1', '\U000e0da2', '\U000e0da3', '\U000e0da4', '\U000e0da5', '\U000e0da6', '\U000e0da7', '\U000e0da8', 
    '\U000e0da9', '\U000e0daa', '\U000e0dab', '\U000e0dac', '\U000e0dad', '\U000e0dae', '\U000e0daf', '\U000e0db0', 
    '\U000e0db1', '\U000e0db2', '\U000e0db3', '\U000e0db4', '\U000e0db5', '\U000e0db6', '\U000e0db7', '\U000e0db8', 
    '\U000e0db9', '\U000e0dba', '\U000e0dbb', '\U000e0dbc', '\U000e0dbd', '\U000e0dbe', '\U000e0dbf', '\U000e0dc0', 
    '\U000e0dc1', '\U000e0dc2', '\U000e0dc3', '\U000e0dc4', '\U000e0dc5', '\U000e0dc6', '\U000e0dc7', '\U000e0dc8', 
    '\U000e0dc9', '\U000e0dca', '\U000e0dcb', '\U000e0dcc', '\U000e0dcd', '\U000e0dce', '\U000e0dcf', '\U000e0dd0', 
    '\U000e0dd1', '\U000e0dd2', '\U000e0dd3', '\U000e0dd4', '\U000e0dd5', '\U000e0dd6', '\U000e0dd7', '\U000e0dd8', 
    '\U000e0dd9', '\U000e0dda', '\U000e0ddb', '\U000e0ddc', '\U000e0ddd', '\U000e0dde', '\U000e0ddf', '\U000e0de0', 
    '\U000e0de1', '\U000e0de2', '\U000e0de3', '\U000e0de4', '\U000e0de5', '\U000e0de6', '\U000e0de7', '\U000e0de8', 
    '\U000e0de9', '\U000e0dea', '\U000e0deb', '\U000e0dec', '\U000e0ded', '\U000e0dee', '\U000e0def', '\U000e0df0', 
    '\U000e0df1', '\U000e0df2', '\U000e0df3', '\U000e0df4', '\U000e0df5', '\U000e0df6', '\U000e0df7', '\U000e0df8', 
    '\U000e0df9', '\U000e0dfa', '\U000e0dfb', '\U000e0dfc', '\U000e0dfd', '\U000e0dfe', '\U000e0dff', '\U000e0e00', 
    '\U000e0e01', '\U000e0e02', '\U000e0e03', '\U000e0e04', '\U000e0e05', '\U000e0e06', '\U000e0e07', '\U000e0e08', 
    '\U000e0e09', '\U000e0e0a', '\U000e0e0b', '\U000e0e0c', '\U000e0e0d', '\U000e0e0e', '\U000e0e0f', '\U000e0e10', 
    '\U000e0e11', '\U000e0e12', '\U000e0e13', '\U000e0e14', '\U000e0e15', '\U000e0e16', '\U000e0e17', '\U000e0e18', 
    '\U000e0e19', '\U000e0e1a', '\U000e0e1b', '\U000e0e1c', '\U000e0e1d', '\U000e0e1e', '\U000e0e1f', '\U000e0e20', 
    '\U000e0e21', '\U000e0e22', '\U000e0e23', '\U000e0e24', '\U000e0e25', '\U000e0e26', '\U000e0e27', '\U000e0e28', 
    '\U000e0e29', '\U000e0e2a', '\U000e0e2b', '\U000e0e2c', '\U000e0e2d', '\U000e0e2e', '\U000e0e2f', '\U000e0e30', 
    '\U000e0e31', '\U000e0e32', '\U000e0e33', '\U000e0e34', '\U000e0e35', '\U000e0e36', '\U000e0e37', '\U000e0e38', 
    '\U000e0e39', '\U000e0e3a', '\U000e0e3b', '\U000e0e3c', '\U000e0e3d', '\U000e0e3e', '\U000e0e3f', '\U000e0e40', 
    '\U000e0e41', '\U000e0e42', '\U000e0e43', '\U000e0e44', '\U000e0e45', '\U000e0e46', '\U000e0e47', '\U000e0e48', 
    '\U000e0e49', '\U000e0e4a', '\U000e0e4b', '\U000e0e4c', '\U000e0e4d', '\U000e0e4e', '\U000e0e4f', '\U000e0e50', 
    '\U000e0e51', '\U000e0e52', '\U000e0e53', '\U000e0e54', '\U000e0e55', '\U000e0e56', '\U000e0e57', '\U000e0e58', 
    '\U000e0e59', '\U000e0e5a', '\U000e0e5b', '\U000e0e5c', '\U000e0e5d', '\U000e0e5e', '\U000e0e5f', '\U000e0e60', 
    '\U000e0e61', '\U000e0e62', '\U000e0e63', '\U000e0e64', '\U000e0e65', '\U000e0e66', '\U000e0e67', '\U000e0e68', 
    '\U000e0e69', '\U000e0e6a', '\U000e0e6b', '\U000e0e6c', '\U000e0e6d', '\U000e0e6e', '\U000e0e6f', '\U000e0e70', 
    '\U000e0e71', '\U000e0e72', '\U000e0e73', '\U000e0e74', '\U000e0e75', '\U000e0e76', '\U000e0e77', '\U000e0e78', 
    '\U000e0e79', '\U000e0e7a', '\U000e0e7b', '\U000e0e7c', '\U000e0e7d', '\U000e0e7e', '\U000e0e7f', '\U000e0e80', 
    '\U000e0e81', '\U000e0e82', '\U000e0e83', '\U000e0e84', '\U000e0e85', '\U000e0e86', '\U000e0e87', '\U000e0e88', 
    '\U000e0e89', '\U000e0e8a', '\U000e0e8b', '\U000e0e8c', '\U000e0e8d', '\U000e0e8e', '\U000e0e8f', '\U000e0e90', 
    '\U000e0e91', '\U000e0e92', '\U000e0e93', '\U000e0e94', '\U000e0e95', '\U000e0e96', '\U000e0e97', '\U000e0e98', 
    '\U000e0e99', '\U000e0e9a', '\U000e0e9b', '\U000e0e9c', '\U000e0e9d', '\U000e0e9e', '\U000e0e9f', '\U000e0ea0', 
    '\U000e0ea1', '\U000e0ea2', '\U000e0ea3', '\U000e0ea4', '\U000e0ea5', '\U000e0ea6', '\U000e0ea7', '\U000e0ea8', 
    '\U000e0ea9', '\U000e0eaa', '\U000e0eab', '\U000e0eac', '\U000e0ead', '\U000e0eae', '\U000e0eaf', '\U000e0eb0', 
    '\U000e0eb1', '\U000e0eb2', '\U000e0eb3', '\U000e0eb4', '\U000e0eb5', '\U000e0eb6', '\U000e0eb7', '\U000e0eb8', 
    '\U000e0eb9', '\U000e0eba', '\U000e0ebb', '\U000e0ebc', '\U000e0ebd', '\U000e0ebe', '\U000e0ebf', '\U000e0ec0', 
    '\U000e0ec1', '\U000e0ec2', '\U000e0ec3', '\U000e0ec4', '\U000e0ec5', '\U000e0ec6', '\U000e0ec7', '\U000e0ec8', 
    '\U000e0ec9', '\U000e0eca', '\U000e0ecb', '\U000e0ecc', '\U000e0ecd', '\U000e0ece', '\U000e0ecf', '\U000e0ed0', 
    '\U000e0ed1', '\U000e0ed2', '\U000e0ed3', '\U000e0ed4', '\U000e0ed5', '\U000e0ed6', '\U000e0ed7', '\U000e0ed8', 
    '\U000e0ed9', '\U000e0eda', '\U000e0edb', '\U000e0edc', '\U000e0edd', '\U000e0ede', '\U000e0edf', '\U000e0ee0', 
    '\U000e0ee1', '\U000e0ee2', '\U000e0ee3', '\U000e0ee4', '\U000e0ee5', '\U000e0ee6', '\U000e0ee7', '\U000e0ee8', 
    '\U000e0ee9', '\U000e0eea', '\U000e0eeb', '\U000e0eec', '\U000e0eed', '\U000e0eee', '\U000e0eef', '\U000e0ef0', 
    '\U000e0ef1', '\U000e0ef2', '\U000e0ef3', '\U000e0ef4', '\U000e0ef5', '\U000e0ef6', '\U000e0ef7', '\U000e0ef8', 
    '\U000e0ef9', '\U000e0efa', '\U000e0efb', '\U000e0efc', '\U000e0efd', '\U000e0efe', '\U000e0eff', '\U000e0f00', 
    '\U000e0f01', '\U000e0f02', '\U000e0f03', '\U000e0f04', '\U000e0f05', '\U000e0f06', '\U000e0f07', '\U000e0f08', 
    '\U000e0f09', '\U000e0f0a', '\U000e0f0b', '\U000e0f0c', '\U000e0f0d', '\U000e0f0e', '\U000e0f0f', '\U000e0f10', 
    '\U000e0f11', '\U000e0f12', '\U000e0f13', '\U000e0f14', '\U000e0f15', '\U000e0f16', '\U000e0f17', '\U000e0f18', 
    '\U000e0f19', '\U000e0f1a', '\U000e0f1b', '\U000e0f1c', '\U000e0f1d', '\U000e0f1e', '\U000e0f1f', '\U000e0f20', 
    '\U000e0f21', '\U000e0f22', '\U000e0f23', '\U000e0f24', '\U000e0f25', '\U000e0f26', '\U000e0f27', '\U000e0f28', 
    '\U000e0f29', '\U000e0f2a', '\U000e0f2b', '\U000e0f2c', '\U000e0f2d', '\U000e0f2e', '\U000e0f2f', '\U000e0f30', 
    '\U000e0f31', '\U000e0f32', '\U000e0f33', '\U000e0f34', '\U000e0f35', '\U000e0f36', '\U000e0f37', '\U000e0f38', 
    '\U000e0f39', '\U000e0f3a', '\U000e0f3b', '\U000e0f3c', '\U000e0f3d', '\U000e0f3e', '\U000e0f3f', '\U000e0f40', 
    '\U000e0f41', '\U000e0f42', '\U000e0f43', '\U000e0f44', '\U000e0f45', '\U000e0f46', '\U000e0f47', '\U000e0f48', 
    '\U000e0f49', '\U000e0f4a', '\U000e0f4b', '\U000e0f4c', '\U000e0f4d', '\U000e0f4e', '\U000e0f4f', '\U000e0f50', 
    '\U000e0f51', '\U000e0f52', '\U000e0f53', '\U000e0f54', '\U000e0f55', '\U000e0f56', '\U000e0f57', '\U000e0f58', 
    '\U000e0f59', '\U000e0f5a', '\U000e0f5b', '\U000e0f5c', '\U000e0f5d', '\U000e0f5e', '\U000e0f5f', '\U000e0f60', 
    '\U000e0f61', '\U000e0f62', '\U000e0f63', '\U000e0f64', '\U000e0f65', '\U000e0f66', '\U000e0f67', '\U000e0f68', 
    '\U000e0f69', '\U000e0f6a', '\U000e0f6b', '\U000e0f6c', '\U000e0f6d', '\U000e0f6e', '\U000e0f6f', '\U000e0f70', 
    '\U000e0f71', '\U000e0f72', '\U000e0f73', '\U000e0f74', '\U000e0f75', '\U000e0f76', '\U000e0f77', '\U000e0f78', 
    '\U000e0f79', '\U000e0f7a', '\U000e0f7b', '\U000e0f7c', '\U000e0f7d', '\U000e0f7e', '\U000e0f7f', '\U000e0f80', 
    '\U000e0f81', '\U000e0f82', '\U000e0f83', '\U000e0f84', '\U000e0f85', '\U000e0f86', '\U000e0f87', '\U000e0f88', 
    '\U000e0f89', '\U000e0f8a', '\U000e0f8b', '\U000e0f8c', '\U000e0f8d', '\U000e0f8e', '\U000e0f8f', '\U000e0f90', 
    '\U000e0f91', '\U000e0f92', '\U000e0f93', '\U000e0f94', '\U000e0f95', '\U000e0f96', '\U000e0f97', '\U000e0f98', 
    '\U000e0f99', '\U000e0f9a', '\U000e0f9b', '\U000e0f9c', '\U000e0f9d', '\U000e0f9e', '\U000e0f9f', '\U000e0fa0', 
    '\U000e0fa1', '\U000e0fa2', '\U000e0fa3', '\U000e0fa4', '\U000e0fa5', '\U000e0fa6', '\U000e0fa7', '\U000e0fa8', 
    '\U000e0fa9', '\U000e0faa', '\U000e0fab', '\U000e0fac', '\U000e0fad', '\U000e0fae', '\U000e0faf', '\U000e0fb0', 
    '\U000e0fb1', '\U000e0fb2', '\U000e0fb3', '\U000e0fb4', '\U000e0fb5', '\U000e0fb6', '\U000e0fb7', '\U000e0fb8', 
    '\U000e0fb9', '\U000e0fba', '\U000e0fbb', '\U000e0fbc', '\U000e0fbd', '\U000e0fbe', '\U000e0fbf', '\U000e0fc0', 
    '\U000e0fc1', '\U000e0fc2', '\U000e0fc3', '\U000e0fc4', '\U000e0fc5', '\U000e0fc6', '\U000e0fc7', '\U000e0fc8', 
    '\U000e0fc9', '\U000e0fca', '\U000e0fcb', '\U000e0fcc', '\U000e0fcd', '\U000e0fce', '\U000e0fcf', '\U000e0fd0', 
    '\U000e0fd1', '\U000e0fd2', '\U000e0fd3', '\U000e0fd4', '\U000e0fd5', '\U000e0fd6', '\U000e0fd7', '\U000e0fd8', 
    '\U000e0fd9', '\U000e0fda', '\U000e0fdb', '\U000e0fdc', '\U000e0fdd', '\U000e0fde', '\U000e0fdf', '\U000e0fe0', 
    '\U000e0fe1', '\U000e0fe2', '\U000e0fe3', '\U000e0fe4', '\U000e0fe5', '\U000e0fe6', '\U000e0fe7', '\U000e0fe8', 
    '\U000e0fe9', '\U000e0fea', '\U000e0feb', '\U000e0fec', '\U000e0fed', '\U000e0fee', '\U000e0fef', '\U000e0ff0', 
    '\U000e0ff1', '\U000e0ff2', '\U000e0ff3', '\U000e0ff4', '\U000e0ff5', '\U000e0ff6', '\U000e0ff7', '\U000e0ff8', 
    '\U000e0ff9', '\U000e0ffa', '\U000e0ffb', '\U000e0ffc', '\U000e0ffd', '\U000e0ffe', '\U000e0fff')
    rangeFromGraphemeClass[int(ControlClass)] = Control

    // Range for Grapheme class SpacingMark
    SpacingMark = rangetable.New('\u0903', '\u093b', '\u093e', '\u093f', '\u0940', '\u0949', 
    '\u094a', '\u094b', '\u094c', '\u094e', '\u094f', '\u0982', '\u0983', '\u09bf', 
    '\u09c0', '\u09c7', '\u09c8', '\u09cb', '\u09cc', '\u0a03', '\u0a3e', '\u0a3f', 
    '\u0a40', '\u0a83', '\u0abe', '\u0abf', '\u0ac0', '\u0ac9', '\u0acb', '\u0acc', 
    '\u0b02', '\u0b03', '\u0b40', '\u0b47', '\u0b48', '\u0b4b', '\u0b4c', '\u0bbf', 
    '\u0bc1', '\u0bc2', '\u0bc6', '\u0bc7', '\u0bc8', '\u0bca', '\u0bcb', '\u0bcc', 
    '\u0c01', '\u0c02', '\u0c03', '\u0c41', '\u0c42', '\u0c43', '\u0c44', '\u0c82', 
    '\u0c83', '\u0cbe', '\u0cc0', '\u0cc1', '\u0cc3', '\u0cc4', '\u0cc7', '\u0cc8', 
    '\u0cca', '\u0ccb', '\u0d02', '\u0d03', '\u0d3f', '\u0d40', '\u0d46', '\u0d47', 
    '\u0d48', '\u0d4a', '\u0d4b', '\u0d4c', '\u0d82', '\u0d83', '\u0dd0', '\u0dd1', 
    '\u0dd8', '\u0dd9', '\u0dda', '\u0ddb', '\u0ddc', '\u0ddd', '\u0dde', '\u0df2', 
    '\u0df3', '\u0e33', '\u0eb3', '\u0f3e', '\u0f3f', '\u0f7f', '\u1031', '\u103b', 
    '\u103c', '\u1056', '\u1057', '\u1084', '\u17b6', '\u17be', '\u17bf', '\u17c0', 
    '\u17c1', '\u17c2', '\u17c3', '\u17c4', '\u17c5', '\u17c7', '\u17c8', '\u1923', 
    '\u1924', '\u1925', '\u1926', '\u1929', '\u192a', '\u192b', '\u1930', '\u1931', 
    '\u1933', '\u1934', '\u1935', '\u1936', '\u1937', '\u1938', '\u1a19', '\u1a1a', 
    '\u1a55', '\u1a57', '\u1a6d', '\u1a6e', '\u1a6f', '\u1a70', '\u1a71', '\u1a72', 
    '\u1b04', '\u1b35', '\u1b3b', '\u1b3d', '\u1b3e', '\u1b3f', '\u1b40', '\u1b41', 
    '\u1b43', '\u1b44', '\u1b82', '\u1ba1', '\u1ba6', '\u1ba7', '\u1baa', '\u1be7', 
    '\u1bea', '\u1beb', '\u1bec', '\u1bee', '\u1bf2', '\u1bf3', '\u1c24', '\u1c25', 
    '\u1c26', '\u1c27', '\u1c28', '\u1c29', '\u1c2a', '\u1c2b', '\u1c34', '\u1c35', 
    '\u1ce1', '\u1cf2', '\u1cf3', '\u1cf7', '\ua823', '\ua824', '\ua827', '\ua880', 
    '\ua881', '\ua8b4', '\ua8b5', '\ua8b6', '\ua8b7', '\ua8b8', '\ua8b9', '\ua8ba', 
    '\ua8bb', '\ua8bc', '\ua8bd', '\ua8be', '\ua8bf', '\ua8c0', '\ua8c1', '\ua8c2', 
    '\ua8c3', '\ua952', '\ua953', '\ua983', '\ua9b4', '\ua9b5', '\ua9ba', '\ua9bb', 
    '\ua9bd', '\ua9be', '\ua9bf', '\ua9c0', '\uaa2f', '\uaa30', '\uaa33', '\uaa34', 
    '\uaa4d', '\uaaeb', '\uaaee', '\uaaef', '\uaaf5', '\uabe3', '\uabe4', '\uabe6', 
    '\uabe7', '\uabe9', '\uabea', '\uabec', '\U00011000', '\U00011002', '\U00011082', '\U000110b0', 
    '\U000110b1', '\U000110b2', '\U000110b7', '\U000110b8', '\U0001112c', '\U00011145', '\U00011146', '\U00011182', 
    '\U000111b3', '\U000111b4', '\U000111b5', '\U000111bf', '\U000111c0', '\U0001122c', '\U0001122d', '\U0001122e', 
    '\U00011232', '\U00011233', '\U00011235', '\U000112e0', '\U000112e1', '\U000112e2', '\U00011302', '\U00011303', 
    '\U0001133f', '\U00011341', '\U00011342', '\U00011343', '\U00011344', '\U00011347', '\U00011348', '\U0001134b', 
    '\U0001134c', '\U0001134d', '\U00011362', '\U00011363', '\U00011435', '\U00011436', '\U00011437', '\U00011440', 
    '\U00011441', '\U00011445', '\U000114b1', '\U000114b2', '\U000114b9', '\U000114bb', '\U000114bc', '\U000114be', 
    '\U000114c1', '\U000115b0', '\U000115b1', '\U000115b8', '\U000115b9', '\U000115ba', '\U000115bb', '\U000115be', 
    '\U00011630', '\U00011631', '\U00011632', '\U0001163b', '\U0001163c', '\U0001163e', '\U000116ac', '\U000116ae', 
    '\U000116af', '\U000116b6', '\U00011720', '\U00011721', '\U00011726', '\U0001182c', '\U0001182d', '\U0001182e', 
    '\U00011838', '\U00011a39', '\U00011a57', '\U00011a58', '\U00011a97', '\U00011c2f', '\U00011c3e', '\U00011ca9', 
    '\U00011cb1', '\U00011cb4', '\U00011d8a', '\U00011d8b', '\U00011d8c', '\U00011d8d', '\U00011d8e', '\U00011d93', 
    '\U00011d94', '\U00011d96', '\U00011ef5', '\U00011ef6', '\U00016f51', '\U00016f52', '\U00016f53', '\U00016f54', 
    '\U00016f55', '\U00016f56', '\U00016f57', '\U00016f58', '\U00016f59', '\U00016f5a', '\U00016f5b', '\U00016f5c', 
    '\U00016f5d', '\U00016f5e', '\U00016f5f', '\U00016f60', '\U00016f61', '\U00016f62', '\U00016f63', '\U00016f64', 
    '\U00016f65', '\U00016f66', '\U00016f67', '\U00016f68', '\U00016f69', '\U00016f6a', '\U00016f6b', '\U00016f6c', 
    '\U00016f6d', '\U00016f6e', '\U00016f6f', '\U00016f70', '\U00016f71', '\U00016f72', '\U00016f73', '\U00016f74', 
    '\U00016f75', '\U00016f76', '\U00016f77', '\U00016f78', '\U00016f79', '\U00016f7a', '\U00016f7b', '\U00016f7c', 
    '\U00016f7d', '\U00016f7e', '\U0001d166', '\U0001d16d')
    rangeFromGraphemeClass[int(SpacingMarkClass)] = SpacingMark

    // Range for Grapheme class LV
    LV = rangetable.New('\uac00', '\uac1c', '\uac38', '\uac54', '\uac70', '\uac8c', 
    '\uaca8', '\uacc4', '\uace0', '\uacfc', '\uad18', '\uad34', '\uad50', '\uad6c', 
    '\uad88', '\uada4', '\uadc0', '\uaddc', '\uadf8', '\uae14', '\uae30', '\uae4c', 
    '\uae68', '\uae84', '\uaea0', '\uaebc', '\uaed8', '\uaef4', '\uaf10', '\uaf2c', 
    '\uaf48', '\uaf64', '\uaf80', '\uaf9c', '\uafb8', '\uafd4', '\uaff0', '\ub00c', 
    '\ub028', '\ub044', '\ub060', '\ub07c', '\ub098', '\ub0b4', '\ub0d0', '\ub0ec', 
    '\ub108', '\ub124', '\ub140', '\ub15c', '\ub178', '\ub194', '\ub1b0', '\ub1cc', 
    '\ub1e8', '\ub204', '\ub220', '\ub23c', '\ub258', '\ub274', '\ub290', '\ub2ac', 
    '\ub2c8', '\ub2e4', '\ub300', '\ub31c', '\ub338', '\ub354', '\ub370', '\ub38c', 
    '\ub3a8', '\ub3c4', '\ub3e0', '\ub3fc', '\ub418', '\ub434', '\ub450', '\ub46c', 
    '\ub488', '\ub4a4', '\ub4c0', '\ub4dc', '\ub4f8', '\ub514', '\ub530', '\ub54c', 
    '\ub568', '\ub584', '\ub5a0', '\ub5bc', '\ub5d8', '\ub5f4', '\ub610', '\ub62c', 
    '\ub648', '\ub664', '\ub680', '\ub69c', '\ub6b8', '\ub6d4', '\ub6f0', '\ub70c', 
    '\ub728', '\ub744', '\ub760', '\ub77c', '\ub798', '\ub7b4', '\ub7d0', '\ub7ec', 
    '\ub808', '\ub824', '\ub840', '\ub85c', '\ub878', '\ub894', '\ub8b0', '\ub8cc', 
    '\ub8e8', '\ub904', '\ub920', '\ub93c', '\ub958', '\ub974', '\ub990', '\ub9ac', 
    '\ub9c8', '\ub9e4', '\uba00', '\uba1c', '\uba38', '\uba54', '\uba70', '\uba8c', 
    '\ubaa8', '\ubac4', '\ubae0', '\ubafc', '\ubb18', '\ubb34', '\ubb50', '\ubb6c', 
    '\ubb88', '\ubba4', '\ubbc0', '\ubbdc', '\ubbf8', '\ubc14', '\ubc30', '\ubc4c', 
    '\ubc68', '\ubc84', '\ubca0', '\ubcbc', '\ubcd8', '\ubcf4', '\ubd10', '\ubd2c', 
    '\ubd48', '\ubd64', '\ubd80', '\ubd9c', '\ubdb8', '\ubdd4', '\ubdf0', '\ube0c', 
    '\ube28', '\ube44', '\ube60', '\ube7c', '\ube98', '\ubeb4', '\ubed0', '\ubeec', 
    '\ubf08', '\ubf24', '\ubf40', '\ubf5c', '\ubf78', '\ubf94', '\ubfb0', '\ubfcc', 
    '\ubfe8', '\uc004', '\uc020', '\uc03c', '\uc058', '\uc074', '\uc090', '\uc0ac', 
    '\uc0c8', '\uc0e4', '\uc100', '\uc11c', '\uc138', '\uc154', '\uc170', '\uc18c', 
    '\uc1a8', '\uc1c4', '\uc1e0', '\uc1fc', '\uc218', '\uc234', '\uc250', '\uc26c', 
    '\uc288', '\uc2a4', '\uc2c0', '\uc2dc', '\uc2f8', '\uc314', '\uc330', '\uc34c', 
    '\uc368', '\uc384', '\uc3a0', '\uc3bc', '\uc3d8', '\uc3f4', '\uc410', '\uc42c', 
    '\uc448', '\uc464', '\uc480', '\uc49c', '\uc4b8', '\uc4d4', '\uc4f0', '\uc50c', 
    '\uc528', '\uc544', '\uc560', '\uc57c', '\uc598', '\uc5b4', '\uc5d0', '\uc5ec', 
    '\uc608', '\uc624', '\uc640', '\uc65c', '\uc678', '\uc694', '\uc6b0', '\uc6cc', 
    '\uc6e8', '\uc704', '\uc720', '\uc73c', '\uc758', '\uc774', '\uc790', '\uc7ac', 
    '\uc7c8', '\uc7e4', '\uc800', '\uc81c', '\uc838', '\uc854', '\uc870', '\uc88c', 
    '\uc8a8', '\uc8c4', '\uc8e0', '\uc8fc', '\uc918', '\uc934', '\uc950', '\uc96c', 
    '\uc988', '\uc9a4', '\uc9c0', '\uc9dc', '\uc9f8', '\uca14', '\uca30', '\uca4c', 
    '\uca68', '\uca84', '\ucaa0', '\ucabc', '\ucad8', '\ucaf4', '\ucb10', '\ucb2c', 
    '\ucb48', '\ucb64', '\ucb80', '\ucb9c', '\ucbb8', '\ucbd4', '\ucbf0', '\ucc0c', 
    '\ucc28', '\ucc44', '\ucc60', '\ucc7c', '\ucc98', '\uccb4', '\uccd0', '\uccec', 
    '\ucd08', '\ucd24', '\ucd40', '\ucd5c', '\ucd78', '\ucd94', '\ucdb0', '\ucdcc', 
    '\ucde8', '\uce04', '\uce20', '\uce3c', '\uce58', '\uce74', '\uce90', '\uceac', 
    '\ucec8', '\ucee4', '\ucf00', '\ucf1c', '\ucf38', '\ucf54', '\ucf70', '\ucf8c', 
    '\ucfa8', '\ucfc4', '\ucfe0', '\ucffc', '\ud018', '\ud034', '\ud050', '\ud06c', 
    '\ud088', '\ud0a4', '\ud0c0', '\ud0dc', '\ud0f8', '\ud114', '\ud130', '\ud14c', 
    '\ud168', '\ud184', '\ud1a0', '\ud1bc', '\ud1d8', '\ud1f4', '\ud210', '\ud22c', 
    '\ud248', '\ud264', '\ud280', '\ud29c', '\ud2b8', '\ud2d4', '\ud2f0', '\ud30c', 
    '\ud328', '\ud344', '\ud360', '\ud37c', '\ud398', '\ud3b4', '\ud3d0', '\ud3ec', 
    '\ud408', '\ud424', '\ud440', '\ud45c', '\ud478', '\ud494', '\ud4b0', '\ud4cc', 
    '\ud4e8', '\ud504', '\ud520', '\ud53c', '\ud558', '\ud574', '\ud590', '\ud5ac', 
    '\ud5c8', '\ud5e4', '\ud600', '\ud61c', '\ud638', '\ud654', '\ud670', '\ud68c', 
    '\ud6a8', '\ud6c4', '\ud6e0', '\ud6fc', '\ud718', '\ud734', '\ud750', '\ud76c', 
    '\ud788')
    rangeFromGraphemeClass[int(LVClass)] = LV

    // Range for Grapheme class ZWJ
    ZWJ = rangetable.New('\u200d')
    rangeFromGraphemeClass[int(ZWJClass)] = ZWJ

    // Range for Grapheme class Prepend
    Prepend = rangetable.New('\u0600', '\u0601', '\u0602', '\u0603', '\u0604', '\u0605', 
    '\u06dd', '\u070f', '\u08e2', '\u0d4e', '\U000110bd', '\U000110cd', '\U000111c2', '\U000111c3', 
    '\U00011a3a', '\U00011a86', '\U00011a87', '\U00011a88', '\U00011a89', '\U00011d46')
    rangeFromGraphemeClass[int(PrependClass)] = Prepend

    // Range for Grapheme class V
    V = rangetable.New('\u1160', '\u1161', '\u1162', '\u1163', '\u1164', '\u1165', 
    '\u1166', '\u1167', '\u1168', '\u1169', '\u116a', '\u116b', '\u116c', '\u116d', 
    '\u116e', '\u116f', '\u1170', '\u1171', '\u1172', '\u1173', '\u1174', '\u1175', 
    '\u1176', '\u1177', '\u1178', '\u1179', '\u117a', '\u117b', '\u117c', '\u117d', 
    '\u117e', '\u117f', '\u1180', '\u1181', '\u1182', '\u1183', '\u1184', '\u1185', 
    '\u1186', '\u1187', '\u1188', '\u1189', '\u118a', '\u118b', '\u118c', '\u118d', 
    '\u118e', '\u118f', '\u1190', '\u1191', '\u1192', '\u1193', '\u1194', '\u1195', 
    '\u1196', '\u1197', '\u1198', '\u1199', '\u119a', '\u119b', '\u119c', '\u119d', 
    '\u119e', '\u119f', '\u11a0', '\u11a1', '\u11a2', '\u11a3', '\u11a4', '\u11a5', 
    '\u11a6', '\u11a7', '\ud7b0', '\ud7b1', '\ud7b2', '\ud7b3', '\ud7b4', '\ud7b5', 
    '\ud7b6', '\ud7b7', '\ud7b8', '\ud7b9', '\ud7ba', '\ud7bb', '\ud7bc', '\ud7bd', 
    '\ud7be', '\ud7bf', '\ud7c0', '\ud7c1', '\ud7c2', '\ud7c3', '\ud7c4', '\ud7c5', 
    '\ud7c6')
    rangeFromGraphemeClass[int(VClass)] = V

    // Range for Grapheme class LVT
    LVT = rangetable.New('\uac01', '\uac02', '\uac03', '\uac04', '\uac05', '\uac06', 
    '\uac07', '\uac08', '\uac09', '\uac0a', '\uac0b', '\uac0c', '\uac0d', '\uac0e', 
    '\uac0f', '\uac10', '\uac11', '\uac12', '\uac13', '\uac14', '\uac15', '\uac16', 
    '\uac17', '\uac18', '\uac19', '\uac1a', '\uac1b', '\uac1d', '\uac1e', '\uac1f', 
    '\uac20', '\uac21', '\uac22', '\uac23', '\uac24', '\uac25', '\uac26', '\uac27', 
    '\uac28', '\uac29', '\uac2a', '\uac2b', '\uac2c', '\uac2d', '\uac2e', '\uac2f', 
    '\uac30', '\uac31', '\uac32', '\uac33', '\uac34', '\uac35', '\uac36', '\uac37', 
    '\uac39', '\uac3a', '\uac3b', '\uac3c', '\uac3d', '\uac3e', '\uac3f', '\uac40', 
    '\uac41', '\uac42', '\uac43', '\uac44', '\uac45', '\uac46', '\uac47', '\uac48', 
    '\uac49', '\uac4a', '\uac4b', '\uac4c', '\uac4d', '\uac4e', '\uac4f', '\uac50', 
    '\uac51', '\uac52', '\uac53', '\uac55', '\uac56', '\uac57', '\uac58', '\uac59', 
    '\uac5a', '\uac5b', '\uac5c', '\uac5d', '\uac5e', '\uac5f', '\uac60', '\uac61', 
    '\uac62', '\uac63', '\uac64', '\uac65', '\uac66', '\uac67', '\uac68', '\uac69', 
    '\uac6a', '\uac6b', '\uac6c', '\uac6d', '\uac6e', '\uac6f', '\uac71', '\uac72', 
    '\uac73', '\uac74', '\uac75', '\uac76', '\uac77', '\uac78', '\uac79', '\uac7a', 
    '\uac7b', '\uac7c', '\uac7d', '\uac7e', '\uac7f', '\uac80', '\uac81', '\uac82', 
    '\uac83', '\uac84', '\uac85', '\uac86', '\uac87', '\uac88', '\uac89', '\uac8a', 
    '\uac8b', '\uac8d', '\uac8e', '\uac8f', '\uac90', '\uac91', '\uac92', '\uac93', 
    '\uac94', '\uac95', '\uac96', '\uac97', '\uac98', '\uac99', '\uac9a', '\uac9b', 
    '\uac9c', '\uac9d', '\uac9e', '\uac9f', '\uaca0', '\uaca1', '\uaca2', '\uaca3', 
    '\uaca4', '\uaca5', '\uaca6', '\uaca7', '\uaca9', '\uacaa', '\uacab', '\uacac', 
    '\uacad', '\uacae', '\uacaf', '\uacb0', '\uacb1', '\uacb2', '\uacb3', '\uacb4', 
    '\uacb5', '\uacb6', '\uacb7', '\uacb8', '\uacb9', '\uacba', '\uacbb', '\uacbc', 
    '\uacbd', '\uacbe', '\uacbf', '\uacc0', '\uacc1', '\uacc2', '\uacc3', '\uacc5', 
    '\uacc6', '\uacc7', '\uacc8', '\uacc9', '\uacca', '\uaccb', '\uaccc', '\uaccd', 
    '\uacce', '\uaccf', '\uacd0', '\uacd1', '\uacd2', '\uacd3', '\uacd4', '\uacd5', 
    '\uacd6', '\uacd7', '\uacd8', '\uacd9', '\uacda', '\uacdb', '\uacdc', '\uacdd', 
    '\uacde', '\uacdf', '\uace1', '\uace2', '\uace3', '\uace4', '\uace5', '\uace6', 
    '\uace7', '\uace8', '\uace9', '\uacea', '\uaceb', '\uacec', '\uaced', '\uacee', 
    '\uacef', '\uacf0', '\uacf1', '\uacf2', '\uacf3', '\uacf4', '\uacf5', '\uacf6', 
    '\uacf7', '\uacf8', '\uacf9', '\uacfa', '\uacfb', '\uacfd', '\uacfe', '\uacff', 
    '\uad00', '\uad01', '\uad02', '\uad03', '\uad04', '\uad05', '\uad06', '\uad07', 
    '\uad08', '\uad09', '\uad0a', '\uad0b', '\uad0c', '\uad0d', '\uad0e', '\uad0f', 
    '\uad10', '\uad11', '\uad12', '\uad13', '\uad14', '\uad15', '\uad16', '\uad17', 
    '\uad19', '\uad1a', '\uad1b', '\uad1c', '\uad1d', '\uad1e', '\uad1f', '\uad20', 
    '\uad21', '\uad22', '\uad23', '\uad24', '\uad25', '\uad26', '\uad27', '\uad28', 
    '\uad29', '\uad2a', '\uad2b', '\uad2c', '\uad2d', '\uad2e', '\uad2f', '\uad30', 
    '\uad31', '\uad32', '\uad33', '\uad35', '\uad36', '\uad37', '\uad38', '\uad39', 
    '\uad3a', '\uad3b', '\uad3c', '\uad3d', '\uad3e', '\uad3f', '\uad40', '\uad41', 
    '\uad42', '\uad43', '\uad44', '\uad45', '\uad46', '\uad47', '\uad48', '\uad49', 
    '\uad4a', '\uad4b', '\uad4c', '\uad4d', '\uad4e', '\uad4f', '\uad51', '\uad52', 
    '\uad53', '\uad54', '\uad55', '\uad56', '\uad57', '\uad58', '\uad59', '\uad5a', 
    '\uad5b', '\uad5c', '\uad5d', '\uad5e', '\uad5f', '\uad60', '\uad61', '\uad62', 
    '\uad63', '\uad64', '\uad65', '\uad66', '\uad67', '\uad68', '\uad69', '\uad6a', 
    '\uad6b', '\uad6d', '\uad6e', '\uad6f', '\uad70', '\uad71', '\uad72', '\uad73', 
    '\uad74', '\uad75', '\uad76', '\uad77', '\uad78', '\uad79', '\uad7a', '\uad7b', 
    '\uad7c', '\uad7d', '\uad7e', '\uad7f', '\uad80', '\uad81', '\uad82', '\uad83', 
    '\uad84', '\uad85', '\uad86', '\uad87', '\uad89', '\uad8a', '\uad8b', '\uad8c', 
    '\uad8d', '\uad8e', '\uad8f', '\uad90', '\uad91', '\uad92', '\uad93', '\uad94', 
    '\uad95', '\uad96', '\uad97', '\uad98', '\uad99', '\uad9a', '\uad9b', '\uad9c', 
    '\uad9d', '\uad9e', '\uad9f', '\uada0', '\uada1', '\uada2', '\uada3', '\uada5', 
    '\uada6', '\uada7', '\uada8', '\uada9', '\uadaa', '\uadab', '\uadac', '\uadad', 
    '\uadae', '\uadaf', '\uadb0', '\uadb1', '\uadb2', '\uadb3', '\uadb4', '\uadb5', 
    '\uadb6', '\uadb7', '\uadb8', '\uadb9', '\uadba', '\uadbb', '\uadbc', '\uadbd', 
    '\uadbe', '\uadbf', '\uadc1', '\uadc2', '\uadc3', '\uadc4', '\uadc5', '\uadc6', 
    '\uadc7', '\uadc8', '\uadc9', '\uadca', '\uadcb', '\uadcc', '\uadcd', '\uadce', 
    '\uadcf', '\uadd0', '\uadd1', '\uadd2', '\uadd3', '\uadd4', '\uadd5', '\uadd6', 
    '\uadd7', '\uadd8', '\uadd9', '\uadda', '\uaddb', '\uaddd', '\uadde', '\uaddf', 
    '\uade0', '\uade1', '\uade2', '\uade3', '\uade4', '\uade5', '\uade6', '\uade7', 
    '\uade8', '\uade9', '\uadea', '\uadeb', '\uadec', '\uaded', '\uadee', '\uadef', 
    '\uadf0', '\uadf1', '\uadf2', '\uadf3', '\uadf4', '\uadf5', '\uadf6', '\uadf7', 
    '\uadf9', '\uadfa', '\uadfb', '\uadfc', '\uadfd', '\uadfe', '\uadff', '\uae00', 
    '\uae01', '\uae02', '\uae03', '\uae04', '\uae05', '\uae06', '\uae07', '\uae08', 
    '\uae09', '\uae0a', '\uae0b', '\uae0c', '\uae0d', '\uae0e', '\uae0f', '\uae10', 
    '\uae11', '\uae12', '\uae13', '\uae15', '\uae16', '\uae17', '\uae18', '\uae19', 
    '\uae1a', '\uae1b', '\uae1c', '\uae1d', '\uae1e', '\uae1f', '\uae20', '\uae21', 
    '\uae22', '\uae23', '\uae24', '\uae25', '\uae26', '\uae27', '\uae28', '\uae29', 
    '\uae2a', '\uae2b', '\uae2c', '\uae2d', '\uae2e', '\uae2f', '\uae31', '\uae32', 
    '\uae33', '\uae34', '\uae35', '\uae36', '\uae37', '\uae38', '\uae39', '\uae3a', 
    '\uae3b', '\uae3c', '\uae3d', '\uae3e', '\uae3f', '\uae40', '\uae41', '\uae42', 
    '\uae43', '\uae44', '\uae45', '\uae46', '\uae47', '\uae48', '\uae49', '\uae4a', 
    '\uae4b', '\uae4d', '\uae4e', '\uae4f', '\uae50', '\uae51', '\uae52', '\uae53', 
    '\uae54', '\uae55', '\uae56', '\uae57', '\uae58', '\uae59', '\uae5a', '\uae5b', 
    '\uae5c', '\uae5d', '\uae5e', '\uae5f', '\uae60', '\uae61', '\uae62', '\uae63', 
    '\uae64', '\uae65', '\uae66', '\uae67', '\uae69', '\uae6a', '\uae6b', '\uae6c', 
    '\uae6d', '\uae6e', '\uae6f', '\uae70', '\uae71', '\uae72', '\uae73', '\uae74', 
    '\uae75', '\uae76', '\uae77', '\uae78', '\uae79', '\uae7a', '\uae7b', '\uae7c', 
    '\uae7d', '\uae7e', '\uae7f', '\uae80', '\uae81', '\uae82', '\uae83', '\uae85', 
    '\uae86', '\uae87', '\uae88', '\uae89', '\uae8a', '\uae8b', '\uae8c', '\uae8d', 
    '\uae8e', '\uae8f', '\uae90', '\uae91', '\uae92', '\uae93', '\uae94', '\uae95', 
    '\uae96', '\uae97', '\uae98', '\uae99', '\uae9a', '\uae9b', '\uae9c', '\uae9d', 
    '\uae9e', '\uae9f', '\uaea1', '\uaea2', '\uaea3', '\uaea4', '\uaea5', '\uaea6', 
    '\uaea7', '\uaea8', '\uaea9', '\uaeaa', '\uaeab', '\uaeac', '\uaead', '\uaeae', 
    '\uaeaf', '\uaeb0', '\uaeb1', '\uaeb2', '\uaeb3', '\uaeb4', '\uaeb5', '\uaeb6', 
    '\uaeb7', '\uaeb8', '\uaeb9', '\uaeba', '\uaebb', '\uaebd', '\uaebe', '\uaebf', 
    '\uaec0', '\uaec1', '\uaec2', '\uaec3', '\uaec4', '\uaec5', '\uaec6', '\uaec7', 
    '\uaec8', '\uaec9', '\uaeca', '\uaecb', '\uaecc', '\uaecd', '\uaece', '\uaecf', 
    '\uaed0', '\uaed1', '\uaed2', '\uaed3', '\uaed4', '\uaed5', '\uaed6', '\uaed7', 
    '\uaed9', '\uaeda', '\uaedb', '\uaedc', '\uaedd', '\uaede', '\uaedf', '\uaee0', 
    '\uaee1', '\uaee2', '\uaee3', '\uaee4', '\uaee5', '\uaee6', '\uaee7', '\uaee8', 
    '\uaee9', '\uaeea', '\uaeeb', '\uaeec', '\uaeed', '\uaeee', '\uaeef', '\uaef0', 
    '\uaef1', '\uaef2', '\uaef3', '\uaef5', '\uaef6', '\uaef7', '\uaef8', '\uaef9', 
    '\uaefa', '\uaefb', '\uaefc', '\uaefd', '\uaefe', '\uaeff', '\uaf00', '\uaf01', 
    '\uaf02', '\uaf03', '\uaf04', '\uaf05', '\uaf06', '\uaf07', '\uaf08', '\uaf09', 
    '\uaf0a', '\uaf0b', '\uaf0c', '\uaf0d', '\uaf0e', '\uaf0f', '\uaf11', '\uaf12', 
    '\uaf13', '\uaf14', '\uaf15', '\uaf16', '\uaf17', '\uaf18', '\uaf19', '\uaf1a', 
    '\uaf1b', '\uaf1c', '\uaf1d', '\uaf1e', '\uaf1f', '\uaf20', '\uaf21', '\uaf22', 
    '\uaf23', '\uaf24', '\uaf25', '\uaf26', '\uaf27', '\uaf28', '\uaf29', '\uaf2a', 
    '\uaf2b', '\uaf2d', '\uaf2e', '\uaf2f', '\uaf30', '\uaf31', '\uaf32', '\uaf33', 
    '\uaf34', '\uaf35', '\uaf36', '\uaf37', '\uaf38', '\uaf39', '\uaf3a', '\uaf3b', 
    '\uaf3c', '\uaf3d', '\uaf3e', '\uaf3f', '\uaf40', '\uaf41', '\uaf42', '\uaf43', 
    '\uaf44', '\uaf45', '\uaf46', '\uaf47', '\uaf49', '\uaf4a', '\uaf4b', '\uaf4c', 
    '\uaf4d', '\uaf4e', '\uaf4f', '\uaf50', '\uaf51', '\uaf52', '\uaf53', '\uaf54', 
    '\uaf55', '\uaf56', '\uaf57', '\uaf58', '\uaf59', '\uaf5a', '\uaf5b', '\uaf5c', 
    '\uaf5d', '\uaf5e', '\uaf5f', '\uaf60', '\uaf61', '\uaf62', '\uaf63', '\uaf65', 
    '\uaf66', '\uaf67', '\uaf68', '\uaf69', '\uaf6a', '\uaf6b', '\uaf6c', '\uaf6d', 
    '\uaf6e', '\uaf6f', '\uaf70', '\uaf71', '\uaf72', '\uaf73', '\uaf74', '\uaf75', 
    '\uaf76', '\uaf77', '\uaf78', '\uaf79', '\uaf7a', '\uaf7b', '\uaf7c', '\uaf7d', 
    '\uaf7e', '\uaf7f', '\uaf81', '\uaf82', '\uaf83', '\uaf84', '\uaf85', '\uaf86', 
    '\uaf87', '\uaf88', '\uaf89', '\uaf8a', '\uaf8b', '\uaf8c', '\uaf8d', '\uaf8e', 
    '\uaf8f', '\uaf90', '\uaf91', '\uaf92', '\uaf93', '\uaf94', '\uaf95', '\uaf96', 
    '\uaf97', '\uaf98', '\uaf99', '\uaf9a', '\uaf9b', '\uaf9d', '\uaf9e', '\uaf9f', 
    '\uafa0', '\uafa1', '\uafa2', '\uafa3', '\uafa4', '\uafa5', '\uafa6', '\uafa7', 
    '\uafa8', '\uafa9', '\uafaa', '\uafab', '\uafac', '\uafad', '\uafae', '\uafaf', 
    '\uafb0', '\uafb1', '\uafb2', '\uafb3', '\uafb4', '\uafb5', '\uafb6', '\uafb7', 
    '\uafb9', '\uafba', '\uafbb', '\uafbc', '\uafbd', '\uafbe', '\uafbf', '\uafc0', 
    '\uafc1', '\uafc2', '\uafc3', '\uafc4', '\uafc5', '\uafc6', '\uafc7', '\uafc8', 
    '\uafc9', '\uafca', '\uafcb', '\uafcc', '\uafcd', '\uafce', '\uafcf', '\uafd0', 
    '\uafd1', '\uafd2', '\uafd3', '\uafd5', '\uafd6', '\uafd7', '\uafd8', '\uafd9', 
    '\uafda', '\uafdb', '\uafdc', '\uafdd', '\uafde', '\uafdf', '\uafe0', '\uafe1', 
    '\uafe2', '\uafe3', '\uafe4', '\uafe5', '\uafe6', '\uafe7', '\uafe8', '\uafe9', 
    '\uafea', '\uafeb', '\uafec', '\uafed', '\uafee', '\uafef', '\uaff1', '\uaff2', 
    '\uaff3', '\uaff4', '\uaff5', '\uaff6', '\uaff7', '\uaff8', '\uaff9', '\uaffa', 
    '\uaffb', '\uaffc', '\uaffd', '\uaffe', '\uafff', '\ub000', '\ub001', '\ub002', 
    '\ub003', '\ub004', '\ub005', '\ub006', '\ub007', '\ub008', '\ub009', '\ub00a', 
    '\ub00b', '\ub00d', '\ub00e', '\ub00f', '\ub010', '\ub011', '\ub012', '\ub013', 
    '\ub014', '\ub015', '\ub016', '\ub017', '\ub018', '\ub019', '\ub01a', '\ub01b', 
    '\ub01c', '\ub01d', '\ub01e', '\ub01f', '\ub020', '\ub021', '\ub022', '\ub023', 
    '\ub024', '\ub025', '\ub026', '\ub027', '\ub029', '\ub02a', '\ub02b', '\ub02c', 
    '\ub02d', '\ub02e', '\ub02f', '\ub030', '\ub031', '\ub032', '\ub033', '\ub034', 
    '\ub035', '\ub036', '\ub037', '\ub038', '\ub039', '\ub03a', '\ub03b', '\ub03c', 
    '\ub03d', '\ub03e', '\ub03f', '\ub040', '\ub041', '\ub042', '\ub043', '\ub045', 
    '\ub046', '\ub047', '\ub048', '\ub049', '\ub04a', '\ub04b', '\ub04c', '\ub04d', 
    '\ub04e', '\ub04f', '\ub050', '\ub051', '\ub052', '\ub053', '\ub054', '\ub055', 
    '\ub056', '\ub057', '\ub058', '\ub059', '\ub05a', '\ub05b', '\ub05c', '\ub05d', 
    '\ub05e', '\ub05f', '\ub061', '\ub062', '\ub063', '\ub064', '\ub065', '\ub066', 
    '\ub067', '\ub068', '\ub069', '\ub06a', '\ub06b', '\ub06c', '\ub06d', '\ub06e', 
    '\ub06f', '\ub070', '\ub071', '\ub072', '\ub073', '\ub074', '\ub075', '\ub076', 
    '\ub077', '\ub078', '\ub079', '\ub07a', '\ub07b', '\ub07d', '\ub07e', '\ub07f', 
    '\ub080', '\ub081', '\ub082', '\ub083', '\ub084', '\ub085', '\ub086', '\ub087', 
    '\ub088', '\ub089', '\ub08a', '\ub08b', '\ub08c', '\ub08d', '\ub08e', '\ub08f', 
    '\ub090', '\ub091', '\ub092', '\ub093', '\ub094', '\ub095', '\ub096', '\ub097', 
    '\ub099', '\ub09a', '\ub09b', '\ub09c', '\ub09d', '\ub09e', '\ub09f', '\ub0a0', 
    '\ub0a1', '\ub0a2', '\ub0a3', '\ub0a4', '\ub0a5', '\ub0a6', '\ub0a7', '\ub0a8', 
    '\ub0a9', '\ub0aa', '\ub0ab', '\ub0ac', '\ub0ad', '\ub0ae', '\ub0af', '\ub0b0', 
    '\ub0b1', '\ub0b2', '\ub0b3', '\ub0b5', '\ub0b6', '\ub0b7', '\ub0b8', '\ub0b9', 
    '\ub0ba', '\ub0bb', '\ub0bc', '\ub0bd', '\ub0be', '\ub0bf', '\ub0c0', '\ub0c1', 
    '\ub0c2', '\ub0c3', '\ub0c4', '\ub0c5', '\ub0c6', '\ub0c7', '\ub0c8', '\ub0c9', 
    '\ub0ca', '\ub0cb', '\ub0cc', '\ub0cd', '\ub0ce', '\ub0cf', '\ub0d1', '\ub0d2', 
    '\ub0d3', '\ub0d4', '\ub0d5', '\ub0d6', '\ub0d7', '\ub0d8', '\ub0d9', '\ub0da', 
    '\ub0db', '\ub0dc', '\ub0dd', '\ub0de', '\ub0df', '\ub0e0', '\ub0e1', '\ub0e2', 
    '\ub0e3', '\ub0e4', '\ub0e5', '\ub0e6', '\ub0e7', '\ub0e8', '\ub0e9', '\ub0ea', 
    '\ub0eb', '\ub0ed', '\ub0ee', '\ub0ef', '\ub0f0', '\ub0f1', '\ub0f2', '\ub0f3', 
    '\ub0f4', '\ub0f5', '\ub0f6', '\ub0f7', '\ub0f8', '\ub0f9', '\ub0fa', '\ub0fb', 
    '\ub0fc', '\ub0fd', '\ub0fe', '\ub0ff', '\ub100', '\ub101', '\ub102', '\ub103', 
    '\ub104', '\ub105', '\ub106', '\ub107', '\ub109', '\ub10a', '\ub10b', '\ub10c', 
    '\ub10d', '\ub10e', '\ub10f', '\ub110', '\ub111', '\ub112', '\ub113', '\ub114', 
    '\ub115', '\ub116', '\ub117', '\ub118', '\ub119', '\ub11a', '\ub11b', '\ub11c', 
    '\ub11d', '\ub11e', '\ub11f', '\ub120', '\ub121', '\ub122', '\ub123', '\ub125', 
    '\ub126', '\ub127', '\ub128', '\ub129', '\ub12a', '\ub12b', '\ub12c', '\ub12d', 
    '\ub12e', '\ub12f', '\ub130', '\ub131', '\ub132', '\ub133', '\ub134', '\ub135', 
    '\ub136', '\ub137', '\ub138', '\ub139', '\ub13a', '\ub13b', '\ub13c', '\ub13d', 
    '\ub13e', '\ub13f', '\ub141', '\ub142', '\ub143', '\ub144', '\ub145', '\ub146', 
    '\ub147', '\ub148', '\ub149', '\ub14a', '\ub14b', '\ub14c', '\ub14d', '\ub14e', 
    '\ub14f', '\ub150', '\ub151', '\ub152', '\ub153', '\ub154', '\ub155', '\ub156', 
    '\ub157', '\ub158', '\ub159', '\ub15a', '\ub15b', '\ub15d', '\ub15e', '\ub15f', 
    '\ub160', '\ub161', '\ub162', '\ub163', '\ub164', '\ub165', '\ub166', '\ub167', 
    '\ub168', '\ub169', '\ub16a', '\ub16b', '\ub16c', '\ub16d', '\ub16e', '\ub16f', 
    '\ub170', '\ub171', '\ub172', '\ub173', '\ub174', '\ub175', '\ub176', '\ub177', 
    '\ub179', '\ub17a', '\ub17b', '\ub17c', '\ub17d', '\ub17e', '\ub17f', '\ub180', 
    '\ub181', '\ub182', '\ub183', '\ub184', '\ub185', '\ub186', '\ub187', '\ub188', 
    '\ub189', '\ub18a', '\ub18b', '\ub18c', '\ub18d', '\ub18e', '\ub18f', '\ub190', 
    '\ub191', '\ub192', '\ub193', '\ub195', '\ub196', '\ub197', '\ub198', '\ub199', 
    '\ub19a', '\ub19b', '\ub19c', '\ub19d', '\ub19e', '\ub19f', '\ub1a0', '\ub1a1', 
    '\ub1a2', '\ub1a3', '\ub1a4', '\ub1a5', '\ub1a6', '\ub1a7', '\ub1a8', '\ub1a9', 
    '\ub1aa', '\ub1ab', '\ub1ac', '\ub1ad', '\ub1ae', '\ub1af', '\ub1b1', '\ub1b2', 
    '\ub1b3', '\ub1b4', '\ub1b5', '\ub1b6', '\ub1b7', '\ub1b8', '\ub1b9', '\ub1ba', 
    '\ub1bb', '\ub1bc', '\ub1bd', '\ub1be', '\ub1bf', '\ub1c0', '\ub1c1', '\ub1c2', 
    '\ub1c3', '\ub1c4', '\ub1c5', '\ub1c6', '\ub1c7', '\ub1c8', '\ub1c9', '\ub1ca', 
    '\ub1cb', '\ub1cd', '\ub1ce', '\ub1cf', '\ub1d0', '\ub1d1', '\ub1d2', '\ub1d3', 
    '\ub1d4', '\ub1d5', '\ub1d6', '\ub1d7', '\ub1d8', '\ub1d9', '\ub1da', '\ub1db', 
    '\ub1dc', '\ub1dd', '\ub1de', '\ub1df', '\ub1e0', '\ub1e1', '\ub1e2', '\ub1e3', 
    '\ub1e4', '\ub1e5', '\ub1e6', '\ub1e7', '\ub1e9', '\ub1ea', '\ub1eb', '\ub1ec', 
    '\ub1ed', '\ub1ee', '\ub1ef', '\ub1f0', '\ub1f1', '\ub1f2', '\ub1f3', '\ub1f4', 
    '\ub1f5', '\ub1f6', '\ub1f7', '\ub1f8', '\ub1f9', '\ub1fa', '\ub1fb', '\ub1fc', 
    '\ub1fd', '\ub1fe', '\ub1ff', '\ub200', '\ub201', '\ub202', '\ub203', '\ub205', 
    '\ub206', '\ub207', '\ub208', '\ub209', '\ub20a', '\ub20b', '\ub20c', '\ub20d', 
    '\ub20e', '\ub20f', '\ub210', '\ub211', '\ub212', '\ub213', '\ub214', '\ub215', 
    '\ub216', '\ub217', '\ub218', '\ub219', '\ub21a', '\ub21b', '\ub21c', '\ub21d', 
    '\ub21e', '\ub21f', '\ub221', '\ub222', '\ub223', '\ub224', '\ub225', '\ub226', 
    '\ub227', '\ub228', '\ub229', '\ub22a', '\ub22b', '\ub22c', '\ub22d', '\ub22e', 
    '\ub22f', '\ub230', '\ub231', '\ub232', '\ub233', '\ub234', '\ub235', '\ub236', 
    '\ub237', '\ub238', '\ub239', '\ub23a', '\ub23b', '\ub23d', '\ub23e', '\ub23f', 
    '\ub240', '\ub241', '\ub242', '\ub243', '\ub244', '\ub245', '\ub246', '\ub247', 
    '\ub248', '\ub249', '\ub24a', '\ub24b', '\ub24c', '\ub24d', '\ub24e', '\ub24f', 
    '\ub250', '\ub251', '\ub252', '\ub253', '\ub254', '\ub255', '\ub256', '\ub257', 
    '\ub259', '\ub25a', '\ub25b', '\ub25c', '\ub25d', '\ub25e', '\ub25f', '\ub260', 
    '\ub261', '\ub262', '\ub263', '\ub264', '\ub265', '\ub266', '\ub267', '\ub268', 
    '\ub269', '\ub26a', '\ub26b', '\ub26c', '\ub26d', '\ub26e', '\ub26f', '\ub270', 
    '\ub271', '\ub272', '\ub273', '\ub275', '\ub276', '\ub277', '\ub278', '\ub279', 
    '\ub27a', '\ub27b', '\ub27c', '\ub27d', '\ub27e', '\ub27f', '\ub280', '\ub281', 
    '\ub282', '\ub283', '\ub284', '\ub285', '\ub286', '\ub287', '\ub288', '\ub289', 
    '\ub28a', '\ub28b', '\ub28c', '\ub28d', '\ub28e', '\ub28f', '\ub291', '\ub292', 
    '\ub293', '\ub294', '\ub295', '\ub296', '\ub297', '\ub298', '\ub299', '\ub29a', 
    '\ub29b', '\ub29c', '\ub29d', '\ub29e', '\ub29f', '\ub2a0', '\ub2a1', '\ub2a2', 
    '\ub2a3', '\ub2a4', '\ub2a5', '\ub2a6', '\ub2a7', '\ub2a8', '\ub2a9', '\ub2aa', 
    '\ub2ab', '\ub2ad', '\ub2ae', '\ub2af', '\ub2b0', '\ub2b1', '\ub2b2', '\ub2b3', 
    '\ub2b4', '\ub2b5', '\ub2b6', '\ub2b7', '\ub2b8', '\ub2b9', '\ub2ba', '\ub2bb', 
    '\ub2bc', '\ub2bd', '\ub2be', '\ub2bf', '\ub2c0', '\ub2c1', '\ub2c2', '\ub2c3', 
    '\ub2c4', '\ub2c5', '\ub2c6', '\ub2c7', '\ub2c9', '\ub2ca', '\ub2cb', '\ub2cc', 
    '\ub2cd', '\ub2ce', '\ub2cf', '\ub2d0', '\ub2d1', '\ub2d2', '\ub2d3', '\ub2d4', 
    '\ub2d5', '\ub2d6', '\ub2d7', '\ub2d8', '\ub2d9', '\ub2da', '\ub2db', '\ub2dc', 
    '\ub2dd', '\ub2de', '\ub2df', '\ub2e0', '\ub2e1', '\ub2e2', '\ub2e3', '\ub2e5', 
    '\ub2e6', '\ub2e7', '\ub2e8', '\ub2e9', '\ub2ea', '\ub2eb', '\ub2ec', '\ub2ed', 
    '\ub2ee', '\ub2ef', '\ub2f0', '\ub2f1', '\ub2f2', '\ub2f3', '\ub2f4', '\ub2f5', 
    '\ub2f6', '\ub2f7', '\ub2f8', '\ub2f9', '\ub2fa', '\ub2fb', '\ub2fc', '\ub2fd', 
    '\ub2fe', '\ub2ff', '\ub301', '\ub302', '\ub303', '\ub304', '\ub305', '\ub306', 
    '\ub307', '\ub308', '\ub309', '\ub30a', '\ub30b', '\ub30c', '\ub30d', '\ub30e', 
    '\ub30f', '\ub310', '\ub311', '\ub312', '\ub313', '\ub314', '\ub315', '\ub316', 
    '\ub317', '\ub318', '\ub319', '\ub31a', '\ub31b', '\ub31d', '\ub31e', '\ub31f', 
    '\ub320', '\ub321', '\ub322', '\ub323', '\ub324', '\ub325', '\ub326', '\ub327', 
    '\ub328', '\ub329', '\ub32a', '\ub32b', '\ub32c', '\ub32d', '\ub32e', '\ub32f', 
    '\ub330', '\ub331', '\ub332', '\ub333', '\ub334', '\ub335', '\ub336', '\ub337', 
    '\ub339', '\ub33a', '\ub33b', '\ub33c', '\ub33d', '\ub33e', '\ub33f', '\ub340', 
    '\ub341', '\ub342', '\ub343', '\ub344', '\ub345', '\ub346', '\ub347', '\ub348', 
    '\ub349', '\ub34a', '\ub34b', '\ub34c', '\ub34d', '\ub34e', '\ub34f', '\ub350', 
    '\ub351', '\ub352', '\ub353', '\ub355', '\ub356', '\ub357', '\ub358', '\ub359', 
    '\ub35a', '\ub35b', '\ub35c', '\ub35d', '\ub35e', '\ub35f', '\ub360', '\ub361', 
    '\ub362', '\ub363', '\ub364', '\ub365', '\ub366', '\ub367', '\ub368', '\ub369', 
    '\ub36a', '\ub36b', '\ub36c', '\ub36d', '\ub36e', '\ub36f', '\ub371', '\ub372', 
    '\ub373', '\ub374', '\ub375', '\ub376', '\ub377', '\ub378', '\ub379', '\ub37a', 
    '\ub37b', '\ub37c', '\ub37d', '\ub37e', '\ub37f', '\ub380', '\ub381', '\ub382', 
    '\ub383', '\ub384', '\ub385', '\ub386', '\ub387', '\ub388', '\ub389', '\ub38a', 
    '\ub38b', '\ub38d', '\ub38e', '\ub38f', '\ub390', '\ub391', '\ub392', '\ub393', 
    '\ub394', '\ub395', '\ub396', '\ub397', '\ub398', '\ub399', '\ub39a', '\ub39b', 
    '\ub39c', '\ub39d', '\ub39e', '\ub39f', '\ub3a0', '\ub3a1', '\ub3a2', '\ub3a3', 
    '\ub3a4', '\ub3a5', '\ub3a6', '\ub3a7', '\ub3a9', '\ub3aa', '\ub3ab', '\ub3ac', 
    '\ub3ad', '\ub3ae', '\ub3af', '\ub3b0', '\ub3b1', '\ub3b2', '\ub3b3', '\ub3b4', 
    '\ub3b5', '\ub3b6', '\ub3b7', '\ub3b8', '\ub3b9', '\ub3ba', '\ub3bb', '\ub3bc', 
    '\ub3bd', '\ub3be', '\ub3bf', '\ub3c0', '\ub3c1', '\ub3c2', '\ub3c3', '\ub3c5', 
    '\ub3c6', '\ub3c7', '\ub3c8', '\ub3c9', '\ub3ca', '\ub3cb', '\ub3cc', '\ub3cd', 
    '\ub3ce', '\ub3cf', '\ub3d0', '\ub3d1', '\ub3d2', '\ub3d3', '\ub3d4', '\ub3d5', 
    '\ub3d6', '\ub3d7', '\ub3d8', '\ub3d9', '\ub3da', '\ub3db', '\ub3dc', '\ub3dd', 
    '\ub3de', '\ub3df', '\ub3e1', '\ub3e2', '\ub3e3', '\ub3e4', '\ub3e5', '\ub3e6', 
    '\ub3e7', '\ub3e8', '\ub3e9', '\ub3ea', '\ub3eb', '\ub3ec', '\ub3ed', '\ub3ee', 
    '\ub3ef', '\ub3f0', '\ub3f1', '\ub3f2', '\ub3f3', '\ub3f4', '\ub3f5', '\ub3f6', 
    '\ub3f7', '\ub3f8', '\ub3f9', '\ub3fa', '\ub3fb', '\ub3fd', '\ub3fe', '\ub3ff', 
    '\ub400', '\ub401', '\ub402', '\ub403', '\ub404', '\ub405', '\ub406', '\ub407', 
    '\ub408', '\ub409', '\ub40a', '\ub40b', '\ub40c', '\ub40d', '\ub40e', '\ub40f', 
    '\ub410', '\ub411', '\ub412', '\ub413', '\ub414', '\ub415', '\ub416', '\ub417', 
    '\ub419', '\ub41a', '\ub41b', '\ub41c', '\ub41d', '\ub41e', '\ub41f', '\ub420', 
    '\ub421', '\ub422', '\ub423', '\ub424', '\ub425', '\ub426', '\ub427', '\ub428', 
    '\ub429', '\ub42a', '\ub42b', '\ub42c', '\ub42d', '\ub42e', '\ub42f', '\ub430', 
    '\ub431', '\ub432', '\ub433', '\ub435', '\ub436', '\ub437', '\ub438', '\ub439', 
    '\ub43a', '\ub43b', '\ub43c', '\ub43d', '\ub43e', '\ub43f', '\ub440', '\ub441', 
    '\ub442', '\ub443', '\ub444', '\ub445', '\ub446', '\ub447', '\ub448', '\ub449', 
    '\ub44a', '\ub44b', '\ub44c', '\ub44d', '\ub44e', '\ub44f', '\ub451', '\ub452', 
    '\ub453', '\ub454', '\ub455', '\ub456', '\ub457', '\ub458', '\ub459', '\ub45a', 
    '\ub45b', '\ub45c', '\ub45d', '\ub45e', '\ub45f', '\ub460', '\ub461', '\ub462', 
    '\ub463', '\ub464', '\ub465', '\ub466', '\ub467', '\ub468', '\ub469', '\ub46a', 
    '\ub46b', '\ub46d', '\ub46e', '\ub46f', '\ub470', '\ub471', '\ub472', '\ub473', 
    '\ub474', '\ub475', '\ub476', '\ub477', '\ub478', '\ub479', '\ub47a', '\ub47b', 
    '\ub47c', '\ub47d', '\ub47e', '\ub47f', '\ub480', '\ub481', '\ub482', '\ub483', 
    '\ub484', '\ub485', '\ub486', '\ub487', '\ub489', '\ub48a', '\ub48b', '\ub48c', 
    '\ub48d', '\ub48e', '\ub48f', '\ub490', '\ub491', '\ub492', '\ub493', '\ub494', 
    '\ub495', '\ub496', '\ub497', '\ub498', '\ub499', '\ub49a', '\ub49b', '\ub49c', 
    '\ub49d', '\ub49e', '\ub49f', '\ub4a0', '\ub4a1', '\ub4a2', '\ub4a3', '\ub4a5', 
    '\ub4a6', '\ub4a7', '\ub4a8', '\ub4a9', '\ub4aa', '\ub4ab', '\ub4ac', '\ub4ad', 
    '\ub4ae', '\ub4af', '\ub4b0', '\ub4b1', '\ub4b2', '\ub4b3', '\ub4b4', '\ub4b5', 
    '\ub4b6', '\ub4b7', '\ub4b8', '\ub4b9', '\ub4ba', '\ub4bb', '\ub4bc', '\ub4bd', 
    '\ub4be', '\ub4bf', '\ub4c1', '\ub4c2', '\ub4c3', '\ub4c4', '\ub4c5', '\ub4c6', 
    '\ub4c7', '\ub4c8', '\ub4c9', '\ub4ca', '\ub4cb', '\ub4cc', '\ub4cd', '\ub4ce', 
    '\ub4cf', '\ub4d0', '\ub4d1', '\ub4d2', '\ub4d3', '\ub4d4', '\ub4d5', '\ub4d6', 
    '\ub4d7', '\ub4d8', '\ub4d9', '\ub4da', '\ub4db', '\ub4dd', '\ub4de', '\ub4df', 
    '\ub4e0', '\ub4e1', '\ub4e2', '\ub4e3', '\ub4e4', '\ub4e5', '\ub4e6', '\ub4e7', 
    '\ub4e8', '\ub4e9', '\ub4ea', '\ub4eb', '\ub4ec', '\ub4ed', '\ub4ee', '\ub4ef', 
    '\ub4f0', '\ub4f1', '\ub4f2', '\ub4f3', '\ub4f4', '\ub4f5', '\ub4f6', '\ub4f7', 
    '\ub4f9', '\ub4fa', '\ub4fb', '\ub4fc', '\ub4fd', '\ub4fe', '\ub4ff', '\ub500', 
    '\ub501', '\ub502', '\ub503', '\ub504', '\ub505', '\ub506', '\ub507', '\ub508', 
    '\ub509', '\ub50a', '\ub50b', '\ub50c', '\ub50d', '\ub50e', '\ub50f', '\ub510', 
    '\ub511', '\ub512', '\ub513', '\ub515', '\ub516', '\ub517', '\ub518', '\ub519', 
    '\ub51a', '\ub51b', '\ub51c', '\ub51d', '\ub51e', '\ub51f', '\ub520', '\ub521', 
    '\ub522', '\ub523', '\ub524', '\ub525', '\ub526', '\ub527', '\ub528', '\ub529', 
    '\ub52a', '\ub52b', '\ub52c', '\ub52d', '\ub52e', '\ub52f', '\ub531', '\ub532', 
    '\ub533', '\ub534', '\ub535', '\ub536', '\ub537', '\ub538', '\ub539', '\ub53a', 
    '\ub53b', '\ub53c', '\ub53d', '\ub53e', '\ub53f', '\ub540', '\ub541', '\ub542', 
    '\ub543', '\ub544', '\ub545', '\ub546', '\ub547', '\ub548', '\ub549', '\ub54a', 
    '\ub54b', '\ub54d', '\ub54e', '\ub54f', '\ub550', '\ub551', '\ub552', '\ub553', 
    '\ub554', '\ub555', '\ub556', '\ub557', '\ub558', '\ub559', '\ub55a', '\ub55b', 
    '\ub55c', '\ub55d', '\ub55e', '\ub55f', '\ub560', '\ub561', '\ub562', '\ub563', 
    '\ub564', '\ub565', '\ub566', '\ub567', '\ub569', '\ub56a', '\ub56b', '\ub56c', 
    '\ub56d', '\ub56e', '\ub56f', '\ub570', '\ub571', '\ub572', '\ub573', '\ub574', 
    '\ub575', '\ub576', '\ub577', '\ub578', '\ub579', '\ub57a', '\ub57b', '\ub57c', 
    '\ub57d', '\ub57e', '\ub57f', '\ub580', '\ub581', '\ub582', '\ub583', '\ub585', 
    '\ub586', '\ub587', '\ub588', '\ub589', '\ub58a', '\ub58b', '\ub58c', '\ub58d', 
    '\ub58e', '\ub58f', '\ub590', '\ub591', '\ub592', '\ub593', '\ub594', '\ub595', 
    '\ub596', '\ub597', '\ub598', '\ub599', '\ub59a', '\ub59b', '\ub59c', '\ub59d', 
    '\ub59e', '\ub59f', '\ub5a1', '\ub5a2', '\ub5a3', '\ub5a4', '\ub5a5', '\ub5a6', 
    '\ub5a7', '\ub5a8', '\ub5a9', '\ub5aa', '\ub5ab', '\ub5ac', '\ub5ad', '\ub5ae', 
    '\ub5af', '\ub5b0', '\ub5b1', '\ub5b2', '\ub5b3', '\ub5b4', '\ub5b5', '\ub5b6', 
    '\ub5b7', '\ub5b8', '\ub5b9', '\ub5ba', '\ub5bb', '\ub5bd', '\ub5be', '\ub5bf', 
    '\ub5c0', '\ub5c1', '\ub5c2', '\ub5c3', '\ub5c4', '\ub5c5', '\ub5c6', '\ub5c7', 
    '\ub5c8', '\ub5c9', '\ub5ca', '\ub5cb', '\ub5cc', '\ub5cd', '\ub5ce', '\ub5cf', 
    '\ub5d0', '\ub5d1', '\ub5d2', '\ub5d3', '\ub5d4', '\ub5d5', '\ub5d6', '\ub5d7', 
    '\ub5d9', '\ub5da', '\ub5db', '\ub5dc', '\ub5dd', '\ub5de', '\ub5df', '\ub5e0', 
    '\ub5e1', '\ub5e2', '\ub5e3', '\ub5e4', '\ub5e5', '\ub5e6', '\ub5e7', '\ub5e8', 
    '\ub5e9', '\ub5ea', '\ub5eb', '\ub5ec', '\ub5ed', '\ub5ee', '\ub5ef', '\ub5f0', 
    '\ub5f1', '\ub5f2', '\ub5f3', '\ub5f5', '\ub5f6', '\ub5f7', '\ub5f8', '\ub5f9', 
    '\ub5fa', '\ub5fb', '\ub5fc', '\ub5fd', '\ub5fe', '\ub5ff', '\ub600', '\ub601', 
    '\ub602', '\ub603', '\ub604', '\ub605', '\ub606', '\ub607', '\ub608', '\ub609', 
    '\ub60a', '\ub60b', '\ub60c', '\ub60d', '\ub60e', '\ub60f', '\ub611', '\ub612', 
    '\ub613', '\ub614', '\ub615', '\ub616', '\ub617', '\ub618', '\ub619', '\ub61a', 
    '\ub61b', '\ub61c', '\ub61d', '\ub61e', '\ub61f', '\ub620', '\ub621', '\ub622', 
    '\ub623', '\ub624', '\ub625', '\ub626', '\ub627', '\ub628', '\ub629', '\ub62a', 
    '\ub62b', '\ub62d', '\ub62e', '\ub62f', '\ub630', '\ub631', '\ub632', '\ub633', 
    '\ub634', '\ub635', '\ub636', '\ub637', '\ub638', '\ub639', '\ub63a', '\ub63b', 
    '\ub63c', '\ub63d', '\ub63e', '\ub63f', '\ub640', '\ub641', '\ub642', '\ub643', 
    '\ub644', '\ub645', '\ub646', '\ub647', '\ub649', '\ub64a', '\ub64b', '\ub64c', 
    '\ub64d', '\ub64e', '\ub64f', '\ub650', '\ub651', '\ub652', '\ub653', '\ub654', 
    '\ub655', '\ub656', '\ub657', '\ub658', '\ub659', '\ub65a', '\ub65b', '\ub65c', 
    '\ub65d', '\ub65e', '\ub65f', '\ub660', '\ub661', '\ub662', '\ub663', '\ub665', 
    '\ub666', '\ub667', '\ub668', '\ub669', '\ub66a', '\ub66b', '\ub66c', '\ub66d', 
    '\ub66e', '\ub66f', '\ub670', '\ub671', '\ub672', '\ub673', '\ub674', '\ub675', 
    '\ub676', '\ub677', '\ub678', '\ub679', '\ub67a', '\ub67b', '\ub67c', '\ub67d', 
    '\ub67e', '\ub67f', '\ub681', '\ub682', '\ub683', '\ub684', '\ub685', '\ub686', 
    '\ub687', '\ub688', '\ub689', '\ub68a', '\ub68b', '\ub68c', '\ub68d', '\ub68e', 
    '\ub68f', '\ub690', '\ub691', '\ub692', '\ub693', '\ub694', '\ub695', '\ub696', 
    '\ub697', '\ub698', '\ub699', '\ub69a', '\ub69b', '\ub69d', '\ub69e', '\ub69f', 
    '\ub6a0', '\ub6a1', '\ub6a2', '\ub6a3', '\ub6a4', '\ub6a5', '\ub6a6', '\ub6a7', 
    '\ub6a8', '\ub6a9', '\ub6aa', '\ub6ab', '\ub6ac', '\ub6ad', '\ub6ae', '\ub6af', 
    '\ub6b0', '\ub6b1', '\ub6b2', '\ub6b3', '\ub6b4', '\ub6b5', '\ub6b6', '\ub6b7', 
    '\ub6b9', '\ub6ba', '\ub6bb', '\ub6bc', '\ub6bd', '\ub6be', '\ub6bf', '\ub6c0', 
    '\ub6c1', '\ub6c2', '\ub6c3', '\ub6c4', '\ub6c5', '\ub6c6', '\ub6c7', '\ub6c8', 
    '\ub6c9', '\ub6ca', '\ub6cb', '\ub6cc', '\ub6cd', '\ub6ce', '\ub6cf', '\ub6d0', 
    '\ub6d1', '\ub6d2', '\ub6d3', '\ub6d5', '\ub6d6', '\ub6d7', '\ub6d8', '\ub6d9', 
    '\ub6da', '\ub6db', '\ub6dc', '\ub6dd', '\ub6de', '\ub6df', '\ub6e0', '\ub6e1', 
    '\ub6e2', '\ub6e3', '\ub6e4', '\ub6e5', '\ub6e6', '\ub6e7', '\ub6e8', '\ub6e9', 
    '\ub6ea', '\ub6eb', '\ub6ec', '\ub6ed', '\ub6ee', '\ub6ef', '\ub6f1', '\ub6f2', 
    '\ub6f3', '\ub6f4', '\ub6f5', '\ub6f6', '\ub6f7', '\ub6f8', '\ub6f9', '\ub6fa', 
    '\ub6fb', '\ub6fc', '\ub6fd', '\ub6fe', '\ub6ff', '\ub700', '\ub701', '\ub702', 
    '\ub703', '\ub704', '\ub705', '\ub706', '\ub707', '\ub708', '\ub709', '\ub70a', 
    '\ub70b', '\ub70d', '\ub70e', '\ub70f', '\ub710', '\ub711', '\ub712', '\ub713', 
    '\ub714', '\ub715', '\ub716', '\ub717', '\ub718', '\ub719', '\ub71a', '\ub71b', 
    '\ub71c', '\ub71d', '\ub71e', '\ub71f', '\ub720', '\ub721', '\ub722', '\ub723', 
    '\ub724', '\ub725', '\ub726', '\ub727', '\ub729', '\ub72a', '\ub72b', '\ub72c', 
    '\ub72d', '\ub72e', '\ub72f', '\ub730', '\ub731', '\ub732', '\ub733', '\ub734', 
    '\ub735', '\ub736', '\ub737', '\ub738', '\ub739', '\ub73a', '\ub73b', '\ub73c', 
    '\ub73d', '\ub73e', '\ub73f', '\ub740', '\ub741', '\ub742', '\ub743', '\ub745', 
    '\ub746', '\ub747', '\ub748', '\ub749', '\ub74a', '\ub74b', '\ub74c', '\ub74d', 
    '\ub74e', '\ub74f', '\ub750', '\ub751', '\ub752', '\ub753', '\ub754', '\ub755', 
    '\ub756', '\ub757', '\ub758', '\ub759', '\ub75a', '\ub75b', '\ub75c', '\ub75d', 
    '\ub75e', '\ub75f', '\ub761', '\ub762', '\ub763', '\ub764', '\ub765', '\ub766', 
    '\ub767', '\ub768', '\ub769', '\ub76a', '\ub76b', '\ub76c', '\ub76d', '\ub76e', 
    '\ub76f', '\ub770', '\ub771', '\ub772', '\ub773', '\ub774', '\ub775', '\ub776', 
    '\ub777', '\ub778', '\ub779', '\ub77a', '\ub77b', '\ub77d', '\ub77e', '\ub77f', 
    '\ub780', '\ub781', '\ub782', '\ub783', '\ub784', '\ub785', '\ub786', '\ub787', 
    '\ub788', '\ub789', '\ub78a', '\ub78b', '\ub78c', '\ub78d', '\ub78e', '\ub78f', 
    '\ub790', '\ub791', '\ub792', '\ub793', '\ub794', '\ub795', '\ub796', '\ub797', 
    '\ub799', '\ub79a', '\ub79b', '\ub79c', '\ub79d', '\ub79e', '\ub79f', '\ub7a0', 
    '\ub7a1', '\ub7a2', '\ub7a3', '\ub7a4', '\ub7a5', '\ub7a6', '\ub7a7', '\ub7a8', 
    '\ub7a9', '\ub7aa', '\ub7ab', '\ub7ac', '\ub7ad', '\ub7ae', '\ub7af', '\ub7b0', 
    '\ub7b1', '\ub7b2', '\ub7b3', '\ub7b5', '\ub7b6', '\ub7b7', '\ub7b8', '\ub7b9', 
    '\ub7ba', '\ub7bb', '\ub7bc', '\ub7bd', '\ub7be', '\ub7bf', '\ub7c0', '\ub7c1', 
    '\ub7c2', '\ub7c3', '\ub7c4', '\ub7c5', '\ub7c6', '\ub7c7', '\ub7c8', '\ub7c9', 
    '\ub7ca', '\ub7cb', '\ub7cc', '\ub7cd', '\ub7ce', '\ub7cf', '\ub7d1', '\ub7d2', 
    '\ub7d3', '\ub7d4', '\ub7d5', '\ub7d6', '\ub7d7', '\ub7d8', '\ub7d9', '\ub7da', 
    '\ub7db', '\ub7dc', '\ub7dd', '\ub7de', '\ub7df', '\ub7e0', '\ub7e1', '\ub7e2', 
    '\ub7e3', '\ub7e4', '\ub7e5', '\ub7e6', '\ub7e7', '\ub7e8', '\ub7e9', '\ub7ea', 
    '\ub7eb', '\ub7ed', '\ub7ee', '\ub7ef', '\ub7f0', '\ub7f1', '\ub7f2', '\ub7f3', 
    '\ub7f4', '\ub7f5', '\ub7f6', '\ub7f7', '\ub7f8', '\ub7f9', '\ub7fa', '\ub7fb', 
    '\ub7fc', '\ub7fd', '\ub7fe', '\ub7ff', '\ub800', '\ub801', '\ub802', '\ub803', 
    '\ub804', '\ub805', '\ub806', '\ub807', '\ub809', '\ub80a', '\ub80b', '\ub80c', 
    '\ub80d', '\ub80e', '\ub80f', '\ub810', '\ub811', '\ub812', '\ub813', '\ub814', 
    '\ub815', '\ub816', '\ub817', '\ub818', '\ub819', '\ub81a', '\ub81b', '\ub81c', 
    '\ub81d', '\ub81e', '\ub81f', '\ub820', '\ub821', '\ub822', '\ub823', '\ub825', 
    '\ub826', '\ub827', '\ub828', '\ub829', '\ub82a', '\ub82b', '\ub82c', '\ub82d', 
    '\ub82e', '\ub82f', '\ub830', '\ub831', '\ub832', '\ub833', '\ub834', '\ub835', 
    '\ub836', '\ub837', '\ub838', '\ub839', '\ub83a', '\ub83b', '\ub83c', '\ub83d', 
    '\ub83e', '\ub83f', '\ub841', '\ub842', '\ub843', '\ub844', '\ub845', '\ub846', 
    '\ub847', '\ub848', '\ub849', '\ub84a', '\ub84b', '\ub84c', '\ub84d', '\ub84e', 
    '\ub84f', '\ub850', '\ub851', '\ub852', '\ub853', '\ub854', '\ub855', '\ub856', 
    '\ub857', '\ub858', '\ub859', '\ub85a', '\ub85b', '\ub85d', '\ub85e', '\ub85f', 
    '\ub860', '\ub861', '\ub862', '\ub863', '\ub864', '\ub865', '\ub866', '\ub867', 
    '\ub868', '\ub869', '\ub86a', '\ub86b', '\ub86c', '\ub86d', '\ub86e', '\ub86f', 
    '\ub870', '\ub871', '\ub872', '\ub873', '\ub874', '\ub875', '\ub876', '\ub877', 
    '\ub879', '\ub87a', '\ub87b', '\ub87c', '\ub87d', '\ub87e', '\ub87f', '\ub880', 
    '\ub881', '\ub882', '\ub883', '\ub884', '\ub885', '\ub886', '\ub887', '\ub888', 
    '\ub889', '\ub88a', '\ub88b', '\ub88c', '\ub88d', '\ub88e', '\ub88f', '\ub890', 
    '\ub891', '\ub892', '\ub893', '\ub895', '\ub896', '\ub897', '\ub898', '\ub899', 
    '\ub89a', '\ub89b', '\ub89c', '\ub89d', '\ub89e', '\ub89f', '\ub8a0', '\ub8a1', 
    '\ub8a2', '\ub8a3', '\ub8a4', '\ub8a5', '\ub8a6', '\ub8a7', '\ub8a8', '\ub8a9', 
    '\ub8aa', '\ub8ab', '\ub8ac', '\ub8ad', '\ub8ae', '\ub8af', '\ub8b1', '\ub8b2', 
    '\ub8b3', '\ub8b4', '\ub8b5', '\ub8b6', '\ub8b7', '\ub8b8', '\ub8b9', '\ub8ba', 
    '\ub8bb', '\ub8bc', '\ub8bd', '\ub8be', '\ub8bf', '\ub8c0', '\ub8c1', '\ub8c2', 
    '\ub8c3', '\ub8c4', '\ub8c5', '\ub8c6', '\ub8c7', '\ub8c8', '\ub8c9', '\ub8ca', 
    '\ub8cb', '\ub8cd', '\ub8ce', '\ub8cf', '\ub8d0', '\ub8d1', '\ub8d2', '\ub8d3', 
    '\ub8d4', '\ub8d5', '\ub8d6', '\ub8d7', '\ub8d8', '\ub8d9', '\ub8da', '\ub8db', 
    '\ub8dc', '\ub8dd', '\ub8de', '\ub8df', '\ub8e0', '\ub8e1', '\ub8e2', '\ub8e3', 
    '\ub8e4', '\ub8e5', '\ub8e6', '\ub8e7', '\ub8e9', '\ub8ea', '\ub8eb', '\ub8ec', 
    '\ub8ed', '\ub8ee', '\ub8ef', '\ub8f0', '\ub8f1', '\ub8f2', '\ub8f3', '\ub8f4', 
    '\ub8f5', '\ub8f6', '\ub8f7', '\ub8f8', '\ub8f9', '\ub8fa', '\ub8fb', '\ub8fc', 
    '\ub8fd', '\ub8fe', '\ub8ff', '\ub900', '\ub901', '\ub902', '\ub903', '\ub905', 
    '\ub906', '\ub907', '\ub908', '\ub909', '\ub90a', '\ub90b', '\ub90c', '\ub90d', 
    '\ub90e', '\ub90f', '\ub910', '\ub911', '\ub912', '\ub913', '\ub914', '\ub915', 
    '\ub916', '\ub917', '\ub918', '\ub919', '\ub91a', '\ub91b', '\ub91c', '\ub91d', 
    '\ub91e', '\ub91f', '\ub921', '\ub922', '\ub923', '\ub924', '\ub925', '\ub926', 
    '\ub927', '\ub928', '\ub929', '\ub92a', '\ub92b', '\ub92c', '\ub92d', '\ub92e', 
    '\ub92f', '\ub930', '\ub931', '\ub932', '\ub933', '\ub934', '\ub935', '\ub936', 
    '\ub937', '\ub938', '\ub939', '\ub93a', '\ub93b', '\ub93d', '\ub93e', '\ub93f', 
    '\ub940', '\ub941', '\ub942', '\ub943', '\ub944', '\ub945', '\ub946', '\ub947', 
    '\ub948', '\ub949', '\ub94a', '\ub94b', '\ub94c', '\ub94d', '\ub94e', '\ub94f', 
    '\ub950', '\ub951', '\ub952', '\ub953', '\ub954', '\ub955', '\ub956', '\ub957', 
    '\ub959', '\ub95a', '\ub95b', '\ub95c', '\ub95d', '\ub95e', '\ub95f', '\ub960', 
    '\ub961', '\ub962', '\ub963', '\ub964', '\ub965', '\ub966', '\ub967', '\ub968', 
    '\ub969', '\ub96a', '\ub96b', '\ub96c', '\ub96d', '\ub96e', '\ub96f', '\ub970', 
    '\ub971', '\ub972', '\ub973', '\ub975', '\ub976', '\ub977', '\ub978', '\ub979', 
    '\ub97a', '\ub97b', '\ub97c', '\ub97d', '\ub97e', '\ub97f', '\ub980', '\ub981', 
    '\ub982', '\ub983', '\ub984', '\ub985', '\ub986', '\ub987', '\ub988', '\ub989', 
    '\ub98a', '\ub98b', '\ub98c', '\ub98d', '\ub98e', '\ub98f', '\ub991', '\ub992', 
    '\ub993', '\ub994', '\ub995', '\ub996', '\ub997', '\ub998', '\ub999', '\ub99a', 
    '\ub99b', '\ub99c', '\ub99d', '\ub99e', '\ub99f', '\ub9a0', '\ub9a1', '\ub9a2', 
    '\ub9a3', '\ub9a4', '\ub9a5', '\ub9a6', '\ub9a7', '\ub9a8', '\ub9a9', '\ub9aa', 
    '\ub9ab', '\ub9ad', '\ub9ae', '\ub9af', '\ub9b0', '\ub9b1', '\ub9b2', '\ub9b3', 
    '\ub9b4', '\ub9b5', '\ub9b6', '\ub9b7', '\ub9b8', '\ub9b9', '\ub9ba', '\ub9bb', 
    '\ub9bc', '\ub9bd', '\ub9be', '\ub9bf', '\ub9c0', '\ub9c1', '\ub9c2', '\ub9c3', 
    '\ub9c4', '\ub9c5', '\ub9c6', '\ub9c7', '\ub9c9', '\ub9ca', '\ub9cb', '\ub9cc', 
    '\ub9cd', '\ub9ce', '\ub9cf', '\ub9d0', '\ub9d1', '\ub9d2', '\ub9d3', '\ub9d4', 
    '\ub9d5', '\ub9d6', '\ub9d7', '\ub9d8', '\ub9d9', '\ub9da', '\ub9db', '\ub9dc', 
    '\ub9dd', '\ub9de', '\ub9df', '\ub9e0', '\ub9e1', '\ub9e2', '\ub9e3', '\ub9e5', 
    '\ub9e6', '\ub9e7', '\ub9e8', '\ub9e9', '\ub9ea', '\ub9eb', '\ub9ec', '\ub9ed', 
    '\ub9ee', '\ub9ef', '\ub9f0', '\ub9f1', '\ub9f2', '\ub9f3', '\ub9f4', '\ub9f5', 
    '\ub9f6', '\ub9f7', '\ub9f8', '\ub9f9', '\ub9fa', '\ub9fb', '\ub9fc', '\ub9fd', 
    '\ub9fe', '\ub9ff', '\uba01', '\uba02', '\uba03', '\uba04', '\uba05', '\uba06', 
    '\uba07', '\uba08', '\uba09', '\uba0a', '\uba0b', '\uba0c', '\uba0d', '\uba0e', 
    '\uba0f', '\uba10', '\uba11', '\uba12', '\uba13', '\uba14', '\uba15', '\uba16', 
    '\uba17', '\uba18', '\uba19', '\uba1a', '\uba1b', '\uba1d', '\uba1e', '\uba1f', 
    '\uba20', '\uba21', '\uba22', '\uba23', '\uba24', '\uba25', '\uba26', '\uba27', 
    '\uba28', '\uba29', '\uba2a', '\uba2b', '\uba2c', '\uba2d', '\uba2e', '\uba2f', 
    '\uba30', '\uba31', '\uba32', '\uba33', '\uba34', '\uba35', '\uba36', '\uba37', 
    '\uba39', '\uba3a', '\uba3b', '\uba3c', '\uba3d', '\uba3e', '\uba3f', '\uba40', 
    '\uba41', '\uba42', '\uba43', '\uba44', '\uba45', '\uba46', '\uba47', '\uba48', 
    '\uba49', '\uba4a', '\uba4b', '\uba4c', '\uba4d', '\uba4e', '\uba4f', '\uba50', 
    '\uba51', '\uba52', '\uba53', '\uba55', '\uba56', '\uba57', '\uba58', '\uba59', 
    '\uba5a', '\uba5b', '\uba5c', '\uba5d', '\uba5e', '\uba5f', '\uba60', '\uba61', 
    '\uba62', '\uba63', '\uba64', '\uba65', '\uba66', '\uba67', '\uba68', '\uba69', 
    '\uba6a', '\uba6b', '\uba6c', '\uba6d', '\uba6e', '\uba6f', '\uba71', '\uba72', 
    '\uba73', '\uba74', '\uba75', '\uba76', '\uba77', '\uba78', '\uba79', '\uba7a', 
    '\uba7b', '\uba7c', '\uba7d', '\uba7e', '\uba7f', '\uba80', '\uba81', '\uba82', 
    '\uba83', '\uba84', '\uba85', '\uba86', '\uba87', '\uba88', '\uba89', '\uba8a', 
    '\uba8b', '\uba8d', '\uba8e', '\uba8f', '\uba90', '\uba91', '\uba92', '\uba93', 
    '\uba94', '\uba95', '\uba96', '\uba97', '\uba98', '\uba99', '\uba9a', '\uba9b', 
    '\uba9c', '\uba9d', '\uba9e', '\uba9f', '\ubaa0', '\ubaa1', '\ubaa2', '\ubaa3', 
    '\ubaa4', '\ubaa5', '\ubaa6', '\ubaa7', '\ubaa9', '\ubaaa', '\ubaab', '\ubaac', 
    '\ubaad', '\ubaae', '\ubaaf', '\ubab0', '\ubab1', '\ubab2', '\ubab3', '\ubab4', 
    '\ubab5', '\ubab6', '\ubab7', '\ubab8', '\ubab9', '\ubaba', '\ubabb', '\ubabc', 
    '\ubabd', '\ubabe', '\ubabf', '\ubac0', '\ubac1', '\ubac2', '\ubac3', '\ubac5', 
    '\ubac6', '\ubac7', '\ubac8', '\ubac9', '\ubaca', '\ubacb', '\ubacc', '\ubacd', 
    '\ubace', '\ubacf', '\ubad0', '\ubad1', '\ubad2', '\ubad3', '\ubad4', '\ubad5', 
    '\ubad6', '\ubad7', '\ubad8', '\ubad9', '\ubada', '\ubadb', '\ubadc', '\ubadd', 
    '\ubade', '\ubadf', '\ubae1', '\ubae2', '\ubae3', '\ubae4', '\ubae5', '\ubae6', 
    '\ubae7', '\ubae8', '\ubae9', '\ubaea', '\ubaeb', '\ubaec', '\ubaed', '\ubaee', 
    '\ubaef', '\ubaf0', '\ubaf1', '\ubaf2', '\ubaf3', '\ubaf4', '\ubaf5', '\ubaf6', 
    '\ubaf7', '\ubaf8', '\ubaf9', '\ubafa', '\ubafb', '\ubafd', '\ubafe', '\ubaff', 
    '\ubb00', '\ubb01', '\ubb02', '\ubb03', '\ubb04', '\ubb05', '\ubb06', '\ubb07', 
    '\ubb08', '\ubb09', '\ubb0a', '\ubb0b', '\ubb0c', '\ubb0d', '\ubb0e', '\ubb0f', 
    '\ubb10', '\ubb11', '\ubb12', '\ubb13', '\ubb14', '\ubb15', '\ubb16', '\ubb17', 
    '\ubb19', '\ubb1a', '\ubb1b', '\ubb1c', '\ubb1d', '\ubb1e', '\ubb1f', '\ubb20', 
    '\ubb21', '\ubb22', '\ubb23', '\ubb24', '\ubb25', '\ubb26', '\ubb27', '\ubb28', 
    '\ubb29', '\ubb2a', '\ubb2b', '\ubb2c', '\ubb2d', '\ubb2e', '\ubb2f', '\ubb30', 
    '\ubb31', '\ubb32', '\ubb33', '\ubb35', '\ubb36', '\ubb37', '\ubb38', '\ubb39', 
    '\ubb3a', '\ubb3b', '\ubb3c', '\ubb3d', '\ubb3e', '\ubb3f', '\ubb40', '\ubb41', 
    '\ubb42', '\ubb43', '\ubb44', '\ubb45', '\ubb46', '\ubb47', '\ubb48', '\ubb49', 
    '\ubb4a', '\ubb4b', '\ubb4c', '\ubb4d', '\ubb4e', '\ubb4f', '\ubb51', '\ubb52', 
    '\ubb53', '\ubb54', '\ubb55', '\ubb56', '\ubb57', '\ubb58', '\ubb59', '\ubb5a', 
    '\ubb5b', '\ubb5c', '\ubb5d', '\ubb5e', '\ubb5f', '\ubb60', '\ubb61', '\ubb62', 
    '\ubb63', '\ubb64', '\ubb65', '\ubb66', '\ubb67', '\ubb68', '\ubb69', '\ubb6a', 
    '\ubb6b', '\ubb6d', '\ubb6e', '\ubb6f', '\ubb70', '\ubb71', '\ubb72', '\ubb73', 
    '\ubb74', '\ubb75', '\ubb76', '\ubb77', '\ubb78', '\ubb79', '\ubb7a', '\ubb7b', 
    '\ubb7c', '\ubb7d', '\ubb7e', '\ubb7f', '\ubb80', '\ubb81', '\ubb82', '\ubb83', 
    '\ubb84', '\ubb85', '\ubb86', '\ubb87', '\ubb89', '\ubb8a', '\ubb8b', '\ubb8c', 
    '\ubb8d', '\ubb8e', '\ubb8f', '\ubb90', '\ubb91', '\ubb92', '\ubb93', '\ubb94', 
    '\ubb95', '\ubb96', '\ubb97', '\ubb98', '\ubb99', '\ubb9a', '\ubb9b', '\ubb9c', 
    '\ubb9d', '\ubb9e', '\ubb9f', '\ubba0', '\ubba1', '\ubba2', '\ubba3', '\ubba5', 
    '\ubba6', '\ubba7', '\ubba8', '\ubba9', '\ubbaa', '\ubbab', '\ubbac', '\ubbad', 
    '\ubbae', '\ubbaf', '\ubbb0', '\ubbb1', '\ubbb2', '\ubbb3', '\ubbb4', '\ubbb5', 
    '\ubbb6', '\ubbb7', '\ubbb8', '\ubbb9', '\ubbba', '\ubbbb', '\ubbbc', '\ubbbd', 
    '\ubbbe', '\ubbbf', '\ubbc1', '\ubbc2', '\ubbc3', '\ubbc4', '\ubbc5', '\ubbc6', 
    '\ubbc7', '\ubbc8', '\ubbc9', '\ubbca', '\ubbcb', '\ubbcc', '\ubbcd', '\ubbce', 
    '\ubbcf', '\ubbd0', '\ubbd1', '\ubbd2', '\ubbd3', '\ubbd4', '\ubbd5', '\ubbd6', 
    '\ubbd7', '\ubbd8', '\ubbd9', '\ubbda', '\ubbdb', '\ubbdd', '\ubbde', '\ubbdf', 
    '\ubbe0', '\ubbe1', '\ubbe2', '\ubbe3', '\ubbe4', '\ubbe5', '\ubbe6', '\ubbe7', 
    '\ubbe8', '\ubbe9', '\ubbea', '\ubbeb', '\ubbec', '\ubbed', '\ubbee', '\ubbef', 
    '\ubbf0', '\ubbf1', '\ubbf2', '\ubbf3', '\ubbf4', '\ubbf5', '\ubbf6', '\ubbf7', 
    '\ubbf9', '\ubbfa', '\ubbfb', '\ubbfc', '\ubbfd', '\ubbfe', '\ubbff', '\ubc00', 
    '\ubc01', '\ubc02', '\ubc03', '\ubc04', '\ubc05', '\ubc06', '\ubc07', '\ubc08', 
    '\ubc09', '\ubc0a', '\ubc0b', '\ubc0c', '\ubc0d', '\ubc0e', '\ubc0f', '\ubc10', 
    '\ubc11', '\ubc12', '\ubc13', '\ubc15', '\ubc16', '\ubc17', '\ubc18', '\ubc19', 
    '\ubc1a', '\ubc1b', '\ubc1c', '\ubc1d', '\ubc1e', '\ubc1f', '\ubc20', '\ubc21', 
    '\ubc22', '\ubc23', '\ubc24', '\ubc25', '\ubc26', '\ubc27', '\ubc28', '\ubc29', 
    '\ubc2a', '\ubc2b', '\ubc2c', '\ubc2d', '\ubc2e', '\ubc2f', '\ubc31', '\ubc32', 
    '\ubc33', '\ubc34', '\ubc35', '\ubc36', '\ubc37', '\ubc38', '\ubc39', '\ubc3a', 
    '\ubc3b', '\ubc3c', '\ubc3d', '\ubc3e', '\ubc3f', '\ubc40', '\ubc41', '\ubc42', 
    '\ubc43', '\ubc44', '\ubc45', '\ubc46', '\ubc47', '\ubc48', '\ubc49', '\ubc4a', 
    '\ubc4b', '\ubc4d', '\ubc4e', '\ubc4f', '\ubc50', '\ubc51', '\ubc52', '\ubc53', 
    '\ubc54', '\ubc55', '\ubc56', '\ubc57', '\ubc58', '\ubc59', '\ubc5a', '\ubc5b', 
    '\ubc5c', '\ubc5d', '\ubc5e', '\ubc5f', '\ubc60', '\ubc61', '\ubc62', '\ubc63', 
    '\ubc64', '\ubc65', '\ubc66', '\ubc67', '\ubc69', '\ubc6a', '\ubc6b', '\ubc6c', 
    '\ubc6d', '\ubc6e', '\ubc6f', '\ubc70', '\ubc71', '\ubc72', '\ubc73', '\ubc74', 
    '\ubc75', '\ubc76', '\ubc77', '\ubc78', '\ubc79', '\ubc7a', '\ubc7b', '\ubc7c', 
    '\ubc7d', '\ubc7e', '\ubc7f', '\ubc80', '\ubc81', '\ubc82', '\ubc83', '\ubc85', 
    '\ubc86', '\ubc87', '\ubc88', '\ubc89', '\ubc8a', '\ubc8b', '\ubc8c', '\ubc8d', 
    '\ubc8e', '\ubc8f', '\ubc90', '\ubc91', '\ubc92', '\ubc93', '\ubc94', '\ubc95', 
    '\ubc96', '\ubc97', '\ubc98', '\ubc99', '\ubc9a', '\ubc9b', '\ubc9c', '\ubc9d', 
    '\ubc9e', '\ubc9f', '\ubca1', '\ubca2', '\ubca3', '\ubca4', '\ubca5', '\ubca6', 
    '\ubca7', '\ubca8', '\ubca9', '\ubcaa', '\ubcab', '\ubcac', '\ubcad', '\ubcae', 
    '\ubcaf', '\ubcb0', '\ubcb1', '\ubcb2', '\ubcb3', '\ubcb4', '\ubcb5', '\ubcb6', 
    '\ubcb7', '\ubcb8', '\ubcb9', '\ubcba', '\ubcbb', '\ubcbd', '\ubcbe', '\ubcbf', 
    '\ubcc0', '\ubcc1', '\ubcc2', '\ubcc3', '\ubcc4', '\ubcc5', '\ubcc6', '\ubcc7', 
    '\ubcc8', '\ubcc9', '\ubcca', '\ubccb', '\ubccc', '\ubccd', '\ubcce', '\ubccf', 
    '\ubcd0', '\ubcd1', '\ubcd2', '\ubcd3', '\ubcd4', '\ubcd5', '\ubcd6', '\ubcd7', 
    '\ubcd9', '\ubcda', '\ubcdb', '\ubcdc', '\ubcdd', '\ubcde', '\ubcdf', '\ubce0', 
    '\ubce1', '\ubce2', '\ubce3', '\ubce4', '\ubce5', '\ubce6', '\ubce7', '\ubce8', 
    '\ubce9', '\ubcea', '\ubceb', '\ubcec', '\ubced', '\ubcee', '\ubcef', '\ubcf0', 
    '\ubcf1', '\ubcf2', '\ubcf3', '\ubcf5', '\ubcf6', '\ubcf7', '\ubcf8', '\ubcf9', 
    '\ubcfa', '\ubcfb', '\ubcfc', '\ubcfd', '\ubcfe', '\ubcff', '\ubd00', '\ubd01', 
    '\ubd02', '\ubd03', '\ubd04', '\ubd05', '\ubd06', '\ubd07', '\ubd08', '\ubd09', 
    '\ubd0a', '\ubd0b', '\ubd0c', '\ubd0d', '\ubd0e', '\ubd0f', '\ubd11', '\ubd12', 
    '\ubd13', '\ubd14', '\ubd15', '\ubd16', '\ubd17', '\ubd18', '\ubd19', '\ubd1a', 
    '\ubd1b', '\ubd1c', '\ubd1d', '\ubd1e', '\ubd1f', '\ubd20', '\ubd21', '\ubd22', 
    '\ubd23', '\ubd24', '\ubd25', '\ubd26', '\ubd27', '\ubd28', '\ubd29', '\ubd2a', 
    '\ubd2b', '\ubd2d', '\ubd2e', '\ubd2f', '\ubd30', '\ubd31', '\ubd32', '\ubd33', 
    '\ubd34', '\ubd35', '\ubd36', '\ubd37', '\ubd38', '\ubd39', '\ubd3a', '\ubd3b', 
    '\ubd3c', '\ubd3d', '\ubd3e', '\ubd3f', '\ubd40', '\ubd41', '\ubd42', '\ubd43', 
    '\ubd44', '\ubd45', '\ubd46', '\ubd47', '\ubd49', '\ubd4a', '\ubd4b', '\ubd4c', 
    '\ubd4d', '\ubd4e', '\ubd4f', '\ubd50', '\ubd51', '\ubd52', '\ubd53', '\ubd54', 
    '\ubd55', '\ubd56', '\ubd57', '\ubd58', '\ubd59', '\ubd5a', '\ubd5b', '\ubd5c', 
    '\ubd5d', '\ubd5e', '\ubd5f', '\ubd60', '\ubd61', '\ubd62', '\ubd63', '\ubd65', 
    '\ubd66', '\ubd67', '\ubd68', '\ubd69', '\ubd6a', '\ubd6b', '\ubd6c', '\ubd6d', 
    '\ubd6e', '\ubd6f', '\ubd70', '\ubd71', '\ubd72', '\ubd73', '\ubd74', '\ubd75', 
    '\ubd76', '\ubd77', '\ubd78', '\ubd79', '\ubd7a', '\ubd7b', '\ubd7c', '\ubd7d', 
    '\ubd7e', '\ubd7f', '\ubd81', '\ubd82', '\ubd83', '\ubd84', '\ubd85', '\ubd86', 
    '\ubd87', '\ubd88', '\ubd89', '\ubd8a', '\ubd8b', '\ubd8c', '\ubd8d', '\ubd8e', 
    '\ubd8f', '\ubd90', '\ubd91', '\ubd92', '\ubd93', '\ubd94', '\ubd95', '\ubd96', 
    '\ubd97', '\ubd98', '\ubd99', '\ubd9a', '\ubd9b', '\ubd9d', '\ubd9e', '\ubd9f', 
    '\ubda0', '\ubda1', '\ubda2', '\ubda3', '\ubda4', '\ubda5', '\ubda6', '\ubda7', 
    '\ubda8', '\ubda9', '\ubdaa', '\ubdab', '\ubdac', '\ubdad', '\ubdae', '\ubdaf', 
    '\ubdb0', '\ubdb1', '\ubdb2', '\ubdb3', '\ubdb4', '\ubdb5', '\ubdb6', '\ubdb7', 
    '\ubdb9', '\ubdba', '\ubdbb', '\ubdbc', '\ubdbd', '\ubdbe', '\ubdbf', '\ubdc0', 
    '\ubdc1', '\ubdc2', '\ubdc3', '\ubdc4', '\ubdc5', '\ubdc6', '\ubdc7', '\ubdc8', 
    '\ubdc9', '\ubdca', '\ubdcb', '\ubdcc', '\ubdcd', '\ubdce', '\ubdcf', '\ubdd0', 
    '\ubdd1', '\ubdd2', '\ubdd3', '\ubdd5', '\ubdd6', '\ubdd7', '\ubdd8', '\ubdd9', 
    '\ubdda', '\ubddb', '\ubddc', '\ubddd', '\ubdde', '\ubddf', '\ubde0', '\ubde1', 
    '\ubde2', '\ubde3', '\ubde4', '\ubde5', '\ubde6', '\ubde7', '\ubde8', '\ubde9', 
    '\ubdea', '\ubdeb', '\ubdec', '\ubded', '\ubdee', '\ubdef', '\ubdf1', '\ubdf2', 
    '\ubdf3', '\ubdf4', '\ubdf5', '\ubdf6', '\ubdf7', '\ubdf8', '\ubdf9', '\ubdfa', 
    '\ubdfb', '\ubdfc', '\ubdfd', '\ubdfe', '\ubdff', '\ube00', '\ube01', '\ube02', 
    '\ube03', '\ube04', '\ube05', '\ube06', '\ube07', '\ube08', '\ube09', '\ube0a', 
    '\ube0b', '\ube0d', '\ube0e', '\ube0f', '\ube10', '\ube11', '\ube12', '\ube13', 
    '\ube14', '\ube15', '\ube16', '\ube17', '\ube18', '\ube19', '\ube1a', '\ube1b', 
    '\ube1c', '\ube1d', '\ube1e', '\ube1f', '\ube20', '\ube21', '\ube22', '\ube23', 
    '\ube24', '\ube25', '\ube26', '\ube27', '\ube29', '\ube2a', '\ube2b', '\ube2c', 
    '\ube2d', '\ube2e', '\ube2f', '\ube30', '\ube31', '\ube32', '\ube33', '\ube34', 
    '\ube35', '\ube36', '\ube37', '\ube38', '\ube39', '\ube3a', '\ube3b', '\ube3c', 
    '\ube3d', '\ube3e', '\ube3f', '\ube40', '\ube41', '\ube42', '\ube43', '\ube45', 
    '\ube46', '\ube47', '\ube48', '\ube49', '\ube4a', '\ube4b', '\ube4c', '\ube4d', 
    '\ube4e', '\ube4f', '\ube50', '\ube51', '\ube52', '\ube53', '\ube54', '\ube55', 
    '\ube56', '\ube57', '\ube58', '\ube59', '\ube5a', '\ube5b', '\ube5c', '\ube5d', 
    '\ube5e', '\ube5f', '\ube61', '\ube62', '\ube63', '\ube64', '\ube65', '\ube66', 
    '\ube67', '\ube68', '\ube69', '\ube6a', '\ube6b', '\ube6c', '\ube6d', '\ube6e', 
    '\ube6f', '\ube70', '\ube71', '\ube72', '\ube73', '\ube74', '\ube75', '\ube76', 
    '\ube77', '\ube78', '\ube79', '\ube7a', '\ube7b', '\ube7d', '\ube7e', '\ube7f', 
    '\ube80', '\ube81', '\ube82', '\ube83', '\ube84', '\ube85', '\ube86', '\ube87', 
    '\ube88', '\ube89', '\ube8a', '\ube8b', '\ube8c', '\ube8d', '\ube8e', '\ube8f', 
    '\ube90', '\ube91', '\ube92', '\ube93', '\ube94', '\ube95', '\ube96', '\ube97', 
    '\ube99', '\ube9a', '\ube9b', '\ube9c', '\ube9d', '\ube9e', '\ube9f', '\ubea0', 
    '\ubea1', '\ubea2', '\ubea3', '\ubea4', '\ubea5', '\ubea6', '\ubea7', '\ubea8', 
    '\ubea9', '\ubeaa', '\ubeab', '\ubeac', '\ubead', '\ubeae', '\ubeaf', '\ubeb0', 
    '\ubeb1', '\ubeb2', '\ubeb3', '\ubeb5', '\ubeb6', '\ubeb7', '\ubeb8', '\ubeb9', 
    '\ubeba', '\ubebb', '\ubebc', '\ubebd', '\ubebe', '\ubebf', '\ubec0', '\ubec1', 
    '\ubec2', '\ubec3', '\ubec4', '\ubec5', '\ubec6', '\ubec7', '\ubec8', '\ubec9', 
    '\ubeca', '\ubecb', '\ubecc', '\ubecd', '\ubece', '\ubecf', '\ubed1', '\ubed2', 
    '\ubed3', '\ubed4', '\ubed5', '\ubed6', '\ubed7', '\ubed8', '\ubed9', '\ubeda', 
    '\ubedb', '\ubedc', '\ubedd', '\ubede', '\ubedf', '\ubee0', '\ubee1', '\ubee2', 
    '\ubee3', '\ubee4', '\ubee5', '\ubee6', '\ubee7', '\ubee8', '\ubee9', '\ubeea', 
    '\ubeeb', '\ubeed', '\ubeee', '\ubeef', '\ubef0', '\ubef1', '\ubef2', '\ubef3', 
    '\ubef4', '\ubef5', '\ubef6', '\ubef7', '\ubef8', '\ubef9', '\ubefa', '\ubefb', 
    '\ubefc', '\ubefd', '\ubefe', '\ubeff', '\ubf00', '\ubf01', '\ubf02', '\ubf03', 
    '\ubf04', '\ubf05', '\ubf06', '\ubf07', '\ubf09', '\ubf0a', '\ubf0b', '\ubf0c', 
    '\ubf0d', '\ubf0e', '\ubf0f', '\ubf10', '\ubf11', '\ubf12', '\ubf13', '\ubf14', 
    '\ubf15', '\ubf16', '\ubf17', '\ubf18', '\ubf19', '\ubf1a', '\ubf1b', '\ubf1c', 
    '\ubf1d', '\ubf1e', '\ubf1f', '\ubf20', '\ubf21', '\ubf22', '\ubf23', '\ubf25', 
    '\ubf26', '\ubf27', '\ubf28', '\ubf29', '\ubf2a', '\ubf2b', '\ubf2c', '\ubf2d', 
    '\ubf2e', '\ubf2f', '\ubf30', '\ubf31', '\ubf32', '\ubf33', '\ubf34', '\ubf35', 
    '\ubf36', '\ubf37', '\ubf38', '\ubf39', '\ubf3a', '\ubf3b', '\ubf3c', '\ubf3d', 
    '\ubf3e', '\ubf3f', '\ubf41', '\ubf42', '\ubf43', '\ubf44', '\ubf45', '\ubf46', 
    '\ubf47', '\ubf48', '\ubf49', '\ubf4a', '\ubf4b', '\ubf4c', '\ubf4d', '\ubf4e', 
    '\ubf4f', '\ubf50', '\ubf51', '\ubf52', '\ubf53', '\ubf54', '\ubf55', '\ubf56', 
    '\ubf57', '\ubf58', '\ubf59', '\ubf5a', '\ubf5b', '\ubf5d', '\ubf5e', '\ubf5f', 
    '\ubf60', '\ubf61', '\ubf62', '\ubf63', '\ubf64', '\ubf65', '\ubf66', '\ubf67', 
    '\ubf68', '\ubf69', '\ubf6a', '\ubf6b', '\ubf6c', '\ubf6d', '\ubf6e', '\ubf6f', 
    '\ubf70', '\ubf71', '\ubf72', '\ubf73', '\ubf74', '\ubf75', '\ubf76', '\ubf77', 
    '\ubf79', '\ubf7a', '\ubf7b', '\ubf7c', '\ubf7d', '\ubf7e', '\ubf7f', '\ubf80', 
    '\ubf81', '\ubf82', '\ubf83', '\ubf84', '\ubf85', '\ubf86', '\ubf87', '\ubf88', 
    '\ubf89', '\ubf8a', '\ubf8b', '\ubf8c', '\ubf8d', '\ubf8e', '\ubf8f', '\ubf90', 
    '\ubf91', '\ubf92', '\ubf93', '\ubf95', '\ubf96', '\ubf97', '\ubf98', '\ubf99', 
    '\ubf9a', '\ubf9b', '\ubf9c', '\ubf9d', '\ubf9e', '\ubf9f', '\ubfa0', '\ubfa1', 
    '\ubfa2', '\ubfa3', '\ubfa4', '\ubfa5', '\ubfa6', '\ubfa7', '\ubfa8', '\ubfa9', 
    '\ubfaa', '\ubfab', '\ubfac', '\ubfad', '\ubfae', '\ubfaf', '\ubfb1', '\ubfb2', 
    '\ubfb3', '\ubfb4', '\ubfb5', '\ubfb6', '\ubfb7', '\ubfb8', '\ubfb9', '\ubfba', 
    '\ubfbb', '\ubfbc', '\ubfbd', '\ubfbe', '\ubfbf', '\ubfc0', '\ubfc1', '\ubfc2', 
    '\ubfc3', '\ubfc4', '\ubfc5', '\ubfc6', '\ubfc7', '\ubfc8', '\ubfc9', '\ubfca', 
    '\ubfcb', '\ubfcd', '\ubfce', '\ubfcf', '\ubfd0', '\ubfd1', '\ubfd2', '\ubfd3', 
    '\ubfd4', '\ubfd5', '\ubfd6', '\ubfd7', '\ubfd8', '\ubfd9', '\ubfda', '\ubfdb', 
    '\ubfdc', '\ubfdd', '\ubfde', '\ubfdf', '\ubfe0', '\ubfe1', '\ubfe2', '\ubfe3', 
    '\ubfe4', '\ubfe5', '\ubfe6', '\ubfe7', '\ubfe9', '\ubfea', '\ubfeb', '\ubfec', 
    '\ubfed', '\ubfee', '\ubfef', '\ubff0', '\ubff1', '\ubff2', '\ubff3', '\ubff4', 
    '\ubff5', '\ubff6', '\ubff7', '\ubff8', '\ubff9', '\ubffa', '\ubffb', '\ubffc', 
    '\ubffd', '\ubffe', '\ubfff', '\uc000', '\uc001', '\uc002', '\uc003', '\uc005', 
    '\uc006', '\uc007', '\uc008', '\uc009', '\uc00a', '\uc00b', '\uc00c', '\uc00d', 
    '\uc00e', '\uc00f', '\uc010', '\uc011', '\uc012', '\uc013', '\uc014', '\uc015', 
    '\uc016', '\uc017', '\uc018', '\uc019', '\uc01a', '\uc01b', '\uc01c', '\uc01d', 
    '\uc01e', '\uc01f', '\uc021', '\uc022', '\uc023', '\uc024', '\uc025', '\uc026', 
    '\uc027', '\uc028', '\uc029', '\uc02a', '\uc02b', '\uc02c', '\uc02d', '\uc02e', 
    '\uc02f', '\uc030', '\uc031', '\uc032', '\uc033', '\uc034', '\uc035', '\uc036', 
    '\uc037', '\uc038', '\uc039', '\uc03a', '\uc03b', '\uc03d', '\uc03e', '\uc03f', 
    '\uc040', '\uc041', '\uc042', '\uc043', '\uc044', '\uc045', '\uc046', '\uc047', 
    '\uc048', '\uc049', '\uc04a', '\uc04b', '\uc04c', '\uc04d', '\uc04e', '\uc04f', 
    '\uc050', '\uc051', '\uc052', '\uc053', '\uc054', '\uc055', '\uc056', '\uc057', 
    '\uc059', '\uc05a', '\uc05b', '\uc05c', '\uc05d', '\uc05e', '\uc05f', '\uc060', 
    '\uc061', '\uc062', '\uc063', '\uc064', '\uc065', '\uc066', '\uc067', '\uc068', 
    '\uc069', '\uc06a', '\uc06b', '\uc06c', '\uc06d', '\uc06e', '\uc06f', '\uc070', 
    '\uc071', '\uc072', '\uc073', '\uc075', '\uc076', '\uc077', '\uc078', '\uc079', 
    '\uc07a', '\uc07b', '\uc07c', '\uc07d', '\uc07e', '\uc07f', '\uc080', '\uc081', 
    '\uc082', '\uc083', '\uc084', '\uc085', '\uc086', '\uc087', '\uc088', '\uc089', 
    '\uc08a', '\uc08b', '\uc08c', '\uc08d', '\uc08e', '\uc08f', '\uc091', '\uc092', 
    '\uc093', '\uc094', '\uc095', '\uc096', '\uc097', '\uc098', '\uc099', '\uc09a', 
    '\uc09b', '\uc09c', '\uc09d', '\uc09e', '\uc09f', '\uc0a0', '\uc0a1', '\uc0a2', 
    '\uc0a3', '\uc0a4', '\uc0a5', '\uc0a6', '\uc0a7', '\uc0a8', '\uc0a9', '\uc0aa', 
    '\uc0ab', '\uc0ad', '\uc0ae', '\uc0af', '\uc0b0', '\uc0b1', '\uc0b2', '\uc0b3', 
    '\uc0b4', '\uc0b5', '\uc0b6', '\uc0b7', '\uc0b8', '\uc0b9', '\uc0ba', '\uc0bb', 
    '\uc0bc', '\uc0bd', '\uc0be', '\uc0bf', '\uc0c0', '\uc0c1', '\uc0c2', '\uc0c3', 
    '\uc0c4', '\uc0c5', '\uc0c6', '\uc0c7', '\uc0c9', '\uc0ca', '\uc0cb', '\uc0cc', 
    '\uc0cd', '\uc0ce', '\uc0cf', '\uc0d0', '\uc0d1', '\uc0d2', '\uc0d3', '\uc0d4', 
    '\uc0d5', '\uc0d6', '\uc0d7', '\uc0d8', '\uc0d9', '\uc0da', '\uc0db', '\uc0dc', 
    '\uc0dd', '\uc0de', '\uc0df', '\uc0e0', '\uc0e1', '\uc0e2', '\uc0e3', '\uc0e5', 
    '\uc0e6', '\uc0e7', '\uc0e8', '\uc0e9', '\uc0ea', '\uc0eb', '\uc0ec', '\uc0ed', 
    '\uc0ee', '\uc0ef', '\uc0f0', '\uc0f1', '\uc0f2', '\uc0f3', '\uc0f4', '\uc0f5', 
    '\uc0f6', '\uc0f7', '\uc0f8', '\uc0f9', '\uc0fa', '\uc0fb', '\uc0fc', '\uc0fd', 
    '\uc0fe', '\uc0ff', '\uc101', '\uc102', '\uc103', '\uc104', '\uc105', '\uc106', 
    '\uc107', '\uc108', '\uc109', '\uc10a', '\uc10b', '\uc10c', '\uc10d', '\uc10e', 
    '\uc10f', '\uc110', '\uc111', '\uc112', '\uc113', '\uc114', '\uc115', '\uc116', 
    '\uc117', '\uc118', '\uc119', '\uc11a', '\uc11b', '\uc11d', '\uc11e', '\uc11f', 
    '\uc120', '\uc121', '\uc122', '\uc123', '\uc124', '\uc125', '\uc126', '\uc127', 
    '\uc128', '\uc129', '\uc12a', '\uc12b', '\uc12c', '\uc12d', '\uc12e', '\uc12f', 
    '\uc130', '\uc131', '\uc132', '\uc133', '\uc134', '\uc135', '\uc136', '\uc137', 
    '\uc139', '\uc13a', '\uc13b', '\uc13c', '\uc13d', '\uc13e', '\uc13f', '\uc140', 
    '\uc141', '\uc142', '\uc143', '\uc144', '\uc145', '\uc146', '\uc147', '\uc148', 
    '\uc149', '\uc14a', '\uc14b', '\uc14c', '\uc14d', '\uc14e', '\uc14f', '\uc150', 
    '\uc151', '\uc152', '\uc153', '\uc155', '\uc156', '\uc157', '\uc158', '\uc159', 
    '\uc15a', '\uc15b', '\uc15c', '\uc15d', '\uc15e', '\uc15f', '\uc160', '\uc161', 
    '\uc162', '\uc163', '\uc164', '\uc165', '\uc166', '\uc167', '\uc168', '\uc169', 
    '\uc16a', '\uc16b', '\uc16c', '\uc16d', '\uc16e', '\uc16f', '\uc171', '\uc172', 
    '\uc173', '\uc174', '\uc175', '\uc176', '\uc177', '\uc178', '\uc179', '\uc17a', 
    '\uc17b', '\uc17c', '\uc17d', '\uc17e', '\uc17f', '\uc180', '\uc181', '\uc182', 
    '\uc183', '\uc184', '\uc185', '\uc186', '\uc187', '\uc188', '\uc189', '\uc18a', 
    '\uc18b', '\uc18d', '\uc18e', '\uc18f', '\uc190', '\uc191', '\uc192', '\uc193', 
    '\uc194', '\uc195', '\uc196', '\uc197', '\uc198', '\uc199', '\uc19a', '\uc19b', 
    '\uc19c', '\uc19d', '\uc19e', '\uc19f', '\uc1a0', '\uc1a1', '\uc1a2', '\uc1a3', 
    '\uc1a4', '\uc1a5', '\uc1a6', '\uc1a7', '\uc1a9', '\uc1aa', '\uc1ab', '\uc1ac', 
    '\uc1ad', '\uc1ae', '\uc1af', '\uc1b0', '\uc1b1', '\uc1b2', '\uc1b3', '\uc1b4', 
    '\uc1b5', '\uc1b6', '\uc1b7', '\uc1b8', '\uc1b9', '\uc1ba', '\uc1bb', '\uc1bc', 
    '\uc1bd', '\uc1be', '\uc1bf', '\uc1c0', '\uc1c1', '\uc1c2', '\uc1c3', '\uc1c5', 
    '\uc1c6', '\uc1c7', '\uc1c8', '\uc1c9', '\uc1ca', '\uc1cb', '\uc1cc', '\uc1cd', 
    '\uc1ce', '\uc1cf', '\uc1d0', '\uc1d1', '\uc1d2', '\uc1d3', '\uc1d4', '\uc1d5', 
    '\uc1d6', '\uc1d7', '\uc1d8', '\uc1d9', '\uc1da', '\uc1db', '\uc1dc', '\uc1dd', 
    '\uc1de', '\uc1df', '\uc1e1', '\uc1e2', '\uc1e3', '\uc1e4', '\uc1e5', '\uc1e6', 
    '\uc1e7', '\uc1e8', '\uc1e9', '\uc1ea', '\uc1eb', '\uc1ec', '\uc1ed', '\uc1ee', 
    '\uc1ef', '\uc1f0', '\uc1f1', '\uc1f2', '\uc1f3', '\uc1f4', '\uc1f5', '\uc1f6', 
    '\uc1f7', '\uc1f8', '\uc1f9', '\uc1fa', '\uc1fb', '\uc1fd', '\uc1fe', '\uc1ff', 
    '\uc200', '\uc201', '\uc202', '\uc203', '\uc204', '\uc205', '\uc206', '\uc207', 
    '\uc208', '\uc209', '\uc20a', '\uc20b', '\uc20c', '\uc20d', '\uc20e', '\uc20f', 
    '\uc210', '\uc211', '\uc212', '\uc213', '\uc214', '\uc215', '\uc216', '\uc217', 
    '\uc219', '\uc21a', '\uc21b', '\uc21c', '\uc21d', '\uc21e', '\uc21f', '\uc220', 
    '\uc221', '\uc222', '\uc223', '\uc224', '\uc225', '\uc226', '\uc227', '\uc228', 
    '\uc229', '\uc22a', '\uc22b', '\uc22c', '\uc22d', '\uc22e', '\uc22f', '\uc230', 
    '\uc231', '\uc232', '\uc233', '\uc235', '\uc236', '\uc237', '\uc238', '\uc239', 
    '\uc23a', '\uc23b', '\uc23c', '\uc23d', '\uc23e', '\uc23f', '\uc240', '\uc241', 
    '\uc242', '\uc243', '\uc244', '\uc245', '\uc246', '\uc247', '\uc248', '\uc249', 
    '\uc24a', '\uc24b', '\uc24c', '\uc24d', '\uc24e', '\uc24f', '\uc251', '\uc252', 
    '\uc253', '\uc254', '\uc255', '\uc256', '\uc257', '\uc258', '\uc259', '\uc25a', 
    '\uc25b', '\uc25c', '\uc25d', '\uc25e', '\uc25f', '\uc260', '\uc261', '\uc262', 
    '\uc263', '\uc264', '\uc265', '\uc266', '\uc267', '\uc268', '\uc269', '\uc26a', 
    '\uc26b', '\uc26d', '\uc26e', '\uc26f', '\uc270', '\uc271', '\uc272', '\uc273', 
    '\uc274', '\uc275', '\uc276', '\uc277', '\uc278', '\uc279', '\uc27a', '\uc27b', 
    '\uc27c', '\uc27d', '\uc27e', '\uc27f', '\uc280', '\uc281', '\uc282', '\uc283', 
    '\uc284', '\uc285', '\uc286', '\uc287', '\uc289', '\uc28a', '\uc28b', '\uc28c', 
    '\uc28d', '\uc28e', '\uc28f', '\uc290', '\uc291', '\uc292', '\uc293', '\uc294', 
    '\uc295', '\uc296', '\uc297', '\uc298', '\uc299', '\uc29a', '\uc29b', '\uc29c', 
    '\uc29d', '\uc29e', '\uc29f', '\uc2a0', '\uc2a1', '\uc2a2', '\uc2a3', '\uc2a5', 
    '\uc2a6', '\uc2a7', '\uc2a8', '\uc2a9', '\uc2aa', '\uc2ab', '\uc2ac', '\uc2ad', 
    '\uc2ae', '\uc2af', '\uc2b0', '\uc2b1', '\uc2b2', '\uc2b3', '\uc2b4', '\uc2b5', 
    '\uc2b6', '\uc2b7', '\uc2b8', '\uc2b9', '\uc2ba', '\uc2bb', '\uc2bc', '\uc2bd', 
    '\uc2be', '\uc2bf', '\uc2c1', '\uc2c2', '\uc2c3', '\uc2c4', '\uc2c5', '\uc2c6', 
    '\uc2c7', '\uc2c8', '\uc2c9', '\uc2ca', '\uc2cb', '\uc2cc', '\uc2cd', '\uc2ce', 
    '\uc2cf', '\uc2d0', '\uc2d1', '\uc2d2', '\uc2d3', '\uc2d4', '\uc2d5', '\uc2d6', 
    '\uc2d7', '\uc2d8', '\uc2d9', '\uc2da', '\uc2db', '\uc2dd', '\uc2de', '\uc2df', 
    '\uc2e0', '\uc2e1', '\uc2e2', '\uc2e3', '\uc2e4', '\uc2e5', '\uc2e6', '\uc2e7', 
    '\uc2e8', '\uc2e9', '\uc2ea', '\uc2eb', '\uc2ec', '\uc2ed', '\uc2ee', '\uc2ef', 
    '\uc2f0', '\uc2f1', '\uc2f2', '\uc2f3', '\uc2f4', '\uc2f5', '\uc2f6', '\uc2f7', 
    '\uc2f9', '\uc2fa', '\uc2fb', '\uc2fc', '\uc2fd', '\uc2fe', '\uc2ff', '\uc300', 
    '\uc301', '\uc302', '\uc303', '\uc304', '\uc305', '\uc306', '\uc307', '\uc308', 
    '\uc309', '\uc30a', '\uc30b', '\uc30c', '\uc30d', '\uc30e', '\uc30f', '\uc310', 
    '\uc311', '\uc312', '\uc313', '\uc315', '\uc316', '\uc317', '\uc318', '\uc319', 
    '\uc31a', '\uc31b', '\uc31c', '\uc31d', '\uc31e', '\uc31f', '\uc320', '\uc321', 
    '\uc322', '\uc323', '\uc324', '\uc325', '\uc326', '\uc327', '\uc328', '\uc329', 
    '\uc32a', '\uc32b', '\uc32c', '\uc32d', '\uc32e', '\uc32f', '\uc331', '\uc332', 
    '\uc333', '\uc334', '\uc335', '\uc336', '\uc337', '\uc338', '\uc339', '\uc33a', 
    '\uc33b', '\uc33c', '\uc33d', '\uc33e', '\uc33f', '\uc340', '\uc341', '\uc342', 
    '\uc343', '\uc344', '\uc345', '\uc346', '\uc347', '\uc348', '\uc349', '\uc34a', 
    '\uc34b', '\uc34d', '\uc34e', '\uc34f', '\uc350', '\uc351', '\uc352', '\uc353', 
    '\uc354', '\uc355', '\uc356', '\uc357', '\uc358', '\uc359', '\uc35a', '\uc35b', 
    '\uc35c', '\uc35d', '\uc35e', '\uc35f', '\uc360', '\uc361', '\uc362', '\uc363', 
    '\uc364', '\uc365', '\uc366', '\uc367', '\uc369', '\uc36a', '\uc36b', '\uc36c', 
    '\uc36d', '\uc36e', '\uc36f', '\uc370', '\uc371', '\uc372', '\uc373', '\uc374', 
    '\uc375', '\uc376', '\uc377', '\uc378', '\uc379', '\uc37a', '\uc37b', '\uc37c', 
    '\uc37d', '\uc37e', '\uc37f', '\uc380', '\uc381', '\uc382', '\uc383', '\uc385', 
    '\uc386', '\uc387', '\uc388', '\uc389', '\uc38a', '\uc38b', '\uc38c', '\uc38d', 
    '\uc38e', '\uc38f', '\uc390', '\uc391', '\uc392', '\uc393', '\uc394', '\uc395', 
    '\uc396', '\uc397', '\uc398', '\uc399', '\uc39a', '\uc39b', '\uc39c', '\uc39d', 
    '\uc39e', '\uc39f', '\uc3a1', '\uc3a2', '\uc3a3', '\uc3a4', '\uc3a5', '\uc3a6', 
    '\uc3a7', '\uc3a8', '\uc3a9', '\uc3aa', '\uc3ab', '\uc3ac', '\uc3ad', '\uc3ae', 
    '\uc3af', '\uc3b0', '\uc3b1', '\uc3b2', '\uc3b3', '\uc3b4', '\uc3b5', '\uc3b6', 
    '\uc3b7', '\uc3b8', '\uc3b9', '\uc3ba', '\uc3bb', '\uc3bd', '\uc3be', '\uc3bf', 
    '\uc3c0', '\uc3c1', '\uc3c2', '\uc3c3', '\uc3c4', '\uc3c5', '\uc3c6', '\uc3c7', 
    '\uc3c8', '\uc3c9', '\uc3ca', '\uc3cb', '\uc3cc', '\uc3cd', '\uc3ce', '\uc3cf', 
    '\uc3d0', '\uc3d1', '\uc3d2', '\uc3d3', '\uc3d4', '\uc3d5', '\uc3d6', '\uc3d7', 
    '\uc3d9', '\uc3da', '\uc3db', '\uc3dc', '\uc3dd', '\uc3de', '\uc3df', '\uc3e0', 
    '\uc3e1', '\uc3e2', '\uc3e3', '\uc3e4', '\uc3e5', '\uc3e6', '\uc3e7', '\uc3e8', 
    '\uc3e9', '\uc3ea', '\uc3eb', '\uc3ec', '\uc3ed', '\uc3ee', '\uc3ef', '\uc3f0', 
    '\uc3f1', '\uc3f2', '\uc3f3', '\uc3f5', '\uc3f6', '\uc3f7', '\uc3f8', '\uc3f9', 
    '\uc3fa', '\uc3fb', '\uc3fc', '\uc3fd', '\uc3fe', '\uc3ff', '\uc400', '\uc401', 
    '\uc402', '\uc403', '\uc404', '\uc405', '\uc406', '\uc407', '\uc408', '\uc409', 
    '\uc40a', '\uc40b', '\uc40c', '\uc40d', '\uc40e', '\uc40f', '\uc411', '\uc412', 
    '\uc413', '\uc414', '\uc415', '\uc416', '\uc417', '\uc418', '\uc419', '\uc41a', 
    '\uc41b', '\uc41c', '\uc41d', '\uc41e', '\uc41f', '\uc420', '\uc421', '\uc422', 
    '\uc423', '\uc424', '\uc425', '\uc426', '\uc427', '\uc428', '\uc429', '\uc42a', 
    '\uc42b', '\uc42d', '\uc42e', '\uc42f', '\uc430', '\uc431', '\uc432', '\uc433', 
    '\uc434', '\uc435', '\uc436', '\uc437', '\uc438', '\uc439', '\uc43a', '\uc43b', 
    '\uc43c', '\uc43d', '\uc43e', '\uc43f', '\uc440', '\uc441', '\uc442', '\uc443', 
    '\uc444', '\uc445', '\uc446', '\uc447', '\uc449', '\uc44a', '\uc44b', '\uc44c', 
    '\uc44d', '\uc44e', '\uc44f', '\uc450', '\uc451', '\uc452', '\uc453', '\uc454', 
    '\uc455', '\uc456', '\uc457', '\uc458', '\uc459', '\uc45a', '\uc45b', '\uc45c', 
    '\uc45d', '\uc45e', '\uc45f', '\uc460', '\uc461', '\uc462', '\uc463', '\uc465', 
    '\uc466', '\uc467', '\uc468', '\uc469', '\uc46a', '\uc46b', '\uc46c', '\uc46d', 
    '\uc46e', '\uc46f', '\uc470', '\uc471', '\uc472', '\uc473', '\uc474', '\uc475', 
    '\uc476', '\uc477', '\uc478', '\uc479', '\uc47a', '\uc47b', '\uc47c', '\uc47d', 
    '\uc47e', '\uc47f', '\uc481', '\uc482', '\uc483', '\uc484', '\uc485', '\uc486', 
    '\uc487', '\uc488', '\uc489', '\uc48a', '\uc48b', '\uc48c', '\uc48d', '\uc48e', 
    '\uc48f', '\uc490', '\uc491', '\uc492', '\uc493', '\uc494', '\uc495', '\uc496', 
    '\uc497', '\uc498', '\uc499', '\uc49a', '\uc49b', '\uc49d', '\uc49e', '\uc49f', 
    '\uc4a0', '\uc4a1', '\uc4a2', '\uc4a3', '\uc4a4', '\uc4a5', '\uc4a6', '\uc4a7', 
    '\uc4a8', '\uc4a9', '\uc4aa', '\uc4ab', '\uc4ac', '\uc4ad', '\uc4ae', '\uc4af', 
    '\uc4b0', '\uc4b1', '\uc4b2', '\uc4b3', '\uc4b4', '\uc4b5', '\uc4b6', '\uc4b7', 
    '\uc4b9', '\uc4ba', '\uc4bb', '\uc4bc', '\uc4bd', '\uc4be', '\uc4bf', '\uc4c0', 
    '\uc4c1', '\uc4c2', '\uc4c3', '\uc4c4', '\uc4c5', '\uc4c6', '\uc4c7', '\uc4c8', 
    '\uc4c9', '\uc4ca', '\uc4cb', '\uc4cc', '\uc4cd', '\uc4ce', '\uc4cf', '\uc4d0', 
    '\uc4d1', '\uc4d2', '\uc4d3', '\uc4d5', '\uc4d6', '\uc4d7', '\uc4d8', '\uc4d9', 
    '\uc4da', '\uc4db', '\uc4dc', '\uc4dd', '\uc4de', '\uc4df', '\uc4e0', '\uc4e1', 
    '\uc4e2', '\uc4e3', '\uc4e4', '\uc4e5', '\uc4e6', '\uc4e7', '\uc4e8', '\uc4e9', 
    '\uc4ea', '\uc4eb', '\uc4ec', '\uc4ed', '\uc4ee', '\uc4ef', '\uc4f1', '\uc4f2', 
    '\uc4f3', '\uc4f4', '\uc4f5', '\uc4f6', '\uc4f7', '\uc4f8', '\uc4f9', '\uc4fa', 
    '\uc4fb', '\uc4fc', '\uc4fd', '\uc4fe', '\uc4ff', '\uc500', '\uc501', '\uc502', 
    '\uc503', '\uc504', '\uc505', '\uc506', '\uc507', '\uc508', '\uc509', '\uc50a', 
    '\uc50b', '\uc50d', '\uc50e', '\uc50f', '\uc510', '\uc511', '\uc512', '\uc513', 
    '\uc514', '\uc515', '\uc516', '\uc517', '\uc518', '\uc519', '\uc51a', '\uc51b', 
    '\uc51c', '\uc51d', '\uc51e', '\uc51f', '\uc520', '\uc521', '\uc522', '\uc523', 
    '\uc524', '\uc525', '\uc526', '\uc527', '\uc529', '\uc52a', '\uc52b', '\uc52c', 
    '\uc52d', '\uc52e', '\uc52f', '\uc530', '\uc531', '\uc532', '\uc533', '\uc534', 
    '\uc535', '\uc536', '\uc537', '\uc538', '\uc539', '\uc53a', '\uc53b', '\uc53c', 
    '\uc53d', '\uc53e', '\uc53f', '\uc540', '\uc541', '\uc542', '\uc543', '\uc545', 
    '\uc546', '\uc547', '\uc548', '\uc549', '\uc54a', '\uc54b', '\uc54c', '\uc54d', 
    '\uc54e', '\uc54f', '\uc550', '\uc551', '\uc552', '\uc553', '\uc554', '\uc555', 
    '\uc556', '\uc557', '\uc558', '\uc559', '\uc55a', '\uc55b', '\uc55c', '\uc55d', 
    '\uc55e', '\uc55f', '\uc561', '\uc562', '\uc563', '\uc564', '\uc565', '\uc566', 
    '\uc567', '\uc568', '\uc569', '\uc56a', '\uc56b', '\uc56c', '\uc56d', '\uc56e', 
    '\uc56f', '\uc570', '\uc571', '\uc572', '\uc573', '\uc574', '\uc575', '\uc576', 
    '\uc577', '\uc578', '\uc579', '\uc57a', '\uc57b', '\uc57d', '\uc57e', '\uc57f', 
    '\uc580', '\uc581', '\uc582', '\uc583', '\uc584', '\uc585', '\uc586', '\uc587', 
    '\uc588', '\uc589', '\uc58a', '\uc58b', '\uc58c', '\uc58d', '\uc58e', '\uc58f', 
    '\uc590', '\uc591', '\uc592', '\uc593', '\uc594', '\uc595', '\uc596', '\uc597', 
    '\uc599', '\uc59a', '\uc59b', '\uc59c', '\uc59d', '\uc59e', '\uc59f', '\uc5a0', 
    '\uc5a1', '\uc5a2', '\uc5a3', '\uc5a4', '\uc5a5', '\uc5a6', '\uc5a7', '\uc5a8', 
    '\uc5a9', '\uc5aa', '\uc5ab', '\uc5ac', '\uc5ad', '\uc5ae', '\uc5af', '\uc5b0', 
    '\uc5b1', '\uc5b2', '\uc5b3', '\uc5b5', '\uc5b6', '\uc5b7', '\uc5b8', '\uc5b9', 
    '\uc5ba', '\uc5bb', '\uc5bc', '\uc5bd', '\uc5be', '\uc5bf', '\uc5c0', '\uc5c1', 
    '\uc5c2', '\uc5c3', '\uc5c4', '\uc5c5', '\uc5c6', '\uc5c7', '\uc5c8', '\uc5c9', 
    '\uc5ca', '\uc5cb', '\uc5cc', '\uc5cd', '\uc5ce', '\uc5cf', '\uc5d1', '\uc5d2', 
    '\uc5d3', '\uc5d4', '\uc5d5', '\uc5d6', '\uc5d7', '\uc5d8', '\uc5d9', '\uc5da', 
    '\uc5db', '\uc5dc', '\uc5dd', '\uc5de', '\uc5df', '\uc5e0', '\uc5e1', '\uc5e2', 
    '\uc5e3', '\uc5e4', '\uc5e5', '\uc5e6', '\uc5e7', '\uc5e8', '\uc5e9', '\uc5ea', 
    '\uc5eb', '\uc5ed', '\uc5ee', '\uc5ef', '\uc5f0', '\uc5f1', '\uc5f2', '\uc5f3', 
    '\uc5f4', '\uc5f5', '\uc5f6', '\uc5f7', '\uc5f8', '\uc5f9', '\uc5fa', '\uc5fb', 
    '\uc5fc', '\uc5fd', '\uc5fe', '\uc5ff', '\uc600', '\uc601', '\uc602', '\uc603', 
    '\uc604', '\uc605', '\uc606', '\uc607', '\uc609', '\uc60a', '\uc60b', '\uc60c', 
    '\uc60d', '\uc60e', '\uc60f', '\uc610', '\uc611', '\uc612', '\uc613', '\uc614', 
    '\uc615', '\uc616', '\uc617', '\uc618', '\uc619', '\uc61a', '\uc61b', '\uc61c', 
    '\uc61d', '\uc61e', '\uc61f', '\uc620', '\uc621', '\uc622', '\uc623', '\uc625', 
    '\uc626', '\uc627', '\uc628', '\uc629', '\uc62a', '\uc62b', '\uc62c', '\uc62d', 
    '\uc62e', '\uc62f', '\uc630', '\uc631', '\uc632', '\uc633', '\uc634', '\uc635', 
    '\uc636', '\uc637', '\uc638', '\uc639', '\uc63a', '\uc63b', '\uc63c', '\uc63d', 
    '\uc63e', '\uc63f', '\uc641', '\uc642', '\uc643', '\uc644', '\uc645', '\uc646', 
    '\uc647', '\uc648', '\uc649', '\uc64a', '\uc64b', '\uc64c', '\uc64d', '\uc64e', 
    '\uc64f', '\uc650', '\uc651', '\uc652', '\uc653', '\uc654', '\uc655', '\uc656', 
    '\uc657', '\uc658', '\uc659', '\uc65a', '\uc65b', '\uc65d', '\uc65e', '\uc65f', 
    '\uc660', '\uc661', '\uc662', '\uc663', '\uc664', '\uc665', '\uc666', '\uc667', 
    '\uc668', '\uc669', '\uc66a', '\uc66b', '\uc66c', '\uc66d', '\uc66e', '\uc66f', 
    '\uc670', '\uc671', '\uc672', '\uc673', '\uc674', '\uc675', '\uc676', '\uc677', 
    '\uc679', '\uc67a', '\uc67b', '\uc67c', '\uc67d', '\uc67e', '\uc67f', '\uc680', 
    '\uc681', '\uc682', '\uc683', '\uc684', '\uc685', '\uc686', '\uc687', '\uc688', 
    '\uc689', '\uc68a', '\uc68b', '\uc68c', '\uc68d', '\uc68e', '\uc68f', '\uc690', 
    '\uc691', '\uc692', '\uc693', '\uc695', '\uc696', '\uc697', '\uc698', '\uc699', 
    '\uc69a', '\uc69b', '\uc69c', '\uc69d', '\uc69e', '\uc69f', '\uc6a0', '\uc6a1', 
    '\uc6a2', '\uc6a3', '\uc6a4', '\uc6a5', '\uc6a6', '\uc6a7', '\uc6a8', '\uc6a9', 
    '\uc6aa', '\uc6ab', '\uc6ac', '\uc6ad', '\uc6ae', '\uc6af', '\uc6b1', '\uc6b2', 
    '\uc6b3', '\uc6b4', '\uc6b5', '\uc6b6', '\uc6b7', '\uc6b8', '\uc6b9', '\uc6ba', 
    '\uc6bb', '\uc6bc', '\uc6bd', '\uc6be', '\uc6bf', '\uc6c0', '\uc6c1', '\uc6c2', 
    '\uc6c3', '\uc6c4', '\uc6c5', '\uc6c6', '\uc6c7', '\uc6c8', '\uc6c9', '\uc6ca', 
    '\uc6cb', '\uc6cd', '\uc6ce', '\uc6cf', '\uc6d0', '\uc6d1', '\uc6d2', '\uc6d3', 
    '\uc6d4', '\uc6d5', '\uc6d6', '\uc6d7', '\uc6d8', '\uc6d9', '\uc6da', '\uc6db', 
    '\uc6dc', '\uc6dd', '\uc6de', '\uc6df', '\uc6e0', '\uc6e1', '\uc6e2', '\uc6e3', 
    '\uc6e4', '\uc6e5', '\uc6e6', '\uc6e7', '\uc6e9', '\uc6ea', '\uc6eb', '\uc6ec', 
    '\uc6ed', '\uc6ee', '\uc6ef', '\uc6f0', '\uc6f1', '\uc6f2', '\uc6f3', '\uc6f4', 
    '\uc6f5', '\uc6f6', '\uc6f7', '\uc6f8', '\uc6f9', '\uc6fa', '\uc6fb', '\uc6fc', 
    '\uc6fd', '\uc6fe', '\uc6ff', '\uc700', '\uc701', '\uc702', '\uc703', '\uc705', 
    '\uc706', '\uc707', '\uc708', '\uc709', '\uc70a', '\uc70b', '\uc70c', '\uc70d', 
    '\uc70e', '\uc70f', '\uc710', '\uc711', '\uc712', '\uc713', '\uc714', '\uc715', 
    '\uc716', '\uc717', '\uc718', '\uc719', '\uc71a', '\uc71b', '\uc71c', '\uc71d', 
    '\uc71e', '\uc71f', '\uc721', '\uc722', '\uc723', '\uc724', '\uc725', '\uc726', 
    '\uc727', '\uc728', '\uc729', '\uc72a', '\uc72b', '\uc72c', '\uc72d', '\uc72e', 
    '\uc72f', '\uc730', '\uc731', '\uc732', '\uc733', '\uc734', '\uc735', '\uc736', 
    '\uc737', '\uc738', '\uc739', '\uc73a', '\uc73b', '\uc73d', '\uc73e', '\uc73f', 
    '\uc740', '\uc741', '\uc742', '\uc743', '\uc744', '\uc745', '\uc746', '\uc747', 
    '\uc748', '\uc749', '\uc74a', '\uc74b', '\uc74c', '\uc74d', '\uc74e', '\uc74f', 
    '\uc750', '\uc751', '\uc752', '\uc753', '\uc754', '\uc755', '\uc756', '\uc757', 
    '\uc759', '\uc75a', '\uc75b', '\uc75c', '\uc75d', '\uc75e', '\uc75f', '\uc760', 
    '\uc761', '\uc762', '\uc763', '\uc764', '\uc765', '\uc766', '\uc767', '\uc768', 
    '\uc769', '\uc76a', '\uc76b', '\uc76c', '\uc76d', '\uc76e', '\uc76f', '\uc770', 
    '\uc771', '\uc772', '\uc773', '\uc775', '\uc776', '\uc777', '\uc778', '\uc779', 
    '\uc77a', '\uc77b', '\uc77c', '\uc77d', '\uc77e', '\uc77f', '\uc780', '\uc781', 
    '\uc782', '\uc783', '\uc784', '\uc785', '\uc786', '\uc787', '\uc788', '\uc789', 
    '\uc78a', '\uc78b', '\uc78c', '\uc78d', '\uc78e', '\uc78f', '\uc791', '\uc792', 
    '\uc793', '\uc794', '\uc795', '\uc796', '\uc797', '\uc798', '\uc799', '\uc79a', 
    '\uc79b', '\uc79c', '\uc79d', '\uc79e', '\uc79f', '\uc7a0', '\uc7a1', '\uc7a2', 
    '\uc7a3', '\uc7a4', '\uc7a5', '\uc7a6', '\uc7a7', '\uc7a8', '\uc7a9', '\uc7aa', 
    '\uc7ab', '\uc7ad', '\uc7ae', '\uc7af', '\uc7b0', '\uc7b1', '\uc7b2', '\uc7b3', 
    '\uc7b4', '\uc7b5', '\uc7b6', '\uc7b7', '\uc7b8', '\uc7b9', '\uc7ba', '\uc7bb', 
    '\uc7bc', '\uc7bd', '\uc7be', '\uc7bf', '\uc7c0', '\uc7c1', '\uc7c2', '\uc7c3', 
    '\uc7c4', '\uc7c5', '\uc7c6', '\uc7c7', '\uc7c9', '\uc7ca', '\uc7cb', '\uc7cc', 
    '\uc7cd', '\uc7ce', '\uc7cf', '\uc7d0', '\uc7d1', '\uc7d2', '\uc7d3', '\uc7d4', 
    '\uc7d5', '\uc7d6', '\uc7d7', '\uc7d8', '\uc7d9', '\uc7da', '\uc7db', '\uc7dc', 
    '\uc7dd', '\uc7de', '\uc7df', '\uc7e0', '\uc7e1', '\uc7e2', '\uc7e3', '\uc7e5', 
    '\uc7e6', '\uc7e7', '\uc7e8', '\uc7e9', '\uc7ea', '\uc7eb', '\uc7ec', '\uc7ed', 
    '\uc7ee', '\uc7ef', '\uc7f0', '\uc7f1', '\uc7f2', '\uc7f3', '\uc7f4', '\uc7f5', 
    '\uc7f6', '\uc7f7', '\uc7f8', '\uc7f9', '\uc7fa', '\uc7fb', '\uc7fc', '\uc7fd', 
    '\uc7fe', '\uc7ff', '\uc801', '\uc802', '\uc803', '\uc804', '\uc805', '\uc806', 
    '\uc807', '\uc808', '\uc809', '\uc80a', '\uc80b', '\uc80c', '\uc80d', '\uc80e', 
    '\uc80f', '\uc810', '\uc811', '\uc812', '\uc813', '\uc814', '\uc815', '\uc816', 
    '\uc817', '\uc818', '\uc819', '\uc81a', '\uc81b', '\uc81d', '\uc81e', '\uc81f', 
    '\uc820', '\uc821', '\uc822', '\uc823', '\uc824', '\uc825', '\uc826', '\uc827', 
    '\uc828', '\uc829', '\uc82a', '\uc82b', '\uc82c', '\uc82d', '\uc82e', '\uc82f', 
    '\uc830', '\uc831', '\uc832', '\uc833', '\uc834', '\uc835', '\uc836', '\uc837', 
    '\uc839', '\uc83a', '\uc83b', '\uc83c', '\uc83d', '\uc83e', '\uc83f', '\uc840', 
    '\uc841', '\uc842', '\uc843', '\uc844', '\uc845', '\uc846', '\uc847', '\uc848', 
    '\uc849', '\uc84a', '\uc84b', '\uc84c', '\uc84d', '\uc84e', '\uc84f', '\uc850', 
    '\uc851', '\uc852', '\uc853', '\uc855', '\uc856', '\uc857', '\uc858', '\uc859', 
    '\uc85a', '\uc85b', '\uc85c', '\uc85d', '\uc85e', '\uc85f', '\uc860', '\uc861', 
    '\uc862', '\uc863', '\uc864', '\uc865', '\uc866', '\uc867', '\uc868', '\uc869', 
    '\uc86a', '\uc86b', '\uc86c', '\uc86d', '\uc86e', '\uc86f', '\uc871', '\uc872', 
    '\uc873', '\uc874', '\uc875', '\uc876', '\uc877', '\uc878', '\uc879', '\uc87a', 
    '\uc87b', '\uc87c', '\uc87d', '\uc87e', '\uc87f', '\uc880', '\uc881', '\uc882', 
    '\uc883', '\uc884', '\uc885', '\uc886', '\uc887', '\uc888', '\uc889', '\uc88a', 
    '\uc88b', '\uc88d', '\uc88e', '\uc88f', '\uc890', '\uc891', '\uc892', '\uc893', 
    '\uc894', '\uc895', '\uc896', '\uc897', '\uc898', '\uc899', '\uc89a', '\uc89b', 
    '\uc89c', '\uc89d', '\uc89e', '\uc89f', '\uc8a0', '\uc8a1', '\uc8a2', '\uc8a3', 
    '\uc8a4', '\uc8a5', '\uc8a6', '\uc8a7', '\uc8a9', '\uc8aa', '\uc8ab', '\uc8ac', 
    '\uc8ad', '\uc8ae', '\uc8af', '\uc8b0', '\uc8b1', '\uc8b2', '\uc8b3', '\uc8b4', 
    '\uc8b5', '\uc8b6', '\uc8b7', '\uc8b8', '\uc8b9', '\uc8ba', '\uc8bb', '\uc8bc', 
    '\uc8bd', '\uc8be', '\uc8bf', '\uc8c0', '\uc8c1', '\uc8c2', '\uc8c3', '\uc8c5', 
    '\uc8c6', '\uc8c7', '\uc8c8', '\uc8c9', '\uc8ca', '\uc8cb', '\uc8cc', '\uc8cd', 
    '\uc8ce', '\uc8cf', '\uc8d0', '\uc8d1', '\uc8d2', '\uc8d3', '\uc8d4', '\uc8d5', 
    '\uc8d6', '\uc8d7', '\uc8d8', '\uc8d9', '\uc8da', '\uc8db', '\uc8dc', '\uc8dd', 
    '\uc8de', '\uc8df', '\uc8e1', '\uc8e2', '\uc8e3', '\uc8e4', '\uc8e5', '\uc8e6', 
    '\uc8e7', '\uc8e8', '\uc8e9', '\uc8ea', '\uc8eb', '\uc8ec', '\uc8ed', '\uc8ee', 
    '\uc8ef', '\uc8f0', '\uc8f1', '\uc8f2', '\uc8f3', '\uc8f4', '\uc8f5', '\uc8f6', 
    '\uc8f7', '\uc8f8', '\uc8f9', '\uc8fa', '\uc8fb', '\uc8fd', '\uc8fe', '\uc8ff', 
    '\uc900', '\uc901', '\uc902', '\uc903', '\uc904', '\uc905', '\uc906', '\uc907', 
    '\uc908', '\uc909', '\uc90a', '\uc90b', '\uc90c', '\uc90d', '\uc90e', '\uc90f', 
    '\uc910', '\uc911', '\uc912', '\uc913', '\uc914', '\uc915', '\uc916', '\uc917', 
    '\uc919', '\uc91a', '\uc91b', '\uc91c', '\uc91d', '\uc91e', '\uc91f', '\uc920', 
    '\uc921', '\uc922', '\uc923', '\uc924', '\uc925', '\uc926', '\uc927', '\uc928', 
    '\uc929', '\uc92a', '\uc92b', '\uc92c', '\uc92d', '\uc92e', '\uc92f', '\uc930', 
    '\uc931', '\uc932', '\uc933', '\uc935', '\uc936', '\uc937', '\uc938', '\uc939', 
    '\uc93a', '\uc93b', '\uc93c', '\uc93d', '\uc93e', '\uc93f', '\uc940', '\uc941', 
    '\uc942', '\uc943', '\uc944', '\uc945', '\uc946', '\uc947', '\uc948', '\uc949', 
    '\uc94a', '\uc94b', '\uc94c', '\uc94d', '\uc94e', '\uc94f', '\uc951', '\uc952', 
    '\uc953', '\uc954', '\uc955', '\uc956', '\uc957', '\uc958', '\uc959', '\uc95a', 
    '\uc95b', '\uc95c', '\uc95d', '\uc95e', '\uc95f', '\uc960', '\uc961', '\uc962', 
    '\uc963', '\uc964', '\uc965', '\uc966', '\uc967', '\uc968', '\uc969', '\uc96a', 
    '\uc96b', '\uc96d', '\uc96e', '\uc96f', '\uc970', '\uc971', '\uc972', '\uc973', 
    '\uc974', '\uc975', '\uc976', '\uc977', '\uc978', '\uc979', '\uc97a', '\uc97b', 
    '\uc97c', '\uc97d', '\uc97e', '\uc97f', '\uc980', '\uc981', '\uc982', '\uc983', 
    '\uc984', '\uc985', '\uc986', '\uc987', '\uc989', '\uc98a', '\uc98b', '\uc98c', 
    '\uc98d', '\uc98e', '\uc98f', '\uc990', '\uc991', '\uc992', '\uc993', '\uc994', 
    '\uc995', '\uc996', '\uc997', '\uc998', '\uc999', '\uc99a', '\uc99b', '\uc99c', 
    '\uc99d', '\uc99e', '\uc99f', '\uc9a0', '\uc9a1', '\uc9a2', '\uc9a3', '\uc9a5', 
    '\uc9a6', '\uc9a7', '\uc9a8', '\uc9a9', '\uc9aa', '\uc9ab', '\uc9ac', '\uc9ad', 
    '\uc9ae', '\uc9af', '\uc9b0', '\uc9b1', '\uc9b2', '\uc9b3', '\uc9b4', '\uc9b5', 
    '\uc9b6', '\uc9b7', '\uc9b8', '\uc9b9', '\uc9ba', '\uc9bb', '\uc9bc', '\uc9bd', 
    '\uc9be', '\uc9bf', '\uc9c1', '\uc9c2', '\uc9c3', '\uc9c4', '\uc9c5', '\uc9c6', 
    '\uc9c7', '\uc9c8', '\uc9c9', '\uc9ca', '\uc9cb', '\uc9cc', '\uc9cd', '\uc9ce', 
    '\uc9cf', '\uc9d0', '\uc9d1', '\uc9d2', '\uc9d3', '\uc9d4', '\uc9d5', '\uc9d6', 
    '\uc9d7', '\uc9d8', '\uc9d9', '\uc9da', '\uc9db', '\uc9dd', '\uc9de', '\uc9df', 
    '\uc9e0', '\uc9e1', '\uc9e2', '\uc9e3', '\uc9e4', '\uc9e5', '\uc9e6', '\uc9e7', 
    '\uc9e8', '\uc9e9', '\uc9ea', '\uc9eb', '\uc9ec', '\uc9ed', '\uc9ee', '\uc9ef', 
    '\uc9f0', '\uc9f1', '\uc9f2', '\uc9f3', '\uc9f4', '\uc9f5', '\uc9f6', '\uc9f7', 
    '\uc9f9', '\uc9fa', '\uc9fb', '\uc9fc', '\uc9fd', '\uc9fe', '\uc9ff', '\uca00', 
    '\uca01', '\uca02', '\uca03', '\uca04', '\uca05', '\uca06', '\uca07', '\uca08', 
    '\uca09', '\uca0a', '\uca0b', '\uca0c', '\uca0d', '\uca0e', '\uca0f', '\uca10', 
    '\uca11', '\uca12', '\uca13', '\uca15', '\uca16', '\uca17', '\uca18', '\uca19', 
    '\uca1a', '\uca1b', '\uca1c', '\uca1d', '\uca1e', '\uca1f', '\uca20', '\uca21', 
    '\uca22', '\uca23', '\uca24', '\uca25', '\uca26', '\uca27', '\uca28', '\uca29', 
    '\uca2a', '\uca2b', '\uca2c', '\uca2d', '\uca2e', '\uca2f', '\uca31', '\uca32', 
    '\uca33', '\uca34', '\uca35', '\uca36', '\uca37', '\uca38', '\uca39', '\uca3a', 
    '\uca3b', '\uca3c', '\uca3d', '\uca3e', '\uca3f', '\uca40', '\uca41', '\uca42', 
    '\uca43', '\uca44', '\uca45', '\uca46', '\uca47', '\uca48', '\uca49', '\uca4a', 
    '\uca4b', '\uca4d', '\uca4e', '\uca4f', '\uca50', '\uca51', '\uca52', '\uca53', 
    '\uca54', '\uca55', '\uca56', '\uca57', '\uca58', '\uca59', '\uca5a', '\uca5b', 
    '\uca5c', '\uca5d', '\uca5e', '\uca5f', '\uca60', '\uca61', '\uca62', '\uca63', 
    '\uca64', '\uca65', '\uca66', '\uca67', '\uca69', '\uca6a', '\uca6b', '\uca6c', 
    '\uca6d', '\uca6e', '\uca6f', '\uca70', '\uca71', '\uca72', '\uca73', '\uca74', 
    '\uca75', '\uca76', '\uca77', '\uca78', '\uca79', '\uca7a', '\uca7b', '\uca7c', 
    '\uca7d', '\uca7e', '\uca7f', '\uca80', '\uca81', '\uca82', '\uca83', '\uca85', 
    '\uca86', '\uca87', '\uca88', '\uca89', '\uca8a', '\uca8b', '\uca8c', '\uca8d', 
    '\uca8e', '\uca8f', '\uca90', '\uca91', '\uca92', '\uca93', '\uca94', '\uca95', 
    '\uca96', '\uca97', '\uca98', '\uca99', '\uca9a', '\uca9b', '\uca9c', '\uca9d', 
    '\uca9e', '\uca9f', '\ucaa1', '\ucaa2', '\ucaa3', '\ucaa4', '\ucaa5', '\ucaa6', 
    '\ucaa7', '\ucaa8', '\ucaa9', '\ucaaa', '\ucaab', '\ucaac', '\ucaad', '\ucaae', 
    '\ucaaf', '\ucab0', '\ucab1', '\ucab2', '\ucab3', '\ucab4', '\ucab5', '\ucab6', 
    '\ucab7', '\ucab8', '\ucab9', '\ucaba', '\ucabb', '\ucabd', '\ucabe', '\ucabf', 
    '\ucac0', '\ucac1', '\ucac2', '\ucac3', '\ucac4', '\ucac5', '\ucac6', '\ucac7', 
    '\ucac8', '\ucac9', '\ucaca', '\ucacb', '\ucacc', '\ucacd', '\ucace', '\ucacf', 
    '\ucad0', '\ucad1', '\ucad2', '\ucad3', '\ucad4', '\ucad5', '\ucad6', '\ucad7', 
    '\ucad9', '\ucada', '\ucadb', '\ucadc', '\ucadd', '\ucade', '\ucadf', '\ucae0', 
    '\ucae1', '\ucae2', '\ucae3', '\ucae4', '\ucae5', '\ucae6', '\ucae7', '\ucae8', 
    '\ucae9', '\ucaea', '\ucaeb', '\ucaec', '\ucaed', '\ucaee', '\ucaef', '\ucaf0', 
    '\ucaf1', '\ucaf2', '\ucaf3', '\ucaf5', '\ucaf6', '\ucaf7', '\ucaf8', '\ucaf9', 
    '\ucafa', '\ucafb', '\ucafc', '\ucafd', '\ucafe', '\ucaff', '\ucb00', '\ucb01', 
    '\ucb02', '\ucb03', '\ucb04', '\ucb05', '\ucb06', '\ucb07', '\ucb08', '\ucb09', 
    '\ucb0a', '\ucb0b', '\ucb0c', '\ucb0d', '\ucb0e', '\ucb0f', '\ucb11', '\ucb12', 
    '\ucb13', '\ucb14', '\ucb15', '\ucb16', '\ucb17', '\ucb18', '\ucb19', '\ucb1a', 
    '\ucb1b', '\ucb1c', '\ucb1d', '\ucb1e', '\ucb1f', '\ucb20', '\ucb21', '\ucb22', 
    '\ucb23', '\ucb24', '\ucb25', '\ucb26', '\ucb27', '\ucb28', '\ucb29', '\ucb2a', 
    '\ucb2b', '\ucb2d', '\ucb2e', '\ucb2f', '\ucb30', '\ucb31', '\ucb32', '\ucb33', 
    '\ucb34', '\ucb35', '\ucb36', '\ucb37', '\ucb38', '\ucb39', '\ucb3a', '\ucb3b', 
    '\ucb3c', '\ucb3d', '\ucb3e', '\ucb3f', '\ucb40', '\ucb41', '\ucb42', '\ucb43', 
    '\ucb44', '\ucb45', '\ucb46', '\ucb47', '\ucb49', '\ucb4a', '\ucb4b', '\ucb4c', 
    '\ucb4d', '\ucb4e', '\ucb4f', '\ucb50', '\ucb51', '\ucb52', '\ucb53', '\ucb54', 
    '\ucb55', '\ucb56', '\ucb57', '\ucb58', '\ucb59', '\ucb5a', '\ucb5b', '\ucb5c', 
    '\ucb5d', '\ucb5e', '\ucb5f', '\ucb60', '\ucb61', '\ucb62', '\ucb63', '\ucb65', 
    '\ucb66', '\ucb67', '\ucb68', '\ucb69', '\ucb6a', '\ucb6b', '\ucb6c', '\ucb6d', 
    '\ucb6e', '\ucb6f', '\ucb70', '\ucb71', '\ucb72', '\ucb73', '\ucb74', '\ucb75', 
    '\ucb76', '\ucb77', '\ucb78', '\ucb79', '\ucb7a', '\ucb7b', '\ucb7c', '\ucb7d', 
    '\ucb7e', '\ucb7f', '\ucb81', '\ucb82', '\ucb83', '\ucb84', '\ucb85', '\ucb86', 
    '\ucb87', '\ucb88', '\ucb89', '\ucb8a', '\ucb8b', '\ucb8c', '\ucb8d', '\ucb8e', 
    '\ucb8f', '\ucb90', '\ucb91', '\ucb92', '\ucb93', '\ucb94', '\ucb95', '\ucb96', 
    '\ucb97', '\ucb98', '\ucb99', '\ucb9a', '\ucb9b', '\ucb9d', '\ucb9e', '\ucb9f', 
    '\ucba0', '\ucba1', '\ucba2', '\ucba3', '\ucba4', '\ucba5', '\ucba6', '\ucba7', 
    '\ucba8', '\ucba9', '\ucbaa', '\ucbab', '\ucbac', '\ucbad', '\ucbae', '\ucbaf', 
    '\ucbb0', '\ucbb1', '\ucbb2', '\ucbb3', '\ucbb4', '\ucbb5', '\ucbb6', '\ucbb7', 
    '\ucbb9', '\ucbba', '\ucbbb', '\ucbbc', '\ucbbd', '\ucbbe', '\ucbbf', '\ucbc0', 
    '\ucbc1', '\ucbc2', '\ucbc3', '\ucbc4', '\ucbc5', '\ucbc6', '\ucbc7', '\ucbc8', 
    '\ucbc9', '\ucbca', '\ucbcb', '\ucbcc', '\ucbcd', '\ucbce', '\ucbcf', '\ucbd0', 
    '\ucbd1', '\ucbd2', '\ucbd3', '\ucbd5', '\ucbd6', '\ucbd7', '\ucbd8', '\ucbd9', 
    '\ucbda', '\ucbdb', '\ucbdc', '\ucbdd', '\ucbde', '\ucbdf', '\ucbe0', '\ucbe1', 
    '\ucbe2', '\ucbe3', '\ucbe4', '\ucbe5', '\ucbe6', '\ucbe7', '\ucbe8', '\ucbe9', 
    '\ucbea', '\ucbeb', '\ucbec', '\ucbed', '\ucbee', '\ucbef', '\ucbf1', '\ucbf2', 
    '\ucbf3', '\ucbf4', '\ucbf5', '\ucbf6', '\ucbf7', '\ucbf8', '\ucbf9', '\ucbfa', 
    '\ucbfb', '\ucbfc', '\ucbfd', '\ucbfe', '\ucbff', '\ucc00', '\ucc01', '\ucc02', 
    '\ucc03', '\ucc04', '\ucc05', '\ucc06', '\ucc07', '\ucc08', '\ucc09', '\ucc0a', 
    '\ucc0b', '\ucc0d', '\ucc0e', '\ucc0f', '\ucc10', '\ucc11', '\ucc12', '\ucc13', 
    '\ucc14', '\ucc15', '\ucc16', '\ucc17', '\ucc18', '\ucc19', '\ucc1a', '\ucc1b', 
    '\ucc1c', '\ucc1d', '\ucc1e', '\ucc1f', '\ucc20', '\ucc21', '\ucc22', '\ucc23', 
    '\ucc24', '\ucc25', '\ucc26', '\ucc27', '\ucc29', '\ucc2a', '\ucc2b', '\ucc2c', 
    '\ucc2d', '\ucc2e', '\ucc2f', '\ucc30', '\ucc31', '\ucc32', '\ucc33', '\ucc34', 
    '\ucc35', '\ucc36', '\ucc37', '\ucc38', '\ucc39', '\ucc3a', '\ucc3b', '\ucc3c', 
    '\ucc3d', '\ucc3e', '\ucc3f', '\ucc40', '\ucc41', '\ucc42', '\ucc43', '\ucc45', 
    '\ucc46', '\ucc47', '\ucc48', '\ucc49', '\ucc4a', '\ucc4b', '\ucc4c', '\ucc4d', 
    '\ucc4e', '\ucc4f', '\ucc50', '\ucc51', '\ucc52', '\ucc53', '\ucc54', '\ucc55', 
    '\ucc56', '\ucc57', '\ucc58', '\ucc59', '\ucc5a', '\ucc5b', '\ucc5c', '\ucc5d', 
    '\ucc5e', '\ucc5f', '\ucc61', '\ucc62', '\ucc63', '\ucc64', '\ucc65', '\ucc66', 
    '\ucc67', '\ucc68', '\ucc69', '\ucc6a', '\ucc6b', '\ucc6c', '\ucc6d', '\ucc6e', 
    '\ucc6f', '\ucc70', '\ucc71', '\ucc72', '\ucc73', '\ucc74', '\ucc75', '\ucc76', 
    '\ucc77', '\ucc78', '\ucc79', '\ucc7a', '\ucc7b', '\ucc7d', '\ucc7e', '\ucc7f', 
    '\ucc80', '\ucc81', '\ucc82', '\ucc83', '\ucc84', '\ucc85', '\ucc86', '\ucc87', 
    '\ucc88', '\ucc89', '\ucc8a', '\ucc8b', '\ucc8c', '\ucc8d', '\ucc8e', '\ucc8f', 
    '\ucc90', '\ucc91', '\ucc92', '\ucc93', '\ucc94', '\ucc95', '\ucc96', '\ucc97', 
    '\ucc99', '\ucc9a', '\ucc9b', '\ucc9c', '\ucc9d', '\ucc9e', '\ucc9f', '\ucca0', 
    '\ucca1', '\ucca2', '\ucca3', '\ucca4', '\ucca5', '\ucca6', '\ucca7', '\ucca8', 
    '\ucca9', '\uccaa', '\uccab', '\uccac', '\uccad', '\uccae', '\uccaf', '\uccb0', 
    '\uccb1', '\uccb2', '\uccb3', '\uccb5', '\uccb6', '\uccb7', '\uccb8', '\uccb9', 
    '\uccba', '\uccbb', '\uccbc', '\uccbd', '\uccbe', '\uccbf', '\uccc0', '\uccc1', 
    '\uccc2', '\uccc3', '\uccc4', '\uccc5', '\uccc6', '\uccc7', '\uccc8', '\uccc9', 
    '\uccca', '\ucccb', '\ucccc', '\ucccd', '\uccce', '\ucccf', '\uccd1', '\uccd2', 
    '\uccd3', '\uccd4', '\uccd5', '\uccd6', '\uccd7', '\uccd8', '\uccd9', '\uccda', 
    '\uccdb', '\uccdc', '\uccdd', '\uccde', '\uccdf', '\ucce0', '\ucce1', '\ucce2', 
    '\ucce3', '\ucce4', '\ucce5', '\ucce6', '\ucce7', '\ucce8', '\ucce9', '\uccea', 
    '\ucceb', '\ucced', '\uccee', '\uccef', '\uccf0', '\uccf1', '\uccf2', '\uccf3', 
    '\uccf4', '\uccf5', '\uccf6', '\uccf7', '\uccf8', '\uccf9', '\uccfa', '\uccfb', 
    '\uccfc', '\uccfd', '\uccfe', '\uccff', '\ucd00', '\ucd01', '\ucd02', '\ucd03', 
    '\ucd04', '\ucd05', '\ucd06', '\ucd07', '\ucd09', '\ucd0a', '\ucd0b', '\ucd0c', 
    '\ucd0d', '\ucd0e', '\ucd0f', '\ucd10', '\ucd11', '\ucd12', '\ucd13', '\ucd14', 
    '\ucd15', '\ucd16', '\ucd17', '\ucd18', '\ucd19', '\ucd1a', '\ucd1b', '\ucd1c', 
    '\ucd1d', '\ucd1e', '\ucd1f', '\ucd20', '\ucd21', '\ucd22', '\ucd23', '\ucd25', 
    '\ucd26', '\ucd27', '\ucd28', '\ucd29', '\ucd2a', '\ucd2b', '\ucd2c', '\ucd2d', 
    '\ucd2e', '\ucd2f', '\ucd30', '\ucd31', '\ucd32', '\ucd33', '\ucd34', '\ucd35', 
    '\ucd36', '\ucd37', '\ucd38', '\ucd39', '\ucd3a', '\ucd3b', '\ucd3c', '\ucd3d', 
    '\ucd3e', '\ucd3f', '\ucd41', '\ucd42', '\ucd43', '\ucd44', '\ucd45', '\ucd46', 
    '\ucd47', '\ucd48', '\ucd49', '\ucd4a', '\ucd4b', '\ucd4c', '\ucd4d', '\ucd4e', 
    '\ucd4f', '\ucd50', '\ucd51', '\ucd52', '\ucd53', '\ucd54', '\ucd55', '\ucd56', 
    '\ucd57', '\ucd58', '\ucd59', '\ucd5a', '\ucd5b', '\ucd5d', '\ucd5e', '\ucd5f', 
    '\ucd60', '\ucd61', '\ucd62', '\ucd63', '\ucd64', '\ucd65', '\ucd66', '\ucd67', 
    '\ucd68', '\ucd69', '\ucd6a', '\ucd6b', '\ucd6c', '\ucd6d', '\ucd6e', '\ucd6f', 
    '\ucd70', '\ucd71', '\ucd72', '\ucd73', '\ucd74', '\ucd75', '\ucd76', '\ucd77', 
    '\ucd79', '\ucd7a', '\ucd7b', '\ucd7c', '\ucd7d', '\ucd7e', '\ucd7f', '\ucd80', 
    '\ucd81', '\ucd82', '\ucd83', '\ucd84', '\ucd85', '\ucd86', '\ucd87', '\ucd88', 
    '\ucd89', '\ucd8a', '\ucd8b', '\ucd8c', '\ucd8d', '\ucd8e', '\ucd8f', '\ucd90', 
    '\ucd91', '\ucd92', '\ucd93', '\ucd95', '\ucd96', '\ucd97', '\ucd98', '\ucd99', 
    '\ucd9a', '\ucd9b', '\ucd9c', '\ucd9d', '\ucd9e', '\ucd9f', '\ucda0', '\ucda1', 
    '\ucda2', '\ucda3', '\ucda4', '\ucda5', '\ucda6', '\ucda7', '\ucda8', '\ucda9', 
    '\ucdaa', '\ucdab', '\ucdac', '\ucdad', '\ucdae', '\ucdaf', '\ucdb1', '\ucdb2', 
    '\ucdb3', '\ucdb4', '\ucdb5', '\ucdb6', '\ucdb7', '\ucdb8', '\ucdb9', '\ucdba', 
    '\ucdbb', '\ucdbc', '\ucdbd', '\ucdbe', '\ucdbf', '\ucdc0', '\ucdc1', '\ucdc2', 
    '\ucdc3', '\ucdc4', '\ucdc5', '\ucdc6', '\ucdc7', '\ucdc8', '\ucdc9', '\ucdca', 
    '\ucdcb', '\ucdcd', '\ucdce', '\ucdcf', '\ucdd0', '\ucdd1', '\ucdd2', '\ucdd3', 
    '\ucdd4', '\ucdd5', '\ucdd6', '\ucdd7', '\ucdd8', '\ucdd9', '\ucdda', '\ucddb', 
    '\ucddc', '\ucddd', '\ucdde', '\ucddf', '\ucde0', '\ucde1', '\ucde2', '\ucde3', 
    '\ucde4', '\ucde5', '\ucde6', '\ucde7', '\ucde9', '\ucdea', '\ucdeb', '\ucdec', 
    '\ucded', '\ucdee', '\ucdef', '\ucdf0', '\ucdf1', '\ucdf2', '\ucdf3', '\ucdf4', 
    '\ucdf5', '\ucdf6', '\ucdf7', '\ucdf8', '\ucdf9', '\ucdfa', '\ucdfb', '\ucdfc', 
    '\ucdfd', '\ucdfe', '\ucdff', '\uce00', '\uce01', '\uce02', '\uce03', '\uce05', 
    '\uce06', '\uce07', '\uce08', '\uce09', '\uce0a', '\uce0b', '\uce0c', '\uce0d', 
    '\uce0e', '\uce0f', '\uce10', '\uce11', '\uce12', '\uce13', '\uce14', '\uce15', 
    '\uce16', '\uce17', '\uce18', '\uce19', '\uce1a', '\uce1b', '\uce1c', '\uce1d', 
    '\uce1e', '\uce1f', '\uce21', '\uce22', '\uce23', '\uce24', '\uce25', '\uce26', 
    '\uce27', '\uce28', '\uce29', '\uce2a', '\uce2b', '\uce2c', '\uce2d', '\uce2e', 
    '\uce2f', '\uce30', '\uce31', '\uce32', '\uce33', '\uce34', '\uce35', '\uce36', 
    '\uce37', '\uce38', '\uce39', '\uce3a', '\uce3b', '\uce3d', '\uce3e', '\uce3f', 
    '\uce40', '\uce41', '\uce42', '\uce43', '\uce44', '\uce45', '\uce46', '\uce47', 
    '\uce48', '\uce49', '\uce4a', '\uce4b', '\uce4c', '\uce4d', '\uce4e', '\uce4f', 
    '\uce50', '\uce51', '\uce52', '\uce53', '\uce54', '\uce55', '\uce56', '\uce57', 
    '\uce59', '\uce5a', '\uce5b', '\uce5c', '\uce5d', '\uce5e', '\uce5f', '\uce60', 
    '\uce61', '\uce62', '\uce63', '\uce64', '\uce65', '\uce66', '\uce67', '\uce68', 
    '\uce69', '\uce6a', '\uce6b', '\uce6c', '\uce6d', '\uce6e', '\uce6f', '\uce70', 
    '\uce71', '\uce72', '\uce73', '\uce75', '\uce76', '\uce77', '\uce78', '\uce79', 
    '\uce7a', '\uce7b', '\uce7c', '\uce7d', '\uce7e', '\uce7f', '\uce80', '\uce81', 
    '\uce82', '\uce83', '\uce84', '\uce85', '\uce86', '\uce87', '\uce88', '\uce89', 
    '\uce8a', '\uce8b', '\uce8c', '\uce8d', '\uce8e', '\uce8f', '\uce91', '\uce92', 
    '\uce93', '\uce94', '\uce95', '\uce96', '\uce97', '\uce98', '\uce99', '\uce9a', 
    '\uce9b', '\uce9c', '\uce9d', '\uce9e', '\uce9f', '\ucea0', '\ucea1', '\ucea2', 
    '\ucea3', '\ucea4', '\ucea5', '\ucea6', '\ucea7', '\ucea8', '\ucea9', '\uceaa', 
    '\uceab', '\ucead', '\uceae', '\uceaf', '\uceb0', '\uceb1', '\uceb2', '\uceb3', 
    '\uceb4', '\uceb5', '\uceb6', '\uceb7', '\uceb8', '\uceb9', '\uceba', '\ucebb', 
    '\ucebc', '\ucebd', '\ucebe', '\ucebf', '\ucec0', '\ucec1', '\ucec2', '\ucec3', 
    '\ucec4', '\ucec5', '\ucec6', '\ucec7', '\ucec9', '\uceca', '\ucecb', '\ucecc', 
    '\ucecd', '\ucece', '\ucecf', '\uced0', '\uced1', '\uced2', '\uced3', '\uced4', 
    '\uced5', '\uced6', '\uced7', '\uced8', '\uced9', '\uceda', '\ucedb', '\ucedc', 
    '\ucedd', '\ucede', '\ucedf', '\ucee0', '\ucee1', '\ucee2', '\ucee3', '\ucee5', 
    '\ucee6', '\ucee7', '\ucee8', '\ucee9', '\uceea', '\uceeb', '\uceec', '\uceed', 
    '\uceee', '\uceef', '\ucef0', '\ucef1', '\ucef2', '\ucef3', '\ucef4', '\ucef5', 
    '\ucef6', '\ucef7', '\ucef8', '\ucef9', '\ucefa', '\ucefb', '\ucefc', '\ucefd', 
    '\ucefe', '\uceff', '\ucf01', '\ucf02', '\ucf03', '\ucf04', '\ucf05', '\ucf06', 
    '\ucf07', '\ucf08', '\ucf09', '\ucf0a', '\ucf0b', '\ucf0c', '\ucf0d', '\ucf0e', 
    '\ucf0f', '\ucf10', '\ucf11', '\ucf12', '\ucf13', '\ucf14', '\ucf15', '\ucf16', 
    '\ucf17', '\ucf18', '\ucf19', '\ucf1a', '\ucf1b', '\ucf1d', '\ucf1e', '\ucf1f', 
    '\ucf20', '\ucf21', '\ucf22', '\ucf23', '\ucf24', '\ucf25', '\ucf26', '\ucf27', 
    '\ucf28', '\ucf29', '\ucf2a', '\ucf2b', '\ucf2c', '\ucf2d', '\ucf2e', '\ucf2f', 
    '\ucf30', '\ucf31', '\ucf32', '\ucf33', '\ucf34', '\ucf35', '\ucf36', '\ucf37', 
    '\ucf39', '\ucf3a', '\ucf3b', '\ucf3c', '\ucf3d', '\ucf3e', '\ucf3f', '\ucf40', 
    '\ucf41', '\ucf42', '\ucf43', '\ucf44', '\ucf45', '\ucf46', '\ucf47', '\ucf48', 
    '\ucf49', '\ucf4a', '\ucf4b', '\ucf4c', '\ucf4d', '\ucf4e', '\ucf4f', '\ucf50', 
    '\ucf51', '\ucf52', '\ucf53', '\ucf55', '\ucf56', '\ucf57', '\ucf58', '\ucf59', 
    '\ucf5a', '\ucf5b', '\ucf5c', '\ucf5d', '\ucf5e', '\ucf5f', '\ucf60', '\ucf61', 
    '\ucf62', '\ucf63', '\ucf64', '\ucf65', '\ucf66', '\ucf67', '\ucf68', '\ucf69', 
    '\ucf6a', '\ucf6b', '\ucf6c', '\ucf6d', '\ucf6e', '\ucf6f', '\ucf71', '\ucf72', 
    '\ucf73', '\ucf74', '\ucf75', '\ucf76', '\ucf77', '\ucf78', '\ucf79', '\ucf7a', 
    '\ucf7b', '\ucf7c', '\ucf7d', '\ucf7e', '\ucf7f', '\ucf80', '\ucf81', '\ucf82', 
    '\ucf83', '\ucf84', '\ucf85', '\ucf86', '\ucf87', '\ucf88', '\ucf89', '\ucf8a', 
    '\ucf8b', '\ucf8d', '\ucf8e', '\ucf8f', '\ucf90', '\ucf91', '\ucf92', '\ucf93', 
    '\ucf94', '\ucf95', '\ucf96', '\ucf97', '\ucf98', '\ucf99', '\ucf9a', '\ucf9b', 
    '\ucf9c', '\ucf9d', '\ucf9e', '\ucf9f', '\ucfa0', '\ucfa1', '\ucfa2', '\ucfa3', 
    '\ucfa4', '\ucfa5', '\ucfa6', '\ucfa7', '\ucfa9', '\ucfaa', '\ucfab', '\ucfac', 
    '\ucfad', '\ucfae', '\ucfaf', '\ucfb0', '\ucfb1', '\ucfb2', '\ucfb3', '\ucfb4', 
    '\ucfb5', '\ucfb6', '\ucfb7', '\ucfb8', '\ucfb9', '\ucfba', '\ucfbb', '\ucfbc', 
    '\ucfbd', '\ucfbe', '\ucfbf', '\ucfc0', '\ucfc1', '\ucfc2', '\ucfc3', '\ucfc5', 
    '\ucfc6', '\ucfc7', '\ucfc8', '\ucfc9', '\ucfca', '\ucfcb', '\ucfcc', '\ucfcd', 
    '\ucfce', '\ucfcf', '\ucfd0', '\ucfd1', '\ucfd2', '\ucfd3', '\ucfd4', '\ucfd5', 
    '\ucfd6', '\ucfd7', '\ucfd8', '\ucfd9', '\ucfda', '\ucfdb', '\ucfdc', '\ucfdd', 
    '\ucfde', '\ucfdf', '\ucfe1', '\ucfe2', '\ucfe3', '\ucfe4', '\ucfe5', '\ucfe6', 
    '\ucfe7', '\ucfe8', '\ucfe9', '\ucfea', '\ucfeb', '\ucfec', '\ucfed', '\ucfee', 
    '\ucfef', '\ucff0', '\ucff1', '\ucff2', '\ucff3', '\ucff4', '\ucff5', '\ucff6', 
    '\ucff7', '\ucff8', '\ucff9', '\ucffa', '\ucffb', '\ucffd', '\ucffe', '\ucfff', 
    '\ud000', '\ud001', '\ud002', '\ud003', '\ud004', '\ud005', '\ud006', '\ud007', 
    '\ud008', '\ud009', '\ud00a', '\ud00b', '\ud00c', '\ud00d', '\ud00e', '\ud00f', 
    '\ud010', '\ud011', '\ud012', '\ud013', '\ud014', '\ud015', '\ud016', '\ud017', 
    '\ud019', '\ud01a', '\ud01b', '\ud01c', '\ud01d', '\ud01e', '\ud01f', '\ud020', 
    '\ud021', '\ud022', '\ud023', '\ud024', '\ud025', '\ud026', '\ud027', '\ud028', 
    '\ud029', '\ud02a', '\ud02b', '\ud02c', '\ud02d', '\ud02e', '\ud02f', '\ud030', 
    '\ud031', '\ud032', '\ud033', '\ud035', '\ud036', '\ud037', '\ud038', '\ud039', 
    '\ud03a', '\ud03b', '\ud03c', '\ud03d', '\ud03e', '\ud03f', '\ud040', '\ud041', 
    '\ud042', '\ud043', '\ud044', '\ud045', '\ud046', '\ud047', '\ud048', '\ud049', 
    '\ud04a', '\ud04b', '\ud04c', '\ud04d', '\ud04e', '\ud04f', '\ud051', '\ud052', 
    '\ud053', '\ud054', '\ud055', '\ud056', '\ud057', '\ud058', '\ud059', '\ud05a', 
    '\ud05b', '\ud05c', '\ud05d', '\ud05e', '\ud05f', '\ud060', '\ud061', '\ud062', 
    '\ud063', '\ud064', '\ud065', '\ud066', '\ud067', '\ud068', '\ud069', '\ud06a', 
    '\ud06b', '\ud06d', '\ud06e', '\ud06f', '\ud070', '\ud071', '\ud072', '\ud073', 
    '\ud074', '\ud075', '\ud076', '\ud077', '\ud078', '\ud079', '\ud07a', '\ud07b', 
    '\ud07c', '\ud07d', '\ud07e', '\ud07f', '\ud080', '\ud081', '\ud082', '\ud083', 
    '\ud084', '\ud085', '\ud086', '\ud087', '\ud089', '\ud08a', '\ud08b', '\ud08c', 
    '\ud08d', '\ud08e', '\ud08f', '\ud090', '\ud091', '\ud092', '\ud093', '\ud094', 
    '\ud095', '\ud096', '\ud097', '\ud098', '\ud099', '\ud09a', '\ud09b', '\ud09c', 
    '\ud09d', '\ud09e', '\ud09f', '\ud0a0', '\ud0a1', '\ud0a2', '\ud0a3', '\ud0a5', 
    '\ud0a6', '\ud0a7', '\ud0a8', '\ud0a9', '\ud0aa', '\ud0ab', '\ud0ac', '\ud0ad', 
    '\ud0ae', '\ud0af', '\ud0b0', '\ud0b1', '\ud0b2', '\ud0b3', '\ud0b4', '\ud0b5', 
    '\ud0b6', '\ud0b7', '\ud0b8', '\ud0b9', '\ud0ba', '\ud0bb', '\ud0bc', '\ud0bd', 
    '\ud0be', '\ud0bf', '\ud0c1', '\ud0c2', '\ud0c3', '\ud0c4', '\ud0c5', '\ud0c6', 
    '\ud0c7', '\ud0c8', '\ud0c9', '\ud0ca', '\ud0cb', '\ud0cc', '\ud0cd', '\ud0ce', 
    '\ud0cf', '\ud0d0', '\ud0d1', '\ud0d2', '\ud0d3', '\ud0d4', '\ud0d5', '\ud0d6', 
    '\ud0d7', '\ud0d8', '\ud0d9', '\ud0da', '\ud0db', '\ud0dd', '\ud0de', '\ud0df', 
    '\ud0e0', '\ud0e1', '\ud0e2', '\ud0e3', '\ud0e4', '\ud0e5', '\ud0e6', '\ud0e7', 
    '\ud0e8', '\ud0e9', '\ud0ea', '\ud0eb', '\ud0ec', '\ud0ed', '\ud0ee', '\ud0ef', 
    '\ud0f0', '\ud0f1', '\ud0f2', '\ud0f3', '\ud0f4', '\ud0f5', '\ud0f6', '\ud0f7', 
    '\ud0f9', '\ud0fa', '\ud0fb', '\ud0fc', '\ud0fd', '\ud0fe', '\ud0ff', '\ud100', 
    '\ud101', '\ud102', '\ud103', '\ud104', '\ud105', '\ud106', '\ud107', '\ud108', 
    '\ud109', '\ud10a', '\ud10b', '\ud10c', '\ud10d', '\ud10e', '\ud10f', '\ud110', 
    '\ud111', '\ud112', '\ud113', '\ud115', '\ud116', '\ud117', '\ud118', '\ud119', 
    '\ud11a', '\ud11b', '\ud11c', '\ud11d', '\ud11e', '\ud11f', '\ud120', '\ud121', 
    '\ud122', '\ud123', '\ud124', '\ud125', '\ud126', '\ud127', '\ud128', '\ud129', 
    '\ud12a', '\ud12b', '\ud12c', '\ud12d', '\ud12e', '\ud12f', '\ud131', '\ud132', 
    '\ud133', '\ud134', '\ud135', '\ud136', '\ud137', '\ud138', '\ud139', '\ud13a', 
    '\ud13b', '\ud13c', '\ud13d', '\ud13e', '\ud13f', '\ud140', '\ud141', '\ud142', 
    '\ud143', '\ud144', '\ud145', '\ud146', '\ud147', '\ud148', '\ud149', '\ud14a', 
    '\ud14b', '\ud14d', '\ud14e', '\ud14f', '\ud150', '\ud151', '\ud152', '\ud153', 
    '\ud154', '\ud155', '\ud156', '\ud157', '\ud158', '\ud159', '\ud15a', '\ud15b', 
    '\ud15c', '\ud15d', '\ud15e', '\ud15f', '\ud160', '\ud161', '\ud162', '\ud163', 
    '\ud164', '\ud165', '\ud166', '\ud167', '\ud169', '\ud16a', '\ud16b', '\ud16c', 
    '\ud16d', '\ud16e', '\ud16f', '\ud170', '\ud171', '\ud172', '\ud173', '\ud174', 
    '\ud175', '\ud176', '\ud177', '\ud178', '\ud179', '\ud17a', '\ud17b', '\ud17c', 
    '\ud17d', '\ud17e', '\ud17f', '\ud180', '\ud181', '\ud182', '\ud183', '\ud185', 
    '\ud186', '\ud187', '\ud188', '\ud189', '\ud18a', '\ud18b', '\ud18c', '\ud18d', 
    '\ud18e', '\ud18f', '\ud190', '\ud191', '\ud192', '\ud193', '\ud194', '\ud195', 
    '\ud196', '\ud197', '\ud198', '\ud199', '\ud19a', '\ud19b', '\ud19c', '\ud19d', 
    '\ud19e', '\ud19f', '\ud1a1', '\ud1a2', '\ud1a3', '\ud1a4', '\ud1a5', '\ud1a6', 
    '\ud1a7', '\ud1a8', '\ud1a9', '\ud1aa', '\ud1ab', '\ud1ac', '\ud1ad', '\ud1ae', 
    '\ud1af', '\ud1b0', '\ud1b1', '\ud1b2', '\ud1b3', '\ud1b4', '\ud1b5', '\ud1b6', 
    '\ud1b7', '\ud1b8', '\ud1b9', '\ud1ba', '\ud1bb', '\ud1bd', '\ud1be', '\ud1bf', 
    '\ud1c0', '\ud1c1', '\ud1c2', '\ud1c3', '\ud1c4', '\ud1c5', '\ud1c6', '\ud1c7', 
    '\ud1c8', '\ud1c9', '\ud1ca', '\ud1cb', '\ud1cc', '\ud1cd', '\ud1ce', '\ud1cf', 
    '\ud1d0', '\ud1d1', '\ud1d2', '\ud1d3', '\ud1d4', '\ud1d5', '\ud1d6', '\ud1d7', 
    '\ud1d9', '\ud1da', '\ud1db', '\ud1dc', '\ud1dd', '\ud1de', '\ud1df', '\ud1e0', 
    '\ud1e1', '\ud1e2', '\ud1e3', '\ud1e4', '\ud1e5', '\ud1e6', '\ud1e7', '\ud1e8', 
    '\ud1e9', '\ud1ea', '\ud1eb', '\ud1ec', '\ud1ed', '\ud1ee', '\ud1ef', '\ud1f0', 
    '\ud1f1', '\ud1f2', '\ud1f3', '\ud1f5', '\ud1f6', '\ud1f7', '\ud1f8', '\ud1f9', 
    '\ud1fa', '\ud1fb', '\ud1fc', '\ud1fd', '\ud1fe', '\ud1ff', '\ud200', '\ud201', 
    '\ud202', '\ud203', '\ud204', '\ud205', '\ud206', '\ud207', '\ud208', '\ud209', 
    '\ud20a', '\ud20b', '\ud20c', '\ud20d', '\ud20e', '\ud20f', '\ud211', '\ud212', 
    '\ud213', '\ud214', '\ud215', '\ud216', '\ud217', '\ud218', '\ud219', '\ud21a', 
    '\ud21b', '\ud21c', '\ud21d', '\ud21e', '\ud21f', '\ud220', '\ud221', '\ud222', 
    '\ud223', '\ud224', '\ud225', '\ud226', '\ud227', '\ud228', '\ud229', '\ud22a', 
    '\ud22b', '\ud22d', '\ud22e', '\ud22f', '\ud230', '\ud231', '\ud232', '\ud233', 
    '\ud234', '\ud235', '\ud236', '\ud237', '\ud238', '\ud239', '\ud23a', '\ud23b', 
    '\ud23c', '\ud23d', '\ud23e', '\ud23f', '\ud240', '\ud241', '\ud242', '\ud243', 
    '\ud244', '\ud245', '\ud246', '\ud247', '\ud249', '\ud24a', '\ud24b', '\ud24c', 
    '\ud24d', '\ud24e', '\ud24f', '\ud250', '\ud251', '\ud252', '\ud253', '\ud254', 
    '\ud255', '\ud256', '\ud257', '\ud258', '\ud259', '\ud25a', '\ud25b', '\ud25c', 
    '\ud25d', '\ud25e', '\ud25f', '\ud260', '\ud261', '\ud262', '\ud263', '\ud265', 
    '\ud266', '\ud267', '\ud268', '\ud269', '\ud26a', '\ud26b', '\ud26c', '\ud26d', 
    '\ud26e', '\ud26f', '\ud270', '\ud271', '\ud272', '\ud273', '\ud274', '\ud275', 
    '\ud276', '\ud277', '\ud278', '\ud279', '\ud27a', '\ud27b', '\ud27c', '\ud27d', 
    '\ud27e', '\ud27f', '\ud281', '\ud282', '\ud283', '\ud284', '\ud285', '\ud286', 
    '\ud287', '\ud288', '\ud289', '\ud28a', '\ud28b', '\ud28c', '\ud28d', '\ud28e', 
    '\ud28f', '\ud290', '\ud291', '\ud292', '\ud293', '\ud294', '\ud295', '\ud296', 
    '\ud297', '\ud298', '\ud299', '\ud29a', '\ud29b', '\ud29d', '\ud29e', '\ud29f', 
    '\ud2a0', '\ud2a1', '\ud2a2', '\ud2a3', '\ud2a4', '\ud2a5', '\ud2a6', '\ud2a7', 
    '\ud2a8', '\ud2a9', '\ud2aa', '\ud2ab', '\ud2ac', '\ud2ad', '\ud2ae', '\ud2af', 
    '\ud2b0', '\ud2b1', '\ud2b2', '\ud2b3', '\ud2b4', '\ud2b5', '\ud2b6', '\ud2b7', 
    '\ud2b9', '\ud2ba', '\ud2bb', '\ud2bc', '\ud2bd', '\ud2be', '\ud2bf', '\ud2c0', 
    '\ud2c1', '\ud2c2', '\ud2c3', '\ud2c4', '\ud2c5', '\ud2c6', '\ud2c7', '\ud2c8', 
    '\ud2c9', '\ud2ca', '\ud2cb', '\ud2cc', '\ud2cd', '\ud2ce', '\ud2cf', '\ud2d0', 
    '\ud2d1', '\ud2d2', '\ud2d3', '\ud2d5', '\ud2d6', '\ud2d7', '\ud2d8', '\ud2d9', 
    '\ud2da', '\ud2db', '\ud2dc', '\ud2dd', '\ud2de', '\ud2df', '\ud2e0', '\ud2e1', 
    '\ud2e2', '\ud2e3', '\ud2e4', '\ud2e5', '\ud2e6', '\ud2e7', '\ud2e8', '\ud2e9', 
    '\ud2ea', '\ud2eb', '\ud2ec', '\ud2ed', '\ud2ee', '\ud2ef', '\ud2f1', '\ud2f2', 
    '\ud2f3', '\ud2f4', '\ud2f5', '\ud2f6', '\ud2f7', '\ud2f8', '\ud2f9', '\ud2fa', 
    '\ud2fb', '\ud2fc', '\ud2fd', '\ud2fe', '\ud2ff', '\ud300', '\ud301', '\ud302', 
    '\ud303', '\ud304', '\ud305', '\ud306', '\ud307', '\ud308', '\ud309', '\ud30a', 
    '\ud30b', '\ud30d', '\ud30e', '\ud30f', '\ud310', '\ud311', '\ud312', '\ud313', 
    '\ud314', '\ud315', '\ud316', '\ud317', '\ud318', '\ud319', '\ud31a', '\ud31b', 
    '\ud31c', '\ud31d', '\ud31e', '\ud31f', '\ud320', '\ud321', '\ud322', '\ud323', 
    '\ud324', '\ud325', '\ud326', '\ud327', '\ud329', '\ud32a', '\ud32b', '\ud32c', 
    '\ud32d', '\ud32e', '\ud32f', '\ud330', '\ud331', '\ud332', '\ud333', '\ud334', 
    '\ud335', '\ud336', '\ud337', '\ud338', '\ud339', '\ud33a', '\ud33b', '\ud33c', 
    '\ud33d', '\ud33e', '\ud33f', '\ud340', '\ud341', '\ud342', '\ud343', '\ud345', 
    '\ud346', '\ud347', '\ud348', '\ud349', '\ud34a', '\ud34b', '\ud34c', '\ud34d', 
    '\ud34e', '\ud34f', '\ud350', '\ud351', '\ud352', '\ud353', '\ud354', '\ud355', 
    '\ud356', '\ud357', '\ud358', '\ud359', '\ud35a', '\ud35b', '\ud35c', '\ud35d', 
    '\ud35e', '\ud35f', '\ud361', '\ud362', '\ud363', '\ud364', '\ud365', '\ud366', 
    '\ud367', '\ud368', '\ud369', '\ud36a', '\ud36b', '\ud36c', '\ud36d', '\ud36e', 
    '\ud36f', '\ud370', '\ud371', '\ud372', '\ud373', '\ud374', '\ud375', '\ud376', 
    '\ud377', '\ud378', '\ud379', '\ud37a', '\ud37b', '\ud37d', '\ud37e', '\ud37f', 
    '\ud380', '\ud381', '\ud382', '\ud383', '\ud384', '\ud385', '\ud386', '\ud387', 
    '\ud388', '\ud389', '\ud38a', '\ud38b', '\ud38c', '\ud38d', '\ud38e', '\ud38f', 
    '\ud390', '\ud391', '\ud392', '\ud393', '\ud394', '\ud395', '\ud396', '\ud397', 
    '\ud399', '\ud39a', '\ud39b', '\ud39c', '\ud39d', '\ud39e', '\ud39f', '\ud3a0', 
    '\ud3a1', '\ud3a2', '\ud3a3', '\ud3a4', '\ud3a5', '\ud3a6', '\ud3a7', '\ud3a8', 
    '\ud3a9', '\ud3aa', '\ud3ab', '\ud3ac', '\ud3ad', '\ud3ae', '\ud3af', '\ud3b0', 
    '\ud3b1', '\ud3b2', '\ud3b3', '\ud3b5', '\ud3b6', '\ud3b7', '\ud3b8', '\ud3b9', 
    '\ud3ba', '\ud3bb', '\ud3bc', '\ud3bd', '\ud3be', '\ud3bf', '\ud3c0', '\ud3c1', 
    '\ud3c2', '\ud3c3', '\ud3c4', '\ud3c5', '\ud3c6', '\ud3c7', '\ud3c8', '\ud3c9', 
    '\ud3ca', '\ud3cb', '\ud3cc', '\ud3cd', '\ud3ce', '\ud3cf', '\ud3d1', '\ud3d2', 
    '\ud3d3', '\ud3d4', '\ud3d5', '\ud3d6', '\ud3d7', '\ud3d8', '\ud3d9', '\ud3da', 
    '\ud3db', '\ud3dc', '\ud3dd', '\ud3de', '\ud3df', '\ud3e0', '\ud3e1', '\ud3e2', 
    '\ud3e3', '\ud3e4', '\ud3e5', '\ud3e6', '\ud3e7', '\ud3e8', '\ud3e9', '\ud3ea', 
    '\ud3eb', '\ud3ed', '\ud3ee', '\ud3ef', '\ud3f0', '\ud3f1', '\ud3f2', '\ud3f3', 
    '\ud3f4', '\ud3f5', '\ud3f6', '\ud3f7', '\ud3f8', '\ud3f9', '\ud3fa', '\ud3fb', 
    '\ud3fc', '\ud3fd', '\ud3fe', '\ud3ff', '\ud400', '\ud401', '\ud402', '\ud403', 
    '\ud404', '\ud405', '\ud406', '\ud407', '\ud409', '\ud40a', '\ud40b', '\ud40c', 
    '\ud40d', '\ud40e', '\ud40f', '\ud410', '\ud411', '\ud412', '\ud413', '\ud414', 
    '\ud415', '\ud416', '\ud417', '\ud418', '\ud419', '\ud41a', '\ud41b', '\ud41c', 
    '\ud41d', '\ud41e', '\ud41f', '\ud420', '\ud421', '\ud422', '\ud423', '\ud425', 
    '\ud426', '\ud427', '\ud428', '\ud429', '\ud42a', '\ud42b', '\ud42c', '\ud42d', 
    '\ud42e', '\ud42f', '\ud430', '\ud431', '\ud432', '\ud433', '\ud434', '\ud435', 
    '\ud436', '\ud437', '\ud438', '\ud439', '\ud43a', '\ud43b', '\ud43c', '\ud43d', 
    '\ud43e', '\ud43f', '\ud441', '\ud442', '\ud443', '\ud444', '\ud445', '\ud446', 
    '\ud447', '\ud448', '\ud449', '\ud44a', '\ud44b', '\ud44c', '\ud44d', '\ud44e', 
    '\ud44f', '\ud450', '\ud451', '\ud452', '\ud453', '\ud454', '\ud455', '\ud456', 
    '\ud457', '\ud458', '\ud459', '\ud45a', '\ud45b', '\ud45d', '\ud45e', '\ud45f', 
    '\ud460', '\ud461', '\ud462', '\ud463', '\ud464', '\ud465', '\ud466', '\ud467', 
    '\ud468', '\ud469', '\ud46a', '\ud46b', '\ud46c', '\ud46d', '\ud46e', '\ud46f', 
    '\ud470', '\ud471', '\ud472', '\ud473', '\ud474', '\ud475', '\ud476', '\ud477', 
    '\ud479', '\ud47a', '\ud47b', '\ud47c', '\ud47d', '\ud47e', '\ud47f', '\ud480', 
    '\ud481', '\ud482', '\ud483', '\ud484', '\ud485', '\ud486', '\ud487', '\ud488', 
    '\ud489', '\ud48a', '\ud48b', '\ud48c', '\ud48d', '\ud48e', '\ud48f', '\ud490', 
    '\ud491', '\ud492', '\ud493', '\ud495', '\ud496', '\ud497', '\ud498', '\ud499', 
    '\ud49a', '\ud49b', '\ud49c', '\ud49d', '\ud49e', '\ud49f', '\ud4a0', '\ud4a1', 
    '\ud4a2', '\ud4a3', '\ud4a4', '\ud4a5', '\ud4a6', '\ud4a7', '\ud4a8', '\ud4a9', 
    '\ud4aa', '\ud4ab', '\ud4ac', '\ud4ad', '\ud4ae', '\ud4af', '\ud4b1', '\ud4b2', 
    '\ud4b3', '\ud4b4', '\ud4b5', '\ud4b6', '\ud4b7', '\ud4b8', '\ud4b9', '\ud4ba', 
    '\ud4bb', '\ud4bc', '\ud4bd', '\ud4be', '\ud4bf', '\ud4c0', '\ud4c1', '\ud4c2', 
    '\ud4c3', '\ud4c4', '\ud4c5', '\ud4c6', '\ud4c7', '\ud4c8', '\ud4c9', '\ud4ca', 
    '\ud4cb', '\ud4cd', '\ud4ce', '\ud4cf', '\ud4d0', '\ud4d1', '\ud4d2', '\ud4d3', 
    '\ud4d4', '\ud4d5', '\ud4d6', '\ud4d7', '\ud4d8', '\ud4d9', '\ud4da', '\ud4db', 
    '\ud4dc', '\ud4dd', '\ud4de', '\ud4df', '\ud4e0', '\ud4e1', '\ud4e2', '\ud4e3', 
    '\ud4e4', '\ud4e5', '\ud4e6', '\ud4e7', '\ud4e9', '\ud4ea', '\ud4eb', '\ud4ec', 
    '\ud4ed', '\ud4ee', '\ud4ef', '\ud4f0', '\ud4f1', '\ud4f2', '\ud4f3', '\ud4f4', 
    '\ud4f5', '\ud4f6', '\ud4f7', '\ud4f8', '\ud4f9', '\ud4fa', '\ud4fb', '\ud4fc', 
    '\ud4fd', '\ud4fe', '\ud4ff', '\ud500', '\ud501', '\ud502', '\ud503', '\ud505', 
    '\ud506', '\ud507', '\ud508', '\ud509', '\ud50a', '\ud50b', '\ud50c', '\ud50d', 
    '\ud50e', '\ud50f', '\ud510', '\ud511', '\ud512', '\ud513', '\ud514', '\ud515', 
    '\ud516', '\ud517', '\ud518', '\ud519', '\ud51a', '\ud51b', '\ud51c', '\ud51d', 
    '\ud51e', '\ud51f', '\ud521', '\ud522', '\ud523', '\ud524', '\ud525', '\ud526', 
    '\ud527', '\ud528', '\ud529', '\ud52a', '\ud52b', '\ud52c', '\ud52d', '\ud52e', 
    '\ud52f', '\ud530', '\ud531', '\ud532', '\ud533', '\ud534', '\ud535', '\ud536', 
    '\ud537', '\ud538', '\ud539', '\ud53a', '\ud53b', '\ud53d', '\ud53e', '\ud53f', 
    '\ud540', '\ud541', '\ud542', '\ud543', '\ud544', '\ud545', '\ud546', '\ud547', 
    '\ud548', '\ud549', '\ud54a', '\ud54b', '\ud54c', '\ud54d', '\ud54e', '\ud54f', 
    '\ud550', '\ud551', '\ud552', '\ud553', '\ud554', '\ud555', '\ud556', '\ud557', 
    '\ud559', '\ud55a', '\ud55b', '\ud55c', '\ud55d', '\ud55e', '\ud55f', '\ud560', 
    '\ud561', '\ud562', '\ud563', '\ud564', '\ud565', '\ud566', '\ud567', '\ud568', 
    '\ud569', '\ud56a', '\ud56b', '\ud56c', '\ud56d', '\ud56e', '\ud56f', '\ud570', 
    '\ud571', '\ud572', '\ud573', '\ud575', '\ud576', '\ud577', '\ud578', '\ud579', 
    '\ud57a', '\ud57b', '\ud57c', '\ud57d', '\ud57e', '\ud57f', '\ud580', '\ud581', 
    '\ud582', '\ud583', '\ud584', '\ud585', '\ud586', '\ud587', '\ud588', '\ud589', 
    '\ud58a', '\ud58b', '\ud58c', '\ud58d', '\ud58e', '\ud58f', '\ud591', '\ud592', 
    '\ud593', '\ud594', '\ud595', '\ud596', '\ud597', '\ud598', '\ud599', '\ud59a', 
    '\ud59b', '\ud59c', '\ud59d', '\ud59e', '\ud59f', '\ud5a0', '\ud5a1', '\ud5a2', 
    '\ud5a3', '\ud5a4', '\ud5a5', '\ud5a6', '\ud5a7', '\ud5a8', '\ud5a9', '\ud5aa', 
    '\ud5ab', '\ud5ad', '\ud5ae', '\ud5af', '\ud5b0', '\ud5b1', '\ud5b2', '\ud5b3', 
    '\ud5b4', '\ud5b5', '\ud5b6', '\ud5b7', '\ud5b8', '\ud5b9', '\ud5ba', '\ud5bb', 
    '\ud5bc', '\ud5bd', '\ud5be', '\ud5bf', '\ud5c0', '\ud5c1', '\ud5c2', '\ud5c3', 
    '\ud5c4', '\ud5c5', '\ud5c6', '\ud5c7', '\ud5c9', '\ud5ca', '\ud5cb', '\ud5cc', 
    '\ud5cd', '\ud5ce', '\ud5cf', '\ud5d0', '\ud5d1', '\ud5d2', '\ud5d3', '\ud5d4', 
    '\ud5d5', '\ud5d6', '\ud5d7', '\ud5d8', '\ud5d9', '\ud5da', '\ud5db', '\ud5dc', 
    '\ud5dd', '\ud5de', '\ud5df', '\ud5e0', '\ud5e1', '\ud5e2', '\ud5e3', '\ud5e5', 
    '\ud5e6', '\ud5e7', '\ud5e8', '\ud5e9', '\ud5ea', '\ud5eb', '\ud5ec', '\ud5ed', 
    '\ud5ee', '\ud5ef', '\ud5f0', '\ud5f1', '\ud5f2', '\ud5f3', '\ud5f4', '\ud5f5', 
    '\ud5f6', '\ud5f7', '\ud5f8', '\ud5f9', '\ud5fa', '\ud5fb', '\ud5fc', '\ud5fd', 
    '\ud5fe', '\ud5ff', '\ud601', '\ud602', '\ud603', '\ud604', '\ud605', '\ud606', 
    '\ud607', '\ud608', '\ud609', '\ud60a', '\ud60b', '\ud60c', '\ud60d', '\ud60e', 
    '\ud60f', '\ud610', '\ud611', '\ud612', '\ud613', '\ud614', '\ud615', '\ud616', 
    '\ud617', '\ud618', '\ud619', '\ud61a', '\ud61b', '\ud61d', '\ud61e', '\ud61f', 
    '\ud620', '\ud621', '\ud622', '\ud623', '\ud624', '\ud625', '\ud626', '\ud627', 
    '\ud628', '\ud629', '\ud62a', '\ud62b', '\ud62c', '\ud62d', '\ud62e', '\ud62f', 
    '\ud630', '\ud631', '\ud632', '\ud633', '\ud634', '\ud635', '\ud636', '\ud637', 
    '\ud639', '\ud63a', '\ud63b', '\ud63c', '\ud63d', '\ud63e', '\ud63f', '\ud640', 
    '\ud641', '\ud642', '\ud643', '\ud644', '\ud645', '\ud646', '\ud647', '\ud648', 
    '\ud649', '\ud64a', '\ud64b', '\ud64c', '\ud64d', '\ud64e', '\ud64f', '\ud650', 
    '\ud651', '\ud652', '\ud653', '\ud655', '\ud656', '\ud657', '\ud658', '\ud659', 
    '\ud65a', '\ud65b', '\ud65c', '\ud65d', '\ud65e', '\ud65f', '\ud660', '\ud661', 
    '\ud662', '\ud663', '\ud664', '\ud665', '\ud666', '\ud667', '\ud668', '\ud669', 
    '\ud66a', '\ud66b', '\ud66c', '\ud66d', '\ud66e', '\ud66f', '\ud671', '\ud672', 
    '\ud673', '\ud674', '\ud675', '\ud676', '\ud677', '\ud678', '\ud679', '\ud67a', 
    '\ud67b', '\ud67c', '\ud67d', '\ud67e', '\ud67f', '\ud680', '\ud681', '\ud682', 
    '\ud683', '\ud684', '\ud685', '\ud686', '\ud687', '\ud688', '\ud689', '\ud68a', 
    '\ud68b', '\ud68d', '\ud68e', '\ud68f', '\ud690', '\ud691', '\ud692', '\ud693', 
    '\ud694', '\ud695', '\ud696', '\ud697', '\ud698', '\ud699', '\ud69a', '\ud69b', 
    '\ud69c', '\ud69d', '\ud69e', '\ud69f', '\ud6a0', '\ud6a1', '\ud6a2', '\ud6a3', 
    '\ud6a4', '\ud6a5', '\ud6a6', '\ud6a7', '\ud6a9', '\ud6aa', '\ud6ab', '\ud6ac', 
    '\ud6ad', '\ud6ae', '\ud6af', '\ud6b0', '\ud6b1', '\ud6b2', '\ud6b3', '\ud6b4', 
    '\ud6b5', '\ud6b6', '\ud6b7', '\ud6b8', '\ud6b9', '\ud6ba', '\ud6bb', '\ud6bc', 
    '\ud6bd', '\ud6be', '\ud6bf', '\ud6c0', '\ud6c1', '\ud6c2', '\ud6c3', '\ud6c5', 
    '\ud6c6', '\ud6c7', '\ud6c8', '\ud6c9', '\ud6ca', '\ud6cb', '\ud6cc', '\ud6cd', 
    '\ud6ce', '\ud6cf', '\ud6d0', '\ud6d1', '\ud6d2', '\ud6d3', '\ud6d4', '\ud6d5', 
    '\ud6d6', '\ud6d7', '\ud6d8', '\ud6d9', '\ud6da', '\ud6db', '\ud6dc', '\ud6dd', 
    '\ud6de', '\ud6df', '\ud6e1', '\ud6e2', '\ud6e3', '\ud6e4', '\ud6e5', '\ud6e6', 
    '\ud6e7', '\ud6e8', '\ud6e9', '\ud6ea', '\ud6eb', '\ud6ec', '\ud6ed', '\ud6ee', 
    '\ud6ef', '\ud6f0', '\ud6f1', '\ud6f2', '\ud6f3', '\ud6f4', '\ud6f5', '\ud6f6', 
    '\ud6f7', '\ud6f8', '\ud6f9', '\ud6fa', '\ud6fb', '\ud6fd', '\ud6fe', '\ud6ff', 
    '\ud700', '\ud701', '\ud702', '\ud703', '\ud704', '\ud705', '\ud706', '\ud707', 
    '\ud708', '\ud709', '\ud70a', '\ud70b', '\ud70c', '\ud70d', '\ud70e', '\ud70f', 
    '\ud710', '\ud711', '\ud712', '\ud713', '\ud714', '\ud715', '\ud716', '\ud717', 
    '\ud719', '\ud71a', '\ud71b', '\ud71c', '\ud71d', '\ud71e', '\ud71f', '\ud720', 
    '\ud721', '\ud722', '\ud723', '\ud724', '\ud725', '\ud726', '\ud727', '\ud728', 
    '\ud729', '\ud72a', '\ud72b', '\ud72c', '\ud72d', '\ud72e', '\ud72f', '\ud730', 
    '\ud731', '\ud732', '\ud733', '\ud735', '\ud736', '\ud737', '\ud738', '\ud739', 
    '\ud73a', '\ud73b', '\ud73c', '\ud73d', '\ud73e', '\ud73f', '\ud740', '\ud741', 
    '\ud742', '\ud743', '\ud744', '\ud745', '\ud746', '\ud747', '\ud748', '\ud749', 
    '\ud74a', '\ud74b', '\ud74c', '\ud74d', '\ud74e', '\ud74f', '\ud751', '\ud752', 
    '\ud753', '\ud754', '\ud755', '\ud756', '\ud757', '\ud758', '\ud759', '\ud75a', 
    '\ud75b', '\ud75c', '\ud75d', '\ud75e', '\ud75f', '\ud760', '\ud761', '\ud762', 
    '\ud763', '\ud764', '\ud765', '\ud766', '\ud767', '\ud768', '\ud769', '\ud76a', 
    '\ud76b', '\ud76d', '\ud76e', '\ud76f', '\ud770', '\ud771', '\ud772', '\ud773', 
    '\ud774', '\ud775', '\ud776', '\ud777', '\ud778', '\ud779', '\ud77a', '\ud77b', 
    '\ud77c', '\ud77d', '\ud77e', '\ud77f', '\ud780', '\ud781', '\ud782', '\ud783', 
    '\ud784', '\ud785', '\ud786', '\ud787', '\ud789', '\ud78a', '\ud78b', '\ud78c', 
    '\ud78d', '\ud78e', '\ud78f', '\ud790', '\ud791', '\ud792', '\ud793', '\ud794', 
    '\ud795', '\ud796', '\ud797', '\ud798', '\ud799', '\ud79a', '\ud79b', '\ud79c', 
    '\ud79d', '\ud79e', '\ud79f', '\ud7a0', '\ud7a1', '\ud7a2', '\ud7a3')
    rangeFromGraphemeClass[int(LVTClass)] = LVT
}
