package emoji

// This file has been generated -- you probably should NOT EDIT IT !
// 
// BSD License, Copyright (c) 2018, Norbert Pillmayer (norbert@pillmayer.com)

import (
    "strconv"
    "unicode"

    "golang.org/x/text/unicode/rangetable"
)

// Type for UTS#51 emoji code-point classes.
// Must be convertable to int.
type EmojisClass int

// Will be initialized in SetupEmojisClasses()
var rangeFromEmojisClass []*unicode.RangeTable

// These are all the emoji breaking classes.
const ( 
    EmojiClass EmojisClass = 0
    Emoji_PresentationClass EmojisClass = 1
    Emoji_ModifierClass EmojisClass = 2
    Emoji_Modifier_BaseClass EmojisClass = 3
    Emoji_ComponentClass EmojisClass = 4
    Extended_PictographicClass EmojisClass = 5
)

// Range tables for emoji code-point classes.
// Will be initialized with SetupEmojisClasses().
// Clients can check with unicode.Is(..., rune)
var Emoji, Emoji_Presentation, Emoji_Modifier, Emoji_Modifier_Base, Emoji_Component, Extended_Pictographic, 
    unused *unicode.RangeTable

const _EmojisClass_name = "EmojiClassEmoji_PresentationClassEmoji_ModifierClassEmoji_Modifier_BaseClassEmoji_ComponentClassExtended_PictographicClass"

var _EmojisClass_index = [...]uint16{0, 10, 33, 52, 76, 96, 122 }

// Stringer for type EmojisClass
func (c EmojisClass) String() string {
    if c < 0 || c >= EmojisClass(len(_EmojisClass_index)-1) {
        return "EmojisClass(" + strconv.FormatInt(int64(c), 10) + ")"
    }
    return _EmojisClass_name[_EmojisClass_index[c]:_EmojisClass_index[c+1]]
}

func setupEmojisClasses() {
    rangeFromEmojisClass = make([]*unicode.RangeTable, int(Extended_PictographicClass)+1)

    // Range for Emoji class Emoji
    Emoji = rangetable.New('#', '*', '0', '1', '2', '3', 
    '4', '5', '6', '7', '8', '9', '\u00a9', '\u00ae', 
    '\u203c', '\u2049', '\u2122', '\u2139', '\u2194', '\u2195', '\u2196', '\u2197', 
    '\u2198', '\u2199', '\u21a9', '\u21aa', '\u231a', '\u231b', '\u2328', '\u23cf', 
    '\u23e9', '\u23ea', '\u23eb', '\u23ec', '\u23ed', '\u23ee', '\u23ef', '\u23f0', 
    '\u23f1', '\u23f2', '\u23f3', '\u23f8', '\u23f9', '\u23fa', '\u24c2', '\u25aa', 
    '\u25ab', '\u25b6', '\u25c0', '\u25fb', '\u25fc', '\u25fd', '\u25fe', '\u2600', 
    '\u2601', '\u2602', '\u2603', '\u2604', '\u260e', '\u2611', '\u2614', '\u2615', 
    '\u2618', '\u261d', '\u2620', '\u2622', '\u2623', '\u2626', '\u262a', '\u262e', 
    '\u262f', '\u2638', '\u2639', '\u263a', '\u2640', '\u2642', '\u2648', '\u2649', 
    '\u264a', '\u264b', '\u264c', '\u264d', '\u264e', '\u264f', '\u2650', '\u2651', 
    '\u2652', '\u2653', '\u265f', '\u2660', '\u2663', '\u2665', '\u2666', '\u2668', 
    '\u267b', '\u267e', '\u267f', '\u2692', '\u2693', '\u2694', '\u2695', '\u2696', 
    '\u2697', '\u2699', '\u269b', '\u269c', '\u26a0', '\u26a1', '\u26aa', '\u26ab', 
    '\u26b0', '\u26b1', '\u26bd', '\u26be', '\u26c4', '\u26c5', '\u26c8', '\u26ce', 
    '\u26cf', '\u26d1', '\u26d3', '\u26d4', '\u26e9', '\u26ea', '\u26f0', '\u26f1', 
    '\u26f2', '\u26f3', '\u26f4', '\u26f5', '\u26f7', '\u26f8', '\u26f9', '\u26fa', 
    '\u26fd', '\u2702', '\u2705', '\u2708', '\u2709', '\u270a', '\u270b', '\u270c', 
    '\u270d', '\u270f', '\u2712', '\u2714', '\u2716', '\u271d', '\u2721', '\u2728', 
    '\u2733', '\u2734', '\u2744', '\u2747', '\u274c', '\u274e', '\u2753', '\u2754', 
    '\u2755', '\u2757', '\u2763', '\u2764', '\u2795', '\u2796', '\u2797', '\u27a1', 
    '\u27b0', '\u27bf', '\u2934', '\u2935', '\u2b05', '\u2b06', '\u2b07', '\u2b1b', 
    '\u2b1c', '\u2b50', '\u2b55', '\u3030', '\u303d', '\u3297', '\u3299', '\U0001f004', 
    '\U0001f0cf', '\U0001f170', '\U0001f171', '\U0001f17e', '\U0001f17f', '\U0001f18e', '\U0001f191', '\U0001f192', 
    '\U0001f193', '\U0001f194', '\U0001f195', '\U0001f196', '\U0001f197', '\U0001f198', '\U0001f199', '\U0001f19a', 
    '\U0001f1e6', '\U0001f1e7', '\U0001f1e8', '\U0001f1e9', '\U0001f1ea', '\U0001f1eb', '\U0001f1ec', '\U0001f1ed', 
    '\U0001f1ee', '\U0001f1ef', '\U0001f1f0', '\U0001f1f1', '\U0001f1f2', '\U0001f1f3', '\U0001f1f4', '\U0001f1f5', 
    '\U0001f1f6', '\U0001f1f7', '\U0001f1f8', '\U0001f1f9', '\U0001f1fa', '\U0001f1fb', '\U0001f1fc', '\U0001f1fd', 
    '\U0001f1fe', '\U0001f1ff', '\U0001f201', '\U0001f202', '\U0001f21a', '\U0001f22f', '\U0001f232', '\U0001f233', 
    '\U0001f234', '\U0001f235', '\U0001f236', '\U0001f237', '\U0001f238', '\U0001f239', '\U0001f23a', '\U0001f250', 
    '\U0001f251', '\U0001f300', '\U0001f301', '\U0001f302', '\U0001f303', '\U0001f304', '\U0001f305', '\U0001f306', 
    '\U0001f307', '\U0001f308', '\U0001f309', '\U0001f30a', '\U0001f30b', '\U0001f30c', '\U0001f30d', '\U0001f30e', 
    '\U0001f30f', '\U0001f310', '\U0001f311', '\U0001f312', '\U0001f313', '\U0001f314', '\U0001f315', '\U0001f316', 
    '\U0001f317', '\U0001f318', '\U0001f319', '\U0001f31a', '\U0001f31b', '\U0001f31c', '\U0001f31d', '\U0001f31e', 
    '\U0001f31f', '\U0001f320', '\U0001f321', '\U0001f324', '\U0001f325', '\U0001f326', '\U0001f327', '\U0001f328', 
    '\U0001f329', '\U0001f32a', '\U0001f32b', '\U0001f32c', '\U0001f32d', '\U0001f32e', '\U0001f32f', '\U0001f330', 
    '\U0001f331', '\U0001f332', '\U0001f333', '\U0001f334', '\U0001f335', '\U0001f336', '\U0001f337', '\U0001f338', 
    '\U0001f339', '\U0001f33a', '\U0001f33b', '\U0001f33c', '\U0001f33d', '\U0001f33e', '\U0001f33f', '\U0001f340', 
    '\U0001f341', '\U0001f342', '\U0001f343', '\U0001f344', '\U0001f345', '\U0001f346', '\U0001f347', '\U0001f348', 
    '\U0001f349', '\U0001f34a', '\U0001f34b', '\U0001f34c', '\U0001f34d', '\U0001f34e', '\U0001f34f', '\U0001f350', 
    '\U0001f351', '\U0001f352', '\U0001f353', '\U0001f354', '\U0001f355', '\U0001f356', '\U0001f357', '\U0001f358', 
    '\U0001f359', '\U0001f35a', '\U0001f35b', '\U0001f35c', '\U0001f35d', '\U0001f35e', '\U0001f35f', '\U0001f360', 
    '\U0001f361', '\U0001f362', '\U0001f363', '\U0001f364', '\U0001f365', '\U0001f366', '\U0001f367', '\U0001f368', 
    '\U0001f369', '\U0001f36a', '\U0001f36b', '\U0001f36c', '\U0001f36d', '\U0001f36e', '\U0001f36f', '\U0001f370', 
    '\U0001f371', '\U0001f372', '\U0001f373', '\U0001f374', '\U0001f375', '\U0001f376', '\U0001f377', '\U0001f378', 
    '\U0001f379', '\U0001f37a', '\U0001f37b', '\U0001f37c', '\U0001f37d', '\U0001f37e', '\U0001f37f', '\U0001f380', 
    '\U0001f381', '\U0001f382', '\U0001f383', '\U0001f384', '\U0001f385', '\U0001f386', '\U0001f387', '\U0001f388', 
    '\U0001f389', '\U0001f38a', '\U0001f38b', '\U0001f38c', '\U0001f38d', '\U0001f38e', '\U0001f38f', '\U0001f390', 
    '\U0001f391', '\U0001f392', '\U0001f393', '\U0001f396', '\U0001f397', '\U0001f399', '\U0001f39a', '\U0001f39b', 
    '\U0001f39e', '\U0001f39f', '\U0001f3a0', '\U0001f3a1', '\U0001f3a2', '\U0001f3a3', '\U0001f3a4', '\U0001f3a5', 
    '\U0001f3a6', '\U0001f3a7', '\U0001f3a8', '\U0001f3a9', '\U0001f3aa', '\U0001f3ab', '\U0001f3ac', '\U0001f3ad', 
    '\U0001f3ae', '\U0001f3af', '\U0001f3b0', '\U0001f3b1', '\U0001f3b2', '\U0001f3b3', '\U0001f3b4', '\U0001f3b5', 
    '\U0001f3b6', '\U0001f3b7', '\U0001f3b8', '\U0001f3b9', '\U0001f3ba', '\U0001f3bb', '\U0001f3bc', '\U0001f3bd', 
    '\U0001f3be', '\U0001f3bf', '\U0001f3c0', '\U0001f3c1', '\U0001f3c2', '\U0001f3c3', '\U0001f3c4', '\U0001f3c5', 
    '\U0001f3c6', '\U0001f3c7', '\U0001f3c8', '\U0001f3c9', '\U0001f3ca', '\U0001f3cb', '\U0001f3cc', '\U0001f3cd', 
    '\U0001f3ce', '\U0001f3cf', '\U0001f3d0', '\U0001f3d1', '\U0001f3d2', '\U0001f3d3', '\U0001f3d4', '\U0001f3d5', 
    '\U0001f3d6', '\U0001f3d7', '\U0001f3d8', '\U0001f3d9', '\U0001f3da', '\U0001f3db', '\U0001f3dc', '\U0001f3dd', 
    '\U0001f3de', '\U0001f3df', '\U0001f3e0', '\U0001f3e1', '\U0001f3e2', '\U0001f3e3', '\U0001f3e4', '\U0001f3e5', 
    '\U0001f3e6', '\U0001f3e7', '\U0001f3e8', '\U0001f3e9', '\U0001f3ea', '\U0001f3eb', '\U0001f3ec', '\U0001f3ed', 
    '\U0001f3ee', '\U0001f3ef', '\U0001f3f0', '\U0001f3f3', '\U0001f3f4', '\U0001f3f5', '\U0001f3f7', '\U0001f3f8', 
    '\U0001f3f9', '\U0001f3fa', '\U0001f3fb', '\U0001f3fc', '\U0001f3fd', '\U0001f3fe', '\U0001f3ff', '\U0001f400', 
    '\U0001f401', '\U0001f402', '\U0001f403', '\U0001f404', '\U0001f405', '\U0001f406', '\U0001f407', '\U0001f408', 
    '\U0001f409', '\U0001f40a', '\U0001f40b', '\U0001f40c', '\U0001f40d', '\U0001f40e', '\U0001f40f', '\U0001f410', 
    '\U0001f411', '\U0001f412', '\U0001f413', '\U0001f414', '\U0001f415', '\U0001f416', '\U0001f417', '\U0001f418', 
    '\U0001f419', '\U0001f41a', '\U0001f41b', '\U0001f41c', '\U0001f41d', '\U0001f41e', '\U0001f41f', '\U0001f420', 
    '\U0001f421', '\U0001f422', '\U0001f423', '\U0001f424', '\U0001f425', '\U0001f426', '\U0001f427', '\U0001f428', 
    '\U0001f429', '\U0001f42a', '\U0001f42b', '\U0001f42c', '\U0001f42d', '\U0001f42e', '\U0001f42f', '\U0001f430', 
    '\U0001f431', '\U0001f432', '\U0001f433', '\U0001f434', '\U0001f435', '\U0001f436', '\U0001f437', '\U0001f438', 
    '\U0001f439', '\U0001f43a', '\U0001f43b', '\U0001f43c', '\U0001f43d', '\U0001f43e', '\U0001f43f', '\U0001f440', 
    '\U0001f441', '\U0001f442', '\U0001f443', '\U0001f444', '\U0001f445', '\U0001f446', '\U0001f447', '\U0001f448', 
    '\U0001f449', '\U0001f44a', '\U0001f44b', '\U0001f44c', '\U0001f44d', '\U0001f44e', '\U0001f44f', '\U0001f450', 
    '\U0001f451', '\U0001f452', '\U0001f453', '\U0001f454', '\U0001f455', '\U0001f456', '\U0001f457', '\U0001f458', 
    '\U0001f459', '\U0001f45a', '\U0001f45b', '\U0001f45c', '\U0001f45d', '\U0001f45e', '\U0001f45f', '\U0001f460', 
    '\U0001f461', '\U0001f462', '\U0001f463', '\U0001f464', '\U0001f465', '\U0001f466', '\U0001f467', '\U0001f468', 
    '\U0001f469', '\U0001f46a', '\U0001f46b', '\U0001f46c', '\U0001f46d', '\U0001f46e', '\U0001f46f', '\U0001f470', 
    '\U0001f471', '\U0001f472', '\U0001f473', '\U0001f474', '\U0001f475', '\U0001f476', '\U0001f477', '\U0001f478', 
    '\U0001f479', '\U0001f47a', '\U0001f47b', '\U0001f47c', '\U0001f47d', '\U0001f47e', '\U0001f47f', '\U0001f480', 
    '\U0001f481', '\U0001f482', '\U0001f483', '\U0001f484', '\U0001f485', '\U0001f486', '\U0001f487', '\U0001f488', 
    '\U0001f489', '\U0001f48a', '\U0001f48b', '\U0001f48c', '\U0001f48d', '\U0001f48e', '\U0001f48f', '\U0001f490', 
    '\U0001f491', '\U0001f492', '\U0001f493', '\U0001f494', '\U0001f495', '\U0001f496', '\U0001f497', '\U0001f498', 
    '\U0001f499', '\U0001f49a', '\U0001f49b', '\U0001f49c', '\U0001f49d', '\U0001f49e', '\U0001f49f', '\U0001f4a0', 
    '\U0001f4a1', '\U0001f4a2', '\U0001f4a3', '\U0001f4a4', '\U0001f4a5', '\U0001f4a6', '\U0001f4a7', '\U0001f4a8', 
    '\U0001f4a9', '\U0001f4aa', '\U0001f4ab', '\U0001f4ac', '\U0001f4ad', '\U0001f4ae', '\U0001f4af', '\U0001f4b0', 
    '\U0001f4b1', '\U0001f4b2', '\U0001f4b3', '\U0001f4b4', '\U0001f4b5', '\U0001f4b6', '\U0001f4b7', '\U0001f4b8', 
    '\U0001f4b9', '\U0001f4ba', '\U0001f4bb', '\U0001f4bc', '\U0001f4bd', '\U0001f4be', '\U0001f4bf', '\U0001f4c0', 
    '\U0001f4c1', '\U0001f4c2', '\U0001f4c3', '\U0001f4c4', '\U0001f4c5', '\U0001f4c6', '\U0001f4c7', '\U0001f4c8', 
    '\U0001f4c9', '\U0001f4ca', '\U0001f4cb', '\U0001f4cc', '\U0001f4cd', '\U0001f4ce', '\U0001f4cf', '\U0001f4d0', 
    '\U0001f4d1', '\U0001f4d2', '\U0001f4d3', '\U0001f4d4', '\U0001f4d5', '\U0001f4d6', '\U0001f4d7', '\U0001f4d8', 
    '\U0001f4d9', '\U0001f4da', '\U0001f4db', '\U0001f4dc', '\U0001f4dd', '\U0001f4de', '\U0001f4df', '\U0001f4e0', 
    '\U0001f4e1', '\U0001f4e2', '\U0001f4e3', '\U0001f4e4', '\U0001f4e5', '\U0001f4e6', '\U0001f4e7', '\U0001f4e8', 
    '\U0001f4e9', '\U0001f4ea', '\U0001f4eb', '\U0001f4ec', '\U0001f4ed', '\U0001f4ee', '\U0001f4ef', '\U0001f4f0', 
    '\U0001f4f1', '\U0001f4f2', '\U0001f4f3', '\U0001f4f4', '\U0001f4f5', '\U0001f4f6', '\U0001f4f7', '\U0001f4f8', 
    '\U0001f4f9', '\U0001f4fa', '\U0001f4fb', '\U0001f4fc', '\U0001f4fd', '\U0001f4ff', '\U0001f500', '\U0001f501', 
    '\U0001f502', '\U0001f503', '\U0001f504', '\U0001f505', '\U0001f506', '\U0001f507', '\U0001f508', '\U0001f509', 
    '\U0001f50a', '\U0001f50b', '\U0001f50c', '\U0001f50d', '\U0001f50e', '\U0001f50f', '\U0001f510', '\U0001f511', 
    '\U0001f512', '\U0001f513', '\U0001f514', '\U0001f515', '\U0001f516', '\U0001f517', '\U0001f518', '\U0001f519', 
    '\U0001f51a', '\U0001f51b', '\U0001f51c', '\U0001f51d', '\U0001f51e', '\U0001f51f', '\U0001f520', '\U0001f521', 
    '\U0001f522', '\U0001f523', '\U0001f524', '\U0001f525', '\U0001f526', '\U0001f527', '\U0001f528', '\U0001f529', 
    '\U0001f52a', '\U0001f52b', '\U0001f52c', '\U0001f52d', '\U0001f52e', '\U0001f52f', '\U0001f530', '\U0001f531', 
    '\U0001f532', '\U0001f533', '\U0001f534', '\U0001f535', '\U0001f536', '\U0001f537', '\U0001f538', '\U0001f539', 
    '\U0001f53a', '\U0001f53b', '\U0001f53c', '\U0001f53d', '\U0001f549', '\U0001f54a', '\U0001f54b', '\U0001f54c', 
    '\U0001f54d', '\U0001f54e', '\U0001f550', '\U0001f551', '\U0001f552', '\U0001f553', '\U0001f554', '\U0001f555', 
    '\U0001f556', '\U0001f557', '\U0001f558', '\U0001f559', '\U0001f55a', '\U0001f55b', '\U0001f55c', '\U0001f55d', 
    '\U0001f55e', '\U0001f55f', '\U0001f560', '\U0001f561', '\U0001f562', '\U0001f563', '\U0001f564', '\U0001f565', 
    '\U0001f566', '\U0001f567', '\U0001f56f', '\U0001f570', '\U0001f573', '\U0001f574', '\U0001f575', '\U0001f576', 
    '\U0001f577', '\U0001f578', '\U0001f579', '\U0001f57a', '\U0001f587', '\U0001f58a', '\U0001f58b', '\U0001f58c', 
    '\U0001f58d', '\U0001f590', '\U0001f595', '\U0001f596', '\U0001f5a4', '\U0001f5a5', '\U0001f5a8', '\U0001f5b1', 
    '\U0001f5b2', '\U0001f5bc', '\U0001f5c2', '\U0001f5c3', '\U0001f5c4', '\U0001f5d1', '\U0001f5d2', '\U0001f5d3', 
    '\U0001f5dc', '\U0001f5dd', '\U0001f5de', '\U0001f5e1', '\U0001f5e3', '\U0001f5e8', '\U0001f5ef', '\U0001f5f3', 
    '\U0001f5fa', '\U0001f5fb', '\U0001f5fc', '\U0001f5fd', '\U0001f5fe', '\U0001f5ff', '\U0001f600', '\U0001f601', 
    '\U0001f602', '\U0001f603', '\U0001f604', '\U0001f605', '\U0001f606', '\U0001f607', '\U0001f608', '\U0001f609', 
    '\U0001f60a', '\U0001f60b', '\U0001f60c', '\U0001f60d', '\U0001f60e', '\U0001f60f', '\U0001f610', '\U0001f611', 
    '\U0001f612', '\U0001f613', '\U0001f614', '\U0001f615', '\U0001f616', '\U0001f617', '\U0001f618', '\U0001f619', 
    '\U0001f61a', '\U0001f61b', '\U0001f61c', '\U0001f61d', '\U0001f61e', '\U0001f61f', '\U0001f620', '\U0001f621', 
    '\U0001f622', '\U0001f623', '\U0001f624', '\U0001f625', '\U0001f626', '\U0001f627', '\U0001f628', '\U0001f629', 
    '\U0001f62a', '\U0001f62b', '\U0001f62c', '\U0001f62d', '\U0001f62e', '\U0001f62f', '\U0001f630', '\U0001f631', 
    '\U0001f632', '\U0001f633', '\U0001f634', '\U0001f635', '\U0001f636', '\U0001f637', '\U0001f638', '\U0001f639', 
    '\U0001f63a', '\U0001f63b', '\U0001f63c', '\U0001f63d', '\U0001f63e', '\U0001f63f', '\U0001f640', '\U0001f641', 
    '\U0001f642', '\U0001f643', '\U0001f644', '\U0001f645', '\U0001f646', '\U0001f647', '\U0001f648', '\U0001f649', 
    '\U0001f64a', '\U0001f64b', '\U0001f64c', '\U0001f64d', '\U0001f64e', '\U0001f64f', '\U0001f680', '\U0001f681', 
    '\U0001f682', '\U0001f683', '\U0001f684', '\U0001f685', '\U0001f686', '\U0001f687', '\U0001f688', '\U0001f689', 
    '\U0001f68a', '\U0001f68b', '\U0001f68c', '\U0001f68d', '\U0001f68e', '\U0001f68f', '\U0001f690', '\U0001f691', 
    '\U0001f692', '\U0001f693', '\U0001f694', '\U0001f695', '\U0001f696', '\U0001f697', '\U0001f698', '\U0001f699', 
    '\U0001f69a', '\U0001f69b', '\U0001f69c', '\U0001f69d', '\U0001f69e', '\U0001f69f', '\U0001f6a0', '\U0001f6a1', 
    '\U0001f6a2', '\U0001f6a3', '\U0001f6a4', '\U0001f6a5', '\U0001f6a6', '\U0001f6a7', '\U0001f6a8', '\U0001f6a9', 
    '\U0001f6aa', '\U0001f6ab', '\U0001f6ac', '\U0001f6ad', '\U0001f6ae', '\U0001f6af', '\U0001f6b0', '\U0001f6b1', 
    '\U0001f6b2', '\U0001f6b3', '\U0001f6b4', '\U0001f6b5', '\U0001f6b6', '\U0001f6b7', '\U0001f6b8', '\U0001f6b9', 
    '\U0001f6ba', '\U0001f6bb', '\U0001f6bc', '\U0001f6bd', '\U0001f6be', '\U0001f6bf', '\U0001f6c0', '\U0001f6c1', 
    '\U0001f6c2', '\U0001f6c3', '\U0001f6c4', '\U0001f6c5', '\U0001f6cb', '\U0001f6cc', '\U0001f6cd', '\U0001f6ce', 
    '\U0001f6cf', '\U0001f6d0', '\U0001f6d1', '\U0001f6d2', '\U0001f6e0', '\U0001f6e1', '\U0001f6e2', '\U0001f6e3', 
    '\U0001f6e4', '\U0001f6e5', '\U0001f6e9', '\U0001f6eb', '\U0001f6ec', '\U0001f6f0', '\U0001f6f3', '\U0001f6f4', 
    '\U0001f6f5', '\U0001f6f6', '\U0001f6f7', '\U0001f6f8', '\U0001f6f9', '\U0001f910', '\U0001f911', '\U0001f912', 
    '\U0001f913', '\U0001f914', '\U0001f915', '\U0001f916', '\U0001f917', '\U0001f918', '\U0001f919', '\U0001f91a', 
    '\U0001f91b', '\U0001f91c', '\U0001f91d', '\U0001f91e', '\U0001f91f', '\U0001f920', '\U0001f921', '\U0001f922', 
    '\U0001f923', '\U0001f924', '\U0001f925', '\U0001f926', '\U0001f927', '\U0001f928', '\U0001f929', '\U0001f92a', 
    '\U0001f92b', '\U0001f92c', '\U0001f92d', '\U0001f92e', '\U0001f92f', '\U0001f930', '\U0001f931', '\U0001f932', 
    '\U0001f933', '\U0001f934', '\U0001f935', '\U0001f936', '\U0001f937', '\U0001f938', '\U0001f939', '\U0001f93a', 
    '\U0001f93c', '\U0001f93d', '\U0001f93e', '\U0001f940', '\U0001f941', '\U0001f942', '\U0001f943', '\U0001f944', 
    '\U0001f945', '\U0001f947', '\U0001f948', '\U0001f949', '\U0001f94a', '\U0001f94b', '\U0001f94c', '\U0001f94d', 
    '\U0001f94e', '\U0001f94f', '\U0001f950', '\U0001f951', '\U0001f952', '\U0001f953', '\U0001f954', '\U0001f955', 
    '\U0001f956', '\U0001f957', '\U0001f958', '\U0001f959', '\U0001f95a', '\U0001f95b', '\U0001f95c', '\U0001f95d', 
    '\U0001f95e', '\U0001f95f', '\U0001f960', '\U0001f961', '\U0001f962', '\U0001f963', '\U0001f964', '\U0001f965', 
    '\U0001f966', '\U0001f967', '\U0001f968', '\U0001f969', '\U0001f96a', '\U0001f96b', '\U0001f96c', '\U0001f96d', 
    '\U0001f96e', '\U0001f96f', '\U0001f970', '\U0001f973', '\U0001f974', '\U0001f975', '\U0001f976', '\U0001f97a', 
    '\U0001f97c', '\U0001f97d', '\U0001f97e', '\U0001f97f', '\U0001f980', '\U0001f981', '\U0001f982', '\U0001f983', 
    '\U0001f984', '\U0001f985', '\U0001f986', '\U0001f987', '\U0001f988', '\U0001f989', '\U0001f98a', '\U0001f98b', 
    '\U0001f98c', '\U0001f98d', '\U0001f98e', '\U0001f98f', '\U0001f990', '\U0001f991', '\U0001f992', '\U0001f993', 
    '\U0001f994', '\U0001f995', '\U0001f996', '\U0001f997', '\U0001f998', '\U0001f999', '\U0001f99a', '\U0001f99b', 
    '\U0001f99c', '\U0001f99d', '\U0001f99e', '\U0001f99f', '\U0001f9a0', '\U0001f9a1', '\U0001f9a2', '\U0001f9b0', 
    '\U0001f9b1', '\U0001f9b2', '\U0001f9b3', '\U0001f9b4', '\U0001f9b5', '\U0001f9b6', '\U0001f9b7', '\U0001f9b8', 
    '\U0001f9b9', '\U0001f9c0', '\U0001f9c1', '\U0001f9c2', '\U0001f9d0', '\U0001f9d1', '\U0001f9d2', '\U0001f9d3', 
    '\U0001f9d4', '\U0001f9d5', '\U0001f9d6', '\U0001f9d7', '\U0001f9d8', '\U0001f9d9', '\U0001f9da', '\U0001f9db', 
    '\U0001f9dc', '\U0001f9dd', '\U0001f9de', '\U0001f9df', '\U0001f9e0', '\U0001f9e1', '\U0001f9e2', '\U0001f9e3', 
    '\U0001f9e4', '\U0001f9e5', '\U0001f9e6', '\U0001f9e7', '\U0001f9e8', '\U0001f9e9', '\U0001f9ea', '\U0001f9eb', 
    '\U0001f9ec', '\U0001f9ed', '\U0001f9ee', '\U0001f9ef', '\U0001f9f0', '\U0001f9f1', '\U0001f9f2', '\U0001f9f3', 
    '\U0001f9f4', '\U0001f9f5', '\U0001f9f6', '\U0001f9f7', '\U0001f9f8', '\U0001f9f9', '\U0001f9fa', '\U0001f9fb', 
    '\U0001f9fc', '\U0001f9fd', '\U0001f9fe', '\U0001f9ff')
    rangeFromEmojisClass[int(EmojiClass)] = Emoji

    // Range for Emoji class Emoji_Presentation
    Emoji_Presentation = rangetable.New('\u231a', '\u231b', '\u23e9', '\u23ea', '\u23eb', '\u23ec', 
    '\u23f0', '\u23f3', '\u25fd', '\u25fe', '\u2614', '\u2615', '\u2648', '\u2649', 
    '\u264a', '\u264b', '\u264c', '\u264d', '\u264e', '\u264f', '\u2650', '\u2651', 
    '\u2652', '\u2653', '\u267f', '\u2693', '\u26a1', '\u26aa', '\u26ab', '\u26bd', 
    '\u26be', '\u26c4', '\u26c5', '\u26ce', '\u26d4', '\u26ea', '\u26f2', '\u26f3', 
    '\u26f5', '\u26fa', '\u26fd', '\u2705', '\u270a', '\u270b', '\u2728', '\u274c', 
    '\u274e', '\u2753', '\u2754', '\u2755', '\u2757', '\u2795', '\u2796', '\u2797', 
    '\u27b0', '\u27bf', '\u2b1b', '\u2b1c', '\u2b50', '\u2b55', '\U0001f004', '\U0001f0cf', 
    '\U0001f18e', '\U0001f191', '\U0001f192', '\U0001f193', '\U0001f194', '\U0001f195', '\U0001f196', '\U0001f197', 
    '\U0001f198', '\U0001f199', '\U0001f19a', '\U0001f1e6', '\U0001f1e7', '\U0001f1e8', '\U0001f1e9', '\U0001f1ea', 
    '\U0001f1eb', '\U0001f1ec', '\U0001f1ed', '\U0001f1ee', '\U0001f1ef', '\U0001f1f0', '\U0001f1f1', '\U0001f1f2', 
    '\U0001f1f3', '\U0001f1f4', '\U0001f1f5', '\U0001f1f6', '\U0001f1f7', '\U0001f1f8', '\U0001f1f9', '\U0001f1fa', 
    '\U0001f1fb', '\U0001f1fc', '\U0001f1fd', '\U0001f1fe', '\U0001f1ff', '\U0001f201', '\U0001f21a', '\U0001f22f', 
    '\U0001f232', '\U0001f233', '\U0001f234', '\U0001f235', '\U0001f236', '\U0001f238', '\U0001f239', '\U0001f23a', 
    '\U0001f250', '\U0001f251', '\U0001f300', '\U0001f301', '\U0001f302', '\U0001f303', '\U0001f304', '\U0001f305', 
    '\U0001f306', '\U0001f307', '\U0001f308', '\U0001f309', '\U0001f30a', '\U0001f30b', '\U0001f30c', '\U0001f30d', 
    '\U0001f30e', '\U0001f30f', '\U0001f310', '\U0001f311', '\U0001f312', '\U0001f313', '\U0001f314', '\U0001f315', 
    '\U0001f316', '\U0001f317', '\U0001f318', '\U0001f319', '\U0001f31a', '\U0001f31b', '\U0001f31c', '\U0001f31d', 
    '\U0001f31e', '\U0001f31f', '\U0001f320', '\U0001f32d', '\U0001f32e', '\U0001f32f', '\U0001f330', '\U0001f331', 
    '\U0001f332', '\U0001f333', '\U0001f334', '\U0001f335', '\U0001f337', '\U0001f338', '\U0001f339', '\U0001f33a', 
    '\U0001f33b', '\U0001f33c', '\U0001f33d', '\U0001f33e', '\U0001f33f', '\U0001f340', '\U0001f341', '\U0001f342', 
    '\U0001f343', '\U0001f344', '\U0001f345', '\U0001f346', '\U0001f347', '\U0001f348', '\U0001f349', '\U0001f34a', 
    '\U0001f34b', '\U0001f34c', '\U0001f34d', '\U0001f34e', '\U0001f34f', '\U0001f350', '\U0001f351', '\U0001f352', 
    '\U0001f353', '\U0001f354', '\U0001f355', '\U0001f356', '\U0001f357', '\U0001f358', '\U0001f359', '\U0001f35a', 
    '\U0001f35b', '\U0001f35c', '\U0001f35d', '\U0001f35e', '\U0001f35f', '\U0001f360', '\U0001f361', '\U0001f362', 
    '\U0001f363', '\U0001f364', '\U0001f365', '\U0001f366', '\U0001f367', '\U0001f368', '\U0001f369', '\U0001f36a', 
    '\U0001f36b', '\U0001f36c', '\U0001f36d', '\U0001f36e', '\U0001f36f', '\U0001f370', '\U0001f371', '\U0001f372', 
    '\U0001f373', '\U0001f374', '\U0001f375', '\U0001f376', '\U0001f377', '\U0001f378', '\U0001f379', '\U0001f37a', 
    '\U0001f37b', '\U0001f37c', '\U0001f37e', '\U0001f37f', '\U0001f380', '\U0001f381', '\U0001f382', '\U0001f383', 
    '\U0001f384', '\U0001f385', '\U0001f386', '\U0001f387', '\U0001f388', '\U0001f389', '\U0001f38a', '\U0001f38b', 
    '\U0001f38c', '\U0001f38d', '\U0001f38e', '\U0001f38f', '\U0001f390', '\U0001f391', '\U0001f392', '\U0001f393', 
    '\U0001f3a0', '\U0001f3a1', '\U0001f3a2', '\U0001f3a3', '\U0001f3a4', '\U0001f3a5', '\U0001f3a6', '\U0001f3a7', 
    '\U0001f3a8', '\U0001f3a9', '\U0001f3aa', '\U0001f3ab', '\U0001f3ac', '\U0001f3ad', '\U0001f3ae', '\U0001f3af', 
    '\U0001f3b0', '\U0001f3b1', '\U0001f3b2', '\U0001f3b3', '\U0001f3b4', '\U0001f3b5', '\U0001f3b6', '\U0001f3b7', 
    '\U0001f3b8', '\U0001f3b9', '\U0001f3ba', '\U0001f3bb', '\U0001f3bc', '\U0001f3bd', '\U0001f3be', '\U0001f3bf', 
    '\U0001f3c0', '\U0001f3c1', '\U0001f3c2', '\U0001f3c3', '\U0001f3c4', '\U0001f3c5', '\U0001f3c6', '\U0001f3c7', 
    '\U0001f3c8', '\U0001f3c9', '\U0001f3ca', '\U0001f3cf', '\U0001f3d0', '\U0001f3d1', '\U0001f3d2', '\U0001f3d3', 
    '\U0001f3e0', '\U0001f3e1', '\U0001f3e2', '\U0001f3e3', '\U0001f3e4', '\U0001f3e5', '\U0001f3e6', '\U0001f3e7', 
    '\U0001f3e8', '\U0001f3e9', '\U0001f3ea', '\U0001f3eb', '\U0001f3ec', '\U0001f3ed', '\U0001f3ee', '\U0001f3ef', 
    '\U0001f3f0', '\U0001f3f4', '\U0001f3f8', '\U0001f3f9', '\U0001f3fa', '\U0001f3fb', '\U0001f3fc', '\U0001f3fd', 
    '\U0001f3fe', '\U0001f3ff', '\U0001f400', '\U0001f401', '\U0001f402', '\U0001f403', '\U0001f404', '\U0001f405', 
    '\U0001f406', '\U0001f407', '\U0001f408', '\U0001f409', '\U0001f40a', '\U0001f40b', '\U0001f40c', '\U0001f40d', 
    '\U0001f40e', '\U0001f40f', '\U0001f410', '\U0001f411', '\U0001f412', '\U0001f413', '\U0001f414', '\U0001f415', 
    '\U0001f416', '\U0001f417', '\U0001f418', '\U0001f419', '\U0001f41a', '\U0001f41b', '\U0001f41c', '\U0001f41d', 
    '\U0001f41e', '\U0001f41f', '\U0001f420', '\U0001f421', '\U0001f422', '\U0001f423', '\U0001f424', '\U0001f425', 
    '\U0001f426', '\U0001f427', '\U0001f428', '\U0001f429', '\U0001f42a', '\U0001f42b', '\U0001f42c', '\U0001f42d', 
    '\U0001f42e', '\U0001f42f', '\U0001f430', '\U0001f431', '\U0001f432', '\U0001f433', '\U0001f434', '\U0001f435', 
    '\U0001f436', '\U0001f437', '\U0001f438', '\U0001f439', '\U0001f43a', '\U0001f43b', '\U0001f43c', '\U0001f43d', 
    '\U0001f43e', '\U0001f440', '\U0001f442', '\U0001f443', '\U0001f444', '\U0001f445', '\U0001f446', '\U0001f447', 
    '\U0001f448', '\U0001f449', '\U0001f44a', '\U0001f44b', '\U0001f44c', '\U0001f44d', '\U0001f44e', '\U0001f44f', 
    '\U0001f450', '\U0001f451', '\U0001f452', '\U0001f453', '\U0001f454', '\U0001f455', '\U0001f456', '\U0001f457', 
    '\U0001f458', '\U0001f459', '\U0001f45a', '\U0001f45b', '\U0001f45c', '\U0001f45d', '\U0001f45e', '\U0001f45f', 
    '\U0001f460', '\U0001f461', '\U0001f462', '\U0001f463', '\U0001f464', '\U0001f465', '\U0001f466', '\U0001f467', 
    '\U0001f468', '\U0001f469', '\U0001f46a', '\U0001f46b', '\U0001f46c', '\U0001f46d', '\U0001f46e', '\U0001f46f', 
    '\U0001f470', '\U0001f471', '\U0001f472', '\U0001f473', '\U0001f474', '\U0001f475', '\U0001f476', '\U0001f477', 
    '\U0001f478', '\U0001f479', '\U0001f47a', '\U0001f47b', '\U0001f47c', '\U0001f47d', '\U0001f47e', '\U0001f47f', 
    '\U0001f480', '\U0001f481', '\U0001f482', '\U0001f483', '\U0001f484', '\U0001f485', '\U0001f486', '\U0001f487', 
    '\U0001f488', '\U0001f489', '\U0001f48a', '\U0001f48b', '\U0001f48c', '\U0001f48d', '\U0001f48e', '\U0001f48f', 
    '\U0001f490', '\U0001f491', '\U0001f492', '\U0001f493', '\U0001f494', '\U0001f495', '\U0001f496', '\U0001f497', 
    '\U0001f498', '\U0001f499', '\U0001f49a', '\U0001f49b', '\U0001f49c', '\U0001f49d', '\U0001f49e', '\U0001f49f', 
    '\U0001f4a0', '\U0001f4a1', '\U0001f4a2', '\U0001f4a3', '\U0001f4a4', '\U0001f4a5', '\U0001f4a6', '\U0001f4a7', 
    '\U0001f4a8', '\U0001f4a9', '\U0001f4aa', '\U0001f4ab', '\U0001f4ac', '\U0001f4ad', '\U0001f4ae', '\U0001f4af', 
    '\U0001f4b0', '\U0001f4b1', '\U0001f4b2', '\U0001f4b3', '\U0001f4b4', '\U0001f4b5', '\U0001f4b6', '\U0001f4b7', 
    '\U0001f4b8', '\U0001f4b9', '\U0001f4ba', '\U0001f4bb', '\U0001f4bc', '\U0001f4bd', '\U0001f4be', '\U0001f4bf', 
    '\U0001f4c0', '\U0001f4c1', '\U0001f4c2', '\U0001f4c3', '\U0001f4c4', '\U0001f4c5', '\U0001f4c6', '\U0001f4c7', 
    '\U0001f4c8', '\U0001f4c9', '\U0001f4ca', '\U0001f4cb', '\U0001f4cc', '\U0001f4cd', '\U0001f4ce', '\U0001f4cf', 
    '\U0001f4d0', '\U0001f4d1', '\U0001f4d2', '\U0001f4d3', '\U0001f4d4', '\U0001f4d5', '\U0001f4d6', '\U0001f4d7', 
    '\U0001f4d8', '\U0001f4d9', '\U0001f4da', '\U0001f4db', '\U0001f4dc', '\U0001f4dd', '\U0001f4de', '\U0001f4df', 
    '\U0001f4e0', '\U0001f4e1', '\U0001f4e2', '\U0001f4e3', '\U0001f4e4', '\U0001f4e5', '\U0001f4e6', '\U0001f4e7', 
    '\U0001f4e8', '\U0001f4e9', '\U0001f4ea', '\U0001f4eb', '\U0001f4ec', '\U0001f4ed', '\U0001f4ee', '\U0001f4ef', 
    '\U0001f4f0', '\U0001f4f1', '\U0001f4f2', '\U0001f4f3', '\U0001f4f4', '\U0001f4f5', '\U0001f4f6', '\U0001f4f7', 
    '\U0001f4f8', '\U0001f4f9', '\U0001f4fa', '\U0001f4fb', '\U0001f4fc', '\U0001f4ff', '\U0001f500', '\U0001f501', 
    '\U0001f502', '\U0001f503', '\U0001f504', '\U0001f505', '\U0001f506', '\U0001f507', '\U0001f508', '\U0001f509', 
    '\U0001f50a', '\U0001f50b', '\U0001f50c', '\U0001f50d', '\U0001f50e', '\U0001f50f', '\U0001f510', '\U0001f511', 
    '\U0001f512', '\U0001f513', '\U0001f514', '\U0001f515', '\U0001f516', '\U0001f517', '\U0001f518', '\U0001f519', 
    '\U0001f51a', '\U0001f51b', '\U0001f51c', '\U0001f51d', '\U0001f51e', '\U0001f51f', '\U0001f520', '\U0001f521', 
    '\U0001f522', '\U0001f523', '\U0001f524', '\U0001f525', '\U0001f526', '\U0001f527', '\U0001f528', '\U0001f529', 
    '\U0001f52a', '\U0001f52b', '\U0001f52c', '\U0001f52d', '\U0001f52e', '\U0001f52f', '\U0001f530', '\U0001f531', 
    '\U0001f532', '\U0001f533', '\U0001f534', '\U0001f535', '\U0001f536', '\U0001f537', '\U0001f538', '\U0001f539', 
    '\U0001f53a', '\U0001f53b', '\U0001f53c', '\U0001f53d', '\U0001f54b', '\U0001f54c', '\U0001f54d', '\U0001f54e', 
    '\U0001f550', '\U0001f551', '\U0001f552', '\U0001f553', '\U0001f554', '\U0001f555', '\U0001f556', '\U0001f557', 
    '\U0001f558', '\U0001f559', '\U0001f55a', '\U0001f55b', '\U0001f55c', '\U0001f55d', '\U0001f55e', '\U0001f55f', 
    '\U0001f560', '\U0001f561', '\U0001f562', '\U0001f563', '\U0001f564', '\U0001f565', '\U0001f566', '\U0001f567', 
    '\U0001f57a', '\U0001f595', '\U0001f596', '\U0001f5a4', '\U0001f5fb', '\U0001f5fc', '\U0001f5fd', '\U0001f5fe', 
    '\U0001f5ff', '\U0001f600', '\U0001f601', '\U0001f602', '\U0001f603', '\U0001f604', '\U0001f605', '\U0001f606', 
    '\U0001f607', '\U0001f608', '\U0001f609', '\U0001f60a', '\U0001f60b', '\U0001f60c', '\U0001f60d', '\U0001f60e', 
    '\U0001f60f', '\U0001f610', '\U0001f611', '\U0001f612', '\U0001f613', '\U0001f614', '\U0001f615', '\U0001f616', 
    '\U0001f617', '\U0001f618', '\U0001f619', '\U0001f61a', '\U0001f61b', '\U0001f61c', '\U0001f61d', '\U0001f61e', 
    '\U0001f61f', '\U0001f620', '\U0001f621', '\U0001f622', '\U0001f623', '\U0001f624', '\U0001f625', '\U0001f626', 
    '\U0001f627', '\U0001f628', '\U0001f629', '\U0001f62a', '\U0001f62b', '\U0001f62c', '\U0001f62d', '\U0001f62e', 
    '\U0001f62f', '\U0001f630', '\U0001f631', '\U0001f632', '\U0001f633', '\U0001f634', '\U0001f635', '\U0001f636', 
    '\U0001f637', '\U0001f638', '\U0001f639', '\U0001f63a', '\U0001f63b', '\U0001f63c', '\U0001f63d', '\U0001f63e', 
    '\U0001f63f', '\U0001f640', '\U0001f641', '\U0001f642', '\U0001f643', '\U0001f644', '\U0001f645', '\U0001f646', 
    '\U0001f647', '\U0001f648', '\U0001f649', '\U0001f64a', '\U0001f64b', '\U0001f64c', '\U0001f64d', '\U0001f64e', 
    '\U0001f64f', '\U0001f680', '\U0001f681', '\U0001f682', '\U0001f683', '\U0001f684', '\U0001f685', '\U0001f686', 
    '\U0001f687', '\U0001f688', '\U0001f689', '\U0001f68a', '\U0001f68b', '\U0001f68c', '\U0001f68d', '\U0001f68e', 
    '\U0001f68f', '\U0001f690', '\U0001f691', '\U0001f692', '\U0001f693', '\U0001f694', '\U0001f695', '\U0001f696', 
    '\U0001f697', '\U0001f698', '\U0001f699', '\U0001f69a', '\U0001f69b', '\U0001f69c', '\U0001f69d', '\U0001f69e', 
    '\U0001f69f', '\U0001f6a0', '\U0001f6a1', '\U0001f6a2', '\U0001f6a3', '\U0001f6a4', '\U0001f6a5', '\U0001f6a6', 
    '\U0001f6a7', '\U0001f6a8', '\U0001f6a9', '\U0001f6aa', '\U0001f6ab', '\U0001f6ac', '\U0001f6ad', '\U0001f6ae', 
    '\U0001f6af', '\U0001f6b0', '\U0001f6b1', '\U0001f6b2', '\U0001f6b3', '\U0001f6b4', '\U0001f6b5', '\U0001f6b6', 
    '\U0001f6b7', '\U0001f6b8', '\U0001f6b9', '\U0001f6ba', '\U0001f6bb', '\U0001f6bc', '\U0001f6bd', '\U0001f6be', 
    '\U0001f6bf', '\U0001f6c0', '\U0001f6c1', '\U0001f6c2', '\U0001f6c3', '\U0001f6c4', '\U0001f6c5', '\U0001f6cc', 
    '\U0001f6d0', '\U0001f6d1', '\U0001f6d2', '\U0001f6eb', '\U0001f6ec', '\U0001f6f4', '\U0001f6f5', '\U0001f6f6', 
    '\U0001f6f7', '\U0001f6f8', '\U0001f6f9', '\U0001f910', '\U0001f911', '\U0001f912', '\U0001f913', '\U0001f914', 
    '\U0001f915', '\U0001f916', '\U0001f917', '\U0001f918', '\U0001f919', '\U0001f91a', '\U0001f91b', '\U0001f91c', 
    '\U0001f91d', '\U0001f91e', '\U0001f91f', '\U0001f920', '\U0001f921', '\U0001f922', '\U0001f923', '\U0001f924', 
    '\U0001f925', '\U0001f926', '\U0001f927', '\U0001f928', '\U0001f929', '\U0001f92a', '\U0001f92b', '\U0001f92c', 
    '\U0001f92d', '\U0001f92e', '\U0001f92f', '\U0001f930', '\U0001f931', '\U0001f932', '\U0001f933', '\U0001f934', 
    '\U0001f935', '\U0001f936', '\U0001f937', '\U0001f938', '\U0001f939', '\U0001f93a', '\U0001f93c', '\U0001f93d', 
    '\U0001f93e', '\U0001f940', '\U0001f941', '\U0001f942', '\U0001f943', '\U0001f944', '\U0001f945', '\U0001f947', 
    '\U0001f948', '\U0001f949', '\U0001f94a', '\U0001f94b', '\U0001f94c', '\U0001f94d', '\U0001f94e', '\U0001f94f', 
    '\U0001f950', '\U0001f951', '\U0001f952', '\U0001f953', '\U0001f954', '\U0001f955', '\U0001f956', '\U0001f957', 
    '\U0001f958', '\U0001f959', '\U0001f95a', '\U0001f95b', '\U0001f95c', '\U0001f95d', '\U0001f95e', '\U0001f95f', 
    '\U0001f960', '\U0001f961', '\U0001f962', '\U0001f963', '\U0001f964', '\U0001f965', '\U0001f966', '\U0001f967', 
    '\U0001f968', '\U0001f969', '\U0001f96a', '\U0001f96b', '\U0001f96c', '\U0001f96d', '\U0001f96e', '\U0001f96f', 
    '\U0001f970', '\U0001f973', '\U0001f974', '\U0001f975', '\U0001f976', '\U0001f97a', '\U0001f97c', '\U0001f97d', 
    '\U0001f97e', '\U0001f97f', '\U0001f980', '\U0001f981', '\U0001f982', '\U0001f983', '\U0001f984', '\U0001f985', 
    '\U0001f986', '\U0001f987', '\U0001f988', '\U0001f989', '\U0001f98a', '\U0001f98b', '\U0001f98c', '\U0001f98d', 
    '\U0001f98e', '\U0001f98f', '\U0001f990', '\U0001f991', '\U0001f992', '\U0001f993', '\U0001f994', '\U0001f995', 
    '\U0001f996', '\U0001f997', '\U0001f998', '\U0001f999', '\U0001f99a', '\U0001f99b', '\U0001f99c', '\U0001f99d', 
    '\U0001f99e', '\U0001f99f', '\U0001f9a0', '\U0001f9a1', '\U0001f9a2', '\U0001f9b0', '\U0001f9b1', '\U0001f9b2', 
    '\U0001f9b3', '\U0001f9b4', '\U0001f9b5', '\U0001f9b6', '\U0001f9b7', '\U0001f9b8', '\U0001f9b9', '\U0001f9c0', 
    '\U0001f9c1', '\U0001f9c2', '\U0001f9d0', '\U0001f9d1', '\U0001f9d2', '\U0001f9d3', '\U0001f9d4', '\U0001f9d5', 
    '\U0001f9d6', '\U0001f9d7', '\U0001f9d8', '\U0001f9d9', '\U0001f9da', '\U0001f9db', '\U0001f9dc', '\U0001f9dd', 
    '\U0001f9de', '\U0001f9df', '\U0001f9e0', '\U0001f9e1', '\U0001f9e2', '\U0001f9e3', '\U0001f9e4', '\U0001f9e5', 
    '\U0001f9e6', '\U0001f9e7', '\U0001f9e8', '\U0001f9e9', '\U0001f9ea', '\U0001f9eb', '\U0001f9ec', '\U0001f9ed', 
    '\U0001f9ee', '\U0001f9ef', '\U0001f9f0', '\U0001f9f1', '\U0001f9f2', '\U0001f9f3', '\U0001f9f4', '\U0001f9f5', 
    '\U0001f9f6', '\U0001f9f7', '\U0001f9f8', '\U0001f9f9', '\U0001f9fa', '\U0001f9fb', '\U0001f9fc', '\U0001f9fd', 
    '\U0001f9fe', '\U0001f9ff')
    rangeFromEmojisClass[int(Emoji_PresentationClass)] = Emoji_Presentation

    // Range for Emoji class Emoji_Modifier
    Emoji_Modifier = rangetable.New('\U0001f3fb', '\U0001f3fc', '\U0001f3fd', '\U0001f3fe', '\U0001f3ff')
    rangeFromEmojisClass[int(Emoji_ModifierClass)] = Emoji_Modifier

    // Range for Emoji class Emoji_Modifier_Base
    Emoji_Modifier_Base = rangetable.New('\u261d', '\u26f9', '\u270a', '\u270b', '\u270c', '\u270d', 
    '\U0001f385', '\U0001f3c2', '\U0001f3c3', '\U0001f3c4', '\U0001f3c7', '\U0001f3ca', '\U0001f3cb', '\U0001f3cc', 
    '\U0001f442', '\U0001f443', '\U0001f446', '\U0001f447', '\U0001f448', '\U0001f449', '\U0001f44a', '\U0001f44b', 
    '\U0001f44c', '\U0001f44d', '\U0001f44e', '\U0001f44f', '\U0001f450', '\U0001f466', '\U0001f467', '\U0001f468', 
    '\U0001f469', '\U0001f46e', '\U0001f470', '\U0001f471', '\U0001f472', '\U0001f473', '\U0001f474', '\U0001f475', 
    '\U0001f476', '\U0001f477', '\U0001f478', '\U0001f47c', '\U0001f481', '\U0001f482', '\U0001f483', '\U0001f485', 
    '\U0001f486', '\U0001f487', '\U0001f4aa', '\U0001f574', '\U0001f575', '\U0001f57a', '\U0001f590', '\U0001f595', 
    '\U0001f596', '\U0001f645', '\U0001f646', '\U0001f647', '\U0001f64b', '\U0001f64c', '\U0001f64d', '\U0001f64e', 
    '\U0001f64f', '\U0001f6a3', '\U0001f6b4', '\U0001f6b5', '\U0001f6b6', '\U0001f6c0', '\U0001f6cc', '\U0001f918', 
    '\U0001f919', '\U0001f91a', '\U0001f91b', '\U0001f91c', '\U0001f91e', '\U0001f91f', '\U0001f926', '\U0001f930', 
    '\U0001f931', '\U0001f932', '\U0001f933', '\U0001f934', '\U0001f935', '\U0001f936', '\U0001f937', '\U0001f938', 
    '\U0001f939', '\U0001f93d', '\U0001f93e', '\U0001f9b5', '\U0001f9b6', '\U0001f9b8', '\U0001f9b9', '\U0001f9d1', 
    '\U0001f9d2', '\U0001f9d3', '\U0001f9d4', '\U0001f9d5', '\U0001f9d6', '\U0001f9d7', '\U0001f9d8', '\U0001f9d9', 
    '\U0001f9da', '\U0001f9db', '\U0001f9dc', '\U0001f9dd')
    rangeFromEmojisClass[int(Emoji_Modifier_BaseClass)] = Emoji_Modifier_Base

    // Range for Emoji class Emoji_Component
    Emoji_Component = rangetable.New('#', '*', '0', '1', '2', '3', 
    '4', '5', '6', '7', '8', '9', '\u200d', '\u20e3', 
    '\ufe0f', '\U0001f1e6', '\U0001f1e7', '\U0001f1e8', '\U0001f1e9', '\U0001f1ea', '\U0001f1eb', '\U0001f1ec', 
    '\U0001f1ed', '\U0001f1ee', '\U0001f1ef', '\U0001f1f0', '\U0001f1f1', '\U0001f1f2', '\U0001f1f3', '\U0001f1f4', 
    '\U0001f1f5', '\U0001f1f6', '\U0001f1f7', '\U0001f1f8', '\U0001f1f9', '\U0001f1fa', '\U0001f1fb', '\U0001f1fc', 
    '\U0001f1fd', '\U0001f1fe', '\U0001f1ff', '\U0001f3fb', '\U0001f3fc', '\U0001f3fd', '\U0001f3fe', '\U0001f3ff', 
    '\U0001f9b0', '\U0001f9b1', '\U0001f9b2', '\U0001f9b3', '\U000e0020', '\U000e0021', '\U000e0022', '\U000e0023', 
    '\U000e0024', '\U000e0025', '\U000e0026', '\U000e0027', '\U000e0028', '\U000e0029', '\U000e002a', '\U000e002b', 
    '\U000e002c', '\U000e002d', '\U000e002e', '\U000e002f', '\U000e0030', '\U000e0031', '\U000e0032', '\U000e0033', 
    '\U000e0034', '\U000e0035', '\U000e0036', '\U000e0037', '\U000e0038', '\U000e0039', '\U000e003a', '\U000e003b', 
    '\U000e003c', '\U000e003d', '\U000e003e', '\U000e003f', '\U000e0040', '\U000e0041', '\U000e0042', '\U000e0043', 
    '\U000e0044', '\U000e0045', '\U000e0046', '\U000e0047', '\U000e0048', '\U000e0049', '\U000e004a', '\U000e004b', 
    '\U000e004c', '\U000e004d', '\U000e004e', '\U000e004f', '\U000e0050', '\U000e0051', '\U000e0052', '\U000e0053', 
    '\U000e0054', '\U000e0055', '\U000e0056', '\U000e0057', '\U000e0058', '\U000e0059', '\U000e005a', '\U000e005b', 
    '\U000e005c', '\U000e005d', '\U000e005e', '\U000e005f', '\U000e0060', '\U000e0061', '\U000e0062', '\U000e0063', 
    '\U000e0064', '\U000e0065', '\U000e0066', '\U000e0067', '\U000e0068', '\U000e0069', '\U000e006a', '\U000e006b', 
    '\U000e006c', '\U000e006d', '\U000e006e', '\U000e006f', '\U000e0070', '\U000e0071', '\U000e0072', '\U000e0073', 
    '\U000e0074', '\U000e0075', '\U000e0076', '\U000e0077', '\U000e0078', '\U000e0079', '\U000e007a', '\U000e007b', 
    '\U000e007c', '\U000e007d', '\U000e007e', '\U000e007f')
    rangeFromEmojisClass[int(Emoji_ComponentClass)] = Emoji_Component

    // Range for Emoji class Extended_Pictographic
    Extended_Pictographic = rangetable.New('\u00a9', '\u00ae', '\u203c', '\u2049', '\u2122', '\u2139', 
    '\u2194', '\u2195', '\u2196', '\u2197', '\u2198', '\u2199', '\u21a9', '\u21aa', 
    '\u231a', '\u231b', '\u2328', '\u2388', '\u23cf', '\u23e9', '\u23ea', '\u23eb', 
    '\u23ec', '\u23ed', '\u23ee', '\u23ef', '\u23f0', '\u23f1', '\u23f2', '\u23f3', 
    '\u23f8', '\u23f9', '\u23fa', '\u24c2', '\u25aa', '\u25ab', '\u25b6', '\u25c0', 
    '\u25fb', '\u25fc', '\u25fd', '\u25fe', '\u2600', '\u2601', '\u2602', '\u2603', 
    '\u2604', '\u2605', '\u2607', '\u2608', '\u2609', '\u260a', '\u260b', '\u260c', 
    '\u260d', '\u260e', '\u260f', '\u2610', '\u2611', '\u2612', '\u2614', '\u2615', 
    '\u2616', '\u2617', '\u2618', '\u2619', '\u261a', '\u261b', '\u261c', '\u261d', 
    '\u261e', '\u261f', '\u2620', '\u2621', '\u2622', '\u2623', '\u2624', '\u2625', 
    '\u2626', '\u2627', '\u2628', '\u2629', '\u262a', '\u262b', '\u262c', '\u262d', 
    '\u262e', '\u262f', '\u2630', '\u2631', '\u2632', '\u2633', '\u2634', '\u2635', 
    '\u2636', '\u2637', '\u2638', '\u2639', '\u263a', '\u263b', '\u263c', '\u263d', 
    '\u263e', '\u263f', '\u2640', '\u2641', '\u2642', '\u2643', '\u2644', '\u2645', 
    '\u2646', '\u2647', '\u2648', '\u2649', '\u264a', '\u264b', '\u264c', '\u264d', 
    '\u264e', '\u264f', '\u2650', '\u2651', '\u2652', '\u2653', '\u2654', '\u2655', 
    '\u2656', '\u2657', '\u2658', '\u2659', '\u265a', '\u265b', '\u265c', '\u265d', 
    '\u265e', '\u265f', '\u2660', '\u2661', '\u2662', '\u2663', '\u2664', '\u2665', 
    '\u2666', '\u2667', '\u2668', '\u2669', '\u266a', '\u266b', '\u266c', '\u266d', 
    '\u266e', '\u266f', '\u2670', '\u2671', '\u2672', '\u2673', '\u2674', '\u2675', 
    '\u2676', '\u2677', '\u2678', '\u2679', '\u267a', '\u267b', '\u267c', '\u267d', 
    '\u267e', '\u267f', '\u2680', '\u2681', '\u2682', '\u2683', '\u2684', '\u2685', 
    '\u2690', '\u2691', '\u2692', '\u2693', '\u2694', '\u2695', '\u2696', '\u2697', 
    '\u2698', '\u2699', '\u269a', '\u269b', '\u269c', '\u269d', '\u269e', '\u269f', 
    '\u26a0', '\u26a1', '\u26a2', '\u26a3', '\u26a4', '\u26a5', '\u26a6', '\u26a7', 
    '\u26a8', '\u26a9', '\u26aa', '\u26ab', '\u26ac', '\u26ad', '\u26ae', '\u26af', 
    '\u26b0', '\u26b1', '\u26b2', '\u26b3', '\u26b4', '\u26b5', '\u26b6', '\u26b7', 
    '\u26b8', '\u26b9', '\u26ba', '\u26bb', '\u26bc', '\u26bd', '\u26be', '\u26bf', 
    '\u26c0', '\u26c1', '\u26c2', '\u26c3', '\u26c4', '\u26c5', '\u26c6', '\u26c7', 
    '\u26c8', '\u26c9', '\u26ca', '\u26cb', '\u26cc', '\u26cd', '\u26ce', '\u26cf', 
    '\u26d0', '\u26d1', '\u26d2', '\u26d3', '\u26d4', '\u26d5', '\u26d6', '\u26d7', 
    '\u26d8', '\u26d9', '\u26da', '\u26db', '\u26dc', '\u26dd', '\u26de', '\u26df', 
    '\u26e0', '\u26e1', '\u26e2', '\u26e3', '\u26e4', '\u26e5', '\u26e6', '\u26e7', 
    '\u26e8', '\u26e9', '\u26ea', '\u26eb', '\u26ec', '\u26ed', '\u26ee', '\u26ef', 
    '\u26f0', '\u26f1', '\u26f2', '\u26f3', '\u26f4', '\u26f5', '\u26f6', '\u26f7', 
    '\u26f8', '\u26f9', '\u26fa', '\u26fb', '\u26fc', '\u26fd', '\u26fe', '\u26ff', 
    '\u2700', '\u2701', '\u2702', '\u2703', '\u2704', '\u2705', '\u2708', '\u2709', 
    '\u270a', '\u270b', '\u270c', '\u270d', '\u270e', '\u270f', '\u2710', '\u2711', 
    '\u2712', '\u2714', '\u2716', '\u271d', '\u2721', '\u2728', '\u2733', '\u2734', 
    '\u2744', '\u2747', '\u274c', '\u274e', '\u2753', '\u2754', '\u2755', '\u2757', 
    '\u2763', '\u2764', '\u2765', '\u2766', '\u2767', '\u2795', '\u2796', '\u2797', 
    '\u27a1', '\u27b0', '\u27bf', '\u2934', '\u2935', '\u2b05', '\u2b06', '\u2b07', 
    '\u2b1b', '\u2b1c', '\u2b50', '\u2b55', '\u3030', '\u303d', '\u3297', '\u3299', 
    '\U0001f000', '\U0001f001', '\U0001f002', '\U0001f003', '\U0001f004', '\U0001f005', '\U0001f006', '\U0001f007', 
    '\U0001f008', '\U0001f009', '\U0001f00a', '\U0001f00b', '\U0001f00c', '\U0001f00d', '\U0001f00e', '\U0001f00f', 
    '\U0001f010', '\U0001f011', '\U0001f012', '\U0001f013', '\U0001f014', '\U0001f015', '\U0001f016', '\U0001f017', 
    '\U0001f018', '\U0001f019', '\U0001f01a', '\U0001f01b', '\U0001f01c', '\U0001f01d', '\U0001f01e', '\U0001f01f', 
    '\U0001f020', '\U0001f021', '\U0001f022', '\U0001f023', '\U0001f024', '\U0001f025', '\U0001f026', '\U0001f027', 
    '\U0001f028', '\U0001f029', '\U0001f02a', '\U0001f02b', '\U0001f02c', '\U0001f02d', '\U0001f02e', '\U0001f02f', 
    '\U0001f030', '\U0001f031', '\U0001f032', '\U0001f033', '\U0001f034', '\U0001f035', '\U0001f036', '\U0001f037', 
    '\U0001f038', '\U0001f039', '\U0001f03a', '\U0001f03b', '\U0001f03c', '\U0001f03d', '\U0001f03e', '\U0001f03f', 
    '\U0001f040', '\U0001f041', '\U0001f042', '\U0001f043', '\U0001f044', '\U0001f045', '\U0001f046', '\U0001f047', 
    '\U0001f048', '\U0001f049', '\U0001f04a', '\U0001f04b', '\U0001f04c', '\U0001f04d', '\U0001f04e', '\U0001f04f', 
    '\U0001f050', '\U0001f051', '\U0001f052', '\U0001f053', '\U0001f054', '\U0001f055', '\U0001f056', '\U0001f057', 
    '\U0001f058', '\U0001f059', '\U0001f05a', '\U0001f05b', '\U0001f05c', '\U0001f05d', '\U0001f05e', '\U0001f05f', 
    '\U0001f060', '\U0001f061', '\U0001f062', '\U0001f063', '\U0001f064', '\U0001f065', '\U0001f066', '\U0001f067', 
    '\U0001f068', '\U0001f069', '\U0001f06a', '\U0001f06b', '\U0001f06c', '\U0001f06d', '\U0001f06e', '\U0001f06f', 
    '\U0001f070', '\U0001f071', '\U0001f072', '\U0001f073', '\U0001f074', '\U0001f075', '\U0001f076', '\U0001f077', 
    '\U0001f078', '\U0001f079', '\U0001f07a', '\U0001f07b', '\U0001f07c', '\U0001f07d', '\U0001f07e', '\U0001f07f', 
    '\U0001f080', '\U0001f081', '\U0001f082', '\U0001f083', '\U0001f084', '\U0001f085', '\U0001f086', '\U0001f087', 
    '\U0001f088', '\U0001f089', '\U0001f08a', '\U0001f08b', '\U0001f08c', '\U0001f08d', '\U0001f08e', '\U0001f08f', 
    '\U0001f090', '\U0001f091', '\U0001f092', '\U0001f093', '\U0001f094', '\U0001f095', '\U0001f096', '\U0001f097', 
    '\U0001f098', '\U0001f099', '\U0001f09a', '\U0001f09b', '\U0001f09c', '\U0001f09d', '\U0001f09e', '\U0001f09f', 
    '\U0001f0a0', '\U0001f0a1', '\U0001f0a2', '\U0001f0a3', '\U0001f0a4', '\U0001f0a5', '\U0001f0a6', '\U0001f0a7', 
    '\U0001f0a8', '\U0001f0a9', '\U0001f0aa', '\U0001f0ab', '\U0001f0ac', '\U0001f0ad', '\U0001f0ae', '\U0001f0af', 
    '\U0001f0b0', '\U0001f0b1', '\U0001f0b2', '\U0001f0b3', '\U0001f0b4', '\U0001f0b5', '\U0001f0b6', '\U0001f0b7', 
    '\U0001f0b8', '\U0001f0b9', '\U0001f0ba', '\U0001f0bb', '\U0001f0bc', '\U0001f0bd', '\U0001f0be', '\U0001f0bf', 
    '\U0001f0c0', '\U0001f0c1', '\U0001f0c2', '\U0001f0c3', '\U0001f0c4', '\U0001f0c5', '\U0001f0c6', '\U0001f0c7', 
    '\U0001f0c8', '\U0001f0c9', '\U0001f0ca', '\U0001f0cb', '\U0001f0cc', '\U0001f0cd', '\U0001f0ce', '\U0001f0cf', 
    '\U0001f0d0', '\U0001f0d1', '\U0001f0d2', '\U0001f0d3', '\U0001f0d4', '\U0001f0d5', '\U0001f0d6', '\U0001f0d7', 
    '\U0001f0d8', '\U0001f0d9', '\U0001f0da', '\U0001f0db', '\U0001f0dc', '\U0001f0dd', '\U0001f0de', '\U0001f0df', 
    '\U0001f0e0', '\U0001f0e1', '\U0001f0e2', '\U0001f0e3', '\U0001f0e4', '\U0001f0e5', '\U0001f0e6', '\U0001f0e7', 
    '\U0001f0e8', '\U0001f0e9', '\U0001f0ea', '\U0001f0eb', '\U0001f0ec', '\U0001f0ed', '\U0001f0ee', '\U0001f0ef', 
    '\U0001f0f0', '\U0001f0f1', '\U0001f0f2', '\U0001f0f3', '\U0001f0f4', '\U0001f0f5', '\U0001f0f6', '\U0001f0f7', 
    '\U0001f0f8', '\U0001f0f9', '\U0001f0fa', '\U0001f0fb', '\U0001f0fc', '\U0001f0fd', '\U0001f0fe', '\U0001f0ff', 
    '\U0001f10d', '\U0001f10e', '\U0001f10f', '\U0001f12f', '\U0001f16c', '\U0001f16d', '\U0001f16e', '\U0001f16f', 
    '\U0001f170', '\U0001f171', '\U0001f17e', '\U0001f17f', '\U0001f18e', '\U0001f191', '\U0001f192', '\U0001f193', 
    '\U0001f194', '\U0001f195', '\U0001f196', '\U0001f197', '\U0001f198', '\U0001f199', '\U0001f19a', '\U0001f1ad', 
    '\U0001f1ae', '\U0001f1af', '\U0001f1b0', '\U0001f1b1', '\U0001f1b2', '\U0001f1b3', '\U0001f1b4', '\U0001f1b5', 
    '\U0001f1b6', '\U0001f1b7', '\U0001f1b8', '\U0001f1b9', '\U0001f1ba', '\U0001f1bb', '\U0001f1bc', '\U0001f1bd', 
    '\U0001f1be', '\U0001f1bf', '\U0001f1c0', '\U0001f1c1', '\U0001f1c2', '\U0001f1c3', '\U0001f1c4', '\U0001f1c5', 
    '\U0001f1c6', '\U0001f1c7', '\U0001f1c8', '\U0001f1c9', '\U0001f1ca', '\U0001f1cb', '\U0001f1cc', '\U0001f1cd', 
    '\U0001f1ce', '\U0001f1cf', '\U0001f1d0', '\U0001f1d1', '\U0001f1d2', '\U0001f1d3', '\U0001f1d4', '\U0001f1d5', 
    '\U0001f1d6', '\U0001f1d7', '\U0001f1d8', '\U0001f1d9', '\U0001f1da', '\U0001f1db', '\U0001f1dc', '\U0001f1dd', 
    '\U0001f1de', '\U0001f1df', '\U0001f1e0', '\U0001f1e1', '\U0001f1e2', '\U0001f1e3', '\U0001f1e4', '\U0001f1e5', 
    '\U0001f201', '\U0001f202', '\U0001f203', '\U0001f204', '\U0001f205', '\U0001f206', '\U0001f207', '\U0001f208', 
    '\U0001f209', '\U0001f20a', '\U0001f20b', '\U0001f20c', '\U0001f20d', '\U0001f20e', '\U0001f20f', '\U0001f21a', 
    '\U0001f22f', '\U0001f232', '\U0001f233', '\U0001f234', '\U0001f235', '\U0001f236', '\U0001f237', '\U0001f238', 
    '\U0001f239', '\U0001f23a', '\U0001f23c', '\U0001f23d', '\U0001f23e', '\U0001f23f', '\U0001f249', '\U0001f24a', 
    '\U0001f24b', '\U0001f24c', '\U0001f24d', '\U0001f24e', '\U0001f24f', '\U0001f250', '\U0001f251', '\U0001f252', 
    '\U0001f253', '\U0001f254', '\U0001f255', '\U0001f256', '\U0001f257', '\U0001f258', '\U0001f259', '\U0001f25a', 
    '\U0001f25b', '\U0001f25c', '\U0001f25d', '\U0001f25e', '\U0001f25f', '\U0001f260', '\U0001f261', '\U0001f262', 
    '\U0001f263', '\U0001f264', '\U0001f265', '\U0001f266', '\U0001f267', '\U0001f268', '\U0001f269', '\U0001f26a', 
    '\U0001f26b', '\U0001f26c', '\U0001f26d', '\U0001f26e', '\U0001f26f', '\U0001f270', '\U0001f271', '\U0001f272', 
    '\U0001f273', '\U0001f274', '\U0001f275', '\U0001f276', '\U0001f277', '\U0001f278', '\U0001f279', '\U0001f27a', 
    '\U0001f27b', '\U0001f27c', '\U0001f27d', '\U0001f27e', '\U0001f27f', '\U0001f280', '\U0001f281', '\U0001f282', 
    '\U0001f283', '\U0001f284', '\U0001f285', '\U0001f286', '\U0001f287', '\U0001f288', '\U0001f289', '\U0001f28a', 
    '\U0001f28b', '\U0001f28c', '\U0001f28d', '\U0001f28e', '\U0001f28f', '\U0001f290', '\U0001f291', '\U0001f292', 
    '\U0001f293', '\U0001f294', '\U0001f295', '\U0001f296', '\U0001f297', '\U0001f298', '\U0001f299', '\U0001f29a', 
    '\U0001f29b', '\U0001f29c', '\U0001f29d', '\U0001f29e', '\U0001f29f', '\U0001f2a0', '\U0001f2a1', '\U0001f2a2', 
    '\U0001f2a3', '\U0001f2a4', '\U0001f2a5', '\U0001f2a6', '\U0001f2a7', '\U0001f2a8', '\U0001f2a9', '\U0001f2aa', 
    '\U0001f2ab', '\U0001f2ac', '\U0001f2ad', '\U0001f2ae', '\U0001f2af', '\U0001f2b0', '\U0001f2b1', '\U0001f2b2', 
    '\U0001f2b3', '\U0001f2b4', '\U0001f2b5', '\U0001f2b6', '\U0001f2b7', '\U0001f2b8', '\U0001f2b9', '\U0001f2ba', 
    '\U0001f2bb', '\U0001f2bc', '\U0001f2bd', '\U0001f2be', '\U0001f2bf', '\U0001f2c0', '\U0001f2c1', '\U0001f2c2', 
    '\U0001f2c3', '\U0001f2c4', '\U0001f2c5', '\U0001f2c6', '\U0001f2c7', '\U0001f2c8', '\U0001f2c9', '\U0001f2ca', 
    '\U0001f2cb', '\U0001f2cc', '\U0001f2cd', '\U0001f2ce', '\U0001f2cf', '\U0001f2d0', '\U0001f2d1', '\U0001f2d2', 
    '\U0001f2d3', '\U0001f2d4', '\U0001f2d5', '\U0001f2d6', '\U0001f2d7', '\U0001f2d8', '\U0001f2d9', '\U0001f2da', 
    '\U0001f2db', '\U0001f2dc', '\U0001f2dd', '\U0001f2de', '\U0001f2df', '\U0001f2e0', '\U0001f2e1', '\U0001f2e2', 
    '\U0001f2e3', '\U0001f2e4', '\U0001f2e5', '\U0001f2e6', '\U0001f2e7', '\U0001f2e8', '\U0001f2e9', '\U0001f2ea', 
    '\U0001f2eb', '\U0001f2ec', '\U0001f2ed', '\U0001f2ee', '\U0001f2ef', '\U0001f2f0', '\U0001f2f1', '\U0001f2f2', 
    '\U0001f2f3', '\U0001f2f4', '\U0001f2f5', '\U0001f2f6', '\U0001f2f7', '\U0001f2f8', '\U0001f2f9', '\U0001f2fa', 
    '\U0001f2fb', '\U0001f2fc', '\U0001f2fd', '\U0001f2fe', '\U0001f2ff', '\U0001f300', '\U0001f301', '\U0001f302', 
    '\U0001f303', '\U0001f304', '\U0001f305', '\U0001f306', '\U0001f307', '\U0001f308', '\U0001f309', '\U0001f30a', 
    '\U0001f30b', '\U0001f30c', '\U0001f30d', '\U0001f30e', '\U0001f30f', '\U0001f310', '\U0001f311', '\U0001f312', 
    '\U0001f313', '\U0001f314', '\U0001f315', '\U0001f316', '\U0001f317', '\U0001f318', '\U0001f319', '\U0001f31a', 
    '\U0001f31b', '\U0001f31c', '\U0001f31d', '\U0001f31e', '\U0001f31f', '\U0001f320', '\U0001f321', '\U0001f322', 
    '\U0001f323', '\U0001f324', '\U0001f325', '\U0001f326', '\U0001f327', '\U0001f328', '\U0001f329', '\U0001f32a', 
    '\U0001f32b', '\U0001f32c', '\U0001f32d', '\U0001f32e', '\U0001f32f', '\U0001f330', '\U0001f331', '\U0001f332', 
    '\U0001f333', '\U0001f334', '\U0001f335', '\U0001f336', '\U0001f337', '\U0001f338', '\U0001f339', '\U0001f33a', 
    '\U0001f33b', '\U0001f33c', '\U0001f33d', '\U0001f33e', '\U0001f33f', '\U0001f340', '\U0001f341', '\U0001f342', 
    '\U0001f343', '\U0001f344', '\U0001f345', '\U0001f346', '\U0001f347', '\U0001f348', '\U0001f349', '\U0001f34a', 
    '\U0001f34b', '\U0001f34c', '\U0001f34d', '\U0001f34e', '\U0001f34f', '\U0001f350', '\U0001f351', '\U0001f352', 
    '\U0001f353', '\U0001f354', '\U0001f355', '\U0001f356', '\U0001f357', '\U0001f358', '\U0001f359', '\U0001f35a', 
    '\U0001f35b', '\U0001f35c', '\U0001f35d', '\U0001f35e', '\U0001f35f', '\U0001f360', '\U0001f361', '\U0001f362', 
    '\U0001f363', '\U0001f364', '\U0001f365', '\U0001f366', '\U0001f367', '\U0001f368', '\U0001f369', '\U0001f36a', 
    '\U0001f36b', '\U0001f36c', '\U0001f36d', '\U0001f36e', '\U0001f36f', '\U0001f370', '\U0001f371', '\U0001f372', 
    '\U0001f373', '\U0001f374', '\U0001f375', '\U0001f376', '\U0001f377', '\U0001f378', '\U0001f379', '\U0001f37a', 
    '\U0001f37b', '\U0001f37c', '\U0001f37d', '\U0001f37e', '\U0001f37f', '\U0001f380', '\U0001f381', '\U0001f382', 
    '\U0001f383', '\U0001f384', '\U0001f385', '\U0001f386', '\U0001f387', '\U0001f388', '\U0001f389', '\U0001f38a', 
    '\U0001f38b', '\U0001f38c', '\U0001f38d', '\U0001f38e', '\U0001f38f', '\U0001f390', '\U0001f391', '\U0001f392', 
    '\U0001f393', '\U0001f394', '\U0001f395', '\U0001f396', '\U0001f397', '\U0001f398', '\U0001f399', '\U0001f39a', 
    '\U0001f39b', '\U0001f39c', '\U0001f39d', '\U0001f39e', '\U0001f39f', '\U0001f3a0', '\U0001f3a1', '\U0001f3a2', 
    '\U0001f3a3', '\U0001f3a4', '\U0001f3a5', '\U0001f3a6', '\U0001f3a7', '\U0001f3a8', '\U0001f3a9', '\U0001f3aa', 
    '\U0001f3ab', '\U0001f3ac', '\U0001f3ad', '\U0001f3ae', '\U0001f3af', '\U0001f3b0', '\U0001f3b1', '\U0001f3b2', 
    '\U0001f3b3', '\U0001f3b4', '\U0001f3b5', '\U0001f3b6', '\U0001f3b7', '\U0001f3b8', '\U0001f3b9', '\U0001f3ba', 
    '\U0001f3bb', '\U0001f3bc', '\U0001f3bd', '\U0001f3be', '\U0001f3bf', '\U0001f3c0', '\U0001f3c1', '\U0001f3c2', 
    '\U0001f3c3', '\U0001f3c4', '\U0001f3c5', '\U0001f3c6', '\U0001f3c7', '\U0001f3c8', '\U0001f3c9', '\U0001f3ca', 
    '\U0001f3cb', '\U0001f3cc', '\U0001f3cd', '\U0001f3ce', '\U0001f3cf', '\U0001f3d0', '\U0001f3d1', '\U0001f3d2', 
    '\U0001f3d3', '\U0001f3d4', '\U0001f3d5', '\U0001f3d6', '\U0001f3d7', '\U0001f3d8', '\U0001f3d9', '\U0001f3da', 
    '\U0001f3db', '\U0001f3dc', '\U0001f3dd', '\U0001f3de', '\U0001f3df', '\U0001f3e0', '\U0001f3e1', '\U0001f3e2', 
    '\U0001f3e3', '\U0001f3e4', '\U0001f3e5', '\U0001f3e6', '\U0001f3e7', '\U0001f3e8', '\U0001f3e9', '\U0001f3ea', 
    '\U0001f3eb', '\U0001f3ec', '\U0001f3ed', '\U0001f3ee', '\U0001f3ef', '\U0001f3f0', '\U0001f3f1', '\U0001f3f2', 
    '\U0001f3f3', '\U0001f3f4', '\U0001f3f5', '\U0001f3f6', '\U0001f3f7', '\U0001f3f8', '\U0001f3f9', '\U0001f3fa', 
    '\U0001f400', '\U0001f401', '\U0001f402', '\U0001f403', '\U0001f404', '\U0001f405', '\U0001f406', '\U0001f407', 
    '\U0001f408', '\U0001f409', '\U0001f40a', '\U0001f40b', '\U0001f40c', '\U0001f40d', '\U0001f40e', '\U0001f40f', 
    '\U0001f410', '\U0001f411', '\U0001f412', '\U0001f413', '\U0001f414', '\U0001f415', '\U0001f416', '\U0001f417', 
    '\U0001f418', '\U0001f419', '\U0001f41a', '\U0001f41b', '\U0001f41c', '\U0001f41d', '\U0001f41e', '\U0001f41f', 
    '\U0001f420', '\U0001f421', '\U0001f422', '\U0001f423', '\U0001f424', '\U0001f425', '\U0001f426', '\U0001f427', 
    '\U0001f428', '\U0001f429', '\U0001f42a', '\U0001f42b', '\U0001f42c', '\U0001f42d', '\U0001f42e', '\U0001f42f', 
    '\U0001f430', '\U0001f431', '\U0001f432', '\U0001f433', '\U0001f434', '\U0001f435', '\U0001f436', '\U0001f437', 
    '\U0001f438', '\U0001f439', '\U0001f43a', '\U0001f43b', '\U0001f43c', '\U0001f43d', '\U0001f43e', '\U0001f43f', 
    '\U0001f440', '\U0001f441', '\U0001f442', '\U0001f443', '\U0001f444', '\U0001f445', '\U0001f446', '\U0001f447', 
    '\U0001f448', '\U0001f449', '\U0001f44a', '\U0001f44b', '\U0001f44c', '\U0001f44d', '\U0001f44e', '\U0001f44f', 
    '\U0001f450', '\U0001f451', '\U0001f452', '\U0001f453', '\U0001f454', '\U0001f455', '\U0001f456', '\U0001f457', 
    '\U0001f458', '\U0001f459', '\U0001f45a', '\U0001f45b', '\U0001f45c', '\U0001f45d', '\U0001f45e', '\U0001f45f', 
    '\U0001f460', '\U0001f461', '\U0001f462', '\U0001f463', '\U0001f464', '\U0001f465', '\U0001f466', '\U0001f467', 
    '\U0001f468', '\U0001f469', '\U0001f46a', '\U0001f46b', '\U0001f46c', '\U0001f46d', '\U0001f46e', '\U0001f46f', 
    '\U0001f470', '\U0001f471', '\U0001f472', '\U0001f473', '\U0001f474', '\U0001f475', '\U0001f476', '\U0001f477', 
    '\U0001f478', '\U0001f479', '\U0001f47a', '\U0001f47b', '\U0001f47c', '\U0001f47d', '\U0001f47e', '\U0001f47f', 
    '\U0001f480', '\U0001f481', '\U0001f482', '\U0001f483', '\U0001f484', '\U0001f485', '\U0001f486', '\U0001f487', 
    '\U0001f488', '\U0001f489', '\U0001f48a', '\U0001f48b', '\U0001f48c', '\U0001f48d', '\U0001f48e', '\U0001f48f', 
    '\U0001f490', '\U0001f491', '\U0001f492', '\U0001f493', '\U0001f494', '\U0001f495', '\U0001f496', '\U0001f497', 
    '\U0001f498', '\U0001f499', '\U0001f49a', '\U0001f49b', '\U0001f49c', '\U0001f49d', '\U0001f49e', '\U0001f49f', 
    '\U0001f4a0', '\U0001f4a1', '\U0001f4a2', '\U0001f4a3', '\U0001f4a4', '\U0001f4a5', '\U0001f4a6', '\U0001f4a7', 
    '\U0001f4a8', '\U0001f4a9', '\U0001f4aa', '\U0001f4ab', '\U0001f4ac', '\U0001f4ad', '\U0001f4ae', '\U0001f4af', 
    '\U0001f4b0', '\U0001f4b1', '\U0001f4b2', '\U0001f4b3', '\U0001f4b4', '\U0001f4b5', '\U0001f4b6', '\U0001f4b7', 
    '\U0001f4b8', '\U0001f4b9', '\U0001f4ba', '\U0001f4bb', '\U0001f4bc', '\U0001f4bd', '\U0001f4be', '\U0001f4bf', 
    '\U0001f4c0', '\U0001f4c1', '\U0001f4c2', '\U0001f4c3', '\U0001f4c4', '\U0001f4c5', '\U0001f4c6', '\U0001f4c7', 
    '\U0001f4c8', '\U0001f4c9', '\U0001f4ca', '\U0001f4cb', '\U0001f4cc', '\U0001f4cd', '\U0001f4ce', '\U0001f4cf', 
    '\U0001f4d0', '\U0001f4d1', '\U0001f4d2', '\U0001f4d3', '\U0001f4d4', '\U0001f4d5', '\U0001f4d6', '\U0001f4d7', 
    '\U0001f4d8', '\U0001f4d9', '\U0001f4da', '\U0001f4db', '\U0001f4dc', '\U0001f4dd', '\U0001f4de', '\U0001f4df', 
    '\U0001f4e0', '\U0001f4e1', '\U0001f4e2', '\U0001f4e3', '\U0001f4e4', '\U0001f4e5', '\U0001f4e6', '\U0001f4e7', 
    '\U0001f4e8', '\U0001f4e9', '\U0001f4ea', '\U0001f4eb', '\U0001f4ec', '\U0001f4ed', '\U0001f4ee', '\U0001f4ef', 
    '\U0001f4f0', '\U0001f4f1', '\U0001f4f2', '\U0001f4f3', '\U0001f4f4', '\U0001f4f5', '\U0001f4f6', '\U0001f4f7', 
    '\U0001f4f8', '\U0001f4f9', '\U0001f4fa', '\U0001f4fb', '\U0001f4fc', '\U0001f4fd', '\U0001f4fe', '\U0001f4ff', 
    '\U0001f500', '\U0001f501', '\U0001f502', '\U0001f503', '\U0001f504', '\U0001f505', '\U0001f506', '\U0001f507', 
    '\U0001f508', '\U0001f509', '\U0001f50a', '\U0001f50b', '\U0001f50c', '\U0001f50d', '\U0001f50e', '\U0001f50f', 
    '\U0001f510', '\U0001f511', '\U0001f512', '\U0001f513', '\U0001f514', '\U0001f515', '\U0001f516', '\U0001f517', 
    '\U0001f518', '\U0001f519', '\U0001f51a', '\U0001f51b', '\U0001f51c', '\U0001f51d', '\U0001f51e', '\U0001f51f', 
    '\U0001f520', '\U0001f521', '\U0001f522', '\U0001f523', '\U0001f524', '\U0001f525', '\U0001f526', '\U0001f527', 
    '\U0001f528', '\U0001f529', '\U0001f52a', '\U0001f52b', '\U0001f52c', '\U0001f52d', '\U0001f52e', '\U0001f52f', 
    '\U0001f530', '\U0001f531', '\U0001f532', '\U0001f533', '\U0001f534', '\U0001f535', '\U0001f536', '\U0001f537', 
    '\U0001f538', '\U0001f539', '\U0001f53a', '\U0001f53b', '\U0001f53c', '\U0001f53d', '\U0001f546', '\U0001f547', 
    '\U0001f548', '\U0001f549', '\U0001f54a', '\U0001f54b', '\U0001f54c', '\U0001f54d', '\U0001f54e', '\U0001f54f', 
    '\U0001f550', '\U0001f551', '\U0001f552', '\U0001f553', '\U0001f554', '\U0001f555', '\U0001f556', '\U0001f557', 
    '\U0001f558', '\U0001f559', '\U0001f55a', '\U0001f55b', '\U0001f55c', '\U0001f55d', '\U0001f55e', '\U0001f55f', 
    '\U0001f560', '\U0001f561', '\U0001f562', '\U0001f563', '\U0001f564', '\U0001f565', '\U0001f566', '\U0001f567', 
    '\U0001f568', '\U0001f569', '\U0001f56a', '\U0001f56b', '\U0001f56c', '\U0001f56d', '\U0001f56e', '\U0001f56f', 
    '\U0001f570', '\U0001f571', '\U0001f572', '\U0001f573', '\U0001f574', '\U0001f575', '\U0001f576', '\U0001f577', 
    '\U0001f578', '\U0001f579', '\U0001f57a', '\U0001f57b', '\U0001f57c', '\U0001f57d', '\U0001f57e', '\U0001f57f', 
    '\U0001f580', '\U0001f581', '\U0001f582', '\U0001f583', '\U0001f584', '\U0001f585', '\U0001f586', '\U0001f587', 
    '\U0001f588', '\U0001f589', '\U0001f58a', '\U0001f58b', '\U0001f58c', '\U0001f58d', '\U0001f58e', '\U0001f58f', 
    '\U0001f590', '\U0001f591', '\U0001f592', '\U0001f593', '\U0001f594', '\U0001f595', '\U0001f596', '\U0001f597', 
    '\U0001f598', '\U0001f599', '\U0001f59a', '\U0001f59b', '\U0001f59c', '\U0001f59d', '\U0001f59e', '\U0001f59f', 
    '\U0001f5a0', '\U0001f5a1', '\U0001f5a2', '\U0001f5a3', '\U0001f5a4', '\U0001f5a5', '\U0001f5a6', '\U0001f5a7', 
    '\U0001f5a8', '\U0001f5a9', '\U0001f5aa', '\U0001f5ab', '\U0001f5ac', '\U0001f5ad', '\U0001f5ae', '\U0001f5af', 
    '\U0001f5b0', '\U0001f5b1', '\U0001f5b2', '\U0001f5b3', '\U0001f5b4', '\U0001f5b5', '\U0001f5b6', '\U0001f5b7', 
    '\U0001f5b8', '\U0001f5b9', '\U0001f5ba', '\U0001f5bb', '\U0001f5bc', '\U0001f5bd', '\U0001f5be', '\U0001f5bf', 
    '\U0001f5c0', '\U0001f5c1', '\U0001f5c2', '\U0001f5c3', '\U0001f5c4', '\U0001f5c5', '\U0001f5c6', '\U0001f5c7', 
    '\U0001f5c8', '\U0001f5c9', '\U0001f5ca', '\U0001f5cb', '\U0001f5cc', '\U0001f5cd', '\U0001f5ce', '\U0001f5cf', 
    '\U0001f5d0', '\U0001f5d1', '\U0001f5d2', '\U0001f5d3', '\U0001f5d4', '\U0001f5d5', '\U0001f5d6', '\U0001f5d7', 
    '\U0001f5d8', '\U0001f5d9', '\U0001f5da', '\U0001f5db', '\U0001f5dc', '\U0001f5dd', '\U0001f5de', '\U0001f5df', 
    '\U0001f5e0', '\U0001f5e1', '\U0001f5e2', '\U0001f5e3', '\U0001f5e4', '\U0001f5e5', '\U0001f5e6', '\U0001f5e7', 
    '\U0001f5e8', '\U0001f5e9', '\U0001f5ea', '\U0001f5eb', '\U0001f5ec', '\U0001f5ed', '\U0001f5ee', '\U0001f5ef', 
    '\U0001f5f0', '\U0001f5f1', '\U0001f5f2', '\U0001f5f3', '\U0001f5f4', '\U0001f5f5', '\U0001f5f6', '\U0001f5f7', 
    '\U0001f5f8', '\U0001f5f9', '\U0001f5fa', '\U0001f5fb', '\U0001f5fc', '\U0001f5fd', '\U0001f5fe', '\U0001f5ff', 
    '\U0001f600', '\U0001f601', '\U0001f602', '\U0001f603', '\U0001f604', '\U0001f605', '\U0001f606', '\U0001f607', 
    '\U0001f608', '\U0001f609', '\U0001f60a', '\U0001f60b', '\U0001f60c', '\U0001f60d', '\U0001f60e', '\U0001f60f', 
    '\U0001f610', '\U0001f611', '\U0001f612', '\U0001f613', '\U0001f614', '\U0001f615', '\U0001f616', '\U0001f617', 
    '\U0001f618', '\U0001f619', '\U0001f61a', '\U0001f61b', '\U0001f61c', '\U0001f61d', '\U0001f61e', '\U0001f61f', 
    '\U0001f620', '\U0001f621', '\U0001f622', '\U0001f623', '\U0001f624', '\U0001f625', '\U0001f626', '\U0001f627', 
    '\U0001f628', '\U0001f629', '\U0001f62a', '\U0001f62b', '\U0001f62c', '\U0001f62d', '\U0001f62e', '\U0001f62f', 
    '\U0001f630', '\U0001f631', '\U0001f632', '\U0001f633', '\U0001f634', '\U0001f635', '\U0001f636', '\U0001f637', 
    '\U0001f638', '\U0001f639', '\U0001f63a', '\U0001f63b', '\U0001f63c', '\U0001f63d', '\U0001f63e', '\U0001f63f', 
    '\U0001f640', '\U0001f641', '\U0001f642', '\U0001f643', '\U0001f644', '\U0001f645', '\U0001f646', '\U0001f647', 
    '\U0001f648', '\U0001f649', '\U0001f64a', '\U0001f64b', '\U0001f64c', '\U0001f64d', '\U0001f64e', '\U0001f64f', 
    '\U0001f680', '\U0001f681', '\U0001f682', '\U0001f683', '\U0001f684', '\U0001f685', '\U0001f686', '\U0001f687', 
    '\U0001f688', '\U0001f689', '\U0001f68a', '\U0001f68b', '\U0001f68c', '\U0001f68d', '\U0001f68e', '\U0001f68f', 
    '\U0001f690', '\U0001f691', '\U0001f692', '\U0001f693', '\U0001f694', '\U0001f695', '\U0001f696', '\U0001f697', 
    '\U0001f698', '\U0001f699', '\U0001f69a', '\U0001f69b', '\U0001f69c', '\U0001f69d', '\U0001f69e', '\U0001f69f', 
    '\U0001f6a0', '\U0001f6a1', '\U0001f6a2', '\U0001f6a3', '\U0001f6a4', '\U0001f6a5', '\U0001f6a6', '\U0001f6a7', 
    '\U0001f6a8', '\U0001f6a9', '\U0001f6aa', '\U0001f6ab', '\U0001f6ac', '\U0001f6ad', '\U0001f6ae', '\U0001f6af', 
    '\U0001f6b0', '\U0001f6b1', '\U0001f6b2', '\U0001f6b3', '\U0001f6b4', '\U0001f6b5', '\U0001f6b6', '\U0001f6b7', 
    '\U0001f6b8', '\U0001f6b9', '\U0001f6ba', '\U0001f6bb', '\U0001f6bc', '\U0001f6bd', '\U0001f6be', '\U0001f6bf', 
    '\U0001f6c0', '\U0001f6c1', '\U0001f6c2', '\U0001f6c3', '\U0001f6c4', '\U0001f6c5', '\U0001f6c6', '\U0001f6c7', 
    '\U0001f6c8', '\U0001f6c9', '\U0001f6ca', '\U0001f6cb', '\U0001f6cc', '\U0001f6cd', '\U0001f6ce', '\U0001f6cf', 
    '\U0001f6d0', '\U0001f6d1', '\U0001f6d2', '\U0001f6d3', '\U0001f6d4', '\U0001f6d5', '\U0001f6d6', '\U0001f6d7', 
    '\U0001f6d8', '\U0001f6d9', '\U0001f6da', '\U0001f6db', '\U0001f6dc', '\U0001f6dd', '\U0001f6de', '\U0001f6df', 
    '\U0001f6e0', '\U0001f6e1', '\U0001f6e2', '\U0001f6e3', '\U0001f6e4', '\U0001f6e5', '\U0001f6e6', '\U0001f6e7', 
    '\U0001f6e8', '\U0001f6e9', '\U0001f6ea', '\U0001f6eb', '\U0001f6ec', '\U0001f6ed', '\U0001f6ee', '\U0001f6ef', 
    '\U0001f6f0', '\U0001f6f1', '\U0001f6f2', '\U0001f6f3', '\U0001f6f4', '\U0001f6f5', '\U0001f6f6', '\U0001f6f7', 
    '\U0001f6f8', '\U0001f6f9', '\U0001f6fa', '\U0001f6fb', '\U0001f6fc', '\U0001f6fd', '\U0001f6fe', '\U0001f6ff', 
    '\U0001f774', '\U0001f775', '\U0001f776', '\U0001f777', '\U0001f778', '\U0001f779', '\U0001f77a', '\U0001f77b', 
    '\U0001f77c', '\U0001f77d', '\U0001f77e', '\U0001f77f', '\U0001f7d5', '\U0001f7d6', '\U0001f7d7', '\U0001f7d8', 
    '\U0001f7d9', '\U0001f7da', '\U0001f7db', '\U0001f7dc', '\U0001f7dd', '\U0001f7de', '\U0001f7df', '\U0001f7e0', 
    '\U0001f7e1', '\U0001f7e2', '\U0001f7e3', '\U0001f7e4', '\U0001f7e5', '\U0001f7e6', '\U0001f7e7', '\U0001f7e8', 
    '\U0001f7e9', '\U0001f7ea', '\U0001f7eb', '\U0001f7ec', '\U0001f7ed', '\U0001f7ee', '\U0001f7ef', '\U0001f7f0', 
    '\U0001f7f1', '\U0001f7f2', '\U0001f7f3', '\U0001f7f4', '\U0001f7f5', '\U0001f7f6', '\U0001f7f7', '\U0001f7f8', 
    '\U0001f7f9', '\U0001f7fa', '\U0001f7fb', '\U0001f7fc', '\U0001f7fd', '\U0001f7fe', '\U0001f7ff', '\U0001f80c', 
    '\U0001f80d', '\U0001f80e', '\U0001f80f', '\U0001f848', '\U0001f849', '\U0001f84a', '\U0001f84b', '\U0001f84c', 
    '\U0001f84d', '\U0001f84e', '\U0001f84f', '\U0001f85a', '\U0001f85b', '\U0001f85c', '\U0001f85d', '\U0001f85e', 
    '\U0001f85f', '\U0001f888', '\U0001f889', '\U0001f88a', '\U0001f88b', '\U0001f88c', '\U0001f88d', '\U0001f88e', 
    '\U0001f88f', '\U0001f8ae', '\U0001f8af', '\U0001f8b0', '\U0001f8b1', '\U0001f8b2', '\U0001f8b3', '\U0001f8b4', 
    '\U0001f8b5', '\U0001f8b6', '\U0001f8b7', '\U0001f8b8', '\U0001f8b9', '\U0001f8ba', '\U0001f8bb', '\U0001f8bc', 
    '\U0001f8bd', '\U0001f8be', '\U0001f8bf', '\U0001f8c0', '\U0001f8c1', '\U0001f8c2', '\U0001f8c3', '\U0001f8c4', 
    '\U0001f8c5', '\U0001f8c6', '\U0001f8c7', '\U0001f8c8', '\U0001f8c9', '\U0001f8ca', '\U0001f8cb', '\U0001f8cc', 
    '\U0001f8cd', '\U0001f8ce', '\U0001f8cf', '\U0001f8d0', '\U0001f8d1', '\U0001f8d2', '\U0001f8d3', '\U0001f8d4', 
    '\U0001f8d5', '\U0001f8d6', '\U0001f8d7', '\U0001f8d8', '\U0001f8d9', '\U0001f8da', '\U0001f8db', '\U0001f8dc', 
    '\U0001f8dd', '\U0001f8de', '\U0001f8df', '\U0001f8e0', '\U0001f8e1', '\U0001f8e2', '\U0001f8e3', '\U0001f8e4', 
    '\U0001f8e5', '\U0001f8e6', '\U0001f8e7', '\U0001f8e8', '\U0001f8e9', '\U0001f8ea', '\U0001f8eb', '\U0001f8ec', 
    '\U0001f8ed', '\U0001f8ee', '\U0001f8ef', '\U0001f8f0', '\U0001f8f1', '\U0001f8f2', '\U0001f8f3', '\U0001f8f4', 
    '\U0001f8f5', '\U0001f8f6', '\U0001f8f7', '\U0001f8f8', '\U0001f8f9', '\U0001f8fa', '\U0001f8fb', '\U0001f8fc', 
    '\U0001f8fd', '\U0001f8fe', '\U0001f8ff', '\U0001f90c', '\U0001f90d', '\U0001f90e', '\U0001f90f', '\U0001f910', 
    '\U0001f911', '\U0001f912', '\U0001f913', '\U0001f914', '\U0001f915', '\U0001f916', '\U0001f917', '\U0001f918', 
    '\U0001f919', '\U0001f91a', '\U0001f91b', '\U0001f91c', '\U0001f91d', '\U0001f91e', '\U0001f91f', '\U0001f920', 
    '\U0001f921', '\U0001f922', '\U0001f923', '\U0001f924', '\U0001f925', '\U0001f926', '\U0001f927', '\U0001f928', 
    '\U0001f929', '\U0001f92a', '\U0001f92b', '\U0001f92c', '\U0001f92d', '\U0001f92e', '\U0001f92f', '\U0001f930', 
    '\U0001f931', '\U0001f932', '\U0001f933', '\U0001f934', '\U0001f935', '\U0001f936', '\U0001f937', '\U0001f938', 
    '\U0001f939', '\U0001f93a', '\U0001f93c', '\U0001f93d', '\U0001f93e', '\U0001f93f', '\U0001f940', '\U0001f941', 
    '\U0001f942', '\U0001f943', '\U0001f944', '\U0001f945', '\U0001f947', '\U0001f948', '\U0001f949', '\U0001f94a', 
    '\U0001f94b', '\U0001f94c', '\U0001f94d', '\U0001f94e', '\U0001f94f', '\U0001f950', '\U0001f951', '\U0001f952', 
    '\U0001f953', '\U0001f954', '\U0001f955', '\U0001f956', '\U0001f957', '\U0001f958', '\U0001f959', '\U0001f95a', 
    '\U0001f95b', '\U0001f95c', '\U0001f95d', '\U0001f95e', '\U0001f95f', '\U0001f960', '\U0001f961', '\U0001f962', 
    '\U0001f963', '\U0001f964', '\U0001f965', '\U0001f966', '\U0001f967', '\U0001f968', '\U0001f969', '\U0001f96a', 
    '\U0001f96b', '\U0001f96c', '\U0001f96d', '\U0001f96e', '\U0001f96f', '\U0001f970', '\U0001f971', '\U0001f972', 
    '\U0001f973', '\U0001f974', '\U0001f975', '\U0001f976', '\U0001f977', '\U0001f978', '\U0001f979', '\U0001f97a', 
    '\U0001f97b', '\U0001f97c', '\U0001f97d', '\U0001f97e', '\U0001f97f', '\U0001f980', '\U0001f981', '\U0001f982', 
    '\U0001f983', '\U0001f984', '\U0001f985', '\U0001f986', '\U0001f987', '\U0001f988', '\U0001f989', '\U0001f98a', 
    '\U0001f98b', '\U0001f98c', '\U0001f98d', '\U0001f98e', '\U0001f98f', '\U0001f990', '\U0001f991', '\U0001f992', 
    '\U0001f993', '\U0001f994', '\U0001f995', '\U0001f996', '\U0001f997', '\U0001f998', '\U0001f999', '\U0001f99a', 
    '\U0001f99b', '\U0001f99c', '\U0001f99d', '\U0001f99e', '\U0001f99f', '\U0001f9a0', '\U0001f9a1', '\U0001f9a2', 
    '\U0001f9a3', '\U0001f9a4', '\U0001f9a5', '\U0001f9a6', '\U0001f9a7', '\U0001f9a8', '\U0001f9a9', '\U0001f9aa', 
    '\U0001f9ab', '\U0001f9ac', '\U0001f9ad', '\U0001f9ae', '\U0001f9af', '\U0001f9b0', '\U0001f9b1', '\U0001f9b2', 
    '\U0001f9b3', '\U0001f9b4', '\U0001f9b5', '\U0001f9b6', '\U0001f9b7', '\U0001f9b8', '\U0001f9b9', '\U0001f9ba', 
    '\U0001f9bb', '\U0001f9bc', '\U0001f9bd', '\U0001f9be', '\U0001f9bf', '\U0001f9c0', '\U0001f9c1', '\U0001f9c2', 
    '\U0001f9c3', '\U0001f9c4', '\U0001f9c5', '\U0001f9c6', '\U0001f9c7', '\U0001f9c8', '\U0001f9c9', '\U0001f9ca', 
    '\U0001f9cb', '\U0001f9cc', '\U0001f9cd', '\U0001f9ce', '\U0001f9cf', '\U0001f9d0', '\U0001f9d1', '\U0001f9d2', 
    '\U0001f9d3', '\U0001f9d4', '\U0001f9d5', '\U0001f9d6', '\U0001f9d7', '\U0001f9d8', '\U0001f9d9', '\U0001f9da', 
    '\U0001f9db', '\U0001f9dc', '\U0001f9dd', '\U0001f9de', '\U0001f9df', '\U0001f9e0', '\U0001f9e1', '\U0001f9e2', 
    '\U0001f9e3', '\U0001f9e4', '\U0001f9e5', '\U0001f9e6', '\U0001f9e7', '\U0001f9e8', '\U0001f9e9', '\U0001f9ea', 
    '\U0001f9eb', '\U0001f9ec', '\U0001f9ed', '\U0001f9ee', '\U0001f9ef', '\U0001f9f0', '\U0001f9f1', '\U0001f9f2', 
    '\U0001f9f3', '\U0001f9f4', '\U0001f9f5', '\U0001f9f6', '\U0001f9f7', '\U0001f9f8', '\U0001f9f9', '\U0001f9fa', 
    '\U0001f9fb', '\U0001f9fc', '\U0001f9fd', '\U0001f9fe', '\U0001f9ff', '\U0001fa00', '\U0001fa01', '\U0001fa02', 
    '\U0001fa03', '\U0001fa04', '\U0001fa05', '\U0001fa06', '\U0001fa07', '\U0001fa08', '\U0001fa09', '\U0001fa0a', 
    '\U0001fa0b', '\U0001fa0c', '\U0001fa0d', '\U0001fa0e', '\U0001fa0f', '\U0001fa10', '\U0001fa11', '\U0001fa12', 
    '\U0001fa13', '\U0001fa14', '\U0001fa15', '\U0001fa16', '\U0001fa17', '\U0001fa18', '\U0001fa19', '\U0001fa1a', 
    '\U0001fa1b', '\U0001fa1c', '\U0001fa1d', '\U0001fa1e', '\U0001fa1f', '\U0001fa20', '\U0001fa21', '\U0001fa22', 
    '\U0001fa23', '\U0001fa24', '\U0001fa25', '\U0001fa26', '\U0001fa27', '\U0001fa28', '\U0001fa29', '\U0001fa2a', 
    '\U0001fa2b', '\U0001fa2c', '\U0001fa2d', '\U0001fa2e', '\U0001fa2f', '\U0001fa30', '\U0001fa31', '\U0001fa32', 
    '\U0001fa33', '\U0001fa34', '\U0001fa35', '\U0001fa36', '\U0001fa37', '\U0001fa38', '\U0001fa39', '\U0001fa3a', 
    '\U0001fa3b', '\U0001fa3c', '\U0001fa3d', '\U0001fa3e', '\U0001fa3f', '\U0001fa40', '\U0001fa41', '\U0001fa42', 
    '\U0001fa43', '\U0001fa44', '\U0001fa45', '\U0001fa46', '\U0001fa47', '\U0001fa48', '\U0001fa49', '\U0001fa4a', 
    '\U0001fa4b', '\U0001fa4c', '\U0001fa4d', '\U0001fa4e', '\U0001fa4f', '\U0001fa50', '\U0001fa51', '\U0001fa52', 
    '\U0001fa53', '\U0001fa54', '\U0001fa55', '\U0001fa56', '\U0001fa57', '\U0001fa58', '\U0001fa59', '\U0001fa5a', 
    '\U0001fa5b', '\U0001fa5c', '\U0001fa5d', '\U0001fa5e', '\U0001fa5f', '\U0001fa60', '\U0001fa61', '\U0001fa62', 
    '\U0001fa63', '\U0001fa64', '\U0001fa65', '\U0001fa66', '\U0001fa67', '\U0001fa68', '\U0001fa69', '\U0001fa6a', 
    '\U0001fa6b', '\U0001fa6c', '\U0001fa6d', '\U0001fa6e', '\U0001fa6f', '\U0001fa70', '\U0001fa71', '\U0001fa72', 
    '\U0001fa73', '\U0001fa74', '\U0001fa75', '\U0001fa76', '\U0001fa77', '\U0001fa78', '\U0001fa79', '\U0001fa7a', 
    '\U0001fa7b', '\U0001fa7c', '\U0001fa7d', '\U0001fa7e', '\U0001fa7f', '\U0001fa80', '\U0001fa81', '\U0001fa82', 
    '\U0001fa83', '\U0001fa84', '\U0001fa85', '\U0001fa86', '\U0001fa87', '\U0001fa88', '\U0001fa89', '\U0001fa8a', 
    '\U0001fa8b', '\U0001fa8c', '\U0001fa8d', '\U0001fa8e', '\U0001fa8f', '\U0001fa90', '\U0001fa91', '\U0001fa92', 
    '\U0001fa93', '\U0001fa94', '\U0001fa95', '\U0001fa96', '\U0001fa97', '\U0001fa98', '\U0001fa99', '\U0001fa9a', 
    '\U0001fa9b', '\U0001fa9c', '\U0001fa9d', '\U0001fa9e', '\U0001fa9f', '\U0001faa0', '\U0001faa1', '\U0001faa2', 
    '\U0001faa3', '\U0001faa4', '\U0001faa5', '\U0001faa6', '\U0001faa7', '\U0001faa8', '\U0001faa9', '\U0001faaa', 
    '\U0001faab', '\U0001faac', '\U0001faad', '\U0001faae', '\U0001faaf', '\U0001fab0', '\U0001fab1', '\U0001fab2', 
    '\U0001fab3', '\U0001fab4', '\U0001fab5', '\U0001fab6', '\U0001fab7', '\U0001fab8', '\U0001fab9', '\U0001faba', 
    '\U0001fabb', '\U0001fabc', '\U0001fabd', '\U0001fabe', '\U0001fabf', '\U0001fac0', '\U0001fac1', '\U0001fac2', 
    '\U0001fac3', '\U0001fac4', '\U0001fac5', '\U0001fac6', '\U0001fac7', '\U0001fac8', '\U0001fac9', '\U0001faca', 
    '\U0001facb', '\U0001facc', '\U0001facd', '\U0001face', '\U0001facf', '\U0001fad0', '\U0001fad1', '\U0001fad2', 
    '\U0001fad3', '\U0001fad4', '\U0001fad5', '\U0001fad6', '\U0001fad7', '\U0001fad8', '\U0001fad9', '\U0001fada', 
    '\U0001fadb', '\U0001fadc', '\U0001fadd', '\U0001fade', '\U0001fadf', '\U0001fae0', '\U0001fae1', '\U0001fae2', 
    '\U0001fae3', '\U0001fae4', '\U0001fae5', '\U0001fae6', '\U0001fae7', '\U0001fae8', '\U0001fae9', '\U0001faea', 
    '\U0001faeb', '\U0001faec', '\U0001faed', '\U0001faee', '\U0001faef', '\U0001faf0', '\U0001faf1', '\U0001faf2', 
    '\U0001faf3', '\U0001faf4', '\U0001faf5', '\U0001faf6', '\U0001faf7', '\U0001faf8', '\U0001faf9', '\U0001fafa', 
    '\U0001fafb', '\U0001fafc', '\U0001fafd', '\U0001fafe', '\U0001faff', '\U0001fb00', '\U0001fb01', '\U0001fb02', 
    '\U0001fb03', '\U0001fb04', '\U0001fb05', '\U0001fb06', '\U0001fb07', '\U0001fb08', '\U0001fb09', '\U0001fb0a', 
    '\U0001fb0b', '\U0001fb0c', '\U0001fb0d', '\U0001fb0e', '\U0001fb0f', '\U0001fb10', '\U0001fb11', '\U0001fb12', 
    '\U0001fb13', '\U0001fb14', '\U0001fb15', '\U0001fb16', '\U0001fb17', '\U0001fb18', '\U0001fb19', '\U0001fb1a', 
    '\U0001fb1b', '\U0001fb1c', '\U0001fb1d', '\U0001fb1e', '\U0001fb1f', '\U0001fb20', '\U0001fb21', '\U0001fb22', 
    '\U0001fb23', '\U0001fb24', '\U0001fb25', '\U0001fb26', '\U0001fb27', '\U0001fb28', '\U0001fb29', '\U0001fb2a', 
    '\U0001fb2b', '\U0001fb2c', '\U0001fb2d', '\U0001fb2e', '\U0001fb2f', '\U0001fb30', '\U0001fb31', '\U0001fb32', 
    '\U0001fb33', '\U0001fb34', '\U0001fb35', '\U0001fb36', '\U0001fb37', '\U0001fb38', '\U0001fb39', '\U0001fb3a', 
    '\U0001fb3b', '\U0001fb3c', '\U0001fb3d', '\U0001fb3e', '\U0001fb3f', '\U0001fb40', '\U0001fb41', '\U0001fb42', 
    '\U0001fb43', '\U0001fb44', '\U0001fb45', '\U0001fb46', '\U0001fb47', '\U0001fb48', '\U0001fb49', '\U0001fb4a', 
    '\U0001fb4b', '\U0001fb4c', '\U0001fb4d', '\U0001fb4e', '\U0001fb4f', '\U0001fb50', '\U0001fb51', '\U0001fb52', 
    '\U0001fb53', '\U0001fb54', '\U0001fb55', '\U0001fb56', '\U0001fb57', '\U0001fb58', '\U0001fb59', '\U0001fb5a', 
    '\U0001fb5b', '\U0001fb5c', '\U0001fb5d', '\U0001fb5e', '\U0001fb5f', '\U0001fb60', '\U0001fb61', '\U0001fb62', 
    '\U0001fb63', '\U0001fb64', '\U0001fb65', '\U0001fb66', '\U0001fb67', '\U0001fb68', '\U0001fb69', '\U0001fb6a', 
    '\U0001fb6b', '\U0001fb6c', '\U0001fb6d', '\U0001fb6e', '\U0001fb6f', '\U0001fb70', '\U0001fb71', '\U0001fb72', 
    '\U0001fb73', '\U0001fb74', '\U0001fb75', '\U0001fb76', '\U0001fb77', '\U0001fb78', '\U0001fb79', '\U0001fb7a', 
    '\U0001fb7b', '\U0001fb7c', '\U0001fb7d', '\U0001fb7e', '\U0001fb7f', '\U0001fb80', '\U0001fb81', '\U0001fb82', 
    '\U0001fb83', '\U0001fb84', '\U0001fb85', '\U0001fb86', '\U0001fb87', '\U0001fb88', '\U0001fb89', '\U0001fb8a', 
    '\U0001fb8b', '\U0001fb8c', '\U0001fb8d', '\U0001fb8e', '\U0001fb8f', '\U0001fb90', '\U0001fb91', '\U0001fb92', 
    '\U0001fb93', '\U0001fb94', '\U0001fb95', '\U0001fb96', '\U0001fb97', '\U0001fb98', '\U0001fb99', '\U0001fb9a', 
    '\U0001fb9b', '\U0001fb9c', '\U0001fb9d', '\U0001fb9e', '\U0001fb9f', '\U0001fba0', '\U0001fba1', '\U0001fba2', 
    '\U0001fba3', '\U0001fba4', '\U0001fba5', '\U0001fba6', '\U0001fba7', '\U0001fba8', '\U0001fba9', '\U0001fbaa', 
    '\U0001fbab', '\U0001fbac', '\U0001fbad', '\U0001fbae', '\U0001fbaf', '\U0001fbb0', '\U0001fbb1', '\U0001fbb2', 
    '\U0001fbb3', '\U0001fbb4', '\U0001fbb5', '\U0001fbb6', '\U0001fbb7', '\U0001fbb8', '\U0001fbb9', '\U0001fbba', 
    '\U0001fbbb', '\U0001fbbc', '\U0001fbbd', '\U0001fbbe', '\U0001fbbf', '\U0001fbc0', '\U0001fbc1', '\U0001fbc2', 
    '\U0001fbc3', '\U0001fbc4', '\U0001fbc5', '\U0001fbc6', '\U0001fbc7', '\U0001fbc8', '\U0001fbc9', '\U0001fbca', 
    '\U0001fbcb', '\U0001fbcc', '\U0001fbcd', '\U0001fbce', '\U0001fbcf', '\U0001fbd0', '\U0001fbd1', '\U0001fbd2', 
    '\U0001fbd3', '\U0001fbd4', '\U0001fbd5', '\U0001fbd6', '\U0001fbd7', '\U0001fbd8', '\U0001fbd9', '\U0001fbda', 
    '\U0001fbdb', '\U0001fbdc', '\U0001fbdd', '\U0001fbde', '\U0001fbdf', '\U0001fbe0', '\U0001fbe1', '\U0001fbe2', 
    '\U0001fbe3', '\U0001fbe4', '\U0001fbe5', '\U0001fbe6', '\U0001fbe7', '\U0001fbe8', '\U0001fbe9', '\U0001fbea', 
    '\U0001fbeb', '\U0001fbec', '\U0001fbed', '\U0001fbee', '\U0001fbef', '\U0001fbf0', '\U0001fbf1', '\U0001fbf2', 
    '\U0001fbf3', '\U0001fbf4', '\U0001fbf5', '\U0001fbf6', '\U0001fbf7', '\U0001fbf8', '\U0001fbf9', '\U0001fbfa', 
    '\U0001fbfb', '\U0001fbfc', '\U0001fbfd', '\U0001fbfe', '\U0001fbff', '\U0001fc00', '\U0001fc01', '\U0001fc02', 
    '\U0001fc03', '\U0001fc04', '\U0001fc05', '\U0001fc06', '\U0001fc07', '\U0001fc08', '\U0001fc09', '\U0001fc0a', 
    '\U0001fc0b', '\U0001fc0c', '\U0001fc0d', '\U0001fc0e', '\U0001fc0f', '\U0001fc10', '\U0001fc11', '\U0001fc12', 
    '\U0001fc13', '\U0001fc14', '\U0001fc15', '\U0001fc16', '\U0001fc17', '\U0001fc18', '\U0001fc19', '\U0001fc1a', 
    '\U0001fc1b', '\U0001fc1c', '\U0001fc1d', '\U0001fc1e', '\U0001fc1f', '\U0001fc20', '\U0001fc21', '\U0001fc22', 
    '\U0001fc23', '\U0001fc24', '\U0001fc25', '\U0001fc26', '\U0001fc27', '\U0001fc28', '\U0001fc29', '\U0001fc2a', 
    '\U0001fc2b', '\U0001fc2c', '\U0001fc2d', '\U0001fc2e', '\U0001fc2f', '\U0001fc30', '\U0001fc31', '\U0001fc32', 
    '\U0001fc33', '\U0001fc34', '\U0001fc35', '\U0001fc36', '\U0001fc37', '\U0001fc38', '\U0001fc39', '\U0001fc3a', 
    '\U0001fc3b', '\U0001fc3c', '\U0001fc3d', '\U0001fc3e', '\U0001fc3f', '\U0001fc40', '\U0001fc41', '\U0001fc42', 
    '\U0001fc43', '\U0001fc44', '\U0001fc45', '\U0001fc46', '\U0001fc47', '\U0001fc48', '\U0001fc49', '\U0001fc4a', 
    '\U0001fc4b', '\U0001fc4c', '\U0001fc4d', '\U0001fc4e', '\U0001fc4f', '\U0001fc50', '\U0001fc51', '\U0001fc52', 
    '\U0001fc53', '\U0001fc54', '\U0001fc55', '\U0001fc56', '\U0001fc57', '\U0001fc58', '\U0001fc59', '\U0001fc5a', 
    '\U0001fc5b', '\U0001fc5c', '\U0001fc5d', '\U0001fc5e', '\U0001fc5f', '\U0001fc60', '\U0001fc61', '\U0001fc62', 
    '\U0001fc63', '\U0001fc64', '\U0001fc65', '\U0001fc66', '\U0001fc67', '\U0001fc68', '\U0001fc69', '\U0001fc6a', 
    '\U0001fc6b', '\U0001fc6c', '\U0001fc6d', '\U0001fc6e', '\U0001fc6f', '\U0001fc70', '\U0001fc71', '\U0001fc72', 
    '\U0001fc73', '\U0001fc74', '\U0001fc75', '\U0001fc76', '\U0001fc77', '\U0001fc78', '\U0001fc79', '\U0001fc7a', 
    '\U0001fc7b', '\U0001fc7c', '\U0001fc7d', '\U0001fc7e', '\U0001fc7f', '\U0001fc80', '\U0001fc81', '\U0001fc82', 
    '\U0001fc83', '\U0001fc84', '\U0001fc85', '\U0001fc86', '\U0001fc87', '\U0001fc88', '\U0001fc89', '\U0001fc8a', 
    '\U0001fc8b', '\U0001fc8c', '\U0001fc8d', '\U0001fc8e', '\U0001fc8f', '\U0001fc90', '\U0001fc91', '\U0001fc92', 
    '\U0001fc93', '\U0001fc94', '\U0001fc95', '\U0001fc96', '\U0001fc97', '\U0001fc98', '\U0001fc99', '\U0001fc9a', 
    '\U0001fc9b', '\U0001fc9c', '\U0001fc9d', '\U0001fc9e', '\U0001fc9f', '\U0001fca0', '\U0001fca1', '\U0001fca2', 
    '\U0001fca3', '\U0001fca4', '\U0001fca5', '\U0001fca6', '\U0001fca7', '\U0001fca8', '\U0001fca9', '\U0001fcaa', 
    '\U0001fcab', '\U0001fcac', '\U0001fcad', '\U0001fcae', '\U0001fcaf', '\U0001fcb0', '\U0001fcb1', '\U0001fcb2', 
    '\U0001fcb3', '\U0001fcb4', '\U0001fcb5', '\U0001fcb6', '\U0001fcb7', '\U0001fcb8', '\U0001fcb9', '\U0001fcba', 
    '\U0001fcbb', '\U0001fcbc', '\U0001fcbd', '\U0001fcbe', '\U0001fcbf', '\U0001fcc0', '\U0001fcc1', '\U0001fcc2', 
    '\U0001fcc3', '\U0001fcc4', '\U0001fcc5', '\U0001fcc6', '\U0001fcc7', '\U0001fcc8', '\U0001fcc9', '\U0001fcca', 
    '\U0001fccb', '\U0001fccc', '\U0001fccd', '\U0001fcce', '\U0001fccf', '\U0001fcd0', '\U0001fcd1', '\U0001fcd2', 
    '\U0001fcd3', '\U0001fcd4', '\U0001fcd5', '\U0001fcd6', '\U0001fcd7', '\U0001fcd8', '\U0001fcd9', '\U0001fcda', 
    '\U0001fcdb', '\U0001fcdc', '\U0001fcdd', '\U0001fcde', '\U0001fcdf', '\U0001fce0', '\U0001fce1', '\U0001fce2', 
    '\U0001fce3', '\U0001fce4', '\U0001fce5', '\U0001fce6', '\U0001fce7', '\U0001fce8', '\U0001fce9', '\U0001fcea', 
    '\U0001fceb', '\U0001fcec', '\U0001fced', '\U0001fcee', '\U0001fcef', '\U0001fcf0', '\U0001fcf1', '\U0001fcf2', 
    '\U0001fcf3', '\U0001fcf4', '\U0001fcf5', '\U0001fcf6', '\U0001fcf7', '\U0001fcf8', '\U0001fcf9', '\U0001fcfa', 
    '\U0001fcfb', '\U0001fcfc', '\U0001fcfd', '\U0001fcfe', '\U0001fcff', '\U0001fd00', '\U0001fd01', '\U0001fd02', 
    '\U0001fd03', '\U0001fd04', '\U0001fd05', '\U0001fd06', '\U0001fd07', '\U0001fd08', '\U0001fd09', '\U0001fd0a', 
    '\U0001fd0b', '\U0001fd0c', '\U0001fd0d', '\U0001fd0e', '\U0001fd0f', '\U0001fd10', '\U0001fd11', '\U0001fd12', 
    '\U0001fd13', '\U0001fd14', '\U0001fd15', '\U0001fd16', '\U0001fd17', '\U0001fd18', '\U0001fd19', '\U0001fd1a', 
    '\U0001fd1b', '\U0001fd1c', '\U0001fd1d', '\U0001fd1e', '\U0001fd1f', '\U0001fd20', '\U0001fd21', '\U0001fd22', 
    '\U0001fd23', '\U0001fd24', '\U0001fd25', '\U0001fd26', '\U0001fd27', '\U0001fd28', '\U0001fd29', '\U0001fd2a', 
    '\U0001fd2b', '\U0001fd2c', '\U0001fd2d', '\U0001fd2e', '\U0001fd2f', '\U0001fd30', '\U0001fd31', '\U0001fd32', 
    '\U0001fd33', '\U0001fd34', '\U0001fd35', '\U0001fd36', '\U0001fd37', '\U0001fd38', '\U0001fd39', '\U0001fd3a', 
    '\U0001fd3b', '\U0001fd3c', '\U0001fd3d', '\U0001fd3e', '\U0001fd3f', '\U0001fd40', '\U0001fd41', '\U0001fd42', 
    '\U0001fd43', '\U0001fd44', '\U0001fd45', '\U0001fd46', '\U0001fd47', '\U0001fd48', '\U0001fd49', '\U0001fd4a', 
    '\U0001fd4b', '\U0001fd4c', '\U0001fd4d', '\U0001fd4e', '\U0001fd4f', '\U0001fd50', '\U0001fd51', '\U0001fd52', 
    '\U0001fd53', '\U0001fd54', '\U0001fd55', '\U0001fd56', '\U0001fd57', '\U0001fd58', '\U0001fd59', '\U0001fd5a', 
    '\U0001fd5b', '\U0001fd5c', '\U0001fd5d', '\U0001fd5e', '\U0001fd5f', '\U0001fd60', '\U0001fd61', '\U0001fd62', 
    '\U0001fd63', '\U0001fd64', '\U0001fd65', '\U0001fd66', '\U0001fd67', '\U0001fd68', '\U0001fd69', '\U0001fd6a', 
    '\U0001fd6b', '\U0001fd6c', '\U0001fd6d', '\U0001fd6e', '\U0001fd6f', '\U0001fd70', '\U0001fd71', '\U0001fd72', 
    '\U0001fd73', '\U0001fd74', '\U0001fd75', '\U0001fd76', '\U0001fd77', '\U0001fd78', '\U0001fd79', '\U0001fd7a', 
    '\U0001fd7b', '\U0001fd7c', '\U0001fd7d', '\U0001fd7e', '\U0001fd7f', '\U0001fd80', '\U0001fd81', '\U0001fd82', 
    '\U0001fd83', '\U0001fd84', '\U0001fd85', '\U0001fd86', '\U0001fd87', '\U0001fd88', '\U0001fd89', '\U0001fd8a', 
    '\U0001fd8b', '\U0001fd8c', '\U0001fd8d', '\U0001fd8e', '\U0001fd8f', '\U0001fd90', '\U0001fd91', '\U0001fd92', 
    '\U0001fd93', '\U0001fd94', '\U0001fd95', '\U0001fd96', '\U0001fd97', '\U0001fd98', '\U0001fd99', '\U0001fd9a', 
    '\U0001fd9b', '\U0001fd9c', '\U0001fd9d', '\U0001fd9e', '\U0001fd9f', '\U0001fda0', '\U0001fda1', '\U0001fda2', 
    '\U0001fda3', '\U0001fda4', '\U0001fda5', '\U0001fda6', '\U0001fda7', '\U0001fda8', '\U0001fda9', '\U0001fdaa', 
    '\U0001fdab', '\U0001fdac', '\U0001fdad', '\U0001fdae', '\U0001fdaf', '\U0001fdb0', '\U0001fdb1', '\U0001fdb2', 
    '\U0001fdb3', '\U0001fdb4', '\U0001fdb5', '\U0001fdb6', '\U0001fdb7', '\U0001fdb8', '\U0001fdb9', '\U0001fdba', 
    '\U0001fdbb', '\U0001fdbc', '\U0001fdbd', '\U0001fdbe', '\U0001fdbf', '\U0001fdc0', '\U0001fdc1', '\U0001fdc2', 
    '\U0001fdc3', '\U0001fdc4', '\U0001fdc5', '\U0001fdc6', '\U0001fdc7', '\U0001fdc8', '\U0001fdc9', '\U0001fdca', 
    '\U0001fdcb', '\U0001fdcc', '\U0001fdcd', '\U0001fdce', '\U0001fdcf', '\U0001fdd0', '\U0001fdd1', '\U0001fdd2', 
    '\U0001fdd3', '\U0001fdd4', '\U0001fdd5', '\U0001fdd6', '\U0001fdd7', '\U0001fdd8', '\U0001fdd9', '\U0001fdda', 
    '\U0001fddb', '\U0001fddc', '\U0001fddd', '\U0001fdde', '\U0001fddf', '\U0001fde0', '\U0001fde1', '\U0001fde2', 
    '\U0001fde3', '\U0001fde4', '\U0001fde5', '\U0001fde6', '\U0001fde7', '\U0001fde8', '\U0001fde9', '\U0001fdea', 
    '\U0001fdeb', '\U0001fdec', '\U0001fded', '\U0001fdee', '\U0001fdef', '\U0001fdf0', '\U0001fdf1', '\U0001fdf2', 
    '\U0001fdf3', '\U0001fdf4', '\U0001fdf5', '\U0001fdf6', '\U0001fdf7', '\U0001fdf8', '\U0001fdf9', '\U0001fdfa', 
    '\U0001fdfb', '\U0001fdfc', '\U0001fdfd', '\U0001fdfe', '\U0001fdff', '\U0001fe00', '\U0001fe01', '\U0001fe02', 
    '\U0001fe03', '\U0001fe04', '\U0001fe05', '\U0001fe06', '\U0001fe07', '\U0001fe08', '\U0001fe09', '\U0001fe0a', 
    '\U0001fe0b', '\U0001fe0c', '\U0001fe0d', '\U0001fe0e', '\U0001fe0f', '\U0001fe10', '\U0001fe11', '\U0001fe12', 
    '\U0001fe13', '\U0001fe14', '\U0001fe15', '\U0001fe16', '\U0001fe17', '\U0001fe18', '\U0001fe19', '\U0001fe1a', 
    '\U0001fe1b', '\U0001fe1c', '\U0001fe1d', '\U0001fe1e', '\U0001fe1f', '\U0001fe20', '\U0001fe21', '\U0001fe22', 
    '\U0001fe23', '\U0001fe24', '\U0001fe25', '\U0001fe26', '\U0001fe27', '\U0001fe28', '\U0001fe29', '\U0001fe2a', 
    '\U0001fe2b', '\U0001fe2c', '\U0001fe2d', '\U0001fe2e', '\U0001fe2f', '\U0001fe30', '\U0001fe31', '\U0001fe32', 
    '\U0001fe33', '\U0001fe34', '\U0001fe35', '\U0001fe36', '\U0001fe37', '\U0001fe38', '\U0001fe39', '\U0001fe3a', 
    '\U0001fe3b', '\U0001fe3c', '\U0001fe3d', '\U0001fe3e', '\U0001fe3f', '\U0001fe40', '\U0001fe41', '\U0001fe42', 
    '\U0001fe43', '\U0001fe44', '\U0001fe45', '\U0001fe46', '\U0001fe47', '\U0001fe48', '\U0001fe49', '\U0001fe4a', 
    '\U0001fe4b', '\U0001fe4c', '\U0001fe4d', '\U0001fe4e', '\U0001fe4f', '\U0001fe50', '\U0001fe51', '\U0001fe52', 
    '\U0001fe53', '\U0001fe54', '\U0001fe55', '\U0001fe56', '\U0001fe57', '\U0001fe58', '\U0001fe59', '\U0001fe5a', 
    '\U0001fe5b', '\U0001fe5c', '\U0001fe5d', '\U0001fe5e', '\U0001fe5f', '\U0001fe60', '\U0001fe61', '\U0001fe62', 
    '\U0001fe63', '\U0001fe64', '\U0001fe65', '\U0001fe66', '\U0001fe67', '\U0001fe68', '\U0001fe69', '\U0001fe6a', 
    '\U0001fe6b', '\U0001fe6c', '\U0001fe6d', '\U0001fe6e', '\U0001fe6f', '\U0001fe70', '\U0001fe71', '\U0001fe72', 
    '\U0001fe73', '\U0001fe74', '\U0001fe75', '\U0001fe76', '\U0001fe77', '\U0001fe78', '\U0001fe79', '\U0001fe7a', 
    '\U0001fe7b', '\U0001fe7c', '\U0001fe7d', '\U0001fe7e', '\U0001fe7f', '\U0001fe80', '\U0001fe81', '\U0001fe82', 
    '\U0001fe83', '\U0001fe84', '\U0001fe85', '\U0001fe86', '\U0001fe87', '\U0001fe88', '\U0001fe89', '\U0001fe8a', 
    '\U0001fe8b', '\U0001fe8c', '\U0001fe8d', '\U0001fe8e', '\U0001fe8f', '\U0001fe90', '\U0001fe91', '\U0001fe92', 
    '\U0001fe93', '\U0001fe94', '\U0001fe95', '\U0001fe96', '\U0001fe97', '\U0001fe98', '\U0001fe99', '\U0001fe9a', 
    '\U0001fe9b', '\U0001fe9c', '\U0001fe9d', '\U0001fe9e', '\U0001fe9f', '\U0001fea0', '\U0001fea1', '\U0001fea2', 
    '\U0001fea3', '\U0001fea4', '\U0001fea5', '\U0001fea6', '\U0001fea7', '\U0001fea8', '\U0001fea9', '\U0001feaa', 
    '\U0001feab', '\U0001feac', '\U0001fead', '\U0001feae', '\U0001feaf', '\U0001feb0', '\U0001feb1', '\U0001feb2', 
    '\U0001feb3', '\U0001feb4', '\U0001feb5', '\U0001feb6', '\U0001feb7', '\U0001feb8', '\U0001feb9', '\U0001feba', 
    '\U0001febb', '\U0001febc', '\U0001febd', '\U0001febe', '\U0001febf', '\U0001fec0', '\U0001fec1', '\U0001fec2', 
    '\U0001fec3', '\U0001fec4', '\U0001fec5', '\U0001fec6', '\U0001fec7', '\U0001fec8', '\U0001fec9', '\U0001feca', 
    '\U0001fecb', '\U0001fecc', '\U0001fecd', '\U0001fece', '\U0001fecf', '\U0001fed0', '\U0001fed1', '\U0001fed2', 
    '\U0001fed3', '\U0001fed4', '\U0001fed5', '\U0001fed6', '\U0001fed7', '\U0001fed8', '\U0001fed9', '\U0001feda', 
    '\U0001fedb', '\U0001fedc', '\U0001fedd', '\U0001fede', '\U0001fedf', '\U0001fee0', '\U0001fee1', '\U0001fee2', 
    '\U0001fee3', '\U0001fee4', '\U0001fee5', '\U0001fee6', '\U0001fee7', '\U0001fee8', '\U0001fee9', '\U0001feea', 
    '\U0001feeb', '\U0001feec', '\U0001feed', '\U0001feee', '\U0001feef', '\U0001fef0', '\U0001fef1', '\U0001fef2', 
    '\U0001fef3', '\U0001fef4', '\U0001fef5', '\U0001fef6', '\U0001fef7', '\U0001fef8', '\U0001fef9', '\U0001fefa', 
    '\U0001fefb', '\U0001fefc', '\U0001fefd', '\U0001fefe', '\U0001feff', '\U0001ff00', '\U0001ff01', '\U0001ff02', 
    '\U0001ff03', '\U0001ff04', '\U0001ff05', '\U0001ff06', '\U0001ff07', '\U0001ff08', '\U0001ff09', '\U0001ff0a', 
    '\U0001ff0b', '\U0001ff0c', '\U0001ff0d', '\U0001ff0e', '\U0001ff0f', '\U0001ff10', '\U0001ff11', '\U0001ff12', 
    '\U0001ff13', '\U0001ff14', '\U0001ff15', '\U0001ff16', '\U0001ff17', '\U0001ff18', '\U0001ff19', '\U0001ff1a', 
    '\U0001ff1b', '\U0001ff1c', '\U0001ff1d', '\U0001ff1e', '\U0001ff1f', '\U0001ff20', '\U0001ff21', '\U0001ff22', 
    '\U0001ff23', '\U0001ff24', '\U0001ff25', '\U0001ff26', '\U0001ff27', '\U0001ff28', '\U0001ff29', '\U0001ff2a', 
    '\U0001ff2b', '\U0001ff2c', '\U0001ff2d', '\U0001ff2e', '\U0001ff2f', '\U0001ff30', '\U0001ff31', '\U0001ff32', 
    '\U0001ff33', '\U0001ff34', '\U0001ff35', '\U0001ff36', '\U0001ff37', '\U0001ff38', '\U0001ff39', '\U0001ff3a', 
    '\U0001ff3b', '\U0001ff3c', '\U0001ff3d', '\U0001ff3e', '\U0001ff3f', '\U0001ff40', '\U0001ff41', '\U0001ff42', 
    '\U0001ff43', '\U0001ff44', '\U0001ff45', '\U0001ff46', '\U0001ff47', '\U0001ff48', '\U0001ff49', '\U0001ff4a', 
    '\U0001ff4b', '\U0001ff4c', '\U0001ff4d', '\U0001ff4e', '\U0001ff4f', '\U0001ff50', '\U0001ff51', '\U0001ff52', 
    '\U0001ff53', '\U0001ff54', '\U0001ff55', '\U0001ff56', '\U0001ff57', '\U0001ff58', '\U0001ff59', '\U0001ff5a', 
    '\U0001ff5b', '\U0001ff5c', '\U0001ff5d', '\U0001ff5e', '\U0001ff5f', '\U0001ff60', '\U0001ff61', '\U0001ff62', 
    '\U0001ff63', '\U0001ff64', '\U0001ff65', '\U0001ff66', '\U0001ff67', '\U0001ff68', '\U0001ff69', '\U0001ff6a', 
    '\U0001ff6b', '\U0001ff6c', '\U0001ff6d', '\U0001ff6e', '\U0001ff6f', '\U0001ff70', '\U0001ff71', '\U0001ff72', 
    '\U0001ff73', '\U0001ff74', '\U0001ff75', '\U0001ff76', '\U0001ff77', '\U0001ff78', '\U0001ff79', '\U0001ff7a', 
    '\U0001ff7b', '\U0001ff7c', '\U0001ff7d', '\U0001ff7e', '\U0001ff7f', '\U0001ff80', '\U0001ff81', '\U0001ff82', 
    '\U0001ff83', '\U0001ff84', '\U0001ff85', '\U0001ff86', '\U0001ff87', '\U0001ff88', '\U0001ff89', '\U0001ff8a', 
    '\U0001ff8b', '\U0001ff8c', '\U0001ff8d', '\U0001ff8e', '\U0001ff8f', '\U0001ff90', '\U0001ff91', '\U0001ff92', 
    '\U0001ff93', '\U0001ff94', '\U0001ff95', '\U0001ff96', '\U0001ff97', '\U0001ff98', '\U0001ff99', '\U0001ff9a', 
    '\U0001ff9b', '\U0001ff9c', '\U0001ff9d', '\U0001ff9e', '\U0001ff9f', '\U0001ffa0', '\U0001ffa1', '\U0001ffa2', 
    '\U0001ffa3', '\U0001ffa4', '\U0001ffa5', '\U0001ffa6', '\U0001ffa7', '\U0001ffa8', '\U0001ffa9', '\U0001ffaa', 
    '\U0001ffab', '\U0001ffac', '\U0001ffad', '\U0001ffae', '\U0001ffaf', '\U0001ffb0', '\U0001ffb1', '\U0001ffb2', 
    '\U0001ffb3', '\U0001ffb4', '\U0001ffb5', '\U0001ffb6', '\U0001ffb7', '\U0001ffb8', '\U0001ffb9', '\U0001ffba', 
    '\U0001ffbb', '\U0001ffbc', '\U0001ffbd', '\U0001ffbe', '\U0001ffbf', '\U0001ffc0', '\U0001ffc1', '\U0001ffc2', 
    '\U0001ffc3', '\U0001ffc4', '\U0001ffc5', '\U0001ffc6', '\U0001ffc7', '\U0001ffc8', '\U0001ffc9', '\U0001ffca', 
    '\U0001ffcb', '\U0001ffcc', '\U0001ffcd', '\U0001ffce', '\U0001ffcf', '\U0001ffd0', '\U0001ffd1', '\U0001ffd2', 
    '\U0001ffd3', '\U0001ffd4', '\U0001ffd5', '\U0001ffd6', '\U0001ffd7', '\U0001ffd8', '\U0001ffd9', '\U0001ffda', 
    '\U0001ffdb', '\U0001ffdc', '\U0001ffdd', '\U0001ffde', '\U0001ffdf', '\U0001ffe0', '\U0001ffe1', '\U0001ffe2', 
    '\U0001ffe3', '\U0001ffe4', '\U0001ffe5', '\U0001ffe6', '\U0001ffe7', '\U0001ffe8', '\U0001ffe9', '\U0001ffea', 
    '\U0001ffeb', '\U0001ffec', '\U0001ffed', '\U0001ffee', '\U0001ffef', '\U0001fff0', '\U0001fff1', '\U0001fff2', 
    '\U0001fff3', '\U0001fff4', '\U0001fff5', '\U0001fff6', '\U0001fff7', '\U0001fff8', '\U0001fff9', '\U0001fffa', 
    '\U0001fffb', '\U0001fffc', '\U0001fffd')
    rangeFromEmojisClass[int(Extended_PictographicClass)] = Extended_Pictographic
}
