---
name: Documentation Issue
about: Use this template for documentation related issues
labels: 'type:docs'

---


Thank you for submitting a TensorFlow documentation issue. Per our GitHub
policy, we only address code/doc bugs, performance issues, feature requests, and
build/installation issues on GitHub.

The TensorFlow docs are open source! To get involved, read the documentation
contributor guide: https://www.tensorflow.org/community/contribute/docs

## URL(s) with the issue:

Please provide a link to the documentation entry, for example:
https://www.tensorflow.org/versions/r2.0/api_docs/python/tf/

## Description of issue (what needs changing):

### Clear description

For example, why should someone use this method? How is it useful?

### Correct links

Is the link to the source code correct?

### Parameters defined

Are all parameters defined and formatted correctly?

### Returns defined

Are return values defined?

### Raises listed and defined

Are the errors defined? For example,
https://www.tensorflow.org/versions/r2.0/api_docs/python/tf/feature_column/categorical_column_with_vocabulary_file#raises

### Usage example

Is there a usage example?

See the API guide: https://www.tensorflow.org/community/contribute/docs_ref
on how to write testable usage examples.

### Request visuals, if applicable

Are there currently visuals? If not, will it clarify the content?

### Submit a pull request?

Are you planning to also submit a pull request to fix the issue? See the docs
contributor guide: https://www.tensorflow.org/community/contribute/docs,
docs API guide: https://www.tensorflow.org/community/contribute/docs_ref and the
docs style guide: https://www.tensorflow.org/community/contribute/docs_style
