## TFSA-2021-140: Reference binding to nullptr in `RaggedTensorToVariant`

### CVE Number
CVE-2021-37666

### Impact
An attacker can cause undefined behavior via binding a reference to null pointer
in `tf.raw_ops.RaggedTensorToVariant`:

```python
import tensorflow as tf

tf.raw_ops.RaggedTensorToVariant(
  rt_nested_splits=[],
  rt_dense_values=[1,2,3],
  batched_input=True)
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/460e000de3a83278fb00b61a16d161b1964f15f4/tensorflow/core/kernels/ragged_tensor_to_variant_op.cc#L129)
has an incomplete validation of the splits values, missing the case when the
argument would be empty.

### Patches
We have patched the issue in GitHub commit
[be7a4de6adfbd303ce08be4332554dff70362612](https://github.com/tensorflow/tensorflow/commit/be7a4de6adfbd303ce08be4332554dff70362612).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
