## TFSA-2021-057: Heap out of bounds read in `MaxPoolGradWithArgmax`

### CVE Number
CVE-2021-29570

### Impact
The implementation of `tf.raw_ops.MaxPoolGradWithArgmax` can cause reads outside
of bounds of heap allocated data if attacker supplies specially crafted inputs:

```python
import tensorflow as tf

input = tf.constant([10.0, 10.0, 10.0], shape=[1, 1, 3, 1], dtype=tf.float32)
grad = tf.constant([10.0, 10.0, 10.0, 10.0], shape=[1, 1, 1, 4], dtype=tf.float32)
argmax = tf.constant([1], shape=[1], dtype=tf.int64)
ksize = [1, 1, 1, 1]
strides = [1, 1, 1, 1]

tf.raw_ops.MaxPoolGradWithArgmax(
  input=input, grad=grad, argmax=argmax, ksize=ksize, strides=strides,
  padding='SAME', include_batch_in_index=False)
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/ef0c008ee84bad91ec6725ddc42091e19a30cf0e/tensorflow/core/kernels/maxpooling_op.cc#L1016-L1017)
uses the same value to index in two different arrays but there is no guarantee
that the sizes are identical.

### Patches
We have patched the issue in GitHub commit
[dcd7867de0fea4b72a2b34bd41eb74548dc23886](https://github.com/tensorflow/tensorflow/commit/dcd7867de0fea4b72a2b34bd41eb74548dc23886).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Ying Wang and Yakun Zhang of Baidu
X-Team.
