// Copyright 2022 The TensorFlow Runtime Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// RUN: lhlo-tfrt-opt %s -lmhlo-to-jitrt | FileCheck %s

// CHECK: @add_and_mul(
// CHECK:   %[[ARG0:[a-z0-9]+]]: memref<4x4xf32>,
// CHECK:   %[[ARG1:[a-z0-9]+]]: memref<4x4xf32>,
// CHECK:   %[[ARG2:[a-z0-9]+]]: memref<4x4xf32>,
// CHECK:   %[[ARG3:[a-z0-9]+]]: memref<4x4xf32>
// CHECK: )
func.func @add_and_mul(%arg0: memref<4x4xf32>, %arg1: memref<4x4xf32>,
                  %arg2: memref<4x4xf32>, %arg3: memref<4x4xf32>) {
  // CHECK: call @[[LAUNCH:[_a-z]+]]
  // CHECK-SAME: ptx = "//\0A// Generated by LLVM NVPTX Back-End
  "lmhlo.fusion"() ({
    %4 = bufferization.to_tensor %arg0 : memref<4x4xf32>
    %5 = bufferization.to_tensor %arg1 : memref<4x4xf32>
    %6 = bufferization.to_tensor %arg2 : memref<4x4xf32>
    %7 = mhlo.add %5, %6 : tensor<4x4xf32>
    %8 = mhlo.multiply %7, %4 : tensor<4x4xf32>
    memref.tensor_store %8, %arg3 : memref<4x4xf32>
    "lmhlo.terminator"() : () -> ()
  }) : () -> ()

  // CHECK: return
  "lmhlo.terminator"() : () -> ()
}

// CHECK: func private @[[LAUNCH]](i32, i32, i32, i32, i32, i32,
// CHECK-SAME: memref<4x4xf32>, memref<4x4xf32>, memref<4x4xf32>,
// CHECK-SAME: memref<4x4xf32>)
// CHECK-SAME: attributes {rt.direct_custom_call = "xla.gpu.func.launch"}
