## TFSA-2022-004: Integer overflow in shape inference for `Dequantize`

### CVE Number
CVE-2022-21727

### Impact
The [implementation of shape inference for `Dequantize`](https://github.com/tensorflow/tensorflow/blob/5100e359aef5c8021f2e71c7b986420b85ce7b3d/tensorflow/core/ops/array_ops.cc#L3001-L3034) is vulnerable to an integer overflow weakness:

```python
import tensorflow as tf

input = tf.constant([1,1],dtype=tf.qint32)

@tf.function
def test():
  y = tf.raw_ops.Dequantize(
    input=input,
    min_range=[1.0],
    max_range=[10.0],
    mode='MIN_COMBINED',
    narrow_range=False,
    axis=2**31-1,
    dtype=tf.bfloat16)
  return y

test()
```

The `axis` argument can be `-1` (the default value for the optional argument) or any other positive value at most the number of dimensions of the input. Unfortunately, the upper bound is not checked, and, since the code computes `axis + 1`, an attacker can trigger an integer overflow:

```cc
  int axis = -1;
  Status s = c->GetAttr("axis", &axis);
  // ...
  if (axis < -1) {
    return errors::InvalidArgument("axis should be at least -1, got ",
                                   axis);
  }
  // ...
  if (axis != -1) {
    ShapeHandle input;
    TF_RETURN_IF_ERROR(c->WithRankAtLeast(c->input(0), axis + 1, &input));
    // ...
  }
```

### Patches
We have patched the issue in GitHub commit [b64638ec5ccaa77b7c1eb90958e3d85ce381f91b](https://github.com/tensorflow/tensorflow/commit/b64638ec5ccaa77b7c1eb90958e3d85ce381f91b).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Yu Tian of Qihoo 360 AIVul Team.
