# TensorFlow Security Advisories

C++ fuzzing: [![Fuzzing Status](https://oss-fuzz-build-logs.storage.googleapis.com/badges/tensorflow.svg)](https://bugs.chromium.org/p/oss-fuzz/issues/list?sort=-opened&can=1&q=proj:tensorflow)

Python fuzzing: [![Fuzzing Status](https://oss-fuzz-build-logs.storage.googleapis.com/badges/tensorflow-py.svg)](https://bugs.chromium.org/p/oss-fuzz/issues/list?sort=-opened&can=1&q=proj:tensorflow-py)

We regularly publish security advisories about using TensorFlow.

*Note*: In conjunction with these security advisories, we strongly encourage
TensorFlow users to read and understand TensorFlow's security model as outlined
in
[SECURITY.md](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md).

| Advisory Number                                                                                                     | Type                                                                               | Versions affected   | Reported by                                                                        | Additional Information
| ------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------- | :-----------------: | ---------------------------------------------------------------------------------- | --------------------------------------------------------------
| [TFSA-2022-084](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-084.md) | Heap buffer overflow due to incorrect hash function                                | == 2.8.0            | (discovered internally)                                                            |
| [TFSA-2022-083](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-083.md) | Type confusion leading to `CHECK`-failure based denial of service                  | < 2.9.0             | (Reported on GitHub)                                                               | [issue](https://github.com/tensorflow/tensorflow/issues/55530)
| [TFSA-2022-082](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-082.md) | Incomplete validation in signal ops leads to crashes                               | < 2.9.0             | (Reported on GitHub)                                                               | [issue](https://github.com/tensorflow/tensorflow/issues/55263)
| [TFSA-2022-081](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-081.md) | Core dump when loading TFLite models with quantization                             | < 2.9.0             | (Reported on GitHub)                                                               | [issue](https://github.com/tensorflow/tensorflow/issues/43661)
| [TFSA-2022-080](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-080.md) | Segfault if `tf.histogram_fixed_width` is called with NaN values                   | < 2.9.0             | (Reported on GitHub)                                                               | [issue](https://github.com/tensorflow/tensorflow/issues/45770)
| [TFSA-2022-079](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-079.md) | Denial of service in `tf.ragged.constant` due to lack of validation                | < 2.9.0             | (Reported on GitHub)                                                               | [issue](https://github.com/tensorflow/tensorflow/issues/55199)
| [TFSA-2022-078](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-078.md) | Missing validation causes denial of service via `Conv3DBackpropFilterV2`           | < 2.9.0             | (Reported on GitHub)                                                               | [issue](https://github.com/tensorflow/tensorflow/issues/55305)
| [TFSA-2022-077](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-077.md) | Segfault and OOB write due to incomplete validation in `EditDistance`              | < 2.9.0             | Neophytos Christou, Secure Systems Lab, Brown University                           |
| [TFSA-2022-076](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-076.md) | Integer overflow in `SpaceToBatchND`                                               | < 2.9.0             | Neophytos Christou, Secure Systems Lab, Brown University                           |
| [TFSA-2022-075](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-075.md) | Missing validation results in undefined behavior in `QuantizedConv2D`              | < 2.9.0             | Neophytos Christou, Secure Systems Lab, Brown University                           |
| [TFSA-2022-074](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-074.md) | Missing validation results in undefined behavior in `SparseTensorDenseAdd`         | < 2.9.0             | Neophytos Christou, Secure Systems Lab, Brown University                           |
| [TFSA-2022-073](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-073.md) | Segfault due to missing support for quantized types                                | < 2.9.0             | Hong Jin, Singapore Management University                                          |
| [TFSA-2022-072](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-072.md) | Undefined behavior when users supply invalid resource handles                      | < 2.9.0             | Hong Jin, Singapore Management University                                          |
| [TFSA-2022-071](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-071.md) | `CHECK` failure in depthwise ops via overflows                                     | < 2.9.0             | Neophytos Christou, Secure Systems Lab, Brown University                           |
| [TFSA-2022-070](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-070.md) | Missing validation causes denial of service via `Conv3DBackpropFilterV2`           | < 2.9.0             | Neophytos Christou, Secure Systems Lab, Brown University                           |
| [TFSA-2022-069](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-069.md) | Missing validation causes denial of service via `LSTMBlockCell`                    | < 2.9.0             | Neophytos Christou, Secure Systems Lab, Brown University                           |
| [TFSA-2022-068](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-068.md) | Missing validation causes denial of service via `SparseTensorToCSRSparseMatrix`    | < 2.9.0             | Neophytos Christou, Secure Systems Lab, Brown University                           |
| [TFSA-2022-067](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-067.md) | Missing validation causes denial of service via `LoadAndRemapMatrix`               | < 2.9.0             | Neophytos Christou, Secure Systems Lab, Brown University                           |
| [TFSA-2022-066](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-066.md) | Missing validation causes denial of service via `UnsortedSegmentJoin`              | < 2.9.0             | Neophytos Christou, Secure Systems Lab, Brown University                           |
| [TFSA-2022-065](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-065.md) | Missing validation causes denial of service via `StagePeek`                        | < 2.9.0             | Neophytos Christou, Secure Systems Lab, Brown University                           |
| [TFSA-2022-064](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-064.md) | Missing validation causes denial of service via `GetSessionTensor`                 | < 2.9.0             | Neophytos Christou, Secure Systems Lab, Brown University                           |
| [TFSA-2022-063](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-063.md) | Missing validation causes denial of service via `DeleteSessionTensor`              | < 2.9.0             | Neophytos Christou, Secure Systems Lab, Brown University                           |
| [TFSA-2022-062](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-062.md) | Missing validation crashes `QuantizeAndDequantizeV4Grad`                           | < 2.9.0             | Neophytos Christou, Secure Systems Lab, Brown University                           |
| [TFSA-2022-061](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-061.md) | Missing validation causes `TensorSummaryV2` to crash                               | < 2.9.0             | Neophytos Christou, Secure Systems Lab, Brown University and Hong Jin, Singapore Management University|
| [TFSA-2022-060](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-060.md) | Code injection in `saved_model_cli`                                                | < 2.9.0             | Andey Robins, Cybersecurity Education and Research Lab, University of Wyoming      |
| [TFSA-2022-059](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-059.md) | Null pointer dereference in `BuildXlaCompilationCache` (XLA)                       | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-058](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-058.md) | Segfault in `simplifyBroadcast` (MLIR)                                             | == 2.8.0            | (discovered internally)                                                            |
| [TFSA-2022-057](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-057.md) | Multiple crashes, heap OOB accesses in TFG dialect (MLIR)                          | >= 2.7.0, < 2.8.0   | (discovered internally)                                                            |
| [TFSA-2022-056](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-056.md) | Crash due to erroneous `StatusOr`                                                  | >= 2.7.0, < 2.8.0   | (discovered internally)                                                            |
| [TFSA-2022-055](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-055.md) | Heap OOB access in `RunForwardTypeInference`                                       | == 2.8.0            | (discovered internally)                                                            |
| [TFSA-2022-054](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-054.md) | Stack overflow due to self-recursive function in `GraphDef`                        | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-053](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-053.md) | `CHECK` failure in constant folding                                                | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-052](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-052.md) | Null pointer dereference in Grappler's `IsConstant`                                | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-051](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-051.md) | Integer overflow in Grappler cost estimation of crop and resize operation          | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-050](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-050.md) | `CHECK`-fails due to attempting to build a reference tensor                        | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-049](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-049.md) | Multiple `CHECK`-fails in `function.cc`                                            | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-048](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-048.md) | Memory leak in decoding PNG images                                                 | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-047](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-047.md) | Use after free in `DecodePng` kernel                                               | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-046](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-046.md) | `CHECK`-failures in binary ops due to type confusion                               | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-045](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-045.md) | `CHECK`-failures in `TensorByteSize`                                               | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-044](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-044.md) | `CHECK`-failures during Grappler's `SafeToRemoveIdentity`                          | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-043](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-043.md) | `CHECK`-failures during Grappler's `IsSimplifiableReshape`                         | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-042](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-042.md) | Abort caused by allocating a vector that is too large                              | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-041](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-041.md) | Memory leak when a graph node is invalid                                           | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-040](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-040.md) | Null dereference in `GetInitOp`                                                    | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-039](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-039.md) | Integer overflow in `OpLevelCostEstimator::CalculateOutputSize`                    | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-038](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-038.md) | Integer overflow in `OpLevelCostEstimator::CalculateTensorSize`                    | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-037](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-037.md) | Unitialized variable access in `AssignOp`                                          | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-036](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-036.md) | Heap OOB read/write in `SpecializeType`                                            | >= 2.6.0, < 2.8.0   | (discovered internally)                                                            |
| [TFSA-2022-035](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-035.md) | Crash when type cannot be specialized                                              | >= 2.6.0, < 2.8.0   | (discovered internally)                                                            |
| [TFSA-2022-034](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-034.md) | Null-dereference when specializing tensor type                                     | >= 2.6.0, < 2.8.0   | (discovered internally)                                                            |
| [TFSA-2022-033](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-033.md) | `CHECK`-fail when decoding invalid tensors from proto                              | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-032](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-032.md) | Heap OOB write in Grappler                                                         | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-031](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-031.md) | `CHECK`-fail with repeated `AttrDef`                                               | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-030](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-030.md) | `CHECK`-fail when decoding resource handles from proto                             | < 2.8.0             | (discovered internally)                                                            |
| [TFSA-2022-029](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-029.md) | Missing validation causes `tf.sparse.split` to crash when `axis` is a tuple        | < 2.8.0             | (Reported on GitHub)                                                               | [issue](https://github.com/tensorflow/tensorflow/issues/53660)
| [TFSA-2022-028](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-028.md) | Integer overflow in Range resulting in undefined behavior and OOM                  | < 2.8.0             | (Reported on GitHub)                                                               | [issue](https://github.com/tensorflow/tensorflow/issues/52676)
| [TFSA-2022-027](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-027.md) | Insecure temporary file                                                            | < 2.8.0             | Srikanth Prathi on huntr.dev, internal variant analysis for more fixes             |
| [TFSA-2022-026](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-026.md) | Read and Write outside of bounds in TFLite                                         | < 2.8.0             | Wang Xuan of Qihoo 360 AIVul Team                                                  |
| [TFSA-2022-025](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-025.md) | Dangerous OOB write in TFLite                                                      | < 2.8.0             | Wang Xuan of Qihoo 360 AIVul Team                                                  |
| [TFSA-2022-024](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-024.md) | Integer overflow in TFLite                                                         | < 2.8.0             | Wang Xuan of Qihoo 360 AIVul Team                                                  |
| [TFSA-2022-023](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-023.md) | Integer overflow in TFLite array creation                                          | < 2.8.0             | Wang Xuan of Qihoo 360 AIVul Team                                                  |
| [TFSA-2022-022](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-022.md) | FPE in depthwise convolutions in TFLite                                            | < 2.8.0             | Wang Xuan of Qihoo 360 AIVul Team                                                  |
| [TFSA-2022-021](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-021.md) | FPE in `BiasAndClamp` in TFLite                                                    | < 2.8.0             | Wang Xuan of Qihoo 360 AIVul Team                                                  |
| [TFSA-2022-020](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-020.md) | Heap overflow in `SparseCountSparseOutput`                                         | < 2.8.0             | Faysal Hossain Shezan from University of Virginia                                  |
| [TFSA-2022-019](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-019.md) | Integer overflow leading to crash in `SparseCountSparseOutput`                     | < 2.8.0             | Faysal Hossain Shezan from University of Virginia                                  |
| [TFSA-2022-018](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-018.md) | Reference binding to null pointer in `QuantizedMaxPool`                            | < 2.8.0             | Faysal Hossain Shezan from University of Virginia                                  |
| [TFSA-2022-017](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-017.md) | Assertion failure based denial of service via faulty bin count operations          | < 2.8.0             | Faysal Hossain Shezan from University of Virginia                                  |
| [TFSA-2022-016](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-016.md) | Undefined behavior in `SparseTensorSliceDataset`                                   | < 2.8.0             | Faysal Hossain Shezan from University of Virginia                                  |
| [TFSA-2022-015](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-015.md) | `CHECK`-fails when building invalid/overflowing tensor shapes                      | < 2.8.0             | Faysal Hossain Shezan from University of Virginia                                  |
| [TFSA-2022-014](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-014.md) | Division by zero in `FractionalMaxPool`                                            | < 2.8.0             | Faysal Hossain Shezan from University of Virginia                                  |
| [TFSA-2022-013](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-013.md) | `CHECK`-failures in `MapStage`                                                     | < 2.8.0             | Faysal Hossain Shezan from University of Virginia                                  |
| [TFSA-2022-012](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-012.md) | Integer overflows in `AddManySparseToTensorsMap`                                   | < 2.8.0             | Faysal Hossain Shezan from University of Virginia                                  |
| [TFSA-2022-011](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-011.md) | Integer overflows in most sparse component-wise ops                                | < 2.8.0             | Faysal Hossain Shezan from University of Virginia                                  |
| [TFSA-2022-010](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-010.md) | More incomplete validation in boosted trees code                                   | < 2.8.0             | Yu Tian of Qihoo 360 AIVul Team, Faysal Hossain Shezan from University of Virginia |
| [TFSA-2022-009](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-009.md) | OOM due to integer overflow in `StringNGrams`                                      | < 2.8.0             | Yu Tian of Qihoo 360 AIVul Team                                                    |
| [TFSA-2022-008](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-008.md) | OOM in `ThreadPoolHandle`                                                          | < 2.8.0             | Yu Tian of Qihoo 360 AIVul Team                                                    |
| [TFSA-2022-007](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-007.md) | Type confusion in shape inference for `ConcatV2`                                   | < 2.8.0             | Yu Tian of Qihoo 360 AIVul Team                                                    |
| [TFSA-2022-006](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-006.md) | Overflow and divide by zero in `UnravelIndex`                                      | < 2.8.0             | Yu Tian of Qihoo 360 AIVul Team                                                    |
| [TFSA-2022-005](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-005.md) | Heap OOB access in `FractionalAvgPoolGrad`                                         | < 2.8.0             | Yu Tian of Qihoo 360 AIVul Team                                                    |
| [TFSA-2022-004](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-004.md) | Integer overflow in shape inference for `Dequantize`                               | < 2.8.0             | Yu Tian of Qihoo 360 AIVul Team                                                    |
| [TFSA-2022-003](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-003.md) | Heap OOB access in `Dequantize`                                                    | < 2.8.0             | Yu Tian of Qihoo 360 AIVul Team                                                    |
| [TFSA-2022-002](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-002.md) | Heap OOB read in shape inference for `ReverseSequence`                             | < 2.8.0             | Yu Tian of Qihoo 360 AIVul Team                                                    |
| [TFSA-2022-001](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2022-001.md) | Floating point division by 0 when executing convolution operators                  | < 2.8.0             | Yu Tian of Qihoo 360 AIVul Team                                                    |
| [TFSA-2021-200](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-200.md) | Crash in `tf.math.segment_*` operations                                            | < 2.7.0             | (Reported on GitHub)                                                               | [issue](https://github.com/tensorflow/tensorflow/issues/46888)
| [TFSA-2021-199](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-199.md) | Crash in `max_pool3d` when size argument is 0 or negative                          | < 2.7.0             | (Reported on GitHub)                                                               | [issue](https://github.com/tensorflow/tensorflow/issues/51936)
| [TFSA-2021-198](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-198.md) | Crashes due to overflow and `CHECK`-fail in ops with large tensor shapes           | < 2.7.0             | (Reported on GitHub)                                                               | [issue](https://github.com/tensorflow/tensorflow/issues/46890), [issue](https://github.com/tensorflow/tensorflow/issues/51618), [issue](https://github.com/tensorflow/tensorflow/issues/51908)
| [TFSA-2021-197](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-197.md) | Incomplete validation in `tf.summary.create_file_writer`                           | < 2.7.0             | (Reported on GitHub)                                                               | [issue](https://github.com/tensorflow/tensorflow/issues/46909)
| [TFSA-2021-196](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-196.md) | Overflow/crash in `tf.tile` when tiling tensor is large                            | < 2.7.0             | (Reported on GitHub)                                                               | [issue](https://github.com/tensorflow/tensorflow/issues/46911)
| [TFSA-2021-195](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-195.md) | Overflow/crash in `tf.image.resize` when size is large                             | < 2.7.0             | (Reported on GitHub)                                                               | [issue](https://github.com/tensorflow/tensorflow/issues/46914)
| [TFSA-2021-194](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-194.md) | Overflow/crash in `tf.range`                                                       | < 2.7.0             | (Reported on GitHub)                                                               | [issue](https://github.com/tensorflow/tensorflow/issues/46912), [issue](https://github.com/tensorflow/tensorflow/issues/46899), [issue](https://github.com/tensorflow/tensorflow/issues/46889)
| [TFSA-2021-193](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-193.md) | Missing validation during checkpoint loading                                       | < 2.7.0             | (discovered internally)                                                            |
| [TFSA-2021-192](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-192.md) | Uninitialized access in `EinsumHelper::ParseEquation`                              | < 2.7.0             | (discovered internally)                                                            |
| [TFSA-2021-191](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-191.md) | Segfault while copying constant resource tensor                                    | < 2.7.0             | (discovered internally)                                                            |
| [TFSA-2021-190](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-190.md) | Incomplete validation of shapes in multiple TF ops                                 | < 2.7.0             | (discovered internally)                                                            |
| [TFSA-2021-189](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-189.md) | Incomplete validation in boosted trees code                                        | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-188](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-188.md) | Heap OOB read in `tf.raw_ops.SparseCountSparseOutput`                              | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-187](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-187.md) | FPE in convolutions with zero size filters                                         | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-186](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-186.md) | FPE in `ParallelConcat`                                                            | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-185](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-185.md) | Heap OOB read in all `tf.raw_ops.QuantizeAndDequantizeV*` ops                      | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-184](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-184.md) | Heap OOB in shape inference for `QuantizeV2`                                       | >= 2.6.0, < 2.7.0   | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-183](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-183.md) | Heap OOB read in `tf.ragged.cross`                                                 | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-182](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-182.md) | Reference binding to `nullptr` in `tf.ragged.cross`                                | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-181](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-181.md) | Null pointer exception in `DeserializeSparse`                                      | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-180](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-180.md) | Deadlock in mutually recursive `tf.function` objects                               | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-179](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-179.md) | Heap buffer overflow in `Transpose`                                                | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-178](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-178.md) | Undefined behavior via `nullptr` reference binding in sparse matrix multiplication | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-177](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-177.md) | Use after free / memory leak in `CollectiveReduceV2`                               | >= 2.6.0, < 2.7.0   | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-176](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-176.md) | Integer division by 0 in `tf.raw_ops.AllToAll`                                     | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-175](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-175.md) | Null pointer exception when `Exit` node is not preceded by `Enter` op              | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-174](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-174.md) | Access to invalid memory during shape inference in `Cudnn*` ops                    | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-173](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-173.md) | Segfault due to negative splits in `SplitV`                                        | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-172](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-172.md) | `SparseFillEmptyRows` heap OOB                                                     | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-171](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-171.md) | Heap OOB in `SparseBinCount`                                                       | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-170](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-170.md) | Arbitrary memory read in `ImmutableConst`                                          | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-169](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-169.md) | Heap OOB in `FusedBatchNorm` kernels                                               | < 2.7.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-168](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-168.md) | A use of uninitialized value vulnerability in Tensorflow                           | < 2.7.0             | Qian Feng from Baidu Security Team                                                 |
| [TFSA-2021-167](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-167.md) | Code injection in `saved_model_cli`                                                | < 2.7.0             | Omer Kaspi from Vdoo                                                               |
| [TFSA-2021-166](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-166.md) | Use after free and segfault in shape inference functions                           | < 2.6.0             | (discovered internally)                                                            |
| [TFSA-2021-165](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-165.md) | Segfault on strings tensors with mismatched dimensions, due to Go code             | >=2.5.0, < 2.6.0    | (Reported on GitHub)                                                               | [PR](https://github.com/tensorflow/tensorflow/pull/50508)
| [TFSA-2021-164](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-164.md) | FPE in LSH in TFLite                                                               | < 2.6.0             | Yakun Zhang of Baidu Security                                                      |
| [TFSA-2021-163](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-163.md) | Null pointer dereference in TFLite MLIR optimizations                              | < 2.6.0             | Yakun Zhang of Baidu Security                                                      |
| [TFSA-2021-162](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-162.md) | Null pointer dereference in TFLite                                                 | < 2.6.0             | Yakun Zhang of Baidu Security                                                      |
| [TFSA-2021-161](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-161.md) | Heap OOB in TFLite's `Gather*` implementations                                     | < 2.6.0             | Yakun Zhang of Baidu Security                                                      |
| [TFSA-2021-160](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-160.md) | Heap OOB in TFLite                                                                 | < 2.6.0             | Yakun Zhang of Baidu Security                                                      |
| [TFSA-2021-159](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-159.md) | Infinite loop in TFLite                                                            | == 2.6.0            | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-158](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-158.md) | FPE in TFLite pooling operations                                                   | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-157](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-157.md) | FPE in TFLite division operations                                                  | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-156](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-156.md) | Use of unitialized value in TFLite                                                 | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-155](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-155.md) | NPE in TFLite                                                                      | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-154](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-154.md) | Division by zero in TFLite                                                         | < 2.6.0             | Aivul Team from Qihoo 360, Yakun Zhang of Baidu Security                           |
| [TFSA-2021-153](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-153.md) | Heap OOB in nested `tf.map_fn` with `RaggedTensor`s                                | < 2.6.0             | Haris Sahovic                                                                      |
| [TFSA-2021-152](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-152.md) | Arbitrary code execution due to YAML deserialization                               | < 2.6.0             | Arjun Shibu                                                                        |
| [TFSA-2021-151](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-151.md) | Missing validation in shape inference for `Dequantize`                             | < 2.6.0             | Yakun Zhang of Baidu Security                                                      |
| [TFSA-2021-150](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-150.md) | Division by 0 in most convolution operators                                        | < 2.6.0             | Yakun Zhang of Baidu Security                                                      |
| [TFSA-2021-149](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-149.md) | Reference binding to nullptr in shape inference                                    | < 2.6.0             | Yakun Zhang of Baidu Security                                                      |
| [TFSA-2021-148](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-148.md) | Incomplete validation in `MaxPoolGrad`                                             | < 2.6.0             | Yakun Zhang of Baidu Security                                                      |
| [TFSA-2021-147](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-147.md) | `CHECK`-fail in `MapStage`                                                         | < 2.6.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-146](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-146.md) | Heap OOB in `SdcaOptimizerV2`                                                      | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-145](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-145.md) | Reference binding to nullptr in map operations                                     | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-144](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-144.md) | Heap OOB in `UpperBound` and `LowerBound`                                          | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-143](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-143.md) | Crash in NMS ops caused by integer conversion to unsigned                          | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-142](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-142.md) | FPE in `tf.raw_ops.UnravelIndex`                                                   | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-141](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-141.md) | Reference binding to nullptr in unicode encoding                                   | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-140](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-140.md) | Reference binding to nullptr in `RaggedTensorToVariant`                            | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-139](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-139.md) | Incomplete validation in MKL requantization                                        | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-138](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-138.md) | Incomplete validation in `QuantizeV2`                                              | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-137](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-137.md) | Heap OOB in boosted trees                                                          | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-136](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-136.md) | Reference binding to nullptr in boosted trees                                      | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-135](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-135.md) | Crash caused by integer conversion to unsigned                                     | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-134](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-134.md) | Division by 0 in inplace operations                                                | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-133](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-133.md) | Reference binding to nullptr and heap OOB in binary cwise ops                      | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-132](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-132.md) | Reference binding to nullptr in `MatrixSetDiagV*` ops                              | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-131](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-131.md) | Reference binding to nullptr in `MatrixDiagV*` ops                                 | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-130](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-130.md) | Reference binding to nullptr in `RaggedTensorToSparse`                             | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-129](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-129.md) | Heap OOB in `ResourceScatterUpdate`                                                | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-128](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-128.md) | Heap OOB and CHECK fail in `ResourceGather`                                        | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-127](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-127.md) | Division by 0 in `ResourceGather`                                                  | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-126](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-126.md) | Use after free in boosted trees creation                                           | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-125](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-125.md) | Heap buffer overflow in `FractionalAvgPoolGrad`                                    | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-124](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-124.md) | Segfault and heap buffer overflow in `{Experimental,}DatasetToTFRecord`            | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-123](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-123.md) | Null pointer dereference in `UncompressElement`                                    | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-122](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-122.md) | Incorrect validation of `SaveV2` inputs                                            | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-121](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-121.md) | Null pointer dereference in `SparseTensorSliceDataset`                             | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-120](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-120.md) | Bad alloc in `StringNGrams` caused by integer conversion                           | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-119](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-119.md) | Integer overflow due to conversion to unsigned                                     | >=2.4.0, < 2.6.0    | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-118](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-118.md) | Null pointer dereference in `MatrixDiagPartOp`                                     | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-117](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-117.md) | `std::abort` raised from `TensorListReserve`                                       | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-116](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-116.md) | Heap OOB in `RaggedGather`                                                         | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-115](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-115.md) | Division by 0 in `ResourceScatterDiv`                                              | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-114](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-114.md) | Integer division by 0 in sparse reshaping                                          | >=2.5.0, < 2.6.0    | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-113](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-113.md) | Null pointer dereference and heap OOB read in operations restoring tensors         | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-112](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-112.md) | Null pointer dereference in `RaggedTensorToTensor`                                 | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-111](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-111.md) | Null pointer dereference in `CompressElement`                                      | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-110](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-110.md) | Floating point exception in `SparseDenseCwiseDiv`                                  | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-109](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-109.md) | Heap out of bounds access in sparse reduction operations                           | < 2.6.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-108](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-108.md) | Segfault in `tf.raw_ops.ImmutableConst`                                            | < 2.5.0             | (discovered internally)                                                            |
| [TFSA-2021-107](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-107.md) | Segfault in `tf.raw_ops.SparseCountSparseOutput`                                   | < 2.5.0             | (discovered internally)                                                            |
| [TFSA-2021-106](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-106.md) | Crash in `tf.strings.substr` due to `CHECK`-fail                                   | < 2.5.0             | (Reported on GitHub)                                                               | [issue report](https://github.com/tensorflow/tensorflow/issues/46900)
| [TFSA-2021-105](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-105.md) | Crash in `tf.transpose` with complex inputs                                        | < 2.5.0             | (Reported on GitHub)                                                               | [issue report](https://github.com/tensorflow/tensorflow/issues/46891)
| [TFSA-2021-104](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-104.md) | Null dereference in Grappler's `TrySimplify`                                       | < 2.5.0             | (discovered internally)                                                            |
| [TFSA-2021-103](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-103.md) | Stack overflow in `ParseAttrValue` with nested tensors                             | < 2.5.0             | (discovered internally)                                                            |
| [TFSA-2021-102](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-102.md) | Interpreter crash from `tf.io.decode_raw`                                          | < 2.5.0             | (discovered internally)                                                            |
| [TFSA-2021-101](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-101.md) | Incomplete validation in `tf.raw_ops.CTCLoss`                                      | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-100](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-100.md) | Heap buffer overflow in `BandedTriangularSolve`                                    | < 2.5.0             | Ye Zhang and Yakun Zhang of Baidu X-Team                                           |
| [TFSA-2021-099](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-099.md) | Invalid validation in `QuantizeAndDequantizeV2`                                    | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-098](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-098.md) | Incomplete validation in `SparseReshape`                                           | >=2.3.0, < 2.5.0    | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-097](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-097.md) | Incomplete validation in `SparseSparseMinimum`                                     | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-096](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-096.md) | Incomplete validation in `SparseAdd`                                               | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-095](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-095.md) | Heap OOB and null pointer dereference in `RaggedTensorToTensor`                    | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-094](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-094.md) | Heap OOB read in TFLite                                                            | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-093](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-093.md) | Heap OOB write in TFLite                                                           | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-092](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-092.md) | Integer overflow in TFLite memory allocation                                       | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-091](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-091.md) | Integer overflow in TFLite concatenation                                           | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-090](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-090.md) | Division by zero in TFLite's implementation of hashtable lookup                    | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-089](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-089.md) | Division by zero in TFLite's implementation of `DepthwiseConv`                     | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-088](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-088.md) | Division by zero in TFLite's implementation of `OneHot`                            | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-087](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-087.md) | Division by zero in TFLite's implementation of `Split`                             | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-086](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-086.md) | Division by zero in TFLite's implementation of `SVDF`                              | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-085](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-085.md) | Division by zero in TFLite's implementation of `SpaceToBatchNd`                    | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-084](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-084.md) | Division by zero in TFLite's implementation of `BatchToSpaceNd`                    | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-083](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-083.md) | Division by zero in TFLite's implementation of `EmbeddingLookup`                   | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-082](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-082.md) | Division by zero in TFLite's convolution code                                      | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-081](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-081.md) | Division by zero in TFLite's implementation of `DepthToSpace`                      | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-080](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-080.md) | Stack overflow due to looping TFLite subgraph                                      | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-079](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-079.md) | Null pointer dereference in TFLite's `Reshape` operator                            | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-078](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-078.md) | Heap OOB read in TFLite's implementation of `Minimum` or `Maximum`                 | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-077](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-077.md) | Division by zero in TFLite's implementation of `TransposeConv`                     | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-076](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-076.md) | Division by zero in TFLite's implementation of `GatherNd`                          | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-075](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-075.md) | Division by zero in TFLite's implementation of `SpaceToDepth`                      | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-074](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-074.md) | Division by zero in optimized pooling implementations in TFLite                    | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-073](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-073.md) | Division by zero in padding computation in TFLite                                  | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-072](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-072.md) | Heap buffer overflow and undefined behavior in `FusedBatchNorm`                    | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-071](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-071.md) | `CHECK`-fail due to integer overflow                                               | < 2.5.0             | University of Virginia and University of California, Santa Barbara                 |
| [TFSA-2021-070](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-070.md) | Heap OOB read in `tf.raw_ops.Dequantize`                                           | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-069](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-069.md) | Segfault in `CTCBeamSearchDecoder`                                                 | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-068](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-068.md) | Heap buffer overflow in `MaxPoolGrad`                                              | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-067](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-067.md) | Heap buffer overflow in `FractionalAvgPoolGrad`                                    | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-066](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-066.md) | Undefined behavior and `CHECK`-fail in `FractionalMaxPoolGrad`                     | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-065](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-065.md) | Heap buffer overflow in `AvgPool3DGrad`                                            | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-064](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-064.md) | Heap buffer overflow in `MaxPool3DGradGrad`                                        | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-063](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-063.md) | Undefined behavior in `MaxPool3DGradGrad`                                          | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-062](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-062.md) | Division by 0 in `MaxPoolGradWithArgmax`                                           | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-061](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-061.md) | Overflow/denial of service in `tf.raw_ops.ReverseSequence`                         | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-060](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-060.md) | Reference binding to nullptr in `SdcaOptimizer`                                    | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-059](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-059.md) | Memory corruption in `DrawBoundingBoxesV2`                                         | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-058](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-058.md) | Heap out of bounds read in `RequantizationRange`                                   | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-057](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-057.md) | Heap out of bounds read in `MaxPoolGradWithArgmax`                                 | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-056](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-056.md) | Lack of validation in `SparseDenseCwiseMul`                                        | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-055](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-055.md) | Reference binding to null in `ParameterizedTruncatedNormal`                        | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-054](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-054.md) | Heap OOB access in `Dilation2DBackpropInput`                                       | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-053](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-053.md) | Null pointer dereference in `SparseFillEmptyRows`                                  | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-052](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-052.md) | Null pointer dereference in `EditDistance`                                         | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-051](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-051.md) | `CHECK`-fail in `tf.raw_ops.RFFT`                                                  | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-050](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-050.md) | `CHECK`-fail in `tf.raw_ops.IRFFT`                                                 | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-049](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-049.md) | `CHECK`-fail in `LoadAndRemapMatrix`                                               | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-048](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-048.md) | Heap buffer overflow in `RaggedTensorToTensor`                                     | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-047](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-047.md) | Heap OOB access in unicode ops                                                     | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-046](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-046.md) | Heap buffer overflow in `SparseSplit`                                              | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-045](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-045.md) | Division by 0 in `Reverse`                                                         | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-044](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-044.md) | Division by 0 in `SparseMatMul`                                                    | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-043](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-043.md) | Division by 0 in `FusedBatchNorm`                                                  | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-042](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-042.md) | Division by 0 in `DenseCountSparseOutput`                                          | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-041](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-041.md) | `CHECK`-failure in `UnsortedSegmentJoin`                                           | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-040](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-040.md) | Heap OOB in `QuantizeAndDequantizeV3`                                              | < 2.5.0             | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-039](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-039.md) | OOB read in `MatrixTriangularSolve`                                                | < 2.5.0             | Ye Zhang and Yakun Zhang of Baidu X-Team                                           |
| [TFSA-2021-038](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-038.md) | Division by 0 in `FractionalAvgPool`                                               | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-037](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-037.md) | Division by 0 in `QuantizedAdd`                                                    | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-036](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-036.md) | Division by 0 in `QuantizedBatchNormWithGlobalNormalization`                       | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-035](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-035.md) | Heap out of bounds in `QuantizedBatchNormWithGlobalNormalization`                  | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-034](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-034.md) | Division by 0 in `QuantizedBiasAdd`                                                | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-033](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-033.md) | Heap buffer overflow in `SparseTensorToCSRSparseMatrix`                            | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-032](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-032.md) | `CHECK`-fail in `CTCGreedyDecoder`                                                 | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-031](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-031.md) | `CHECK`-fail in `QuantizeAndDequantizeV4Grad`                                      | >= 2.4.0, < 2.5.0   | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-030](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-030.md) | Null pointer dereference in `StringNGrams`                                         | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-029](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-029.md) | Heap buffer overflow `StringNGrams`                                                | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-028](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-028.md) | Heap buffer overflow `Conv2DBackpropFilter`                                        | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-027](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-027.md) | Division by zero in `Conv2DBackpropFilter`                                         | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-026](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-026.md) | Heap buffer overflow in `QuantizedReshape`                                         | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-025](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-025.md) | Heap buffer overflow in `QuantizedResizeBilinear`                                  | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-024](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-024.md) | `CHECK`-fail in `SparseConcat`                                                     | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-023](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-023.md) | Heap buffer overflow in `QuantizedMul`                                             | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-022](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-022.md) | `CHECK`-fail in `DrawBoundingBoxes`                                                | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-021](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-021.md) | Heap out of bounds read in `RaggedCross`                                           | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-020](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-020.md) | `CHECK`-fail in `tf.raw_ops.EncodePng`                                             | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-019](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-019.md) | Heap buffer overflow caused by rounding                                            | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-018](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-018.md) | Invalid validation in `SparseMatrixSparseCholesky`                                 | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-017](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-017.md) | Division by 0 in `QuantizedMul`                                                    | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-016](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-016.md) | Division by 0 in `QuantizedConv2D`                                                 | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-015](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-015.md) | Division by 0 in `Conv2D`                                                          | < 2.5.0             | Ying Wang and Yakun Zhang of Baidu X-Team                                          |
| [TFSA-2021-014](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-014.md) | Division by 0 in `Conv2DBackpropInput`                                             | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-013](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-013.md) | Division by 0 in `Conv2DBackpropFilter`                                            | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-012](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-012.md) | `CHECK`-fail in `AddManySparseToTensorsMap`                                        | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-011](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-011.md) | Division by 0 in `Conv3DBackprop*`                                                 | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-010](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-010.md) | Heap buffer overflow in `Conv3DBackprop*`                                          | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-009](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-009.md) | Segfault in `SparseCountSparseOutput`                                              | >= 2.3.0, < 2.5.0   | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-008](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-008.md) | `CHECK`-fail in `SparseCross` due to type confusion                                | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-007](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-007.md) | Session operations in eager mode lead to null pointer dereferences                 | >= 2.0.0, < 2.5.0   | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-006](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-006.md) | Division by zero in `Conv3D`                                                       | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-005](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-005.md) | Null pointer dereference via invalid Ragged Tensors                                | < 2.5.0             | Yakun Zhang and Ying Wang of Baidu X-Team                                          |
| [TFSA-2021-004](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-004.md) | Reference binding to null pointer in `MatrixDiag*` ops                             | < 2.5.0             | Ye Zhang and Yakun Zhang of Baidu X-Team                                           |
| [TFSA-2021-003](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-003.md) | Type confusion during tensor casts lead to dereferencing null pointers             | < 2.5.0             | Aivul Team from Qihoo 360; Ye Zhang and Yakun Zhang of Baidu X-Team                |
| [TFSA-2021-002](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-002.md) | Heap out of bounds write in `RaggedBinCount`                                       | >= 2.3.0, < 2.5.0   | Aivul Team from Qihoo 360                                                          |
| [TFSA-2021-001](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-001.md) | Heap buffer overflow in `RaggedBinCount`                                           | >= 2.3.0, < 2.5.0   | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-034](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-034.md) | Heap out of bounds access in MakeEdge                                              | >= 1.15.0, <= 2.3.0 | (discovered internally)                                                            |
| [TFSA-2020-033](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-033.md) | CHECK-fail in LSTM with zero-length input                                          | >= 1.15.0, <= 2.3.0 | (discovered internally)                                                            |
| [TFSA-2020-032](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-032.md) | Heap out of bounds read in filesystem glob matching                                | 2.4.0-rc{0,1,2,3}   | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-031](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-031.md) | Write to immutable memory region                                                   | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-030](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-030.md) | Lack of validation in data format attributes                                       | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-029](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-029.md) | Uninitialized memory access in Eigen types                                         | >= 1.15.0, <= 2.3.0 | (discovered internally)                                                            |
| [TFSA-2020-028](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-028.md) | Float cast overflow undefined behavior                                             | <= 2.3              | (Reported on GitHub)                                                               | [issue report](https://github.com/tensorflow/tensorflow/issues/42129)
| [TFSA-2020-027](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-027.md) | Segfault in `tf.quantization.quantize_and_dequantize`                              | <= 2.3              | (Reported on GitHub)                                                               | [issue report](https://github.com/tensorflow/tensorflow/issues/42105)
| [TFSA-2020-026](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-026.md) | Segfault in `tf.raw_ops.Switch` in eager mode                                      | 2.2.0, 2.3.0        | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-025](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-025.md) | Undefined behavior in `dlpack.to_dlpack`                                           | 2.2.0, 2.3.0        | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-024](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-024.md) | Memory leak in `dlpack.to_dlpack`                                                  | 2.2.0, 2.3.0        | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-023](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-023.md) | Memory corruption in `dlpack.to_dlpack`                                            | 2.2.0, 2.3.0        | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-022](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-022.md) | Crash due to invalid shape of `grad_values` in SparseFillEmptyRowsGrad             | >= 1.15.0, <= 2.3.0 | (variant analysis, Aivul Team from Qihoo 360)                                      |
| [TFSA-2020-021](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-021.md) | Heap buffer overflow in SparseFillEmptyRowsGrad                                    | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-020](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-020.md) | Heap buffer overflow in weighted sparse count ops                                  | 2.3.0               | (variant analysis, Aivul Team from Qihoo 360)                                      |
| [TFSA-2020-019](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-019.md) | Crash due to invalid splits in SparseCountSparseOutput                             | 2.3.0               | (variant analysis, Aivul Team from Qihoo 360)                                      |
| [TFSA-2020-018](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-018.md) | Heap buffer overflow due to invalid indices in SparseCountSparseOutput             | 2.3.0               | (variant analysis, Aivul Team from Qihoo 360)                                      |
| [TFSA-2020-017](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-017.md) | Abort due to invalid splits in RaggedCountSparseOutput                             | 2.3.0               | (variant analysis, Aivul Team from Qihoo 360)                                      |
| [TFSA-2020-016](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-016.md) | Segfault due to invalid splits in RaggedCountSparseOutput                          | 2.3.0               | (variant analysis, Aivul Team from Qihoo 360)                                      |
| [TFSA-2020-015](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-015.md) | Heap buffer overflow due to invalid splits in RaggedCountSparseOutput              | 2.3.0               | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-014](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-014.md) | Integer truncation in Shard API usage                                              | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-013](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-013.md) | Format-string vulnerability in TensorFlow's `as_string`                            | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-012](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-012.md) | Segfault by calling session-only ops in eager mode                                 | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-011](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-011.md) | Data leak in `tf.raw_ops.StringNGrams`                                             | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-010](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-010.md) | Incomplete validation in TensorFlow's SavedModel's constant nodes causes segfaults | >= 1.15.0, <= 2.3.0 | Shuaike Dong, Alipay Tian Qian Security Lab                                        | [issue report](https://github.com/tensorflow/tensorflow/issues/41097)
| [TFSA-2020-009](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-009.md) | Segfault and data corruption caused by negative indexing in TFLite                 | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-008](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-008.md) | Data corruption due to dimension mismatch in TFLite                                | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-007](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-007.md) | Null pointer dereference in TFLite                                                 | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360, variant analysis                                        |
| [TFSA-2020-006](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-006.md) | Segmentation fault and/or data corruption due to invalid TFLite model              | >= 1.15.0, <= 2.3.0 | (variant analysis, Aivul Team from Qihoo 360)                                      |
| [TFSA-2020-005](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-005.md) | Out of bounds access in TFLite operators                                           | >= 1.15.0, <= 2.3.0 | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-004](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-004.md) | Out of bounds access in TFLite implementation of segment sum                       | 2.2.0, 2.3.0        | (variant analysis, Aivul Team from Qihoo 360)                                      |
| [TFSA-2020-003](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-003.md) | Denial of service from TFLite implementation of segment sum                        | 2.2.0, 2.3.0        | (variant analysis, Aivul Team from Qihoo 360)                                      |
| [TFSA-2020-002](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-002.md) | Out of bounds write in TFLite implementation of segment sum                        | 2.2.0, 2.3.0        | Aivul Team from Qihoo 360                                                          |
| [TFSA-2020-001](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-001.md) | Segmentation fault when converting a Python string to `tf.float16`                 | >= 1.12.0, <= 2.1   | (found internally)                                                                 |
| [TFSA-2019-002](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2019-002.md) | Heap buffer overflow in `UnsortedSegmentSum`                                       | <= 1.14             | (found internally)                                                                 |
| [TFSA-2019-001](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2019-001.md) | Null Pointer Dereference Error in Decoding GIF Files                               | <= 1.12             | Baidu Security Lab                                                                 |
| [TFSA-2018-006](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2018-006.md) | Crafted Configuration File results in Invalid Memory Access                        | <= 1.7              | Blade Team of Tencent                                                              |
| [TFSA-2018-005](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2018-005.md) | Old Snappy Library Usage Resulting in Memcpy Parameter Overlap                     | <= 1.7              | Blade Team of Tencent                                                              |
| [TFSA-2018-004](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2018-004.md) | Checkpoint Meta File Out-of-Bounds Read                                            | <= 1.7              | Blade Team of Tencent                                                              |
| [TFSA-2018-003](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2018-003.md) | TensorFlow Lite TOCO FlatBuffer Parsing Vulnerability                              | <= 1.7              | Blade Team of Tencent                                                              |
| [TFSA-2018-002](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2018-002.md) | GIF File Parsing Null Pointer Dereference Error                                    | <= 1.5              | Blade Team of Tencent                                                              |
| [TFSA-2018-001](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2018-001.md) | BMP File Parser Out-of-bounds Read                                                 | <= 1.6              | Blade Team of Tencent                                                              |
| -                                                                                                                   | Out Of Bounds Read                                                                 | <= 1.4              | Blade Team of Tencent                                                              | [issue report](https://github.com/tensorflow/tensorflow/issues/14959)
