apply(from = "../config/quality.gradle")

plugins {
    alias(libs.plugins.androidLibrary)
    alias(libs.plugins.kotlinAndroid)
}

android {
    namespace = "org.odk.collect.mobiledevicemanagement"
    compileSdk = libs.versions.compileSdk.get().toInt()

    defaultConfig {
        minSdk = libs.versions.minSdk.get().toInt()

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
    }

    buildTypes {
        release {
            isMinifyEnabled = false
        }
    }

    compileOptions {
        isCoreLibraryDesugaringEnabled = true
        sourceCompatibility = JavaVersion.VERSION_17
        targetCompatibility = JavaVersion.VERSION_17
    }
}

dependencies {
    coreLibraryDesugaring(libs.desugar)

    implementation(project(":async"))
    implementation(project(":androidshared"))
    implementation(project(":strings"))
    implementation(project(":settings"))
    implementation(project(":shared"))
    implementation(project(":projects"))
    implementation(project(":analytics"))

    testImplementation(project(":test-shared"))
    testImplementation(libs.mockitoKotlin)
    testImplementation(libs.robolectric)
    testImplementation(libs.androidxTestExtJunit)
}
