/*
 * Decompiled with CFR 0.152.
 */
package bikramsambat;

import bikramsambat.BikramSambatDate;
import bikramsambat.BsException;
import bikramsambat.BsGregorianDate;
import bikramsambat.BsUtils;
import bikramsambat.DevanagariDigitConverter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;

public final class BsCalendar {
    private static final long BS_EPOCH_TS = -1789990200000L;
    private static final int BS_YEAR_ZERO = 1970;
    private static final long[] ENCODED_MONTH_LENGTHS = new long[]{5315258L, 5314490L, 9459438L, 8673005L, 5315258L, 5315066L, 9459438L, 8673005L, 5315258L, 5314298L, 9459438L, 5327594L, 5315258L, 5314298L, 9459438L, 5327594L, 5315258L, 5314286L, 9459438L, 5315306L, 5315258L, 5314286L, 8673006L, 5315306L, 5315258L, 5265134L, 8673006L, 5315258L, 5315258L, 9459438L, 8673005L, 5315258L, 5314298L, 9459438L, 8673005L, 5315258L, 5314298L, 9459438L, 8473322L, 5315258L, 5314298L, 9459438L, 5327594L, 5315258L, 5314298L, 9459438L, 5327594L, 5315258L, 5314286L, 8673006L, 5315306L, 5315258L, 5265134L, 8673006L, 5315306L, 5315258L, 9459438L, 8673005L, 5315258L, 5314490L, 9459438L, 8673005L, 5315258L, 5314298L, 9459438L, 8473325L, 5315258L, 5314298L, 9459438L, 5327594L, 5315258L, 5314298L, 9459438L, 5327594L, 5315258L, 5314286L, 9459438L, 5315306L, 5315258L, 5265134L, 8673006L, 5315306L, 5315258L, 5265134L, 8673006L, 5315258L, 5314490L, 9459438L, 8673005L, 5315258L, 5314298L, 9459438L, 8669933L, 5315258L, 5314298L, 9459438L, 8473322L, 5315258L, 5314298L, 9459438L, 5327594L, 5315258L, 5314286L, 9459438L, 5315306L, 5315258L, 5265134L, 8673006L, 5315306L, 5315258L, 5265134L, 8673006L, 5315258L, 5527226L, 5527226L, 5528046L, 5527277L, 5528250L, 5528057L, 5527277L, 5527277L};
    private static final BsCalendar instance = new BsCalendar();
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final long MS_PER_DAY = 86400000L;
    private static final String[] _MONTH_NAMES = new String[]{"\u092c\u0948\u0936\u093e\u0916", "\u091c\u0947\u0920", "\u0905\u0938\u093e\u0930", "\u0938\u093e\u0909\u0928", "\u092d\u0926\u094c", "\u0905\u0938\u094b\u091c", "\u0915\u093e\u0930\u094d\u0924\u093f\u0915", "\u092e\u0902\u0938\u093f\u0930", "\u092a\u094c\u0937", "\u092e\u093e\u0918", "\u092b\u093e\u0932\u094d\u0917\u0941\u0928", "\u091a\u0948\u0924"};
    public static final List<String> MONTH_NAMES = Collections.unmodifiableList(Arrays.asList(_MONTH_NAMES));
    private DevanagariDigitConverter devanagari = DevanagariDigitConverter.getInstance();

    private BsCalendar() {
    }

    public static BsCalendar getInstance() {
        return instance;
    }

    public int daysInMonth(int year, int month) throws BsException {
        if (month < 1 || month > 12) {
            throw new BsException(String.format("Month does not exist: %s", month));
        }
        try {
            return 29 + (int)(ENCODED_MONTH_LENGTHS[year - 1970] >>> (month - 1 << 1) & 3L);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new BsException(String.format("Unsupported year/month combination: %s/%s", year, month));
        }
    }

    public BsGregorianDate toGreg(BikramSambatDate bik) throws BsException {
        int year;
        int month = bik.month;
        int day = bik.day;
        if (month < 1) {
            throw new BsException("Invalid month value " + month);
        }
        if (year < 1970) {
            throw new BsException("Invalid year value " + year);
        }
        if (day < 1 || day > this.daysInMonth(year, month)) {
            throw new BsException("Invalid day value " + day);
        }
        long timestamp = -1789990200000L + 86400000L * (long)day;
        --month;
        for (year = bik.year; year >= 1970; --year) {
            while (month > 0) {
                timestamp += 86400000L * (long)this.daysInMonth(year, month);
                --month;
            }
            month = 12;
        }
        Calendar c = Calendar.getInstance(GMT);
        c.setTimeInMillis(timestamp);
        return new BsGregorianDate(c.get(1), 1 + c.get(2), c.get(5));
    }

    public String toBik_euro(String greg) throws BsException {
        BikramSambatDate d = this.toBik(greg);
        return d.year + "-" + BsUtils.zPad(d.month) + "-" + BsUtils.zPad(d.day);
    }

    public String toBik_dev(String greg) throws BsException {
        return this.devanagari.toDev(this.toBik_euro(greg));
    }

    public String toBik_text(String greg) throws BsException {
        BikramSambatDate d = this.toBik(greg);
        return this.devanagari.toDev(d.day) + " " + _MONTH_NAMES[d.month - 1] + " " + this.devanagari.toDev(d.year);
    }

    public BikramSambatDate toBik(BsGregorianDate greg) throws BsException {
        return this.toBik(greg.year, greg.month, greg.day);
    }

    public BikramSambatDate toBik(int year, int month, int day) throws BsException {
        return this.toBik(year + "-" + BsUtils.zPad(month) + "-" + BsUtils.zPad(day));
    }

    private BikramSambatDate toBik(String greg) throws BsException {
        int days;
        int year = 1970;
        try {
            days = (int)Math.floor((this.parseDate(greg) - -1789990200000L) / 86400000L) + 1;
        }
        catch (ParseException ex) {
            throw new BsException("Unable to parse gregorian date: " + greg, ex);
        }
        while (days > 0) {
            for (int m = 1; m <= 12; ++m) {
                int dM = this.daysInMonth(year, m);
                if (days <= dM) {
                    return new BikramSambatDate(year, m, days);
                }
                days -= dM;
            }
            ++year;
        }
        throw new BsException("Date outside supported range: " + greg + " AD");
    }

    private long parseDate(String date) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setTimeZone(GMT);
        return dateFormat.parse(date).getTime();
    }
}

