require 'openssl'

describe "OpenSSL::PKey::RSA.new" do
  it "constructs a private key with correct value" do
    key = "-----BEGIN RSA PRIVATE KEY-----\nProc-Type: 4,ENCRYPTED\nDEK-Info: DES-EDE3-CBC,212892DF3709856D\n\nxGMDk+el+eTIKK579whf6BM6uVu9XDWKFi9E9JVUo0NqzlbuTgEmhdEXsSUu+di2\nOOg3O4yckqMGVRFeLvuwNfL1t+wJIa4RhE23d4nk/n0PINDEQKtQU1HmMCVuOrXH\nHmsjTdShzB4sUFTxxKXybZkecdrH9lHb9sDGIR0M9soaPUhhnb1aoZ+2hlyy++eH\nh3zL1W+J0a3OK64Oh1GZNgSyrZMiVAhfd7gnrOt6sy6PH0EEJgn1H1MJpfmmgc+D\n+KlnFvivmpRT5jyIJyd0uWHA/Y4jZwZKoL9QN1jeDRlquWhrbKaKUSF0A2jRrW7W\n7vErmzs7S/GQLXtu/RqztT7BBWeCHx6wpeDy6FzpMcYlspfHOVbrNs7pZyK1Zw4E\n9YfTbjaMvtT+VaBB9WheiZ7+UWR59usB3u3mMK50yYf3CXW4BM7gnKP9/r3Pm6Xh\nXKKHxHwr3TcaT7vNZavwMQfrw/ngnVoS1kLNec7C5Sfwcy/0FsAESrIOoI7xj/0m\n+wyqmJZZXTQtn04I7MFF7RZ8evmbRcLJ5dFAke83GB4SR9dFu4Fbgv3juP/yjyZ/\nIpZmpBdPUdkWQjL61R5WMHwrnnK+QUvCmL/A3Jdxn81qk3gNleaF93f54esrdQo5\nLMsKc1Q+QGA/N1QW1tCcSpLUsOx/0ohYQiAaZZ6JpNp3szkVPQLV2hYwgWraLlJi\nYqVKTFXL3z9Q2SVYDkMqBwrVfHQ1fvZbWRH4CTw4yOIYaiOO7fIoduu2mmz8hUgc\n9xKe0jDKX0OnJ6M0No/+24YAT1gbJAaaH84CUhxNIOJTvtIJ7LJjyREAaO64HPT3\nbQ6Pk8aleBzxSOTXclfC9ArtOVEqG00BkZYqXb6axq7udnTJYvmI83mWzONQGOlM\nLswZKv6s4AOCBJKY5KJeKxlGrrh31cvH3sr7njCWKmM5/94kcv0SbiBeaiam4cDO\nvsT8Le3kkLtRD1027/r5+8UPiau3EpGSIxCJkMv8ELC7OkBuYwlytylECHunU820\npU9g1xuu/cw5kJ6AlIq2z9Gaa0sEIodljyn3B56ud71zO427vvvEUVEMlXyy1id4\nofCoMuv7Z185podBO6lhjDYW6ygUqNESPw4HqO86aL1Pw/n65T/I1Q7ss0SMh20i\nazN7NTZTGNTSJQZqbb8WmcqMmSaDPqdUz8HMRe+veFKgwSJDnsUr/ez2JUMofpjI\n2PBcGF5OXx92hPo3+905X9lUUjO8pbJ6WRz/ss/1ZfydCsbc4abJJLQRdrezFxmu\neBfMpKhinaubfJ+HjtH9zuGKSlHX58kvIWl0msbJr7Z0/S9YyP72mFKav6KtBF1b\naQVUBx/ggVNsj0ALxOg+FFLE46lx8+bcVqWFFBcUr7sACxVYfVukdjrPfP6/lxQ8\nDISvm9nXOvZEATeR+2u5Jx7e7DjGvir0JgpJEEcKd1GMD+9K3Sz+VduUzEoes4Mj\nNF26rTpsqL4e/f3yHaBk2cMnpUzQOyJ5yYTLBdLs2gQMjKXyCm9GatKPrih+OFSZ\nQTj5Bz12T5yHRA1ywYMJ42az86xaNEFbgWmZCl28nWoP00MtA50ONA==\n-----END RSA PRIVATE KEY-----\n-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6lrHgcOozilAzYNxTcg3\n0VE+gl43J6t3Z5cGsEEOkelOzvwVCWKzMczw8pXpb1fW2AxznRFI9jy3/2a0sKQV\nIslMwQhzDy6EYpJ/alnAQJVryTQVljUXLjrMgckXJ2qscWsnCiWGyPR3sY3CFDFJ\n2XOb30c6DySlgbsLHAsEDIZGlsVql5vDBHpQNgNsv9jYGHj8fDIzn/eWTetMRJPV\nIT4KytIu5oM3BDJjaBBQBpCJu6gZzYRloIU58l4pDbMarisKMj7UK08AMp7D9dZl\ngY+cnN8H/otn751E+YaUMyzvkbKZMCLv4VZxAEW7YgDv1ZcSr+HIn3IJqVA5HbNa\n7QIDAQAB\n-----END PUBLIC KEY-----\n"
    finished_key = OpenSSL::PKey::RSA.new(key, 'password')
    finished_key.to_s.length.should == 1675
  end
end
