## data-man Public API ##

A data manager, allowing you to attach various types of data and get it back in various other types

_API documentation automatically generated by [docmeteor](https://github.com/raix/docmeteor)._

-

### <a name="DataMan"></a>new DataMan(data, [type])&nbsp;&nbsp;<sub><i>Client</i></sub> ###


__Arguments__

* __data__ *{[File](#File)|[Blob](#Blob)|ArrayBuffer|Uint8Array|String}*  

 The data that you want to manipulate.

* __type__ *{String}*  (Optional)

 The data content (MIME) type, if known. Required if the first argument is an ArrayBuffer, Uint8Array, or URL



> ```DataMan = function DataMan(data, type) { ...``` [client/data-man-api.js:8](client/data-man-api.js#L8)


-

### <a name="DataMan.prototype.getBlob"></a>*dataman*.getBlob(callback)&nbsp;&nbsp;<sub><i>Client</i></sub> ###

*This method __getBlob__ is defined in `prototype` of `DataMan`*

__Arguments__

* __callback__ *{Function}*  

 callback(error, blob)


__Returns__  *{undefined}*


Passes a Blob representing this data to a callback.

> ```DataMan.prototype.getBlob = function dataManGetBlob(callback) { ...``` [client/data-man-api.js:52](client/data-man-api.js#L52)


-

### <a name="DataMan.prototype.getBinary"></a>*dataman*.getBinary([start], [end], callback)&nbsp;&nbsp;<sub><i>Client</i></sub> ###

*This method __getBinary__ is defined in `prototype` of `DataMan`*

__Arguments__

* __start__ *{Number}*  (Optional)

 First byte position to read.

* __end__ *{Number}*  (Optional)

 Last byte position to read.

* __callback__ *{Function}*  

 callback(error, binaryData)


__Returns__  *{undefined}*


Passes a Uint8Array representing this data to a callback.

> ```DataMan.prototype.getBinary = function dataManGetBinary(start, end, callback) { ...``` [client/data-man-api.js:84](client/data-man-api.js#L84)


-

### <a name="DataMan.prototype.saveAs"></a>*dataman*.saveAs([filename])&nbsp;&nbsp;<sub><i>Client</i></sub> ###

*This method __saveAs__ is defined in `prototype` of `DataMan`*

__Arguments__

* __filename__ *{String}*  (Optional)

__Returns__  *{undefined}*

Tells the browser to save the data like a normal downloaded file,
using the provided filename.


> ```DataMan.prototype.saveAs = function dataManSaveAs(filename) { ...``` [client/data-man-api.js:146](client/data-man-api.js#L146)


-

### <a name="DataMan.prototype.getDataUri"></a>*dataman*.getDataUri(callback)&nbsp;&nbsp;<sub><i>Client</i></sub> ###

*This method __getDataUri__ is defined in `prototype` of `DataMan`*

__Arguments__

* __callback__ *{function}*  

 callback(err, dataUri)



> ```DataMan.prototype.getDataUri = function dataManGetDataUri(callback) { ...``` [client/data-man-api.js:166](client/data-man-api.js#L166)


-

### <a name="DataMan.prototype.type"></a>*dataman*.type()&nbsp;&nbsp;<sub><i>Client</i></sub> ###

*This method __type__ is defined in `prototype` of `DataMan`*


Returns the type of the data.

> ```DataMan.prototype.type = function dataManType() { ...``` [client/data-man-api.js:227](client/data-man-api.js#L227)


-

### <a name="DataMan"></a>new DataMan(data, [type])&nbsp;&nbsp;<sub><i>Server</i></sub> ###


__Arguments__

* __data__ *{Buffer|ArrayBuffer|Uint8Array|String}*  

 The data that you want to manipulate.

* __type__ *{String}*  (Optional)

 The data content (MIME) type, if known. Required if the first argument is a Buffer, ArrayBuffer, Uint8Array, or URL



> ```DataMan = function DataMan(data, type) { ...``` [server/data-man-api.js:10](server/data-man-api.js#L10)


-

### <a name="DataMan.prototype.getBuffer"></a>*dataman*.getBuffer([callback])&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __getBuffer__ is defined in `prototype` of `DataMan`*

__Arguments__

* __callback__ *{function}*  (Optional)

 callback(err, buffer)


__Returns__  *{Buffer|undefined}*


Returns a Buffer representing this data, or passes the Buffer to a callback.

> ```DataMan.prototype.getBuffer = function dataManGetBuffer(callback) { ...``` [server/data-man-api.js:54](server/data-man-api.js#L54)


-

### <a name="DataMan.prototype.saveToFile"></a>*dataman*.saveToFile()&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __saveToFile__ is defined in `prototype` of `DataMan`*

__Returns__  *{undefined}*


Saves this data to a filepath on the local filesystem.

> ```DataMan.prototype.saveToFile = function dataManSaveToFile(filePath) { ...``` [server/data-man-api.js:66](server/data-man-api.js#L66)


-

### <a name="DataMan.prototype.getDataUri"></a>*dataman*.getDataUri([callback])&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __getDataUri__ is defined in `prototype` of `DataMan`*

__Arguments__

* __callback__ *{function}*  (Optional)

 callback(err, dataUri)



If no callback, returns the data URI.

> ```DataMan.prototype.getDataUri = function dataManGetDataUri(callback) { ...``` [server/data-man-api.js:84](server/data-man-api.js#L84)


-

### <a name="DataMan.prototype.createReadStream"></a>*dataman*.createReadStream()&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __createReadStream__ is defined in `prototype` of `DataMan`*


Returns a read stream for the data.

> ```DataMan.prototype.createReadStream = function dataManCreateReadStream() { ...``` [server/data-man-api.js:95](server/data-man-api.js#L95)


-

### <a name="DataMan.prototype.size"></a>*dataman*.size([callback])&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __size__ is defined in `prototype` of `DataMan`*

__Arguments__

* __callback__ *{function}*  (Optional)

 callback(err, size)



If no callback, returns the size in bytes of the data.

> ```DataMan.prototype.size = function dataManSize(callback) { ...``` [server/data-man-api.js:106](server/data-man-api.js#L106)


-

### <a name="DataMan.prototype.type"></a>*dataman*.type()&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __type__ is defined in `prototype` of `DataMan`*


Returns the type of the data.

> ```DataMan.prototype.type = function dataManType() { ...``` [server/data-man-api.js:117](server/data-man-api.js#L117)


-

### <a name="DataMan.Buffer"></a>new *dataman*.Buffer(buffer, type)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __Buffer__ is defined in `DataMan`*

__Arguments__

* __buffer__ *{Buffer}*  
* __type__ *{String}*  

 The data content (MIME) type.



> ```DataMan.Buffer = function DataManBuffer(buffer, type) { ...``` [server/data-man-buffer.js:10](server/data-man-buffer.js#L10)


-

### <a name="DataMan.DataURI"></a>new *dataman*.DataURI(dataUri)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __DataURI__ is defined in `DataMan`*

__Arguments__

* __dataUri__ *{String}*  


> ```DataMan.DataURI = function DataManDataURI(dataUri) { ...``` [server/data-man-datauri.js:7](server/data-man-datauri.js#L7)


-

### <a name="DataMan.FilePath"></a>new *dataman*.FilePath(filepath, [type])&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __FilePath__ is defined in `DataMan`*

__Arguments__

* __filepath__ *{String}*  
* __type__ *{String}*  (Optional)

 The data content (MIME) type. Will lookup from file if not passed.



> ```DataMan.FilePath = function DataManFilePath(filepath, type) { ...``` [server/data-man-filepath.js:11](server/data-man-filepath.js#L11)


-

### <a name="DataMan.URL"></a>new *dataman*.URL(url, type)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __URL__ is defined in `DataMan`*

__Arguments__

* __url__ *{String}*  
* __type__ *{String}*  

 The data content (MIME) type.



> ```DataMan.URL = function DataManURL(url, type) { ...``` [server/data-man-url.js:10](server/data-man-url.js#L10)


