// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: v1/syncservice.proto

package v1connect

import (
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	v1 "github.com/garethgeorge/backrest/gen/go/v1"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// TunnelServiceName is the fully-qualified name of the TunnelService service.
	TunnelServiceName = "v1.TunnelService"
	// BackrestSyncServiceName is the fully-qualified name of the BackrestSyncService service.
	BackrestSyncServiceName = "v1.BackrestSyncService"
	// BackrestSyncStateServiceName is the fully-qualified name of the BackrestSyncStateService service.
	BackrestSyncStateServiceName = "v1.BackrestSyncStateService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// TunnelServiceTunnelProcedure is the fully-qualified name of the TunnelService's Tunnel RPC.
	TunnelServiceTunnelProcedure = "/v1.TunnelService/Tunnel"
	// BackrestSyncServiceSyncProcedure is the fully-qualified name of the BackrestSyncService's Sync
	// RPC.
	BackrestSyncServiceSyncProcedure = "/v1.BackrestSyncService/Sync"
	// BackrestSyncStateServiceGetPeerSyncStatesStreamProcedure is the fully-qualified name of the
	// BackrestSyncStateService's GetPeerSyncStatesStream RPC.
	BackrestSyncStateServiceGetPeerSyncStatesStreamProcedure = "/v1.BackrestSyncStateService/GetPeerSyncStatesStream"
)

// These variables are the protoreflect.Descriptor objects for the RPCs defined in this package.
var (
	tunnelServiceServiceDescriptor                                  = v1.File_v1_syncservice_proto.Services().ByName("TunnelService")
	tunnelServiceTunnelMethodDescriptor                             = tunnelServiceServiceDescriptor.Methods().ByName("Tunnel")
	backrestSyncServiceServiceDescriptor                            = v1.File_v1_syncservice_proto.Services().ByName("BackrestSyncService")
	backrestSyncServiceSyncMethodDescriptor                         = backrestSyncServiceServiceDescriptor.Methods().ByName("Sync")
	backrestSyncStateServiceServiceDescriptor                       = v1.File_v1_syncservice_proto.Services().ByName("BackrestSyncStateService")
	backrestSyncStateServiceGetPeerSyncStatesStreamMethodDescriptor = backrestSyncStateServiceServiceDescriptor.Methods().ByName("GetPeerSyncStatesStream")
)

// TunnelServiceClient is a client for the v1.TunnelService service.
type TunnelServiceClient interface {
	Tunnel(context.Context) *connect.BidiStreamForClient[v1.TunnelMessage, v1.TunnelMessage]
}

// NewTunnelServiceClient constructs a client for the v1.TunnelService service. By default, it uses
// the Connect protocol with the binary Protobuf Codec, asks for gzipped responses, and sends
// uncompressed requests. To use the gRPC or gRPC-Web protocols, supply the connect.WithGRPC() or
// connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewTunnelServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) TunnelServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &tunnelServiceClient{
		tunnel: connect.NewClient[v1.TunnelMessage, v1.TunnelMessage](
			httpClient,
			baseURL+TunnelServiceTunnelProcedure,
			connect.WithSchema(tunnelServiceTunnelMethodDescriptor),
			connect.WithClientOptions(opts...),
		),
	}
}

// tunnelServiceClient implements TunnelServiceClient.
type tunnelServiceClient struct {
	tunnel *connect.Client[v1.TunnelMessage, v1.TunnelMessage]
}

// Tunnel calls v1.TunnelService.Tunnel.
func (c *tunnelServiceClient) Tunnel(ctx context.Context) *connect.BidiStreamForClient[v1.TunnelMessage, v1.TunnelMessage] {
	return c.tunnel.CallBidiStream(ctx)
}

// TunnelServiceHandler is an implementation of the v1.TunnelService service.
type TunnelServiceHandler interface {
	Tunnel(context.Context, *connect.BidiStream[v1.TunnelMessage, v1.TunnelMessage]) error
}

// NewTunnelServiceHandler builds an HTTP handler from the service implementation. It returns the
// path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewTunnelServiceHandler(svc TunnelServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	tunnelServiceTunnelHandler := connect.NewBidiStreamHandler(
		TunnelServiceTunnelProcedure,
		svc.Tunnel,
		connect.WithSchema(tunnelServiceTunnelMethodDescriptor),
		connect.WithHandlerOptions(opts...),
	)
	return "/v1.TunnelService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case TunnelServiceTunnelProcedure:
			tunnelServiceTunnelHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedTunnelServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedTunnelServiceHandler struct{}

func (UnimplementedTunnelServiceHandler) Tunnel(context.Context, *connect.BidiStream[v1.TunnelMessage, v1.TunnelMessage]) error {
	return connect.NewError(connect.CodeUnimplemented, errors.New("v1.TunnelService.Tunnel is not implemented"))
}

// BackrestSyncServiceClient is a client for the v1.BackrestSyncService service.
type BackrestSyncServiceClient interface {
	Sync(context.Context) *connect.BidiStreamForClient[v1.SyncStreamItem, v1.SyncStreamItem]
}

// NewBackrestSyncServiceClient constructs a client for the v1.BackrestSyncService service. By
// default, it uses the Connect protocol with the binary Protobuf Codec, asks for gzipped responses,
// and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply the
// connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewBackrestSyncServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) BackrestSyncServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &backrestSyncServiceClient{
		sync: connect.NewClient[v1.SyncStreamItem, v1.SyncStreamItem](
			httpClient,
			baseURL+BackrestSyncServiceSyncProcedure,
			connect.WithSchema(backrestSyncServiceSyncMethodDescriptor),
			connect.WithClientOptions(opts...),
		),
	}
}

// backrestSyncServiceClient implements BackrestSyncServiceClient.
type backrestSyncServiceClient struct {
	sync *connect.Client[v1.SyncStreamItem, v1.SyncStreamItem]
}

// Sync calls v1.BackrestSyncService.Sync.
func (c *backrestSyncServiceClient) Sync(ctx context.Context) *connect.BidiStreamForClient[v1.SyncStreamItem, v1.SyncStreamItem] {
	return c.sync.CallBidiStream(ctx)
}

// BackrestSyncServiceHandler is an implementation of the v1.BackrestSyncService service.
type BackrestSyncServiceHandler interface {
	Sync(context.Context, *connect.BidiStream[v1.SyncStreamItem, v1.SyncStreamItem]) error
}

// NewBackrestSyncServiceHandler builds an HTTP handler from the service implementation. It returns
// the path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewBackrestSyncServiceHandler(svc BackrestSyncServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	backrestSyncServiceSyncHandler := connect.NewBidiStreamHandler(
		BackrestSyncServiceSyncProcedure,
		svc.Sync,
		connect.WithSchema(backrestSyncServiceSyncMethodDescriptor),
		connect.WithHandlerOptions(opts...),
	)
	return "/v1.BackrestSyncService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case BackrestSyncServiceSyncProcedure:
			backrestSyncServiceSyncHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedBackrestSyncServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedBackrestSyncServiceHandler struct{}

func (UnimplementedBackrestSyncServiceHandler) Sync(context.Context, *connect.BidiStream[v1.SyncStreamItem, v1.SyncStreamItem]) error {
	return connect.NewError(connect.CodeUnimplemented, errors.New("v1.BackrestSyncService.Sync is not implemented"))
}

// BackrestSyncStateServiceClient is a client for the v1.BackrestSyncStateService service.
type BackrestSyncStateServiceClient interface {
	GetPeerSyncStatesStream(context.Context, *connect.Request[v1.SyncStateStreamRequest]) (*connect.ServerStreamForClient[v1.PeerState], error)
}

// NewBackrestSyncStateServiceClient constructs a client for the v1.BackrestSyncStateService
// service. By default, it uses the Connect protocol with the binary Protobuf Codec, asks for
// gzipped responses, and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply
// the connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewBackrestSyncStateServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) BackrestSyncStateServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &backrestSyncStateServiceClient{
		getPeerSyncStatesStream: connect.NewClient[v1.SyncStateStreamRequest, v1.PeerState](
			httpClient,
			baseURL+BackrestSyncStateServiceGetPeerSyncStatesStreamProcedure,
			connect.WithSchema(backrestSyncStateServiceGetPeerSyncStatesStreamMethodDescriptor),
			connect.WithClientOptions(opts...),
		),
	}
}

// backrestSyncStateServiceClient implements BackrestSyncStateServiceClient.
type backrestSyncStateServiceClient struct {
	getPeerSyncStatesStream *connect.Client[v1.SyncStateStreamRequest, v1.PeerState]
}

// GetPeerSyncStatesStream calls v1.BackrestSyncStateService.GetPeerSyncStatesStream.
func (c *backrestSyncStateServiceClient) GetPeerSyncStatesStream(ctx context.Context, req *connect.Request[v1.SyncStateStreamRequest]) (*connect.ServerStreamForClient[v1.PeerState], error) {
	return c.getPeerSyncStatesStream.CallServerStream(ctx, req)
}

// BackrestSyncStateServiceHandler is an implementation of the v1.BackrestSyncStateService service.
type BackrestSyncStateServiceHandler interface {
	GetPeerSyncStatesStream(context.Context, *connect.Request[v1.SyncStateStreamRequest], *connect.ServerStream[v1.PeerState]) error
}

// NewBackrestSyncStateServiceHandler builds an HTTP handler from the service implementation. It
// returns the path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewBackrestSyncStateServiceHandler(svc BackrestSyncStateServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	backrestSyncStateServiceGetPeerSyncStatesStreamHandler := connect.NewServerStreamHandler(
		BackrestSyncStateServiceGetPeerSyncStatesStreamProcedure,
		svc.GetPeerSyncStatesStream,
		connect.WithSchema(backrestSyncStateServiceGetPeerSyncStatesStreamMethodDescriptor),
		connect.WithHandlerOptions(opts...),
	)
	return "/v1.BackrestSyncStateService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case BackrestSyncStateServiceGetPeerSyncStatesStreamProcedure:
			backrestSyncStateServiceGetPeerSyncStatesStreamHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedBackrestSyncStateServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedBackrestSyncStateServiceHandler struct{}

func (UnimplementedBackrestSyncStateServiceHandler) GetPeerSyncStatesStream(context.Context, *connect.Request[v1.SyncStateStreamRequest], *connect.ServerStream[v1.PeerState]) error {
	return connect.NewError(connect.CodeUnimplemented, errors.New("v1.BackrestSyncStateService.GetPeerSyncStatesStream is not implemented"))
}
