// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: v1/authentication.proto

package v1connect

import (
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	types "github.com/garethgeorge/backrest/gen/go/types"
	v1 "github.com/garethgeorge/backrest/gen/go/v1"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// AuthenticationName is the fully-qualified name of the Authentication service.
	AuthenticationName = "v1.Authentication"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// AuthenticationLoginProcedure is the fully-qualified name of the Authentication's Login RPC.
	AuthenticationLoginProcedure = "/v1.Authentication/Login"
	// AuthenticationHashPasswordProcedure is the fully-qualified name of the Authentication's
	// HashPassword RPC.
	AuthenticationHashPasswordProcedure = "/v1.Authentication/HashPassword"
)

// These variables are the protoreflect.Descriptor objects for the RPCs defined in this package.
var (
	authenticationServiceDescriptor            = v1.File_v1_authentication_proto.Services().ByName("Authentication")
	authenticationLoginMethodDescriptor        = authenticationServiceDescriptor.Methods().ByName("Login")
	authenticationHashPasswordMethodDescriptor = authenticationServiceDescriptor.Methods().ByName("HashPassword")
)

// AuthenticationClient is a client for the v1.Authentication service.
type AuthenticationClient interface {
	Login(context.Context, *connect.Request[v1.LoginRequest]) (*connect.Response[v1.LoginResponse], error)
	HashPassword(context.Context, *connect.Request[types.StringValue]) (*connect.Response[types.StringValue], error)
}

// NewAuthenticationClient constructs a client for the v1.Authentication service. By default, it
// uses the Connect protocol with the binary Protobuf Codec, asks for gzipped responses, and sends
// uncompressed requests. To use the gRPC or gRPC-Web protocols, supply the connect.WithGRPC() or
// connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewAuthenticationClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) AuthenticationClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &authenticationClient{
		login: connect.NewClient[v1.LoginRequest, v1.LoginResponse](
			httpClient,
			baseURL+AuthenticationLoginProcedure,
			connect.WithSchema(authenticationLoginMethodDescriptor),
			connect.WithClientOptions(opts...),
		),
		hashPassword: connect.NewClient[types.StringValue, types.StringValue](
			httpClient,
			baseURL+AuthenticationHashPasswordProcedure,
			connect.WithSchema(authenticationHashPasswordMethodDescriptor),
			connect.WithClientOptions(opts...),
		),
	}
}

// authenticationClient implements AuthenticationClient.
type authenticationClient struct {
	login        *connect.Client[v1.LoginRequest, v1.LoginResponse]
	hashPassword *connect.Client[types.StringValue, types.StringValue]
}

// Login calls v1.Authentication.Login.
func (c *authenticationClient) Login(ctx context.Context, req *connect.Request[v1.LoginRequest]) (*connect.Response[v1.LoginResponse], error) {
	return c.login.CallUnary(ctx, req)
}

// HashPassword calls v1.Authentication.HashPassword.
func (c *authenticationClient) HashPassword(ctx context.Context, req *connect.Request[types.StringValue]) (*connect.Response[types.StringValue], error) {
	return c.hashPassword.CallUnary(ctx, req)
}

// AuthenticationHandler is an implementation of the v1.Authentication service.
type AuthenticationHandler interface {
	Login(context.Context, *connect.Request[v1.LoginRequest]) (*connect.Response[v1.LoginResponse], error)
	HashPassword(context.Context, *connect.Request[types.StringValue]) (*connect.Response[types.StringValue], error)
}

// NewAuthenticationHandler builds an HTTP handler from the service implementation. It returns the
// path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewAuthenticationHandler(svc AuthenticationHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	authenticationLoginHandler := connect.NewUnaryHandler(
		AuthenticationLoginProcedure,
		svc.Login,
		connect.WithSchema(authenticationLoginMethodDescriptor),
		connect.WithHandlerOptions(opts...),
	)
	authenticationHashPasswordHandler := connect.NewUnaryHandler(
		AuthenticationHashPasswordProcedure,
		svc.HashPassword,
		connect.WithSchema(authenticationHashPasswordMethodDescriptor),
		connect.WithHandlerOptions(opts...),
	)
	return "/v1.Authentication/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case AuthenticationLoginProcedure:
			authenticationLoginHandler.ServeHTTP(w, r)
		case AuthenticationHashPasswordProcedure:
			authenticationHashPasswordHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedAuthenticationHandler returns CodeUnimplemented from all methods.
type UnimplementedAuthenticationHandler struct{}

func (UnimplementedAuthenticationHandler) Login(context.Context, *connect.Request[v1.LoginRequest]) (*connect.Response[v1.LoginResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("v1.Authentication.Login is not implemented"))
}

func (UnimplementedAuthenticationHandler) HashPassword(context.Context, *connect.Request[types.StringValue]) (*connect.Response[types.StringValue], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("v1.Authentication.HashPassword is not implemented"))
}
