// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        (unknown)
// source: v1/operations.proto

package v1

import (
	types "github.com/garethgeorge/backrest/gen/go/types"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// OperationEventType indicates whether the operation was created or updated
type OperationEventType int32

const (
	OperationEventType_EVENT_UNKNOWN OperationEventType = 0
	OperationEventType_EVENT_CREATED OperationEventType = 1
	OperationEventType_EVENT_UPDATED OperationEventType = 2
	OperationEventType_EVENT_DELETED OperationEventType = 3
)

// Enum value maps for OperationEventType.
var (
	OperationEventType_name = map[int32]string{
		0: "EVENT_UNKNOWN",
		1: "EVENT_CREATED",
		2: "EVENT_UPDATED",
		3: "EVENT_DELETED",
	}
	OperationEventType_value = map[string]int32{
		"EVENT_UNKNOWN": 0,
		"EVENT_CREATED": 1,
		"EVENT_UPDATED": 2,
		"EVENT_DELETED": 3,
	}
)

func (x OperationEventType) Enum() *OperationEventType {
	p := new(OperationEventType)
	*p = x
	return p
}

func (x OperationEventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OperationEventType) Descriptor() protoreflect.EnumDescriptor {
	return file_v1_operations_proto_enumTypes[0].Descriptor()
}

func (OperationEventType) Type() protoreflect.EnumType {
	return &file_v1_operations_proto_enumTypes[0]
}

func (x OperationEventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OperationEventType.Descriptor instead.
func (OperationEventType) EnumDescriptor() ([]byte, []int) {
	return file_v1_operations_proto_rawDescGZIP(), []int{0}
}

type OperationStatus int32

const (
	OperationStatus_STATUS_UNKNOWN          OperationStatus = 0 // used to indicate that the status is unknown.
	OperationStatus_STATUS_PENDING          OperationStatus = 1 // used to indicate that the operation is pending.
	OperationStatus_STATUS_INPROGRESS       OperationStatus = 2 // used to indicate that the operation is in progress.
	OperationStatus_STATUS_SUCCESS          OperationStatus = 3 // used to indicate that the operation completed successfully.
	OperationStatus_STATUS_WARNING          OperationStatus = 7 // used to indicate that the operation completed with warnings.
	OperationStatus_STATUS_ERROR            OperationStatus = 4 // used to indicate that the operation failed.
	OperationStatus_STATUS_SYSTEM_CANCELLED OperationStatus = 5 // indicates operation cancelled by the system.
	OperationStatus_STATUS_USER_CANCELLED   OperationStatus = 6 // indicates operation cancelled by the user.
)

// Enum value maps for OperationStatus.
var (
	OperationStatus_name = map[int32]string{
		0: "STATUS_UNKNOWN",
		1: "STATUS_PENDING",
		2: "STATUS_INPROGRESS",
		3: "STATUS_SUCCESS",
		7: "STATUS_WARNING",
		4: "STATUS_ERROR",
		5: "STATUS_SYSTEM_CANCELLED",
		6: "STATUS_USER_CANCELLED",
	}
	OperationStatus_value = map[string]int32{
		"STATUS_UNKNOWN":          0,
		"STATUS_PENDING":          1,
		"STATUS_INPROGRESS":       2,
		"STATUS_SUCCESS":          3,
		"STATUS_WARNING":          7,
		"STATUS_ERROR":            4,
		"STATUS_SYSTEM_CANCELLED": 5,
		"STATUS_USER_CANCELLED":   6,
	}
)

func (x OperationStatus) Enum() *OperationStatus {
	p := new(OperationStatus)
	*p = x
	return p
}

func (x OperationStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OperationStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_v1_operations_proto_enumTypes[1].Descriptor()
}

func (OperationStatus) Type() protoreflect.EnumType {
	return &file_v1_operations_proto_enumTypes[1]
}

func (x OperationStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OperationStatus.Descriptor instead.
func (OperationStatus) EnumDescriptor() ([]byte, []int) {
	return file_v1_operations_proto_rawDescGZIP(), []int{1}
}

type OperationList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Operations []*Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
}

func (x *OperationList) Reset() {
	*x = OperationList{}
	mi := &file_v1_operations_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationList) ProtoMessage() {}

func (x *OperationList) ProtoReflect() protoreflect.Message {
	mi := &file_v1_operations_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationList.ProtoReflect.Descriptor instead.
func (*OperationList) Descriptor() ([]byte, []int) {
	return file_v1_operations_proto_rawDescGZIP(), []int{0}
}

func (x *OperationList) GetOperations() []*Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

// Operation is the basic unit of record in backrest
type Operation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// required, primary ID of the operation. ID is sequential based on creation time of the operation.
	Id         int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	OriginalId int64 `protobuf:"varint,13,opt,name=original_id,json=originalId,proto3" json:"original_id,omitempty"`
	// modno increments with each change to the operation. This supports easy diffing.
	Modno int64 `protobuf:"varint,12,opt,name=modno,proto3" json:"modno,omitempty"`
	// flow id groups operations together, e.g. by an execution of a plan.
	// must be unique within the context of a repo.
	FlowId         int64 `protobuf:"varint,10,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	OriginalFlowId int64 `protobuf:"varint,14,opt,name=original_flow_id,json=originalFlowId,proto3" json:"original_flow_id,omitempty"`
	// repo id is a string identifier for the repo, and repo_guid is the globally unique ID of the repo.
	RepoId   string `protobuf:"bytes,2,opt,name=repo_id,json=repoId,proto3" json:"repo_id,omitempty"`
	RepoGuid string `protobuf:"bytes,15,opt,name=repo_guid,json=repoGuid,proto3" json:"repo_guid,omitempty"`
	// plan id e.g. a scheduled set of operations (or system) that created this operation.
	PlanId string `protobuf:"bytes,3,opt,name=plan_id,json=planId,proto3" json:"plan_id,omitempty"`
	// instance ID that the operation is attributed to, not necessarily the same as the instance that created it.
	InstanceId string `protobuf:"bytes,11,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// original instance guid is the verifiable instance that created the operation. Only set for remote operations created by sync.
	OriginalInstanceKeyid string `protobuf:"bytes,16,opt,name=original_instance_keyid,json=originalInstanceKeyid,proto3" json:"original_instance_keyid,omitempty"`
	// optional snapshot id if associated with a snapshot.
	SnapshotId string          `protobuf:"bytes,8,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	Status     OperationStatus `protobuf:"varint,4,opt,name=status,proto3,enum=v1.OperationStatus" json:"status,omitempty"`
	// required, unix time in milliseconds of the operation's creation (ID is derived from this)
	UnixTimeStartMs int64 `protobuf:"varint,5,opt,name=unix_time_start_ms,json=unixTimeStartMs,proto3" json:"unix_time_start_ms,omitempty"`
	// ptional, unix time in milliseconds of the operation's completion
	UnixTimeEndMs int64 `protobuf:"varint,6,opt,name=unix_time_end_ms,json=unixTimeEndMs,proto3" json:"unix_time_end_ms,omitempty"`
	// optional, human readable context message, typically an error message.
	DisplayMessage string `protobuf:"bytes,7,opt,name=display_message,json=displayMessage,proto3" json:"display_message,omitempty"`
	// logref can point to arbitrary logs associated with the operation.
	Logref string `protobuf:"bytes,9,opt,name=logref,proto3" json:"logref,omitempty"`
	// Types that are assignable to Op:
	//
	//	*Operation_OperationBackup
	//	*Operation_OperationIndexSnapshot
	//	*Operation_OperationForget
	//	*Operation_OperationPrune
	//	*Operation_OperationRestore
	//	*Operation_OperationStats
	//	*Operation_OperationRunHook
	//	*Operation_OperationCheck
	//	*Operation_OperationRunCommand
	Op isOperation_Op `protobuf_oneof:"op"`
}

func (x *Operation) Reset() {
	*x = Operation{}
	mi := &file_v1_operations_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Operation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Operation) ProtoMessage() {}

func (x *Operation) ProtoReflect() protoreflect.Message {
	mi := &file_v1_operations_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Operation.ProtoReflect.Descriptor instead.
func (*Operation) Descriptor() ([]byte, []int) {
	return file_v1_operations_proto_rawDescGZIP(), []int{1}
}

func (x *Operation) GetId() int64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Operation) GetOriginalId() int64 {
	if x != nil {
		return x.OriginalId
	}
	return 0
}

func (x *Operation) GetModno() int64 {
	if x != nil {
		return x.Modno
	}
	return 0
}

func (x *Operation) GetFlowId() int64 {
	if x != nil {
		return x.FlowId
	}
	return 0
}

func (x *Operation) GetOriginalFlowId() int64 {
	if x != nil {
		return x.OriginalFlowId
	}
	return 0
}

func (x *Operation) GetRepoId() string {
	if x != nil {
		return x.RepoId
	}
	return ""
}

func (x *Operation) GetRepoGuid() string {
	if x != nil {
		return x.RepoGuid
	}
	return ""
}

func (x *Operation) GetPlanId() string {
	if x != nil {
		return x.PlanId
	}
	return ""
}

func (x *Operation) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *Operation) GetOriginalInstanceKeyid() string {
	if x != nil {
		return x.OriginalInstanceKeyid
	}
	return ""
}

func (x *Operation) GetSnapshotId() string {
	if x != nil {
		return x.SnapshotId
	}
	return ""
}

func (x *Operation) GetStatus() OperationStatus {
	if x != nil {
		return x.Status
	}
	return OperationStatus_STATUS_UNKNOWN
}

func (x *Operation) GetUnixTimeStartMs() int64 {
	if x != nil {
		return x.UnixTimeStartMs
	}
	return 0
}

func (x *Operation) GetUnixTimeEndMs() int64 {
	if x != nil {
		return x.UnixTimeEndMs
	}
	return 0
}

func (x *Operation) GetDisplayMessage() string {
	if x != nil {
		return x.DisplayMessage
	}
	return ""
}

func (x *Operation) GetLogref() string {
	if x != nil {
		return x.Logref
	}
	return ""
}

func (m *Operation) GetOp() isOperation_Op {
	if m != nil {
		return m.Op
	}
	return nil
}

func (x *Operation) GetOperationBackup() *OperationBackup {
	if x, ok := x.GetOp().(*Operation_OperationBackup); ok {
		return x.OperationBackup
	}
	return nil
}

func (x *Operation) GetOperationIndexSnapshot() *OperationIndexSnapshot {
	if x, ok := x.GetOp().(*Operation_OperationIndexSnapshot); ok {
		return x.OperationIndexSnapshot
	}
	return nil
}

func (x *Operation) GetOperationForget() *OperationForget {
	if x, ok := x.GetOp().(*Operation_OperationForget); ok {
		return x.OperationForget
	}
	return nil
}

func (x *Operation) GetOperationPrune() *OperationPrune {
	if x, ok := x.GetOp().(*Operation_OperationPrune); ok {
		return x.OperationPrune
	}
	return nil
}

func (x *Operation) GetOperationRestore() *OperationRestore {
	if x, ok := x.GetOp().(*Operation_OperationRestore); ok {
		return x.OperationRestore
	}
	return nil
}

func (x *Operation) GetOperationStats() *OperationStats {
	if x, ok := x.GetOp().(*Operation_OperationStats); ok {
		return x.OperationStats
	}
	return nil
}

func (x *Operation) GetOperationRunHook() *OperationRunHook {
	if x, ok := x.GetOp().(*Operation_OperationRunHook); ok {
		return x.OperationRunHook
	}
	return nil
}

func (x *Operation) GetOperationCheck() *OperationCheck {
	if x, ok := x.GetOp().(*Operation_OperationCheck); ok {
		return x.OperationCheck
	}
	return nil
}

func (x *Operation) GetOperationRunCommand() *OperationRunCommand {
	if x, ok := x.GetOp().(*Operation_OperationRunCommand); ok {
		return x.OperationRunCommand
	}
	return nil
}

type isOperation_Op interface {
	isOperation_Op()
}

type Operation_OperationBackup struct {
	OperationBackup *OperationBackup `protobuf:"bytes,100,opt,name=operation_backup,json=operationBackup,proto3,oneof"`
}

type Operation_OperationIndexSnapshot struct {
	OperationIndexSnapshot *OperationIndexSnapshot `protobuf:"bytes,101,opt,name=operation_index_snapshot,json=operationIndexSnapshot,proto3,oneof"`
}

type Operation_OperationForget struct {
	OperationForget *OperationForget `protobuf:"bytes,102,opt,name=operation_forget,json=operationForget,proto3,oneof"`
}

type Operation_OperationPrune struct {
	OperationPrune *OperationPrune `protobuf:"bytes,103,opt,name=operation_prune,json=operationPrune,proto3,oneof"`
}

type Operation_OperationRestore struct {
	OperationRestore *OperationRestore `protobuf:"bytes,104,opt,name=operation_restore,json=operationRestore,proto3,oneof"`
}

type Operation_OperationStats struct {
	OperationStats *OperationStats `protobuf:"bytes,105,opt,name=operation_stats,json=operationStats,proto3,oneof"`
}

type Operation_OperationRunHook struct {
	OperationRunHook *OperationRunHook `protobuf:"bytes,106,opt,name=operation_run_hook,json=operationRunHook,proto3,oneof"`
}

type Operation_OperationCheck struct {
	OperationCheck *OperationCheck `protobuf:"bytes,107,opt,name=operation_check,json=operationCheck,proto3,oneof"`
}

type Operation_OperationRunCommand struct {
	OperationRunCommand *OperationRunCommand `protobuf:"bytes,108,opt,name=operation_run_command,json=operationRunCommand,proto3,oneof"`
}

func (*Operation_OperationBackup) isOperation_Op() {}

func (*Operation_OperationIndexSnapshot) isOperation_Op() {}

func (*Operation_OperationForget) isOperation_Op() {}

func (*Operation_OperationPrune) isOperation_Op() {}

func (*Operation_OperationRestore) isOperation_Op() {}

func (*Operation_OperationStats) isOperation_Op() {}

func (*Operation_OperationRunHook) isOperation_Op() {}

func (*Operation_OperationCheck) isOperation_Op() {}

func (*Operation_OperationRunCommand) isOperation_Op() {}

// OperationEvent is used in the wireformat to stream operation changes to clients
type OperationEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Event:
	//
	//	*OperationEvent_KeepAlive
	//	*OperationEvent_CreatedOperations
	//	*OperationEvent_UpdatedOperations
	//	*OperationEvent_DeletedOperations
	Event isOperationEvent_Event `protobuf_oneof:"event"`
}

func (x *OperationEvent) Reset() {
	*x = OperationEvent{}
	mi := &file_v1_operations_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationEvent) ProtoMessage() {}

func (x *OperationEvent) ProtoReflect() protoreflect.Message {
	mi := &file_v1_operations_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationEvent.ProtoReflect.Descriptor instead.
func (*OperationEvent) Descriptor() ([]byte, []int) {
	return file_v1_operations_proto_rawDescGZIP(), []int{2}
}

func (m *OperationEvent) GetEvent() isOperationEvent_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (x *OperationEvent) GetKeepAlive() *types.Empty {
	if x, ok := x.GetEvent().(*OperationEvent_KeepAlive); ok {
		return x.KeepAlive
	}
	return nil
}

func (x *OperationEvent) GetCreatedOperations() *OperationList {
	if x, ok := x.GetEvent().(*OperationEvent_CreatedOperations); ok {
		return x.CreatedOperations
	}
	return nil
}

func (x *OperationEvent) GetUpdatedOperations() *OperationList {
	if x, ok := x.GetEvent().(*OperationEvent_UpdatedOperations); ok {
		return x.UpdatedOperations
	}
	return nil
}

func (x *OperationEvent) GetDeletedOperations() *types.Int64List {
	if x, ok := x.GetEvent().(*OperationEvent_DeletedOperations); ok {
		return x.DeletedOperations
	}
	return nil
}

type isOperationEvent_Event interface {
	isOperationEvent_Event()
}

type OperationEvent_KeepAlive struct {
	KeepAlive *types.Empty `protobuf:"bytes,1,opt,name=keep_alive,json=keepAlive,proto3,oneof"`
}

type OperationEvent_CreatedOperations struct {
	CreatedOperations *OperationList `protobuf:"bytes,2,opt,name=created_operations,json=createdOperations,proto3,oneof"`
}

type OperationEvent_UpdatedOperations struct {
	UpdatedOperations *OperationList `protobuf:"bytes,3,opt,name=updated_operations,json=updatedOperations,proto3,oneof"`
}

type OperationEvent_DeletedOperations struct {
	DeletedOperations *types.Int64List `protobuf:"bytes,4,opt,name=deleted_operations,json=deletedOperations,proto3,oneof"`
}

func (*OperationEvent_KeepAlive) isOperationEvent_Event() {}

func (*OperationEvent_CreatedOperations) isOperationEvent_Event() {}

func (*OperationEvent_UpdatedOperations) isOperationEvent_Event() {}

func (*OperationEvent_DeletedOperations) isOperationEvent_Event() {}

type OperationBackup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LastStatus *BackupProgressEntry   `protobuf:"bytes,3,opt,name=last_status,json=lastStatus,proto3" json:"last_status,omitempty"`
	Errors     []*BackupProgressError `protobuf:"bytes,4,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *OperationBackup) Reset() {
	*x = OperationBackup{}
	mi := &file_v1_operations_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationBackup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationBackup) ProtoMessage() {}

func (x *OperationBackup) ProtoReflect() protoreflect.Message {
	mi := &file_v1_operations_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationBackup.ProtoReflect.Descriptor instead.
func (*OperationBackup) Descriptor() ([]byte, []int) {
	return file_v1_operations_proto_rawDescGZIP(), []int{3}
}

func (x *OperationBackup) GetLastStatus() *BackupProgressEntry {
	if x != nil {
		return x.LastStatus
	}
	return nil
}

func (x *OperationBackup) GetErrors() []*BackupProgressError {
	if x != nil {
		return x.Errors
	}
	return nil
}

// OperationIndexSnapshot tracks that a snapshot was detected by backrest.
type OperationIndexSnapshot struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Snapshot *ResticSnapshot `protobuf:"bytes,2,opt,name=snapshot,proto3" json:"snapshot,omitempty"` // the snapshot that was indexed.
	Forgot   bool            `protobuf:"varint,3,opt,name=forgot,proto3" json:"forgot,omitempty"`    // tracks whether this snapshot is forgotten yet.
}

func (x *OperationIndexSnapshot) Reset() {
	*x = OperationIndexSnapshot{}
	mi := &file_v1_operations_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationIndexSnapshot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationIndexSnapshot) ProtoMessage() {}

func (x *OperationIndexSnapshot) ProtoReflect() protoreflect.Message {
	mi := &file_v1_operations_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationIndexSnapshot.ProtoReflect.Descriptor instead.
func (*OperationIndexSnapshot) Descriptor() ([]byte, []int) {
	return file_v1_operations_proto_rawDescGZIP(), []int{4}
}

func (x *OperationIndexSnapshot) GetSnapshot() *ResticSnapshot {
	if x != nil {
		return x.Snapshot
	}
	return nil
}

func (x *OperationIndexSnapshot) GetForgot() bool {
	if x != nil {
		return x.Forgot
	}
	return false
}

// OperationForget tracks a forget operation.
type OperationForget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Forget []*ResticSnapshot `protobuf:"bytes,1,rep,name=forget,proto3" json:"forget,omitempty"`
	Policy *RetentionPolicy  `protobuf:"bytes,2,opt,name=policy,proto3" json:"policy,omitempty"`
}

func (x *OperationForget) Reset() {
	*x = OperationForget{}
	mi := &file_v1_operations_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationForget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationForget) ProtoMessage() {}

func (x *OperationForget) ProtoReflect() protoreflect.Message {
	mi := &file_v1_operations_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationForget.ProtoReflect.Descriptor instead.
func (*OperationForget) Descriptor() ([]byte, []int) {
	return file_v1_operations_proto_rawDescGZIP(), []int{5}
}

func (x *OperationForget) GetForget() []*ResticSnapshot {
	if x != nil {
		return x.Forget
	}
	return nil
}

func (x *OperationForget) GetPolicy() *RetentionPolicy {
	if x != nil {
		return x.Policy
	}
	return nil
}

// OperationPrune tracks a prune operation.
type OperationPrune struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated: Marked as deprecated in v1/operations.proto.
	Output       string `protobuf:"bytes,1,opt,name=output,proto3" json:"output,omitempty"`                                 // output of the prune.
	OutputLogref string `protobuf:"bytes,2,opt,name=output_logref,json=outputLogref,proto3" json:"output_logref,omitempty"` // logref of the prune output.
}

func (x *OperationPrune) Reset() {
	*x = OperationPrune{}
	mi := &file_v1_operations_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationPrune) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationPrune) ProtoMessage() {}

func (x *OperationPrune) ProtoReflect() protoreflect.Message {
	mi := &file_v1_operations_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationPrune.ProtoReflect.Descriptor instead.
func (*OperationPrune) Descriptor() ([]byte, []int) {
	return file_v1_operations_proto_rawDescGZIP(), []int{6}
}

// Deprecated: Marked as deprecated in v1/operations.proto.
func (x *OperationPrune) GetOutput() string {
	if x != nil {
		return x.Output
	}
	return ""
}

func (x *OperationPrune) GetOutputLogref() string {
	if x != nil {
		return x.OutputLogref
	}
	return ""
}

// OperationCheck tracks a check operation.
type OperationCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated: Marked as deprecated in v1/operations.proto.
	Output       string `protobuf:"bytes,1,opt,name=output,proto3" json:"output,omitempty"`                                 // output of the check operation.
	OutputLogref string `protobuf:"bytes,2,opt,name=output_logref,json=outputLogref,proto3" json:"output_logref,omitempty"` // logref of the check output.
}

func (x *OperationCheck) Reset() {
	*x = OperationCheck{}
	mi := &file_v1_operations_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationCheck) ProtoMessage() {}

func (x *OperationCheck) ProtoReflect() protoreflect.Message {
	mi := &file_v1_operations_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationCheck.ProtoReflect.Descriptor instead.
func (*OperationCheck) Descriptor() ([]byte, []int) {
	return file_v1_operations_proto_rawDescGZIP(), []int{7}
}

// Deprecated: Marked as deprecated in v1/operations.proto.
func (x *OperationCheck) GetOutput() string {
	if x != nil {
		return x.Output
	}
	return ""
}

func (x *OperationCheck) GetOutputLogref() string {
	if x != nil {
		return x.OutputLogref
	}
	return ""
}

// OperationRunCommand tracks a long running command. Commands are grouped into a flow ID for each session.
type OperationRunCommand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Command         string `protobuf:"bytes,1,opt,name=command,proto3" json:"command,omitempty"`
	OutputLogref    string `protobuf:"bytes,2,opt,name=output_logref,json=outputLogref,proto3" json:"output_logref,omitempty"`
	OutputSizeBytes int64  `protobuf:"varint,3,opt,name=output_size_bytes,json=outputSizeBytes,proto3" json:"output_size_bytes,omitempty"` // not necessarily authoritative, tracked as an optimization to allow clients to avoid fetching very large outputs.
}

func (x *OperationRunCommand) Reset() {
	*x = OperationRunCommand{}
	mi := &file_v1_operations_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationRunCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationRunCommand) ProtoMessage() {}

func (x *OperationRunCommand) ProtoReflect() protoreflect.Message {
	mi := &file_v1_operations_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationRunCommand.ProtoReflect.Descriptor instead.
func (*OperationRunCommand) Descriptor() ([]byte, []int) {
	return file_v1_operations_proto_rawDescGZIP(), []int{8}
}

func (x *OperationRunCommand) GetCommand() string {
	if x != nil {
		return x.Command
	}
	return ""
}

func (x *OperationRunCommand) GetOutputLogref() string {
	if x != nil {
		return x.OutputLogref
	}
	return ""
}

func (x *OperationRunCommand) GetOutputSizeBytes() int64 {
	if x != nil {
		return x.OutputSizeBytes
	}
	return 0
}

// OperationRestore tracks a restore operation.
type OperationRestore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path       string                `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`                               // path in the snapshot to restore.
	Target     string                `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`                           // location to restore it to.
	LastStatus *RestoreProgressEntry `protobuf:"bytes,3,opt,name=last_status,json=lastStatus,proto3" json:"last_status,omitempty"` // status of the restore.
}

func (x *OperationRestore) Reset() {
	*x = OperationRestore{}
	mi := &file_v1_operations_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationRestore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationRestore) ProtoMessage() {}

func (x *OperationRestore) ProtoReflect() protoreflect.Message {
	mi := &file_v1_operations_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationRestore.ProtoReflect.Descriptor instead.
func (*OperationRestore) Descriptor() ([]byte, []int) {
	return file_v1_operations_proto_rawDescGZIP(), []int{9}
}

func (x *OperationRestore) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *OperationRestore) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationRestore) GetLastStatus() *RestoreProgressEntry {
	if x != nil {
		return x.LastStatus
	}
	return nil
}

// OperationStats tracks a stats operation.
type OperationStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Stats *RepoStats `protobuf:"bytes,1,opt,name=stats,proto3" json:"stats,omitempty"`
}

func (x *OperationStats) Reset() {
	*x = OperationStats{}
	mi := &file_v1_operations_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationStats) ProtoMessage() {}

func (x *OperationStats) ProtoReflect() protoreflect.Message {
	mi := &file_v1_operations_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationStats.ProtoReflect.Descriptor instead.
func (*OperationStats) Descriptor() ([]byte, []int) {
	return file_v1_operations_proto_rawDescGZIP(), []int{10}
}

func (x *OperationStats) GetStats() *RepoStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

// OperationRunHook tracks a hook that was run.
type OperationRunHook struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ParentOp     int64          `protobuf:"varint,4,opt,name=parent_op,json=parentOp,proto3" json:"parent_op,omitempty"`            // ID of the operation that ran the hook.
	Name         string         `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`                                     // description of the hook that was run. typically repo/hook_idx or plan/hook_idx.
	OutputLogref string         `protobuf:"bytes,2,opt,name=output_logref,json=outputLogref,proto3" json:"output_logref,omitempty"` // logref of the hook's output. DEPRECATED.
	Condition    Hook_Condition `protobuf:"varint,3,opt,name=condition,proto3,enum=v1.Hook_Condition" json:"condition,omitempty"`   // triggering condition of the hook.
}

func (x *OperationRunHook) Reset() {
	*x = OperationRunHook{}
	mi := &file_v1_operations_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationRunHook) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationRunHook) ProtoMessage() {}

func (x *OperationRunHook) ProtoReflect() protoreflect.Message {
	mi := &file_v1_operations_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationRunHook.ProtoReflect.Descriptor instead.
func (*OperationRunHook) Descriptor() ([]byte, []int) {
	return file_v1_operations_proto_rawDescGZIP(), []int{11}
}

func (x *OperationRunHook) GetParentOp() int64 {
	if x != nil {
		return x.ParentOp
	}
	return 0
}

func (x *OperationRunHook) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *OperationRunHook) GetOutputLogref() string {
	if x != nil {
		return x.OutputLogref
	}
	return ""
}

func (x *OperationRunHook) GetCondition() Hook_Condition {
	if x != nil {
		return x.Condition
	}
	return Hook_CONDITION_UNKNOWN
}

var File_v1_operations_proto protoreflect.FileDescriptor

var file_v1_operations_proto_rawDesc = []byte{
	0x0a, 0x13, 0x76, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x02, 0x76, 0x31, 0x1a, 0x0f, 0x76, 0x31, 0x2f, 0x72, 0x65,
	0x73, 0x74, 0x69, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x0f, 0x76, 0x31, 0x2f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x11, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x3e,
	0x0a, 0x0d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12,
	0x2d, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x9b,
	0x09, 0x0a, 0x09, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1f, 0x0a, 0x0b,
	0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0a, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x14, 0x0a,
	0x05, 0x6d, 0x6f, 0x64, 0x6e, 0x6f, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6d, 0x6f,
	0x64, 0x6e, 0x6f, 0x12, 0x17, 0x0a, 0x07, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x69, 0x64, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x10,
	0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x69, 0x64,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c,
	0x46, 0x6c, 0x6f, 0x77, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x72, 0x65, 0x70, 0x6f, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x70, 0x6f, 0x49, 0x64, 0x12,
	0x1b, 0x0a, 0x09, 0x72, 0x65, 0x70, 0x6f, 0x5f, 0x67, 0x75, 0x69, 0x64, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x70, 0x6f, 0x47, 0x75, 0x69, 0x64, 0x12, 0x17, 0x0a, 0x07,
	0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70,
	0x6c, 0x61, 0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x36, 0x0a, 0x17, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x69,
	0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61,
	0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x69, 0x64, 0x12, 0x1f,
	0x0a, 0x0b, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x49, 0x64, 0x12,
	0x2b, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x13, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2b, 0x0a, 0x12,
	0x75, 0x6e, 0x69, 0x78, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x6d, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x75, 0x6e, 0x69, 0x78, 0x54, 0x69,
	0x6d, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x73, 0x12, 0x27, 0x0a, 0x10, 0x75, 0x6e, 0x69,
	0x78, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x6d, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0d, 0x75, 0x6e, 0x69, 0x78, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x6e, 0x64,
	0x4d, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6c,
	0x6f, 0x67, 0x72, 0x65, 0x66, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6c, 0x6f, 0x67,
	0x72, 0x65, 0x66, 0x12, 0x40, 0x0a, 0x10, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x48, 0x00, 0x52, 0x0f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x56, 0x0a, 0x18, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x48, 0x00, 0x52, 0x16, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x40, 0x0a,
	0x10, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x6f, 0x72, 0x67, 0x65,
	0x74, 0x18, 0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x6f, 0x72, 0x67, 0x65, 0x74, 0x48, 0x00, 0x52, 0x0f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x6f, 0x72, 0x67, 0x65, 0x74, 0x12,
	0x3d, 0x0a, 0x0f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x75,
	0x6e, 0x65, 0x18, 0x67, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x75, 0x6e, 0x65, 0x48, 0x00, 0x52, 0x0e,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x75, 0x6e, 0x65, 0x12, 0x43,
	0x0a, 0x11, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x18, 0x68, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x48,
	0x00, 0x52, 0x10, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x12, 0x3d, 0x0a, 0x0f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x69, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x48, 0x00, 0x52, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x44, 0x0a, 0x12, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x72, 0x75, 0x6e, 0x5f, 0x68, 0x6f, 0x6f, 0x6b, 0x18, 0x6a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e,
	0x48, 0x6f, 0x6f, 0x6b, 0x48, 0x00, 0x52, 0x10, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x75, 0x6e, 0x48, 0x6f, 0x6f, 0x6b, 0x12, 0x3d, 0x0a, 0x0f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x18, 0x6b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x48, 0x00, 0x52, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x4d, 0x0a, 0x15, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x18, 0x6c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x48,
	0x00, 0x52, 0x13, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x42, 0x04, 0x0a, 0x02, 0x6f, 0x70, 0x22, 0x93, 0x02, 0x0a,
	0x0e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12,
	0x2d, 0x0a, 0x0a, 0x6b, 0x65, 0x65, 0x70, 0x5f, 0x61, 0x6c, 0x69, 0x76, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x48, 0x00, 0x52, 0x09, 0x6b, 0x65, 0x65, 0x70, 0x41, 0x6c, 0x69, 0x76, 0x65, 0x12, 0x42,
	0x0a, 0x12, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52,
	0x11, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x42, 0x0a, 0x12, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73,
	0x74, 0x48, 0x00, 0x52, 0x11, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x41, 0x0a, 0x12, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x10, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x11, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x22, 0x7c, 0x0a, 0x0f, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x38, 0x0a, 0x0b, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0a, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x2f, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73,
	0x22, 0x60, 0x0a, 0x16, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x2e, 0x0a, 0x08, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x69, 0x63, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x52, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x6f,
	0x72, 0x67, 0x6f, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x67,
	0x6f, 0x74, 0x22, 0x6a, 0x0a, 0x0f, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46,
	0x6f, 0x72, 0x67, 0x65, 0x74, 0x12, 0x2a, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x67, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x69,
	0x63, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x67, 0x65,
	0x74, 0x12, 0x2b, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x13, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x51,
	0x0a, 0x0e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x75, 0x6e, 0x65,
	0x12, 0x1a, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x23, 0x0a, 0x0d,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6c, 0x6f, 0x67, 0x72, 0x65, 0x66, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4c, 0x6f, 0x67, 0x72, 0x65,
	0x66, 0x22, 0x51, 0x0a, 0x0e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x12, 0x1a, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12,
	0x23, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6c, 0x6f, 0x67, 0x72, 0x65, 0x66,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4c, 0x6f,
	0x67, 0x72, 0x65, 0x66, 0x22, 0x80, 0x01, 0x0a, 0x13, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x18, 0x0a, 0x07,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x6c, 0x6f, 0x67, 0x72, 0x65, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x4c, 0x6f, 0x67, 0x72, 0x65, 0x66, 0x12, 0x2a, 0x0a, 0x11, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x69,
	0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x79, 0x0a, 0x10, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12,
	0x16, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x39, 0x0a, 0x0b, 0x6c, 0x61, 0x73, 0x74, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x22, 0x35, 0x0a, 0x0e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x12, 0x23, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x22, 0x9a, 0x01, 0x0a, 0x10, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x48, 0x6f, 0x6f, 0x6b, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x08, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x4f, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6c, 0x6f, 0x67, 0x72, 0x65, 0x66,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4c, 0x6f,
	0x67, 0x72, 0x65, 0x66, 0x12, 0x30, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6f, 0x6f,
	0x6b, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2a, 0x60, 0x0a, 0x12, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x11, 0x0a, 0x0d,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12,
	0x11, 0x0a, 0x0d, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x50, 0x44, 0x41,
	0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x03, 0x2a, 0xc2, 0x01, 0x0a, 0x0f, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12, 0x0a, 0x0e,
	0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00,
	0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x50, 0x45, 0x4e, 0x44, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x49,
	0x4e, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x53,
	0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x03, 0x12,
	0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e,
	0x47, 0x10, 0x07, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x04, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f,
	0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44,
	0x10, 0x05, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x53, 0x45,
	0x52, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x42, 0x2c, 0x5a,
	0x2a, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x61, 0x72, 0x65,
	0x74, 0x68, 0x67, 0x65, 0x6f, 0x72, 0x67, 0x65, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x72, 0x65, 0x73,
	0x74, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_v1_operations_proto_rawDescOnce sync.Once
	file_v1_operations_proto_rawDescData = file_v1_operations_proto_rawDesc
)

func file_v1_operations_proto_rawDescGZIP() []byte {
	file_v1_operations_proto_rawDescOnce.Do(func() {
		file_v1_operations_proto_rawDescData = protoimpl.X.CompressGZIP(file_v1_operations_proto_rawDescData)
	})
	return file_v1_operations_proto_rawDescData
}

var file_v1_operations_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_v1_operations_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_v1_operations_proto_goTypes = []any{
	(OperationEventType)(0),        // 0: v1.OperationEventType
	(OperationStatus)(0),           // 1: v1.OperationStatus
	(*OperationList)(nil),          // 2: v1.OperationList
	(*Operation)(nil),              // 3: v1.Operation
	(*OperationEvent)(nil),         // 4: v1.OperationEvent
	(*OperationBackup)(nil),        // 5: v1.OperationBackup
	(*OperationIndexSnapshot)(nil), // 6: v1.OperationIndexSnapshot
	(*OperationForget)(nil),        // 7: v1.OperationForget
	(*OperationPrune)(nil),         // 8: v1.OperationPrune
	(*OperationCheck)(nil),         // 9: v1.OperationCheck
	(*OperationRunCommand)(nil),    // 10: v1.OperationRunCommand
	(*OperationRestore)(nil),       // 11: v1.OperationRestore
	(*OperationStats)(nil),         // 12: v1.OperationStats
	(*OperationRunHook)(nil),       // 13: v1.OperationRunHook
	(*types.Empty)(nil),            // 14: types.Empty
	(*types.Int64List)(nil),        // 15: types.Int64List
	(*BackupProgressEntry)(nil),    // 16: v1.BackupProgressEntry
	(*BackupProgressError)(nil),    // 17: v1.BackupProgressError
	(*ResticSnapshot)(nil),         // 18: v1.ResticSnapshot
	(*RetentionPolicy)(nil),        // 19: v1.RetentionPolicy
	(*RestoreProgressEntry)(nil),   // 20: v1.RestoreProgressEntry
	(*RepoStats)(nil),              // 21: v1.RepoStats
	(Hook_Condition)(0),            // 22: v1.Hook.Condition
}
var file_v1_operations_proto_depIdxs = []int32{
	3,  // 0: v1.OperationList.operations:type_name -> v1.Operation
	1,  // 1: v1.Operation.status:type_name -> v1.OperationStatus
	5,  // 2: v1.Operation.operation_backup:type_name -> v1.OperationBackup
	6,  // 3: v1.Operation.operation_index_snapshot:type_name -> v1.OperationIndexSnapshot
	7,  // 4: v1.Operation.operation_forget:type_name -> v1.OperationForget
	8,  // 5: v1.Operation.operation_prune:type_name -> v1.OperationPrune
	11, // 6: v1.Operation.operation_restore:type_name -> v1.OperationRestore
	12, // 7: v1.Operation.operation_stats:type_name -> v1.OperationStats
	13, // 8: v1.Operation.operation_run_hook:type_name -> v1.OperationRunHook
	9,  // 9: v1.Operation.operation_check:type_name -> v1.OperationCheck
	10, // 10: v1.Operation.operation_run_command:type_name -> v1.OperationRunCommand
	14, // 11: v1.OperationEvent.keep_alive:type_name -> types.Empty
	2,  // 12: v1.OperationEvent.created_operations:type_name -> v1.OperationList
	2,  // 13: v1.OperationEvent.updated_operations:type_name -> v1.OperationList
	15, // 14: v1.OperationEvent.deleted_operations:type_name -> types.Int64List
	16, // 15: v1.OperationBackup.last_status:type_name -> v1.BackupProgressEntry
	17, // 16: v1.OperationBackup.errors:type_name -> v1.BackupProgressError
	18, // 17: v1.OperationIndexSnapshot.snapshot:type_name -> v1.ResticSnapshot
	18, // 18: v1.OperationForget.forget:type_name -> v1.ResticSnapshot
	19, // 19: v1.OperationForget.policy:type_name -> v1.RetentionPolicy
	20, // 20: v1.OperationRestore.last_status:type_name -> v1.RestoreProgressEntry
	21, // 21: v1.OperationStats.stats:type_name -> v1.RepoStats
	22, // 22: v1.OperationRunHook.condition:type_name -> v1.Hook.Condition
	23, // [23:23] is the sub-list for method output_type
	23, // [23:23] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_v1_operations_proto_init() }
func file_v1_operations_proto_init() {
	if File_v1_operations_proto != nil {
		return
	}
	file_v1_restic_proto_init()
	file_v1_config_proto_init()
	file_v1_operations_proto_msgTypes[1].OneofWrappers = []any{
		(*Operation_OperationBackup)(nil),
		(*Operation_OperationIndexSnapshot)(nil),
		(*Operation_OperationForget)(nil),
		(*Operation_OperationPrune)(nil),
		(*Operation_OperationRestore)(nil),
		(*Operation_OperationStats)(nil),
		(*Operation_OperationRunHook)(nil),
		(*Operation_OperationCheck)(nil),
		(*Operation_OperationRunCommand)(nil),
	}
	file_v1_operations_proto_msgTypes[2].OneofWrappers = []any{
		(*OperationEvent_KeepAlive)(nil),
		(*OperationEvent_CreatedOperations)(nil),
		(*OperationEvent_UpdatedOperations)(nil),
		(*OperationEvent_DeletedOperations)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_v1_operations_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_v1_operations_proto_goTypes,
		DependencyIndexes: file_v1_operations_proto_depIdxs,
		EnumInfos:         file_v1_operations_proto_enumTypes,
		MessageInfos:      file_v1_operations_proto_msgTypes,
	}.Build()
	File_v1_operations_proto = out.File
	file_v1_operations_proto_rawDesc = nil
	file_v1_operations_proto_goTypes = nil
	file_v1_operations_proto_depIdxs = nil
}
