# SSH Remote

This guide will walk you through the creation of a remote repository using SSH.

Before beginning, be aware that SSH remotes are an advanced topic and basic familiarity with SSH and Unix shell is assumed.

## Prerequisites

- SSH client installed on your local machine
- Access to a remote server with SSH enabled
- Basic understanding of SSH key authentication
- Sufficient storage space on the remote server

## Setup

### Step 1: Create SSH Configuration Directory

First, create a directory to store your SSH configuration files:

```bash
mkdir -p ~/.config/backrest/ssh
```

### Step 2: Configure SSH Connection

Create an SSH config file to define your connection parameters:

```bash
cat > ~/.config/backrest/ssh/config << EOF
Host backrest-remote
    Hostname example.com
    Port 22
    User your-username
    IdentityFile ~/.config/backrest/ssh/id_rsa
EOF
```

Replace:
- `backrest-remote` with a memorable name for this connection
- `example.com` with your server's hostname or IP address
- `22` with your SSH port (if different from the default)
- `your-username` with your username on the remote server

### Step 3: Generate SSH Key (if needed)

If you don't already have an SSH key to use, generate one:

```bash
ssh-keygen -f ~/.config/backrest/ssh/id_rsa -C "backrest-backup-key"
```

### Step 4: Add Key to Remote Server

Copy your public key to the remote server:

```bash
ssh-copy-id -i ~/.config/backrest/ssh/id_rsa.pub your-username@example.com
```

### Step 5: Generate Known Hosts File

Create a known_hosts file with your server's fingerprint:

```bash
ssh-keyscan -H example.com > ~/.config/backrest/ssh/known_hosts
```

### Step 6: Set Permissions

Set the appropriate permissions for your SSH files:

```bash
chmod 700 ~/.config/backrest/ssh
chmod 600 ~/.config/backrest/ssh/*
```

If you're running Backrest as root or in a container, you may need to adjust ownership:

```bash
# Only if running as root or in a container
sudo chown -R root:root ~/.config/backrest/ssh/
```

### Step 7: Configure Backrest

#### For Docker Installations

If you're running Backrest in Docker, update your `compose.yml` to mount the SSH directory:

```yml
services:
  backrest:
    # ... other configuration ...
    volumes:
      # ... other volumes ...
      - ~/.config/backrest/ssh:/root/.ssh
```

#### For Native Installations

For native installations, Backrest will use the SSH directory you specified in the previous steps.

### Step 8: Add Repository in Backrest

In the Backrest web interface:

1. Click "Add Repository"
2. Select "SFTP" as the repository type
3. Enter the repository URL in the format: `sftp:backrest-remote:/path/to/backup/location`
   - `backrest-remote` is the host name from your SSH config
   - `/path/to/backup/location` is the directory on the remote server where backups will be stored
4. Set the SSH directory to: `~/.config/backrest/ssh` (or `/root/.ssh` if running in Docker)
5. Enter your repository password (this is for encrypting backups, not your SSH password)
6. Click "Initialize Repository" (or "Connect to Existing" if the repository already exists)

## Troubleshooting

If you encounter connection issues:

1. Check that your SSH key has the correct permissions: `chmod 600 ~/.config/backrest/ssh/id_rsa`
2. Verify you can connect manually: `ssh -F ~/.config/backrest/ssh/config backrest-remote`
3. Ensure the remote directory exists and is writable
4. Check Backrest logs for detailed error messages
