# Slack Hook Build Kit Examples

## Overview

When using the Slack Hook you can provide a simple message or a [Slack Block Kit](https://api.slack.com/block-kit) message. You can leverage the [Block Kit Builder](https://app.slack.com/block-kit-builder) to Preview the message.

## Clean Job Summary

<div style="text-align: center;">
<img src="/screenshots/slack-clean-job.png" alt="Settings View" style="width: 700px; height: auto;" />
</div>

```
{
  "blocks": [
    {
      "type": "section",
      "text": {
        "type": "mrkdwn",
        "text": "Backup: *{{ .Plan.Id }}* ➝ *{{ .Repo.Id }}* at *{{ .FormatTime .CurTime }}*"
      }
    },
    {
      "type": "divider"
    },
    {{ if .Error }}
    {
      "type": "section",
      "text": {
        "type": "mrkdwn",
        "text": ":x: *Snapshot failed:*\n```{{ .Error }}```"
      }
    }
    {{ else }}
    {
      "type": "section",
      "text": {
        "type": "mrkdwn",
        "text": ":white_check_mark: *Snapshot `{{ .SnapshotId }}` created*"
      }
    },
    {
      "type": "section",
      "fields": [
        {
          "type": "mrkdwn",
          "text": "*Total Added:*\n`{{ .FormatSizeBytes .SnapshotStats.DataAdded }}`"
        },
        {
          "type": "mrkdwn",
          "text": "*Files Processed:*\n`{{ .SnapshotStats.TotalFilesProcessed }}`"
        },
        {
          "type": "mrkdwn",
          "text": "*Bytes Processed:*\n`{{ .FormatSizeBytes .SnapshotStats.TotalBytesProcessed }}`"
        },
        {
          "type": "mrkdwn",
          "text": "*Time:*\n`{{ .SnapshotStats.TotalDuration }}s`"
        }
      ]
    },
    {
      "type": "section",
      "text": {
        "type": "mrkdwn",
        "text": "*Backup Stats:*\n• *Files:* `{{ .SnapshotStats.FilesNew }} new`, `{{ .SnapshotStats.FilesChanged }} changed`, `{{ .SnapshotStats.FilesUnmodified }} unmodified`\n• *Dirs:* `{{ .SnapshotStats.DirsNew }} new`, `{{ .SnapshotStats.DirsChanged }} changed`, `{{ .SnapshotStats.DirsUnmodified }} unmodified`"
      }
    }
    {{ end }}
  ]
}
```