# API

Backrest provides a limited HTTP API for interacting with the backrest service. To use the API authentication must be disabled (or you can optionally provide a username and password with basic auth headers) e.g. `curl -u user:password http://localhost:9898/v1/<endpoint>`

All of Backrest's API endpoints are defined as a gRPC service and are exposed over HTTP by a JSON RPC gateway for easy scripting. For the full service definition see [service.proto](https://github.com/garethgeorge/backrest/blob/main/proto/v1/service.proto).

::alert{type="warning"}
Only the APIs documented below are considered stable, other endpoints may be subject to change.
::

### Backup API

The backup API can be used to trigger execution of a plan e.g. 

```
curl -X POST 'localhost:9898/v1.Backrest/Backup' --data '{"value": "YOUR_PLAN_ID"}' -H 'Content-Type: application/json'
```

The request will block until the operation has completed. A 200 response means the backup completed successfully, if the request times out the operation will continue in the background.
### Operations API 

The operations API can be used to fetch operation history e.g. 

```
curl -X POST 'localhost:9898/v1.Backrest/GetOperations' --data '{}' -H 'Content-Type: application/json'
```

More complex selectors can be applied e.g. 

```
curl -X POST 'localhost:9898/v1.Backrest/GetOperations' --data '{"selector": {"planId": "YOUR_PLAN_ID"}}' -H 'Content-Type: application/json'
```

For details on the structure of operations returned see the [operations.proto](https://github.com/garethgeorge/backrest/blob/main/proto/v1/operations.proto).

::alert{type="warning"}
The structure of the operation history is subject to change over time. Different fields may be added or removed in future versions.
::
