# Restore Files

This guide will walk you through the basic steps of using Backrest to restore files.

## Prerequisites

- A running Backrest instance
- A repo configured in Backrest

## Indexing Snapshots

A snapshot is a point-in-time backup of your files. This is interchangeable with the term "backup". To restore files, you first need to index the snapshots in your repository. This is done automatically by Backrest when you 

 1. first add a repository
 2. run a backup
 
if you have recently added your repository or are using backrest to regularly create backups there is nothing to do here. If you've created your backups some other way, you may need to index them before they will show up in the UI. To do this, click the "Index Snapshots" button in the repository view.

<img src="/screenshots/index-snapshots-btn.png" alt="Index Snapshots Button" style="width: 700px; height: auto;" />

## Restoring a Snapshot

Once your snapshots are indexed, they are visible in backrest in a tree view ordered by their creation timestamp. To view details about a snapshot, click on it in the tree view. This will open a side panel with the history of operations that created the snapshot (if it was created by this backrest install) as well as the snapshot operation itself which includes:

 * Metadata about the snapshot
 * Snapshot browser which can be used to browse and restore files in the snapshot

<img src="/screenshots/tree-view-for-restore-article.png" alt="Tree View for Restore Article" style="width: 700px; height: auto;" />

To restore a snapshot start by browsing for the files you'd like to restore. Click on the "Snapshot Browser" shown in the red box in the image above. This view will expand to show the files in your snapshot. 

::alert{type="warning"}
If your repo is using remote storage browsing can be very slow as restic fetches pack files to index the directory structure of your snapshot.
::

Once you have found the directory you'd like to restore, hover over the directory and click the restore icon and select "Restore to path". The restore location options are

 1. Restore to a specific location, the default populated location will be the folder name + the first 8 digets of the snapshot's ID.
 2. If the location is left empty, Backrest will attempt to locate and restore to your Downloads directory.

Once you have selected a location, click "Restore". Backrest will begin the restore process as a new operation visible at the top of the operation tree. You can monitor the progress of the restore in the operation tree.

<img src="/screenshots/restore-progress.png" alt="Restore Progress" style="width: 700px; height: auto;" />

