---
title: Home
navigation: false
layout: page
main:
  fluid: false
---

:ellipsis{right=0px width=75% blur=150px}

::block-hero
---
cta:
  - Get started
  - /introduction/getting-started
secondary:
  - Open on GitHub →
  - https://github.com/garethgeorge/backrest
---

#title
Web UI and orchestrator for [Restic](https://restic.net) backup.

#description

Backrest is a web-accessible backup solution built on top of [restic](https://restic.net/) and providing a WebUI which wraps the restic CLI and makes it easy to create repos, browse snapshots, and restore files. Additionally, Backrest can run in the background and take an opinionated approach to scheduling snapshots and orchestrating repo health operations.


#extra
  ::list
  - Import your existing restic repositories
  - Cron scheduled backups and health operations (e.g. prune and forget)
  - UI for browsing and restoring files from snapshots
  - Configurable backup notifications (e.g. Discord, Slack, Shoutrrr, Gotify)
  - Add shell command hooks to run before and after backup operations.
  - Compatible with rclone remotes
  - Cross-platform support (Linux, macOS, Windows, FreeBSD, [Docker](https://hub.docker.com/r/garethgeorge/backrest))
  - Backup to any restic supported storage (e.g. S3, B2, Azure, GCS, local, SFTP, and all [rclone remotes](https://rclone.org/))
  ::

#support
::code-group
```bash [MacOS]
brew tap garethgeorge/homebrew-backrest-tap
brew install backrest
brew services start backrest
```
```bash [Arch Linux]
paru -Sy backrest
sudo systemctl enable --now backrest@$USER.service
```
```yaml [docker-compose]
version: "3.2"
services:
  backrest:
    image: garethgeorge/backrest
    container_name: backrest
    hostname: backrest
    volumes:
      - ./backrest/data:/data
      - ./backrest/config:/config
      - ./backrest/cache:/cache
    environment:
      - BACKREST_DATA=/data
      - BACKREST_CONFIG=/config/config.json 
      - XDG_CACHE_HOME=/cache 
      - TZ=America/Los_Angeles
    restart: unless-stopped
    ports:
      - 9898:9898
```
::
::
