// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        (unknown)
// source: github.com/gunk/opt/openapiv2/all.proto

package openapiv2

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Scheme describes the schemes supported by the OpenAPI Swagger
// and Operation objects.
type Scheme int32

const (
	Scheme_SwaggerSchemeUNKNOWN Scheme = 0
	Scheme_HTTP                 Scheme = 1
	Scheme_HTTPS                Scheme = 2
	Scheme_WS                   Scheme = 3
	Scheme_WSS                  Scheme = 4
)

// Enum value maps for Scheme.
var (
	Scheme_name = map[int32]string{
		0: "SwaggerSchemeUNKNOWN",
		1: "HTTP",
		2: "HTTPS",
		3: "WS",
		4: "WSS",
	}
	Scheme_value = map[string]int32{
		"SwaggerSchemeUNKNOWN": 0,
		"HTTP":                 1,
		"HTTPS":                2,
		"WS":                   3,
		"WSS":                  4,
	}
)

func (x Scheme) Enum() *Scheme {
	p := new(Scheme)
	*p = x
	return p
}

func (x Scheme) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Scheme) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_gunk_opt_openapiv2_all_proto_enumTypes[0].Descriptor()
}

func (Scheme) Type() protoreflect.EnumType {
	return &file_github_com_gunk_opt_openapiv2_all_proto_enumTypes[0]
}

func (x Scheme) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Scheme.Descriptor instead.
func (Scheme) EnumDescriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{0}
}

type JSONSchemaSimpleTypes int32

const (
	JSONSchemaSimpleTypes_JSONSchemaSimpleTypes_UNKNOWN JSONSchemaSimpleTypes = 0
	JSONSchemaSimpleTypes_ARRAY                         JSONSchemaSimpleTypes = 1
	JSONSchemaSimpleTypes_BOOLEAN                       JSONSchemaSimpleTypes = 2
	JSONSchemaSimpleTypes_INTEGER                       JSONSchemaSimpleTypes = 3
	JSONSchemaSimpleTypes_NULL                          JSONSchemaSimpleTypes = 4
	JSONSchemaSimpleTypes_NUMBER                        JSONSchemaSimpleTypes = 5
	JSONSchemaSimpleTypes_OBJECT                        JSONSchemaSimpleTypes = 6
	JSONSchemaSimpleTypes_STRING                        JSONSchemaSimpleTypes = 7
)

// Enum value maps for JSONSchemaSimpleTypes.
var (
	JSONSchemaSimpleTypes_name = map[int32]string{
		0: "JSONSchemaSimpleTypes_UNKNOWN",
		1: "ARRAY",
		2: "BOOLEAN",
		3: "INTEGER",
		4: "NULL",
		5: "NUMBER",
		6: "OBJECT",
		7: "STRING",
	}
	JSONSchemaSimpleTypes_value = map[string]int32{
		"JSONSchemaSimpleTypes_UNKNOWN": 0,
		"ARRAY":                         1,
		"BOOLEAN":                       2,
		"INTEGER":                       3,
		"NULL":                          4,
		"NUMBER":                        5,
		"OBJECT":                        6,
		"STRING":                        7,
	}
)

func (x JSONSchemaSimpleTypes) Enum() *JSONSchemaSimpleTypes {
	p := new(JSONSchemaSimpleTypes)
	*p = x
	return p
}

func (x JSONSchemaSimpleTypes) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JSONSchemaSimpleTypes) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_gunk_opt_openapiv2_all_proto_enumTypes[1].Descriptor()
}

func (JSONSchemaSimpleTypes) Type() protoreflect.EnumType {
	return &file_github_com_gunk_opt_openapiv2_all_proto_enumTypes[1]
}

func (x JSONSchemaSimpleTypes) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JSONSchemaSimpleTypes.Descriptor instead.
func (JSONSchemaSimpleTypes) EnumDescriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{1}
}

// The type of the security scheme. Valid values are "basic",
// "apiKey" or "oauth2".
type Type int32

const (
	Type_TYPE_INVALID Type = 0
	Type_TYPE_BASIC   Type = 1
	Type_TYPE_API_KEY Type = 2
	Type_TYPE_OAUTH2  Type = 3
)

// Enum value maps for Type.
var (
	Type_name = map[int32]string{
		0: "TYPE_INVALID",
		1: "TYPE_BASIC",
		2: "TYPE_API_KEY",
		3: "TYPE_OAUTH2",
	}
	Type_value = map[string]int32{
		"TYPE_INVALID": 0,
		"TYPE_BASIC":   1,
		"TYPE_API_KEY": 2,
		"TYPE_OAUTH2":  3,
	}
)

func (x Type) Enum() *Type {
	p := new(Type)
	*p = x
	return p
}

func (x Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Type) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_gunk_opt_openapiv2_all_proto_enumTypes[2].Descriptor()
}

func (Type) Type() protoreflect.EnumType {
	return &file_github_com_gunk_opt_openapiv2_all_proto_enumTypes[2]
}

func (x Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Type.Descriptor instead.
func (Type) EnumDescriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{2}
}

// The location of the API key. Valid values are "query" or "header".
type In int32

const (
	In_IN_INVALID In = 0
	In_IN_QUERY   In = 1
	In_IN_HEADER  In = 2
)

// Enum value maps for In.
var (
	In_name = map[int32]string{
		0: "IN_INVALID",
		1: "IN_QUERY",
		2: "IN_HEADER",
	}
	In_value = map[string]int32{
		"IN_INVALID": 0,
		"IN_QUERY":   1,
		"IN_HEADER":  2,
	}
)

func (x In) Enum() *In {
	p := new(In)
	*p = x
	return p
}

func (x In) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (In) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_gunk_opt_openapiv2_all_proto_enumTypes[3].Descriptor()
}

func (In) Type() protoreflect.EnumType {
	return &file_github_com_gunk_opt_openapiv2_all_proto_enumTypes[3]
}

func (x In) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use In.Descriptor instead.
func (In) EnumDescriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{3}
}

// The flow used by the OAuth2 security scheme. Valid values are
// "implicit", "password", "application" or "accessCode".
type Flow int32

const (
	Flow_FLOW_INVALID     Flow = 0
	Flow_FLOW_IMPLICIT    Flow = 1
	Flow_FLOW_PASSWORD    Flow = 2
	Flow_FLOW_APPLICATION Flow = 3
	Flow_FLOW_ACCESS_CODE Flow = 4
)

// Enum value maps for Flow.
var (
	Flow_name = map[int32]string{
		0: "FLOW_INVALID",
		1: "FLOW_IMPLICIT",
		2: "FLOW_PASSWORD",
		3: "FLOW_APPLICATION",
		4: "FLOW_ACCESS_CODE",
	}
	Flow_value = map[string]int32{
		"FLOW_INVALID":     0,
		"FLOW_IMPLICIT":    1,
		"FLOW_PASSWORD":    2,
		"FLOW_APPLICATION": 3,
		"FLOW_ACCESS_CODE": 4,
	}
)

func (x Flow) Enum() *Flow {
	p := new(Flow)
	*p = x
	return p
}

func (x Flow) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Flow) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_gunk_opt_openapiv2_all_proto_enumTypes[4].Descriptor()
}

func (Flow) Type() protoreflect.EnumType {
	return &file_github_com_gunk_opt_openapiv2_all_proto_enumTypes[4]
}

func (x Flow) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Flow.Descriptor instead.
func (Flow) EnumDescriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{4}
}

// `Swagger` is a representation of OpenAPI v2 specification's Swagger object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#swaggerObject
//
// Example:
//
//  option (grpc.gateway.protoc_gen_openapiv2.options.openapiv2_swagger) = {
//    info: {
//      title: "Echo API";
//      version: "1.0";
//      description: ";
//      contact: {
//        name: "gRPC-Gateway project";
//        url: "https://github.com/grpc-ecosystem/grpc-gateway";
//        email: "none@example.com";
//      };
//      license: {
//        name: "BSD 3-Clause License";
//        url: "https://github.com/grpc-ecosystem/grpc-gateway/blob/master/LICENSE.txt";
//      };
//    };
//    schemes: HTTPS;
//    consumes: "application/json";
//    produces: "application/json";
//  };
type Swagger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the OpenAPI Specification version being used. It can be
	// used by the OpenAPI UI and other clients to interpret the API listing. The
	// value MUST be "2.0".
	Swagger string `protobuf:"bytes,1,opt,name=Swagger,json=swagger,proto3" json:"Swagger,omitempty"`
	// Provides metadata about the API. The metadata can be used by the
	// clients if needed.
	Info *Info `protobuf:"bytes,2,opt,name=Info,json=info,proto3" json:"Info,omitempty"`
	// The host (name or ip) serving the API. This MUST be the host only and does
	// not include the scheme nor sub-paths. It MAY include a port. If the host is
	// not included, the host serving the documentation is to be used (including
	// the port). The host does not support path templating.
	Host string `protobuf:"bytes,3,opt,name=Host,json=host,proto3" json:"Host,omitempty"`
	// The base path on which the API is served, which is relative to the host. If
	// it is not included, the API is served directly under the host. The value
	// MUST start with a leading slash (/). The basePath does not support path
	// templating.
	// Note that using `base_path` does not change the endpoint paths that are
	// generated in the resulting OpenAPI file. If you wish to use `base_path`
	// with relatively generated OpenAPI paths, the `base_path` prefix must be
	// manually removed from your `google.api.http` paths and your code changed to
	// serve the API from the `base_path`.
	BasePath string `protobuf:"bytes,4,opt,name=BasePath,json=base_path,proto3" json:"BasePath,omitempty"`
	// The transfer protocol of the API. Values MUST be from the list: "http",
	// "https", "ws", "wss". If the schemes is not included, the default scheme to
	// be used is the one used to access the OpenAPI definition itself.
	Schemes []Scheme `protobuf:"varint,5,rep,packed,name=Schemes,json=schemes,proto3,enum=openapiv2.Scheme" json:"Schemes,omitempty"`
	// A list of MIME types the APIs can consume. This is global to all APIs but
	// can be overridden on specific API calls. Value MUST be as described under
	// Mime Types.
	Consumes []string `protobuf:"bytes,6,rep,name=Consumes,json=consumes,proto3" json:"Consumes,omitempty"`
	// A list of MIME types the APIs can produce. This is global to all APIs but
	// can be overridden on specific API calls. Value MUST be as described under
	// Mime Types.
	Produces []string `protobuf:"bytes,7,rep,name=Produces,json=produces,proto3" json:"Produces,omitempty"`
	// An object to hold responses that can be used across operations. This
	// property does not define global responses for all operations.
	Responses map[string]*Response `protobuf:"bytes,10,rep,name=Responses,json=responses,proto3" json:"Responses,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Security scheme definitions that can be used across the specification.
	SecurityDefinitions *SecurityDefinitions `protobuf:"bytes,11,opt,name=SecurityDefinitions,json=security_definitions,proto3" json:"SecurityDefinitions,omitempty"`
	// A declaration of which security schemes are applied for the API as a whole.
	// The list of values describes alternative security schemes that can be used
	// (that is, there is a logical OR between the security requirements).
	// Individual operations can override this definition.
	Security []*SecurityRequirement `protobuf:"bytes,12,rep,name=Security,json=security,proto3" json:"Security,omitempty"`
	// Additional external documentation.
	ExternalDocs *ExternalDocumentation `protobuf:"bytes,14,opt,name=ExternalDocs,json=external_docs,proto3" json:"ExternalDocs,omitempty"`
}

func (x *Swagger) Reset() {
	*x = Swagger{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Swagger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Swagger) ProtoMessage() {}

func (x *Swagger) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Swagger.ProtoReflect.Descriptor instead.
func (*Swagger) Descriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{0}
}

func (x *Swagger) GetSwagger() string {
	if x != nil {
		return x.Swagger
	}
	return ""
}

func (x *Swagger) GetInfo() *Info {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *Swagger) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *Swagger) GetBasePath() string {
	if x != nil {
		return x.BasePath
	}
	return ""
}

func (x *Swagger) GetSchemes() []Scheme {
	if x != nil {
		return x.Schemes
	}
	return nil
}

func (x *Swagger) GetConsumes() []string {
	if x != nil {
		return x.Consumes
	}
	return nil
}

func (x *Swagger) GetProduces() []string {
	if x != nil {
		return x.Produces
	}
	return nil
}

func (x *Swagger) GetResponses() map[string]*Response {
	if x != nil {
		return x.Responses
	}
	return nil
}

func (x *Swagger) GetSecurityDefinitions() *SecurityDefinitions {
	if x != nil {
		return x.SecurityDefinitions
	}
	return nil
}

func (x *Swagger) GetSecurity() []*SecurityRequirement {
	if x != nil {
		return x.Security
	}
	return nil
}

func (x *Swagger) GetExternalDocs() *ExternalDocumentation {
	if x != nil {
		return x.ExternalDocs
	}
	return nil
}

// `Operation` is a representation of OpenAPI v2 specification's Operation object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#operationObject
//
// Example:
//
//  service EchoService {
//    rpc Echo(SimpleMessage) returns (SimpleMessage) {
//      option (google.api.http) = {
//        get: "/v1/example/echo/{id}"
//      };
//
//      option (grpc.gateway.protoc_gen_openapiv2.options.openapiv2_operation) = {
//        summary: "Get a message.";
//        operation_id: "getMessage";
//        tags: "echo";
//        responses: {
//          key: "200"
//            value: {
//            description: "OK";
//          }
//        }
//      };
//    }
//  }
type Operation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of tags for API documentation control. Tags can be used for logical
	// grouping of operations by resources or any other qualifier.
	Tags []string `protobuf:"bytes,1,rep,name=Tags,json=tags,proto3" json:"Tags,omitempty"`
	// A short summary of what the operation does. For maximum readability in the
	// swagger-ui, this field SHOULD be less than 120 characters.
	Summary string `protobuf:"bytes,2,opt,name=Summary,json=summary,proto3" json:"Summary,omitempty"`
	// A verbose explanation of the operation behavior. GFM syntax can be used for
	// rich text representation.
	Description string `protobuf:"bytes,3,opt,name=Description,json=description,proto3" json:"Description,omitempty"`
	// Additional external documentation for this operation.
	ExternalDocs *ExternalDocumentation `protobuf:"bytes,4,opt,name=ExternalDocs,json=external_docs,proto3" json:"ExternalDocs,omitempty"`
	// Unique string used to identify the operation. The id MUST be unique among
	// all operations described in the API. Tools and libraries MAY use the
	// operationId to uniquely identify an operation, therefore, it is recommended
	// to follow common programming naming conventions.
	OperationID string `protobuf:"bytes,5,opt,name=OperationID,json=operation_id,proto3" json:"OperationID,omitempty"`
	// A list of MIME types the operation can consume. This overrides the consumes
	// definition at the OpenAPI Object. An empty value MAY be used to clear the
	// global definition. Value MUST be as described under Mime Types.
	Consumes []string `protobuf:"bytes,6,rep,name=Consumes,json=consumes,proto3" json:"Consumes,omitempty"`
	// A list of MIME types the operation can produce. This overrides the produces
	// definition at the OpenAPI Object. An empty value MAY be used to clear the
	// global definition. Value MUST be as described under Mime Types.
	Produces []string `protobuf:"bytes,7,rep,name=Produces,json=produces,proto3" json:"Produces,omitempty"`
	// The list of possible responses as they are returned from executing this
	// operation.
	Responses map[string]*Response `protobuf:"bytes,9,rep,name=Responses,json=responses,proto3" json:"Responses,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The transfer protocol for the operation. Values MUST be from the list:
	// "http", "https", "ws", "wss". The value overrides the OpenAPI Object
	// schemes definition.
	Schemes []Scheme `protobuf:"varint,10,rep,packed,name=Schemes,json=schemes,proto3,enum=openapiv2.Scheme" json:"Schemes,omitempty"`
	// Declares this operation to be deprecated. Usage of the declared operation
	// should be refrained. Default value is false.
	Deprecated bool `protobuf:"varint,11,opt,name=Deprecated,json=deprecated,proto3" json:"Deprecated,omitempty"`
	// A declaration of which security schemes are applied for this operation. The
	// list of values describes alternative security schemes that can be used
	// (that is, there is a logical OR between the security requirements). This
	// definition overrides any declared top-level security. To remove a top-level
	// security declaration, an empty array can be used.
	Security []*SecurityRequirement `protobuf:"bytes,12,rep,name=Security,json=security,proto3" json:"Security,omitempty"`
}

func (x *Operation) Reset() {
	*x = Operation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Operation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Operation) ProtoMessage() {}

func (x *Operation) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Operation.ProtoReflect.Descriptor instead.
func (*Operation) Descriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{1}
}

func (x *Operation) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *Operation) GetSummary() string {
	if x != nil {
		return x.Summary
	}
	return ""
}

func (x *Operation) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Operation) GetExternalDocs() *ExternalDocumentation {
	if x != nil {
		return x.ExternalDocs
	}
	return nil
}

func (x *Operation) GetOperationID() string {
	if x != nil {
		return x.OperationID
	}
	return ""
}

func (x *Operation) GetConsumes() []string {
	if x != nil {
		return x.Consumes
	}
	return nil
}

func (x *Operation) GetProduces() []string {
	if x != nil {
		return x.Produces
	}
	return nil
}

func (x *Operation) GetResponses() map[string]*Response {
	if x != nil {
		return x.Responses
	}
	return nil
}

func (x *Operation) GetSchemes() []Scheme {
	if x != nil {
		return x.Schemes
	}
	return nil
}

func (x *Operation) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

func (x *Operation) GetSecurity() []*SecurityRequirement {
	if x != nil {
		return x.Security
	}
	return nil
}

// `Header` is a representation of OpenAPI v2 specification's Header object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#headerObject
type Header struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `Description` is a short description of the header.
	Description string `protobuf:"bytes,1,opt,name=Description,json=description,proto3" json:"Description,omitempty"`
	// The type of the object. The value MUST be one of "string", "number", "integer", or "boolean". The "array" type is not supported.
	Type string `protobuf:"bytes,2,opt,name=Type,json=type,proto3" json:"Type,omitempty"`
	// `Format` The extending format for the previously mentioned type.
	Format string `protobuf:"bytes,3,opt,name=Format,json=format,proto3" json:"Format,omitempty"`
	// `Default` Declares the value of the header that the server will use if none is provided.
	// See: https://tools.ietf.org/html/draft-fge-json-schema-validation-00#section-6.2.
	// Unlike JSON Schema this value MUST conform to the defined type for the header.
	Default string `protobuf:"bytes,6,opt,name=Default,json=default,proto3" json:"Default,omitempty"`
	// 'Pattern' See https://tools.ietf.org/html/draft-fge-json-schema-validation-00#section-5.2.3.
	Pattern string `protobuf:"bytes,13,opt,name=Pattern,json=pattern,proto3" json:"Pattern,omitempty"`
}

func (x *Header) Reset() {
	*x = Header{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Header) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Header) ProtoMessage() {}

func (x *Header) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Header.ProtoReflect.Descriptor instead.
func (*Header) Descriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{2}
}

func (x *Header) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Header) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Header) GetFormat() string {
	if x != nil {
		return x.Format
	}
	return ""
}

func (x *Header) GetDefault() string {
	if x != nil {
		return x.Default
	}
	return ""
}

func (x *Header) GetPattern() string {
	if x != nil {
		return x.Pattern
	}
	return ""
}

// `Response` is a representation of OpenAPI v2 specification's Response object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#responseObject
type Response struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `Description` is a short description of the response.
	// GFM syntax can be used for rich text representation.
	Description string `protobuf:"bytes,1,opt,name=Description,json=description,proto3" json:"Description,omitempty"`
	// `Schema` optionally defines the structure of the response.
	// If `Schema` is not provided, it means there is no content to the response.
	Schema *Schema `protobuf:"bytes,2,opt,name=Schema,json=schema,proto3" json:"Schema,omitempty"`
	// `Headers` A list of headers that are sent with the response.
	// `Header` name is expected to be a string in the canonical format of the MIME header key
	// See: https://golang.org/pkg/net/textproto/#CanonicalMIMEHeaderKey
	Headers map[string]*Header `protobuf:"bytes,3,rep,name=Headers,json=headers,proto3" json:"Headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// `Examples` gives per-mimetype response examples.
	// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#example-object
	Examples map[string]string `protobuf:"bytes,4,rep,name=Examples,json=examples,proto3" json:"Examples,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Response) Reset() {
	*x = Response{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Response) ProtoMessage() {}

func (x *Response) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Response.ProtoReflect.Descriptor instead.
func (*Response) Descriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{3}
}

func (x *Response) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Response) GetSchema() *Schema {
	if x != nil {
		return x.Schema
	}
	return nil
}

func (x *Response) GetHeaders() map[string]*Header {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *Response) GetExamples() map[string]string {
	if x != nil {
		return x.Examples
	}
	return nil
}

// `Info` is a representation of OpenAPI v2 specification's Info object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#infoObject
//
// Example:
//
//  option (grpc.gateway.protoc_gen_openapiv2.options.openapiv2_swagger) = {
//    info: {
//      title: "Echo API";
//      version: "1.0";
//      description: ";
//      contact: {
//        name: "gRPC-Gateway project";
//        url: "https://github.com/grpc-ecosystem/grpc-gateway";
//        email: "none@example.com";
//      };
//      license: {
//        name: "BSD 3-Clause License";
//        url: "https://github.com/grpc-ecosystem/grpc-gateway/blob/master/LICENSE.txt";
//      };
//    };
//    ...
//  };
type Info struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The title of the application.
	Title string `protobuf:"bytes,1,opt,name=Title,json=title,proto3" json:"Title,omitempty"`
	// A short description of the application. GFM syntax can be used for rich
	// text representation.
	Description string `protobuf:"bytes,2,opt,name=Description,json=description,proto3" json:"Description,omitempty"`
	// The Terms of Service for the API.
	TermsOfService string `protobuf:"bytes,3,opt,name=TermsOfService,json=terms_of_service,proto3" json:"TermsOfService,omitempty"`
	// The contact information for the exposed API.
	Contact *Contact `protobuf:"bytes,4,opt,name=Contact,json=contact,proto3" json:"Contact,omitempty"`
	// The license information for the exposed API.
	License *License `protobuf:"bytes,5,opt,name=License,json=license,proto3" json:"License,omitempty"`
	// Provides the version of the application API (not to be confused
	// with the specification version).
	Version string `protobuf:"bytes,6,opt,name=Version,json=version,proto3" json:"Version,omitempty"`
}

func (x *Info) Reset() {
	*x = Info{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Info) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Info) ProtoMessage() {}

func (x *Info) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Info.ProtoReflect.Descriptor instead.
func (*Info) Descriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{4}
}

func (x *Info) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Info) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Info) GetTermsOfService() string {
	if x != nil {
		return x.TermsOfService
	}
	return ""
}

func (x *Info) GetContact() *Contact {
	if x != nil {
		return x.Contact
	}
	return nil
}

func (x *Info) GetLicense() *License {
	if x != nil {
		return x.License
	}
	return nil
}

func (x *Info) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// `Contact` is a representation of OpenAPI v2 specification's Contact object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#contactObject
//
// Example:
//
//  option (grpc.gateway.protoc_gen_openapiv2.options.openapiv2_swagger) = {
//    info: {
//      ...
//      contact: {
//        name: "gRPC-Gateway project";
//        url: "https://github.com/grpc-ecosystem/grpc-gateway";
//        email: "none@example.com";
//      };
//      ...
//    };
//    ...
//  };
type Contact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifying name of the contact person/organization.
	Name string `protobuf:"bytes,1,opt,name=Name,json=name,proto3" json:"Name,omitempty"`
	// The URL pointing to the contact information. MUST be in the format of a
	// URL.
	URL string `protobuf:"bytes,2,opt,name=URL,json=url,proto3" json:"URL,omitempty"`
	// The email address of the contact person/organization. MUST be in the format
	// of an email address.
	Email string `protobuf:"bytes,3,opt,name=Email,json=email,proto3" json:"Email,omitempty"`
}

func (x *Contact) Reset() {
	*x = Contact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Contact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Contact) ProtoMessage() {}

func (x *Contact) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Contact.ProtoReflect.Descriptor instead.
func (*Contact) Descriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{5}
}

func (x *Contact) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Contact) GetURL() string {
	if x != nil {
		return x.URL
	}
	return ""
}

func (x *Contact) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

// `License` is a representation of OpenAPI v2 specification's License object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#licenseObject
//
// Example:
//
//  option (grpc.gateway.protoc_gen_openapiv2.options.openapiv2_swagger) = {
//    info: {
//      ...
//      license: {
//        name: "BSD 3-Clause License";
//        url: "https://github.com/grpc-ecosystem/grpc-gateway/blob/master/LICENSE.txt";
//      };
//      ...
//    };
//    ...
//  };
type License struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The license name used for the API.
	Name string `protobuf:"bytes,1,opt,name=Name,json=name,proto3" json:"Name,omitempty"`
	// A URL to the license used for the API. MUST be in the format of a URL.
	URL string `protobuf:"bytes,2,opt,name=URL,json=url,proto3" json:"URL,omitempty"`
}

func (x *License) Reset() {
	*x = License{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *License) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*License) ProtoMessage() {}

func (x *License) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use License.ProtoReflect.Descriptor instead.
func (*License) Descriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{6}
}

func (x *License) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *License) GetURL() string {
	if x != nil {
		return x.URL
	}
	return ""
}

// `ExternalDocumentation` is a representation of OpenAPI v2 specification's
// ExternalDocumentation object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#externalDocumentationObject
//
// Example:
//
//  option (grpc.gateway.protoc_gen_openapiv2.options.openapiv2_swagger) = {
//    ...
//    external_docs: {
//      description: "More about gRPC-Gateway";
//      url: "https://github.com/grpc-ecosystem/grpc-gateway";
//    }
//    ...
//  };
type ExternalDocumentation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A short description of the target documentation. GFM syntax can be used for
	// rich text representation.
	Description string `protobuf:"bytes,1,opt,name=Description,json=description,proto3" json:"Description,omitempty"`
	// The URL for the target documentation. Value MUST be in the format
	// of a URL.
	URL string `protobuf:"bytes,2,opt,name=URL,json=url,proto3" json:"URL,omitempty"`
}

func (x *ExternalDocumentation) Reset() {
	*x = ExternalDocumentation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExternalDocumentation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalDocumentation) ProtoMessage() {}

func (x *ExternalDocumentation) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalDocumentation.ProtoReflect.Descriptor instead.
func (*ExternalDocumentation) Descriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{7}
}

func (x *ExternalDocumentation) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ExternalDocumentation) GetURL() string {
	if x != nil {
		return x.URL
	}
	return ""
}

// `Schema` is a representation of OpenAPI v2 specification's Schema object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#schemaObject
type Schema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JSONSchema *JSONSchema `protobuf:"bytes,1,opt,name=JSONSchema,json=json_schema,proto3" json:"JSONSchema,omitempty"`
	// Adds support for polymorphism. The discriminator is the schema property
	// name that is used to differentiate between other schema that inherit this
	// schema. The property name used MUST be defined at this schema and it MUST
	// be in the required property list. When used, the value MUST be the name of
	// this schema or any schema that inherits it.
	Discriminator string `protobuf:"bytes,2,opt,name=Discriminator,json=discriminator,proto3" json:"Discriminator,omitempty"`
	// Relevant only for Schema "properties" definitions. Declares the property as
	// "read only". This means that it MAY be sent as part of a response but MUST
	// NOT be sent as part of the request. Properties marked as readOnly being
	// true SHOULD NOT be in the required list of the defined schema. Default
	// value is false.
	ReadOnly bool `protobuf:"varint,3,opt,name=ReadOnly,json=read_only,proto3" json:"ReadOnly,omitempty"`
	// Additional external documentation for this schema.
	ExternalDocs *ExternalDocumentation `protobuf:"bytes,5,opt,name=ExternalDocs,json=external_docs,proto3" json:"ExternalDocs,omitempty"`
	// A free-form property to include an example of an instance for this schema in JSON.
	// This is copied verbatim to the output.
	Example string `protobuf:"bytes,6,opt,name=Example,json=example,proto3" json:"Example,omitempty"`
}

func (x *Schema) Reset() {
	*x = Schema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Schema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema) ProtoMessage() {}

func (x *Schema) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema.ProtoReflect.Descriptor instead.
func (*Schema) Descriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{8}
}

func (x *Schema) GetJSONSchema() *JSONSchema {
	if x != nil {
		return x.JSONSchema
	}
	return nil
}

func (x *Schema) GetDiscriminator() string {
	if x != nil {
		return x.Discriminator
	}
	return ""
}

func (x *Schema) GetReadOnly() bool {
	if x != nil {
		return x.ReadOnly
	}
	return false
}

func (x *Schema) GetExternalDocs() *ExternalDocumentation {
	if x != nil {
		return x.ExternalDocs
	}
	return nil
}

func (x *Schema) GetExample() string {
	if x != nil {
		return x.Example
	}
	return ""
}

// `JSONSchema` represents properties from JSON Schema taken, and as used, in
// the OpenAPI v2 spec.
//
// This includes changes made by OpenAPI v2.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#schemaObject
//
// See also: https://cswr.github.io/JsonSchema/spec/basic_types/,
// https://github.com/json-schema-org/json-schema-spec/blob/master/schema.json
//
// Example:
//
//  message SimpleMessage {
//    option (grpc.gateway.protoc_gen_openapiv2.options.openapiv2_schema) = {
//      json_schema: {
//        title: "SimpleMessage"
//        description: "A simple message."
//        required: ["id"]
//      }
//    };
//
//    // Id represents the message identifier.
//    string id = 1; [
//        (grpc.gateway.protoc_gen_openapiv2.options.openapiv2_field) = {
//          {description: "The unique identifier of the simple message."
//        }];
//  }
type JSONSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Ref is used to define an external reference to include in the message.
	// This could be a fully qualified proto message reference, and that type must
	// be imported into the protofile. If no message is identified, the Ref will
	// be used verbatim in the output.
	// For example:
	//  `ref: ".google.protobuf.Timestamp"`.
	Ref string `protobuf:"bytes,3,opt,name=Ref,json=ref,proto3" json:"Ref,omitempty"`
	// The title of the schema.
	Title string `protobuf:"bytes,5,opt,name=Title,json=title,proto3" json:"Title,omitempty"`
	// A short description of the schema.
	Description string `protobuf:"bytes,6,opt,name=Description,json=description,proto3" json:"Description,omitempty"`
	Default     string `protobuf:"bytes,7,opt,name=Default,json=default,proto3" json:"Default,omitempty"`
	ReadOnly    bool   `protobuf:"varint,8,opt,name=ReadOnly,json=read_only,proto3" json:"ReadOnly,omitempty"`
	// A free-form property to include a JSON example of this field. This is copied
	// verbatim to the output swagger.json. Quotes must be escaped.
	// This property is the same for 2.0 and 3.0.0 https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/3.0.0.md#schemaObject  https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#schemaObject
	Example    string  `protobuf:"bytes,9,opt,name=Example,json=example,proto3" json:"Example,omitempty"`
	MultipleOf float64 `protobuf:"fixed64,10,opt,name=MultipleOf,json=multiple_of,proto3" json:"MultipleOf,omitempty"`
	// Maximum represents an inclusive upper limit for a numeric instance. The
	// value of MUST be a number,
	Maximum          float64 `protobuf:"fixed64,11,opt,name=Maximum,json=maximum,proto3" json:"Maximum,omitempty"`
	ExclusiveMaximum bool    `protobuf:"varint,12,opt,name=ExclusiveMaximum,json=exclusive_maximum,proto3" json:"ExclusiveMaximum,omitempty"`
	// Minimum represents an inclusive lower limit for a numeric instance. The
	// value of MUST be a number,
	Minimum          float64  `protobuf:"fixed64,13,opt,name=Minimum,json=minimum,proto3" json:"Minimum,omitempty"`
	ExclusiveMinimum bool     `protobuf:"varint,14,opt,name=ExclusiveMinimum,json=exclusive_minimum,proto3" json:"ExclusiveMinimum,omitempty"`
	MaxLength        uint64   `protobuf:"varint,15,opt,name=MaxLength,json=max_length,proto3" json:"MaxLength,omitempty"`
	MinLength        uint64   `protobuf:"varint,16,opt,name=MinLength,json=min_length,proto3" json:"MinLength,omitempty"`
	Pattern          string   `protobuf:"bytes,17,opt,name=Pattern,json=pattern,proto3" json:"Pattern,omitempty"`
	MaxItems         uint64   `protobuf:"varint,20,opt,name=MaxItems,json=max_items,proto3" json:"MaxItems,omitempty"`
	MinItems         uint64   `protobuf:"varint,21,opt,name=MinItems,json=min_items,proto3" json:"MinItems,omitempty"`
	UniqueItems      bool     `protobuf:"varint,22,opt,name=UniqueItems,json=unique_items,proto3" json:"UniqueItems,omitempty"`
	MaxProperties    uint64   `protobuf:"varint,24,opt,name=MaxProperties,json=max_properties,proto3" json:"MaxProperties,omitempty"`
	MinProperties    uint64   `protobuf:"varint,25,opt,name=MinProperties,json=min_properties,proto3" json:"MinProperties,omitempty"`
	Required         []string `protobuf:"bytes,26,rep,name=Required,json=required,proto3" json:"Required,omitempty"`
	// Items in 'array' must be unique.
	Array []string                `protobuf:"bytes,34,rep,name=Array,json=array,proto3" json:"Array,omitempty"`
	Type  []JSONSchemaSimpleTypes `protobuf:"varint,35,rep,packed,name=Type,json=type,proto3,enum=openapiv2.JSONSchemaSimpleTypes" json:"Type,omitempty"`
	// `Format`
	Format string `protobuf:"bytes,36,opt,name=Format,json=format,proto3" json:"Format,omitempty"`
	// Items in `enum` must be unique https://tools.ietf.org/html/draft-fge-json-schema-validation-00#section-5.5.1
	Enum []string `protobuf:"bytes,46,rep,name=Enum,json=enum,proto3" json:"Enum,omitempty"`
}

func (x *JSONSchema) Reset() {
	*x = JSONSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JSONSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JSONSchema) ProtoMessage() {}

func (x *JSONSchema) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JSONSchema.ProtoReflect.Descriptor instead.
func (*JSONSchema) Descriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{9}
}

func (x *JSONSchema) GetRef() string {
	if x != nil {
		return x.Ref
	}
	return ""
}

func (x *JSONSchema) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *JSONSchema) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *JSONSchema) GetDefault() string {
	if x != nil {
		return x.Default
	}
	return ""
}

func (x *JSONSchema) GetReadOnly() bool {
	if x != nil {
		return x.ReadOnly
	}
	return false
}

func (x *JSONSchema) GetExample() string {
	if x != nil {
		return x.Example
	}
	return ""
}

func (x *JSONSchema) GetMultipleOf() float64 {
	if x != nil {
		return x.MultipleOf
	}
	return 0
}

func (x *JSONSchema) GetMaximum() float64 {
	if x != nil {
		return x.Maximum
	}
	return 0
}

func (x *JSONSchema) GetExclusiveMaximum() bool {
	if x != nil {
		return x.ExclusiveMaximum
	}
	return false
}

func (x *JSONSchema) GetMinimum() float64 {
	if x != nil {
		return x.Minimum
	}
	return 0
}

func (x *JSONSchema) GetExclusiveMinimum() bool {
	if x != nil {
		return x.ExclusiveMinimum
	}
	return false
}

func (x *JSONSchema) GetMaxLength() uint64 {
	if x != nil {
		return x.MaxLength
	}
	return 0
}

func (x *JSONSchema) GetMinLength() uint64 {
	if x != nil {
		return x.MinLength
	}
	return 0
}

func (x *JSONSchema) GetPattern() string {
	if x != nil {
		return x.Pattern
	}
	return ""
}

func (x *JSONSchema) GetMaxItems() uint64 {
	if x != nil {
		return x.MaxItems
	}
	return 0
}

func (x *JSONSchema) GetMinItems() uint64 {
	if x != nil {
		return x.MinItems
	}
	return 0
}

func (x *JSONSchema) GetUniqueItems() bool {
	if x != nil {
		return x.UniqueItems
	}
	return false
}

func (x *JSONSchema) GetMaxProperties() uint64 {
	if x != nil {
		return x.MaxProperties
	}
	return 0
}

func (x *JSONSchema) GetMinProperties() uint64 {
	if x != nil {
		return x.MinProperties
	}
	return 0
}

func (x *JSONSchema) GetRequired() []string {
	if x != nil {
		return x.Required
	}
	return nil
}

func (x *JSONSchema) GetArray() []string {
	if x != nil {
		return x.Array
	}
	return nil
}

func (x *JSONSchema) GetType() []JSONSchemaSimpleTypes {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *JSONSchema) GetFormat() string {
	if x != nil {
		return x.Format
	}
	return ""
}

func (x *JSONSchema) GetEnum() []string {
	if x != nil {
		return x.Enum
	}
	return nil
}

// `Tag` is a representation of OpenAPI v2 specification's Tag object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#tagObject
type Tag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A short description for the tag. GFM syntax can be used for rich text
	// representation.
	Description string `protobuf:"bytes,2,opt,name=Description,json=description,proto3" json:"Description,omitempty"`
	// Additional external documentation for this tag.
	ExternalDocs *ExternalDocumentation `protobuf:"bytes,3,opt,name=ExternalDocs,json=external_docs,proto3" json:"ExternalDocs,omitempty"`
}

func (x *Tag) Reset() {
	*x = Tag{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tag) ProtoMessage() {}

func (x *Tag) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tag.ProtoReflect.Descriptor instead.
func (*Tag) Descriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{10}
}

func (x *Tag) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Tag) GetExternalDocs() *ExternalDocumentation {
	if x != nil {
		return x.ExternalDocs
	}
	return nil
}

// `SecurityDefinitions` is a representation of OpenAPI v2 specification's
// Security Definitions object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#securityDefinitionsObject
//
// A declaration of the security schemes available to be used in the
// specification. This does not enforce the security schemes on the operations
// and only serves to provide the relevant details for each scheme.
type SecurityDefinitions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A single security scheme definition, mapping a "name" to the scheme it
	// defines.
	Security map[string]*SecurityScheme `protobuf:"bytes,1,rep,name=Security,json=security,proto3" json:"Security,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *SecurityDefinitions) Reset() {
	*x = SecurityDefinitions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecurityDefinitions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityDefinitions) ProtoMessage() {}

func (x *SecurityDefinitions) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityDefinitions.ProtoReflect.Descriptor instead.
func (*SecurityDefinitions) Descriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{11}
}

func (x *SecurityDefinitions) GetSecurity() map[string]*SecurityScheme {
	if x != nil {
		return x.Security
	}
	return nil
}

// `SecurityScheme` is a representation of OpenAPI v2 specification's
// Security Scheme object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#securitySchemeObject
//
// Allows the definition of a security scheme that can be used by the
// operations. Supported schemes are basic authentication, an API key (either as
// a header or as a query parameter) and OAuth2's common flows (implicit,
// password, application and access code).
type SecurityScheme struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the security scheme. Valid values are "basic",
	// "apiKey" or "oauth2".
	Type Type `protobuf:"varint,1,opt,name=Type,json=type,proto3,enum=openapiv2.Type" json:"Type,omitempty"`
	// A short description for security scheme.
	Description string `protobuf:"bytes,2,opt,name=Description,json=description,proto3" json:"Description,omitempty"`
	// The name of the header or query parameter to be used.
	// Valid for apiKey.
	Name string `protobuf:"bytes,3,opt,name=Name,json=name,proto3" json:"Name,omitempty"`
	// The location of the API key. Valid values are "query" or
	// "header".
	// Valid for apiKey.
	In In `protobuf:"varint,4,opt,name=In,json=in,proto3,enum=openapiv2.In" json:"In,omitempty"`
	// The flow used by the OAuth2 security scheme. Valid values are
	// "implicit", "password", "application" or "accessCode".
	// Valid for oauth2.
	Flow Flow `protobuf:"varint,5,opt,name=Flow,json=flow,proto3,enum=openapiv2.Flow" json:"Flow,omitempty"`
	// The authorization URL to be used for this flow. This SHOULD be in
	// the form of a URL.
	// Valid for oauth2/implicit and oauth2/accessCode.
	AuthorizationURL string `protobuf:"bytes,6,opt,name=AuthorizationURL,json=authorization_url,proto3" json:"AuthorizationURL,omitempty"`
	// The token URL to be used for this flow. This SHOULD be in the
	// form of a URL.
	// Valid for oauth2/password, oauth2/application and oauth2/accessCode.
	TokenURL string `protobuf:"bytes,7,opt,name=TokenURL,json=token_url,proto3" json:"TokenURL,omitempty"`
	// The available scopes for the OAuth2 security scheme.
	// Valid for oauth2.
	Scopes *Scopes `protobuf:"bytes,8,opt,name=Scopes,json=scopes,proto3" json:"Scopes,omitempty"`
}

func (x *SecurityScheme) Reset() {
	*x = SecurityScheme{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecurityScheme) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityScheme) ProtoMessage() {}

func (x *SecurityScheme) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityScheme.ProtoReflect.Descriptor instead.
func (*SecurityScheme) Descriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{12}
}

func (x *SecurityScheme) GetType() Type {
	if x != nil {
		return x.Type
	}
	return Type_TYPE_INVALID
}

func (x *SecurityScheme) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *SecurityScheme) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SecurityScheme) GetIn() In {
	if x != nil {
		return x.In
	}
	return In_IN_INVALID
}

func (x *SecurityScheme) GetFlow() Flow {
	if x != nil {
		return x.Flow
	}
	return Flow_FLOW_INVALID
}

func (x *SecurityScheme) GetAuthorizationURL() string {
	if x != nil {
		return x.AuthorizationURL
	}
	return ""
}

func (x *SecurityScheme) GetTokenURL() string {
	if x != nil {
		return x.TokenURL
	}
	return ""
}

func (x *SecurityScheme) GetScopes() *Scopes {
	if x != nil {
		return x.Scopes
	}
	return nil
}

// If the security scheme is of type "oauth2", then the value is a list of
// scope names required for the execution. For other security scheme types,
// the array MUST be empty.
type SecurityRequirement_SecurityRequirementValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Scope []string `protobuf:"bytes,1,rep,name=Scope,json=scope,proto3" json:"Scope,omitempty"`
}

func (x *SecurityRequirement_SecurityRequirementValue) Reset() {
	*x = SecurityRequirement_SecurityRequirementValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecurityRequirement_SecurityRequirementValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityRequirement_SecurityRequirementValue) ProtoMessage() {}

func (x *SecurityRequirement_SecurityRequirementValue) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityRequirement_SecurityRequirementValue.ProtoReflect.Descriptor instead.
func (*SecurityRequirement_SecurityRequirementValue) Descriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{13}
}

func (x *SecurityRequirement_SecurityRequirementValue) GetScope() []string {
	if x != nil {
		return x.Scope
	}
	return nil
}

// `SecurityRequirement` is a representation of OpenAPI v2 specification's
// Security Requirement object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#securityRequirementObject
//
// Lists the required security schemes to execute this operation. The object can
// have multiple security schemes declared in it which are all required (that
// is, there is a logical AND between the schemes).
//
// The name used for each property MUST correspond to a security scheme
// declared in the Security Definitions.
type SecurityRequirement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Each name must correspond to a security scheme which is declared in
	// the Security Definitions. If the security scheme is of type "oauth2",
	// then the value is a list of scope names required for the execution.
	// For other security scheme types, the array MUST be empty.
	SecurityRequirement map[string]*SecurityRequirement_SecurityRequirementValue `protobuf:"bytes,1,rep,name=SecurityRequirement,json=security_requirement,proto3" json:"SecurityRequirement,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *SecurityRequirement) Reset() {
	*x = SecurityRequirement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecurityRequirement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityRequirement) ProtoMessage() {}

func (x *SecurityRequirement) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityRequirement.ProtoReflect.Descriptor instead.
func (*SecurityRequirement) Descriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{14}
}

func (x *SecurityRequirement) GetSecurityRequirement() map[string]*SecurityRequirement_SecurityRequirementValue {
	if x != nil {
		return x.SecurityRequirement
	}
	return nil
}

// `Scopes` is a representation of OpenAPI v2 specification's Scopes object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#scopesObject
//
// Lists the available scopes for an OAuth2 security scheme.
type Scopes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Maps between a name of a scope to a short description of it (as the value
	// of the property).
	Scope map[string]string `protobuf:"bytes,1,rep,name=Scope,json=scope,proto3" json:"Scope,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Scopes) Reset() {
	*x = Scopes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Scopes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Scopes) ProtoMessage() {}

func (x *Scopes) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Scopes.ProtoReflect.Descriptor instead.
func (*Scopes) Descriptor() ([]byte, []int) {
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP(), []int{15}
}

func (x *Scopes) GetScope() map[string]string {
	if x != nil {
		return x.Scope
	}
	return nil
}

var File_github_com_gunk_opt_openapiv2_all_proto protoreflect.FileDescriptor

var file_github_com_gunk_opt_openapiv2_all_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x75, 0x6e,
	0x6b, 0x2f, 0x6f, 0x70, 0x74, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f,
	0x61, 0x6c, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x09, 0x6f, 0x70, 0x65, 0x6e, 0x61,
	0x70, 0x69, 0x76, 0x32, 0x22, 0xc8, 0x05, 0x0a, 0x07, 0x53, 0x77, 0x61, 0x67, 0x67, 0x65, 0x72,
	0x12, 0x24, 0x0a, 0x07, 0x53, 0x77, 0x61, 0x67, 0x67, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x07, 0x73,
	0x77, 0x61, 0x67, 0x67, 0x65, 0x72, 0x12, 0x2f, 0x0a, 0x04, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32,
	0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50,
	0x00, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x1e, 0x0a, 0x04, 0x48, 0x6f, 0x73, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50,
	0x00, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x08, 0x42, 0x61, 0x73, 0x65, 0x50,
	0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28,
	0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x09, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x12, 0x37, 0x0a, 0x07, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0e, 0x32, 0x11, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x65, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00,
	0x52, 0x07, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x08, 0x43, 0x6f, 0x6e,
	0x73, 0x75, 0x6d, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18,
	0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x09, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x53, 0x77, 0x61, 0x67, 0x67, 0x65, 0x72,
	0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x09, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x5d, 0x0a, 0x13, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52,
	0x14, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x46, 0x0a, 0x08, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70,
	0x69, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30,
	0x00, 0x50, 0x00, 0x52, 0x08, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x12, 0x51, 0x0a,
	0x0c, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x44, 0x6f, 0x63, 0x73, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e,
	0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50,
	0x00, 0x52, 0x0d, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x64, 0x6f, 0x63, 0x73,
	0x1a, 0x45, 0x0a, 0x0e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x0b, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x12,
	0x22, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x06, 0x08, 0x00, 0x10, 0x00, 0x18, 0x00, 0x22,
	0x9c, 0x05, 0x0a, 0x09, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a,
	0x04, 0x54, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18,
	0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x24, 0x0a,
	0x07, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a,
	0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x12, 0x2c, 0x0a, 0x0b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00,
	0x30, 0x00, 0x50, 0x00, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x51, 0x0a, 0x0c, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x44, 0x6f, 0x63,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70,
	0x69, 0x76, 0x32, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28,
	0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x0d, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f,
	0x64, 0x6f, 0x63, 0x73, 0x12, 0x2d, 0x0a, 0x0b, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x44, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28,
	0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x0c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x12, 0x26, 0x0a, 0x08, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50,
	0x00, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x08, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0a, 0x08,
	0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x09, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73,
	0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69,
	0x76, 0x32, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x0a, 0x08, 0x00, 0x18,
	0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x73, 0x12, 0x37, 0x0a, 0x07, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x73, 0x18, 0x0a, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x11, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00,
	0x50, 0x00, 0x52, 0x07, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x73, 0x12, 0x2a, 0x0a, 0x0a, 0x44,
	0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x0a, 0x64, 0x65, 0x70,
	0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x46, 0x0a, 0x08, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28,
	0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x08, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x1a,
	0x45, 0x0a, 0x0e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x0b, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x12, 0x22,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x06, 0x08, 0x00, 0x10, 0x00, 0x18, 0x00, 0x22, 0xce,
	0x01, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x2c, 0x0a, 0x0b, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a,
	0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50,
	0x00, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x06, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30,
	0x00, 0x50, 0x00, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x24, 0x0a, 0x07, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00,
	0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x07, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x12, 0x24, 0x0a, 0x07, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x07,
	0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x3a, 0x06, 0x08, 0x00, 0x10, 0x00, 0x18, 0x00, 0x22,
	0xfe, 0x02, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x0b,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x06, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x0a, 0x08,
	0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x12, 0x46, 0x0a, 0x07, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00,
	0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x49, 0x0a, 0x08, 0x45, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x0a,
	0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x08, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x73, 0x1a, 0x41, 0x0a, 0x0c, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x0b, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x12, 0x20, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x11, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x2f, 0x0a, 0x0d, 0x45, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x0b, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x12, 0x0d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x06, 0x08, 0x00, 0x10, 0x00, 0x18, 0x00,
	0x22, 0xae, 0x02, 0x0a, 0x04, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x20, 0x0a, 0x05, 0x54, 0x69, 0x74,
	0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00,
	0x30, 0x00, 0x50, 0x00, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x2c, 0x0a, 0x0b, 0x44,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x0e, 0x54, 0x65, 0x72,
	0x6d, 0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x10, 0x74,
	0x65, 0x72, 0x6d, 0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x38, 0x0a, 0x07, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00,
	0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x12, 0x38, 0x0a, 0x07, 0x4c, 0x69, 0x63,
	0x65, 0x6e, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x42, 0x0a,
	0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x07, 0x6c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x12, 0x24, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x3a, 0x06, 0x08, 0x00, 0x10, 0x00, 0x18,
	0x00, 0x22, 0x71, 0x0a, 0x07, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x12, 0x1e, 0x0a, 0x04,
	0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00,
	0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x03,
	0x55, 0x52, 0x4c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28,
	0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x20, 0x0a, 0x05, 0x45, 0x6d,
	0x61, 0x69, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28,
	0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x3a, 0x06, 0x08, 0x00,
	0x10, 0x00, 0x18, 0x00, 0x22, 0x4f, 0x0a, 0x07, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x12,
	0x1e, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08,
	0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1c, 0x0a, 0x03, 0x55, 0x52, 0x4c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00,
	0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x3a, 0x06, 0x08,
	0x00, 0x10, 0x00, 0x18, 0x00, 0x22, 0x6b, 0x0a, 0x15, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c,
	0x0a, 0x0b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x03,
	0x55, 0x52, 0x4c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28,
	0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x3a, 0x06, 0x08, 0x00, 0x10, 0x00,
	0x18, 0x00, 0x22, 0xa8, 0x02, 0x0a, 0x06, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x42, 0x0a,
	0x0a, 0x4a, 0x53, 0x4f, 0x4e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x15, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x4a, 0x53,
	0x4f, 0x4e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00,
	0x30, 0x00, 0x50, 0x00, 0x52, 0x0b, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x12, 0x30, 0x0a, 0x0d, 0x44, 0x69, 0x73, 0x63, 0x72, 0x69, 0x6d, 0x69, 0x6e, 0x61, 0x74,
	0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00,
	0x30, 0x00, 0x50, 0x00, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x63, 0x72, 0x69, 0x6d, 0x69, 0x6e, 0x61,
	0x74, 0x6f, 0x72, 0x12, 0x27, 0x0a, 0x08, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50,
	0x00, 0x52, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x12, 0x51, 0x0a, 0x0c,
	0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x44, 0x6f, 0x63, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x45,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00,
	0x52, 0x0d, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x64, 0x6f, 0x63, 0x73, 0x12,
	0x24, 0x0a, 0x07, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x07, 0x65, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x3a, 0x06, 0x08, 0x00, 0x10, 0x00, 0x18, 0x00, 0x22, 0x95, 0x08,
	0x0a, 0x0a, 0x4a, 0x53, 0x4f, 0x4e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x1c, 0x0a, 0x03,
	0x52, 0x65, 0x66, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28,
	0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x03, 0x72, 0x65, 0x66, 0x12, 0x20, 0x0a, 0x05, 0x54, 0x69,
	0x74, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28,
	0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x2c, 0x0a, 0x0b,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x07, 0x44, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18,
	0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x07, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x12, 0x27, 0x0a, 0x08, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x09,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x12, 0x24, 0x0a, 0x07, 0x45, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00,
	0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x07, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12,
	0x2b, 0x0a, 0x0a, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x4f, 0x66, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x01, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52,
	0x0b, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x5f, 0x6f, 0x66, 0x12, 0x24, 0x0a, 0x07,
	0x4d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x01, 0x42, 0x0a, 0x08,
	0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x07, 0x6d, 0x61, 0x78, 0x69, 0x6d,
	0x75, 0x6d, 0x12, 0x37, 0x0a, 0x10, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x4d,
	0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x42, 0x0a, 0x08, 0x00,
	0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x11, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x76, 0x65, 0x5f, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x12, 0x24, 0x0a, 0x07, 0x4d,
	0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x01, 0x42, 0x0a, 0x08, 0x00,
	0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x07, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75,
	0x6d, 0x12, 0x37, 0x0a, 0x10, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x4d, 0x69,
	0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x42, 0x0a, 0x08, 0x00, 0x18,
	0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x11, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69,
	0x76, 0x65, 0x5f, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x12, 0x29, 0x0a, 0x09, 0x4d, 0x61,
	0x78, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x04, 0x42, 0x0a, 0x08,
	0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x5f, 0x6c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x29, 0x0a, 0x09, 0x4d, 0x69, 0x6e, 0x4c, 0x65, 0x6e, 0x67,
	0x74, 0x68, 0x18, 0x10, 0x20, 0x01, 0x28, 0x04, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00,
	0x30, 0x00, 0x50, 0x00, 0x52, 0x0a, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x12, 0x24, 0x0a, 0x07, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x07, 0x70,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x27, 0x0a, 0x08, 0x4d, 0x61, 0x78, 0x49, 0x74, 0x65,
	0x6d, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x04, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00,
	0x30, 0x00, 0x50, 0x00, 0x52, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x12,
	0x27, 0x0a, 0x08, 0x4d, 0x69, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28,
	0x04, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x09, 0x6d,
	0x69, 0x6e, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x2d, 0x0a, 0x0b, 0x55, 0x6e, 0x69, 0x71,
	0x75, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x16, 0x20, 0x01, 0x28, 0x08, 0x42, 0x0a, 0x08,
	0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x0c, 0x75, 0x6e, 0x69, 0x71, 0x75,
	0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x31, 0x0a, 0x0d, 0x4d, 0x61, 0x78, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x04, 0x42, 0x0a,
	0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x5f,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x0d, 0x4d, 0x69,
	0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x19, 0x20, 0x01, 0x28,
	0x04, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x0e, 0x6d,
	0x69, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x08, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x1a, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x08, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x64, 0x12, 0x20, 0x0a, 0x05, 0x41, 0x72, 0x72, 0x61, 0x79, 0x18, 0x22,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00,
	0x52, 0x05, 0x61, 0x72, 0x72, 0x61, 0x79, 0x12, 0x40, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x18,
	0x23, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76,
	0x32, 0x2e, 0x4a, 0x53, 0x4f, 0x4e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x53, 0x69, 0x6d, 0x70,
	0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30,
	0x00, 0x50, 0x00, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x06, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x18, 0x24, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28,
	0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1e, 0x0a,
	0x04, 0x45, 0x6e, 0x75, 0x6d, 0x18, 0x2e, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18,
	0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x04, 0x65, 0x6e, 0x75, 0x6d, 0x3a, 0x06, 0x08,
	0x00, 0x10, 0x00, 0x18, 0x00, 0x22, 0x8e, 0x01, 0x0a, 0x03, 0x54, 0x61, 0x67, 0x12, 0x2c, 0x0a,
	0x0b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x0c, 0x45,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x44, 0x6f, 0x63, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x45, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52,
	0x0d, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x64, 0x6f, 0x63, 0x73, 0x3a, 0x06,
	0x08, 0x00, 0x10, 0x00, 0x18, 0x00, 0x22, 0xbf, 0x01, 0x0a, 0x13, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x54,
	0x0a, 0x08, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x0a,
	0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x08, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x1a, 0x4a, 0x0a, 0x0d, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x0b, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x12, 0x28, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x3a, 0x06, 0x08, 0x00, 0x10, 0x00, 0x18, 0x00, 0x22, 0x8c, 0x03, 0x0a, 0x0e, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x04, 0x54,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0f, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00,
	0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x0b,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x04, 0x4e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00,
	0x30, 0x00, 0x50, 0x00, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x02, 0x49, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0d, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50,
	0x00, 0x52, 0x02, 0x69, 0x6e, 0x12, 0x2f, 0x0a, 0x04, 0x46, 0x6c, 0x6f, 0x77, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x0f, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2e,
	0x46, 0x6c, 0x6f, 0x77, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00,
	0x52, 0x04, 0x66, 0x6c, 0x6f, 0x77, 0x12, 0x37, 0x0a, 0x10, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x52, 0x4c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x11, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x6c, 0x12,
	0x27, 0x0a, 0x08, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x55, 0x52, 0x4c, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x09, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x75, 0x72, 0x6c, 0x12, 0x35, 0x0a, 0x06, 0x53, 0x63, 0x6f, 0x70,
	0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61,
	0x70, 0x69, 0x76, 0x32, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x42, 0x0a, 0x08, 0x00, 0x18,
	0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x3a,
	0x06, 0x08, 0x00, 0x10, 0x00, 0x18, 0x00, 0x22, 0x58, 0x0a, 0x2c, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x20, 0x0a, 0x05, 0x53, 0x63, 0x6f, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00,
	0x50, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x3a, 0x06, 0x08, 0x00, 0x10, 0x00, 0x18,
	0x00, 0x22, 0x8a, 0x02, 0x0a, 0x13, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x76, 0x0a, 0x13, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69,
	0x76, 0x32, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50, 0x00, 0x52, 0x14, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x1a, 0x73, 0x0a, 0x18, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x0b, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x12, 0x46, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x61, 0x70, 0x69, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x06, 0x08, 0x00, 0x10, 0x00, 0x18, 0x00, 0x22, 0x7e,
	0x0a, 0x06, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x12, 0x3e, 0x0a, 0x05, 0x53, 0x63, 0x6f, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70,
	0x69, 0x76, 0x32, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x0a, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 0x30, 0x00, 0x50,
	0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x1a, 0x2c, 0x0a, 0x0a, 0x53, 0x63, 0x6f, 0x70,
	0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x0b, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x12, 0x0d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x06, 0x08, 0x00, 0x10, 0x00, 0x18, 0x00, 0x2a, 0x60,
	0x0a, 0x06, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x14, 0x53, 0x77, 0x61, 0x67,
	0x67, 0x65, 0x72, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e,
	0x10, 0x00, 0x1a, 0x02, 0x08, 0x00, 0x12, 0x0c, 0x0a, 0x04, 0x48, 0x54, 0x54, 0x50, 0x10, 0x01,
	0x1a, 0x02, 0x08, 0x00, 0x12, 0x0d, 0x0a, 0x05, 0x48, 0x54, 0x54, 0x50, 0x53, 0x10, 0x02, 0x1a,
	0x02, 0x08, 0x00, 0x12, 0x0a, 0x0a, 0x02, 0x57, 0x53, 0x10, 0x03, 0x1a, 0x02, 0x08, 0x00, 0x12,
	0x0b, 0x0a, 0x03, 0x57, 0x53, 0x53, 0x10, 0x04, 0x1a, 0x02, 0x08, 0x00, 0x1a, 0x02, 0x18, 0x00,
	0x2a, 0xb1, 0x01, 0x0a, 0x15, 0x4a, 0x53, 0x4f, 0x4e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x53,
	0x69, 0x6d, 0x70, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x1d, 0x4a, 0x53,
	0x4f, 0x4e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x53, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x1a, 0x02, 0x08,
	0x00, 0x12, 0x0d, 0x0a, 0x05, 0x41, 0x52, 0x52, 0x41, 0x59, 0x10, 0x01, 0x1a, 0x02, 0x08, 0x00,
	0x12, 0x0f, 0x0a, 0x07, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x10, 0x02, 0x1a, 0x02, 0x08,
	0x00, 0x12, 0x0f, 0x0a, 0x07, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x45, 0x52, 0x10, 0x03, 0x1a, 0x02,
	0x08, 0x00, 0x12, 0x0c, 0x0a, 0x04, 0x4e, 0x55, 0x4c, 0x4c, 0x10, 0x04, 0x1a, 0x02, 0x08, 0x00,
	0x12, 0x0e, 0x0a, 0x06, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x10, 0x05, 0x1a, 0x02, 0x08, 0x00,
	0x12, 0x0e, 0x0a, 0x06, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x06, 0x1a, 0x02, 0x08, 0x00,
	0x12, 0x0e, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x1a, 0x02, 0x08, 0x00,
	0x1a, 0x02, 0x18, 0x00, 0x2a, 0x5f, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x0c,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x1a, 0x02,
	0x08, 0x00, 0x12, 0x12, 0x0a, 0x0a, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43,
	0x10, 0x01, 0x1a, 0x02, 0x08, 0x00, 0x12, 0x14, 0x0a, 0x0c, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x41,
	0x50, 0x49, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x02, 0x1a, 0x02, 0x08, 0x00, 0x12, 0x13, 0x0a, 0x0b,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x41, 0x55, 0x54, 0x48, 0x32, 0x10, 0x03, 0x1a, 0x02, 0x08,
	0x00, 0x1a, 0x02, 0x18, 0x00, 0x2a, 0x41, 0x0a, 0x02, 0x49, 0x6e, 0x12, 0x12, 0x0a, 0x0a, 0x49,
	0x4e, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x1a, 0x02, 0x08, 0x00, 0x12,
	0x10, 0x0a, 0x08, 0x49, 0x4e, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x01, 0x1a, 0x02, 0x08,
	0x00, 0x12, 0x11, 0x0a, 0x09, 0x49, 0x4e, 0x5f, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x10, 0x02,
	0x1a, 0x02, 0x08, 0x00, 0x1a, 0x02, 0x18, 0x00, 0x2a, 0x82, 0x01, 0x0a, 0x04, 0x46, 0x6c, 0x6f,
	0x77, 0x12, 0x14, 0x0a, 0x0c, 0x46, 0x4c, 0x4f, 0x57, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49,
	0x44, 0x10, 0x00, 0x1a, 0x02, 0x08, 0x00, 0x12, 0x15, 0x0a, 0x0d, 0x46, 0x4c, 0x4f, 0x57, 0x5f,
	0x49, 0x4d, 0x50, 0x4c, 0x49, 0x43, 0x49, 0x54, 0x10, 0x01, 0x1a, 0x02, 0x08, 0x00, 0x12, 0x15,
	0x0a, 0x0d, 0x46, 0x4c, 0x4f, 0x57, 0x5f, 0x50, 0x41, 0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x10,
	0x02, 0x1a, 0x02, 0x08, 0x00, 0x12, 0x18, 0x0a, 0x10, 0x46, 0x4c, 0x4f, 0x57, 0x5f, 0x41, 0x50,
	0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x1a, 0x02, 0x08, 0x00, 0x12,
	0x18, 0x0a, 0x10, 0x46, 0x4c, 0x4f, 0x57, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x43,
	0x4f, 0x44, 0x45, 0x10, 0x04, 0x1a, 0x02, 0x08, 0x00, 0x1a, 0x02, 0x18, 0x00, 0x42, 0x42, 0x48,
	0x01, 0x50, 0x00, 0x5a, 0x27, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x75, 0x6e, 0x6b, 0x2f, 0x6f, 0x70, 0x74, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69,
	0x76, 0x32, 0x3b, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x80, 0x01, 0x00, 0x88,
	0x01, 0x00, 0x90, 0x01, 0x00, 0xb8, 0x01, 0x00, 0xd8, 0x01, 0x00, 0xf8, 0x01, 0x01, 0xd0, 0x02,
	0x00, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_github_com_gunk_opt_openapiv2_all_proto_rawDescOnce sync.Once
	file_github_com_gunk_opt_openapiv2_all_proto_rawDescData = file_github_com_gunk_opt_openapiv2_all_proto_rawDesc
)

func file_github_com_gunk_opt_openapiv2_all_proto_rawDescGZIP() []byte {
	file_github_com_gunk_opt_openapiv2_all_proto_rawDescOnce.Do(func() {
		file_github_com_gunk_opt_openapiv2_all_proto_rawDescData = protoimpl.X.CompressGZIP(file_github_com_gunk_opt_openapiv2_all_proto_rawDescData)
	})
	return file_github_com_gunk_opt_openapiv2_all_proto_rawDescData
}

var (
	file_github_com_gunk_opt_openapiv2_all_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
	file_github_com_gunk_opt_openapiv2_all_proto_msgTypes  = make([]protoimpl.MessageInfo, 23)
	file_github_com_gunk_opt_openapiv2_all_proto_goTypes   = []interface{}{
		(Scheme)(0),                   // 0: openapiv2.Scheme
		(JSONSchemaSimpleTypes)(0),    // 1: openapiv2.JSONSchemaSimpleTypes
		(Type)(0),                     // 2: openapiv2.Type
		(In)(0),                       // 3: openapiv2.In
		(Flow)(0),                     // 4: openapiv2.Flow
		(*Swagger)(nil),               // 5: openapiv2.Swagger
		(*Operation)(nil),             // 6: openapiv2.Operation
		(*Header)(nil),                // 7: openapiv2.Header
		(*Response)(nil),              // 8: openapiv2.Response
		(*Info)(nil),                  // 9: openapiv2.Info
		(*Contact)(nil),               // 10: openapiv2.Contact
		(*License)(nil),               // 11: openapiv2.License
		(*ExternalDocumentation)(nil), // 12: openapiv2.ExternalDocumentation
		(*Schema)(nil),                // 13: openapiv2.Schema
		(*JSONSchema)(nil),            // 14: openapiv2.JSONSchema
		(*Tag)(nil),                   // 15: openapiv2.Tag
		(*SecurityDefinitions)(nil),   // 16: openapiv2.SecurityDefinitions
		(*SecurityScheme)(nil),        // 17: openapiv2.SecurityScheme
		(*SecurityRequirement_SecurityRequirementValue)(nil), // 18: openapiv2.SecurityRequirement_SecurityRequirementValue
		(*SecurityRequirement)(nil),                          // 19: openapiv2.SecurityRequirement
		(*Scopes)(nil),                                       // 20: openapiv2.Scopes
		nil,                                                  // 21: openapiv2.Swagger.ResponsesEntry
		nil,                                                  // 22: openapiv2.Operation.ResponsesEntry
		nil,                                                  // 23: openapiv2.Response.HeadersEntry
		nil,                                                  // 24: openapiv2.Response.ExamplesEntry
		nil,                                                  // 25: openapiv2.SecurityDefinitions.SecurityEntry
		nil,                                                  // 26: openapiv2.SecurityRequirement.SecurityRequirementEntry
		nil,                                                  // 27: openapiv2.Scopes.ScopeEntry
	}
)

var file_github_com_gunk_opt_openapiv2_all_proto_depIdxs = []int32{
	9,  // 0: openapiv2.Swagger.Info:type_name -> openapiv2.Info
	0,  // 1: openapiv2.Swagger.Schemes:type_name -> openapiv2.Scheme
	21, // 2: openapiv2.Swagger.Responses:type_name -> openapiv2.Swagger.ResponsesEntry
	16, // 3: openapiv2.Swagger.SecurityDefinitions:type_name -> openapiv2.SecurityDefinitions
	19, // 4: openapiv2.Swagger.Security:type_name -> openapiv2.SecurityRequirement
	12, // 5: openapiv2.Swagger.ExternalDocs:type_name -> openapiv2.ExternalDocumentation
	12, // 6: openapiv2.Operation.ExternalDocs:type_name -> openapiv2.ExternalDocumentation
	22, // 7: openapiv2.Operation.Responses:type_name -> openapiv2.Operation.ResponsesEntry
	0,  // 8: openapiv2.Operation.Schemes:type_name -> openapiv2.Scheme
	19, // 9: openapiv2.Operation.Security:type_name -> openapiv2.SecurityRequirement
	13, // 10: openapiv2.Response.Schema:type_name -> openapiv2.Schema
	23, // 11: openapiv2.Response.Headers:type_name -> openapiv2.Response.HeadersEntry
	24, // 12: openapiv2.Response.Examples:type_name -> openapiv2.Response.ExamplesEntry
	10, // 13: openapiv2.Info.Contact:type_name -> openapiv2.Contact
	11, // 14: openapiv2.Info.License:type_name -> openapiv2.License
	14, // 15: openapiv2.Schema.JSONSchema:type_name -> openapiv2.JSONSchema
	12, // 16: openapiv2.Schema.ExternalDocs:type_name -> openapiv2.ExternalDocumentation
	1,  // 17: openapiv2.JSONSchema.Type:type_name -> openapiv2.JSONSchemaSimpleTypes
	12, // 18: openapiv2.Tag.ExternalDocs:type_name -> openapiv2.ExternalDocumentation
	25, // 19: openapiv2.SecurityDefinitions.Security:type_name -> openapiv2.SecurityDefinitions.SecurityEntry
	2,  // 20: openapiv2.SecurityScheme.Type:type_name -> openapiv2.Type
	3,  // 21: openapiv2.SecurityScheme.In:type_name -> openapiv2.In
	4,  // 22: openapiv2.SecurityScheme.Flow:type_name -> openapiv2.Flow
	20, // 23: openapiv2.SecurityScheme.Scopes:type_name -> openapiv2.Scopes
	26, // 24: openapiv2.SecurityRequirement.SecurityRequirement:type_name -> openapiv2.SecurityRequirement.SecurityRequirementEntry
	27, // 25: openapiv2.Scopes.Scope:type_name -> openapiv2.Scopes.ScopeEntry
	8,  // 26: openapiv2.Swagger.ResponsesEntry.value:type_name -> openapiv2.Response
	8,  // 27: openapiv2.Operation.ResponsesEntry.value:type_name -> openapiv2.Response
	7,  // 28: openapiv2.Response.HeadersEntry.value:type_name -> openapiv2.Header
	17, // 29: openapiv2.SecurityDefinitions.SecurityEntry.value:type_name -> openapiv2.SecurityScheme
	18, // 30: openapiv2.SecurityRequirement.SecurityRequirementEntry.value:type_name -> openapiv2.SecurityRequirement_SecurityRequirementValue
	31, // [31:31] is the sub-list for method output_type
	31, // [31:31] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_github_com_gunk_opt_openapiv2_all_proto_init() }
func file_github_com_gunk_opt_openapiv2_all_proto_init() {
	if File_github_com_gunk_opt_openapiv2_all_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Swagger); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Operation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Header); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Response); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Info); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Contact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*License); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExternalDocumentation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Schema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JSONSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Tag); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecurityDefinitions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecurityScheme); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecurityRequirement_SecurityRequirementValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecurityRequirement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_gunk_opt_openapiv2_all_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Scopes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_github_com_gunk_opt_openapiv2_all_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_github_com_gunk_opt_openapiv2_all_proto_goTypes,
		DependencyIndexes: file_github_com_gunk_opt_openapiv2_all_proto_depIdxs,
		EnumInfos:         file_github_com_gunk_opt_openapiv2_all_proto_enumTypes,
		MessageInfos:      file_github_com_gunk_opt_openapiv2_all_proto_msgTypes,
	}.Build()
	File_github_com_gunk_opt_openapiv2_all_proto = out.File
	file_github_com_gunk_opt_openapiv2_all_proto_rawDesc = nil
	file_github_com_gunk_opt_openapiv2_all_proto_goTypes = nil
	file_github_com_gunk_opt_openapiv2_all_proto_depIdxs = nil
}
