/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 5644:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isInterestingFile = exports.parseGitStatus = exports.checkDirtyFiles = exports.parseOnDirtyFiles = void 0;
const core = __importStar(__nccwpck_require__(2186));
const exec = __importStar(__nccwpck_require__(1514));
function parseOnDirtyFiles(input) {
    switch (input) {
        case "warn":
        case "error":
            return input;
        default:
            throw new Error(`Invalid on-dirty-files, must be warn or error, saw: ${input}`);
    }
}
exports.parseOnDirtyFiles = parseOnDirtyFiles;
async function checkDirtyFiles(onDirtyFiles) {
    const stdout = await readGitStatus();
    const paths = parseGitStatus(stdout).filter(isInterestingFile);
    if (paths.length === 0) {
        return;
    }
    const message = `Build caused changes to ${paths.join(", ")}`;
    switch (onDirtyFiles) {
        case "warn":
            core.warning(message);
            break;
        case "error":
            throw new Error(message);
    }
}
exports.checkDirtyFiles = checkDirtyFiles;
async function readGitStatus() {
    let stdout = "";
    const options = {
        listeners: {
            stdout: (data) => {
                stdout += data.toString();
            },
        },
        ignoreReturnCode: true,
    };
    await exec.exec("git", ["status", "--porcelain"], options);
    return stdout;
}
function parseGitStatus(stdout) {
    return stdout
        .split("\n")
        .filter((path) => {
        return !path.startsWith("??");
    })
        .map((path) => {
        return path.replace(/^\s*/, "").split(/\s+/).slice(1).join(" ");
    })
        .filter((path) => {
        return path.trim() !== "";
    });
}
exports.parseGitStatus = parseGitStatus;
const INTERESTING_EXTENSIONS = [".cabal", ".yaml.lock"];
function isInterestingFile(path) {
    return INTERESTING_EXTENSIONS.some((ext, _index, _array) => {
        return path.endsWith(ext);
    });
}
exports.isInterestingFile = isInterestingFile;


/***/ }),

/***/ 9778:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.envsubst = void 0;
const REGEXP = new RegExp("\\$([A-Z_]+)|\\$\\{([A-Z_]+)\\}");
function replacer(_match, p1, p2) {
    return process.env[p2 ?? p1] ?? "";
}
function envsubst(str) {
    return str.replace(REGEXP, replacer);
}
exports.envsubst = envsubst;


/***/ }),

/***/ 1341:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getCacheKeys = void 0;
function getCacheKeys(parts) {
    const primaryKey = parts.join("-");
    const restoreKeys = [];
    let restoreParts = parts.slice(0, -1);
    while (restoreParts.length > 0) {
        restoreKeys.push(`${restoreParts.join("-")}-`);
        restoreParts = restoreParts.slice(0, -1);
    }
    return { primaryKey, restoreKeys };
}
exports.getCacheKeys = getCacheKeys;


/***/ }),

/***/ 4717:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.hashProject = exports.BUILD_FILES_PATTERNS = exports.ALL_SOURCES_PATTERNS = void 0;
const path = __importStar(__nccwpck_require__(1017));
const glob_1 = __nccwpck_require__(8090);
exports.ALL_SOURCES_PATTERNS = `**\n!**${path.sep}.stack-work\n!.git\n`;
exports.BUILD_FILES_PATTERNS = `**${path.sep}package.yaml\n**${path.sep}*.cabal\n`;
async function hashProject(stackYaml) {
    return {
        snapshot: await (0, glob_1.hashFiles)(stackYaml),
        package: await (0, glob_1.hashFiles)(exports.BUILD_FILES_PATTERNS),
        sources: await (0, glob_1.hashFiles)(exports.ALL_SOURCES_PATTERNS),
    };
}
exports.hashProject = hashProject;


/***/ }),

/***/ 6180:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getInputs = void 0;
const core = __importStar(__nccwpck_require__(2186));
const Shellwords = __importStar(__nccwpck_require__(8519));
const envsubst_1 = __nccwpck_require__(9778);
const dirty_files_1 = __nccwpck_require__(5644);
function getInputs() {
    const getBuildArguments = (step) => {
        return getShellWordsInput("stack-build-arguments").concat(getShellWordsInput(`stack-build-arguments-${step}`));
    };
    const rawOnDirtyFiles = core.getInput("on-dirty-files", { required: true });
    return {
        workingDirectory: getInputDefault("working-directory", null),
        test: core.getBooleanInput("test"),
        stackArguments: getShellWordsInput("stack-arguments"),
        stackSetupArguments: getShellWordsInput("stack-setup-arguments"),
        stackQueryArguments: getShellWordsInput("stack-query-arguments"),
        stackBuildArgumentsDependencies: getBuildArguments("dependencies"),
        stackBuildArgumentsBuild: getBuildArguments("build"),
        stackBuildArgumentsTest: getBuildArguments("test"),
        cachePrefix: core.getInput("cache-prefix"),
        cacheSaveAlways: core.getBooleanInput("cache-save-always"),
        onDirtyFiles: (0, dirty_files_1.parseOnDirtyFiles)(rawOnDirtyFiles),
        installStack: core.getBooleanInput("install-stack"),
        upgradeStack: core.getBooleanInput("upgrade-stack"),
        compilerTools: core.getMultilineInput("compiler-tools"),
        stackYaml: getInputDefault("stack-yaml", null),
    };
}
exports.getInputs = getInputs;
function getInputDefault(name, d) {
    const raw = core.getInput(name, { trimWhitespace: true });
    return raw === "" ? d : raw;
}
function getShellWordsInput(name, options) {
    const raw = core.getMultilineInput(name, options).join(" ");
    return Shellwords.split(raw).map(envsubst_1.envsubst);
}


/***/ }),

/***/ 3109:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const core = __importStar(__nccwpck_require__(2186));
const dirty_files_1 = __nccwpck_require__(5644);
const stack_cli_1 = __nccwpck_require__(8939);
const get_cache_keys_1 = __nccwpck_require__(1341);
const hash_project_1 = __nccwpck_require__(4717);
const inputs_1 = __nccwpck_require__(6180);
const stack_yaml_1 = __nccwpck_require__(7703);
const with_cache_1 = __nccwpck_require__(4739);
async function run() {
    try {
        const inputs = (0, inputs_1.getInputs)();
        if (inputs.workingDirectory) {
            core.debug(`Change directory: ${inputs.workingDirectory}`);
            process.chdir(inputs.workingDirectory);
        }
        if (inputs.stackYaml) {
            core.warning("inputs.stack-yaml is deprecated. Set env.STACK_YAML or use inputs.stack-arguments instead.");
            inputs.stackArguments.unshift(inputs.stackYaml);
            inputs.stackArguments.unshift("--stack-yaml");
        }
        const stack = new stack_cli_1.StackCLI(inputs.stackArguments, core.isDebug());
        await core.group("Install/upgrade stack", async () => {
            const installed = await stack.installed();
            if (installed) {
                if (inputs.upgradeStack) {
                    core.info("Upgrading stack");
                    await stack.upgrade();
                }
            }
            else {
                if (inputs.installStack) {
                    core.info("Installing stack");
                    await stack.install();
                }
                else {
                    throw new Error([
                        "The executable stack is not present on $PATH",
                        "Make sure it is installed in a preceding step, or use",
                        "`install-stack: true` to have it installed for you.",
                    ].join("\n"));
                }
            }
        });
        const hashes = await core.group("Calculate hashes", async () => {
            const hashes = await (0, hash_project_1.hashProject)(stack.config);
            core.info(`Snapshot: ${hashes.snapshot}`);
            core.info(`Packages: ${hashes.package}`);
            core.info(`Sources: ${hashes.sources}`);
            return hashes;
        });
        const { stackYaml, stackDirectories } = await core.group("Determine stack directories", async () => {
            const stackYaml = (0, stack_yaml_1.readStackYamlSync)(stack.config);
            const stackDirectories = await (0, stack_yaml_1.getStackDirectories)(stackYaml, stack);
            core.info([
                `Stack root: ${stackDirectories.stackRoot}`,
                `Stack programs: ${stackDirectories.stackPrograms}`,
                `Stack works:\n - ${stackDirectories.stackWorks.join("\n - ")}`,
            ].join("\n"));
            return { stackYaml, stackDirectories };
        });
        const cachePrefix = `${inputs.cachePrefix}${process.platform}/${stack.resolver ?? stackYaml.resolver}`;
        await core.group("Setup and install dependencies", async () => {
            const { stackRoot, stackPrograms, stackWorks } = stackDirectories;
            await (0, with_cache_1.withCache)([stackRoot, stackPrograms].concat(stackWorks), (0, get_cache_keys_1.getCacheKeys)([`${cachePrefix}/deps`, hashes.snapshot, hashes.package]), async () => {
                await stack.setup(inputs.stackSetupArguments);
                await stack.buildDependencies(inputs.stackBuildArgumentsDependencies);
                await stack.installCompilerTools(inputs.compilerTools);
            }, {
                ...with_cache_1.DEFAULT_CACHE_OPTIONS,
                saveOnError: inputs.cacheSaveAlways,
            });
        });
        await core.group("Build", async () => {
            await (0, with_cache_1.withCache)(stackDirectories.stackWorks, (0, get_cache_keys_1.getCacheKeys)([
                `${cachePrefix}/build`,
                hashes.snapshot,
                hashes.package,
                hashes.sources,
            ]), async () => {
                await stack.buildNoTest(inputs.stackBuildArgumentsBuild);
            }, {
                ...with_cache_1.DEFAULT_CACHE_OPTIONS,
                skipOnHit: false,
                saveOnError: inputs.cacheSaveAlways,
            });
        });
        await core.group("Check for dirty files", async () => {
            await (0, dirty_files_1.checkDirtyFiles)(inputs.onDirtyFiles);
        });
        if (inputs.test) {
            await core.group("Test", async () => {
                await stack.buildTest(inputs.stackBuildArgumentsTest);
            });
        }
        await core.group("Set outputs", async () => {
            const stackQuery = await stack.query();
            const compiler = stackQuery.compiler.actual;
            const compilerVersion = compiler.replace(/^ghc-/, "");
            core.info("Setting query-compiler outputs");
            core.setOutput("compiler", compiler);
            core.setOutput("compiler-version", compilerVersion);
            const stackPath = await stack.path();
            core.info("Setting stack-path outputs");
            for (const k in stackPath) {
                const v = stackPath[k];
                core.debug(`Setting stack-path output: ${k}=${v}`);
                core.setOutput(k, v);
            }
        });
        process.exit(0);
    }
    catch (error) {
        if (error instanceof Error) {
            core.error(error);
            core.setFailed(error.message);
        }
        else if (typeof error === "string") {
            core.error(error);
            core.setFailed(error);
        }
        else {
            core.error("Non-Error exception");
            core.setFailed("Non-Error exception");
        }
        process.exit(1);
    }
}
run();


/***/ }),

/***/ 1895:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.parseStackPath = void 0;
const yaml = __importStar(__nccwpck_require__(1917));
function parseStackPath(stdout) {
    return yaml.load(stdout);
}
exports.parseStackPath = parseStackPath;


/***/ }),

/***/ 6445:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.parseStackQuery = void 0;
const yaml = __importStar(__nccwpck_require__(1917));
function parseStackQuery(stdout) {
    return yaml.load(stdout);
}
exports.parseStackQuery = parseStackQuery;


/***/ }),

/***/ 8939:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StackCLI = void 0;
const fs = __importStar(__nccwpck_require__(7147));
const path = __importStar(__nccwpck_require__(1017));
const os_1 = __nccwpck_require__(2037);
const exec = __importStar(__nccwpck_require__(1514));
const parse_stack_path_1 = __nccwpck_require__(1895);
const parse_stack_query_1 = __nccwpck_require__(6445);
class StackCLI {
    config;
    resolver;
    debug;
    globalArgs;
    constructor(args, debug) {
        this.debug = debug ?? false;
        this.globalArgs = args;
        const stackYamlIdx = args.indexOf("--stack-yaml");
        const stackYamlArg = stackYamlIdx >= 0 ? args[stackYamlIdx + 1] : null;
        this.config = stackYamlArg ?? process.env.STACK_YAML ?? "stack.yaml";
        const resolverIdx = args.indexOf("--resolver");
        const resolverArg = resolverIdx >= 0 ? args[resolverIdx + 1] : null;
        this.resolver = resolverArg;
        if (!this.resolver && path.basename(this.config) === "stack-nightly.yaml") {
            this.resolver = "nightly";
            this.globalArgs.push("--resolver");
            this.globalArgs.push("nightly");
        }
    }
    async installed() {
        const ec = await exec.exec("which", ["stack"], {
            silent: true,
            ignoreReturnCode: true,
        });
        return ec == 0;
    }
    async install() {
        const url = "https://get.haskellstack.org";
        const tmp = "install-stack.sh";
        await exec.exec("curl", ["-sSL", "-o", tmp, url]);
        await exec.exec("sh", [tmp]);
        fs.rmSync(tmp);
    }
    async upgrade() {
        return await exec.exec("stack", ["upgrade"]);
    }
    async setup(args) {
        return await this.exec(["setup"].concat(args));
    }
    async installCompilerTools(tools) {
        if (tools.length > 0) {
            return await this.exec(["install", "--copy-compiler-tool"].concat(tools));
        }
        return 0;
    }
    async buildDependencies(args) {
        return await this.buildNoTest(["--dependencies-only"].concat(args));
    }
    async buildNoTest(args) {
        return await this.build(["--test", "--no-run-tests"].concat(args));
    }
    async buildTest(args) {
        return await this.build(["--test"].concat(args));
    }
    async build(args) {
        return await this.exec(["build"].concat(args));
    }
    async path() {
        return await this.parse(["path"], parse_stack_path_1.parseStackPath);
    }
    async query() {
        return await this.parse(["query"], parse_stack_query_1.parseStackQuery);
    }
    async parse(args, f) {
        const stdout = await this.read(args);
        return f(stdout);
    }
    async read(args) {
        let stdout = "";
        const options = {
            listeners: {
                stdout: (data) => {
                    stdout += data.toString();
                },
            },
        };
        if (!this.debug) {
            options.outStream = fs.createWriteStream(os_1.devNull);
        }
        await this.exec(args, options);
        return stdout;
    }
    async exec(args, options) {
        return await exec.exec("stack", this.globalArgs.concat(args), options);
    }
}
exports.StackCLI = StackCLI;


/***/ }),

/***/ 7703:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getStackDirectories = exports.parseStackYaml = exports.readStackYamlSync = void 0;
const fs = __importStar(__nccwpck_require__(7147));
const path_1 = __nccwpck_require__(1017);
const yaml = __importStar(__nccwpck_require__(1917));
function readStackYamlSync(path) {
    const contents = fs.readFileSync(path, { encoding: "utf-8" });
    return parseStackYaml(contents);
}
exports.readStackYamlSync = readStackYamlSync;
function parseStackYaml(contents) {
    return yaml.load(contents);
}
exports.parseStackYaml = parseStackYaml;
async function getStackDirectories(stackYaml, stack, workingDirectory) {
    const cwd = workingDirectory ?? process.cwd();
    const output = await stack.read(["path", "--stack-root", "--programs"]);
    const stackPath = yaml.load(output);
    const stackWorks = packagesStackWorks(stackYaml, cwd);
    return {
        stackRoot: stackPath["stack-root"],
        stackPrograms: stackPath.programs,
        stackWorks,
    };
}
exports.getStackDirectories = getStackDirectories;
function packagesStackWorks(stackYaml, cwd) {
    const packageStackWorks = (stackYaml.packages ?? [])
        .filter((p) => p !== ".")
        .map((p) => (0, path_1.join)(cwd, p, ".stack-work"));
    return [(0, path_1.join)(cwd, ".stack-work")].concat(packageStackWorks);
}


/***/ }),

/***/ 4739:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.withCache = exports.DEFAULT_CACHE_OPTIONS = void 0;
const core = __importStar(__nccwpck_require__(2186));
const cache = __importStar(__nccwpck_require__(7799));
exports.DEFAULT_CACHE_OPTIONS = {
    skipOnHit: true,
    saveOnError: false,
};
async function withCache(paths, keys, fn, options = exports.DEFAULT_CACHE_OPTIONS) {
    const { skipOnHit, saveOnError } = options;
    core.info(`Cached paths:\n - ${paths.join("\n - ")}`);
    core.info(`Cache key: ${keys.primaryKey}`);
    core.info(`Cache restore keys:\n - ${keys.restoreKeys.join("\n - ")}`);
    const restoredKey = await cache.restoreCache(paths, keys.primaryKey, keys.restoreKeys);
    const primaryKeyHit = restoredKey == keys.primaryKey;
    if (restoredKey) {
        core.info(`Cache restored from key: ${restoredKey}`);
    }
    else {
        core.warning("No cache found");
    }
    if (primaryKeyHit && skipOnHit && !saveOnError) {
        core.info("Skipping due to primary key hit");
        return;
    }
    let result;
    try {
        result = await fn();
        if (!primaryKeyHit) {
            await cache.saveCache(paths, keys.primaryKey);
        }
    }
    catch (ex) {
        if (saveOnError && !primaryKeyHit) {
            await cache.saveCache(paths, keys.primaryKey);
        }
        throw ex;
    }
    return result;
}
exports.withCache = withCache;


/***/ }),

/***/ 7799:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.saveCache = exports.restoreCache = exports.isFeatureAvailable = exports.ReserveCacheError = exports.ValidationError = void 0;
const core = __importStar(__nccwpck_require__(2186));
const path = __importStar(__nccwpck_require__(1017));
const utils = __importStar(__nccwpck_require__(1518));
const cacheHttpClient = __importStar(__nccwpck_require__(8245));
const tar_1 = __nccwpck_require__(6490);
class ValidationError extends Error {
    constructor(message) {
        super(message);
        this.name = 'ValidationError';
        Object.setPrototypeOf(this, ValidationError.prototype);
    }
}
exports.ValidationError = ValidationError;
class ReserveCacheError extends Error {
    constructor(message) {
        super(message);
        this.name = 'ReserveCacheError';
        Object.setPrototypeOf(this, ReserveCacheError.prototype);
    }
}
exports.ReserveCacheError = ReserveCacheError;
function checkPaths(paths) {
    if (!paths || paths.length === 0) {
        throw new ValidationError(`Path Validation Error: At least one directory or file path is required`);
    }
}
function checkKey(key) {
    if (key.length > 512) {
        throw new ValidationError(`Key Validation Error: ${key} cannot be larger than 512 characters.`);
    }
    const regex = /^[^,]*$/;
    if (!regex.test(key)) {
        throw new ValidationError(`Key Validation Error: ${key} cannot contain commas.`);
    }
}
/**
 * isFeatureAvailable to check the presence of Actions cache service
 *
 * @returns boolean return true if Actions cache service feature is available, otherwise false
 */
function isFeatureAvailable() {
    return !!process.env['ACTIONS_CACHE_URL'];
}
exports.isFeatureAvailable = isFeatureAvailable;
/**
 * Restores cache from keys
 *
 * @param paths a list of file paths to restore from the cache
 * @param primaryKey an explicit key for restoring the cache
 * @param restoreKeys an optional ordered list of keys to use for restoring the cache if no cache hit occurred for key
 * @param downloadOptions cache download options
 * @param enableCrossOsArchive an optional boolean enabled to restore on windows any cache created on any platform
 * @returns string returns the key for the cache hit, otherwise returns undefined
 */
function restoreCache(paths, primaryKey, restoreKeys, options, enableCrossOsArchive = false) {
    return __awaiter(this, void 0, void 0, function* () {
        checkPaths(paths);
        restoreKeys = restoreKeys || [];
        const keys = [primaryKey, ...restoreKeys];
        core.debug('Resolved Keys:');
        core.debug(JSON.stringify(keys));
        if (keys.length > 10) {
            throw new ValidationError(`Key Validation Error: Keys are limited to a maximum of 10.`);
        }
        for (const key of keys) {
            checkKey(key);
        }
        const compressionMethod = yield utils.getCompressionMethod();
        let archivePath = '';
        try {
            // path are needed to compute version
            const cacheEntry = yield cacheHttpClient.getCacheEntry(keys, paths, {
                compressionMethod,
                enableCrossOsArchive
            });
            if (!(cacheEntry === null || cacheEntry === void 0 ? void 0 : cacheEntry.archiveLocation)) {
                // Cache not found
                return undefined;
            }
            if (options === null || options === void 0 ? void 0 : options.lookupOnly) {
                core.info('Lookup only - skipping download');
                return cacheEntry.cacheKey;
            }
            archivePath = path.join(yield utils.createTempDirectory(), utils.getCacheFileName(compressionMethod));
            core.debug(`Archive Path: ${archivePath}`);
            // Download the cache from the cache entry
            yield cacheHttpClient.downloadCache(cacheEntry.archiveLocation, archivePath, options);
            if (core.isDebug()) {
                yield (0, tar_1.listTar)(archivePath, compressionMethod);
            }
            const archiveFileSize = utils.getArchiveFileSizeInBytes(archivePath);
            core.info(`Cache Size: ~${Math.round(archiveFileSize / (1024 * 1024))} MB (${archiveFileSize} B)`);
            yield (0, tar_1.extractTar)(archivePath, compressionMethod);
            core.info('Cache restored successfully');
            return cacheEntry.cacheKey;
        }
        catch (error) {
            const typedError = error;
            if (typedError.name === ValidationError.name) {
                throw error;
            }
            else {
                // Supress all non-validation cache related errors because caching should be optional
                core.warning(`Failed to restore: ${error.message}`);
            }
        }
        finally {
            // Try to delete the archive to save space
            try {
                yield utils.unlinkFile(archivePath);
            }
            catch (error) {
                core.debug(`Failed to delete archive: ${error}`);
            }
        }
        return undefined;
    });
}
exports.restoreCache = restoreCache;
/**
 * Saves a list of files with the specified key
 *
 * @param paths a list of file paths to be cached
 * @param key an explicit key for restoring the cache
 * @param enableCrossOsArchive an optional boolean enabled to save cache on windows which could be restored on any platform
 * @param options cache upload options
 * @returns number returns cacheId if the cache was saved successfully and throws an error if save fails
 */
function saveCache(paths, key, options, enableCrossOsArchive = false) {
    var _a, _b, _c, _d, _e;
    return __awaiter(this, void 0, void 0, function* () {
        checkPaths(paths);
        checkKey(key);
        const compressionMethod = yield utils.getCompressionMethod();
        let cacheId = -1;
        const cachePaths = yield utils.resolvePaths(paths);
        core.debug('Cache Paths:');
        core.debug(`${JSON.stringify(cachePaths)}`);
        if (cachePaths.length === 0) {
            throw new Error(`Path Validation Error: Path(s) specified in the action for caching do(es) not exist, hence no cache is being saved.`);
        }
        const archiveFolder = yield utils.createTempDirectory();
        const archivePath = path.join(archiveFolder, utils.getCacheFileName(compressionMethod));
        core.debug(`Archive Path: ${archivePath}`);
        try {
            yield (0, tar_1.createTar)(archiveFolder, cachePaths, compressionMethod);
            if (core.isDebug()) {
                yield (0, tar_1.listTar)(archivePath, compressionMethod);
            }
            const fileSizeLimit = 10 * 1024 * 1024 * 1024; // 10GB per repo limit
            const archiveFileSize = utils.getArchiveFileSizeInBytes(archivePath);
            core.debug(`File Size: ${archiveFileSize}`);
            // For GHES, this check will take place in ReserveCache API with enterprise file size limit
            if (archiveFileSize > fileSizeLimit && !utils.isGhes()) {
                throw new Error(`Cache size of ~${Math.round(archiveFileSize / (1024 * 1024))} MB (${archiveFileSize} B) is over the 10GB limit, not saving cache.`);
            }
            core.debug('Reserving Cache');
            const reserveCacheResponse = yield cacheHttpClient.reserveCache(key, paths, {
                compressionMethod,
                enableCrossOsArchive,
                cacheSize: archiveFileSize
            });
            if ((_a = reserveCacheResponse === null || reserveCacheResponse === void 0 ? void 0 : reserveCacheResponse.result) === null || _a === void 0 ? void 0 : _a.cacheId) {
                cacheId = (_b = reserveCacheResponse === null || reserveCacheResponse === void 0 ? void 0 : reserveCacheResponse.result) === null || _b === void 0 ? void 0 : _b.cacheId;
            }
            else if ((reserveCacheResponse === null || reserveCacheResponse === void 0 ? void 0 : reserveCacheResponse.statusCode) === 400) {
                throw new Error((_d = (_c = reserveCacheResponse === null || reserveCacheResponse === void 0 ? void 0 : reserveCacheResponse.error) === null || _c === void 0 ? void 0 : _c.message) !== null && _d !== void 0 ? _d : `Cache size of ~${Math.round(archiveFileSize / (1024 * 1024))} MB (${archiveFileSize} B) is over the data cap limit, not saving cache.`);
            }
            else {
                throw new ReserveCacheError(`Unable to reserve cache with key ${key}, another job may be creating this cache. More details: ${(_e = reserveCacheResponse === null || reserveCacheResponse === void 0 ? void 0 : reserveCacheResponse.error) === null || _e === void 0 ? void 0 : _e.message}`);
            }
            core.debug(`Saving Cache (ID: ${cacheId})`);
            yield cacheHttpClient.saveCache(cacheId, archivePath, options);
        }
        catch (error) {
            const typedError = error;
            if (typedError.name === ValidationError.name) {
                throw error;
            }
            else if (typedError.name === ReserveCacheError.name) {
                core.info(`Failed to save: ${typedError.message}`);
            }
            else {
                core.warning(`Failed to save: ${typedError.message}`);
            }
        }
        finally {
            // Try to delete the archive to save space
            try {
                yield utils.unlinkFile(archivePath);
            }
            catch (error) {
                core.debug(`Failed to delete archive: ${error}`);
            }
        }
        return cacheId;
    });
}
exports.saveCache = saveCache;
//# sourceMappingURL=cache.js.map

/***/ }),

/***/ 8245:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.saveCache = exports.reserveCache = exports.downloadCache = exports.getCacheEntry = exports.getCacheVersion = void 0;
const core = __importStar(__nccwpck_require__(2186));
const http_client_1 = __nccwpck_require__(6255);
const auth_1 = __nccwpck_require__(5526);
const crypto = __importStar(__nccwpck_require__(6113));
const fs = __importStar(__nccwpck_require__(7147));
const url_1 = __nccwpck_require__(7310);
const utils = __importStar(__nccwpck_require__(1518));
const downloadUtils_1 = __nccwpck_require__(5500);
const options_1 = __nccwpck_require__(6215);
const requestUtils_1 = __nccwpck_require__(3981);
const versionSalt = '1.0';
function getCacheApiUrl(resource) {
    const baseUrl = process.env['ACTIONS_CACHE_URL'] || '';
    if (!baseUrl) {
        throw new Error('Cache Service Url not found, unable to restore cache.');
    }
    const url = `${baseUrl}_apis/artifactcache/${resource}`;
    core.debug(`Resource Url: ${url}`);
    return url;
}
function createAcceptHeader(type, apiVersion) {
    return `${type};api-version=${apiVersion}`;
}
function getRequestOptions() {
    const requestOptions = {
        headers: {
            Accept: createAcceptHeader('application/json', '6.0-preview.1')
        }
    };
    return requestOptions;
}
function createHttpClient() {
    const token = process.env['ACTIONS_RUNTIME_TOKEN'] || '';
    const bearerCredentialHandler = new auth_1.BearerCredentialHandler(token);
    return new http_client_1.HttpClient('actions/cache', [bearerCredentialHandler], getRequestOptions());
}
function getCacheVersion(paths, compressionMethod, enableCrossOsArchive = false) {
    // don't pass changes upstream
    const components = paths.slice();
    // Add compression method to cache version to restore
    // compressed cache as per compression method
    if (compressionMethod) {
        components.push(compressionMethod);
    }
    // Only check for windows platforms if enableCrossOsArchive is false
    if (process.platform === 'win32' && !enableCrossOsArchive) {
        components.push('windows-only');
    }
    // Add salt to cache version to support breaking changes in cache entry
    components.push(versionSalt);
    return crypto.createHash('sha256').update(components.join('|')).digest('hex');
}
exports.getCacheVersion = getCacheVersion;
function getCacheEntry(keys, paths, options) {
    return __awaiter(this, void 0, void 0, function* () {
        const httpClient = createHttpClient();
        const version = getCacheVersion(paths, options === null || options === void 0 ? void 0 : options.compressionMethod, options === null || options === void 0 ? void 0 : options.enableCrossOsArchive);
        const resource = `cache?keys=${encodeURIComponent(keys.join(','))}&version=${version}`;
        const response = yield (0, requestUtils_1.retryTypedResponse)('getCacheEntry', () => __awaiter(this, void 0, void 0, function* () { return httpClient.getJson(getCacheApiUrl(resource)); }));
        // Cache not found
        if (response.statusCode === 204) {
            // List cache for primary key only if cache miss occurs
            if (core.isDebug()) {
                yield printCachesListForDiagnostics(keys[0], httpClient, version);
            }
            return null;
        }
        if (!(0, requestUtils_1.isSuccessStatusCode)(response.statusCode)) {
            throw new Error(`Cache service responded with ${response.statusCode}`);
        }
        const cacheResult = response.result;
        const cacheDownloadUrl = cacheResult === null || cacheResult === void 0 ? void 0 : cacheResult.archiveLocation;
        if (!cacheDownloadUrl) {
            // Cache achiveLocation not found. This should never happen, and hence bail out.
            throw new Error('Cache not found.');
        }
        core.setSecret(cacheDownloadUrl);
        core.debug(`Cache Result:`);
        core.debug(JSON.stringify(cacheResult));
        return cacheResult;
    });
}
exports.getCacheEntry = getCacheEntry;
function printCachesListForDiagnostics(key, httpClient, version) {
    return __awaiter(this, void 0, void 0, function* () {
        const resource = `caches?key=${encodeURIComponent(key)}`;
        const response = yield (0, requestUtils_1.retryTypedResponse)('listCache', () => __awaiter(this, void 0, void 0, function* () { return httpClient.getJson(getCacheApiUrl(resource)); }));
        if (response.statusCode === 200) {
            const cacheListResult = response.result;
            const totalCount = cacheListResult === null || cacheListResult === void 0 ? void 0 : cacheListResult.totalCount;
            if (totalCount && totalCount > 0) {
                core.debug(`No matching cache found for cache key '${key}', version '${version} and scope ${process.env['GITHUB_REF']}. There exist one or more cache(s) with similar key but they have different version or scope. See more info on cache matching here: https://docs.github.com/en/actions/using-workflows/caching-dependencies-to-speed-up-workflows#matching-a-cache-key \nOther caches with similar key:`);
                for (const cacheEntry of (cacheListResult === null || cacheListResult === void 0 ? void 0 : cacheListResult.artifactCaches) || []) {
                    core.debug(`Cache Key: ${cacheEntry === null || cacheEntry === void 0 ? void 0 : cacheEntry.cacheKey}, Cache Version: ${cacheEntry === null || cacheEntry === void 0 ? void 0 : cacheEntry.cacheVersion}, Cache Scope: ${cacheEntry === null || cacheEntry === void 0 ? void 0 : cacheEntry.scope}, Cache Created: ${cacheEntry === null || cacheEntry === void 0 ? void 0 : cacheEntry.creationTime}`);
                }
            }
        }
    });
}
function downloadCache(archiveLocation, archivePath, options) {
    return __awaiter(this, void 0, void 0, function* () {
        const archiveUrl = new url_1.URL(archiveLocation);
        const downloadOptions = (0, options_1.getDownloadOptions)(options);
        if (archiveUrl.hostname.endsWith('.blob.core.windows.net')) {
            if (downloadOptions.useAzureSdk) {
                // Use Azure storage SDK to download caches hosted on Azure to improve speed and reliability.
                yield (0, downloadUtils_1.downloadCacheStorageSDK)(archiveLocation, archivePath, downloadOptions);
            }
            else if (downloadOptions.concurrentBlobDownloads) {
                // Use concurrent implementation with HttpClient to work around blob SDK issue
                yield (0, downloadUtils_1.downloadCacheHttpClientConcurrent)(archiveLocation, archivePath, downloadOptions);
            }
            else {
                // Otherwise, download using the Actions http-client.
                yield (0, downloadUtils_1.downloadCacheHttpClient)(archiveLocation, archivePath);
            }
        }
        else {
            yield (0, downloadUtils_1.downloadCacheHttpClient)(archiveLocation, archivePath);
        }
    });
}
exports.downloadCache = downloadCache;
// Reserve Cache
function reserveCache(key, paths, options) {
    return __awaiter(this, void 0, void 0, function* () {
        const httpClient = createHttpClient();
        const version = getCacheVersion(paths, options === null || options === void 0 ? void 0 : options.compressionMethod, options === null || options === void 0 ? void 0 : options.enableCrossOsArchive);
        const reserveCacheRequest = {
            key,
            version,
            cacheSize: options === null || options === void 0 ? void 0 : options.cacheSize
        };
        const response = yield (0, requestUtils_1.retryTypedResponse)('reserveCache', () => __awaiter(this, void 0, void 0, function* () {
            return httpClient.postJson(getCacheApiUrl('caches'), reserveCacheRequest);
        }));
        return response;
    });
}
exports.reserveCache = reserveCache;
function getContentRange(start, end) {
    // Format: `bytes start-end/filesize
    // start and end are inclusive
    // filesize can be *
    // For a 200 byte chunk starting at byte 0:
    // Content-Range: bytes 0-199/*
    return `bytes ${start}-${end}/*`;
}
function uploadChunk(httpClient, resourceUrl, openStream, start, end) {
    return __awaiter(this, void 0, void 0, function* () {
        core.debug(`Uploading chunk of size ${end - start + 1} bytes at offset ${start} with content range: ${getContentRange(start, end)}`);
        const additionalHeaders = {
            'Content-Type': 'application/octet-stream',
            'Content-Range': getContentRange(start, end)
        };
        const uploadChunkResponse = yield (0, requestUtils_1.retryHttpClientResponse)(`uploadChunk (start: ${start}, end: ${end})`, () => __awaiter(this, void 0, void 0, function* () {
            return httpClient.sendStream('PATCH', resourceUrl, openStream(), additionalHeaders);
        }));
        if (!(0, requestUtils_1.isSuccessStatusCode)(uploadChunkResponse.message.statusCode)) {
            throw new Error(`Cache service responded with ${uploadChunkResponse.message.statusCode} during upload chunk.`);
        }
    });
}
function uploadFile(httpClient, cacheId, archivePath, options) {
    return __awaiter(this, void 0, void 0, function* () {
        // Upload Chunks
        const fileSize = utils.getArchiveFileSizeInBytes(archivePath);
        const resourceUrl = getCacheApiUrl(`caches/${cacheId.toString()}`);
        const fd = fs.openSync(archivePath, 'r');
        const uploadOptions = (0, options_1.getUploadOptions)(options);
        const concurrency = utils.assertDefined('uploadConcurrency', uploadOptions.uploadConcurrency);
        const maxChunkSize = utils.assertDefined('uploadChunkSize', uploadOptions.uploadChunkSize);
        const parallelUploads = [...new Array(concurrency).keys()];
        core.debug('Awaiting all uploads');
        let offset = 0;
        try {
            yield Promise.all(parallelUploads.map(() => __awaiter(this, void 0, void 0, function* () {
                while (offset < fileSize) {
                    const chunkSize = Math.min(fileSize - offset, maxChunkSize);
                    const start = offset;
                    const end = offset + chunkSize - 1;
                    offset += maxChunkSize;
                    yield uploadChunk(httpClient, resourceUrl, () => fs
                        .createReadStream(archivePath, {
                        fd,
                        start,
                        end,
                        autoClose: false
                    })
                        .on('error', error => {
                        throw new Error(`Cache upload failed because file read failed with ${error.message}`);
                    }), start, end);
                }
            })));
        }
        finally {
            fs.closeSync(fd);
        }
        return;
    });
}
function commitCache(httpClient, cacheId, filesize) {
    return __awaiter(this, void 0, void 0, function* () {
        const commitCacheRequest = { size: filesize };
        return yield (0, requestUtils_1.retryTypedResponse)('commitCache', () => __awaiter(this, void 0, void 0, function* () {
            return httpClient.postJson(getCacheApiUrl(`caches/${cacheId.toString()}`), commitCacheRequest);
        }));
    });
}
function saveCache(cacheId, archivePath, options) {
    return __awaiter(this, void 0, void 0, function* () {
        const httpClient = createHttpClient();
        core.debug('Upload cache');
        yield uploadFile(httpClient, cacheId, archivePath, options);
        // Commit Cache
        core.debug('Commiting cache');
        const cacheSize = utils.getArchiveFileSizeInBytes(archivePath);
        core.info(`Cache Size: ~${Math.round(cacheSize / (1024 * 1024))} MB (${cacheSize} B)`);
        const commitCacheResponse = yield commitCache(httpClient, cacheId, cacheSize);
        if (!(0, requestUtils_1.isSuccessStatusCode)(commitCacheResponse.statusCode)) {
            throw new Error(`Cache service responded with ${commitCacheResponse.statusCode} during commit cache.`);
        }
        core.info('Cache saved successfully');
    });
}
exports.saveCache = saveCache;
//# sourceMappingURL=cacheHttpClient.js.map

/***/ }),

/***/ 1518:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isGhes = exports.assertDefined = exports.getGnuTarPathOnWindows = exports.getCacheFileName = exports.getCompressionMethod = exports.unlinkFile = exports.resolvePaths = exports.getArchiveFileSizeInBytes = exports.createTempDirectory = void 0;
const core = __importStar(__nccwpck_require__(2186));
const exec = __importStar(__nccwpck_require__(1514));
const glob = __importStar(__nccwpck_require__(1597));
const io = __importStar(__nccwpck_require__(7436));
const fs = __importStar(__nccwpck_require__(7147));
const path = __importStar(__nccwpck_require__(1017));
const semver = __importStar(__nccwpck_require__(5911));
const util = __importStar(__nccwpck_require__(3837));
const uuid_1 = __nccwpck_require__(4138);
const constants_1 = __nccwpck_require__(8840);
// From https://github.com/actions/toolkit/blob/main/packages/tool-cache/src/tool-cache.ts#L23
function createTempDirectory() {
    return __awaiter(this, void 0, void 0, function* () {
        const IS_WINDOWS = process.platform === 'win32';
        let tempDirectory = process.env['RUNNER_TEMP'] || '';
        if (!tempDirectory) {
            let baseLocation;
            if (IS_WINDOWS) {
                // On Windows use the USERPROFILE env variable
                baseLocation = process.env['USERPROFILE'] || 'C:\\';
            }
            else {
                if (process.platform === 'darwin') {
                    baseLocation = '/Users';
                }
                else {
                    baseLocation = '/home';
                }
            }
            tempDirectory = path.join(baseLocation, 'actions', 'temp');
        }
        const dest = path.join(tempDirectory, (0, uuid_1.v4)());
        yield io.mkdirP(dest);
        return dest;
    });
}
exports.createTempDirectory = createTempDirectory;
function getArchiveFileSizeInBytes(filePath) {
    return fs.statSync(filePath).size;
}
exports.getArchiveFileSizeInBytes = getArchiveFileSizeInBytes;
function resolvePaths(patterns) {
    var _a, e_1, _b, _c;
    var _d;
    return __awaiter(this, void 0, void 0, function* () {
        const paths = [];
        const workspace = (_d = process.env['GITHUB_WORKSPACE']) !== null && _d !== void 0 ? _d : process.cwd();
        const globber = yield glob.create(patterns.join('\n'), {
            implicitDescendants: false
        });
        try {
            for (var _e = true, _f = __asyncValues(globber.globGenerator()), _g; _g = yield _f.next(), _a = _g.done, !_a; _e = true) {
                _c = _g.value;
                _e = false;
                const file = _c;
                const relativeFile = path
                    .relative(workspace, file)
                    .replace(new RegExp(`\\${path.sep}`, 'g'), '/');
                core.debug(`Matched: ${relativeFile}`);
                // Paths are made relative so the tar entries are all relative to the root of the workspace.
                if (relativeFile === '') {
                    // path.relative returns empty string if workspace and file are equal
                    paths.push('.');
                }
                else {
                    paths.push(`${relativeFile}`);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (!_e && !_a && (_b = _f.return)) yield _b.call(_f);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return paths;
    });
}
exports.resolvePaths = resolvePaths;
function unlinkFile(filePath) {
    return __awaiter(this, void 0, void 0, function* () {
        return util.promisify(fs.unlink)(filePath);
    });
}
exports.unlinkFile = unlinkFile;
function getVersion(app, additionalArgs = []) {
    return __awaiter(this, void 0, void 0, function* () {
        let versionOutput = '';
        additionalArgs.push('--version');
        core.debug(`Checking ${app} ${additionalArgs.join(' ')}`);
        try {
            yield exec.exec(`${app}`, additionalArgs, {
                ignoreReturnCode: true,
                silent: true,
                listeners: {
                    stdout: (data) => (versionOutput += data.toString()),
                    stderr: (data) => (versionOutput += data.toString())
                }
            });
        }
        catch (err) {
            core.debug(err.message);
        }
        versionOutput = versionOutput.trim();
        core.debug(versionOutput);
        return versionOutput;
    });
}
// Use zstandard if possible to maximize cache performance
function getCompressionMethod() {
    return __awaiter(this, void 0, void 0, function* () {
        const versionOutput = yield getVersion('zstd', ['--quiet']);
        const version = semver.clean(versionOutput);
        core.debug(`zstd version: ${version}`);
        if (versionOutput === '') {
            return constants_1.CompressionMethod.Gzip;
        }
        else {
            return constants_1.CompressionMethod.ZstdWithoutLong;
        }
    });
}
exports.getCompressionMethod = getCompressionMethod;
function getCacheFileName(compressionMethod) {
    return compressionMethod === constants_1.CompressionMethod.Gzip
        ? constants_1.CacheFilename.Gzip
        : constants_1.CacheFilename.Zstd;
}
exports.getCacheFileName = getCacheFileName;
function getGnuTarPathOnWindows() {
    return __awaiter(this, void 0, void 0, function* () {
        if (fs.existsSync(constants_1.GnuTarPathOnWindows)) {
            return constants_1.GnuTarPathOnWindows;
        }
        const versionOutput = yield getVersion('tar');
        return versionOutput.toLowerCase().includes('gnu tar') ? io.which('tar') : '';
    });
}
exports.getGnuTarPathOnWindows = getGnuTarPathOnWindows;
function assertDefined(name, value) {
    if (value === undefined) {
        throw Error(`Expected ${name} but value was undefiend`);
    }
    return value;
}
exports.assertDefined = assertDefined;
function isGhes() {
    const ghUrl = new URL(process.env['GITHUB_SERVER_URL'] || 'https://github.com');
    const hostname = ghUrl.hostname.trimEnd().toUpperCase();
    const isGitHubHost = hostname === 'GITHUB.COM';
    const isGheHost = hostname.endsWith('.GHE.COM') || hostname.endsWith('.GHE.LOCALHOST');
    return !isGitHubHost && !isGheHost;
}
exports.isGhes = isGhes;
//# sourceMappingURL=cacheUtils.js.map

/***/ }),

/***/ 8840:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ManifestFilename = exports.TarFilename = exports.SystemTarPathOnWindows = exports.GnuTarPathOnWindows = exports.SocketTimeout = exports.DefaultRetryDelay = exports.DefaultRetryAttempts = exports.ArchiveToolType = exports.CompressionMethod = exports.CacheFilename = void 0;
var CacheFilename;
(function (CacheFilename) {
    CacheFilename["Gzip"] = "cache.tgz";
    CacheFilename["Zstd"] = "cache.tzst";
})(CacheFilename || (exports.CacheFilename = CacheFilename = {}));
var CompressionMethod;
(function (CompressionMethod) {
    CompressionMethod["Gzip"] = "gzip";
    // Long range mode was added to zstd in v1.3.2.
    // This enum is for earlier version of zstd that does not have --long support
    CompressionMethod["ZstdWithoutLong"] = "zstd-without-long";
    CompressionMethod["Zstd"] = "zstd";
})(CompressionMethod || (exports.CompressionMethod = CompressionMethod = {}));
var ArchiveToolType;
(function (ArchiveToolType) {
    ArchiveToolType["GNU"] = "gnu";
    ArchiveToolType["BSD"] = "bsd";
})(ArchiveToolType || (exports.ArchiveToolType = ArchiveToolType = {}));
// The default number of retry attempts.
exports.DefaultRetryAttempts = 2;
// The default delay in milliseconds between retry attempts.
exports.DefaultRetryDelay = 5000;
// Socket timeout in milliseconds during download.  If no traffic is received
// over the socket during this period, the socket is destroyed and the download
// is aborted.
exports.SocketTimeout = 5000;
// The default path of GNUtar on hosted Windows runners
exports.GnuTarPathOnWindows = `${process.env['PROGRAMFILES']}\\Git\\usr\\bin\\tar.exe`;
// The default path of BSDtar on hosted Windows runners
exports.SystemTarPathOnWindows = `${process.env['SYSTEMDRIVE']}\\Windows\\System32\\tar.exe`;
exports.TarFilename = 'cache.tar';
exports.ManifestFilename = 'manifest.txt';
//# sourceMappingURL=constants.js.map

/***/ }),

/***/ 5500:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.downloadCacheStorageSDK = exports.downloadCacheHttpClientConcurrent = exports.downloadCacheHttpClient = exports.DownloadProgress = void 0;
const core = __importStar(__nccwpck_require__(2186));
const http_client_1 = __nccwpck_require__(6255);
const storage_blob_1 = __nccwpck_require__(4100);
const buffer = __importStar(__nccwpck_require__(4300));
const fs = __importStar(__nccwpck_require__(7147));
const stream = __importStar(__nccwpck_require__(2781));
const util = __importStar(__nccwpck_require__(3837));
const utils = __importStar(__nccwpck_require__(1518));
const constants_1 = __nccwpck_require__(8840);
const requestUtils_1 = __nccwpck_require__(3981);
const abort_controller_1 = __nccwpck_require__(2557);
/**
 * Pipes the body of a HTTP response to a stream
 *
 * @param response the HTTP response
 * @param output the writable stream
 */
function pipeResponseToStream(response, output) {
    return __awaiter(this, void 0, void 0, function* () {
        const pipeline = util.promisify(stream.pipeline);
        yield pipeline(response.message, output);
    });
}
/**
 * Class for tracking the download state and displaying stats.
 */
class DownloadProgress {
    constructor(contentLength) {
        this.contentLength = contentLength;
        this.segmentIndex = 0;
        this.segmentSize = 0;
        this.segmentOffset = 0;
        this.receivedBytes = 0;
        this.displayedComplete = false;
        this.startTime = Date.now();
    }
    /**
     * Progress to the next segment. Only call this method when the previous segment
     * is complete.
     *
     * @param segmentSize the length of the next segment
     */
    nextSegment(segmentSize) {
        this.segmentOffset = this.segmentOffset + this.segmentSize;
        this.segmentIndex = this.segmentIndex + 1;
        this.segmentSize = segmentSize;
        this.receivedBytes = 0;
        core.debug(`Downloading segment at offset ${this.segmentOffset} with length ${this.segmentSize}...`);
    }
    /**
     * Sets the number of bytes received for the current segment.
     *
     * @param receivedBytes the number of bytes received
     */
    setReceivedBytes(receivedBytes) {
        this.receivedBytes = receivedBytes;
    }
    /**
     * Returns the total number of bytes transferred.
     */
    getTransferredBytes() {
        return this.segmentOffset + this.receivedBytes;
    }
    /**
     * Returns true if the download is complete.
     */
    isDone() {
        return this.getTransferredBytes() === this.contentLength;
    }
    /**
     * Prints the current download stats. Once the download completes, this will print one
     * last line and then stop.
     */
    display() {
        if (this.displayedComplete) {
            return;
        }
        const transferredBytes = this.segmentOffset + this.receivedBytes;
        const percentage = (100 * (transferredBytes / this.contentLength)).toFixed(1);
        const elapsedTime = Date.now() - this.startTime;
        const downloadSpeed = (transferredBytes /
            (1024 * 1024) /
            (elapsedTime / 1000)).toFixed(1);
        core.info(`Received ${transferredBytes} of ${this.contentLength} (${percentage}%), ${downloadSpeed} MBs/sec`);
        if (this.isDone()) {
            this.displayedComplete = true;
        }
    }
    /**
     * Returns a function used to handle TransferProgressEvents.
     */
    onProgress() {
        return (progress) => {
            this.setReceivedBytes(progress.loadedBytes);
        };
    }
    /**
     * Starts the timer that displays the stats.
     *
     * @param delayInMs the delay between each write
     */
    startDisplayTimer(delayInMs = 1000) {
        const displayCallback = () => {
            this.display();
            if (!this.isDone()) {
                this.timeoutHandle = setTimeout(displayCallback, delayInMs);
            }
        };
        this.timeoutHandle = setTimeout(displayCallback, delayInMs);
    }
    /**
     * Stops the timer that displays the stats. As this typically indicates the download
     * is complete, this will display one last line, unless the last line has already
     * been written.
     */
    stopDisplayTimer() {
        if (this.timeoutHandle) {
            clearTimeout(this.timeoutHandle);
            this.timeoutHandle = undefined;
        }
        this.display();
    }
}
exports.DownloadProgress = DownloadProgress;
/**
 * Download the cache using the Actions toolkit http-client
 *
 * @param archiveLocation the URL for the cache
 * @param archivePath the local path where the cache is saved
 */
function downloadCacheHttpClient(archiveLocation, archivePath) {
    return __awaiter(this, void 0, void 0, function* () {
        const writeStream = fs.createWriteStream(archivePath);
        const httpClient = new http_client_1.HttpClient('actions/cache');
        const downloadResponse = yield (0, requestUtils_1.retryHttpClientResponse)('downloadCache', () => __awaiter(this, void 0, void 0, function* () { return httpClient.get(archiveLocation); }));
        // Abort download if no traffic received over the socket.
        downloadResponse.message.socket.setTimeout(constants_1.SocketTimeout, () => {
            downloadResponse.message.destroy();
            core.debug(`Aborting download, socket timed out after ${constants_1.SocketTimeout} ms`);
        });
        yield pipeResponseToStream(downloadResponse, writeStream);
        // Validate download size.
        const contentLengthHeader = downloadResponse.message.headers['content-length'];
        if (contentLengthHeader) {
            const expectedLength = parseInt(contentLengthHeader);
            const actualLength = utils.getArchiveFileSizeInBytes(archivePath);
            if (actualLength !== expectedLength) {
                throw new Error(`Incomplete download. Expected file size: ${expectedLength}, actual file size: ${actualLength}`);
            }
        }
        else {
            core.debug('Unable to validate download, no Content-Length header');
        }
    });
}
exports.downloadCacheHttpClient = downloadCacheHttpClient;
/**
 * Download the cache using the Actions toolkit http-client concurrently
 *
 * @param archiveLocation the URL for the cache
 * @param archivePath the local path where the cache is saved
 */
function downloadCacheHttpClientConcurrent(archiveLocation, archivePath, options) {
    var _a;
    return __awaiter(this, void 0, void 0, function* () {
        const archiveDescriptor = yield fs.promises.open(archivePath, 'w');
        const httpClient = new http_client_1.HttpClient('actions/cache', undefined, {
            socketTimeout: options.timeoutInMs,
            keepAlive: true
        });
        try {
            const res = yield (0, requestUtils_1.retryHttpClientResponse)('downloadCacheMetadata', () => __awaiter(this, void 0, void 0, function* () { return yield httpClient.request('HEAD', archiveLocation, null, {}); }));
            const lengthHeader = res.message.headers['content-length'];
            if (lengthHeader === undefined || lengthHeader === null) {
                throw new Error('Content-Length not found on blob response');
            }
            const length = parseInt(lengthHeader);
            if (Number.isNaN(length)) {
                throw new Error(`Could not interpret Content-Length: ${length}`);
            }
            const downloads = [];
            const blockSize = 4 * 1024 * 1024;
            for (let offset = 0; offset < length; offset += blockSize) {
                const count = Math.min(blockSize, length - offset);
                downloads.push({
                    offset,
                    promiseGetter: () => __awaiter(this, void 0, void 0, function* () {
                        return yield downloadSegmentRetry(httpClient, archiveLocation, offset, count);
                    })
                });
            }
            // reverse to use .pop instead of .shift
            downloads.reverse();
            let actives = 0;
            let bytesDownloaded = 0;
            const progress = new DownloadProgress(length);
            progress.startDisplayTimer();
            const progressFn = progress.onProgress();
            const activeDownloads = [];
            let nextDownload;
            const waitAndWrite = () => __awaiter(this, void 0, void 0, function* () {
                const segment = yield Promise.race(Object.values(activeDownloads));
                yield archiveDescriptor.write(segment.buffer, 0, segment.count, segment.offset);
                actives--;
                delete activeDownloads[segment.offset];
                bytesDownloaded += segment.count;
                progressFn({ loadedBytes: bytesDownloaded });
            });
            while ((nextDownload = downloads.pop())) {
                activeDownloads[nextDownload.offset] = nextDownload.promiseGetter();
                actives++;
                if (actives >= ((_a = options.downloadConcurrency) !== null && _a !== void 0 ? _a : 10)) {
                    yield waitAndWrite();
                }
            }
            while (actives > 0) {
                yield waitAndWrite();
            }
        }
        finally {
            httpClient.dispose();
            yield archiveDescriptor.close();
        }
    });
}
exports.downloadCacheHttpClientConcurrent = downloadCacheHttpClientConcurrent;
function downloadSegmentRetry(httpClient, archiveLocation, offset, count) {
    return __awaiter(this, void 0, void 0, function* () {
        const retries = 5;
        let failures = 0;
        while (true) {
            try {
                const timeout = 30000;
                const result = yield promiseWithTimeout(timeout, downloadSegment(httpClient, archiveLocation, offset, count));
                if (typeof result === 'string') {
                    throw new Error('downloadSegmentRetry failed due to timeout');
                }
                return result;
            }
            catch (err) {
                if (failures >= retries) {
                    throw err;
                }
                failures++;
            }
        }
    });
}
function downloadSegment(httpClient, archiveLocation, offset, count) {
    return __awaiter(this, void 0, void 0, function* () {
        const partRes = yield (0, requestUtils_1.retryHttpClientResponse)('downloadCachePart', () => __awaiter(this, void 0, void 0, function* () {
            return yield httpClient.get(archiveLocation, {
                Range: `bytes=${offset}-${offset + count - 1}`
            });
        }));
        if (!partRes.readBodyBuffer) {
            throw new Error('Expected HttpClientResponse to implement readBodyBuffer');
        }
        return {
            offset,
            count,
            buffer: yield partRes.readBodyBuffer()
        };
    });
}
/**
 * Download the cache using the Azure Storage SDK.  Only call this method if the
 * URL points to an Azure Storage endpoint.
 *
 * @param archiveLocation the URL for the cache
 * @param archivePath the local path where the cache is saved
 * @param options the download options with the defaults set
 */
function downloadCacheStorageSDK(archiveLocation, archivePath, options) {
    var _a;
    return __awaiter(this, void 0, void 0, function* () {
        const client = new storage_blob_1.BlockBlobClient(archiveLocation, undefined, {
            retryOptions: {
                // Override the timeout used when downloading each 4 MB chunk
                // The default is 2 min / MB, which is way too slow
                tryTimeoutInMs: options.timeoutInMs
            }
        });
        const properties = yield client.getProperties();
        const contentLength = (_a = properties.contentLength) !== null && _a !== void 0 ? _a : -1;
        if (contentLength < 0) {
            // We should never hit this condition, but just in case fall back to downloading the
            // file as one large stream
            core.debug('Unable to determine content length, downloading file with http-client...');
            yield downloadCacheHttpClient(archiveLocation, archivePath);
        }
        else {
            // Use downloadToBuffer for faster downloads, since internally it splits the
            // file into 4 MB chunks which can then be parallelized and retried independently
            //
            // If the file exceeds the buffer maximum length (~1 GB on 32-bit systems and ~2 GB
            // on 64-bit systems), split the download into multiple segments
            // ~2 GB = 2147483647, beyond this, we start getting out of range error. So, capping it accordingly.
            // Updated segment size to 128MB = 134217728 bytes, to complete a segment faster and fail fast
            const maxSegmentSize = Math.min(134217728, buffer.constants.MAX_LENGTH);
            const downloadProgress = new DownloadProgress(contentLength);
            const fd = fs.openSync(archivePath, 'w');
            try {
                downloadProgress.startDisplayTimer();
                const controller = new abort_controller_1.AbortController();
                const abortSignal = controller.signal;
                while (!downloadProgress.isDone()) {
                    const segmentStart = downloadProgress.segmentOffset + downloadProgress.segmentSize;
                    const segmentSize = Math.min(maxSegmentSize, contentLength - segmentStart);
                    downloadProgress.nextSegment(segmentSize);
                    const result = yield promiseWithTimeout(options.segmentTimeoutInMs || 3600000, client.downloadToBuffer(segmentStart, segmentSize, {
                        abortSignal,
                        concurrency: options.downloadConcurrency,
                        onProgress: downloadProgress.onProgress()
                    }));
                    if (result === 'timeout') {
                        controller.abort();
                        throw new Error('Aborting cache download as the download time exceeded the timeout.');
                    }
                    else if (Buffer.isBuffer(result)) {
                        fs.writeFileSync(fd, result);
                    }
                }
            }
            finally {
                downloadProgress.stopDisplayTimer();
                fs.closeSync(fd);
            }
        }
    });
}
exports.downloadCacheStorageSDK = downloadCacheStorageSDK;
const promiseWithTimeout = (timeoutMs, promise) => __awaiter(void 0, void 0, void 0, function* () {
    let timeoutHandle;
    const timeoutPromise = new Promise(resolve => {
        timeoutHandle = setTimeout(() => resolve('timeout'), timeoutMs);
    });
    return Promise.race([promise, timeoutPromise]).then(result => {
        clearTimeout(timeoutHandle);
        return result;
    });
});
//# sourceMappingURL=downloadUtils.js.map

/***/ }),

/***/ 3981:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.retryHttpClientResponse = exports.retryTypedResponse = exports.retry = exports.isRetryableStatusCode = exports.isServerErrorStatusCode = exports.isSuccessStatusCode = void 0;
const core = __importStar(__nccwpck_require__(2186));
const http_client_1 = __nccwpck_require__(6255);
const constants_1 = __nccwpck_require__(8840);
function isSuccessStatusCode(statusCode) {
    if (!statusCode) {
        return false;
    }
    return statusCode >= 200 && statusCode < 300;
}
exports.isSuccessStatusCode = isSuccessStatusCode;
function isServerErrorStatusCode(statusCode) {
    if (!statusCode) {
        return true;
    }
    return statusCode >= 500;
}
exports.isServerErrorStatusCode = isServerErrorStatusCode;
function isRetryableStatusCode(statusCode) {
    if (!statusCode) {
        return false;
    }
    const retryableStatusCodes = [
        http_client_1.HttpCodes.BadGateway,
        http_client_1.HttpCodes.ServiceUnavailable,
        http_client_1.HttpCodes.GatewayTimeout
    ];
    return retryableStatusCodes.includes(statusCode);
}
exports.isRetryableStatusCode = isRetryableStatusCode;
function sleep(milliseconds) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise(resolve => setTimeout(resolve, milliseconds));
    });
}
function retry(name, method, getStatusCode, maxAttempts = constants_1.DefaultRetryAttempts, delay = constants_1.DefaultRetryDelay, onError = undefined) {
    return __awaiter(this, void 0, void 0, function* () {
        let errorMessage = '';
        let attempt = 1;
        while (attempt <= maxAttempts) {
            let response = undefined;
            let statusCode = undefined;
            let isRetryable = false;
            try {
                response = yield method();
            }
            catch (error) {
                if (onError) {
                    response = onError(error);
                }
                isRetryable = true;
                errorMessage = error.message;
            }
            if (response) {
                statusCode = getStatusCode(response);
                if (!isServerErrorStatusCode(statusCode)) {
                    return response;
                }
            }
            if (statusCode) {
                isRetryable = isRetryableStatusCode(statusCode);
                errorMessage = `Cache service responded with ${statusCode}`;
            }
            core.debug(`${name} - Attempt ${attempt} of ${maxAttempts} failed with error: ${errorMessage}`);
            if (!isRetryable) {
                core.debug(`${name} - Error is not retryable`);
                break;
            }
            yield sleep(delay);
            attempt++;
        }
        throw Error(`${name} failed: ${errorMessage}`);
    });
}
exports.retry = retry;
function retryTypedResponse(name, method, maxAttempts = constants_1.DefaultRetryAttempts, delay = constants_1.DefaultRetryDelay) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield retry(name, method, (response) => response.statusCode, maxAttempts, delay, 
        // If the error object contains the statusCode property, extract it and return
        // an TypedResponse<T> so it can be processed by the retry logic.
        (error) => {
            if (error instanceof http_client_1.HttpClientError) {
                return {
                    statusCode: error.statusCode,
                    result: null,
                    headers: {},
                    error
                };
            }
            else {
                return undefined;
            }
        });
    });
}
exports.retryTypedResponse = retryTypedResponse;
function retryHttpClientResponse(name, method, maxAttempts = constants_1.DefaultRetryAttempts, delay = constants_1.DefaultRetryDelay) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield retry(name, method, (response) => response.message.statusCode, maxAttempts, delay);
    });
}
exports.retryHttpClientResponse = retryHttpClientResponse;
//# sourceMappingURL=requestUtils.js.map

/***/ }),

/***/ 6490:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createTar = exports.extractTar = exports.listTar = void 0;
const exec_1 = __nccwpck_require__(1514);
const io = __importStar(__nccwpck_require__(7436));
const fs_1 = __nccwpck_require__(7147);
const path = __importStar(__nccwpck_require__(1017));
const utils = __importStar(__nccwpck_require__(1518));
const constants_1 = __nccwpck_require__(8840);
const IS_WINDOWS = process.platform === 'win32';
// Returns tar path and type: BSD or GNU
function getTarPath() {
    return __awaiter(this, void 0, void 0, function* () {
        switch (process.platform) {
            case 'win32': {
                const gnuTar = yield utils.getGnuTarPathOnWindows();
                const systemTar = constants_1.SystemTarPathOnWindows;
                if (gnuTar) {
                    // Use GNUtar as default on windows
                    return { path: gnuTar, type: constants_1.ArchiveToolType.GNU };
                }
                else if ((0, fs_1.existsSync)(systemTar)) {
                    return { path: systemTar, type: constants_1.ArchiveToolType.BSD };
                }
                break;
            }
            case 'darwin': {
                const gnuTar = yield io.which('gtar', false);
                if (gnuTar) {
                    // fix permission denied errors when extracting BSD tar archive with GNU tar - https://github.com/actions/cache/issues/527
                    return { path: gnuTar, type: constants_1.ArchiveToolType.GNU };
                }
                else {
                    return {
                        path: yield io.which('tar', true),
                        type: constants_1.ArchiveToolType.BSD
                    };
                }
            }
            default:
                break;
        }
        // Default assumption is GNU tar is present in path
        return {
            path: yield io.which('tar', true),
            type: constants_1.ArchiveToolType.GNU
        };
    });
}
// Return arguments for tar as per tarPath, compressionMethod, method type and os
function getTarArgs(tarPath, compressionMethod, type, archivePath = '') {
    return __awaiter(this, void 0, void 0, function* () {
        const args = [`"${tarPath.path}"`];
        const cacheFileName = utils.getCacheFileName(compressionMethod);
        const tarFile = 'cache.tar';
        const workingDirectory = getWorkingDirectory();
        // Speficic args for BSD tar on windows for workaround
        const BSD_TAR_ZSTD = tarPath.type === constants_1.ArchiveToolType.BSD &&
            compressionMethod !== constants_1.CompressionMethod.Gzip &&
            IS_WINDOWS;
        // Method specific args
        switch (type) {
            case 'create':
                args.push('--posix', '-cf', BSD_TAR_ZSTD
                    ? tarFile
                    : cacheFileName.replace(new RegExp(`\\${path.sep}`, 'g'), '/'), '--exclude', BSD_TAR_ZSTD
                    ? tarFile
                    : cacheFileName.replace(new RegExp(`\\${path.sep}`, 'g'), '/'), '-P', '-C', workingDirectory.replace(new RegExp(`\\${path.sep}`, 'g'), '/'), '--files-from', constants_1.ManifestFilename);
                break;
            case 'extract':
                args.push('-xf', BSD_TAR_ZSTD
                    ? tarFile
                    : archivePath.replace(new RegExp(`\\${path.sep}`, 'g'), '/'), '-P', '-C', workingDirectory.replace(new RegExp(`\\${path.sep}`, 'g'), '/'));
                break;
            case 'list':
                args.push('-tf', BSD_TAR_ZSTD
                    ? tarFile
                    : archivePath.replace(new RegExp(`\\${path.sep}`, 'g'), '/'), '-P');
                break;
        }
        // Platform specific args
        if (tarPath.type === constants_1.ArchiveToolType.GNU) {
            switch (process.platform) {
                case 'win32':
                    args.push('--force-local');
                    break;
                case 'darwin':
                    args.push('--delay-directory-restore');
                    break;
            }
        }
        return args;
    });
}
// Returns commands to run tar and compression program
function getCommands(compressionMethod, type, archivePath = '') {
    return __awaiter(this, void 0, void 0, function* () {
        let args;
        const tarPath = yield getTarPath();
        const tarArgs = yield getTarArgs(tarPath, compressionMethod, type, archivePath);
        const compressionArgs = type !== 'create'
            ? yield getDecompressionProgram(tarPath, compressionMethod, archivePath)
            : yield getCompressionProgram(tarPath, compressionMethod);
        const BSD_TAR_ZSTD = tarPath.type === constants_1.ArchiveToolType.BSD &&
            compressionMethod !== constants_1.CompressionMethod.Gzip &&
            IS_WINDOWS;
        if (BSD_TAR_ZSTD && type !== 'create') {
            args = [[...compressionArgs].join(' '), [...tarArgs].join(' ')];
        }
        else {
            args = [[...tarArgs].join(' '), [...compressionArgs].join(' ')];
        }
        if (BSD_TAR_ZSTD) {
            return args;
        }
        return [args.join(' ')];
    });
}
function getWorkingDirectory() {
    var _a;
    return (_a = process.env['GITHUB_WORKSPACE']) !== null && _a !== void 0 ? _a : process.cwd();
}
// Common function for extractTar and listTar to get the compression method
function getDecompressionProgram(tarPath, compressionMethod, archivePath) {
    return __awaiter(this, void 0, void 0, function* () {
        // -d: Decompress.
        // unzstd is equivalent to 'zstd -d'
        // --long=#: Enables long distance matching with # bits. Maximum is 30 (1GB) on 32-bit OS and 31 (2GB) on 64-bit.
        // Using 30 here because we also support 32-bit self-hosted runners.
        const BSD_TAR_ZSTD = tarPath.type === constants_1.ArchiveToolType.BSD &&
            compressionMethod !== constants_1.CompressionMethod.Gzip &&
            IS_WINDOWS;
        switch (compressionMethod) {
            case constants_1.CompressionMethod.Zstd:
                return BSD_TAR_ZSTD
                    ? [
                        'zstd -d --long=30 --force -o',
                        constants_1.TarFilename,
                        archivePath.replace(new RegExp(`\\${path.sep}`, 'g'), '/')
                    ]
                    : [
                        '--use-compress-program',
                        IS_WINDOWS ? '"zstd -d --long=30"' : 'unzstd --long=30'
                    ];
            case constants_1.CompressionMethod.ZstdWithoutLong:
                return BSD_TAR_ZSTD
                    ? [
                        'zstd -d --force -o',
                        constants_1.TarFilename,
                        archivePath.replace(new RegExp(`\\${path.sep}`, 'g'), '/')
                    ]
                    : ['--use-compress-program', IS_WINDOWS ? '"zstd -d"' : 'unzstd'];
            default:
                return ['-z'];
        }
    });
}
// Used for creating the archive
// -T#: Compress using # working thread. If # is 0, attempt to detect and use the number of physical CPU cores.
// zstdmt is equivalent to 'zstd -T0'
// --long=#: Enables long distance matching with # bits. Maximum is 30 (1GB) on 32-bit OS and 31 (2GB) on 64-bit.
// Using 30 here because we also support 32-bit self-hosted runners.
// Long range mode is added to zstd in v1.3.2 release, so we will not use --long in older version of zstd.
function getCompressionProgram(tarPath, compressionMethod) {
    return __awaiter(this, void 0, void 0, function* () {
        const cacheFileName = utils.getCacheFileName(compressionMethod);
        const BSD_TAR_ZSTD = tarPath.type === constants_1.ArchiveToolType.BSD &&
            compressionMethod !== constants_1.CompressionMethod.Gzip &&
            IS_WINDOWS;
        switch (compressionMethod) {
            case constants_1.CompressionMethod.Zstd:
                return BSD_TAR_ZSTD
                    ? [
                        'zstd -T0 --long=30 --force -o',
                        cacheFileName.replace(new RegExp(`\\${path.sep}`, 'g'), '/'),
                        constants_1.TarFilename
                    ]
                    : [
                        '--use-compress-program',
                        IS_WINDOWS ? '"zstd -T0 --long=30"' : 'zstdmt --long=30'
                    ];
            case constants_1.CompressionMethod.ZstdWithoutLong:
                return BSD_TAR_ZSTD
                    ? [
                        'zstd -T0 --force -o',
                        cacheFileName.replace(new RegExp(`\\${path.sep}`, 'g'), '/'),
                        constants_1.TarFilename
                    ]
                    : ['--use-compress-program', IS_WINDOWS ? '"zstd -T0"' : 'zstdmt'];
            default:
                return ['-z'];
        }
    });
}
// Executes all commands as separate processes
function execCommands(commands, cwd) {
    return __awaiter(this, void 0, void 0, function* () {
        for (const command of commands) {
            try {
                yield (0, exec_1.exec)(command, undefined, {
                    cwd,
                    env: Object.assign(Object.assign({}, process.env), { MSYS: 'winsymlinks:nativestrict' })
                });
            }
            catch (error) {
                throw new Error(`${command.split(' ')[0]} failed with error: ${error === null || error === void 0 ? void 0 : error.message}`);
            }
        }
    });
}
// List the contents of a tar
function listTar(archivePath, compressionMethod) {
    return __awaiter(this, void 0, void 0, function* () {
        const commands = yield getCommands(compressionMethod, 'list', archivePath);
        yield execCommands(commands);
    });
}
exports.listTar = listTar;
// Extract a tar
function extractTar(archivePath, compressionMethod) {
    return __awaiter(this, void 0, void 0, function* () {
        // Create directory to extract tar into
        const workingDirectory = getWorkingDirectory();
        yield io.mkdirP(workingDirectory);
        const commands = yield getCommands(compressionMethod, 'extract', archivePath);
        yield execCommands(commands);
    });
}
exports.extractTar = extractTar;
// Create a tar
function createTar(archiveFolder, sourceDirectories, compressionMethod) {
    return __awaiter(this, void 0, void 0, function* () {
        // Write source directories to manifest.txt to avoid command length limits
        (0, fs_1.writeFileSync)(path.join(archiveFolder, constants_1.ManifestFilename), sourceDirectories.join('\n'));
        const commands = yield getCommands(compressionMethod, 'create');
        yield execCommands(commands, archiveFolder);
    });
}
exports.createTar = createTar;
//# sourceMappingURL=tar.js.map

/***/ }),

/***/ 6215:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getDownloadOptions = exports.getUploadOptions = void 0;
const core = __importStar(__nccwpck_require__(2186));
/**
 * Returns a copy of the upload options with defaults filled in.
 *
 * @param copy the original upload options
 */
function getUploadOptions(copy) {
    const result = {
        uploadConcurrency: 4,
        uploadChunkSize: 32 * 1024 * 1024
    };
    if (copy) {
        if (typeof copy.uploadConcurrency === 'number') {
            result.uploadConcurrency = copy.uploadConcurrency;
        }
        if (typeof copy.uploadChunkSize === 'number') {
            result.uploadChunkSize = copy.uploadChunkSize;
        }
    }
    core.debug(`Upload concurrency: ${result.uploadConcurrency}`);
    core.debug(`Upload chunk size: ${result.uploadChunkSize}`);
    return result;
}
exports.getUploadOptions = getUploadOptions;
/**
 * Returns a copy of the download options with defaults filled in.
 *
 * @param copy the original download options
 */
function getDownloadOptions(copy) {
    const result = {
        useAzureSdk: false,
        concurrentBlobDownloads: true,
        downloadConcurrency: 8,
        timeoutInMs: 30000,
        segmentTimeoutInMs: 600000,
        lookupOnly: false
    };
    if (copy) {
        if (typeof copy.useAzureSdk === 'boolean') {
            result.useAzureSdk = copy.useAzureSdk;
        }
        if (typeof copy.concurrentBlobDownloads === 'boolean') {
            result.concurrentBlobDownloads = copy.concurrentBlobDownloads;
        }
        if (typeof copy.downloadConcurrency === 'number') {
            result.downloadConcurrency = copy.downloadConcurrency;
        }
        if (typeof copy.timeoutInMs === 'number') {
            result.timeoutInMs = copy.timeoutInMs;
        }
        if (typeof copy.segmentTimeoutInMs === 'number') {
            result.segmentTimeoutInMs = copy.segmentTimeoutInMs;
        }
        if (typeof copy.lookupOnly === 'boolean') {
            result.lookupOnly = copy.lookupOnly;
        }
    }
    const segmentDownloadTimeoutMins = process.env['SEGMENT_DOWNLOAD_TIMEOUT_MINS'];
    if (segmentDownloadTimeoutMins &&
        !isNaN(Number(segmentDownloadTimeoutMins)) &&
        isFinite(Number(segmentDownloadTimeoutMins))) {
        result.segmentTimeoutInMs = Number(segmentDownloadTimeoutMins) * 60 * 1000;
    }
    core.debug(`Use Azure SDK: ${result.useAzureSdk}`);
    core.debug(`Download concurrency: ${result.downloadConcurrency}`);
    core.debug(`Request timeout (ms): ${result.timeoutInMs}`);
    core.debug(`Cache segment download timeout mins env var: ${process.env['SEGMENT_DOWNLOAD_TIMEOUT_MINS']}`);
    core.debug(`Segment download timeout (ms): ${result.segmentTimeoutInMs}`);
    core.debug(`Lookup only: ${result.lookupOnly}`);
    return result;
}
exports.getDownloadOptions = getDownloadOptions;
//# sourceMappingURL=options.js.map

/***/ }),

/***/ 1597:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.create = void 0;
const internal_globber_1 = __nccwpck_require__(7341);
/**
 * Constructs a globber
 *
 * @param patterns  Patterns separated by newlines
 * @param options   Glob options
 */
function create(patterns, options) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield internal_globber_1.DefaultGlobber.create(patterns, options);
    });
}
exports.create = create;
//# sourceMappingURL=glob.js.map

/***/ }),

/***/ 9350:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getOptions = void 0;
const core = __importStar(__nccwpck_require__(2186));
/**
 * Returns a copy with defaults filled in.
 */
function getOptions(copy) {
    const result = {
        followSymbolicLinks: true,
        implicitDescendants: true,
        omitBrokenSymbolicLinks: true
    };
    if (copy) {
        if (typeof copy.followSymbolicLinks === 'boolean') {
            result.followSymbolicLinks = copy.followSymbolicLinks;
            core.debug(`followSymbolicLinks '${result.followSymbolicLinks}'`);
        }
        if (typeof copy.implicitDescendants === 'boolean') {
            result.implicitDescendants = copy.implicitDescendants;
            core.debug(`implicitDescendants '${result.implicitDescendants}'`);
        }
        if (typeof copy.omitBrokenSymbolicLinks === 'boolean') {
            result.omitBrokenSymbolicLinks = copy.omitBrokenSymbolicLinks;
            core.debug(`omitBrokenSymbolicLinks '${result.omitBrokenSymbolicLinks}'`);
        }
    }
    return result;
}
exports.getOptions = getOptions;
//# sourceMappingURL=internal-glob-options-helper.js.map

/***/ }),

/***/ 7341:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultGlobber = void 0;
const core = __importStar(__nccwpck_require__(2186));
const fs = __importStar(__nccwpck_require__(7147));
const globOptionsHelper = __importStar(__nccwpck_require__(9350));
const path = __importStar(__nccwpck_require__(1017));
const patternHelper = __importStar(__nccwpck_require__(5186));
const internal_match_kind_1 = __nccwpck_require__(836);
const internal_pattern_1 = __nccwpck_require__(5343);
const internal_search_state_1 = __nccwpck_require__(8530);
const IS_WINDOWS = process.platform === 'win32';
class DefaultGlobber {
    constructor(options) {
        this.patterns = [];
        this.searchPaths = [];
        this.options = globOptionsHelper.getOptions(options);
    }
    getSearchPaths() {
        // Return a copy
        return this.searchPaths.slice();
    }
    glob() {
        var e_1, _a;
        return __awaiter(this, void 0, void 0, function* () {
            const result = [];
            try {
                for (var _b = __asyncValues(this.globGenerator()), _c; _c = yield _b.next(), !_c.done;) {
                    const itemPath = _c.value;
                    result.push(itemPath);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) yield _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return result;
        });
    }
    globGenerator() {
        return __asyncGenerator(this, arguments, function* globGenerator_1() {
            // Fill in defaults options
            const options = globOptionsHelper.getOptions(this.options);
            // Implicit descendants?
            const patterns = [];
            for (const pattern of this.patterns) {
                patterns.push(pattern);
                if (options.implicitDescendants &&
                    (pattern.trailingSeparator ||
                        pattern.segments[pattern.segments.length - 1] !== '**')) {
                    patterns.push(new internal_pattern_1.Pattern(pattern.negate, true, pattern.segments.concat('**')));
                }
            }
            // Push the search paths
            const stack = [];
            for (const searchPath of patternHelper.getSearchPaths(patterns)) {
                core.debug(`Search path '${searchPath}'`);
                // Exists?
                try {
                    // Intentionally using lstat. Detection for broken symlink
                    // will be performed later (if following symlinks).
                    yield __await(fs.promises.lstat(searchPath));
                }
                catch (err) {
                    if (err.code === 'ENOENT') {
                        continue;
                    }
                    throw err;
                }
                stack.unshift(new internal_search_state_1.SearchState(searchPath, 1));
            }
            // Search
            const traversalChain = []; // used to detect cycles
            while (stack.length) {
                // Pop
                const item = stack.pop();
                // Match?
                const match = patternHelper.match(patterns, item.path);
                const partialMatch = !!match || patternHelper.partialMatch(patterns, item.path);
                if (!match && !partialMatch) {
                    continue;
                }
                // Stat
                const stats = yield __await(DefaultGlobber.stat(item, options, traversalChain)
                // Broken symlink, or symlink cycle detected, or no longer exists
                );
                // Broken symlink, or symlink cycle detected, or no longer exists
                if (!stats) {
                    continue;
                }
                // Directory
                if (stats.isDirectory()) {
                    // Matched
                    if (match & internal_match_kind_1.MatchKind.Directory) {
                        yield yield __await(item.path);
                    }
                    // Descend?
                    else if (!partialMatch) {
                        continue;
                    }
                    // Push the child items in reverse
                    const childLevel = item.level + 1;
                    const childItems = (yield __await(fs.promises.readdir(item.path))).map(x => new internal_search_state_1.SearchState(path.join(item.path, x), childLevel));
                    stack.push(...childItems.reverse());
                }
                // File
                else if (match & internal_match_kind_1.MatchKind.File) {
                    yield yield __await(item.path);
                }
            }
        });
    }
    /**
     * Constructs a DefaultGlobber
     */
    static create(patterns, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const result = new DefaultGlobber(options);
            if (IS_WINDOWS) {
                patterns = patterns.replace(/\r\n/g, '\n');
                patterns = patterns.replace(/\r/g, '\n');
            }
            const lines = patterns.split('\n').map(x => x.trim());
            for (const line of lines) {
                // Empty or comment
                if (!line || line.startsWith('#')) {
                    continue;
                }
                // Pattern
                else {
                    result.patterns.push(new internal_pattern_1.Pattern(line));
                }
            }
            result.searchPaths.push(...patternHelper.getSearchPaths(result.patterns));
            return result;
        });
    }
    static stat(item, options, traversalChain) {
        return __awaiter(this, void 0, void 0, function* () {
            // Note:
            // `stat` returns info about the target of a symlink (or symlink chain)
            // `lstat` returns info about a symlink itself
            let stats;
            if (options.followSymbolicLinks) {
                try {
                    // Use `stat` (following symlinks)
                    stats = yield fs.promises.stat(item.path);
                }
                catch (err) {
                    if (err.code === 'ENOENT') {
                        if (options.omitBrokenSymbolicLinks) {
                            core.debug(`Broken symlink '${item.path}'`);
                            return undefined;
                        }
                        throw new Error(`No information found for the path '${item.path}'. This may indicate a broken symbolic link.`);
                    }
                    throw err;
                }
            }
            else {
                // Use `lstat` (not following symlinks)
                stats = yield fs.promises.lstat(item.path);
            }
            // Note, isDirectory() returns false for the lstat of a symlink
            if (stats.isDirectory() && options.followSymbolicLinks) {
                // Get the realpath
                const realPath = yield fs.promises.realpath(item.path);
                // Fixup the traversal chain to match the item level
                while (traversalChain.length >= item.level) {
                    traversalChain.pop();
                }
                // Test for a cycle
                if (traversalChain.some((x) => x === realPath)) {
                    core.debug(`Symlink cycle detected for path '${item.path}' and realpath '${realPath}'`);
                    return undefined;
                }
                // Update the traversal chain
                traversalChain.push(realPath);
            }
            return stats;
        });
    }
}
exports.DefaultGlobber = DefaultGlobber;
//# sourceMappingURL=internal-globber.js.map

/***/ }),

/***/ 836:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MatchKind = void 0;
/**
 * Indicates whether a pattern matches a path
 */
var MatchKind;
(function (MatchKind) {
    /** Not matched */
    MatchKind[MatchKind["None"] = 0] = "None";
    /** Matched if the path is a directory */
    MatchKind[MatchKind["Directory"] = 1] = "Directory";
    /** Matched if the path is a regular file */
    MatchKind[MatchKind["File"] = 2] = "File";
    /** Matched */
    MatchKind[MatchKind["All"] = 3] = "All";
})(MatchKind = exports.MatchKind || (exports.MatchKind = {}));
//# sourceMappingURL=internal-match-kind.js.map

/***/ }),

/***/ 22:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.safeTrimTrailingSeparator = exports.normalizeSeparators = exports.hasRoot = exports.hasAbsoluteRoot = exports.ensureAbsoluteRoot = exports.dirname = void 0;
const path = __importStar(__nccwpck_require__(1017));
const assert_1 = __importDefault(__nccwpck_require__(9491));
const IS_WINDOWS = process.platform === 'win32';
/**
 * Similar to path.dirname except normalizes the path separators and slightly better handling for Windows UNC paths.
 *
 * For example, on Linux/macOS:
 * - `/               => /`
 * - `/hello          => /`
 *
 * For example, on Windows:
 * - `C:\             => C:\`
 * - `C:\hello        => C:\`
 * - `C:              => C:`
 * - `C:hello         => C:`
 * - `\               => \`
 * - `\hello          => \`
 * - `\\hello         => \\hello`
 * - `\\hello\world   => \\hello\world`
 */
function dirname(p) {
    // Normalize slashes and trim unnecessary trailing slash
    p = safeTrimTrailingSeparator(p);
    // Windows UNC root, e.g. \\hello or \\hello\world
    if (IS_WINDOWS && /^\\\\[^\\]+(\\[^\\]+)?$/.test(p)) {
        return p;
    }
    // Get dirname
    let result = path.dirname(p);
    // Trim trailing slash for Windows UNC root, e.g. \\hello\world\
    if (IS_WINDOWS && /^\\\\[^\\]+\\[^\\]+\\$/.test(result)) {
        result = safeTrimTrailingSeparator(result);
    }
    return result;
}
exports.dirname = dirname;
/**
 * Roots the path if not already rooted. On Windows, relative roots like `\`
 * or `C:` are expanded based on the current working directory.
 */
function ensureAbsoluteRoot(root, itemPath) {
    assert_1.default(root, `ensureAbsoluteRoot parameter 'root' must not be empty`);
    assert_1.default(itemPath, `ensureAbsoluteRoot parameter 'itemPath' must not be empty`);
    // Already rooted
    if (hasAbsoluteRoot(itemPath)) {
        return itemPath;
    }
    // Windows
    if (IS_WINDOWS) {
        // Check for itemPath like C: or C:foo
        if (itemPath.match(/^[A-Z]:[^\\/]|^[A-Z]:$/i)) {
            let cwd = process.cwd();
            assert_1.default(cwd.match(/^[A-Z]:\\/i), `Expected current directory to start with an absolute drive root. Actual '${cwd}'`);
            // Drive letter matches cwd? Expand to cwd
            if (itemPath[0].toUpperCase() === cwd[0].toUpperCase()) {
                // Drive only, e.g. C:
                if (itemPath.length === 2) {
                    // Preserve specified drive letter case (upper or lower)
                    return `${itemPath[0]}:\\${cwd.substr(3)}`;
                }
                // Drive + path, e.g. C:foo
                else {
                    if (!cwd.endsWith('\\')) {
                        cwd += '\\';
                    }
                    // Preserve specified drive letter case (upper or lower)
                    return `${itemPath[0]}:\\${cwd.substr(3)}${itemPath.substr(2)}`;
                }
            }
            // Different drive
            else {
                return `${itemPath[0]}:\\${itemPath.substr(2)}`;
            }
        }
        // Check for itemPath like \ or \foo
        else if (normalizeSeparators(itemPath).match(/^\\$|^\\[^\\]/)) {
            const cwd = process.cwd();
            assert_1.default(cwd.match(/^[A-Z]:\\/i), `Expected current directory to start with an absolute drive root. Actual '${cwd}'`);
            return `${cwd[0]}:\\${itemPath.substr(1)}`;
        }
    }
    assert_1.default(hasAbsoluteRoot(root), `ensureAbsoluteRoot parameter 'root' must have an absolute root`);
    // Otherwise ensure root ends with a separator
    if (root.endsWith('/') || (IS_WINDOWS && root.endsWith('\\'))) {
        // Intentionally empty
    }
    else {
        // Append separator
        root += path.sep;
    }
    return root + itemPath;
}
exports.ensureAbsoluteRoot = ensureAbsoluteRoot;
/**
 * On Linux/macOS, true if path starts with `/`. On Windows, true for paths like:
 * `\\hello\share` and `C:\hello` (and using alternate separator).
 */
function hasAbsoluteRoot(itemPath) {
    assert_1.default(itemPath, `hasAbsoluteRoot parameter 'itemPath' must not be empty`);
    // Normalize separators
    itemPath = normalizeSeparators(itemPath);
    // Windows
    if (IS_WINDOWS) {
        // E.g. \\hello\share or C:\hello
        return itemPath.startsWith('\\\\') || /^[A-Z]:\\/i.test(itemPath);
    }
    // E.g. /hello
    return itemPath.startsWith('/');
}
exports.hasAbsoluteRoot = hasAbsoluteRoot;
/**
 * On Linux/macOS, true if path starts with `/`. On Windows, true for paths like:
 * `\`, `\hello`, `\\hello\share`, `C:`, and `C:\hello` (and using alternate separator).
 */
function hasRoot(itemPath) {
    assert_1.default(itemPath, `isRooted parameter 'itemPath' must not be empty`);
    // Normalize separators
    itemPath = normalizeSeparators(itemPath);
    // Windows
    if (IS_WINDOWS) {
        // E.g. \ or \hello or \\hello
        // E.g. C: or C:\hello
        return itemPath.startsWith('\\') || /^[A-Z]:/i.test(itemPath);
    }
    // E.g. /hello
    return itemPath.startsWith('/');
}
exports.hasRoot = hasRoot;
/**
 * Removes redundant slashes and converts `/` to `\` on Windows
 */
function normalizeSeparators(p) {
    p = p || '';
    // Windows
    if (IS_WINDOWS) {
        // Convert slashes on Windows
        p = p.replace(/\//g, '\\');
        // Remove redundant slashes
        const isUnc = /^\\\\+[^\\]/.test(p); // e.g. \\hello
        return (isUnc ? '\\' : '') + p.replace(/\\\\+/g, '\\'); // preserve leading \\ for UNC
    }
    // Remove redundant slashes
    return p.replace(/\/\/+/g, '/');
}
exports.normalizeSeparators = normalizeSeparators;
/**
 * Normalizes the path separators and trims the trailing separator (when safe).
 * For example, `/foo/ => /foo` but `/ => /`
 */
function safeTrimTrailingSeparator(p) {
    // Short-circuit if empty
    if (!p) {
        return '';
    }
    // Normalize separators
    p = normalizeSeparators(p);
    // No trailing slash
    if (!p.endsWith(path.sep)) {
        return p;
    }
    // Check '/' on Linux/macOS and '\' on Windows
    if (p === path.sep) {
        return p;
    }
    // On Windows check if drive root. E.g. C:\
    if (IS_WINDOWS && /^[A-Z]:\\$/i.test(p)) {
        return p;
    }
    // Otherwise trim trailing slash
    return p.substr(0, p.length - 1);
}
exports.safeTrimTrailingSeparator = safeTrimTrailingSeparator;
//# sourceMappingURL=internal-path-helper.js.map

/***/ }),

/***/ 9413:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Path = void 0;
const path = __importStar(__nccwpck_require__(1017));
const pathHelper = __importStar(__nccwpck_require__(22));
const assert_1 = __importDefault(__nccwpck_require__(9491));
const IS_WINDOWS = process.platform === 'win32';
/**
 * Helper class for parsing paths into segments
 */
class Path {
    /**
     * Constructs a Path
     * @param itemPath Path or array of segments
     */
    constructor(itemPath) {
        this.segments = [];
        // String
        if (typeof itemPath === 'string') {
            assert_1.default(itemPath, `Parameter 'itemPath' must not be empty`);
            // Normalize slashes and trim unnecessary trailing slash
            itemPath = pathHelper.safeTrimTrailingSeparator(itemPath);
            // Not rooted
            if (!pathHelper.hasRoot(itemPath)) {
                this.segments = itemPath.split(path.sep);
            }
            // Rooted
            else {
                // Add all segments, while not at the root
                let remaining = itemPath;
                let dir = pathHelper.dirname(remaining);
                while (dir !== remaining) {
                    // Add the segment
                    const basename = path.basename(remaining);
                    this.segments.unshift(basename);
                    // Truncate the last segment
                    remaining = dir;
                    dir = pathHelper.dirname(remaining);
                }
                // Remainder is the root
                this.segments.unshift(remaining);
            }
        }
        // Array
        else {
            // Must not be empty
            assert_1.default(itemPath.length > 0, `Parameter 'itemPath' must not be an empty array`);
            // Each segment
            for (let i = 0; i < itemPath.length; i++) {
                let segment = itemPath[i];
                // Must not be empty
                assert_1.default(segment, `Parameter 'itemPath' must not contain any empty segments`);
                // Normalize slashes
                segment = pathHelper.normalizeSeparators(itemPath[i]);
                // Root segment
                if (i === 0 && pathHelper.hasRoot(segment)) {
                    segment = pathHelper.safeTrimTrailingSeparator(segment);
                    assert_1.default(segment === pathHelper.dirname(segment), `Parameter 'itemPath' root segment contains information for multiple segments`);
                    this.segments.push(segment);
                }
                // All other segments
                else {
                    // Must not contain slash
                    assert_1.default(!segment.includes(path.sep), `Parameter 'itemPath' contains unexpected path separators`);
                    this.segments.push(segment);
                }
            }
        }
    }
    /**
     * Converts the path to it's string representation
     */
    toString() {
        // First segment
        let result = this.segments[0];
        // All others
        let skipSlash = result.endsWith(path.sep) || (IS_WINDOWS && /^[A-Z]:$/i.test(result));
        for (let i = 1; i < this.segments.length; i++) {
            if (skipSlash) {
                skipSlash = false;
            }
            else {
                result += path.sep;
            }
            result += this.segments[i];
        }
        return result;
    }
}
exports.Path = Path;
//# sourceMappingURL=internal-path.js.map

/***/ }),

/***/ 5186:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.partialMatch = exports.match = exports.getSearchPaths = void 0;
const pathHelper = __importStar(__nccwpck_require__(22));
const internal_match_kind_1 = __nccwpck_require__(836);
const IS_WINDOWS = process.platform === 'win32';
/**
 * Given an array of patterns, returns an array of paths to search.
 * Duplicates and paths under other included paths are filtered out.
 */
function getSearchPaths(patterns) {
    // Ignore negate patterns
    patterns = patterns.filter(x => !x.negate);
    // Create a map of all search paths
    const searchPathMap = {};
    for (const pattern of patterns) {
        const key = IS_WINDOWS
            ? pattern.searchPath.toUpperCase()
            : pattern.searchPath;
        searchPathMap[key] = 'candidate';
    }
    const result = [];
    for (const pattern of patterns) {
        // Check if already included
        const key = IS_WINDOWS
            ? pattern.searchPath.toUpperCase()
            : pattern.searchPath;
        if (searchPathMap[key] === 'included') {
            continue;
        }
        // Check for an ancestor search path
        let foundAncestor = false;
        let tempKey = key;
        let parent = pathHelper.dirname(tempKey);
        while (parent !== tempKey) {
            if (searchPathMap[parent]) {
                foundAncestor = true;
                break;
            }
            tempKey = parent;
            parent = pathHelper.dirname(tempKey);
        }
        // Include the search pattern in the result
        if (!foundAncestor) {
            result.push(pattern.searchPath);
            searchPathMap[key] = 'included';
        }
    }
    return result;
}
exports.getSearchPaths = getSearchPaths;
/**
 * Matches the patterns against the path
 */
function match(patterns, itemPath) {
    let result = internal_match_kind_1.MatchKind.None;
    for (const pattern of patterns) {
        if (pattern.negate) {
            result &= ~pattern.match(itemPath);
        }
        else {
            result |= pattern.match(itemPath);
        }
    }
    return result;
}
exports.match = match;
/**
 * Checks whether to descend further into the directory
 */
function partialMatch(patterns, itemPath) {
    return patterns.some(x => !x.negate && x.partialMatch(itemPath));
}
exports.partialMatch = partialMatch;
//# sourceMappingURL=internal-pattern-helper.js.map

/***/ }),

/***/ 5343:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Pattern = void 0;
const os = __importStar(__nccwpck_require__(2037));
const path = __importStar(__nccwpck_require__(1017));
const pathHelper = __importStar(__nccwpck_require__(22));
const assert_1 = __importDefault(__nccwpck_require__(9491));
const minimatch_1 = __nccwpck_require__(3973);
const internal_match_kind_1 = __nccwpck_require__(836);
const internal_path_1 = __nccwpck_require__(9413);
const IS_WINDOWS = process.platform === 'win32';
class Pattern {
    constructor(patternOrNegate, isImplicitPattern = false, segments, homedir) {
        /**
         * Indicates whether matches should be excluded from the result set
         */
        this.negate = false;
        // Pattern overload
        let pattern;
        if (typeof patternOrNegate === 'string') {
            pattern = patternOrNegate.trim();
        }
        // Segments overload
        else {
            // Convert to pattern
            segments = segments || [];
            assert_1.default(segments.length, `Parameter 'segments' must not empty`);
            const root = Pattern.getLiteral(segments[0]);
            assert_1.default(root && pathHelper.hasAbsoluteRoot(root), `Parameter 'segments' first element must be a root path`);
            pattern = new internal_path_1.Path(segments).toString().trim();
            if (patternOrNegate) {
                pattern = `!${pattern}`;
            }
        }
        // Negate
        while (pattern.startsWith('!')) {
            this.negate = !this.negate;
            pattern = pattern.substr(1).trim();
        }
        // Normalize slashes and ensures absolute root
        pattern = Pattern.fixupPattern(pattern, homedir);
        // Segments
        this.segments = new internal_path_1.Path(pattern).segments;
        // Trailing slash indicates the pattern should only match directories, not regular files
        this.trailingSeparator = pathHelper
            .normalizeSeparators(pattern)
            .endsWith(path.sep);
        pattern = pathHelper.safeTrimTrailingSeparator(pattern);
        // Search path (literal path prior to the first glob segment)
        let foundGlob = false;
        const searchSegments = this.segments
            .map(x => Pattern.getLiteral(x))
            .filter(x => !foundGlob && !(foundGlob = x === ''));
        this.searchPath = new internal_path_1.Path(searchSegments).toString();
        // Root RegExp (required when determining partial match)
        this.rootRegExp = new RegExp(Pattern.regExpEscape(searchSegments[0]), IS_WINDOWS ? 'i' : '');
        this.isImplicitPattern = isImplicitPattern;
        // Create minimatch
        const minimatchOptions = {
            dot: true,
            nobrace: true,
            nocase: IS_WINDOWS,
            nocomment: true,
            noext: true,
            nonegate: true
        };
        pattern = IS_WINDOWS ? pattern.replace(/\\/g, '/') : pattern;
        this.minimatch = new minimatch_1.Minimatch(pattern, minimatchOptions);
    }
    /**
     * Matches the pattern against the specified path
     */
    match(itemPath) {
        // Last segment is globstar?
        if (this.segments[this.segments.length - 1] === '**') {
            // Normalize slashes
            itemPath = pathHelper.normalizeSeparators(itemPath);
            // Append a trailing slash. Otherwise Minimatch will not match the directory immediately
            // preceding the globstar. For example, given the pattern `/foo/**`, Minimatch returns
            // false for `/foo` but returns true for `/foo/`. Append a trailing slash to handle that quirk.
            if (!itemPath.endsWith(path.sep) && this.isImplicitPattern === false) {
                // Note, this is safe because the constructor ensures the pattern has an absolute root.
                // For example, formats like C: and C:foo on Windows are resolved to an absolute root.
                itemPath = `${itemPath}${path.sep}`;
            }
        }
        else {
            // Normalize slashes and trim unnecessary trailing slash
            itemPath = pathHelper.safeTrimTrailingSeparator(itemPath);
        }
        // Match
        if (this.minimatch.match(itemPath)) {
            return this.trailingSeparator ? internal_match_kind_1.MatchKind.Directory : internal_match_kind_1.MatchKind.All;
        }
        return internal_match_kind_1.MatchKind.None;
    }
    /**
     * Indicates whether the pattern may match descendants of the specified path
     */
    partialMatch(itemPath) {
        // Normalize slashes and trim unnecessary trailing slash
        itemPath = pathHelper.safeTrimTrailingSeparator(itemPath);
        // matchOne does not handle root path correctly
        if (pathHelper.dirname(itemPath) === itemPath) {
            return this.rootRegExp.test(itemPath);
        }
        return this.minimatch.matchOne(itemPath.split(IS_WINDOWS ? /\\+/ : /\/+/), this.minimatch.set[0], true);
    }
    /**
     * Escapes glob patterns within a path
     */
    static globEscape(s) {
        return (IS_WINDOWS ? s : s.replace(/\\/g, '\\\\')) // escape '\' on Linux/macOS
            .replace(/(\[)(?=[^/]+\])/g, '[[]') // escape '[' when ']' follows within the path segment
            .replace(/\?/g, '[?]') // escape '?'
            .replace(/\*/g, '[*]'); // escape '*'
    }
    /**
     * Normalizes slashes and ensures absolute root
     */
    static fixupPattern(pattern, homedir) {
        // Empty
        assert_1.default(pattern, 'pattern cannot be empty');
        // Must not contain `.` segment, unless first segment
        // Must not contain `..` segment
        const literalSegments = new internal_path_1.Path(pattern).segments.map(x => Pattern.getLiteral(x));
        assert_1.default(literalSegments.every((x, i) => (x !== '.' || i === 0) && x !== '..'), `Invalid pattern '${pattern}'. Relative pathing '.' and '..' is not allowed.`);
        // Must not contain globs in root, e.g. Windows UNC path \\foo\b*r
        assert_1.default(!pathHelper.hasRoot(pattern) || literalSegments[0], `Invalid pattern '${pattern}'. Root segment must not contain globs.`);
        // Normalize slashes
        pattern = pathHelper.normalizeSeparators(pattern);
        // Replace leading `.` segment
        if (pattern === '.' || pattern.startsWith(`.${path.sep}`)) {
            pattern = Pattern.globEscape(process.cwd()) + pattern.substr(1);
        }
        // Replace leading `~` segment
        else if (pattern === '~' || pattern.startsWith(`~${path.sep}`)) {
            homedir = homedir || os.homedir();
            assert_1.default(homedir, 'Unable to determine HOME directory');
            assert_1.default(pathHelper.hasAbsoluteRoot(homedir), `Expected HOME directory to be a rooted path. Actual '${homedir}'`);
            pattern = Pattern.globEscape(homedir) + pattern.substr(1);
        }
        // Replace relative drive root, e.g. pattern is C: or C:foo
        else if (IS_WINDOWS &&
            (pattern.match(/^[A-Z]:$/i) || pattern.match(/^[A-Z]:[^\\]/i))) {
            let root = pathHelper.ensureAbsoluteRoot('C:\\dummy-root', pattern.substr(0, 2));
            if (pattern.length > 2 && !root.endsWith('\\')) {
                root += '\\';
            }
            pattern = Pattern.globEscape(root) + pattern.substr(2);
        }
        // Replace relative root, e.g. pattern is \ or \foo
        else if (IS_WINDOWS && (pattern === '\\' || pattern.match(/^\\[^\\]/))) {
            let root = pathHelper.ensureAbsoluteRoot('C:\\dummy-root', '\\');
            if (!root.endsWith('\\')) {
                root += '\\';
            }
            pattern = Pattern.globEscape(root) + pattern.substr(1);
        }
        // Otherwise ensure absolute root
        else {
            pattern = pathHelper.ensureAbsoluteRoot(Pattern.globEscape(process.cwd()), pattern);
        }
        return pathHelper.normalizeSeparators(pattern);
    }
    /**
     * Attempts to unescape a pattern segment to create a literal path segment.
     * Otherwise returns empty string.
     */
    static getLiteral(segment) {
        let literal = '';
        for (let i = 0; i < segment.length; i++) {
            const c = segment[i];
            // Escape
            if (c === '\\' && !IS_WINDOWS && i + 1 < segment.length) {
                literal += segment[++i];
                continue;
            }
            // Wildcard
            else if (c === '*' || c === '?') {
                return '';
            }
            // Character set
            else if (c === '[' && i + 1 < segment.length) {
                let set = '';
                let closed = -1;
                for (let i2 = i + 1; i2 < segment.length; i2++) {
                    const c2 = segment[i2];
                    // Escape
                    if (c2 === '\\' && !IS_WINDOWS && i2 + 1 < segment.length) {
                        set += segment[++i2];
                        continue;
                    }
                    // Closed
                    else if (c2 === ']') {
                        closed = i2;
                        break;
                    }
                    // Otherwise
                    else {
                        set += c2;
                    }
                }
                // Closed?
                if (closed >= 0) {
                    // Cannot convert
                    if (set.length > 1) {
                        return '';
                    }
                    // Convert to literal
                    if (set) {
                        literal += set;
                        i = closed;
                        continue;
                    }
                }
                // Otherwise fall thru
            }
            // Append
            literal += c;
        }
        return literal;
    }
    /**
     * Escapes regexp special characters
     * https://javascript.info/regexp-escaping
     */
    static regExpEscape(s) {
        return s.replace(/[[\\^$.|?*+()]/g, '\\$&');
    }
}
exports.Pattern = Pattern;
//# sourceMappingURL=internal-pattern.js.map

/***/ }),

/***/ 8530:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SearchState = void 0;
class SearchState {
    constructor(path, level) {
        this.path = path;
        this.level = level;
    }
}
exports.SearchState = SearchState;
//# sourceMappingURL=internal-search-state.js.map

/***/ }),

/***/ 4138:
/***/ ((module, __unused_webpack_exports, __nccwpck_require__) => {

var v1 = __nccwpck_require__(1610);
var v4 = __nccwpck_require__(8373);

var uuid = v4;
uuid.v1 = v1;
uuid.v4 = v4;

module.exports = uuid;


/***/ }),

/***/ 5694:
/***/ ((module) => {

/**
 * Convert array of 16 byte values to UUID string format of the form:
 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
 */
var byteToHex = [];
for (var i = 0; i < 256; ++i) {
  byteToHex[i] = (i + 0x100).toString(16).substr(1);
}

function bytesToUuid(buf, offset) {
  var i = offset || 0;
  var bth = byteToHex;
  // join used to fix memory issue caused by concatenation: https://bugs.chromium.org/p/v8/issues/detail?id=3175#c4
  return ([
    bth[buf[i++]], bth[buf[i++]],
    bth[buf[i++]], bth[buf[i++]], '-',
    bth[buf[i++]], bth[buf[i++]], '-',
    bth[buf[i++]], bth[buf[i++]], '-',
    bth[buf[i++]], bth[buf[i++]], '-',
    bth[buf[i++]], bth[buf[i++]],
    bth[buf[i++]], bth[buf[i++]],
    bth[buf[i++]], bth[buf[i++]]
  ]).join('');
}

module.exports = bytesToUuid;


/***/ }),

/***/ 4069:
/***/ ((module, __unused_webpack_exports, __nccwpck_require__) => {

// Unique ID creation requires a high quality random # generator.  In node.js
// this is pretty straight-forward - we use the crypto API.

var crypto = __nccwpck_require__(6113);

module.exports = function nodeRNG() {
  return crypto.randomBytes(16);
};


/***/ }),

/***/ 1610:
/***/ ((module, __unused_webpack_exports, __nccwpck_require__) => {

var rng = __nccwpck_require__(4069);
var bytesToUuid = __nccwpck_require__(5694);

// **`v1()` - Generate time-based UUID**
//
// Inspired by https://github.com/LiosK/UUID.js
// and http://docs.python.org/library/uuid.html

var _nodeId;
var _clockseq;

// Previous uuid creation time
var _lastMSecs = 0;
var _lastNSecs = 0;

// See https://github.com/uuidjs/uuid for API details
function v1(options, buf, offset) {
  var i = buf && offset || 0;
  var b = buf || [];

  options = options || {};
  var node = options.node || _nodeId;
  var clockseq = options.clockseq !== undefined ? options.clockseq : _clockseq;

  // node and clockseq need to be initialized to random values if they're not
  // specified.  We do this lazily to minimize issues related to insufficient
  // system entropy.  See #189
  if (node == null || clockseq == null) {
    var seedBytes = rng();
    if (node == null) {
      // Per 4.5, create and 48-bit node id, (47 random bits + multicast bit = 1)
      node = _nodeId = [
        seedBytes[0] | 0x01,
        seedBytes[1], seedBytes[2], seedBytes[3], seedBytes[4], seedBytes[5]
      ];
    }
    if (clockseq == null) {
      // Per 4.2.2, randomize (14 bit) clockseq
      clockseq = _clockseq = (seedBytes[6] << 8 | seedBytes[7]) & 0x3fff;
    }
  }

  // UUID timestamps are 100 nano-second units since the Gregorian epoch,
  // (1582-10-15 00:00).  JSNumbers aren't precise enough for this, so
  // time is handled internally as 'msecs' (integer milliseconds) and 'nsecs'
  // (100-nanoseconds offset from msecs) since unix epoch, 1970-01-01 00:00.
  var msecs = options.msecs !== undefined ? options.msecs : new Date().getTime();

  // Per 4.2.1.2, use count of uuid's generated during the current clock
  // cycle to simulate higher resolution clock
  var nsecs = options.nsecs !== undefined ? options.nsecs : _lastNSecs + 1;

  // Time since last uuid creation (in msecs)
  var dt = (msecs - _lastMSecs) + (nsecs - _lastNSecs)/10000;

  // Per 4.2.1.2, Bump clockseq on clock regression
  if (dt < 0 && options.clockseq === undefined) {
    clockseq = clockseq + 1 & 0x3fff;
  }

  // Reset nsecs if clock regresses (new clockseq) or we've moved onto a new
  // time interval
  if ((dt < 0 || msecs > _lastMSecs) && options.nsecs === undefined) {
    nsecs = 0;
  }

  // Per 4.2.1.2 Throw error if too many uuids are requested
  if (nsecs >= 10000) {
    throw new Error('uuid.v1(): Can\'t create more than 10M uuids/sec');
  }

  _lastMSecs = msecs;
  _lastNSecs = nsecs;
  _clockseq = clockseq;

  // Per 4.1.4 - Convert from unix epoch to Gregorian epoch
  msecs += 12219292800000;

  // `time_low`
  var tl = ((msecs & 0xfffffff) * 10000 + nsecs) % 0x100000000;
  b[i++] = tl >>> 24 & 0xff;
  b[i++] = tl >>> 16 & 0xff;
  b[i++] = tl >>> 8 & 0xff;
  b[i++] = tl & 0xff;

  // `time_mid`
  var tmh = (msecs / 0x100000000 * 10000) & 0xfffffff;
  b[i++] = tmh >>> 8 & 0xff;
  b[i++] = tmh & 0xff;

  // `time_high_and_version`
  b[i++] = tmh >>> 24 & 0xf | 0x10; // include version
  b[i++] = tmh >>> 16 & 0xff;

  // `clock_seq_hi_and_reserved` (Per 4.2.2 - include variant)
  b[i++] = clockseq >>> 8 | 0x80;

  // `clock_seq_low`
  b[i++] = clockseq & 0xff;

  // `node`
  for (var n = 0; n < 6; ++n) {
    b[i + n] = node[n];
  }

  return buf ? buf : bytesToUuid(b);
}

module.exports = v1;


/***/ }),

/***/ 8373:
/***/ ((module, __unused_webpack_exports, __nccwpck_require__) => {

var rng = __nccwpck_require__(4069);
var bytesToUuid = __nccwpck_require__(5694);

function v4(options, buf, offset) {
  var i = buf && offset || 0;

  if (typeof(options) == 'string') {
    buf = options === 'binary' ? new Array(16) : null;
    options = null;
  }
  options = options || {};

  var rnds = options.random || (options.rng || rng)();

  // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`
  rnds[6] = (rnds[6] & 0x0f) | 0x40;
  rnds[8] = (rnds[8] & 0x3f) | 0x80;

  // Copy bytes to buffer, if provided
  if (buf) {
    for (var ii = 0; ii < 16; ++ii) {
      buf[i + ii] = rnds[ii];
    }
  }

  return buf || bytesToUuid(rnds);
}

module.exports = v4;


/***/ }),

/***/ 7351:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.issue = exports.issueCommand = void 0;
const os = __importStar(__nccwpck_require__(2037));
const utils_1 = __nccwpck_require__(5278);
/**
 * Commands
 *
 * Command Format:
 *   ::name key=value,key=value::message
 *
 * Examples:
 *   ::warning::This is the message
 *   ::set-env name=MY_VAR::some value
 */
function issueCommand(command, properties, message) {
    const cmd = new Command(command, properties, message);
    process.stdout.write(cmd.toString() + os.EOL);
}
exports.issueCommand = issueCommand;
function issue(name, message = '') {
    issueCommand(name, {}, message);
}
exports.issue = issue;
const CMD_STRING = '::';
class Command {
    constructor(command, properties, message) {
        if (!command) {
            command = 'missing.command';
        }
        this.command = command;
        this.properties = properties;
        this.message = message;
    }
    toString() {
        let cmdStr = CMD_STRING + this.command;
        if (this.properties && Object.keys(this.properties).length > 0) {
            cmdStr += ' ';
            let first = true;
            for (const key in this.properties) {
                if (this.properties.hasOwnProperty(key)) {
                    const val = this.properties[key];
                    if (val) {
                        if (first) {
                            first = false;
                        }
                        else {
                            cmdStr += ',';
                        }
                        cmdStr += `${key}=${escapeProperty(val)}`;
                    }
                }
            }
        }
        cmdStr += `${CMD_STRING}${escapeData(this.message)}`;
        return cmdStr;
    }
}
function escapeData(s) {
    return utils_1.toCommandValue(s)
        .replace(/%/g, '%25')
        .replace(/\r/g, '%0D')
        .replace(/\n/g, '%0A');
}
function escapeProperty(s) {
    return utils_1.toCommandValue(s)
        .replace(/%/g, '%25')
        .replace(/\r/g, '%0D')
        .replace(/\n/g, '%0A')
        .replace(/:/g, '%3A')
        .replace(/,/g, '%2C');
}
//# sourceMappingURL=command.js.map

/***/ }),

/***/ 2186:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getIDToken = exports.getState = exports.saveState = exports.group = exports.endGroup = exports.startGroup = exports.info = exports.notice = exports.warning = exports.error = exports.debug = exports.isDebug = exports.setFailed = exports.setCommandEcho = exports.setOutput = exports.getBooleanInput = exports.getMultilineInput = exports.getInput = exports.addPath = exports.setSecret = exports.exportVariable = exports.ExitCode = void 0;
const command_1 = __nccwpck_require__(7351);
const file_command_1 = __nccwpck_require__(717);
const utils_1 = __nccwpck_require__(5278);
const os = __importStar(__nccwpck_require__(2037));
const path = __importStar(__nccwpck_require__(1017));
const oidc_utils_1 = __nccwpck_require__(8041);
/**
 * The code to exit an action
 */
var ExitCode;
(function (ExitCode) {
    /**
     * A code indicating that the action was successful
     */
    ExitCode[ExitCode["Success"] = 0] = "Success";
    /**
     * A code indicating that the action was a failure
     */
    ExitCode[ExitCode["Failure"] = 1] = "Failure";
})(ExitCode = exports.ExitCode || (exports.ExitCode = {}));
//-----------------------------------------------------------------------
// Variables
//-----------------------------------------------------------------------
/**
 * Sets env variable for this action and future actions in the job
 * @param name the name of the variable to set
 * @param val the value of the variable. Non-string values will be converted to a string via JSON.stringify
 */
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function exportVariable(name, val) {
    const convertedVal = utils_1.toCommandValue(val);
    process.env[name] = convertedVal;
    const filePath = process.env['GITHUB_ENV'] || '';
    if (filePath) {
        return file_command_1.issueFileCommand('ENV', file_command_1.prepareKeyValueMessage(name, val));
    }
    command_1.issueCommand('set-env', { name }, convertedVal);
}
exports.exportVariable = exportVariable;
/**
 * Registers a secret which will get masked from logs
 * @param secret value of the secret
 */
function setSecret(secret) {
    command_1.issueCommand('add-mask', {}, secret);
}
exports.setSecret = setSecret;
/**
 * Prepends inputPath to the PATH (for this action and future actions)
 * @param inputPath
 */
function addPath(inputPath) {
    const filePath = process.env['GITHUB_PATH'] || '';
    if (filePath) {
        file_command_1.issueFileCommand('PATH', inputPath);
    }
    else {
        command_1.issueCommand('add-path', {}, inputPath);
    }
    process.env['PATH'] = `${inputPath}${path.delimiter}${process.env['PATH']}`;
}
exports.addPath = addPath;
/**
 * Gets the value of an input.
 * Unless trimWhitespace is set to false in InputOptions, the value is also trimmed.
 * Returns an empty string if the value is not defined.
 *
 * @param     name     name of the input to get
 * @param     options  optional. See InputOptions.
 * @returns   string
 */
function getInput(name, options) {
    const val = process.env[`INPUT_${name.replace(/ /g, '_').toUpperCase()}`] || '';
    if (options && options.required && !val) {
        throw new Error(`Input required and not supplied: ${name}`);
    }
    if (options && options.trimWhitespace === false) {
        return val;
    }
    return val.trim();
}
exports.getInput = getInput;
/**
 * Gets the values of an multiline input.  Each value is also trimmed.
 *
 * @param     name     name of the input to get
 * @param     options  optional. See InputOptions.
 * @returns   string[]
 *
 */
function getMultilineInput(name, options) {
    const inputs = getInput(name, options)
        .split('\n')
        .filter(x => x !== '');
    if (options && options.trimWhitespace === false) {
        return inputs;
    }
    return inputs.map(input => input.trim());
}
exports.getMultilineInput = getMultilineInput;
/**
 * Gets the input value of the boolean type in the YAML 1.2 "core schema" specification.
 * Support boolean input list: `true | True | TRUE | false | False | FALSE` .
 * The return value is also in boolean type.
 * ref: https://yaml.org/spec/1.2/spec.html#id2804923
 *
 * @param     name     name of the input to get
 * @param     options  optional. See InputOptions.
 * @returns   boolean
 */
function getBooleanInput(name, options) {
    const trueValue = ['true', 'True', 'TRUE'];
    const falseValue = ['false', 'False', 'FALSE'];
    const val = getInput(name, options);
    if (trueValue.includes(val))
        return true;
    if (falseValue.includes(val))
        return false;
    throw new TypeError(`Input does not meet YAML 1.2 "Core Schema" specification: ${name}\n` +
        `Support boolean input list: \`true | True | TRUE | false | False | FALSE\``);
}
exports.getBooleanInput = getBooleanInput;
/**
 * Sets the value of an output.
 *
 * @param     name     name of the output to set
 * @param     value    value to store. Non-string values will be converted to a string via JSON.stringify
 */
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function setOutput(name, value) {
    const filePath = process.env['GITHUB_OUTPUT'] || '';
    if (filePath) {
        return file_command_1.issueFileCommand('OUTPUT', file_command_1.prepareKeyValueMessage(name, value));
    }
    process.stdout.write(os.EOL);
    command_1.issueCommand('set-output', { name }, utils_1.toCommandValue(value));
}
exports.setOutput = setOutput;
/**
 * Enables or disables the echoing of commands into stdout for the rest of the step.
 * Echoing is disabled by default if ACTIONS_STEP_DEBUG is not set.
 *
 */
function setCommandEcho(enabled) {
    command_1.issue('echo', enabled ? 'on' : 'off');
}
exports.setCommandEcho = setCommandEcho;
//-----------------------------------------------------------------------
// Results
//-----------------------------------------------------------------------
/**
 * Sets the action status to failed.
 * When the action exits it will be with an exit code of 1
 * @param message add error issue message
 */
function setFailed(message) {
    process.exitCode = ExitCode.Failure;
    error(message);
}
exports.setFailed = setFailed;
//-----------------------------------------------------------------------
// Logging Commands
//-----------------------------------------------------------------------
/**
 * Gets whether Actions Step Debug is on or not
 */
function isDebug() {
    return process.env['RUNNER_DEBUG'] === '1';
}
exports.isDebug = isDebug;
/**
 * Writes debug message to user log
 * @param message debug message
 */
function debug(message) {
    command_1.issueCommand('debug', {}, message);
}
exports.debug = debug;
/**
 * Adds an error issue
 * @param message error issue message. Errors will be converted to string via toString()
 * @param properties optional properties to add to the annotation.
 */
function error(message, properties = {}) {
    command_1.issueCommand('error', utils_1.toCommandProperties(properties), message instanceof Error ? message.toString() : message);
}
exports.error = error;
/**
 * Adds a warning issue
 * @param message warning issue message. Errors will be converted to string via toString()
 * @param properties optional properties to add to the annotation.
 */
function warning(message, properties = {}) {
    command_1.issueCommand('warning', utils_1.toCommandProperties(properties), message instanceof Error ? message.toString() : message);
}
exports.warning = warning;
/**
 * Adds a notice issue
 * @param message notice issue message. Errors will be converted to string via toString()
 * @param properties optional properties to add to the annotation.
 */
function notice(message, properties = {}) {
    command_1.issueCommand('notice', utils_1.toCommandProperties(properties), message instanceof Error ? message.toString() : message);
}
exports.notice = notice;
/**
 * Writes info to log with console.log.
 * @param message info message
 */
function info(message) {
    process.stdout.write(message + os.EOL);
}
exports.info = info;
/**
 * Begin an output group.
 *
 * Output until the next `groupEnd` will be foldable in this group
 *
 * @param name The name of the output group
 */
function startGroup(name) {
    command_1.issue('group', name);
}
exports.startGroup = startGroup;
/**
 * End an output group.
 */
function endGroup() {
    command_1.issue('endgroup');
}
exports.endGroup = endGroup;
/**
 * Wrap an asynchronous function call in a group.
 *
 * Returns the same type as the function itself.
 *
 * @param name The name of the group
 * @param fn The function to wrap in the group
 */
function group(name, fn) {
    return __awaiter(this, void 0, void 0, function* () {
        startGroup(name);
        let result;
        try {
            result = yield fn();
        }
        finally {
            endGroup();
        }
        return result;
    });
}
exports.group = group;
//-----------------------------------------------------------------------
// Wrapper action state
//-----------------------------------------------------------------------
/**
 * Saves state for current action, the state can only be retrieved by this action's post job execution.
 *
 * @param     name     name of the state to store
 * @param     value    value to store. Non-string values will be converted to a string via JSON.stringify
 */
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function saveState(name, value) {
    const filePath = process.env['GITHUB_STATE'] || '';
    if (filePath) {
        return file_command_1.issueFileCommand('STATE', file_command_1.prepareKeyValueMessage(name, value));
    }
    command_1.issueCommand('save-state', { name }, utils_1.toCommandValue(value));
}
exports.saveState = saveState;
/**
 * Gets the value of an state set by this action's main execution.
 *
 * @param     name     name of the state to get
 * @returns   string
 */
function getState(name) {
    return process.env[`STATE_${name}`] || '';
}
exports.getState = getState;
function getIDToken(aud) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield oidc_utils_1.OidcClient.getIDToken(aud);
    });
}
exports.getIDToken = getIDToken;
/**
 * Summary exports
 */
var summary_1 = __nccwpck_require__(1327);
Object.defineProperty(exports, "summary", ({ enumerable: true, get: function () { return summary_1.summary; } }));
/**
 * @deprecated use core.summary
 */
var summary_2 = __nccwpck_require__(1327);
Object.defineProperty(exports, "markdownSummary", ({ enumerable: true, get: function () { return summary_2.markdownSummary; } }));
/**
 * Path exports
 */
var path_utils_1 = __nccwpck_require__(2981);
Object.defineProperty(exports, "toPosixPath", ({ enumerable: true, get: function () { return path_utils_1.toPosixPath; } }));
Object.defineProperty(exports, "toWin32Path", ({ enumerable: true, get: function () { return path_utils_1.toWin32Path; } }));
Object.defineProperty(exports, "toPlatformPath", ({ enumerable: true, get: function () { return path_utils_1.toPlatformPath; } }));
//# sourceMappingURL=core.js.map

/***/ }),

/***/ 717:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

// For internal use, subject to change.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.prepareKeyValueMessage = exports.issueFileCommand = void 0;
// We use any as a valid input type
/* eslint-disable @typescript-eslint/no-explicit-any */
const fs = __importStar(__nccwpck_require__(7147));
const os = __importStar(__nccwpck_require__(2037));
const uuid_1 = __nccwpck_require__(5840);
const utils_1 = __nccwpck_require__(5278);
function issueFileCommand(command, message) {
    const filePath = process.env[`GITHUB_${command}`];
    if (!filePath) {
        throw new Error(`Unable to find environment variable for file command ${command}`);
    }
    if (!fs.existsSync(filePath)) {
        throw new Error(`Missing file at path: ${filePath}`);
    }
    fs.appendFileSync(filePath, `${utils_1.toCommandValue(message)}${os.EOL}`, {
        encoding: 'utf8'
    });
}
exports.issueFileCommand = issueFileCommand;
function prepareKeyValueMessage(key, value) {
    const delimiter = `ghadelimiter_${uuid_1.v4()}`;
    const convertedValue = utils_1.toCommandValue(value);
    // These should realistically never happen, but just in case someone finds a
    // way to exploit uuid generation let's not allow keys or values that contain
    // the delimiter.
    if (key.includes(delimiter)) {
        throw new Error(`Unexpected input: name should not contain the delimiter "${delimiter}"`);
    }
    if (convertedValue.includes(delimiter)) {
        throw new Error(`Unexpected input: value should not contain the delimiter "${delimiter}"`);
    }
    return `${key}<<${delimiter}${os.EOL}${convertedValue}${os.EOL}${delimiter}`;
}
exports.prepareKeyValueMessage = prepareKeyValueMessage;
//# sourceMappingURL=file-command.js.map

/***/ }),

/***/ 8041:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OidcClient = void 0;
const http_client_1 = __nccwpck_require__(6255);
const auth_1 = __nccwpck_require__(5526);
const core_1 = __nccwpck_require__(2186);
class OidcClient {
    static createHttpClient(allowRetry = true, maxRetry = 10) {
        const requestOptions = {
            allowRetries: allowRetry,
            maxRetries: maxRetry
        };
        return new http_client_1.HttpClient('actions/oidc-client', [new auth_1.BearerCredentialHandler(OidcClient.getRequestToken())], requestOptions);
    }
    static getRequestToken() {
        const token = process.env['ACTIONS_ID_TOKEN_REQUEST_TOKEN'];
        if (!token) {
            throw new Error('Unable to get ACTIONS_ID_TOKEN_REQUEST_TOKEN env variable');
        }
        return token;
    }
    static getIDTokenUrl() {
        const runtimeUrl = process.env['ACTIONS_ID_TOKEN_REQUEST_URL'];
        if (!runtimeUrl) {
            throw new Error('Unable to get ACTIONS_ID_TOKEN_REQUEST_URL env variable');
        }
        return runtimeUrl;
    }
    static getCall(id_token_url) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const httpclient = OidcClient.createHttpClient();
            const res = yield httpclient
                .getJson(id_token_url)
                .catch(error => {
                throw new Error(`Failed to get ID Token. \n 
        Error Code : ${error.statusCode}\n 
        Error Message: ${error.message}`);
            });
            const id_token = (_a = res.result) === null || _a === void 0 ? void 0 : _a.value;
            if (!id_token) {
                throw new Error('Response json body do not have ID Token field');
            }
            return id_token;
        });
    }
    static getIDToken(audience) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                // New ID Token is requested from action service
                let id_token_url = OidcClient.getIDTokenUrl();
                if (audience) {
                    const encodedAudience = encodeURIComponent(audience);
                    id_token_url = `${id_token_url}&audience=${encodedAudience}`;
                }
                core_1.debug(`ID token url is ${id_token_url}`);
                const id_token = yield OidcClient.getCall(id_token_url);
                core_1.setSecret(id_token);
                return id_token;
            }
            catch (error) {
                throw new Error(`Error message: ${error.message}`);
            }
        });
    }
}
exports.OidcClient = OidcClient;
//# sourceMappingURL=oidc-utils.js.map

/***/ }),

/***/ 2981:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.toPlatformPath = exports.toWin32Path = exports.toPosixPath = void 0;
const path = __importStar(__nccwpck_require__(1017));
/**
 * toPosixPath converts the given path to the posix form. On Windows, \\ will be
 * replaced with /.
 *
 * @param pth. Path to transform.
 * @return string Posix path.
 */
function toPosixPath(pth) {
    return pth.replace(/[\\]/g, '/');
}
exports.toPosixPath = toPosixPath;
/**
 * toWin32Path converts the given path to the win32 form. On Linux, / will be
 * replaced with \\.
 *
 * @param pth. Path to transform.
 * @return string Win32 path.
 */
function toWin32Path(pth) {
    return pth.replace(/[/]/g, '\\');
}
exports.toWin32Path = toWin32Path;
/**
 * toPlatformPath converts the given path to a platform-specific path. It does
 * this by replacing instances of / and \ with the platform-specific path
 * separator.
 *
 * @param pth The path to platformize.
 * @return string The platform-specific path.
 */
function toPlatformPath(pth) {
    return pth.replace(/[/\\]/g, path.sep);
}
exports.toPlatformPath = toPlatformPath;
//# sourceMappingURL=path-utils.js.map

/***/ }),

/***/ 1327:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.summary = exports.markdownSummary = exports.SUMMARY_DOCS_URL = exports.SUMMARY_ENV_VAR = void 0;
const os_1 = __nccwpck_require__(2037);
const fs_1 = __nccwpck_require__(7147);
const { access, appendFile, writeFile } = fs_1.promises;
exports.SUMMARY_ENV_VAR = 'GITHUB_STEP_SUMMARY';
exports.SUMMARY_DOCS_URL = 'https://docs.github.com/actions/using-workflows/workflow-commands-for-github-actions#adding-a-job-summary';
class Summary {
    constructor() {
        this._buffer = '';
    }
    /**
     * Finds the summary file path from the environment, rejects if env var is not found or file does not exist
     * Also checks r/w permissions.
     *
     * @returns step summary file path
     */
    filePath() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this._filePath) {
                return this._filePath;
            }
            const pathFromEnv = process.env[exports.SUMMARY_ENV_VAR];
            if (!pathFromEnv) {
                throw new Error(`Unable to find environment variable for $${exports.SUMMARY_ENV_VAR}. Check if your runtime environment supports job summaries.`);
            }
            try {
                yield access(pathFromEnv, fs_1.constants.R_OK | fs_1.constants.W_OK);
            }
            catch (_a) {
                throw new Error(`Unable to access summary file: '${pathFromEnv}'. Check if the file has correct read/write permissions.`);
            }
            this._filePath = pathFromEnv;
            return this._filePath;
        });
    }
    /**
     * Wraps content in an HTML tag, adding any HTML attributes
     *
     * @param {string} tag HTML tag to wrap
     * @param {string | null} content content within the tag
     * @param {[attribute: string]: string} attrs key-value list of HTML attributes to add
     *
     * @returns {string} content wrapped in HTML element
     */
    wrap(tag, content, attrs = {}) {
        const htmlAttrs = Object.entries(attrs)
            .map(([key, value]) => ` ${key}="${value}"`)
            .join('');
        if (!content) {
            return `<${tag}${htmlAttrs}>`;
        }
        return `<${tag}${htmlAttrs}>${content}</${tag}>`;
    }
    /**
     * Writes text in the buffer to the summary buffer file and empties buffer. Will append by default.
     *
     * @param {SummaryWriteOptions} [options] (optional) options for write operation
     *
     * @returns {Promise<Summary>} summary instance
     */
    write(options) {
        return __awaiter(this, void 0, void 0, function* () {
            const overwrite = !!(options === null || options === void 0 ? void 0 : options.overwrite);
            const filePath = yield this.filePath();
            const writeFunc = overwrite ? writeFile : appendFile;
            yield writeFunc(filePath, this._buffer, { encoding: 'utf8' });
            return this.emptyBuffer();
        });
    }
    /**
     * Clears the summary buffer and wipes the summary file
     *
     * @returns {Summary} summary instance
     */
    clear() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.emptyBuffer().write({ overwrite: true });
        });
    }
    /**
     * Returns the current summary buffer as a string
     *
     * @returns {string} string of summary buffer
     */
    stringify() {
        return this._buffer;
    }
    /**
     * If the summary buffer is empty
     *
     * @returns {boolen} true if the buffer is empty
     */
    isEmptyBuffer() {
        return this._buffer.length === 0;
    }
    /**
     * Resets the summary buffer without writing to summary file
     *
     * @returns {Summary} summary instance
     */
    emptyBuffer() {
        this._buffer = '';
        return this;
    }
    /**
     * Adds raw text to the summary buffer
     *
     * @param {string} text content to add
     * @param {boolean} [addEOL=false] (optional) append an EOL to the raw text (default: false)
     *
     * @returns {Summary} summary instance
     */
    addRaw(text, addEOL = false) {
        this._buffer += text;
        return addEOL ? this.addEOL() : this;
    }
    /**
     * Adds the operating system-specific end-of-line marker to the buffer
     *
     * @returns {Summary} summary instance
     */
    addEOL() {
        return this.addRaw(os_1.EOL);
    }
    /**
     * Adds an HTML codeblock to the summary buffer
     *
     * @param {string} code content to render within fenced code block
     * @param {string} lang (optional) language to syntax highlight code
     *
     * @returns {Summary} summary instance
     */
    addCodeBlock(code, lang) {
        const attrs = Object.assign({}, (lang && { lang }));
        const element = this.wrap('pre', this.wrap('code', code), attrs);
        return this.addRaw(element).addEOL();
    }
    /**
     * Adds an HTML list to the summary buffer
     *
     * @param {string[]} items list of items to render
     * @param {boolean} [ordered=false] (optional) if the rendered list should be ordered or not (default: false)
     *
     * @returns {Summary} summary instance
     */
    addList(items, ordered = false) {
        const tag = ordered ? 'ol' : 'ul';
        const listItems = items.map(item => this.wrap('li', item)).join('');
        const element = this.wrap(tag, listItems);
        return this.addRaw(element).addEOL();
    }
    /**
     * Adds an HTML table to the summary buffer
     *
     * @param {SummaryTableCell[]} rows table rows
     *
     * @returns {Summary} summary instance
     */
    addTable(rows) {
        const tableBody = rows
            .map(row => {
            const cells = row
                .map(cell => {
                if (typeof cell === 'string') {
                    return this.wrap('td', cell);
                }
                const { header, data, colspan, rowspan } = cell;
                const tag = header ? 'th' : 'td';
                const attrs = Object.assign(Object.assign({}, (colspan && { colspan })), (rowspan && { rowspan }));
                return this.wrap(tag, data, attrs);
            })
                .join('');
            return this.wrap('tr', cells);
        })
            .join('');
        const element = this.wrap('table', tableBody);
        return this.addRaw(element).addEOL();
    }
    /**
     * Adds a collapsable HTML details element to the summary buffer
     *
     * @param {string} label text for the closed state
     * @param {string} content collapsable content
     *
     * @returns {Summary} summary instance
     */
    addDetails(label, content) {
        const element = this.wrap('details', this.wrap('summary', label) + content);
        return this.addRaw(element).addEOL();
    }
    /**
     * Adds an HTML image tag to the summary buffer
     *
     * @param {string} src path to the image you to embed
     * @param {string} alt text description of the image
     * @param {SummaryImageOptions} options (optional) addition image attributes
     *
     * @returns {Summary} summary instance
     */
    addImage(src, alt, options) {
        const { width, height } = options || {};
        const attrs = Object.assign(Object.assign({}, (width && { width })), (height && { height }));
        const element = this.wrap('img', null, Object.assign({ src, alt }, attrs));
        return this.addRaw(element).addEOL();
    }
    /**
     * Adds an HTML section heading element
     *
     * @param {string} text heading text
     * @param {number | string} [level=1] (optional) the heading level, default: 1
     *
     * @returns {Summary} summary instance
     */
    addHeading(text, level) {
        const tag = `h${level}`;
        const allowedTag = ['h1', 'h2', 'h3', 'h4', 'h5', 'h6'].includes(tag)
            ? tag
            : 'h1';
        const element = this.wrap(allowedTag, text);
        return this.addRaw(element).addEOL();
    }
    /**
     * Adds an HTML thematic break (<hr>) to the summary buffer
     *
     * @returns {Summary} summary instance
     */
    addSeparator() {
        const element = this.wrap('hr', null);
        return this.addRaw(element).addEOL();
    }
    /**
     * Adds an HTML line break (<br>) to the summary buffer
     *
     * @returns {Summary} summary instance
     */
    addBreak() {
        const element = this.wrap('br', null);
        return this.addRaw(element).addEOL();
    }
    /**
     * Adds an HTML blockquote to the summary buffer
     *
     * @param {string} text quote text
     * @param {string} cite (optional) citation url
     *
     * @returns {Summary} summary instance
     */
    addQuote(text, cite) {
        const attrs = Object.assign({}, (cite && { cite }));
        const element = this.wrap('blockquote', text, attrs);
        return this.addRaw(element).addEOL();
    }
    /**
     * Adds an HTML anchor tag to the summary buffer
     *
     * @param {string} text link text/content
     * @param {string} href hyperlink
     *
     * @returns {Summary} summary instance
     */
    addLink(text, href) {
        const element = this.wrap('a', text, { href });
        return this.addRaw(element).addEOL();
    }
}
const _summary = new Summary();
/**
 * @deprecated use `core.summary`
 */
exports.markdownSummary = _summary;
exports.summary = _summary;
//# sourceMappingURL=summary.js.map

/***/ }),

/***/ 5278:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// We use any as a valid input type
/* eslint-disable @typescript-eslint/no-explicit-any */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.toCommandProperties = exports.toCommandValue = void 0;
/**
 * Sanitizes an input into a string so it can be passed into issueCommand safely
 * @param input input to sanitize into a string
 */
function toCommandValue(input) {
    if (input === null || input === undefined) {
        return '';
    }
    else if (typeof input === 'string' || input instanceof String) {
        return input;
    }
    return JSON.stringify(input);
}
exports.toCommandValue = toCommandValue;
/**
 *
 * @param annotationProperties
 * @returns The command properties to send with the actual annotation command
 * See IssueCommandProperties: https://github.com/actions/runner/blob/main/src/Runner.Worker/ActionCommandManager.cs#L646
 */
function toCommandProperties(annotationProperties) {
    if (!Object.keys(annotationProperties).length) {
        return {};
    }
    return {
        title: annotationProperties.title,
        file: annotationProperties.file,
        line: annotationProperties.startLine,
        endLine: annotationProperties.endLine,
        col: annotationProperties.startColumn,
        endColumn: annotationProperties.endColumn
    };
}
exports.toCommandProperties = toCommandProperties;
//# sourceMappingURL=utils.js.map

/***/ }),

/***/ 1514:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getExecOutput = exports.exec = void 0;
const string_decoder_1 = __nccwpck_require__(1576);
const tr = __importStar(__nccwpck_require__(8159));
/**
 * Exec a command.
 * Output will be streamed to the live console.
 * Returns promise with return code
 *
 * @param     commandLine        command to execute (can include additional args). Must be correctly escaped.
 * @param     args               optional arguments for tool. Escaping is handled by the lib.
 * @param     options            optional exec options.  See ExecOptions
 * @returns   Promise<number>    exit code
 */
function exec(commandLine, args, options) {
    return __awaiter(this, void 0, void 0, function* () {
        const commandArgs = tr.argStringToArray(commandLine);
        if (commandArgs.length === 0) {
            throw new Error(`Parameter 'commandLine' cannot be null or empty.`);
        }
        // Path to tool to execute should be first arg
        const toolPath = commandArgs[0];
        args = commandArgs.slice(1).concat(args || []);
        const runner = new tr.ToolRunner(toolPath, args, options);
        return runner.exec();
    });
}
exports.exec = exec;
/**
 * Exec a command and get the output.
 * Output will be streamed to the live console.
 * Returns promise with the exit code and collected stdout and stderr
 *
 * @param     commandLine           command to execute (can include additional args). Must be correctly escaped.
 * @param     args                  optional arguments for tool. Escaping is handled by the lib.
 * @param     options               optional exec options.  See ExecOptions
 * @returns   Promise<ExecOutput>   exit code, stdout, and stderr
 */
function getExecOutput(commandLine, args, options) {
    var _a, _b;
    return __awaiter(this, void 0, void 0, function* () {
        let stdout = '';
        let stderr = '';
        //Using string decoder covers the case where a mult-byte character is split
        const stdoutDecoder = new string_decoder_1.StringDecoder('utf8');
        const stderrDecoder = new string_decoder_1.StringDecoder('utf8');
        const originalStdoutListener = (_a = options === null || options === void 0 ? void 0 : options.listeners) === null || _a === void 0 ? void 0 : _a.stdout;
        const originalStdErrListener = (_b = options === null || options === void 0 ? void 0 : options.listeners) === null || _b === void 0 ? void 0 : _b.stderr;
        const stdErrListener = (data) => {
            stderr += stderrDecoder.write(data);
            if (originalStdErrListener) {
                originalStdErrListener(data);
            }
        };
        const stdOutListener = (data) => {
            stdout += stdoutDecoder.write(data);
            if (originalStdoutListener) {
                originalStdoutListener(data);
            }
        };
        const listeners = Object.assign(Object.assign({}, options === null || options === void 0 ? void 0 : options.listeners), { stdout: stdOutListener, stderr: stdErrListener });
        const exitCode = yield exec(commandLine, args, Object.assign(Object.assign({}, options), { listeners }));
        //flush any remaining characters
        stdout += stdoutDecoder.end();
        stderr += stderrDecoder.end();
        return {
            exitCode,
            stdout,
            stderr
        };
    });
}
exports.getExecOutput = getExecOutput;
//# sourceMappingURL=exec.js.map

/***/ }),

/***/ 8159:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.argStringToArray = exports.ToolRunner = void 0;
const os = __importStar(__nccwpck_require__(2037));
const events = __importStar(__nccwpck_require__(2361));
const child = __importStar(__nccwpck_require__(2081));
const path = __importStar(__nccwpck_require__(1017));
const io = __importStar(__nccwpck_require__(7436));
const ioUtil = __importStar(__nccwpck_require__(1962));
const timers_1 = __nccwpck_require__(9512);
/* eslint-disable @typescript-eslint/unbound-method */
const IS_WINDOWS = process.platform === 'win32';
/*
 * Class for running command line tools. Handles quoting and arg parsing in a platform agnostic way.
 */
class ToolRunner extends events.EventEmitter {
    constructor(toolPath, args, options) {
        super();
        if (!toolPath) {
            throw new Error("Parameter 'toolPath' cannot be null or empty.");
        }
        this.toolPath = toolPath;
        this.args = args || [];
        this.options = options || {};
    }
    _debug(message) {
        if (this.options.listeners && this.options.listeners.debug) {
            this.options.listeners.debug(message);
        }
    }
    _getCommandString(options, noPrefix) {
        const toolPath = this._getSpawnFileName();
        const args = this._getSpawnArgs(options);
        let cmd = noPrefix ? '' : '[command]'; // omit prefix when piped to a second tool
        if (IS_WINDOWS) {
            // Windows + cmd file
            if (this._isCmdFile()) {
                cmd += toolPath;
                for (const a of args) {
                    cmd += ` ${a}`;
                }
            }
            // Windows + verbatim
            else if (options.windowsVerbatimArguments) {
                cmd += `"${toolPath}"`;
                for (const a of args) {
                    cmd += ` ${a}`;
                }
            }
            // Windows (regular)
            else {
                cmd += this._windowsQuoteCmdArg(toolPath);
                for (const a of args) {
                    cmd += ` ${this._windowsQuoteCmdArg(a)}`;
                }
            }
        }
        else {
            // OSX/Linux - this can likely be improved with some form of quoting.
            // creating processes on Unix is fundamentally different than Windows.
            // on Unix, execvp() takes an arg array.
            cmd += toolPath;
            for (const a of args) {
                cmd += ` ${a}`;
            }
        }
        return cmd;
    }
    _processLineBuffer(data, strBuffer, onLine) {
        try {
            let s = strBuffer + data.toString();
            let n = s.indexOf(os.EOL);
            while (n > -1) {
                const line = s.substring(0, n);
                onLine(line);
                // the rest of the string ...
                s = s.substring(n + os.EOL.length);
                n = s.indexOf(os.EOL);
            }
            return s;
        }
        catch (err) {
            // streaming lines to console is best effort.  Don't fail a build.
            this._debug(`error processing line. Failed with error ${err}`);
            return '';
        }
    }
    _getSpawnFileName() {
        if (IS_WINDOWS) {
            if (this._isCmdFile()) {
                return process.env['COMSPEC'] || 'cmd.exe';
            }
        }
        return this.toolPath;
    }
    _getSpawnArgs(options) {
        if (IS_WINDOWS) {
            if (this._isCmdFile()) {
                let argline = `/D /S /C "${this._windowsQuoteCmdArg(this.toolPath)}`;
                for (const a of this.args) {
                    argline += ' ';
                    argline += options.windowsVerbatimArguments
                        ? a
                        : this._windowsQuoteCmdArg(a);
                }
                argline += '"';
                return [argline];
            }
        }
        return this.args;
    }
    _endsWith(str, end) {
        return str.endsWith(end);
    }
    _isCmdFile() {
        const upperToolPath = this.toolPath.toUpperCase();
        return (this._endsWith(upperToolPath, '.CMD') ||
            this._endsWith(upperToolPath, '.BAT'));
    }
    _windowsQuoteCmdArg(arg) {
        // for .exe, apply the normal quoting rules that libuv applies
        if (!this._isCmdFile()) {
            return this._uvQuoteCmdArg(arg);
        }
        // otherwise apply quoting rules specific to the cmd.exe command line parser.
        // the libuv rules are generic and are not designed specifically for cmd.exe
        // command line parser.
        //
        // for a detailed description of the cmd.exe command line parser, refer to
        // http://stackoverflow.com/questions/4094699/how-does-the-windows-command-interpreter-cmd-exe-parse-scripts/7970912#7970912
        // need quotes for empty arg
        if (!arg) {
            return '""';
        }
        // determine whether the arg needs to be quoted
        const cmdSpecialChars = [
            ' ',
            '\t',
            '&',
            '(',
            ')',
            '[',
            ']',
            '{',
            '}',
            '^',
            '=',
            ';',
            '!',
            "'",
            '+',
            ',',
            '`',
            '~',
            '|',
            '<',
            '>',
            '"'
        ];
        let needsQuotes = false;
        for (const char of arg) {
            if (cmdSpecialChars.some(x => x === char)) {
                needsQuotes = true;
                break;
            }
        }
        // short-circuit if quotes not needed
        if (!needsQuotes) {
            return arg;
        }
        // the following quoting rules are very similar to the rules that by libuv applies.
        //
        // 1) wrap the string in quotes
        //
        // 2) double-up quotes - i.e. " => ""
        //
        //    this is different from the libuv quoting rules. libuv replaces " with \", which unfortunately
        //    doesn't work well with a cmd.exe command line.
        //
        //    note, replacing " with "" also works well if the arg is passed to a downstream .NET console app.
        //    for example, the command line:
        //          foo.exe "myarg:""my val"""
        //    is parsed by a .NET console app into an arg array:
        //          [ "myarg:\"my val\"" ]
        //    which is the same end result when applying libuv quoting rules. although the actual
        //    command line from libuv quoting rules would look like:
        //          foo.exe "myarg:\"my val\""
        //
        // 3) double-up slashes that precede a quote,
        //    e.g.  hello \world    => "hello \world"
        //          hello\"world    => "hello\\""world"
        //          hello\\"world   => "hello\\\\""world"
        //          hello world\    => "hello world\\"
        //
        //    technically this is not required for a cmd.exe command line, or the batch argument parser.
        //    the reasons for including this as a .cmd quoting rule are:
        //
        //    a) this is optimized for the scenario where the argument is passed from the .cmd file to an
        //       external program. many programs (e.g. .NET console apps) rely on the slash-doubling rule.
        //
        //    b) it's what we've been doing previously (by deferring to node default behavior) and we
        //       haven't heard any complaints about that aspect.
        //
        // note, a weakness of the quoting rules chosen here, is that % is not escaped. in fact, % cannot be
        // escaped when used on the command line directly - even though within a .cmd file % can be escaped
        // by using %%.
        //
        // the saving grace is, on the command line, %var% is left as-is if var is not defined. this contrasts
        // the line parsing rules within a .cmd file, where if var is not defined it is replaced with nothing.
        //
        // one option that was explored was replacing % with ^% - i.e. %var% => ^%var^%. this hack would
        // often work, since it is unlikely that var^ would exist, and the ^ character is removed when the
        // variable is used. the problem, however, is that ^ is not removed when %* is used to pass the args
        // to an external program.
        //
        // an unexplored potential solution for the % escaping problem, is to create a wrapper .cmd file.
        // % can be escaped within a .cmd file.
        let reverse = '"';
        let quoteHit = true;
        for (let i = arg.length; i > 0; i--) {
            // walk the string in reverse
            reverse += arg[i - 1];
            if (quoteHit && arg[i - 1] === '\\') {
                reverse += '\\'; // double the slash
            }
            else if (arg[i - 1] === '"') {
                quoteHit = true;
                reverse += '"'; // double the quote
            }
            else {
                quoteHit = false;
            }
        }
        reverse += '"';
        return reverse
            .split('')
            .reverse()
            .join('');
    }
    _uvQuoteCmdArg(arg) {
        // Tool runner wraps child_process.spawn() and needs to apply the same quoting as
        // Node in certain cases where the undocumented spawn option windowsVerbatimArguments
        // is used.
        //
        // Since this function is a port of quote_cmd_arg from Node 4.x (technically, lib UV,
        // see https://github.com/nodejs/node/blob/v4.x/deps/uv/src/win/process.c for details),
        // pasting copyright notice from Node within this function:
        //
        //      Copyright Joyent, Inc. and other Node contributors. All rights reserved.
        //
        //      Permission is hereby granted, free of charge, to any person obtaining a copy
        //      of this software and associated documentation files (the "Software"), to
        //      deal in the Software without restriction, including without limitation the
        //      rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
        //      sell copies of the Software, and to permit persons to whom the Software is
        //      furnished to do so, subject to the following conditions:
        //
        //      The above copyright notice and this permission notice shall be included in
        //      all copies or substantial portions of the Software.
        //
        //      THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        //      IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        //      FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        //      AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        //      LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
        //      FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
        //      IN THE SOFTWARE.
        if (!arg) {
            // Need double quotation for empty argument
            return '""';
        }
        if (!arg.includes(' ') && !arg.includes('\t') && !arg.includes('"')) {
            // No quotation needed
            return arg;
        }
        if (!arg.includes('"') && !arg.includes('\\')) {
            // No embedded double quotes or backslashes, so I can just wrap
            // quote marks around the whole thing.
            return `"${arg}"`;
        }
        // Expected input/output:
        //   input : hello"world
        //   output: "hello\"world"
        //   input : hello""world
        //   output: "hello\"\"world"
        //   input : hello\world
        //   output: hello\world
        //   input : hello\\world
        //   output: hello\\world
        //   input : hello\"world
        //   output: "hello\\\"world"
        //   input : hello\\"world
        //   output: "hello\\\\\"world"
        //   input : hello world\
        //   output: "hello world\\" - note the comment in libuv actually reads "hello world\"
        //                             but it appears the comment is wrong, it should be "hello world\\"
        let reverse = '"';
        let quoteHit = true;
        for (let i = arg.length; i > 0; i--) {
            // walk the string in reverse
            reverse += arg[i - 1];
            if (quoteHit && arg[i - 1] === '\\') {
                reverse += '\\';
            }
            else if (arg[i - 1] === '"') {
                quoteHit = true;
                reverse += '\\';
            }
            else {
                quoteHit = false;
            }
        }
        reverse += '"';
        return reverse
            .split('')
            .reverse()
            .join('');
    }
    _cloneExecOptions(options) {
        options = options || {};
        const result = {
            cwd: options.cwd || process.cwd(),
            env: options.env || process.env,
            silent: options.silent || false,
            windowsVerbatimArguments: options.windowsVerbatimArguments || false,
            failOnStdErr: options.failOnStdErr || false,
            ignoreReturnCode: options.ignoreReturnCode || false,
            delay: options.delay || 10000
        };
        result.outStream = options.outStream || process.stdout;
        result.errStream = options.errStream || process.stderr;
        return result;
    }
    _getSpawnOptions(options, toolPath) {
        options = options || {};
        const result = {};
        result.cwd = options.cwd;
        result.env = options.env;
        result['windowsVerbatimArguments'] =
            options.windowsVerbatimArguments || this._isCmdFile();
        if (options.windowsVerbatimArguments) {
            result.argv0 = `"${toolPath}"`;
        }
        return result;
    }
    /**
     * Exec a tool.
     * Output will be streamed to the live console.
     * Returns promise with return code
     *
     * @param     tool     path to tool to exec
     * @param     options  optional exec options.  See ExecOptions
     * @returns   number
     */
    exec() {
        return __awaiter(this, void 0, void 0, function* () {
            // root the tool path if it is unrooted and contains relative pathing
            if (!ioUtil.isRooted(this.toolPath) &&
                (this.toolPath.includes('/') ||
                    (IS_WINDOWS && this.toolPath.includes('\\')))) {
                // prefer options.cwd if it is specified, however options.cwd may also need to be rooted
                this.toolPath = path.resolve(process.cwd(), this.options.cwd || process.cwd(), this.toolPath);
            }
            // if the tool is only a file name, then resolve it from the PATH
            // otherwise verify it exists (add extension on Windows if necessary)
            this.toolPath = yield io.which(this.toolPath, true);
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                this._debug(`exec tool: ${this.toolPath}`);
                this._debug('arguments:');
                for (const arg of this.args) {
                    this._debug(`   ${arg}`);
                }
                const optionsNonNull = this._cloneExecOptions(this.options);
                if (!optionsNonNull.silent && optionsNonNull.outStream) {
                    optionsNonNull.outStream.write(this._getCommandString(optionsNonNull) + os.EOL);
                }
                const state = new ExecState(optionsNonNull, this.toolPath);
                state.on('debug', (message) => {
                    this._debug(message);
                });
                if (this.options.cwd && !(yield ioUtil.exists(this.options.cwd))) {
                    return reject(new Error(`The cwd: ${this.options.cwd} does not exist!`));
                }
                const fileName = this._getSpawnFileName();
                const cp = child.spawn(fileName, this._getSpawnArgs(optionsNonNull), this._getSpawnOptions(this.options, fileName));
                let stdbuffer = '';
                if (cp.stdout) {
                    cp.stdout.on('data', (data) => {
                        if (this.options.listeners && this.options.listeners.stdout) {
                            this.options.listeners.stdout(data);
                        }
                        if (!optionsNonNull.silent && optionsNonNull.outStream) {
                            optionsNonNull.outStream.write(data);
                        }
                        stdbuffer = this._processLineBuffer(data, stdbuffer, (line) => {
                            if (this.options.listeners && this.options.listeners.stdline) {
                                this.options.listeners.stdline(line);
                            }
                        });
                    });
                }
                let errbuffer = '';
                if (cp.stderr) {
                    cp.stderr.on('data', (data) => {
                        state.processStderr = true;
                        if (this.options.listeners && this.options.listeners.stderr) {
                            this.options.listeners.stderr(data);
                        }
                        if (!optionsNonNull.silent &&
                            optionsNonNull.errStream &&
                            optionsNonNull.outStream) {
                            const s = optionsNonNull.failOnStdErr
                                ? optionsNonNull.errStream
                                : optionsNonNull.outStream;
                            s.write(data);
                        }
                        errbuffer = this._processLineBuffer(data, errbuffer, (line) => {
                            if (this.options.listeners && this.options.listeners.errline) {
                                this.options.listeners.errline(line);
                            }
                        });
                    });
                }
                cp.on('error', (err) => {
                    state.processError = err.message;
                    state.processExited = true;
                    state.processClosed = true;
                    state.CheckComplete();
                });
                cp.on('exit', (code) => {
                    state.processExitCode = code;
                    state.processExited = true;
                    this._debug(`Exit code ${code} received from tool '${this.toolPath}'`);
                    state.CheckComplete();
                });
                cp.on('close', (code) => {
                    state.processExitCode = code;
                    state.processExited = true;
                    state.processClosed = true;
                    this._debug(`STDIO streams have closed for tool '${this.toolPath}'`);
                    state.CheckComplete();
                });
                state.on('done', (error, exitCode) => {
                    if (stdbuffer.length > 0) {
                        this.emit('stdline', stdbuffer);
                    }
                    if (errbuffer.length > 0) {
                        this.emit('errline', errbuffer);
                    }
                    cp.removeAllListeners();
                    if (error) {
                        reject(error);
                    }
                    else {
                        resolve(exitCode);
                    }
                });
                if (this.options.input) {
                    if (!cp.stdin) {
                        throw new Error('child process missing stdin');
                    }
                    cp.stdin.end(this.options.input);
                }
            }));
        });
    }
}
exports.ToolRunner = ToolRunner;
/**
 * Convert an arg string to an array of args. Handles escaping
 *
 * @param    argString   string of arguments
 * @returns  string[]    array of arguments
 */
function argStringToArray(argString) {
    const args = [];
    let inQuotes = false;
    let escaped = false;
    let arg = '';
    function append(c) {
        // we only escape double quotes.
        if (escaped && c !== '"') {
            arg += '\\';
        }
        arg += c;
        escaped = false;
    }
    for (let i = 0; i < argString.length; i++) {
        const c = argString.charAt(i);
        if (c === '"') {
            if (!escaped) {
                inQuotes = !inQuotes;
            }
            else {
                append(c);
            }
            continue;
        }
        if (c === '\\' && escaped) {
            append(c);
            continue;
        }
        if (c === '\\' && inQuotes) {
            escaped = true;
            continue;
        }
        if (c === ' ' && !inQuotes) {
            if (arg.length > 0) {
                args.push(arg);
                arg = '';
            }
            continue;
        }
        append(c);
    }
    if (arg.length > 0) {
        args.push(arg.trim());
    }
    return args;
}
exports.argStringToArray = argStringToArray;
class ExecState extends events.EventEmitter {
    constructor(options, toolPath) {
        super();
        this.processClosed = false; // tracks whether the process has exited and stdio is closed
        this.processError = '';
        this.processExitCode = 0;
        this.processExited = false; // tracks whether the process has exited
        this.processStderr = false; // tracks whether stderr was written to
        this.delay = 10000; // 10 seconds
        this.done = false;
        this.timeout = null;
        if (!toolPath) {
            throw new Error('toolPath must not be empty');
        }
        this.options = options;
        this.toolPath = toolPath;
        if (options.delay) {
            this.delay = options.delay;
        }
    }
    CheckComplete() {
        if (this.done) {
            return;
        }
        if (this.processClosed) {
            this._setResult();
        }
        else if (this.processExited) {
            this.timeout = timers_1.setTimeout(ExecState.HandleTimeout, this.delay, this);
        }
    }
    _debug(message) {
        this.emit('debug', message);
    }
    _setResult() {
        // determine whether there is an error
        let error;
        if (this.processExited) {
            if (this.processError) {
                error = new Error(`There was an error when attempting to execute the process '${this.toolPath}'. This may indicate the process failed to start. Error: ${this.processError}`);
            }
            else if (this.processExitCode !== 0 && !this.options.ignoreReturnCode) {
                error = new Error(`The process '${this.toolPath}' failed with exit code ${this.processExitCode}`);
            }
            else if (this.processStderr && this.options.failOnStdErr) {
                error = new Error(`The process '${this.toolPath}' failed because one or more lines were written to the STDERR stream`);
            }
        }
        // clear the timeout
        if (this.timeout) {
            clearTimeout(this.timeout);
            this.timeout = null;
        }
        this.done = true;
        this.emit('done', error, this.processExitCode);
    }
    static HandleTimeout(state) {
        if (state.done) {
            return;
        }
        if (!state.processClosed && state.processExited) {
            const message = `The STDIO streams did not close within ${state.delay /
                1000} seconds of the exit event from process '${state.toolPath}'. This may indicate a child process inherited the STDIO streams and has not yet exited.`;
            state._debug(message);
        }
        state._setResult();
    }
}
//# sourceMappingURL=toolrunner.js.map

/***/ }),

/***/ 8090:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.hashFiles = exports.create = void 0;
const internal_globber_1 = __nccwpck_require__(8298);
const internal_hash_files_1 = __nccwpck_require__(2448);
/**
 * Constructs a globber
 *
 * @param patterns  Patterns separated by newlines
 * @param options   Glob options
 */
function create(patterns, options) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield internal_globber_1.DefaultGlobber.create(patterns, options);
    });
}
exports.create = create;
/**
 * Computes the sha256 hash of a glob
 *
 * @param patterns  Patterns separated by newlines
 * @param currentWorkspace  Workspace used when matching files
 * @param options   Glob options
 * @param verbose   Enables verbose logging
 */
function hashFiles(patterns, currentWorkspace = '', options, verbose = false) {
    return __awaiter(this, void 0, void 0, function* () {
        let followSymbolicLinks = true;
        if (options && typeof options.followSymbolicLinks === 'boolean') {
            followSymbolicLinks = options.followSymbolicLinks;
        }
        const globber = yield create(patterns, { followSymbolicLinks });
        return internal_hash_files_1.hashFiles(globber, currentWorkspace, verbose);
    });
}
exports.hashFiles = hashFiles;
//# sourceMappingURL=glob.js.map

/***/ }),

/***/ 1026:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getOptions = void 0;
const core = __importStar(__nccwpck_require__(2186));
/**
 * Returns a copy with defaults filled in.
 */
function getOptions(copy) {
    const result = {
        followSymbolicLinks: true,
        implicitDescendants: true,
        matchDirectories: true,
        omitBrokenSymbolicLinks: true
    };
    if (copy) {
        if (typeof copy.followSymbolicLinks === 'boolean') {
            result.followSymbolicLinks = copy.followSymbolicLinks;
            core.debug(`followSymbolicLinks '${result.followSymbolicLinks}'`);
        }
        if (typeof copy.implicitDescendants === 'boolean') {
            result.implicitDescendants = copy.implicitDescendants;
            core.debug(`implicitDescendants '${result.implicitDescendants}'`);
        }
        if (typeof copy.matchDirectories === 'boolean') {
            result.matchDirectories = copy.matchDirectories;
            core.debug(`matchDirectories '${result.matchDirectories}'`);
        }
        if (typeof copy.omitBrokenSymbolicLinks === 'boolean') {
            result.omitBrokenSymbolicLinks = copy.omitBrokenSymbolicLinks;
            core.debug(`omitBrokenSymbolicLinks '${result.omitBrokenSymbolicLinks}'`);
        }
    }
    return result;
}
exports.getOptions = getOptions;
//# sourceMappingURL=internal-glob-options-helper.js.map

/***/ }),

/***/ 8298:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultGlobber = void 0;
const core = __importStar(__nccwpck_require__(2186));
const fs = __importStar(__nccwpck_require__(7147));
const globOptionsHelper = __importStar(__nccwpck_require__(1026));
const path = __importStar(__nccwpck_require__(1017));
const patternHelper = __importStar(__nccwpck_require__(9005));
const internal_match_kind_1 = __nccwpck_require__(1063);
const internal_pattern_1 = __nccwpck_require__(4536);
const internal_search_state_1 = __nccwpck_require__(9117);
const IS_WINDOWS = process.platform === 'win32';
class DefaultGlobber {
    constructor(options) {
        this.patterns = [];
        this.searchPaths = [];
        this.options = globOptionsHelper.getOptions(options);
    }
    getSearchPaths() {
        // Return a copy
        return this.searchPaths.slice();
    }
    glob() {
        var e_1, _a;
        return __awaiter(this, void 0, void 0, function* () {
            const result = [];
            try {
                for (var _b = __asyncValues(this.globGenerator()), _c; _c = yield _b.next(), !_c.done;) {
                    const itemPath = _c.value;
                    result.push(itemPath);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) yield _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return result;
        });
    }
    globGenerator() {
        return __asyncGenerator(this, arguments, function* globGenerator_1() {
            // Fill in defaults options
            const options = globOptionsHelper.getOptions(this.options);
            // Implicit descendants?
            const patterns = [];
            for (const pattern of this.patterns) {
                patterns.push(pattern);
                if (options.implicitDescendants &&
                    (pattern.trailingSeparator ||
                        pattern.segments[pattern.segments.length - 1] !== '**')) {
                    patterns.push(new internal_pattern_1.Pattern(pattern.negate, true, pattern.segments.concat('**')));
                }
            }
            // Push the search paths
            const stack = [];
            for (const searchPath of patternHelper.getSearchPaths(patterns)) {
                core.debug(`Search path '${searchPath}'`);
                // Exists?
                try {
                    // Intentionally using lstat. Detection for broken symlink
                    // will be performed later (if following symlinks).
                    yield __await(fs.promises.lstat(searchPath));
                }
                catch (err) {
                    if (err.code === 'ENOENT') {
                        continue;
                    }
                    throw err;
                }
                stack.unshift(new internal_search_state_1.SearchState(searchPath, 1));
            }
            // Search
            const traversalChain = []; // used to detect cycles
            while (stack.length) {
                // Pop
                const item = stack.pop();
                // Match?
                const match = patternHelper.match(patterns, item.path);
                const partialMatch = !!match || patternHelper.partialMatch(patterns, item.path);
                if (!match && !partialMatch) {
                    continue;
                }
                // Stat
                const stats = yield __await(DefaultGlobber.stat(item, options, traversalChain)
                // Broken symlink, or symlink cycle detected, or no longer exists
                );
                // Broken symlink, or symlink cycle detected, or no longer exists
                if (!stats) {
                    continue;
                }
                // Directory
                if (stats.isDirectory()) {
                    // Matched
                    if (match & internal_match_kind_1.MatchKind.Directory && options.matchDirectories) {
                        yield yield __await(item.path);
                    }
                    // Descend?
                    else if (!partialMatch) {
                        continue;
                    }
                    // Push the child items in reverse
                    const childLevel = item.level + 1;
                    const childItems = (yield __await(fs.promises.readdir(item.path))).map(x => new internal_search_state_1.SearchState(path.join(item.path, x), childLevel));
                    stack.push(...childItems.reverse());
                }
                // File
                else if (match & internal_match_kind_1.MatchKind.File) {
                    yield yield __await(item.path);
                }
            }
        });
    }
    /**
     * Constructs a DefaultGlobber
     */
    static create(patterns, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const result = new DefaultGlobber(options);
            if (IS_WINDOWS) {
                patterns = patterns.replace(/\r\n/g, '\n');
                patterns = patterns.replace(/\r/g, '\n');
            }
            const lines = patterns.split('\n').map(x => x.trim());
            for (const line of lines) {
                // Empty or comment
                if (!line || line.startsWith('#')) {
                    continue;
                }
                // Pattern
                else {
                    result.patterns.push(new internal_pattern_1.Pattern(line));
                }
            }
            result.searchPaths.push(...patternHelper.getSearchPaths(result.patterns));
            return result;
        });
    }
    static stat(item, options, traversalChain) {
        return __awaiter(this, void 0, void 0, function* () {
            // Note:
            // `stat` returns info about the target of a symlink (or symlink chain)
            // `lstat` returns info about a symlink itself
            let stats;
            if (options.followSymbolicLinks) {
                try {
                    // Use `stat` (following symlinks)
                    stats = yield fs.promises.stat(item.path);
                }
                catch (err) {
                    if (err.code === 'ENOENT') {
                        if (options.omitBrokenSymbolicLinks) {
                            core.debug(`Broken symlink '${item.path}'`);
                            return undefined;
                        }
                        throw new Error(`No information found for the path '${item.path}'. This may indicate a broken symbolic link.`);
                    }
                    throw err;
                }
            }
            else {
                // Use `lstat` (not following symlinks)
                stats = yield fs.promises.lstat(item.path);
            }
            // Note, isDirectory() returns false for the lstat of a symlink
            if (stats.isDirectory() && options.followSymbolicLinks) {
                // Get the realpath
                const realPath = yield fs.promises.realpath(item.path);
                // Fixup the traversal chain to match the item level
                while (traversalChain.length >= item.level) {
                    traversalChain.pop();
                }
                // Test for a cycle
                if (traversalChain.some((x) => x === realPath)) {
                    core.debug(`Symlink cycle detected for path '${item.path}' and realpath '${realPath}'`);
                    return undefined;
                }
                // Update the traversal chain
                traversalChain.push(realPath);
            }
            return stats;
        });
    }
}
exports.DefaultGlobber = DefaultGlobber;
//# sourceMappingURL=internal-globber.js.map

/***/ }),

/***/ 2448:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.hashFiles = void 0;
const crypto = __importStar(__nccwpck_require__(6113));
const core = __importStar(__nccwpck_require__(2186));
const fs = __importStar(__nccwpck_require__(7147));
const stream = __importStar(__nccwpck_require__(2781));
const util = __importStar(__nccwpck_require__(3837));
const path = __importStar(__nccwpck_require__(1017));
function hashFiles(globber, currentWorkspace, verbose = false) {
    var e_1, _a;
    var _b;
    return __awaiter(this, void 0, void 0, function* () {
        const writeDelegate = verbose ? core.info : core.debug;
        let hasMatch = false;
        const githubWorkspace = currentWorkspace
            ? currentWorkspace
            : (_b = process.env['GITHUB_WORKSPACE']) !== null && _b !== void 0 ? _b : process.cwd();
        const result = crypto.createHash('sha256');
        let count = 0;
        try {
            for (var _c = __asyncValues(globber.globGenerator()), _d; _d = yield _c.next(), !_d.done;) {
                const file = _d.value;
                writeDelegate(file);
                if (!file.startsWith(`${githubWorkspace}${path.sep}`)) {
                    writeDelegate(`Ignore '${file}' since it is not under GITHUB_WORKSPACE.`);
                    continue;
                }
                if (fs.statSync(file).isDirectory()) {
                    writeDelegate(`Skip directory '${file}'.`);
                    continue;
                }
                const hash = crypto.createHash('sha256');
                const pipeline = util.promisify(stream.pipeline);
                yield pipeline(fs.createReadStream(file), hash);
                result.write(hash.digest());
                count++;
                if (!hasMatch) {
                    hasMatch = true;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) yield _a.call(_c);
            }
            finally { if (e_1) throw e_1.error; }
        }
        result.end();
        if (hasMatch) {
            writeDelegate(`Found ${count} files to hash.`);
            return result.digest('hex');
        }
        else {
            writeDelegate(`No matches found for glob`);
            return '';
        }
    });
}
exports.hashFiles = hashFiles;
//# sourceMappingURL=internal-hash-files.js.map

/***/ }),

/***/ 1063:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MatchKind = void 0;
/**
 * Indicates whether a pattern matches a path
 */
var MatchKind;
(function (MatchKind) {
    /** Not matched */
    MatchKind[MatchKind["None"] = 0] = "None";
    /** Matched if the path is a directory */
    MatchKind[MatchKind["Directory"] = 1] = "Directory";
    /** Matched if the path is a regular file */
    MatchKind[MatchKind["File"] = 2] = "File";
    /** Matched */
    MatchKind[MatchKind["All"] = 3] = "All";
})(MatchKind = exports.MatchKind || (exports.MatchKind = {}));
//# sourceMappingURL=internal-match-kind.js.map

/***/ }),

/***/ 1849:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.safeTrimTrailingSeparator = exports.normalizeSeparators = exports.hasRoot = exports.hasAbsoluteRoot = exports.ensureAbsoluteRoot = exports.dirname = void 0;
const path = __importStar(__nccwpck_require__(1017));
const assert_1 = __importDefault(__nccwpck_require__(9491));
const IS_WINDOWS = process.platform === 'win32';
/**
 * Similar to path.dirname except normalizes the path separators and slightly better handling for Windows UNC paths.
 *
 * For example, on Linux/macOS:
 * - `/               => /`
 * - `/hello          => /`
 *
 * For example, on Windows:
 * - `C:\             => C:\`
 * - `C:\hello        => C:\`
 * - `C:              => C:`
 * - `C:hello         => C:`
 * - `\               => \`
 * - `\hello          => \`
 * - `\\hello         => \\hello`
 * - `\\hello\world   => \\hello\world`
 */
function dirname(p) {
    // Normalize slashes and trim unnecessary trailing slash
    p = safeTrimTrailingSeparator(p);
    // Windows UNC root, e.g. \\hello or \\hello\world
    if (IS_WINDOWS && /^\\\\[^\\]+(\\[^\\]+)?$/.test(p)) {
        return p;
    }
    // Get dirname
    let result = path.dirname(p);
    // Trim trailing slash for Windows UNC root, e.g. \\hello\world\
    if (IS_WINDOWS && /^\\\\[^\\]+\\[^\\]+\\$/.test(result)) {
        result = safeTrimTrailingSeparator(result);
    }
    return result;
}
exports.dirname = dirname;
/**
 * Roots the path if not already rooted. On Windows, relative roots like `\`
 * or `C:` are expanded based on the current working directory.
 */
function ensureAbsoluteRoot(root, itemPath) {
    assert_1.default(root, `ensureAbsoluteRoot parameter 'root' must not be empty`);
    assert_1.default(itemPath, `ensureAbsoluteRoot parameter 'itemPath' must not be empty`);
    // Already rooted
    if (hasAbsoluteRoot(itemPath)) {
        return itemPath;
    }
    // Windows
    if (IS_WINDOWS) {
        // Check for itemPath like C: or C:foo
        if (itemPath.match(/^[A-Z]:[^\\/]|^[A-Z]:$/i)) {
            let cwd = process.cwd();
            assert_1.default(cwd.match(/^[A-Z]:\\/i), `Expected current directory to start with an absolute drive root. Actual '${cwd}'`);
            // Drive letter matches cwd? Expand to cwd
            if (itemPath[0].toUpperCase() === cwd[0].toUpperCase()) {
                // Drive only, e.g. C:
                if (itemPath.length === 2) {
                    // Preserve specified drive letter case (upper or lower)
                    return `${itemPath[0]}:\\${cwd.substr(3)}`;
                }
                // Drive + path, e.g. C:foo
                else {
                    if (!cwd.endsWith('\\')) {
                        cwd += '\\';
                    }
                    // Preserve specified drive letter case (upper or lower)
                    return `${itemPath[0]}:\\${cwd.substr(3)}${itemPath.substr(2)}`;
                }
            }
            // Different drive
            else {
                return `${itemPath[0]}:\\${itemPath.substr(2)}`;
            }
        }
        // Check for itemPath like \ or \foo
        else if (normalizeSeparators(itemPath).match(/^\\$|^\\[^\\]/)) {
            const cwd = process.cwd();
            assert_1.default(cwd.match(/^[A-Z]:\\/i), `Expected current directory to start with an absolute drive root. Actual '${cwd}'`);
            return `${cwd[0]}:\\${itemPath.substr(1)}`;
        }
    }
    assert_1.default(hasAbsoluteRoot(root), `ensureAbsoluteRoot parameter 'root' must have an absolute root`);
    // Otherwise ensure root ends with a separator
    if (root.endsWith('/') || (IS_WINDOWS && root.endsWith('\\'))) {
        // Intentionally empty
    }
    else {
        // Append separator
        root += path.sep;
    }
    return root + itemPath;
}
exports.ensureAbsoluteRoot = ensureAbsoluteRoot;
/**
 * On Linux/macOS, true if path starts with `/`. On Windows, true for paths like:
 * `\\hello\share` and `C:\hello` (and using alternate separator).
 */
function hasAbsoluteRoot(itemPath) {
    assert_1.default(itemPath, `hasAbsoluteRoot parameter 'itemPath' must not be empty`);
    // Normalize separators
    itemPath = normalizeSeparators(itemPath);
    // Windows
    if (IS_WINDOWS) {
        // E.g. \\hello\share or C:\hello
        return itemPath.startsWith('\\\\') || /^[A-Z]:\\/i.test(itemPath);
    }
    // E.g. /hello
    return itemPath.startsWith('/');
}
exports.hasAbsoluteRoot = hasAbsoluteRoot;
/**
 * On Linux/macOS, true if path starts with `/`. On Windows, true for paths like:
 * `\`, `\hello`, `\\hello\share`, `C:`, and `C:\hello` (and using alternate separator).
 */
function hasRoot(itemPath) {
    assert_1.default(itemPath, `isRooted parameter 'itemPath' must not be empty`);
    // Normalize separators
    itemPath = normalizeSeparators(itemPath);
    // Windows
    if (IS_WINDOWS) {
        // E.g. \ or \hello or \\hello
        // E.g. C: or C:\hello
        return itemPath.startsWith('\\') || /^[A-Z]:/i.test(itemPath);
    }
    // E.g. /hello
    return itemPath.startsWith('/');
}
exports.hasRoot = hasRoot;
/**
 * Removes redundant slashes and converts `/` to `\` on Windows
 */
function normalizeSeparators(p) {
    p = p || '';
    // Windows
    if (IS_WINDOWS) {
        // Convert slashes on Windows
        p = p.replace(/\//g, '\\');
        // Remove redundant slashes
        const isUnc = /^\\\\+[^\\]/.test(p); // e.g. \\hello
        return (isUnc ? '\\' : '') + p.replace(/\\\\+/g, '\\'); // preserve leading \\ for UNC
    }
    // Remove redundant slashes
    return p.replace(/\/\/+/g, '/');
}
exports.normalizeSeparators = normalizeSeparators;
/**
 * Normalizes the path separators and trims the trailing separator (when safe).
 * For example, `/foo/ => /foo` but `/ => /`
 */
function safeTrimTrailingSeparator(p) {
    // Short-circuit if empty
    if (!p) {
        return '';
    }
    // Normalize separators
    p = normalizeSeparators(p);
    // No trailing slash
    if (!p.endsWith(path.sep)) {
        return p;
    }
    // Check '/' on Linux/macOS and '\' on Windows
    if (p === path.sep) {
        return p;
    }
    // On Windows check if drive root. E.g. C:\
    if (IS_WINDOWS && /^[A-Z]:\\$/i.test(p)) {
        return p;
    }
    // Otherwise trim trailing slash
    return p.substr(0, p.length - 1);
}
exports.safeTrimTrailingSeparator = safeTrimTrailingSeparator;
//# sourceMappingURL=internal-path-helper.js.map

/***/ }),

/***/ 6836:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Path = void 0;
const path = __importStar(__nccwpck_require__(1017));
const pathHelper = __importStar(__nccwpck_require__(1849));
const assert_1 = __importDefault(__nccwpck_require__(9491));
const IS_WINDOWS = process.platform === 'win32';
/**
 * Helper class for parsing paths into segments
 */
class Path {
    /**
     * Constructs a Path
     * @param itemPath Path or array of segments
     */
    constructor(itemPath) {
        this.segments = [];
        // String
        if (typeof itemPath === 'string') {
            assert_1.default(itemPath, `Parameter 'itemPath' must not be empty`);
            // Normalize slashes and trim unnecessary trailing slash
            itemPath = pathHelper.safeTrimTrailingSeparator(itemPath);
            // Not rooted
            if (!pathHelper.hasRoot(itemPath)) {
                this.segments = itemPath.split(path.sep);
            }
            // Rooted
            else {
                // Add all segments, while not at the root
                let remaining = itemPath;
                let dir = pathHelper.dirname(remaining);
                while (dir !== remaining) {
                    // Add the segment
                    const basename = path.basename(remaining);
                    this.segments.unshift(basename);
                    // Truncate the last segment
                    remaining = dir;
                    dir = pathHelper.dirname(remaining);
                }
                // Remainder is the root
                this.segments.unshift(remaining);
            }
        }
        // Array
        else {
            // Must not be empty
            assert_1.default(itemPath.length > 0, `Parameter 'itemPath' must not be an empty array`);
            // Each segment
            for (let i = 0; i < itemPath.length; i++) {
                let segment = itemPath[i];
                // Must not be empty
                assert_1.default(segment, `Parameter 'itemPath' must not contain any empty segments`);
                // Normalize slashes
                segment = pathHelper.normalizeSeparators(itemPath[i]);
                // Root segment
                if (i === 0 && pathHelper.hasRoot(segment)) {
                    segment = pathHelper.safeTrimTrailingSeparator(segment);
                    assert_1.default(segment === pathHelper.dirname(segment), `Parameter 'itemPath' root segment contains information for multiple segments`);
                    this.segments.push(segment);
                }
                // All other segments
                else {
                    // Must not contain slash
                    assert_1.default(!segment.includes(path.sep), `Parameter 'itemPath' contains unexpected path separators`);
                    this.segments.push(segment);
                }
            }
        }
    }
    /**
     * Converts the path to it's string representation
     */
    toString() {
        // First segment
        let result = this.segments[0];
        // All others
        let skipSlash = result.endsWith(path.sep) || (IS_WINDOWS && /^[A-Z]:$/i.test(result));
        for (let i = 1; i < this.segments.length; i++) {
            if (skipSlash) {
                skipSlash = false;
            }
            else {
                result += path.sep;
            }
            result += this.segments[i];
        }
        return result;
    }
}
exports.Path = Path;
//# sourceMappingURL=internal-path.js.map

/***/ }),

/***/ 9005:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.partialMatch = exports.match = exports.getSearchPaths = void 0;
const pathHelper = __importStar(__nccwpck_require__(1849));
const internal_match_kind_1 = __nccwpck_require__(1063);
const IS_WINDOWS = process.platform === 'win32';
/**
 * Given an array of patterns, returns an array of paths to search.
 * Duplicates and paths under other included paths are filtered out.
 */
function getSearchPaths(patterns) {
    // Ignore negate patterns
    patterns = patterns.filter(x => !x.negate);
    // Create a map of all search paths
    const searchPathMap = {};
    for (const pattern of patterns) {
        const key = IS_WINDOWS
            ? pattern.searchPath.toUpperCase()
            : pattern.searchPath;
        searchPathMap[key] = 'candidate';
    }
    const result = [];
    for (const pattern of patterns) {
        // Check if already included
        const key = IS_WINDOWS
            ? pattern.searchPath.toUpperCase()
            : pattern.searchPath;
        if (searchPathMap[key] === 'included') {
            continue;
        }
        // Check for an ancestor search path
        let foundAncestor = false;
        let tempKey = key;
        let parent = pathHelper.dirname(tempKey);
        while (parent !== tempKey) {
            if (searchPathMap[parent]) {
                foundAncestor = true;
                break;
            }
            tempKey = parent;
            parent = pathHelper.dirname(tempKey);
        }
        // Include the search pattern in the result
        if (!foundAncestor) {
            result.push(pattern.searchPath);
            searchPathMap[key] = 'included';
        }
    }
    return result;
}
exports.getSearchPaths = getSearchPaths;
/**
 * Matches the patterns against the path
 */
function match(patterns, itemPath) {
    let result = internal_match_kind_1.MatchKind.None;
    for (const pattern of patterns) {
        if (pattern.negate) {
            result &= ~pattern.match(itemPath);
        }
        else {
            result |= pattern.match(itemPath);
        }
    }
    return result;
}
exports.match = match;
/**
 * Checks whether to descend further into the directory
 */
function partialMatch(patterns, itemPath) {
    return patterns.some(x => !x.negate && x.partialMatch(itemPath));
}
exports.partialMatch = partialMatch;
//# sourceMappingURL=internal-pattern-helper.js.map

/***/ }),

/***/ 4536:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Pattern = void 0;
const os = __importStar(__nccwpck_require__(2037));
const path = __importStar(__nccwpck_require__(1017));
const pathHelper = __importStar(__nccwpck_require__(1849));
const assert_1 = __importDefault(__nccwpck_require__(9491));
const minimatch_1 = __nccwpck_require__(3973);
const internal_match_kind_1 = __nccwpck_require__(1063);
const internal_path_1 = __nccwpck_require__(6836);
const IS_WINDOWS = process.platform === 'win32';
class Pattern {
    constructor(patternOrNegate, isImplicitPattern = false, segments, homedir) {
        /**
         * Indicates whether matches should be excluded from the result set
         */
        this.negate = false;
        // Pattern overload
        let pattern;
        if (typeof patternOrNegate === 'string') {
            pattern = patternOrNegate.trim();
        }
        // Segments overload
        else {
            // Convert to pattern
            segments = segments || [];
            assert_1.default(segments.length, `Parameter 'segments' must not empty`);
            const root = Pattern.getLiteral(segments[0]);
            assert_1.default(root && pathHelper.hasAbsoluteRoot(root), `Parameter 'segments' first element must be a root path`);
            pattern = new internal_path_1.Path(segments).toString().trim();
            if (patternOrNegate) {
                pattern = `!${pattern}`;
            }
        }
        // Negate
        while (pattern.startsWith('!')) {
            this.negate = !this.negate;
            pattern = pattern.substr(1).trim();
        }
        // Normalize slashes and ensures absolute root
        pattern = Pattern.fixupPattern(pattern, homedir);
        // Segments
        this.segments = new internal_path_1.Path(pattern).segments;
        // Trailing slash indicates the pattern should only match directories, not regular files
        this.trailingSeparator = pathHelper
            .normalizeSeparators(pattern)
            .endsWith(path.sep);
        pattern = pathHelper.safeTrimTrailingSeparator(pattern);
        // Search path (literal path prior to the first glob segment)
        let foundGlob = false;
        const searchSegments = this.segments
            .map(x => Pattern.getLiteral(x))
            .filter(x => !foundGlob && !(foundGlob = x === ''));
        this.searchPath = new internal_path_1.Path(searchSegments).toString();
        // Root RegExp (required when determining partial match)
        this.rootRegExp = new RegExp(Pattern.regExpEscape(searchSegments[0]), IS_WINDOWS ? 'i' : '');
        this.isImplicitPattern = isImplicitPattern;
        // Create minimatch
        const minimatchOptions = {
            dot: true,
            nobrace: true,
            nocase: IS_WINDOWS,
            nocomment: true,
            noext: true,
            nonegate: true
        };
        pattern = IS_WINDOWS ? pattern.replace(/\\/g, '/') : pattern;
        this.minimatch = new minimatch_1.Minimatch(pattern, minimatchOptions);
    }
    /**
     * Matches the pattern against the specified path
     */
    match(itemPath) {
        // Last segment is globstar?
        if (this.segments[this.segments.length - 1] === '**') {
            // Normalize slashes
            itemPath = pathHelper.normalizeSeparators(itemPath);
            // Append a trailing slash. Otherwise Minimatch will not match the directory immediately
            // preceding the globstar. For example, given the pattern `/foo/**`, Minimatch returns
            // false for `/foo` but returns true for `/foo/`. Append a trailing slash to handle that quirk.
            if (!itemPath.endsWith(path.sep) && this.isImplicitPattern === false) {
                // Note, this is safe because the constructor ensures the pattern has an absolute root.
                // For example, formats like C: and C:foo on Windows are resolved to an absolute root.
                itemPath = `${itemPath}${path.sep}`;
            }
        }
        else {
            // Normalize slashes and trim unnecessary trailing slash
            itemPath = pathHelper.safeTrimTrailingSeparator(itemPath);
        }
        // Match
        if (this.minimatch.match(itemPath)) {
            return this.trailingSeparator ? internal_match_kind_1.MatchKind.Directory : internal_match_kind_1.MatchKind.All;
        }
        return internal_match_kind_1.MatchKind.None;
    }
    /**
     * Indicates whether the pattern may match descendants of the specified path
     */
    partialMatch(itemPath) {
        // Normalize slashes and trim unnecessary trailing slash
        itemPath = pathHelper.safeTrimTrailingSeparator(itemPath);
        // matchOne does not handle root path correctly
        if (pathHelper.dirname(itemPath) === itemPath) {
            return this.rootRegExp.test(itemPath);
        }
        return this.minimatch.matchOne(itemPath.split(IS_WINDOWS ? /\\+/ : /\/+/), this.minimatch.set[0], true);
    }
    /**
     * Escapes glob patterns within a path
     */
    static globEscape(s) {
        return (IS_WINDOWS ? s : s.replace(/\\/g, '\\\\')) // escape '\' on Linux/macOS
            .replace(/(\[)(?=[^/]+\])/g, '[[]') // escape '[' when ']' follows within the path segment
            .replace(/\?/g, '[?]') // escape '?'
            .replace(/\*/g, '[*]'); // escape '*'
    }
    /**
     * Normalizes slashes and ensures absolute root
     */
    static fixupPattern(pattern, homedir) {
        // Empty
        assert_1.default(pattern, 'pattern cannot be empty');
        // Must not contain `.` segment, unless first segment
        // Must not contain `..` segment
        const literalSegments = new internal_path_1.Path(pattern).segments.map(x => Pattern.getLiteral(x));
        assert_1.default(literalSegments.every((x, i) => (x !== '.' || i === 0) && x !== '..'), `Invalid pattern '${pattern}'. Relative pathing '.' and '..' is not allowed.`);
        // Must not contain globs in root, e.g. Windows UNC path \\foo\b*r
        assert_1.default(!pathHelper.hasRoot(pattern) || literalSegments[0], `Invalid pattern '${pattern}'. Root segment must not contain globs.`);
        // Normalize slashes
        pattern = pathHelper.normalizeSeparators(pattern);
        // Replace leading `.` segment
        if (pattern === '.' || pattern.startsWith(`.${path.sep}`)) {
            pattern = Pattern.globEscape(process.cwd()) + pattern.substr(1);
        }
        // Replace leading `~` segment
        else if (pattern === '~' || pattern.startsWith(`~${path.sep}`)) {
            homedir = homedir || os.homedir();
            assert_1.default(homedir, 'Unable to determine HOME directory');
            assert_1.default(pathHelper.hasAbsoluteRoot(homedir), `Expected HOME directory to be a rooted path. Actual '${homedir}'`);
            pattern = Pattern.globEscape(homedir) + pattern.substr(1);
        }
        // Replace relative drive root, e.g. pattern is C: or C:foo
        else if (IS_WINDOWS &&
            (pattern.match(/^[A-Z]:$/i) || pattern.match(/^[A-Z]:[^\\]/i))) {
            let root = pathHelper.ensureAbsoluteRoot('C:\\dummy-root', pattern.substr(0, 2));
            if (pattern.length > 2 && !root.endsWith('\\')) {
                root += '\\';
            }
            pattern = Pattern.globEscape(root) + pattern.substr(2);
        }
        // Replace relative root, e.g. pattern is \ or \foo
        else if (IS_WINDOWS && (pattern === '\\' || pattern.match(/^\\[^\\]/))) {
            let root = pathHelper.ensureAbsoluteRoot('C:\\dummy-root', '\\');
            if (!root.endsWith('\\')) {
                root += '\\';
            }
            pattern = Pattern.globEscape(root) + pattern.substr(1);
        }
        // Otherwise ensure absolute root
        else {
            pattern = pathHelper.ensureAbsoluteRoot(Pattern.globEscape(process.cwd()), pattern);
        }
        return pathHelper.normalizeSeparators(pattern);
    }
    /**
     * Attempts to unescape a pattern segment to create a literal path segment.
     * Otherwise returns empty string.
     */
    static getLiteral(segment) {
        let literal = '';
        for (let i = 0; i < segment.length; i++) {
            const c = segment[i];
            // Escape
            if (c === '\\' && !IS_WINDOWS && i + 1 < segment.length) {
                literal += segment[++i];
                continue;
            }
            // Wildcard
            else if (c === '*' || c === '?') {
                return '';
            }
            // Character set
            else if (c === '[' && i + 1 < segment.length) {
                let set = '';
                let closed = -1;
                for (let i2 = i + 1; i2 < segment.length; i2++) {
                    const c2 = segment[i2];
                    // Escape
                    if (c2 === '\\' && !IS_WINDOWS && i2 + 1 < segment.length) {
                        set += segment[++i2];
                        continue;
                    }
                    // Closed
                    else if (c2 === ']') {
                        closed = i2;
                        break;
                    }
                    // Otherwise
                    else {
                        set += c2;
                    }
                }
                // Closed?
                if (closed >= 0) {
                    // Cannot convert
                    if (set.length > 1) {
                        return '';
                    }
                    // Convert to literal
                    if (set) {
                        literal += set;
                        i = closed;
                        continue;
                    }
                }
                // Otherwise fall thru
            }
            // Append
            literal += c;
        }
        return literal;
    }
    /**
     * Escapes regexp special characters
     * https://javascript.info/regexp-escaping
     */
    static regExpEscape(s) {
        return s.replace(/[[\\^$.|?*+()]/g, '\\$&');
    }
}
exports.Pattern = Pattern;
//# sourceMappingURL=internal-pattern.js.map

/***/ }),

/***/ 9117:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SearchState = void 0;
class SearchState {
    constructor(path, level) {
        this.path = path;
        this.level = level;
    }
}
exports.SearchState = SearchState;
//# sourceMappingURL=internal-search-state.js.map

/***/ }),

/***/ 5526:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PersonalAccessTokenCredentialHandler = exports.BearerCredentialHandler = exports.BasicCredentialHandler = void 0;
class BasicCredentialHandler {
    constructor(username, password) {
        this.username = username;
        this.password = password;
    }
    prepareRequest(options) {
        if (!options.headers) {
            throw Error('The request has no headers');
        }
        options.headers['Authorization'] = `Basic ${Buffer.from(`${this.username}:${this.password}`).toString('base64')}`;
    }
    // This handler cannot handle 401
    canHandleAuthentication() {
        return false;
    }
    handleAuthentication() {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('not implemented');
        });
    }
}
exports.BasicCredentialHandler = BasicCredentialHandler;
class BearerCredentialHandler {
    constructor(token) {
        this.token = token;
    }
    // currently implements pre-authorization
    // TODO: support preAuth = false where it hooks on 401
    prepareRequest(options) {
        if (!options.headers) {
            throw Error('The request has no headers');
        }
        options.headers['Authorization'] = `Bearer ${this.token}`;
    }
    // This handler cannot handle 401
    canHandleAuthentication() {
        return false;
    }
    handleAuthentication() {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('not implemented');
        });
    }
}
exports.BearerCredentialHandler = BearerCredentialHandler;
class PersonalAccessTokenCredentialHandler {
    constructor(token) {
        this.token = token;
    }
    // currently implements pre-authorization
    // TODO: support preAuth = false where it hooks on 401
    prepareRequest(options) {
        if (!options.headers) {
            throw Error('The request has no headers');
        }
        options.headers['Authorization'] = `Basic ${Buffer.from(`PAT:${this.token}`).toString('base64')}`;
    }
    // This handler cannot handle 401
    canHandleAuthentication() {
        return false;
    }
    handleAuthentication() {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('not implemented');
        });
    }
}
exports.PersonalAccessTokenCredentialHandler = PersonalAccessTokenCredentialHandler;
//# sourceMappingURL=auth.js.map

/***/ }),

/***/ 6255:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

/* eslint-disable @typescript-eslint/no-explicit-any */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HttpClient = exports.isHttps = exports.HttpClientResponse = exports.HttpClientError = exports.getProxyUrl = exports.MediaTypes = exports.Headers = exports.HttpCodes = void 0;
const http = __importStar(__nccwpck_require__(3685));
const https = __importStar(__nccwpck_require__(5687));
const pm = __importStar(__nccwpck_require__(9835));
const tunnel = __importStar(__nccwpck_require__(4294));
const undici_1 = __nccwpck_require__(1773);
var HttpCodes;
(function (HttpCodes) {
    HttpCodes[HttpCodes["OK"] = 200] = "OK";
    HttpCodes[HttpCodes["MultipleChoices"] = 300] = "MultipleChoices";
    HttpCodes[HttpCodes["MovedPermanently"] = 301] = "MovedPermanently";
    HttpCodes[HttpCodes["ResourceMoved"] = 302] = "ResourceMoved";
    HttpCodes[HttpCodes["SeeOther"] = 303] = "SeeOther";
    HttpCodes[HttpCodes["NotModified"] = 304] = "NotModified";
    HttpCodes[HttpCodes["UseProxy"] = 305] = "UseProxy";
    HttpCodes[HttpCodes["SwitchProxy"] = 306] = "SwitchProxy";
    HttpCodes[HttpCodes["TemporaryRedirect"] = 307] = "TemporaryRedirect";
    HttpCodes[HttpCodes["PermanentRedirect"] = 308] = "PermanentRedirect";
    HttpCodes[HttpCodes["BadRequest"] = 400] = "BadRequest";
    HttpCodes[HttpCodes["Unauthorized"] = 401] = "Unauthorized";
    HttpCodes[HttpCodes["PaymentRequired"] = 402] = "PaymentRequired";
    HttpCodes[HttpCodes["Forbidden"] = 403] = "Forbidden";
    HttpCodes[HttpCodes["NotFound"] = 404] = "NotFound";
    HttpCodes[HttpCodes["MethodNotAllowed"] = 405] = "MethodNotAllowed";
    HttpCodes[HttpCodes["NotAcceptable"] = 406] = "NotAcceptable";
    HttpCodes[HttpCodes["ProxyAuthenticationRequired"] = 407] = "ProxyAuthenticationRequired";
    HttpCodes[HttpCodes["RequestTimeout"] = 408] = "RequestTimeout";
    HttpCodes[HttpCodes["Conflict"] = 409] = "Conflict";
    HttpCodes[HttpCodes["Gone"] = 410] = "Gone";
    HttpCodes[HttpCodes["TooManyRequests"] = 429] = "TooManyRequests";
    HttpCodes[HttpCodes["InternalServerError"] = 500] = "InternalServerError";
    HttpCodes[HttpCodes["NotImplemented"] = 501] = "NotImplemented";
    HttpCodes[HttpCodes["BadGateway"] = 502] = "BadGateway";
    HttpCodes[HttpCodes["ServiceUnavailable"] = 503] = "ServiceUnavailable";
    HttpCodes[HttpCodes["GatewayTimeout"] = 504] = "GatewayTimeout";
})(HttpCodes || (exports.HttpCodes = HttpCodes = {}));
var Headers;
(function (Headers) {
    Headers["Accept"] = "accept";
    Headers["ContentType"] = "content-type";
})(Headers || (exports.Headers = Headers = {}));
var MediaTypes;
(function (MediaTypes) {
    MediaTypes["ApplicationJson"] = "application/json";
})(MediaTypes || (exports.MediaTypes = MediaTypes = {}));
/**
 * Returns the proxy URL, depending upon the supplied url and proxy environment variables.
 * @param serverUrl  The server URL where the request will be sent. For example, https://api.github.com
 */
function getProxyUrl(serverUrl) {
    const proxyUrl = pm.getProxyUrl(new URL(serverUrl));
    return proxyUrl ? proxyUrl.href : '';
}
exports.getProxyUrl = getProxyUrl;
const HttpRedirectCodes = [
    HttpCodes.MovedPermanently,
    HttpCodes.ResourceMoved,
    HttpCodes.SeeOther,
    HttpCodes.TemporaryRedirect,
    HttpCodes.PermanentRedirect
];
const HttpResponseRetryCodes = [
    HttpCodes.BadGateway,
    HttpCodes.ServiceUnavailable,
    HttpCodes.GatewayTimeout
];
const RetryableHttpVerbs = ['OPTIONS', 'GET', 'DELETE', 'HEAD'];
const ExponentialBackoffCeiling = 10;
const ExponentialBackoffTimeSlice = 5;
class HttpClientError extends Error {
    constructor(message, statusCode) {
        super(message);
        this.name = 'HttpClientError';
        this.statusCode = statusCode;
        Object.setPrototypeOf(this, HttpClientError.prototype);
    }
}
exports.HttpClientError = HttpClientError;
class HttpClientResponse {
    constructor(message) {
        this.message = message;
    }
    readBody() {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve) => __awaiter(this, void 0, void 0, function* () {
                let output = Buffer.alloc(0);
                this.message.on('data', (chunk) => {
                    output = Buffer.concat([output, chunk]);
                });
                this.message.on('end', () => {
                    resolve(output.toString());
                });
            }));
        });
    }
    readBodyBuffer() {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve) => __awaiter(this, void 0, void 0, function* () {
                const chunks = [];
                this.message.on('data', (chunk) => {
                    chunks.push(chunk);
                });
                this.message.on('end', () => {
                    resolve(Buffer.concat(chunks));
                });
            }));
        });
    }
}
exports.HttpClientResponse = HttpClientResponse;
function isHttps(requestUrl) {
    const parsedUrl = new URL(requestUrl);
    return parsedUrl.protocol === 'https:';
}
exports.isHttps = isHttps;
class HttpClient {
    constructor(userAgent, handlers, requestOptions) {
        this._ignoreSslError = false;
        this._allowRedirects = true;
        this._allowRedirectDowngrade = false;
        this._maxRedirects = 50;
        this._allowRetries = false;
        this._maxRetries = 1;
        this._keepAlive = false;
        this._disposed = false;
        this.userAgent = userAgent;
        this.handlers = handlers || [];
        this.requestOptions = requestOptions;
        if (requestOptions) {
            if (requestOptions.ignoreSslError != null) {
                this._ignoreSslError = requestOptions.ignoreSslError;
            }
            this._socketTimeout = requestOptions.socketTimeout;
            if (requestOptions.allowRedirects != null) {
                this._allowRedirects = requestOptions.allowRedirects;
            }
            if (requestOptions.allowRedirectDowngrade != null) {
                this._allowRedirectDowngrade = requestOptions.allowRedirectDowngrade;
            }
            if (requestOptions.maxRedirects != null) {
                this._maxRedirects = Math.max(requestOptions.maxRedirects, 0);
            }
            if (requestOptions.keepAlive != null) {
                this._keepAlive = requestOptions.keepAlive;
            }
            if (requestOptions.allowRetries != null) {
                this._allowRetries = requestOptions.allowRetries;
            }
            if (requestOptions.maxRetries != null) {
                this._maxRetries = requestOptions.maxRetries;
            }
        }
    }
    options(requestUrl, additionalHeaders) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.request('OPTIONS', requestUrl, null, additionalHeaders || {});
        });
    }
    get(requestUrl, additionalHeaders) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.request('GET', requestUrl, null, additionalHeaders || {});
        });
    }
    del(requestUrl, additionalHeaders) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.request('DELETE', requestUrl, null, additionalHeaders || {});
        });
    }
    post(requestUrl, data, additionalHeaders) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.request('POST', requestUrl, data, additionalHeaders || {});
        });
    }
    patch(requestUrl, data, additionalHeaders) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.request('PATCH', requestUrl, data, additionalHeaders || {});
        });
    }
    put(requestUrl, data, additionalHeaders) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.request('PUT', requestUrl, data, additionalHeaders || {});
        });
    }
    head(requestUrl, additionalHeaders) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.request('HEAD', requestUrl, null, additionalHeaders || {});
        });
    }
    sendStream(verb, requestUrl, stream, additionalHeaders) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.request(verb, requestUrl, stream, additionalHeaders);
        });
    }
    /**
     * Gets a typed object from an endpoint
     * Be aware that not found returns a null.  Other errors (4xx, 5xx) reject the promise
     */
    getJson(requestUrl, additionalHeaders = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            additionalHeaders[Headers.Accept] = this._getExistingOrDefaultHeader(additionalHeaders, Headers.Accept, MediaTypes.ApplicationJson);
            const res = yield this.get(requestUrl, additionalHeaders);
            return this._processResponse(res, this.requestOptions);
        });
    }
    postJson(requestUrl, obj, additionalHeaders = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            const data = JSON.stringify(obj, null, 2);
            additionalHeaders[Headers.Accept] = this._getExistingOrDefaultHeader(additionalHeaders, Headers.Accept, MediaTypes.ApplicationJson);
            additionalHeaders[Headers.ContentType] = this._getExistingOrDefaultHeader(additionalHeaders, Headers.ContentType, MediaTypes.ApplicationJson);
            const res = yield this.post(requestUrl, data, additionalHeaders);
            return this._processResponse(res, this.requestOptions);
        });
    }
    putJson(requestUrl, obj, additionalHeaders = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            const data = JSON.stringify(obj, null, 2);
            additionalHeaders[Headers.Accept] = this._getExistingOrDefaultHeader(additionalHeaders, Headers.Accept, MediaTypes.ApplicationJson);
            additionalHeaders[Headers.ContentType] = this._getExistingOrDefaultHeader(additionalHeaders, Headers.ContentType, MediaTypes.ApplicationJson);
            const res = yield this.put(requestUrl, data, additionalHeaders);
            return this._processResponse(res, this.requestOptions);
        });
    }
    patchJson(requestUrl, obj, additionalHeaders = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            const data = JSON.stringify(obj, null, 2);
            additionalHeaders[Headers.Accept] = this._getExistingOrDefaultHeader(additionalHeaders, Headers.Accept, MediaTypes.ApplicationJson);
            additionalHeaders[Headers.ContentType] = this._getExistingOrDefaultHeader(additionalHeaders, Headers.ContentType, MediaTypes.ApplicationJson);
            const res = yield this.patch(requestUrl, data, additionalHeaders);
            return this._processResponse(res, this.requestOptions);
        });
    }
    /**
     * Makes a raw http request.
     * All other methods such as get, post, patch, and request ultimately call this.
     * Prefer get, del, post and patch
     */
    request(verb, requestUrl, data, headers) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this._disposed) {
                throw new Error('Client has already been disposed.');
            }
            const parsedUrl = new URL(requestUrl);
            let info = this._prepareRequest(verb, parsedUrl, headers);
            // Only perform retries on reads since writes may not be idempotent.
            const maxTries = this._allowRetries && RetryableHttpVerbs.includes(verb)
                ? this._maxRetries + 1
                : 1;
            let numTries = 0;
            let response;
            do {
                response = yield this.requestRaw(info, data);
                // Check if it's an authentication challenge
                if (response &&
                    response.message &&
                    response.message.statusCode === HttpCodes.Unauthorized) {
                    let authenticationHandler;
                    for (const handler of this.handlers) {
                        if (handler.canHandleAuthentication(response)) {
                            authenticationHandler = handler;
                            break;
                        }
                    }
                    if (authenticationHandler) {
                        return authenticationHandler.handleAuthentication(this, info, data);
                    }
                    else {
                        // We have received an unauthorized response but have no handlers to handle it.
                        // Let the response return to the caller.
                        return response;
                    }
                }
                let redirectsRemaining = this._maxRedirects;
                while (response.message.statusCode &&
                    HttpRedirectCodes.includes(response.message.statusCode) &&
                    this._allowRedirects &&
                    redirectsRemaining > 0) {
                    const redirectUrl = response.message.headers['location'];
                    if (!redirectUrl) {
                        // if there's no location to redirect to, we won't
                        break;
                    }
                    const parsedRedirectUrl = new URL(redirectUrl);
                    if (parsedUrl.protocol === 'https:' &&
                        parsedUrl.protocol !== parsedRedirectUrl.protocol &&
                        !this._allowRedirectDowngrade) {
                        throw new Error('Redirect from HTTPS to HTTP protocol. This downgrade is not allowed for security reasons. If you want to allow this behavior, set the allowRedirectDowngrade option to true.');
                    }
                    // we need to finish reading the response before reassigning response
                    // which will leak the open socket.
                    yield response.readBody();
                    // strip authorization header if redirected to a different hostname
                    if (parsedRedirectUrl.hostname !== parsedUrl.hostname) {
                        for (const header in headers) {
                            // header names are case insensitive
                            if (header.toLowerCase() === 'authorization') {
                                delete headers[header];
                            }
                        }
                    }
                    // let's make the request with the new redirectUrl
                    info = this._prepareRequest(verb, parsedRedirectUrl, headers);
                    response = yield this.requestRaw(info, data);
                    redirectsRemaining--;
                }
                if (!response.message.statusCode ||
                    !HttpResponseRetryCodes.includes(response.message.statusCode)) {
                    // If not a retry code, return immediately instead of retrying
                    return response;
                }
                numTries += 1;
                if (numTries < maxTries) {
                    yield response.readBody();
                    yield this._performExponentialBackoff(numTries);
                }
            } while (numTries < maxTries);
            return response;
        });
    }
    /**
     * Needs to be called if keepAlive is set to true in request options.
     */
    dispose() {
        if (this._agent) {
            this._agent.destroy();
        }
        this._disposed = true;
    }
    /**
     * Raw request.
     * @param info
     * @param data
     */
    requestRaw(info, data) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => {
                function callbackForResult(err, res) {
                    if (err) {
                        reject(err);
                    }
                    else if (!res) {
                        // If `err` is not passed, then `res` must be passed.
                        reject(new Error('Unknown error'));
                    }
                    else {
                        resolve(res);
                    }
                }
                this.requestRawWithCallback(info, data, callbackForResult);
            });
        });
    }
    /**
     * Raw request with callback.
     * @param info
     * @param data
     * @param onResult
     */
    requestRawWithCallback(info, data, onResult) {
        if (typeof data === 'string') {
            if (!info.options.headers) {
                info.options.headers = {};
            }
            info.options.headers['Content-Length'] = Buffer.byteLength(data, 'utf8');
        }
        let callbackCalled = false;
        function handleResult(err, res) {
            if (!callbackCalled) {
                callbackCalled = true;
                onResult(err, res);
            }
        }
        const req = info.httpModule.request(info.options, (msg) => {
            const res = new HttpClientResponse(msg);
            handleResult(undefined, res);
        });
        let socket;
        req.on('socket', sock => {
            socket = sock;
        });
        // If we ever get disconnected, we want the socket to timeout eventually
        req.setTimeout(this._socketTimeout || 3 * 60000, () => {
            if (socket) {
                socket.end();
            }
            handleResult(new Error(`Request timeout: ${info.options.path}`));
        });
        req.on('error', function (err) {
            // err has statusCode property
            // res should have headers
            handleResult(err);
        });
        if (data && typeof data === 'string') {
            req.write(data, 'utf8');
        }
        if (data && typeof data !== 'string') {
            data.on('close', function () {
                req.end();
            });
            data.pipe(req);
        }
        else {
            req.end();
        }
    }
    /**
     * Gets an http agent. This function is useful when you need an http agent that handles
     * routing through a proxy server - depending upon the url and proxy environment variables.
     * @param serverUrl  The server URL where the request will be sent. For example, https://api.github.com
     */
    getAgent(serverUrl) {
        const parsedUrl = new URL(serverUrl);
        return this._getAgent(parsedUrl);
    }
    getAgentDispatcher(serverUrl) {
        const parsedUrl = new URL(serverUrl);
        const proxyUrl = pm.getProxyUrl(parsedUrl);
        const useProxy = proxyUrl && proxyUrl.hostname;
        if (!useProxy) {
            return;
        }
        return this._getProxyAgentDispatcher(parsedUrl, proxyUrl);
    }
    _prepareRequest(method, requestUrl, headers) {
        const info = {};
        info.parsedUrl = requestUrl;
        const usingSsl = info.parsedUrl.protocol === 'https:';
        info.httpModule = usingSsl ? https : http;
        const defaultPort = usingSsl ? 443 : 80;
        info.options = {};
        info.options.host = info.parsedUrl.hostname;
        info.options.port = info.parsedUrl.port
            ? parseInt(info.parsedUrl.port)
            : defaultPort;
        info.options.path =
            (info.parsedUrl.pathname || '') + (info.parsedUrl.search || '');
        info.options.method = method;
        info.options.headers = this._mergeHeaders(headers);
        if (this.userAgent != null) {
            info.options.headers['user-agent'] = this.userAgent;
        }
        info.options.agent = this._getAgent(info.parsedUrl);
        // gives handlers an opportunity to participate
        if (this.handlers) {
            for (const handler of this.handlers) {
                handler.prepareRequest(info.options);
            }
        }
        return info;
    }
    _mergeHeaders(headers) {
        if (this.requestOptions && this.requestOptions.headers) {
            return Object.assign({}, lowercaseKeys(this.requestOptions.headers), lowercaseKeys(headers || {}));
        }
        return lowercaseKeys(headers || {});
    }
    _getExistingOrDefaultHeader(additionalHeaders, header, _default) {
        let clientHeader;
        if (this.requestOptions && this.requestOptions.headers) {
            clientHeader = lowercaseKeys(this.requestOptions.headers)[header];
        }
        return additionalHeaders[header] || clientHeader || _default;
    }
    _getAgent(parsedUrl) {
        let agent;
        const proxyUrl = pm.getProxyUrl(parsedUrl);
        const useProxy = proxyUrl && proxyUrl.hostname;
        if (this._keepAlive && useProxy) {
            agent = this._proxyAgent;
        }
        if (this._keepAlive && !useProxy) {
            agent = this._agent;
        }
        // if agent is already assigned use that agent.
        if (agent) {
            return agent;
        }
        const usingSsl = parsedUrl.protocol === 'https:';
        let maxSockets = 100;
        if (this.requestOptions) {
            maxSockets = this.requestOptions.maxSockets || http.globalAgent.maxSockets;
        }
        // This is `useProxy` again, but we need to check `proxyURl` directly for TypeScripts's flow analysis.
        if (proxyUrl && proxyUrl.hostname) {
            const agentOptions = {
                maxSockets,
                keepAlive: this._keepAlive,
                proxy: Object.assign(Object.assign({}, ((proxyUrl.username || proxyUrl.password) && {
                    proxyAuth: `${proxyUrl.username}:${proxyUrl.password}`
                })), { host: proxyUrl.hostname, port: proxyUrl.port })
            };
            let tunnelAgent;
            const overHttps = proxyUrl.protocol === 'https:';
            if (usingSsl) {
                tunnelAgent = overHttps ? tunnel.httpsOverHttps : tunnel.httpsOverHttp;
            }
            else {
                tunnelAgent = overHttps ? tunnel.httpOverHttps : tunnel.httpOverHttp;
            }
            agent = tunnelAgent(agentOptions);
            this._proxyAgent = agent;
        }
        // if reusing agent across request and tunneling agent isn't assigned create a new agent
        if (this._keepAlive && !agent) {
            const options = { keepAlive: this._keepAlive, maxSockets };
            agent = usingSsl ? new https.Agent(options) : new http.Agent(options);
            this._agent = agent;
        }
        // if not using private agent and tunnel agent isn't setup then use global agent
        if (!agent) {
            agent = usingSsl ? https.globalAgent : http.globalAgent;
        }
        if (usingSsl && this._ignoreSslError) {
            // we don't want to set NODE_TLS_REJECT_UNAUTHORIZED=0 since that will affect request for entire process
            // http.RequestOptions doesn't expose a way to modify RequestOptions.agent.options
            // we have to cast it to any and change it directly
            agent.options = Object.assign(agent.options || {}, {
                rejectUnauthorized: false
            });
        }
        return agent;
    }
    _getProxyAgentDispatcher(parsedUrl, proxyUrl) {
        let proxyAgent;
        if (this._keepAlive) {
            proxyAgent = this._proxyAgentDispatcher;
        }
        // if agent is already assigned use that agent.
        if (proxyAgent) {
            return proxyAgent;
        }
        const usingSsl = parsedUrl.protocol === 'https:';
        proxyAgent = new undici_1.ProxyAgent(Object.assign({ uri: proxyUrl.href, pipelining: !this._keepAlive ? 0 : 1 }, ((proxyUrl.username || proxyUrl.password) && {
            token: `${proxyUrl.username}:${proxyUrl.password}`
        })));
        this._proxyAgentDispatcher = proxyAgent;
        if (usingSsl && this._ignoreSslError) {
            // we don't want to set NODE_TLS_REJECT_UNAUTHORIZED=0 since that will affect request for entire process
            // http.RequestOptions doesn't expose a way to modify RequestOptions.agent.options
            // we have to cast it to any and change it directly
            proxyAgent.options = Object.assign(proxyAgent.options.requestTls || {}, {
                rejectUnauthorized: false
            });
        }
        return proxyAgent;
    }
    _performExponentialBackoff(retryNumber) {
        return __awaiter(this, void 0, void 0, function* () {
            retryNumber = Math.min(ExponentialBackoffCeiling, retryNumber);
            const ms = ExponentialBackoffTimeSlice * Math.pow(2, retryNumber);
            return new Promise(resolve => setTimeout(() => resolve(), ms));
        });
    }
    _processResponse(res, options) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                const statusCode = res.message.statusCode || 0;
                const response = {
                    statusCode,
                    result: null,
                    headers: {}
                };
                // not found leads to null obj returned
                if (statusCode === HttpCodes.NotFound) {
                    resolve(response);
                }
                // get the result from the body
                function dateTimeDeserializer(key, value) {
                    if (typeof value === 'string') {
                        const a = new Date(value);
                        if (!isNaN(a.valueOf())) {
                            return a;
                        }
                    }
                    return value;
                }
                let obj;
                let contents;
                try {
                    contents = yield res.readBody();
                    if (contents && contents.length > 0) {
                        if (options && options.deserializeDates) {
                            obj = JSON.parse(contents, dateTimeDeserializer);
                        }
                        else {
                            obj = JSON.parse(contents);
                        }
                        response.result = obj;
                    }
                    response.headers = res.message.headers;
                }
                catch (err) {
                    // Invalid resource (contents not json);  leaving result obj null
                }
                // note that 3xx redirects are handled by the http layer.
                if (statusCode > 299) {
                    let msg;
                    // if exception/error in body, attempt to get better error
                    if (obj && obj.message) {
                        msg = obj.message;
                    }
                    else if (contents && contents.length > 0) {
                        // it may be the case that the exception is in the body message as string
                        msg = contents;
                    }
                    else {
                        msg = `Failed request: (${statusCode})`;
                    }
                    const err = new HttpClientError(msg, statusCode);
                    err.result = response.result;
                    reject(err);
                }
                else {
                    resolve(response);
                }
            }));
        });
    }
}
exports.HttpClient = HttpClient;
const lowercaseKeys = (obj) => Object.keys(obj).reduce((c, k) => ((c[k.toLowerCase()] = obj[k]), c), {});
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 9835:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.checkBypass = exports.getProxyUrl = void 0;
function getProxyUrl(reqUrl) {
    const usingSsl = reqUrl.protocol === 'https:';
    if (checkBypass(reqUrl)) {
        return undefined;
    }
    const proxyVar = (() => {
        if (usingSsl) {
            return process.env['https_proxy'] || process.env['HTTPS_PROXY'];
        }
        else {
            return process.env['http_proxy'] || process.env['HTTP_PROXY'];
        }
    })();
    if (proxyVar) {
        try {
            return new URL(proxyVar);
        }
        catch (_a) {
            if (!proxyVar.startsWith('http://') && !proxyVar.startsWith('https://'))
                return new URL(`http://${proxyVar}`);
        }
    }
    else {
        return undefined;
    }
}
exports.getProxyUrl = getProxyUrl;
function checkBypass(reqUrl) {
    if (!reqUrl.hostname) {
        return false;
    }
    const reqHost = reqUrl.hostname;
    if (isLoopbackAddress(reqHost)) {
        return true;
    }
    const noProxy = process.env['no_proxy'] || process.env['NO_PROXY'] || '';
    if (!noProxy) {
        return false;
    }
    // Determine the request port
    let reqPort;
    if (reqUrl.port) {
        reqPort = Number(reqUrl.port);
    }
    else if (reqUrl.protocol === 'http:') {
        reqPort = 80;
    }
    else if (reqUrl.protocol === 'https:') {
        reqPort = 443;
    }
    // Format the request hostname and hostname with port
    const upperReqHosts = [reqUrl.hostname.toUpperCase()];
    if (typeof reqPort === 'number') {
        upperReqHosts.push(`${upperReqHosts[0]}:${reqPort}`);
    }
    // Compare request host against noproxy
    for (const upperNoProxyItem of noProxy
        .split(',')
        .map(x => x.trim().toUpperCase())
        .filter(x => x)) {
        if (upperNoProxyItem === '*' ||
            upperReqHosts.some(x => x === upperNoProxyItem ||
                x.endsWith(`.${upperNoProxyItem}`) ||
                (upperNoProxyItem.startsWith('.') &&
                    x.endsWith(`${upperNoProxyItem}`)))) {
            return true;
        }
    }
    return false;
}
exports.checkBypass = checkBypass;
function isLoopbackAddress(host) {
    const hostLower = host.toLowerCase();
    return (hostLower === 'localhost' ||
        hostLower.startsWith('127.') ||
        hostLower.startsWith('[::1]') ||
        hostLower.startsWith('[0:0:0:0:0:0:0:1]'));
}
//# sourceMappingURL=proxy.js.map

/***/ }),

/***/ 1962:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getCmdPath = exports.tryGetExecutablePath = exports.isRooted = exports.isDirectory = exports.exists = exports.READONLY = exports.UV_FS_O_EXLOCK = exports.IS_WINDOWS = exports.unlink = exports.symlink = exports.stat = exports.rmdir = exports.rm = exports.rename = exports.readlink = exports.readdir = exports.open = exports.mkdir = exports.lstat = exports.copyFile = exports.chmod = void 0;
const fs = __importStar(__nccwpck_require__(7147));
const path = __importStar(__nccwpck_require__(1017));
_a = fs.promises
// export const {open} = 'fs'
, exports.chmod = _a.chmod, exports.copyFile = _a.copyFile, exports.lstat = _a.lstat, exports.mkdir = _a.mkdir, exports.open = _a.open, exports.readdir = _a.readdir, exports.readlink = _a.readlink, exports.rename = _a.rename, exports.rm = _a.rm, exports.rmdir = _a.rmdir, exports.stat = _a.stat, exports.symlink = _a.symlink, exports.unlink = _a.unlink;
// export const {open} = 'fs'
exports.IS_WINDOWS = process.platform === 'win32';
// See https://github.com/nodejs/node/blob/d0153aee367422d0858105abec186da4dff0a0c5/deps/uv/include/uv/win.h#L691
exports.UV_FS_O_EXLOCK = 0x10000000;
exports.READONLY = fs.constants.O_RDONLY;
function exists(fsPath) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            yield exports.stat(fsPath);
        }
        catch (err) {
            if (err.code === 'ENOENT') {
                return false;
            }
            throw err;
        }
        return true;
    });
}
exports.exists = exists;
function isDirectory(fsPath, useStat = false) {
    return __awaiter(this, void 0, void 0, function* () {
        const stats = useStat ? yield exports.stat(fsPath) : yield exports.lstat(fsPath);
        return stats.isDirectory();
    });
}
exports.isDirectory = isDirectory;
/**
 * On OSX/Linux, true if path starts with '/'. On Windows, true for paths like:
 * \, \hello, \\hello\share, C:, and C:\hello (and corresponding alternate separator cases).
 */
function isRooted(p) {
    p = normalizeSeparators(p);
    if (!p) {
        throw new Error('isRooted() parameter "p" cannot be empty');
    }
    if (exports.IS_WINDOWS) {
        return (p.startsWith('\\') || /^[A-Z]:/i.test(p) // e.g. \ or \hello or \\hello
        ); // e.g. C: or C:\hello
    }
    return p.startsWith('/');
}
exports.isRooted = isRooted;
/**
 * Best effort attempt to determine whether a file exists and is executable.
 * @param filePath    file path to check
 * @param extensions  additional file extensions to try
 * @return if file exists and is executable, returns the file path. otherwise empty string.
 */
function tryGetExecutablePath(filePath, extensions) {
    return __awaiter(this, void 0, void 0, function* () {
        let stats = undefined;
        try {
            // test file exists
            stats = yield exports.stat(filePath);
        }
        catch (err) {
            if (err.code !== 'ENOENT') {
                // eslint-disable-next-line no-console
                console.log(`Unexpected error attempting to determine if executable file exists '${filePath}': ${err}`);
            }
        }
        if (stats && stats.isFile()) {
            if (exports.IS_WINDOWS) {
                // on Windows, test for valid extension
                const upperExt = path.extname(filePath).toUpperCase();
                if (extensions.some(validExt => validExt.toUpperCase() === upperExt)) {
                    return filePath;
                }
            }
            else {
                if (isUnixExecutable(stats)) {
                    return filePath;
                }
            }
        }
        // try each extension
        const originalFilePath = filePath;
        for (const extension of extensions) {
            filePath = originalFilePath + extension;
            stats = undefined;
            try {
                stats = yield exports.stat(filePath);
            }
            catch (err) {
                if (err.code !== 'ENOENT') {
                    // eslint-disable-next-line no-console
                    console.log(`Unexpected error attempting to determine if executable file exists '${filePath}': ${err}`);
                }
            }
            if (stats && stats.isFile()) {
                if (exports.IS_WINDOWS) {
                    // preserve the case of the actual file (since an extension was appended)
                    try {
                        const directory = path.dirname(filePath);
                        const upperName = path.basename(filePath).toUpperCase();
                        for (const actualName of yield exports.readdir(directory)) {
                            if (upperName === actualName.toUpperCase()) {
                                filePath = path.join(directory, actualName);
                                break;
                            }
                        }
                    }
                    catch (err) {
                        // eslint-disable-next-line no-console
                        console.log(`Unexpected error attempting to determine the actual case of the file '${filePath}': ${err}`);
                    }
                    return filePath;
                }
                else {
                    if (isUnixExecutable(stats)) {
                        return filePath;
                    }
                }
            }
        }
        return '';
    });
}
exports.tryGetExecutablePath = tryGetExecutablePath;
function normalizeSeparators(p) {
    p = p || '';
    if (exports.IS_WINDOWS) {
        // convert slashes on Windows
        p = p.replace(/\//g, '\\');
        // remove redundant slashes
        return p.replace(/\\\\+/g, '\\');
    }
    // remove redundant slashes
    return p.replace(/\/\/+/g, '/');
}
// on Mac/Linux, test the execute bit
//     R   W  X  R  W X R W X
//   256 128 64 32 16 8 4 2 1
function isUnixExecutable(stats) {
    return ((stats.mode & 1) > 0 ||
        ((stats.mode & 8) > 0 && stats.gid === process.getgid()) ||
        ((stats.mode & 64) > 0 && stats.uid === process.getuid()));
}
// Get the path of cmd.exe in windows
function getCmdPath() {
    var _a;
    return (_a = process.env['COMSPEC']) !== null && _a !== void 0 ? _a : `cmd.exe`;
}
exports.getCmdPath = getCmdPath;
//# sourceMappingURL=io-util.js.map

/***/ }),

/***/ 7436:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.findInPath = exports.which = exports.mkdirP = exports.rmRF = exports.mv = exports.cp = void 0;
const assert_1 = __nccwpck_require__(9491);
const path = __importStar(__nccwpck_require__(1017));
const ioUtil = __importStar(__nccwpck_require__(1962));
/**
 * Copies a file or folder.
 * Based off of shelljs - https://github.com/shelljs/shelljs/blob/9237f66c52e5daa40458f94f9565e18e8132f5a6/src/cp.js
 *
 * @param     source    source path
 * @param     dest      destination path
 * @param     options   optional. See CopyOptions.
 */
function cp(source, dest, options = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        const { force, recursive, copySourceDirectory } = readCopyOptions(options);
        const destStat = (yield ioUtil.exists(dest)) ? yield ioUtil.stat(dest) : null;
        // Dest is an existing file, but not forcing
        if (destStat && destStat.isFile() && !force) {
            return;
        }
        // If dest is an existing directory, should copy inside.
        const newDest = destStat && destStat.isDirectory() && copySourceDirectory
            ? path.join(dest, path.basename(source))
            : dest;
        if (!(yield ioUtil.exists(source))) {
            throw new Error(`no such file or directory: ${source}`);
        }
        const sourceStat = yield ioUtil.stat(source);
        if (sourceStat.isDirectory()) {
            if (!recursive) {
                throw new Error(`Failed to copy. ${source} is a directory, but tried to copy without recursive flag.`);
            }
            else {
                yield cpDirRecursive(source, newDest, 0, force);
            }
        }
        else {
            if (path.relative(source, newDest) === '') {
                // a file cannot be copied to itself
                throw new Error(`'${newDest}' and '${source}' are the same file`);
            }
            yield copyFile(source, newDest, force);
        }
    });
}
exports.cp = cp;
/**
 * Moves a path.
 *
 * @param     source    source path
 * @param     dest      destination path
 * @param     options   optional. See MoveOptions.
 */
function mv(source, dest, options = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        if (yield ioUtil.exists(dest)) {
            let destExists = true;
            if (yield ioUtil.isDirectory(dest)) {
                // If dest is directory copy src into dest
                dest = path.join(dest, path.basename(source));
                destExists = yield ioUtil.exists(dest);
            }
            if (destExists) {
                if (options.force == null || options.force) {
                    yield rmRF(dest);
                }
                else {
                    throw new Error('Destination already exists');
                }
            }
        }
        yield mkdirP(path.dirname(dest));
        yield ioUtil.rename(source, dest);
    });
}
exports.mv = mv;
/**
 * Remove a path recursively with force
 *
 * @param inputPath path to remove
 */
function rmRF(inputPath) {
    return __awaiter(this, void 0, void 0, function* () {
        if (ioUtil.IS_WINDOWS) {
            // Check for invalid characters
            // https://docs.microsoft.com/en-us/windows/win32/fileio/naming-a-file
            if (/[*"<>|]/.test(inputPath)) {
                throw new Error('File path must not contain `*`, `"`, `<`, `>` or `|` on Windows');
            }
        }
        try {
            // note if path does not exist, error is silent
            yield ioUtil.rm(inputPath, {
                force: true,
                maxRetries: 3,
                recursive: true,
                retryDelay: 300
            });
        }
        catch (err) {
            throw new Error(`File was unable to be removed ${err}`);
        }
    });
}
exports.rmRF = rmRF;
/**
 * Make a directory.  Creates the full path with folders in between
 * Will throw if it fails
 *
 * @param   fsPath        path to create
 * @returns Promise<void>
 */
function mkdirP(fsPath) {
    return __awaiter(this, void 0, void 0, function* () {
        assert_1.ok(fsPath, 'a path argument must be provided');
        yield ioUtil.mkdir(fsPath, { recursive: true });
    });
}
exports.mkdirP = mkdirP;
/**
 * Returns path of a tool had the tool actually been invoked.  Resolves via paths.
 * If you check and the tool does not exist, it will throw.
 *
 * @param     tool              name of the tool
 * @param     check             whether to check if tool exists
 * @returns   Promise<string>   path to tool
 */
function which(tool, check) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!tool) {
            throw new Error("parameter 'tool' is required");
        }
        // recursive when check=true
        if (check) {
            const result = yield which(tool, false);
            if (!result) {
                if (ioUtil.IS_WINDOWS) {
                    throw new Error(`Unable to locate executable file: ${tool}. Please verify either the file path exists or the file can be found within a directory specified by the PATH environment variable. Also verify the file has a valid extension for an executable file.`);
                }
                else {
                    throw new Error(`Unable to locate executable file: ${tool}. Please verify either the file path exists or the file can be found within a directory specified by the PATH environment variable. Also check the file mode to verify the file is executable.`);
                }
            }
            return result;
        }
        const matches = yield findInPath(tool);
        if (matches && matches.length > 0) {
            return matches[0];
        }
        return '';
    });
}
exports.which = which;
/**
 * Returns a list of all occurrences of the given tool on the system path.
 *
 * @returns   Promise<string[]>  the paths of the tool
 */
function findInPath(tool) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!tool) {
            throw new Error("parameter 'tool' is required");
        }
        // build the list of extensions to try
        const extensions = [];
        if (ioUtil.IS_WINDOWS && process.env['PATHEXT']) {
            for (const extension of process.env['PATHEXT'].split(path.delimiter)) {
                if (extension) {
                    extensions.push(extension);
                }
            }
        }
        // if it's rooted, return it if exists. otherwise return empty.
        if (ioUtil.isRooted(tool)) {
            const filePath = yield ioUtil.tryGetExecutablePath(tool, extensions);
            if (filePath) {
                return [filePath];
            }
            return [];
        }
        // if any path separators, return empty
        if (tool.includes(path.sep)) {
            return [];
        }
        // build the list of directories
        //
        // Note, technically "where" checks the current directory on Windows. From a toolkit perspective,
        // it feels like we should not do this. Checking the current directory seems like more of a use
        // case of a shell, and the which() function exposed by the toolkit should strive for consistency
        // across platforms.
        const directories = [];
        if (process.env.PATH) {
            for (const p of process.env.PATH.split(path.delimiter)) {
                if (p) {
                    directories.push(p);
                }
            }
        }
        // find all matches
        const matches = [];
        for (const directory of directories) {
            const filePath = yield ioUtil.tryGetExecutablePath(path.join(directory, tool), extensions);
            if (filePath) {
                matches.push(filePath);
            }
        }
        return matches;
    });
}
exports.findInPath = findInPath;
function readCopyOptions(options) {
    const force = options.force == null ? true : options.force;
    const recursive = Boolean(options.recursive);
    const copySourceDirectory = options.copySourceDirectory == null
        ? true
        : Boolean(options.copySourceDirectory);
    return { force, recursive, copySourceDirectory };
}
function cpDirRecursive(sourceDir, destDir, currentDepth, force) {
    return __awaiter(this, void 0, void 0, function* () {
        // Ensure there is not a run away recursive copy
        if (currentDepth >= 255)
            return;
        currentDepth++;
        yield mkdirP(destDir);
        const files = yield ioUtil.readdir(sourceDir);
        for (const fileName of files) {
            const srcFile = `${sourceDir}/${fileName}`;
            const destFile = `${destDir}/${fileName}`;
            const srcFileStat = yield ioUtil.lstat(srcFile);
            if (srcFileStat.isDirectory()) {
                // Recurse
                yield cpDirRecursive(srcFile, destFile, currentDepth, force);
            }
            else {
                yield copyFile(srcFile, destFile, force);
            }
        }
        // Change the mode for the newly created directory
        yield ioUtil.chmod(destDir, (yield ioUtil.stat(sourceDir)).mode);
    });
}
// Buffered file copy
function copyFile(srcFile, destFile, force) {
    return __awaiter(this, void 0, void 0, function* () {
        if ((yield ioUtil.lstat(srcFile)).isSymbolicLink()) {
            // unlink/re-link it
            try {
                yield ioUtil.lstat(destFile);
                yield ioUtil.unlink(destFile);
            }
            catch (e) {
                // Try to override file permission
                if (e.code === 'EPERM') {
                    yield ioUtil.chmod(destFile, '0666');
                    yield ioUtil.unlink(destFile);
                }
                // other errors = it doesn't exist, no work to do
            }
            // Copy over symlink
            const symlinkFull = yield ioUtil.readlink(srcFile);
            yield ioUtil.symlink(symlinkFull, destFile, ioUtil.IS_WINDOWS ? 'junction' : null);
        }
        else if (!(yield ioUtil.exists(destFile)) || force) {
            yield ioUtil.copyFile(srcFile, destFile);
        }
    });
}
//# sourceMappingURL=io.js.map

/***/ }),

/***/ 2557:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({ value: true }));

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/// <reference path="../shims-public.d.ts" />
const listenersMap = new WeakMap();
const abortedMap = new WeakMap();
/**
 * An aborter instance implements AbortSignal interface, can abort HTTP requests.
 *
 * - Call AbortSignal.none to create a new AbortSignal instance that cannot be cancelled.
 * Use `AbortSignal.none` when you are required to pass a cancellation token but the operation
 * cannot or will not ever be cancelled.
 *
 * @example
 * Abort without timeout
 * ```ts
 * await doAsyncWork(AbortSignal.none);
 * ```
 */
class AbortSignal {
    constructor() {
        /**
         * onabort event listener.
         */
        this.onabort = null;
        listenersMap.set(this, []);
        abortedMap.set(this, false);
    }
    /**
     * Status of whether aborted or not.
     *
     * @readonly
     */
    get aborted() {
        if (!abortedMap.has(this)) {
            throw new TypeError("Expected `this` to be an instance of AbortSignal.");
        }
        return abortedMap.get(this);
    }
    /**
     * Creates a new AbortSignal instance that will never be aborted.
     *
     * @readonly
     */
    static get none() {
        return new AbortSignal();
    }
    /**
     * Added new "abort" event listener, only support "abort" event.
     *
     * @param _type - Only support "abort" event
     * @param listener - The listener to be added
     */
    addEventListener(
    // tslint:disable-next-line:variable-name
    _type, listener) {
        if (!listenersMap.has(this)) {
            throw new TypeError("Expected `this` to be an instance of AbortSignal.");
        }
        const listeners = listenersMap.get(this);
        listeners.push(listener);
    }
    /**
     * Remove "abort" event listener, only support "abort" event.
     *
     * @param _type - Only support "abort" event
     * @param listener - The listener to be removed
     */
    removeEventListener(
    // tslint:disable-next-line:variable-name
    _type, listener) {
        if (!listenersMap.has(this)) {
            throw new TypeError("Expected `this` to be an instance of AbortSignal.");
        }
        const listeners = listenersMap.get(this);
        const index = listeners.indexOf(listener);
        if (index > -1) {
            listeners.splice(index, 1);
        }
    }
    /**
     * Dispatches a synthetic event to the AbortSignal.
     */
    dispatchEvent(_event) {
        throw new Error("This is a stub dispatchEvent implementation that should not be used.  It only exists for type-checking purposes.");
    }
}
/**
 * Helper to trigger an abort event immediately, the onabort and all abort event listeners will be triggered.
 * Will try to trigger abort event for all linked AbortSignal nodes.
 *
 * - If there is a timeout, the timer will be cancelled.
 * - If aborted is true, nothing will happen.
 *
 * @internal
 */
// eslint-disable-next-line @azure/azure-sdk/ts-use-interface-parameters
function abortSignal(signal) {
    if (signal.aborted) {
        return;
    }
    if (signal.onabort) {
        signal.onabort.call(signal);
    }
    const listeners = listenersMap.get(signal);
    if (listeners) {
        // Create a copy of listeners so mutations to the array
        // (e.g. via removeListener calls) don't affect the listeners
        // we invoke.
        listeners.slice().forEach((listener) => {
            listener.call(signal, { type: "abort" });
        });
    }
    abortedMap.set(signal, true);
}

// Copyright (c) Microsoft Corporation.
/**
 * This error is thrown when an asynchronous operation has been aborted.
 * Check for this error by testing the `name` that the name property of the
 * error matches `"AbortError"`.
 *
 * @example
 * ```ts
 * const controller = new AbortController();
 * controller.abort();
 * try {
 *   doAsyncWork(controller.signal)
 * } catch (e) {
 *   if (e.name === 'AbortError') {
 *     // handle abort error here.
 *   }
 * }
 * ```
 */
class AbortError extends Error {
    constructor(message) {
        super(message);
        this.name = "AbortError";
    }
}
/**
 * An AbortController provides an AbortSignal and the associated controls to signal
 * that an asynchronous operation should be aborted.
 *
 * @example
 * Abort an operation when another event fires
 * ```ts
 * const controller = new AbortController();
 * const signal = controller.signal;
 * doAsyncWork(signal);
 * button.addEventListener('click', () => controller.abort());
 * ```
 *
 * @example
 * Share aborter cross multiple operations in 30s
 * ```ts
 * // Upload the same data to 2 different data centers at the same time,
 * // abort another when any of them is finished
 * const controller = AbortController.withTimeout(30 * 1000);
 * doAsyncWork(controller.signal).then(controller.abort);
 * doAsyncWork(controller.signal).then(controller.abort);
 *```
 *
 * @example
 * Cascaded aborting
 * ```ts
 * // All operations can't take more than 30 seconds
 * const aborter = Aborter.timeout(30 * 1000);
 *
 * // Following 2 operations can't take more than 25 seconds
 * await doAsyncWork(aborter.withTimeout(25 * 1000));
 * await doAsyncWork(aborter.withTimeout(25 * 1000));
 * ```
 */
class AbortController {
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    constructor(parentSignals) {
        this._signal = new AbortSignal();
        if (!parentSignals) {
            return;
        }
        // coerce parentSignals into an array
        if (!Array.isArray(parentSignals)) {
            // eslint-disable-next-line prefer-rest-params
            parentSignals = arguments;
        }
        for (const parentSignal of parentSignals) {
            // if the parent signal has already had abort() called,
            // then call abort on this signal as well.
            if (parentSignal.aborted) {
                this.abort();
            }
            else {
                // when the parent signal aborts, this signal should as well.
                parentSignal.addEventListener("abort", () => {
                    this.abort();
                });
            }
        }
    }
    /**
     * The AbortSignal associated with this controller that will signal aborted
     * when the abort method is called on this controller.
     *
     * @readonly
     */
    get signal() {
        return this._signal;
    }
    /**
     * Signal that any operations passed this controller's associated abort signal
     * to cancel any remaining work and throw an `AbortError`.
     */
    abort() {
        abortSignal(this._signal);
    }
    /**
     * Creates a new AbortSignal instance that will abort after the provided ms.
     * @param ms - Elapsed time in milliseconds to trigger an abort.
     */
    static timeout(ms) {
        const signal = new AbortSignal();
        const timer = setTimeout(abortSignal, ms, signal);
        // Prevent the active Timer from keeping the Node.js event loop active.
        if (typeof timer.unref === "function") {
            timer.unref();
        }
        return signal;
    }
}

exports.AbortController = AbortController;
exports.AbortError = AbortError;
exports.AbortSignal = AbortSignal;
//# sourceMappingURL=index.js.map


/***/ }),

/***/ 9645:
/***/ ((__unused_webpack_module, exports, __nccwpck_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({ value: true }));

var coreUtil = __nccwpck_require__(1333);

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * A static-key-based credential that supports updating
 * the underlying key value.
 */
class AzureKeyCredential {
    /**
     * The value of the key to be used in authentication
     */
    get key() {
        return this._key;
    }
    /**
     * Create an instance of an AzureKeyCredential for use
     * with a service client.
     *
     * @param key - The initial value of the key to use in authentication
     */
    constructor(key) {
        if (!key) {
            throw new Error("key must be a non-empty string");
        }
        this._key = key;
    }
    /**
     * Change the value of the key.
     *
     * Updates will take effect upon the next request after
     * updating the key value.
     *
     * @param newKey - The new key value to be used
     */
    update(newKey) {
        this._key = newKey;
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * Tests an object to determine whether it implements KeyCredential.
 *
 * @param credential - The assumed KeyCredential to be tested.
 */
function isKeyCredential(credential) {
    return coreUtil.isObjectWithProperties(credential, ["key"]) && typeof credential.key === "string";
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * A static name/key-based credential that supports updating
 * the underlying name and key values.
 */
class AzureNamedKeyCredential {
    /**
     * The value of the key to be used in authentication.
     */
    get key() {
        return this._key;
    }
    /**
     * The value of the name to be used in authentication.
     */
    get name() {
        return this._name;
    }
    /**
     * Create an instance of an AzureNamedKeyCredential for use
     * with a service client.
     *
     * @param name - The initial value of the name to use in authentication.
     * @param key - The initial value of the key to use in authentication.
     */
    constructor(name, key) {
        if (!name || !key) {
            throw new TypeError("name and key must be non-empty strings");
        }
        this._name = name;
        this._key = key;
    }
    /**
     * Change the value of the key.
     *
     * Updates will take effect upon the next request after
     * updating the key value.
     *
     * @param newName - The new name value to be used.
     * @param newKey - The new key value to be used.
     */
    update(newName, newKey) {
        if (!newName || !newKey) {
            throw new TypeError("newName and newKey must be non-empty strings");
        }
        this._name = newName;
        this._key = newKey;
    }
}
/**
 * Tests an object to determine whether it implements NamedKeyCredential.
 *
 * @param credential - The assumed NamedKeyCredential to be tested.
 */
function isNamedKeyCredential(credential) {
    return (coreUtil.isObjectWithProperties(credential, ["name", "key"]) &&
        typeof credential.key === "string" &&
        typeof credential.name === "string");
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * A static-signature-based credential that supports updating
 * the underlying signature value.
 */
class AzureSASCredential {
    /**
     * The value of the shared access signature to be used in authentication
     */
    get signature() {
        return this._signature;
    }
    /**
     * Create an instance of an AzureSASCredential for use
     * with a service client.
     *
     * @param signature - The initial value of the shared access signature to use in authentication
     */
    constructor(signature) {
        if (!signature) {
            throw new Error("shared access signature must be a non-empty string");
        }
        this._signature = signature;
    }
    /**
     * Change the value of the signature.
     *
     * Updates will take effect upon the next request after
     * updating the signature value.
     *
     * @param newSignature - The new shared access signature value to be used
     */
    update(newSignature) {
        if (!newSignature) {
            throw new Error("shared access signature must be a non-empty string");
        }
        this._signature = newSignature;
    }
}
/**
 * Tests an object to determine whether it implements SASCredential.
 *
 * @param credential - The assumed SASCredential to be tested.
 */
function isSASCredential(credential) {
    return (coreUtil.isObjectWithProperties(credential, ["signature"]) && typeof credential.signature === "string");
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * Tests an object to determine whether it implements TokenCredential.
 *
 * @param credential - The assumed TokenCredential to be tested.
 */
function isTokenCredential(credential) {
    // Check for an object with a 'getToken' function and possibly with
    // a 'signRequest' function.  We do this check to make sure that
    // a ServiceClientCredentials implementor (like TokenClientCredentials
    // in ms-rest-nodeauth) doesn't get mistaken for a TokenCredential if
    // it doesn't actually implement TokenCredential also.
    const castCredential = credential;
    return (castCredential &&
        typeof castCredential.getToken === "function" &&
        (castCredential.signRequest === undefined || castCredential.getToken.length > 0));
}

exports.AzureKeyCredential = AzureKeyCredential;
exports.AzureNamedKeyCredential = AzureNamedKeyCredential;
exports.AzureSASCredential = AzureSASCredential;
exports.isKeyCredential = isKeyCredential;
exports.isNamedKeyCredential = isNamedKeyCredential;
exports.isSASCredential = isSASCredential;
exports.isTokenCredential = isTokenCredential;
//# sourceMappingURL=index.js.map


/***/ }),

/***/ 4607:
/***/ ((__unused_webpack_module, exports, __nccwpck_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({ value: true }));

var uuid = __nccwpck_require__(5840);
var util = __nccwpck_require__(3837);
var tslib = __nccwpck_require__(4351);
var xml2js = __nccwpck_require__(6189);
var coreUtil = __nccwpck_require__(1333);
var logger$1 = __nccwpck_require__(3233);
var coreAuth = __nccwpck_require__(9645);
var os = __nccwpck_require__(2037);
var http = __nccwpck_require__(3685);
var https = __nccwpck_require__(5687);
var abortController = __nccwpck_require__(2557);
var tunnel = __nccwpck_require__(4294);
var stream = __nccwpck_require__(2781);
var FormData = __nccwpck_require__(4334);
var node_fetch = __nccwpck_require__(467);
var coreTracing = __nccwpck_require__(4175);

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    var n = Object.create(null);
    if (e) {
        Object.keys(e).forEach(function (k) {
            if (k !== 'default') {
                var d = Object.getOwnPropertyDescriptor(e, k);
                Object.defineProperty(n, k, d.get ? d : {
                    enumerable: true,
                    get: function () { return e[k]; }
                });
            }
        });
    }
    n["default"] = e;
    return Object.freeze(n);
}

var xml2js__namespace = /*#__PURE__*/_interopNamespace(xml2js);
var os__namespace = /*#__PURE__*/_interopNamespace(os);
var http__namespace = /*#__PURE__*/_interopNamespace(http);
var https__namespace = /*#__PURE__*/_interopNamespace(https);
var tunnel__namespace = /*#__PURE__*/_interopNamespace(tunnel);
var FormData__default = /*#__PURE__*/_interopDefaultLegacy(FormData);
var node_fetch__default = /*#__PURE__*/_interopDefaultLegacy(node_fetch);

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * A collection of HttpHeaders that can be sent with a HTTP request.
 */
function getHeaderKey(headerName) {
    return headerName.toLowerCase();
}
function isHttpHeadersLike(object) {
    if (object && typeof object === "object") {
        const castObject = object;
        if (typeof castObject.rawHeaders === "function" &&
            typeof castObject.clone === "function" &&
            typeof castObject.get === "function" &&
            typeof castObject.set === "function" &&
            typeof castObject.contains === "function" &&
            typeof castObject.remove === "function" &&
            typeof castObject.headersArray === "function" &&
            typeof castObject.headerValues === "function" &&
            typeof castObject.headerNames === "function" &&
            typeof castObject.toJson === "function") {
            return true;
        }
    }
    return false;
}
/**
 * A collection of HTTP header key/value pairs.
 */
class HttpHeaders {
    constructor(rawHeaders) {
        this._headersMap = {};
        if (rawHeaders) {
            for (const headerName in rawHeaders) {
                this.set(headerName, rawHeaders[headerName]);
            }
        }
    }
    /**
     * Set a header in this collection with the provided name and value. The name is
     * case-insensitive.
     * @param headerName - The name of the header to set. This value is case-insensitive.
     * @param headerValue - The value of the header to set.
     */
    set(headerName, headerValue) {
        this._headersMap[getHeaderKey(headerName)] = {
            name: headerName,
            value: headerValue.toString().trim(),
        };
    }
    /**
     * Get the header value for the provided header name, or undefined if no header exists in this
     * collection with the provided name.
     * @param headerName - The name of the header.
     */
    get(headerName) {
        const header = this._headersMap[getHeaderKey(headerName)];
        return !header ? undefined : header.value;
    }
    /**
     * Get whether or not this header collection contains a header entry for the provided header name.
     */
    contains(headerName) {
        return !!this._headersMap[getHeaderKey(headerName)];
    }
    /**
     * Remove the header with the provided headerName. Return whether or not the header existed and
     * was removed.
     * @param headerName - The name of the header to remove.
     */
    remove(headerName) {
        const result = this.contains(headerName);
        delete this._headersMap[getHeaderKey(headerName)];
        return result;
    }
    /**
     * Get the headers that are contained this collection as an object.
     */
    rawHeaders() {
        return this.toJson({ preserveCase: true });
    }
    /**
     * Get the headers that are contained in this collection as an array.
     */
    headersArray() {
        const headers = [];
        for (const headerKey in this._headersMap) {
            headers.push(this._headersMap[headerKey]);
        }
        return headers;
    }
    /**
     * Get the header names that are contained in this collection.
     */
    headerNames() {
        const headerNames = [];
        const headers = this.headersArray();
        for (let i = 0; i < headers.length; ++i) {
            headerNames.push(headers[i].name);
        }
        return headerNames;
    }
    /**
     * Get the header values that are contained in this collection.
     */
    headerValues() {
        const headerValues = [];
        const headers = this.headersArray();
        for (let i = 0; i < headers.length; ++i) {
            headerValues.push(headers[i].value);
        }
        return headerValues;
    }
    /**
     * Get the JSON object representation of this HTTP header collection.
     */
    toJson(options = {}) {
        const result = {};
        if (options.preserveCase) {
            for (const headerKey in this._headersMap) {
                const header = this._headersMap[headerKey];
                result[header.name] = header.value;
            }
        }
        else {
            for (const headerKey in this._headersMap) {
                const header = this._headersMap[headerKey];
                result[getHeaderKey(header.name)] = header.value;
            }
        }
        return result;
    }
    /**
     * Get the string representation of this HTTP header collection.
     */
    toString() {
        return JSON.stringify(this.toJson({ preserveCase: true }));
    }
    /**
     * Create a deep clone/copy of this HttpHeaders collection.
     */
    clone() {
        const resultPreservingCasing = {};
        for (const headerKey in this._headersMap) {
            const header = this._headersMap[headerKey];
            resultPreservingCasing[header.name] = header.value;
        }
        return new HttpHeaders(resultPreservingCasing);
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * Encodes a string in base64 format.
 * @param value - The string to encode
 */
function encodeString(value) {
    return Buffer.from(value).toString("base64");
}
/**
 * Encodes a byte array in base64 format.
 * @param value - The Uint8Aray to encode
 */
function encodeByteArray(value) {
    // Buffer.from accepts <ArrayBuffer> | <SharedArrayBuffer>-- the TypeScript definition is off here
    // https://nodejs.org/api/buffer.html#buffer_class_method_buffer_from_arraybuffer_byteoffset_length
    const bufferValue = value instanceof Buffer ? value : Buffer.from(value.buffer);
    return bufferValue.toString("base64");
}
/**
 * Decodes a base64 string into a byte array.
 * @param value - The base64 string to decode
 */
function decodeString(value) {
    return Buffer.from(value, "base64");
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * A set of constants used internally when processing requests.
 */
const Constants = {
    /**
     * The core-http version
     */
    coreHttpVersion: "3.0.4",
    /**
     * Specifies HTTP.
     */
    HTTP: "http:",
    /**
     * Specifies HTTPS.
     */
    HTTPS: "https:",
    /**
     * Specifies HTTP Proxy.
     */
    HTTP_PROXY: "HTTP_PROXY",
    /**
     * Specifies HTTPS Proxy.
     */
    HTTPS_PROXY: "HTTPS_PROXY",
    /**
     * Specifies NO Proxy.
     */
    NO_PROXY: "NO_PROXY",
    /**
     * Specifies ALL Proxy.
     */
    ALL_PROXY: "ALL_PROXY",
    HttpConstants: {
        /**
         * Http Verbs
         */
        HttpVerbs: {
            PUT: "PUT",
            GET: "GET",
            DELETE: "DELETE",
            POST: "POST",
            MERGE: "MERGE",
            HEAD: "HEAD",
            PATCH: "PATCH",
        },
        StatusCodes: {
            TooManyRequests: 429,
            ServiceUnavailable: 503,
        },
    },
    /**
     * Defines constants for use with HTTP headers.
     */
    HeaderConstants: {
        /**
         * The Authorization header.
         */
        AUTHORIZATION: "authorization",
        AUTHORIZATION_SCHEME: "Bearer",
        /**
         * The Retry-After response-header field can be used with a 503 (Service
         * Unavailable) or 349 (Too Many Requests) responses to indicate how long
         * the service is expected to be unavailable to the requesting client.
         */
        RETRY_AFTER: "Retry-After",
        /**
         * The UserAgent header.
         */
        USER_AGENT: "User-Agent",
    },
};

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * Default key used to access the XML attributes.
 */
const XML_ATTRKEY = "$";
/**
 * Default key used to access the XML value content.
 */
const XML_CHARKEY = "_";

// Copyright (c) Microsoft Corporation.
const validUuidRegex = /^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$/i;
/**
 * Encodes an URI.
 *
 * @param uri - The URI to be encoded.
 * @returns The encoded URI.
 */
function encodeUri(uri) {
    return encodeURIComponent(uri)
        .replace(/!/g, "%21")
        .replace(/"/g, "%27")
        .replace(/\(/g, "%28")
        .replace(/\)/g, "%29")
        .replace(/\*/g, "%2A");
}
/**
 * Returns a stripped version of the Http Response which only contains body,
 * headers and the status.
 *
 * @param response - The Http Response
 * @returns The stripped version of Http Response.
 */
function stripResponse(response) {
    const strippedResponse = {};
    strippedResponse.body = response.bodyAsText;
    strippedResponse.headers = response.headers;
    strippedResponse.status = response.status;
    return strippedResponse;
}
/**
 * Returns a stripped version of the Http Request that does not contain the
 * Authorization header.
 *
 * @param request - The Http Request object
 * @returns The stripped version of Http Request.
 */
function stripRequest(request) {
    const strippedRequest = request.clone();
    if (strippedRequest.headers) {
        strippedRequest.headers.remove("authorization");
    }
    return strippedRequest;
}
/**
 * Validates the given uuid as a string
 *
 * @param uuid - The uuid as a string that needs to be validated
 * @returns True if the uuid is valid; false otherwise.
 */
function isValidUuid(uuid) {
    return validUuidRegex.test(uuid);
}
/**
 * Generated UUID
 *
 * @returns RFC4122 v4 UUID.
 */
function generateUuid() {
    return uuid.v4();
}
/**
 * Executes an array of promises sequentially. Inspiration of this method is here:
 * https://pouchdb.com/2015/05/18/we-have-a-problem-with-promises.html. An awesome blog on promises!
 *
 * @param promiseFactories - An array of promise factories(A function that return a promise)
 * @param kickstart - Input to the first promise that is used to kickstart the promise chain.
 * If not provided then the promise chain starts with undefined.
 * @returns A chain of resolved or rejected promises
 */
function executePromisesSequentially(promiseFactories, kickstart) {
    let result = Promise.resolve(kickstart);
    promiseFactories.forEach((promiseFactory) => {
        result = result.then(promiseFactory);
    });
    return result;
}
/**
 * Converts a Promise to a callback.
 * @param promise - The Promise to be converted to a callback
 * @returns A function that takes the callback `(cb: Function) => void`
 * @deprecated generated code should instead depend on responseToBody
 */
// eslint-disable-next-line @typescript-eslint/ban-types
function promiseToCallback(promise) {
    if (typeof promise.then !== "function") {
        throw new Error("The provided input is not a Promise.");
    }
    // eslint-disable-next-line @typescript-eslint/ban-types
    return (cb) => {
        promise
            .then((data) => {
            // eslint-disable-next-line promise/no-callback-in-promise
            return cb(undefined, data);
        })
            .catch((err) => {
            // eslint-disable-next-line promise/no-callback-in-promise
            cb(err);
        });
    };
}
/**
 * Converts a Promise to a service callback.
 * @param promise - The Promise of HttpOperationResponse to be converted to a service callback
 * @returns A function that takes the service callback (cb: ServiceCallback<T>): void
 */
function promiseToServiceCallback(promise) {
    if (typeof promise.then !== "function") {
        throw new Error("The provided input is not a Promise.");
    }
    return (cb) => {
        promise
            .then((data) => {
            return process.nextTick(cb, undefined, data.parsedBody, data.request, data);
        })
            .catch((err) => {
            process.nextTick(cb, err);
        });
    };
}
function prepareXMLRootList(obj, elementName, xmlNamespaceKey, xmlNamespace) {
    if (!Array.isArray(obj)) {
        obj = [obj];
    }
    if (!xmlNamespaceKey || !xmlNamespace) {
        return { [elementName]: obj };
    }
    const result = { [elementName]: obj };
    result[XML_ATTRKEY] = { [xmlNamespaceKey]: xmlNamespace };
    return result;
}
/**
 * Applies the properties on the prototype of sourceCtors to the prototype of targetCtor
 * @param targetCtor - The target object on which the properties need to be applied.
 * @param sourceCtors - An array of source objects from which the properties need to be taken.
 */
function applyMixins(targetCtorParam, sourceCtors) {
    const castTargetCtorParam = targetCtorParam;
    sourceCtors.forEach((sourceCtor) => {
        Object.getOwnPropertyNames(sourceCtor.prototype).forEach((name) => {
            castTargetCtorParam.prototype[name] = sourceCtor.prototype[name];
        });
    });
}
const validateISODuration = /^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;
/**
 * Indicates whether the given string is in ISO 8601 format.
 * @param value - The value to be validated for ISO 8601 duration format.
 * @returns `true` if valid, `false` otherwise.
 */
function isDuration(value) {
    return validateISODuration.test(value);
}
/**
 * Replace all of the instances of searchValue in value with the provided replaceValue.
 * @param value - The value to search and replace in.
 * @param searchValue - The value to search for in the value argument.
 * @param replaceValue - The value to replace searchValue with in the value argument.
 * @returns The value where each instance of searchValue was replaced with replacedValue.
 */
function replaceAll(value, searchValue, replaceValue) {
    return !value || !searchValue ? value : value.split(searchValue).join(replaceValue || "");
}
/**
 * Determines whether the given entity is a basic/primitive type
 * (string, number, boolean, null, undefined).
 * @param value - Any entity
 * @returns true is it is primitive type, false otherwise.
 */
function isPrimitiveType(value) {
    return (typeof value !== "object" && typeof value !== "function") || value === null;
}
function getEnvironmentValue(name) {
    if (process.env[name]) {
        return process.env[name];
    }
    else if (process.env[name.toLowerCase()]) {
        return process.env[name.toLowerCase()];
    }
    return undefined;
}
/**
 * @internal
 * @returns true when input is an object type that is not null, Array, RegExp, or Date.
 */
function isObject(input) {
    return (typeof input === "object" &&
        input !== null &&
        !Array.isArray(input) &&
        !(input instanceof RegExp) &&
        !(input instanceof Date));
}

// Copyright (c) Microsoft Corporation.
// This file contains utility code to serialize and deserialize network operations according to `OperationSpec` objects generated by AutoRest.TypeScript from OpenAPI specifications.
/**
 * Used to map raw response objects to final shapes.
 * Helps packing and unpacking Dates and other encoded types that are not intrinsic to JSON.
 * Also allows pulling values from headers, as well as inserting default values and constants.
 */
class Serializer {
    constructor(
    /**
     * The provided model mapper.
     */
    modelMappers = {}, 
    /**
     * Whether the contents are XML or not.
     */
    isXML) {
        this.modelMappers = modelMappers;
        this.isXML = isXML;
    }
    /**
     * Validates constraints, if any. This function will throw if the provided value does not respect those constraints.
     * @param mapper - The definition of data models.
     * @param value - The value.
     * @param objectName - Name of the object. Used in the error messages.
     * @deprecated Removing the constraints validation on client side.
     */
    validateConstraints(mapper, value, objectName) {
        const failValidation = (constraintName, constraintValue) => {
            throw new Error(`"${objectName}" with value "${value}" should satisfy the constraint "${constraintName}": ${constraintValue}.`);
        };
        if (mapper.constraints && value != undefined) {
            const valueAsNumber = value;
            const { ExclusiveMaximum, ExclusiveMinimum, InclusiveMaximum, InclusiveMinimum, MaxItems, MaxLength, MinItems, MinLength, MultipleOf, Pattern, UniqueItems, } = mapper.constraints;
            if (ExclusiveMaximum != undefined && valueAsNumber >= ExclusiveMaximum) {
                failValidation("ExclusiveMaximum", ExclusiveMaximum);
            }
            if (ExclusiveMinimum != undefined && valueAsNumber <= ExclusiveMinimum) {
                failValidation("ExclusiveMinimum", ExclusiveMinimum);
            }
            if (InclusiveMaximum != undefined && valueAsNumber > InclusiveMaximum) {
                failValidation("InclusiveMaximum", InclusiveMaximum);
            }
            if (InclusiveMinimum != undefined && valueAsNumber < InclusiveMinimum) {
                failValidation("InclusiveMinimum", InclusiveMinimum);
            }
            const valueAsArray = value;
            if (MaxItems != undefined && valueAsArray.length > MaxItems) {
                failValidation("MaxItems", MaxItems);
            }
            if (MaxLength != undefined && valueAsArray.length > MaxLength) {
                failValidation("MaxLength", MaxLength);
            }
            if (MinItems != undefined && valueAsArray.length < MinItems) {
                failValidation("MinItems", MinItems);
            }
            if (MinLength != undefined && valueAsArray.length < MinLength) {
                failValidation("MinLength", MinLength);
            }
            if (MultipleOf != undefined && valueAsNumber % MultipleOf !== 0) {
                failValidation("MultipleOf", MultipleOf);
            }
            if (Pattern) {
                const pattern = typeof Pattern === "string" ? new RegExp(Pattern) : Pattern;
                if (typeof value !== "string" || value.match(pattern) === null) {
                    failValidation("Pattern", Pattern);
                }
            }
            if (UniqueItems &&
                valueAsArray.some((item, i, ar) => ar.indexOf(item) !== i)) {
                failValidation("UniqueItems", UniqueItems);
            }
        }
    }
    /**
     * Serialize the given object based on its metadata defined in the mapper.
     *
     * @param mapper - The mapper which defines the metadata of the serializable object.
     * @param object - A valid Javascript object to be serialized.
     * @param objectName - Name of the serialized object.
     * @param options - additional options to deserialization.
     * @returns A valid serialized Javascript object.
     */
    serialize(mapper, object, objectName, options = {}) {
        var _a, _b, _c;
        const updatedOptions = {
            rootName: (_a = options.rootName) !== null && _a !== void 0 ? _a : "",
            includeRoot: (_b = options.includeRoot) !== null && _b !== void 0 ? _b : false,
            xmlCharKey: (_c = options.xmlCharKey) !== null && _c !== void 0 ? _c : XML_CHARKEY,
        };
        let payload = {};
        const mapperType = mapper.type.name;
        if (!objectName) {
            objectName = mapper.serializedName;
        }
        if (mapperType.match(/^Sequence$/i) !== null) {
            payload = [];
        }
        if (mapper.isConstant) {
            object = mapper.defaultValue;
        }
        // This table of allowed values should help explain
        // the mapper.required and mapper.nullable properties.
        // X means "neither undefined or null are allowed".
        //           || required
        //           || true      | false
        //  nullable || ==========================
        //      true || null      | undefined/null
        //     false || X         | undefined
        // undefined || X         | undefined/null
        const { required, nullable } = mapper;
        if (required && nullable && object === undefined) {
            throw new Error(`${objectName} cannot be undefined.`);
        }
        if (required && !nullable && object == undefined) {
            throw new Error(`${objectName} cannot be null or undefined.`);
        }
        if (!required && nullable === false && object === null) {
            throw new Error(`${objectName} cannot be null.`);
        }
        if (object == undefined) {
            payload = object;
        }
        else {
            if (mapperType.match(/^any$/i) !== null) {
                payload = object;
            }
            else if (mapperType.match(/^(Number|String|Boolean|Object|Stream|Uuid)$/i) !== null) {
                payload = serializeBasicTypes(mapperType, objectName, object);
            }
            else if (mapperType.match(/^Enum$/i) !== null) {
                const enumMapper = mapper;
                payload = serializeEnumType(objectName, enumMapper.type.allowedValues, object);
            }
            else if (mapperType.match(/^(Date|DateTime|TimeSpan|DateTimeRfc1123|UnixTime)$/i) !== null) {
                payload = serializeDateTypes(mapperType, object, objectName);
            }
            else if (mapperType.match(/^ByteArray$/i) !== null) {
                payload = serializeByteArrayType(objectName, object);
            }
            else if (mapperType.match(/^Base64Url$/i) !== null) {
                payload = serializeBase64UrlType(objectName, object);
            }
            else if (mapperType.match(/^Sequence$/i) !== null) {
                payload = serializeSequenceType(this, mapper, object, objectName, Boolean(this.isXML), updatedOptions);
            }
            else if (mapperType.match(/^Dictionary$/i) !== null) {
                payload = serializeDictionaryType(this, mapper, object, objectName, Boolean(this.isXML), updatedOptions);
            }
            else if (mapperType.match(/^Composite$/i) !== null) {
                payload = serializeCompositeType(this, mapper, object, objectName, Boolean(this.isXML), updatedOptions);
            }
        }
        return payload;
    }
    /**
     * Deserialize the given object based on its metadata defined in the mapper.
     *
     * @param mapper - The mapper which defines the metadata of the serializable object.
     * @param responseBody - A valid Javascript entity to be deserialized.
     * @param objectName - Name of the deserialized object.
     * @param options - Controls behavior of XML parser and builder.
     * @returns A valid deserialized Javascript object.
     */
    deserialize(mapper, responseBody, objectName, options = {}) {
        var _a, _b, _c;
        const updatedOptions = {
            rootName: (_a = options.rootName) !== null && _a !== void 0 ? _a : "",
            includeRoot: (_b = options.includeRoot) !== null && _b !== void 0 ? _b : false,
            xmlCharKey: (_c = options.xmlCharKey) !== null && _c !== void 0 ? _c : XML_CHARKEY,
        };
        if (responseBody == undefined) {
            if (this.isXML && mapper.type.name === "Sequence" && !mapper.xmlIsWrapped) {
                // Edge case for empty XML non-wrapped lists. xml2js can't distinguish
                // between the list being empty versus being missing,
                // so let's do the more user-friendly thing and return an empty list.
                responseBody = [];
            }
            // specifically check for undefined as default value can be a falsey value `0, "", false, null`
            if (mapper.defaultValue !== undefined) {
                responseBody = mapper.defaultValue;
            }
            return responseBody;
        }
        let payload;
        const mapperType = mapper.type.name;
        if (!objectName) {
            objectName = mapper.serializedName;
        }
        if (mapperType.match(/^Composite$/i) !== null) {
            payload = deserializeCompositeType(this, mapper, responseBody, objectName, updatedOptions);
        }
        else {
            if (this.isXML) {
                const xmlCharKey = updatedOptions.xmlCharKey;
                const castResponseBody = responseBody;
                /**
                 * If the mapper specifies this as a non-composite type value but the responseBody contains
                 * both header ("$" i.e., XML_ATTRKEY) and body ("#" i.e., XML_CHARKEY) properties,
                 * then just reduce the responseBody value to the body ("#" i.e., XML_CHARKEY) property.
                 */
                if (castResponseBody[XML_ATTRKEY] != undefined &&
                    castResponseBody[xmlCharKey] != undefined) {
                    responseBody = castResponseBody[xmlCharKey];
                }
            }
            if (mapperType.match(/^Number$/i) !== null) {
                payload = parseFloat(responseBody);
                if (isNaN(payload)) {
                    payload = responseBody;
                }
            }
            else if (mapperType.match(/^Boolean$/i) !== null) {
                if (responseBody === "true") {
                    payload = true;
                }
                else if (responseBody === "false") {
                    payload = false;
                }
                else {
                    payload = responseBody;
                }
            }
            else if (mapperType.match(/^(String|Enum|Object|Stream|Uuid|TimeSpan|any)$/i) !== null) {
                payload = responseBody;
            }
            else if (mapperType.match(/^(Date|DateTime|DateTimeRfc1123)$/i) !== null) {
                payload = new Date(responseBody);
            }
            else if (mapperType.match(/^UnixTime$/i) !== null) {
                payload = unixTimeToDate(responseBody);
            }
            else if (mapperType.match(/^ByteArray$/i) !== null) {
                payload = decodeString(responseBody);
            }
            else if (mapperType.match(/^Base64Url$/i) !== null) {
                payload = base64UrlToByteArray(responseBody);
            }
            else if (mapperType.match(/^Sequence$/i) !== null) {
                payload = deserializeSequenceType(this, mapper, responseBody, objectName, updatedOptions);
            }
            else if (mapperType.match(/^Dictionary$/i) !== null) {
                payload = deserializeDictionaryType(this, mapper, responseBody, objectName, updatedOptions);
            }
        }
        if (mapper.isConstant) {
            payload = mapper.defaultValue;
        }
        return payload;
    }
}
function trimEnd(str, ch) {
    let len = str.length;
    while (len - 1 >= 0 && str[len - 1] === ch) {
        --len;
    }
    return str.substr(0, len);
}
function bufferToBase64Url(buffer) {
    if (!buffer) {
        return undefined;
    }
    if (!(buffer instanceof Uint8Array)) {
        throw new Error(`Please provide an input of type Uint8Array for converting to Base64Url.`);
    }
    // Uint8Array to Base64.
    const str = encodeByteArray(buffer);
    // Base64 to Base64Url.
    return trimEnd(str, "=").replace(/\+/g, "-").replace(/\//g, "_");
}
function base64UrlToByteArray(str) {
    if (!str) {
        return undefined;
    }
    if (str && typeof str.valueOf() !== "string") {
        throw new Error("Please provide an input of type string for converting to Uint8Array");
    }
    // Base64Url to Base64.
    str = str.replace(/-/g, "+").replace(/_/g, "/");
    // Base64 to Uint8Array.
    return decodeString(str);
}
function splitSerializeName(prop) {
    const classes = [];
    let partialclass = "";
    if (prop) {
        const subwords = prop.split(".");
        for (const item of subwords) {
            if (item.charAt(item.length - 1) === "\\") {
                partialclass += item.substr(0, item.length - 1) + ".";
            }
            else {
                partialclass += item;
                classes.push(partialclass);
                partialclass = "";
            }
        }
    }
    return classes;
}
function dateToUnixTime(d) {
    if (!d) {
        return undefined;
    }
    if (typeof d.valueOf() === "string") {
        d = new Date(d);
    }
    return Math.floor(d.getTime() / 1000);
}
function unixTimeToDate(n) {
    if (!n) {
        return undefined;
    }
    return new Date(n * 1000);
}
function serializeBasicTypes(typeName, objectName, value) {
    if (value !== null && value !== undefined) {
        if (typeName.match(/^Number$/i) !== null) {
            if (typeof value !== "number") {
                throw new Error(`${objectName} with value ${value} must be of type number.`);
            }
        }
        else if (typeName.match(/^String$/i) !== null) {
            if (typeof value.valueOf() !== "string") {
                throw new Error(`${objectName} with value "${value}" must be of type string.`);
            }
        }
        else if (typeName.match(/^Uuid$/i) !== null) {
            if (!(typeof value.valueOf() === "string" && isValidUuid(value))) {
                throw new Error(`${objectName} with value "${value}" must be of type string and a valid uuid.`);
            }
        }
        else if (typeName.match(/^Boolean$/i) !== null) {
            if (typeof value !== "boolean") {
                throw new Error(`${objectName} with value ${value} must be of type boolean.`);
            }
        }
        else if (typeName.match(/^Stream$/i) !== null) {
            const objectType = typeof value;
            if (objectType !== "string" &&
                objectType !== "function" &&
                !(value instanceof ArrayBuffer) &&
                !ArrayBuffer.isView(value) &&
                !((typeof Blob === "function" || typeof Blob === "object") && value instanceof Blob)) {
                throw new Error(`${objectName} must be a string, Blob, ArrayBuffer, ArrayBufferView, or a function returning NodeJS.ReadableStream.`);
            }
        }
    }
    return value;
}
function serializeEnumType(objectName, allowedValues, value) {
    if (!allowedValues) {
        throw new Error(`Please provide a set of allowedValues to validate ${objectName} as an Enum Type.`);
    }
    const isPresent = allowedValues.some((item) => {
        if (typeof item.valueOf() === "string") {
            return item.toLowerCase() === value.toLowerCase();
        }
        return item === value;
    });
    if (!isPresent) {
        throw new Error(`${value} is not a valid value for ${objectName}. The valid values are: ${JSON.stringify(allowedValues)}.`);
    }
    return value;
}
function serializeByteArrayType(objectName, value) {
    let returnValue = "";
    if (value != undefined) {
        if (!(value instanceof Uint8Array)) {
            throw new Error(`${objectName} must be of type Uint8Array.`);
        }
        returnValue = encodeByteArray(value);
    }
    return returnValue;
}
function serializeBase64UrlType(objectName, value) {
    let returnValue = "";
    if (value != undefined) {
        if (!(value instanceof Uint8Array)) {
            throw new Error(`${objectName} must be of type Uint8Array.`);
        }
        returnValue = bufferToBase64Url(value) || "";
    }
    return returnValue;
}
function serializeDateTypes(typeName, value, objectName) {
    if (value != undefined) {
        if (typeName.match(/^Date$/i) !== null) {
            if (!(value instanceof Date ||
                (typeof value.valueOf() === "string" && !isNaN(Date.parse(value))))) {
                throw new Error(`${objectName} must be an instanceof Date or a string in ISO8601 format.`);
            }
            value =
                value instanceof Date
                    ? value.toISOString().substring(0, 10)
                    : new Date(value).toISOString().substring(0, 10);
        }
        else if (typeName.match(/^DateTime$/i) !== null) {
            if (!(value instanceof Date ||
                (typeof value.valueOf() === "string" && !isNaN(Date.parse(value))))) {
                throw new Error(`${objectName} must be an instanceof Date or a string in ISO8601 format.`);
            }
            value = value instanceof Date ? value.toISOString() : new Date(value).toISOString();
        }
        else if (typeName.match(/^DateTimeRfc1123$/i) !== null) {
            if (!(value instanceof Date ||
                (typeof value.valueOf() === "string" && !isNaN(Date.parse(value))))) {
                throw new Error(`${objectName} must be an instanceof Date or a string in RFC-1123 format.`);
            }
            value = value instanceof Date ? value.toUTCString() : new Date(value).toUTCString();
        }
        else if (typeName.match(/^UnixTime$/i) !== null) {
            if (!(value instanceof Date ||
                (typeof value.valueOf() === "string" && !isNaN(Date.parse(value))))) {
                throw new Error(`${objectName} must be an instanceof Date or a string in RFC-1123/ISO8601 format ` +
                    `for it to be serialized in UnixTime/Epoch format.`);
            }
            value = dateToUnixTime(value);
        }
        else if (typeName.match(/^TimeSpan$/i) !== null) {
            if (!isDuration(value)) {
                throw new Error(`${objectName} must be a string in ISO 8601 format. Instead was "${value}".`);
            }
        }
    }
    return value;
}
function serializeSequenceType(serializer, mapper, object, objectName, isXml, options) {
    if (!Array.isArray(object)) {
        throw new Error(`${objectName} must be of type Array.`);
    }
    const elementType = mapper.type.element;
    if (!elementType || typeof elementType !== "object") {
        throw new Error(`element" metadata for an Array must be defined in the ` +
            `mapper and it must of type "object" in ${objectName}.`);
    }
    const tempArray = [];
    for (let i = 0; i < object.length; i++) {
        const serializedValue = serializer.serialize(elementType, object[i], objectName, options);
        if (isXml && elementType.xmlNamespace) {
            const xmlnsKey = elementType.xmlNamespacePrefix
                ? `xmlns:${elementType.xmlNamespacePrefix}`
                : "xmlns";
            if (elementType.type.name === "Composite") {
                tempArray[i] = Object.assign({}, serializedValue);
                tempArray[i][XML_ATTRKEY] = { [xmlnsKey]: elementType.xmlNamespace };
            }
            else {
                tempArray[i] = {};
                tempArray[i][options.xmlCharKey] = serializedValue;
                tempArray[i][XML_ATTRKEY] = { [xmlnsKey]: elementType.xmlNamespace };
            }
        }
        else {
            tempArray[i] = serializedValue;
        }
    }
    return tempArray;
}
function serializeDictionaryType(serializer, mapper, object, objectName, isXml, options) {
    if (typeof object !== "object") {
        throw new Error(`${objectName} must be of type object.`);
    }
    const valueType = mapper.type.value;
    if (!valueType || typeof valueType !== "object") {
        throw new Error(`"value" metadata for a Dictionary must be defined in the ` +
            `mapper and it must of type "object" in ${objectName}.`);
    }
    const tempDictionary = {};
    for (const key of Object.keys(object)) {
        const serializedValue = serializer.serialize(valueType, object[key], objectName, options);
        // If the element needs an XML namespace we need to add it within the $ property
        tempDictionary[key] = getXmlObjectValue(valueType, serializedValue, isXml, options);
    }
    // Add the namespace to the root element if needed
    if (isXml && mapper.xmlNamespace) {
        const xmlnsKey = mapper.xmlNamespacePrefix ? `xmlns:${mapper.xmlNamespacePrefix}` : "xmlns";
        const result = tempDictionary;
        result[XML_ATTRKEY] = { [xmlnsKey]: mapper.xmlNamespace };
        return result;
    }
    return tempDictionary;
}
/**
 * Resolves the additionalProperties property from a referenced mapper.
 * @param serializer - The serializer containing the entire set of mappers.
 * @param mapper - The composite mapper to resolve.
 * @param objectName - Name of the object being serialized.
 */
function resolveAdditionalProperties(serializer, mapper, objectName) {
    const additionalProperties = mapper.type.additionalProperties;
    if (!additionalProperties && mapper.type.className) {
        const modelMapper = resolveReferencedMapper(serializer, mapper, objectName);
        return modelMapper === null || modelMapper === void 0 ? void 0 : modelMapper.type.additionalProperties;
    }
    return additionalProperties;
}
/**
 * Finds the mapper referenced by `className`.
 * @param serializer - The serializer containing the entire set of mappers
 * @param mapper - The composite mapper to resolve
 * @param objectName - Name of the object being serialized
 */
function resolveReferencedMapper(serializer, mapper, objectName) {
    const className = mapper.type.className;
    if (!className) {
        throw new Error(`Class name for model "${objectName}" is not provided in the mapper "${JSON.stringify(mapper, undefined, 2)}".`);
    }
    return serializer.modelMappers[className];
}
/**
 * Resolves a composite mapper's modelProperties.
 * @param serializer - The serializer containing the entire set of mappers
 * @param mapper - The composite mapper to resolve
 */
function resolveModelProperties(serializer, mapper, objectName) {
    let modelProps = mapper.type.modelProperties;
    if (!modelProps) {
        const modelMapper = resolveReferencedMapper(serializer, mapper, objectName);
        if (!modelMapper) {
            throw new Error(`mapper() cannot be null or undefined for model "${mapper.type.className}".`);
        }
        modelProps = modelMapper === null || modelMapper === void 0 ? void 0 : modelMapper.type.modelProperties;
        if (!modelProps) {
            throw new Error(`modelProperties cannot be null or undefined in the ` +
                `mapper "${JSON.stringify(modelMapper)}" of type "${mapper.type.className}" for object "${objectName}".`);
        }
    }
    return modelProps;
}
function serializeCompositeType(serializer, mapper, object, objectName, isXml, options) {
    if (getPolymorphicDiscriminatorRecursively(serializer, mapper)) {
        mapper = getPolymorphicMapper(serializer, mapper, object, "clientName");
    }
    if (object != undefined) {
        const payload = {};
        const modelProps = resolveModelProperties(serializer, mapper, objectName);
        for (const key of Object.keys(modelProps)) {
            const propertyMapper = modelProps[key];
            if (propertyMapper.readOnly) {
                continue;
            }
            let propName;
            let parentObject = payload;
            if (serializer.isXML) {
                if (propertyMapper.xmlIsWrapped) {
                    propName = propertyMapper.xmlName;
                }
                else {
                    propName = propertyMapper.xmlElementName || propertyMapper.xmlName;
                }
            }
            else {
                const paths = splitSerializeName(propertyMapper.serializedName);
                propName = paths.pop();
                for (const pathName of paths) {
                    const childObject = parentObject[pathName];
                    if (childObject == undefined &&
                        (object[key] != undefined || propertyMapper.defaultValue !== undefined)) {
                        parentObject[pathName] = {};
                    }
                    parentObject = parentObject[pathName];
                }
            }
            if (parentObject != undefined) {
                if (isXml && mapper.xmlNamespace) {
                    const xmlnsKey = mapper.xmlNamespacePrefix
                        ? `xmlns:${mapper.xmlNamespacePrefix}`
                        : "xmlns";
                    parentObject[XML_ATTRKEY] = Object.assign(Object.assign({}, parentObject[XML_ATTRKEY]), { [xmlnsKey]: mapper.xmlNamespace });
                }
                const propertyObjectName = propertyMapper.serializedName !== ""
                    ? objectName + "." + propertyMapper.serializedName
                    : objectName;
                let toSerialize = object[key];
                const polymorphicDiscriminator = getPolymorphicDiscriminatorRecursively(serializer, mapper);
                if (polymorphicDiscriminator &&
                    polymorphicDiscriminator.clientName === key &&
                    toSerialize == undefined) {
                    toSerialize = mapper.serializedName;
                }
                const serializedValue = serializer.serialize(propertyMapper, toSerialize, propertyObjectName, options);
                if (serializedValue !== undefined && propName != undefined) {
                    const value = getXmlObjectValue(propertyMapper, serializedValue, isXml, options);
                    if (isXml && propertyMapper.xmlIsAttribute) {
                        // XML_ATTRKEY, i.e., $ is the key attributes are kept under in xml2js.
                        // This keeps things simple while preventing name collision
                        // with names in user documents.
                        parentObject[XML_ATTRKEY] = parentObject[XML_ATTRKEY] || {};
                        parentObject[XML_ATTRKEY][propName] = serializedValue;
                    }
                    else if (isXml && propertyMapper.xmlIsWrapped) {
                        parentObject[propName] = { [propertyMapper.xmlElementName]: value };
                    }
                    else {
                        parentObject[propName] = value;
                    }
                }
            }
        }
        const additionalPropertiesMapper = resolveAdditionalProperties(serializer, mapper, objectName);
        if (additionalPropertiesMapper) {
            const propNames = Object.keys(modelProps);
            for (const clientPropName in object) {
                const isAdditionalProperty = propNames.every((pn) => pn !== clientPropName);
                if (isAdditionalProperty) {
                    payload[clientPropName] = serializer.serialize(additionalPropertiesMapper, object[clientPropName], objectName + '["' + clientPropName + '"]', options);
                }
            }
        }
        return payload;
    }
    return object;
}
function getXmlObjectValue(propertyMapper, serializedValue, isXml, options) {
    if (!isXml || !propertyMapper.xmlNamespace) {
        return serializedValue;
    }
    const xmlnsKey = propertyMapper.xmlNamespacePrefix
        ? `xmlns:${propertyMapper.xmlNamespacePrefix}`
        : "xmlns";
    const xmlNamespace = { [xmlnsKey]: propertyMapper.xmlNamespace };
    if (["Composite"].includes(propertyMapper.type.name)) {
        if (serializedValue[XML_ATTRKEY]) {
            return serializedValue;
        }
        else {
            const result = Object.assign({}, serializedValue);
            result[XML_ATTRKEY] = xmlNamespace;
            return result;
        }
    }
    const result = {};
    result[options.xmlCharKey] = serializedValue;
    result[XML_ATTRKEY] = xmlNamespace;
    return result;
}
function isSpecialXmlProperty(propertyName, options) {
    return [XML_ATTRKEY, options.xmlCharKey].includes(propertyName);
}
function deserializeCompositeType(serializer, mapper, responseBody, objectName, options) {
    var _a, _b;
    const xmlCharKey = (_a = options.xmlCharKey) !== null && _a !== void 0 ? _a : XML_CHARKEY;
    if (getPolymorphicDiscriminatorRecursively(serializer, mapper)) {
        mapper = getPolymorphicMapper(serializer, mapper, responseBody, "serializedName");
    }
    const modelProps = resolveModelProperties(serializer, mapper, objectName);
    let instance = {};
    const handledPropertyNames = [];
    for (const key of Object.keys(modelProps)) {
        const propertyMapper = modelProps[key];
        const paths = splitSerializeName(modelProps[key].serializedName);
        handledPropertyNames.push(paths[0]);
        const { serializedName, xmlName, xmlElementName } = propertyMapper;
        let propertyObjectName = objectName;
        if (serializedName !== "" && serializedName !== undefined) {
            propertyObjectName = objectName + "." + serializedName;
        }
        const headerCollectionPrefix = propertyMapper.headerCollectionPrefix;
        if (headerCollectionPrefix) {
            const dictionary = {};
            for (const headerKey of Object.keys(responseBody)) {
                if (headerKey.startsWith(headerCollectionPrefix)) {
                    dictionary[headerKey.substring(headerCollectionPrefix.length)] = serializer.deserialize(propertyMapper.type.value, responseBody[headerKey], propertyObjectName, options);
                }
                handledPropertyNames.push(headerKey);
            }
            instance[key] = dictionary;
        }
        else if (serializer.isXML) {
            if (propertyMapper.xmlIsAttribute && responseBody[XML_ATTRKEY]) {
                instance[key] = serializer.deserialize(propertyMapper, responseBody[XML_ATTRKEY][xmlName], propertyObjectName, options);
            }
            else if (propertyMapper.xmlIsMsText) {
                if (responseBody[xmlCharKey] !== undefined) {
                    instance[key] = responseBody[xmlCharKey];
                }
                else if (typeof responseBody === "string") {
                    // The special case where xml parser parses "<Name>content</Name>" into JSON of
                    //   `{ name: "content"}` instead of `{ name: { "_": "content" }}`
                    instance[key] = responseBody;
                }
            }
            else {
                const propertyName = xmlElementName || xmlName || serializedName;
                if (propertyMapper.xmlIsWrapped) {
                    /* a list of <xmlElementName> wrapped by <xmlName>
                      For the xml example below
                        <Cors>
                          <CorsRule>...</CorsRule>
                          <CorsRule>...</CorsRule>
                        </Cors>
                      the responseBody has
                        {
                          Cors: {
                            CorsRule: [{...}, {...}]
                          }
                        }
                      xmlName is "Cors" and xmlElementName is"CorsRule".
                    */
                    const wrapped = responseBody[xmlName];
                    const elementList = (_b = wrapped === null || wrapped === void 0 ? void 0 : wrapped[xmlElementName]) !== null && _b !== void 0 ? _b : [];
                    instance[key] = serializer.deserialize(propertyMapper, elementList, propertyObjectName, options);
                    handledPropertyNames.push(xmlName);
                }
                else {
                    const property = responseBody[propertyName];
                    instance[key] = serializer.deserialize(propertyMapper, property, propertyObjectName, options);
                    handledPropertyNames.push(propertyName);
                }
            }
        }
        else {
            // deserialize the property if it is present in the provided responseBody instance
            let propertyInstance;
            let res = responseBody;
            // traversing the object step by step.
            for (const item of paths) {
                if (!res)
                    break;
                res = res[item];
            }
            propertyInstance = res;
            const polymorphicDiscriminator = mapper.type.polymorphicDiscriminator;
            // checking that the model property name (key)(ex: "fishtype") and the
            // clientName of the polymorphicDiscriminator {metadata} (ex: "fishtype")
            // instead of the serializedName of the polymorphicDiscriminator (ex: "fish.type")
            // is a better approach. The generator is not consistent with escaping '\.' in the
            // serializedName of the property (ex: "fish\.type") that is marked as polymorphic discriminator
            // and the serializedName of the metadata polymorphicDiscriminator (ex: "fish.type"). However,
            // the clientName transformation of the polymorphicDiscriminator (ex: "fishtype") and
            // the transformation of model property name (ex: "fishtype") is done consistently.
            // Hence, it is a safer bet to rely on the clientName of the polymorphicDiscriminator.
            if (polymorphicDiscriminator &&
                key === polymorphicDiscriminator.clientName &&
                propertyInstance == undefined) {
                propertyInstance = mapper.serializedName;
            }
            let serializedValue;
            // paging
            if (Array.isArray(responseBody[key]) && modelProps[key].serializedName === "") {
                propertyInstance = responseBody[key];
                const arrayInstance = serializer.deserialize(propertyMapper, propertyInstance, propertyObjectName, options);
                // Copy over any properties that have already been added into the instance, where they do
                // not exist on the newly de-serialized array
                for (const [k, v] of Object.entries(instance)) {
                    if (!Object.prototype.hasOwnProperty.call(arrayInstance, k)) {
                        arrayInstance[k] = v;
                    }
                }
                instance = arrayInstance;
            }
            else if (propertyInstance !== undefined || propertyMapper.defaultValue !== undefined) {
                serializedValue = serializer.deserialize(propertyMapper, propertyInstance, propertyObjectName, options);
                instance[key] = serializedValue;
            }
        }
    }
    const additionalPropertiesMapper = mapper.type.additionalProperties;
    if (additionalPropertiesMapper) {
        const isAdditionalProperty = (responsePropName) => {
            for (const clientPropName in modelProps) {
                const paths = splitSerializeName(modelProps[clientPropName].serializedName);
                if (paths[0] === responsePropName) {
                    return false;
                }
            }
            return true;
        };
        for (const responsePropName in responseBody) {
            if (isAdditionalProperty(responsePropName)) {
                instance[responsePropName] = serializer.deserialize(additionalPropertiesMapper, responseBody[responsePropName], objectName + '["' + responsePropName + '"]', options);
            }
        }
    }
    else if (responseBody) {
        for (const key of Object.keys(responseBody)) {
            if (instance[key] === undefined &&
                !handledPropertyNames.includes(key) &&
                !isSpecialXmlProperty(key, options)) {
                instance[key] = responseBody[key];
            }
        }
    }
    return instance;
}
function deserializeDictionaryType(serializer, mapper, responseBody, objectName, options) {
    const value = mapper.type.value;
    if (!value || typeof value !== "object") {
        throw new Error(`"value" metadata for a Dictionary must be defined in the ` +
            `mapper and it must of type "object" in ${objectName}`);
    }
    if (responseBody) {
        const tempDictionary = {};
        for (const key of Object.keys(responseBody)) {
            tempDictionary[key] = serializer.deserialize(value, responseBody[key], objectName, options);
        }
        return tempDictionary;
    }
    return responseBody;
}
function deserializeSequenceType(serializer, mapper, responseBody, objectName, options) {
    const element = mapper.type.element;
    if (!element || typeof element !== "object") {
        throw new Error(`element" metadata for an Array must be defined in the ` +
            `mapper and it must of type "object" in ${objectName}`);
    }
    if (responseBody) {
        if (!Array.isArray(responseBody)) {
            // xml2js will interpret a single element array as just the element, so force it to be an array
            responseBody = [responseBody];
        }
        const tempArray = [];
        for (let i = 0; i < responseBody.length; i++) {
            tempArray[i] = serializer.deserialize(element, responseBody[i], `${objectName}[${i}]`, options);
        }
        return tempArray;
    }
    return responseBody;
}
function getPolymorphicMapper(serializer, mapper, object, polymorphicPropertyName) {
    const polymorphicDiscriminator = getPolymorphicDiscriminatorRecursively(serializer, mapper);
    if (polymorphicDiscriminator) {
        const discriminatorName = polymorphicDiscriminator[polymorphicPropertyName];
        if (discriminatorName != undefined) {
            const discriminatorValue = object[discriminatorName];
            if (discriminatorValue != undefined) {
                const typeName = mapper.type.uberParent || mapper.type.className;
                const indexDiscriminator = discriminatorValue === typeName
                    ? discriminatorValue
                    : typeName + "." + discriminatorValue;
                const polymorphicMapper = serializer.modelMappers.discriminators[indexDiscriminator];
                if (polymorphicMapper) {
                    mapper = polymorphicMapper;
                }
            }
        }
    }
    return mapper;
}
function getPolymorphicDiscriminatorRecursively(serializer, mapper) {
    return (mapper.type.polymorphicDiscriminator ||
        getPolymorphicDiscriminatorSafely(serializer, mapper.type.uberParent) ||
        getPolymorphicDiscriminatorSafely(serializer, mapper.type.className));
}
function getPolymorphicDiscriminatorSafely(serializer, typeName) {
    return (typeName &&
        serializer.modelMappers[typeName] &&
        serializer.modelMappers[typeName].type.polymorphicDiscriminator);
}
/**
 * Utility function that serializes an object that might contain binary information into a plain object, array or a string.
 */
function serializeObject(toSerialize) {
    const castToSerialize = toSerialize;
    if (toSerialize == undefined)
        return undefined;
    if (toSerialize instanceof Uint8Array) {
        toSerialize = encodeByteArray(toSerialize);
        return toSerialize;
    }
    else if (toSerialize instanceof Date) {
        return toSerialize.toISOString();
    }
    else if (Array.isArray(toSerialize)) {
        const array = [];
        for (let i = 0; i < toSerialize.length; i++) {
            array.push(serializeObject(toSerialize[i]));
        }
        return array;
    }
    else if (typeof toSerialize === "object") {
        const dictionary = {};
        for (const property in toSerialize) {
            dictionary[property] = serializeObject(castToSerialize[property]);
        }
        return dictionary;
    }
    return toSerialize;
}
/**
 * Utility function to create a K:V from a list of strings
 */
function strEnum(o) {
    const result = {};
    for (const key of o) {
        result[key] = key;
    }
    return result;
}
/**
 * String enum containing the string types of property mappers.
 */
// eslint-disable-next-line @typescript-eslint/no-redeclare
const MapperType = strEnum([
    "Base64Url",
    "Boolean",
    "ByteArray",
    "Composite",
    "Date",
    "DateTime",
    "DateTimeRfc1123",
    "Dictionary",
    "Enum",
    "Number",
    "Object",
    "Sequence",
    "String",
    "Stream",
    "TimeSpan",
    "UnixTime",
]);

// Copyright (c) Microsoft Corporation.
function isWebResourceLike(object) {
    if (object && typeof object === "object") {
        const castObject = object;
        if (typeof castObject.url === "string" &&
            typeof castObject.method === "string" &&
            typeof castObject.headers === "object" &&
            isHttpHeadersLike(castObject.headers) &&
            typeof castObject.validateRequestProperties === "function" &&
            typeof castObject.prepare === "function" &&
            typeof castObject.clone === "function") {
            return true;
        }
    }
    return false;
}
/**
 * Creates a new WebResource object.
 *
 * This class provides an abstraction over a REST call by being library / implementation agnostic and wrapping the necessary
 * properties to initiate a request.
 */
class WebResource {
    constructor(url, method, body, query, headers, streamResponseBody, withCredentials, abortSignal, timeout, onUploadProgress, onDownloadProgress, proxySettings, keepAlive, decompressResponse, streamResponseStatusCodes) {
        this.streamResponseBody = streamResponseBody;
        this.streamResponseStatusCodes = streamResponseStatusCodes;
        this.url = url || "";
        this.method = method || "GET";
        this.headers = isHttpHeadersLike(headers) ? headers : new HttpHeaders(headers);
        this.body = body;
        this.query = query;
        this.formData = undefined;
        this.withCredentials = withCredentials || false;
        this.abortSignal = abortSignal;
        this.timeout = timeout || 0;
        this.onUploadProgress = onUploadProgress;
        this.onDownloadProgress = onDownloadProgress;
        this.proxySettings = proxySettings;
        this.keepAlive = keepAlive;
        this.decompressResponse = decompressResponse;
        this.requestId = this.headers.get("x-ms-client-request-id") || generateUuid();
    }
    /**
     * Validates that the required properties such as method, url, headers["Content-Type"],
     * headers["accept-language"] are defined. It will throw an error if one of the above
     * mentioned properties are not defined.
     */
    validateRequestProperties() {
        if (!this.method) {
            throw new Error("WebResource.method is required.");
        }
        if (!this.url) {
            throw new Error("WebResource.url is required.");
        }
    }
    /**
     * Prepares the request.
     * @param options - Options to provide for preparing the request.
     * @returns Returns the prepared WebResource (HTTP Request) object that needs to be given to the request pipeline.
     */
    prepare(options) {
        if (!options) {
            throw new Error("options object is required");
        }
        if (options.method === undefined ||
            options.method === null ||
            typeof options.method.valueOf() !== "string") {
            throw new Error("options.method must be a string.");
        }
        if (options.url && options.pathTemplate) {
            throw new Error("options.url and options.pathTemplate are mutually exclusive. Please provide exactly one of them.");
        }
        if ((options.pathTemplate === undefined ||
            options.pathTemplate === null ||
            typeof options.pathTemplate.valueOf() !== "string") &&
            (options.url === undefined ||
                options.url === null ||
                typeof options.url.valueOf() !== "string")) {
            throw new Error("Please provide exactly one of options.pathTemplate or options.url.");
        }
        // set the url if it is provided.
        if (options.url) {
            if (typeof options.url !== "string") {
                throw new Error('options.url must be of type "string".');
            }
            this.url = options.url;
        }
        // set the method
        if (options.method) {
            const validMethods = ["GET", "PUT", "HEAD", "DELETE", "OPTIONS", "POST", "PATCH", "TRACE"];
            if (validMethods.indexOf(options.method.toUpperCase()) === -1) {
                throw new Error('The provided method "' +
                    options.method +
                    '" is invalid. Supported HTTP methods are: ' +
                    JSON.stringify(validMethods));
            }
        }
        this.method = options.method.toUpperCase();
        // construct the url if path template is provided
        if (options.pathTemplate) {
            const { pathTemplate, pathParameters } = options;
            if (typeof pathTemplate !== "string") {
                throw new Error('options.pathTemplate must be of type "string".');
            }
            if (!options.baseUrl) {
                options.baseUrl = "https://management.azure.com";
            }
            const baseUrl = options.baseUrl;
            let url = baseUrl +
                (baseUrl.endsWith("/") ? "" : "/") +
                (pathTemplate.startsWith("/") ? pathTemplate.slice(1) : pathTemplate);
            const segments = url.match(/({[\w-]*\s*[\w-]*})/gi);
            if (segments && segments.length) {
                if (!pathParameters) {
                    throw new Error(`pathTemplate: ${pathTemplate} has been provided. Hence, options.pathParameters must also be provided.`);
                }
                segments.forEach(function (item) {
                    const pathParamName = item.slice(1, -1);
                    const pathParam = pathParameters[pathParamName];
                    if (pathParam === null ||
                        pathParam === undefined ||
                        !(typeof pathParam === "string" || typeof pathParam === "object")) {
                        const stringifiedPathParameters = JSON.stringify(pathParameters, undefined, 2);
                        throw new Error(`pathTemplate: ${pathTemplate} contains the path parameter ${pathParamName}` +
                            ` however, it is not present in parameters: ${stringifiedPathParameters}.` +
                            `The value of the path parameter can either be a "string" of the form { ${pathParamName}: "some sample value" } or ` +
                            `it can be an "object" of the form { "${pathParamName}": { value: "some sample value", skipUrlEncoding: true } }.`);
                    }
                    if (typeof pathParam.valueOf() === "string") {
                        url = url.replace(item, encodeURIComponent(pathParam));
                    }
                    if (typeof pathParam.valueOf() === "object") {
                        if (!pathParam.value) {
                            throw new Error(`options.pathParameters[${pathParamName}] is of type "object" but it does not contain a "value" property.`);
                        }
                        if (pathParam.skipUrlEncoding) {
                            url = url.replace(item, pathParam.value);
                        }
                        else {
                            url = url.replace(item, encodeURIComponent(pathParam.value));
                        }
                    }
                });
            }
            this.url = url;
        }
        // append query parameters to the url if they are provided. They can be provided with pathTemplate or url option.
        if (options.queryParameters) {
            const queryParameters = options.queryParameters;
            if (typeof queryParameters !== "object") {
                throw new Error(`options.queryParameters must be of type object. It should be a JSON object ` +
                    `of "query-parameter-name" as the key and the "query-parameter-value" as the value. ` +
                    `The "query-parameter-value" may be fo type "string" or an "object" of the form { value: "query-parameter-value", skipUrlEncoding: true }.`);
            }
            // append question mark if it is not present in the url
            if (this.url && this.url.indexOf("?") === -1) {
                this.url += "?";
            }
            // construct queryString
            const queryParams = [];
            // We need to populate this.query as a dictionary if the request is being used for Sway's validateRequest().
            this.query = {};
            for (const queryParamName in queryParameters) {
                const queryParam = queryParameters[queryParamName];
                if (queryParam) {
                    if (typeof queryParam === "string") {
                        queryParams.push(queryParamName + "=" + encodeURIComponent(queryParam));
                        this.query[queryParamName] = encodeURIComponent(queryParam);
                    }
                    else if (typeof queryParam === "object") {
                        if (!queryParam.value) {
                            throw new Error(`options.queryParameters[${queryParamName}] is of type "object" but it does not contain a "value" property.`);
                        }
                        if (queryParam.skipUrlEncoding) {
                            queryParams.push(queryParamName + "=" + queryParam.value);
                            this.query[queryParamName] = queryParam.value;
                        }
                        else {
                            queryParams.push(queryParamName + "=" + encodeURIComponent(queryParam.value));
                            this.query[queryParamName] = encodeURIComponent(queryParam.value);
                        }
                    }
                }
            } // end-of-for
            // append the queryString
            this.url += queryParams.join("&");
        }
        // add headers to the request if they are provided
        if (options.headers) {
            const headers = options.headers;
            for (const headerName of Object.keys(options.headers)) {
                this.headers.set(headerName, headers[headerName]);
            }
        }
        // ensure accept-language is set correctly
        if (!this.headers.get("accept-language")) {
            this.headers.set("accept-language", "en-US");
        }
        // ensure the request-id is set correctly
        if (!this.headers.get("x-ms-client-request-id") && !options.disableClientRequestId) {
            this.headers.set("x-ms-client-request-id", this.requestId);
        }
        // default
        if (!this.headers.get("Content-Type")) {
            this.headers.set("Content-Type", "application/json; charset=utf-8");
        }
        // set the request body. request.js automatically sets the Content-Length request header, so we need not set it explicitly
        this.body = options.body;
        if (options.body !== undefined && options.body !== null) {
            // body as a stream special case. set the body as-is and check for some special request headers specific to sending a stream.
            if (options.bodyIsStream) {
                if (!this.headers.get("Transfer-Encoding")) {
                    this.headers.set("Transfer-Encoding", "chunked");
                }
                if (this.headers.get("Content-Type") !== "application/octet-stream") {
                    this.headers.set("Content-Type", "application/octet-stream");
                }
            }
            else {
                if (options.serializationMapper) {
                    this.body = new Serializer(options.mappers).serialize(options.serializationMapper, options.body, "requestBody");
                }
                if (!options.disableJsonStringifyOnBody) {
                    this.body = JSON.stringify(options.body);
                }
            }
        }
        if (options.spanOptions) {
            this.spanOptions = options.spanOptions;
        }
        if (options.tracingContext) {
            this.tracingContext = options.tracingContext;
        }
        this.abortSignal = options.abortSignal;
        this.onDownloadProgress = options.onDownloadProgress;
        this.onUploadProgress = options.onUploadProgress;
        return this;
    }
    /**
     * Clone this WebResource HTTP request object.
     * @returns The clone of this WebResource HTTP request object.
     */
    clone() {
        const result = new WebResource(this.url, this.method, this.body, this.query, this.headers && this.headers.clone(), this.streamResponseBody, this.withCredentials, this.abortSignal, this.timeout, this.onUploadProgress, this.onDownloadProgress, this.proxySettings, this.keepAlive, this.decompressResponse, this.streamResponseStatusCodes);
        if (this.formData) {
            result.formData = this.formData;
        }
        if (this.operationSpec) {
            result.operationSpec = this.operationSpec;
        }
        if (this.shouldDeserialize) {
            result.shouldDeserialize = this.shouldDeserialize;
        }
        if (this.operationResponseGetter) {
            result.operationResponseGetter = this.operationResponseGetter;
        }
        return result;
    }
}

// Copyright (c) Microsoft Corporation.
/**
 * A class that handles the query portion of a URLBuilder.
 */
class URLQuery {
    constructor() {
        this._rawQuery = {};
    }
    /**
     * Get whether or not there any query parameters in this URLQuery.
     */
    any() {
        return Object.keys(this._rawQuery).length > 0;
    }
    /**
     * Get the keys of the query string.
     */
    keys() {
        return Object.keys(this._rawQuery);
    }
    /**
     * Set a query parameter with the provided name and value. If the parameterValue is undefined or
     * empty, then this will attempt to remove an existing query parameter with the provided
     * parameterName.
     */
    set(parameterName, parameterValue) {
        const caseParameterValue = parameterValue;
        if (parameterName) {
            if (caseParameterValue !== undefined && caseParameterValue !== null) {
                const newValue = Array.isArray(caseParameterValue)
                    ? caseParameterValue
                    : caseParameterValue.toString();
                this._rawQuery[parameterName] = newValue;
            }
            else {
                delete this._rawQuery[parameterName];
            }
        }
    }
    /**
     * Get the value of the query parameter with the provided name. If no parameter exists with the
     * provided parameter name, then undefined will be returned.
     */
    get(parameterName) {
        return parameterName ? this._rawQuery[parameterName] : undefined;
    }
    /**
     * Get the string representation of this query. The return value will not start with a "?".
     */
    toString() {
        let result = "";
        for (const parameterName in this._rawQuery) {
            if (result) {
                result += "&";
            }
            const parameterValue = this._rawQuery[parameterName];
            if (Array.isArray(parameterValue)) {
                const parameterStrings = [];
                for (const parameterValueElement of parameterValue) {
                    parameterStrings.push(`${parameterName}=${parameterValueElement}`);
                }
                result += parameterStrings.join("&");
            }
            else {
                result += `${parameterName}=${parameterValue}`;
            }
        }
        return result;
    }
    /**
     * Parse a URLQuery from the provided text.
     */
    static parse(text) {
        const result = new URLQuery();
        if (text) {
            if (text.startsWith("?")) {
                text = text.substring(1);
            }
            let currentState = "ParameterName";
            let parameterName = "";
            let parameterValue = "";
            for (let i = 0; i < text.length; ++i) {
                const currentCharacter = text[i];
                switch (currentState) {
                    case "ParameterName":
                        switch (currentCharacter) {
                            case "=":
                                currentState = "ParameterValue";
                                break;
                            case "&":
                                parameterName = "";
                                parameterValue = "";
                                break;
                            default:
                                parameterName += currentCharacter;
                                break;
                        }
                        break;
                    case "ParameterValue":
                        switch (currentCharacter) {
                            case "&":
                                result.set(parameterName, parameterValue);
                                parameterName = "";
                                parameterValue = "";
                                currentState = "ParameterName";
                                break;
                            default:
                                parameterValue += currentCharacter;
                                break;
                        }
                        break;
                    default:
                        throw new Error("Unrecognized URLQuery parse state: " + currentState);
                }
            }
            if (currentState === "ParameterValue") {
                result.set(parameterName, parameterValue);
            }
        }
        return result;
    }
}
/**
 * A class that handles creating, modifying, and parsing URLs.
 */
class URLBuilder {
    /**
     * Set the scheme/protocol for this URL. If the provided scheme contains other parts of a URL
     * (such as a host, port, path, or query), those parts will be added to this URL as well.
     */
    setScheme(scheme) {
        if (!scheme) {
            this._scheme = undefined;
        }
        else {
            this.set(scheme, "SCHEME");
        }
    }
    /**
     * Get the scheme that has been set in this URL.
     */
    getScheme() {
        return this._scheme;
    }
    /**
     * Set the host for this URL. If the provided host contains other parts of a URL (such as a
     * port, path, or query), those parts will be added to this URL as well.
     */
    setHost(host) {
        if (!host) {
            this._host = undefined;
        }
        else {
            this.set(host, "SCHEME_OR_HOST");
        }
    }
    /**
     * Get the host that has been set in this URL.
     */
    getHost() {
        return this._host;
    }
    /**
     * Set the port for this URL. If the provided port contains other parts of a URL (such as a
     * path or query), those parts will be added to this URL as well.
     */
    setPort(port) {
        if (port === undefined || port === null || port === "") {
            this._port = undefined;
        }
        else {
            this.set(port.toString(), "PORT");
        }
    }
    /**
     * Get the port that has been set in this URL.
     */
    getPort() {
        return this._port;
    }
    /**
     * Set the path for this URL. If the provided path contains a query, then it will be added to
     * this URL as well.
     */
    setPath(path) {
        if (!path) {
            this._path = undefined;
        }
        else {
            const schemeIndex = path.indexOf("://");
            if (schemeIndex !== -1) {
                const schemeStart = path.lastIndexOf("/", schemeIndex);
                // Make sure to only grab the URL part of the path before setting the state back to SCHEME
                // this will handle cases such as "/a/b/c/https://microsoft.com" => "https://microsoft.com"
                this.set(schemeStart === -1 ? path : path.substr(schemeStart + 1), "SCHEME");
            }
            else {
                this.set(path, "PATH");
            }
        }
    }
    /**
     * Append the provided path to this URL's existing path. If the provided path contains a query,
     * then it will be added to this URL as well.
     */
    appendPath(path) {
        if (path) {
            let currentPath = this.getPath();
            if (currentPath) {
                if (!currentPath.endsWith("/")) {
                    currentPath += "/";
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                path = currentPath + path;
            }
            this.set(path, "PATH");
        }
    }
    /**
     * Get the path that has been set in this URL.
     */
    getPath() {
        return this._path;
    }
    /**
     * Set the query in this URL.
     */
    setQuery(query) {
        if (!query) {
            this._query = undefined;
        }
        else {
            this._query = URLQuery.parse(query);
        }
    }
    /**
     * Set a query parameter with the provided name and value in this URL's query. If the provided
     * query parameter value is undefined or empty, then the query parameter will be removed if it
     * existed.
     */
    setQueryParameter(queryParameterName, queryParameterValue) {
        if (queryParameterName) {
            if (!this._query) {
                this._query = new URLQuery();
            }
            this._query.set(queryParameterName, queryParameterValue);
        }
    }
    /**
     * Get the value of the query parameter with the provided query parameter name. If no query
     * parameter exists with the provided name, then undefined will be returned.
     */
    getQueryParameterValue(queryParameterName) {
        return this._query ? this._query.get(queryParameterName) : undefined;
    }
    /**
     * Get the query in this URL.
     */
    getQuery() {
        return this._query ? this._query.toString() : undefined;
    }
    /**
     * Set the parts of this URL by parsing the provided text using the provided startState.
     */
    set(text, startState) {
        const tokenizer = new URLTokenizer(text, startState);
        while (tokenizer.next()) {
            const token = tokenizer.current();
            let tokenPath;
            if (token) {
                switch (token.type) {
                    case "SCHEME":
                        this._scheme = token.text || undefined;
                        break;
                    case "HOST":
                        this._host = token.text || undefined;
                        break;
                    case "PORT":
                        this._port = token.text || undefined;
                        break;
                    case "PATH":
                        tokenPath = token.text || undefined;
                        if (!this._path || this._path === "/" || tokenPath !== "/") {
                            this._path = tokenPath;
                        }
                        break;
                    case "QUERY":
                        this._query = URLQuery.parse(token.text);
                        break;
                    default:
                        throw new Error(`Unrecognized URLTokenType: ${token.type}`);
                }
            }
        }
    }
    /**
     * Serializes the URL as a string.
     * @returns the URL as a string.
     */
    toString() {
        let result = "";
        if (this._scheme) {
            result += `${this._scheme}://`;
        }
        if (this._host) {
            result += this._host;
        }
        if (this._port) {
            result += `:${this._port}`;
        }
        if (this._path) {
            if (!this._path.startsWith("/")) {
                result += "/";
            }
            result += this._path;
        }
        if (this._query && this._query.any()) {
            result += `?${this._query.toString()}`;
        }
        return result;
    }
    /**
     * If the provided searchValue is found in this URLBuilder, then replace it with the provided
     * replaceValue.
     */
    replaceAll(searchValue, replaceValue) {
        if (searchValue) {
            this.setScheme(replaceAll(this.getScheme(), searchValue, replaceValue));
            this.setHost(replaceAll(this.getHost(), searchValue, replaceValue));
            this.setPort(replaceAll(this.getPort(), searchValue, replaceValue));
            this.setPath(replaceAll(this.getPath(), searchValue, replaceValue));
            this.setQuery(replaceAll(this.getQuery(), searchValue, replaceValue));
        }
    }
    /**
     * Parses a given string URL into a new {@link URLBuilder}.
     */
    static parse(text) {
        const result = new URLBuilder();
        result.set(text, "SCHEME_OR_HOST");
        return result;
    }
}
class URLToken {
    constructor(text, type) {
        this.text = text;
        this.type = type;
    }
    static scheme(text) {
        return new URLToken(text, "SCHEME");
    }
    static host(text) {
        return new URLToken(text, "HOST");
    }
    static port(text) {
        return new URLToken(text, "PORT");
    }
    static path(text) {
        return new URLToken(text, "PATH");
    }
    static query(text) {
        return new URLToken(text, "QUERY");
    }
}
/**
 * Get whether or not the provided character (single character string) is an alphanumeric (letter or
 * digit) character.
 */
function isAlphaNumericCharacter(character) {
    const characterCode = character.charCodeAt(0);
    return ((48 /* '0' */ <= characterCode && characterCode <= 57) /* '9' */ ||
        (65 /* 'A' */ <= characterCode && characterCode <= 90) /* 'Z' */ ||
        (97 /* 'a' */ <= characterCode && characterCode <= 122) /* 'z' */);
}
/**
 * A class that tokenizes URL strings.
 */
class URLTokenizer {
    constructor(_text, state) {
        this._text = _text;
        this._textLength = _text ? _text.length : 0;
        this._currentState = state !== undefined && state !== null ? state : "SCHEME_OR_HOST";
        this._currentIndex = 0;
    }
    /**
     * Get the current URLToken this URLTokenizer is pointing at, or undefined if the URLTokenizer
     * hasn't started or has finished tokenizing.
     */
    current() {
        return this._currentToken;
    }
    /**
     * Advance to the next URLToken and return whether or not a URLToken was found.
     */
    next() {
        if (!hasCurrentCharacter(this)) {
            this._currentToken = undefined;
        }
        else {
            switch (this._currentState) {
                case "SCHEME":
                    nextScheme(this);
                    break;
                case "SCHEME_OR_HOST":
                    nextSchemeOrHost(this);
                    break;
                case "HOST":
                    nextHost(this);
                    break;
                case "PORT":
                    nextPort(this);
                    break;
                case "PATH":
                    nextPath(this);
                    break;
                case "QUERY":
                    nextQuery(this);
                    break;
                default:
                    throw new Error(`Unrecognized URLTokenizerState: ${this._currentState}`);
            }
        }
        return !!this._currentToken;
    }
}
/**
 * Read the remaining characters from this Tokenizer's character stream.
 */
function readRemaining(tokenizer) {
    let result = "";
    if (tokenizer._currentIndex < tokenizer._textLength) {
        result = tokenizer._text.substring(tokenizer._currentIndex);
        tokenizer._currentIndex = tokenizer._textLength;
    }
    return result;
}
/**
 * Whether or not this URLTokenizer has a current character.
 */
function hasCurrentCharacter(tokenizer) {
    return tokenizer._currentIndex < tokenizer._textLength;
}
/**
 * Get the character in the text string at the current index.
 */
function getCurrentCharacter(tokenizer) {
    return tokenizer._text[tokenizer._currentIndex];
}
/**
 * Advance to the character in text that is "step" characters ahead. If no step value is provided,
 * then step will default to 1.
 */
function nextCharacter(tokenizer, step) {
    if (hasCurrentCharacter(tokenizer)) {
        if (!step) {
            step = 1;
        }
        tokenizer._currentIndex += step;
    }
}
/**
 * Starting with the current character, peek "charactersToPeek" number of characters ahead in this
 * Tokenizer's stream of characters.
 */
function peekCharacters(tokenizer, charactersToPeek) {
    let endIndex = tokenizer._currentIndex + charactersToPeek;
    if (tokenizer._textLength < endIndex) {
        endIndex = tokenizer._textLength;
    }
    return tokenizer._text.substring(tokenizer._currentIndex, endIndex);
}
/**
 * Read characters from this Tokenizer until the end of the stream or until the provided condition
 * is false when provided the current character.
 */
function readWhile(tokenizer, condition) {
    let result = "";
    while (hasCurrentCharacter(tokenizer)) {
        const currentCharacter = getCurrentCharacter(tokenizer);
        if (!condition(currentCharacter)) {
            break;
        }
        else {
            result += currentCharacter;
            nextCharacter(tokenizer);
        }
    }
    return result;
}
/**
 * Read characters from this Tokenizer until a non-alphanumeric character or the end of the
 * character stream is reached.
 */
function readWhileLetterOrDigit(tokenizer) {
    return readWhile(tokenizer, (character) => isAlphaNumericCharacter(character));
}
/**
 * Read characters from this Tokenizer until one of the provided terminating characters is read or
 * the end of the character stream is reached.
 */
function readUntilCharacter(tokenizer, ...terminatingCharacters) {
    return readWhile(tokenizer, (character) => terminatingCharacters.indexOf(character) === -1);
}
function nextScheme(tokenizer) {
    const scheme = readWhileLetterOrDigit(tokenizer);
    tokenizer._currentToken = URLToken.scheme(scheme);
    if (!hasCurrentCharacter(tokenizer)) {
        tokenizer._currentState = "DONE";
    }
    else {
        tokenizer._currentState = "HOST";
    }
}
function nextSchemeOrHost(tokenizer) {
    const schemeOrHost = readUntilCharacter(tokenizer, ":", "/", "?");
    if (!hasCurrentCharacter(tokenizer)) {
        tokenizer._currentToken = URLToken.host(schemeOrHost);
        tokenizer._currentState = "DONE";
    }
    else if (getCurrentCharacter(tokenizer) === ":") {
        if (peekCharacters(tokenizer, 3) === "://") {
            tokenizer._currentToken = URLToken.scheme(schemeOrHost);
            tokenizer._currentState = "HOST";
        }
        else {
            tokenizer._currentToken = URLToken.host(schemeOrHost);
            tokenizer._currentState = "PORT";
        }
    }
    else {
        tokenizer._currentToken = URLToken.host(schemeOrHost);
        if (getCurrentCharacter(tokenizer) === "/") {
            tokenizer._currentState = "PATH";
        }
        else {
            tokenizer._currentState = "QUERY";
        }
    }
}
function nextHost(tokenizer) {
    if (peekCharacters(tokenizer, 3) === "://") {
        nextCharacter(tokenizer, 3);
    }
    const host = readUntilCharacter(tokenizer, ":", "/", "?");
    tokenizer._currentToken = URLToken.host(host);
    if (!hasCurrentCharacter(tokenizer)) {
        tokenizer._currentState = "DONE";
    }
    else if (getCurrentCharacter(tokenizer) === ":") {
        tokenizer._currentState = "PORT";
    }
    else if (getCurrentCharacter(tokenizer) === "/") {
        tokenizer._currentState = "PATH";
    }
    else {
        tokenizer._currentState = "QUERY";
    }
}
function nextPort(tokenizer) {
    if (getCurrentCharacter(tokenizer) === ":") {
        nextCharacter(tokenizer);
    }
    const port = readUntilCharacter(tokenizer, "/", "?");
    tokenizer._currentToken = URLToken.port(port);
    if (!hasCurrentCharacter(tokenizer)) {
        tokenizer._currentState = "DONE";
    }
    else if (getCurrentCharacter(tokenizer) === "/") {
        tokenizer._currentState = "PATH";
    }
    else {
        tokenizer._currentState = "QUERY";
    }
}
function nextPath(tokenizer) {
    const path = readUntilCharacter(tokenizer, "?");
    tokenizer._currentToken = URLToken.path(path);
    if (!hasCurrentCharacter(tokenizer)) {
        tokenizer._currentState = "DONE";
    }
    else {
        tokenizer._currentState = "QUERY";
    }
}
function nextQuery(tokenizer) {
    if (getCurrentCharacter(tokenizer) === "?") {
        nextCharacter(tokenizer);
    }
    const query = readRemaining(tokenizer);
    tokenizer._currentToken = URLToken.query(query);
    tokenizer._currentState = "DONE";
}

// Copyright (c) Microsoft Corporation.
function createProxyAgent(requestUrl, proxySettings, headers) {
    const host = URLBuilder.parse(proxySettings.host).getHost();
    if (!host) {
        throw new Error("Expecting a non-empty host in proxy settings.");
    }
    if (!isValidPort(proxySettings.port)) {
        throw new Error("Expecting a valid port number in the range of [0, 65535] in proxy settings.");
    }
    const tunnelOptions = {
        proxy: {
            host: host,
            port: proxySettings.port,
            headers: (headers && headers.rawHeaders()) || {},
        },
    };
    if (proxySettings.username && proxySettings.password) {
        tunnelOptions.proxy.proxyAuth = `${proxySettings.username}:${proxySettings.password}`;
    }
    else if (proxySettings.username) {
        tunnelOptions.proxy.proxyAuth = `${proxySettings.username}`;
    }
    const isRequestHttps = isUrlHttps(requestUrl);
    const isProxyHttps = isUrlHttps(proxySettings.host);
    const proxyAgent = {
        isHttps: isRequestHttps,
        agent: createTunnel(isRequestHttps, isProxyHttps, tunnelOptions),
    };
    return proxyAgent;
}
function isUrlHttps(url) {
    const urlScheme = URLBuilder.parse(url).getScheme() || "";
    return urlScheme.toLowerCase() === "https";
}
function createTunnel(isRequestHttps, isProxyHttps, tunnelOptions) {
    if (isRequestHttps && isProxyHttps) {
        return tunnel__namespace.httpsOverHttps(tunnelOptions);
    }
    else if (isRequestHttps && !isProxyHttps) {
        return tunnel__namespace.httpsOverHttp(tunnelOptions);
    }
    else if (!isRequestHttps && isProxyHttps) {
        return tunnel__namespace.httpOverHttps(tunnelOptions);
    }
    else {
        return tunnel__namespace.httpOverHttp(tunnelOptions);
    }
}
function isValidPort(port) {
    // any port in 0-65535 range is valid (RFC 793) even though almost all implementations
    // will reserve 0 for a specific purpose, and a range of numbers for ephemeral ports
    return 0 <= port && port <= 65535;
}

// Copyright (c) Microsoft Corporation.
const RedactedString = "REDACTED";
const defaultAllowedHeaderNames = [
    "x-ms-client-request-id",
    "x-ms-return-client-request-id",
    "x-ms-useragent",
    "x-ms-correlation-request-id",
    "x-ms-request-id",
    "client-request-id",
    "ms-cv",
    "return-client-request-id",
    "traceparent",
    "Access-Control-Allow-Credentials",
    "Access-Control-Allow-Headers",
    "Access-Control-Allow-Methods",
    "Access-Control-Allow-Origin",
    "Access-Control-Expose-Headers",
    "Access-Control-Max-Age",
    "Access-Control-Request-Headers",
    "Access-Control-Request-Method",
    "Origin",
    "Accept",
    "Accept-Encoding",
    "Cache-Control",
    "Connection",
    "Content-Length",
    "Content-Type",
    "Date",
    "ETag",
    "Expires",
    "If-Match",
    "If-Modified-Since",
    "If-None-Match",
    "If-Unmodified-Since",
    "Last-Modified",
    "Pragma",
    "Request-Id",
    "Retry-After",
    "Server",
    "Transfer-Encoding",
    "User-Agent",
    "WWW-Authenticate",
];
const defaultAllowedQueryParameters = ["api-version"];
class Sanitizer {
    constructor({ allowedHeaderNames = [], allowedQueryParameters = [] } = {}) {
        allowedHeaderNames = Array.isArray(allowedHeaderNames)
            ? defaultAllowedHeaderNames.concat(allowedHeaderNames)
            : defaultAllowedHeaderNames;
        allowedQueryParameters = Array.isArray(allowedQueryParameters)
            ? defaultAllowedQueryParameters.concat(allowedQueryParameters)
            : defaultAllowedQueryParameters;
        this.allowedHeaderNames = new Set(allowedHeaderNames.map((n) => n.toLowerCase()));
        this.allowedQueryParameters = new Set(allowedQueryParameters.map((p) => p.toLowerCase()));
    }
    sanitize(obj) {
        const seen = new Set();
        return JSON.stringify(obj, (key, value) => {
            // Ensure Errors include their interesting non-enumerable members
            if (value instanceof Error) {
                return Object.assign(Object.assign({}, value), { name: value.name, message: value.message });
            }
            if (key === "_headersMap") {
                return this.sanitizeHeaders(value);
            }
            else if (key === "url") {
                return this.sanitizeUrl(value);
            }
            else if (key === "query") {
                return this.sanitizeQuery(value);
            }
            else if (key === "body") {
                // Don't log the request body
                return undefined;
            }
            else if (key === "response") {
                // Don't log response again
                return undefined;
            }
            else if (key === "operationSpec") {
                // When using sendOperationRequest, the request carries a massive
                // field with the autorest spec. No need to log it.
                return undefined;
            }
            else if (Array.isArray(value) || isObject(value)) {
                if (seen.has(value)) {
                    return "[Circular]";
                }
                seen.add(value);
            }
            return value;
        }, 2);
    }
    sanitizeHeaders(value) {
        return this.sanitizeObject(value, this.allowedHeaderNames, (v, k) => v[k].value);
    }
    sanitizeQuery(value) {
        return this.sanitizeObject(value, this.allowedQueryParameters, (v, k) => v[k]);
    }
    sanitizeObject(value, allowedKeys, accessor) {
        if (typeof value !== "object" || value === null) {
            return value;
        }
        const sanitized = {};
        for (const k of Object.keys(value)) {
            if (allowedKeys.has(k.toLowerCase())) {
                sanitized[k] = accessor(value, k);
            }
            else {
                sanitized[k] = RedactedString;
            }
        }
        return sanitized;
    }
    sanitizeUrl(value) {
        if (typeof value !== "string" || value === null) {
            return value;
        }
        const urlBuilder = URLBuilder.parse(value);
        const queryString = urlBuilder.getQuery();
        if (!queryString) {
            return value;
        }
        const query = URLQuery.parse(queryString);
        for (const k of query.keys()) {
            if (!this.allowedQueryParameters.has(k.toLowerCase())) {
                query.set(k, RedactedString);
            }
        }
        urlBuilder.setQuery(query.toString());
        return urlBuilder.toString();
    }
}

// Copyright (c) Microsoft Corporation.
const custom = util.inspect.custom;

// Copyright (c) Microsoft Corporation.
const errorSanitizer = new Sanitizer();
/**
 * An error resulting from an HTTP request to a service endpoint.
 */
class RestError extends Error {
    constructor(message, code, statusCode, request, response) {
        super(message);
        this.name = "RestError";
        this.code = code;
        this.statusCode = statusCode;
        this.request = request;
        this.response = response;
        Object.setPrototypeOf(this, RestError.prototype);
    }
    /**
     * Logging method for util.inspect in Node
     */
    [custom]() {
        return `RestError: ${this.message} \n ${errorSanitizer.sanitize(this)}`;
    }
}
/**
 * A constant string to identify errors that may arise when making an HTTP request that indicates an issue with the transport layer (e.g. the hostname of the URL cannot be resolved via DNS.)
 */
RestError.REQUEST_SEND_ERROR = "REQUEST_SEND_ERROR";
/**
 * A constant string to identify errors that may arise from parsing an incoming HTTP response. Usually indicates a malformed HTTP body, such as an encoded JSON payload that is incomplete.
 */
RestError.PARSE_ERROR = "PARSE_ERROR";

// Copyright (c) Microsoft Corporation.
const logger = logger$1.createClientLogger("core-http");

// Copyright (c) Microsoft Corporation.
function getCachedAgent(isHttps, agentCache) {
    return isHttps ? agentCache.httpsAgent : agentCache.httpAgent;
}
class ReportTransform extends stream.Transform {
    constructor(progressCallback) {
        super();
        this.progressCallback = progressCallback;
        this.loadedBytes = 0;
    }
    _transform(chunk, _encoding, callback) {
        this.push(chunk);
        this.loadedBytes += chunk.length;
        this.progressCallback({ loadedBytes: this.loadedBytes });
        callback(undefined);
    }
}
function isReadableStream(body) {
    return body && typeof body.pipe === "function";
}
function isStreamComplete(stream, aborter) {
    return new Promise((resolve) => {
        stream.once("close", () => {
            aborter === null || aborter === void 0 ? void 0 : aborter.abort();
            resolve();
        });
        stream.once("end", resolve);
        stream.once("error", resolve);
    });
}
/**
 * Transforms a set of headers into the key/value pair defined by {@link HttpHeadersLike}
 */
function parseHeaders(headers) {
    const httpHeaders = new HttpHeaders();
    headers.forEach((value, key) => {
        httpHeaders.set(key, value);
    });
    return httpHeaders;
}
/**
 * An HTTP client that uses `node-fetch`.
 */
class NodeFetchHttpClient {
    constructor() {
        // a mapping of proxy settings string `${host}:${port}:${username}:${password}` to agent
        this.proxyAgentMap = new Map();
        this.keepAliveAgents = {};
    }
    /**
     * Provides minimum viable error handling and the logic that executes the abstract methods.
     * @param httpRequest - Object representing the outgoing HTTP request.
     * @returns An object representing the incoming HTTP response.
     */
    async sendRequest(httpRequest) {
        var _a;
        if (!httpRequest && typeof httpRequest !== "object") {
            throw new Error("'httpRequest' (WebResourceLike) cannot be null or undefined and must be of type object.");
        }
        const abortController$1 = new abortController.AbortController();
        let abortListener;
        if (httpRequest.abortSignal) {
            if (httpRequest.abortSignal.aborted) {
                throw new abortController.AbortError("The operation was aborted.");
            }
            abortListener = (event) => {
                if (event.type === "abort") {
                    abortController$1.abort();
                }
            };
            httpRequest.abortSignal.addEventListener("abort", abortListener);
        }
        if (httpRequest.timeout) {
            setTimeout(() => {
                abortController$1.abort();
            }, httpRequest.timeout);
        }
        if (httpRequest.formData) {
            const formData = httpRequest.formData;
            const requestForm = new FormData__default["default"]();
            const appendFormValue = (key, value) => {
                // value function probably returns a stream so we can provide a fresh stream on each retry
                if (typeof value === "function") {
                    value = value();
                }
                if (value &&
                    Object.prototype.hasOwnProperty.call(value, "value") &&
                    Object.prototype.hasOwnProperty.call(value, "options")) {
                    requestForm.append(key, value.value, value.options);
                }
                else {
                    requestForm.append(key, value);
                }
            };
            for (const formKey of Object.keys(formData)) {
                const formValue = formData[formKey];
                if (Array.isArray(formValue)) {
                    for (let j = 0; j < formValue.length; j++) {
                        appendFormValue(formKey, formValue[j]);
                    }
                }
                else {
                    appendFormValue(formKey, formValue);
                }
            }
            httpRequest.body = requestForm;
            httpRequest.formData = undefined;
            const contentType = httpRequest.headers.get("Content-Type");
            if (contentType && contentType.indexOf("multipart/form-data") !== -1) {
                if (typeof requestForm.getBoundary === "function") {
                    httpRequest.headers.set("Content-Type", `multipart/form-data; boundary=${requestForm.getBoundary()}`);
                }
                else {
                    // browser will automatically apply a suitable content-type header
                    httpRequest.headers.remove("Content-Type");
                }
            }
        }
        let body = httpRequest.body
            ? typeof httpRequest.body === "function"
                ? httpRequest.body()
                : httpRequest.body
            : undefined;
        if (httpRequest.onUploadProgress && httpRequest.body) {
            const onUploadProgress = httpRequest.onUploadProgress;
            const uploadReportStream = new ReportTransform(onUploadProgress);
            if (isReadableStream(body)) {
                body.pipe(uploadReportStream);
            }
            else {
                uploadReportStream.end(body);
            }
            body = uploadReportStream;
        }
        const platformSpecificRequestInit = await this.prepareRequest(httpRequest);
        const requestInit = Object.assign({ body: body, headers: httpRequest.headers.rawHeaders(), method: httpRequest.method, 
            // the types for RequestInit are from the browser, which expects AbortSignal to
            // have `reason` and `throwIfAborted`, but these don't exist on our polyfill
            // for Node.
            signal: abortController$1.signal, redirect: "manual" }, platformSpecificRequestInit);
        let operationResponse;
        try {
            const response = await this.fetch(httpRequest.url, requestInit);
            const headers = parseHeaders(response.headers);
            const streaming = ((_a = httpRequest.streamResponseStatusCodes) === null || _a === void 0 ? void 0 : _a.has(response.status)) ||
                httpRequest.streamResponseBody;
            operationResponse = {
                headers: headers,
                request: httpRequest,
                status: response.status,
                readableStreamBody: streaming
                    ? response.body
                    : undefined,
                bodyAsText: !streaming ? await response.text() : undefined,
            };
            const onDownloadProgress = httpRequest.onDownloadProgress;
            if (onDownloadProgress) {
                const responseBody = response.body || undefined;
                if (isReadableStream(responseBody)) {
                    const downloadReportStream = new ReportTransform(onDownloadProgress);
                    responseBody.pipe(downloadReportStream);
                    operationResponse.readableStreamBody = downloadReportStream;
                }
                else {
                    const length = parseInt(headers.get("Content-Length")) || undefined;
                    if (length) {
                        // Calling callback for non-stream response for consistency with browser
                        onDownloadProgress({ loadedBytes: length });
                    }
                }
            }
            await this.processRequest(operationResponse);
            return operationResponse;
        }
        catch (error) {
            const fetchError = error;
            if (fetchError.code === "ENOTFOUND") {
                throw new RestError(fetchError.message, RestError.REQUEST_SEND_ERROR, undefined, httpRequest);
            }
            else if (fetchError.type === "aborted") {
                throw new abortController.AbortError("The operation was aborted.");
            }
            throw fetchError;
        }
        finally {
            // clean up event listener
            if (httpRequest.abortSignal && abortListener) {
                let uploadStreamDone = Promise.resolve();
                if (isReadableStream(body)) {
                    uploadStreamDone = isStreamComplete(body);
                }
                let downloadStreamDone = Promise.resolve();
                if (isReadableStream(operationResponse === null || operationResponse === void 0 ? void 0 : operationResponse.readableStreamBody)) {
                    downloadStreamDone = isStreamComplete(operationResponse.readableStreamBody, abortController$1);
                }
                Promise.all([uploadStreamDone, downloadStreamDone])
                    .then(() => {
                    var _a;
                    (_a = httpRequest.abortSignal) === null || _a === void 0 ? void 0 : _a.removeEventListener("abort", abortListener);
                    return;
                })
                    .catch((e) => {
                    logger.warning("Error when cleaning up abortListener on httpRequest", e);
                });
            }
        }
    }
    getOrCreateAgent(httpRequest) {
        var _a;
        const isHttps = isUrlHttps(httpRequest.url);
        // At the moment, proxy settings and keepAlive are mutually
        // exclusive because the 'tunnel' library currently lacks the
        // ability to create a proxy with keepAlive turned on.
        if (httpRequest.proxySettings) {
            const { host, port, username, password } = httpRequest.proxySettings;
            const key = `${host}:${port}:${username}:${password}`;
            const proxyAgents = (_a = this.proxyAgentMap.get(key)) !== null && _a !== void 0 ? _a : {};
            let agent = getCachedAgent(isHttps, proxyAgents);
            if (agent) {
                return agent;
            }
            const tunnel = createProxyAgent(httpRequest.url, httpRequest.proxySettings, httpRequest.headers);
            agent = tunnel.agent;
            if (tunnel.isHttps) {
                proxyAgents.httpsAgent = tunnel.agent;
            }
            else {
                proxyAgents.httpAgent = tunnel.agent;
            }
            this.proxyAgentMap.set(key, proxyAgents);
            return agent;
        }
        else if (httpRequest.keepAlive) {
            let agent = getCachedAgent(isHttps, this.keepAliveAgents);
            if (agent) {
                return agent;
            }
            const agentOptions = {
                keepAlive: httpRequest.keepAlive,
            };
            if (isHttps) {
                agent = this.keepAliveAgents.httpsAgent = new https__namespace.Agent(agentOptions);
            }
            else {
                agent = this.keepAliveAgents.httpAgent = new http__namespace.Agent(agentOptions);
            }
            return agent;
        }
        else {
            return isHttps ? https__namespace.globalAgent : http__namespace.globalAgent;
        }
    }
    /**
     * Uses `node-fetch` to perform the request.
     */
    // eslint-disable-next-line @azure/azure-sdk/ts-apisurface-standardized-verbs
    async fetch(input, init) {
        return node_fetch__default["default"](input, init);
    }
    /**
     * Prepares a request based on the provided web resource.
     */
    async prepareRequest(httpRequest) {
        const requestInit = {};
        // Set the http(s) agent
        requestInit.agent = this.getOrCreateAgent(httpRequest);
        requestInit.compress = httpRequest.decompressResponse;
        return requestInit;
    }
    /**
     * Process an HTTP response.
     */
    async processRequest(_operationResponse) {
        /* no_op */
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * The different levels of logs that can be used with the HttpPipelineLogger.
 */
exports.HttpPipelineLogLevel = void 0;
(function (HttpPipelineLogLevel) {
    /**
     * A log level that indicates that no logs will be logged.
     */
    HttpPipelineLogLevel[HttpPipelineLogLevel["OFF"] = 0] = "OFF";
    /**
     * An error log.
     */
    HttpPipelineLogLevel[HttpPipelineLogLevel["ERROR"] = 1] = "ERROR";
    /**
     * A warning log.
     */
    HttpPipelineLogLevel[HttpPipelineLogLevel["WARNING"] = 2] = "WARNING";
    /**
     * An information log.
     */
    HttpPipelineLogLevel[HttpPipelineLogLevel["INFO"] = 3] = "INFO";
})(exports.HttpPipelineLogLevel || (exports.HttpPipelineLogLevel = {}));

// Copyright (c) Microsoft Corporation.
/**
 * Converts an OperationOptions to a RequestOptionsBase
 *
 * @param opts - OperationOptions object to convert to RequestOptionsBase
 */
function operationOptionsToRequestOptionsBase(opts) {
    const { requestOptions, tracingOptions } = opts, additionalOptions = tslib.__rest(opts, ["requestOptions", "tracingOptions"]);
    let result = additionalOptions;
    if (requestOptions) {
        result = Object.assign(Object.assign({}, result), requestOptions);
    }
    if (tracingOptions) {
        result.tracingContext = tracingOptions.tracingContext;
        // By passing spanOptions if they exist at runtime, we're backwards compatible with @azure/core-tracing@preview.13 and earlier.
        result.spanOptions = tracingOptions === null || tracingOptions === void 0 ? void 0 : tracingOptions.spanOptions;
    }
    return result;
}

// Copyright (c) Microsoft Corporation.
/**
 * The base class from which all request policies derive.
 */
class BaseRequestPolicy {
    /**
     * The main method to implement that manipulates a request/response.
     */
    constructor(
    /**
     * The next policy in the pipeline. Each policy is responsible for executing the next one if the request is to continue through the pipeline.
     */
    _nextPolicy, 
    /**
     * The options that can be passed to a given request policy.
     */
    _options) {
        this._nextPolicy = _nextPolicy;
        this._options = _options;
    }
    /**
     * Get whether or not a log with the provided log level should be logged.
     * @param logLevel - The log level of the log that will be logged.
     * @returns Whether or not a log with the provided log level should be logged.
     */
    shouldLog(logLevel) {
        return this._options.shouldLog(logLevel);
    }
    /**
     * Attempt to log the provided message to the provided logger. If no logger was provided or if
     * the log level does not meat the logger's threshold, then nothing will be logged.
     * @param logLevel - The log level of this log.
     * @param message - The message of this log.
     */
    log(logLevel, message) {
        this._options.log(logLevel, message);
    }
}
/**
 * Optional properties that can be used when creating a RequestPolicy.
 */
class RequestPolicyOptions {
    constructor(_logger) {
        this._logger = _logger;
    }
    /**
     * Get whether or not a log with the provided log level should be logged.
     * @param logLevel - The log level of the log that will be logged.
     * @returns Whether or not a log with the provided log level should be logged.
     */
    shouldLog(logLevel) {
        return (!!this._logger &&
            logLevel !== exports.HttpPipelineLogLevel.OFF &&
            logLevel <= this._logger.minimumLogLevel);
    }
    /**
     * Attempt to log the provided message to the provided logger. If no logger was provided or if
     * the log level does not meet the logger's threshold, then nothing will be logged.
     * @param logLevel - The log level of this log.
     * @param message - The message of this log.
     */
    log(logLevel, message) {
        if (this._logger && this.shouldLog(logLevel)) {
            this._logger.log(logLevel, message);
        }
    }
}

// Copyright (c) Microsoft Corporation.
// Note: The reason we re-define all of the xml2js default settings (version 2.0) here is because the default settings object exposed
// by the xm2js library is mutable. See https://github.com/Leonidas-from-XIV/node-xml2js/issues/536
// By creating a new copy of the settings each time we instantiate the parser,
// we are safeguarding against the possibility of the default settings being mutated elsewhere unintentionally.
const xml2jsDefaultOptionsV2 = {
    explicitCharkey: false,
    trim: false,
    normalize: false,
    normalizeTags: false,
    attrkey: XML_ATTRKEY,
    explicitArray: true,
    ignoreAttrs: false,
    mergeAttrs: false,
    explicitRoot: true,
    validator: undefined,
    xmlns: false,
    explicitChildren: false,
    preserveChildrenOrder: false,
    childkey: "$$",
    charsAsChildren: false,
    includeWhiteChars: false,
    async: false,
    strict: true,
    attrNameProcessors: undefined,
    attrValueProcessors: undefined,
    tagNameProcessors: undefined,
    valueProcessors: undefined,
    rootName: "root",
    xmldec: {
        version: "1.0",
        encoding: "UTF-8",
        standalone: true,
    },
    doctype: undefined,
    renderOpts: {
        pretty: true,
        indent: "  ",
        newline: "\n",
    },
    headless: false,
    chunkSize: 10000,
    emptyTag: "",
    cdata: false,
};
// The xml2js settings for general XML parsing operations.
const xml2jsParserSettings = Object.assign({}, xml2jsDefaultOptionsV2);
xml2jsParserSettings.explicitArray = false;
// The xml2js settings for general XML building operations.
const xml2jsBuilderSettings = Object.assign({}, xml2jsDefaultOptionsV2);
xml2jsBuilderSettings.explicitArray = false;
xml2jsBuilderSettings.renderOpts = {
    pretty: false,
};
/**
 * Converts given JSON object to XML string
 * @param obj - JSON object to be converted into XML string
 * @param opts - Options that govern the parsing of given JSON object
 */
function stringifyXML(obj, opts = {}) {
    var _a;
    xml2jsBuilderSettings.rootName = opts.rootName;
    xml2jsBuilderSettings.charkey = (_a = opts.xmlCharKey) !== null && _a !== void 0 ? _a : XML_CHARKEY;
    const builder = new xml2js__namespace.Builder(xml2jsBuilderSettings);
    return builder.buildObject(obj);
}
/**
 * Converts given XML string into JSON
 * @param str - String containing the XML content to be parsed into JSON
 * @param opts - Options that govern the parsing of given xml string
 */
function parseXML(str, opts = {}) {
    var _a;
    xml2jsParserSettings.explicitRoot = !!opts.includeRoot;
    xml2jsParserSettings.charkey = (_a = opts.xmlCharKey) !== null && _a !== void 0 ? _a : XML_CHARKEY;
    const xmlParser = new xml2js__namespace.Parser(xml2jsParserSettings);
    return new Promise((resolve, reject) => {
        if (!str) {
            reject(new Error("Document is empty"));
        }
        else {
            xmlParser.parseString(str, (err, res) => {
                if (err) {
                    reject(err);
                }
                else {
                    resolve(res);
                }
            });
        }
    });
}

// Copyright (c) Microsoft Corporation.
/**
 * Create a new serialization RequestPolicyCreator that will serialized HTTP request bodies as they
 * pass through the HTTP pipeline.
 */
function deserializationPolicy(deserializationContentTypes, parsingOptions) {
    return {
        create: (nextPolicy, options) => {
            return new DeserializationPolicy(nextPolicy, options, deserializationContentTypes, parsingOptions);
        },
    };
}
const defaultJsonContentTypes = ["application/json", "text/json"];
const defaultXmlContentTypes = ["application/xml", "application/atom+xml"];
const DefaultDeserializationOptions = {
    expectedContentTypes: {
        json: defaultJsonContentTypes,
        xml: defaultXmlContentTypes,
    },
};
/**
 * A RequestPolicy that will deserialize HTTP response bodies and headers as they pass through the
 * HTTP pipeline.
 */
class DeserializationPolicy extends BaseRequestPolicy {
    constructor(nextPolicy, requestPolicyOptions, deserializationContentTypes, parsingOptions = {}) {
        var _a;
        super(nextPolicy, requestPolicyOptions);
        this.jsonContentTypes =
            (deserializationContentTypes && deserializationContentTypes.json) || defaultJsonContentTypes;
        this.xmlContentTypes =
            (deserializationContentTypes && deserializationContentTypes.xml) || defaultXmlContentTypes;
        this.xmlCharKey = (_a = parsingOptions.xmlCharKey) !== null && _a !== void 0 ? _a : XML_CHARKEY;
    }
    async sendRequest(request) {
        return this._nextPolicy.sendRequest(request).then((response) => deserializeResponseBody(this.jsonContentTypes, this.xmlContentTypes, response, {
            xmlCharKey: this.xmlCharKey,
        }));
    }
}
function getOperationResponse(parsedResponse) {
    let result;
    const request = parsedResponse.request;
    const operationSpec = request.operationSpec;
    if (operationSpec) {
        const operationResponseGetter = request.operationResponseGetter;
        if (!operationResponseGetter) {
            result = operationSpec.responses[parsedResponse.status];
        }
        else {
            result = operationResponseGetter(operationSpec, parsedResponse);
        }
    }
    return result;
}
function shouldDeserializeResponse(parsedResponse) {
    const shouldDeserialize = parsedResponse.request.shouldDeserialize;
    let result;
    if (shouldDeserialize === undefined) {
        result = true;
    }
    else if (typeof shouldDeserialize === "boolean") {
        result = shouldDeserialize;
    }
    else {
        result = shouldDeserialize(parsedResponse);
    }
    return result;
}
/**
 * Given a particular set of content types to parse as either JSON or XML, consumes the HTTP response to produce the result object defined by the request's {@link OperationSpec}.
 * @param jsonContentTypes - Response content types to parse the body as JSON.
 * @param xmlContentTypes  - Response content types to parse the body as XML.
 * @param response - HTTP Response from the pipeline.
 * @param options  - Options to the serializer, mostly for configuring the XML parser if needed.
 * @returns A parsed {@link HttpOperationResponse} object that can be returned by the {@link ServiceClient}.
 */
function deserializeResponseBody(jsonContentTypes, xmlContentTypes, response, options = {}) {
    var _a, _b, _c;
    const updatedOptions = {
        rootName: (_a = options.rootName) !== null && _a !== void 0 ? _a : "",
        includeRoot: (_b = options.includeRoot) !== null && _b !== void 0 ? _b : false,
        xmlCharKey: (_c = options.xmlCharKey) !== null && _c !== void 0 ? _c : XML_CHARKEY,
    };
    return parse(jsonContentTypes, xmlContentTypes, response, updatedOptions).then((parsedResponse) => {
        if (!shouldDeserializeResponse(parsedResponse)) {
            return parsedResponse;
        }
        const operationSpec = parsedResponse.request.operationSpec;
        if (!operationSpec || !operationSpec.responses) {
            return parsedResponse;
        }
        const responseSpec = getOperationResponse(parsedResponse);
        const { error, shouldReturnResponse } = handleErrorResponse(parsedResponse, operationSpec, responseSpec);
        if (error) {
            throw error;
        }
        else if (shouldReturnResponse) {
            return parsedResponse;
        }
        // An operation response spec does exist for current status code, so
        // use it to deserialize the response.
        if (responseSpec) {
            if (responseSpec.bodyMapper) {
                let valueToDeserialize = parsedResponse.parsedBody;
                if (operationSpec.isXML && responseSpec.bodyMapper.type.name === MapperType.Sequence) {
                    valueToDeserialize =
                        typeof valueToDeserialize === "object"
                            ? valueToDeserialize[responseSpec.bodyMapper.xmlElementName]
                            : [];
                }
                try {
                    parsedResponse.parsedBody = operationSpec.serializer.deserialize(responseSpec.bodyMapper, valueToDeserialize, "operationRes.parsedBody", options);
                }
                catch (innerError) {
                    const restError = new RestError(`Error ${innerError} occurred in deserializing the responseBody - ${parsedResponse.bodyAsText}`, undefined, parsedResponse.status, parsedResponse.request, parsedResponse);
                    throw restError;
                }
            }
            else if (operationSpec.httpMethod === "HEAD") {
                // head methods never have a body, but we return a boolean to indicate presence/absence of the resource
                parsedResponse.parsedBody = response.status >= 200 && response.status < 300;
            }
            if (responseSpec.headersMapper) {
                parsedResponse.parsedHeaders = operationSpec.serializer.deserialize(responseSpec.headersMapper, parsedResponse.headers.toJson(), "operationRes.parsedHeaders", options);
            }
        }
        return parsedResponse;
    });
}
function isOperationSpecEmpty(operationSpec) {
    const expectedStatusCodes = Object.keys(operationSpec.responses);
    return (expectedStatusCodes.length === 0 ||
        (expectedStatusCodes.length === 1 && expectedStatusCodes[0] === "default"));
}
function handleErrorResponse(parsedResponse, operationSpec, responseSpec) {
    var _a;
    const isSuccessByStatus = 200 <= parsedResponse.status && parsedResponse.status < 300;
    const isExpectedStatusCode = isOperationSpecEmpty(operationSpec)
        ? isSuccessByStatus
        : !!responseSpec;
    if (isExpectedStatusCode) {
        if (responseSpec) {
            if (!responseSpec.isError) {
                return { error: null, shouldReturnResponse: false };
            }
        }
        else {
            return { error: null, shouldReturnResponse: false };
        }
    }
    const errorResponseSpec = responseSpec !== null && responseSpec !== void 0 ? responseSpec : operationSpec.responses.default;
    const streaming = ((_a = parsedResponse.request.streamResponseStatusCodes) === null || _a === void 0 ? void 0 : _a.has(parsedResponse.status)) ||
        parsedResponse.request.streamResponseBody;
    const initialErrorMessage = streaming
        ? `Unexpected status code: ${parsedResponse.status}`
        : parsedResponse.bodyAsText;
    const error = new RestError(initialErrorMessage, undefined, parsedResponse.status, parsedResponse.request, parsedResponse);
    // If the item failed but there's no error spec or default spec to deserialize the error,
    // we should fail so we just throw the parsed response
    if (!errorResponseSpec) {
        throw error;
    }
    const defaultBodyMapper = errorResponseSpec.bodyMapper;
    const defaultHeadersMapper = errorResponseSpec.headersMapper;
    try {
        // If error response has a body, try to deserialize it using default body mapper.
        // Then try to extract error code & message from it
        if (parsedResponse.parsedBody) {
            const parsedBody = parsedResponse.parsedBody;
            let parsedError;
            if (defaultBodyMapper) {
                let valueToDeserialize = parsedBody;
                if (operationSpec.isXML && defaultBodyMapper.type.name === MapperType.Sequence) {
                    valueToDeserialize =
                        typeof parsedBody === "object" ? parsedBody[defaultBodyMapper.xmlElementName] : [];
                }
                parsedError = operationSpec.serializer.deserialize(defaultBodyMapper, valueToDeserialize, "error.response.parsedBody");
            }
            const internalError = parsedBody.error || parsedError || parsedBody;
            error.code = internalError.code;
            if (internalError.message) {
                error.message = internalError.message;
            }
            if (defaultBodyMapper) {
                error.response.parsedBody = parsedError;
            }
        }
        // If error response has headers, try to deserialize it using default header mapper
        if (parsedResponse.headers && defaultHeadersMapper) {
            error.response.parsedHeaders = operationSpec.serializer.deserialize(defaultHeadersMapper, parsedResponse.headers.toJson(), "operationRes.parsedHeaders");
        }
    }
    catch (defaultError) {
        error.message = `Error "${defaultError.message}" occurred in deserializing the responseBody - "${parsedResponse.bodyAsText}" for the default response.`;
    }
    return { error, shouldReturnResponse: false };
}
function parse(jsonContentTypes, xmlContentTypes, operationResponse, opts) {
    var _a;
    const errorHandler = (err) => {
        const msg = `Error "${err}" occurred while parsing the response body - ${operationResponse.bodyAsText}.`;
        const errCode = err.code || RestError.PARSE_ERROR;
        const e = new RestError(msg, errCode, operationResponse.status, operationResponse.request, operationResponse);
        return Promise.reject(e);
    };
    const streaming = ((_a = operationResponse.request.streamResponseStatusCodes) === null || _a === void 0 ? void 0 : _a.has(operationResponse.status)) ||
        operationResponse.request.streamResponseBody;
    if (!streaming && operationResponse.bodyAsText) {
        const text = operationResponse.bodyAsText;
        const contentType = operationResponse.headers.get("Content-Type") || "";
        const contentComponents = !contentType
            ? []
            : contentType.split(";").map((component) => component.toLowerCase());
        if (contentComponents.length === 0 ||
            contentComponents.some((component) => jsonContentTypes.indexOf(component) !== -1)) {
            return new Promise((resolve) => {
                operationResponse.parsedBody = JSON.parse(text);
                resolve(operationResponse);
            }).catch(errorHandler);
        }
        else if (contentComponents.some((component) => xmlContentTypes.indexOf(component) !== -1)) {
            return parseXML(text, opts)
                .then((body) => {
                operationResponse.parsedBody = body;
                return operationResponse;
            })
                .catch(errorHandler);
        }
    }
    return Promise.resolve(operationResponse);
}

// Copyright (c) Microsoft Corporation.
/**
 * By default, HTTP connections are maintained for future requests.
 */
const DefaultKeepAliveOptions = {
    enable: true,
};
/**
 * Creates a policy that controls whether HTTP connections are maintained on future requests.
 * @param keepAliveOptions - Keep alive options. By default, HTTP connections are maintained for future requests.
 * @returns An instance of the {@link KeepAlivePolicy}
 */
function keepAlivePolicy(keepAliveOptions) {
    return {
        create: (nextPolicy, options) => {
            return new KeepAlivePolicy(nextPolicy, options, keepAliveOptions || DefaultKeepAliveOptions);
        },
    };
}
/**
 * KeepAlivePolicy is a policy used to control keep alive settings for every request.
 */
class KeepAlivePolicy extends BaseRequestPolicy {
    /**
     * Creates an instance of KeepAlivePolicy.
     *
     * @param nextPolicy -
     * @param options -
     * @param keepAliveOptions -
     */
    constructor(nextPolicy, options, keepAliveOptions) {
        super(nextPolicy, options);
        this.keepAliveOptions = keepAliveOptions;
    }
    /**
     * Sends out request.
     *
     * @param request -
     * @returns
     */
    async sendRequest(request) {
        request.keepAlive = this.keepAliveOptions.enable;
        return this._nextPolicy.sendRequest(request);
    }
}

// Copyright (c) Microsoft Corporation.
/**
 * Methods that are allowed to follow redirects 301 and 302
 */
const allowedRedirect = ["GET", "HEAD"];
const DefaultRedirectOptions = {
    handleRedirects: true,
    maxRetries: 20,
};
/**
 * Creates a redirect policy, which sends a repeats the request to a new destination if a response arrives with a "location" header, and a status code between 300 and 307.
 * @param maximumRetries - Maximum number of redirects to follow.
 * @returns An instance of the {@link RedirectPolicy}
 */
function redirectPolicy(maximumRetries = 20) {
    return {
        create: (nextPolicy, options) => {
            return new RedirectPolicy(nextPolicy, options, maximumRetries);
        },
    };
}
/**
 * Resends the request to a new destination if a response arrives with a "location" header, and a status code between 300 and 307.
 */
class RedirectPolicy extends BaseRequestPolicy {
    constructor(nextPolicy, options, maxRetries = 20) {
        super(nextPolicy, options);
        this.maxRetries = maxRetries;
    }
    sendRequest(request) {
        return this._nextPolicy
            .sendRequest(request)
            .then((response) => handleRedirect(this, response, 0));
    }
}
function handleRedirect(policy, response, currentRetries) {
    const { request, status } = response;
    const locationHeader = response.headers.get("location");
    if (locationHeader &&
        (status === 300 ||
            (status === 301 && allowedRedirect.includes(request.method)) ||
            (status === 302 && allowedRedirect.includes(request.method)) ||
            (status === 303 && request.method === "POST") ||
            status === 307) &&
        (!policy.maxRetries || currentRetries < policy.maxRetries)) {
        const builder = URLBuilder.parse(request.url);
        builder.setPath(locationHeader);
        request.url = builder.toString();
        // POST request with Status code 303 should be converted into a
        // redirected GET request if the redirect url is present in the location header
        if (status === 303) {
            request.method = "GET";
            delete request.body;
        }
        return policy._nextPolicy
            .sendRequest(request)
            .then((res) => handleRedirect(policy, res, currentRetries + 1));
    }
    return Promise.resolve(response);
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
const DEFAULT_CLIENT_RETRY_COUNT = 3;
// intervals are in ms
const DEFAULT_CLIENT_RETRY_INTERVAL = 1000 * 30;
const DEFAULT_CLIENT_MAX_RETRY_INTERVAL = 1000 * 90;
const DEFAULT_CLIENT_MIN_RETRY_INTERVAL = 1000 * 3;
function isNumber(n) {
    return typeof n === "number";
}
/**
 * @internal
 * Determines if the operation should be retried.
 *
 * @param retryLimit - Specifies the max number of retries.
 * @param predicate - Initial chekck on whether to retry based on given responses or errors
 * @param retryData -  The retry data.
 * @returns True if the operation qualifies for a retry; false otherwise.
 */
function shouldRetry(retryLimit, predicate, retryData, response, error) {
    if (!predicate(response, error)) {
        return false;
    }
    return retryData.retryCount < retryLimit;
}
/**
 * @internal
 * Updates the retry data for the next attempt.
 *
 * @param retryOptions - specifies retry interval, and its lower bound and upper bound.
 * @param retryData -  The retry data.
 * @param err - The operation"s error, if any.
 */
function updateRetryData(retryOptions, retryData = { retryCount: 0, retryInterval: 0 }, err) {
    if (err) {
        if (retryData.error) {
            err.innerError = retryData.error;
        }
        retryData.error = err;
    }
    // Adjust retry count
    retryData.retryCount++;
    // Adjust retry interval
    let incrementDelta = Math.pow(2, retryData.retryCount - 1) - 1;
    const boundedRandDelta = retryOptions.retryInterval * 0.8 +
        Math.floor(Math.random() * (retryOptions.retryInterval * 0.4));
    incrementDelta *= boundedRandDelta;
    retryData.retryInterval = Math.min(retryOptions.minRetryInterval + incrementDelta, retryOptions.maxRetryInterval);
    return retryData;
}

// Copyright (c) Microsoft Corporation.
/**
 * Policy that retries the request as many times as configured for as long as the max retry time interval specified, each retry waiting longer to begin than the last time.
 * @param retryCount - Maximum number of retries.
 * @param retryInterval - Base time between retries.
 * @param maxRetryInterval - Maximum time to wait between retries.
 */
function exponentialRetryPolicy(retryCount, retryInterval, maxRetryInterval) {
    return {
        create: (nextPolicy, options) => {
            return new ExponentialRetryPolicy(nextPolicy, options, retryCount, retryInterval, maxRetryInterval);
        },
    };
}
/**
 * Describes the Retry Mode type. Currently supporting only Exponential.
 */
exports.RetryMode = void 0;
(function (RetryMode) {
    /**
     * Currently supported retry mode.
     * Each time a retry happens, it will take exponentially more time than the last time.
     */
    RetryMode[RetryMode["Exponential"] = 0] = "Exponential";
})(exports.RetryMode || (exports.RetryMode = {}));
const DefaultRetryOptions = {
    maxRetries: DEFAULT_CLIENT_RETRY_COUNT,
    retryDelayInMs: DEFAULT_CLIENT_RETRY_INTERVAL,
    maxRetryDelayInMs: DEFAULT_CLIENT_MAX_RETRY_INTERVAL,
};
/**
 * Instantiates a new "ExponentialRetryPolicyFilter" instance.
 */
class ExponentialRetryPolicy extends BaseRequestPolicy {
    /**
     * @param nextPolicy - The next RequestPolicy in the pipeline chain.
     * @param options - The options for this RequestPolicy.
     * @param retryCount - The client retry count.
     * @param retryInterval - The client retry interval, in milliseconds.
     * @param minRetryInterval - The minimum retry interval, in milliseconds.
     * @param maxRetryInterval - The maximum retry interval, in milliseconds.
     */
    constructor(nextPolicy, options, retryCount, retryInterval, maxRetryInterval) {
        super(nextPolicy, options);
        this.retryCount = isNumber(retryCount) ? retryCount : DEFAULT_CLIENT_RETRY_COUNT;
        this.retryInterval = isNumber(retryInterval) ? retryInterval : DEFAULT_CLIENT_RETRY_INTERVAL;
        this.maxRetryInterval = isNumber(maxRetryInterval)
            ? maxRetryInterval
            : DEFAULT_CLIENT_MAX_RETRY_INTERVAL;
    }
    sendRequest(request) {
        return this._nextPolicy
            .sendRequest(request.clone())
            .then((response) => retry$1(this, request, response))
            .catch((error) => retry$1(this, request, error.response, undefined, error));
    }
}
async function retry$1(policy, request, response, retryData, requestError) {
    function shouldPolicyRetry(responseParam) {
        const statusCode = responseParam === null || responseParam === void 0 ? void 0 : responseParam.status;
        if (statusCode === 503 && (response === null || response === void 0 ? void 0 : response.headers.get(Constants.HeaderConstants.RETRY_AFTER))) {
            return false;
        }
        if (statusCode === undefined ||
            (statusCode < 500 && statusCode !== 408) ||
            statusCode === 501 ||
            statusCode === 505) {
            return false;
        }
        return true;
    }
    retryData = updateRetryData({
        retryInterval: policy.retryInterval,
        minRetryInterval: 0,
        maxRetryInterval: policy.maxRetryInterval,
    }, retryData, requestError);
    const isAborted = request.abortSignal && request.abortSignal.aborted;
    if (!isAborted && shouldRetry(policy.retryCount, shouldPolicyRetry, retryData, response)) {
        logger.info(`Retrying request in ${retryData.retryInterval}`);
        try {
            await coreUtil.delay(retryData.retryInterval);
            const res = await policy._nextPolicy.sendRequest(request.clone());
            return retry$1(policy, request, res, retryData);
        }
        catch (err) {
            return retry$1(policy, request, response, retryData, err);
        }
    }
    else if (isAborted || requestError || !response) {
        // If the operation failed in the end, return all errors instead of just the last one
        const err = retryData.error ||
            new RestError("Failed to send the request.", RestError.REQUEST_SEND_ERROR, response && response.status, response && response.request, response);
        throw err;
    }
    else {
        return response;
    }
}

// Copyright (c) Microsoft Corporation.
/**
 * Creates a policy that logs information about the outgoing request and the incoming responses.
 * @param loggingOptions - Logging options.
 * @returns An instance of the {@link LogPolicy}
 */
function logPolicy(loggingOptions = {}) {
    return {
        create: (nextPolicy, options) => {
            return new LogPolicy(nextPolicy, options, loggingOptions);
        },
    };
}
/**
 * A policy that logs information about the outgoing request and the incoming responses.
 */
class LogPolicy extends BaseRequestPolicy {
    constructor(nextPolicy, options, { logger: logger$1 = logger.info, allowedHeaderNames = [], allowedQueryParameters = [], } = {}) {
        super(nextPolicy, options);
        this.logger = logger$1;
        this.sanitizer = new Sanitizer({ allowedHeaderNames, allowedQueryParameters });
    }
    /**
     * Header names whose values will be logged when logging is enabled. Defaults to
     * Date, traceparent, x-ms-client-request-id, and x-ms-request id.  Any headers
     * specified in this field will be added to that list.  Any other values will
     * be written to logs as "REDACTED".
     * @deprecated Pass these into the constructor instead.
     */
    get allowedHeaderNames() {
        return this.sanitizer.allowedHeaderNames;
    }
    /**
     * Header names whose values will be logged when logging is enabled. Defaults to
     * Date, traceparent, x-ms-client-request-id, and x-ms-request id.  Any headers
     * specified in this field will be added to that list.  Any other values will
     * be written to logs as "REDACTED".
     * @deprecated Pass these into the constructor instead.
     */
    set allowedHeaderNames(allowedHeaderNames) {
        this.sanitizer.allowedHeaderNames = allowedHeaderNames;
    }
    /**
     * Query string names whose values will be logged when logging is enabled. By default no
     * query string values are logged.
     * @deprecated Pass these into the constructor instead.
     */
    get allowedQueryParameters() {
        return this.sanitizer.allowedQueryParameters;
    }
    /**
     * Query string names whose values will be logged when logging is enabled. By default no
     * query string values are logged.
     * @deprecated Pass these into the constructor instead.
     */
    set allowedQueryParameters(allowedQueryParameters) {
        this.sanitizer.allowedQueryParameters = allowedQueryParameters;
    }
    sendRequest(request) {
        if (!this.logger.enabled)
            return this._nextPolicy.sendRequest(request);
        this.logRequest(request);
        return this._nextPolicy.sendRequest(request).then((response) => this.logResponse(response));
    }
    logRequest(request) {
        this.logger(`Request: ${this.sanitizer.sanitize(request)}`);
    }
    logResponse(response) {
        this.logger(`Response status code: ${response.status}`);
        this.logger(`Headers: ${this.sanitizer.sanitize(response.headers)}`);
        return response;
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * Get the path to this parameter's value as a dotted string (a.b.c).
 * @param parameter - The parameter to get the path string for.
 * @returns The path to this parameter's value as a dotted string.
 */
function getPathStringFromParameter(parameter) {
    return getPathStringFromParameterPath(parameter.parameterPath, parameter.mapper);
}
function getPathStringFromParameterPath(parameterPath, mapper) {
    let result;
    if (typeof parameterPath === "string") {
        result = parameterPath;
    }
    else if (Array.isArray(parameterPath)) {
        result = parameterPath.join(".");
    }
    else {
        result = mapper.serializedName;
    }
    return result;
}

// Copyright (c) Microsoft Corporation.
/**
 * Gets the list of status codes for streaming responses.
 * @internal
 */
function getStreamResponseStatusCodes(operationSpec) {
    const result = new Set();
    for (const statusCode in operationSpec.responses) {
        const operationResponse = operationSpec.responses[statusCode];
        if (operationResponse.bodyMapper &&
            operationResponse.bodyMapper.type.name === MapperType.Stream) {
            result.add(Number(statusCode));
        }
    }
    return result;
}

// Copyright (c) Microsoft Corporation.
function getDefaultUserAgentKey() {
    return Constants.HeaderConstants.USER_AGENT;
}
function getPlatformSpecificData() {
    const runtimeInfo = {
        key: "Node",
        value: process.version,
    };
    const osInfo = {
        key: "OS",
        value: `(${os__namespace.arch()}-${os__namespace.type()}-${os__namespace.release()})`,
    };
    return [runtimeInfo, osInfo];
}

// Copyright (c) Microsoft Corporation.
function getRuntimeInfo() {
    const msRestRuntime = {
        key: "core-http",
        value: Constants.coreHttpVersion,
    };
    return [msRestRuntime];
}
function getUserAgentString(telemetryInfo, keySeparator = " ", valueSeparator = "/") {
    return telemetryInfo
        .map((info) => {
        const value = info.value ? `${valueSeparator}${info.value}` : "";
        return `${info.key}${value}`;
    })
        .join(keySeparator);
}
const getDefaultUserAgentHeaderName = getDefaultUserAgentKey;
/**
 * The default approach to generate user agents.
 * Uses static information from this package, plus system information available from the runtime.
 */
function getDefaultUserAgentValue() {
    const runtimeInfo = getRuntimeInfo();
    const platformSpecificData = getPlatformSpecificData();
    const userAgent = getUserAgentString(runtimeInfo.concat(platformSpecificData));
    return userAgent;
}
/**
 * Returns a policy that adds the user agent header to outgoing requests based on the given {@link TelemetryInfo}.
 * @param userAgentData - Telemetry information.
 * @returns A new {@link UserAgentPolicy}.
 */
function userAgentPolicy(userAgentData) {
    const key = !userAgentData || userAgentData.key === undefined || userAgentData.key === null
        ? getDefaultUserAgentKey()
        : userAgentData.key;
    const value = !userAgentData || userAgentData.value === undefined || userAgentData.value === null
        ? getDefaultUserAgentValue()
        : userAgentData.value;
    return {
        create: (nextPolicy, options) => {
            return new UserAgentPolicy(nextPolicy, options, key, value);
        },
    };
}
/**
 * A policy that adds the user agent header to outgoing requests based on the given {@link TelemetryInfo}.
 */
class UserAgentPolicy extends BaseRequestPolicy {
    constructor(_nextPolicy, _options, headerKey, headerValue) {
        super(_nextPolicy, _options);
        this._nextPolicy = _nextPolicy;
        this._options = _options;
        this.headerKey = headerKey;
        this.headerValue = headerValue;
    }
    sendRequest(request) {
        this.addUserAgentHeader(request);
        return this._nextPolicy.sendRequest(request);
    }
    /**
     * Adds the user agent header to the outgoing request.
     */
    addUserAgentHeader(request) {
        if (!request.headers) {
            request.headers = new HttpHeaders();
        }
        if (!request.headers.get(this.headerKey) && this.headerValue) {
            request.headers.set(this.headerKey, this.headerValue);
        }
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * The format that will be used to join an array of values together for a query parameter value.
 */
exports.QueryCollectionFormat = void 0;
(function (QueryCollectionFormat) {
    /**
     * CSV: Each pair of segments joined by a single comma.
     */
    QueryCollectionFormat["Csv"] = ",";
    /**
     * SSV: Each pair of segments joined by a single space character.
     */
    QueryCollectionFormat["Ssv"] = " ";
    /**
     * TSV: Each pair of segments joined by a single tab character.
     */
    QueryCollectionFormat["Tsv"] = "\t";
    /**
     * Pipes: Each pair of segments joined by a single pipe character.
     */
    QueryCollectionFormat["Pipes"] = "|";
    /**
     * Denotes this is an array of values that should be passed to the server in multiple key/value pairs, e.g. `?queryParam=value1&queryParam=value2`
     */
    QueryCollectionFormat["Multi"] = "Multi";
})(exports.QueryCollectionFormat || (exports.QueryCollectionFormat = {}));

// Copyright (c) Microsoft Corporation.
// Default options for the cycler if none are provided
const DEFAULT_CYCLER_OPTIONS = {
    forcedRefreshWindowInMs: 1000,
    retryIntervalInMs: 3000,
    refreshWindowInMs: 1000 * 60 * 2, // Start refreshing 2m before expiry
};
/**
 * Converts an an unreliable access token getter (which may resolve with null)
 * into an AccessTokenGetter by retrying the unreliable getter in a regular
 * interval.
 *
 * @param getAccessToken - a function that produces a promise of an access
 * token that may fail by returning null
 * @param retryIntervalInMs - the time (in milliseconds) to wait between retry
 * attempts
 * @param timeoutInMs - the timestamp after which the refresh attempt will fail,
 * throwing an exception
 * @returns - a promise that, if it resolves, will resolve with an access token
 */
async function beginRefresh(getAccessToken, retryIntervalInMs, timeoutInMs) {
    // This wrapper handles exceptions gracefully as long as we haven't exceeded
    // the timeout.
    async function tryGetAccessToken() {
        if (Date.now() < timeoutInMs) {
            try {
                return await getAccessToken();
            }
            catch (_a) {
                return null;
            }
        }
        else {
            const finalToken = await getAccessToken();
            // Timeout is up, so throw if it's still null
            if (finalToken === null) {
                throw new Error("Failed to refresh access token.");
            }
            return finalToken;
        }
    }
    let token = await tryGetAccessToken();
    while (token === null) {
        await coreUtil.delay(retryIntervalInMs);
        token = await tryGetAccessToken();
    }
    return token;
}
/**
 * Creates a token cycler from a credential, scopes, and optional settings.
 *
 * A token cycler represents a way to reliably retrieve a valid access token
 * from a TokenCredential. It will handle initializing the token, refreshing it
 * when it nears expiration, and synchronizes refresh attempts to avoid
 * concurrency hazards.
 *
 * @param credential - the underlying TokenCredential that provides the access
 * token
 * @param scopes - the scopes to request authorization for
 * @param tokenCyclerOptions - optionally override default settings for the cycler
 *
 * @returns - a function that reliably produces a valid access token
 */
function createTokenCycler(credential, scopes, tokenCyclerOptions) {
    let refreshWorker = null;
    let token = null;
    const options = Object.assign(Object.assign({}, DEFAULT_CYCLER_OPTIONS), tokenCyclerOptions);
    /**
     * This little holder defines several predicates that we use to construct
     * the rules of refreshing the token.
     */
    const cycler = {
        /**
         * Produces true if a refresh job is currently in progress.
         */
        get isRefreshing() {
            return refreshWorker !== null;
        },
        /**
         * Produces true if the cycler SHOULD refresh (we are within the refresh
         * window and not already refreshing)
         */
        get shouldRefresh() {
            var _a;
            return (!cycler.isRefreshing &&
                ((_a = token === null || token === void 0 ? void 0 : token.expiresOnTimestamp) !== null && _a !== void 0 ? _a : 0) - options.refreshWindowInMs < Date.now());
        },
        /**
         * Produces true if the cycler MUST refresh (null or nearly-expired
         * token).
         */
        get mustRefresh() {
            return (token === null || token.expiresOnTimestamp - options.forcedRefreshWindowInMs < Date.now());
        },
    };
    /**
     * Starts a refresh job or returns the existing job if one is already
     * running.
     */
    function refresh(getTokenOptions) {
        var _a;
        if (!cycler.isRefreshing) {
            // We bind `scopes` here to avoid passing it around a lot
            const tryGetAccessToken = () => credential.getToken(scopes, getTokenOptions);
            // Take advantage of promise chaining to insert an assignment to `token`
            // before the refresh can be considered done.
            refreshWorker = beginRefresh(tryGetAccessToken, options.retryIntervalInMs, 
            // If we don't have a token, then we should timeout immediately
            (_a = token === null || token === void 0 ? void 0 : token.expiresOnTimestamp) !== null && _a !== void 0 ? _a : Date.now())
                .then((_token) => {
                refreshWorker = null;
                token = _token;
                return token;
            })
                .catch((reason) => {
                // We also should reset the refresher if we enter a failed state.  All
                // existing awaiters will throw, but subsequent requests will start a
                // new retry chain.
                refreshWorker = null;
                token = null;
                throw reason;
            });
        }
        return refreshWorker;
    }
    return async (tokenOptions) => {
        //
        // Simple rules:
        // - If we MUST refresh, then return the refresh task, blocking
        //   the pipeline until a token is available.
        // - If we SHOULD refresh, then run refresh but don't return it
        //   (we can still use the cached token).
        // - Return the token, since it's fine if we didn't return in
        //   step 1.
        //
        if (cycler.mustRefresh)
            return refresh(tokenOptions);
        if (cycler.shouldRefresh) {
            refresh(tokenOptions);
        }
        return token;
    };
}
// #endregion
/**
 * Creates a new factory for a RequestPolicy that applies a bearer token to
 * the requests' `Authorization` headers.
 *
 * @param credential - The TokenCredential implementation that can supply the bearer token.
 * @param scopes - The scopes for which the bearer token applies.
 */
function bearerTokenAuthenticationPolicy(credential, scopes) {
    // This simple function encapsulates the entire process of reliably retrieving the token
    const getToken = createTokenCycler(credential, scopes /* , options */);
    class BearerTokenAuthenticationPolicy extends BaseRequestPolicy {
        constructor(nextPolicy, options) {
            super(nextPolicy, options);
        }
        async sendRequest(webResource) {
            if (!webResource.url.toLowerCase().startsWith("https://")) {
                throw new Error("Bearer token authentication is not permitted for non-TLS protected (non-https) URLs.");
            }
            const { token } = await getToken({
                abortSignal: webResource.abortSignal,
                tracingOptions: {
                    tracingContext: webResource.tracingContext,
                },
            });
            webResource.headers.set(Constants.HeaderConstants.AUTHORIZATION, `Bearer ${token}`);
            return this._nextPolicy.sendRequest(webResource);
        }
    }
    return {
        create: (nextPolicy, options) => {
            return new BearerTokenAuthenticationPolicy(nextPolicy, options);
        },
    };
}

// Copyright (c) Microsoft Corporation.
/**
 * Returns a request policy factory that can be used to create an instance of
 * {@link DisableResponseDecompressionPolicy}.
 */
function disableResponseDecompressionPolicy() {
    return {
        create: (nextPolicy, options) => {
            return new DisableResponseDecompressionPolicy(nextPolicy, options);
        },
    };
}
/**
 * A policy to disable response decompression according to Accept-Encoding header
 * https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept-Encoding
 */
class DisableResponseDecompressionPolicy extends BaseRequestPolicy {
    /**
     * Creates an instance of DisableResponseDecompressionPolicy.
     *
     * @param nextPolicy -
     * @param options -
     */
    // The parent constructor is protected.
    /* eslint-disable-next-line @typescript-eslint/no-useless-constructor */
    constructor(nextPolicy, options) {
        super(nextPolicy, options);
    }
    /**
     * Sends out request.
     *
     * @param request -
     * @returns
     */
    async sendRequest(request) {
        request.decompressResponse = false;
        return this._nextPolicy.sendRequest(request);
    }
}

// Copyright (c) Microsoft Corporation.
/**
 * Creates a policy that assigns a unique request id to outgoing requests.
 * @param requestIdHeaderName - The name of the header to use when assigning the unique id to the request.
 */
function generateClientRequestIdPolicy(requestIdHeaderName = "x-ms-client-request-id") {
    return {
        create: (nextPolicy, options) => {
            return new GenerateClientRequestIdPolicy(nextPolicy, options, requestIdHeaderName);
        },
    };
}
class GenerateClientRequestIdPolicy extends BaseRequestPolicy {
    constructor(nextPolicy, options, _requestIdHeaderName) {
        super(nextPolicy, options);
        this._requestIdHeaderName = _requestIdHeaderName;
    }
    sendRequest(request) {
        if (!request.headers.contains(this._requestIdHeaderName)) {
            request.headers.set(this._requestIdHeaderName, request.requestId);
        }
        return this._nextPolicy.sendRequest(request);
    }
}

// Copyright (c) Microsoft Corporation.
let cachedHttpClient;
function getCachedDefaultHttpClient() {
    if (!cachedHttpClient) {
        cachedHttpClient = new NodeFetchHttpClient();
    }
    return cachedHttpClient;
}

// Copyright (c) Microsoft Corporation.
function ndJsonPolicy() {
    return {
        create: (nextPolicy, options) => {
            return new NdJsonPolicy(nextPolicy, options);
        },
    };
}
/**
 * NdJsonPolicy that formats a JSON array as newline-delimited JSON
 */
class NdJsonPolicy extends BaseRequestPolicy {
    /**
     * Creates an instance of KeepAlivePolicy.
     */
    constructor(nextPolicy, options) {
        super(nextPolicy, options);
    }
    /**
     * Sends a request.
     */
    async sendRequest(request) {
        // There currently isn't a good way to bypass the serializer
        if (typeof request.body === "string" && request.body.startsWith("[")) {
            const body = JSON.parse(request.body);
            if (Array.isArray(body)) {
                request.body = body.map((item) => JSON.stringify(item) + "\n").join("");
            }
        }
        return this._nextPolicy.sendRequest(request);
    }
}

// Copyright (c) Microsoft Corporation.
/**
 * Stores the patterns specified in NO_PROXY environment variable.
 * @internal
 */
const globalNoProxyList = [];
let noProxyListLoaded = false;
/** A cache of whether a host should bypass the proxy. */
const globalBypassedMap = new Map();
function loadEnvironmentProxyValue() {
    if (!process) {
        return undefined;
    }
    const httpsProxy = getEnvironmentValue(Constants.HTTPS_PROXY);
    const allProxy = getEnvironmentValue(Constants.ALL_PROXY);
    const httpProxy = getEnvironmentValue(Constants.HTTP_PROXY);
    return httpsProxy || allProxy || httpProxy;
}
/**
 * Check whether the host of a given `uri` matches any pattern in the no proxy list.
 * If there's a match, any request sent to the same host shouldn't have the proxy settings set.
 * This implementation is a port of https://github.com/Azure/azure-sdk-for-net/blob/8cca811371159e527159c7eb65602477898683e2/sdk/core/Azure.Core/src/Pipeline/Internal/HttpEnvironmentProxy.cs#L210
 */
function isBypassed(uri, noProxyList, bypassedMap) {
    if (noProxyList.length === 0) {
        return false;
    }
    const host = URLBuilder.parse(uri).getHost();
    if (bypassedMap === null || bypassedMap === void 0 ? void 0 : bypassedMap.has(host)) {
        return bypassedMap.get(host);
    }
    let isBypassedFlag = false;
    for (const pattern of noProxyList) {
        if (pattern[0] === ".") {
            // This should match either domain it self or any subdomain or host
            // .foo.com will match foo.com it self or *.foo.com
            if (host.endsWith(pattern)) {
                isBypassedFlag = true;
            }
            else {
                if (host.length === pattern.length - 1 && host === pattern.slice(1)) {
                    isBypassedFlag = true;
                }
            }
        }
        else {
            if (host === pattern) {
                isBypassedFlag = true;
            }
        }
    }
    bypassedMap === null || bypassedMap === void 0 ? void 0 : bypassedMap.set(host, isBypassedFlag);
    return isBypassedFlag;
}
/**
 * @internal
 */
function loadNoProxy() {
    const noProxy = getEnvironmentValue(Constants.NO_PROXY);
    noProxyListLoaded = true;
    if (noProxy) {
        return noProxy
            .split(",")
            .map((item) => item.trim())
            .filter((item) => item.length);
    }
    return [];
}
/**
 * Converts a given URL of a proxy server into `ProxySettings` or attempts to retrieve `ProxySettings` from the current environment if one is not passed.
 * @param proxyUrl - URL of the proxy
 * @returns The default proxy settings, or undefined.
 */
function getDefaultProxySettings(proxyUrl) {
    if (!proxyUrl) {
        proxyUrl = loadEnvironmentProxyValue();
        if (!proxyUrl) {
            return undefined;
        }
    }
    const { username, password, urlWithoutAuth } = extractAuthFromUrl(proxyUrl);
    const parsedUrl = URLBuilder.parse(urlWithoutAuth);
    const schema = parsedUrl.getScheme() ? parsedUrl.getScheme() + "://" : "";
    return {
        host: schema + parsedUrl.getHost(),
        port: Number.parseInt(parsedUrl.getPort() || "80"),
        username,
        password,
    };
}
/**
 * A policy that allows one to apply proxy settings to all requests.
 * If not passed static settings, they will be retrieved from the HTTPS_PROXY
 * or HTTP_PROXY environment variables.
 * @param proxySettings - ProxySettings to use on each request.
 * @param options - additional settings, for example, custom NO_PROXY patterns
 */
function proxyPolicy(proxySettings, options) {
    if (!proxySettings) {
        proxySettings = getDefaultProxySettings();
    }
    if (!noProxyListLoaded) {
        globalNoProxyList.push(...loadNoProxy());
    }
    return {
        create: (nextPolicy, requestPolicyOptions) => {
            return new ProxyPolicy(nextPolicy, requestPolicyOptions, proxySettings, options === null || options === void 0 ? void 0 : options.customNoProxyList);
        },
    };
}
function extractAuthFromUrl(url) {
    const atIndex = url.indexOf("@");
    if (atIndex === -1) {
        return { urlWithoutAuth: url };
    }
    const schemeIndex = url.indexOf("://");
    const authStart = schemeIndex !== -1 ? schemeIndex + 3 : 0;
    const auth = url.substring(authStart, atIndex);
    const colonIndex = auth.indexOf(":");
    const hasPassword = colonIndex !== -1;
    const username = hasPassword ? auth.substring(0, colonIndex) : auth;
    const password = hasPassword ? auth.substring(colonIndex + 1) : undefined;
    const urlWithoutAuth = url.substring(0, authStart) + url.substring(atIndex + 1);
    return {
        username,
        password,
        urlWithoutAuth,
    };
}
class ProxyPolicy extends BaseRequestPolicy {
    constructor(nextPolicy, options, proxySettings, customNoProxyList) {
        super(nextPolicy, options);
        this.proxySettings = proxySettings;
        this.customNoProxyList = customNoProxyList;
    }
    sendRequest(request) {
        var _a;
        if (!request.proxySettings &&
            !isBypassed(request.url, (_a = this.customNoProxyList) !== null && _a !== void 0 ? _a : globalNoProxyList, this.customNoProxyList ? undefined : globalBypassedMap)) {
            request.proxySettings = this.proxySettings;
        }
        return this._nextPolicy.sendRequest(request);
    }
}

// Copyright (c) Microsoft Corporation.
function rpRegistrationPolicy(retryTimeout = 30) {
    return {
        create: (nextPolicy, options) => {
            return new RPRegistrationPolicy(nextPolicy, options, retryTimeout);
        },
    };
}
class RPRegistrationPolicy extends BaseRequestPolicy {
    constructor(nextPolicy, options, _retryTimeout = 30) {
        super(nextPolicy, options);
        this._retryTimeout = _retryTimeout;
    }
    sendRequest(request) {
        return this._nextPolicy
            .sendRequest(request.clone())
            .then((response) => registerIfNeeded(this, request, response));
    }
}
function registerIfNeeded(policy, request, response) {
    if (response.status === 409) {
        const rpName = checkRPNotRegisteredError(response.bodyAsText);
        if (rpName) {
            const urlPrefix = extractSubscriptionUrl(request.url);
            return (registerRP(policy, urlPrefix, rpName, request)
                // Autoregistration of ${provider} failed for some reason. We will not return this error
                // instead will return the initial response with 409 status code back to the user.
                // do nothing here as we are returning the original response at the end of this method.
                .catch(() => false)
                .then((registrationStatus) => {
                if (registrationStatus) {
                    // Retry the original request. We have to change the x-ms-client-request-id
                    // otherwise Azure endpoint will return the initial 409 (cached) response.
                    request.headers.set("x-ms-client-request-id", generateUuid());
                    return policy._nextPolicy.sendRequest(request.clone());
                }
                return response;
            }));
        }
    }
    return Promise.resolve(response);
}
/**
 * Reuses the headers of the original request and url (if specified).
 * @param originalRequest - The original request
 * @param reuseUrlToo - Should the url from the original request be reused as well. Default false.
 * @returns A new request object with desired headers.
 */
function getRequestEssentials(originalRequest, reuseUrlToo = false) {
    const reqOptions = originalRequest.clone();
    if (reuseUrlToo) {
        reqOptions.url = originalRequest.url;
    }
    // We have to change the x-ms-client-request-id otherwise Azure endpoint
    // will return the initial 409 (cached) response.
    reqOptions.headers.set("x-ms-client-request-id", generateUuid());
    // Set content-type to application/json
    reqOptions.headers.set("Content-Type", "application/json; charset=utf-8");
    return reqOptions;
}
/**
 * Validates the error code and message associated with 409 response status code. If it matches to that of
 * RP not registered then it returns the name of the RP else returns undefined.
 * @param body - The response body received after making the original request.
 * @returns The name of the RP if condition is satisfied else undefined.
 */
function checkRPNotRegisteredError(body) {
    let result, responseBody;
    if (body) {
        try {
            responseBody = JSON.parse(body);
        }
        catch (err) {
            // do nothing;
        }
        if (responseBody &&
            responseBody.error &&
            responseBody.error.message &&
            responseBody.error.code &&
            responseBody.error.code === "MissingSubscriptionRegistration") {
            const matchRes = responseBody.error.message.match(/.*'(.*)'/i);
            if (matchRes) {
                result = matchRes.pop();
            }
        }
    }
    return result;
}
/**
 * Extracts the first part of the URL, just after subscription:
 * https://management.azure.com/subscriptions/00000000-0000-0000-0000-000000000000/
 * @param url - The original request url
 * @returns The url prefix as explained above.
 */
function extractSubscriptionUrl(url) {
    let result;
    const matchRes = url.match(/.*\/subscriptions\/[a-f0-9-]+\//gi);
    if (matchRes && matchRes[0]) {
        result = matchRes[0];
    }
    else {
        throw new Error(`Unable to extract subscriptionId from the given url - ${url}.`);
    }
    return result;
}
/**
 * Registers the given provider.
 * @param policy - The RPRegistrationPolicy this function is being called against.
 * @param urlPrefix - https://management.azure.com/subscriptions/00000000-0000-0000-0000-000000000000/
 * @param provider - The provider name to be registered.
 * @param originalRequest - The original request sent by the user that returned a 409 response
 * with a message that the provider is not registered.
 */
async function registerRP(policy, urlPrefix, provider, originalRequest) {
    const postUrl = `${urlPrefix}providers/${provider}/register?api-version=2016-02-01`;
    const getUrl = `${urlPrefix}providers/${provider}?api-version=2016-02-01`;
    const reqOptions = getRequestEssentials(originalRequest);
    reqOptions.method = "POST";
    reqOptions.url = postUrl;
    const response = await policy._nextPolicy.sendRequest(reqOptions);
    if (response.status !== 200) {
        throw new Error(`Autoregistration of ${provider} failed. Please try registering manually.`);
    }
    return getRegistrationStatus(policy, getUrl, originalRequest);
}
/**
 * Polls the registration status of the provider that was registered. Polling happens at an interval of 30 seconds.
 * Polling will happen till the registrationState property of the response body is "Registered".
 * @param policy - The RPRegistrationPolicy this function is being called against.
 * @param url - The request url for polling
 * @param originalRequest - The original request sent by the user that returned a 409 response
 * with a message that the provider is not registered.
 * @returns True if RP Registration is successful.
 */
async function getRegistrationStatus(policy, url, originalRequest) {
    const reqOptions = getRequestEssentials(originalRequest);
    reqOptions.url = url;
    reqOptions.method = "GET";
    const res = await policy._nextPolicy.sendRequest(reqOptions);
    const obj = res.parsedBody;
    if (res.parsedBody && obj.registrationState && obj.registrationState === "Registered") {
        return true;
    }
    else {
        await coreUtil.delay(policy._retryTimeout * 1000);
        return getRegistrationStatus(policy, url, originalRequest);
    }
}

// Copyright (c) Microsoft Corporation.
/**
 * Creates a policy that signs outgoing requests by calling to the provided `authenticationProvider`'s `signRequest` method.
 * @param authenticationProvider - The authentication provider.
 * @returns An instance of the {@link SigningPolicy}.
 */
function signingPolicy(authenticationProvider) {
    return {
        create: (nextPolicy, options) => {
            return new SigningPolicy(nextPolicy, options, authenticationProvider);
        },
    };
}
/**
 * A policy that signs outgoing requests by calling to the provided `authenticationProvider`'s `signRequest` method.
 */
class SigningPolicy extends BaseRequestPolicy {
    constructor(nextPolicy, options, authenticationProvider) {
        super(nextPolicy, options);
        this.authenticationProvider = authenticationProvider;
    }
    signRequest(request) {
        return this.authenticationProvider.signRequest(request);
    }
    sendRequest(request) {
        return this.signRequest(request).then((nextRequest) => this._nextPolicy.sendRequest(nextRequest));
    }
}

// Copyright (c) Microsoft Corporation.
/**
 * A policy that retries when there's a system error, identified by the codes "ETIMEDOUT", "ESOCKETTIMEDOUT", "ECONNREFUSED", "ECONNRESET" or "ENOENT".
 * @param retryCount - Maximum number of retries.
 * @param retryInterval - The client retry interval, in milliseconds.
 * @param minRetryInterval - The minimum retry interval, in milliseconds.
 * @param maxRetryInterval - The maximum retry interval, in milliseconds.
 * @returns An instance of the {@link SystemErrorRetryPolicy}
 */
function systemErrorRetryPolicy(retryCount, retryInterval, minRetryInterval, maxRetryInterval) {
    return {
        create: (nextPolicy, options) => {
            return new SystemErrorRetryPolicy(nextPolicy, options, retryCount, retryInterval, minRetryInterval, maxRetryInterval);
        },
    };
}
/**
 * A policy that retries when there's a system error, identified by the codes "ETIMEDOUT", "ESOCKETTIMEDOUT", "ECONNREFUSED", "ECONNRESET" or "ENOENT".
 * @param retryCount - The client retry count.
 * @param retryInterval - The client retry interval, in milliseconds.
 * @param minRetryInterval - The minimum retry interval, in milliseconds.
 * @param maxRetryInterval - The maximum retry interval, in milliseconds.
 */
class SystemErrorRetryPolicy extends BaseRequestPolicy {
    constructor(nextPolicy, options, retryCount, retryInterval, minRetryInterval, maxRetryInterval) {
        super(nextPolicy, options);
        this.retryCount = isNumber(retryCount) ? retryCount : DEFAULT_CLIENT_RETRY_COUNT;
        this.retryInterval = isNumber(retryInterval) ? retryInterval : DEFAULT_CLIENT_RETRY_INTERVAL;
        this.minRetryInterval = isNumber(minRetryInterval)
            ? minRetryInterval
            : DEFAULT_CLIENT_MIN_RETRY_INTERVAL;
        this.maxRetryInterval = isNumber(maxRetryInterval)
            ? maxRetryInterval
            : DEFAULT_CLIENT_MAX_RETRY_INTERVAL;
    }
    sendRequest(request) {
        return this._nextPolicy
            .sendRequest(request.clone())
            .catch((error) => retry(this, request, error.response, error));
    }
}
async function retry(policy, request, operationResponse, err, retryData) {
    retryData = updateRetryData(policy, retryData, err);
    function shouldPolicyRetry(_response, error) {
        if (error &&
            error.code &&
            (error.code === "ETIMEDOUT" ||
                error.code === "ESOCKETTIMEDOUT" ||
                error.code === "ECONNREFUSED" ||
                error.code === "ECONNRESET" ||
                error.code === "ENOENT")) {
            return true;
        }
        return false;
    }
    if (shouldRetry(policy.retryCount, shouldPolicyRetry, retryData, operationResponse, err)) {
        // If previous operation ended with an error and the policy allows a retry, do that
        try {
            await coreUtil.delay(retryData.retryInterval);
            return policy._nextPolicy.sendRequest(request.clone());
        }
        catch (nestedErr) {
            return retry(policy, request, operationResponse, nestedErr, retryData);
        }
    }
    else {
        if (err) {
            // If the operation failed in the end, return all errors instead of just the last one
            return Promise.reject(retryData.error);
        }
        return operationResponse;
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * Maximum number of retries for the throttling retry policy
 */
const DEFAULT_CLIENT_MAX_RETRY_COUNT = 3;

// Copyright (c) Microsoft Corporation.
const StatusCodes = Constants.HttpConstants.StatusCodes;
/**
 * Creates a policy that re-sends the request if the response indicates the request failed because of throttling reasons.
 * For example, if the response contains a `Retry-After` header, it will retry sending the request based on the value of that header.
 *
 * To learn more, please refer to
 * https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-request-limits,
 * https://docs.microsoft.com/en-us/azure/azure-subscription-service-limits and
 * https://docs.microsoft.com/en-us/azure/virtual-machines/troubleshooting/troubleshooting-throttling-errors
 * @returns
 */
function throttlingRetryPolicy() {
    return {
        create: (nextPolicy, options) => {
            return new ThrottlingRetryPolicy(nextPolicy, options);
        },
    };
}
const StandardAbortMessage = "The operation was aborted.";
/**
 * Creates a policy that re-sends the request if the response indicates the request failed because of throttling reasons.
 * For example, if the response contains a `Retry-After` header, it will retry sending the request based on the value of that header.
 *
 * To learn more, please refer to
 * https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-request-limits,
 * https://docs.microsoft.com/en-us/azure/azure-subscription-service-limits and
 * https://docs.microsoft.com/en-us/azure/virtual-machines/troubleshooting/troubleshooting-throttling-errors
 */
class ThrottlingRetryPolicy extends BaseRequestPolicy {
    constructor(nextPolicy, options, _handleResponse) {
        super(nextPolicy, options);
        this.numberOfRetries = 0;
        this._handleResponse = _handleResponse || this._defaultResponseHandler;
    }
    async sendRequest(httpRequest) {
        const response = await this._nextPolicy.sendRequest(httpRequest.clone());
        if (response.status !== StatusCodes.TooManyRequests &&
            response.status !== StatusCodes.ServiceUnavailable) {
            return response;
        }
        else {
            return this._handleResponse(httpRequest, response);
        }
    }
    async _defaultResponseHandler(httpRequest, httpResponse) {
        var _a;
        const retryAfterHeader = httpResponse.headers.get(Constants.HeaderConstants.RETRY_AFTER);
        if (retryAfterHeader) {
            const delayInMs = ThrottlingRetryPolicy.parseRetryAfterHeader(retryAfterHeader);
            if (delayInMs) {
                this.numberOfRetries += 1;
                await coreUtil.delay(delayInMs, {
                    abortSignal: httpRequest.abortSignal,
                    abortErrorMsg: StandardAbortMessage,
                });
                if ((_a = httpRequest.abortSignal) === null || _a === void 0 ? void 0 : _a.aborted) {
                    throw new abortController.AbortError(StandardAbortMessage);
                }
                if (this.numberOfRetries < DEFAULT_CLIENT_MAX_RETRY_COUNT) {
                    return this.sendRequest(httpRequest);
                }
                else {
                    return this._nextPolicy.sendRequest(httpRequest);
                }
            }
        }
        return httpResponse;
    }
    static parseRetryAfterHeader(headerValue) {
        const retryAfterInSeconds = Number(headerValue);
        if (Number.isNaN(retryAfterInSeconds)) {
            return ThrottlingRetryPolicy.parseDateRetryAfterHeader(headerValue);
        }
        else {
            return retryAfterInSeconds * 1000;
        }
    }
    static parseDateRetryAfterHeader(headerValue) {
        try {
            const now = Date.now();
            const date = Date.parse(headerValue);
            const diff = date - now;
            return Number.isNaN(diff) ? undefined : diff;
        }
        catch (error) {
            return undefined;
        }
    }
}

// Copyright (c) Microsoft Corporation.
const createSpan = coreTracing.createSpanFunction({
    packagePrefix: "",
    namespace: "",
});
/**
 * Creates a policy that wraps outgoing requests with a tracing span.
 * @param tracingOptions - Tracing options.
 * @returns An instance of the {@link TracingPolicy} class.
 */
function tracingPolicy(tracingOptions = {}) {
    return {
        create(nextPolicy, options) {
            return new TracingPolicy(nextPolicy, options, tracingOptions);
        },
    };
}
/**
 * A policy that wraps outgoing requests with a tracing span.
 */
class TracingPolicy extends BaseRequestPolicy {
    constructor(nextPolicy, options, tracingOptions) {
        super(nextPolicy, options);
        this.userAgent = tracingOptions.userAgent;
    }
    async sendRequest(request) {
        if (!request.tracingContext) {
            return this._nextPolicy.sendRequest(request);
        }
        const span = this.tryCreateSpan(request);
        if (!span) {
            return this._nextPolicy.sendRequest(request);
        }
        try {
            const response = await this._nextPolicy.sendRequest(request);
            this.tryProcessResponse(span, response);
            return response;
        }
        catch (err) {
            this.tryProcessError(span, err);
            throw err;
        }
    }
    tryCreateSpan(request) {
        var _a;
        try {
            // Passing spanOptions as part of tracingOptions to maintain compatibility @azure/core-tracing@preview.13 and earlier.
            // We can pass this as a separate parameter once we upgrade to the latest core-tracing.
            const { span } = createSpan(`HTTP ${request.method}`, {
                tracingOptions: {
                    spanOptions: Object.assign(Object.assign({}, request.spanOptions), { kind: coreTracing.SpanKind.CLIENT }),
                    tracingContext: request.tracingContext,
                },
            });
            // If the span is not recording, don't do any more work.
            if (!span.isRecording()) {
                span.end();
                return undefined;
            }
            const namespaceFromContext = (_a = request.tracingContext) === null || _a === void 0 ? void 0 : _a.getValue(Symbol.for("az.namespace"));
            if (typeof namespaceFromContext === "string") {
                span.setAttribute("az.namespace", namespaceFromContext);
            }
            span.setAttributes({
                "http.method": request.method,
                "http.url": request.url,
                requestId: request.requestId,
            });
            if (this.userAgent) {
                span.setAttribute("http.user_agent", this.userAgent);
            }
            // set headers
            const spanContext = span.spanContext();
            const traceParentHeader = coreTracing.getTraceParentHeader(spanContext);
            if (traceParentHeader && coreTracing.isSpanContextValid(spanContext)) {
                request.headers.set("traceparent", traceParentHeader);
                const traceState = spanContext.traceState && spanContext.traceState.serialize();
                // if tracestate is set, traceparent MUST be set, so only set tracestate after traceparent
                if (traceState) {
                    request.headers.set("tracestate", traceState);
                }
            }
            return span;
        }
        catch (error) {
            logger.warning(`Skipping creating a tracing span due to an error: ${error.message}`);
            return undefined;
        }
    }
    tryProcessError(span, err) {
        try {
            span.setStatus({
                code: coreTracing.SpanStatusCode.ERROR,
                message: err.message,
            });
            if (err.statusCode) {
                span.setAttribute("http.status_code", err.statusCode);
            }
            span.end();
        }
        catch (error) {
            logger.warning(`Skipping tracing span processing due to an error: ${error.message}`);
        }
    }
    tryProcessResponse(span, response) {
        try {
            span.setAttribute("http.status_code", response.status);
            const serviceRequestId = response.headers.get("x-ms-request-id");
            if (serviceRequestId) {
                span.setAttribute("serviceRequestId", serviceRequestId);
            }
            span.setStatus({
                code: coreTracing.SpanStatusCode.OK,
            });
            span.end();
        }
        catch (error) {
            logger.warning(`Skipping tracing span processing due to an error: ${error.message}`);
        }
    }
}

// Copyright (c) Microsoft Corporation.
/**
 * ServiceClient sends service requests and receives responses.
 */
class ServiceClient {
    /**
     * The ServiceClient constructor
     * @param credentials - The credentials used for authentication with the service.
     * @param options - The service client options that govern the behavior of the client.
     */
    constructor(credentials, 
    /* eslint-disable-next-line @azure/azure-sdk/ts-naming-options */
    options) {
        if (!options) {
            options = {};
        }
        this._withCredentials = options.withCredentials || false;
        this._httpClient = options.httpClient || getCachedDefaultHttpClient();
        this._requestPolicyOptions = new RequestPolicyOptions(options.httpPipelineLogger);
        let requestPolicyFactories;
        if (Array.isArray(options.requestPolicyFactories)) {
            logger.info("ServiceClient: using custom request policies");
            requestPolicyFactories = options.requestPolicyFactories;
        }
        else {
            let authPolicyFactory = undefined;
            if (coreAuth.isTokenCredential(credentials)) {
                logger.info("ServiceClient: creating bearer token authentication policy from provided credentials");
                // Create a wrapped RequestPolicyFactory here so that we can provide the
                // correct scope to the BearerTokenAuthenticationPolicy at the first time
                // one is requested.  This is needed because generated ServiceClient
                // implementations do not set baseUri until after ServiceClient's constructor
                // is finished, leaving baseUri empty at the time when it is needed to
                // build the correct scope name.
                const wrappedPolicyFactory = () => {
                    let bearerTokenPolicyFactory = undefined;
                    // eslint-disable-next-line @typescript-eslint/no-this-alias
                    const serviceClient = this;
                    const serviceClientOptions = options;
                    return {
                        create(nextPolicy, createOptions) {
                            const credentialScopes = getCredentialScopes(serviceClientOptions, serviceClient.baseUri);
                            if (!credentialScopes) {
                                throw new Error(`When using credential, the ServiceClient must contain a baseUri or a credentialScopes in ServiceClientOptions. Unable to create a bearerTokenAuthenticationPolicy`);
                            }
                            if (bearerTokenPolicyFactory === undefined || bearerTokenPolicyFactory === null) {
                                bearerTokenPolicyFactory = bearerTokenAuthenticationPolicy(credentials, credentialScopes);
                            }
                            return bearerTokenPolicyFactory.create(nextPolicy, createOptions);
                        },
                    };
                };
                authPolicyFactory = wrappedPolicyFactory();
            }
            else if (credentials && typeof credentials.signRequest === "function") {
                logger.info("ServiceClient: creating signing policy from provided credentials");
                authPolicyFactory = signingPolicy(credentials);
            }
            else if (credentials !== undefined && credentials !== null) {
                throw new Error("The credentials argument must implement the TokenCredential interface");
            }
            logger.info("ServiceClient: using default request policies");
            requestPolicyFactories = createDefaultRequestPolicyFactories(authPolicyFactory, options);
            if (options.requestPolicyFactories) {
                // options.requestPolicyFactories can also be a function that manipulates
                // the default requestPolicyFactories array
                const newRequestPolicyFactories = options.requestPolicyFactories(requestPolicyFactories);
                if (newRequestPolicyFactories) {
                    requestPolicyFactories = newRequestPolicyFactories;
                }
            }
        }
        this._requestPolicyFactories = requestPolicyFactories;
    }
    /**
     * Send the provided httpRequest.
     */
    sendRequest(options) {
        if (options === null || options === undefined || typeof options !== "object") {
            throw new Error("options cannot be null or undefined and it must be of type object.");
        }
        let httpRequest;
        try {
            if (isWebResourceLike(options)) {
                options.validateRequestProperties();
                httpRequest = options;
            }
            else {
                httpRequest = new WebResource();
                httpRequest = httpRequest.prepare(options);
            }
        }
        catch (error) {
            return Promise.reject(error);
        }
        let httpPipeline = this._httpClient;
        if (this._requestPolicyFactories && this._requestPolicyFactories.length > 0) {
            for (let i = this._requestPolicyFactories.length - 1; i >= 0; --i) {
                httpPipeline = this._requestPolicyFactories[i].create(httpPipeline, this._requestPolicyOptions);
            }
        }
        return httpPipeline.sendRequest(httpRequest);
    }
    /**
     * Send an HTTP request that is populated using the provided OperationSpec.
     * @param operationArguments - The arguments that the HTTP request's templated values will be populated from.
     * @param operationSpec - The OperationSpec to use to populate the httpRequest.
     * @param callback - The callback to call when the response is received.
     */
    async sendOperationRequest(operationArguments, operationSpec, callback) {
        var _a;
        if (typeof operationArguments.options === "function") {
            callback = operationArguments.options;
            operationArguments.options = undefined;
        }
        const serializerOptions = (_a = operationArguments.options) === null || _a === void 0 ? void 0 : _a.serializerOptions;
        const httpRequest = new WebResource();
        let result;
        try {
            const baseUri = operationSpec.baseUrl || this.baseUri;
            if (!baseUri) {
                throw new Error("If operationSpec.baseUrl is not specified, then the ServiceClient must have a baseUri string property that contains the base URL to use.");
            }
            httpRequest.method = operationSpec.httpMethod;
            httpRequest.operationSpec = operationSpec;
            const requestUrl = URLBuilder.parse(baseUri);
            if (operationSpec.path) {
                requestUrl.appendPath(operationSpec.path);
            }
            if (operationSpec.urlParameters && operationSpec.urlParameters.length > 0) {
                for (const urlParameter of operationSpec.urlParameters) {
                    let urlParameterValue = getOperationArgumentValueFromParameter(this, operationArguments, urlParameter, operationSpec.serializer);
                    urlParameterValue = operationSpec.serializer.serialize(urlParameter.mapper, urlParameterValue, getPathStringFromParameter(urlParameter), serializerOptions);
                    if (!urlParameter.skipEncoding) {
                        urlParameterValue = encodeURIComponent(urlParameterValue);
                    }
                    requestUrl.replaceAll(`{${urlParameter.mapper.serializedName || getPathStringFromParameter(urlParameter)}}`, urlParameterValue);
                }
            }
            if (operationSpec.queryParameters && operationSpec.queryParameters.length > 0) {
                for (const queryParameter of operationSpec.queryParameters) {
                    let queryParameterValue = getOperationArgumentValueFromParameter(this, operationArguments, queryParameter, operationSpec.serializer);
                    if (queryParameterValue !== undefined && queryParameterValue !== null) {
                        queryParameterValue = operationSpec.serializer.serialize(queryParameter.mapper, queryParameterValue, getPathStringFromParameter(queryParameter), serializerOptions);
                        if (queryParameter.collectionFormat !== undefined &&
                            queryParameter.collectionFormat !== null) {
                            if (queryParameter.collectionFormat === exports.QueryCollectionFormat.Multi) {
                                if (queryParameterValue.length === 0) {
                                    // The collection is empty, no need to try serializing the current queryParam
                                    continue;
                                }
                                else {
                                    for (const index in queryParameterValue) {
                                        const item = queryParameterValue[index];
                                        queryParameterValue[index] =
                                            item === undefined || item === null ? "" : item.toString();
                                    }
                                }
                            }
                            else if (queryParameter.collectionFormat === exports.QueryCollectionFormat.Ssv ||
                                queryParameter.collectionFormat === exports.QueryCollectionFormat.Tsv) {
                                queryParameterValue = queryParameterValue.join(queryParameter.collectionFormat);
                            }
                        }
                        if (!queryParameter.skipEncoding) {
                            if (Array.isArray(queryParameterValue)) {
                                for (const index in queryParameterValue) {
                                    if (queryParameterValue[index] !== undefined &&
                                        queryParameterValue[index] !== null) {
                                        queryParameterValue[index] = encodeURIComponent(queryParameterValue[index]);
                                    }
                                }
                            }
                            else {
                                queryParameterValue = encodeURIComponent(queryParameterValue);
                            }
                        }
                        if (queryParameter.collectionFormat !== undefined &&
                            queryParameter.collectionFormat !== null &&
                            queryParameter.collectionFormat !== exports.QueryCollectionFormat.Multi &&
                            queryParameter.collectionFormat !== exports.QueryCollectionFormat.Ssv &&
                            queryParameter.collectionFormat !== exports.QueryCollectionFormat.Tsv) {
                            queryParameterValue = queryParameterValue.join(queryParameter.collectionFormat);
                        }
                        requestUrl.setQueryParameter(queryParameter.mapper.serializedName || getPathStringFromParameter(queryParameter), queryParameterValue);
                    }
                }
            }
            httpRequest.url = requestUrl.toString();
            const contentType = operationSpec.contentType || this.requestContentType;
            if (contentType && operationSpec.requestBody) {
                httpRequest.headers.set("Content-Type", contentType);
            }
            if (operationSpec.headerParameters) {
                for (const headerParameter of operationSpec.headerParameters) {
                    let headerValue = getOperationArgumentValueFromParameter(this, operationArguments, headerParameter, operationSpec.serializer);
                    if (headerValue !== undefined && headerValue !== null) {
                        headerValue = operationSpec.serializer.serialize(headerParameter.mapper, headerValue, getPathStringFromParameter(headerParameter), serializerOptions);
                        const headerCollectionPrefix = headerParameter.mapper
                            .headerCollectionPrefix;
                        if (headerCollectionPrefix) {
                            for (const key of Object.keys(headerValue)) {
                                httpRequest.headers.set(headerCollectionPrefix + key, headerValue[key]);
                            }
                        }
                        else {
                            httpRequest.headers.set(headerParameter.mapper.serializedName ||
                                getPathStringFromParameter(headerParameter), headerValue);
                        }
                    }
                }
            }
            const options = operationArguments.options;
            if (options) {
                if (options.customHeaders) {
                    for (const customHeaderName in options.customHeaders) {
                        httpRequest.headers.set(customHeaderName, options.customHeaders[customHeaderName]);
                    }
                }
                if (options.abortSignal) {
                    httpRequest.abortSignal = options.abortSignal;
                }
                if (options.timeout) {
                    httpRequest.timeout = options.timeout;
                }
                if (options.onUploadProgress) {
                    httpRequest.onUploadProgress = options.onUploadProgress;
                }
                if (options.onDownloadProgress) {
                    httpRequest.onDownloadProgress = options.onDownloadProgress;
                }
                if (options.spanOptions) {
                    // By passing spanOptions if they exist at runtime, we're backwards compatible with @azure/core-tracing@preview.13 and earlier.
                    httpRequest.spanOptions = options.spanOptions;
                }
                if (options.tracingContext) {
                    httpRequest.tracingContext = options.tracingContext;
                }
                if (options.shouldDeserialize !== undefined && options.shouldDeserialize !== null) {
                    httpRequest.shouldDeserialize = options.shouldDeserialize;
                }
            }
            httpRequest.withCredentials = this._withCredentials;
            serializeRequestBody(this, httpRequest, operationArguments, operationSpec);
            if (httpRequest.streamResponseStatusCodes === undefined) {
                httpRequest.streamResponseStatusCodes = getStreamResponseStatusCodes(operationSpec);
            }
            let rawResponse;
            let sendRequestError;
            try {
                rawResponse = await this.sendRequest(httpRequest);
            }
            catch (error) {
                sendRequestError = error;
            }
            if (sendRequestError) {
                if (sendRequestError.response) {
                    sendRequestError.details = flattenResponse(sendRequestError.response, operationSpec.responses[sendRequestError.statusCode] ||
                        operationSpec.responses["default"]);
                }
                result = Promise.reject(sendRequestError);
            }
            else {
                result = Promise.resolve(flattenResponse(rawResponse, operationSpec.responses[rawResponse.status]));
            }
        }
        catch (error) {
            result = Promise.reject(error);
        }
        const cb = callback;
        if (cb) {
            result
                .then((res) => cb(null, res._response.parsedBody, res._response.request, res._response))
                .catch((err) => cb(err));
        }
        return result;
    }
}
function serializeRequestBody(serviceClient, httpRequest, operationArguments, operationSpec) {
    var _a, _b, _c, _d, _e, _f;
    const serializerOptions = (_b = (_a = operationArguments.options) === null || _a === void 0 ? void 0 : _a.serializerOptions) !== null && _b !== void 0 ? _b : {};
    const updatedOptions = {
        rootName: (_c = serializerOptions.rootName) !== null && _c !== void 0 ? _c : "",
        includeRoot: (_d = serializerOptions.includeRoot) !== null && _d !== void 0 ? _d : false,
        xmlCharKey: (_e = serializerOptions.xmlCharKey) !== null && _e !== void 0 ? _e : XML_CHARKEY,
    };
    const xmlCharKey = serializerOptions.xmlCharKey;
    if (operationSpec.requestBody && operationSpec.requestBody.mapper) {
        httpRequest.body = getOperationArgumentValueFromParameter(serviceClient, operationArguments, operationSpec.requestBody, operationSpec.serializer);
        const bodyMapper = operationSpec.requestBody.mapper;
        const { required, xmlName, xmlElementName, serializedName, xmlNamespace, xmlNamespacePrefix } = bodyMapper;
        const typeName = bodyMapper.type.name;
        try {
            if ((httpRequest.body !== undefined && httpRequest.body !== null) || required) {
                const requestBodyParameterPathString = getPathStringFromParameter(operationSpec.requestBody);
                httpRequest.body = operationSpec.serializer.serialize(bodyMapper, httpRequest.body, requestBodyParameterPathString, updatedOptions);
                const isStream = typeName === MapperType.Stream;
                if (operationSpec.isXML) {
                    const xmlnsKey = xmlNamespacePrefix ? `xmlns:${xmlNamespacePrefix}` : "xmlns";
                    const value = getXmlValueWithNamespace(xmlNamespace, xmlnsKey, typeName, httpRequest.body, updatedOptions);
                    if (typeName === MapperType.Sequence) {
                        httpRequest.body = stringifyXML(prepareXMLRootList(value, xmlElementName || xmlName || serializedName, xmlnsKey, xmlNamespace), {
                            rootName: xmlName || serializedName,
                            xmlCharKey,
                        });
                    }
                    else if (!isStream) {
                        httpRequest.body = stringifyXML(value, {
                            rootName: xmlName || serializedName,
                            xmlCharKey,
                        });
                    }
                }
                else if (typeName === MapperType.String &&
                    (((_f = operationSpec.contentType) === null || _f === void 0 ? void 0 : _f.match("text/plain")) || operationSpec.mediaType === "text")) {
                    // the String serializer has validated that request body is a string
                    // so just send the string.
                    return;
                }
                else if (!isStream) {
                    httpRequest.body = JSON.stringify(httpRequest.body);
                }
            }
        }
        catch (error) {
            throw new Error(`Error "${error.message}" occurred in serializing the payload - ${JSON.stringify(serializedName, undefined, "  ")}.`);
        }
    }
    else if (operationSpec.formDataParameters && operationSpec.formDataParameters.length > 0) {
        httpRequest.formData = {};
        for (const formDataParameter of operationSpec.formDataParameters) {
            const formDataParameterValue = getOperationArgumentValueFromParameter(serviceClient, operationArguments, formDataParameter, operationSpec.serializer);
            if (formDataParameterValue !== undefined && formDataParameterValue !== null) {
                const formDataParameterPropertyName = formDataParameter.mapper.serializedName || getPathStringFromParameter(formDataParameter);
                httpRequest.formData[formDataParameterPropertyName] = operationSpec.serializer.serialize(formDataParameter.mapper, formDataParameterValue, getPathStringFromParameter(formDataParameter), updatedOptions);
            }
        }
    }
}
/**
 * Adds an xml namespace to the xml serialized object if needed, otherwise it just returns the value itself
 */
function getXmlValueWithNamespace(xmlNamespace, xmlnsKey, typeName, serializedValue, options) {
    // Composite and Sequence schemas already got their root namespace set during serialization
    // We just need to add xmlns to the other schema types
    if (xmlNamespace && !["Composite", "Sequence", "Dictionary"].includes(typeName)) {
        const result = {};
        result[options.xmlCharKey] = serializedValue;
        result[XML_ATTRKEY] = { [xmlnsKey]: xmlNamespace };
        return result;
    }
    return serializedValue;
}
function getValueOrFunctionResult(value, defaultValueCreator) {
    let result;
    if (typeof value === "string") {
        result = value;
    }
    else {
        result = defaultValueCreator();
        if (typeof value === "function") {
            result = value(result);
        }
    }
    return result;
}
function createDefaultRequestPolicyFactories(authPolicyFactory, options) {
    const factories = [];
    if (options.generateClientRequestIdHeader) {
        factories.push(generateClientRequestIdPolicy(options.clientRequestIdHeaderName));
    }
    if (authPolicyFactory) {
        factories.push(authPolicyFactory);
    }
    const userAgentHeaderName = getValueOrFunctionResult(options.userAgentHeaderName, getDefaultUserAgentHeaderName);
    const userAgentHeaderValue = getValueOrFunctionResult(options.userAgent, getDefaultUserAgentValue);
    if (userAgentHeaderName && userAgentHeaderValue) {
        factories.push(userAgentPolicy({ key: userAgentHeaderName, value: userAgentHeaderValue }));
    }
    factories.push(redirectPolicy());
    factories.push(rpRegistrationPolicy(options.rpRegistrationRetryTimeout));
    if (!options.noRetryPolicy) {
        factories.push(exponentialRetryPolicy());
        factories.push(systemErrorRetryPolicy());
        factories.push(throttlingRetryPolicy());
    }
    factories.push(deserializationPolicy(options.deserializationContentTypes));
    if (coreUtil.isNode) {
        factories.push(proxyPolicy(options.proxySettings));
    }
    factories.push(logPolicy({ logger: logger.info }));
    return factories;
}
/**
 * Creates an HTTP pipeline based on the given options.
 * @param pipelineOptions - Defines options that are used to configure policies in the HTTP pipeline for an SDK client.
 * @param authPolicyFactory - An optional authentication policy factory to use for signing requests.
 * @returns A set of options that can be passed to create a new {@link ServiceClient}.
 */
function createPipelineFromOptions(pipelineOptions, authPolicyFactory) {
    const requestPolicyFactories = [];
    if (pipelineOptions.sendStreamingJson) {
        requestPolicyFactories.push(ndJsonPolicy());
    }
    let userAgentValue = undefined;
    if (pipelineOptions.userAgentOptions && pipelineOptions.userAgentOptions.userAgentPrefix) {
        const userAgentInfo = [];
        userAgentInfo.push(pipelineOptions.userAgentOptions.userAgentPrefix);
        // Add the default user agent value if it isn't already specified
        // by the userAgentPrefix option.
        const defaultUserAgentInfo = getDefaultUserAgentValue();
        if (userAgentInfo.indexOf(defaultUserAgentInfo) === -1) {
            userAgentInfo.push(defaultUserAgentInfo);
        }
        userAgentValue = userAgentInfo.join(" ");
    }
    const keepAliveOptions = Object.assign(Object.assign({}, DefaultKeepAliveOptions), pipelineOptions.keepAliveOptions);
    const retryOptions = Object.assign(Object.assign({}, DefaultRetryOptions), pipelineOptions.retryOptions);
    const redirectOptions = Object.assign(Object.assign({}, DefaultRedirectOptions), pipelineOptions.redirectOptions);
    if (coreUtil.isNode) {
        requestPolicyFactories.push(proxyPolicy(pipelineOptions.proxyOptions));
    }
    const deserializationOptions = Object.assign(Object.assign({}, DefaultDeserializationOptions), pipelineOptions.deserializationOptions);
    const loggingOptions = Object.assign({}, pipelineOptions.loggingOptions);
    requestPolicyFactories.push(tracingPolicy({ userAgent: userAgentValue }), keepAlivePolicy(keepAliveOptions), userAgentPolicy({ value: userAgentValue }), generateClientRequestIdPolicy(), deserializationPolicy(deserializationOptions.expectedContentTypes), throttlingRetryPolicy(), systemErrorRetryPolicy(), exponentialRetryPolicy(retryOptions.maxRetries, retryOptions.retryDelayInMs, retryOptions.maxRetryDelayInMs));
    if (redirectOptions.handleRedirects) {
        requestPolicyFactories.push(redirectPolicy(redirectOptions.maxRetries));
    }
    if (authPolicyFactory) {
        requestPolicyFactories.push(authPolicyFactory);
    }
    requestPolicyFactories.push(logPolicy(loggingOptions));
    if (coreUtil.isNode && pipelineOptions.decompressResponse === false) {
        requestPolicyFactories.push(disableResponseDecompressionPolicy());
    }
    return {
        httpClient: pipelineOptions.httpClient,
        requestPolicyFactories,
    };
}
function getOperationArgumentValueFromParameter(serviceClient, operationArguments, parameter, serializer) {
    return getOperationArgumentValueFromParameterPath(serviceClient, operationArguments, parameter.parameterPath, parameter.mapper, serializer);
}
function getOperationArgumentValueFromParameterPath(serviceClient, operationArguments, parameterPath, parameterMapper, serializer) {
    var _a;
    let value;
    if (typeof parameterPath === "string") {
        parameterPath = [parameterPath];
    }
    const serializerOptions = (_a = operationArguments.options) === null || _a === void 0 ? void 0 : _a.serializerOptions;
    if (Array.isArray(parameterPath)) {
        if (parameterPath.length > 0) {
            if (parameterMapper.isConstant) {
                value = parameterMapper.defaultValue;
            }
            else {
                let propertySearchResult = getPropertyFromParameterPath(operationArguments, parameterPath);
                if (!propertySearchResult.propertyFound) {
                    propertySearchResult = getPropertyFromParameterPath(serviceClient, parameterPath);
                }
                let useDefaultValue = false;
                if (!propertySearchResult.propertyFound) {
                    useDefaultValue =
                        parameterMapper.required ||
                            (parameterPath[0] === "options" && parameterPath.length === 2);
                }
                value = useDefaultValue ? parameterMapper.defaultValue : propertySearchResult.propertyValue;
            }
            // Serialize just for validation purposes.
            const parameterPathString = getPathStringFromParameterPath(parameterPath, parameterMapper);
            serializer.serialize(parameterMapper, value, parameterPathString, serializerOptions);
        }
    }
    else {
        if (parameterMapper.required) {
            value = {};
        }
        for (const propertyName in parameterPath) {
            const propertyMapper = parameterMapper.type.modelProperties[propertyName];
            const propertyPath = parameterPath[propertyName];
            const propertyValue = getOperationArgumentValueFromParameterPath(serviceClient, operationArguments, propertyPath, propertyMapper, serializer);
            // Serialize just for validation purposes.
            const propertyPathString = getPathStringFromParameterPath(propertyPath, propertyMapper);
            serializer.serialize(propertyMapper, propertyValue, propertyPathString, serializerOptions);
            if (propertyValue !== undefined && propertyValue !== null) {
                if (!value) {
                    value = {};
                }
                value[propertyName] = propertyValue;
            }
        }
    }
    return value;
}
function getPropertyFromParameterPath(parent, parameterPath) {
    const result = { propertyFound: false };
    let i = 0;
    for (; i < parameterPath.length; ++i) {
        const parameterPathPart = parameterPath[i];
        // Make sure to check inherited properties too, so don't use hasOwnProperty().
        if (parent !== undefined && parent !== null && parameterPathPart in parent) {
            parent = parent[parameterPathPart];
        }
        else {
            break;
        }
    }
    if (i === parameterPath.length) {
        result.propertyValue = parent;
        result.propertyFound = true;
    }
    return result;
}
/**
 * Parses an {@link HttpOperationResponse} into a normalized HTTP response object ({@link RestResponse}).
 * @param _response - Wrapper object for http response.
 * @param responseSpec - Mappers for how to parse the response properties.
 * @returns - A normalized response object.
 */
function flattenResponse(_response, responseSpec) {
    const parsedHeaders = _response.parsedHeaders;
    const bodyMapper = responseSpec && responseSpec.bodyMapper;
    const addOperationResponse = (obj) => {
        return Object.defineProperty(obj, "_response", {
            value: _response,
        });
    };
    if (bodyMapper) {
        const typeName = bodyMapper.type.name;
        if (typeName === "Stream") {
            return addOperationResponse(Object.assign(Object.assign({}, parsedHeaders), { blobBody: _response.blobBody, readableStreamBody: _response.readableStreamBody }));
        }
        const modelProperties = (typeName === "Composite" && bodyMapper.type.modelProperties) || {};
        const isPageableResponse = Object.keys(modelProperties).some((k) => modelProperties[k].serializedName === "");
        if (typeName === "Sequence" || isPageableResponse) {
            const arrayResponse = [...(_response.parsedBody || [])];
            for (const key of Object.keys(modelProperties)) {
                if (modelProperties[key].serializedName) {
                    arrayResponse[key] = _response.parsedBody[key];
                }
            }
            if (parsedHeaders) {
                for (const key of Object.keys(parsedHeaders)) {
                    arrayResponse[key] = parsedHeaders[key];
                }
            }
            addOperationResponse(arrayResponse);
            return arrayResponse;
        }
        if (typeName === "Composite" || typeName === "Dictionary") {
            return addOperationResponse(Object.assign(Object.assign({}, parsedHeaders), _response.parsedBody));
        }
    }
    if (bodyMapper ||
        _response.request.method === "HEAD" ||
        isPrimitiveType(_response.parsedBody)) {
        // primitive body types and HEAD booleans
        return addOperationResponse(Object.assign(Object.assign({}, parsedHeaders), { body: _response.parsedBody }));
    }
    return addOperationResponse(Object.assign(Object.assign({}, parsedHeaders), _response.parsedBody));
}
function getCredentialScopes(options, baseUri) {
    if (options === null || options === void 0 ? void 0 : options.credentialScopes) {
        return options.credentialScopes;
    }
    if (baseUri) {
        return `${baseUri}/.default`;
    }
    return undefined;
}

// Copyright (c) Microsoft Corporation.
/**
 * This function is only here for compatibility. Use createSpanFunction in core-tracing.
 *
 * @deprecated This function is only here for compatibility. Use createSpanFunction in core-tracing.
 * @hidden

 * @param spanConfig - The name of the operation being performed.
 * @param tracingOptions - The options for the underlying http request.
 */
function createSpanFunction(args) {
    return coreTracing.createSpanFunction(args);
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * Defines the default token refresh buffer duration.
 */
const TokenRefreshBufferMs = 2 * 60 * 1000; // 2 Minutes
/**
 * Provides an {@link AccessTokenCache} implementation which clears
 * the cached {@link AccessToken}'s after the expiresOnTimestamp has
 * passed.
 *
 * @deprecated No longer used in the bearer authorization policy.
 */
class ExpiringAccessTokenCache {
    /**
     * Constructs an instance of {@link ExpiringAccessTokenCache} with
     * an optional expiration buffer time.
     */
    constructor(tokenRefreshBufferMs = TokenRefreshBufferMs) {
        this.cachedToken = undefined;
        this.tokenRefreshBufferMs = tokenRefreshBufferMs;
    }
    /**
     * Saves an access token into the internal in-memory cache.
     * @param accessToken - Access token or undefined to clear the cache.
     */
    setCachedToken(accessToken) {
        this.cachedToken = accessToken;
    }
    /**
     * Returns the cached access token, or `undefined` if one is not cached or the cached one is expiring soon.
     */
    getCachedToken() {
        if (this.cachedToken &&
            Date.now() + this.tokenRefreshBufferMs >= this.cachedToken.expiresOnTimestamp) {
            this.cachedToken = undefined;
        }
        return this.cachedToken;
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * Helps the core-http token authentication policies with requesting a new token if we're not currently waiting for a new token.
 *
 * @deprecated No longer used in the bearer authorization policy.
 */
class AccessTokenRefresher {
    constructor(credential, scopes, requiredMillisecondsBeforeNewRefresh = 30000) {
        this.credential = credential;
        this.scopes = scopes;
        this.requiredMillisecondsBeforeNewRefresh = requiredMillisecondsBeforeNewRefresh;
        this.lastCalled = 0;
    }
    /**
     * Returns true if the required milliseconds(defaulted to 30000) have been passed signifying
     * that we are ready for a new refresh.
     */
    isReady() {
        // We're only ready for a new refresh if the required milliseconds have passed.
        return (!this.lastCalled || Date.now() - this.lastCalled > this.requiredMillisecondsBeforeNewRefresh);
    }
    /**
     * Stores the time in which it is called,
     * then requests a new token,
     * then sets this.promise to undefined,
     * then returns the token.
     */
    async getToken(options) {
        this.lastCalled = Date.now();
        const token = await this.credential.getToken(this.scopes, options);
        this.promise = undefined;
        return token || undefined;
    }
    /**
     * Requests a new token if we're not currently waiting for a new token.
     * Returns null if the required time between each call hasn't been reached.
     */
    refresh(options) {
        if (!this.promise) {
            this.promise = this.getToken(options);
        }
        return this.promise;
    }
}

// Copyright (c) Microsoft Corporation.
const HeaderConstants = Constants.HeaderConstants;
const DEFAULT_AUTHORIZATION_SCHEME = "Basic";
/**
 * A simple {@link ServiceClientCredential} that authenticates with a username and a password.
 */
class BasicAuthenticationCredentials {
    /**
     * Creates a new BasicAuthenticationCredentials object.
     *
     * @param userName - User name.
     * @param password - Password.
     * @param authorizationScheme - The authorization scheme.
     */
    constructor(userName, password, authorizationScheme = DEFAULT_AUTHORIZATION_SCHEME) {
        /**
         * Authorization scheme. Defaults to "Basic".
         * More information about authorization schemes is available here: https://developer.mozilla.org/docs/Web/HTTP/Authentication#authentication_schemes
         */
        this.authorizationScheme = DEFAULT_AUTHORIZATION_SCHEME;
        if (userName === null || userName === undefined || typeof userName.valueOf() !== "string") {
            throw new Error("userName cannot be null or undefined and must be of type string.");
        }
        if (password === null || password === undefined || typeof password.valueOf() !== "string") {
            throw new Error("password cannot be null or undefined and must be of type string.");
        }
        this.userName = userName;
        this.password = password;
        this.authorizationScheme = authorizationScheme;
    }
    /**
     * Signs a request with the Authentication header.
     *
     * @param webResource - The WebResourceLike to be signed.
     * @returns The signed request object.
     */
    signRequest(webResource) {
        const credentials = `${this.userName}:${this.password}`;
        const encodedCredentials = `${this.authorizationScheme} ${encodeString(credentials)}`;
        if (!webResource.headers)
            webResource.headers = new HttpHeaders();
        webResource.headers.set(HeaderConstants.AUTHORIZATION, encodedCredentials);
        return Promise.resolve(webResource);
    }
}

// Copyright (c) Microsoft Corporation.
/**
 * Authenticates to a service using an API key.
 */
class ApiKeyCredentials {
    /**
     * @param options - Specifies the options to be provided for auth. Either header or query needs to be provided.
     */
    constructor(options) {
        if (!options || (options && !options.inHeader && !options.inQuery)) {
            throw new Error(`options cannot be null or undefined. Either "inHeader" or "inQuery" property of the options object needs to be provided.`);
        }
        this.inHeader = options.inHeader;
        this.inQuery = options.inQuery;
    }
    /**
     * Signs a request with the values provided in the inHeader and inQuery parameter.
     *
     * @param webResource - The WebResourceLike to be signed.
     * @returns The signed request object.
     */
    signRequest(webResource) {
        if (!webResource) {
            return Promise.reject(new Error(`webResource cannot be null or undefined and must be of type "object".`));
        }
        if (this.inHeader) {
            if (!webResource.headers) {
                webResource.headers = new HttpHeaders();
            }
            for (const headerName in this.inHeader) {
                webResource.headers.set(headerName, this.inHeader[headerName]);
            }
        }
        if (this.inQuery) {
            if (!webResource.url) {
                return Promise.reject(new Error(`url cannot be null in the request object.`));
            }
            if (webResource.url.indexOf("?") < 0) {
                webResource.url += "?";
            }
            for (const key in this.inQuery) {
                if (!webResource.url.endsWith("?")) {
                    webResource.url += "&";
                }
                webResource.url += `${key}=${this.inQuery[key]}`;
            }
        }
        return Promise.resolve(webResource);
    }
}

// Copyright (c) Microsoft Corporation.
/**
 * A {@link TopicCredentials} object used for Azure Event Grid.
 */
class TopicCredentials extends ApiKeyCredentials {
    /**
     * Creates a new EventGrid TopicCredentials object.
     *
     * @param topicKey - The EventGrid topic key
     */
    constructor(topicKey) {
        if (!topicKey || (topicKey && typeof topicKey !== "string")) {
            throw new Error("topicKey cannot be null or undefined and must be of type string.");
        }
        const options = {
            inHeader: {
                "aeg-sas-key": topicKey,
            },
        };
        super(options);
    }
}

Object.defineProperty(exports, "delay", ({
    enumerable: true,
    get: function () { return coreUtil.delay; }
}));
Object.defineProperty(exports, "isNode", ({
    enumerable: true,
    get: function () { return coreUtil.isNode; }
}));
Object.defineProperty(exports, "isTokenCredential", ({
    enumerable: true,
    get: function () { return coreAuth.isTokenCredential; }
}));
exports.AccessTokenRefresher = AccessTokenRefresher;
exports.ApiKeyCredentials = ApiKeyCredentials;
exports.BaseRequestPolicy = BaseRequestPolicy;
exports.BasicAuthenticationCredentials = BasicAuthenticationCredentials;
exports.Constants = Constants;
exports.DefaultHttpClient = NodeFetchHttpClient;
exports.ExpiringAccessTokenCache = ExpiringAccessTokenCache;
exports.HttpHeaders = HttpHeaders;
exports.MapperType = MapperType;
exports.RequestPolicyOptions = RequestPolicyOptions;
exports.RestError = RestError;
exports.Serializer = Serializer;
exports.ServiceClient = ServiceClient;
exports.TopicCredentials = TopicCredentials;
exports.URLBuilder = URLBuilder;
exports.URLQuery = URLQuery;
exports.WebResource = WebResource;
exports.XML_ATTRKEY = XML_ATTRKEY;
exports.XML_CHARKEY = XML_CHARKEY;
exports.applyMixins = applyMixins;
exports.bearerTokenAuthenticationPolicy = bearerTokenAuthenticationPolicy;
exports.createPipelineFromOptions = createPipelineFromOptions;
exports.createSpanFunction = createSpanFunction;
exports.deserializationPolicy = deserializationPolicy;
exports.deserializeResponseBody = deserializeResponseBody;
exports.disableResponseDecompressionPolicy = disableResponseDecompressionPolicy;
exports.encodeUri = encodeUri;
exports.executePromisesSequentially = executePromisesSequentially;
exports.exponentialRetryPolicy = exponentialRetryPolicy;
exports.flattenResponse = flattenResponse;
exports.generateClientRequestIdPolicy = generateClientRequestIdPolicy;
exports.generateUuid = generateUuid;
exports.getDefaultProxySettings = getDefaultProxySettings;
exports.getDefaultUserAgentValue = getDefaultUserAgentValue;
exports.isDuration = isDuration;
exports.isValidUuid = isValidUuid;
exports.keepAlivePolicy = keepAlivePolicy;
exports.logPolicy = logPolicy;
exports.operationOptionsToRequestOptionsBase = operationOptionsToRequestOptionsBase;
exports.parseXML = parseXML;
exports.promiseToCallback = promiseToCallback;
exports.promiseToServiceCallback = promiseToServiceCallback;
exports.proxyPolicy = proxyPolicy;
exports.redirectPolicy = redirectPolicy;
exports.serializeObject = serializeObject;
exports.signingPolicy = signingPolicy;
exports.stringifyXML = stringifyXML;
exports.stripRequest = stripRequest;
exports.stripResponse = stripResponse;
exports.systemErrorRetryPolicy = systemErrorRetryPolicy;
exports.throttlingRetryPolicy = throttlingRetryPolicy;
exports.tracingPolicy = tracingPolicy;
exports.userAgentPolicy = userAgentPolicy;
//# sourceMappingURL=index.js.map


/***/ }),

/***/ 7094:
/***/ ((__unused_webpack_module, exports, __nccwpck_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({ value: true }));

var logger$1 = __nccwpck_require__(3233);
var coreUtil = __nccwpck_require__(1333);

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * The `@azure/logger` configuration for this package.
 * @internal
 */
const logger = logger$1.createClientLogger("core-lro");

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * The default time interval to wait before sending the next polling request.
 */
const POLL_INTERVAL_IN_MS = 2000;
/**
 * The closed set of terminal states.
 */
const terminalStates = ["succeeded", "canceled", "failed"];

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * Deserializes the state
 */
function deserializeState(serializedState) {
    try {
        return JSON.parse(serializedState).state;
    }
    catch (e) {
        throw new Error(`Unable to deserialize input state: ${serializedState}`);
    }
}
function setStateError(inputs) {
    const { state, stateProxy, isOperationError } = inputs;
    return (error) => {
        if (isOperationError(error)) {
            stateProxy.setError(state, error);
            stateProxy.setFailed(state);
        }
        throw error;
    };
}
function appendReadableErrorMessage(currentMessage, innerMessage) {
    let message = currentMessage;
    if (message.slice(-1) !== ".") {
        message = message + ".";
    }
    return message + " " + innerMessage;
}
function simplifyError(err) {
    let message = err.message;
    let code = err.code;
    let curErr = err;
    while (curErr.innererror) {
        curErr = curErr.innererror;
        code = curErr.code;
        message = appendReadableErrorMessage(message, curErr.message);
    }
    return {
        code,
        message,
    };
}
function processOperationStatus(result) {
    const { state, stateProxy, status, isDone, processResult, getError, response, setErrorAsResult } = result;
    switch (status) {
        case "succeeded": {
            stateProxy.setSucceeded(state);
            break;
        }
        case "failed": {
            const err = getError === null || getError === void 0 ? void 0 : getError(response);
            let postfix = "";
            if (err) {
                const { code, message } = simplifyError(err);
                postfix = `. ${code}. ${message}`;
            }
            const errStr = `The long-running operation has failed${postfix}`;
            stateProxy.setError(state, new Error(errStr));
            stateProxy.setFailed(state);
            logger.warning(errStr);
            break;
        }
        case "canceled": {
            stateProxy.setCanceled(state);
            break;
        }
    }
    if ((isDone === null || isDone === void 0 ? void 0 : isDone(response, state)) ||
        (isDone === undefined &&
            ["succeeded", "canceled"].concat(setErrorAsResult ? [] : ["failed"]).includes(status))) {
        stateProxy.setResult(state, buildResult({
            response,
            state,
            processResult,
        }));
    }
}
function buildResult(inputs) {
    const { processResult, response, state } = inputs;
    return processResult ? processResult(response, state) : response;
}
/**
 * Initiates the long-running operation.
 */
async function initOperation(inputs) {
    const { init, stateProxy, processResult, getOperationStatus, withOperationLocation, setErrorAsResult, } = inputs;
    const { operationLocation, resourceLocation, metadata, response } = await init();
    if (operationLocation)
        withOperationLocation === null || withOperationLocation === void 0 ? void 0 : withOperationLocation(operationLocation, false);
    const config = {
        metadata,
        operationLocation,
        resourceLocation,
    };
    logger.verbose(`LRO: Operation description:`, config);
    const state = stateProxy.initState(config);
    const status = getOperationStatus({ response, state, operationLocation });
    processOperationStatus({ state, status, stateProxy, response, setErrorAsResult, processResult });
    return state;
}
async function pollOperationHelper(inputs) {
    const { poll, state, stateProxy, operationLocation, getOperationStatus, getResourceLocation, isOperationError, options, } = inputs;
    const response = await poll(operationLocation, options).catch(setStateError({
        state,
        stateProxy,
        isOperationError,
    }));
    const status = getOperationStatus(response, state);
    logger.verbose(`LRO: Status:\n\tPolling from: ${state.config.operationLocation}\n\tOperation status: ${status}\n\tPolling status: ${terminalStates.includes(status) ? "Stopped" : "Running"}`);
    if (status === "succeeded") {
        const resourceLocation = getResourceLocation(response, state);
        if (resourceLocation !== undefined) {
            return {
                response: await poll(resourceLocation).catch(setStateError({ state, stateProxy, isOperationError })),
                status,
            };
        }
    }
    return { response, status };
}
/** Polls the long-running operation. */
async function pollOperation(inputs) {
    const { poll, state, stateProxy, options, getOperationStatus, getResourceLocation, getOperationLocation, isOperationError, withOperationLocation, getPollingInterval, processResult, getError, updateState, setDelay, isDone, setErrorAsResult, } = inputs;
    const { operationLocation } = state.config;
    if (operationLocation !== undefined) {
        const { response, status } = await pollOperationHelper({
            poll,
            getOperationStatus,
            state,
            stateProxy,
            operationLocation,
            getResourceLocation,
            isOperationError,
            options,
        });
        processOperationStatus({
            status,
            response,
            state,
            stateProxy,
            isDone,
            processResult,
            getError,
            setErrorAsResult,
        });
        if (!terminalStates.includes(status)) {
            const intervalInMs = getPollingInterval === null || getPollingInterval === void 0 ? void 0 : getPollingInterval(response);
            if (intervalInMs)
                setDelay(intervalInMs);
            const location = getOperationLocation === null || getOperationLocation === void 0 ? void 0 : getOperationLocation(response, state);
            if (location !== undefined) {
                const isUpdated = operationLocation !== location;
                state.config.operationLocation = location;
                withOperationLocation === null || withOperationLocation === void 0 ? void 0 : withOperationLocation(location, isUpdated);
            }
            else
                withOperationLocation === null || withOperationLocation === void 0 ? void 0 : withOperationLocation(operationLocation, false);
        }
        updateState === null || updateState === void 0 ? void 0 : updateState(state, response);
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
function getOperationLocationPollingUrl(inputs) {
    const { azureAsyncOperation, operationLocation } = inputs;
    return operationLocation !== null && operationLocation !== void 0 ? operationLocation : azureAsyncOperation;
}
function getLocationHeader(rawResponse) {
    return rawResponse.headers["location"];
}
function getOperationLocationHeader(rawResponse) {
    return rawResponse.headers["operation-location"];
}
function getAzureAsyncOperationHeader(rawResponse) {
    return rawResponse.headers["azure-asyncoperation"];
}
function findResourceLocation(inputs) {
    var _a;
    const { location, requestMethod, requestPath, resourceLocationConfig } = inputs;
    switch (requestMethod) {
        case "PUT": {
            return requestPath;
        }
        case "DELETE": {
            return undefined;
        }
        case "PATCH": {
            return (_a = getDefault()) !== null && _a !== void 0 ? _a : requestPath;
        }
        default: {
            return getDefault();
        }
    }
    function getDefault() {
        switch (resourceLocationConfig) {
            case "azure-async-operation": {
                return undefined;
            }
            case "original-uri": {
                return requestPath;
            }
            case "location":
            default: {
                return location;
            }
        }
    }
}
function inferLroMode(inputs) {
    const { rawResponse, requestMethod, requestPath, resourceLocationConfig } = inputs;
    const operationLocation = getOperationLocationHeader(rawResponse);
    const azureAsyncOperation = getAzureAsyncOperationHeader(rawResponse);
    const pollingUrl = getOperationLocationPollingUrl({ operationLocation, azureAsyncOperation });
    const location = getLocationHeader(rawResponse);
    const normalizedRequestMethod = requestMethod === null || requestMethod === void 0 ? void 0 : requestMethod.toLocaleUpperCase();
    if (pollingUrl !== undefined) {
        return {
            mode: "OperationLocation",
            operationLocation: pollingUrl,
            resourceLocation: findResourceLocation({
                requestMethod: normalizedRequestMethod,
                location,
                requestPath,
                resourceLocationConfig,
            }),
        };
    }
    else if (location !== undefined) {
        return {
            mode: "ResourceLocation",
            operationLocation: location,
        };
    }
    else if (normalizedRequestMethod === "PUT" && requestPath) {
        return {
            mode: "Body",
            operationLocation: requestPath,
        };
    }
    else {
        return undefined;
    }
}
function transformStatus(inputs) {
    const { status, statusCode } = inputs;
    if (typeof status !== "string" && status !== undefined) {
        throw new Error(`Polling was unsuccessful. Expected status to have a string value or no value but it has instead: ${status}. This doesn't necessarily indicate the operation has failed. Check your Azure subscription or resource status for more information.`);
    }
    switch (status === null || status === void 0 ? void 0 : status.toLocaleLowerCase()) {
        case undefined:
            return toOperationStatus(statusCode);
        case "succeeded":
            return "succeeded";
        case "failed":
            return "failed";
        case "running":
        case "accepted":
        case "started":
        case "canceling":
        case "cancelling":
            return "running";
        case "canceled":
        case "cancelled":
            return "canceled";
        default: {
            logger.verbose(`LRO: unrecognized operation status: ${status}`);
            return status;
        }
    }
}
function getStatus(rawResponse) {
    var _a;
    const { status } = (_a = rawResponse.body) !== null && _a !== void 0 ? _a : {};
    return transformStatus({ status, statusCode: rawResponse.statusCode });
}
function getProvisioningState(rawResponse) {
    var _a, _b;
    const { properties, provisioningState } = (_a = rawResponse.body) !== null && _a !== void 0 ? _a : {};
    const status = (_b = properties === null || properties === void 0 ? void 0 : properties.provisioningState) !== null && _b !== void 0 ? _b : provisioningState;
    return transformStatus({ status, statusCode: rawResponse.statusCode });
}
function toOperationStatus(statusCode) {
    if (statusCode === 202) {
        return "running";
    }
    else if (statusCode < 300) {
        return "succeeded";
    }
    else {
        return "failed";
    }
}
function parseRetryAfter({ rawResponse }) {
    const retryAfter = rawResponse.headers["retry-after"];
    if (retryAfter !== undefined) {
        // Retry-After header value is either in HTTP date format, or in seconds
        const retryAfterInSeconds = parseInt(retryAfter);
        return isNaN(retryAfterInSeconds)
            ? calculatePollingIntervalFromDate(new Date(retryAfter))
            : retryAfterInSeconds * 1000;
    }
    return undefined;
}
function getErrorFromResponse(response) {
    const error = accessBodyProperty(response, "error");
    if (!error) {
        logger.warning(`The long-running operation failed but there is no error property in the response's body`);
        return;
    }
    if (!error.code || !error.message) {
        logger.warning(`The long-running operation failed but the error property in the response's body doesn't contain code or message`);
        return;
    }
    return error;
}
function calculatePollingIntervalFromDate(retryAfterDate) {
    const timeNow = Math.floor(new Date().getTime());
    const retryAfterTime = retryAfterDate.getTime();
    if (timeNow < retryAfterTime) {
        return retryAfterTime - timeNow;
    }
    return undefined;
}
function getStatusFromInitialResponse(inputs) {
    const { response, state, operationLocation } = inputs;
    function helper() {
        var _a;
        const mode = (_a = state.config.metadata) === null || _a === void 0 ? void 0 : _a["mode"];
        switch (mode) {
            case undefined:
                return toOperationStatus(response.rawResponse.statusCode);
            case "Body":
                return getOperationStatus(response, state);
            default:
                return "running";
        }
    }
    const status = helper();
    return status === "running" && operationLocation === undefined ? "succeeded" : status;
}
/**
 * Initiates the long-running operation.
 */
async function initHttpOperation(inputs) {
    const { stateProxy, resourceLocationConfig, processResult, lro, setErrorAsResult } = inputs;
    return initOperation({
        init: async () => {
            const response = await lro.sendInitialRequest();
            const config = inferLroMode({
                rawResponse: response.rawResponse,
                requestPath: lro.requestPath,
                requestMethod: lro.requestMethod,
                resourceLocationConfig,
            });
            return Object.assign({ response, operationLocation: config === null || config === void 0 ? void 0 : config.operationLocation, resourceLocation: config === null || config === void 0 ? void 0 : config.resourceLocation }, ((config === null || config === void 0 ? void 0 : config.mode) ? { metadata: { mode: config.mode } } : {}));
        },
        stateProxy,
        processResult: processResult
            ? ({ flatResponse }, state) => processResult(flatResponse, state)
            : ({ flatResponse }) => flatResponse,
        getOperationStatus: getStatusFromInitialResponse,
        setErrorAsResult,
    });
}
function getOperationLocation({ rawResponse }, state) {
    var _a;
    const mode = (_a = state.config.metadata) === null || _a === void 0 ? void 0 : _a["mode"];
    switch (mode) {
        case "OperationLocation": {
            return getOperationLocationPollingUrl({
                operationLocation: getOperationLocationHeader(rawResponse),
                azureAsyncOperation: getAzureAsyncOperationHeader(rawResponse),
            });
        }
        case "ResourceLocation": {
            return getLocationHeader(rawResponse);
        }
        case "Body":
        default: {
            return undefined;
        }
    }
}
function getOperationStatus({ rawResponse }, state) {
    var _a;
    const mode = (_a = state.config.metadata) === null || _a === void 0 ? void 0 : _a["mode"];
    switch (mode) {
        case "OperationLocation": {
            return getStatus(rawResponse);
        }
        case "ResourceLocation": {
            return toOperationStatus(rawResponse.statusCode);
        }
        case "Body": {
            return getProvisioningState(rawResponse);
        }
        default:
            throw new Error(`Internal error: Unexpected operation mode: ${mode}`);
    }
}
function accessBodyProperty({ flatResponse, rawResponse }, prop) {
    var _a, _b;
    return (_a = flatResponse === null || flatResponse === void 0 ? void 0 : flatResponse[prop]) !== null && _a !== void 0 ? _a : (_b = rawResponse.body) === null || _b === void 0 ? void 0 : _b[prop];
}
function getResourceLocation(res, state) {
    const loc = accessBodyProperty(res, "resourceLocation");
    if (loc && typeof loc === "string") {
        state.config.resourceLocation = loc;
    }
    return state.config.resourceLocation;
}
function isOperationError(e) {
    return e.name === "RestError";
}
/** Polls the long-running operation. */
async function pollHttpOperation(inputs) {
    const { lro, stateProxy, options, processResult, updateState, setDelay, state, setErrorAsResult, } = inputs;
    return pollOperation({
        state,
        stateProxy,
        setDelay,
        processResult: processResult
            ? ({ flatResponse }, inputState) => processResult(flatResponse, inputState)
            : ({ flatResponse }) => flatResponse,
        getError: getErrorFromResponse,
        updateState,
        getPollingInterval: parseRetryAfter,
        getOperationLocation,
        getOperationStatus,
        isOperationError,
        getResourceLocation,
        options,
        /**
         * The expansion here is intentional because `lro` could be an object that
         * references an inner this, so we need to preserve a reference to it.
         */
        poll: async (location, inputOptions) => lro.sendPollRequest(location, inputOptions),
        setErrorAsResult,
    });
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
const createStateProxy$1 = () => ({
    /**
     * The state at this point is created to be of type OperationState<TResult>.
     * It will be updated later to be of type TState when the
     * customer-provided callback, `updateState`, is called during polling.
     */
    initState: (config) => ({ status: "running", config }),
    setCanceled: (state) => (state.status = "canceled"),
    setError: (state, error) => (state.error = error),
    setResult: (state, result) => (state.result = result),
    setRunning: (state) => (state.status = "running"),
    setSucceeded: (state) => (state.status = "succeeded"),
    setFailed: (state) => (state.status = "failed"),
    getError: (state) => state.error,
    getResult: (state) => state.result,
    isCanceled: (state) => state.status === "canceled",
    isFailed: (state) => state.status === "failed",
    isRunning: (state) => state.status === "running",
    isSucceeded: (state) => state.status === "succeeded",
});
/**
 * Returns a poller factory.
 */
function buildCreatePoller(inputs) {
    const { getOperationLocation, getStatusFromInitialResponse, getStatusFromPollResponse, isOperationError, getResourceLocation, getPollingInterval, getError, resolveOnUnsuccessful, } = inputs;
    return async ({ init, poll }, options) => {
        const { processResult, updateState, withOperationLocation: withOperationLocationCallback, intervalInMs = POLL_INTERVAL_IN_MS, restoreFrom, } = options || {};
        const stateProxy = createStateProxy$1();
        const withOperationLocation = withOperationLocationCallback
            ? (() => {
                let called = false;
                return (operationLocation, isUpdated) => {
                    if (isUpdated)
                        withOperationLocationCallback(operationLocation);
                    else if (!called)
                        withOperationLocationCallback(operationLocation);
                    called = true;
                };
            })()
            : undefined;
        const state = restoreFrom
            ? deserializeState(restoreFrom)
            : await initOperation({
                init,
                stateProxy,
                processResult,
                getOperationStatus: getStatusFromInitialResponse,
                withOperationLocation,
                setErrorAsResult: !resolveOnUnsuccessful,
            });
        let resultPromise;
        const abortController = new AbortController();
        const handlers = new Map();
        const handleProgressEvents = async () => handlers.forEach((h) => h(state));
        const cancelErrMsg = "Operation was canceled";
        let currentPollIntervalInMs = intervalInMs;
        const poller = {
            getOperationState: () => state,
            getResult: () => state.result,
            isDone: () => ["succeeded", "failed", "canceled"].includes(state.status),
            isStopped: () => resultPromise === undefined,
            stopPolling: () => {
                abortController.abort();
            },
            toString: () => JSON.stringify({
                state,
            }),
            onProgress: (callback) => {
                const s = Symbol();
                handlers.set(s, callback);
                return () => handlers.delete(s);
            },
            pollUntilDone: (pollOptions) => (resultPromise !== null && resultPromise !== void 0 ? resultPromise : (resultPromise = (async () => {
                const { abortSignal: inputAbortSignal } = pollOptions || {};
                // In the future we can use AbortSignal.any() instead
                function abortListener() {
                    abortController.abort();
                }
                const abortSignal = abortController.signal;
                if (inputAbortSignal === null || inputAbortSignal === void 0 ? void 0 : inputAbortSignal.aborted) {
                    abortController.abort();
                }
                else if (!abortSignal.aborted) {
                    inputAbortSignal === null || inputAbortSignal === void 0 ? void 0 : inputAbortSignal.addEventListener("abort", abortListener, { once: true });
                }
                try {
                    if (!poller.isDone()) {
                        await poller.poll({ abortSignal });
                        while (!poller.isDone()) {
                            await coreUtil.delay(currentPollIntervalInMs, { abortSignal });
                            await poller.poll({ abortSignal });
                        }
                    }
                }
                finally {
                    inputAbortSignal === null || inputAbortSignal === void 0 ? void 0 : inputAbortSignal.removeEventListener("abort", abortListener);
                }
                if (resolveOnUnsuccessful) {
                    return poller.getResult();
                }
                else {
                    switch (state.status) {
                        case "succeeded":
                            return poller.getResult();
                        case "canceled":
                            throw new Error(cancelErrMsg);
                        case "failed":
                            throw state.error;
                        case "notStarted":
                        case "running":
                            throw new Error(`Polling completed without succeeding or failing`);
                    }
                }
            })().finally(() => {
                resultPromise = undefined;
            }))),
            async poll(pollOptions) {
                if (resolveOnUnsuccessful) {
                    if (poller.isDone())
                        return;
                }
                else {
                    switch (state.status) {
                        case "succeeded":
                            return;
                        case "canceled":
                            throw new Error(cancelErrMsg);
                        case "failed":
                            throw state.error;
                    }
                }
                await pollOperation({
                    poll,
                    state,
                    stateProxy,
                    getOperationLocation,
                    isOperationError,
                    withOperationLocation,
                    getPollingInterval,
                    getOperationStatus: getStatusFromPollResponse,
                    getResourceLocation,
                    processResult,
                    getError,
                    updateState,
                    options: pollOptions,
                    setDelay: (pollIntervalInMs) => {
                        currentPollIntervalInMs = pollIntervalInMs;
                    },
                    setErrorAsResult: !resolveOnUnsuccessful,
                });
                await handleProgressEvents();
                if (!resolveOnUnsuccessful) {
                    switch (state.status) {
                        case "canceled":
                            throw new Error(cancelErrMsg);
                        case "failed":
                            throw state.error;
                    }
                }
            },
        };
        return poller;
    };
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * Creates a poller that can be used to poll a long-running operation.
 * @param lro - Description of the long-running operation
 * @param options - options to configure the poller
 * @returns an initialized poller
 */
async function createHttpPoller(lro, options) {
    const { resourceLocationConfig, intervalInMs, processResult, restoreFrom, updateState, withOperationLocation, resolveOnUnsuccessful = false, } = options || {};
    return buildCreatePoller({
        getStatusFromInitialResponse,
        getStatusFromPollResponse: getOperationStatus,
        isOperationError,
        getOperationLocation,
        getResourceLocation,
        getPollingInterval: parseRetryAfter,
        getError: getErrorFromResponse,
        resolveOnUnsuccessful,
    })({
        init: async () => {
            const response = await lro.sendInitialRequest();
            const config = inferLroMode({
                rawResponse: response.rawResponse,
                requestPath: lro.requestPath,
                requestMethod: lro.requestMethod,
                resourceLocationConfig,
            });
            return Object.assign({ response, operationLocation: config === null || config === void 0 ? void 0 : config.operationLocation, resourceLocation: config === null || config === void 0 ? void 0 : config.resourceLocation }, ((config === null || config === void 0 ? void 0 : config.mode) ? { metadata: { mode: config.mode } } : {}));
        },
        poll: lro.sendPollRequest,
    }, {
        intervalInMs,
        withOperationLocation,
        restoreFrom,
        updateState,
        processResult: processResult
            ? ({ flatResponse }, state) => processResult(flatResponse, state)
            : ({ flatResponse }) => flatResponse,
    });
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
const createStateProxy = () => ({
    initState: (config) => ({ config, isStarted: true }),
    setCanceled: (state) => (state.isCancelled = true),
    setError: (state, error) => (state.error = error),
    setResult: (state, result) => (state.result = result),
    setRunning: (state) => (state.isStarted = true),
    setSucceeded: (state) => (state.isCompleted = true),
    setFailed: () => {
        /** empty body */
    },
    getError: (state) => state.error,
    getResult: (state) => state.result,
    isCanceled: (state) => !!state.isCancelled,
    isFailed: (state) => !!state.error,
    isRunning: (state) => !!state.isStarted,
    isSucceeded: (state) => Boolean(state.isCompleted && !state.isCancelled && !state.error),
});
class GenericPollOperation {
    constructor(state, lro, setErrorAsResult, lroResourceLocationConfig, processResult, updateState, isDone) {
        this.state = state;
        this.lro = lro;
        this.setErrorAsResult = setErrorAsResult;
        this.lroResourceLocationConfig = lroResourceLocationConfig;
        this.processResult = processResult;
        this.updateState = updateState;
        this.isDone = isDone;
    }
    setPollerConfig(pollerConfig) {
        this.pollerConfig = pollerConfig;
    }
    async update(options) {
        var _a;
        const stateProxy = createStateProxy();
        if (!this.state.isStarted) {
            this.state = Object.assign(Object.assign({}, this.state), (await initHttpOperation({
                lro: this.lro,
                stateProxy,
                resourceLocationConfig: this.lroResourceLocationConfig,
                processResult: this.processResult,
                setErrorAsResult: this.setErrorAsResult,
            })));
        }
        const updateState = this.updateState;
        const isDone = this.isDone;
        if (!this.state.isCompleted && this.state.error === undefined) {
            await pollHttpOperation({
                lro: this.lro,
                state: this.state,
                stateProxy,
                processResult: this.processResult,
                updateState: updateState
                    ? (state, { rawResponse }) => updateState(state, rawResponse)
                    : undefined,
                isDone: isDone
                    ? ({ flatResponse }, state) => isDone(flatResponse, state)
                    : undefined,
                options,
                setDelay: (intervalInMs) => {
                    this.pollerConfig.intervalInMs = intervalInMs;
                },
                setErrorAsResult: this.setErrorAsResult,
            });
        }
        (_a = options === null || options === void 0 ? void 0 : options.fireProgress) === null || _a === void 0 ? void 0 : _a.call(options, this.state);
        return this;
    }
    async cancel() {
        logger.error("`cancelOperation` is deprecated because it wasn't implemented");
        return this;
    }
    /**
     * Serializes the Poller operation.
     */
    toString() {
        return JSON.stringify({
            state: this.state,
        });
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * When a poller is manually stopped through the `stopPolling` method,
 * the poller will be rejected with an instance of the PollerStoppedError.
 */
class PollerStoppedError extends Error {
    constructor(message) {
        super(message);
        this.name = "PollerStoppedError";
        Object.setPrototypeOf(this, PollerStoppedError.prototype);
    }
}
/**
 * When the operation is cancelled, the poller will be rejected with an instance
 * of the PollerCancelledError.
 */
class PollerCancelledError extends Error {
    constructor(message) {
        super(message);
        this.name = "PollerCancelledError";
        Object.setPrototypeOf(this, PollerCancelledError.prototype);
    }
}
/**
 * A class that represents the definition of a program that polls through consecutive requests
 * until it reaches a state of completion.
 *
 * A poller can be executed manually, by polling request by request by calling to the `poll()` method repeatedly, until its operation is completed.
 * It also provides a way to wait until the operation completes, by calling `pollUntilDone()` and waiting until the operation finishes.
 * Pollers can also request the cancellation of the ongoing process to whom is providing the underlying long running operation.
 *
 * ```ts
 * const poller = new MyPoller();
 *
 * // Polling just once:
 * await poller.poll();
 *
 * // We can try to cancel the request here, by calling:
 * //
 * //     await poller.cancelOperation();
 * //
 *
 * // Getting the final result:
 * const result = await poller.pollUntilDone();
 * ```
 *
 * The Poller is defined by two types, a type representing the state of the poller, which
 * must include a basic set of properties from `PollOperationState<TResult>`,
 * and a return type defined by `TResult`, which can be anything.
 *
 * The Poller class implements the `PollerLike` interface, which allows poller implementations to avoid having
 * to export the Poller's class directly, and instead only export the already instantiated poller with the PollerLike type.
 *
 * ```ts
 * class Client {
 *   public async makePoller: PollerLike<MyOperationState, MyResult> {
 *     const poller = new MyPoller({});
 *     // It might be preferred to return the poller after the first request is made,
 *     // so that some information can be obtained right away.
 *     await poller.poll();
 *     return poller;
 *   }
 * }
 *
 * const poller: PollerLike<MyOperationState, MyResult> = myClient.makePoller();
 * ```
 *
 * A poller can be created through its constructor, then it can be polled until it's completed.
 * At any point in time, the state of the poller can be obtained without delay through the getOperationState method.
 * At any point in time, the intermediate forms of the result type can be requested without delay.
 * Once the underlying operation is marked as completed, the poller will stop and the final value will be returned.
 *
 * ```ts
 * const poller = myClient.makePoller();
 * const state: MyOperationState = poller.getOperationState();
 *
 * // The intermediate result can be obtained at any time.
 * const result: MyResult | undefined = poller.getResult();
 *
 * // The final result can only be obtained after the poller finishes.
 * const result: MyResult = await poller.pollUntilDone();
 * ```
 *
 */
// eslint-disable-next-line no-use-before-define
class Poller {
    /**
     * A poller needs to be initialized by passing in at least the basic properties of the `PollOperation<TState, TResult>`.
     *
     * When writing an implementation of a Poller, this implementation needs to deal with the initialization
     * of any custom state beyond the basic definition of the poller. The basic poller assumes that the poller's
     * operation has already been defined, at least its basic properties. The code below shows how to approach
     * the definition of the constructor of a new custom poller.
     *
     * ```ts
     * export class MyPoller extends Poller<MyOperationState, string> {
     *   constructor({
     *     // Anything you might need outside of the basics
     *   }) {
     *     let state: MyOperationState = {
     *       privateProperty: private,
     *       publicProperty: public,
     *     };
     *
     *     const operation = {
     *       state,
     *       update,
     *       cancel,
     *       toString
     *     }
     *
     *     // Sending the operation to the parent's constructor.
     *     super(operation);
     *
     *     // You can assign more local properties here.
     *   }
     * }
     * ```
     *
     * Inside of this constructor, a new promise is created. This will be used to
     * tell the user when the poller finishes (see `pollUntilDone()`). The promise's
     * resolve and reject methods are also used internally to control when to resolve
     * or reject anyone waiting for the poller to finish.
     *
     * The constructor of a custom implementation of a poller is where any serialized version of
     * a previous poller's operation should be deserialized into the operation sent to the
     * base constructor. For example:
     *
     * ```ts
     * export class MyPoller extends Poller<MyOperationState, string> {
     *   constructor(
     *     baseOperation: string | undefined
     *   ) {
     *     let state: MyOperationState = {};
     *     if (baseOperation) {
     *       state = {
     *         ...JSON.parse(baseOperation).state,
     *         ...state
     *       };
     *     }
     *     const operation = {
     *       state,
     *       // ...
     *     }
     *     super(operation);
     *   }
     * }
     * ```
     *
     * @param operation - Must contain the basic properties of `PollOperation<State, TResult>`.
     */
    constructor(operation) {
        /** controls whether to throw an error if the operation failed or was canceled. */
        this.resolveOnUnsuccessful = false;
        this.stopped = true;
        this.pollProgressCallbacks = [];
        this.operation = operation;
        this.promise = new Promise((resolve, reject) => {
            this.resolve = resolve;
            this.reject = reject;
        });
        // This prevents the UnhandledPromiseRejectionWarning in node.js from being thrown.
        // The above warning would get thrown if `poller.poll` is called, it returns an error,
        // and pullUntilDone did not have a .catch or await try/catch on it's return value.
        this.promise.catch(() => {
            /* intentionally blank */
        });
    }
    /**
     * Starts a loop that will break only if the poller is done
     * or if the poller is stopped.
     */
    async startPolling(pollOptions = {}) {
        if (this.stopped) {
            this.stopped = false;
        }
        while (!this.isStopped() && !this.isDone()) {
            await this.poll(pollOptions);
            await this.delay();
        }
    }
    /**
     * pollOnce does one polling, by calling to the update method of the underlying
     * poll operation to make any relevant change effective.
     *
     * It only optionally receives an object with an abortSignal property, from \@azure/abort-controller's AbortSignalLike.
     *
     * @param options - Optional properties passed to the operation's update method.
     */
    async pollOnce(options = {}) {
        if (!this.isDone()) {
            this.operation = await this.operation.update({
                abortSignal: options.abortSignal,
                fireProgress: this.fireProgress.bind(this),
            });
        }
        this.processUpdatedState();
    }
    /**
     * fireProgress calls the functions passed in via onProgress the method of the poller.
     *
     * It loops over all of the callbacks received from onProgress, and executes them, sending them
     * the current operation state.
     *
     * @param state - The current operation state.
     */
    fireProgress(state) {
        for (const callback of this.pollProgressCallbacks) {
            callback(state);
        }
    }
    /**
     * Invokes the underlying operation's cancel method.
     */
    async cancelOnce(options = {}) {
        this.operation = await this.operation.cancel(options);
    }
    /**
     * Returns a promise that will resolve once a single polling request finishes.
     * It does this by calling the update method of the Poller's operation.
     *
     * It only optionally receives an object with an abortSignal property, from \@azure/abort-controller's AbortSignalLike.
     *
     * @param options - Optional properties passed to the operation's update method.
     */
    poll(options = {}) {
        if (!this.pollOncePromise) {
            this.pollOncePromise = this.pollOnce(options);
            const clearPollOncePromise = () => {
                this.pollOncePromise = undefined;
            };
            this.pollOncePromise.then(clearPollOncePromise, clearPollOncePromise).catch(this.reject);
        }
        return this.pollOncePromise;
    }
    processUpdatedState() {
        if (this.operation.state.error) {
            this.stopped = true;
            if (!this.resolveOnUnsuccessful) {
                this.reject(this.operation.state.error);
                throw this.operation.state.error;
            }
        }
        if (this.operation.state.isCancelled) {
            this.stopped = true;
            if (!this.resolveOnUnsuccessful) {
                const error = new PollerCancelledError("Operation was canceled");
                this.reject(error);
                throw error;
            }
        }
        if (this.isDone() && this.resolve) {
            // If the poller has finished polling, this means we now have a result.
            // However, it can be the case that TResult is instantiated to void, so
            // we are not expecting a result anyway. To assert that we might not
            // have a result eventually after finishing polling, we cast the result
            // to TResult.
            this.resolve(this.getResult());
        }
    }
    /**
     * Returns a promise that will resolve once the underlying operation is completed.
     */
    async pollUntilDone(pollOptions = {}) {
        if (this.stopped) {
            this.startPolling(pollOptions).catch(this.reject);
        }
        // This is needed because the state could have been updated by
        // `cancelOperation`, e.g. the operation is canceled or an error occurred.
        this.processUpdatedState();
        return this.promise;
    }
    /**
     * Invokes the provided callback after each polling is completed,
     * sending the current state of the poller's operation.
     *
     * It returns a method that can be used to stop receiving updates on the given callback function.
     */
    onProgress(callback) {
        this.pollProgressCallbacks.push(callback);
        return () => {
            this.pollProgressCallbacks = this.pollProgressCallbacks.filter((c) => c !== callback);
        };
    }
    /**
     * Returns true if the poller has finished polling.
     */
    isDone() {
        const state = this.operation.state;
        return Boolean(state.isCompleted || state.isCancelled || state.error);
    }
    /**
     * Stops the poller from continuing to poll.
     */
    stopPolling() {
        if (!this.stopped) {
            this.stopped = true;
            if (this.reject) {
                this.reject(new PollerStoppedError("This poller is already stopped"));
            }
        }
    }
    /**
     * Returns true if the poller is stopped.
     */
    isStopped() {
        return this.stopped;
    }
    /**
     * Attempts to cancel the underlying operation.
     *
     * It only optionally receives an object with an abortSignal property, from \@azure/abort-controller's AbortSignalLike.
     *
     * If it's called again before it finishes, it will throw an error.
     *
     * @param options - Optional properties passed to the operation's update method.
     */
    cancelOperation(options = {}) {
        if (!this.cancelPromise) {
            this.cancelPromise = this.cancelOnce(options);
        }
        else if (options.abortSignal) {
            throw new Error("A cancel request is currently pending");
        }
        return this.cancelPromise;
    }
    /**
     * Returns the state of the operation.
     *
     * Even though TState will be the same type inside any of the methods of any extension of the Poller class,
     * implementations of the pollers can customize what's shared with the public by writing their own
     * version of the `getOperationState` method, and by defining two types, one representing the internal state of the poller
     * and a public type representing a safe to share subset of the properties of the internal state.
     * Their definition of getOperationState can then return their public type.
     *
     * Example:
     *
     * ```ts
     * // Let's say we have our poller's operation state defined as:
     * interface MyOperationState extends PollOperationState<ResultType> {
     *   privateProperty?: string;
     *   publicProperty?: string;
     * }
     *
     * // To allow us to have a true separation of public and private state, we have to define another interface:
     * interface PublicState extends PollOperationState<ResultType> {
     *   publicProperty?: string;
     * }
     *
     * // Then, we define our Poller as follows:
     * export class MyPoller extends Poller<MyOperationState, ResultType> {
     *   // ... More content is needed here ...
     *
     *   public getOperationState(): PublicState {
     *     const state: PublicState = this.operation.state;
     *     return {
     *       // Properties from PollOperationState<TResult>
     *       isStarted: state.isStarted,
     *       isCompleted: state.isCompleted,
     *       isCancelled: state.isCancelled,
     *       error: state.error,
     *       result: state.result,
     *
     *       // The only other property needed by PublicState.
     *       publicProperty: state.publicProperty
     *     }
     *   }
     * }
     * ```
     *
     * You can see this in the tests of this repository, go to the file:
     * `../test/utils/testPoller.ts`
     * and look for the getOperationState implementation.
     */
    getOperationState() {
        return this.operation.state;
    }
    /**
     * Returns the result value of the operation,
     * regardless of the state of the poller.
     * It can return undefined or an incomplete form of the final TResult value
     * depending on the implementation.
     */
    getResult() {
        const state = this.operation.state;
        return state.result;
    }
    /**
     * Returns a serialized version of the poller's operation
     * by invoking the operation's toString method.
     */
    toString() {
        return this.operation.toString();
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * The LRO Engine, a class that performs polling.
 */
class LroEngine extends Poller {
    constructor(lro, options) {
        const { intervalInMs = POLL_INTERVAL_IN_MS, resumeFrom, resolveOnUnsuccessful = false, isDone, lroResourceLocationConfig, processResult, updateState, } = options || {};
        const state = resumeFrom
            ? deserializeState(resumeFrom)
            : {};
        const operation = new GenericPollOperation(state, lro, !resolveOnUnsuccessful, lroResourceLocationConfig, processResult, updateState, isDone);
        super(operation);
        this.resolveOnUnsuccessful = resolveOnUnsuccessful;
        this.config = { intervalInMs: intervalInMs };
        operation.setPollerConfig(this.config);
    }
    /**
     * The method used by the poller to wait before attempting to update its operation.
     */
    delay() {
        return new Promise((resolve) => setTimeout(() => resolve(), this.config.intervalInMs));
    }
}

exports.LroEngine = LroEngine;
exports.Poller = Poller;
exports.PollerCancelledError = PollerCancelledError;
exports.PollerStoppedError = PollerStoppedError;
exports.createHttpPoller = createHttpPoller;
//# sourceMappingURL=index.js.map


/***/ }),

/***/ 4559:
/***/ ((__unused_webpack_module, exports, __nccwpck_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({ value: true }));

var tslib = __nccwpck_require__(4351);

// Copyright (c) Microsoft Corporation.
/**
 * returns an async iterator that iterates over results. It also has a `byPage`
 * method that returns pages of items at once.
 *
 * @param pagedResult - an object that specifies how to get pages.
 * @returns a paged async iterator that iterates over results.
 */
function getPagedAsyncIterator(pagedResult) {
    var _a;
    const iter = getItemAsyncIterator(pagedResult);
    return {
        next() {
            return iter.next();
        },
        [Symbol.asyncIterator]() {
            return this;
        },
        byPage: (_a = pagedResult === null || pagedResult === void 0 ? void 0 : pagedResult.byPage) !== null && _a !== void 0 ? _a : ((settings) => {
            const { continuationToken, maxPageSize } = settings !== null && settings !== void 0 ? settings : {};
            return getPageAsyncIterator(pagedResult, {
                pageLink: continuationToken,
                maxPageSize,
            });
        }),
    };
}
function getItemAsyncIterator(pagedResult) {
    return tslib.__asyncGenerator(this, arguments, function* getItemAsyncIterator_1() {
        var e_1, _a, e_2, _b;
        const pages = getPageAsyncIterator(pagedResult);
        const firstVal = yield tslib.__await(pages.next());
        // if the result does not have an array shape, i.e. TPage = TElement, then we return it as is
        if (!Array.isArray(firstVal.value)) {
            // can extract elements from this page
            const { toElements } = pagedResult;
            if (toElements) {
                yield tslib.__await(yield* tslib.__asyncDelegator(tslib.__asyncValues(toElements(firstVal.value))));
                try {
                    for (var pages_1 = tslib.__asyncValues(pages), pages_1_1; pages_1_1 = yield tslib.__await(pages_1.next()), !pages_1_1.done;) {
                        const page = pages_1_1.value;
                        yield tslib.__await(yield* tslib.__asyncDelegator(tslib.__asyncValues(toElements(page))));
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (pages_1_1 && !pages_1_1.done && (_a = pages_1.return)) yield tslib.__await(_a.call(pages_1));
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
            else {
                yield yield tslib.__await(firstVal.value);
                // `pages` is of type `AsyncIterableIterator<TPage>` but TPage = TElement in this case
                yield tslib.__await(yield* tslib.__asyncDelegator(tslib.__asyncValues(pages)));
            }
        }
        else {
            yield tslib.__await(yield* tslib.__asyncDelegator(tslib.__asyncValues(firstVal.value)));
            try {
                for (var pages_2 = tslib.__asyncValues(pages), pages_2_1; pages_2_1 = yield tslib.__await(pages_2.next()), !pages_2_1.done;) {
                    const page = pages_2_1.value;
                    // pages is of type `AsyncIterableIterator<TPage>` so `page` is of type `TPage`. In this branch,
                    // it must be the case that `TPage = TElement[]`
                    yield tslib.__await(yield* tslib.__asyncDelegator(tslib.__asyncValues(page)));
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (pages_2_1 && !pages_2_1.done && (_b = pages_2.return)) yield tslib.__await(_b.call(pages_2));
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
    });
}
function getPageAsyncIterator(pagedResult, options = {}) {
    return tslib.__asyncGenerator(this, arguments, function* getPageAsyncIterator_1() {
        const { pageLink, maxPageSize } = options;
        let response = yield tslib.__await(pagedResult.getPage(pageLink !== null && pageLink !== void 0 ? pageLink : pagedResult.firstPageLink, maxPageSize));
        if (!response) {
            return yield tslib.__await(void 0);
        }
        yield yield tslib.__await(response.page);
        while (response.nextPageLink) {
            response = yield tslib.__await(pagedResult.getPage(response.nextPageLink, maxPageSize));
            if (!response) {
                return yield tslib.__await(void 0);
            }
            yield yield tslib.__await(response.page);
        }
    });
}

exports.getPagedAsyncIterator = getPagedAsyncIterator;
//# sourceMappingURL=index.js.map


/***/ }),

/***/ 4175:
/***/ ((__unused_webpack_module, exports, __nccwpck_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({ value: true }));

var api = __nccwpck_require__(5163);

// Copyright (c) Microsoft Corporation.
(function (SpanKind) {
    /** Default value. Indicates that the span is used internally. */
    SpanKind[SpanKind["INTERNAL"] = 0] = "INTERNAL";
    /**
     * Indicates that the span covers server-side handling of an RPC or other
     * remote request.
     */
    SpanKind[SpanKind["SERVER"] = 1] = "SERVER";
    /**
     * Indicates that the span covers the client-side wrapper around an RPC or
     * other remote request.
     */
    SpanKind[SpanKind["CLIENT"] = 2] = "CLIENT";
    /**
     * Indicates that the span describes producer sending a message to a
     * broker. Unlike client and server, there is no direct critical path latency
     * relationship between producer and consumer spans.
     */
    SpanKind[SpanKind["PRODUCER"] = 3] = "PRODUCER";
    /**
     * Indicates that the span describes consumer receiving a message from a
     * broker. Unlike client and server, there is no direct critical path latency
     * relationship between producer and consumer spans.
     */
    SpanKind[SpanKind["CONSUMER"] = 4] = "CONSUMER";
})(exports.SpanKind || (exports.SpanKind = {}));
/**
 * Return the span if one exists
 *
 * @param context - context to get span from
 */
function getSpan(context) {
    return api.trace.getSpan(context);
}
/**
 * Set the span on a context
 *
 * @param context - context to use as parent
 * @param span - span to set active
 */
function setSpan(context, span) {
    return api.trace.setSpan(context, span);
}
/**
 * Wrap span context in a NoopSpan and set as span in a new
 * context
 *
 * @param context - context to set active span on
 * @param spanContext - span context to be wrapped
 */
function setSpanContext(context, spanContext) {
    return api.trace.setSpanContext(context, spanContext);
}
/**
 * Get the span context of the span if it exists.
 *
 * @param context - context to get values from
 */
function getSpanContext(context) {
    return api.trace.getSpanContext(context);
}
/**
 * Returns true of the given {@link SpanContext} is valid.
 * A valid {@link SpanContext} is one which has a valid trace ID and span ID as per the spec.
 *
 * @param context - the {@link SpanContext} to validate.
 *
 * @returns true if the {@link SpanContext} is valid, false otherwise.
 */
function isSpanContextValid(context) {
    return api.trace.isSpanContextValid(context);
}
function getTracer(name, version) {
    return api.trace.getTracer(name || "azure/core-tracing", version);
}
/** Entrypoint for context API */
const context = api.context;
(function (SpanStatusCode) {
    /**
     * The default status.
     */
    SpanStatusCode[SpanStatusCode["UNSET"] = 0] = "UNSET";
    /**
     * The operation has been validated by an Application developer or
     * Operator to have completed successfully.
     */
    SpanStatusCode[SpanStatusCode["OK"] = 1] = "OK";
    /**
     * The operation contains an error.
     */
    SpanStatusCode[SpanStatusCode["ERROR"] = 2] = "ERROR";
})(exports.SpanStatusCode || (exports.SpanStatusCode = {}));

// Copyright (c) Microsoft Corporation.
function isTracingDisabled() {
    var _a;
    if (typeof process === "undefined") {
        // not supported in browser for now without polyfills
        return false;
    }
    const azureTracingDisabledValue = (_a = process.env.AZURE_TRACING_DISABLED) === null || _a === void 0 ? void 0 : _a.toLowerCase();
    if (azureTracingDisabledValue === "false" || azureTracingDisabledValue === "0") {
        return false;
    }
    return Boolean(azureTracingDisabledValue);
}
/**
 * Creates a function that can be used to create spans using the global tracer.
 *
 * Usage:
 *
 * ```typescript
 * // once
 * const createSpan = createSpanFunction({ packagePrefix: "Azure.Data.AppConfiguration", namespace: "Microsoft.AppConfiguration" });
 *
 * // in each operation
 * const span = createSpan("deleteConfigurationSetting", operationOptions);
 *    // code...
 * span.end();
 * ```
 *
 * @hidden
 * @param args - allows configuration of the prefix for each span as well as the az.namespace field.
 */
function createSpanFunction(args) {
    return function (operationName, operationOptions) {
        const tracer = getTracer();
        const tracingOptions = (operationOptions === null || operationOptions === void 0 ? void 0 : operationOptions.tracingOptions) || {};
        const spanOptions = Object.assign({ kind: exports.SpanKind.INTERNAL }, tracingOptions.spanOptions);
        const spanName = args.packagePrefix ? `${args.packagePrefix}.${operationName}` : operationName;
        let span;
        if (isTracingDisabled()) {
            span = api.trace.wrapSpanContext(api.INVALID_SPAN_CONTEXT);
        }
        else {
            span = tracer.startSpan(spanName, spanOptions, tracingOptions.tracingContext);
        }
        if (args.namespace) {
            span.setAttribute("az.namespace", args.namespace);
        }
        let newSpanOptions = tracingOptions.spanOptions || {};
        if (span.isRecording() && args.namespace) {
            newSpanOptions = Object.assign(Object.assign({}, tracingOptions.spanOptions), { attributes: Object.assign(Object.assign({}, spanOptions.attributes), { "az.namespace": args.namespace }) });
        }
        const newTracingOptions = Object.assign(Object.assign({}, tracingOptions), { spanOptions: newSpanOptions, tracingContext: setSpan(tracingOptions.tracingContext || context.active(), span) });
        const newOperationOptions = Object.assign(Object.assign({}, operationOptions), { tracingOptions: newTracingOptions });
        return {
            span,
            updatedOptions: newOperationOptions
        };
    };
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
const VERSION = "00";
/**
 * Generates a `SpanContext` given a `traceparent` header value.
 * @param traceParent - Serialized span context data as a `traceparent` header value.
 * @returns The `SpanContext` generated from the `traceparent` value.
 */
function extractSpanContextFromTraceParentHeader(traceParentHeader) {
    const parts = traceParentHeader.split("-");
    if (parts.length !== 4) {
        return;
    }
    const [version, traceId, spanId, traceOptions] = parts;
    if (version !== VERSION) {
        return;
    }
    const traceFlags = parseInt(traceOptions, 16);
    const spanContext = {
        spanId,
        traceId,
        traceFlags
    };
    return spanContext;
}
/**
 * Generates a `traceparent` value given a span context.
 * @param spanContext - Contains context for a specific span.
 * @returns The `spanContext` represented as a `traceparent` value.
 */
function getTraceParentHeader(spanContext) {
    const missingFields = [];
    if (!spanContext.traceId) {
        missingFields.push("traceId");
    }
    if (!spanContext.spanId) {
        missingFields.push("spanId");
    }
    if (missingFields.length) {
        return;
    }
    const flags = spanContext.traceFlags || 0 /* NONE */;
    const hexFlags = flags.toString(16);
    const traceFlags = hexFlags.length === 1 ? `0${hexFlags}` : hexFlags;
    // https://www.w3.org/TR/trace-context/#traceparent-header-field-values
    return `${VERSION}-${spanContext.traceId}-${spanContext.spanId}-${traceFlags}`;
}

exports.context = context;
exports.createSpanFunction = createSpanFunction;
exports.extractSpanContextFromTraceParentHeader = extractSpanContextFromTraceParentHeader;
exports.getSpan = getSpan;
exports.getSpanContext = getSpanContext;
exports.getTraceParentHeader = getTraceParentHeader;
exports.getTracer = getTracer;
exports.isSpanContextValid = isSpanContextValid;
exports.setSpan = setSpan;
exports.setSpanContext = setSpanContext;
//# sourceMappingURL=index.js.map


/***/ }),

/***/ 1333:
/***/ ((__unused_webpack_module, exports, __nccwpck_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({ value: true }));

var abortController = __nccwpck_require__(4200);
var crypto = __nccwpck_require__(6113);

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * Creates an abortable promise.
 * @param buildPromise - A function that takes the resolve and reject functions as parameters.
 * @param options - The options for the abortable promise.
 * @returns A promise that can be aborted.
 */
function createAbortablePromise(buildPromise, options) {
    const { cleanupBeforeAbort, abortSignal, abortErrorMsg } = options !== null && options !== void 0 ? options : {};
    return new Promise((resolve, reject) => {
        function rejectOnAbort() {
            reject(new abortController.AbortError(abortErrorMsg !== null && abortErrorMsg !== void 0 ? abortErrorMsg : "The operation was aborted."));
        }
        function removeListeners() {
            abortSignal === null || abortSignal === void 0 ? void 0 : abortSignal.removeEventListener("abort", onAbort);
        }
        function onAbort() {
            cleanupBeforeAbort === null || cleanupBeforeAbort === void 0 ? void 0 : cleanupBeforeAbort();
            removeListeners();
            rejectOnAbort();
        }
        if (abortSignal === null || abortSignal === void 0 ? void 0 : abortSignal.aborted) {
            return rejectOnAbort();
        }
        try {
            buildPromise((x) => {
                removeListeners();
                resolve(x);
            }, (x) => {
                removeListeners();
                reject(x);
            });
        }
        catch (err) {
            reject(err);
        }
        abortSignal === null || abortSignal === void 0 ? void 0 : abortSignal.addEventListener("abort", onAbort);
    });
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
const StandardAbortMessage = "The delay was aborted.";
/**
 * A wrapper for setTimeout that resolves a promise after timeInMs milliseconds.
 * @param timeInMs - The number of milliseconds to be delayed.
 * @param options - The options for delay - currently abort options
 * @returns Promise that is resolved after timeInMs
 */
function delay(timeInMs, options) {
    let token;
    const { abortSignal, abortErrorMsg } = options !== null && options !== void 0 ? options : {};
    return createAbortablePromise((resolve) => {
        token = setTimeout(resolve, timeInMs);
    }, {
        cleanupBeforeAbort: () => clearTimeout(token),
        abortSignal,
        abortErrorMsg: abortErrorMsg !== null && abortErrorMsg !== void 0 ? abortErrorMsg : StandardAbortMessage,
    });
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * promise.race() wrapper that aborts rest of promises as soon as the first promise settles.
 */
async function cancelablePromiseRace(abortablePromiseBuilders, options) {
    var _a, _b;
    const aborter = new AbortController();
    function abortHandler() {
        aborter.abort();
    }
    (_a = options === null || options === void 0 ? void 0 : options.abortSignal) === null || _a === void 0 ? void 0 : _a.addEventListener("abort", abortHandler);
    try {
        return await Promise.race(abortablePromiseBuilders.map((p) => p({ abortSignal: aborter.signal })));
    }
    finally {
        aborter.abort();
        (_b = options === null || options === void 0 ? void 0 : options.abortSignal) === null || _b === void 0 ? void 0 : _b.removeEventListener("abort", abortHandler);
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * Returns a random integer value between a lower and upper bound,
 * inclusive of both bounds.
 * Note that this uses Math.random and isn't secure. If you need to use
 * this for any kind of security purpose, find a better source of random.
 * @param min - The smallest integer value allowed.
 * @param max - The largest integer value allowed.
 */
function getRandomIntegerInclusive(min, max) {
    // Make sure inputs are integers.
    min = Math.ceil(min);
    max = Math.floor(max);
    // Pick a random offset from zero to the size of the range.
    // Since Math.random() can never return 1, we have to make the range one larger
    // in order to be inclusive of the maximum value after we take the floor.
    const offset = Math.floor(Math.random() * (max - min + 1));
    return offset + min;
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * Helper to determine when an input is a generic JS object.
 * @returns true when input is an object type that is not null, Array, RegExp, or Date.
 */
function isObject(input) {
    return (typeof input === "object" &&
        input !== null &&
        !Array.isArray(input) &&
        !(input instanceof RegExp) &&
        !(input instanceof Date));
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * Typeguard for an error object shape (has name and message)
 * @param e - Something caught by a catch clause.
 */
function isError(e) {
    if (isObject(e)) {
        const hasName = typeof e.name === "string";
        const hasMessage = typeof e.message === "string";
        return hasName && hasMessage;
    }
    return false;
}
/**
 * Given what is thought to be an error object, return the message if possible.
 * If the message is missing, returns a stringified version of the input.
 * @param e - Something thrown from a try block
 * @returns The error message or a string of the input
 */
function getErrorMessage(e) {
    if (isError(e)) {
        return e.message;
    }
    else {
        let stringified;
        try {
            if (typeof e === "object" && e) {
                stringified = JSON.stringify(e);
            }
            else {
                stringified = String(e);
            }
        }
        catch (err) {
            stringified = "[unable to stringify input]";
        }
        return `Unknown error ${stringified}`;
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * Generates a SHA-256 HMAC signature.
 * @param key - The HMAC key represented as a base64 string, used to generate the cryptographic HMAC hash.
 * @param stringToSign - The data to be signed.
 * @param encoding - The textual encoding to use for the returned HMAC digest.
 */
async function computeSha256Hmac(key, stringToSign, encoding) {
    const decodedKey = Buffer.from(key, "base64");
    return crypto.createHmac("sha256", decodedKey).update(stringToSign).digest(encoding);
}
/**
 * Generates a SHA-256 hash.
 * @param content - The data to be included in the hash.
 * @param encoding - The textual encoding to use for the returned hash.
 */
async function computeSha256Hash(content, encoding) {
    return crypto.createHash("sha256").update(content).digest(encoding);
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * Helper TypeGuard that checks if something is defined or not.
 * @param thing - Anything
 */
function isDefined(thing) {
    return typeof thing !== "undefined" && thing !== null;
}
/**
 * Helper TypeGuard that checks if the input is an object with the specified properties.
 * @param thing - Anything.
 * @param properties - The name of the properties that should appear in the object.
 */
function isObjectWithProperties(thing, properties) {
    if (!isDefined(thing) || typeof thing !== "object") {
        return false;
    }
    for (const property of properties) {
        if (!objectHasProperty(thing, property)) {
            return false;
        }
    }
    return true;
}
/**
 * Helper TypeGuard that checks if the input is an object with the specified property.
 * @param thing - Any object.
 * @param property - The name of the property that should appear in the object.
 */
function objectHasProperty(thing, property) {
    return (isDefined(thing) && typeof thing === "object" && property in thing);
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/*
 * NOTE: When moving this file, please update "react-native" section in package.json.
 */
/**
 * Generated Universally Unique Identifier
 *
 * @returns RFC4122 v4 UUID.
 */
function generateUUID() {
    let uuid = "";
    for (let i = 0; i < 32; i++) {
        // Generate a random number between 0 and 15
        const randomNumber = Math.floor(Math.random() * 16);
        // Set the UUID version to 4 in the 13th position
        if (i === 12) {
            uuid += "4";
        }
        else if (i === 16) {
            // Set the UUID variant to "10" in the 17th position
            uuid += (randomNumber & 0x3) | 0x8;
        }
        else {
            // Add a random hexadecimal digit to the UUID string
            uuid += randomNumber.toString(16);
        }
        // Add hyphens to the UUID string at the appropriate positions
        if (i === 7 || i === 11 || i === 15 || i === 19) {
            uuid += "-";
        }
    }
    return uuid;
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
var _a$1;
// NOTE: This is a workaround until we can use `globalThis.crypto.randomUUID` in Node.js 19+.
let uuidFunction = typeof ((_a$1 = globalThis === null || globalThis === void 0 ? void 0 : globalThis.crypto) === null || _a$1 === void 0 ? void 0 : _a$1.randomUUID) === "function"
    ? globalThis.crypto.randomUUID.bind(globalThis.crypto)
    : crypto.randomUUID;
// Not defined in earlier versions of Node.js 14
if (!uuidFunction) {
    uuidFunction = generateUUID;
}
/**
 * Generated Universally Unique Identifier
 *
 * @returns RFC4122 v4 UUID.
 */
function randomUUID() {
    return uuidFunction();
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
var _a, _b, _c, _d;
/**
 * A constant that indicates whether the environment the code is running is a Web Browser.
 */
// eslint-disable-next-line @azure/azure-sdk/ts-no-window
const isBrowser = typeof window !== "undefined" && typeof window.document !== "undefined";
/**
 * A constant that indicates whether the environment the code is running is a Web Worker.
 */
const isWebWorker = typeof self === "object" &&
    typeof (self === null || self === void 0 ? void 0 : self.importScripts) === "function" &&
    (((_a = self.constructor) === null || _a === void 0 ? void 0 : _a.name) === "DedicatedWorkerGlobalScope" ||
        ((_b = self.constructor) === null || _b === void 0 ? void 0 : _b.name) === "ServiceWorkerGlobalScope" ||
        ((_c = self.constructor) === null || _c === void 0 ? void 0 : _c.name) === "SharedWorkerGlobalScope");
/**
 * A constant that indicates whether the environment the code is running is Deno.
 */
const isDeno = typeof Deno !== "undefined" &&
    typeof Deno.version !== "undefined" &&
    typeof Deno.version.deno !== "undefined";
/**
 * A constant that indicates whether the environment the code is running is Node.JS.
 */
const isNode = typeof process !== "undefined" &&
    Boolean(process.version) &&
    Boolean((_d = process.versions) === null || _d === void 0 ? void 0 : _d.node) &&
    // Deno thought it was a good idea to spoof process.versions.node, see https://deno.land/std@0.177.0/node/process.ts?s=versions
    !isDeno;
/**
 * A constant that indicates whether the environment the code is running is Bun.sh.
 */
const isBun = typeof Bun !== "undefined" && typeof Bun.version !== "undefined";
/**
 * A constant that indicates whether the environment the code is running is in React-Native.
 */
// https://github.com/facebook/react-native/blob/main/packages/react-native/Libraries/Core/setUpNavigator.js
const isReactNative = typeof navigator !== "undefined" && (navigator === null || navigator === void 0 ? void 0 : navigator.product) === "ReactNative";

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * The helper that transforms bytes with specific character encoding into string
 * @param bytes - the uint8array bytes
 * @param format - the format we use to encode the byte
 * @returns a string of the encoded string
 */
function uint8ArrayToString(bytes, format) {
    return Buffer.from(bytes).toString(format);
}
/**
 * The helper that transforms string to specific character encoded bytes array.
 * @param value - the string to be converted
 * @param format - the format we use to decode the value
 * @returns a uint8array
 */
function stringToUint8Array(value, format) {
    return Buffer.from(value, format);
}

exports.cancelablePromiseRace = cancelablePromiseRace;
exports.computeSha256Hash = computeSha256Hash;
exports.computeSha256Hmac = computeSha256Hmac;
exports.createAbortablePromise = createAbortablePromise;
exports.delay = delay;
exports.getErrorMessage = getErrorMessage;
exports.getRandomIntegerInclusive = getRandomIntegerInclusive;
exports.isBrowser = isBrowser;
exports.isBun = isBun;
exports.isDefined = isDefined;
exports.isDeno = isDeno;
exports.isError = isError;
exports.isNode = isNode;
exports.isObject = isObject;
exports.isObjectWithProperties = isObjectWithProperties;
exports.isReactNative = isReactNative;
exports.isWebWorker = isWebWorker;
exports.objectHasProperty = objectHasProperty;
exports.randomUUID = randomUUID;
exports.stringToUint8Array = stringToUint8Array;
exports.uint8ArrayToString = uint8ArrayToString;
//# sourceMappingURL=index.js.map


/***/ }),

/***/ 4200:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({ value: true }));

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
/**
 * This error is thrown when an asynchronous operation has been aborted.
 * Check for this error by testing the `name` that the name property of the
 * error matches `"AbortError"`.
 *
 * @example
 * ```ts
 * const controller = new AbortController();
 * controller.abort();
 * try {
 *   doAsyncWork(controller.signal)
 * } catch (e) {
 *   if (e.name === 'AbortError') {
 *     // handle abort error here.
 *   }
 * }
 * ```
 */
class AbortError extends Error {
    constructor(message) {
        super(message);
        this.name = "AbortError";
    }
}

exports.AbortError = AbortError;
//# sourceMappingURL=index.js.map


/***/ }),

/***/ 3233:
/***/ ((__unused_webpack_module, exports, __nccwpck_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({ value: true }));

var os = __nccwpck_require__(2037);
var util = __nccwpck_require__(3837);

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var util__default = /*#__PURE__*/_interopDefaultLegacy(util);

// Copyright (c) Microsoft Corporation.
function log(message, ...args) {
    process.stderr.write(`${util__default["default"].format(message, ...args)}${os.EOL}`);
}

// Copyright (c) Microsoft Corporation.
const debugEnvVariable = (typeof process !== "undefined" && process.env && process.env.DEBUG) || undefined;
let enabledString;
let enabledNamespaces = [];
let skippedNamespaces = [];
const debuggers = [];
if (debugEnvVariable) {
    enable(debugEnvVariable);
}
const debugObj = Object.assign((namespace) => {
    return createDebugger(namespace);
}, {
    enable,
    enabled,
    disable,
    log,
});
function enable(namespaces) {
    enabledString = namespaces;
    enabledNamespaces = [];
    skippedNamespaces = [];
    const wildcard = /\*/g;
    const namespaceList = namespaces.split(",").map((ns) => ns.trim().replace(wildcard, ".*?"));
    for (const ns of namespaceList) {
        if (ns.startsWith("-")) {
            skippedNamespaces.push(new RegExp(`^${ns.substr(1)}$`));
        }
        else {
            enabledNamespaces.push(new RegExp(`^${ns}$`));
        }
    }
    for (const instance of debuggers) {
        instance.enabled = enabled(instance.namespace);
    }
}
function enabled(namespace) {
    if (namespace.endsWith("*")) {
        return true;
    }
    for (const skipped of skippedNamespaces) {
        if (skipped.test(namespace)) {
            return false;
        }
    }
    for (const enabledNamespace of enabledNamespaces) {
        if (enabledNamespace.test(namespace)) {
            return true;
        }
    }
    return false;
}
function disable() {
    const result = enabledString || "";
    enable("");
    return result;
}
function createDebugger(namespace) {
    const newDebugger = Object.assign(debug, {
        enabled: enabled(namespace),
        destroy,
        log: debugObj.log,
        namespace,
        extend,
    });
    function debug(...args) {
        if (!newDebugger.enabled) {
            return;
        }
        if (args.length > 0) {
            args[0] = `${namespace} ${args[0]}`;
        }
        newDebugger.log(...args);
    }
    debuggers.push(newDebugger);
    return newDebugger;
}
function destroy() {
    const index = debuggers.indexOf(this);
    if (index >= 0) {
        debuggers.splice(index, 1);
        return true;
    }
    return false;
}
function extend(namespace) {
    const newDebugger = createDebugger(`${this.namespace}:${namespace}`);
    newDebugger.log = this.log;
    return newDebugger;
}
var debug = debugObj;

// Copyright (c) Microsoft Corporation.
const registeredLoggers = new Set();
const logLevelFromEnv = (typeof process !== "undefined" && process.env && process.env.AZURE_LOG_LEVEL) || undefined;
let azureLogLevel;
/**
 * The AzureLogger provides a mechanism for overriding where logs are output to.
 * By default, logs are sent to stderr.
 * Override the `log` method to redirect logs to another location.
 */
const AzureLogger = debug("azure");
AzureLogger.log = (...args) => {
    debug.log(...args);
};
const AZURE_LOG_LEVELS = ["verbose", "info", "warning", "error"];
if (logLevelFromEnv) {
    // avoid calling setLogLevel because we don't want a mis-set environment variable to crash
    if (isAzureLogLevel(logLevelFromEnv)) {
        setLogLevel(logLevelFromEnv);
    }
    else {
        console.error(`AZURE_LOG_LEVEL set to unknown log level '${logLevelFromEnv}'; logging is not enabled. Acceptable values: ${AZURE_LOG_LEVELS.join(", ")}.`);
    }
}
/**
 * Immediately enables logging at the specified log level. If no level is specified, logging is disabled.
 * @param level - The log level to enable for logging.
 * Options from most verbose to least verbose are:
 * - verbose
 * - info
 * - warning
 * - error
 */
function setLogLevel(level) {
    if (level && !isAzureLogLevel(level)) {
        throw new Error(`Unknown log level '${level}'. Acceptable values: ${AZURE_LOG_LEVELS.join(",")}`);
    }
    azureLogLevel = level;
    const enabledNamespaces = [];
    for (const logger of registeredLoggers) {
        if (shouldEnable(logger)) {
            enabledNamespaces.push(logger.namespace);
        }
    }
    debug.enable(enabledNamespaces.join(","));
}
/**
 * Retrieves the currently specified log level.
 */
function getLogLevel() {
    return azureLogLevel;
}
const levelMap = {
    verbose: 400,
    info: 300,
    warning: 200,
    error: 100,
};
/**
 * Creates a logger for use by the Azure SDKs that inherits from `AzureLogger`.
 * @param namespace - The name of the SDK package.
 * @hidden
 */
function createClientLogger(namespace) {
    const clientRootLogger = AzureLogger.extend(namespace);
    patchLogMethod(AzureLogger, clientRootLogger);
    return {
        error: createLogger(clientRootLogger, "error"),
        warning: createLogger(clientRootLogger, "warning"),
        info: createLogger(clientRootLogger, "info"),
        verbose: createLogger(clientRootLogger, "verbose"),
    };
}
function patchLogMethod(parent, child) {
    child.log = (...args) => {
        parent.log(...args);
    };
}
function createLogger(parent, level) {
    const logger = Object.assign(parent.extend(level), {
        level,
    });
    patchLogMethod(parent, logger);
    if (shouldEnable(logger)) {
        const enabledNamespaces = debug.disable();
        debug.enable(enabledNamespaces + "," + logger.namespace);
    }
    registeredLoggers.add(logger);
    return logger;
}
function shouldEnable(logger) {
    return Boolean(azureLogLevel && levelMap[logger.level] <= levelMap[azureLogLevel]);
}
function isAzureLogLevel(logLevel) {
    return AZURE_LOG_LEVELS.includes(logLevel);
}

exports.AzureLogger = AzureLogger;
exports.createClientLogger = createClientLogger;
exports.getLogLevel = getLogLevel;
exports.setLogLevel = setLogLevel;
//# sourceMappingURL=index.js.map


/***/ }),

/***/ 4100:
/***/ ((__unused_webpack_module, exports, __nccwpck_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({ value: true }));

var coreHttp = __nccwpck_require__(4607);
var tslib = __nccwpck_require__(4351);
var coreTracing = __nccwpck_require__(4175);
var logger$1 = __nccwpck_require__(3233);
var abortController = __nccwpck_require__(2557);
var os = __nccwpck_require__(2037);
var crypto = __nccwpck_require__(6113);
var stream = __nccwpck_require__(2781);
__nccwpck_require__(4559);
var coreLro = __nccwpck_require__(7094);
var events = __nccwpck_require__(2361);
var fs = __nccwpck_require__(7147);
var util = __nccwpck_require__(3837);

function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    var n = Object.create(null);
    if (e) {
        Object.keys(e).forEach(function (k) {
            if (k !== 'default') {
                var d = Object.getOwnPropertyDescriptor(e, k);
                Object.defineProperty(n, k, d.get ? d : {
                    enumerable: true,
                    get: function () { return e[k]; }
                });
            }
        });
    }
    n["default"] = e;
    return Object.freeze(n);
}

var coreHttp__namespace = /*#__PURE__*/_interopNamespace(coreHttp);
var os__namespace = /*#__PURE__*/_interopNamespace(os);
var fs__namespace = /*#__PURE__*/_interopNamespace(fs);
var util__namespace = /*#__PURE__*/_interopNamespace(util);

/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
const BlobServiceProperties = {
    serializedName: "BlobServiceProperties",
    xmlName: "StorageServiceProperties",
    type: {
        name: "Composite",
        className: "BlobServiceProperties",
        modelProperties: {
            blobAnalyticsLogging: {
                serializedName: "Logging",
                xmlName: "Logging",
                type: {
                    name: "Composite",
                    className: "Logging"
                }
            },
            hourMetrics: {
                serializedName: "HourMetrics",
                xmlName: "HourMetrics",
                type: {
                    name: "Composite",
                    className: "Metrics"
                }
            },
            minuteMetrics: {
                serializedName: "MinuteMetrics",
                xmlName: "MinuteMetrics",
                type: {
                    name: "Composite",
                    className: "Metrics"
                }
            },
            cors: {
                serializedName: "Cors",
                xmlName: "Cors",
                xmlIsWrapped: true,
                xmlElementName: "CorsRule",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "CorsRule"
                        }
                    }
                }
            },
            defaultServiceVersion: {
                serializedName: "DefaultServiceVersion",
                xmlName: "DefaultServiceVersion",
                type: {
                    name: "String"
                }
            },
            deleteRetentionPolicy: {
                serializedName: "DeleteRetentionPolicy",
                xmlName: "DeleteRetentionPolicy",
                type: {
                    name: "Composite",
                    className: "RetentionPolicy"
                }
            },
            staticWebsite: {
                serializedName: "StaticWebsite",
                xmlName: "StaticWebsite",
                type: {
                    name: "Composite",
                    className: "StaticWebsite"
                }
            }
        }
    }
};
const Logging = {
    serializedName: "Logging",
    type: {
        name: "Composite",
        className: "Logging",
        modelProperties: {
            version: {
                serializedName: "Version",
                required: true,
                xmlName: "Version",
                type: {
                    name: "String"
                }
            },
            deleteProperty: {
                serializedName: "Delete",
                required: true,
                xmlName: "Delete",
                type: {
                    name: "Boolean"
                }
            },
            read: {
                serializedName: "Read",
                required: true,
                xmlName: "Read",
                type: {
                    name: "Boolean"
                }
            },
            write: {
                serializedName: "Write",
                required: true,
                xmlName: "Write",
                type: {
                    name: "Boolean"
                }
            },
            retentionPolicy: {
                serializedName: "RetentionPolicy",
                xmlName: "RetentionPolicy",
                type: {
                    name: "Composite",
                    className: "RetentionPolicy"
                }
            }
        }
    }
};
const RetentionPolicy = {
    serializedName: "RetentionPolicy",
    type: {
        name: "Composite",
        className: "RetentionPolicy",
        modelProperties: {
            enabled: {
                serializedName: "Enabled",
                required: true,
                xmlName: "Enabled",
                type: {
                    name: "Boolean"
                }
            },
            days: {
                constraints: {
                    InclusiveMinimum: 1
                },
                serializedName: "Days",
                xmlName: "Days",
                type: {
                    name: "Number"
                }
            }
        }
    }
};
const Metrics = {
    serializedName: "Metrics",
    type: {
        name: "Composite",
        className: "Metrics",
        modelProperties: {
            version: {
                serializedName: "Version",
                xmlName: "Version",
                type: {
                    name: "String"
                }
            },
            enabled: {
                serializedName: "Enabled",
                required: true,
                xmlName: "Enabled",
                type: {
                    name: "Boolean"
                }
            },
            includeAPIs: {
                serializedName: "IncludeAPIs",
                xmlName: "IncludeAPIs",
                type: {
                    name: "Boolean"
                }
            },
            retentionPolicy: {
                serializedName: "RetentionPolicy",
                xmlName: "RetentionPolicy",
                type: {
                    name: "Composite",
                    className: "RetentionPolicy"
                }
            }
        }
    }
};
const CorsRule = {
    serializedName: "CorsRule",
    type: {
        name: "Composite",
        className: "CorsRule",
        modelProperties: {
            allowedOrigins: {
                serializedName: "AllowedOrigins",
                required: true,
                xmlName: "AllowedOrigins",
                type: {
                    name: "String"
                }
            },
            allowedMethods: {
                serializedName: "AllowedMethods",
                required: true,
                xmlName: "AllowedMethods",
                type: {
                    name: "String"
                }
            },
            allowedHeaders: {
                serializedName: "AllowedHeaders",
                required: true,
                xmlName: "AllowedHeaders",
                type: {
                    name: "String"
                }
            },
            exposedHeaders: {
                serializedName: "ExposedHeaders",
                required: true,
                xmlName: "ExposedHeaders",
                type: {
                    name: "String"
                }
            },
            maxAgeInSeconds: {
                constraints: {
                    InclusiveMinimum: 0
                },
                serializedName: "MaxAgeInSeconds",
                required: true,
                xmlName: "MaxAgeInSeconds",
                type: {
                    name: "Number"
                }
            }
        }
    }
};
const StaticWebsite = {
    serializedName: "StaticWebsite",
    type: {
        name: "Composite",
        className: "StaticWebsite",
        modelProperties: {
            enabled: {
                serializedName: "Enabled",
                required: true,
                xmlName: "Enabled",
                type: {
                    name: "Boolean"
                }
            },
            indexDocument: {
                serializedName: "IndexDocument",
                xmlName: "IndexDocument",
                type: {
                    name: "String"
                }
            },
            errorDocument404Path: {
                serializedName: "ErrorDocument404Path",
                xmlName: "ErrorDocument404Path",
                type: {
                    name: "String"
                }
            },
            defaultIndexDocumentPath: {
                serializedName: "DefaultIndexDocumentPath",
                xmlName: "DefaultIndexDocumentPath",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const StorageError = {
    serializedName: "StorageError",
    type: {
        name: "Composite",
        className: "StorageError",
        modelProperties: {
            message: {
                serializedName: "Message",
                xmlName: "Message",
                type: {
                    name: "String"
                }
            },
            code: {
                serializedName: "Code",
                xmlName: "Code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobServiceStatistics = {
    serializedName: "BlobServiceStatistics",
    xmlName: "StorageServiceStats",
    type: {
        name: "Composite",
        className: "BlobServiceStatistics",
        modelProperties: {
            geoReplication: {
                serializedName: "GeoReplication",
                xmlName: "GeoReplication",
                type: {
                    name: "Composite",
                    className: "GeoReplication"
                }
            }
        }
    }
};
const GeoReplication = {
    serializedName: "GeoReplication",
    type: {
        name: "Composite",
        className: "GeoReplication",
        modelProperties: {
            status: {
                serializedName: "Status",
                required: true,
                xmlName: "Status",
                type: {
                    name: "Enum",
                    allowedValues: ["live", "bootstrap", "unavailable"]
                }
            },
            lastSyncOn: {
                serializedName: "LastSyncTime",
                required: true,
                xmlName: "LastSyncTime",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const ListContainersSegmentResponse = {
    serializedName: "ListContainersSegmentResponse",
    xmlName: "EnumerationResults",
    type: {
        name: "Composite",
        className: "ListContainersSegmentResponse",
        modelProperties: {
            serviceEndpoint: {
                serializedName: "ServiceEndpoint",
                required: true,
                xmlName: "ServiceEndpoint",
                xmlIsAttribute: true,
                type: {
                    name: "String"
                }
            },
            prefix: {
                serializedName: "Prefix",
                xmlName: "Prefix",
                type: {
                    name: "String"
                }
            },
            marker: {
                serializedName: "Marker",
                xmlName: "Marker",
                type: {
                    name: "String"
                }
            },
            maxPageSize: {
                serializedName: "MaxResults",
                xmlName: "MaxResults",
                type: {
                    name: "Number"
                }
            },
            containerItems: {
                serializedName: "ContainerItems",
                required: true,
                xmlName: "Containers",
                xmlIsWrapped: true,
                xmlElementName: "Container",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "ContainerItem"
                        }
                    }
                }
            },
            continuationToken: {
                serializedName: "NextMarker",
                xmlName: "NextMarker",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerItem = {
    serializedName: "ContainerItem",
    xmlName: "Container",
    type: {
        name: "Composite",
        className: "ContainerItem",
        modelProperties: {
            name: {
                serializedName: "Name",
                required: true,
                xmlName: "Name",
                type: {
                    name: "String"
                }
            },
            deleted: {
                serializedName: "Deleted",
                xmlName: "Deleted",
                type: {
                    name: "Boolean"
                }
            },
            version: {
                serializedName: "Version",
                xmlName: "Version",
                type: {
                    name: "String"
                }
            },
            properties: {
                serializedName: "Properties",
                xmlName: "Properties",
                type: {
                    name: "Composite",
                    className: "ContainerProperties"
                }
            },
            metadata: {
                serializedName: "Metadata",
                xmlName: "Metadata",
                type: {
                    name: "Dictionary",
                    value: { type: { name: "String" } }
                }
            }
        }
    }
};
const ContainerProperties = {
    serializedName: "ContainerProperties",
    type: {
        name: "Composite",
        className: "ContainerProperties",
        modelProperties: {
            lastModified: {
                serializedName: "Last-Modified",
                required: true,
                xmlName: "Last-Modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "Etag",
                required: true,
                xmlName: "Etag",
                type: {
                    name: "String"
                }
            },
            leaseStatus: {
                serializedName: "LeaseStatus",
                xmlName: "LeaseStatus",
                type: {
                    name: "Enum",
                    allowedValues: ["locked", "unlocked"]
                }
            },
            leaseState: {
                serializedName: "LeaseState",
                xmlName: "LeaseState",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "available",
                        "leased",
                        "expired",
                        "breaking",
                        "broken"
                    ]
                }
            },
            leaseDuration: {
                serializedName: "LeaseDuration",
                xmlName: "LeaseDuration",
                type: {
                    name: "Enum",
                    allowedValues: ["infinite", "fixed"]
                }
            },
            publicAccess: {
                serializedName: "PublicAccess",
                xmlName: "PublicAccess",
                type: {
                    name: "Enum",
                    allowedValues: ["container", "blob"]
                }
            },
            hasImmutabilityPolicy: {
                serializedName: "HasImmutabilityPolicy",
                xmlName: "HasImmutabilityPolicy",
                type: {
                    name: "Boolean"
                }
            },
            hasLegalHold: {
                serializedName: "HasLegalHold",
                xmlName: "HasLegalHold",
                type: {
                    name: "Boolean"
                }
            },
            defaultEncryptionScope: {
                serializedName: "DefaultEncryptionScope",
                xmlName: "DefaultEncryptionScope",
                type: {
                    name: "String"
                }
            },
            preventEncryptionScopeOverride: {
                serializedName: "DenyEncryptionScopeOverride",
                xmlName: "DenyEncryptionScopeOverride",
                type: {
                    name: "Boolean"
                }
            },
            deletedOn: {
                serializedName: "DeletedTime",
                xmlName: "DeletedTime",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            remainingRetentionDays: {
                serializedName: "RemainingRetentionDays",
                xmlName: "RemainingRetentionDays",
                type: {
                    name: "Number"
                }
            },
            isImmutableStorageWithVersioningEnabled: {
                serializedName: "ImmutableStorageWithVersioningEnabled",
                xmlName: "ImmutableStorageWithVersioningEnabled",
                type: {
                    name: "Boolean"
                }
            }
        }
    }
};
const KeyInfo = {
    serializedName: "KeyInfo",
    type: {
        name: "Composite",
        className: "KeyInfo",
        modelProperties: {
            startsOn: {
                serializedName: "Start",
                required: true,
                xmlName: "Start",
                type: {
                    name: "String"
                }
            },
            expiresOn: {
                serializedName: "Expiry",
                required: true,
                xmlName: "Expiry",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const UserDelegationKey = {
    serializedName: "UserDelegationKey",
    type: {
        name: "Composite",
        className: "UserDelegationKey",
        modelProperties: {
            signedObjectId: {
                serializedName: "SignedOid",
                required: true,
                xmlName: "SignedOid",
                type: {
                    name: "String"
                }
            },
            signedTenantId: {
                serializedName: "SignedTid",
                required: true,
                xmlName: "SignedTid",
                type: {
                    name: "String"
                }
            },
            signedStartsOn: {
                serializedName: "SignedStart",
                required: true,
                xmlName: "SignedStart",
                type: {
                    name: "String"
                }
            },
            signedExpiresOn: {
                serializedName: "SignedExpiry",
                required: true,
                xmlName: "SignedExpiry",
                type: {
                    name: "String"
                }
            },
            signedService: {
                serializedName: "SignedService",
                required: true,
                xmlName: "SignedService",
                type: {
                    name: "String"
                }
            },
            signedVersion: {
                serializedName: "SignedVersion",
                required: true,
                xmlName: "SignedVersion",
                type: {
                    name: "String"
                }
            },
            value: {
                serializedName: "Value",
                required: true,
                xmlName: "Value",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const FilterBlobSegment = {
    serializedName: "FilterBlobSegment",
    xmlName: "EnumerationResults",
    type: {
        name: "Composite",
        className: "FilterBlobSegment",
        modelProperties: {
            serviceEndpoint: {
                serializedName: "ServiceEndpoint",
                required: true,
                xmlName: "ServiceEndpoint",
                xmlIsAttribute: true,
                type: {
                    name: "String"
                }
            },
            where: {
                serializedName: "Where",
                required: true,
                xmlName: "Where",
                type: {
                    name: "String"
                }
            },
            blobs: {
                serializedName: "Blobs",
                required: true,
                xmlName: "Blobs",
                xmlIsWrapped: true,
                xmlElementName: "Blob",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "FilterBlobItem"
                        }
                    }
                }
            },
            continuationToken: {
                serializedName: "NextMarker",
                xmlName: "NextMarker",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const FilterBlobItem = {
    serializedName: "FilterBlobItem",
    xmlName: "Blob",
    type: {
        name: "Composite",
        className: "FilterBlobItem",
        modelProperties: {
            name: {
                serializedName: "Name",
                required: true,
                xmlName: "Name",
                type: {
                    name: "String"
                }
            },
            containerName: {
                serializedName: "ContainerName",
                required: true,
                xmlName: "ContainerName",
                type: {
                    name: "String"
                }
            },
            tags: {
                serializedName: "Tags",
                xmlName: "Tags",
                type: {
                    name: "Composite",
                    className: "BlobTags"
                }
            }
        }
    }
};
const BlobTags = {
    serializedName: "BlobTags",
    xmlName: "Tags",
    type: {
        name: "Composite",
        className: "BlobTags",
        modelProperties: {
            blobTagSet: {
                serializedName: "BlobTagSet",
                required: true,
                xmlName: "TagSet",
                xmlIsWrapped: true,
                xmlElementName: "Tag",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "BlobTag"
                        }
                    }
                }
            }
        }
    }
};
const BlobTag = {
    serializedName: "BlobTag",
    xmlName: "Tag",
    type: {
        name: "Composite",
        className: "BlobTag",
        modelProperties: {
            key: {
                serializedName: "Key",
                required: true,
                xmlName: "Key",
                type: {
                    name: "String"
                }
            },
            value: {
                serializedName: "Value",
                required: true,
                xmlName: "Value",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const SignedIdentifier = {
    serializedName: "SignedIdentifier",
    xmlName: "SignedIdentifier",
    type: {
        name: "Composite",
        className: "SignedIdentifier",
        modelProperties: {
            id: {
                serializedName: "Id",
                required: true,
                xmlName: "Id",
                type: {
                    name: "String"
                }
            },
            accessPolicy: {
                serializedName: "AccessPolicy",
                xmlName: "AccessPolicy",
                type: {
                    name: "Composite",
                    className: "AccessPolicy"
                }
            }
        }
    }
};
const AccessPolicy = {
    serializedName: "AccessPolicy",
    type: {
        name: "Composite",
        className: "AccessPolicy",
        modelProperties: {
            startsOn: {
                serializedName: "Start",
                xmlName: "Start",
                type: {
                    name: "String"
                }
            },
            expiresOn: {
                serializedName: "Expiry",
                xmlName: "Expiry",
                type: {
                    name: "String"
                }
            },
            permissions: {
                serializedName: "Permission",
                xmlName: "Permission",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ListBlobsFlatSegmentResponse = {
    serializedName: "ListBlobsFlatSegmentResponse",
    xmlName: "EnumerationResults",
    type: {
        name: "Composite",
        className: "ListBlobsFlatSegmentResponse",
        modelProperties: {
            serviceEndpoint: {
                serializedName: "ServiceEndpoint",
                required: true,
                xmlName: "ServiceEndpoint",
                xmlIsAttribute: true,
                type: {
                    name: "String"
                }
            },
            containerName: {
                serializedName: "ContainerName",
                required: true,
                xmlName: "ContainerName",
                xmlIsAttribute: true,
                type: {
                    name: "String"
                }
            },
            prefix: {
                serializedName: "Prefix",
                xmlName: "Prefix",
                type: {
                    name: "String"
                }
            },
            marker: {
                serializedName: "Marker",
                xmlName: "Marker",
                type: {
                    name: "String"
                }
            },
            maxPageSize: {
                serializedName: "MaxResults",
                xmlName: "MaxResults",
                type: {
                    name: "Number"
                }
            },
            segment: {
                serializedName: "Segment",
                xmlName: "Blobs",
                type: {
                    name: "Composite",
                    className: "BlobFlatListSegment"
                }
            },
            continuationToken: {
                serializedName: "NextMarker",
                xmlName: "NextMarker",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobFlatListSegment = {
    serializedName: "BlobFlatListSegment",
    xmlName: "Blobs",
    type: {
        name: "Composite",
        className: "BlobFlatListSegment",
        modelProperties: {
            blobItems: {
                serializedName: "BlobItems",
                required: true,
                xmlName: "BlobItems",
                xmlElementName: "Blob",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "BlobItemInternal"
                        }
                    }
                }
            }
        }
    }
};
const BlobItemInternal = {
    serializedName: "BlobItemInternal",
    xmlName: "Blob",
    type: {
        name: "Composite",
        className: "BlobItemInternal",
        modelProperties: {
            name: {
                serializedName: "Name",
                xmlName: "Name",
                type: {
                    name: "Composite",
                    className: "BlobName"
                }
            },
            deleted: {
                serializedName: "Deleted",
                required: true,
                xmlName: "Deleted",
                type: {
                    name: "Boolean"
                }
            },
            snapshot: {
                serializedName: "Snapshot",
                required: true,
                xmlName: "Snapshot",
                type: {
                    name: "String"
                }
            },
            versionId: {
                serializedName: "VersionId",
                xmlName: "VersionId",
                type: {
                    name: "String"
                }
            },
            isCurrentVersion: {
                serializedName: "IsCurrentVersion",
                xmlName: "IsCurrentVersion",
                type: {
                    name: "Boolean"
                }
            },
            properties: {
                serializedName: "Properties",
                xmlName: "Properties",
                type: {
                    name: "Composite",
                    className: "BlobPropertiesInternal"
                }
            },
            metadata: {
                serializedName: "Metadata",
                xmlName: "Metadata",
                type: {
                    name: "Dictionary",
                    value: { type: { name: "String" } }
                }
            },
            blobTags: {
                serializedName: "BlobTags",
                xmlName: "Tags",
                type: {
                    name: "Composite",
                    className: "BlobTags"
                }
            },
            objectReplicationMetadata: {
                serializedName: "ObjectReplicationMetadata",
                xmlName: "OrMetadata",
                type: {
                    name: "Dictionary",
                    value: { type: { name: "String" } }
                }
            },
            hasVersionsOnly: {
                serializedName: "HasVersionsOnly",
                xmlName: "HasVersionsOnly",
                type: {
                    name: "Boolean"
                }
            }
        }
    }
};
const BlobName = {
    serializedName: "BlobName",
    type: {
        name: "Composite",
        className: "BlobName",
        modelProperties: {
            encoded: {
                serializedName: "Encoded",
                xmlName: "Encoded",
                xmlIsAttribute: true,
                type: {
                    name: "Boolean"
                }
            },
            content: {
                serializedName: "content",
                xmlName: "content",
                xmlIsMsText: true,
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobPropertiesInternal = {
    serializedName: "BlobPropertiesInternal",
    xmlName: "Properties",
    type: {
        name: "Composite",
        className: "BlobPropertiesInternal",
        modelProperties: {
            createdOn: {
                serializedName: "Creation-Time",
                xmlName: "Creation-Time",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            lastModified: {
                serializedName: "Last-Modified",
                required: true,
                xmlName: "Last-Modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "Etag",
                required: true,
                xmlName: "Etag",
                type: {
                    name: "String"
                }
            },
            contentLength: {
                serializedName: "Content-Length",
                xmlName: "Content-Length",
                type: {
                    name: "Number"
                }
            },
            contentType: {
                serializedName: "Content-Type",
                xmlName: "Content-Type",
                type: {
                    name: "String"
                }
            },
            contentEncoding: {
                serializedName: "Content-Encoding",
                xmlName: "Content-Encoding",
                type: {
                    name: "String"
                }
            },
            contentLanguage: {
                serializedName: "Content-Language",
                xmlName: "Content-Language",
                type: {
                    name: "String"
                }
            },
            contentMD5: {
                serializedName: "Content-MD5",
                xmlName: "Content-MD5",
                type: {
                    name: "ByteArray"
                }
            },
            contentDisposition: {
                serializedName: "Content-Disposition",
                xmlName: "Content-Disposition",
                type: {
                    name: "String"
                }
            },
            cacheControl: {
                serializedName: "Cache-Control",
                xmlName: "Cache-Control",
                type: {
                    name: "String"
                }
            },
            blobSequenceNumber: {
                serializedName: "x-ms-blob-sequence-number",
                xmlName: "x-ms-blob-sequence-number",
                type: {
                    name: "Number"
                }
            },
            blobType: {
                serializedName: "BlobType",
                xmlName: "BlobType",
                type: {
                    name: "Enum",
                    allowedValues: ["BlockBlob", "PageBlob", "AppendBlob"]
                }
            },
            leaseStatus: {
                serializedName: "LeaseStatus",
                xmlName: "LeaseStatus",
                type: {
                    name: "Enum",
                    allowedValues: ["locked", "unlocked"]
                }
            },
            leaseState: {
                serializedName: "LeaseState",
                xmlName: "LeaseState",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "available",
                        "leased",
                        "expired",
                        "breaking",
                        "broken"
                    ]
                }
            },
            leaseDuration: {
                serializedName: "LeaseDuration",
                xmlName: "LeaseDuration",
                type: {
                    name: "Enum",
                    allowedValues: ["infinite", "fixed"]
                }
            },
            copyId: {
                serializedName: "CopyId",
                xmlName: "CopyId",
                type: {
                    name: "String"
                }
            },
            copyStatus: {
                serializedName: "CopyStatus",
                xmlName: "CopyStatus",
                type: {
                    name: "Enum",
                    allowedValues: ["pending", "success", "aborted", "failed"]
                }
            },
            copySource: {
                serializedName: "CopySource",
                xmlName: "CopySource",
                type: {
                    name: "String"
                }
            },
            copyProgress: {
                serializedName: "CopyProgress",
                xmlName: "CopyProgress",
                type: {
                    name: "String"
                }
            },
            copyCompletedOn: {
                serializedName: "CopyCompletionTime",
                xmlName: "CopyCompletionTime",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            copyStatusDescription: {
                serializedName: "CopyStatusDescription",
                xmlName: "CopyStatusDescription",
                type: {
                    name: "String"
                }
            },
            serverEncrypted: {
                serializedName: "ServerEncrypted",
                xmlName: "ServerEncrypted",
                type: {
                    name: "Boolean"
                }
            },
            incrementalCopy: {
                serializedName: "IncrementalCopy",
                xmlName: "IncrementalCopy",
                type: {
                    name: "Boolean"
                }
            },
            destinationSnapshot: {
                serializedName: "DestinationSnapshot",
                xmlName: "DestinationSnapshot",
                type: {
                    name: "String"
                }
            },
            deletedOn: {
                serializedName: "DeletedTime",
                xmlName: "DeletedTime",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            remainingRetentionDays: {
                serializedName: "RemainingRetentionDays",
                xmlName: "RemainingRetentionDays",
                type: {
                    name: "Number"
                }
            },
            accessTier: {
                serializedName: "AccessTier",
                xmlName: "AccessTier",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "P4",
                        "P6",
                        "P10",
                        "P15",
                        "P20",
                        "P30",
                        "P40",
                        "P50",
                        "P60",
                        "P70",
                        "P80",
                        "Hot",
                        "Cool",
                        "Archive",
                        "Cold"
                    ]
                }
            },
            accessTierInferred: {
                serializedName: "AccessTierInferred",
                xmlName: "AccessTierInferred",
                type: {
                    name: "Boolean"
                }
            },
            archiveStatus: {
                serializedName: "ArchiveStatus",
                xmlName: "ArchiveStatus",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "rehydrate-pending-to-hot",
                        "rehydrate-pending-to-cool",
                        "rehydrate-pending-to-cold"
                    ]
                }
            },
            customerProvidedKeySha256: {
                serializedName: "CustomerProvidedKeySha256",
                xmlName: "CustomerProvidedKeySha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "EncryptionScope",
                xmlName: "EncryptionScope",
                type: {
                    name: "String"
                }
            },
            accessTierChangedOn: {
                serializedName: "AccessTierChangeTime",
                xmlName: "AccessTierChangeTime",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            tagCount: {
                serializedName: "TagCount",
                xmlName: "TagCount",
                type: {
                    name: "Number"
                }
            },
            expiresOn: {
                serializedName: "Expiry-Time",
                xmlName: "Expiry-Time",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            isSealed: {
                serializedName: "Sealed",
                xmlName: "Sealed",
                type: {
                    name: "Boolean"
                }
            },
            rehydratePriority: {
                serializedName: "RehydratePriority",
                xmlName: "RehydratePriority",
                type: {
                    name: "Enum",
                    allowedValues: ["High", "Standard"]
                }
            },
            lastAccessedOn: {
                serializedName: "LastAccessTime",
                xmlName: "LastAccessTime",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            immutabilityPolicyExpiresOn: {
                serializedName: "ImmutabilityPolicyUntilDate",
                xmlName: "ImmutabilityPolicyUntilDate",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            immutabilityPolicyMode: {
                serializedName: "ImmutabilityPolicyMode",
                xmlName: "ImmutabilityPolicyMode",
                type: {
                    name: "Enum",
                    allowedValues: ["Mutable", "Unlocked", "Locked"]
                }
            },
            legalHold: {
                serializedName: "LegalHold",
                xmlName: "LegalHold",
                type: {
                    name: "Boolean"
                }
            }
        }
    }
};
const ListBlobsHierarchySegmentResponse = {
    serializedName: "ListBlobsHierarchySegmentResponse",
    xmlName: "EnumerationResults",
    type: {
        name: "Composite",
        className: "ListBlobsHierarchySegmentResponse",
        modelProperties: {
            serviceEndpoint: {
                serializedName: "ServiceEndpoint",
                required: true,
                xmlName: "ServiceEndpoint",
                xmlIsAttribute: true,
                type: {
                    name: "String"
                }
            },
            containerName: {
                serializedName: "ContainerName",
                required: true,
                xmlName: "ContainerName",
                xmlIsAttribute: true,
                type: {
                    name: "String"
                }
            },
            prefix: {
                serializedName: "Prefix",
                xmlName: "Prefix",
                type: {
                    name: "String"
                }
            },
            marker: {
                serializedName: "Marker",
                xmlName: "Marker",
                type: {
                    name: "String"
                }
            },
            maxPageSize: {
                serializedName: "MaxResults",
                xmlName: "MaxResults",
                type: {
                    name: "Number"
                }
            },
            delimiter: {
                serializedName: "Delimiter",
                xmlName: "Delimiter",
                type: {
                    name: "String"
                }
            },
            segment: {
                serializedName: "Segment",
                xmlName: "Blobs",
                type: {
                    name: "Composite",
                    className: "BlobHierarchyListSegment"
                }
            },
            continuationToken: {
                serializedName: "NextMarker",
                xmlName: "NextMarker",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobHierarchyListSegment = {
    serializedName: "BlobHierarchyListSegment",
    xmlName: "Blobs",
    type: {
        name: "Composite",
        className: "BlobHierarchyListSegment",
        modelProperties: {
            blobPrefixes: {
                serializedName: "BlobPrefixes",
                xmlName: "BlobPrefixes",
                xmlElementName: "BlobPrefix",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "BlobPrefix"
                        }
                    }
                }
            },
            blobItems: {
                serializedName: "BlobItems",
                required: true,
                xmlName: "BlobItems",
                xmlElementName: "Blob",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "BlobItemInternal"
                        }
                    }
                }
            }
        }
    }
};
const BlobPrefix = {
    serializedName: "BlobPrefix",
    type: {
        name: "Composite",
        className: "BlobPrefix",
        modelProperties: {
            name: {
                serializedName: "Name",
                xmlName: "Name",
                type: {
                    name: "Composite",
                    className: "BlobName"
                }
            }
        }
    }
};
const BlockLookupList = {
    serializedName: "BlockLookupList",
    xmlName: "BlockList",
    type: {
        name: "Composite",
        className: "BlockLookupList",
        modelProperties: {
            committed: {
                serializedName: "Committed",
                xmlName: "Committed",
                xmlElementName: "Committed",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "String"
                        }
                    }
                }
            },
            uncommitted: {
                serializedName: "Uncommitted",
                xmlName: "Uncommitted",
                xmlElementName: "Uncommitted",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "String"
                        }
                    }
                }
            },
            latest: {
                serializedName: "Latest",
                xmlName: "Latest",
                xmlElementName: "Latest",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "String"
                        }
                    }
                }
            }
        }
    }
};
const BlockList = {
    serializedName: "BlockList",
    type: {
        name: "Composite",
        className: "BlockList",
        modelProperties: {
            committedBlocks: {
                serializedName: "CommittedBlocks",
                xmlName: "CommittedBlocks",
                xmlIsWrapped: true,
                xmlElementName: "Block",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "Block"
                        }
                    }
                }
            },
            uncommittedBlocks: {
                serializedName: "UncommittedBlocks",
                xmlName: "UncommittedBlocks",
                xmlIsWrapped: true,
                xmlElementName: "Block",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "Block"
                        }
                    }
                }
            }
        }
    }
};
const Block = {
    serializedName: "Block",
    type: {
        name: "Composite",
        className: "Block",
        modelProperties: {
            name: {
                serializedName: "Name",
                required: true,
                xmlName: "Name",
                type: {
                    name: "String"
                }
            },
            size: {
                serializedName: "Size",
                required: true,
                xmlName: "Size",
                type: {
                    name: "Number"
                }
            }
        }
    }
};
const PageList = {
    serializedName: "PageList",
    type: {
        name: "Composite",
        className: "PageList",
        modelProperties: {
            pageRange: {
                serializedName: "PageRange",
                xmlName: "PageRange",
                xmlElementName: "PageRange",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "PageRange"
                        }
                    }
                }
            },
            clearRange: {
                serializedName: "ClearRange",
                xmlName: "ClearRange",
                xmlElementName: "ClearRange",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "ClearRange"
                        }
                    }
                }
            },
            continuationToken: {
                serializedName: "NextMarker",
                xmlName: "NextMarker",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageRange = {
    serializedName: "PageRange",
    xmlName: "PageRange",
    type: {
        name: "Composite",
        className: "PageRange",
        modelProperties: {
            start: {
                serializedName: "Start",
                required: true,
                xmlName: "Start",
                type: {
                    name: "Number"
                }
            },
            end: {
                serializedName: "End",
                required: true,
                xmlName: "End",
                type: {
                    name: "Number"
                }
            }
        }
    }
};
const ClearRange = {
    serializedName: "ClearRange",
    xmlName: "ClearRange",
    type: {
        name: "Composite",
        className: "ClearRange",
        modelProperties: {
            start: {
                serializedName: "Start",
                required: true,
                xmlName: "Start",
                type: {
                    name: "Number"
                }
            },
            end: {
                serializedName: "End",
                required: true,
                xmlName: "End",
                type: {
                    name: "Number"
                }
            }
        }
    }
};
const QueryRequest = {
    serializedName: "QueryRequest",
    xmlName: "QueryRequest",
    type: {
        name: "Composite",
        className: "QueryRequest",
        modelProperties: {
            queryType: {
                serializedName: "QueryType",
                required: true,
                xmlName: "QueryType",
                type: {
                    name: "String"
                }
            },
            expression: {
                serializedName: "Expression",
                required: true,
                xmlName: "Expression",
                type: {
                    name: "String"
                }
            },
            inputSerialization: {
                serializedName: "InputSerialization",
                xmlName: "InputSerialization",
                type: {
                    name: "Composite",
                    className: "QuerySerialization"
                }
            },
            outputSerialization: {
                serializedName: "OutputSerialization",
                xmlName: "OutputSerialization",
                type: {
                    name: "Composite",
                    className: "QuerySerialization"
                }
            }
        }
    }
};
const QuerySerialization = {
    serializedName: "QuerySerialization",
    type: {
        name: "Composite",
        className: "QuerySerialization",
        modelProperties: {
            format: {
                serializedName: "Format",
                xmlName: "Format",
                type: {
                    name: "Composite",
                    className: "QueryFormat"
                }
            }
        }
    }
};
const QueryFormat = {
    serializedName: "QueryFormat",
    type: {
        name: "Composite",
        className: "QueryFormat",
        modelProperties: {
            type: {
                serializedName: "Type",
                required: true,
                xmlName: "Type",
                type: {
                    name: "Enum",
                    allowedValues: ["delimited", "json", "arrow", "parquet"]
                }
            },
            delimitedTextConfiguration: {
                serializedName: "DelimitedTextConfiguration",
                xmlName: "DelimitedTextConfiguration",
                type: {
                    name: "Composite",
                    className: "DelimitedTextConfiguration"
                }
            },
            jsonTextConfiguration: {
                serializedName: "JsonTextConfiguration",
                xmlName: "JsonTextConfiguration",
                type: {
                    name: "Composite",
                    className: "JsonTextConfiguration"
                }
            },
            arrowConfiguration: {
                serializedName: "ArrowConfiguration",
                xmlName: "ArrowConfiguration",
                type: {
                    name: "Composite",
                    className: "ArrowConfiguration"
                }
            },
            parquetTextConfiguration: {
                serializedName: "ParquetTextConfiguration",
                xmlName: "ParquetTextConfiguration",
                type: {
                    name: "any"
                }
            }
        }
    }
};
const DelimitedTextConfiguration = {
    serializedName: "DelimitedTextConfiguration",
    xmlName: "DelimitedTextConfiguration",
    type: {
        name: "Composite",
        className: "DelimitedTextConfiguration",
        modelProperties: {
            columnSeparator: {
                serializedName: "ColumnSeparator",
                xmlName: "ColumnSeparator",
                type: {
                    name: "String"
                }
            },
            fieldQuote: {
                serializedName: "FieldQuote",
                xmlName: "FieldQuote",
                type: {
                    name: "String"
                }
            },
            recordSeparator: {
                serializedName: "RecordSeparator",
                xmlName: "RecordSeparator",
                type: {
                    name: "String"
                }
            },
            escapeChar: {
                serializedName: "EscapeChar",
                xmlName: "EscapeChar",
                type: {
                    name: "String"
                }
            },
            headersPresent: {
                serializedName: "HeadersPresent",
                xmlName: "HasHeaders",
                type: {
                    name: "Boolean"
                }
            }
        }
    }
};
const JsonTextConfiguration = {
    serializedName: "JsonTextConfiguration",
    xmlName: "JsonTextConfiguration",
    type: {
        name: "Composite",
        className: "JsonTextConfiguration",
        modelProperties: {
            recordSeparator: {
                serializedName: "RecordSeparator",
                xmlName: "RecordSeparator",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ArrowConfiguration = {
    serializedName: "ArrowConfiguration",
    xmlName: "ArrowConfiguration",
    type: {
        name: "Composite",
        className: "ArrowConfiguration",
        modelProperties: {
            schema: {
                serializedName: "Schema",
                required: true,
                xmlName: "Schema",
                xmlIsWrapped: true,
                xmlElementName: "Field",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "ArrowField"
                        }
                    }
                }
            }
        }
    }
};
const ArrowField = {
    serializedName: "ArrowField",
    xmlName: "Field",
    type: {
        name: "Composite",
        className: "ArrowField",
        modelProperties: {
            type: {
                serializedName: "Type",
                required: true,
                xmlName: "Type",
                type: {
                    name: "String"
                }
            },
            name: {
                serializedName: "Name",
                xmlName: "Name",
                type: {
                    name: "String"
                }
            },
            precision: {
                serializedName: "Precision",
                xmlName: "Precision",
                type: {
                    name: "Number"
                }
            },
            scale: {
                serializedName: "Scale",
                xmlName: "Scale",
                type: {
                    name: "Number"
                }
            }
        }
    }
};
const ServiceSetPropertiesHeaders = {
    serializedName: "Service_setPropertiesHeaders",
    type: {
        name: "Composite",
        className: "ServiceSetPropertiesHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceSetPropertiesExceptionHeaders = {
    serializedName: "Service_setPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "ServiceSetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceGetPropertiesHeaders = {
    serializedName: "Service_getPropertiesHeaders",
    type: {
        name: "Composite",
        className: "ServiceGetPropertiesHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceGetPropertiesExceptionHeaders = {
    serializedName: "Service_getPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "ServiceGetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceGetStatisticsHeaders = {
    serializedName: "Service_getStatisticsHeaders",
    type: {
        name: "Composite",
        className: "ServiceGetStatisticsHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceGetStatisticsExceptionHeaders = {
    serializedName: "Service_getStatisticsExceptionHeaders",
    type: {
        name: "Composite",
        className: "ServiceGetStatisticsExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceListContainersSegmentHeaders = {
    serializedName: "Service_listContainersSegmentHeaders",
    type: {
        name: "Composite",
        className: "ServiceListContainersSegmentHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceListContainersSegmentExceptionHeaders = {
    serializedName: "Service_listContainersSegmentExceptionHeaders",
    type: {
        name: "Composite",
        className: "ServiceListContainersSegmentExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceGetUserDelegationKeyHeaders = {
    serializedName: "Service_getUserDelegationKeyHeaders",
    type: {
        name: "Composite",
        className: "ServiceGetUserDelegationKeyHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceGetUserDelegationKeyExceptionHeaders = {
    serializedName: "Service_getUserDelegationKeyExceptionHeaders",
    type: {
        name: "Composite",
        className: "ServiceGetUserDelegationKeyExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceGetAccountInfoHeaders = {
    serializedName: "Service_getAccountInfoHeaders",
    type: {
        name: "Composite",
        className: "ServiceGetAccountInfoHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            skuName: {
                serializedName: "x-ms-sku-name",
                xmlName: "x-ms-sku-name",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "Standard_LRS",
                        "Standard_GRS",
                        "Standard_RAGRS",
                        "Standard_ZRS",
                        "Premium_LRS"
                    ]
                }
            },
            accountKind: {
                serializedName: "x-ms-account-kind",
                xmlName: "x-ms-account-kind",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "Storage",
                        "BlobStorage",
                        "StorageV2",
                        "FileStorage",
                        "BlockBlobStorage"
                    ]
                }
            },
            isHierarchicalNamespaceEnabled: {
                serializedName: "x-ms-is-hns-enabled",
                xmlName: "x-ms-is-hns-enabled",
                type: {
                    name: "Boolean"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceGetAccountInfoExceptionHeaders = {
    serializedName: "Service_getAccountInfoExceptionHeaders",
    type: {
        name: "Composite",
        className: "ServiceGetAccountInfoExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceSubmitBatchHeaders = {
    serializedName: "Service_submitBatchHeaders",
    type: {
        name: "Composite",
        className: "ServiceSubmitBatchHeaders",
        modelProperties: {
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceSubmitBatchExceptionHeaders = {
    serializedName: "Service_submitBatchExceptionHeaders",
    type: {
        name: "Composite",
        className: "ServiceSubmitBatchExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceFilterBlobsHeaders = {
    serializedName: "Service_filterBlobsHeaders",
    type: {
        name: "Composite",
        className: "ServiceFilterBlobsHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceFilterBlobsExceptionHeaders = {
    serializedName: "Service_filterBlobsExceptionHeaders",
    type: {
        name: "Composite",
        className: "ServiceFilterBlobsExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerCreateHeaders = {
    serializedName: "Container_createHeaders",
    type: {
        name: "Composite",
        className: "ContainerCreateHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerCreateExceptionHeaders = {
    serializedName: "Container_createExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerCreateExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerGetPropertiesHeaders = {
    serializedName: "Container_getPropertiesHeaders",
    type: {
        name: "Composite",
        className: "ContainerGetPropertiesHeaders",
        modelProperties: {
            metadata: {
                serializedName: "x-ms-meta",
                xmlName: "x-ms-meta",
                type: {
                    name: "Dictionary",
                    value: { type: { name: "String" } }
                },
                headerCollectionPrefix: "x-ms-meta-"
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            leaseDuration: {
                serializedName: "x-ms-lease-duration",
                xmlName: "x-ms-lease-duration",
                type: {
                    name: "Enum",
                    allowedValues: ["infinite", "fixed"]
                }
            },
            leaseState: {
                serializedName: "x-ms-lease-state",
                xmlName: "x-ms-lease-state",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "available",
                        "leased",
                        "expired",
                        "breaking",
                        "broken"
                    ]
                }
            },
            leaseStatus: {
                serializedName: "x-ms-lease-status",
                xmlName: "x-ms-lease-status",
                type: {
                    name: "Enum",
                    allowedValues: ["locked", "unlocked"]
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            blobPublicAccess: {
                serializedName: "x-ms-blob-public-access",
                xmlName: "x-ms-blob-public-access",
                type: {
                    name: "Enum",
                    allowedValues: ["container", "blob"]
                }
            },
            hasImmutabilityPolicy: {
                serializedName: "x-ms-has-immutability-policy",
                xmlName: "x-ms-has-immutability-policy",
                type: {
                    name: "Boolean"
                }
            },
            hasLegalHold: {
                serializedName: "x-ms-has-legal-hold",
                xmlName: "x-ms-has-legal-hold",
                type: {
                    name: "Boolean"
                }
            },
            defaultEncryptionScope: {
                serializedName: "x-ms-default-encryption-scope",
                xmlName: "x-ms-default-encryption-scope",
                type: {
                    name: "String"
                }
            },
            denyEncryptionScopeOverride: {
                serializedName: "x-ms-deny-encryption-scope-override",
                xmlName: "x-ms-deny-encryption-scope-override",
                type: {
                    name: "Boolean"
                }
            },
            isImmutableStorageWithVersioningEnabled: {
                serializedName: "x-ms-immutable-storage-with-versioning-enabled",
                xmlName: "x-ms-immutable-storage-with-versioning-enabled",
                type: {
                    name: "Boolean"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerGetPropertiesExceptionHeaders = {
    serializedName: "Container_getPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerGetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerDeleteHeaders = {
    serializedName: "Container_deleteHeaders",
    type: {
        name: "Composite",
        className: "ContainerDeleteHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerDeleteExceptionHeaders = {
    serializedName: "Container_deleteExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerDeleteExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerSetMetadataHeaders = {
    serializedName: "Container_setMetadataHeaders",
    type: {
        name: "Composite",
        className: "ContainerSetMetadataHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerSetMetadataExceptionHeaders = {
    serializedName: "Container_setMetadataExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerSetMetadataExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerGetAccessPolicyHeaders = {
    serializedName: "Container_getAccessPolicyHeaders",
    type: {
        name: "Composite",
        className: "ContainerGetAccessPolicyHeaders",
        modelProperties: {
            blobPublicAccess: {
                serializedName: "x-ms-blob-public-access",
                xmlName: "x-ms-blob-public-access",
                type: {
                    name: "Enum",
                    allowedValues: ["container", "blob"]
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerGetAccessPolicyExceptionHeaders = {
    serializedName: "Container_getAccessPolicyExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerGetAccessPolicyExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerSetAccessPolicyHeaders = {
    serializedName: "Container_setAccessPolicyHeaders",
    type: {
        name: "Composite",
        className: "ContainerSetAccessPolicyHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerSetAccessPolicyExceptionHeaders = {
    serializedName: "Container_setAccessPolicyExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerSetAccessPolicyExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerRestoreHeaders = {
    serializedName: "Container_restoreHeaders",
    type: {
        name: "Composite",
        className: "ContainerRestoreHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerRestoreExceptionHeaders = {
    serializedName: "Container_restoreExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerRestoreExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerRenameHeaders = {
    serializedName: "Container_renameHeaders",
    type: {
        name: "Composite",
        className: "ContainerRenameHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerRenameExceptionHeaders = {
    serializedName: "Container_renameExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerRenameExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerSubmitBatchHeaders = {
    serializedName: "Container_submitBatchHeaders",
    type: {
        name: "Composite",
        className: "ContainerSubmitBatchHeaders",
        modelProperties: {
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerSubmitBatchExceptionHeaders = {
    serializedName: "Container_submitBatchExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerSubmitBatchExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerFilterBlobsHeaders = {
    serializedName: "Container_filterBlobsHeaders",
    type: {
        name: "Composite",
        className: "ContainerFilterBlobsHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const ContainerFilterBlobsExceptionHeaders = {
    serializedName: "Container_filterBlobsExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerFilterBlobsExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerAcquireLeaseHeaders = {
    serializedName: "Container_acquireLeaseHeaders",
    type: {
        name: "Composite",
        className: "ContainerAcquireLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            leaseId: {
                serializedName: "x-ms-lease-id",
                xmlName: "x-ms-lease-id",
                type: {
                    name: "String"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const ContainerAcquireLeaseExceptionHeaders = {
    serializedName: "Container_acquireLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerAcquireLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerReleaseLeaseHeaders = {
    serializedName: "Container_releaseLeaseHeaders",
    type: {
        name: "Composite",
        className: "ContainerReleaseLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const ContainerReleaseLeaseExceptionHeaders = {
    serializedName: "Container_releaseLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerReleaseLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerRenewLeaseHeaders = {
    serializedName: "Container_renewLeaseHeaders",
    type: {
        name: "Composite",
        className: "ContainerRenewLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            leaseId: {
                serializedName: "x-ms-lease-id",
                xmlName: "x-ms-lease-id",
                type: {
                    name: "String"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const ContainerRenewLeaseExceptionHeaders = {
    serializedName: "Container_renewLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerRenewLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerBreakLeaseHeaders = {
    serializedName: "Container_breakLeaseHeaders",
    type: {
        name: "Composite",
        className: "ContainerBreakLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            leaseTime: {
                serializedName: "x-ms-lease-time",
                xmlName: "x-ms-lease-time",
                type: {
                    name: "Number"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const ContainerBreakLeaseExceptionHeaders = {
    serializedName: "Container_breakLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerBreakLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerChangeLeaseHeaders = {
    serializedName: "Container_changeLeaseHeaders",
    type: {
        name: "Composite",
        className: "ContainerChangeLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            leaseId: {
                serializedName: "x-ms-lease-id",
                xmlName: "x-ms-lease-id",
                type: {
                    name: "String"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const ContainerChangeLeaseExceptionHeaders = {
    serializedName: "Container_changeLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerChangeLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerListBlobFlatSegmentHeaders = {
    serializedName: "Container_listBlobFlatSegmentHeaders",
    type: {
        name: "Composite",
        className: "ContainerListBlobFlatSegmentHeaders",
        modelProperties: {
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerListBlobFlatSegmentExceptionHeaders = {
    serializedName: "Container_listBlobFlatSegmentExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerListBlobFlatSegmentExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerListBlobHierarchySegmentHeaders = {
    serializedName: "Container_listBlobHierarchySegmentHeaders",
    type: {
        name: "Composite",
        className: "ContainerListBlobHierarchySegmentHeaders",
        modelProperties: {
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerListBlobHierarchySegmentExceptionHeaders = {
    serializedName: "Container_listBlobHierarchySegmentExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerListBlobHierarchySegmentExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ContainerGetAccountInfoHeaders = {
    serializedName: "Container_getAccountInfoHeaders",
    type: {
        name: "Composite",
        className: "ContainerGetAccountInfoHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            skuName: {
                serializedName: "x-ms-sku-name",
                xmlName: "x-ms-sku-name",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "Standard_LRS",
                        "Standard_GRS",
                        "Standard_RAGRS",
                        "Standard_ZRS",
                        "Premium_LRS"
                    ]
                }
            },
            accountKind: {
                serializedName: "x-ms-account-kind",
                xmlName: "x-ms-account-kind",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "Storage",
                        "BlobStorage",
                        "StorageV2",
                        "FileStorage",
                        "BlockBlobStorage"
                    ]
                }
            }
        }
    }
};
const ContainerGetAccountInfoExceptionHeaders = {
    serializedName: "Container_getAccountInfoExceptionHeaders",
    type: {
        name: "Composite",
        className: "ContainerGetAccountInfoExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobDownloadHeaders = {
    serializedName: "Blob_downloadHeaders",
    type: {
        name: "Composite",
        className: "BlobDownloadHeaders",
        modelProperties: {
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            createdOn: {
                serializedName: "x-ms-creation-time",
                xmlName: "x-ms-creation-time",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            metadata: {
                serializedName: "x-ms-meta",
                xmlName: "x-ms-meta",
                type: {
                    name: "Dictionary",
                    value: { type: { name: "String" } }
                },
                headerCollectionPrefix: "x-ms-meta-"
            },
            objectReplicationPolicyId: {
                serializedName: "x-ms-or-policy-id",
                xmlName: "x-ms-or-policy-id",
                type: {
                    name: "String"
                }
            },
            objectReplicationRules: {
                serializedName: "x-ms-or",
                xmlName: "x-ms-or",
                type: {
                    name: "Dictionary",
                    value: { type: { name: "String" } }
                },
                headerCollectionPrefix: "x-ms-or-"
            },
            contentLength: {
                serializedName: "content-length",
                xmlName: "content-length",
                type: {
                    name: "Number"
                }
            },
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            },
            contentRange: {
                serializedName: "content-range",
                xmlName: "content-range",
                type: {
                    name: "String"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            contentEncoding: {
                serializedName: "content-encoding",
                xmlName: "content-encoding",
                type: {
                    name: "String"
                }
            },
            cacheControl: {
                serializedName: "cache-control",
                xmlName: "cache-control",
                type: {
                    name: "String"
                }
            },
            contentDisposition: {
                serializedName: "content-disposition",
                xmlName: "content-disposition",
                type: {
                    name: "String"
                }
            },
            contentLanguage: {
                serializedName: "content-language",
                xmlName: "content-language",
                type: {
                    name: "String"
                }
            },
            blobSequenceNumber: {
                serializedName: "x-ms-blob-sequence-number",
                xmlName: "x-ms-blob-sequence-number",
                type: {
                    name: "Number"
                }
            },
            blobType: {
                serializedName: "x-ms-blob-type",
                xmlName: "x-ms-blob-type",
                type: {
                    name: "Enum",
                    allowedValues: ["BlockBlob", "PageBlob", "AppendBlob"]
                }
            },
            copyCompletedOn: {
                serializedName: "x-ms-copy-completion-time",
                xmlName: "x-ms-copy-completion-time",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            copyStatusDescription: {
                serializedName: "x-ms-copy-status-description",
                xmlName: "x-ms-copy-status-description",
                type: {
                    name: "String"
                }
            },
            copyId: {
                serializedName: "x-ms-copy-id",
                xmlName: "x-ms-copy-id",
                type: {
                    name: "String"
                }
            },
            copyProgress: {
                serializedName: "x-ms-copy-progress",
                xmlName: "x-ms-copy-progress",
                type: {
                    name: "String"
                }
            },
            copySource: {
                serializedName: "x-ms-copy-source",
                xmlName: "x-ms-copy-source",
                type: {
                    name: "String"
                }
            },
            copyStatus: {
                serializedName: "x-ms-copy-status",
                xmlName: "x-ms-copy-status",
                type: {
                    name: "Enum",
                    allowedValues: ["pending", "success", "aborted", "failed"]
                }
            },
            leaseDuration: {
                serializedName: "x-ms-lease-duration",
                xmlName: "x-ms-lease-duration",
                type: {
                    name: "Enum",
                    allowedValues: ["infinite", "fixed"]
                }
            },
            leaseState: {
                serializedName: "x-ms-lease-state",
                xmlName: "x-ms-lease-state",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "available",
                        "leased",
                        "expired",
                        "breaking",
                        "broken"
                    ]
                }
            },
            leaseStatus: {
                serializedName: "x-ms-lease-status",
                xmlName: "x-ms-lease-status",
                type: {
                    name: "Enum",
                    allowedValues: ["locked", "unlocked"]
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            versionId: {
                serializedName: "x-ms-version-id",
                xmlName: "x-ms-version-id",
                type: {
                    name: "String"
                }
            },
            isCurrentVersion: {
                serializedName: "x-ms-is-current-version",
                xmlName: "x-ms-is-current-version",
                type: {
                    name: "Boolean"
                }
            },
            acceptRanges: {
                serializedName: "accept-ranges",
                xmlName: "accept-ranges",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            blobCommittedBlockCount: {
                serializedName: "x-ms-blob-committed-block-count",
                xmlName: "x-ms-blob-committed-block-count",
                type: {
                    name: "Number"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-server-encrypted",
                xmlName: "x-ms-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "x-ms-encryption-scope",
                xmlName: "x-ms-encryption-scope",
                type: {
                    name: "String"
                }
            },
            blobContentMD5: {
                serializedName: "x-ms-blob-content-md5",
                xmlName: "x-ms-blob-content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            tagCount: {
                serializedName: "x-ms-tag-count",
                xmlName: "x-ms-tag-count",
                type: {
                    name: "Number"
                }
            },
            isSealed: {
                serializedName: "x-ms-blob-sealed",
                xmlName: "x-ms-blob-sealed",
                type: {
                    name: "Boolean"
                }
            },
            lastAccessed: {
                serializedName: "x-ms-last-access-time",
                xmlName: "x-ms-last-access-time",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            immutabilityPolicyExpiresOn: {
                serializedName: "x-ms-immutability-policy-until-date",
                xmlName: "x-ms-immutability-policy-until-date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            immutabilityPolicyMode: {
                serializedName: "x-ms-immutability-policy-mode",
                xmlName: "x-ms-immutability-policy-mode",
                type: {
                    name: "Enum",
                    allowedValues: ["Mutable", "Unlocked", "Locked"]
                }
            },
            legalHold: {
                serializedName: "x-ms-legal-hold",
                xmlName: "x-ms-legal-hold",
                type: {
                    name: "Boolean"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            },
            contentCrc64: {
                serializedName: "x-ms-content-crc64",
                xmlName: "x-ms-content-crc64",
                type: {
                    name: "ByteArray"
                }
            }
        }
    }
};
const BlobDownloadExceptionHeaders = {
    serializedName: "Blob_downloadExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobDownloadExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobGetPropertiesHeaders = {
    serializedName: "Blob_getPropertiesHeaders",
    type: {
        name: "Composite",
        className: "BlobGetPropertiesHeaders",
        modelProperties: {
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            createdOn: {
                serializedName: "x-ms-creation-time",
                xmlName: "x-ms-creation-time",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            metadata: {
                serializedName: "x-ms-meta",
                xmlName: "x-ms-meta",
                type: {
                    name: "Dictionary",
                    value: { type: { name: "String" } }
                },
                headerCollectionPrefix: "x-ms-meta-"
            },
            objectReplicationPolicyId: {
                serializedName: "x-ms-or-policy-id",
                xmlName: "x-ms-or-policy-id",
                type: {
                    name: "String"
                }
            },
            objectReplicationRules: {
                serializedName: "x-ms-or",
                xmlName: "x-ms-or",
                type: {
                    name: "Dictionary",
                    value: { type: { name: "String" } }
                },
                headerCollectionPrefix: "x-ms-or-"
            },
            blobType: {
                serializedName: "x-ms-blob-type",
                xmlName: "x-ms-blob-type",
                type: {
                    name: "Enum",
                    allowedValues: ["BlockBlob", "PageBlob", "AppendBlob"]
                }
            },
            copyCompletedOn: {
                serializedName: "x-ms-copy-completion-time",
                xmlName: "x-ms-copy-completion-time",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            copyStatusDescription: {
                serializedName: "x-ms-copy-status-description",
                xmlName: "x-ms-copy-status-description",
                type: {
                    name: "String"
                }
            },
            copyId: {
                serializedName: "x-ms-copy-id",
                xmlName: "x-ms-copy-id",
                type: {
                    name: "String"
                }
            },
            copyProgress: {
                serializedName: "x-ms-copy-progress",
                xmlName: "x-ms-copy-progress",
                type: {
                    name: "String"
                }
            },
            copySource: {
                serializedName: "x-ms-copy-source",
                xmlName: "x-ms-copy-source",
                type: {
                    name: "String"
                }
            },
            copyStatus: {
                serializedName: "x-ms-copy-status",
                xmlName: "x-ms-copy-status",
                type: {
                    name: "Enum",
                    allowedValues: ["pending", "success", "aborted", "failed"]
                }
            },
            isIncrementalCopy: {
                serializedName: "x-ms-incremental-copy",
                xmlName: "x-ms-incremental-copy",
                type: {
                    name: "Boolean"
                }
            },
            destinationSnapshot: {
                serializedName: "x-ms-copy-destination-snapshot",
                xmlName: "x-ms-copy-destination-snapshot",
                type: {
                    name: "String"
                }
            },
            leaseDuration: {
                serializedName: "x-ms-lease-duration",
                xmlName: "x-ms-lease-duration",
                type: {
                    name: "Enum",
                    allowedValues: ["infinite", "fixed"]
                }
            },
            leaseState: {
                serializedName: "x-ms-lease-state",
                xmlName: "x-ms-lease-state",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "available",
                        "leased",
                        "expired",
                        "breaking",
                        "broken"
                    ]
                }
            },
            leaseStatus: {
                serializedName: "x-ms-lease-status",
                xmlName: "x-ms-lease-status",
                type: {
                    name: "Enum",
                    allowedValues: ["locked", "unlocked"]
                }
            },
            contentLength: {
                serializedName: "content-length",
                xmlName: "content-length",
                type: {
                    name: "Number"
                }
            },
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            contentEncoding: {
                serializedName: "content-encoding",
                xmlName: "content-encoding",
                type: {
                    name: "String"
                }
            },
            contentDisposition: {
                serializedName: "content-disposition",
                xmlName: "content-disposition",
                type: {
                    name: "String"
                }
            },
            contentLanguage: {
                serializedName: "content-language",
                xmlName: "content-language",
                type: {
                    name: "String"
                }
            },
            cacheControl: {
                serializedName: "cache-control",
                xmlName: "cache-control",
                type: {
                    name: "String"
                }
            },
            blobSequenceNumber: {
                serializedName: "x-ms-blob-sequence-number",
                xmlName: "x-ms-blob-sequence-number",
                type: {
                    name: "Number"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            acceptRanges: {
                serializedName: "accept-ranges",
                xmlName: "accept-ranges",
                type: {
                    name: "String"
                }
            },
            blobCommittedBlockCount: {
                serializedName: "x-ms-blob-committed-block-count",
                xmlName: "x-ms-blob-committed-block-count",
                type: {
                    name: "Number"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-server-encrypted",
                xmlName: "x-ms-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "x-ms-encryption-scope",
                xmlName: "x-ms-encryption-scope",
                type: {
                    name: "String"
                }
            },
            accessTier: {
                serializedName: "x-ms-access-tier",
                xmlName: "x-ms-access-tier",
                type: {
                    name: "String"
                }
            },
            accessTierInferred: {
                serializedName: "x-ms-access-tier-inferred",
                xmlName: "x-ms-access-tier-inferred",
                type: {
                    name: "Boolean"
                }
            },
            archiveStatus: {
                serializedName: "x-ms-archive-status",
                xmlName: "x-ms-archive-status",
                type: {
                    name: "String"
                }
            },
            accessTierChangedOn: {
                serializedName: "x-ms-access-tier-change-time",
                xmlName: "x-ms-access-tier-change-time",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            versionId: {
                serializedName: "x-ms-version-id",
                xmlName: "x-ms-version-id",
                type: {
                    name: "String"
                }
            },
            isCurrentVersion: {
                serializedName: "x-ms-is-current-version",
                xmlName: "x-ms-is-current-version",
                type: {
                    name: "Boolean"
                }
            },
            tagCount: {
                serializedName: "x-ms-tag-count",
                xmlName: "x-ms-tag-count",
                type: {
                    name: "Number"
                }
            },
            expiresOn: {
                serializedName: "x-ms-expiry-time",
                xmlName: "x-ms-expiry-time",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            isSealed: {
                serializedName: "x-ms-blob-sealed",
                xmlName: "x-ms-blob-sealed",
                type: {
                    name: "Boolean"
                }
            },
            rehydratePriority: {
                serializedName: "x-ms-rehydrate-priority",
                xmlName: "x-ms-rehydrate-priority",
                type: {
                    name: "Enum",
                    allowedValues: ["High", "Standard"]
                }
            },
            lastAccessed: {
                serializedName: "x-ms-last-access-time",
                xmlName: "x-ms-last-access-time",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            immutabilityPolicyExpiresOn: {
                serializedName: "x-ms-immutability-policy-until-date",
                xmlName: "x-ms-immutability-policy-until-date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            immutabilityPolicyMode: {
                serializedName: "x-ms-immutability-policy-mode",
                xmlName: "x-ms-immutability-policy-mode",
                type: {
                    name: "Enum",
                    allowedValues: ["Mutable", "Unlocked", "Locked"]
                }
            },
            legalHold: {
                serializedName: "x-ms-legal-hold",
                xmlName: "x-ms-legal-hold",
                type: {
                    name: "Boolean"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobGetPropertiesExceptionHeaders = {
    serializedName: "Blob_getPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobGetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobDeleteHeaders = {
    serializedName: "Blob_deleteHeaders",
    type: {
        name: "Composite",
        className: "BlobDeleteHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobDeleteExceptionHeaders = {
    serializedName: "Blob_deleteExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobDeleteExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobUndeleteHeaders = {
    serializedName: "Blob_undeleteHeaders",
    type: {
        name: "Composite",
        className: "BlobUndeleteHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobUndeleteExceptionHeaders = {
    serializedName: "Blob_undeleteExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobUndeleteExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobSetExpiryHeaders = {
    serializedName: "Blob_setExpiryHeaders",
    type: {
        name: "Composite",
        className: "BlobSetExpiryHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const BlobSetExpiryExceptionHeaders = {
    serializedName: "Blob_setExpiryExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobSetExpiryExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobSetHttpHeadersHeaders = {
    serializedName: "Blob_setHttpHeadersHeaders",
    type: {
        name: "Composite",
        className: "BlobSetHttpHeadersHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            blobSequenceNumber: {
                serializedName: "x-ms-blob-sequence-number",
                xmlName: "x-ms-blob-sequence-number",
                type: {
                    name: "Number"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobSetHttpHeadersExceptionHeaders = {
    serializedName: "Blob_setHttpHeadersExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobSetHttpHeadersExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobSetImmutabilityPolicyHeaders = {
    serializedName: "Blob_setImmutabilityPolicyHeaders",
    type: {
        name: "Composite",
        className: "BlobSetImmutabilityPolicyHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            immutabilityPolicyExpiry: {
                serializedName: "x-ms-immutability-policy-until-date",
                xmlName: "x-ms-immutability-policy-until-date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            immutabilityPolicyMode: {
                serializedName: "x-ms-immutability-policy-mode",
                xmlName: "x-ms-immutability-policy-mode",
                type: {
                    name: "Enum",
                    allowedValues: ["Mutable", "Unlocked", "Locked"]
                }
            }
        }
    }
};
const BlobSetImmutabilityPolicyExceptionHeaders = {
    serializedName: "Blob_setImmutabilityPolicyExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobSetImmutabilityPolicyExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobDeleteImmutabilityPolicyHeaders = {
    serializedName: "Blob_deleteImmutabilityPolicyHeaders",
    type: {
        name: "Composite",
        className: "BlobDeleteImmutabilityPolicyHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const BlobDeleteImmutabilityPolicyExceptionHeaders = {
    serializedName: "Blob_deleteImmutabilityPolicyExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobDeleteImmutabilityPolicyExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobSetLegalHoldHeaders = {
    serializedName: "Blob_setLegalHoldHeaders",
    type: {
        name: "Composite",
        className: "BlobSetLegalHoldHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            legalHold: {
                serializedName: "x-ms-legal-hold",
                xmlName: "x-ms-legal-hold",
                type: {
                    name: "Boolean"
                }
            }
        }
    }
};
const BlobSetLegalHoldExceptionHeaders = {
    serializedName: "Blob_setLegalHoldExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobSetLegalHoldExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobSetMetadataHeaders = {
    serializedName: "Blob_setMetadataHeaders",
    type: {
        name: "Composite",
        className: "BlobSetMetadataHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            versionId: {
                serializedName: "x-ms-version-id",
                xmlName: "x-ms-version-id",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "x-ms-encryption-scope",
                xmlName: "x-ms-encryption-scope",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobSetMetadataExceptionHeaders = {
    serializedName: "Blob_setMetadataExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobSetMetadataExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobAcquireLeaseHeaders = {
    serializedName: "Blob_acquireLeaseHeaders",
    type: {
        name: "Composite",
        className: "BlobAcquireLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            leaseId: {
                serializedName: "x-ms-lease-id",
                xmlName: "x-ms-lease-id",
                type: {
                    name: "String"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const BlobAcquireLeaseExceptionHeaders = {
    serializedName: "Blob_acquireLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobAcquireLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobReleaseLeaseHeaders = {
    serializedName: "Blob_releaseLeaseHeaders",
    type: {
        name: "Composite",
        className: "BlobReleaseLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const BlobReleaseLeaseExceptionHeaders = {
    serializedName: "Blob_releaseLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobReleaseLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobRenewLeaseHeaders = {
    serializedName: "Blob_renewLeaseHeaders",
    type: {
        name: "Composite",
        className: "BlobRenewLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            leaseId: {
                serializedName: "x-ms-lease-id",
                xmlName: "x-ms-lease-id",
                type: {
                    name: "String"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const BlobRenewLeaseExceptionHeaders = {
    serializedName: "Blob_renewLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobRenewLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobChangeLeaseHeaders = {
    serializedName: "Blob_changeLeaseHeaders",
    type: {
        name: "Composite",
        className: "BlobChangeLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            leaseId: {
                serializedName: "x-ms-lease-id",
                xmlName: "x-ms-lease-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const BlobChangeLeaseExceptionHeaders = {
    serializedName: "Blob_changeLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobChangeLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobBreakLeaseHeaders = {
    serializedName: "Blob_breakLeaseHeaders",
    type: {
        name: "Composite",
        className: "BlobBreakLeaseHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            leaseTime: {
                serializedName: "x-ms-lease-time",
                xmlName: "x-ms-lease-time",
                type: {
                    name: "Number"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const BlobBreakLeaseExceptionHeaders = {
    serializedName: "Blob_breakLeaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobBreakLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobCreateSnapshotHeaders = {
    serializedName: "Blob_createSnapshotHeaders",
    type: {
        name: "Composite",
        className: "BlobCreateSnapshotHeaders",
        modelProperties: {
            snapshot: {
                serializedName: "x-ms-snapshot",
                xmlName: "x-ms-snapshot",
                type: {
                    name: "String"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            versionId: {
                serializedName: "x-ms-version-id",
                xmlName: "x-ms-version-id",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobCreateSnapshotExceptionHeaders = {
    serializedName: "Blob_createSnapshotExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobCreateSnapshotExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobStartCopyFromURLHeaders = {
    serializedName: "Blob_startCopyFromURLHeaders",
    type: {
        name: "Composite",
        className: "BlobStartCopyFromURLHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            versionId: {
                serializedName: "x-ms-version-id",
                xmlName: "x-ms-version-id",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            copyId: {
                serializedName: "x-ms-copy-id",
                xmlName: "x-ms-copy-id",
                type: {
                    name: "String"
                }
            },
            copyStatus: {
                serializedName: "x-ms-copy-status",
                xmlName: "x-ms-copy-status",
                type: {
                    name: "Enum",
                    allowedValues: ["pending", "success", "aborted", "failed"]
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobStartCopyFromURLExceptionHeaders = {
    serializedName: "Blob_startCopyFromURLExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobStartCopyFromURLExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobCopyFromURLHeaders = {
    serializedName: "Blob_copyFromURLHeaders",
    type: {
        name: "Composite",
        className: "BlobCopyFromURLHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            versionId: {
                serializedName: "x-ms-version-id",
                xmlName: "x-ms-version-id",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            copyId: {
                serializedName: "x-ms-copy-id",
                xmlName: "x-ms-copy-id",
                type: {
                    name: "String"
                }
            },
            copyStatus: {
                defaultValue: "success",
                isConstant: true,
                serializedName: "x-ms-copy-status",
                type: {
                    name: "String"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            xMsContentCrc64: {
                serializedName: "x-ms-content-crc64",
                xmlName: "x-ms-content-crc64",
                type: {
                    name: "ByteArray"
                }
            },
            encryptionScope: {
                serializedName: "x-ms-encryption-scope",
                xmlName: "x-ms-encryption-scope",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobCopyFromURLExceptionHeaders = {
    serializedName: "Blob_copyFromURLExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobCopyFromURLExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobAbortCopyFromURLHeaders = {
    serializedName: "Blob_abortCopyFromURLHeaders",
    type: {
        name: "Composite",
        className: "BlobAbortCopyFromURLHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobAbortCopyFromURLExceptionHeaders = {
    serializedName: "Blob_abortCopyFromURLExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobAbortCopyFromURLExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobSetTierHeaders = {
    serializedName: "Blob_setTierHeaders",
    type: {
        name: "Composite",
        className: "BlobSetTierHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobSetTierExceptionHeaders = {
    serializedName: "Blob_setTierExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobSetTierExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobGetAccountInfoHeaders = {
    serializedName: "Blob_getAccountInfoHeaders",
    type: {
        name: "Composite",
        className: "BlobGetAccountInfoHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            skuName: {
                serializedName: "x-ms-sku-name",
                xmlName: "x-ms-sku-name",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "Standard_LRS",
                        "Standard_GRS",
                        "Standard_RAGRS",
                        "Standard_ZRS",
                        "Premium_LRS"
                    ]
                }
            },
            accountKind: {
                serializedName: "x-ms-account-kind",
                xmlName: "x-ms-account-kind",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "Storage",
                        "BlobStorage",
                        "StorageV2",
                        "FileStorage",
                        "BlockBlobStorage"
                    ]
                }
            }
        }
    }
};
const BlobGetAccountInfoExceptionHeaders = {
    serializedName: "Blob_getAccountInfoExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobGetAccountInfoExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobQueryHeaders = {
    serializedName: "Blob_queryHeaders",
    type: {
        name: "Composite",
        className: "BlobQueryHeaders",
        modelProperties: {
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            metadata: {
                serializedName: "x-ms-meta",
                xmlName: "x-ms-meta",
                type: {
                    name: "Dictionary",
                    value: { type: { name: "String" } }
                }
            },
            contentLength: {
                serializedName: "content-length",
                xmlName: "content-length",
                type: {
                    name: "Number"
                }
            },
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            },
            contentRange: {
                serializedName: "content-range",
                xmlName: "content-range",
                type: {
                    name: "String"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            contentEncoding: {
                serializedName: "content-encoding",
                xmlName: "content-encoding",
                type: {
                    name: "String"
                }
            },
            cacheControl: {
                serializedName: "cache-control",
                xmlName: "cache-control",
                type: {
                    name: "String"
                }
            },
            contentDisposition: {
                serializedName: "content-disposition",
                xmlName: "content-disposition",
                type: {
                    name: "String"
                }
            },
            contentLanguage: {
                serializedName: "content-language",
                xmlName: "content-language",
                type: {
                    name: "String"
                }
            },
            blobSequenceNumber: {
                serializedName: "x-ms-blob-sequence-number",
                xmlName: "x-ms-blob-sequence-number",
                type: {
                    name: "Number"
                }
            },
            blobType: {
                serializedName: "x-ms-blob-type",
                xmlName: "x-ms-blob-type",
                type: {
                    name: "Enum",
                    allowedValues: ["BlockBlob", "PageBlob", "AppendBlob"]
                }
            },
            copyCompletionTime: {
                serializedName: "x-ms-copy-completion-time",
                xmlName: "x-ms-copy-completion-time",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            copyStatusDescription: {
                serializedName: "x-ms-copy-status-description",
                xmlName: "x-ms-copy-status-description",
                type: {
                    name: "String"
                }
            },
            copyId: {
                serializedName: "x-ms-copy-id",
                xmlName: "x-ms-copy-id",
                type: {
                    name: "String"
                }
            },
            copyProgress: {
                serializedName: "x-ms-copy-progress",
                xmlName: "x-ms-copy-progress",
                type: {
                    name: "String"
                }
            },
            copySource: {
                serializedName: "x-ms-copy-source",
                xmlName: "x-ms-copy-source",
                type: {
                    name: "String"
                }
            },
            copyStatus: {
                serializedName: "x-ms-copy-status",
                xmlName: "x-ms-copy-status",
                type: {
                    name: "Enum",
                    allowedValues: ["pending", "success", "aborted", "failed"]
                }
            },
            leaseDuration: {
                serializedName: "x-ms-lease-duration",
                xmlName: "x-ms-lease-duration",
                type: {
                    name: "Enum",
                    allowedValues: ["infinite", "fixed"]
                }
            },
            leaseState: {
                serializedName: "x-ms-lease-state",
                xmlName: "x-ms-lease-state",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "available",
                        "leased",
                        "expired",
                        "breaking",
                        "broken"
                    ]
                }
            },
            leaseStatus: {
                serializedName: "x-ms-lease-status",
                xmlName: "x-ms-lease-status",
                type: {
                    name: "Enum",
                    allowedValues: ["locked", "unlocked"]
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            acceptRanges: {
                serializedName: "accept-ranges",
                xmlName: "accept-ranges",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            blobCommittedBlockCount: {
                serializedName: "x-ms-blob-committed-block-count",
                xmlName: "x-ms-blob-committed-block-count",
                type: {
                    name: "Number"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-server-encrypted",
                xmlName: "x-ms-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "x-ms-encryption-scope",
                xmlName: "x-ms-encryption-scope",
                type: {
                    name: "String"
                }
            },
            blobContentMD5: {
                serializedName: "x-ms-blob-content-md5",
                xmlName: "x-ms-blob-content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            },
            contentCrc64: {
                serializedName: "x-ms-content-crc64",
                xmlName: "x-ms-content-crc64",
                type: {
                    name: "ByteArray"
                }
            }
        }
    }
};
const BlobQueryExceptionHeaders = {
    serializedName: "Blob_queryExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobQueryExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobGetTagsHeaders = {
    serializedName: "Blob_getTagsHeaders",
    type: {
        name: "Composite",
        className: "BlobGetTagsHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobGetTagsExceptionHeaders = {
    serializedName: "Blob_getTagsExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobGetTagsExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobSetTagsHeaders = {
    serializedName: "Blob_setTagsHeaders",
    type: {
        name: "Composite",
        className: "BlobSetTagsHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobSetTagsExceptionHeaders = {
    serializedName: "Blob_setTagsExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlobSetTagsExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobCreateHeaders = {
    serializedName: "PageBlob_createHeaders",
    type: {
        name: "Composite",
        className: "PageBlobCreateHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            versionId: {
                serializedName: "x-ms-version-id",
                xmlName: "x-ms-version-id",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "x-ms-encryption-scope",
                xmlName: "x-ms-encryption-scope",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobCreateExceptionHeaders = {
    serializedName: "PageBlob_createExceptionHeaders",
    type: {
        name: "Composite",
        className: "PageBlobCreateExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobUploadPagesHeaders = {
    serializedName: "PageBlob_uploadPagesHeaders",
    type: {
        name: "Composite",
        className: "PageBlobUploadPagesHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            xMsContentCrc64: {
                serializedName: "x-ms-content-crc64",
                xmlName: "x-ms-content-crc64",
                type: {
                    name: "ByteArray"
                }
            },
            blobSequenceNumber: {
                serializedName: "x-ms-blob-sequence-number",
                xmlName: "x-ms-blob-sequence-number",
                type: {
                    name: "Number"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "x-ms-encryption-scope",
                xmlName: "x-ms-encryption-scope",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobUploadPagesExceptionHeaders = {
    serializedName: "PageBlob_uploadPagesExceptionHeaders",
    type: {
        name: "Composite",
        className: "PageBlobUploadPagesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobClearPagesHeaders = {
    serializedName: "PageBlob_clearPagesHeaders",
    type: {
        name: "Composite",
        className: "PageBlobClearPagesHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            xMsContentCrc64: {
                serializedName: "x-ms-content-crc64",
                xmlName: "x-ms-content-crc64",
                type: {
                    name: "ByteArray"
                }
            },
            blobSequenceNumber: {
                serializedName: "x-ms-blob-sequence-number",
                xmlName: "x-ms-blob-sequence-number",
                type: {
                    name: "Number"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobClearPagesExceptionHeaders = {
    serializedName: "PageBlob_clearPagesExceptionHeaders",
    type: {
        name: "Composite",
        className: "PageBlobClearPagesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobUploadPagesFromURLHeaders = {
    serializedName: "PageBlob_uploadPagesFromURLHeaders",
    type: {
        name: "Composite",
        className: "PageBlobUploadPagesFromURLHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            xMsContentCrc64: {
                serializedName: "x-ms-content-crc64",
                xmlName: "x-ms-content-crc64",
                type: {
                    name: "ByteArray"
                }
            },
            blobSequenceNumber: {
                serializedName: "x-ms-blob-sequence-number",
                xmlName: "x-ms-blob-sequence-number",
                type: {
                    name: "Number"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "x-ms-encryption-scope",
                xmlName: "x-ms-encryption-scope",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobUploadPagesFromURLExceptionHeaders = {
    serializedName: "PageBlob_uploadPagesFromURLExceptionHeaders",
    type: {
        name: "Composite",
        className: "PageBlobUploadPagesFromURLExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobGetPageRangesHeaders = {
    serializedName: "PageBlob_getPageRangesHeaders",
    type: {
        name: "Composite",
        className: "PageBlobGetPageRangesHeaders",
        modelProperties: {
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            blobContentLength: {
                serializedName: "x-ms-blob-content-length",
                xmlName: "x-ms-blob-content-length",
                type: {
                    name: "Number"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobGetPageRangesExceptionHeaders = {
    serializedName: "PageBlob_getPageRangesExceptionHeaders",
    type: {
        name: "Composite",
        className: "PageBlobGetPageRangesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobGetPageRangesDiffHeaders = {
    serializedName: "PageBlob_getPageRangesDiffHeaders",
    type: {
        name: "Composite",
        className: "PageBlobGetPageRangesDiffHeaders",
        modelProperties: {
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            blobContentLength: {
                serializedName: "x-ms-blob-content-length",
                xmlName: "x-ms-blob-content-length",
                type: {
                    name: "Number"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobGetPageRangesDiffExceptionHeaders = {
    serializedName: "PageBlob_getPageRangesDiffExceptionHeaders",
    type: {
        name: "Composite",
        className: "PageBlobGetPageRangesDiffExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobResizeHeaders = {
    serializedName: "PageBlob_resizeHeaders",
    type: {
        name: "Composite",
        className: "PageBlobResizeHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            blobSequenceNumber: {
                serializedName: "x-ms-blob-sequence-number",
                xmlName: "x-ms-blob-sequence-number",
                type: {
                    name: "Number"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobResizeExceptionHeaders = {
    serializedName: "PageBlob_resizeExceptionHeaders",
    type: {
        name: "Composite",
        className: "PageBlobResizeExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobUpdateSequenceNumberHeaders = {
    serializedName: "PageBlob_updateSequenceNumberHeaders",
    type: {
        name: "Composite",
        className: "PageBlobUpdateSequenceNumberHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            blobSequenceNumber: {
                serializedName: "x-ms-blob-sequence-number",
                xmlName: "x-ms-blob-sequence-number",
                type: {
                    name: "Number"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobUpdateSequenceNumberExceptionHeaders = {
    serializedName: "PageBlob_updateSequenceNumberExceptionHeaders",
    type: {
        name: "Composite",
        className: "PageBlobUpdateSequenceNumberExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobCopyIncrementalHeaders = {
    serializedName: "PageBlob_copyIncrementalHeaders",
    type: {
        name: "Composite",
        className: "PageBlobCopyIncrementalHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            copyId: {
                serializedName: "x-ms-copy-id",
                xmlName: "x-ms-copy-id",
                type: {
                    name: "String"
                }
            },
            copyStatus: {
                serializedName: "x-ms-copy-status",
                xmlName: "x-ms-copy-status",
                type: {
                    name: "Enum",
                    allowedValues: ["pending", "success", "aborted", "failed"]
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PageBlobCopyIncrementalExceptionHeaders = {
    serializedName: "PageBlob_copyIncrementalExceptionHeaders",
    type: {
        name: "Composite",
        className: "PageBlobCopyIncrementalExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const AppendBlobCreateHeaders = {
    serializedName: "AppendBlob_createHeaders",
    type: {
        name: "Composite",
        className: "AppendBlobCreateHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            versionId: {
                serializedName: "x-ms-version-id",
                xmlName: "x-ms-version-id",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "x-ms-encryption-scope",
                xmlName: "x-ms-encryption-scope",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const AppendBlobCreateExceptionHeaders = {
    serializedName: "AppendBlob_createExceptionHeaders",
    type: {
        name: "Composite",
        className: "AppendBlobCreateExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const AppendBlobAppendBlockHeaders = {
    serializedName: "AppendBlob_appendBlockHeaders",
    type: {
        name: "Composite",
        className: "AppendBlobAppendBlockHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            xMsContentCrc64: {
                serializedName: "x-ms-content-crc64",
                xmlName: "x-ms-content-crc64",
                type: {
                    name: "ByteArray"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            blobAppendOffset: {
                serializedName: "x-ms-blob-append-offset",
                xmlName: "x-ms-blob-append-offset",
                type: {
                    name: "String"
                }
            },
            blobCommittedBlockCount: {
                serializedName: "x-ms-blob-committed-block-count",
                xmlName: "x-ms-blob-committed-block-count",
                type: {
                    name: "Number"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "x-ms-encryption-scope",
                xmlName: "x-ms-encryption-scope",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const AppendBlobAppendBlockExceptionHeaders = {
    serializedName: "AppendBlob_appendBlockExceptionHeaders",
    type: {
        name: "Composite",
        className: "AppendBlobAppendBlockExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const AppendBlobAppendBlockFromUrlHeaders = {
    serializedName: "AppendBlob_appendBlockFromUrlHeaders",
    type: {
        name: "Composite",
        className: "AppendBlobAppendBlockFromUrlHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            xMsContentCrc64: {
                serializedName: "x-ms-content-crc64",
                xmlName: "x-ms-content-crc64",
                type: {
                    name: "ByteArray"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            blobAppendOffset: {
                serializedName: "x-ms-blob-append-offset",
                xmlName: "x-ms-blob-append-offset",
                type: {
                    name: "String"
                }
            },
            blobCommittedBlockCount: {
                serializedName: "x-ms-blob-committed-block-count",
                xmlName: "x-ms-blob-committed-block-count",
                type: {
                    name: "Number"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "x-ms-encryption-scope",
                xmlName: "x-ms-encryption-scope",
                type: {
                    name: "String"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const AppendBlobAppendBlockFromUrlExceptionHeaders = {
    serializedName: "AppendBlob_appendBlockFromUrlExceptionHeaders",
    type: {
        name: "Composite",
        className: "AppendBlobAppendBlockFromUrlExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const AppendBlobSealHeaders = {
    serializedName: "AppendBlob_sealHeaders",
    type: {
        name: "Composite",
        className: "AppendBlobSealHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            isSealed: {
                serializedName: "x-ms-blob-sealed",
                xmlName: "x-ms-blob-sealed",
                type: {
                    name: "Boolean"
                }
            }
        }
    }
};
const AppendBlobSealExceptionHeaders = {
    serializedName: "AppendBlob_sealExceptionHeaders",
    type: {
        name: "Composite",
        className: "AppendBlobSealExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlockBlobUploadHeaders = {
    serializedName: "BlockBlob_uploadHeaders",
    type: {
        name: "Composite",
        className: "BlockBlobUploadHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            versionId: {
                serializedName: "x-ms-version-id",
                xmlName: "x-ms-version-id",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "x-ms-encryption-scope",
                xmlName: "x-ms-encryption-scope",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlockBlobUploadExceptionHeaders = {
    serializedName: "BlockBlob_uploadExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlockBlobUploadExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlockBlobPutBlobFromUrlHeaders = {
    serializedName: "BlockBlob_putBlobFromUrlHeaders",
    type: {
        name: "Composite",
        className: "BlockBlobPutBlobFromUrlHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            versionId: {
                serializedName: "x-ms-version-id",
                xmlName: "x-ms-version-id",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "x-ms-encryption-scope",
                xmlName: "x-ms-encryption-scope",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlockBlobPutBlobFromUrlExceptionHeaders = {
    serializedName: "BlockBlob_putBlobFromUrlExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlockBlobPutBlobFromUrlExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlockBlobStageBlockHeaders = {
    serializedName: "BlockBlob_stageBlockHeaders",
    type: {
        name: "Composite",
        className: "BlockBlobStageBlockHeaders",
        modelProperties: {
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            xMsContentCrc64: {
                serializedName: "x-ms-content-crc64",
                xmlName: "x-ms-content-crc64",
                type: {
                    name: "ByteArray"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "x-ms-encryption-scope",
                xmlName: "x-ms-encryption-scope",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlockBlobStageBlockExceptionHeaders = {
    serializedName: "BlockBlob_stageBlockExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlockBlobStageBlockExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlockBlobStageBlockFromURLHeaders = {
    serializedName: "BlockBlob_stageBlockFromURLHeaders",
    type: {
        name: "Composite",
        className: "BlockBlobStageBlockFromURLHeaders",
        modelProperties: {
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            xMsContentCrc64: {
                serializedName: "x-ms-content-crc64",
                xmlName: "x-ms-content-crc64",
                type: {
                    name: "ByteArray"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "x-ms-encryption-scope",
                xmlName: "x-ms-encryption-scope",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlockBlobStageBlockFromURLExceptionHeaders = {
    serializedName: "BlockBlob_stageBlockFromURLExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlockBlobStageBlockFromURLExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlockBlobCommitBlockListHeaders = {
    serializedName: "BlockBlob_commitBlockListHeaders",
    type: {
        name: "Composite",
        className: "BlockBlobCommitBlockListHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            xMsContentCrc64: {
                serializedName: "x-ms-content-crc64",
                xmlName: "x-ms-content-crc64",
                type: {
                    name: "ByteArray"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            versionId: {
                serializedName: "x-ms-version-id",
                xmlName: "x-ms-version-id",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "x-ms-encryption-scope",
                xmlName: "x-ms-encryption-scope",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlockBlobCommitBlockListExceptionHeaders = {
    serializedName: "BlockBlob_commitBlockListExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlockBlobCommitBlockListExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlockBlobGetBlockListHeaders = {
    serializedName: "BlockBlob_getBlockListHeaders",
    type: {
        name: "Composite",
        className: "BlockBlobGetBlockListHeaders",
        modelProperties: {
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            },
            blobContentLength: {
                serializedName: "x-ms-blob-content-length",
                xmlName: "x-ms-blob-content-length",
                type: {
                    name: "Number"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlockBlobGetBlockListExceptionHeaders = {
    serializedName: "BlockBlob_getBlockListExceptionHeaders",
    type: {
        name: "Composite",
        className: "BlockBlobGetBlockListExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};

var Mappers = /*#__PURE__*/Object.freeze({
    __proto__: null,
    BlobServiceProperties: BlobServiceProperties,
    Logging: Logging,
    RetentionPolicy: RetentionPolicy,
    Metrics: Metrics,
    CorsRule: CorsRule,
    StaticWebsite: StaticWebsite,
    StorageError: StorageError,
    BlobServiceStatistics: BlobServiceStatistics,
    GeoReplication: GeoReplication,
    ListContainersSegmentResponse: ListContainersSegmentResponse,
    ContainerItem: ContainerItem,
    ContainerProperties: ContainerProperties,
    KeyInfo: KeyInfo,
    UserDelegationKey: UserDelegationKey,
    FilterBlobSegment: FilterBlobSegment,
    FilterBlobItem: FilterBlobItem,
    BlobTags: BlobTags,
    BlobTag: BlobTag,
    SignedIdentifier: SignedIdentifier,
    AccessPolicy: AccessPolicy,
    ListBlobsFlatSegmentResponse: ListBlobsFlatSegmentResponse,
    BlobFlatListSegment: BlobFlatListSegment,
    BlobItemInternal: BlobItemInternal,
    BlobName: BlobName,
    BlobPropertiesInternal: BlobPropertiesInternal,
    ListBlobsHierarchySegmentResponse: ListBlobsHierarchySegmentResponse,
    BlobHierarchyListSegment: BlobHierarchyListSegment,
    BlobPrefix: BlobPrefix,
    BlockLookupList: BlockLookupList,
    BlockList: BlockList,
    Block: Block,
    PageList: PageList,
    PageRange: PageRange,
    ClearRange: ClearRange,
    QueryRequest: QueryRequest,
    QuerySerialization: QuerySerialization,
    QueryFormat: QueryFormat,
    DelimitedTextConfiguration: DelimitedTextConfiguration,
    JsonTextConfiguration: JsonTextConfiguration,
    ArrowConfiguration: ArrowConfiguration,
    ArrowField: ArrowField,
    ServiceSetPropertiesHeaders: ServiceSetPropertiesHeaders,
    ServiceSetPropertiesExceptionHeaders: ServiceSetPropertiesExceptionHeaders,
    ServiceGetPropertiesHeaders: ServiceGetPropertiesHeaders,
    ServiceGetPropertiesExceptionHeaders: ServiceGetPropertiesExceptionHeaders,
    ServiceGetStatisticsHeaders: ServiceGetStatisticsHeaders,
    ServiceGetStatisticsExceptionHeaders: ServiceGetStatisticsExceptionHeaders,
    ServiceListContainersSegmentHeaders: ServiceListContainersSegmentHeaders,
    ServiceListContainersSegmentExceptionHeaders: ServiceListContainersSegmentExceptionHeaders,
    ServiceGetUserDelegationKeyHeaders: ServiceGetUserDelegationKeyHeaders,
    ServiceGetUserDelegationKeyExceptionHeaders: ServiceGetUserDelegationKeyExceptionHeaders,
    ServiceGetAccountInfoHeaders: ServiceGetAccountInfoHeaders,
    ServiceGetAccountInfoExceptionHeaders: ServiceGetAccountInfoExceptionHeaders,
    ServiceSubmitBatchHeaders: ServiceSubmitBatchHeaders,
    ServiceSubmitBatchExceptionHeaders: ServiceSubmitBatchExceptionHeaders,
    ServiceFilterBlobsHeaders: ServiceFilterBlobsHeaders,
    ServiceFilterBlobsExceptionHeaders: ServiceFilterBlobsExceptionHeaders,
    ContainerCreateHeaders: ContainerCreateHeaders,
    ContainerCreateExceptionHeaders: ContainerCreateExceptionHeaders,
    ContainerGetPropertiesHeaders: ContainerGetPropertiesHeaders,
    ContainerGetPropertiesExceptionHeaders: ContainerGetPropertiesExceptionHeaders,
    ContainerDeleteHeaders: ContainerDeleteHeaders,
    ContainerDeleteExceptionHeaders: ContainerDeleteExceptionHeaders,
    ContainerSetMetadataHeaders: ContainerSetMetadataHeaders,
    ContainerSetMetadataExceptionHeaders: ContainerSetMetadataExceptionHeaders,
    ContainerGetAccessPolicyHeaders: ContainerGetAccessPolicyHeaders,
    ContainerGetAccessPolicyExceptionHeaders: ContainerGetAccessPolicyExceptionHeaders,
    ContainerSetAccessPolicyHeaders: ContainerSetAccessPolicyHeaders,
    ContainerSetAccessPolicyExceptionHeaders: ContainerSetAccessPolicyExceptionHeaders,
    ContainerRestoreHeaders: ContainerRestoreHeaders,
    ContainerRestoreExceptionHeaders: ContainerRestoreExceptionHeaders,
    ContainerRenameHeaders: ContainerRenameHeaders,
    ContainerRenameExceptionHeaders: ContainerRenameExceptionHeaders,
    ContainerSubmitBatchHeaders: ContainerSubmitBatchHeaders,
    ContainerSubmitBatchExceptionHeaders: ContainerSubmitBatchExceptionHeaders,
    ContainerFilterBlobsHeaders: ContainerFilterBlobsHeaders,
    ContainerFilterBlobsExceptionHeaders: ContainerFilterBlobsExceptionHeaders,
    ContainerAcquireLeaseHeaders: ContainerAcquireLeaseHeaders,
    ContainerAcquireLeaseExceptionHeaders: ContainerAcquireLeaseExceptionHeaders,
    ContainerReleaseLeaseHeaders: ContainerReleaseLeaseHeaders,
    ContainerReleaseLeaseExceptionHeaders: ContainerReleaseLeaseExceptionHeaders,
    ContainerRenewLeaseHeaders: ContainerRenewLeaseHeaders,
    ContainerRenewLeaseExceptionHeaders: ContainerRenewLeaseExceptionHeaders,
    ContainerBreakLeaseHeaders: ContainerBreakLeaseHeaders,
    ContainerBreakLeaseExceptionHeaders: ContainerBreakLeaseExceptionHeaders,
    ContainerChangeLeaseHeaders: ContainerChangeLeaseHeaders,
    ContainerChangeLeaseExceptionHeaders: ContainerChangeLeaseExceptionHeaders,
    ContainerListBlobFlatSegmentHeaders: ContainerListBlobFlatSegmentHeaders,
    ContainerListBlobFlatSegmentExceptionHeaders: ContainerListBlobFlatSegmentExceptionHeaders,
    ContainerListBlobHierarchySegmentHeaders: ContainerListBlobHierarchySegmentHeaders,
    ContainerListBlobHierarchySegmentExceptionHeaders: ContainerListBlobHierarchySegmentExceptionHeaders,
    ContainerGetAccountInfoHeaders: ContainerGetAccountInfoHeaders,
    ContainerGetAccountInfoExceptionHeaders: ContainerGetAccountInfoExceptionHeaders,
    BlobDownloadHeaders: BlobDownloadHeaders,
    BlobDownloadExceptionHeaders: BlobDownloadExceptionHeaders,
    BlobGetPropertiesHeaders: BlobGetPropertiesHeaders,
    BlobGetPropertiesExceptionHeaders: BlobGetPropertiesExceptionHeaders,
    BlobDeleteHeaders: BlobDeleteHeaders,
    BlobDeleteExceptionHeaders: BlobDeleteExceptionHeaders,
    BlobUndeleteHeaders: BlobUndeleteHeaders,
    BlobUndeleteExceptionHeaders: BlobUndeleteExceptionHeaders,
    BlobSetExpiryHeaders: BlobSetExpiryHeaders,
    BlobSetExpiryExceptionHeaders: BlobSetExpiryExceptionHeaders,
    BlobSetHttpHeadersHeaders: BlobSetHttpHeadersHeaders,
    BlobSetHttpHeadersExceptionHeaders: BlobSetHttpHeadersExceptionHeaders,
    BlobSetImmutabilityPolicyHeaders: BlobSetImmutabilityPolicyHeaders,
    BlobSetImmutabilityPolicyExceptionHeaders: BlobSetImmutabilityPolicyExceptionHeaders,
    BlobDeleteImmutabilityPolicyHeaders: BlobDeleteImmutabilityPolicyHeaders,
    BlobDeleteImmutabilityPolicyExceptionHeaders: BlobDeleteImmutabilityPolicyExceptionHeaders,
    BlobSetLegalHoldHeaders: BlobSetLegalHoldHeaders,
    BlobSetLegalHoldExceptionHeaders: BlobSetLegalHoldExceptionHeaders,
    BlobSetMetadataHeaders: BlobSetMetadataHeaders,
    BlobSetMetadataExceptionHeaders: BlobSetMetadataExceptionHeaders,
    BlobAcquireLeaseHeaders: BlobAcquireLeaseHeaders,
    BlobAcquireLeaseExceptionHeaders: BlobAcquireLeaseExceptionHeaders,
    BlobReleaseLeaseHeaders: BlobReleaseLeaseHeaders,
    BlobReleaseLeaseExceptionHeaders: BlobReleaseLeaseExceptionHeaders,
    BlobRenewLeaseHeaders: BlobRenewLeaseHeaders,
    BlobRenewLeaseExceptionHeaders: BlobRenewLeaseExceptionHeaders,
    BlobChangeLeaseHeaders: BlobChangeLeaseHeaders,
    BlobChangeLeaseExceptionHeaders: BlobChangeLeaseExceptionHeaders,
    BlobBreakLeaseHeaders: BlobBreakLeaseHeaders,
    BlobBreakLeaseExceptionHeaders: BlobBreakLeaseExceptionHeaders,
    BlobCreateSnapshotHeaders: BlobCreateSnapshotHeaders,
    BlobCreateSnapshotExceptionHeaders: BlobCreateSnapshotExceptionHeaders,
    BlobStartCopyFromURLHeaders: BlobStartCopyFromURLHeaders,
    BlobStartCopyFromURLExceptionHeaders: BlobStartCopyFromURLExceptionHeaders,
    BlobCopyFromURLHeaders: BlobCopyFromURLHeaders,
    BlobCopyFromURLExceptionHeaders: BlobCopyFromURLExceptionHeaders,
    BlobAbortCopyFromURLHeaders: BlobAbortCopyFromURLHeaders,
    BlobAbortCopyFromURLExceptionHeaders: BlobAbortCopyFromURLExceptionHeaders,
    BlobSetTierHeaders: BlobSetTierHeaders,
    BlobSetTierExceptionHeaders: BlobSetTierExceptionHeaders,
    BlobGetAccountInfoHeaders: BlobGetAccountInfoHeaders,
    BlobGetAccountInfoExceptionHeaders: BlobGetAccountInfoExceptionHeaders,
    BlobQueryHeaders: BlobQueryHeaders,
    BlobQueryExceptionHeaders: BlobQueryExceptionHeaders,
    BlobGetTagsHeaders: BlobGetTagsHeaders,
    BlobGetTagsExceptionHeaders: BlobGetTagsExceptionHeaders,
    BlobSetTagsHeaders: BlobSetTagsHeaders,
    BlobSetTagsExceptionHeaders: BlobSetTagsExceptionHeaders,
    PageBlobCreateHeaders: PageBlobCreateHeaders,
    PageBlobCreateExceptionHeaders: PageBlobCreateExceptionHeaders,
    PageBlobUploadPagesHeaders: PageBlobUploadPagesHeaders,
    PageBlobUploadPagesExceptionHeaders: PageBlobUploadPagesExceptionHeaders,
    PageBlobClearPagesHeaders: PageBlobClearPagesHeaders,
    PageBlobClearPagesExceptionHeaders: PageBlobClearPagesExceptionHeaders,
    PageBlobUploadPagesFromURLHeaders: PageBlobUploadPagesFromURLHeaders,
    PageBlobUploadPagesFromURLExceptionHeaders: PageBlobUploadPagesFromURLExceptionHeaders,
    PageBlobGetPageRangesHeaders: PageBlobGetPageRangesHeaders,
    PageBlobGetPageRangesExceptionHeaders: PageBlobGetPageRangesExceptionHeaders,
    PageBlobGetPageRangesDiffHeaders: PageBlobGetPageRangesDiffHeaders,
    PageBlobGetPageRangesDiffExceptionHeaders: PageBlobGetPageRangesDiffExceptionHeaders,
    PageBlobResizeHeaders: PageBlobResizeHeaders,
    PageBlobResizeExceptionHeaders: PageBlobResizeExceptionHeaders,
    PageBlobUpdateSequenceNumberHeaders: PageBlobUpdateSequenceNumberHeaders,
    PageBlobUpdateSequenceNumberExceptionHeaders: PageBlobUpdateSequenceNumberExceptionHeaders,
    PageBlobCopyIncrementalHeaders: PageBlobCopyIncrementalHeaders,
    PageBlobCopyIncrementalExceptionHeaders: PageBlobCopyIncrementalExceptionHeaders,
    AppendBlobCreateHeaders: AppendBlobCreateHeaders,
    AppendBlobCreateExceptionHeaders: AppendBlobCreateExceptionHeaders,
    AppendBlobAppendBlockHeaders: AppendBlobAppendBlockHeaders,
    AppendBlobAppendBlockExceptionHeaders: AppendBlobAppendBlockExceptionHeaders,
    AppendBlobAppendBlockFromUrlHeaders: AppendBlobAppendBlockFromUrlHeaders,
    AppendBlobAppendBlockFromUrlExceptionHeaders: AppendBlobAppendBlockFromUrlExceptionHeaders,
    AppendBlobSealHeaders: AppendBlobSealHeaders,
    AppendBlobSealExceptionHeaders: AppendBlobSealExceptionHeaders,
    BlockBlobUploadHeaders: BlockBlobUploadHeaders,
    BlockBlobUploadExceptionHeaders: BlockBlobUploadExceptionHeaders,
    BlockBlobPutBlobFromUrlHeaders: BlockBlobPutBlobFromUrlHeaders,
    BlockBlobPutBlobFromUrlExceptionHeaders: BlockBlobPutBlobFromUrlExceptionHeaders,
    BlockBlobStageBlockHeaders: BlockBlobStageBlockHeaders,
    BlockBlobStageBlockExceptionHeaders: BlockBlobStageBlockExceptionHeaders,
    BlockBlobStageBlockFromURLHeaders: BlockBlobStageBlockFromURLHeaders,
    BlockBlobStageBlockFromURLExceptionHeaders: BlockBlobStageBlockFromURLExceptionHeaders,
    BlockBlobCommitBlockListHeaders: BlockBlobCommitBlockListHeaders,
    BlockBlobCommitBlockListExceptionHeaders: BlockBlobCommitBlockListExceptionHeaders,
    BlockBlobGetBlockListHeaders: BlockBlobGetBlockListHeaders,
    BlockBlobGetBlockListExceptionHeaders: BlockBlobGetBlockListExceptionHeaders
});

/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
const contentType = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String"
        }
    }
};
const blobServiceProperties = {
    parameterPath: "blobServiceProperties",
    mapper: BlobServiceProperties
};
const accept = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
const url = {
    parameterPath: "url",
    mapper: {
        serializedName: "url",
        required: true,
        xmlName: "url",
        type: {
            name: "String"
        }
    },
    skipEncoding: true
};
const restype = {
    parameterPath: "restype",
    mapper: {
        defaultValue: "service",
        isConstant: true,
        serializedName: "restype",
        type: {
            name: "String"
        }
    }
};
const comp = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "properties",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const timeoutInSeconds = {
    parameterPath: ["options", "timeoutInSeconds"],
    mapper: {
        constraints: {
            InclusiveMinimum: 0
        },
        serializedName: "timeout",
        xmlName: "timeout",
        type: {
            name: "Number"
        }
    }
};
const version = {
    parameterPath: "version",
    mapper: {
        defaultValue: "2023-11-03",
        isConstant: true,
        serializedName: "x-ms-version",
        type: {
            name: "String"
        }
    }
};
const requestId = {
    parameterPath: ["options", "requestId"],
    mapper: {
        serializedName: "x-ms-client-request-id",
        xmlName: "x-ms-client-request-id",
        type: {
            name: "String"
        }
    }
};
const accept1 = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
const comp1 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "stats",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const comp2 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "list",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const prefix = {
    parameterPath: ["options", "prefix"],
    mapper: {
        serializedName: "prefix",
        xmlName: "prefix",
        type: {
            name: "String"
        }
    }
};
const marker = {
    parameterPath: ["options", "marker"],
    mapper: {
        serializedName: "marker",
        xmlName: "marker",
        type: {
            name: "String"
        }
    }
};
const maxPageSize = {
    parameterPath: ["options", "maxPageSize"],
    mapper: {
        constraints: {
            InclusiveMinimum: 1
        },
        serializedName: "maxresults",
        xmlName: "maxresults",
        type: {
            name: "Number"
        }
    }
};
const include = {
    parameterPath: ["options", "include"],
    mapper: {
        serializedName: "include",
        xmlName: "include",
        xmlElementName: "ListContainersIncludeType",
        type: {
            name: "Sequence",
            element: {
                type: {
                    name: "Enum",
                    allowedValues: ["metadata", "deleted", "system"]
                }
            }
        }
    },
    collectionFormat: coreHttp.QueryCollectionFormat.Csv
};
const keyInfo = {
    parameterPath: "keyInfo",
    mapper: KeyInfo
};
const comp3 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "userdelegationkey",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const restype1 = {
    parameterPath: "restype",
    mapper: {
        defaultValue: "account",
        isConstant: true,
        serializedName: "restype",
        type: {
            name: "String"
        }
    }
};
const body = {
    parameterPath: "body",
    mapper: {
        serializedName: "body",
        required: true,
        xmlName: "body",
        type: {
            name: "Stream"
        }
    }
};
const comp4 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "batch",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const contentLength = {
    parameterPath: "contentLength",
    mapper: {
        serializedName: "Content-Length",
        required: true,
        xmlName: "Content-Length",
        type: {
            name: "Number"
        }
    }
};
const multipartContentType = {
    parameterPath: "multipartContentType",
    mapper: {
        serializedName: "Content-Type",
        required: true,
        xmlName: "Content-Type",
        type: {
            name: "String"
        }
    }
};
const comp5 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "blobs",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const where = {
    parameterPath: ["options", "where"],
    mapper: {
        serializedName: "where",
        xmlName: "where",
        type: {
            name: "String"
        }
    }
};
const restype2 = {
    parameterPath: "restype",
    mapper: {
        defaultValue: "container",
        isConstant: true,
        serializedName: "restype",
        type: {
            name: "String"
        }
    }
};
const metadata = {
    parameterPath: ["options", "metadata"],
    mapper: {
        serializedName: "x-ms-meta",
        xmlName: "x-ms-meta",
        type: {
            name: "Dictionary",
            value: { type: { name: "String" } }
        },
        headerCollectionPrefix: "x-ms-meta-"
    }
};
const access = {
    parameterPath: ["options", "access"],
    mapper: {
        serializedName: "x-ms-blob-public-access",
        xmlName: "x-ms-blob-public-access",
        type: {
            name: "Enum",
            allowedValues: ["container", "blob"]
        }
    }
};
const defaultEncryptionScope = {
    parameterPath: [
        "options",
        "containerEncryptionScope",
        "defaultEncryptionScope"
    ],
    mapper: {
        serializedName: "x-ms-default-encryption-scope",
        xmlName: "x-ms-default-encryption-scope",
        type: {
            name: "String"
        }
    }
};
const preventEncryptionScopeOverride = {
    parameterPath: [
        "options",
        "containerEncryptionScope",
        "preventEncryptionScopeOverride"
    ],
    mapper: {
        serializedName: "x-ms-deny-encryption-scope-override",
        xmlName: "x-ms-deny-encryption-scope-override",
        type: {
            name: "Boolean"
        }
    }
};
const leaseId = {
    parameterPath: ["options", "leaseAccessConditions", "leaseId"],
    mapper: {
        serializedName: "x-ms-lease-id",
        xmlName: "x-ms-lease-id",
        type: {
            name: "String"
        }
    }
};
const ifModifiedSince = {
    parameterPath: ["options", "modifiedAccessConditions", "ifModifiedSince"],
    mapper: {
        serializedName: "If-Modified-Since",
        xmlName: "If-Modified-Since",
        type: {
            name: "DateTimeRfc1123"
        }
    }
};
const ifUnmodifiedSince = {
    parameterPath: ["options", "modifiedAccessConditions", "ifUnmodifiedSince"],
    mapper: {
        serializedName: "If-Unmodified-Since",
        xmlName: "If-Unmodified-Since",
        type: {
            name: "DateTimeRfc1123"
        }
    }
};
const comp6 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "metadata",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const comp7 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "acl",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const containerAcl = {
    parameterPath: ["options", "containerAcl"],
    mapper: {
        serializedName: "containerAcl",
        xmlName: "SignedIdentifiers",
        xmlIsWrapped: true,
        xmlElementName: "SignedIdentifier",
        type: {
            name: "Sequence",
            element: {
                type: {
                    name: "Composite",
                    className: "SignedIdentifier"
                }
            }
        }
    }
};
const comp8 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "undelete",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const deletedContainerName = {
    parameterPath: ["options", "deletedContainerName"],
    mapper: {
        serializedName: "x-ms-deleted-container-name",
        xmlName: "x-ms-deleted-container-name",
        type: {
            name: "String"
        }
    }
};
const deletedContainerVersion = {
    parameterPath: ["options", "deletedContainerVersion"],
    mapper: {
        serializedName: "x-ms-deleted-container-version",
        xmlName: "x-ms-deleted-container-version",
        type: {
            name: "String"
        }
    }
};
const comp9 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "rename",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const sourceContainerName = {
    parameterPath: "sourceContainerName",
    mapper: {
        serializedName: "x-ms-source-container-name",
        required: true,
        xmlName: "x-ms-source-container-name",
        type: {
            name: "String"
        }
    }
};
const sourceLeaseId = {
    parameterPath: ["options", "sourceLeaseId"],
    mapper: {
        serializedName: "x-ms-source-lease-id",
        xmlName: "x-ms-source-lease-id",
        type: {
            name: "String"
        }
    }
};
const comp10 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "lease",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const action = {
    parameterPath: "action",
    mapper: {
        defaultValue: "acquire",
        isConstant: true,
        serializedName: "x-ms-lease-action",
        type: {
            name: "String"
        }
    }
};
const duration = {
    parameterPath: ["options", "duration"],
    mapper: {
        serializedName: "x-ms-lease-duration",
        xmlName: "x-ms-lease-duration",
        type: {
            name: "Number"
        }
    }
};
const proposedLeaseId = {
    parameterPath: ["options", "proposedLeaseId"],
    mapper: {
        serializedName: "x-ms-proposed-lease-id",
        xmlName: "x-ms-proposed-lease-id",
        type: {
            name: "String"
        }
    }
};
const action1 = {
    parameterPath: "action",
    mapper: {
        defaultValue: "release",
        isConstant: true,
        serializedName: "x-ms-lease-action",
        type: {
            name: "String"
        }
    }
};
const leaseId1 = {
    parameterPath: "leaseId",
    mapper: {
        serializedName: "x-ms-lease-id",
        required: true,
        xmlName: "x-ms-lease-id",
        type: {
            name: "String"
        }
    }
};
const action2 = {
    parameterPath: "action",
    mapper: {
        defaultValue: "renew",
        isConstant: true,
        serializedName: "x-ms-lease-action",
        type: {
            name: "String"
        }
    }
};
const action3 = {
    parameterPath: "action",
    mapper: {
        defaultValue: "break",
        isConstant: true,
        serializedName: "x-ms-lease-action",
        type: {
            name: "String"
        }
    }
};
const breakPeriod = {
    parameterPath: ["options", "breakPeriod"],
    mapper: {
        serializedName: "x-ms-lease-break-period",
        xmlName: "x-ms-lease-break-period",
        type: {
            name: "Number"
        }
    }
};
const action4 = {
    parameterPath: "action",
    mapper: {
        defaultValue: "change",
        isConstant: true,
        serializedName: "x-ms-lease-action",
        type: {
            name: "String"
        }
    }
};
const proposedLeaseId1 = {
    parameterPath: "proposedLeaseId",
    mapper: {
        serializedName: "x-ms-proposed-lease-id",
        required: true,
        xmlName: "x-ms-proposed-lease-id",
        type: {
            name: "String"
        }
    }
};
const include1 = {
    parameterPath: ["options", "include"],
    mapper: {
        serializedName: "include",
        xmlName: "include",
        xmlElementName: "ListBlobsIncludeItem",
        type: {
            name: "Sequence",
            element: {
                type: {
                    name: "Enum",
                    allowedValues: [
                        "copy",
                        "deleted",
                        "metadata",
                        "snapshots",
                        "uncommittedblobs",
                        "versions",
                        "tags",
                        "immutabilitypolicy",
                        "legalhold",
                        "deletedwithversions"
                    ]
                }
            }
        }
    },
    collectionFormat: coreHttp.QueryCollectionFormat.Csv
};
const delimiter = {
    parameterPath: "delimiter",
    mapper: {
        serializedName: "delimiter",
        required: true,
        xmlName: "delimiter",
        type: {
            name: "String"
        }
    }
};
const snapshot = {
    parameterPath: ["options", "snapshot"],
    mapper: {
        serializedName: "snapshot",
        xmlName: "snapshot",
        type: {
            name: "String"
        }
    }
};
const versionId = {
    parameterPath: ["options", "versionId"],
    mapper: {
        serializedName: "versionid",
        xmlName: "versionid",
        type: {
            name: "String"
        }
    }
};
const range = {
    parameterPath: ["options", "range"],
    mapper: {
        serializedName: "x-ms-range",
        xmlName: "x-ms-range",
        type: {
            name: "String"
        }
    }
};
const rangeGetContentMD5 = {
    parameterPath: ["options", "rangeGetContentMD5"],
    mapper: {
        serializedName: "x-ms-range-get-content-md5",
        xmlName: "x-ms-range-get-content-md5",
        type: {
            name: "Boolean"
        }
    }
};
const rangeGetContentCRC64 = {
    parameterPath: ["options", "rangeGetContentCRC64"],
    mapper: {
        serializedName: "x-ms-range-get-content-crc64",
        xmlName: "x-ms-range-get-content-crc64",
        type: {
            name: "Boolean"
        }
    }
};
const encryptionKey = {
    parameterPath: ["options", "cpkInfo", "encryptionKey"],
    mapper: {
        serializedName: "x-ms-encryption-key",
        xmlName: "x-ms-encryption-key",
        type: {
            name: "String"
        }
    }
};
const encryptionKeySha256 = {
    parameterPath: ["options", "cpkInfo", "encryptionKeySha256"],
    mapper: {
        serializedName: "x-ms-encryption-key-sha256",
        xmlName: "x-ms-encryption-key-sha256",
        type: {
            name: "String"
        }
    }
};
const encryptionAlgorithm = {
    parameterPath: ["options", "cpkInfo", "encryptionAlgorithm"],
    mapper: {
        serializedName: "x-ms-encryption-algorithm",
        xmlName: "x-ms-encryption-algorithm",
        type: {
            name: "String"
        }
    }
};
const ifMatch = {
    parameterPath: ["options", "modifiedAccessConditions", "ifMatch"],
    mapper: {
        serializedName: "If-Match",
        xmlName: "If-Match",
        type: {
            name: "String"
        }
    }
};
const ifNoneMatch = {
    parameterPath: ["options", "modifiedAccessConditions", "ifNoneMatch"],
    mapper: {
        serializedName: "If-None-Match",
        xmlName: "If-None-Match",
        type: {
            name: "String"
        }
    }
};
const ifTags = {
    parameterPath: ["options", "modifiedAccessConditions", "ifTags"],
    mapper: {
        serializedName: "x-ms-if-tags",
        xmlName: "x-ms-if-tags",
        type: {
            name: "String"
        }
    }
};
const deleteSnapshots = {
    parameterPath: ["options", "deleteSnapshots"],
    mapper: {
        serializedName: "x-ms-delete-snapshots",
        xmlName: "x-ms-delete-snapshots",
        type: {
            name: "Enum",
            allowedValues: ["include", "only"]
        }
    }
};
const blobDeleteType = {
    parameterPath: ["options", "blobDeleteType"],
    mapper: {
        serializedName: "deletetype",
        xmlName: "deletetype",
        type: {
            name: "String"
        }
    }
};
const comp11 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "expiry",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const expiryOptions = {
    parameterPath: "expiryOptions",
    mapper: {
        serializedName: "x-ms-expiry-option",
        required: true,
        xmlName: "x-ms-expiry-option",
        type: {
            name: "String"
        }
    }
};
const expiresOn = {
    parameterPath: ["options", "expiresOn"],
    mapper: {
        serializedName: "x-ms-expiry-time",
        xmlName: "x-ms-expiry-time",
        type: {
            name: "String"
        }
    }
};
const blobCacheControl = {
    parameterPath: ["options", "blobHttpHeaders", "blobCacheControl"],
    mapper: {
        serializedName: "x-ms-blob-cache-control",
        xmlName: "x-ms-blob-cache-control",
        type: {
            name: "String"
        }
    }
};
const blobContentType = {
    parameterPath: ["options", "blobHttpHeaders", "blobContentType"],
    mapper: {
        serializedName: "x-ms-blob-content-type",
        xmlName: "x-ms-blob-content-type",
        type: {
            name: "String"
        }
    }
};
const blobContentMD5 = {
    parameterPath: ["options", "blobHttpHeaders", "blobContentMD5"],
    mapper: {
        serializedName: "x-ms-blob-content-md5",
        xmlName: "x-ms-blob-content-md5",
        type: {
            name: "ByteArray"
        }
    }
};
const blobContentEncoding = {
    parameterPath: ["options", "blobHttpHeaders", "blobContentEncoding"],
    mapper: {
        serializedName: "x-ms-blob-content-encoding",
        xmlName: "x-ms-blob-content-encoding",
        type: {
            name: "String"
        }
    }
};
const blobContentLanguage = {
    parameterPath: ["options", "blobHttpHeaders", "blobContentLanguage"],
    mapper: {
        serializedName: "x-ms-blob-content-language",
        xmlName: "x-ms-blob-content-language",
        type: {
            name: "String"
        }
    }
};
const blobContentDisposition = {
    parameterPath: ["options", "blobHttpHeaders", "blobContentDisposition"],
    mapper: {
        serializedName: "x-ms-blob-content-disposition",
        xmlName: "x-ms-blob-content-disposition",
        type: {
            name: "String"
        }
    }
};
const comp12 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "immutabilityPolicies",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const immutabilityPolicyExpiry = {
    parameterPath: ["options", "immutabilityPolicyExpiry"],
    mapper: {
        serializedName: "x-ms-immutability-policy-until-date",
        xmlName: "x-ms-immutability-policy-until-date",
        type: {
            name: "DateTimeRfc1123"
        }
    }
};
const immutabilityPolicyMode = {
    parameterPath: ["options", "immutabilityPolicyMode"],
    mapper: {
        serializedName: "x-ms-immutability-policy-mode",
        xmlName: "x-ms-immutability-policy-mode",
        type: {
            name: "Enum",
            allowedValues: ["Mutable", "Unlocked", "Locked"]
        }
    }
};
const comp13 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "legalhold",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const legalHold = {
    parameterPath: "legalHold",
    mapper: {
        serializedName: "x-ms-legal-hold",
        required: true,
        xmlName: "x-ms-legal-hold",
        type: {
            name: "Boolean"
        }
    }
};
const encryptionScope = {
    parameterPath: ["options", "encryptionScope"],
    mapper: {
        serializedName: "x-ms-encryption-scope",
        xmlName: "x-ms-encryption-scope",
        type: {
            name: "String"
        }
    }
};
const comp14 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "snapshot",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const tier = {
    parameterPath: ["options", "tier"],
    mapper: {
        serializedName: "x-ms-access-tier",
        xmlName: "x-ms-access-tier",
        type: {
            name: "Enum",
            allowedValues: [
                "P4",
                "P6",
                "P10",
                "P15",
                "P20",
                "P30",
                "P40",
                "P50",
                "P60",
                "P70",
                "P80",
                "Hot",
                "Cool",
                "Archive",
                "Cold"
            ]
        }
    }
};
const rehydratePriority = {
    parameterPath: ["options", "rehydratePriority"],
    mapper: {
        serializedName: "x-ms-rehydrate-priority",
        xmlName: "x-ms-rehydrate-priority",
        type: {
            name: "Enum",
            allowedValues: ["High", "Standard"]
        }
    }
};
const sourceIfModifiedSince = {
    parameterPath: [
        "options",
        "sourceModifiedAccessConditions",
        "sourceIfModifiedSince"
    ],
    mapper: {
        serializedName: "x-ms-source-if-modified-since",
        xmlName: "x-ms-source-if-modified-since",
        type: {
            name: "DateTimeRfc1123"
        }
    }
};
const sourceIfUnmodifiedSince = {
    parameterPath: [
        "options",
        "sourceModifiedAccessConditions",
        "sourceIfUnmodifiedSince"
    ],
    mapper: {
        serializedName: "x-ms-source-if-unmodified-since",
        xmlName: "x-ms-source-if-unmodified-since",
        type: {
            name: "DateTimeRfc1123"
        }
    }
};
const sourceIfMatch = {
    parameterPath: ["options", "sourceModifiedAccessConditions", "sourceIfMatch"],
    mapper: {
        serializedName: "x-ms-source-if-match",
        xmlName: "x-ms-source-if-match",
        type: {
            name: "String"
        }
    }
};
const sourceIfNoneMatch = {
    parameterPath: [
        "options",
        "sourceModifiedAccessConditions",
        "sourceIfNoneMatch"
    ],
    mapper: {
        serializedName: "x-ms-source-if-none-match",
        xmlName: "x-ms-source-if-none-match",
        type: {
            name: "String"
        }
    }
};
const sourceIfTags = {
    parameterPath: ["options", "sourceModifiedAccessConditions", "sourceIfTags"],
    mapper: {
        serializedName: "x-ms-source-if-tags",
        xmlName: "x-ms-source-if-tags",
        type: {
            name: "String"
        }
    }
};
const copySource = {
    parameterPath: "copySource",
    mapper: {
        serializedName: "x-ms-copy-source",
        required: true,
        xmlName: "x-ms-copy-source",
        type: {
            name: "String"
        }
    }
};
const blobTagsString = {
    parameterPath: ["options", "blobTagsString"],
    mapper: {
        serializedName: "x-ms-tags",
        xmlName: "x-ms-tags",
        type: {
            name: "String"
        }
    }
};
const sealBlob = {
    parameterPath: ["options", "sealBlob"],
    mapper: {
        serializedName: "x-ms-seal-blob",
        xmlName: "x-ms-seal-blob",
        type: {
            name: "Boolean"
        }
    }
};
const legalHold1 = {
    parameterPath: ["options", "legalHold"],
    mapper: {
        serializedName: "x-ms-legal-hold",
        xmlName: "x-ms-legal-hold",
        type: {
            name: "Boolean"
        }
    }
};
const xMsRequiresSync = {
    parameterPath: "xMsRequiresSync",
    mapper: {
        defaultValue: "true",
        isConstant: true,
        serializedName: "x-ms-requires-sync",
        type: {
            name: "String"
        }
    }
};
const sourceContentMD5 = {
    parameterPath: ["options", "sourceContentMD5"],
    mapper: {
        serializedName: "x-ms-source-content-md5",
        xmlName: "x-ms-source-content-md5",
        type: {
            name: "ByteArray"
        }
    }
};
const copySourceAuthorization = {
    parameterPath: ["options", "copySourceAuthorization"],
    mapper: {
        serializedName: "x-ms-copy-source-authorization",
        xmlName: "x-ms-copy-source-authorization",
        type: {
            name: "String"
        }
    }
};
const copySourceTags = {
    parameterPath: ["options", "copySourceTags"],
    mapper: {
        serializedName: "x-ms-copy-source-tag-option",
        xmlName: "x-ms-copy-source-tag-option",
        type: {
            name: "Enum",
            allowedValues: ["REPLACE", "COPY"]
        }
    }
};
const comp15 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "copy",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const copyActionAbortConstant = {
    parameterPath: "copyActionAbortConstant",
    mapper: {
        defaultValue: "abort",
        isConstant: true,
        serializedName: "x-ms-copy-action",
        type: {
            name: "String"
        }
    }
};
const copyId = {
    parameterPath: "copyId",
    mapper: {
        serializedName: "copyid",
        required: true,
        xmlName: "copyid",
        type: {
            name: "String"
        }
    }
};
const comp16 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "tier",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const tier1 = {
    parameterPath: "tier",
    mapper: {
        serializedName: "x-ms-access-tier",
        required: true,
        xmlName: "x-ms-access-tier",
        type: {
            name: "Enum",
            allowedValues: [
                "P4",
                "P6",
                "P10",
                "P15",
                "P20",
                "P30",
                "P40",
                "P50",
                "P60",
                "P70",
                "P80",
                "Hot",
                "Cool",
                "Archive",
                "Cold"
            ]
        }
    }
};
const queryRequest = {
    parameterPath: ["options", "queryRequest"],
    mapper: QueryRequest
};
const comp17 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "query",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const comp18 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "tags",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const tags = {
    parameterPath: ["options", "tags"],
    mapper: BlobTags
};
const transactionalContentMD5 = {
    parameterPath: ["options", "transactionalContentMD5"],
    mapper: {
        serializedName: "Content-MD5",
        xmlName: "Content-MD5",
        type: {
            name: "ByteArray"
        }
    }
};
const transactionalContentCrc64 = {
    parameterPath: ["options", "transactionalContentCrc64"],
    mapper: {
        serializedName: "x-ms-content-crc64",
        xmlName: "x-ms-content-crc64",
        type: {
            name: "ByteArray"
        }
    }
};
const blobType = {
    parameterPath: "blobType",
    mapper: {
        defaultValue: "PageBlob",
        isConstant: true,
        serializedName: "x-ms-blob-type",
        type: {
            name: "String"
        }
    }
};
const blobContentLength = {
    parameterPath: "blobContentLength",
    mapper: {
        serializedName: "x-ms-blob-content-length",
        required: true,
        xmlName: "x-ms-blob-content-length",
        type: {
            name: "Number"
        }
    }
};
const blobSequenceNumber = {
    parameterPath: ["options", "blobSequenceNumber"],
    mapper: {
        serializedName: "x-ms-blob-sequence-number",
        xmlName: "x-ms-blob-sequence-number",
        type: {
            name: "Number"
        }
    }
};
const contentType1 = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/octet-stream",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String"
        }
    }
};
const body1 = {
    parameterPath: "body",
    mapper: {
        serializedName: "body",
        required: true,
        xmlName: "body",
        type: {
            name: "Stream"
        }
    }
};
const accept2 = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
const comp19 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "page",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const pageWrite = {
    parameterPath: "pageWrite",
    mapper: {
        defaultValue: "update",
        isConstant: true,
        serializedName: "x-ms-page-write",
        type: {
            name: "String"
        }
    }
};
const ifSequenceNumberLessThanOrEqualTo = {
    parameterPath: [
        "options",
        "sequenceNumberAccessConditions",
        "ifSequenceNumberLessThanOrEqualTo"
    ],
    mapper: {
        serializedName: "x-ms-if-sequence-number-le",
        xmlName: "x-ms-if-sequence-number-le",
        type: {
            name: "Number"
        }
    }
};
const ifSequenceNumberLessThan = {
    parameterPath: [
        "options",
        "sequenceNumberAccessConditions",
        "ifSequenceNumberLessThan"
    ],
    mapper: {
        serializedName: "x-ms-if-sequence-number-lt",
        xmlName: "x-ms-if-sequence-number-lt",
        type: {
            name: "Number"
        }
    }
};
const ifSequenceNumberEqualTo = {
    parameterPath: [
        "options",
        "sequenceNumberAccessConditions",
        "ifSequenceNumberEqualTo"
    ],
    mapper: {
        serializedName: "x-ms-if-sequence-number-eq",
        xmlName: "x-ms-if-sequence-number-eq",
        type: {
            name: "Number"
        }
    }
};
const pageWrite1 = {
    parameterPath: "pageWrite",
    mapper: {
        defaultValue: "clear",
        isConstant: true,
        serializedName: "x-ms-page-write",
        type: {
            name: "String"
        }
    }
};
const sourceUrl = {
    parameterPath: "sourceUrl",
    mapper: {
        serializedName: "x-ms-copy-source",
        required: true,
        xmlName: "x-ms-copy-source",
        type: {
            name: "String"
        }
    }
};
const sourceRange = {
    parameterPath: "sourceRange",
    mapper: {
        serializedName: "x-ms-source-range",
        required: true,
        xmlName: "x-ms-source-range",
        type: {
            name: "String"
        }
    }
};
const sourceContentCrc64 = {
    parameterPath: ["options", "sourceContentCrc64"],
    mapper: {
        serializedName: "x-ms-source-content-crc64",
        xmlName: "x-ms-source-content-crc64",
        type: {
            name: "ByteArray"
        }
    }
};
const range1 = {
    parameterPath: "range",
    mapper: {
        serializedName: "x-ms-range",
        required: true,
        xmlName: "x-ms-range",
        type: {
            name: "String"
        }
    }
};
const comp20 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "pagelist",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const prevsnapshot = {
    parameterPath: ["options", "prevsnapshot"],
    mapper: {
        serializedName: "prevsnapshot",
        xmlName: "prevsnapshot",
        type: {
            name: "String"
        }
    }
};
const prevSnapshotUrl = {
    parameterPath: ["options", "prevSnapshotUrl"],
    mapper: {
        serializedName: "x-ms-previous-snapshot-url",
        xmlName: "x-ms-previous-snapshot-url",
        type: {
            name: "String"
        }
    }
};
const sequenceNumberAction = {
    parameterPath: "sequenceNumberAction",
    mapper: {
        serializedName: "x-ms-sequence-number-action",
        required: true,
        xmlName: "x-ms-sequence-number-action",
        type: {
            name: "Enum",
            allowedValues: ["max", "update", "increment"]
        }
    }
};
const comp21 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "incrementalcopy",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const blobType1 = {
    parameterPath: "blobType",
    mapper: {
        defaultValue: "AppendBlob",
        isConstant: true,
        serializedName: "x-ms-blob-type",
        type: {
            name: "String"
        }
    }
};
const comp22 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "appendblock",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const maxSize = {
    parameterPath: ["options", "appendPositionAccessConditions", "maxSize"],
    mapper: {
        serializedName: "x-ms-blob-condition-maxsize",
        xmlName: "x-ms-blob-condition-maxsize",
        type: {
            name: "Number"
        }
    }
};
const appendPosition = {
    parameterPath: [
        "options",
        "appendPositionAccessConditions",
        "appendPosition"
    ],
    mapper: {
        serializedName: "x-ms-blob-condition-appendpos",
        xmlName: "x-ms-blob-condition-appendpos",
        type: {
            name: "Number"
        }
    }
};
const sourceRange1 = {
    parameterPath: ["options", "sourceRange"],
    mapper: {
        serializedName: "x-ms-source-range",
        xmlName: "x-ms-source-range",
        type: {
            name: "String"
        }
    }
};
const comp23 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "seal",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const blobType2 = {
    parameterPath: "blobType",
    mapper: {
        defaultValue: "BlockBlob",
        isConstant: true,
        serializedName: "x-ms-blob-type",
        type: {
            name: "String"
        }
    }
};
const copySourceBlobProperties = {
    parameterPath: ["options", "copySourceBlobProperties"],
    mapper: {
        serializedName: "x-ms-copy-source-blob-properties",
        xmlName: "x-ms-copy-source-blob-properties",
        type: {
            name: "Boolean"
        }
    }
};
const comp24 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "block",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const blockId = {
    parameterPath: "blockId",
    mapper: {
        serializedName: "blockid",
        required: true,
        xmlName: "blockid",
        type: {
            name: "String"
        }
    }
};
const blocks = {
    parameterPath: "blocks",
    mapper: BlockLookupList
};
const comp25 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "blocklist",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const listType = {
    parameterPath: "listType",
    mapper: {
        defaultValue: "committed",
        serializedName: "blocklisttype",
        required: true,
        xmlName: "blocklisttype",
        type: {
            name: "Enum",
            allowedValues: ["committed", "uncommitted", "all"]
        }
    }
};

/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
/** Class representing a Service. */
class Service {
    /**
     * Initialize a new instance of the class Service class.
     * @param client Reference to the service client
     */
    constructor(client) {
        this.client = client;
    }
    /**
     * Sets properties for a storage account's Blob service endpoint, including properties for Storage
     * Analytics and CORS (Cross-Origin Resource Sharing) rules
     * @param blobServiceProperties The StorageService properties.
     * @param options The options parameters.
     */
    setProperties(blobServiceProperties, options) {
        const operationArguments = {
            blobServiceProperties,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, setPropertiesOperationSpec);
    }
    /**
     * gets the properties of a storage account's Blob service, including properties for Storage Analytics
     * and CORS (Cross-Origin Resource Sharing) rules.
     * @param options The options parameters.
     */
    getProperties(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, getPropertiesOperationSpec$2);
    }
    /**
     * Retrieves statistics related to replication for the Blob service. It is only available on the
     * secondary location endpoint when read-access geo-redundant replication is enabled for the storage
     * account.
     * @param options The options parameters.
     */
    getStatistics(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, getStatisticsOperationSpec);
    }
    /**
     * The List Containers Segment operation returns a list of the containers under the specified account
     * @param options The options parameters.
     */
    listContainersSegment(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, listContainersSegmentOperationSpec);
    }
    /**
     * Retrieves a user delegation key for the Blob service. This is only a valid operation when using
     * bearer token authentication.
     * @param keyInfo Key information
     * @param options The options parameters.
     */
    getUserDelegationKey(keyInfo, options) {
        const operationArguments = {
            keyInfo,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, getUserDelegationKeyOperationSpec);
    }
    /**
     * Returns the sku name and account kind
     * @param options The options parameters.
     */
    getAccountInfo(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, getAccountInfoOperationSpec$2);
    }
    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch
     *                             boundary. Example header value: multipart/mixed; boundary=batch_<GUID>
     * @param body Initial data
     * @param options The options parameters.
     */
    submitBatch(contentLength, multipartContentType, body, options) {
        const operationArguments = {
            contentLength,
            multipartContentType,
            body,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, submitBatchOperationSpec$1);
    }
    /**
     * The Filter Blobs operation enables callers to list blobs across all containers whose tags match a
     * given search expression.  Filter blobs searches across all containers within a storage account but
     * can be scoped within the expression to a single container.
     * @param options The options parameters.
     */
    filterBlobs(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, filterBlobsOperationSpec$1);
    }
}
// Operation Specifications
const xmlSerializer$5 = new coreHttp__namespace.Serializer(Mappers, /* isXml */ true);
const setPropertiesOperationSpec = {
    path: "/",
    httpMethod: "PUT",
    responses: {
        202: {
            headersMapper: ServiceSetPropertiesHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ServiceSetPropertiesExceptionHeaders
        }
    },
    requestBody: blobServiceProperties,
    queryParameters: [
        restype,
        comp,
        timeoutInSeconds
    ],
    urlParameters: [url],
    headerParameters: [
        contentType,
        accept,
        version,
        requestId
    ],
    isXML: true,
    contentType: "application/xml; charset=utf-8",
    mediaType: "xml",
    serializer: xmlSerializer$5
};
const getPropertiesOperationSpec$2 = {
    path: "/",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: BlobServiceProperties,
            headersMapper: ServiceGetPropertiesHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ServiceGetPropertiesExceptionHeaders
        }
    },
    queryParameters: [
        restype,
        comp,
        timeoutInSeconds
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1
    ],
    isXML: true,
    serializer: xmlSerializer$5
};
const getStatisticsOperationSpec = {
    path: "/",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: BlobServiceStatistics,
            headersMapper: ServiceGetStatisticsHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ServiceGetStatisticsExceptionHeaders
        }
    },
    queryParameters: [
        restype,
        timeoutInSeconds,
        comp1
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1
    ],
    isXML: true,
    serializer: xmlSerializer$5
};
const listContainersSegmentOperationSpec = {
    path: "/",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: ListContainersSegmentResponse,
            headersMapper: ServiceListContainersSegmentHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ServiceListContainersSegmentExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        comp2,
        prefix,
        marker,
        maxPageSize,
        include
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1
    ],
    isXML: true,
    serializer: xmlSerializer$5
};
const getUserDelegationKeyOperationSpec = {
    path: "/",
    httpMethod: "POST",
    responses: {
        200: {
            bodyMapper: UserDelegationKey,
            headersMapper: ServiceGetUserDelegationKeyHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ServiceGetUserDelegationKeyExceptionHeaders
        }
    },
    requestBody: keyInfo,
    queryParameters: [
        restype,
        timeoutInSeconds,
        comp3
    ],
    urlParameters: [url],
    headerParameters: [
        contentType,
        accept,
        version,
        requestId
    ],
    isXML: true,
    contentType: "application/xml; charset=utf-8",
    mediaType: "xml",
    serializer: xmlSerializer$5
};
const getAccountInfoOperationSpec$2 = {
    path: "/",
    httpMethod: "GET",
    responses: {
        200: {
            headersMapper: ServiceGetAccountInfoHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ServiceGetAccountInfoExceptionHeaders
        }
    },
    queryParameters: [comp, restype1],
    urlParameters: [url],
    headerParameters: [version, accept1],
    isXML: true,
    serializer: xmlSerializer$5
};
const submitBatchOperationSpec$1 = {
    path: "/",
    httpMethod: "POST",
    responses: {
        202: {
            bodyMapper: {
                type: { name: "Stream" },
                serializedName: "parsedResponse"
            },
            headersMapper: ServiceSubmitBatchHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ServiceSubmitBatchExceptionHeaders
        }
    },
    requestBody: body,
    queryParameters: [timeoutInSeconds, comp4],
    urlParameters: [url],
    headerParameters: [
        contentType,
        accept,
        version,
        requestId,
        contentLength,
        multipartContentType
    ],
    isXML: true,
    contentType: "application/xml; charset=utf-8",
    mediaType: "xml",
    serializer: xmlSerializer$5
};
const filterBlobsOperationSpec$1 = {
    path: "/",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: FilterBlobSegment,
            headersMapper: ServiceFilterBlobsHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ServiceFilterBlobsExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        marker,
        maxPageSize,
        comp5,
        where
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1
    ],
    isXML: true,
    serializer: xmlSerializer$5
};

/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
/** Class representing a Container. */
class Container {
    /**
     * Initialize a new instance of the class Container class.
     * @param client Reference to the service client
     */
    constructor(client) {
        this.client = client;
    }
    /**
     * creates a new container under the specified account. If the container with the same name already
     * exists, the operation fails
     * @param options The options parameters.
     */
    create(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, createOperationSpec$2);
    }
    /**
     * returns all user-defined metadata and system properties for the specified container. The data
     * returned does not include the container's list of blobs
     * @param options The options parameters.
     */
    getProperties(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, getPropertiesOperationSpec$1);
    }
    /**
     * operation marks the specified container for deletion. The container and any blobs contained within
     * it are later deleted during garbage collection
     * @param options The options parameters.
     */
    delete(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, deleteOperationSpec$1);
    }
    /**
     * operation sets one or more user-defined name-value pairs for the specified container.
     * @param options The options parameters.
     */
    setMetadata(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, setMetadataOperationSpec$1);
    }
    /**
     * gets the permissions for the specified container. The permissions indicate whether container data
     * may be accessed publicly.
     * @param options The options parameters.
     */
    getAccessPolicy(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, getAccessPolicyOperationSpec);
    }
    /**
     * sets the permissions for the specified container. The permissions indicate whether blobs in a
     * container may be accessed publicly.
     * @param options The options parameters.
     */
    setAccessPolicy(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, setAccessPolicyOperationSpec);
    }
    /**
     * Restores a previously-deleted container.
     * @param options The options parameters.
     */
    restore(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, restoreOperationSpec);
    }
    /**
     * Renames an existing container.
     * @param sourceContainerName Required.  Specifies the name of the container to rename.
     * @param options The options parameters.
     */
    rename(sourceContainerName, options) {
        const operationArguments = {
            sourceContainerName,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, renameOperationSpec);
    }
    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch
     *                             boundary. Example header value: multipart/mixed; boundary=batch_<GUID>
     * @param body Initial data
     * @param options The options parameters.
     */
    submitBatch(contentLength, multipartContentType, body, options) {
        const operationArguments = {
            contentLength,
            multipartContentType,
            body,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, submitBatchOperationSpec);
    }
    /**
     * The Filter Blobs operation enables callers to list blobs in a container whose tags match a given
     * search expression.  Filter blobs searches within the given container.
     * @param options The options parameters.
     */
    filterBlobs(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, filterBlobsOperationSpec);
    }
    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can
     * be 15 to 60 seconds, or can be infinite
     * @param options The options parameters.
     */
    acquireLease(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, acquireLeaseOperationSpec$1);
    }
    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can
     * be 15 to 60 seconds, or can be infinite
     * @param leaseId Specifies the current lease ID on the resource.
     * @param options The options parameters.
     */
    releaseLease(leaseId, options) {
        const operationArguments = {
            leaseId,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, releaseLeaseOperationSpec$1);
    }
    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can
     * be 15 to 60 seconds, or can be infinite
     * @param leaseId Specifies the current lease ID on the resource.
     * @param options The options parameters.
     */
    renewLease(leaseId, options) {
        const operationArguments = {
            leaseId,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, renewLeaseOperationSpec$1);
    }
    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can
     * be 15 to 60 seconds, or can be infinite
     * @param options The options parameters.
     */
    breakLease(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, breakLeaseOperationSpec$1);
    }
    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can
     * be 15 to 60 seconds, or can be infinite
     * @param leaseId Specifies the current lease ID on the resource.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400
     *                        (Invalid request) if the proposed lease ID is not in the correct format. See Guid Constructor
     *                        (String) for a list of valid GUID string formats.
     * @param options The options parameters.
     */
    changeLease(leaseId, proposedLeaseId, options) {
        const operationArguments = {
            leaseId,
            proposedLeaseId,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, changeLeaseOperationSpec$1);
    }
    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container
     * @param options The options parameters.
     */
    listBlobFlatSegment(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, listBlobFlatSegmentOperationSpec);
    }
    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container
     * @param delimiter When the request includes this parameter, the operation returns a BlobPrefix
     *                  element in the response body that acts as a placeholder for all blobs whose names begin with the
     *                  same substring up to the appearance of the delimiter character. The delimiter may be a single
     *                  character or a string.
     * @param options The options parameters.
     */
    listBlobHierarchySegment(delimiter, options) {
        const operationArguments = {
            delimiter,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, listBlobHierarchySegmentOperationSpec);
    }
    /**
     * Returns the sku name and account kind
     * @param options The options parameters.
     */
    getAccountInfo(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, getAccountInfoOperationSpec$1);
    }
}
// Operation Specifications
const xmlSerializer$4 = new coreHttp__namespace.Serializer(Mappers, /* isXml */ true);
const createOperationSpec$2 = {
    path: "/{containerName}",
    httpMethod: "PUT",
    responses: {
        201: {
            headersMapper: ContainerCreateHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerCreateExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds, restype2],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        metadata,
        access,
        defaultEncryptionScope,
        preventEncryptionScopeOverride
    ],
    isXML: true,
    serializer: xmlSerializer$4
};
const getPropertiesOperationSpec$1 = {
    path: "/{containerName}",
    httpMethod: "GET",
    responses: {
        200: {
            headersMapper: ContainerGetPropertiesHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerGetPropertiesExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds, restype2],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        leaseId
    ],
    isXML: true,
    serializer: xmlSerializer$4
};
const deleteOperationSpec$1 = {
    path: "/{containerName}",
    httpMethod: "DELETE",
    responses: {
        202: {
            headersMapper: ContainerDeleteHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerDeleteExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds, restype2],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        leaseId,
        ifModifiedSince,
        ifUnmodifiedSince
    ],
    isXML: true,
    serializer: xmlSerializer$4
};
const setMetadataOperationSpec$1 = {
    path: "/{containerName}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: ContainerSetMetadataHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerSetMetadataExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        restype2,
        comp6
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        metadata,
        leaseId,
        ifModifiedSince
    ],
    isXML: true,
    serializer: xmlSerializer$4
};
const getAccessPolicyOperationSpec = {
    path: "/{containerName}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: {
                type: {
                    name: "Sequence",
                    element: {
                        type: { name: "Composite", className: "SignedIdentifier" }
                    }
                },
                serializedName: "SignedIdentifiers",
                xmlName: "SignedIdentifiers",
                xmlIsWrapped: true,
                xmlElementName: "SignedIdentifier"
            },
            headersMapper: ContainerGetAccessPolicyHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerGetAccessPolicyExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        restype2,
        comp7
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        leaseId
    ],
    isXML: true,
    serializer: xmlSerializer$4
};
const setAccessPolicyOperationSpec = {
    path: "/{containerName}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: ContainerSetAccessPolicyHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerSetAccessPolicyExceptionHeaders
        }
    },
    requestBody: containerAcl,
    queryParameters: [
        timeoutInSeconds,
        restype2,
        comp7
    ],
    urlParameters: [url],
    headerParameters: [
        contentType,
        accept,
        version,
        requestId,
        access,
        leaseId,
        ifModifiedSince,
        ifUnmodifiedSince
    ],
    isXML: true,
    contentType: "application/xml; charset=utf-8",
    mediaType: "xml",
    serializer: xmlSerializer$4
};
const restoreOperationSpec = {
    path: "/{containerName}",
    httpMethod: "PUT",
    responses: {
        201: {
            headersMapper: ContainerRestoreHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerRestoreExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        restype2,
        comp8
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        deletedContainerName,
        deletedContainerVersion
    ],
    isXML: true,
    serializer: xmlSerializer$4
};
const renameOperationSpec = {
    path: "/{containerName}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: ContainerRenameHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerRenameExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        restype2,
        comp9
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        sourceContainerName,
        sourceLeaseId
    ],
    isXML: true,
    serializer: xmlSerializer$4
};
const submitBatchOperationSpec = {
    path: "/{containerName}",
    httpMethod: "POST",
    responses: {
        202: {
            bodyMapper: {
                type: { name: "Stream" },
                serializedName: "parsedResponse"
            },
            headersMapper: ContainerSubmitBatchHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerSubmitBatchExceptionHeaders
        }
    },
    requestBody: body,
    queryParameters: [
        timeoutInSeconds,
        comp4,
        restype2
    ],
    urlParameters: [url],
    headerParameters: [
        contentType,
        accept,
        version,
        requestId,
        contentLength,
        multipartContentType
    ],
    isXML: true,
    contentType: "application/xml; charset=utf-8",
    mediaType: "xml",
    serializer: xmlSerializer$4
};
const filterBlobsOperationSpec = {
    path: "/{containerName}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: FilterBlobSegment,
            headersMapper: ContainerFilterBlobsHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerFilterBlobsExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        marker,
        maxPageSize,
        comp5,
        where,
        restype2
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1
    ],
    isXML: true,
    serializer: xmlSerializer$4
};
const acquireLeaseOperationSpec$1 = {
    path: "/{containerName}",
    httpMethod: "PUT",
    responses: {
        201: {
            headersMapper: ContainerAcquireLeaseHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerAcquireLeaseExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        restype2,
        comp10
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        ifModifiedSince,
        ifUnmodifiedSince,
        action,
        duration,
        proposedLeaseId
    ],
    isXML: true,
    serializer: xmlSerializer$4
};
const releaseLeaseOperationSpec$1 = {
    path: "/{containerName}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: ContainerReleaseLeaseHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerReleaseLeaseExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        restype2,
        comp10
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        ifModifiedSince,
        ifUnmodifiedSince,
        action1,
        leaseId1
    ],
    isXML: true,
    serializer: xmlSerializer$4
};
const renewLeaseOperationSpec$1 = {
    path: "/{containerName}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: ContainerRenewLeaseHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerRenewLeaseExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        restype2,
        comp10
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        ifModifiedSince,
        ifUnmodifiedSince,
        leaseId1,
        action2
    ],
    isXML: true,
    serializer: xmlSerializer$4
};
const breakLeaseOperationSpec$1 = {
    path: "/{containerName}",
    httpMethod: "PUT",
    responses: {
        202: {
            headersMapper: ContainerBreakLeaseHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerBreakLeaseExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        restype2,
        comp10
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        ifModifiedSince,
        ifUnmodifiedSince,
        action3,
        breakPeriod
    ],
    isXML: true,
    serializer: xmlSerializer$4
};
const changeLeaseOperationSpec$1 = {
    path: "/{containerName}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: ContainerChangeLeaseHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerChangeLeaseExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        restype2,
        comp10
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        ifModifiedSince,
        ifUnmodifiedSince,
        leaseId1,
        action4,
        proposedLeaseId1
    ],
    isXML: true,
    serializer: xmlSerializer$4
};
const listBlobFlatSegmentOperationSpec = {
    path: "/{containerName}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: ListBlobsFlatSegmentResponse,
            headersMapper: ContainerListBlobFlatSegmentHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerListBlobFlatSegmentExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        comp2,
        prefix,
        marker,
        maxPageSize,
        restype2,
        include1
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1
    ],
    isXML: true,
    serializer: xmlSerializer$4
};
const listBlobHierarchySegmentOperationSpec = {
    path: "/{containerName}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: ListBlobsHierarchySegmentResponse,
            headersMapper: ContainerListBlobHierarchySegmentHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerListBlobHierarchySegmentExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        comp2,
        prefix,
        marker,
        maxPageSize,
        restype2,
        include1,
        delimiter
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1
    ],
    isXML: true,
    serializer: xmlSerializer$4
};
const getAccountInfoOperationSpec$1 = {
    path: "/{containerName}",
    httpMethod: "GET",
    responses: {
        200: {
            headersMapper: ContainerGetAccountInfoHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ContainerGetAccountInfoExceptionHeaders
        }
    },
    queryParameters: [comp, restype1],
    urlParameters: [url],
    headerParameters: [version, accept1],
    isXML: true,
    serializer: xmlSerializer$4
};

/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
/** Class representing a Blob. */
class Blob$1 {
    /**
     * Initialize a new instance of the class Blob class.
     * @param client Reference to the service client
     */
    constructor(client) {
        this.client = client;
    }
    /**
     * The Download operation reads or downloads a blob from the system, including its metadata and
     * properties. You can also call Download to read a snapshot.
     * @param options The options parameters.
     */
    download(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, downloadOperationSpec);
    }
    /**
     * The Get Properties operation returns all user-defined metadata, standard HTTP properties, and system
     * properties for the blob. It does not return the content of the blob.
     * @param options The options parameters.
     */
    getProperties(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, getPropertiesOperationSpec);
    }
    /**
     * If the storage account's soft delete feature is disabled then, when a blob is deleted, it is
     * permanently removed from the storage account. If the storage account's soft delete feature is
     * enabled, then, when a blob is deleted, it is marked for deletion and becomes inaccessible
     * immediately. However, the blob service retains the blob or snapshot for the number of days specified
     * by the DeleteRetentionPolicy section of [Storage service properties]
     * (Set-Blob-Service-Properties.md). After the specified number of days has passed, the blob's data is
     * permanently removed from the storage account. Note that you continue to be charged for the
     * soft-deleted blob's storage until it is permanently removed. Use the List Blobs API and specify the
     * "include=deleted" query parameter to discover which blobs and snapshots have been soft deleted. You
     * can then use the Undelete Blob API to restore a soft-deleted blob. All other operations on a
     * soft-deleted blob or snapshot causes the service to return an HTTP status code of 404
     * (ResourceNotFound).
     * @param options The options parameters.
     */
    delete(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, deleteOperationSpec);
    }
    /**
     * Undelete a blob that was previously soft deleted
     * @param options The options parameters.
     */
    undelete(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, undeleteOperationSpec);
    }
    /**
     * Sets the time a blob will expire and be deleted.
     * @param expiryOptions Required. Indicates mode of the expiry time
     * @param options The options parameters.
     */
    setExpiry(expiryOptions, options) {
        const operationArguments = {
            expiryOptions,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, setExpiryOperationSpec);
    }
    /**
     * The Set HTTP Headers operation sets system properties on the blob
     * @param options The options parameters.
     */
    setHttpHeaders(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, setHttpHeadersOperationSpec);
    }
    /**
     * The Set Immutability Policy operation sets the immutability policy on the blob
     * @param options The options parameters.
     */
    setImmutabilityPolicy(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, setImmutabilityPolicyOperationSpec);
    }
    /**
     * The Delete Immutability Policy operation deletes the immutability policy on the blob
     * @param options The options parameters.
     */
    deleteImmutabilityPolicy(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, deleteImmutabilityPolicyOperationSpec);
    }
    /**
     * The Set Legal Hold operation sets a legal hold on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param options The options parameters.
     */
    setLegalHold(legalHold, options) {
        const operationArguments = {
            legalHold,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, setLegalHoldOperationSpec);
    }
    /**
     * The Set Blob Metadata operation sets user-defined metadata for the specified blob as one or more
     * name-value pairs
     * @param options The options parameters.
     */
    setMetadata(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, setMetadataOperationSpec);
    }
    /**
     * [Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete
     * operations
     * @param options The options parameters.
     */
    acquireLease(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, acquireLeaseOperationSpec);
    }
    /**
     * [Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete
     * operations
     * @param leaseId Specifies the current lease ID on the resource.
     * @param options The options parameters.
     */
    releaseLease(leaseId, options) {
        const operationArguments = {
            leaseId,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, releaseLeaseOperationSpec);
    }
    /**
     * [Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete
     * operations
     * @param leaseId Specifies the current lease ID on the resource.
     * @param options The options parameters.
     */
    renewLease(leaseId, options) {
        const operationArguments = {
            leaseId,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, renewLeaseOperationSpec);
    }
    /**
     * [Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete
     * operations
     * @param leaseId Specifies the current lease ID on the resource.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400
     *                        (Invalid request) if the proposed lease ID is not in the correct format. See Guid Constructor
     *                        (String) for a list of valid GUID string formats.
     * @param options The options parameters.
     */
    changeLease(leaseId, proposedLeaseId, options) {
        const operationArguments = {
            leaseId,
            proposedLeaseId,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, changeLeaseOperationSpec);
    }
    /**
     * [Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete
     * operations
     * @param options The options parameters.
     */
    breakLease(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, breakLeaseOperationSpec);
    }
    /**
     * The Create Snapshot operation creates a read-only snapshot of a blob
     * @param options The options parameters.
     */
    createSnapshot(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, createSnapshotOperationSpec);
    }
    /**
     * The Start Copy From URL operation copies a blob or an internet resource to a new blob.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to
     *                   2 KB in length that specifies a page blob snapshot. The value should be URL-encoded as it would
     *                   appear in a request URI. The source blob must either be public or must be authenticated via a shared
     *                   access signature.
     * @param options The options parameters.
     */
    startCopyFromURL(copySource, options) {
        const operationArguments = {
            copySource,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, startCopyFromURLOperationSpec);
    }
    /**
     * The Copy From URL operation copies a blob or an internet resource to a new blob. It will not return
     * a response until the copy is complete.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to
     *                   2 KB in length that specifies a page blob snapshot. The value should be URL-encoded as it would
     *                   appear in a request URI. The source blob must either be public or must be authenticated via a shared
     *                   access signature.
     * @param options The options parameters.
     */
    copyFromURL(copySource, options) {
        const operationArguments = {
            copySource,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, copyFromURLOperationSpec);
    }
    /**
     * The Abort Copy From URL operation aborts a pending Copy From URL operation, and leaves a destination
     * blob with zero length and full metadata.
     * @param copyId The copy identifier provided in the x-ms-copy-id header of the original Copy Blob
     *               operation.
     * @param options The options parameters.
     */
    abortCopyFromURL(copyId, options) {
        const operationArguments = {
            copyId,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, abortCopyFromURLOperationSpec);
    }
    /**
     * The Set Tier operation sets the tier on a blob. The operation is allowed on a page blob in a premium
     * storage account and on a block blob in a blob storage account (locally redundant storage only). A
     * premium page blob's tier determines the allowed size, IOPS, and bandwidth of the blob. A block
     * blob's tier determines Hot/Cool/Archive storage type. This operation does not update the blob's
     * ETag.
     * @param tier Indicates the tier to be set on the blob.
     * @param options The options parameters.
     */
    setTier(tier, options) {
        const operationArguments = {
            tier,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, setTierOperationSpec);
    }
    /**
     * Returns the sku name and account kind
     * @param options The options parameters.
     */
    getAccountInfo(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, getAccountInfoOperationSpec);
    }
    /**
     * The Query operation enables users to select/project on blob data by providing simple query
     * expressions.
     * @param options The options parameters.
     */
    query(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, queryOperationSpec);
    }
    /**
     * The Get Tags operation enables users to get the tags associated with a blob.
     * @param options The options parameters.
     */
    getTags(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, getTagsOperationSpec);
    }
    /**
     * The Set Tags operation enables users to set tags on a blob.
     * @param options The options parameters.
     */
    setTags(options) {
        const operationArguments = {
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, setTagsOperationSpec);
    }
}
// Operation Specifications
const xmlSerializer$3 = new coreHttp__namespace.Serializer(Mappers, /* isXml */ true);
const downloadOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: {
                type: { name: "Stream" },
                serializedName: "parsedResponse"
            },
            headersMapper: BlobDownloadHeaders
        },
        206: {
            bodyMapper: {
                type: { name: "Stream" },
                serializedName: "parsedResponse"
            },
            headersMapper: BlobDownloadHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobDownloadExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        snapshot,
        versionId
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        leaseId,
        ifModifiedSince,
        ifUnmodifiedSince,
        range,
        rangeGetContentMD5,
        rangeGetContentCRC64,
        encryptionKey,
        encryptionKeySha256,
        encryptionAlgorithm,
        ifMatch,
        ifNoneMatch,
        ifTags
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const getPropertiesOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "HEAD",
    responses: {
        200: {
            headersMapper: BlobGetPropertiesHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobGetPropertiesExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        snapshot,
        versionId
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        leaseId,
        ifModifiedSince,
        ifUnmodifiedSince,
        encryptionKey,
        encryptionKeySha256,
        encryptionAlgorithm,
        ifMatch,
        ifNoneMatch,
        ifTags
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const deleteOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "DELETE",
    responses: {
        202: {
            headersMapper: BlobDeleteHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobDeleteExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        snapshot,
        versionId,
        blobDeleteType
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        leaseId,
        ifModifiedSince,
        ifUnmodifiedSince,
        ifMatch,
        ifNoneMatch,
        ifTags,
        deleteSnapshots
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const undeleteOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: BlobUndeleteHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobUndeleteExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds, comp8],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const setExpiryOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: BlobSetExpiryHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobSetExpiryExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds, comp11],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        expiryOptions,
        expiresOn
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const setHttpHeadersOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: BlobSetHttpHeadersHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobSetHttpHeadersExceptionHeaders
        }
    },
    queryParameters: [comp, timeoutInSeconds],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        leaseId,
        ifModifiedSince,
        ifUnmodifiedSince,
        ifMatch,
        ifNoneMatch,
        ifTags,
        blobCacheControl,
        blobContentType,
        blobContentMD5,
        blobContentEncoding,
        blobContentLanguage,
        blobContentDisposition
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const setImmutabilityPolicyOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: BlobSetImmutabilityPolicyHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobSetImmutabilityPolicyExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds, comp12],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        ifUnmodifiedSince,
        immutabilityPolicyExpiry,
        immutabilityPolicyMode
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const deleteImmutabilityPolicyOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "DELETE",
    responses: {
        200: {
            headersMapper: BlobDeleteImmutabilityPolicyHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobDeleteImmutabilityPolicyExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds, comp12],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const setLegalHoldOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: BlobSetLegalHoldHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobSetLegalHoldExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds, comp13],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        legalHold
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const setMetadataOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: BlobSetMetadataHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobSetMetadataExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds, comp6],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        metadata,
        leaseId,
        ifModifiedSince,
        ifUnmodifiedSince,
        encryptionKey,
        encryptionKeySha256,
        encryptionAlgorithm,
        ifMatch,
        ifNoneMatch,
        ifTags,
        encryptionScope
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const acquireLeaseOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        201: {
            headersMapper: BlobAcquireLeaseHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobAcquireLeaseExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds, comp10],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        ifModifiedSince,
        ifUnmodifiedSince,
        action,
        duration,
        proposedLeaseId,
        ifMatch,
        ifNoneMatch,
        ifTags
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const releaseLeaseOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: BlobReleaseLeaseHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobReleaseLeaseExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds, comp10],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        ifModifiedSince,
        ifUnmodifiedSince,
        action1,
        leaseId1,
        ifMatch,
        ifNoneMatch,
        ifTags
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const renewLeaseOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: BlobRenewLeaseHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobRenewLeaseExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds, comp10],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        ifModifiedSince,
        ifUnmodifiedSince,
        leaseId1,
        action2,
        ifMatch,
        ifNoneMatch,
        ifTags
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const changeLeaseOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: BlobChangeLeaseHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobChangeLeaseExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds, comp10],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        ifModifiedSince,
        ifUnmodifiedSince,
        leaseId1,
        action4,
        proposedLeaseId1,
        ifMatch,
        ifNoneMatch,
        ifTags
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const breakLeaseOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        202: {
            headersMapper: BlobBreakLeaseHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobBreakLeaseExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds, comp10],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        ifModifiedSince,
        ifUnmodifiedSince,
        action3,
        breakPeriod,
        ifMatch,
        ifNoneMatch,
        ifTags
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const createSnapshotOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        201: {
            headersMapper: BlobCreateSnapshotHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobCreateSnapshotExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds, comp14],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        metadata,
        leaseId,
        ifModifiedSince,
        ifUnmodifiedSince,
        encryptionKey,
        encryptionKeySha256,
        encryptionAlgorithm,
        ifMatch,
        ifNoneMatch,
        ifTags,
        encryptionScope
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const startCopyFromURLOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        202: {
            headersMapper: BlobStartCopyFromURLHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobStartCopyFromURLExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        metadata,
        leaseId,
        ifModifiedSince,
        ifUnmodifiedSince,
        ifMatch,
        ifNoneMatch,
        ifTags,
        immutabilityPolicyExpiry,
        immutabilityPolicyMode,
        tier,
        rehydratePriority,
        sourceIfModifiedSince,
        sourceIfUnmodifiedSince,
        sourceIfMatch,
        sourceIfNoneMatch,
        sourceIfTags,
        copySource,
        blobTagsString,
        sealBlob,
        legalHold1
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const copyFromURLOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        202: {
            headersMapper: BlobCopyFromURLHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobCopyFromURLExceptionHeaders
        }
    },
    queryParameters: [timeoutInSeconds],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        metadata,
        leaseId,
        ifModifiedSince,
        ifUnmodifiedSince,
        ifMatch,
        ifNoneMatch,
        ifTags,
        immutabilityPolicyExpiry,
        immutabilityPolicyMode,
        encryptionScope,
        tier,
        sourceIfModifiedSince,
        sourceIfUnmodifiedSince,
        sourceIfMatch,
        sourceIfNoneMatch,
        copySource,
        blobTagsString,
        legalHold1,
        xMsRequiresSync,
        sourceContentMD5,
        copySourceAuthorization,
        copySourceTags
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const abortCopyFromURLOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        204: {
            headersMapper: BlobAbortCopyFromURLHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobAbortCopyFromURLExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        comp15,
        copyId
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        leaseId,
        copyActionAbortConstant
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const setTierOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: BlobSetTierHeaders
        },
        202: {
            headersMapper: BlobSetTierHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobSetTierExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        snapshot,
        versionId,
        comp16
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        leaseId,
        ifTags,
        rehydratePriority,
        tier1
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const getAccountInfoOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "GET",
    responses: {
        200: {
            headersMapper: BlobGetAccountInfoHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobGetAccountInfoExceptionHeaders
        }
    },
    queryParameters: [comp, restype1],
    urlParameters: [url],
    headerParameters: [version, accept1],
    isXML: true,
    serializer: xmlSerializer$3
};
const queryOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "POST",
    responses: {
        200: {
            bodyMapper: {
                type: { name: "Stream" },
                serializedName: "parsedResponse"
            },
            headersMapper: BlobQueryHeaders
        },
        206: {
            bodyMapper: {
                type: { name: "Stream" },
                serializedName: "parsedResponse"
            },
            headersMapper: BlobQueryHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobQueryExceptionHeaders
        }
    },
    requestBody: queryRequest,
    queryParameters: [
        timeoutInSeconds,
        snapshot,
        comp17
    ],
    urlParameters: [url],
    headerParameters: [
        contentType,
        accept,
        version,
        requestId,
        leaseId,
        ifModifiedSince,
        ifUnmodifiedSince,
        encryptionKey,
        encryptionKeySha256,
        encryptionAlgorithm,
        ifMatch,
        ifNoneMatch,
        ifTags
    ],
    isXML: true,
    contentType: "application/xml; charset=utf-8",
    mediaType: "xml",
    serializer: xmlSerializer$3
};
const getTagsOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: BlobTags,
            headersMapper: BlobGetTagsHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobGetTagsExceptionHeaders
        }
    },
    queryParameters: [
        timeoutInSeconds,
        snapshot,
        versionId,
        comp18
    ],
    urlParameters: [url],
    headerParameters: [
        version,
        requestId,
        accept1,
        leaseId,
        ifTags
    ],
    isXML: true,
    serializer: xmlSerializer$3
};
const setTagsOperationSpec = {
    path: "/{containerName}/{blob}",
    httpMethod: "PUT",
    responses: {
        204: {
            headersMapper: BlobSetTagsHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: BlobSetTagsExceptionHeaders
        }
    },
    requestBody: tags,
    queryParameters: [
        timeoutInSeconds,
        versionId,
        comp18
    ],
    urlParameters: [url],
    headerParameters: [
        contentType,
        accept,
        version,
        requestId,
        leaseId,
        ifTags,
        transactionalContentMD5,
        transactionalContentCrc64
    ],
    isXML: true,
    contentType: "application/xml; charset=utf-8",
    mediaType: "xml",
    serializer: xmlSerializer$3
};

/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
/** Class representing a PageBlob. */
class PageBlob {
    /**
     * Initialize a new instance of the class PageBlob class.
     * @param client Reference to the service client
     */
    constructor(client) {
        this.client = client;
    }
    /**
     * The Create operation creates a new page blob.
     * @param contentLength The length of the request.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The
     *                          page blob size must be aligned to a 512-byte boundary.
     * @param options The options parameters.
     */
    create(contentLength, blobContentLength, options) {
        const operationArguments = {
            contentLength,
            blobContentLength,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, createOperationSpec$1);
    }
    /**
     * The Upload Pages operation writes a range of pages to a page blob
     * @param contentLength The length of the request.
     * @param body Initial data
     * @param options The options parameters.
     */
    uploadPages(contentLength, body, options) {
        const operationArguments = {
            contentLength,
            body,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, uploadPagesOperationSpec);
    }
    /**
     * The Clear Pages operation clears a set of pages from a page blob
     * @param contentLength The length of the request.
     * @param options The options parameters.
     */
    clearPages(contentLength, options) {
        const operationArguments = {
            contentLength,
            options: coreHttp__namespace.operationOptionsToRequestOptionsBase(options || {})
        };
        return this.client.sendOperationRequest(operationArguments, clearPagesOperationSpec);
    }
    /**
     * 