[![Electron Logo](https://electron.atom.io/images/electron-logo.svg)](https://electron.atom.io/)

[![Travis Build Status](https://travis-ci.org/electron/electron.svg?branch=master)](https://travis-ci.org/electron/electron)
[![AppVeyor Build Status](https://ci.appveyor.com/api/projects/status/kvxe4byi7jcxbe26/branch/master?svg=true)](https://ci.appveyor.com/project/Atom/electron)
[![devDependency Status](https://david-dm.org/electron/electron/dev-status.svg)](https://david-dm.org/electron/electron?type=dev)
[![Join the Electron Community on Slack](http://atom-slack.herokuapp.com/badge.svg)](http://atom-slack.herokuapp.com/)

Electron框架讓你可以用JavaScript, HTML 和 CSS 編寫跨平台的應用程式。
它是基於[Node.js](https://nodejs.org/)和[Chromium](http://www.chromium.org)，
並且被[Atom editor](https://github.com/atom/atom)及許多其他的[apps](https://electron.atom.io/apps)所使用。

請關注[@ElectronJS](https://twitter.com/electronjs)的Twitter以獲得重要公告。

該項目遵守貢獻者約定 [code of conduct](CODE_OF_CONDUCT.md)。
我們希望貢獻者能遵守此約定。如果有發現任何不被接受的行為，請回報至electron@github.com(PS:請用英語)。

## 下載

預編譯的二進位檔和debug symbols版可以在[releases](https://github.com/electron/electron/releases)中找到，
其中包含Linux, Windows 和 macOS版的Electron。

你也可以用[`npm`](https://docs.npmjs.com/)安裝預編譯的二進位檔:

```sh
# 在 $PATH 全域安裝 `electron`
npm install electron -g

# 安裝為開發依賴
npm install electron --save-dev
```

### 鏡像網站

- [中國](https://npm.taobao.org/mirrors/electron)

## 文件

開發指南和API文件位於
[docs](https://github.com/electron/electron/tree/master/docs)。
它也包括如何編譯看改進Electron。

## 翻譯版文件

- [葡萄牙語－巴西](https://github.com/electron/electron/tree/master/docs-translations/pt-BR)
- [韓語](https://github.com/electron/electron/tree/master/docs-translations/ko-KR)
- [日語](https://github.com/electron/electron/tree/master/docs-translations/jp)
- [西班牙語](https://github.com/electron/electron/tree/master/docs-translations/es)
- [簡體中文](https://github.com/electron/electron/tree/master/docs-translations/zh-CN)
- [正體中文](https://github.com/electron/electron/tree/master/docs-translations/zh-TW)
- [土耳其](https://github.com/electron/electron/tree/master/docs-translations/tr-TR)
- [烏克蘭](https://github.com/electron/electron/tree/master/docs-translations/uk-UA)
- [俄語](https://github.com/electron/electron/tree/master/docs-translations/ru-RU)
- [法語](https://github.com/electron/electron/tree/master/docs-translations/fr-FR)

## 快速開始

Clone 並使用 [`electron/electron-quick-start`](https://github.com/electron/electron-quick-start)
這個repo，以使用輕量化的Electron。

## 社群

你可以在以下位置提問並和社群成員互動:
- [`electron`](http://discuss.atom.io/c/electron) Atom論壇上的其中一區
- `#atom-shell` Freenode的聊天頻道
- [`Atom`](http://atom-slack.herokuapp.com/) Slack上的頻道
- [`electron-br`](https://electron-br.slack.com) *(葡萄牙語－巴西)*
- [`electron-kr`](http://www.meetup.com/electron-kr/) *(韓語)*
- [`electron-jp`](https://electron-jp-slackin.herokuapp.com/) *(日語)*
- [`electron-tr`](http://www.meetup.com/Electron-JS-Istanbul/) *(土耳其)*
- [`electron-id`](https://electron-id.slack.com) *(印度尼西亞)*

在 [awesome-electron](https://github.com/sindresorhus/awesome-electron)
查看由社群維護的清單，包括實用的應用程式、工具以及資源。

## 憑證

MIT © 2016 Github
