Lütfen kullandığınız dokümanın Electron versiyonunuzla aynı olduğundan emin olun.
Versiyon numarası okuduğunuz dokümanın URL'sindekiyle aynı olmalı. Eğer aynı değilse, muhtemelen geliştirme aşamasındaki API değişikliklerini içerebilecek dokümantasyonudur.
Eğer öyleyse, atom.io üzerinden [mevcut sürümler](https://electron.atom.io/docs/)e göz atabilirsiniz ya da eğer GitHub arayüzünü kullanıyorsanız "Switch branches/tags" açılır menüsünden versiyonunuza uygun olanı seçebilirsiniz.

## SSS(Sıkça Sorulan Sorular)

Bir problem(issue) bildirmeden önce sıkça sorulan sorulara göz atın:
* [Electron SSS](https://github.com/electron/electron/tree/master/docs/faq/electron-faq.md)

## Klavuzlar

* [Desteklenen Platformlar ](https://github.com/electron/electron/tree/master/docs/tutorial/supported-platforms.md)
* [Uygulama Dağıtımı](https://github.com/electron/electron/tree/master/docs/tutorial/application-distribution.md)
* [Mac Uygulama Mağazası Başvuru Klavuzu](https://github.com/electron/electron/tree/master/docs/tutorial/mac-app-store-submission-guide.md)
* [Uygulama Paketleme](https://github.com/electron/electron/tree/master/docs/tutorial/application-packaging.md)
* [Native Node Modüllerini Kullanma](https://github.com/electron/electron/tree/master/docs/tutorial/using-native-node-modules.md)
* [Ana Süreç(Main Process) Hata ayıklama](https://github.com/electron/electron/tree/master/docs/tutorial/debugging-main-process.md)
* [Selenium ve WebDriver kullanımı](https://github.com/electron/electron/tree/master/docs/tutorial/using-selenium-and-webdriver.md)
* [DevTools Eklentisi](https://github.com/electron/electron/tree/master/docs/tutorial/devtools-extension.md)
* [Pepper Flash Kullanımı](https://github.com/electron/electron/tree/master/docs/tutorial/using-pepper-flash-plugin.md)
* [Widevine CDM Kullanımı](https://github.com/electron/electron/tree/master/docs/tutorial/using-widevine-cdm-plugin.md)
* [CI Sistem Testleri (Travis, Jenkins)](https://github.com/electron/electron/tree/master/docs/tutorial/testing-on-headless-ci.md)

## Eğitimler

* [Quick Start](https://github.com/electron/electron/tree/master/docs/tutorial/quick-start.md)
* [Desktop Environment Integration](https://github.com/electron/electron/tree/master/docs/tutorial/desktop-environment-integration.md)
* [Online/Offline Event Detection](https://github.com/electron/electron/tree/master/docs/tutorial/online-offline-events.md)

## API Kaynakları

* [Synopsis](https://github.com/electron/electron/tree/master/docs/api/synopsis.md)
* [Process Object](https://github.com/electron/electron/tree/master/docs/api/process.md)
* [Desteklenen Chrome Komut Satırı Anahtarları](https://github.com/electron/electron/tree/master/docs/api/chrome-command-line-switches.md)
* [Environment Değişkenleri](https://github.com/electron/electron/tree/master/docs/api/environment-variables.md)

### Özel DOM Elementleri:

* [`File` Nesnesi](api/file-object.md)
* [`<webview>` Etiketi](https://github.com/electron/electron/tree/master/docs/api/webview-tag.md)
* [`window.open` Fonksiyonu](https://github.com/electron/electron/tree/master/docs/api/window-open.md)

### Ana Süreç(Main Process) Modülleri:

* [app](https://github.com/electron/electron/tree/master/docs/api/app.md)
* [autoUpdater](https://github.com/electron/electron/tree/master/docs/api/auto-updater.md)
* [BrowserWindow](https://github.com/electron/electron/tree/master/docs/api/browser-window.md)
* [contentTracing](https://github.com/electron/electron/tree/master/docs/api/content-tracing.md)
* [dialog](https://github.com/electron/electron/tree/master/docs/api/dialog.md)
* [globalShortcut](https://github.com/electron/electron/tree/master/docs/api/global-shortcut.md)
* [ipcMain](https://github.com/electron/electron/tree/master/docs/api/ipc-main.md)
* [Menu](https://github.com/electron/electron/tree/master/docs/api/menu.md)
* [MenuItem](https://github.com/electron/electron/tree/master/docs/api/menu-item.md)
* [powerMonitor](https://github.com/electron/electron/tree/master/docs/api/power-monitor.md)
* [powerSaveBlocker](https://github.com/electron/electron/tree/master/docs/api/power-save-blocker.md)
* [protocol](https://github.com/electron/electron/tree/master/docs/api/protocol.md)
* [session](https://github.com/electron/electron/tree/master/docs/api/session.md)
* [webContents](https://github.com/electron/electron/tree/master/docs/api/web-contents.md)
* [Tray](https://github.com/electron/electron/tree/master/docs/api/tray.md)

### Renderer Process Modülelri (Web Page):

* [desktopCapturer](https://github.com/electron/electron/tree/master/docs/api/desktop-capturer.md)
* [ipcRenderer](https://github.com/electron/electron/tree/master/docs/api/ipc-renderer.md)
* [remote](https://github.com/electron/electron/tree/master/docs/api/remote.md)
* [webFrame](https://github.com/electron/electron/tree/master/docs/api/web-frame.md)

### Her İki Süreç İçin Geçerli Modüller:

* [clipboard](https://github.com/electron/electron/tree/master/docs/api/clipboard.md)
* [crashReporter](https://github.com/electron/electron/tree/master/docs/api/crash-reporter.md)
* [nativeImage](https://github.com/electron/electron/tree/master/docs/api/native-image.md)
* [screen](https://github.com/electron/electron/tree/master/docs/api/screen.md)
* [shell](https://github.com/electron/electron/tree/master/docs/api/shell.md)

## Geliştirme

* [Kodlama Stili](https://github.com/electron/electron/tree/master/docs/development/coding-style.md)
* [Kaynak Kod Dizin Yapısı](https://github.com/electron/electron/tree/master/docs/development/source-code-directory-structure.md)
* [NW.js(node-webkit adıyla bilinen) İle Arasındaki Teknik Farklılıklar](https://github.com/electron/electron/tree/master/docs/development/atom-shell-vs-node-webkit.md)
* [Build Sisyem Genel Bakış](https://github.com/electron/electron/tree/master/docs/development/build-system-overview.md)
* [(macOS) Build Komutları](https://github.com/electron/electron/tree/master/docs/development/build-instructions-osx.md)
* [(Windows) Build Komutları](https://github.com/electron/electron/tree/master/docs/development/build-instructions-windows.md)
* [(Linux) Build Komutları](https://github.com/electron/electron/tree/master/docs/development/build-instructions-linux.md)
* [(Windows) Hata Ayıklama Komutları](https://github.com/electron/electron/tree/master/docs/development/debug-instructions-windows.md)
* [Simge Sunucusu(Symbol Server) Hata Ayıklama Kurulumu](https://github.com/electron/electron/tree/master/docs/development/setting-up-symbol-server.md)
